<?php
$configData = Helper::appClasses();
?>



<?php $__env->startSection('title', 'Alt Menüler'); ?>
<?php $__env->startSection('vendor-style'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/animate-css/animate.css')); ?>" />
<link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/sweetalert2/sweetalert2.css')); ?>" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
<script src="<?php echo e(asset('assets/vendor/libs/sweetalert2/sweetalert2.js')); ?>"></script>
<script src="<?php echo e(asset('assets/vendor/libs/cleavejs/cleave.js')); ?>"></script>
<?php if(session('success')): ?>
<script>
    Swal.fire({
        icon: 'success',
        title: 'Başarılı!',
        text: '<?php echo e(session('success')); ?>',
        showConfirmButton: false,
        timer: 1500
    });
</script>

<?php elseif(session('error')): ?>
<script>
    Swal.fire({
        icon: 'error',
        title: 'Oops...',
        text: '<?php echo e(session('error')); ?>',
        showConfirmButton: false,
        timer: 1500
    });
</script>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<h4>Alt Menüler</h4>

<div class="d-grid gap-2 d-md-flex justify-content-md-end">
    <form action="<?php echo e(route('alt_menu.index')); ?>" method="GET" class="d-inline">
        <div class="input-group mb-3">
            <select name="ana_menu_id" class="form-select" id="inputGroupSelect01">
                <option value="">Ana Menü Seçiniz</option>
                <?php $__currentLoopData = $ana_menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ana_menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($ana_menu->id); ?>"<?php if(isset($search_data['ana_menu_id']) && $search_data['ana_menu_id'] == $ana_menu->id): ?> selected <?php endif; ?>><?php echo e($ana_menu->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <input type="text" class="form-control" name="arama" placeholder="Arama" value="<?php echo e($search_data['arama'] ?? ''); ?>">
            <button class="btn btn-outline-secondary" type="submit" id="button-addon2">Ara</button>
        </div>
    </form>
    <a href="<?php echo e(route('alt_menu.create')); ?>" class="btn btn-success mb-3">+ Yeni Alt Menü Ekle</a>
</div>


<div class="row">
    <div class="col-lg-12 col-sm-12">
        <div class="card">
          <h5 class="card-header"><span class="text-success">Toplam Alt Menü: <?php echo e($alt_menu_count); ?> Adet</span></h5>
          <div class="table-responsive text-nowrap">
            <table class="table">
              <thead>
                <tr>
                    <th>İsim</th>
                    <th>Sıra</th>
                    <th>Ana Menü</th>
                    <th>İşlemler</th>
                </tr>
              </thead>
              <tbody class="table-border-bottom-0">
                <?php $__currentLoopData = $alt_menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $alt_menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="w-50"><?php echo e($alt_menu->name); ?></td>
                    <td><?php echo e($alt_menu->sira); ?></td>
                    <td><?php echo e($alt_menu->ana_menu_name); ?></td>
                    <td>
                        <a href="<?php echo e(route('alt_menu.show', $alt_menu->id)); ?>" class="btn btn-sm btn-outline-primary">Görüntüle</a>
                        <a href="<?php echo e(route('alt_menu.edit', $alt_menu->id)); ?>" class="btn btn-sm btn-outline-warning">Düzenle</a>
                        <form action="<?php echo e(route('alt_menu.destroy', $alt_menu->id)); ?>" method="POST" class="d-inline">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-sm btn-outline-danger">Sil</button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </tbody>
            </table>
            <div class="d-flex justify-content-center mt-3">
                <?php echo $alt_menus->links(); ?>

            </div>
          </div>
        </div>
    </div>
</div>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/baristeksin/web/75simdo.dijimenu.com.tr/public_html/resources/views/admin/alt_menu/index.blade.php ENDPATH**/ ?>