<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>QR Kod Menü</title>
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js" integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <link rel="stylesheet" href="<?php echo e(asset('assets/custom/main.css')); ?>">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
</head>

<body>
    <div class="fixed-header">
        <marquee behavior="scroll" direction="left">Hoşgeldiniz! Bugünün özel menüsü: Margherita Pizza ve Fettuccine Alfredo.</marquee>
    </div>

    <div class="container mt-5 pt-5">
        <div class="text-center my-4">
            <img src="https://via.placeholder.com/800x200" alt="Tanıtım Görseli" class="img-fluid">
        </div>
        <div class="text-center my-4">
            <a href="https://www.instagram.com/yourprofile" class="btn btn-outline-primary">Instagram</a>
            <a href="https://www.google.com/maps/place/YourLocation" class="btn btn-outline-success">Google Maps</a>
        </div>
        <h2 class="text-center my-4 font-weight-bold">Menülerimiz</h2>
        <div class="category-scroll my-2 text-center" id="category-container">
            <?php $__currentLoopData = $menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="category-item <?php if($loop->first): ?> active <?php endif; ?>" onclick="showProducts('<?php echo e($menu->name); ?>')">
                <img src="<?php echo e(asset('storage/' . $menu->image)); ?>" alt="<?php echo e($menu->name); ?>" class="card-img-top">
                <p><?php echo e($menu->name); ?></p>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </div>
        <div class="text-center">
            <button id="toggleViewBtn" class="btn btn-secondary" onclick="toggleView()">Hepsini Göster</button>
        </div>
        <hr>
        <div id="product-container" class="row"></div>
    </div>

    <footer class="text-center mt-5">
      <p class="font-weight-bold">© 2024 <a href="https://www.dijimenu.com">Diji Menü</a> - Tüm hakları saklıdır.</p>
    </footer>

    <!-- Modal -->
    <div class="modal fade" id="imageModal" tabindex="-1" role="dialog" aria-labelledby="imageModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <img id="modalImage" src="" class="img-fluid" alt="">
                    <h4 id="modalTitle" class="text-center mt-2"></h4>
                    <p id="modalDescription" class="text-center"></p>
                </div>
            </div>
        </div>
    </div>


    <a href="#" id="scrollToTopBtn" class="scroll-to-top"><i class="fa fa-arrow-up"></i></a>

    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="<?php echo e(asset('assets/custom/script.js')); ?>"></script>
</body>

</html>
<?php /**PATH C:\Users\bteks\Downloads\app\resources\views/front/index.blade.php ENDPATH**/ ?>