<?php
$configData = Helper::appClasses();
?>



<?php $__env->startSection('title', 'Yemek Ekle'); ?>

<?php $__env->startSection('vendor-style'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/animate-css/animate.css')); ?>" />
<link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/sweetalert2/sweetalert2.css')); ?>" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
<script src="<?php echo e(asset('assets/vendor/libs/sweetalert2/sweetalert2.js')); ?>"></script>
<script src="<?php echo e(asset('assets/vendor/libs/cleavejs/cleave.js')); ?>"></script>
<?php if(session('success')): ?>
<script>
    Swal.fire({
        icon: 'success',
        title: 'Başarılı!',
        text: '<?php echo e(session('success')); ?>',
        showConfirmButton: false,
        timer: 1500
    });
</script>

<?php elseif(session('error')): ?>
<script>
    Swal.fire({
        icon: 'error',
        title: 'Oops...',
        text: '<?php echo e(session('error')); ?>',
        showConfirmButton: false,
        timer: 1500
    });
</script>
<?php endif; ?>

<?php $__env->startSection('content'); ?>

<h4>Yeni Yemek Ekle</h4>

<div class="row">
    <div class="col-lg-12 col-sm-12">
        <div class="card">
            <div class="card-body">
                <form action="<?php echo e(route('yemek.update',$data->id)); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="mb-3">
                        <label for="adi" class="form-label">Adı</label>
                        <input type="text" class="form-control" id="name" name="name" value="<?php echo e($data->name ?? old('name')); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="link" class="form-label">Resim</label>
                        <input type="file" class="form-control" id="image" name="image" value="">
                    </div>
                    <div class="mb-3">
                        <label for="sira" class="form-label">Sıra</label>
                        <input type="number" class="form-control" id="sira" name="sira" value="<?php echo e($data->sira ?? old('sira')); ?>" min="1" step="1" required>
                    </div>
                    <div class="mb-3">
                        <label for="hazirlik_suresi" class="form-label">Hazırlık Süresi</label>
                        <input type="number" class="form-control" id="hazirlik_suresi" name="hazirlik_suresi" value="<?php echo e($data->hazirlik_suresi ?? old('hazirlik_suresi')); ?>" min="1" step="1" required>
                    </div>
                    <div class="mb-3">
                        <label for="kisa_aciklama" class="form-label">Kısa Açıklama</label>
                        <input type="text" class="form-control" id="kisa_aciklama" name="kisa_aciklama" value="<?php echo e($data->kisa_aciklama ?? old('kisa_aciklama')); ?>" min="1" step="1" required>
                    </div>
                    <div class="mb-3">
                        <label for="fiyat" class="form-label">Fiyat</label>
                        <input type="text" class="form-control" id="fiyat" name="fiyat" value="<?php echo e($data->fiyat ?? old('fiyat')); ?>"  required>
                    </div>
                    <div class="mb-3">
                        <label for="alt_menu_id" class="form-label">Ana Menü</label>
                        <select name="alt_menu_id" class="form-select" id="inputGroupSelect01">
                            <option value="">Alt Menü Seçiniz</option>
                            <?php $__currentLoopData = $alt_menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $alt_menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($alt_menu->id); ?>"<?php if($alt_menu->id == $data->alt_menu_id): ?> selected <?php endif; ?>><?php echo e($alt_menu->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-primary">Kaydet</button>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dijimenucom/public_html/alba.dijimenu.com.tr/resources/views/admin/yemek/edit.blade.php ENDPATH**/ ?>