<?php
$configData = Helper::appClasses();
?>



<?php $__env->startSection('title', 'Yemekler'); ?>
<?php $__env->startSection('vendor-style'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/animate-css/animate.css')); ?>" />
<link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/sweetalert2/sweetalert2.css')); ?>" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
<script src="<?php echo e(asset('assets/vendor/libs/sweetalert2/sweetalert2.js')); ?>"></script>
<script src="<?php echo e(asset('assets/vendor/libs/cleavejs/cleave.js')); ?>"></script>
<?php if(session('success')): ?>
<script>
    Swal.fire({
        icon: 'success',
        title: 'Başarılı!',
        text: '<?php echo e(session('success')); ?>',
        showConfirmButton: false,
        timer: 1500
    });
</script>

<?php elseif(session('error')): ?>
<script>
    Swal.fire({
        icon: 'error',
        title: 'Oops...',
        text: '<?php echo e(session('error')); ?>',
        showConfirmButton: false,
        timer: 1500
    });
</script>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<h4>Alt Menüler</h4>

<div class="d-grid gap-2 d-md-flex justify-content-md-end">
    <form action="<?php echo e(route('yemek.index')); ?>" method="GET" class="d-inline">
        <div class="input-group mb-3">
            <select name="alt_menu_id" class="form-select" id="inputGroupSelect01">
                <option value="">Alt Menü Seçiniz</option>
                <?php $__currentLoopData = $alt_menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $alt_menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($alt_menu->id); ?>"<?php if(isset($search_data['alt_menu_id']) && $search_data['alt_menu_id'] == $alt_menu->id): ?> selected <?php endif; ?>><?php echo e($alt_menu->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <input type="text" class="form-control" name="arama" placeholder="Arama" value="<?php echo e($search_data['arama'] ?? ''); ?>">
            <button class="btn btn-outline-secondary" type="submit" id="button-addon2">Ara</button>
        </div>
    </form>
    <a href="<?php echo e(route('yemek.create')); ?>" class="btn btn-success mb-3">+ Yeni Yemek Ekle</a>
</div>


<div class="row">
    <div class="col-lg-12 col-sm-12">
        <div class="card">
          <h5 class="card-header"><span class="text-success">Toplam Yemek: <?php echo e($yemek_count); ?> Adet</span></h5>
          <div class="table-responsive text-nowrap">
            <table class="table">
              <thead>
                <tr>
                    <th>İsim</th>
                    <th>Sıra</th>
                    <th>Hazırlanma Süresi</th>
                    <th>Kısa Açıklama</th>
                    <th>Alt Menü</th>
                    <th>İşlemler</th>
                </tr>
              </thead>
              <tbody class="table-border-bottom-0">
                <?php $__currentLoopData = $yemeks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $yemek): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="w-25"><?php echo e($yemek->name); ?></td>
                    <td><?php echo e($yemek->sira); ?></td>
                    <td><?php echo e($yemek->hazirlik_suresi); ?></td>
                    <td class="w-25"><?php echo e($yemek->kisa_aciklama); ?></td>
                    <td><?php echo e($yemek->alt_menu_name); ?></td>
                    <td>
                        <a href="<?php echo e(route('yemek.show', $yemek->id)); ?>" class="btn btn-sm btn-outline-primary">Görüntüle</a>
                        <a href="<?php echo e(route('yemek.edit', $yemek->id)); ?>" class="btn btn-sm btn-outline-warning">Düzenle</a>
                        <form action="<?php echo e(route('yemek.destroy', $yemek->id)); ?>" method="POST" class="d-inline">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-sm btn-outline-danger">Sil</button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </tbody>
            </table>
            <div class="d-flex justify-content-center mt-3">
                <?php echo $yemeks->links(); ?>

            </div>
          </div>
        </div>
    </div>
</div>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dijimenucom/public_html/alba.dijimenu.com.tr/resources/views/admin/yemek/index.blade.php ENDPATH**/ ?>