<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AnaMenuController;
use App\Http\Controllers\AltMenuController;
use App\Http\Controllers\YemekController;
use App\Http\Controllers\DisariController;
use App\Http\Controllers\AyarController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::middleware([
    'auth:sanctum',
    config('jetstream.auth_session'),
    'verified',
])->group(function () {
    Route::resource('ana_menu', AnaMenuController::class);
    Route::resource('alt_menu', AltMenuController::class);
    Route::resource('yemek', YemekController::class);
    Route::resource('ayarlar', AyarController::class);
});
Route::get('/', [DisariController::class, 'index'])->name('disari.ana_menu');
Route::get('/menu/{id}', [DisariController::class, 'alt_menu'])->name('disari.alt_menu');
Route::get('/yemekler/{id}', [DisariController::class, 'yemek'])->name('disari.yemek');
Route::post('/api_yemekler', [DisariController::class, 'api_yemekler'])->name('disari.api_yemekler');
Route::post('/api_yemek/{id}', [DisariController::class, 'api_yemek'])->name('disari.api_yemek');