@php
$configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Ayarlar')
@section('vendor-style')
<link rel="stylesheet" href="{{asset('assets/vendor/libs/animate-css/animate.css')}}" />
<link rel="stylesheet" href="{{asset('assets/vendor/libs/sweetalert2/sweetalert2.css')}}" />
@endsection

@section('vendor-script')
<script src="{{asset('assets/vendor/libs/sweetalert2/sweetalert2.js')}}"></script>
<script src="{{asset('assets/vendor/libs/cleavejs/cleave.js')}}"></script>
@if (session('success'))
<script>
    Swal.fire({
        icon: 'success',
        title: 'Başarılı!',
        text: '{{ session('success') }}',
        showConfirmButton: false,
        timer: 1500
    });
</script>

@elseif (session('error'))
<script>
    Swal.fire({
        icon: 'error',
        title: 'Oops...',
        text: '{{ session('error') }}',
        showConfirmButton: false,
        timer: 1500
    });
</script>
@endif

@endsection

@section('content')

<h4>Ayarlar</h4>

<div class="row">
    <div class="col-lg-12 col-sm-12">
        <div class="card">
          <div class="table-responsive text-nowrap">
            <table class="table">
              <thead>
                <tr>
                    <th>İsim</th>
                    <th>Açıklama</th>
                    <th>İşlemler</th>
                </tr>
              </thead>
              <tbody class="table-border-bottom-0">
                @foreach ($ayarlar as $ayar)
                <tr>
                    <td class="w-50">{{ $ayar->key }}</td>
                    <td>{{ $ayar->description }}</td>
                    <td>
                        <a href="{{ route('ayarlar.show', $ayar->id) }}" class="btn btn-sm btn-outline-primary">Görüntüle</a>
                        <a href="{{ route('ayarlar.edit', $ayar->id) }}" class="btn btn-sm btn-outline-warning">Düzenle</a>
                    </td>
                </tr>
                @endforeach
              </tbody>
            </table>
          </div>
        </div>
    </div>
</div>


@endsection
