@php
$configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Alt Menüler')
@section('vendor-style')
<link rel="stylesheet" href="{{asset('assets/vendor/libs/animate-css/animate.css')}}" />
<link rel="stylesheet" href="{{asset('assets/vendor/libs/sweetalert2/sweetalert2.css')}}" />
@endsection

@section('vendor-script')
<script src="{{asset('assets/vendor/libs/sweetalert2/sweetalert2.js')}}"></script>
<script src="{{asset('assets/vendor/libs/cleavejs/cleave.js')}}"></script>
@if (session('success'))
<script>
    Swal.fire({
        icon: 'success',
        title: 'Başarılı!',
        text: '{{ session('success') }}',
        showConfirmButton: false,
        timer: 1500
    });
</script>

@elseif (session('error'))
<script>
    Swal.fire({
        icon: 'error',
        title: 'Oops...',
        text: '{{ session('error') }}',
        showConfirmButton: false,
        timer: 1500
    });
</script>
@endif

@endsection

@section('content')

<h4>Alt Menüler</h4>

<div class="d-grid gap-2 d-md-flex justify-content-md-end">
    <form action="{{ route('alt_menu.index') }}" method="GET" class="d-inline">
        <div class="input-group mb-3">
            <select name="ana_menu_id" class="form-select" id="inputGroupSelect01">
                <option value="">Ana Menü Seçiniz</option>
                @foreach ($ana_menus as $ana_menu)
                <option value="{{ $ana_menu->id }}"@if (isset($search_data['ana_menu_id']) && $search_data['ana_menu_id'] == $ana_menu->id) selected @endif>{{ $ana_menu->name }}</option>
                @endforeach
            <input type="text" class="form-control" name="arama" placeholder="Arama" value="{{ $search_data['arama'] ?? '' }}">
            <button class="btn btn-outline-secondary" type="submit" id="button-addon2">Ara</button>
        </div>
    </form>
    <a href="{{ route('alt_menu.create') }}" class="btn btn-success mb-3">+ Yeni Alt Menü Ekle</a>
</div>


<div class="row">
    <div class="col-lg-12 col-sm-12">
        <div class="card">
          <h5 class="card-header"><span class="text-success">Toplam Alt Menü: {{$alt_menu_count}} Adet</span></h5>
          <div class="table-responsive text-nowrap">
            <table class="table">
              <thead>
                <tr>
                    <th>İsim</th>
                    <th>Sıra</th>
                    <th>Ana Menü</th>
                    <th>İşlemler</th>
                </tr>
              </thead>
              <tbody class="table-border-bottom-0">
                @foreach ($alt_menus as $alt_menu)
                <tr>
                    <td class="w-50">{{ $alt_menu->name }}</td>
                    <td>{{ $alt_menu->sira }}</td>
                    <td>{{ $alt_menu->ana_menu_name }}</td>
                    <td>
                        <a href="{{ route('alt_menu.show', $alt_menu->id) }}" class="btn btn-sm btn-outline-primary">Görüntüle</a>
                        <a href="{{ route('alt_menu.edit', $alt_menu->id) }}" class="btn btn-sm btn-outline-warning">Düzenle</a>
                        <form action="{{ route('alt_menu.destroy', $alt_menu->id) }}" method="POST" class="d-inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-sm btn-outline-danger">Sil</button>
                        </form>
                    </td>
                </tr>
                @endforeach
              </tbody>
            </table>
            <div class="d-flex justify-content-center mt-3">
                {!! $alt_menus->links() !!}
            </div>
          </div>
        </div>
    </div>
</div>


@endsection
