(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else {
		var a = factory();
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(self, function() {
return /******/ (function() { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/highlight.js/lib/core.js":
/*!***********************************************!*\
  !*** ./node_modules/highlight.js/lib/core.js ***!
  \***********************************************/
/***/ (function(module) {

/* eslint-disable no-multi-assign */

function deepFreeze(obj) {
  if (obj instanceof Map) {
    obj.clear =
      obj.delete =
      obj.set =
        function () {
          throw new Error('map is read-only');
        };
  } else if (obj instanceof Set) {
    obj.add =
      obj.clear =
      obj.delete =
        function () {
          throw new Error('set is read-only');
        };
  }

  // Freeze self
  Object.freeze(obj);

  Object.getOwnPropertyNames(obj).forEach((name) => {
    const prop = obj[name];
    const type = typeof prop;

    // Freeze prop if it is an object or function and also not already frozen
    if ((type === 'object' || type === 'function') && !Object.isFrozen(prop)) {
      deepFreeze(prop);
    }
  });

  return obj;
}

/** @typedef {import('highlight.js').CallbackResponse} CallbackResponse */
/** @typedef {import('highlight.js').CompiledMode} CompiledMode */
/** @implements CallbackResponse */

class Response {
  /**
   * @param {CompiledMode} mode
   */
  constructor(mode) {
    // eslint-disable-next-line no-undefined
    if (mode.data === undefined) mode.data = {};

    this.data = mode.data;
    this.isMatchIgnored = false;
  }

  ignoreMatch() {
    this.isMatchIgnored = true;
  }
}

/**
 * @param {string} value
 * @returns {string}
 */
function escapeHTML(value) {
  return value
    .replace(/&/g, '&amp;')
    .replace(/</g, '&lt;')
    .replace(/>/g, '&gt;')
    .replace(/"/g, '&quot;')
    .replace(/'/g, '&#x27;');
}

/**
 * performs a shallow merge of multiple objects into one
 *
 * @template T
 * @param {T} original
 * @param {Record<string,any>[]} objects
 * @returns {T} a single new object
 */
function inherit$1(original, ...objects) {
  /** @type Record<string,any> */
  const result = Object.create(null);

  for (const key in original) {
    result[key] = original[key];
  }
  objects.forEach(function(obj) {
    for (const key in obj) {
      result[key] = obj[key];
    }
  });
  return /** @type {T} */ (result);
}

/**
 * @typedef {object} Renderer
 * @property {(text: string) => void} addText
 * @property {(node: Node) => void} openNode
 * @property {(node: Node) => void} closeNode
 * @property {() => string} value
 */

/** @typedef {{scope?: string, language?: string, sublanguage?: boolean}} Node */
/** @typedef {{walk: (r: Renderer) => void}} Tree */
/** */

const SPAN_CLOSE = '</span>';

/**
 * Determines if a node needs to be wrapped in <span>
 *
 * @param {Node} node */
const emitsWrappingTags = (node) => {
  // rarely we can have a sublanguage where language is undefined
  // TODO: track down why
  return !!node.scope;
};

/**
 *
 * @param {string} name
 * @param {{prefix:string}} options
 */
const scopeToCSSClass = (name, { prefix }) => {
  // sub-language
  if (name.startsWith("language:")) {
    return name.replace("language:", "language-");
  }
  // tiered scope: comment.line
  if (name.includes(".")) {
    const pieces = name.split(".");
    return [
      `${prefix}${pieces.shift()}`,
      ...(pieces.map((x, i) => `${x}${"_".repeat(i + 1)}`))
    ].join(" ");
  }
  // simple scope
  return `${prefix}${name}`;
};

/** @type {Renderer} */
class HTMLRenderer {
  /**
   * Creates a new HTMLRenderer
   *
   * @param {Tree} parseTree - the parse tree (must support `walk` API)
   * @param {{classPrefix: string}} options
   */
  constructor(parseTree, options) {
    this.buffer = "";
    this.classPrefix = options.classPrefix;
    parseTree.walk(this);
  }

  /**
   * Adds texts to the output stream
   *
   * @param {string} text */
  addText(text) {
    this.buffer += escapeHTML(text);
  }

  /**
   * Adds a node open to the output stream (if needed)
   *
   * @param {Node} node */
  openNode(node) {
    if (!emitsWrappingTags(node)) return;

    const className = scopeToCSSClass(node.scope,
      { prefix: this.classPrefix });
    this.span(className);
  }

  /**
   * Adds a node close to the output stream (if needed)
   *
   * @param {Node} node */
  closeNode(node) {
    if (!emitsWrappingTags(node)) return;

    this.buffer += SPAN_CLOSE;
  }

  /**
   * returns the accumulated buffer
  */
  value() {
    return this.buffer;
  }

  // helpers

  /**
   * Builds a span element
   *
   * @param {string} className */
  span(className) {
    this.buffer += `<span class="${className}">`;
  }
}

/** @typedef {{scope?: string, language?: string, sublanguage?: boolean, children: Node[]} | string} Node */
/** @typedef {{scope?: string, language?: string, sublanguage?: boolean, children: Node[]} } DataNode */
/** @typedef {import('highlight.js').Emitter} Emitter */
/**  */

/** @returns {DataNode} */
const newNode = (opts = {}) => {
  /** @type DataNode */
  const result = { children: [] };
  Object.assign(result, opts);
  return result;
};

class TokenTree {
  constructor() {
    /** @type DataNode */
    this.rootNode = newNode();
    this.stack = [this.rootNode];
  }

  get top() {
    return this.stack[this.stack.length - 1];
  }

  get root() { return this.rootNode; }

  /** @param {Node} node */
  add(node) {
    this.top.children.push(node);
  }

  /** @param {string} scope */
  openNode(scope) {
    /** @type Node */
    const node = newNode({ scope });
    this.add(node);
    this.stack.push(node);
  }

  closeNode() {
    if (this.stack.length > 1) {
      return this.stack.pop();
    }
    // eslint-disable-next-line no-undefined
    return undefined;
  }

  closeAllNodes() {
    while (this.closeNode());
  }

  toJSON() {
    return JSON.stringify(this.rootNode, null, 4);
  }

  /**
   * @typedef { import("./html_renderer").Renderer } Renderer
   * @param {Renderer} builder
   */
  walk(builder) {
    // this does not
    return this.constructor._walk(builder, this.rootNode);
    // this works
    // return TokenTree._walk(builder, this.rootNode);
  }

  /**
   * @param {Renderer} builder
   * @param {Node} node
   */
  static _walk(builder, node) {
    if (typeof node === "string") {
      builder.addText(node);
    } else if (node.children) {
      builder.openNode(node);
      node.children.forEach((child) => this._walk(builder, child));
      builder.closeNode(node);
    }
    return builder;
  }

  /**
   * @param {Node} node
   */
  static _collapse(node) {
    if (typeof node === "string") return;
    if (!node.children) return;

    if (node.children.every(el => typeof el === "string")) {
      // node.text = node.children.join("");
      // delete node.children;
      node.children = [node.children.join("")];
    } else {
      node.children.forEach((child) => {
        TokenTree._collapse(child);
      });
    }
  }
}

/**
  Currently this is all private API, but this is the minimal API necessary
  that an Emitter must implement to fully support the parser.

  Minimal interface:

  - addText(text)
  - __addSublanguage(emitter, subLanguageName)
  - startScope(scope)
  - endScope()
  - finalize()
  - toHTML()

*/

/**
 * @implements {Emitter}
 */
class TokenTreeEmitter extends TokenTree {
  /**
   * @param {*} options
   */
  constructor(options) {
    super();
    this.options = options;
  }

  /**
   * @param {string} text
   */
  addText(text) {
    if (text === "") { return; }

    this.add(text);
  }

  /** @param {string} scope */
  startScope(scope) {
    this.openNode(scope);
  }

  endScope() {
    this.closeNode();
  }

  /**
   * @param {Emitter & {root: DataNode}} emitter
   * @param {string} name
   */
  __addSublanguage(emitter, name) {
    /** @type DataNode */
    const node = emitter.root;
    if (name) node.scope = `language:${name}`;

    this.add(node);
  }

  toHTML() {
    const renderer = new HTMLRenderer(this, this.options);
    return renderer.value();
  }

  finalize() {
    this.closeAllNodes();
    return true;
  }
}

/**
 * @param {string} value
 * @returns {RegExp}
 * */

/**
 * @param {RegExp | string } re
 * @returns {string}
 */
function source(re) {
  if (!re) return null;
  if (typeof re === "string") return re;

  return re.source;
}

/**
 * @param {RegExp | string } re
 * @returns {string}
 */
function lookahead(re) {
  return concat('(?=', re, ')');
}

/**
 * @param {RegExp | string } re
 * @returns {string}
 */
function anyNumberOfTimes(re) {
  return concat('(?:', re, ')*');
}

/**
 * @param {RegExp | string } re
 * @returns {string}
 */
function optional(re) {
  return concat('(?:', re, ')?');
}

/**
 * @param {...(RegExp | string) } args
 * @returns {string}
 */
function concat(...args) {
  const joined = args.map((x) => source(x)).join("");
  return joined;
}

/**
 * @param { Array<string | RegExp | Object> } args
 * @returns {object}
 */
function stripOptionsFromArgs(args) {
  const opts = args[args.length - 1];

  if (typeof opts === 'object' && opts.constructor === Object) {
    args.splice(args.length - 1, 1);
    return opts;
  } else {
    return {};
  }
}

/** @typedef { {capture?: boolean} } RegexEitherOptions */

/**
 * Any of the passed expresssions may match
 *
 * Creates a huge this | this | that | that match
 * @param {(RegExp | string)[] | [...(RegExp | string)[], RegexEitherOptions]} args
 * @returns {string}
 */
function either(...args) {
  /** @type { object & {capture?: boolean} }  */
  const opts = stripOptionsFromArgs(args);
  const joined = '('
    + (opts.capture ? "" : "?:")
    + args.map((x) => source(x)).join("|") + ")";
  return joined;
}

/**
 * @param {RegExp | string} re
 * @returns {number}
 */
function countMatchGroups(re) {
  return (new RegExp(re.toString() + '|')).exec('').length - 1;
}

/**
 * Does lexeme start with a regular expression match at the beginning
 * @param {RegExp} re
 * @param {string} lexeme
 */
function startsWith(re, lexeme) {
  const match = re && re.exec(lexeme);
  return match && match.index === 0;
}

// BACKREF_RE matches an open parenthesis or backreference. To avoid
// an incorrect parse, it additionally matches the following:
// - [...] elements, where the meaning of parentheses and escapes change
// - other escape sequences, so we do not misparse escape sequences as
//   interesting elements
// - non-matching or lookahead parentheses, which do not capture. These
//   follow the '(' with a '?'.
const BACKREF_RE = /\[(?:[^\\\]]|\\.)*\]|\(\??|\\([1-9][0-9]*)|\\./;

// **INTERNAL** Not intended for outside usage
// join logically computes regexps.join(separator), but fixes the
// backreferences so they continue to match.
// it also places each individual regular expression into it's own
// match group, keeping track of the sequencing of those match groups
// is currently an exercise for the caller. :-)
/**
 * @param {(string | RegExp)[]} regexps
 * @param {{joinWith: string}} opts
 * @returns {string}
 */
function _rewriteBackreferences(regexps, { joinWith }) {
  let numCaptures = 0;

  return regexps.map((regex) => {
    numCaptures += 1;
    const offset = numCaptures;
    let re = source(regex);
    let out = '';

    while (re.length > 0) {
      const match = BACKREF_RE.exec(re);
      if (!match) {
        out += re;
        break;
      }
      out += re.substring(0, match.index);
      re = re.substring(match.index + match[0].length);
      if (match[0][0] === '\\' && match[1]) {
        // Adjust the backreference.
        out += '\\' + String(Number(match[1]) + offset);
      } else {
        out += match[0];
        if (match[0] === '(') {
          numCaptures++;
        }
      }
    }
    return out;
  }).map(re => `(${re})`).join(joinWith);
}

/** @typedef {import('highlight.js').Mode} Mode */
/** @typedef {import('highlight.js').ModeCallback} ModeCallback */

// Common regexps
const MATCH_NOTHING_RE = /\b\B/;
const IDENT_RE = '[a-zA-Z]\\w*';
const UNDERSCORE_IDENT_RE = '[a-zA-Z_]\\w*';
const NUMBER_RE = '\\b\\d+(\\.\\d+)?';
const C_NUMBER_RE = '(-?)(\\b0[xX][a-fA-F0-9]+|(\\b\\d+(\\.\\d*)?|\\.\\d+)([eE][-+]?\\d+)?)'; // 0x..., 0..., decimal, float
const BINARY_NUMBER_RE = '\\b(0b[01]+)'; // 0b...
const RE_STARTERS_RE = '!|!=|!==|%|%=|&|&&|&=|\\*|\\*=|\\+|\\+=|,|-|-=|/=|/|:|;|<<|<<=|<=|<|===|==|=|>>>=|>>=|>=|>>>|>>|>|\\?|\\[|\\{|\\(|\\^|\\^=|\\||\\|=|\\|\\||~';

/**
* @param { Partial<Mode> & {binary?: string | RegExp} } opts
*/
const SHEBANG = (opts = {}) => {
  const beginShebang = /^#![ ]*\//;
  if (opts.binary) {
    opts.begin = concat(
      beginShebang,
      /.*\b/,
      opts.binary,
      /\b.*/);
  }
  return inherit$1({
    scope: 'meta',
    begin: beginShebang,
    end: /$/,
    relevance: 0,
    /** @type {ModeCallback} */
    "on:begin": (m, resp) => {
      if (m.index !== 0) resp.ignoreMatch();
    }
  }, opts);
};

// Common modes
const BACKSLASH_ESCAPE = {
  begin: '\\\\[\\s\\S]', relevance: 0
};
const APOS_STRING_MODE = {
  scope: 'string',
  begin: '\'',
  end: '\'',
  illegal: '\\n',
  contains: [BACKSLASH_ESCAPE]
};
const QUOTE_STRING_MODE = {
  scope: 'string',
  begin: '"',
  end: '"',
  illegal: '\\n',
  contains: [BACKSLASH_ESCAPE]
};
const PHRASAL_WORDS_MODE = {
  begin: /\b(a|an|the|are|I'm|isn't|don't|doesn't|won't|but|just|should|pretty|simply|enough|gonna|going|wtf|so|such|will|you|your|they|like|more)\b/
};
/**
 * Creates a comment mode
 *
 * @param {string | RegExp} begin
 * @param {string | RegExp} end
 * @param {Mode | {}} [modeOptions]
 * @returns {Partial<Mode>}
 */
const COMMENT = function(begin, end, modeOptions = {}) {
  const mode = inherit$1(
    {
      scope: 'comment',
      begin,
      end,
      contains: []
    },
    modeOptions
  );
  mode.contains.push({
    scope: 'doctag',
    // hack to avoid the space from being included. the space is necessary to
    // match here to prevent the plain text rule below from gobbling up doctags
    begin: '[ ]*(?=(TODO|FIXME|NOTE|BUG|OPTIMIZE|HACK|XXX):)',
    end: /(TODO|FIXME|NOTE|BUG|OPTIMIZE|HACK|XXX):/,
    excludeBegin: true,
    relevance: 0
  });
  const ENGLISH_WORD = either(
    // list of common 1 and 2 letter words in English
    "I",
    "a",
    "is",
    "so",
    "us",
    "to",
    "at",
    "if",
    "in",
    "it",
    "on",
    // note: this is not an exhaustive list of contractions, just popular ones
    /[A-Za-z]+['](d|ve|re|ll|t|s|n)/, // contractions - can't we'd they're let's, etc
    /[A-Za-z]+[-][a-z]+/, // `no-way`, etc.
    /[A-Za-z][a-z]{2,}/ // allow capitalized words at beginning of sentences
  );
  // looking like plain text, more likely to be a comment
  mode.contains.push(
    {
      // TODO: how to include ", (, ) without breaking grammars that use these for
      // comment delimiters?
      // begin: /[ ]+([()"]?([A-Za-z'-]{3,}|is|a|I|so|us|[tT][oO]|at|if|in|it|on)[.]?[()":]?([.][ ]|[ ]|\))){3}/
      // ---

      // this tries to find sequences of 3 english words in a row (without any
      // "programming" type syntax) this gives us a strong signal that we've
      // TRULY found a comment - vs perhaps scanning with the wrong language.
      // It's possible to find something that LOOKS like the start of the
      // comment - but then if there is no readable text - good chance it is a
      // false match and not a comment.
      //
      // for a visual example please see:
      // https://github.com/highlightjs/highlight.js/issues/2827

      begin: concat(
        /[ ]+/, // necessary to prevent us gobbling up doctags like /* @author Bob Mcgill */
        '(',
        ENGLISH_WORD,
        /[.]?[:]?([.][ ]|[ ])/,
        '){3}') // look for 3 words in a row
    }
  );
  return mode;
};
const C_LINE_COMMENT_MODE = COMMENT('//', '$');
const C_BLOCK_COMMENT_MODE = COMMENT('/\\*', '\\*/');
const HASH_COMMENT_MODE = COMMENT('#', '$');
const NUMBER_MODE = {
  scope: 'number',
  begin: NUMBER_RE,
  relevance: 0
};
const C_NUMBER_MODE = {
  scope: 'number',
  begin: C_NUMBER_RE,
  relevance: 0
};
const BINARY_NUMBER_MODE = {
  scope: 'number',
  begin: BINARY_NUMBER_RE,
  relevance: 0
};
const REGEXP_MODE = {
  // this outer rule makes sure we actually have a WHOLE regex and not simply
  // an expression such as:
  //
  //     3 / something
  //
  // (which will then blow up when regex's `illegal` sees the newline)
  begin: /(?=\/[^/\n]*\/)/,
  contains: [{
    scope: 'regexp',
    begin: /\//,
    end: /\/[gimuy]*/,
    illegal: /\n/,
    contains: [
      BACKSLASH_ESCAPE,
      {
        begin: /\[/,
        end: /\]/,
        relevance: 0,
        contains: [BACKSLASH_ESCAPE]
      }
    ]
  }]
};
const TITLE_MODE = {
  scope: 'title',
  begin: IDENT_RE,
  relevance: 0
};
const UNDERSCORE_TITLE_MODE = {
  scope: 'title',
  begin: UNDERSCORE_IDENT_RE,
  relevance: 0
};
const METHOD_GUARD = {
  // excludes method names from keyword processing
  begin: '\\.\\s*' + UNDERSCORE_IDENT_RE,
  relevance: 0
};

/**
 * Adds end same as begin mechanics to a mode
 *
 * Your mode must include at least a single () match group as that first match
 * group is what is used for comparison
 * @param {Partial<Mode>} mode
 */
const END_SAME_AS_BEGIN = function(mode) {
  return Object.assign(mode,
    {
      /** @type {ModeCallback} */
      'on:begin': (m, resp) => { resp.data._beginMatch = m[1]; },
      /** @type {ModeCallback} */
      'on:end': (m, resp) => { if (resp.data._beginMatch !== m[1]) resp.ignoreMatch(); }
    });
};

var MODES = /*#__PURE__*/Object.freeze({
  __proto__: null,
  MATCH_NOTHING_RE: MATCH_NOTHING_RE,
  IDENT_RE: IDENT_RE,
  UNDERSCORE_IDENT_RE: UNDERSCORE_IDENT_RE,
  NUMBER_RE: NUMBER_RE,
  C_NUMBER_RE: C_NUMBER_RE,
  BINARY_NUMBER_RE: BINARY_NUMBER_RE,
  RE_STARTERS_RE: RE_STARTERS_RE,
  SHEBANG: SHEBANG,
  BACKSLASH_ESCAPE: BACKSLASH_ESCAPE,
  APOS_STRING_MODE: APOS_STRING_MODE,
  QUOTE_STRING_MODE: QUOTE_STRING_MODE,
  PHRASAL_WORDS_MODE: PHRASAL_WORDS_MODE,
  COMMENT: COMMENT,
  C_LINE_COMMENT_MODE: C_LINE_COMMENT_MODE,
  C_BLOCK_COMMENT_MODE: C_BLOCK_COMMENT_MODE,
  HASH_COMMENT_MODE: HASH_COMMENT_MODE,
  NUMBER_MODE: NUMBER_MODE,
  C_NUMBER_MODE: C_NUMBER_MODE,
  BINARY_NUMBER_MODE: BINARY_NUMBER_MODE,
  REGEXP_MODE: REGEXP_MODE,
  TITLE_MODE: TITLE_MODE,
  UNDERSCORE_TITLE_MODE: UNDERSCORE_TITLE_MODE,
  METHOD_GUARD: METHOD_GUARD,
  END_SAME_AS_BEGIN: END_SAME_AS_BEGIN
});

/**
@typedef {import('highlight.js').CallbackResponse} CallbackResponse
@typedef {import('highlight.js').CompilerExt} CompilerExt
*/

// Grammar extensions / plugins
// See: https://github.com/highlightjs/highlight.js/issues/2833

// Grammar extensions allow "syntactic sugar" to be added to the grammar modes
// without requiring any underlying changes to the compiler internals.

// `compileMatch` being the perfect small example of now allowing a grammar
// author to write `match` when they desire to match a single expression rather
// than being forced to use `begin`.  The extension then just moves `match` into
// `begin` when it runs.  Ie, no features have been added, but we've just made
// the experience of writing (and reading grammars) a little bit nicer.

// ------

// TODO: We need negative look-behind support to do this properly
/**
 * Skip a match if it has a preceding dot
 *
 * This is used for `beginKeywords` to prevent matching expressions such as
 * `bob.keyword.do()`. The mode compiler automatically wires this up as a
 * special _internal_ 'on:begin' callback for modes with `beginKeywords`
 * @param {RegExpMatchArray} match
 * @param {CallbackResponse} response
 */
function skipIfHasPrecedingDot(match, response) {
  const before = match.input[match.index - 1];
  if (before === ".") {
    response.ignoreMatch();
  }
}

/**
 *
 * @type {CompilerExt}
 */
function scopeClassName(mode, _parent) {
  // eslint-disable-next-line no-undefined
  if (mode.className !== undefined) {
    mode.scope = mode.className;
    delete mode.className;
  }
}

/**
 * `beginKeywords` syntactic sugar
 * @type {CompilerExt}
 */
function beginKeywords(mode, parent) {
  if (!parent) return;
  if (!mode.beginKeywords) return;

  // for languages with keywords that include non-word characters checking for
  // a word boundary is not sufficient, so instead we check for a word boundary
  // or whitespace - this does no harm in any case since our keyword engine
  // doesn't allow spaces in keywords anyways and we still check for the boundary
  // first
  mode.begin = '\\b(' + mode.beginKeywords.split(' ').join('|') + ')(?!\\.)(?=\\b|\\s)';
  mode.__beforeBegin = skipIfHasPrecedingDot;
  mode.keywords = mode.keywords || mode.beginKeywords;
  delete mode.beginKeywords;

  // prevents double relevance, the keywords themselves provide
  // relevance, the mode doesn't need to double it
  // eslint-disable-next-line no-undefined
  if (mode.relevance === undefined) mode.relevance = 0;
}

/**
 * Allow `illegal` to contain an array of illegal values
 * @type {CompilerExt}
 */
function compileIllegal(mode, _parent) {
  if (!Array.isArray(mode.illegal)) return;

  mode.illegal = either(...mode.illegal);
}

/**
 * `match` to match a single expression for readability
 * @type {CompilerExt}
 */
function compileMatch(mode, _parent) {
  if (!mode.match) return;
  if (mode.begin || mode.end) throw new Error("begin & end are not supported with match");

  mode.begin = mode.match;
  delete mode.match;
}

/**
 * provides the default 1 relevance to all modes
 * @type {CompilerExt}
 */
function compileRelevance(mode, _parent) {
  // eslint-disable-next-line no-undefined
  if (mode.relevance === undefined) mode.relevance = 1;
}

// allow beforeMatch to act as a "qualifier" for the match
// the full match begin must be [beforeMatch][begin]
const beforeMatchExt = (mode, parent) => {
  if (!mode.beforeMatch) return;
  // starts conflicts with endsParent which we need to make sure the child
  // rule is not matched multiple times
  if (mode.starts) throw new Error("beforeMatch cannot be used with starts");

  const originalMode = Object.assign({}, mode);
  Object.keys(mode).forEach((key) => { delete mode[key]; });

  mode.keywords = originalMode.keywords;
  mode.begin = concat(originalMode.beforeMatch, lookahead(originalMode.begin));
  mode.starts = {
    relevance: 0,
    contains: [
      Object.assign(originalMode, { endsParent: true })
    ]
  };
  mode.relevance = 0;

  delete originalMode.beforeMatch;
};

// keywords that should have no default relevance value
const COMMON_KEYWORDS = [
  'of',
  'and',
  'for',
  'in',
  'not',
  'or',
  'if',
  'then',
  'parent', // common variable name
  'list', // common variable name
  'value' // common variable name
];

const DEFAULT_KEYWORD_SCOPE = "keyword";

/**
 * Given raw keywords from a language definition, compile them.
 *
 * @param {string | Record<string,string|string[]> | Array<string>} rawKeywords
 * @param {boolean} caseInsensitive
 */
function compileKeywords(rawKeywords, caseInsensitive, scopeName = DEFAULT_KEYWORD_SCOPE) {
  /** @type {import("highlight.js/private").KeywordDict} */
  const compiledKeywords = Object.create(null);

  // input can be a string of keywords, an array of keywords, or a object with
  // named keys representing scopeName (which can then point to a string or array)
  if (typeof rawKeywords === 'string') {
    compileList(scopeName, rawKeywords.split(" "));
  } else if (Array.isArray(rawKeywords)) {
    compileList(scopeName, rawKeywords);
  } else {
    Object.keys(rawKeywords).forEach(function(scopeName) {
      // collapse all our objects back into the parent object
      Object.assign(
        compiledKeywords,
        compileKeywords(rawKeywords[scopeName], caseInsensitive, scopeName)
      );
    });
  }
  return compiledKeywords;

  // ---

  /**
   * Compiles an individual list of keywords
   *
   * Ex: "for if when while|5"
   *
   * @param {string} scopeName
   * @param {Array<string>} keywordList
   */
  function compileList(scopeName, keywordList) {
    if (caseInsensitive) {
      keywordList = keywordList.map(x => x.toLowerCase());
    }
    keywordList.forEach(function(keyword) {
      const pair = keyword.split('|');
      compiledKeywords[pair[0]] = [scopeName, scoreForKeyword(pair[0], pair[1])];
    });
  }
}

/**
 * Returns the proper score for a given keyword
 *
 * Also takes into account comment keywords, which will be scored 0 UNLESS
 * another score has been manually assigned.
 * @param {string} keyword
 * @param {string} [providedScore]
 */
function scoreForKeyword(keyword, providedScore) {
  // manual scores always win over common keywords
  // so you can force a score of 1 if you really insist
  if (providedScore) {
    return Number(providedScore);
  }

  return commonKeyword(keyword) ? 0 : 1;
}

/**
 * Determines if a given keyword is common or not
 *
 * @param {string} keyword */
function commonKeyword(keyword) {
  return COMMON_KEYWORDS.includes(keyword.toLowerCase());
}

/*

For the reasoning behind this please see:
https://github.com/highlightjs/highlight.js/issues/2880#issuecomment-747275419

*/

/**
 * @type {Record<string, boolean>}
 */
const seenDeprecations = {};

/**
 * @param {string} message
 */
const error = (message) => {
  console.error(message);
};

/**
 * @param {string} message
 * @param {any} args
 */
const warn = (message, ...args) => {
  console.log(`WARN: ${message}`, ...args);
};

/**
 * @param {string} version
 * @param {string} message
 */
const deprecated = (version, message) => {
  if (seenDeprecations[`${version}/${message}`]) return;

  console.log(`Deprecated as of ${version}. ${message}`);
  seenDeprecations[`${version}/${message}`] = true;
};

/* eslint-disable no-throw-literal */

/**
@typedef {import('highlight.js').CompiledMode} CompiledMode
*/

const MultiClassError = new Error();

/**
 * Renumbers labeled scope names to account for additional inner match
 * groups that otherwise would break everything.
 *
 * Lets say we 3 match scopes:
 *
 *   { 1 => ..., 2 => ..., 3 => ... }
 *
 * So what we need is a clean match like this:
 *
 *   (a)(b)(c) => [ "a", "b", "c" ]
 *
 * But this falls apart with inner match groups:
 *
 * (a)(((b)))(c) => ["a", "b", "b", "b", "c" ]
 *
 * Our scopes are now "out of alignment" and we're repeating `b` 3 times.
 * What needs to happen is the numbers are remapped:
 *
 *   { 1 => ..., 2 => ..., 5 => ... }
 *
 * We also need to know that the ONLY groups that should be output
 * are 1, 2, and 5.  This function handles this behavior.
 *
 * @param {CompiledMode} mode
 * @param {Array<RegExp | string>} regexes
 * @param {{key: "beginScope"|"endScope"}} opts
 */
function remapScopeNames(mode, regexes, { key }) {
  let offset = 0;
  const scopeNames = mode[key];
  /** @type Record<number,boolean> */
  const emit = {};
  /** @type Record<number,string> */
  const positions = {};

  for (let i = 1; i <= regexes.length; i++) {
    positions[i + offset] = scopeNames[i];
    emit[i + offset] = true;
    offset += countMatchGroups(regexes[i - 1]);
  }
  // we use _emit to keep track of which match groups are "top-level" to avoid double
  // output from inside match groups
  mode[key] = positions;
  mode[key]._emit = emit;
  mode[key]._multi = true;
}

/**
 * @param {CompiledMode} mode
 */
function beginMultiClass(mode) {
  if (!Array.isArray(mode.begin)) return;

  if (mode.skip || mode.excludeBegin || mode.returnBegin) {
    error("skip, excludeBegin, returnBegin not compatible with beginScope: {}");
    throw MultiClassError;
  }

  if (typeof mode.beginScope !== "object" || mode.beginScope === null) {
    error("beginScope must be object");
    throw MultiClassError;
  }

  remapScopeNames(mode, mode.begin, { key: "beginScope" });
  mode.begin = _rewriteBackreferences(mode.begin, { joinWith: "" });
}

/**
 * @param {CompiledMode} mode
 */
function endMultiClass(mode) {
  if (!Array.isArray(mode.end)) return;

  if (mode.skip || mode.excludeEnd || mode.returnEnd) {
    error("skip, excludeEnd, returnEnd not compatible with endScope: {}");
    throw MultiClassError;
  }

  if (typeof mode.endScope !== "object" || mode.endScope === null) {
    error("endScope must be object");
    throw MultiClassError;
  }

  remapScopeNames(mode, mode.end, { key: "endScope" });
  mode.end = _rewriteBackreferences(mode.end, { joinWith: "" });
}

/**
 * this exists only to allow `scope: {}` to be used beside `match:`
 * Otherwise `beginScope` would necessary and that would look weird

  {
    match: [ /def/, /\w+/ ]
    scope: { 1: "keyword" , 2: "title" }
  }

 * @param {CompiledMode} mode
 */
function scopeSugar(mode) {
  if (mode.scope && typeof mode.scope === "object" && mode.scope !== null) {
    mode.beginScope = mode.scope;
    delete mode.scope;
  }
}

/**
 * @param {CompiledMode} mode
 */
function MultiClass(mode) {
  scopeSugar(mode);

  if (typeof mode.beginScope === "string") {
    mode.beginScope = { _wrap: mode.beginScope };
  }
  if (typeof mode.endScope === "string") {
    mode.endScope = { _wrap: mode.endScope };
  }

  beginMultiClass(mode);
  endMultiClass(mode);
}

/**
@typedef {import('highlight.js').Mode} Mode
@typedef {import('highlight.js').CompiledMode} CompiledMode
@typedef {import('highlight.js').Language} Language
@typedef {import('highlight.js').HLJSPlugin} HLJSPlugin
@typedef {import('highlight.js').CompiledLanguage} CompiledLanguage
*/

// compilation

/**
 * Compiles a language definition result
 *
 * Given the raw result of a language definition (Language), compiles this so
 * that it is ready for highlighting code.
 * @param {Language} language
 * @returns {CompiledLanguage}
 */
function compileLanguage(language) {
  /**
   * Builds a regex with the case sensitivity of the current language
   *
   * @param {RegExp | string} value
   * @param {boolean} [global]
   */
  function langRe(value, global) {
    return new RegExp(
      source(value),
      'm'
      + (language.case_insensitive ? 'i' : '')
      + (language.unicodeRegex ? 'u' : '')
      + (global ? 'g' : '')
    );
  }

  /**
    Stores multiple regular expressions and allows you to quickly search for
    them all in a string simultaneously - returning the first match.  It does
    this by creating a huge (a|b|c) regex - each individual item wrapped with ()
    and joined by `|` - using match groups to track position.  When a match is
    found checking which position in the array has content allows us to figure
    out which of the original regexes / match groups triggered the match.

    The match object itself (the result of `Regex.exec`) is returned but also
    enhanced by merging in any meta-data that was registered with the regex.
    This is how we keep track of which mode matched, and what type of rule
    (`illegal`, `begin`, end, etc).
  */
  class MultiRegex {
    constructor() {
      this.matchIndexes = {};
      // @ts-ignore
      this.regexes = [];
      this.matchAt = 1;
      this.position = 0;
    }

    // @ts-ignore
    addRule(re, opts) {
      opts.position = this.position++;
      // @ts-ignore
      this.matchIndexes[this.matchAt] = opts;
      this.regexes.push([opts, re]);
      this.matchAt += countMatchGroups(re) + 1;
    }

    compile() {
      if (this.regexes.length === 0) {
        // avoids the need to check length every time exec is called
        // @ts-ignore
        this.exec = () => null;
      }
      const terminators = this.regexes.map(el => el[1]);
      this.matcherRe = langRe(_rewriteBackreferences(terminators, { joinWith: '|' }), true);
      this.lastIndex = 0;
    }

    /** @param {string} s */
    exec(s) {
      this.matcherRe.lastIndex = this.lastIndex;
      const match = this.matcherRe.exec(s);
      if (!match) { return null; }

      // eslint-disable-next-line no-undefined
      const i = match.findIndex((el, i) => i > 0 && el !== undefined);
      // @ts-ignore
      const matchData = this.matchIndexes[i];
      // trim off any earlier non-relevant match groups (ie, the other regex
      // match groups that make up the multi-matcher)
      match.splice(0, i);

      return Object.assign(match, matchData);
    }
  }

  /*
    Created to solve the key deficiently with MultiRegex - there is no way to
    test for multiple matches at a single location.  Why would we need to do
    that?  In the future a more dynamic engine will allow certain matches to be
    ignored.  An example: if we matched say the 3rd regex in a large group but
    decided to ignore it - we'd need to started testing again at the 4th
    regex... but MultiRegex itself gives us no real way to do that.

    So what this class creates MultiRegexs on the fly for whatever search
    position they are needed.

    NOTE: These additional MultiRegex objects are created dynamically.  For most
    grammars most of the time we will never actually need anything more than the
    first MultiRegex - so this shouldn't have too much overhead.

    Say this is our search group, and we match regex3, but wish to ignore it.

      regex1 | regex2 | regex3 | regex4 | regex5    ' ie, startAt = 0

    What we need is a new MultiRegex that only includes the remaining
    possibilities:

      regex4 | regex5                               ' ie, startAt = 3

    This class wraps all that complexity up in a simple API... `startAt` decides
    where in the array of expressions to start doing the matching. It
    auto-increments, so if a match is found at position 2, then startAt will be
    set to 3.  If the end is reached startAt will return to 0.

    MOST of the time the parser will be setting startAt manually to 0.
  */
  class ResumableMultiRegex {
    constructor() {
      // @ts-ignore
      this.rules = [];
      // @ts-ignore
      this.multiRegexes = [];
      this.count = 0;

      this.lastIndex = 0;
      this.regexIndex = 0;
    }

    // @ts-ignore
    getMatcher(index) {
      if (this.multiRegexes[index]) return this.multiRegexes[index];

      const matcher = new MultiRegex();
      this.rules.slice(index).forEach(([re, opts]) => matcher.addRule(re, opts));
      matcher.compile();
      this.multiRegexes[index] = matcher;
      return matcher;
    }

    resumingScanAtSamePosition() {
      return this.regexIndex !== 0;
    }

    considerAll() {
      this.regexIndex = 0;
    }

    // @ts-ignore
    addRule(re, opts) {
      this.rules.push([re, opts]);
      if (opts.type === "begin") this.count++;
    }

    /** @param {string} s */
    exec(s) {
      const m = this.getMatcher(this.regexIndex);
      m.lastIndex = this.lastIndex;
      let result = m.exec(s);

      // The following is because we have no easy way to say "resume scanning at the
      // existing position but also skip the current rule ONLY". What happens is
      // all prior rules are also skipped which can result in matching the wrong
      // thing. Example of matching "booger":

      // our matcher is [string, "booger", number]
      //
      // ....booger....

      // if "booger" is ignored then we'd really need a regex to scan from the
      // SAME position for only: [string, number] but ignoring "booger" (if it
      // was the first match), a simple resume would scan ahead who knows how
      // far looking only for "number", ignoring potential string matches (or
      // future "booger" matches that might be valid.)

      // So what we do: We execute two matchers, one resuming at the same
      // position, but the second full matcher starting at the position after:

      //     /--- resume first regex match here (for [number])
      //     |/---- full match here for [string, "booger", number]
      //     vv
      // ....booger....

      // Which ever results in a match first is then used. So this 3-4 step
      // process essentially allows us to say "match at this position, excluding
      // a prior rule that was ignored".
      //
      // 1. Match "booger" first, ignore. Also proves that [string] does non match.
      // 2. Resume matching for [number]
      // 3. Match at index + 1 for [string, "booger", number]
      // 4. If #2 and #3 result in matches, which came first?
      if (this.resumingScanAtSamePosition()) {
        if (result && result.index === this.lastIndex) ; else { // use the second matcher result
          const m2 = this.getMatcher(0);
          m2.lastIndex = this.lastIndex + 1;
          result = m2.exec(s);
        }
      }

      if (result) {
        this.regexIndex += result.position + 1;
        if (this.regexIndex === this.count) {
          // wrap-around to considering all matches again
          this.considerAll();
        }
      }

      return result;
    }
  }

  /**
   * Given a mode, builds a huge ResumableMultiRegex that can be used to walk
   * the content and find matches.
   *
   * @param {CompiledMode} mode
   * @returns {ResumableMultiRegex}
   */
  function buildModeRegex(mode) {
    const mm = new ResumableMultiRegex();

    mode.contains.forEach(term => mm.addRule(term.begin, { rule: term, type: "begin" }));

    if (mode.terminatorEnd) {
      mm.addRule(mode.terminatorEnd, { type: "end" });
    }
    if (mode.illegal) {
      mm.addRule(mode.illegal, { type: "illegal" });
    }

    return mm;
  }

  /** skip vs abort vs ignore
   *
   * @skip   - The mode is still entered and exited normally (and contains rules apply),
   *           but all content is held and added to the parent buffer rather than being
   *           output when the mode ends.  Mostly used with `sublanguage` to build up
   *           a single large buffer than can be parsed by sublanguage.
   *
   *             - The mode begin ands ends normally.
   *             - Content matched is added to the parent mode buffer.
   *             - The parser cursor is moved forward normally.
   *
   * @abort  - A hack placeholder until we have ignore.  Aborts the mode (as if it
   *           never matched) but DOES NOT continue to match subsequent `contains`
   *           modes.  Abort is bad/suboptimal because it can result in modes
   *           farther down not getting applied because an earlier rule eats the
   *           content but then aborts.
   *
   *             - The mode does not begin.
   *             - Content matched by `begin` is added to the mode buffer.
   *             - The parser cursor is moved forward accordingly.
   *
   * @ignore - Ignores the mode (as if it never matched) and continues to match any
   *           subsequent `contains` modes.  Ignore isn't technically possible with
   *           the current parser implementation.
   *
   *             - The mode does not begin.
   *             - Content matched by `begin` is ignored.
   *             - The parser cursor is not moved forward.
   */

  /**
   * Compiles an individual mode
   *
   * This can raise an error if the mode contains certain detectable known logic
   * issues.
   * @param {Mode} mode
   * @param {CompiledMode | null} [parent]
   * @returns {CompiledMode | never}
   */
  function compileMode(mode, parent) {
    const cmode = /** @type CompiledMode */ (mode);
    if (mode.isCompiled) return cmode;

    [
      scopeClassName,
      // do this early so compiler extensions generally don't have to worry about
      // the distinction between match/begin
      compileMatch,
      MultiClass,
      beforeMatchExt
    ].forEach(ext => ext(mode, parent));

    language.compilerExtensions.forEach(ext => ext(mode, parent));

    // __beforeBegin is considered private API, internal use only
    mode.__beforeBegin = null;

    [
      beginKeywords,
      // do this later so compiler extensions that come earlier have access to the
      // raw array if they wanted to perhaps manipulate it, etc.
      compileIllegal,
      // default to 1 relevance if not specified
      compileRelevance
    ].forEach(ext => ext(mode, parent));

    mode.isCompiled = true;

    let keywordPattern = null;
    if (typeof mode.keywords === "object" && mode.keywords.$pattern) {
      // we need a copy because keywords might be compiled multiple times
      // so we can't go deleting $pattern from the original on the first
      // pass
      mode.keywords = Object.assign({}, mode.keywords);
      keywordPattern = mode.keywords.$pattern;
      delete mode.keywords.$pattern;
    }
    keywordPattern = keywordPattern || /\w+/;

    if (mode.keywords) {
      mode.keywords = compileKeywords(mode.keywords, language.case_insensitive);
    }

    cmode.keywordPatternRe = langRe(keywordPattern, true);

    if (parent) {
      if (!mode.begin) mode.begin = /\B|\b/;
      cmode.beginRe = langRe(cmode.begin);
      if (!mode.end && !mode.endsWithParent) mode.end = /\B|\b/;
      if (mode.end) cmode.endRe = langRe(cmode.end);
      cmode.terminatorEnd = source(cmode.end) || '';
      if (mode.endsWithParent && parent.terminatorEnd) {
        cmode.terminatorEnd += (mode.end ? '|' : '') + parent.terminatorEnd;
      }
    }
    if (mode.illegal) cmode.illegalRe = langRe(/** @type {RegExp | string} */ (mode.illegal));
    if (!mode.contains) mode.contains = [];

    mode.contains = [].concat(...mode.contains.map(function(c) {
      return expandOrCloneMode(c === 'self' ? mode : c);
    }));
    mode.contains.forEach(function(c) { compileMode(/** @type Mode */ (c), cmode); });

    if (mode.starts) {
      compileMode(mode.starts, parent);
    }

    cmode.matcher = buildModeRegex(cmode);
    return cmode;
  }

  if (!language.compilerExtensions) language.compilerExtensions = [];

  // self is not valid at the top-level
  if (language.contains && language.contains.includes('self')) {
    throw new Error("ERR: contains `self` is not supported at the top-level of a language.  See documentation.");
  }

  // we need a null object, which inherit will guarantee
  language.classNameAliases = inherit$1(language.classNameAliases || {});

  return compileMode(/** @type Mode */ (language));
}

/**
 * Determines if a mode has a dependency on it's parent or not
 *
 * If a mode does have a parent dependency then often we need to clone it if
 * it's used in multiple places so that each copy points to the correct parent,
 * where-as modes without a parent can often safely be re-used at the bottom of
 * a mode chain.
 *
 * @param {Mode | null} mode
 * @returns {boolean} - is there a dependency on the parent?
 * */
function dependencyOnParent(mode) {
  if (!mode) return false;

  return mode.endsWithParent || dependencyOnParent(mode.starts);
}

/**
 * Expands a mode or clones it if necessary
 *
 * This is necessary for modes with parental dependenceis (see notes on
 * `dependencyOnParent`) and for nodes that have `variants` - which must then be
 * exploded into their own individual modes at compile time.
 *
 * @param {Mode} mode
 * @returns {Mode | Mode[]}
 * */
function expandOrCloneMode(mode) {
  if (mode.variants && !mode.cachedVariants) {
    mode.cachedVariants = mode.variants.map(function(variant) {
      return inherit$1(mode, { variants: null }, variant);
    });
  }

  // EXPAND
  // if we have variants then essentially "replace" the mode with the variants
  // this happens in compileMode, where this function is called from
  if (mode.cachedVariants) {
    return mode.cachedVariants;
  }

  // CLONE
  // if we have dependencies on parents then we need a unique
  // instance of ourselves, so we can be reused with many
  // different parents without issue
  if (dependencyOnParent(mode)) {
    return inherit$1(mode, { starts: mode.starts ? inherit$1(mode.starts) : null });
  }

  if (Object.isFrozen(mode)) {
    return inherit$1(mode);
  }

  // no special dependency issues, just return ourselves
  return mode;
}

var version = "11.8.0";

class HTMLInjectionError extends Error {
  constructor(reason, html) {
    super(reason);
    this.name = "HTMLInjectionError";
    this.html = html;
  }
}

/*
Syntax highlighting with language autodetection.
https://highlightjs.org/
*/


/**
@typedef {import('highlight.js').Mode} Mode
@typedef {import('highlight.js').CompiledMode} CompiledMode
@typedef {import('highlight.js').CompiledScope} CompiledScope
@typedef {import('highlight.js').Language} Language
@typedef {import('highlight.js').HLJSApi} HLJSApi
@typedef {import('highlight.js').HLJSPlugin} HLJSPlugin
@typedef {import('highlight.js').PluginEvent} PluginEvent
@typedef {import('highlight.js').HLJSOptions} HLJSOptions
@typedef {import('highlight.js').LanguageFn} LanguageFn
@typedef {import('highlight.js').HighlightedHTMLElement} HighlightedHTMLElement
@typedef {import('highlight.js').BeforeHighlightContext} BeforeHighlightContext
@typedef {import('highlight.js/private').MatchType} MatchType
@typedef {import('highlight.js/private').KeywordData} KeywordData
@typedef {import('highlight.js/private').EnhancedMatch} EnhancedMatch
@typedef {import('highlight.js/private').AnnotatedError} AnnotatedError
@typedef {import('highlight.js').AutoHighlightResult} AutoHighlightResult
@typedef {import('highlight.js').HighlightOptions} HighlightOptions
@typedef {import('highlight.js').HighlightResult} HighlightResult
*/


const escape = escapeHTML;
const inherit = inherit$1;
const NO_MATCH = Symbol("nomatch");
const MAX_KEYWORD_HITS = 7;

/**
 * @param {any} hljs - object that is extended (legacy)
 * @returns {HLJSApi}
 */
const HLJS = function(hljs) {
  // Global internal variables used within the highlight.js library.
  /** @type {Record<string, Language>} */
  const languages = Object.create(null);
  /** @type {Record<string, string>} */
  const aliases = Object.create(null);
  /** @type {HLJSPlugin[]} */
  const plugins = [];

  // safe/production mode - swallows more errors, tries to keep running
  // even if a single syntax or parse hits a fatal error
  let SAFE_MODE = true;
  const LANGUAGE_NOT_FOUND = "Could not find the language '{}', did you forget to load/include a language module?";
  /** @type {Language} */
  const PLAINTEXT_LANGUAGE = { disableAutodetect: true, name: 'Plain text', contains: [] };

  // Global options used when within external APIs. This is modified when
  // calling the `hljs.configure` function.
  /** @type HLJSOptions */
  let options = {
    ignoreUnescapedHTML: false,
    throwUnescapedHTML: false,
    noHighlightRe: /^(no-?highlight)$/i,
    languageDetectRe: /\blang(?:uage)?-([\w-]+)\b/i,
    classPrefix: 'hljs-',
    cssSelector: 'pre code',
    languages: null,
    // beta configuration options, subject to change, welcome to discuss
    // https://github.com/highlightjs/highlight.js/issues/1086
    __emitter: TokenTreeEmitter
  };

  /* Utility functions */

  /**
   * Tests a language name to see if highlighting should be skipped
   * @param {string} languageName
   */
  function shouldNotHighlight(languageName) {
    return options.noHighlightRe.test(languageName);
  }

  /**
   * @param {HighlightedHTMLElement} block - the HTML element to determine language for
   */
  function blockLanguage(block) {
    let classes = block.className + ' ';

    classes += block.parentNode ? block.parentNode.className : '';

    // language-* takes precedence over non-prefixed class names.
    const match = options.languageDetectRe.exec(classes);
    if (match) {
      const language = getLanguage(match[1]);
      if (!language) {
        warn(LANGUAGE_NOT_FOUND.replace("{}", match[1]));
        warn("Falling back to no-highlight mode for this block.", block);
      }
      return language ? match[1] : 'no-highlight';
    }

    return classes
      .split(/\s+/)
      .find((_class) => shouldNotHighlight(_class) || getLanguage(_class));
  }

  /**
   * Core highlighting function.
   *
   * OLD API
   * highlight(lang, code, ignoreIllegals, continuation)
   *
   * NEW API
   * highlight(code, {lang, ignoreIllegals})
   *
   * @param {string} codeOrLanguageName - the language to use for highlighting
   * @param {string | HighlightOptions} optionsOrCode - the code to highlight
   * @param {boolean} [ignoreIllegals] - whether to ignore illegal matches, default is to bail
   *
   * @returns {HighlightResult} Result - an object that represents the result
   * @property {string} language - the language name
   * @property {number} relevance - the relevance score
   * @property {string} value - the highlighted HTML code
   * @property {string} code - the original raw code
   * @property {CompiledMode} top - top of the current mode stack
   * @property {boolean} illegal - indicates whether any illegal matches were found
  */
  function highlight(codeOrLanguageName, optionsOrCode, ignoreIllegals) {
    let code = "";
    let languageName = "";
    if (typeof optionsOrCode === "object") {
      code = codeOrLanguageName;
      ignoreIllegals = optionsOrCode.ignoreIllegals;
      languageName = optionsOrCode.language;
    } else {
      // old API
      deprecated("10.7.0", "highlight(lang, code, ...args) has been deprecated.");
      deprecated("10.7.0", "Please use highlight(code, options) instead.\nhttps://github.com/highlightjs/highlight.js/issues/2277");
      languageName = codeOrLanguageName;
      code = optionsOrCode;
    }

    // https://github.com/highlightjs/highlight.js/issues/3149
    // eslint-disable-next-line no-undefined
    if (ignoreIllegals === undefined) { ignoreIllegals = true; }

    /** @type {BeforeHighlightContext} */
    const context = {
      code,
      language: languageName
    };
    // the plugin can change the desired language or the code to be highlighted
    // just be changing the object it was passed
    fire("before:highlight", context);

    // a before plugin can usurp the result completely by providing it's own
    // in which case we don't even need to call highlight
    const result = context.result
      ? context.result
      : _highlight(context.language, context.code, ignoreIllegals);

    result.code = context.code;
    // the plugin can change anything in result to suite it
    fire("after:highlight", result);

    return result;
  }

  /**
   * private highlight that's used internally and does not fire callbacks
   *
   * @param {string} languageName - the language to use for highlighting
   * @param {string} codeToHighlight - the code to highlight
   * @param {boolean?} [ignoreIllegals] - whether to ignore illegal matches, default is to bail
   * @param {CompiledMode?} [continuation] - current continuation mode, if any
   * @returns {HighlightResult} - result of the highlight operation
  */
  function _highlight(languageName, codeToHighlight, ignoreIllegals, continuation) {
    const keywordHits = Object.create(null);

    /**
     * Return keyword data if a match is a keyword
     * @param {CompiledMode} mode - current mode
     * @param {string} matchText - the textual match
     * @returns {KeywordData | false}
     */
    function keywordData(mode, matchText) {
      return mode.keywords[matchText];
    }

    function processKeywords() {
      if (!top.keywords) {
        emitter.addText(modeBuffer);
        return;
      }

      let lastIndex = 0;
      top.keywordPatternRe.lastIndex = 0;
      let match = top.keywordPatternRe.exec(modeBuffer);
      let buf = "";

      while (match) {
        buf += modeBuffer.substring(lastIndex, match.index);
        const word = language.case_insensitive ? match[0].toLowerCase() : match[0];
        const data = keywordData(top, word);
        if (data) {
          const [kind, keywordRelevance] = data;
          emitter.addText(buf);
          buf = "";

          keywordHits[word] = (keywordHits[word] || 0) + 1;
          if (keywordHits[word] <= MAX_KEYWORD_HITS) relevance += keywordRelevance;
          if (kind.startsWith("_")) {
            // _ implied for relevance only, do not highlight
            // by applying a class name
            buf += match[0];
          } else {
            const cssClass = language.classNameAliases[kind] || kind;
            emitKeyword(match[0], cssClass);
          }
        } else {
          buf += match[0];
        }
        lastIndex = top.keywordPatternRe.lastIndex;
        match = top.keywordPatternRe.exec(modeBuffer);
      }
      buf += modeBuffer.substring(lastIndex);
      emitter.addText(buf);
    }

    function processSubLanguage() {
      if (modeBuffer === "") return;
      /** @type HighlightResult */
      let result = null;

      if (typeof top.subLanguage === 'string') {
        if (!languages[top.subLanguage]) {
          emitter.addText(modeBuffer);
          return;
        }
        result = _highlight(top.subLanguage, modeBuffer, true, continuations[top.subLanguage]);
        continuations[top.subLanguage] = /** @type {CompiledMode} */ (result._top);
      } else {
        result = highlightAuto(modeBuffer, top.subLanguage.length ? top.subLanguage : null);
      }

      // Counting embedded language score towards the host language may be disabled
      // with zeroing the containing mode relevance. Use case in point is Markdown that
      // allows XML everywhere and makes every XML snippet to have a much larger Markdown
      // score.
      if (top.relevance > 0) {
        relevance += result.relevance;
      }
      emitter.__addSublanguage(result._emitter, result.language);
    }

    function processBuffer() {
      if (top.subLanguage != null) {
        processSubLanguage();
      } else {
        processKeywords();
      }
      modeBuffer = '';
    }

    /**
     * @param {string} text
     * @param {string} scope
     */
    function emitKeyword(keyword, scope) {
      if (keyword === "") return;

      emitter.startScope(scope);
      emitter.addText(keyword);
      emitter.endScope();
    }

    /**
     * @param {CompiledScope} scope
     * @param {RegExpMatchArray} match
     */
    function emitMultiClass(scope, match) {
      let i = 1;
      const max = match.length - 1;
      while (i <= max) {
        if (!scope._emit[i]) { i++; continue; }
        const klass = language.classNameAliases[scope[i]] || scope[i];
        const text = match[i];
        if (klass) {
          emitKeyword(text, klass);
        } else {
          modeBuffer = text;
          processKeywords();
          modeBuffer = "";
        }
        i++;
      }
    }

    /**
     * @param {CompiledMode} mode - new mode to start
     * @param {RegExpMatchArray} match
     */
    function startNewMode(mode, match) {
      if (mode.scope && typeof mode.scope === "string") {
        emitter.openNode(language.classNameAliases[mode.scope] || mode.scope);
      }
      if (mode.beginScope) {
        // beginScope just wraps the begin match itself in a scope
        if (mode.beginScope._wrap) {
          emitKeyword(modeBuffer, language.classNameAliases[mode.beginScope._wrap] || mode.beginScope._wrap);
          modeBuffer = "";
        } else if (mode.beginScope._multi) {
          // at this point modeBuffer should just be the match
          emitMultiClass(mode.beginScope, match);
          modeBuffer = "";
        }
      }

      top = Object.create(mode, { parent: { value: top } });
      return top;
    }

    /**
     * @param {CompiledMode } mode - the mode to potentially end
     * @param {RegExpMatchArray} match - the latest match
     * @param {string} matchPlusRemainder - match plus remainder of content
     * @returns {CompiledMode | void} - the next mode, or if void continue on in current mode
     */
    function endOfMode(mode, match, matchPlusRemainder) {
      let matched = startsWith(mode.endRe, matchPlusRemainder);

      if (matched) {
        if (mode["on:end"]) {
          const resp = new Response(mode);
          mode["on:end"](match, resp);
          if (resp.isMatchIgnored) matched = false;
        }

        if (matched) {
          while (mode.endsParent && mode.parent) {
            mode = mode.parent;
          }
          return mode;
        }
      }
      // even if on:end fires an `ignore` it's still possible
      // that we might trigger the end node because of a parent mode
      if (mode.endsWithParent) {
        return endOfMode(mode.parent, match, matchPlusRemainder);
      }
    }

    /**
     * Handle matching but then ignoring a sequence of text
     *
     * @param {string} lexeme - string containing full match text
     */
    function doIgnore(lexeme) {
      if (top.matcher.regexIndex === 0) {
        // no more regexes to potentially match here, so we move the cursor forward one
        // space
        modeBuffer += lexeme[0];
        return 1;
      } else {
        // no need to move the cursor, we still have additional regexes to try and
        // match at this very spot
        resumeScanAtSamePosition = true;
        return 0;
      }
    }

    /**
     * Handle the start of a new potential mode match
     *
     * @param {EnhancedMatch} match - the current match
     * @returns {number} how far to advance the parse cursor
     */
    function doBeginMatch(match) {
      const lexeme = match[0];
      const newMode = match.rule;

      const resp = new Response(newMode);
      // first internal before callbacks, then the public ones
      const beforeCallbacks = [newMode.__beforeBegin, newMode["on:begin"]];
      for (const cb of beforeCallbacks) {
        if (!cb) continue;
        cb(match, resp);
        if (resp.isMatchIgnored) return doIgnore(lexeme);
      }

      if (newMode.skip) {
        modeBuffer += lexeme;
      } else {
        if (newMode.excludeBegin) {
          modeBuffer += lexeme;
        }
        processBuffer();
        if (!newMode.returnBegin && !newMode.excludeBegin) {
          modeBuffer = lexeme;
        }
      }
      startNewMode(newMode, match);
      return newMode.returnBegin ? 0 : lexeme.length;
    }

    /**
     * Handle the potential end of mode
     *
     * @param {RegExpMatchArray} match - the current match
     */
    function doEndMatch(match) {
      const lexeme = match[0];
      const matchPlusRemainder = codeToHighlight.substring(match.index);

      const endMode = endOfMode(top, match, matchPlusRemainder);
      if (!endMode) { return NO_MATCH; }

      const origin = top;
      if (top.endScope && top.endScope._wrap) {
        processBuffer();
        emitKeyword(lexeme, top.endScope._wrap);
      } else if (top.endScope && top.endScope._multi) {
        processBuffer();
        emitMultiClass(top.endScope, match);
      } else if (origin.skip) {
        modeBuffer += lexeme;
      } else {
        if (!(origin.returnEnd || origin.excludeEnd)) {
          modeBuffer += lexeme;
        }
        processBuffer();
        if (origin.excludeEnd) {
          modeBuffer = lexeme;
        }
      }
      do {
        if (top.scope) {
          emitter.closeNode();
        }
        if (!top.skip && !top.subLanguage) {
          relevance += top.relevance;
        }
        top = top.parent;
      } while (top !== endMode.parent);
      if (endMode.starts) {
        startNewMode(endMode.starts, match);
      }
      return origin.returnEnd ? 0 : lexeme.length;
    }

    function processContinuations() {
      const list = [];
      for (let current = top; current !== language; current = current.parent) {
        if (current.scope) {
          list.unshift(current.scope);
        }
      }
      list.forEach(item => emitter.openNode(item));
    }

    /** @type {{type?: MatchType, index?: number, rule?: Mode}}} */
    let lastMatch = {};

    /**
     *  Process an individual match
     *
     * @param {string} textBeforeMatch - text preceding the match (since the last match)
     * @param {EnhancedMatch} [match] - the match itself
     */
    function processLexeme(textBeforeMatch, match) {
      const lexeme = match && match[0];

      // add non-matched text to the current mode buffer
      modeBuffer += textBeforeMatch;

      if (lexeme == null) {
        processBuffer();
        return 0;
      }

      // we've found a 0 width match and we're stuck, so we need to advance
      // this happens when we have badly behaved rules that have optional matchers to the degree that
      // sometimes they can end up matching nothing at all
      // Ref: https://github.com/highlightjs/highlight.js/issues/2140
      if (lastMatch.type === "begin" && match.type === "end" && lastMatch.index === match.index && lexeme === "") {
        // spit the "skipped" character that our regex choked on back into the output sequence
        modeBuffer += codeToHighlight.slice(match.index, match.index + 1);
        if (!SAFE_MODE) {
          /** @type {AnnotatedError} */
          const err = new Error(`0 width match regex (${languageName})`);
          err.languageName = languageName;
          err.badRule = lastMatch.rule;
          throw err;
        }
        return 1;
      }
      lastMatch = match;

      if (match.type === "begin") {
        return doBeginMatch(match);
      } else if (match.type === "illegal" && !ignoreIllegals) {
        // illegal match, we do not continue processing
        /** @type {AnnotatedError} */
        const err = new Error('Illegal lexeme "' + lexeme + '" for mode "' + (top.scope || '<unnamed>') + '"');
        err.mode = top;
        throw err;
      } else if (match.type === "end") {
        const processed = doEndMatch(match);
        if (processed !== NO_MATCH) {
          return processed;
        }
      }

      // edge case for when illegal matches $ (end of line) which is technically
      // a 0 width match but not a begin/end match so it's not caught by the
      // first handler (when ignoreIllegals is true)
      if (match.type === "illegal" && lexeme === "") {
        // advance so we aren't stuck in an infinite loop
        return 1;
      }

      // infinite loops are BAD, this is a last ditch catch all. if we have a
      // decent number of iterations yet our index (cursor position in our
      // parsing) still 3x behind our index then something is very wrong
      // so we bail
      if (iterations > 100000 && iterations > match.index * 3) {
        const err = new Error('potential infinite loop, way more iterations than matches');
        throw err;
      }

      /*
      Why might be find ourselves here?  An potential end match that was
      triggered but could not be completed.  IE, `doEndMatch` returned NO_MATCH.
      (this could be because a callback requests the match be ignored, etc)

      This causes no real harm other than stopping a few times too many.
      */

      modeBuffer += lexeme;
      return lexeme.length;
    }

    const language = getLanguage(languageName);
    if (!language) {
      error(LANGUAGE_NOT_FOUND.replace("{}", languageName));
      throw new Error('Unknown language: "' + languageName + '"');
    }

    const md = compileLanguage(language);
    let result = '';
    /** @type {CompiledMode} */
    let top = continuation || md;
    /** @type Record<string,CompiledMode> */
    const continuations = {}; // keep continuations for sub-languages
    const emitter = new options.__emitter(options);
    processContinuations();
    let modeBuffer = '';
    let relevance = 0;
    let index = 0;
    let iterations = 0;
    let resumeScanAtSamePosition = false;

    try {
      if (!language.__emitTokens) {
        top.matcher.considerAll();

        for (;;) {
          iterations++;
          if (resumeScanAtSamePosition) {
            // only regexes not matched previously will now be
            // considered for a potential match
            resumeScanAtSamePosition = false;
          } else {
            top.matcher.considerAll();
          }
          top.matcher.lastIndex = index;

          const match = top.matcher.exec(codeToHighlight);
          // console.log("match", match[0], match.rule && match.rule.begin)

          if (!match) break;

          const beforeMatch = codeToHighlight.substring(index, match.index);
          const processedCount = processLexeme(beforeMatch, match);
          index = match.index + processedCount;
        }
        processLexeme(codeToHighlight.substring(index));
      } else {
        language.__emitTokens(codeToHighlight, emitter);
      }

      emitter.finalize();
      result = emitter.toHTML();

      return {
        language: languageName,
        value: result,
        relevance,
        illegal: false,
        _emitter: emitter,
        _top: top
      };
    } catch (err) {
      if (err.message && err.message.includes('Illegal')) {
        return {
          language: languageName,
          value: escape(codeToHighlight),
          illegal: true,
          relevance: 0,
          _illegalBy: {
            message: err.message,
            index,
            context: codeToHighlight.slice(index - 100, index + 100),
            mode: err.mode,
            resultSoFar: result
          },
          _emitter: emitter
        };
      } else if (SAFE_MODE) {
        return {
          language: languageName,
          value: escape(codeToHighlight),
          illegal: false,
          relevance: 0,
          errorRaised: err,
          _emitter: emitter,
          _top: top
        };
      } else {
        throw err;
      }
    }
  }

  /**
   * returns a valid highlight result, without actually doing any actual work,
   * auto highlight starts with this and it's possible for small snippets that
   * auto-detection may not find a better match
   * @param {string} code
   * @returns {HighlightResult}
   */
  function justTextHighlightResult(code) {
    const result = {
      value: escape(code),
      illegal: false,
      relevance: 0,
      _top: PLAINTEXT_LANGUAGE,
      _emitter: new options.__emitter(options)
    };
    result._emitter.addText(code);
    return result;
  }

  /**
  Highlighting with language detection. Accepts a string with the code to
  highlight. Returns an object with the following properties:

  - language (detected language)
  - relevance (int)
  - value (an HTML string with highlighting markup)
  - secondBest (object with the same structure for second-best heuristically
    detected language, may be absent)

    @param {string} code
    @param {Array<string>} [languageSubset]
    @returns {AutoHighlightResult}
  */
  function highlightAuto(code, languageSubset) {
    languageSubset = languageSubset || options.languages || Object.keys(languages);
    const plaintext = justTextHighlightResult(code);

    const results = languageSubset.filter(getLanguage).filter(autoDetection).map(name =>
      _highlight(name, code, false)
    );
    results.unshift(plaintext); // plaintext is always an option

    const sorted = results.sort((a, b) => {
      // sort base on relevance
      if (a.relevance !== b.relevance) return b.relevance - a.relevance;

      // always award the tie to the base language
      // ie if C++ and Arduino are tied, it's more likely to be C++
      if (a.language && b.language) {
        if (getLanguage(a.language).supersetOf === b.language) {
          return 1;
        } else if (getLanguage(b.language).supersetOf === a.language) {
          return -1;
        }
      }

      // otherwise say they are equal, which has the effect of sorting on
      // relevance while preserving the original ordering - which is how ties
      // have historically been settled, ie the language that comes first always
      // wins in the case of a tie
      return 0;
    });

    const [best, secondBest] = sorted;

    /** @type {AutoHighlightResult} */
    const result = best;
    result.secondBest = secondBest;

    return result;
  }

  /**
   * Builds new class name for block given the language name
   *
   * @param {HTMLElement} element
   * @param {string} [currentLang]
   * @param {string} [resultLang]
   */
  function updateClassName(element, currentLang, resultLang) {
    const language = (currentLang && aliases[currentLang]) || resultLang;

    element.classList.add("hljs");
    element.classList.add(`language-${language}`);
  }

  /**
   * Applies highlighting to a DOM node containing code.
   *
   * @param {HighlightedHTMLElement} element - the HTML element to highlight
  */
  function highlightElement(element) {
    /** @type HTMLElement */
    let node = null;
    const language = blockLanguage(element);

    if (shouldNotHighlight(language)) return;

    fire("before:highlightElement",
      { el: element, language });

    // we should be all text, no child nodes (unescaped HTML) - this is possibly
    // an HTML injection attack - it's likely too late if this is already in
    // production (the code has likely already done its damage by the time
    // we're seeing it)... but we yell loudly about this so that hopefully it's
    // more likely to be caught in development before making it to production
    if (element.children.length > 0) {
      if (!options.ignoreUnescapedHTML) {
        console.warn("One of your code blocks includes unescaped HTML. This is a potentially serious security risk.");
        console.warn("https://github.com/highlightjs/highlight.js/wiki/security");
        console.warn("The element with unescaped HTML:");
        console.warn(element);
      }
      if (options.throwUnescapedHTML) {
        const err = new HTMLInjectionError(
          "One of your code blocks includes unescaped HTML.",
          element.innerHTML
        );
        throw err;
      }
    }

    node = element;
    const text = node.textContent;
    const result = language ? highlight(text, { language, ignoreIllegals: true }) : highlightAuto(text);

    element.innerHTML = result.value;
    updateClassName(element, language, result.language);
    element.result = {
      language: result.language,
      // TODO: remove with version 11.0
      re: result.relevance,
      relevance: result.relevance
    };
    if (result.secondBest) {
      element.secondBest = {
        language: result.secondBest.language,
        relevance: result.secondBest.relevance
      };
    }

    fire("after:highlightElement", { el: element, result, text });
  }

  /**
   * Updates highlight.js global options with the passed options
   *
   * @param {Partial<HLJSOptions>} userOptions
   */
  function configure(userOptions) {
    options = inherit(options, userOptions);
  }

  // TODO: remove v12, deprecated
  const initHighlighting = () => {
    highlightAll();
    deprecated("10.6.0", "initHighlighting() deprecated.  Use highlightAll() now.");
  };

  // TODO: remove v12, deprecated
  function initHighlightingOnLoad() {
    highlightAll();
    deprecated("10.6.0", "initHighlightingOnLoad() deprecated.  Use highlightAll() now.");
  }

  let wantsHighlight = false;

  /**
   * auto-highlights all pre>code elements on the page
   */
  function highlightAll() {
    // if we are called too early in the loading process
    if (document.readyState === "loading") {
      wantsHighlight = true;
      return;
    }

    const blocks = document.querySelectorAll(options.cssSelector);
    blocks.forEach(highlightElement);
  }

  function boot() {
    // if a highlight was requested before DOM was loaded, do now
    if (wantsHighlight) highlightAll();
  }

  // make sure we are in the browser environment
  if (typeof window !== 'undefined' && window.addEventListener) {
    window.addEventListener('DOMContentLoaded', boot, false);
  }

  /**
   * Register a language grammar module
   *
   * @param {string} languageName
   * @param {LanguageFn} languageDefinition
   */
  function registerLanguage(languageName, languageDefinition) {
    let lang = null;
    try {
      lang = languageDefinition(hljs);
    } catch (error$1) {
      error("Language definition for '{}' could not be registered.".replace("{}", languageName));
      // hard or soft error
      if (!SAFE_MODE) { throw error$1; } else { error(error$1); }
      // languages that have serious errors are replaced with essentially a
      // "plaintext" stand-in so that the code blocks will still get normal
      // css classes applied to them - and one bad language won't break the
      // entire highlighter
      lang = PLAINTEXT_LANGUAGE;
    }
    // give it a temporary name if it doesn't have one in the meta-data
    if (!lang.name) lang.name = languageName;
    languages[languageName] = lang;
    lang.rawDefinition = languageDefinition.bind(null, hljs);

    if (lang.aliases) {
      registerAliases(lang.aliases, { languageName });
    }
  }

  /**
   * Remove a language grammar module
   *
   * @param {string} languageName
   */
  function unregisterLanguage(languageName) {
    delete languages[languageName];
    for (const alias of Object.keys(aliases)) {
      if (aliases[alias] === languageName) {
        delete aliases[alias];
      }
    }
  }

  /**
   * @returns {string[]} List of language internal names
   */
  function listLanguages() {
    return Object.keys(languages);
  }

  /**
   * @param {string} name - name of the language to retrieve
   * @returns {Language | undefined}
   */
  function getLanguage(name) {
    name = (name || '').toLowerCase();
    return languages[name] || languages[aliases[name]];
  }

  /**
   *
   * @param {string|string[]} aliasList - single alias or list of aliases
   * @param {{languageName: string}} opts
   */
  function registerAliases(aliasList, { languageName }) {
    if (typeof aliasList === 'string') {
      aliasList = [aliasList];
    }
    aliasList.forEach(alias => { aliases[alias.toLowerCase()] = languageName; });
  }

  /**
   * Determines if a given language has auto-detection enabled
   * @param {string} name - name of the language
   */
  function autoDetection(name) {
    const lang = getLanguage(name);
    return lang && !lang.disableAutodetect;
  }

  /**
   * Upgrades the old highlightBlock plugins to the new
   * highlightElement API
   * @param {HLJSPlugin} plugin
   */
  function upgradePluginAPI(plugin) {
    // TODO: remove with v12
    if (plugin["before:highlightBlock"] && !plugin["before:highlightElement"]) {
      plugin["before:highlightElement"] = (data) => {
        plugin["before:highlightBlock"](
          Object.assign({ block: data.el }, data)
        );
      };
    }
    if (plugin["after:highlightBlock"] && !plugin["after:highlightElement"]) {
      plugin["after:highlightElement"] = (data) => {
        plugin["after:highlightBlock"](
          Object.assign({ block: data.el }, data)
        );
      };
    }
  }

  /**
   * @param {HLJSPlugin} plugin
   */
  function addPlugin(plugin) {
    upgradePluginAPI(plugin);
    plugins.push(plugin);
  }

  /**
   * @param {HLJSPlugin} plugin
   */
  function removePlugin(plugin) {
    const index = plugins.indexOf(plugin);
    if (index !== -1) {
      plugins.splice(index, 1);
    }
  }

  /**
   *
   * @param {PluginEvent} event
   * @param {any} args
   */
  function fire(event, args) {
    const cb = event;
    plugins.forEach(function(plugin) {
      if (plugin[cb]) {
        plugin[cb](args);
      }
    });
  }

  /**
   * DEPRECATED
   * @param {HighlightedHTMLElement} el
   */
  function deprecateHighlightBlock(el) {
    deprecated("10.7.0", "highlightBlock will be removed entirely in v12.0");
    deprecated("10.7.0", "Please use highlightElement now.");

    return highlightElement(el);
  }

  /* Interface definition */
  Object.assign(hljs, {
    highlight,
    highlightAuto,
    highlightAll,
    highlightElement,
    // TODO: Remove with v12 API
    highlightBlock: deprecateHighlightBlock,
    configure,
    initHighlighting,
    initHighlightingOnLoad,
    registerLanguage,
    unregisterLanguage,
    listLanguages,
    getLanguage,
    registerAliases,
    autoDetection,
    inherit,
    addPlugin,
    removePlugin
  });

  hljs.debugMode = function() { SAFE_MODE = false; };
  hljs.safeMode = function() { SAFE_MODE = true; };
  hljs.versionString = version;

  hljs.regex = {
    concat: concat,
    lookahead: lookahead,
    either: either,
    optional: optional,
    anyNumberOfTimes: anyNumberOfTimes
  };

  for (const key in MODES) {
    // @ts-ignore
    if (typeof MODES[key] === "object") {
      // @ts-ignore
      deepFreeze(MODES[key]);
    }
  }

  // merge all the modes/regexes into our main object
  Object.assign(hljs, MODES);

  return hljs;
};

// Other names for the variable may break build script
const highlight = HLJS({});

// returns a new instance of the highlighter to be used for extensions
// check https://github.com/wooorm/lowlight/issues/47
highlight.newInstance = () => HLJS({});

module.exports = highlight;
highlight.HighlightJS = highlight;
highlight.default = highlight;


/***/ }),

/***/ "./node_modules/highlight.js/lib/index.js":
/*!************************************************!*\
  !*** ./node_modules/highlight.js/lib/index.js ***!
  \************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

var hljs = __webpack_require__(/*! ./core */ "./node_modules/highlight.js/lib/core.js");

hljs.registerLanguage('1c', __webpack_require__(/*! ./languages/1c */ "./node_modules/highlight.js/lib/languages/1c.js"));
hljs.registerLanguage('abnf', __webpack_require__(/*! ./languages/abnf */ "./node_modules/highlight.js/lib/languages/abnf.js"));
hljs.registerLanguage('accesslog', __webpack_require__(/*! ./languages/accesslog */ "./node_modules/highlight.js/lib/languages/accesslog.js"));
hljs.registerLanguage('actionscript', __webpack_require__(/*! ./languages/actionscript */ "./node_modules/highlight.js/lib/languages/actionscript.js"));
hljs.registerLanguage('ada', __webpack_require__(/*! ./languages/ada */ "./node_modules/highlight.js/lib/languages/ada.js"));
hljs.registerLanguage('angelscript', __webpack_require__(/*! ./languages/angelscript */ "./node_modules/highlight.js/lib/languages/angelscript.js"));
hljs.registerLanguage('apache', __webpack_require__(/*! ./languages/apache */ "./node_modules/highlight.js/lib/languages/apache.js"));
hljs.registerLanguage('applescript', __webpack_require__(/*! ./languages/applescript */ "./node_modules/highlight.js/lib/languages/applescript.js"));
hljs.registerLanguage('arcade', __webpack_require__(/*! ./languages/arcade */ "./node_modules/highlight.js/lib/languages/arcade.js"));
hljs.registerLanguage('arduino', __webpack_require__(/*! ./languages/arduino */ "./node_modules/highlight.js/lib/languages/arduino.js"));
hljs.registerLanguage('armasm', __webpack_require__(/*! ./languages/armasm */ "./node_modules/highlight.js/lib/languages/armasm.js"));
hljs.registerLanguage('xml', __webpack_require__(/*! ./languages/xml */ "./node_modules/highlight.js/lib/languages/xml.js"));
hljs.registerLanguage('asciidoc', __webpack_require__(/*! ./languages/asciidoc */ "./node_modules/highlight.js/lib/languages/asciidoc.js"));
hljs.registerLanguage('aspectj', __webpack_require__(/*! ./languages/aspectj */ "./node_modules/highlight.js/lib/languages/aspectj.js"));
hljs.registerLanguage('autohotkey', __webpack_require__(/*! ./languages/autohotkey */ "./node_modules/highlight.js/lib/languages/autohotkey.js"));
hljs.registerLanguage('autoit', __webpack_require__(/*! ./languages/autoit */ "./node_modules/highlight.js/lib/languages/autoit.js"));
hljs.registerLanguage('avrasm', __webpack_require__(/*! ./languages/avrasm */ "./node_modules/highlight.js/lib/languages/avrasm.js"));
hljs.registerLanguage('awk', __webpack_require__(/*! ./languages/awk */ "./node_modules/highlight.js/lib/languages/awk.js"));
hljs.registerLanguage('axapta', __webpack_require__(/*! ./languages/axapta */ "./node_modules/highlight.js/lib/languages/axapta.js"));
hljs.registerLanguage('bash', __webpack_require__(/*! ./languages/bash */ "./node_modules/highlight.js/lib/languages/bash.js"));
hljs.registerLanguage('basic', __webpack_require__(/*! ./languages/basic */ "./node_modules/highlight.js/lib/languages/basic.js"));
hljs.registerLanguage('bnf', __webpack_require__(/*! ./languages/bnf */ "./node_modules/highlight.js/lib/languages/bnf.js"));
hljs.registerLanguage('brainfuck', __webpack_require__(/*! ./languages/brainfuck */ "./node_modules/highlight.js/lib/languages/brainfuck.js"));
hljs.registerLanguage('c', __webpack_require__(/*! ./languages/c */ "./node_modules/highlight.js/lib/languages/c.js"));
hljs.registerLanguage('cal', __webpack_require__(/*! ./languages/cal */ "./node_modules/highlight.js/lib/languages/cal.js"));
hljs.registerLanguage('capnproto', __webpack_require__(/*! ./languages/capnproto */ "./node_modules/highlight.js/lib/languages/capnproto.js"));
hljs.registerLanguage('ceylon', __webpack_require__(/*! ./languages/ceylon */ "./node_modules/highlight.js/lib/languages/ceylon.js"));
hljs.registerLanguage('clean', __webpack_require__(/*! ./languages/clean */ "./node_modules/highlight.js/lib/languages/clean.js"));
hljs.registerLanguage('clojure', __webpack_require__(/*! ./languages/clojure */ "./node_modules/highlight.js/lib/languages/clojure.js"));
hljs.registerLanguage('clojure-repl', __webpack_require__(/*! ./languages/clojure-repl */ "./node_modules/highlight.js/lib/languages/clojure-repl.js"));
hljs.registerLanguage('cmake', __webpack_require__(/*! ./languages/cmake */ "./node_modules/highlight.js/lib/languages/cmake.js"));
hljs.registerLanguage('coffeescript', __webpack_require__(/*! ./languages/coffeescript */ "./node_modules/highlight.js/lib/languages/coffeescript.js"));
hljs.registerLanguage('coq', __webpack_require__(/*! ./languages/coq */ "./node_modules/highlight.js/lib/languages/coq.js"));
hljs.registerLanguage('cos', __webpack_require__(/*! ./languages/cos */ "./node_modules/highlight.js/lib/languages/cos.js"));
hljs.registerLanguage('cpp', __webpack_require__(/*! ./languages/cpp */ "./node_modules/highlight.js/lib/languages/cpp.js"));
hljs.registerLanguage('crmsh', __webpack_require__(/*! ./languages/crmsh */ "./node_modules/highlight.js/lib/languages/crmsh.js"));
hljs.registerLanguage('crystal', __webpack_require__(/*! ./languages/crystal */ "./node_modules/highlight.js/lib/languages/crystal.js"));
hljs.registerLanguage('csharp', __webpack_require__(/*! ./languages/csharp */ "./node_modules/highlight.js/lib/languages/csharp.js"));
hljs.registerLanguage('csp', __webpack_require__(/*! ./languages/csp */ "./node_modules/highlight.js/lib/languages/csp.js"));
hljs.registerLanguage('css', __webpack_require__(/*! ./languages/css */ "./node_modules/highlight.js/lib/languages/css.js"));
hljs.registerLanguage('d', __webpack_require__(/*! ./languages/d */ "./node_modules/highlight.js/lib/languages/d.js"));
hljs.registerLanguage('markdown', __webpack_require__(/*! ./languages/markdown */ "./node_modules/highlight.js/lib/languages/markdown.js"));
hljs.registerLanguage('dart', __webpack_require__(/*! ./languages/dart */ "./node_modules/highlight.js/lib/languages/dart.js"));
hljs.registerLanguage('delphi', __webpack_require__(/*! ./languages/delphi */ "./node_modules/highlight.js/lib/languages/delphi.js"));
hljs.registerLanguage('diff', __webpack_require__(/*! ./languages/diff */ "./node_modules/highlight.js/lib/languages/diff.js"));
hljs.registerLanguage('django', __webpack_require__(/*! ./languages/django */ "./node_modules/highlight.js/lib/languages/django.js"));
hljs.registerLanguage('dns', __webpack_require__(/*! ./languages/dns */ "./node_modules/highlight.js/lib/languages/dns.js"));
hljs.registerLanguage('dockerfile', __webpack_require__(/*! ./languages/dockerfile */ "./node_modules/highlight.js/lib/languages/dockerfile.js"));
hljs.registerLanguage('dos', __webpack_require__(/*! ./languages/dos */ "./node_modules/highlight.js/lib/languages/dos.js"));
hljs.registerLanguage('dsconfig', __webpack_require__(/*! ./languages/dsconfig */ "./node_modules/highlight.js/lib/languages/dsconfig.js"));
hljs.registerLanguage('dts', __webpack_require__(/*! ./languages/dts */ "./node_modules/highlight.js/lib/languages/dts.js"));
hljs.registerLanguage('dust', __webpack_require__(/*! ./languages/dust */ "./node_modules/highlight.js/lib/languages/dust.js"));
hljs.registerLanguage('ebnf', __webpack_require__(/*! ./languages/ebnf */ "./node_modules/highlight.js/lib/languages/ebnf.js"));
hljs.registerLanguage('elixir', __webpack_require__(/*! ./languages/elixir */ "./node_modules/highlight.js/lib/languages/elixir.js"));
hljs.registerLanguage('elm', __webpack_require__(/*! ./languages/elm */ "./node_modules/highlight.js/lib/languages/elm.js"));
hljs.registerLanguage('ruby', __webpack_require__(/*! ./languages/ruby */ "./node_modules/highlight.js/lib/languages/ruby.js"));
hljs.registerLanguage('erb', __webpack_require__(/*! ./languages/erb */ "./node_modules/highlight.js/lib/languages/erb.js"));
hljs.registerLanguage('erlang-repl', __webpack_require__(/*! ./languages/erlang-repl */ "./node_modules/highlight.js/lib/languages/erlang-repl.js"));
hljs.registerLanguage('erlang', __webpack_require__(/*! ./languages/erlang */ "./node_modules/highlight.js/lib/languages/erlang.js"));
hljs.registerLanguage('excel', __webpack_require__(/*! ./languages/excel */ "./node_modules/highlight.js/lib/languages/excel.js"));
hljs.registerLanguage('fix', __webpack_require__(/*! ./languages/fix */ "./node_modules/highlight.js/lib/languages/fix.js"));
hljs.registerLanguage('flix', __webpack_require__(/*! ./languages/flix */ "./node_modules/highlight.js/lib/languages/flix.js"));
hljs.registerLanguage('fortran', __webpack_require__(/*! ./languages/fortran */ "./node_modules/highlight.js/lib/languages/fortran.js"));
hljs.registerLanguage('fsharp', __webpack_require__(/*! ./languages/fsharp */ "./node_modules/highlight.js/lib/languages/fsharp.js"));
hljs.registerLanguage('gams', __webpack_require__(/*! ./languages/gams */ "./node_modules/highlight.js/lib/languages/gams.js"));
hljs.registerLanguage('gauss', __webpack_require__(/*! ./languages/gauss */ "./node_modules/highlight.js/lib/languages/gauss.js"));
hljs.registerLanguage('gcode', __webpack_require__(/*! ./languages/gcode */ "./node_modules/highlight.js/lib/languages/gcode.js"));
hljs.registerLanguage('gherkin', __webpack_require__(/*! ./languages/gherkin */ "./node_modules/highlight.js/lib/languages/gherkin.js"));
hljs.registerLanguage('glsl', __webpack_require__(/*! ./languages/glsl */ "./node_modules/highlight.js/lib/languages/glsl.js"));
hljs.registerLanguage('gml', __webpack_require__(/*! ./languages/gml */ "./node_modules/highlight.js/lib/languages/gml.js"));
hljs.registerLanguage('go', __webpack_require__(/*! ./languages/go */ "./node_modules/highlight.js/lib/languages/go.js"));
hljs.registerLanguage('golo', __webpack_require__(/*! ./languages/golo */ "./node_modules/highlight.js/lib/languages/golo.js"));
hljs.registerLanguage('gradle', __webpack_require__(/*! ./languages/gradle */ "./node_modules/highlight.js/lib/languages/gradle.js"));
hljs.registerLanguage('graphql', __webpack_require__(/*! ./languages/graphql */ "./node_modules/highlight.js/lib/languages/graphql.js"));
hljs.registerLanguage('groovy', __webpack_require__(/*! ./languages/groovy */ "./node_modules/highlight.js/lib/languages/groovy.js"));
hljs.registerLanguage('haml', __webpack_require__(/*! ./languages/haml */ "./node_modules/highlight.js/lib/languages/haml.js"));
hljs.registerLanguage('handlebars', __webpack_require__(/*! ./languages/handlebars */ "./node_modules/highlight.js/lib/languages/handlebars.js"));
hljs.registerLanguage('haskell', __webpack_require__(/*! ./languages/haskell */ "./node_modules/highlight.js/lib/languages/haskell.js"));
hljs.registerLanguage('haxe', __webpack_require__(/*! ./languages/haxe */ "./node_modules/highlight.js/lib/languages/haxe.js"));
hljs.registerLanguage('hsp', __webpack_require__(/*! ./languages/hsp */ "./node_modules/highlight.js/lib/languages/hsp.js"));
hljs.registerLanguage('http', __webpack_require__(/*! ./languages/http */ "./node_modules/highlight.js/lib/languages/http.js"));
hljs.registerLanguage('hy', __webpack_require__(/*! ./languages/hy */ "./node_modules/highlight.js/lib/languages/hy.js"));
hljs.registerLanguage('inform7', __webpack_require__(/*! ./languages/inform7 */ "./node_modules/highlight.js/lib/languages/inform7.js"));
hljs.registerLanguage('ini', __webpack_require__(/*! ./languages/ini */ "./node_modules/highlight.js/lib/languages/ini.js"));
hljs.registerLanguage('irpf90', __webpack_require__(/*! ./languages/irpf90 */ "./node_modules/highlight.js/lib/languages/irpf90.js"));
hljs.registerLanguage('isbl', __webpack_require__(/*! ./languages/isbl */ "./node_modules/highlight.js/lib/languages/isbl.js"));
hljs.registerLanguage('java', __webpack_require__(/*! ./languages/java */ "./node_modules/highlight.js/lib/languages/java.js"));
hljs.registerLanguage('javascript', __webpack_require__(/*! ./languages/javascript */ "./node_modules/highlight.js/lib/languages/javascript.js"));
hljs.registerLanguage('jboss-cli', __webpack_require__(/*! ./languages/jboss-cli */ "./node_modules/highlight.js/lib/languages/jboss-cli.js"));
hljs.registerLanguage('json', __webpack_require__(/*! ./languages/json */ "./node_modules/highlight.js/lib/languages/json.js"));
hljs.registerLanguage('julia', __webpack_require__(/*! ./languages/julia */ "./node_modules/highlight.js/lib/languages/julia.js"));
hljs.registerLanguage('julia-repl', __webpack_require__(/*! ./languages/julia-repl */ "./node_modules/highlight.js/lib/languages/julia-repl.js"));
hljs.registerLanguage('kotlin', __webpack_require__(/*! ./languages/kotlin */ "./node_modules/highlight.js/lib/languages/kotlin.js"));
hljs.registerLanguage('lasso', __webpack_require__(/*! ./languages/lasso */ "./node_modules/highlight.js/lib/languages/lasso.js"));
hljs.registerLanguage('latex', __webpack_require__(/*! ./languages/latex */ "./node_modules/highlight.js/lib/languages/latex.js"));
hljs.registerLanguage('ldif', __webpack_require__(/*! ./languages/ldif */ "./node_modules/highlight.js/lib/languages/ldif.js"));
hljs.registerLanguage('leaf', __webpack_require__(/*! ./languages/leaf */ "./node_modules/highlight.js/lib/languages/leaf.js"));
hljs.registerLanguage('less', __webpack_require__(/*! ./languages/less */ "./node_modules/highlight.js/lib/languages/less.js"));
hljs.registerLanguage('lisp', __webpack_require__(/*! ./languages/lisp */ "./node_modules/highlight.js/lib/languages/lisp.js"));
hljs.registerLanguage('livecodeserver', __webpack_require__(/*! ./languages/livecodeserver */ "./node_modules/highlight.js/lib/languages/livecodeserver.js"));
hljs.registerLanguage('livescript', __webpack_require__(/*! ./languages/livescript */ "./node_modules/highlight.js/lib/languages/livescript.js"));
hljs.registerLanguage('llvm', __webpack_require__(/*! ./languages/llvm */ "./node_modules/highlight.js/lib/languages/llvm.js"));
hljs.registerLanguage('lsl', __webpack_require__(/*! ./languages/lsl */ "./node_modules/highlight.js/lib/languages/lsl.js"));
hljs.registerLanguage('lua', __webpack_require__(/*! ./languages/lua */ "./node_modules/highlight.js/lib/languages/lua.js"));
hljs.registerLanguage('makefile', __webpack_require__(/*! ./languages/makefile */ "./node_modules/highlight.js/lib/languages/makefile.js"));
hljs.registerLanguage('mathematica', __webpack_require__(/*! ./languages/mathematica */ "./node_modules/highlight.js/lib/languages/mathematica.js"));
hljs.registerLanguage('matlab', __webpack_require__(/*! ./languages/matlab */ "./node_modules/highlight.js/lib/languages/matlab.js"));
hljs.registerLanguage('maxima', __webpack_require__(/*! ./languages/maxima */ "./node_modules/highlight.js/lib/languages/maxima.js"));
hljs.registerLanguage('mel', __webpack_require__(/*! ./languages/mel */ "./node_modules/highlight.js/lib/languages/mel.js"));
hljs.registerLanguage('mercury', __webpack_require__(/*! ./languages/mercury */ "./node_modules/highlight.js/lib/languages/mercury.js"));
hljs.registerLanguage('mipsasm', __webpack_require__(/*! ./languages/mipsasm */ "./node_modules/highlight.js/lib/languages/mipsasm.js"));
hljs.registerLanguage('mizar', __webpack_require__(/*! ./languages/mizar */ "./node_modules/highlight.js/lib/languages/mizar.js"));
hljs.registerLanguage('perl', __webpack_require__(/*! ./languages/perl */ "./node_modules/highlight.js/lib/languages/perl.js"));
hljs.registerLanguage('mojolicious', __webpack_require__(/*! ./languages/mojolicious */ "./node_modules/highlight.js/lib/languages/mojolicious.js"));
hljs.registerLanguage('monkey', __webpack_require__(/*! ./languages/monkey */ "./node_modules/highlight.js/lib/languages/monkey.js"));
hljs.registerLanguage('moonscript', __webpack_require__(/*! ./languages/moonscript */ "./node_modules/highlight.js/lib/languages/moonscript.js"));
hljs.registerLanguage('n1ql', __webpack_require__(/*! ./languages/n1ql */ "./node_modules/highlight.js/lib/languages/n1ql.js"));
hljs.registerLanguage('nestedtext', __webpack_require__(/*! ./languages/nestedtext */ "./node_modules/highlight.js/lib/languages/nestedtext.js"));
hljs.registerLanguage('nginx', __webpack_require__(/*! ./languages/nginx */ "./node_modules/highlight.js/lib/languages/nginx.js"));
hljs.registerLanguage('nim', __webpack_require__(/*! ./languages/nim */ "./node_modules/highlight.js/lib/languages/nim.js"));
hljs.registerLanguage('nix', __webpack_require__(/*! ./languages/nix */ "./node_modules/highlight.js/lib/languages/nix.js"));
hljs.registerLanguage('node-repl', __webpack_require__(/*! ./languages/node-repl */ "./node_modules/highlight.js/lib/languages/node-repl.js"));
hljs.registerLanguage('nsis', __webpack_require__(/*! ./languages/nsis */ "./node_modules/highlight.js/lib/languages/nsis.js"));
hljs.registerLanguage('objectivec', __webpack_require__(/*! ./languages/objectivec */ "./node_modules/highlight.js/lib/languages/objectivec.js"));
hljs.registerLanguage('ocaml', __webpack_require__(/*! ./languages/ocaml */ "./node_modules/highlight.js/lib/languages/ocaml.js"));
hljs.registerLanguage('openscad', __webpack_require__(/*! ./languages/openscad */ "./node_modules/highlight.js/lib/languages/openscad.js"));
hljs.registerLanguage('oxygene', __webpack_require__(/*! ./languages/oxygene */ "./node_modules/highlight.js/lib/languages/oxygene.js"));
hljs.registerLanguage('parser3', __webpack_require__(/*! ./languages/parser3 */ "./node_modules/highlight.js/lib/languages/parser3.js"));
hljs.registerLanguage('pf', __webpack_require__(/*! ./languages/pf */ "./node_modules/highlight.js/lib/languages/pf.js"));
hljs.registerLanguage('pgsql', __webpack_require__(/*! ./languages/pgsql */ "./node_modules/highlight.js/lib/languages/pgsql.js"));
hljs.registerLanguage('php', __webpack_require__(/*! ./languages/php */ "./node_modules/highlight.js/lib/languages/php.js"));
hljs.registerLanguage('php-template', __webpack_require__(/*! ./languages/php-template */ "./node_modules/highlight.js/lib/languages/php-template.js"));
hljs.registerLanguage('plaintext', __webpack_require__(/*! ./languages/plaintext */ "./node_modules/highlight.js/lib/languages/plaintext.js"));
hljs.registerLanguage('pony', __webpack_require__(/*! ./languages/pony */ "./node_modules/highlight.js/lib/languages/pony.js"));
hljs.registerLanguage('powershell', __webpack_require__(/*! ./languages/powershell */ "./node_modules/highlight.js/lib/languages/powershell.js"));
hljs.registerLanguage('processing', __webpack_require__(/*! ./languages/processing */ "./node_modules/highlight.js/lib/languages/processing.js"));
hljs.registerLanguage('profile', __webpack_require__(/*! ./languages/profile */ "./node_modules/highlight.js/lib/languages/profile.js"));
hljs.registerLanguage('prolog', __webpack_require__(/*! ./languages/prolog */ "./node_modules/highlight.js/lib/languages/prolog.js"));
hljs.registerLanguage('properties', __webpack_require__(/*! ./languages/properties */ "./node_modules/highlight.js/lib/languages/properties.js"));
hljs.registerLanguage('protobuf', __webpack_require__(/*! ./languages/protobuf */ "./node_modules/highlight.js/lib/languages/protobuf.js"));
hljs.registerLanguage('puppet', __webpack_require__(/*! ./languages/puppet */ "./node_modules/highlight.js/lib/languages/puppet.js"));
hljs.registerLanguage('purebasic', __webpack_require__(/*! ./languages/purebasic */ "./node_modules/highlight.js/lib/languages/purebasic.js"));
hljs.registerLanguage('python', __webpack_require__(/*! ./languages/python */ "./node_modules/highlight.js/lib/languages/python.js"));
hljs.registerLanguage('python-repl', __webpack_require__(/*! ./languages/python-repl */ "./node_modules/highlight.js/lib/languages/python-repl.js"));
hljs.registerLanguage('q', __webpack_require__(/*! ./languages/q */ "./node_modules/highlight.js/lib/languages/q.js"));
hljs.registerLanguage('qml', __webpack_require__(/*! ./languages/qml */ "./node_modules/highlight.js/lib/languages/qml.js"));
hljs.registerLanguage('r', __webpack_require__(/*! ./languages/r */ "./node_modules/highlight.js/lib/languages/r.js"));
hljs.registerLanguage('reasonml', __webpack_require__(/*! ./languages/reasonml */ "./node_modules/highlight.js/lib/languages/reasonml.js"));
hljs.registerLanguage('rib', __webpack_require__(/*! ./languages/rib */ "./node_modules/highlight.js/lib/languages/rib.js"));
hljs.registerLanguage('roboconf', __webpack_require__(/*! ./languages/roboconf */ "./node_modules/highlight.js/lib/languages/roboconf.js"));
hljs.registerLanguage('routeros', __webpack_require__(/*! ./languages/routeros */ "./node_modules/highlight.js/lib/languages/routeros.js"));
hljs.registerLanguage('rsl', __webpack_require__(/*! ./languages/rsl */ "./node_modules/highlight.js/lib/languages/rsl.js"));
hljs.registerLanguage('ruleslanguage', __webpack_require__(/*! ./languages/ruleslanguage */ "./node_modules/highlight.js/lib/languages/ruleslanguage.js"));
hljs.registerLanguage('rust', __webpack_require__(/*! ./languages/rust */ "./node_modules/highlight.js/lib/languages/rust.js"));
hljs.registerLanguage('sas', __webpack_require__(/*! ./languages/sas */ "./node_modules/highlight.js/lib/languages/sas.js"));
hljs.registerLanguage('scala', __webpack_require__(/*! ./languages/scala */ "./node_modules/highlight.js/lib/languages/scala.js"));
hljs.registerLanguage('scheme', __webpack_require__(/*! ./languages/scheme */ "./node_modules/highlight.js/lib/languages/scheme.js"));
hljs.registerLanguage('scilab', __webpack_require__(/*! ./languages/scilab */ "./node_modules/highlight.js/lib/languages/scilab.js"));
hljs.registerLanguage('scss', __webpack_require__(/*! ./languages/scss */ "./node_modules/highlight.js/lib/languages/scss.js"));
hljs.registerLanguage('shell', __webpack_require__(/*! ./languages/shell */ "./node_modules/highlight.js/lib/languages/shell.js"));
hljs.registerLanguage('smali', __webpack_require__(/*! ./languages/smali */ "./node_modules/highlight.js/lib/languages/smali.js"));
hljs.registerLanguage('smalltalk', __webpack_require__(/*! ./languages/smalltalk */ "./node_modules/highlight.js/lib/languages/smalltalk.js"));
hljs.registerLanguage('sml', __webpack_require__(/*! ./languages/sml */ "./node_modules/highlight.js/lib/languages/sml.js"));
hljs.registerLanguage('sqf', __webpack_require__(/*! ./languages/sqf */ "./node_modules/highlight.js/lib/languages/sqf.js"));
hljs.registerLanguage('sql', __webpack_require__(/*! ./languages/sql */ "./node_modules/highlight.js/lib/languages/sql.js"));
hljs.registerLanguage('stan', __webpack_require__(/*! ./languages/stan */ "./node_modules/highlight.js/lib/languages/stan.js"));
hljs.registerLanguage('stata', __webpack_require__(/*! ./languages/stata */ "./node_modules/highlight.js/lib/languages/stata.js"));
hljs.registerLanguage('step21', __webpack_require__(/*! ./languages/step21 */ "./node_modules/highlight.js/lib/languages/step21.js"));
hljs.registerLanguage('stylus', __webpack_require__(/*! ./languages/stylus */ "./node_modules/highlight.js/lib/languages/stylus.js"));
hljs.registerLanguage('subunit', __webpack_require__(/*! ./languages/subunit */ "./node_modules/highlight.js/lib/languages/subunit.js"));
hljs.registerLanguage('swift', __webpack_require__(/*! ./languages/swift */ "./node_modules/highlight.js/lib/languages/swift.js"));
hljs.registerLanguage('taggerscript', __webpack_require__(/*! ./languages/taggerscript */ "./node_modules/highlight.js/lib/languages/taggerscript.js"));
hljs.registerLanguage('yaml', __webpack_require__(/*! ./languages/yaml */ "./node_modules/highlight.js/lib/languages/yaml.js"));
hljs.registerLanguage('tap', __webpack_require__(/*! ./languages/tap */ "./node_modules/highlight.js/lib/languages/tap.js"));
hljs.registerLanguage('tcl', __webpack_require__(/*! ./languages/tcl */ "./node_modules/highlight.js/lib/languages/tcl.js"));
hljs.registerLanguage('thrift', __webpack_require__(/*! ./languages/thrift */ "./node_modules/highlight.js/lib/languages/thrift.js"));
hljs.registerLanguage('tp', __webpack_require__(/*! ./languages/tp */ "./node_modules/highlight.js/lib/languages/tp.js"));
hljs.registerLanguage('twig', __webpack_require__(/*! ./languages/twig */ "./node_modules/highlight.js/lib/languages/twig.js"));
hljs.registerLanguage('typescript', __webpack_require__(/*! ./languages/typescript */ "./node_modules/highlight.js/lib/languages/typescript.js"));
hljs.registerLanguage('vala', __webpack_require__(/*! ./languages/vala */ "./node_modules/highlight.js/lib/languages/vala.js"));
hljs.registerLanguage('vbnet', __webpack_require__(/*! ./languages/vbnet */ "./node_modules/highlight.js/lib/languages/vbnet.js"));
hljs.registerLanguage('vbscript', __webpack_require__(/*! ./languages/vbscript */ "./node_modules/highlight.js/lib/languages/vbscript.js"));
hljs.registerLanguage('vbscript-html', __webpack_require__(/*! ./languages/vbscript-html */ "./node_modules/highlight.js/lib/languages/vbscript-html.js"));
hljs.registerLanguage('verilog', __webpack_require__(/*! ./languages/verilog */ "./node_modules/highlight.js/lib/languages/verilog.js"));
hljs.registerLanguage('vhdl', __webpack_require__(/*! ./languages/vhdl */ "./node_modules/highlight.js/lib/languages/vhdl.js"));
hljs.registerLanguage('vim', __webpack_require__(/*! ./languages/vim */ "./node_modules/highlight.js/lib/languages/vim.js"));
hljs.registerLanguage('wasm', __webpack_require__(/*! ./languages/wasm */ "./node_modules/highlight.js/lib/languages/wasm.js"));
hljs.registerLanguage('wren', __webpack_require__(/*! ./languages/wren */ "./node_modules/highlight.js/lib/languages/wren.js"));
hljs.registerLanguage('x86asm', __webpack_require__(/*! ./languages/x86asm */ "./node_modules/highlight.js/lib/languages/x86asm.js"));
hljs.registerLanguage('xl', __webpack_require__(/*! ./languages/xl */ "./node_modules/highlight.js/lib/languages/xl.js"));
hljs.registerLanguage('xquery', __webpack_require__(/*! ./languages/xquery */ "./node_modules/highlight.js/lib/languages/xquery.js"));
hljs.registerLanguage('zephir', __webpack_require__(/*! ./languages/zephir */ "./node_modules/highlight.js/lib/languages/zephir.js"));

hljs.HighlightJS = hljs
hljs.default = hljs
module.exports = hljs;

/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/1c.js":
/*!*******************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/1c.js ***!
  \*******************************************************/
/***/ (function(module) {

/*
Language: 1C:Enterprise
Author: Stanislav Belov <stbelov@gmail.com>
Description: built-in language 1C:Enterprise (v7, v8)
Category: enterprise
*/

function _1c(hljs) {
  // общий паттерн для определения идентификаторов
  const UNDERSCORE_IDENT_RE = '[A-Za-zА-Яа-яёЁ_][A-Za-zА-Яа-яёЁ_0-9]+';

  // v7 уникальные ключевые слова, отсутствующие в v8 ==> keyword
  const v7_keywords =
  'далее ';

  // v8 ключевые слова ==> keyword
  const v8_keywords =
  'возврат вызватьисключение выполнить для если и из или иначе иначеесли исключение каждого конецесли '
  + 'конецпопытки конеццикла не новый перейти перем по пока попытка прервать продолжить тогда цикл экспорт ';

  // keyword : ключевые слова
  const KEYWORD = v7_keywords + v8_keywords;

  // v7 уникальные директивы, отсутствующие в v8 ==> meta-keyword
  const v7_meta_keywords =
  'загрузитьизфайла ';

  // v8 ключевые слова в инструкциях препроцессора, директивах компиляции, аннотациях ==> meta-keyword
  const v8_meta_keywords =
  'вебклиент вместо внешнеесоединение клиент конецобласти мобильноеприложениеклиент мобильноеприложениесервер '
  + 'наклиенте наклиентенасервере наклиентенасерверебезконтекста насервере насерверебезконтекста область перед '
  + 'после сервер толстыйклиентобычноеприложение толстыйклиентуправляемоеприложение тонкийклиент ';

  // meta-keyword : ключевые слова в инструкциях препроцессора, директивах компиляции, аннотациях
  const METAKEYWORD = v7_meta_keywords + v8_meta_keywords;

  // v7 системные константы ==> built_in
  const v7_system_constants =
  'разделительстраниц разделительстрок символтабуляции ';

  // v7 уникальные методы глобального контекста, отсутствующие в v8 ==> built_in
  const v7_global_context_methods =
  'ansitooem oemtoansi ввестивидсубконто ввестиперечисление ввестипериод ввестиплансчетов выбранныйплансчетов '
  + 'датагод датамесяц датачисло заголовоксистемы значениевстроку значениеизстроки каталогиб каталогпользователя '
  + 'кодсимв конгода конецпериодаби конецрассчитанногопериодаби конецстандартногоинтервала конквартала конмесяца '
  + 'коннедели лог лог10 максимальноеколичествосубконто названиеинтерфейса названиенабораправ назначитьвид '
  + 'назначитьсчет найтиссылки началопериодаби началостандартногоинтервала начгода начквартала начмесяца '
  + 'начнедели номерднягода номерднянедели номернеделигода обработкаожидания основнойжурналрасчетов '
  + 'основнойплансчетов основнойязык очиститьокносообщений периодстр получитьвремята получитьдатута '
  + 'получитьдокументта получитьзначенияотбора получитьпозициюта получитьпустоезначение получитьта '
  + 'префиксавтонумерации пропись пустоезначение разм разобратьпозициюдокумента рассчитатьрегистрына '
  + 'рассчитатьрегистрыпо симв создатьобъект статусвозврата стрколичествострок сформироватьпозициюдокумента '
  + 'счетпокоду текущеевремя типзначения типзначениястр установитьтана установитьтапо фиксшаблон шаблон ';

  // v8 методы глобального контекста ==> built_in
  const v8_global_context_methods =
  'acos asin atan base64значение base64строка cos exp log log10 pow sin sqrt tan xmlзначение xmlстрока '
  + 'xmlтип xmlтипзнч активноеокно безопасныйрежим безопасныйрежимразделенияданных булево ввестидату ввестизначение '
  + 'ввестистроку ввестичисло возможностьчтенияxml вопрос восстановитьзначение врег выгрузитьжурналрегистрации '
  + 'выполнитьобработкуоповещения выполнитьпроверкуправдоступа вычислить год данныеформывзначение дата день деньгода '
  + 'деньнедели добавитьмесяц заблокироватьданныедляредактирования заблокироватьработупользователя завершитьработусистемы '
  + 'загрузитьвнешнююкомпоненту закрытьсправку записатьjson записатьxml записатьдатуjson записьжурналарегистрации '
  + 'заполнитьзначениясвойств запроситьразрешениепользователя запуститьприложение запуститьсистему зафиксироватьтранзакцию '
  + 'значениевданныеформы значениевстрокувнутр значениевфайл значениезаполнено значениеизстрокивнутр значениеизфайла '
  + 'изxmlтипа импортмоделиxdto имякомпьютера имяпользователя инициализироватьпредопределенныеданные информацияобошибке '
  + 'каталогбиблиотекимобильногоустройства каталогвременныхфайлов каталогдокументов каталогпрограммы кодироватьстроку '
  + 'кодлокализацииинформационнойбазы кодсимвола командасистемы конецгода конецдня конецквартала конецмесяца конецминуты '
  + 'конецнедели конецчаса конфигурациябазыданныхизмененадинамически конфигурацияизменена копироватьданныеформы '
  + 'копироватьфайл краткоепредставлениеошибки лев макс местноевремя месяц мин минута монопольныйрежим найти '
  + 'найтинедопустимыесимволыxml найтиокнопонавигационнойссылке найтипомеченныенаудаление найтипоссылкам найтифайлы '
  + 'началогода началодня началоквартала началомесяца началоминуты началонедели началочаса начатьзапросразрешенияпользователя '
  + 'начатьзапускприложения начатькопированиефайла начатьперемещениефайла начатьподключениевнешнейкомпоненты '
  + 'начатьподключениерасширенияработыскриптографией начатьподключениерасширенияработысфайлами начатьпоискфайлов '
  + 'начатьполучениекаталогавременныхфайлов начатьполучениекаталогадокументов начатьполучениерабочегокаталогаданныхпользователя '
  + 'начатьполучениефайлов начатьпомещениефайла начатьпомещениефайлов начатьсозданиедвоичныхданныхизфайла начатьсозданиекаталога '
  + 'начатьтранзакцию начатьудалениефайлов начатьустановкувнешнейкомпоненты начатьустановкурасширенияработыскриптографией '
  + 'начатьустановкурасширенияработысфайлами неделягода необходимостьзавершениясоединения номерсеансаинформационнойбазы '
  + 'номерсоединенияинформационнойбазы нрег нстр обновитьинтерфейс обновитьнумерациюобъектов обновитьповторноиспользуемыезначения '
  + 'обработкапрерыванияпользователя объединитьфайлы окр описаниеошибки оповестить оповеститьобизменении '
  + 'отключитьобработчикзапросанастроекклиенталицензирования отключитьобработчикожидания отключитьобработчикоповещения '
  + 'открытьзначение открытьиндекссправки открытьсодержаниесправки открытьсправку открытьформу открытьформумодально '
  + 'отменитьтранзакцию очиститьжурналрегистрации очиститьнастройкипользователя очиститьсообщения параметрыдоступа '
  + 'перейтипонавигационнойссылке переместитьфайл подключитьвнешнююкомпоненту '
  + 'подключитьобработчикзапросанастроекклиенталицензирования подключитьобработчикожидания подключитьобработчикоповещения '
  + 'подключитьрасширениеработыскриптографией подключитьрасширениеработысфайлами подробноепредставлениеошибки '
  + 'показатьвводдаты показатьвводзначения показатьвводстроки показатьвводчисла показатьвопрос показатьзначение '
  + 'показатьинформациюобошибке показатьнакарте показатьоповещениепользователя показатьпредупреждение полноеимяпользователя '
  + 'получитьcomобъект получитьxmlтип получитьадреспоместоположению получитьблокировкусеансов получитьвремязавершенияспящегосеанса '
  + 'получитьвремязасыпанияпассивногосеанса получитьвремяожиданияблокировкиданных получитьданныевыбора '
  + 'получитьдополнительныйпараметрклиенталицензирования получитьдопустимыекодылокализации получитьдопустимыечасовыепояса '
  + 'получитьзаголовокклиентскогоприложения получитьзаголовоксистемы получитьзначенияотборажурналарегистрации '
  + 'получитьидентификаторконфигурации получитьизвременногохранилища получитьимявременногофайла '
  + 'получитьимяклиенталицензирования получитьинформациюэкрановклиента получитьиспользованиежурналарегистрации '
  + 'получитьиспользованиесобытияжурналарегистрации получитькраткийзаголовокприложения получитьмакетоформления '
  + 'получитьмаскувсефайлы получитьмаскувсефайлыклиента получитьмаскувсефайлысервера получитьместоположениепоадресу '
  + 'получитьминимальнуюдлинупаролейпользователей получитьнавигационнуюссылку получитьнавигационнуюссылкуинформационнойбазы '
  + 'получитьобновлениеконфигурациибазыданных получитьобновлениепредопределенныхданныхинформационнойбазы получитьобщиймакет '
  + 'получитьобщуюформу получитьокна получитьоперативнуюотметкувремени получитьотключениебезопасногорежима '
  + 'получитьпараметрыфункциональныхопцийинтерфейса получитьполноеимяпредопределенногозначения '
  + 'получитьпредставлениянавигационныхссылок получитьпроверкусложностипаролейпользователей получитьразделительпути '
  + 'получитьразделительпутиклиента получитьразделительпутисервера получитьсеансыинформационнойбазы '
  + 'получитьскоростьклиентскогосоединения получитьсоединенияинформационнойбазы получитьсообщенияпользователю '
  + 'получитьсоответствиеобъектаиформы получитьсоставстандартногоинтерфейсаodata получитьструктурухранениябазыданных '
  + 'получитьтекущийсеансинформационнойбазы получитьфайл получитьфайлы получитьформу получитьфункциональнуюопцию '
  + 'получитьфункциональнуюопциюинтерфейса получитьчасовойпоясинформационнойбазы пользователиос поместитьвовременноехранилище '
  + 'поместитьфайл поместитьфайлы прав праводоступа предопределенноезначение представлениекодалокализации представлениепериода '
  + 'представлениеправа представлениеприложения представлениесобытияжурналарегистрации представлениечасовогопояса предупреждение '
  + 'прекратитьработусистемы привилегированныйрежим продолжитьвызов прочитатьjson прочитатьxml прочитатьдатуjson пустаястрока '
  + 'рабочийкаталогданныхпользователя разблокироватьданныедляредактирования разделитьфайл разорватьсоединениесвнешнимисточникомданных '
  + 'раскодироватьстроку рольдоступна секунда сигнал символ скопироватьжурналрегистрации смещениелетнеговремени '
  + 'смещениестандартноговремени соединитьбуферыдвоичныхданных создатькаталог создатьфабрикуxdto сокрл сокрлп сокрп сообщить '
  + 'состояние сохранитьзначение сохранитьнастройкипользователя сред стрдлина стрзаканчиваетсяна стрзаменить стрнайти стрначинаетсяс '
  + 'строка строкасоединенияинформационнойбазы стрполучитьстроку стрразделить стрсоединить стрсравнить стрчисловхождений '
  + 'стрчислострок стршаблон текущаядата текущаядатасеанса текущаяуниверсальнаядата текущаяуниверсальнаядатавмиллисекундах '
  + 'текущийвариантинтерфейсаклиентскогоприложения текущийвариантосновногошрифтаклиентскогоприложения текущийкодлокализации '
  + 'текущийрежимзапуска текущийязык текущийязыксистемы тип типзнч транзакцияактивна трег удалитьданныеинформационнойбазы '
  + 'удалитьизвременногохранилища удалитьобъекты удалитьфайлы универсальноевремя установитьбезопасныйрежим '
  + 'установитьбезопасныйрежимразделенияданных установитьблокировкусеансов установитьвнешнююкомпоненту '
  + 'установитьвремязавершенияспящегосеанса установитьвремязасыпанияпассивногосеанса установитьвремяожиданияблокировкиданных '
  + 'установитьзаголовокклиентскогоприложения установитьзаголовоксистемы установитьиспользованиежурналарегистрации '
  + 'установитьиспользованиесобытияжурналарегистрации установитькраткийзаголовокприложения '
  + 'установитьминимальнуюдлинупаролейпользователей установитьмонопольныйрежим установитьнастройкиклиенталицензирования '
  + 'установитьобновлениепредопределенныхданныхинформационнойбазы установитьотключениебезопасногорежима '
  + 'установитьпараметрыфункциональныхопцийинтерфейса установитьпривилегированныйрежим '
  + 'установитьпроверкусложностипаролейпользователей установитьрасширениеработыскриптографией '
  + 'установитьрасширениеработысфайлами установитьсоединениесвнешнимисточникомданных установитьсоответствиеобъектаиформы '
  + 'установитьсоставстандартногоинтерфейсаodata установитьчасовойпоясинформационнойбазы установитьчасовойпояссеанса '
  + 'формат цел час часовойпояс часовойпояссеанса число числопрописью этоадресвременногохранилища ';

  // v8 свойства глобального контекста ==> built_in
  const v8_global_context_property =
  'wsссылки библиотекакартинок библиотекамакетовоформлениякомпоновкиданных библиотекастилей бизнеспроцессы '
  + 'внешниеисточникиданных внешниеобработки внешниеотчеты встроенныепокупки главныйинтерфейс главныйстиль '
  + 'документы доставляемыеуведомления журналыдокументов задачи информацияобинтернетсоединении использованиерабочейдаты '
  + 'историяработыпользователя константы критерииотбора метаданные обработки отображениерекламы отправкадоставляемыхуведомлений '
  + 'отчеты панельзадачос параметрзапуска параметрысеанса перечисления планывидоврасчета планывидовхарактеристик '
  + 'планыобмена планысчетов полнотекстовыйпоиск пользователиинформационнойбазы последовательности проверкавстроенныхпокупок '
  + 'рабочаядата расширенияконфигурации регистрыбухгалтерии регистрынакопления регистрырасчета регистрысведений '
  + 'регламентныезадания сериализаторxdto справочники средствагеопозиционирования средствакриптографии средствамультимедиа '
  + 'средстваотображениярекламы средствапочты средствателефонии фабрикаxdto файловыепотоки фоновыезадания хранилищанастроек '
  + 'хранилищевариантовотчетов хранилищенастроекданныхформ хранилищеобщихнастроек хранилищепользовательскихнастроекдинамическихсписков '
  + 'хранилищепользовательскихнастроекотчетов хранилищесистемныхнастроек ';

  // built_in : встроенные или библиотечные объекты (константы, классы, функции)
  const BUILTIN =
  v7_system_constants
  + v7_global_context_methods + v8_global_context_methods
  + v8_global_context_property;

  // v8 системные наборы значений ==> class
  const v8_system_sets_of_values =
  'webцвета windowsцвета windowsшрифты библиотекакартинок рамкистиля символы цветастиля шрифтыстиля ';

  // v8 системные перечисления - интерфейсные ==> class
  const v8_system_enums_interface =
  'автоматическоесохранениеданныхформывнастройках автонумерациявформе автораздвижениесерий '
  + 'анимациядиаграммы вариантвыравниванияэлементовизаголовков вариантуправлениявысотойтаблицы '
  + 'вертикальнаяпрокруткаформы вертикальноеположение вертикальноеположениеэлемента видгруппыформы '
  + 'виддекорацииформы виддополненияэлементаформы видизмененияданных видкнопкиформы видпереключателя '
  + 'видподписейкдиаграмме видполяформы видфлажка влияниеразмеранапузырекдиаграммы горизонтальноеположение '
  + 'горизонтальноеположениеэлемента группировкаколонок группировкаподчиненныхэлементовформы '
  + 'группыиэлементы действиеперетаскивания дополнительныйрежимотображения допустимыедействияперетаскивания '
  + 'интервалмеждуэлементамиформы использованиевывода использованиеполосыпрокрутки '
  + 'используемоезначениеточкибиржевойдиаграммы историявыборапривводе источникзначенийоситочекдиаграммы '
  + 'источникзначенияразмерапузырькадиаграммы категориягруппыкоманд максимумсерий начальноеотображениедерева '
  + 'начальноеотображениесписка обновлениетекстаредактирования ориентациядендрограммы ориентациядиаграммы '
  + 'ориентацияметокдиаграммы ориентацияметоксводнойдиаграммы ориентацияэлементаформы отображениевдиаграмме '
  + 'отображениевлегендедиаграммы отображениегруппыкнопок отображениезаголовкашкалыдиаграммы '
  + 'отображениезначенийсводнойдиаграммы отображениезначенияизмерительнойдиаграммы '
  + 'отображениеинтерваладиаграммыганта отображениекнопки отображениекнопкивыбора отображениеобсужденийформы '
  + 'отображениеобычнойгруппы отображениеотрицательныхзначенийпузырьковойдиаграммы отображениепанелипоиска '
  + 'отображениеподсказки отображениепредупрежденияприредактировании отображениеразметкиполосырегулирования '
  + 'отображениестраницформы отображениетаблицы отображениетекстазначениядиаграммыганта '
  + 'отображениеуправленияобычнойгруппы отображениефигурыкнопки палитрацветовдиаграммы поведениеобычнойгруппы '
  + 'поддержкамасштабадендрограммы поддержкамасштабадиаграммыганта поддержкамасштабасводнойдиаграммы '
  + 'поисквтаблицепривводе положениезаголовкаэлементаформы положениекартинкикнопкиформы '
  + 'положениекартинкиэлементаграфическойсхемы положениекоманднойпанелиформы положениекоманднойпанелиэлементаформы '
  + 'положениеопорнойточкиотрисовки положениеподписейкдиаграмме положениеподписейшкалызначенийизмерительнойдиаграммы '
  + 'положениесостоянияпросмотра положениестрокипоиска положениетекстасоединительнойлинии положениеуправленияпоиском '
  + 'положениешкалывремени порядокотображенияточекгоризонтальнойгистограммы порядоксерийвлегендедиаграммы '
  + 'размеркартинки расположениезаголовкашкалыдиаграммы растягиваниеповертикалидиаграммыганта '
  + 'режимавтоотображениясостояния режимвводастроктаблицы режимвыборанезаполненного режимвыделениядаты '
  + 'режимвыделениястрокитаблицы режимвыделениятаблицы режимизмененияразмера режимизменениясвязанногозначения '
  + 'режимиспользованиядиалогапечати режимиспользованияпараметракоманды режиммасштабированияпросмотра '
  + 'режимосновногоокнаклиентскогоприложения режимоткрытияокнаформы режимотображениявыделения '
  + 'режимотображениягеографическойсхемы режимотображениязначенийсерии режимотрисовкисеткиграфическойсхемы '
  + 'режимполупрозрачностидиаграммы режимпробеловдиаграммы режимразмещениянастранице режимредактированияколонки '
  + 'режимсглаживаниядиаграммы режимсглаживанияиндикатора режимсписказадач сквозноевыравнивание '
  + 'сохранениеданныхформывнастройках способзаполнениятекстазаголовкашкалыдиаграммы '
  + 'способопределенияограничивающегозначениядиаграммы стандартнаягруппакоманд стандартноеоформление '
  + 'статусоповещенияпользователя стильстрелки типаппроксимациилиниитрендадиаграммы типдиаграммы '
  + 'типединицышкалывремени типимпортасерийслоягеографическойсхемы типлиниигеографическойсхемы типлиниидиаграммы '
  + 'типмаркерагеографическойсхемы типмаркерадиаграммы типобластиоформления '
  + 'типорганизацииисточникаданныхгеографическойсхемы типотображениясериислоягеографическойсхемы '
  + 'типотображенияточечногообъектагеографическойсхемы типотображенияшкалыэлементалегендыгеографическойсхемы '
  + 'типпоискаобъектовгеографическойсхемы типпроекциигеографическойсхемы типразмещенияизмерений '
  + 'типразмещенияреквизитовизмерений типрамкиэлементауправления типсводнойдиаграммы '
  + 'типсвязидиаграммыганта типсоединениязначенийпосериямдиаграммы типсоединенияточекдиаграммы '
  + 'типсоединительнойлинии типстороныэлементаграфическойсхемы типформыотчета типшкалырадарнойдиаграммы '
  + 'факторлиниитрендадиаграммы фигуракнопки фигурыграфическойсхемы фиксациявтаблице форматдняшкалывремени '
  + 'форматкартинки ширинаподчиненныхэлементовформы ';

  // v8 системные перечисления - свойства прикладных объектов ==> class
  const v8_system_enums_objects_properties =
  'виддвижениябухгалтерии виддвижениянакопления видпериодарегистрарасчета видсчета видточкимаршрутабизнеспроцесса '
  + 'использованиеагрегатарегистранакопления использованиегруппиэлементов использованиережимапроведения '
  + 'использованиесреза периодичностьагрегатарегистранакопления режимавтовремя режимзаписидокумента режимпроведениядокумента ';

  // v8 системные перечисления - планы обмена ==> class
  const v8_system_enums_exchange_plans =
  'авторегистрацияизменений допустимыйномерсообщения отправкаэлементаданных получениеэлементаданных ';

  // v8 системные перечисления - табличный документ ==> class
  const v8_system_enums_tabular_document =
  'использованиерасшифровкитабличногодокумента ориентациястраницы положениеитоговколоноксводнойтаблицы '
  + 'положениеитоговстроксводнойтаблицы положениетекстаотносительнокартинки расположениезаголовкагруппировкитабличногодокумента '
  + 'способчтениязначенийтабличногодокумента типдвустороннейпечати типзаполненияобластитабличногодокумента '
  + 'типкурсоровтабличногодокумента типлиниирисункатабличногодокумента типлинииячейкитабличногодокумента '
  + 'типнаправленияпереходатабличногодокумента типотображениявыделениятабличногодокумента типотображениялинийсводнойтаблицы '
  + 'типразмещениятекстатабличногодокумента типрисункатабличногодокумента типсмещениятабличногодокумента '
  + 'типузоратабличногодокумента типфайлатабличногодокумента точностьпечати чередованиерасположениястраниц ';

  // v8 системные перечисления - планировщик ==> class
  const v8_system_enums_sheduler =
  'отображениевремениэлементовпланировщика ';

  // v8 системные перечисления - форматированный документ ==> class
  const v8_system_enums_formatted_document =
  'типфайлаформатированногодокумента ';

  // v8 системные перечисления - запрос ==> class
  const v8_system_enums_query =
  'обходрезультатазапроса типзаписизапроса ';

  // v8 системные перечисления - построитель отчета ==> class
  const v8_system_enums_report_builder =
  'видзаполнениярасшифровкипостроителяотчета типдобавленияпредставлений типизмеренияпостроителяотчета типразмещенияитогов ';

  // v8 системные перечисления - работа с файлами ==> class
  const v8_system_enums_files =
  'доступкфайлу режимдиалогавыборафайла режимоткрытияфайла ';

  // v8 системные перечисления - построитель запроса ==> class
  const v8_system_enums_query_builder =
  'типизмеренияпостроителязапроса ';

  // v8 системные перечисления - анализ данных ==> class
  const v8_system_enums_data_analysis =
  'видданныханализа методкластеризации типединицыинтервалавременианализаданных типзаполнениятаблицырезультатаанализаданных '
  + 'типиспользованиячисловыхзначенийанализаданных типисточникаданныхпоискаассоциаций типколонкианализаданныхдереворешений '
  + 'типколонкианализаданныхкластеризация типколонкианализаданныхобщаястатистика типколонкианализаданныхпоискассоциаций '
  + 'типколонкианализаданныхпоискпоследовательностей типколонкимоделипрогноза типмерырасстоянияанализаданных '
  + 'типотсеченияправилассоциации типполяанализаданных типстандартизациианализаданных типупорядочиванияправилассоциациианализаданных '
  + 'типупорядочиванияшаблоновпоследовательностейанализаданных типупрощениядереварешений ';

  // v8 системные перечисления - xml, json, xs, dom, xdto, web-сервисы ==> class
  const v8_system_enums_xml_json_xs_dom_xdto_ws =
  'wsнаправлениепараметра вариантxpathxs вариантзаписидатыjson вариантпростоготипаxs видгруппымоделиxs видфасетаxdto '
  + 'действиепостроителяdom завершенностьпростоготипаxs завершенностьсоставноготипаxs завершенностьсхемыxs запрещенныеподстановкиxs '
  + 'исключениягруппподстановкиxs категорияиспользованияатрибутаxs категорияограниченияидентичностиxs категорияограниченияпространствименxs '
  + 'методнаследованияxs модельсодержимогоxs назначениетипаxml недопустимыеподстановкиxs обработкапробельныхсимволовxs обработкасодержимогоxs '
  + 'ограничениезначенияxs параметрыотбораузловdom переносстрокjson позициявдокументеdom пробельныесимволыxml типатрибутаxml типзначенияjson '
  + 'типканоническогоxml типкомпонентыxs типпроверкиxml типрезультатаdomxpath типузлаdom типузлаxml формаxml формапредставленияxs '
  + 'форматдатыjson экранированиесимволовjson ';

  // v8 системные перечисления - система компоновки данных ==> class
  const v8_system_enums_data_composition_system =
  'видсравнениякомпоновкиданных действиеобработкирасшифровкикомпоновкиданных направлениесортировкикомпоновкиданных '
  + 'расположениевложенныхэлементоврезультатакомпоновкиданных расположениеитоговкомпоновкиданных расположениегруппировкикомпоновкиданных '
  + 'расположениеполейгруппировкикомпоновкиданных расположениеполякомпоновкиданных расположениереквизитовкомпоновкиданных '
  + 'расположениересурсовкомпоновкиданных типбухгалтерскогоостаткакомпоновкиданных типвыводатекстакомпоновкиданных '
  + 'типгруппировкикомпоновкиданных типгруппыэлементовотборакомпоновкиданных типдополненияпериодакомпоновкиданных '
  + 'типзаголовкаполейкомпоновкиданных типмакетагруппировкикомпоновкиданных типмакетаобластикомпоновкиданных типостаткакомпоновкиданных '
  + 'типпериодакомпоновкиданных типразмещениятекстакомпоновкиданных типсвязинаборовданныхкомпоновкиданных типэлементарезультатакомпоновкиданных '
  + 'расположениелегендыдиаграммыкомпоновкиданных типпримененияотборакомпоновкиданных режимотображенияэлементанастройкикомпоновкиданных '
  + 'режимотображениянастроеккомпоновкиданных состояниеэлементанастройкикомпоновкиданных способвосстановлениянастроеккомпоновкиданных '
  + 'режимкомпоновкирезультата использованиепараметракомпоновкиданных автопозицияресурсовкомпоновкиданных '
  + 'вариантиспользованиягруппировкикомпоновкиданных расположениересурсоввдиаграммекомпоновкиданных фиксациякомпоновкиданных '
  + 'использованиеусловногооформлениякомпоновкиданных ';

  // v8 системные перечисления - почта ==> class
  const v8_system_enums_email =
  'важностьинтернетпочтовогосообщения обработкатекстаинтернетпочтовогосообщения способкодированияинтернетпочтовоговложения '
  + 'способкодированиянеasciiсимволовинтернетпочтовогосообщения типтекстапочтовогосообщения протоколинтернетпочты '
  + 'статусразборапочтовогосообщения ';

  // v8 системные перечисления - журнал регистрации ==> class
  const v8_system_enums_logbook =
  'режимтранзакциизаписижурналарегистрации статустранзакциизаписижурналарегистрации уровеньжурналарегистрации ';

  // v8 системные перечисления - криптография ==> class
  const v8_system_enums_cryptography =
  'расположениехранилищасертификатовкриптографии режимвключениясертификатовкриптографии режимпроверкисертификатакриптографии '
  + 'типхранилищасертификатовкриптографии ';

  // v8 системные перечисления - ZIP ==> class
  const v8_system_enums_zip =
  'кодировкаименфайловвzipфайле методсжатияzip методшифрованияzip режимвосстановленияпутейфайловzip режимобработкиподкаталоговzip '
  + 'режимсохраненияпутейzip уровеньсжатияzip ';

  // v8 системные перечисления -
  // Блокировка данных, Фоновые задания, Автоматизированное тестирование,
  // Доставляемые уведомления, Встроенные покупки, Интернет, Работа с двоичными данными ==> class
  const v8_system_enums_other =
  'звуковоеоповещение направлениепереходакстроке позициявпотоке порядокбайтов режимблокировкиданных режимуправленияблокировкойданных '
  + 'сервисвстроенныхпокупок состояниефоновогозадания типподписчикадоставляемыхуведомлений уровеньиспользованиязащищенногосоединенияftp ';

  // v8 системные перечисления - схема запроса ==> class
  const v8_system_enums_request_schema =
  'направлениепорядкасхемызапроса типдополненияпериодамисхемызапроса типконтрольнойточкисхемызапроса типобъединениясхемызапроса '
  + 'типпараметрадоступнойтаблицысхемызапроса типсоединениясхемызапроса ';

  // v8 системные перечисления - свойства объектов метаданных ==> class
  const v8_system_enums_properties_of_metadata_objects =
  'httpметод автоиспользованиеобщегореквизита автопрефиксномеразадачи вариантвстроенногоязыка видиерархии видрегистранакопления '
  + 'видтаблицывнешнегоисточникаданных записьдвиженийприпроведении заполнениепоследовательностей индексирование '
  + 'использованиебазыпланавидоврасчета использованиебыстроговыбора использованиеобщегореквизита использованиеподчинения '
  + 'использованиеполнотекстовогопоиска использованиеразделяемыхданныхобщегореквизита использованиереквизита '
  + 'назначениеиспользованияприложения назначениерасширенияконфигурации направлениепередачи обновлениепредопределенныхданных '
  + 'оперативноепроведение основноепредставлениевидарасчета основноепредставлениевидахарактеристики основноепредставлениезадачи '
  + 'основноепредставлениепланаобмена основноепредставлениесправочника основноепредставлениесчета перемещениеграницыприпроведении '
  + 'периодичностьномерабизнеспроцесса периодичностьномерадокумента периодичностьрегистрарасчета периодичностьрегистрасведений '
  + 'повторноеиспользованиевозвращаемыхзначений полнотекстовыйпоискпривводепостроке принадлежностьобъекта проведение '
  + 'разделениеаутентификацииобщегореквизита разделениеданныхобщегореквизита разделениерасширенийконфигурацииобщегореквизита '
  + 'режимавтонумерацииобъектов режимзаписирегистра режимиспользованиямодальности '
  + 'режимиспользованиясинхронныхвызововрасширенийплатформыивнешнихкомпонент режимповторногоиспользованиясеансов '
  + 'режимполученияданныхвыборапривводепостроке режимсовместимости режимсовместимостиинтерфейса '
  + 'режимуправленияблокировкойданныхпоумолчанию сериикодовпланавидовхарактеристик сериикодовпланасчетов '
  + 'сериикодовсправочника созданиепривводе способвыбора способпоискастрокипривводепостроке способредактирования '
  + 'типданныхтаблицывнешнегоисточникаданных типкодапланавидоврасчета типкодасправочника типмакета типномерабизнеспроцесса '
  + 'типномерадокумента типномеразадачи типформы удалениедвижений ';

  // v8 системные перечисления - разные ==> class
  const v8_system_enums_differents =
  'важностьпроблемыприменениярасширенияконфигурации вариантинтерфейсаклиентскогоприложения вариантмасштабаформклиентскогоприложения '
  + 'вариантосновногошрифтаклиентскогоприложения вариантстандартногопериода вариантстандартнойдатыначала видграницы видкартинки '
  + 'видотображенияполнотекстовогопоиска видрамки видсравнения видцвета видчисловогозначения видшрифта допустимаядлина допустимыйзнак '
  + 'использованиеbyteordermark использованиеметаданныхполнотекстовогопоиска источникрасширенийконфигурации клавиша кодвозвратадиалога '
  + 'кодировкаxbase кодировкатекста направлениепоиска направлениесортировки обновлениепредопределенныхданных обновлениеприизмененииданных '
  + 'отображениепанелиразделов проверказаполнения режимдиалогавопрос режимзапускаклиентскогоприложения режимокругления режимоткрытияформприложения '
  + 'режимполнотекстовогопоиска скоростьклиентскогосоединения состояниевнешнегоисточникаданных состояниеобновленияконфигурациибазыданных '
  + 'способвыборасертификатаwindows способкодированиястроки статуссообщения типвнешнейкомпоненты типплатформы типповеденияклавишиenter '
  + 'типэлементаинформацииовыполненииобновленияконфигурациибазыданных уровеньизоляциитранзакций хешфункция частидаты';

  // class: встроенные наборы значений, системные перечисления (содержат дочерние значения, обращения к которым через разыменование)
  const CLASS =
  v8_system_sets_of_values
  + v8_system_enums_interface
  + v8_system_enums_objects_properties
  + v8_system_enums_exchange_plans
  + v8_system_enums_tabular_document
  + v8_system_enums_sheduler
  + v8_system_enums_formatted_document
  + v8_system_enums_query
  + v8_system_enums_report_builder
  + v8_system_enums_files
  + v8_system_enums_query_builder
  + v8_system_enums_data_analysis
  + v8_system_enums_xml_json_xs_dom_xdto_ws
  + v8_system_enums_data_composition_system
  + v8_system_enums_email
  + v8_system_enums_logbook
  + v8_system_enums_cryptography
  + v8_system_enums_zip
  + v8_system_enums_other
  + v8_system_enums_request_schema
  + v8_system_enums_properties_of_metadata_objects
  + v8_system_enums_differents;

  // v8 общие объекты (у объектов есть конструктор, экземпляры создаются методом НОВЫЙ) ==> type
  const v8_shared_object =
  'comобъект ftpсоединение httpзапрос httpсервисответ httpсоединение wsопределения wsпрокси xbase анализданных аннотацияxs '
  + 'блокировкаданных буфердвоичныхданных включениеxs выражениекомпоновкиданных генераторслучайныхчисел географическаясхема '
  + 'географическиекоординаты графическаясхема группамоделиxs данныерасшифровкикомпоновкиданных двоичныеданные дендрограмма '
  + 'диаграмма диаграммаганта диалогвыборафайла диалогвыборацвета диалогвыборашрифта диалограсписаниярегламентногозадания '
  + 'диалогредактированиястандартногопериода диапазон документdom документhtml документацияxs доставляемоеуведомление '
  + 'записьdom записьfastinfoset записьhtml записьjson записьxml записьzipфайла записьданных записьтекста записьузловdom '
  + 'запрос защищенноесоединениеopenssl значенияполейрасшифровкикомпоновкиданных извлечениетекста импортxs интернетпочта '
  + 'интернетпочтовоесообщение интернетпочтовыйпрофиль интернетпрокси интернетсоединение информациядляприложенияxs '
  + 'использованиеатрибутаxs использованиесобытияжурналарегистрации источникдоступныхнастроеккомпоновкиданных '
  + 'итераторузловdom картинка квалификаторыдаты квалификаторыдвоичныхданных квалификаторыстроки квалификаторычисла '
  + 'компоновщикмакетакомпоновкиданных компоновщикнастроеккомпоновкиданных конструктормакетаоформлениякомпоновкиданных '
  + 'конструкторнастроеккомпоновкиданных конструкторформатнойстроки линия макеткомпоновкиданных макетобластикомпоновкиданных '
  + 'макетоформлениякомпоновкиданных маскаxs менеджеркриптографии наборсхемxml настройкикомпоновкиданных настройкисериализацииjson '
  + 'обработкакартинок обработкарасшифровкикомпоновкиданных обходдереваdom объявлениеатрибутаxs объявлениенотацииxs '
  + 'объявлениеэлементаxs описаниеиспользованиясобытиядоступжурналарегистрации '
  + 'описаниеиспользованиясобытияотказвдоступежурналарегистрации описаниеобработкирасшифровкикомпоновкиданных '
  + 'описаниепередаваемогофайла описаниетипов определениегруппыатрибутовxs определениегруппымоделиxs '
  + 'определениеограниченияидентичностиxs определениепростоготипаxs определениесоставноготипаxs определениетипадокументаdom '
  + 'определенияxpathxs отборкомпоновкиданных пакетотображаемыхдокументов параметрвыбора параметркомпоновкиданных '
  + 'параметрызаписиjson параметрызаписиxml параметрычтенияxml переопределениеxs планировщик полеанализаданных '
  + 'полекомпоновкиданных построительdom построительзапроса построительотчета построительотчетаанализаданных '
  + 'построительсхемxml поток потоквпамяти почта почтовоесообщение преобразованиеxsl преобразованиекканоническомуxml '
  + 'процессорвыводарезультатакомпоновкиданныхвколлекциюзначений процессорвыводарезультатакомпоновкиданныхвтабличныйдокумент '
  + 'процессоркомпоновкиданных разыменовательпространствименdom рамка расписаниерегламентногозадания расширенноеимяxml '
  + 'результатчтенияданных своднаядиаграмма связьпараметравыбора связьпотипу связьпотипукомпоновкиданных сериализаторxdto '
  + 'сертификатклиентаwindows сертификатклиентафайл сертификаткриптографии сертификатыудостоверяющихцентровwindows '
  + 'сертификатыудостоверяющихцентровфайл сжатиеданных системнаяинформация сообщениепользователю сочетаниеклавиш '
  + 'сравнениезначений стандартнаядатаначала стандартныйпериод схемаxml схемакомпоновкиданных табличныйдокумент '
  + 'текстовыйдокумент тестируемоеприложение типданныхxml уникальныйидентификатор фабрикаxdto файл файловыйпоток '
  + 'фасетдлиныxs фасетколичестваразрядовдробнойчастиxs фасетмаксимальноговключающегозначенияxs '
  + 'фасетмаксимальногоисключающегозначенияxs фасетмаксимальнойдлиныxs фасетминимальноговключающегозначенияxs '
  + 'фасетминимальногоисключающегозначенияxs фасетминимальнойдлиныxs фасетобразцаxs фасетобщегоколичестваразрядовxs '
  + 'фасетперечисленияxs фасетпробельныхсимволовxs фильтрузловdom форматированнаястрока форматированныйдокумент '
  + 'фрагментxs хешированиеданных хранилищезначения цвет чтениеfastinfoset чтениеhtml чтениеjson чтениеxml чтениеzipфайла '
  + 'чтениеданных чтениетекста чтениеузловdom шрифт элементрезультатакомпоновкиданных ';

  // v8 универсальные коллекции значений ==> type
  const v8_universal_collection =
  'comsafearray деревозначений массив соответствие списокзначений структура таблицазначений фиксированнаяструктура '
  + 'фиксированноесоответствие фиксированныймассив ';

  // type : встроенные типы
  const TYPE =
  v8_shared_object
  + v8_universal_collection;

  // literal : примитивные типы
  const LITERAL = 'null истина ложь неопределено';

  // number : числа
  const NUMBERS = hljs.inherit(hljs.NUMBER_MODE);

  // string : строки
  const STRINGS = {
    className: 'string',
    begin: '"|\\|',
    end: '"|$',
    contains: [ { begin: '""' } ]
  };

  // number : даты
  const DATE = {
    begin: "'",
    end: "'",
    excludeBegin: true,
    excludeEnd: true,
    contains: [
      {
        className: 'number',
        begin: '\\d{4}([\\.\\\\/:-]?\\d{2}){0,5}'
      }
    ]
  };

  // comment : комментарии
  const COMMENTS = hljs.inherit(hljs.C_LINE_COMMENT_MODE);

  // meta : инструкции препроцессора, директивы компиляции
  const META = {
    className: 'meta',

    begin: '#|&',
    end: '$',
    keywords: {
      $pattern: UNDERSCORE_IDENT_RE,
      keyword: KEYWORD + METAKEYWORD
    },
    contains: [ COMMENTS ]
  };

  // symbol : метка goto
  const SYMBOL = {
    className: 'symbol',
    begin: '~',
    end: ';|:',
    excludeEnd: true
  };

  // function : объявление процедур и функций
  const FUNCTION = {
    className: 'function',
    variants: [
      {
        begin: 'процедура|функция',
        end: '\\)',
        keywords: 'процедура функция'
      },
      {
        begin: 'конецпроцедуры|конецфункции',
        keywords: 'конецпроцедуры конецфункции'
      }
    ],
    contains: [
      {
        begin: '\\(',
        end: '\\)',
        endsParent: true,
        contains: [
          {
            className: 'params',
            begin: UNDERSCORE_IDENT_RE,
            end: ',',
            excludeEnd: true,
            endsWithParent: true,
            keywords: {
              $pattern: UNDERSCORE_IDENT_RE,
              keyword: 'знач',
              literal: LITERAL
            },
            contains: [
              NUMBERS,
              STRINGS,
              DATE
            ]
          },
          COMMENTS
        ]
      },
      hljs.inherit(hljs.TITLE_MODE, { begin: UNDERSCORE_IDENT_RE })
    ]
  };

  return {
    name: '1C:Enterprise',
    case_insensitive: true,
    keywords: {
      $pattern: UNDERSCORE_IDENT_RE,
      keyword: KEYWORD,
      built_in: BUILTIN,
      class: CLASS,
      type: TYPE,
      literal: LITERAL
    },
    contains: [
      META,
      FUNCTION,
      COMMENTS,
      SYMBOL,
      NUMBERS,
      STRINGS,
      DATE
    ]
  };
}

module.exports = _1c;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/abnf.js":
/*!*********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/abnf.js ***!
  \*********************************************************/
/***/ (function(module) {

/*
Language: Augmented Backus-Naur Form
Author: Alex McKibben <alex@nullscope.net>
Website: https://tools.ietf.org/html/rfc5234
Audit: 2020
*/

/** @type LanguageFn */
function abnf(hljs) {
  const regex = hljs.regex;
  const IDENT = /^[a-zA-Z][a-zA-Z0-9-]*/;

  const KEYWORDS = [
    "ALPHA",
    "BIT",
    "CHAR",
    "CR",
    "CRLF",
    "CTL",
    "DIGIT",
    "DQUOTE",
    "HEXDIG",
    "HTAB",
    "LF",
    "LWSP",
    "OCTET",
    "SP",
    "VCHAR",
    "WSP"
  ];

  const COMMENT = hljs.COMMENT(/;/, /$/);

  const TERMINAL_BINARY = {
    scope: "symbol",
    match: /%b[0-1]+(-[0-1]+|(\.[0-1]+)+)?/
  };

  const TERMINAL_DECIMAL = {
    scope: "symbol",
    match: /%d[0-9]+(-[0-9]+|(\.[0-9]+)+)?/
  };

  const TERMINAL_HEXADECIMAL = {
    scope: "symbol",
    match: /%x[0-9A-F]+(-[0-9A-F]+|(\.[0-9A-F]+)+)?/
  };

  const CASE_SENSITIVITY = {
    scope: "symbol",
    match: /%[si](?=".*")/
  };

  const RULE_DECLARATION = {
    scope: "attribute",
    match: regex.concat(IDENT, /(?=\s*=)/)
  };

  const ASSIGNMENT = {
    scope: "operator",
    match: /=\/?/
  };

  return {
    name: 'Augmented Backus-Naur Form',
    illegal: /[!@#$^&',?+~`|:]/,
    keywords: KEYWORDS,
    contains: [
      ASSIGNMENT,
      RULE_DECLARATION,
      COMMENT,
      TERMINAL_BINARY,
      TERMINAL_DECIMAL,
      TERMINAL_HEXADECIMAL,
      CASE_SENSITIVITY,
      hljs.QUOTE_STRING_MODE,
      hljs.NUMBER_MODE
    ]
  };
}

module.exports = abnf;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/accesslog.js":
/*!**************************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/accesslog.js ***!
  \**************************************************************/
/***/ (function(module) {

/*
 Language: Apache Access Log
 Author: Oleg Efimov <efimovov@gmail.com>
 Description: Apache/Nginx Access Logs
 Website: https://httpd.apache.org/docs/2.4/logs.html#accesslog
 Category: web, logs
 Audit: 2020
 */

/** @type LanguageFn */
function accesslog(hljs) {
  const regex = hljs.regex;
  // https://developer.mozilla.org/en-US/docs/Web/HTTP/Methods
  const HTTP_VERBS = [
    "GET",
    "POST",
    "HEAD",
    "PUT",
    "DELETE",
    "CONNECT",
    "OPTIONS",
    "PATCH",
    "TRACE"
  ];
  return {
    name: 'Apache Access Log',
    contains: [
      // IP
      {
        className: 'number',
        begin: /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}(:\d{1,5})?\b/,
        relevance: 5
      },
      // Other numbers
      {
        className: 'number',
        begin: /\b\d+\b/,
        relevance: 0
      },
      // Requests
      {
        className: 'string',
        begin: regex.concat(/"/, regex.either(...HTTP_VERBS)),
        end: /"/,
        keywords: HTTP_VERBS,
        illegal: /\n/,
        relevance: 5,
        contains: [
          {
            begin: /HTTP\/[12]\.\d'/,
            relevance: 5
          }
        ]
      },
      // Dates
      {
        className: 'string',
        // dates must have a certain length, this prevents matching
        // simple array accesses a[123] and [] and other common patterns
        // found in other languages
        begin: /\[\d[^\]\n]{8,}\]/,
        illegal: /\n/,
        relevance: 1
      },
      {
        className: 'string',
        begin: /\[/,
        end: /\]/,
        illegal: /\n/,
        relevance: 0
      },
      // User agent / relevance boost
      {
        className: 'string',
        begin: /"Mozilla\/\d\.\d \(/,
        end: /"/,
        illegal: /\n/,
        relevance: 3
      },
      // Strings
      {
        className: 'string',
        begin: /"/,
        end: /"/,
        illegal: /\n/,
        relevance: 0
      }
    ]
  };
}

module.exports = accesslog;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/actionscript.js":
/*!*****************************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/actionscript.js ***!
  \*****************************************************************/
/***/ (function(module) {

/*
Language: ActionScript
Author: Alexander Myadzel <myadzel@gmail.com>
Category: scripting
Audit: 2020
*/

/** @type LanguageFn */
function actionscript(hljs) {
  const regex = hljs.regex;
  const IDENT_RE = /[a-zA-Z_$][a-zA-Z0-9_$]*/;
  const PKG_NAME_RE = regex.concat(
    IDENT_RE,
    regex.concat("(\\.", IDENT_RE, ")*")
  );
  const IDENT_FUNC_RETURN_TYPE_RE = /([*]|[a-zA-Z_$][a-zA-Z0-9_$]*)/;

  const AS3_REST_ARG_MODE = {
    className: 'rest_arg',
    begin: /[.]{3}/,
    end: IDENT_RE,
    relevance: 10
  };

  const KEYWORDS = [
    "as",
    "break",
    "case",
    "catch",
    "class",
    "const",
    "continue",
    "default",
    "delete",
    "do",
    "dynamic",
    "each",
    "else",
    "extends",
    "final",
    "finally",
    "for",
    "function",
    "get",
    "if",
    "implements",
    "import",
    "in",
    "include",
    "instanceof",
    "interface",
    "internal",
    "is",
    "namespace",
    "native",
    "new",
    "override",
    "package",
    "private",
    "protected",
    "public",
    "return",
    "set",
    "static",
    "super",
    "switch",
    "this",
    "throw",
    "try",
    "typeof",
    "use",
    "var",
    "void",
    "while",
    "with"
  ];
  const LITERALS = [
    "true",
    "false",
    "null",
    "undefined"
  ];

  return {
    name: 'ActionScript',
    aliases: [ 'as' ],
    keywords: {
      keyword: KEYWORDS,
      literal: LITERALS
    },
    contains: [
      hljs.APOS_STRING_MODE,
      hljs.QUOTE_STRING_MODE,
      hljs.C_LINE_COMMENT_MODE,
      hljs.C_BLOCK_COMMENT_MODE,
      hljs.C_NUMBER_MODE,
      {
        match: [
          /\bpackage/,
          /\s+/,
          PKG_NAME_RE
        ],
        className: {
          1: "keyword",
          3: "title.class"
        }
      },
      {
        match: [
          /\b(?:class|interface|extends|implements)/,
          /\s+/,
          IDENT_RE
        ],
        className: {
          1: "keyword",
          3: "title.class"
        }
      },
      {
        className: 'meta',
        beginKeywords: 'import include',
        end: /;/,
        keywords: { keyword: 'import include' }
      },
      {
        beginKeywords: 'function',
        end: /[{;]/,
        excludeEnd: true,
        illegal: /\S/,
        contains: [
          hljs.inherit(hljs.TITLE_MODE, { className: "title.function" }),
          {
            className: 'params',
            begin: /\(/,
            end: /\)/,
            contains: [
              hljs.APOS_STRING_MODE,
              hljs.QUOTE_STRING_MODE,
              hljs.C_LINE_COMMENT_MODE,
              hljs.C_BLOCK_COMMENT_MODE,
              AS3_REST_ARG_MODE
            ]
          },
          { begin: regex.concat(/:\s*/, IDENT_FUNC_RETURN_TYPE_RE) }
        ]
      },
      hljs.METHOD_GUARD
    ],
    illegal: /#/
  };
}

module.exports = actionscript;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/ada.js":
/*!********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/ada.js ***!
  \********************************************************/
/***/ (function(module) {

/*
Language: Ada
Author: Lars Schulna <kartoffelbrei.mit.muskatnuss@gmail.org>
Description: Ada is a general-purpose programming language that has great support for saftey critical and real-time applications.
             It has been developed by the DoD and thus has been used in military and safety-critical applications (like civil aviation).
             The first version appeared in the 80s, but it's still actively developed today with
             the newest standard being Ada2012.
*/

// We try to support full Ada2012
//
// We highlight all appearances of types, keywords, literals (string, char, number, bool)
// and titles (user defined function/procedure/package)
// CSS classes are set accordingly
//
// Languages causing problems for language detection:
// xml (broken by Foo : Bar type), elm (broken by Foo : Bar type), vbscript-html (broken by body keyword)
// sql (ada default.txt has a lot of sql keywords)

/** @type LanguageFn */
function ada(hljs) {
  // Regular expression for Ada numeric literals.
  // stolen form the VHDL highlighter

  // Decimal literal:
  const INTEGER_RE = '\\d(_|\\d)*';
  const EXPONENT_RE = '[eE][-+]?' + INTEGER_RE;
  const DECIMAL_LITERAL_RE = INTEGER_RE + '(\\.' + INTEGER_RE + ')?' + '(' + EXPONENT_RE + ')?';

  // Based literal:
  const BASED_INTEGER_RE = '\\w+';
  const BASED_LITERAL_RE = INTEGER_RE + '#' + BASED_INTEGER_RE + '(\\.' + BASED_INTEGER_RE + ')?' + '#' + '(' + EXPONENT_RE + ')?';

  const NUMBER_RE = '\\b(' + BASED_LITERAL_RE + '|' + DECIMAL_LITERAL_RE + ')';

  // Identifier regex
  const ID_REGEX = '[A-Za-z](_?[A-Za-z0-9.])*';

  // bad chars, only allowed in literals
  const BAD_CHARS = `[]\\{\\}%#'"`;

  // Ada doesn't have block comments, only line comments
  const COMMENTS = hljs.COMMENT('--', '$');

  // variable declarations of the form
  // Foo : Bar := Baz;
  // where only Bar will be highlighted
  const VAR_DECLS = {
    // TODO: These spaces are not required by the Ada syntax
    // however, I have yet to see handwritten Ada code where
    // someone does not put spaces around :
    begin: '\\s+:\\s+',
    end: '\\s*(:=|;|\\)|=>|$)',
    // endsWithParent: true,
    // returnBegin: true,
    illegal: BAD_CHARS,
    contains: [
      {
        // workaround to avoid highlighting
        // named loops and declare blocks
        beginKeywords: 'loop for declare others',
        endsParent: true
      },
      {
        // properly highlight all modifiers
        className: 'keyword',
        beginKeywords: 'not null constant access function procedure in out aliased exception'
      },
      {
        className: 'type',
        begin: ID_REGEX,
        endsParent: true,
        relevance: 0
      }
    ]
  };

  const KEYWORDS = [
    "abort",
    "else",
    "new",
    "return",
    "abs",
    "elsif",
    "not",
    "reverse",
    "abstract",
    "end",
    "accept",
    "entry",
    "select",
    "access",
    "exception",
    "of",
    "separate",
    "aliased",
    "exit",
    "or",
    "some",
    "all",
    "others",
    "subtype",
    "and",
    "for",
    "out",
    "synchronized",
    "array",
    "function",
    "overriding",
    "at",
    "tagged",
    "generic",
    "package",
    "task",
    "begin",
    "goto",
    "pragma",
    "terminate",
    "body",
    "private",
    "then",
    "if",
    "procedure",
    "type",
    "case",
    "in",
    "protected",
    "constant",
    "interface",
    "is",
    "raise",
    "use",
    "declare",
    "range",
    "delay",
    "limited",
    "record",
    "when",
    "delta",
    "loop",
    "rem",
    "while",
    "digits",
    "renames",
    "with",
    "do",
    "mod",
    "requeue",
    "xor"
  ];

  return {
    name: 'Ada',
    case_insensitive: true,
    keywords: {
      keyword: KEYWORDS,
      literal: [
        "True",
        "False"
      ]
    },
    contains: [
      COMMENTS,
      // strings "foobar"
      {
        className: 'string',
        begin: /"/,
        end: /"/,
        contains: [
          {
            begin: /""/,
            relevance: 0
          }
        ]
      },
      // characters ''
      {
        // character literals always contain one char
        className: 'string',
        begin: /'.'/
      },
      {
        // number literals
        className: 'number',
        begin: NUMBER_RE,
        relevance: 0
      },
      {
        // Attributes
        className: 'symbol',
        begin: "'" + ID_REGEX
      },
      {
        // package definition, maybe inside generic
        className: 'title',
        begin: '(\\bwith\\s+)?(\\bprivate\\s+)?\\bpackage\\s+(\\bbody\\s+)?',
        end: '(is|$)',
        keywords: 'package body',
        excludeBegin: true,
        excludeEnd: true,
        illegal: BAD_CHARS
      },
      {
        // function/procedure declaration/definition
        // maybe inside generic
        begin: '(\\b(with|overriding)\\s+)?\\b(function|procedure)\\s+',
        end: '(\\bis|\\bwith|\\brenames|\\)\\s*;)',
        keywords: 'overriding function procedure with is renames return',
        // we need to re-match the 'function' keyword, so that
        // the title mode below matches only exactly once
        returnBegin: true,
        contains:
                [
                  COMMENTS,
                  {
                    // name of the function/procedure
                    className: 'title',
                    begin: '(\\bwith\\s+)?\\b(function|procedure)\\s+',
                    end: '(\\(|\\s+|$)',
                    excludeBegin: true,
                    excludeEnd: true,
                    illegal: BAD_CHARS
                  },
                  // 'self'
                  // // parameter types
                  VAR_DECLS,
                  {
                    // return type
                    className: 'type',
                    begin: '\\breturn\\s+',
                    end: '(\\s+|;|$)',
                    keywords: 'return',
                    excludeBegin: true,
                    excludeEnd: true,
                    // we are done with functions
                    endsParent: true,
                    illegal: BAD_CHARS

                  }
                ]
      },
      {
        // new type declarations
        // maybe inside generic
        className: 'type',
        begin: '\\b(sub)?type\\s+',
        end: '\\s+',
        keywords: 'type',
        excludeBegin: true,
        illegal: BAD_CHARS
      },

      // see comment above the definition
      VAR_DECLS

      // no markup
      // relevance boosters for small snippets
      // {begin: '\\s*=>\\s*'},
      // {begin: '\\s*:=\\s*'},
      // {begin: '\\s+:=\\s+'},
    ]
  };
}

module.exports = ada;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/angelscript.js":
/*!****************************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/angelscript.js ***!
  \****************************************************************/
/***/ (function(module) {

/*
Language: AngelScript
Author: Melissa Geels <melissa@nimble.tools>
Category: scripting
Website: https://www.angelcode.com/angelscript/
*/

/** @type LanguageFn */
function angelscript(hljs) {
  const builtInTypeMode = {
    className: 'built_in',
    begin: '\\b(void|bool|int8|int16|int32|int64|int|uint8|uint16|uint32|uint64|uint|string|ref|array|double|float|auto|dictionary)'
  };

  const objectHandleMode = {
    className: 'symbol',
    begin: '[a-zA-Z0-9_]+@'
  };

  const genericMode = {
    className: 'keyword',
    begin: '<',
    end: '>',
    contains: [
      builtInTypeMode,
      objectHandleMode
    ]
  };

  builtInTypeMode.contains = [ genericMode ];
  objectHandleMode.contains = [ genericMode ];

  const KEYWORDS = [
    "for",
    "in|0",
    "break",
    "continue",
    "while",
    "do|0",
    "return",
    "if",
    "else",
    "case",
    "switch",
    "namespace",
    "is",
    "cast",
    "or",
    "and",
    "xor",
    "not",
    "get|0",
    "in",
    "inout|10",
    "out",
    "override",
    "set|0",
    "private",
    "public",
    "const",
    "default|0",
    "final",
    "shared",
    "external",
    "mixin|10",
    "enum",
    "typedef",
    "funcdef",
    "this",
    "super",
    "import",
    "from",
    "interface",
    "abstract|0",
    "try",
    "catch",
    "protected",
    "explicit",
    "property"
  ];

  return {
    name: 'AngelScript',
    aliases: [ 'asc' ],

    keywords: KEYWORDS,

    // avoid close detection with C# and JS
    illegal: '(^using\\s+[A-Za-z0-9_\\.]+;$|\\bfunction\\s*[^\\(])',

    contains: [
      { // 'strings'
        className: 'string',
        begin: '\'',
        end: '\'',
        illegal: '\\n',
        contains: [ hljs.BACKSLASH_ESCAPE ],
        relevance: 0
      },

      // """heredoc strings"""
      {
        className: 'string',
        begin: '"""',
        end: '"""'
      },

      { // "strings"
        className: 'string',
        begin: '"',
        end: '"',
        illegal: '\\n',
        contains: [ hljs.BACKSLASH_ESCAPE ],
        relevance: 0
      },

      hljs.C_LINE_COMMENT_MODE, // single-line comments
      hljs.C_BLOCK_COMMENT_MODE, // comment blocks

      { // metadata
        className: 'string',
        begin: '^\\s*\\[',
        end: '\\]'
      },

      { // interface or namespace declaration
        beginKeywords: 'interface namespace',
        end: /\{/,
        illegal: '[;.\\-]',
        contains: [
          { // interface or namespace name
            className: 'symbol',
            begin: '[a-zA-Z0-9_]+'
          }
        ]
      },

      { // class declaration
        beginKeywords: 'class',
        end: /\{/,
        illegal: '[;.\\-]',
        contains: [
          { // class name
            className: 'symbol',
            begin: '[a-zA-Z0-9_]+',
            contains: [
              {
                begin: '[:,]\\s*',
                contains: [
                  {
                    className: 'symbol',
                    begin: '[a-zA-Z0-9_]+'
                  }
                ]
              }
            ]
          }
        ]
      },

      builtInTypeMode, // built-in types
      objectHandleMode, // object handles

      { // literals
        className: 'literal',
        begin: '\\b(null|true|false)'
      },

      { // numbers
        className: 'number',
        relevance: 0,
        begin: '(-?)(\\b0[xXbBoOdD][a-fA-F0-9]+|(\\b\\d+(\\.\\d*)?f?|\\.\\d+f?)([eE][-+]?\\d+f?)?)'
      }
    ]
  };
}

module.exports = angelscript;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/apache.js":
/*!***********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/apache.js ***!
  \***********************************************************/
/***/ (function(module) {

/*
Language: Apache config
Author: Ruslan Keba <rukeba@gmail.com>
Contributors: Ivan Sagalaev <maniac@softwaremaniacs.org>
Website: https://httpd.apache.org
Description: language definition for Apache configuration files (httpd.conf & .htaccess)
Category: config, web
Audit: 2020
*/

/** @type LanguageFn */
function apache(hljs) {
  const NUMBER_REF = {
    className: 'number',
    begin: /[$%]\d+/
  };
  const NUMBER = {
    className: 'number',
    begin: /\b\d+/
  };
  const IP_ADDRESS = {
    className: "number",
    begin: /\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}(:\d{1,5})?/
  };
  const PORT_NUMBER = {
    className: "number",
    begin: /:\d{1,5}/
  };
  return {
    name: 'Apache config',
    aliases: [ 'apacheconf' ],
    case_insensitive: true,
    contains: [
      hljs.HASH_COMMENT_MODE,
      {
        className: 'section',
        begin: /<\/?/,
        end: />/,
        contains: [
          IP_ADDRESS,
          PORT_NUMBER,
          // low relevance prevents us from claming XML/HTML where this rule would
          // match strings inside of XML tags
          hljs.inherit(hljs.QUOTE_STRING_MODE, { relevance: 0 })
        ]
      },
      {
        className: 'attribute',
        begin: /\w+/,
        relevance: 0,
        // keywords aren’t needed for highlighting per se, they only boost relevance
        // for a very generally defined mode (starts with a word, ends with line-end
        keywords: { _: [
          "order",
          "deny",
          "allow",
          "setenv",
          "rewriterule",
          "rewriteengine",
          "rewritecond",
          "documentroot",
          "sethandler",
          "errordocument",
          "loadmodule",
          "options",
          "header",
          "listen",
          "serverroot",
          "servername"
        ] },
        starts: {
          end: /$/,
          relevance: 0,
          keywords: { literal: 'on off all deny allow' },
          contains: [
            {
              className: 'meta',
              begin: /\s\[/,
              end: /\]$/
            },
            {
              className: 'variable',
              begin: /[\$%]\{/,
              end: /\}/,
              contains: [
                'self',
                NUMBER_REF
              ]
            },
            IP_ADDRESS,
            NUMBER,
            hljs.QUOTE_STRING_MODE
          ]
        }
      }
    ],
    illegal: /\S/
  };
}

module.exports = apache;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/applescript.js":
/*!****************************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/applescript.js ***!
  \****************************************************************/
/***/ (function(module) {

/*
Language: AppleScript
Authors: Nathan Grigg <nathan@nathanamy.org>, Dr. Drang <drdrang@gmail.com>
Category: scripting
Website: https://developer.apple.com/library/archive/documentation/AppleScript/Conceptual/AppleScriptLangGuide/introduction/ASLR_intro.html
Audit: 2020
*/

/** @type LanguageFn */
function applescript(hljs) {
  const regex = hljs.regex;
  const STRING = hljs.inherit(
    hljs.QUOTE_STRING_MODE, { illegal: null });
  const PARAMS = {
    className: 'params',
    begin: /\(/,
    end: /\)/,
    contains: [
      'self',
      hljs.C_NUMBER_MODE,
      STRING
    ]
  };
  const COMMENT_MODE_1 = hljs.COMMENT(/--/, /$/);
  const COMMENT_MODE_2 = hljs.COMMENT(
    /\(\*/,
    /\*\)/,
    { contains: [
      'self', // allow nesting
      COMMENT_MODE_1
    ] }
  );
  const COMMENTS = [
    COMMENT_MODE_1,
    COMMENT_MODE_2,
    hljs.HASH_COMMENT_MODE
  ];

  const KEYWORD_PATTERNS = [
    /apart from/,
    /aside from/,
    /instead of/,
    /out of/,
    /greater than/,
    /isn't|(doesn't|does not) (equal|come before|come after|contain)/,
    /(greater|less) than( or equal)?/,
    /(starts?|ends|begins?) with/,
    /contained by/,
    /comes (before|after)/,
    /a (ref|reference)/,
    /POSIX (file|path)/,
    /(date|time) string/,
    /quoted form/
  ];

  const BUILT_IN_PATTERNS = [
    /clipboard info/,
    /the clipboard/,
    /info for/,
    /list (disks|folder)/,
    /mount volume/,
    /path to/,
    /(close|open for) access/,
    /(get|set) eof/,
    /current date/,
    /do shell script/,
    /get volume settings/,
    /random number/,
    /set volume/,
    /system attribute/,
    /system info/,
    /time to GMT/,
    /(load|run|store) script/,
    /scripting components/,
    /ASCII (character|number)/,
    /localized string/,
    /choose (application|color|file|file name|folder|from list|remote application|URL)/,
    /display (alert|dialog)/
  ];

  return {
    name: 'AppleScript',
    aliases: [ 'osascript' ],
    keywords: {
      keyword:
        'about above after against and around as at back before beginning '
        + 'behind below beneath beside between but by considering '
        + 'contain contains continue copy div does eighth else end equal '
        + 'equals error every exit fifth first for fourth from front '
        + 'get given global if ignoring in into is it its last local me '
        + 'middle mod my ninth not of on onto or over prop property put ref '
        + 'reference repeat returning script second set seventh since '
        + 'sixth some tell tenth that the|0 then third through thru '
        + 'timeout times to transaction try until where while whose with '
        + 'without',
      literal:
        'AppleScript false linefeed return pi quote result space tab true',
      built_in:
        'alias application boolean class constant date file integer list '
        + 'number real record string text '
        + 'activate beep count delay launch log offset read round '
        + 'run say summarize write '
        + 'character characters contents day frontmost id item length '
        + 'month name|0 paragraph paragraphs rest reverse running time version '
        + 'weekday word words year'
    },
    contains: [
      STRING,
      hljs.C_NUMBER_MODE,
      {
        className: 'built_in',
        begin: regex.concat(
          /\b/,
          regex.either(...BUILT_IN_PATTERNS),
          /\b/
        )
      },
      {
        className: 'built_in',
        begin: /^\s*return\b/
      },
      {
        className: 'literal',
        begin:
          /\b(text item delimiters|current application|missing value)\b/
      },
      {
        className: 'keyword',
        begin: regex.concat(
          /\b/,
          regex.either(...KEYWORD_PATTERNS),
          /\b/
        )
      },
      {
        beginKeywords: 'on',
        illegal: /[${=;\n]/,
        contains: [
          hljs.UNDERSCORE_TITLE_MODE,
          PARAMS
        ]
      },
      ...COMMENTS
    ],
    illegal: /\/\/|->|=>|\[\[/
  };
}

module.exports = applescript;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/arcade.js":
/*!***********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/arcade.js ***!
  \***********************************************************/
/***/ (function(module) {

/*
 Language: ArcGIS Arcade
 Category: scripting
 Author: John Foster <jfoster@esri.com>
 Website: https://developers.arcgis.com/arcade/
 Description: ArcGIS Arcade is an expression language used in many Esri ArcGIS products such as Pro, Online, Server, Runtime, JavaScript, and Python
*/

/** @type LanguageFn */
function arcade(hljs) {
  const IDENT_RE = '[A-Za-z_][0-9A-Za-z_]*';
  const KEYWORDS = {
    keyword: [
      "if",
      "for",
      "while",
      "var",
      "new",
      "function",
      "do",
      "return",
      "void",
      "else",
      "break"
    ],
    literal: [
      "BackSlash",
      "DoubleQuote",
      "false",
      "ForwardSlash",
      "Infinity",
      "NaN",
      "NewLine",
      "null",
      "PI",
      "SingleQuote",
      "Tab",
      "TextFormatting",
      "true",
      "undefined"
    ],
    built_in: [
      "Abs",
      "Acos",
      "All",
      "Angle",
      "Any",
      "Area",
      "AreaGeodetic",
      "Array",
      "Asin",
      "Atan",
      "Atan2",
      "Attachments",
      "Average",
      "Back",
      "Bearing",
      "Boolean",
      "Buffer",
      "BufferGeodetic",
      "Ceil",
      "Centroid",
      "Clip",
      "Concatenate",
      "Console",
      "Constrain",
      "Contains",
      "ConvertDirection",
      "Cos",
      "Count",
      "Crosses",
      "Cut",
      "Date",
      "DateAdd",
      "DateDiff",
      "Day",
      "Decode",
      "DefaultValue",
      "Densify",
      "DensifyGeodetic",
      "Dictionary",
      "Difference",
      "Disjoint",
      "Distance",
      "DistanceGeodetic",
      "Distinct",
      "Domain",
      "DomainCode",
      "DomainName",
      "EnvelopeIntersects",
      "Equals",
      "Erase",
      "Exp",
      "Expects",
      "Extent",
      "Feature",
      "FeatureSet",
      "FeatureSetByAssociation",
      "FeatureSetById",
      "FeatureSetByName",
      "FeatureSetByPortalItem",
      "FeatureSetByRelationshipName",
      "Filter",
      "Find",
      "First",
      "Floor",
      "FromCharCode",
      "FromCodePoint",
      "FromJSON",
      "GdbVersion",
      "Generalize",
      "Geometry",
      "GetFeatureSet",
      "GetUser",
      "GroupBy",
      "Guid",
      "Hash",
      "HasKey",
      "Hour",
      "IIf",
      "Includes",
      "IndexOf",
      "Insert",
      "Intersection",
      "Intersects",
      "IsEmpty",
      "IsNan",
      "ISOMonth",
      "ISOWeek",
      "ISOWeekday",
      "ISOYear",
      "IsSelfIntersecting",
      "IsSimple",
      "Left|0",
      "Length",
      "Length3D",
      "LengthGeodetic",
      "Log",
      "Lower",
      "Map",
      "Max",
      "Mean",
      "Mid",
      "Millisecond",
      "Min",
      "Minute",
      "Month",
      "MultiPartToSinglePart",
      "Multipoint",
      "NextSequenceValue",
      "None",
      "Now",
      "Number",
      "Offset|0",
      "OrderBy",
      "Overlaps",
      "Point",
      "Polygon",
      "Polyline",
      "Pop",
      "Portal",
      "Pow",
      "Proper",
      "Push",
      "Random",
      "Reduce",
      "Relate",
      "Replace",
      "Resize",
      "Reverse",
      "Right|0",
      "RingIsClockwise",
      "Rotate",
      "Round",
      "Schema",
      "Second",
      "SetGeometry",
      "Simplify",
      "Sin",
      "Slice",
      "Sort",
      "Splice",
      "Split",
      "Sqrt",
      "Stdev",
      "SubtypeCode",
      "SubtypeName",
      "Subtypes",
      "Sum",
      "SymmetricDifference",
      "Tan",
      "Text",
      "Timestamp",
      "ToCharCode",
      "ToCodePoint",
      "Today",
      "ToHex",
      "ToLocal",
      "Top|0",
      "Touches",
      "ToUTC",
      "TrackAccelerationAt",
      "TrackAccelerationWindow",
      "TrackCurrentAcceleration",
      "TrackCurrentDistance",
      "TrackCurrentSpeed",
      "TrackCurrentTime",
      "TrackDistanceAt",
      "TrackDistanceWindow",
      "TrackDuration",
      "TrackFieldWindow",
      "TrackGeometryWindow",
      "TrackIndex",
      "TrackSpeedAt",
      "TrackSpeedWindow",
      "TrackStartTime",
      "TrackWindow",
      "Trim",
      "TypeOf",
      "Union",
      "Upper",
      "UrlEncode",
      "Variance",
      "Week",
      "Weekday",
      "When",
      "Within",
      "Year"
    ]
  };
  const SYMBOL = {
    className: 'symbol',
    begin: '\\$[datastore|feature|layer|map|measure|sourcefeature|sourcelayer|targetfeature|targetlayer|value|view]+'
  };
  const NUMBER = {
    className: 'number',
    variants: [
      { begin: '\\b(0[bB][01]+)' },
      { begin: '\\b(0[oO][0-7]+)' },
      { begin: hljs.C_NUMBER_RE }
    ],
    relevance: 0
  };
  const SUBST = {
    className: 'subst',
    begin: '\\$\\{',
    end: '\\}',
    keywords: KEYWORDS,
    contains: [] // defined later
  };
  const TEMPLATE_STRING = {
    className: 'string',
    begin: '`',
    end: '`',
    contains: [
      hljs.BACKSLASH_ESCAPE,
      SUBST
    ]
  };
  SUBST.contains = [
    hljs.APOS_STRING_MODE,
    hljs.QUOTE_STRING_MODE,
    TEMPLATE_STRING,
    NUMBER,
    hljs.REGEXP_MODE
  ];
  const PARAMS_CONTAINS = SUBST.contains.concat([
    hljs.C_BLOCK_COMMENT_MODE,
    hljs.C_LINE_COMMENT_MODE
  ]);

  return {
    name: 'ArcGIS Arcade',
    case_insensitive: true,
    keywords: KEYWORDS,
    contains: [
      hljs.APOS_STRING_MODE,
      hljs.QUOTE_STRING_MODE,
      TEMPLATE_STRING,
      hljs.C_LINE_COMMENT_MODE,
      hljs.C_BLOCK_COMMENT_MODE,
      SYMBOL,
      NUMBER,
      { // object attr container
        begin: /[{,]\s*/,
        relevance: 0,
        contains: [
          {
            begin: IDENT_RE + '\\s*:',
            returnBegin: true,
            relevance: 0,
            contains: [
              {
                className: 'attr',
                begin: IDENT_RE,
                relevance: 0
              }
            ]
          }
        ]
      },
      { // "value" container
        begin: '(' + hljs.RE_STARTERS_RE + '|\\b(return)\\b)\\s*',
        keywords: 'return',
        contains: [
          hljs.C_LINE_COMMENT_MODE,
          hljs.C_BLOCK_COMMENT_MODE,
          hljs.REGEXP_MODE,
          {
            className: 'function',
            begin: '(\\(.*?\\)|' + IDENT_RE + ')\\s*=>',
            returnBegin: true,
            end: '\\s*=>',
            contains: [
              {
                className: 'params',
                variants: [
                  { begin: IDENT_RE },
                  { begin: /\(\s*\)/ },
                  {
                    begin: /\(/,
                    end: /\)/,
                    excludeBegin: true,
                    excludeEnd: true,
                    keywords: KEYWORDS,
                    contains: PARAMS_CONTAINS
                  }
                ]
              }
            ]
          }
        ],
        relevance: 0
      },
      {
        beginKeywords: 'function',
        end: /\{/,
        excludeEnd: true,
        contains: [
          hljs.inherit(hljs.TITLE_MODE, {
            className: "title.function",
            begin: IDENT_RE
          }),
          {
            className: 'params',
            begin: /\(/,
            end: /\)/,
            excludeBegin: true,
            excludeEnd: true,
            contains: PARAMS_CONTAINS
          }
        ],
        illegal: /\[|%/
      },
      { begin: /\$[(.]/ }
    ],
    illegal: /#(?!!)/
  };
}

module.exports = arcade;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/arduino.js":
/*!************************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/arduino.js ***!
  \************************************************************/
/***/ (function(module) {

/*
Language: C++
Category: common, system
Website: https://isocpp.org
*/

/** @type LanguageFn */
function cPlusPlus(hljs) {
  const regex = hljs.regex;
  // added for historic reasons because `hljs.C_LINE_COMMENT_MODE` does
  // not include such support nor can we be sure all the grammars depending
  // on it would desire this behavior
  const C_LINE_COMMENT_MODE = hljs.COMMENT('//', '$', { contains: [ { begin: /\\\n/ } ] });
  const DECLTYPE_AUTO_RE = 'decltype\\(auto\\)';
  const NAMESPACE_RE = '[a-zA-Z_]\\w*::';
  const TEMPLATE_ARGUMENT_RE = '<[^<>]+>';
  const FUNCTION_TYPE_RE = '(?!struct)('
    + DECLTYPE_AUTO_RE + '|'
    + regex.optional(NAMESPACE_RE)
    + '[a-zA-Z_]\\w*' + regex.optional(TEMPLATE_ARGUMENT_RE)
  + ')';

  const CPP_PRIMITIVE_TYPES = {
    className: 'type',
    begin: '\\b[a-z\\d_]*_t\\b'
  };

  // https://en.cppreference.com/w/cpp/language/escape
  // \\ \x \xFF \u2837 \u00323747 \374
  const CHARACTER_ESCAPES = '\\\\(x[0-9A-Fa-f]{2}|u[0-9A-Fa-f]{4,8}|[0-7]{3}|\\S)';
  const STRINGS = {
    className: 'string',
    variants: [
      {
        begin: '(u8?|U|L)?"',
        end: '"',
        illegal: '\\n',
        contains: [ hljs.BACKSLASH_ESCAPE ]
      },
      {
        begin: '(u8?|U|L)?\'(' + CHARACTER_ESCAPES + '|.)',
        end: '\'',
        illegal: '.'
      },
      hljs.END_SAME_AS_BEGIN({
        begin: /(?:u8?|U|L)?R"([^()\\ ]{0,16})\(/,
        end: /\)([^()\\ ]{0,16})"/
      })
    ]
  };

  const NUMBERS = {
    className: 'number',
    variants: [
      { begin: '\\b(0b[01\']+)' },
      { begin: '(-?)\\b([\\d\']+(\\.[\\d\']*)?|\\.[\\d\']+)((ll|LL|l|L)(u|U)?|(u|U)(ll|LL|l|L)?|f|F|b|B)' },
      { begin: '(-?)(\\b0[xX][a-fA-F0-9\']+|(\\b[\\d\']+(\\.[\\d\']*)?|\\.[\\d\']+)([eE][-+]?[\\d\']+)?)' }
    ],
    relevance: 0
  };

  const PREPROCESSOR = {
    className: 'meta',
    begin: /#\s*[a-z]+\b/,
    end: /$/,
    keywords: { keyword:
        'if else elif endif define undef warning error line '
        + 'pragma _Pragma ifdef ifndef include' },
    contains: [
      {
        begin: /\\\n/,
        relevance: 0
      },
      hljs.inherit(STRINGS, { className: 'string' }),
      {
        className: 'string',
        begin: /<.*?>/
      },
      C_LINE_COMMENT_MODE,
      hljs.C_BLOCK_COMMENT_MODE
    ]
  };

  const TITLE_MODE = {
    className: 'title',
    begin: regex.optional(NAMESPACE_RE) + hljs.IDENT_RE,
    relevance: 0
  };

  const FUNCTION_TITLE = regex.optional(NAMESPACE_RE) + hljs.IDENT_RE + '\\s*\\(';

  // https://en.cppreference.com/w/cpp/keyword
  const RESERVED_KEYWORDS = [
    'alignas',
    'alignof',
    'and',
    'and_eq',
    'asm',
    'atomic_cancel',
    'atomic_commit',
    'atomic_noexcept',
    'auto',
    'bitand',
    'bitor',
    'break',
    'case',
    'catch',
    'class',
    'co_await',
    'co_return',
    'co_yield',
    'compl',
    'concept',
    'const_cast|10',
    'consteval',
    'constexpr',
    'constinit',
    'continue',
    'decltype',
    'default',
    'delete',
    'do',
    'dynamic_cast|10',
    'else',
    'enum',
    'explicit',
    'export',
    'extern',
    'false',
    'final',
    'for',
    'friend',
    'goto',
    'if',
    'import',
    'inline',
    'module',
    'mutable',
    'namespace',
    'new',
    'noexcept',
    'not',
    'not_eq',
    'nullptr',
    'operator',
    'or',
    'or_eq',
    'override',
    'private',
    'protected',
    'public',
    'reflexpr',
    'register',
    'reinterpret_cast|10',
    'requires',
    'return',
    'sizeof',
    'static_assert',
    'static_cast|10',
    'struct',
    'switch',
    'synchronized',
    'template',
    'this',
    'thread_local',
    'throw',
    'transaction_safe',
    'transaction_safe_dynamic',
    'true',
    'try',
    'typedef',
    'typeid',
    'typename',
    'union',
    'using',
    'virtual',
    'volatile',
    'while',
    'xor',
    'xor_eq'
  ];

  // https://en.cppreference.com/w/cpp/keyword
  const RESERVED_TYPES = [
    'bool',
    'char',
    'char16_t',
    'char32_t',
    'char8_t',
    'double',
    'float',
    'int',
    'long',
    'short',
    'void',
    'wchar_t',
    'unsigned',
    'signed',
    'const',
    'static'
  ];

  const TYPE_HINTS = [
    'any',
    'auto_ptr',
    'barrier',
    'binary_semaphore',
    'bitset',
    'complex',
    'condition_variable',
    'condition_variable_any',
    'counting_semaphore',
    'deque',
    'false_type',
    'future',
    'imaginary',
    'initializer_list',
    'istringstream',
    'jthread',
    'latch',
    'lock_guard',
    'multimap',
    'multiset',
    'mutex',
    'optional',
    'ostringstream',
    'packaged_task',
    'pair',
    'promise',
    'priority_queue',
    'queue',
    'recursive_mutex',
    'recursive_timed_mutex',
    'scoped_lock',
    'set',
    'shared_future',
    'shared_lock',
    'shared_mutex',
    'shared_timed_mutex',
    'shared_ptr',
    'stack',
    'string_view',
    'stringstream',
    'timed_mutex',
    'thread',
    'true_type',
    'tuple',
    'unique_lock',
    'unique_ptr',
    'unordered_map',
    'unordered_multimap',
    'unordered_multiset',
    'unordered_set',
    'variant',
    'vector',
    'weak_ptr',
    'wstring',
    'wstring_view'
  ];

  const FUNCTION_HINTS = [
    'abort',
    'abs',
    'acos',
    'apply',
    'as_const',
    'asin',
    'atan',
    'atan2',
    'calloc',
    'ceil',
    'cerr',
    'cin',
    'clog',
    'cos',
    'cosh',
    'cout',
    'declval',
    'endl',
    'exchange',
    'exit',
    'exp',
    'fabs',
    'floor',
    'fmod',
    'forward',
    'fprintf',
    'fputs',
    'free',
    'frexp',
    'fscanf',
    'future',
    'invoke',
    'isalnum',
    'isalpha',
    'iscntrl',
    'isdigit',
    'isgraph',
    'islower',
    'isprint',
    'ispunct',
    'isspace',
    'isupper',
    'isxdigit',
    'labs',
    'launder',
    'ldexp',
    'log',
    'log10',
    'make_pair',
    'make_shared',
    'make_shared_for_overwrite',
    'make_tuple',
    'make_unique',
    'malloc',
    'memchr',
    'memcmp',
    'memcpy',
    'memset',
    'modf',
    'move',
    'pow',
    'printf',
    'putchar',
    'puts',
    'realloc',
    'scanf',
    'sin',
    'sinh',
    'snprintf',
    'sprintf',
    'sqrt',
    'sscanf',
    'std',
    'stderr',
    'stdin',
    'stdout',
    'strcat',
    'strchr',
    'strcmp',
    'strcpy',
    'strcspn',
    'strlen',
    'strncat',
    'strncmp',
    'strncpy',
    'strpbrk',
    'strrchr',
    'strspn',
    'strstr',
    'swap',
    'tan',
    'tanh',
    'terminate',
    'to_underlying',
    'tolower',
    'toupper',
    'vfprintf',
    'visit',
    'vprintf',
    'vsprintf'
  ];

  const LITERALS = [
    'NULL',
    'false',
    'nullopt',
    'nullptr',
    'true'
  ];

  // https://en.cppreference.com/w/cpp/keyword
  const BUILT_IN = [ '_Pragma' ];

  const CPP_KEYWORDS = {
    type: RESERVED_TYPES,
    keyword: RESERVED_KEYWORDS,
    literal: LITERALS,
    built_in: BUILT_IN,
    _type_hints: TYPE_HINTS
  };

  const FUNCTION_DISPATCH = {
    className: 'function.dispatch',
    relevance: 0,
    keywords: {
      // Only for relevance, not highlighting.
      _hint: FUNCTION_HINTS },
    begin: regex.concat(
      /\b/,
      /(?!decltype)/,
      /(?!if)/,
      /(?!for)/,
      /(?!switch)/,
      /(?!while)/,
      hljs.IDENT_RE,
      regex.lookahead(/(<[^<>]+>|)\s*\(/))
  };

  const EXPRESSION_CONTAINS = [
    FUNCTION_DISPATCH,
    PREPROCESSOR,
    CPP_PRIMITIVE_TYPES,
    C_LINE_COMMENT_MODE,
    hljs.C_BLOCK_COMMENT_MODE,
    NUMBERS,
    STRINGS
  ];

  const EXPRESSION_CONTEXT = {
    // This mode covers expression context where we can't expect a function
    // definition and shouldn't highlight anything that looks like one:
    // `return some()`, `else if()`, `(x*sum(1, 2))`
    variants: [
      {
        begin: /=/,
        end: /;/
      },
      {
        begin: /\(/,
        end: /\)/
      },
      {
        beginKeywords: 'new throw return else',
        end: /;/
      }
    ],
    keywords: CPP_KEYWORDS,
    contains: EXPRESSION_CONTAINS.concat([
      {
        begin: /\(/,
        end: /\)/,
        keywords: CPP_KEYWORDS,
        contains: EXPRESSION_CONTAINS.concat([ 'self' ]),
        relevance: 0
      }
    ]),
    relevance: 0
  };

  const FUNCTION_DECLARATION = {
    className: 'function',
    begin: '(' + FUNCTION_TYPE_RE + '[\\*&\\s]+)+' + FUNCTION_TITLE,
    returnBegin: true,
    end: /[{;=]/,
    excludeEnd: true,
    keywords: CPP_KEYWORDS,
    illegal: /[^\w\s\*&:<>.]/,
    contains: [
      { // to prevent it from being confused as the function title
        begin: DECLTYPE_AUTO_RE,
        keywords: CPP_KEYWORDS,
        relevance: 0
      },
      {
        begin: FUNCTION_TITLE,
        returnBegin: true,
        contains: [ TITLE_MODE ],
        relevance: 0
      },
      // needed because we do not have look-behind on the below rule
      // to prevent it from grabbing the final : in a :: pair
      {
        begin: /::/,
        relevance: 0
      },
      // initializers
      {
        begin: /:/,
        endsWithParent: true,
        contains: [
          STRINGS,
          NUMBERS
        ]
      },
      // allow for multiple declarations, e.g.:
      // extern void f(int), g(char);
      {
        relevance: 0,
        match: /,/
      },
      {
        className: 'params',
        begin: /\(/,
        end: /\)/,
        keywords: CPP_KEYWORDS,
        relevance: 0,
        contains: [
          C_LINE_COMMENT_MODE,
          hljs.C_BLOCK_COMMENT_MODE,
          STRINGS,
          NUMBERS,
          CPP_PRIMITIVE_TYPES,
          // Count matching parentheses.
          {
            begin: /\(/,
            end: /\)/,
            keywords: CPP_KEYWORDS,
            relevance: 0,
            contains: [
              'self',
              C_LINE_COMMENT_MODE,
              hljs.C_BLOCK_COMMENT_MODE,
              STRINGS,
              NUMBERS,
              CPP_PRIMITIVE_TYPES
            ]
          }
        ]
      },
      CPP_PRIMITIVE_TYPES,
      C_LINE_COMMENT_MODE,
      hljs.C_BLOCK_COMMENT_MODE,
      PREPROCESSOR
    ]
  };

  return {
    name: 'C++',
    aliases: [
      'cc',
      'c++',
      'h++',
      'hpp',
      'hh',
      'hxx',
      'cxx'
    ],
    keywords: CPP_KEYWORDS,
    illegal: '</',
    classNameAliases: { 'function.dispatch': 'built_in' },
    contains: [].concat(
      EXPRESSION_CONTEXT,
      FUNCTION_DECLARATION,
      FUNCTION_DISPATCH,
      EXPRESSION_CONTAINS,
      [
        PREPROCESSOR,
        { // containers: ie, `vector <int> rooms (9);`
          begin: '\\b(deque|list|queue|priority_queue|pair|stack|vector|map|set|bitset|multiset|multimap|unordered_map|unordered_set|unordered_multiset|unordered_multimap|array|tuple|optional|variant|function)\\s*<(?!<)',
          end: '>',
          keywords: CPP_KEYWORDS,
          contains: [
            'self',
            CPP_PRIMITIVE_TYPES
          ]
        },
        {
          begin: hljs.IDENT_RE + '::',
          keywords: CPP_KEYWORDS
        },
        {
          match: [
            // extra complexity to deal with `enum class` and `enum struct`
            /\b(?:enum(?:\s+(?:class|struct))?|class|struct|union)/,
            /\s+/,
            /\w+/
          ],
          className: {
            1: 'keyword',
            3: 'title.class'
          }
        }
      ])
  };
}

/*
Language: Arduino
Author: Stefania Mellai <s.mellai@arduino.cc>
Description: The Arduino® Language is a superset of C++. This rules are designed to highlight the Arduino® source code. For info about language see http://www.arduino.cc.
Website: https://www.arduino.cc
*/

/** @type LanguageFn */
function arduino(hljs) {
  const ARDUINO_KW = {
    type: [
      "boolean",
      "byte",
      "word",
      "String"
    ],
    built_in: [
      "KeyboardController",
      "MouseController",
      "SoftwareSerial",
      "EthernetServer",
      "EthernetClient",
      "LiquidCrystal",
      "RobotControl",
      "GSMVoiceCall",
      "EthernetUDP",
      "EsploraTFT",
      "HttpClient",
      "RobotMotor",
      "WiFiClient",
      "GSMScanner",
      "FileSystem",
      "Scheduler",
      "GSMServer",
      "YunClient",
      "YunServer",
      "IPAddress",
      "GSMClient",
      "GSMModem",
      "Keyboard",
      "Ethernet",
      "Console",
      "GSMBand",
      "Esplora",
      "Stepper",
      "Process",
      "WiFiUDP",
      "GSM_SMS",
      "Mailbox",
      "USBHost",
      "Firmata",
      "PImage",
      "Client",
      "Server",
      "GSMPIN",
      "FileIO",
      "Bridge",
      "Serial",
      "EEPROM",
      "Stream",
      "Mouse",
      "Audio",
      "Servo",
      "File",
      "Task",
      "GPRS",
      "WiFi",
      "Wire",
      "TFT",
      "GSM",
      "SPI",
      "SD"
    ],
    _hints: [
      "setup",
      "loop",
      "runShellCommandAsynchronously",
      "analogWriteResolution",
      "retrieveCallingNumber",
      "printFirmwareVersion",
      "analogReadResolution",
      "sendDigitalPortPair",
      "noListenOnLocalhost",
      "readJoystickButton",
      "setFirmwareVersion",
      "readJoystickSwitch",
      "scrollDisplayRight",
      "getVoiceCallStatus",
      "scrollDisplayLeft",
      "writeMicroseconds",
      "delayMicroseconds",
      "beginTransmission",
      "getSignalStrength",
      "runAsynchronously",
      "getAsynchronously",
      "listenOnLocalhost",
      "getCurrentCarrier",
      "readAccelerometer",
      "messageAvailable",
      "sendDigitalPorts",
      "lineFollowConfig",
      "countryNameWrite",
      "runShellCommand",
      "readStringUntil",
      "rewindDirectory",
      "readTemperature",
      "setClockDivider",
      "readLightSensor",
      "endTransmission",
      "analogReference",
      "detachInterrupt",
      "countryNameRead",
      "attachInterrupt",
      "encryptionType",
      "readBytesUntil",
      "robotNameWrite",
      "readMicrophone",
      "robotNameRead",
      "cityNameWrite",
      "userNameWrite",
      "readJoystickY",
      "readJoystickX",
      "mouseReleased",
      "openNextFile",
      "scanNetworks",
      "noInterrupts",
      "digitalWrite",
      "beginSpeaker",
      "mousePressed",
      "isActionDone",
      "mouseDragged",
      "displayLogos",
      "noAutoscroll",
      "addParameter",
      "remoteNumber",
      "getModifiers",
      "keyboardRead",
      "userNameRead",
      "waitContinue",
      "processInput",
      "parseCommand",
      "printVersion",
      "readNetworks",
      "writeMessage",
      "blinkVersion",
      "cityNameRead",
      "readMessage",
      "setDataMode",
      "parsePacket",
      "isListening",
      "setBitOrder",
      "beginPacket",
      "isDirectory",
      "motorsWrite",
      "drawCompass",
      "digitalRead",
      "clearScreen",
      "serialEvent",
      "rightToLeft",
      "setTextSize",
      "leftToRight",
      "requestFrom",
      "keyReleased",
      "compassRead",
      "analogWrite",
      "interrupts",
      "WiFiServer",
      "disconnect",
      "playMelody",
      "parseFloat",
      "autoscroll",
      "getPINUsed",
      "setPINUsed",
      "setTimeout",
      "sendAnalog",
      "readSlider",
      "analogRead",
      "beginWrite",
      "createChar",
      "motorsStop",
      "keyPressed",
      "tempoWrite",
      "readButton",
      "subnetMask",
      "debugPrint",
      "macAddress",
      "writeGreen",
      "randomSeed",
      "attachGPRS",
      "readString",
      "sendString",
      "remotePort",
      "releaseAll",
      "mouseMoved",
      "background",
      "getXChange",
      "getYChange",
      "answerCall",
      "getResult",
      "voiceCall",
      "endPacket",
      "constrain",
      "getSocket",
      "writeJSON",
      "getButton",
      "available",
      "connected",
      "findUntil",
      "readBytes",
      "exitValue",
      "readGreen",
      "writeBlue",
      "startLoop",
      "IPAddress",
      "isPressed",
      "sendSysex",
      "pauseMode",
      "gatewayIP",
      "setCursor",
      "getOemKey",
      "tuneWrite",
      "noDisplay",
      "loadImage",
      "switchPIN",
      "onRequest",
      "onReceive",
      "changePIN",
      "playFile",
      "noBuffer",
      "parseInt",
      "overflow",
      "checkPIN",
      "knobRead",
      "beginTFT",
      "bitClear",
      "updateIR",
      "bitWrite",
      "position",
      "writeRGB",
      "highByte",
      "writeRed",
      "setSpeed",
      "readBlue",
      "noStroke",
      "remoteIP",
      "transfer",
      "shutdown",
      "hangCall",
      "beginSMS",
      "endWrite",
      "attached",
      "maintain",
      "noCursor",
      "checkReg",
      "checkPUK",
      "shiftOut",
      "isValid",
      "shiftIn",
      "pulseIn",
      "connect",
      "println",
      "localIP",
      "pinMode",
      "getIMEI",
      "display",
      "noBlink",
      "process",
      "getBand",
      "running",
      "beginSD",
      "drawBMP",
      "lowByte",
      "setBand",
      "release",
      "bitRead",
      "prepare",
      "pointTo",
      "readRed",
      "setMode",
      "noFill",
      "remove",
      "listen",
      "stroke",
      "detach",
      "attach",
      "noTone",
      "exists",
      "buffer",
      "height",
      "bitSet",
      "circle",
      "config",
      "cursor",
      "random",
      "IRread",
      "setDNS",
      "endSMS",
      "getKey",
      "micros",
      "millis",
      "begin",
      "print",
      "write",
      "ready",
      "flush",
      "width",
      "isPIN",
      "blink",
      "clear",
      "press",
      "mkdir",
      "rmdir",
      "close",
      "point",
      "yield",
      "image",
      "BSSID",
      "click",
      "delay",
      "read",
      "text",
      "move",
      "peek",
      "beep",
      "rect",
      "line",
      "open",
      "seek",
      "fill",
      "size",
      "turn",
      "stop",
      "home",
      "find",
      "step",
      "tone",
      "sqrt",
      "RSSI",
      "SSID",
      "end",
      "bit",
      "tan",
      "cos",
      "sin",
      "pow",
      "map",
      "abs",
      "max",
      "min",
      "get",
      "run",
      "put"
    ],
    literal: [
      "DIGITAL_MESSAGE",
      "FIRMATA_STRING",
      "ANALOG_MESSAGE",
      "REPORT_DIGITAL",
      "REPORT_ANALOG",
      "INPUT_PULLUP",
      "SET_PIN_MODE",
      "INTERNAL2V56",
      "SYSTEM_RESET",
      "LED_BUILTIN",
      "INTERNAL1V1",
      "SYSEX_START",
      "INTERNAL",
      "EXTERNAL",
      "DEFAULT",
      "OUTPUT",
      "INPUT",
      "HIGH",
      "LOW"
    ]
  };

  const ARDUINO = cPlusPlus(hljs);

  const kws = /** @type {Record<string,any>} */ (ARDUINO.keywords);

  kws.type = [
    ...kws.type,
    ...ARDUINO_KW.type
  ];
  kws.literal = [
    ...kws.literal,
    ...ARDUINO_KW.literal
  ];
  kws.built_in = [
    ...kws.built_in,
    ...ARDUINO_KW.built_in
  ];
  kws._hints = ARDUINO_KW._hints;

  ARDUINO.name = 'Arduino';
  ARDUINO.aliases = [ 'ino' ];
  ARDUINO.supersetOf = "cpp";

  return ARDUINO;
}

module.exports = arduino;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/armasm.js":
/*!***********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/armasm.js ***!
  \***********************************************************/
/***/ (function(module) {

/*
Language: ARM Assembly
Author: Dan Panzarella <alsoelp@gmail.com>
Description: ARM Assembly including Thumb and Thumb2 instructions
Category: assembler
*/

/** @type LanguageFn */
function armasm(hljs) {
  // local labels: %?[FB]?[AT]?\d{1,2}\w+

  const COMMENT = { variants: [
    hljs.COMMENT('^[ \\t]*(?=#)', '$', {
      relevance: 0,
      excludeBegin: true
    }),
    hljs.COMMENT('[;@]', '$', { relevance: 0 }),
    hljs.C_LINE_COMMENT_MODE,
    hljs.C_BLOCK_COMMENT_MODE
  ] };

  return {
    name: 'ARM Assembly',
    case_insensitive: true,
    aliases: [ 'arm' ],
    keywords: {
      $pattern: '\\.?' + hljs.IDENT_RE,
      meta:
        // GNU preprocs
        '.2byte .4byte .align .ascii .asciz .balign .byte .code .data .else .end .endif .endm .endr .equ .err .exitm .extern .global .hword .if .ifdef .ifndef .include .irp .long .macro .rept .req .section .set .skip .space .text .word .arm .thumb .code16 .code32 .force_thumb .thumb_func .ltorg '
        // ARM directives
        + 'ALIAS ALIGN ARM AREA ASSERT ATTR CN CODE CODE16 CODE32 COMMON CP DATA DCB DCD DCDU DCDO DCFD DCFDU DCI DCQ DCQU DCW DCWU DN ELIF ELSE END ENDFUNC ENDIF ENDP ENTRY EQU EXPORT EXPORTAS EXTERN FIELD FILL FUNCTION GBLA GBLL GBLS GET GLOBAL IF IMPORT INCBIN INCLUDE INFO KEEP LCLA LCLL LCLS LTORG MACRO MAP MEND MEXIT NOFP OPT PRESERVE8 PROC QN READONLY RELOC REQUIRE REQUIRE8 RLIST FN ROUT SETA SETL SETS SN SPACE SUBT THUMB THUMBX TTL WHILE WEND ',
      built_in:
        'r0 r1 r2 r3 r4 r5 r6 r7 r8 r9 r10 r11 r12 r13 r14 r15 ' // standard registers
        + 'pc lr sp ip sl sb fp ' // typical regs plus backward compatibility
        + 'a1 a2 a3 a4 v1 v2 v3 v4 v5 v6 v7 v8 f0 f1 f2 f3 f4 f5 f6 f7 ' // more regs and fp
        + 'p0 p1 p2 p3 p4 p5 p6 p7 p8 p9 p10 p11 p12 p13 p14 p15 ' // coprocessor regs
        + 'c0 c1 c2 c3 c4 c5 c6 c7 c8 c9 c10 c11 c12 c13 c14 c15 ' // more coproc
        + 'q0 q1 q2 q3 q4 q5 q6 q7 q8 q9 q10 q11 q12 q13 q14 q15 ' // advanced SIMD NEON regs

        // program status registers
        + 'cpsr_c cpsr_x cpsr_s cpsr_f cpsr_cx cpsr_cxs cpsr_xs cpsr_xsf cpsr_sf cpsr_cxsf '
        + 'spsr_c spsr_x spsr_s spsr_f spsr_cx spsr_cxs spsr_xs spsr_xsf spsr_sf spsr_cxsf '

        // NEON and VFP registers
        + 's0 s1 s2 s3 s4 s5 s6 s7 s8 s9 s10 s11 s12 s13 s14 s15 '
        + 's16 s17 s18 s19 s20 s21 s22 s23 s24 s25 s26 s27 s28 s29 s30 s31 '
        + 'd0 d1 d2 d3 d4 d5 d6 d7 d8 d9 d10 d11 d12 d13 d14 d15 '
        + 'd16 d17 d18 d19 d20 d21 d22 d23 d24 d25 d26 d27 d28 d29 d30 d31 '

        + '{PC} {VAR} {TRUE} {FALSE} {OPT} {CONFIG} {ENDIAN} {CODESIZE} {CPU} {FPU} {ARCHITECTURE} {PCSTOREOFFSET} {ARMASM_VERSION} {INTER} {ROPI} {RWPI} {SWST} {NOSWST} . @'
    },
    contains: [
      {
        className: 'keyword',
        begin: '\\b(' // mnemonics
            + 'adc|'
            + '(qd?|sh?|u[qh]?)?add(8|16)?|usada?8|(q|sh?|u[qh]?)?(as|sa)x|'
            + 'and|adrl?|sbc|rs[bc]|asr|b[lx]?|blx|bxj|cbn?z|tb[bh]|bic|'
            + 'bfc|bfi|[su]bfx|bkpt|cdp2?|clz|clrex|cmp|cmn|cpsi[ed]|cps|'
            + 'setend|dbg|dmb|dsb|eor|isb|it[te]{0,3}|lsl|lsr|ror|rrx|'
            + 'ldm(([id][ab])|f[ds])?|ldr((s|ex)?[bhd])?|movt?|mvn|mra|mar|'
            + 'mul|[us]mull|smul[bwt][bt]|smu[as]d|smmul|smmla|'
            + 'mla|umlaal|smlal?([wbt][bt]|d)|mls|smlsl?[ds]|smc|svc|sev|'
            + 'mia([bt]{2}|ph)?|mrr?c2?|mcrr2?|mrs|msr|orr|orn|pkh(tb|bt)|rbit|'
            + 'rev(16|sh)?|sel|[su]sat(16)?|nop|pop|push|rfe([id][ab])?|'
            + 'stm([id][ab])?|str(ex)?[bhd]?|(qd?)?sub|(sh?|q|u[qh]?)?sub(8|16)|'
            + '[su]xt(a?h|a?b(16)?)|srs([id][ab])?|swpb?|swi|smi|tst|teq|'
            + 'wfe|wfi|yield'
        + ')'
        + '(eq|ne|cs|cc|mi|pl|vs|vc|hi|ls|ge|lt|gt|le|al|hs|lo)?' // condition codes
        + '[sptrx]?' // legal postfixes
        + '(?=\\s)' // followed by space
      },
      COMMENT,
      hljs.QUOTE_STRING_MODE,
      {
        className: 'string',
        begin: '\'',
        end: '[^\\\\]\'',
        relevance: 0
      },
      {
        className: 'title',
        begin: '\\|',
        end: '\\|',
        illegal: '\\n',
        relevance: 0
      },
      {
        className: 'number',
        variants: [
          { // hex
            begin: '[#$=]?0x[0-9a-f]+' },
          { // bin
            begin: '[#$=]?0b[01]+' },
          { // literal
            begin: '[#$=]\\d+' },
          { // bare number
            begin: '\\b\\d+' }
        ],
        relevance: 0
      },
      {
        className: 'symbol',
        variants: [
          { // GNU ARM syntax
            begin: '^[ \\t]*[a-z_\\.\\$][a-z0-9_\\.\\$]+:' },
          { // ARM syntax
            begin: '^[a-z_\\.\\$][a-z0-9_\\.\\$]+' },
          { // label reference
            begin: '[=#]\\w+' }
        ],
        relevance: 0
      }
    ]
  };
}

module.exports = armasm;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/asciidoc.js":
/*!*************************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/asciidoc.js ***!
  \*************************************************************/
/***/ (function(module) {

/*
Language: AsciiDoc
Requires: xml.js
Author: Dan Allen <dan.j.allen@gmail.com>
Website: http://asciidoc.org
Description: A semantic, text-based document format that can be exported to HTML, DocBook and other backends.
Category: markup
*/

/** @type LanguageFn */
function asciidoc(hljs) {
  const regex = hljs.regex;
  const HORIZONTAL_RULE = {
    begin: '^\'{3,}[ \\t]*$',
    relevance: 10
  };
  const ESCAPED_FORMATTING = [
    // escaped constrained formatting marks (i.e., \* \_ or \`)
    { begin: /\\[*_`]/ },
    // escaped unconstrained formatting marks (i.e., \\** \\__ or \\``)
    // must ignore until the next formatting marks
    // this rule might not be 100% compliant with Asciidoctor 2.0 but we are entering undefined behavior territory...
    { begin: /\\\\\*{2}[^\n]*?\*{2}/ },
    { begin: /\\\\_{2}[^\n]*_{2}/ },
    { begin: /\\\\`{2}[^\n]*`{2}/ },
    // guard: constrained formatting mark may not be preceded by ":", ";" or
    // "}". match these so the constrained rule doesn't see them
    { begin: /[:;}][*_`](?![*_`])/ }
  ];
  const STRONG = [
    // inline unconstrained strong (single line)
    {
      className: 'strong',
      begin: /\*{2}([^\n]+?)\*{2}/
    },
    // inline unconstrained strong (multi-line)
    {
      className: 'strong',
      begin: regex.concat(
        /\*\*/,
        /((\*(?!\*)|\\[^\n]|[^*\n\\])+\n)+/,
        /(\*(?!\*)|\\[^\n]|[^*\n\\])*/,
        /\*\*/
      ),
      relevance: 0
    },
    // inline constrained strong (single line)
    {
      className: 'strong',
      // must not precede or follow a word character
      begin: /\B\*(\S|\S[^\n]*?\S)\*(?!\w)/
    },
    // inline constrained strong (multi-line)
    {
      className: 'strong',
      // must not precede or follow a word character
      begin: /\*[^\s]([^\n]+\n)+([^\n]+)\*/
    }
  ];
  const EMPHASIS = [
    // inline unconstrained emphasis (single line)
    {
      className: 'emphasis',
      begin: /_{2}([^\n]+?)_{2}/
    },
    // inline unconstrained emphasis (multi-line)
    {
      className: 'emphasis',
      begin: regex.concat(
        /__/,
        /((_(?!_)|\\[^\n]|[^_\n\\])+\n)+/,
        /(_(?!_)|\\[^\n]|[^_\n\\])*/,
        /__/
      ),
      relevance: 0
    },
    // inline constrained emphasis (single line)
    {
      className: 'emphasis',
      // must not precede or follow a word character
      begin: /\b_(\S|\S[^\n]*?\S)_(?!\w)/
    },
    // inline constrained emphasis (multi-line)
    {
      className: 'emphasis',
      // must not precede or follow a word character
      begin: /_[^\s]([^\n]+\n)+([^\n]+)_/
    },
    // inline constrained emphasis using single quote (legacy)
    {
      className: 'emphasis',
      // must not follow a word character or be followed by a single quote or space
      begin: '\\B\'(?![\'\\s])',
      end: '(\\n{2}|\')',
      // allow escaped single quote followed by word char
      contains: [
        {
          begin: '\\\\\'\\w',
          relevance: 0
        }
      ],
      relevance: 0
    }
  ];
  const ADMONITION = {
    className: 'symbol',
    begin: '^(NOTE|TIP|IMPORTANT|WARNING|CAUTION):\\s+',
    relevance: 10
  };
  const BULLET_LIST = {
    className: 'bullet',
    begin: '^(\\*+|-+|\\.+|[^\\n]+?::)\\s+'
  };

  return {
    name: 'AsciiDoc',
    aliases: [ 'adoc' ],
    contains: [
      // block comment
      hljs.COMMENT(
        '^/{4,}\\n',
        '\\n/{4,}$',
        // can also be done as...
        // '^/{4,}$',
        // '^/{4,}$',
        { relevance: 10 }
      ),
      // line comment
      hljs.COMMENT(
        '^//',
        '$',
        { relevance: 0 }
      ),
      // title
      {
        className: 'title',
        begin: '^\\.\\w.*$'
      },
      // example, admonition & sidebar blocks
      {
        begin: '^[=\\*]{4,}\\n',
        end: '\\n^[=\\*]{4,}$',
        relevance: 10
      },
      // headings
      {
        className: 'section',
        relevance: 10,
        variants: [
          { begin: '^(={1,6})[ \t].+?([ \t]\\1)?$' },
          { begin: '^[^\\[\\]\\n]+?\\n[=\\-~\\^\\+]{2,}$' }
        ]
      },
      // document attributes
      {
        className: 'meta',
        begin: '^:.+?:',
        end: '\\s',
        excludeEnd: true,
        relevance: 10
      },
      // block attributes
      {
        className: 'meta',
        begin: '^\\[.+?\\]$',
        relevance: 0
      },
      // quoteblocks
      {
        className: 'quote',
        begin: '^_{4,}\\n',
        end: '\\n_{4,}$',
        relevance: 10
      },
      // listing and literal blocks
      {
        className: 'code',
        begin: '^[\\-\\.]{4,}\\n',
        end: '\\n[\\-\\.]{4,}$',
        relevance: 10
      },
      // passthrough blocks
      {
        begin: '^\\+{4,}\\n',
        end: '\\n\\+{4,}$',
        contains: [
          {
            begin: '<',
            end: '>',
            subLanguage: 'xml',
            relevance: 0
          }
        ],
        relevance: 10
      },

      BULLET_LIST,
      ADMONITION,
      ...ESCAPED_FORMATTING,
      ...STRONG,
      ...EMPHASIS,

      // inline smart quotes
      {
        className: 'string',
        variants: [
          { begin: "``.+?''" },
          { begin: "`.+?'" }
        ]
      },
      // inline unconstrained emphasis
      {
        className: 'code',
        begin: /`{2}/,
        end: /(\n{2}|`{2})/
      },
      // inline code snippets (TODO should get same treatment as strong and emphasis)
      {
        className: 'code',
        begin: '(`.+?`|\\+.+?\\+)',
        relevance: 0
      },
      // indented literal block
      {
        className: 'code',
        begin: '^[ \\t]',
        end: '$',
        relevance: 0
      },
      HORIZONTAL_RULE,
      // images and links
      {
        begin: '(link:)?(http|https|ftp|file|irc|image:?):\\S+?\\[[^[]*?\\]',
        returnBegin: true,
        contains: [
          {
            begin: '(link|image:?):',
            relevance: 0
          },
          {
            className: 'link',
            begin: '\\w',
            end: '[^\\[]+',
            relevance: 0
          },
          {
            className: 'string',
            begin: '\\[',
            end: '\\]',
            excludeBegin: true,
            excludeEnd: true,
            relevance: 0
          }
        ],
        relevance: 10
      }
    ]
  };
}

module.exports = asciidoc;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/aspectj.js":
/*!************************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/aspectj.js ***!
  \************************************************************/
/***/ (function(module) {

/*
Language: AspectJ
Author: Hakan Ozler <ozler.hakan@gmail.com>
Website: https://www.eclipse.org/aspectj/
Description: Syntax Highlighting for the AspectJ Language which is a general-purpose aspect-oriented extension to the Java programming language.
Audit: 2020
*/

/** @type LanguageFn */
function aspectj(hljs) {
  const regex = hljs.regex;
  const KEYWORDS = [
    "false",
    "synchronized",
    "int",
    "abstract",
    "float",
    "private",
    "char",
    "boolean",
    "static",
    "null",
    "if",
    "const",
    "for",
    "true",
    "while",
    "long",
    "throw",
    "strictfp",
    "finally",
    "protected",
    "import",
    "native",
    "final",
    "return",
    "void",
    "enum",
    "else",
    "extends",
    "implements",
    "break",
    "transient",
    "new",
    "catch",
    "instanceof",
    "byte",
    "super",
    "volatile",
    "case",
    "assert",
    "short",
    "package",
    "default",
    "double",
    "public",
    "try",
    "this",
    "switch",
    "continue",
    "throws",
    "privileged",
    "aspectOf",
    "adviceexecution",
    "proceed",
    "cflowbelow",
    "cflow",
    "initialization",
    "preinitialization",
    "staticinitialization",
    "withincode",
    "target",
    "within",
    "execution",
    "getWithinTypeName",
    "handler",
    "thisJoinPoint",
    "thisJoinPointStaticPart",
    "thisEnclosingJoinPointStaticPart",
    "declare",
    "parents",
    "warning",
    "error",
    "soft",
    "precedence",
    "thisAspectInstance"
  ];
  const SHORTKEYS = [
    "get",
    "set",
    "args",
    "call"
  ];

  return {
    name: 'AspectJ',
    keywords: KEYWORDS,
    illegal: /<\/|#/,
    contains: [
      hljs.COMMENT(
        /\/\*\*/,
        /\*\//,
        {
          relevance: 0,
          contains: [
            {
              // eat up @'s in emails to prevent them to be recognized as doctags
              begin: /\w+@/,
              relevance: 0
            },
            {
              className: 'doctag',
              begin: /@[A-Za-z]+/
            }
          ]
        }
      ),
      hljs.C_LINE_COMMENT_MODE,
      hljs.C_BLOCK_COMMENT_MODE,
      hljs.APOS_STRING_MODE,
      hljs.QUOTE_STRING_MODE,
      {
        className: 'class',
        beginKeywords: 'aspect',
        end: /[{;=]/,
        excludeEnd: true,
        illegal: /[:;"\[\]]/,
        contains: [
          { beginKeywords: 'extends implements pertypewithin perthis pertarget percflowbelow percflow issingleton' },
          hljs.UNDERSCORE_TITLE_MODE,
          {
            begin: /\([^\)]*/,
            end: /[)]+/,
            keywords: KEYWORDS.concat(SHORTKEYS),
            excludeEnd: false
          }
        ]
      },
      {
        className: 'class',
        beginKeywords: 'class interface',
        end: /[{;=]/,
        excludeEnd: true,
        relevance: 0,
        keywords: 'class interface',
        illegal: /[:"\[\]]/,
        contains: [
          { beginKeywords: 'extends implements' },
          hljs.UNDERSCORE_TITLE_MODE
        ]
      },
      {
        // AspectJ Constructs
        beginKeywords: 'pointcut after before around throwing returning',
        end: /[)]/,
        excludeEnd: false,
        illegal: /["\[\]]/,
        contains: [
          {
            begin: regex.concat(hljs.UNDERSCORE_IDENT_RE, /\s*\(/),
            returnBegin: true,
            contains: [ hljs.UNDERSCORE_TITLE_MODE ]
          }
        ]
      },
      {
        begin: /[:]/,
        returnBegin: true,
        end: /[{;]/,
        relevance: 0,
        excludeEnd: false,
        keywords: KEYWORDS,
        illegal: /["\[\]]/,
        contains: [
          {
            begin: regex.concat(hljs.UNDERSCORE_IDENT_RE, /\s*\(/),
            keywords: KEYWORDS.concat(SHORTKEYS),
            relevance: 0
          },
          hljs.QUOTE_STRING_MODE
        ]
      },
      {
        // this prevents 'new Name(...), or throw ...' from being recognized as a function definition
        beginKeywords: 'new throw',
        relevance: 0
      },
      {
        // the function class is a bit different for AspectJ compared to the Java language
        className: 'function',
        begin: /\w+ +\w+(\.\w+)?\s*\([^\)]*\)\s*((throws)[\w\s,]+)?[\{;]/,
        returnBegin: true,
        end: /[{;=]/,
        keywords: KEYWORDS,
        excludeEnd: true,
        contains: [
          {
            begin: regex.concat(hljs.UNDERSCORE_IDENT_RE, /\s*\(/),
            returnBegin: true,
            relevance: 0,
            contains: [ hljs.UNDERSCORE_TITLE_MODE ]
          },
          {
            className: 'params',
            begin: /\(/,
            end: /\)/,
            relevance: 0,
            keywords: KEYWORDS,
            contains: [
              hljs.APOS_STRING_MODE,
              hljs.QUOTE_STRING_MODE,
              hljs.C_NUMBER_MODE,
              hljs.C_BLOCK_COMMENT_MODE
            ]
          },
          hljs.C_LINE_COMMENT_MODE,
          hljs.C_BLOCK_COMMENT_MODE
        ]
      },
      hljs.C_NUMBER_MODE,
      {
        // annotation is also used in this language
        className: 'meta',
        begin: /@[A-Za-z]+/
      }
    ]
  };
}

module.exports = aspectj;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/autohotkey.js":
/*!***************************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/autohotkey.js ***!
  \***************************************************************/
/***/ (function(module) {

/*
Language: AutoHotkey
Author: Seongwon Lee <dlimpid@gmail.com>
Description: AutoHotkey language definition
Category: scripting
*/

/** @type LanguageFn */
function autohotkey(hljs) {
  const BACKTICK_ESCAPE = { begin: '`[\\s\\S]' };

  return {
    name: 'AutoHotkey',
    case_insensitive: true,
    aliases: [ 'ahk' ],
    keywords: {
      keyword: 'Break Continue Critical Exit ExitApp Gosub Goto New OnExit Pause return SetBatchLines SetTimer Suspend Thread Throw Until ahk_id ahk_class ahk_pid ahk_exe ahk_group',
      literal: 'true false NOT AND OR',
      built_in: 'ComSpec Clipboard ClipboardAll ErrorLevel'
    },
    contains: [
      BACKTICK_ESCAPE,
      hljs.inherit(hljs.QUOTE_STRING_MODE, { contains: [ BACKTICK_ESCAPE ] }),
      hljs.COMMENT(';', '$', { relevance: 0 }),
      hljs.C_BLOCK_COMMENT_MODE,
      {
        className: 'number',
        begin: hljs.NUMBER_RE,
        relevance: 0
      },
      {
        // subst would be the most accurate however fails the point of
        // highlighting. variable is comparably the most accurate that actually
        // has some effect
        className: 'variable',
        begin: '%[a-zA-Z0-9#_$@]+%'
      },
      {
        className: 'built_in',
        begin: '^\\s*\\w+\\s*(,|%)'
        // I don't really know if this is totally relevant
      },
      {
        // symbol would be most accurate however is highlighted just like
        // built_in and that makes up a lot of AutoHotkey code meaning that it
        // would fail to highlight anything
        className: 'title',
        variants: [
          { begin: '^[^\\n";]+::(?!=)' },
          {
            begin: '^[^\\n";]+:(?!=)',
            // zero relevance as it catches a lot of things
            // followed by a single ':' in many languages
            relevance: 0
          }
        ]
      },
      {
        className: 'meta',
        begin: '^\\s*#\\w+',
        end: '$',
        relevance: 0
      },
      {
        className: 'built_in',
        begin: 'A_[a-zA-Z0-9]+'
      },
      {
        // consecutive commas, not for highlighting but just for relevance
        begin: ',\\s*,' }
    ]
  };
}

module.exports = autohotkey;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/autoit.js":
/*!***********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/autoit.js ***!
  \***********************************************************/
/***/ (function(module) {

/*
Language: AutoIt
Author: Manh Tuan <junookyo@gmail.com>
Description: AutoIt language definition
Category: scripting
*/

/** @type LanguageFn */
function autoit(hljs) {
  const KEYWORDS = 'ByRef Case Const ContinueCase ContinueLoop '
        + 'Dim Do Else ElseIf EndFunc EndIf EndSelect '
        + 'EndSwitch EndWith Enum Exit ExitLoop For Func '
        + 'Global If In Local Next ReDim Return Select Static '
        + 'Step Switch Then To Until Volatile WEnd While With';

  const DIRECTIVES = [
    "EndRegion",
    "forcedef",
    "forceref",
    "ignorefunc",
    "include",
    "include-once",
    "NoTrayIcon",
    "OnAutoItStartRegister",
    "pragma",
    "Region",
    "RequireAdmin",
    "Tidy_Off",
    "Tidy_On",
    "Tidy_Parameters"
  ];

  const LITERAL = 'True False And Null Not Or Default';

  const BUILT_IN =
          'Abs ACos AdlibRegister AdlibUnRegister Asc AscW ASin Assign ATan AutoItSetOption AutoItWinGetTitle AutoItWinSetTitle Beep Binary BinaryLen BinaryMid BinaryToString BitAND BitNOT BitOR BitRotate BitShift BitXOR BlockInput Break Call CDTray Ceiling Chr ChrW ClipGet ClipPut ConsoleRead ConsoleWrite ConsoleWriteError ControlClick ControlCommand ControlDisable ControlEnable ControlFocus ControlGetFocus ControlGetHandle ControlGetPos ControlGetText ControlHide ControlListView ControlMove ControlSend ControlSetText ControlShow ControlTreeView Cos Dec DirCopy DirCreate DirGetSize DirMove DirRemove DllCall DllCallAddress DllCallbackFree DllCallbackGetPtr DllCallbackRegister DllClose DllOpen DllStructCreate DllStructGetData DllStructGetPtr DllStructGetSize DllStructSetData DriveGetDrive DriveGetFileSystem DriveGetLabel DriveGetSerial DriveGetType DriveMapAdd DriveMapDel DriveMapGet DriveSetLabel DriveSpaceFree DriveSpaceTotal DriveStatus EnvGet EnvSet EnvUpdate Eval Execute Exp FileChangeDir FileClose FileCopy FileCreateNTFSLink FileCreateShortcut FileDelete FileExists FileFindFirstFile FileFindNextFile FileFlush FileGetAttrib FileGetEncoding FileGetLongName FileGetPos FileGetShortcut FileGetShortName FileGetSize FileGetTime FileGetVersion FileInstall FileMove FileOpen FileOpenDialog FileRead FileReadLine FileReadToArray FileRecycle FileRecycleEmpty FileSaveDialog FileSelectFolder FileSetAttrib FileSetEnd FileSetPos FileSetTime FileWrite FileWriteLine Floor FtpSetProxy FuncName GUICreate GUICtrlCreateAvi GUICtrlCreateButton GUICtrlCreateCheckbox GUICtrlCreateCombo GUICtrlCreateContextMenu GUICtrlCreateDate GUICtrlCreateDummy GUICtrlCreateEdit GUICtrlCreateGraphic GUICtrlCreateGroup GUICtrlCreateIcon GUICtrlCreateInput GUICtrlCreateLabel GUICtrlCreateList GUICtrlCreateListView GUICtrlCreateListViewItem GUICtrlCreateMenu GUICtrlCreateMenuItem GUICtrlCreateMonthCal GUICtrlCreateObj GUICtrlCreatePic GUICtrlCreateProgress GUICtrlCreateRadio GUICtrlCreateSlider GUICtrlCreateTab GUICtrlCreateTabItem GUICtrlCreateTreeView GUICtrlCreateTreeViewItem GUICtrlCreateUpdown GUICtrlDelete GUICtrlGetHandle GUICtrlGetState GUICtrlRead GUICtrlRecvMsg GUICtrlRegisterListViewSort GUICtrlSendMsg GUICtrlSendToDummy GUICtrlSetBkColor GUICtrlSetColor GUICtrlSetCursor GUICtrlSetData GUICtrlSetDefBkColor GUICtrlSetDefColor GUICtrlSetFont GUICtrlSetGraphic GUICtrlSetImage GUICtrlSetLimit GUICtrlSetOnEvent GUICtrlSetPos GUICtrlSetResizing GUICtrlSetState GUICtrlSetStyle GUICtrlSetTip GUIDelete GUIGetCursorInfo GUIGetMsg GUIGetStyle GUIRegisterMsg GUISetAccelerators GUISetBkColor GUISetCoord GUISetCursor GUISetFont GUISetHelp GUISetIcon GUISetOnEvent GUISetState GUISetStyle GUIStartGroup GUISwitch Hex HotKeySet HttpSetProxy HttpSetUserAgent HWnd InetClose InetGet InetGetInfo InetGetSize InetRead IniDelete IniRead IniReadSection IniReadSectionNames IniRenameSection IniWrite IniWriteSection InputBox Int IsAdmin IsArray IsBinary IsBool IsDeclared IsDllStruct IsFloat IsFunc IsHWnd IsInt IsKeyword IsNumber IsObj IsPtr IsString Log MemGetStats Mod MouseClick MouseClickDrag MouseDown MouseGetCursor MouseGetPos MouseMove MouseUp MouseWheel MsgBox Number ObjCreate ObjCreateInterface ObjEvent ObjGet ObjName OnAutoItExitRegister OnAutoItExitUnRegister Ping PixelChecksum PixelGetColor PixelSearch ProcessClose ProcessExists ProcessGetStats ProcessList ProcessSetPriority ProcessWait ProcessWaitClose ProgressOff ProgressOn ProgressSet Ptr Random RegDelete RegEnumKey RegEnumVal RegRead RegWrite Round Run RunAs RunAsWait RunWait Send SendKeepActive SetError SetExtended ShellExecute ShellExecuteWait Shutdown Sin Sleep SoundPlay SoundSetWaveVolume SplashImageOn SplashOff SplashTextOn Sqrt SRandom StatusbarGetText StderrRead StdinWrite StdioClose StdoutRead String StringAddCR StringCompare StringFormat StringFromASCIIArray StringInStr StringIsAlNum StringIsAlpha StringIsASCII StringIsDigit StringIsFloat StringIsInt StringIsLower StringIsSpace StringIsUpper StringIsXDigit StringLeft StringLen StringLower StringMid StringRegExp StringRegExpReplace StringReplace StringReverse StringRight StringSplit StringStripCR StringStripWS StringToASCIIArray StringToBinary StringTrimLeft StringTrimRight StringUpper Tan TCPAccept TCPCloseSocket TCPConnect TCPListen TCPNameToIP TCPRecv TCPSend TCPShutdown, UDPShutdown TCPStartup, UDPStartup TimerDiff TimerInit ToolTip TrayCreateItem TrayCreateMenu TrayGetMsg TrayItemDelete TrayItemGetHandle TrayItemGetState TrayItemGetText TrayItemSetOnEvent TrayItemSetState TrayItemSetText TraySetClick TraySetIcon TraySetOnEvent TraySetPauseIcon TraySetState TraySetToolTip TrayTip UBound UDPBind UDPCloseSocket UDPOpen UDPRecv UDPSend VarGetType WinActivate WinActive WinClose WinExists WinFlash WinGetCaretPos WinGetClassList WinGetClientSize WinGetHandle WinGetPos WinGetProcess WinGetState WinGetText WinGetTitle WinKill WinList WinMenuSelectItem WinMinimizeAll WinMinimizeAllUndo WinMove WinSetOnTop WinSetState WinSetTitle WinSetTrans WinWait WinWaitActive WinWaitClose WinWaitNotActive';

  const COMMENT = { variants: [
    hljs.COMMENT(';', '$', { relevance: 0 }),
    hljs.COMMENT('#cs', '#ce'),
    hljs.COMMENT('#comments-start', '#comments-end')
  ] };

  const VARIABLE = { begin: '\\$[A-z0-9_]+' };

  const STRING = {
    className: 'string',
    variants: [
      {
        begin: /"/,
        end: /"/,
        contains: [
          {
            begin: /""/,
            relevance: 0
          }
        ]
      },
      {
        begin: /'/,
        end: /'/,
        contains: [
          {
            begin: /''/,
            relevance: 0
          }
        ]
      }
    ]
  };

  const NUMBER = { variants: [
    hljs.BINARY_NUMBER_MODE,
    hljs.C_NUMBER_MODE
  ] };

  const PREPROCESSOR = {
    className: 'meta',
    begin: '#',
    end: '$',
    keywords: { keyword: DIRECTIVES },
    contains: [
      {
        begin: /\\\n/,
        relevance: 0
      },
      {
        beginKeywords: 'include',
        keywords: { keyword: 'include' },
        end: '$',
        contains: [
          STRING,
          {
            className: 'string',
            variants: [
              {
                begin: '<',
                end: '>'
              },
              {
                begin: /"/,
                end: /"/,
                contains: [
                  {
                    begin: /""/,
                    relevance: 0
                  }
                ]
              },
              {
                begin: /'/,
                end: /'/,
                contains: [
                  {
                    begin: /''/,
                    relevance: 0
                  }
                ]
              }
            ]
          }
        ]
      },
      STRING,
      COMMENT
    ]
  };

  const CONSTANT = {
    className: 'symbol',
    // begin: '@',
    // end: '$',
    // keywords: 'AppDataCommonDir AppDataDir AutoItExe AutoItPID AutoItVersion AutoItX64 COM_EventObj CommonFilesDir Compiled ComputerName ComSpec CPUArch CR CRLF DesktopCommonDir DesktopDepth DesktopDir DesktopHeight DesktopRefresh DesktopWidth DocumentsCommonDir error exitCode exitMethod extended FavoritesCommonDir FavoritesDir GUI_CtrlHandle GUI_CtrlId GUI_DragFile GUI_DragId GUI_DropId GUI_WinHandle HomeDrive HomePath HomeShare HotKeyPressed HOUR IPAddress1 IPAddress2 IPAddress3 IPAddress4 KBLayout LF LocalAppDataDir LogonDNSDomain LogonDomain LogonServer MDAY MIN MON MSEC MUILang MyDocumentsDir NumParams OSArch OSBuild OSLang OSServicePack OSType OSVersion ProgramFilesDir ProgramsCommonDir ProgramsDir ScriptDir ScriptFullPath ScriptLineNumber ScriptName SEC StartMenuCommonDir StartMenuDir StartupCommonDir StartupDir SW_DISABLE SW_ENABLE SW_HIDE SW_LOCK SW_MAXIMIZE SW_MINIMIZE SW_RESTORE SW_SHOW SW_SHOWDEFAULT SW_SHOWMAXIMIZED SW_SHOWMINIMIZED SW_SHOWMINNOACTIVE SW_SHOWNA SW_SHOWNOACTIVATE SW_SHOWNORMAL SW_UNLOCK SystemDir TAB TempDir TRAY_ID TrayIconFlashing TrayIconVisible UserName UserProfileDir WDAY WindowsDir WorkingDir YDAY YEAR',
    // relevance: 5
    begin: '@[A-z0-9_]+'
  };

  const FUNCTION = {
    beginKeywords: 'Func',
    end: '$',
    illegal: '\\$|\\[|%',
    contains: [
      hljs.inherit(hljs.UNDERSCORE_TITLE_MODE, { className: "title.function" }),
      {
        className: 'params',
        begin: '\\(',
        end: '\\)',
        contains: [
          VARIABLE,
          STRING,
          NUMBER
        ]
      }
    ]
  };

  return {
    name: 'AutoIt',
    case_insensitive: true,
    illegal: /\/\*/,
    keywords: {
      keyword: KEYWORDS,
      built_in: BUILT_IN,
      literal: LITERAL
    },
    contains: [
      COMMENT,
      VARIABLE,
      STRING,
      NUMBER,
      PREPROCESSOR,
      CONSTANT,
      FUNCTION
    ]
  };
}

module.exports = autoit;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/avrasm.js":
/*!***********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/avrasm.js ***!
  \***********************************************************/
/***/ (function(module) {

/*
Language: AVR Assembly
Author: Vladimir Ermakov <vooon341@gmail.com>
Category: assembler
Website: https://www.microchip.com/webdoc/avrassembler/avrassembler.wb_instruction_list.html
*/

/** @type LanguageFn */
function avrasm(hljs) {
  return {
    name: 'AVR Assembly',
    case_insensitive: true,
    keywords: {
      $pattern: '\\.?' + hljs.IDENT_RE,
      keyword:
        /* mnemonic */
        'adc add adiw and andi asr bclr bld brbc brbs brcc brcs break breq brge brhc brhs '
        + 'brid brie brlo brlt brmi brne brpl brsh brtc brts brvc brvs bset bst call cbi cbr '
        + 'clc clh cli cln clr cls clt clv clz com cp cpc cpi cpse dec eicall eijmp elpm eor '
        + 'fmul fmuls fmulsu icall ijmp in inc jmp ld ldd ldi lds lpm lsl lsr mov movw mul '
        + 'muls mulsu neg nop or ori out pop push rcall ret reti rjmp rol ror sbc sbr sbrc sbrs '
        + 'sec seh sbi sbci sbic sbis sbiw sei sen ser ses set sev sez sleep spm st std sts sub '
        + 'subi swap tst wdr',
      built_in:
        /* general purpose registers */
        'r0 r1 r2 r3 r4 r5 r6 r7 r8 r9 r10 r11 r12 r13 r14 r15 r16 r17 r18 r19 r20 r21 r22 '
        + 'r23 r24 r25 r26 r27 r28 r29 r30 r31 x|0 xh xl y|0 yh yl z|0 zh zl '
        /* IO Registers (ATMega128) */
        + 'ucsr1c udr1 ucsr1a ucsr1b ubrr1l ubrr1h ucsr0c ubrr0h tccr3c tccr3a tccr3b tcnt3h '
        + 'tcnt3l ocr3ah ocr3al ocr3bh ocr3bl ocr3ch ocr3cl icr3h icr3l etimsk etifr tccr1c '
        + 'ocr1ch ocr1cl twcr twdr twar twsr twbr osccal xmcra xmcrb eicra spmcsr spmcr portg '
        + 'ddrg ping portf ddrf sreg sph spl xdiv rampz eicrb eimsk gimsk gicr eifr gifr timsk '
        + 'tifr mcucr mcucsr tccr0 tcnt0 ocr0 assr tccr1a tccr1b tcnt1h tcnt1l ocr1ah ocr1al '
        + 'ocr1bh ocr1bl icr1h icr1l tccr2 tcnt2 ocr2 ocdr wdtcr sfior eearh eearl eedr eecr '
        + 'porta ddra pina portb ddrb pinb portc ddrc pinc portd ddrd pind spdr spsr spcr udr0 '
        + 'ucsr0a ucsr0b ubrr0l acsr admux adcsr adch adcl porte ddre pine pinf',
      meta:
        '.byte .cseg .db .def .device .dseg .dw .endmacro .equ .eseg .exit .include .list '
        + '.listmac .macro .nolist .org .set'
    },
    contains: [
      hljs.C_BLOCK_COMMENT_MODE,
      hljs.COMMENT(
        ';',
        '$',
        { relevance: 0 }
      ),
      hljs.C_NUMBER_MODE, // 0x..., decimal, float
      hljs.BINARY_NUMBER_MODE, // 0b...
      {
        className: 'number',
        begin: '\\b(\\$[a-zA-Z0-9]+|0o[0-7]+)' // $..., 0o...
      },
      hljs.QUOTE_STRING_MODE,
      {
        className: 'string',
        begin: '\'',
        end: '[^\\\\]\'',
        illegal: '[^\\\\][^\']'
      },
      {
        className: 'symbol',
        begin: '^[A-Za-z0-9_.$]+:'
      },
      {
        className: 'meta',
        begin: '#',
        end: '$'
      },
      { // substitution within a macro
        className: 'subst',
        begin: '@[0-9]+'
      }
    ]
  };
}

module.exports = avrasm;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/awk.js":
/*!********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/awk.js ***!
  \********************************************************/
/***/ (function(module) {

/*
Language: Awk
Author: Matthew Daly <matthewbdaly@gmail.com>
Website: https://www.gnu.org/software/gawk/manual/gawk.html
Description: language definition for Awk scripts
*/

/** @type LanguageFn */
function awk(hljs) {
  const VARIABLE = {
    className: 'variable',
    variants: [
      { begin: /\$[\w\d#@][\w\d_]*/ },
      { begin: /\$\{(.*?)\}/ }
    ]
  };
  const KEYWORDS = 'BEGIN END if else while do for in break continue delete next nextfile function func exit|10';
  const STRING = {
    className: 'string',
    contains: [ hljs.BACKSLASH_ESCAPE ],
    variants: [
      {
        begin: /(u|b)?r?'''/,
        end: /'''/,
        relevance: 10
      },
      {
        begin: /(u|b)?r?"""/,
        end: /"""/,
        relevance: 10
      },
      {
        begin: /(u|r|ur)'/,
        end: /'/,
        relevance: 10
      },
      {
        begin: /(u|r|ur)"/,
        end: /"/,
        relevance: 10
      },
      {
        begin: /(b|br)'/,
        end: /'/
      },
      {
        begin: /(b|br)"/,
        end: /"/
      },
      hljs.APOS_STRING_MODE,
      hljs.QUOTE_STRING_MODE
    ]
  };
  return {
    name: 'Awk',
    keywords: { keyword: KEYWORDS },
    contains: [
      VARIABLE,
      STRING,
      hljs.REGEXP_MODE,
      hljs.HASH_COMMENT_MODE,
      hljs.NUMBER_MODE
    ]
  };
}

module.exports = awk;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/axapta.js":
/*!***********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/axapta.js ***!
  \***********************************************************/
/***/ (function(module) {

/*
Language: Microsoft X++
Description: X++ is a language used in Microsoft Dynamics 365, Dynamics AX, and Axapta.
Author: Dmitri Roudakov <dmitri@roudakov.ru>
Website: https://dynamics.microsoft.com/en-us/ax-overview/
Category: enterprise
*/

/** @type LanguageFn */
function axapta(hljs) {
  const IDENT_RE = hljs.UNDERSCORE_IDENT_RE;
  const BUILT_IN_KEYWORDS = [
    'anytype',
    'boolean',
    'byte',
    'char',
    'container',
    'date',
    'double',
    'enum',
    'guid',
    'int',
    'int64',
    'long',
    'real',
    'short',
    'str',
    'utcdatetime',
    'var'
  ];

  const LITERAL_KEYWORDS = [
    'default',
    'false',
    'null',
    'true'
  ];

  const NORMAL_KEYWORDS = [
    'abstract',
    'as',
    'asc',
    'avg',
    'break',
    'breakpoint',
    'by',
    'byref',
    'case',
    'catch',
    'changecompany',
    'class',
    'client',
    'client',
    'common',
    'const',
    'continue',
    'count',
    'crosscompany',
    'delegate',
    'delete_from',
    'desc',
    'display',
    'div',
    'do',
    'edit',
    'else',
    'eventhandler',
    'exists',
    'extends',
    'final',
    'finally',
    'firstfast',
    'firstonly',
    'firstonly1',
    'firstonly10',
    'firstonly100',
    'firstonly1000',
    'flush',
    'for',
    'forceliterals',
    'forcenestedloop',
    'forceplaceholders',
    'forceselectorder',
    'forupdate',
    'from',
    'generateonly',
    'group',
    'hint',
    'if',
    'implements',
    'in',
    'index',
    'insert_recordset',
    'interface',
    'internal',
    'is',
    'join',
    'like',
    'maxof',
    'minof',
    'mod',
    'namespace',
    'new',
    'next',
    'nofetch',
    'notexists',
    'optimisticlock',
    'order',
    'outer',
    'pessimisticlock',
    'print',
    'private',
    'protected',
    'public',
    'readonly',
    'repeatableread',
    'retry',
    'return',
    'reverse',
    'select',
    'server',
    'setting',
    'static',
    'sum',
    'super',
    'switch',
    'this',
    'throw',
    'try',
    'ttsabort',
    'ttsbegin',
    'ttscommit',
    'unchecked',
    'update_recordset',
    'using',
    'validtimestate',
    'void',
    'where',
    'while'
  ];

  const KEYWORDS = {
    keyword: NORMAL_KEYWORDS,
    built_in: BUILT_IN_KEYWORDS,
    literal: LITERAL_KEYWORDS
  };

  const CLASS_DEFINITION = {
    variants: [
      { match: [
        /(class|interface)\s+/,
        IDENT_RE,
        /\s+(extends|implements)\s+/,
        IDENT_RE
      ] },
      { match: [
        /class\s+/,
        IDENT_RE
      ] }
    ],
    scope: {
      2: "title.class",
      4: "title.class.inherited"
    },
    keywords: KEYWORDS
  };

  return {
    name: 'X++',
    aliases: [ 'x++' ],
    keywords: KEYWORDS,
    contains: [
      hljs.C_LINE_COMMENT_MODE,
      hljs.C_BLOCK_COMMENT_MODE,
      hljs.APOS_STRING_MODE,
      hljs.QUOTE_STRING_MODE,
      hljs.C_NUMBER_MODE,
      {
        className: 'meta',
        begin: '#',
        end: '$'
      },
      CLASS_DEFINITION
    ]
  };
}

module.exports = axapta;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/bash.js":
/*!*********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/bash.js ***!
  \*********************************************************/
/***/ (function(module) {

/*
Language: Bash
Author: vah <vahtenberg@gmail.com>
Contributrors: Benjamin Pannell <contact@sierrasoftworks.com>
Website: https://www.gnu.org/software/bash/
Category: common
*/

/** @type LanguageFn */
function bash(hljs) {
  const regex = hljs.regex;
  const VAR = {};
  const BRACED_VAR = {
    begin: /\$\{/,
    end: /\}/,
    contains: [
      "self",
      {
        begin: /:-/,
        contains: [ VAR ]
      } // default values
    ]
  };
  Object.assign(VAR, {
    className: 'variable',
    variants: [
      { begin: regex.concat(/\$[\w\d#@][\w\d_]*/,
        // negative look-ahead tries to avoid matching patterns that are not
        // Perl at all like $ident$, @ident@, etc.
        `(?![\\w\\d])(?![$])`) },
      BRACED_VAR
    ]
  });

  const SUBST = {
    className: 'subst',
    begin: /\$\(/,
    end: /\)/,
    contains: [ hljs.BACKSLASH_ESCAPE ]
  };
  const HERE_DOC = {
    begin: /<<-?\s*(?=\w+)/,
    starts: { contains: [
      hljs.END_SAME_AS_BEGIN({
        begin: /(\w+)/,
        end: /(\w+)/,
        className: 'string'
      })
    ] }
  };
  const QUOTE_STRING = {
    className: 'string',
    begin: /"/,
    end: /"/,
    contains: [
      hljs.BACKSLASH_ESCAPE,
      VAR,
      SUBST
    ]
  };
  SUBST.contains.push(QUOTE_STRING);
  const ESCAPED_QUOTE = {
    className: '',
    begin: /\\"/

  };
  const APOS_STRING = {
    className: 'string',
    begin: /'/,
    end: /'/
  };
  const ARITHMETIC = {
    begin: /\$?\(\(/,
    end: /\)\)/,
    contains: [
      {
        begin: /\d+#[0-9a-f]+/,
        className: "number"
      },
      hljs.NUMBER_MODE,
      VAR
    ]
  };
  const SH_LIKE_SHELLS = [
    "fish",
    "bash",
    "zsh",
    "sh",
    "csh",
    "ksh",
    "tcsh",
    "dash",
    "scsh",
  ];
  const KNOWN_SHEBANG = hljs.SHEBANG({
    binary: `(${SH_LIKE_SHELLS.join("|")})`,
    relevance: 10
  });
  const FUNCTION = {
    className: 'function',
    begin: /\w[\w\d_]*\s*\(\s*\)\s*\{/,
    returnBegin: true,
    contains: [ hljs.inherit(hljs.TITLE_MODE, { begin: /\w[\w\d_]*/ }) ],
    relevance: 0
  };

  const KEYWORDS = [
    "if",
    "then",
    "else",
    "elif",
    "fi",
    "for",
    "while",
    "until",
    "in",
    "do",
    "done",
    "case",
    "esac",
    "function",
    "select"
  ];

  const LITERALS = [
    "true",
    "false"
  ];

  // to consume paths to prevent keyword matches inside them
  const PATH_MODE = { match: /(\/[a-z._-]+)+/ };

  // http://www.gnu.org/software/bash/manual/html_node/Shell-Builtin-Commands.html
  const SHELL_BUILT_INS = [
    "break",
    "cd",
    "continue",
    "eval",
    "exec",
    "exit",
    "export",
    "getopts",
    "hash",
    "pwd",
    "readonly",
    "return",
    "shift",
    "test",
    "times",
    "trap",
    "umask",
    "unset"
  ];

  const BASH_BUILT_INS = [
    "alias",
    "bind",
    "builtin",
    "caller",
    "command",
    "declare",
    "echo",
    "enable",
    "help",
    "let",
    "local",
    "logout",
    "mapfile",
    "printf",
    "read",
    "readarray",
    "source",
    "type",
    "typeset",
    "ulimit",
    "unalias"
  ];

  const ZSH_BUILT_INS = [
    "autoload",
    "bg",
    "bindkey",
    "bye",
    "cap",
    "chdir",
    "clone",
    "comparguments",
    "compcall",
    "compctl",
    "compdescribe",
    "compfiles",
    "compgroups",
    "compquote",
    "comptags",
    "comptry",
    "compvalues",
    "dirs",
    "disable",
    "disown",
    "echotc",
    "echoti",
    "emulate",
    "fc",
    "fg",
    "float",
    "functions",
    "getcap",
    "getln",
    "history",
    "integer",
    "jobs",
    "kill",
    "limit",
    "log",
    "noglob",
    "popd",
    "print",
    "pushd",
    "pushln",
    "rehash",
    "sched",
    "setcap",
    "setopt",
    "stat",
    "suspend",
    "ttyctl",
    "unfunction",
    "unhash",
    "unlimit",
    "unsetopt",
    "vared",
    "wait",
    "whence",
    "where",
    "which",
    "zcompile",
    "zformat",
    "zftp",
    "zle",
    "zmodload",
    "zparseopts",
    "zprof",
    "zpty",
    "zregexparse",
    "zsocket",
    "zstyle",
    "ztcp"
  ];

  const GNU_CORE_UTILS = [
    "chcon",
    "chgrp",
    "chown",
    "chmod",
    "cp",
    "dd",
    "df",
    "dir",
    "dircolors",
    "ln",
    "ls",
    "mkdir",
    "mkfifo",
    "mknod",
    "mktemp",
    "mv",
    "realpath",
    "rm",
    "rmdir",
    "shred",
    "sync",
    "touch",
    "truncate",
    "vdir",
    "b2sum",
    "base32",
    "base64",
    "cat",
    "cksum",
    "comm",
    "csplit",
    "cut",
    "expand",
    "fmt",
    "fold",
    "head",
    "join",
    "md5sum",
    "nl",
    "numfmt",
    "od",
    "paste",
    "ptx",
    "pr",
    "sha1sum",
    "sha224sum",
    "sha256sum",
    "sha384sum",
    "sha512sum",
    "shuf",
    "sort",
    "split",
    "sum",
    "tac",
    "tail",
    "tr",
    "tsort",
    "unexpand",
    "uniq",
    "wc",
    "arch",
    "basename",
    "chroot",
    "date",
    "dirname",
    "du",
    "echo",
    "env",
    "expr",
    "factor",
    // "false", // keyword literal already
    "groups",
    "hostid",
    "id",
    "link",
    "logname",
    "nice",
    "nohup",
    "nproc",
    "pathchk",
    "pinky",
    "printenv",
    "printf",
    "pwd",
    "readlink",
    "runcon",
    "seq",
    "sleep",
    "stat",
    "stdbuf",
    "stty",
    "tee",
    "test",
    "timeout",
    // "true", // keyword literal already
    "tty",
    "uname",
    "unlink",
    "uptime",
    "users",
    "who",
    "whoami",
    "yes"
  ];

  return {
    name: 'Bash',
    aliases: [ 'sh' ],
    keywords: {
      $pattern: /\b[a-z][a-z0-9._-]+\b/,
      keyword: KEYWORDS,
      literal: LITERALS,
      built_in: [
        ...SHELL_BUILT_INS,
        ...BASH_BUILT_INS,
        // Shell modifiers
        "set",
        "shopt",
        ...ZSH_BUILT_INS,
        ...GNU_CORE_UTILS
      ]
    },
    contains: [
      KNOWN_SHEBANG, // to catch known shells and boost relevancy
      hljs.SHEBANG(), // to catch unknown shells but still highlight the shebang
      FUNCTION,
      ARITHMETIC,
      hljs.HASH_COMMENT_MODE,
      HERE_DOC,
      PATH_MODE,
      QUOTE_STRING,
      ESCAPED_QUOTE,
      APOS_STRING,
      VAR
    ]
  };
}

module.exports = bash;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/basic.js":
/*!**********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/basic.js ***!
  \**********************************************************/
/***/ (function(module) {

/*
Language: BASIC
Author: Raphaël Assénat <raph@raphnet.net>
Description: Based on the BASIC reference from the Tandy 1000 guide
Website: https://en.wikipedia.org/wiki/Tandy_1000
*/

/** @type LanguageFn */
function basic(hljs) {
  const KEYWORDS = [
    "ABS",
    "ASC",
    "AND",
    "ATN",
    "AUTO|0",
    "BEEP",
    "BLOAD|10",
    "BSAVE|10",
    "CALL",
    "CALLS",
    "CDBL",
    "CHAIN",
    "CHDIR",
    "CHR$|10",
    "CINT",
    "CIRCLE",
    "CLEAR",
    "CLOSE",
    "CLS",
    "COLOR",
    "COM",
    "COMMON",
    "CONT",
    "COS",
    "CSNG",
    "CSRLIN",
    "CVD",
    "CVI",
    "CVS",
    "DATA",
    "DATE$",
    "DEFDBL",
    "DEFINT",
    "DEFSNG",
    "DEFSTR",
    "DEF|0",
    "SEG",
    "USR",
    "DELETE",
    "DIM",
    "DRAW",
    "EDIT",
    "END",
    "ENVIRON",
    "ENVIRON$",
    "EOF",
    "EQV",
    "ERASE",
    "ERDEV",
    "ERDEV$",
    "ERL",
    "ERR",
    "ERROR",
    "EXP",
    "FIELD",
    "FILES",
    "FIX",
    "FOR|0",
    "FRE",
    "GET",
    "GOSUB|10",
    "GOTO",
    "HEX$",
    "IF",
    "THEN",
    "ELSE|0",
    "INKEY$",
    "INP",
    "INPUT",
    "INPUT#",
    "INPUT$",
    "INSTR",
    "IMP",
    "INT",
    "IOCTL",
    "IOCTL$",
    "KEY",
    "ON",
    "OFF",
    "LIST",
    "KILL",
    "LEFT$",
    "LEN",
    "LET",
    "LINE",
    "LLIST",
    "LOAD",
    "LOC",
    "LOCATE",
    "LOF",
    "LOG",
    "LPRINT",
    "USING",
    "LSET",
    "MERGE",
    "MID$",
    "MKDIR",
    "MKD$",
    "MKI$",
    "MKS$",
    "MOD",
    "NAME",
    "NEW",
    "NEXT",
    "NOISE",
    "NOT",
    "OCT$",
    "ON",
    "OR",
    "PEN",
    "PLAY",
    "STRIG",
    "OPEN",
    "OPTION",
    "BASE",
    "OUT",
    "PAINT",
    "PALETTE",
    "PCOPY",
    "PEEK",
    "PMAP",
    "POINT",
    "POKE",
    "POS",
    "PRINT",
    "PRINT]",
    "PSET",
    "PRESET",
    "PUT",
    "RANDOMIZE",
    "READ",
    "REM",
    "RENUM",
    "RESET|0",
    "RESTORE",
    "RESUME",
    "RETURN|0",
    "RIGHT$",
    "RMDIR",
    "RND",
    "RSET",
    "RUN",
    "SAVE",
    "SCREEN",
    "SGN",
    "SHELL",
    "SIN",
    "SOUND",
    "SPACE$",
    "SPC",
    "SQR",
    "STEP",
    "STICK",
    "STOP",
    "STR$",
    "STRING$",
    "SWAP",
    "SYSTEM",
    "TAB",
    "TAN",
    "TIME$",
    "TIMER",
    "TROFF",
    "TRON",
    "TO",
    "USR",
    "VAL",
    "VARPTR",
    "VARPTR$",
    "VIEW",
    "WAIT",
    "WHILE",
    "WEND",
    "WIDTH",
    "WINDOW",
    "WRITE",
    "XOR"
  ];

  return {
    name: 'BASIC',
    case_insensitive: true,
    illegal: '^\.',
    // Support explicitly typed variables that end with $%! or #.
    keywords: {
      $pattern: '[a-zA-Z][a-zA-Z0-9_$%!#]*',
      keyword: KEYWORDS
    },
    contains: [
      hljs.QUOTE_STRING_MODE,
      hljs.COMMENT('REM', '$', { relevance: 10 }),
      hljs.COMMENT('\'', '$', { relevance: 0 }),
      {
        // Match line numbers
        className: 'symbol',
        begin: '^[0-9]+ ',
        relevance: 10
      },
      {
        // Match typed numeric constants (1000, 12.34!, 1.2e5, 1.5#, 1.2D2)
        className: 'number',
        begin: '\\b\\d+(\\.\\d+)?([edED]\\d+)?[#\!]?',
        relevance: 0
      },
      {
        // Match hexadecimal numbers (&Hxxxx)
        className: 'number',
        begin: '(&[hH][0-9a-fA-F]{1,4})'
      },
      {
        // Match octal numbers (&Oxxxxxx)
        className: 'number',
        begin: '(&[oO][0-7]{1,6})'
      }
    ]
  };
}

module.exports = basic;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/bnf.js":
/*!********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/bnf.js ***!
  \********************************************************/
/***/ (function(module) {

/*
Language: Backus–Naur Form
Website: https://en.wikipedia.org/wiki/Backus–Naur_form
Author: Oleg Efimov <efimovov@gmail.com>
*/

/** @type LanguageFn */
function bnf(hljs) {
  return {
    name: 'Backus–Naur Form',
    contains: [
      // Attribute
      {
        className: 'attribute',
        begin: /</,
        end: />/
      },
      // Specific
      {
        begin: /::=/,
        end: /$/,
        contains: [
          {
            begin: /</,
            end: />/
          },
          // Common
          hljs.C_LINE_COMMENT_MODE,
          hljs.C_BLOCK_COMMENT_MODE,
          hljs.APOS_STRING_MODE,
          hljs.QUOTE_STRING_MODE
        ]
      }
    ]
  };
}

module.exports = bnf;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/brainfuck.js":
/*!**************************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/brainfuck.js ***!
  \**************************************************************/
/***/ (function(module) {

/*
Language: Brainfuck
Author: Evgeny Stepanischev <imbolk@gmail.com>
Website: https://esolangs.org/wiki/Brainfuck
*/

/** @type LanguageFn */
function brainfuck(hljs) {
  const LITERAL = {
    className: 'literal',
    begin: /[+-]+/,
    relevance: 0
  };
  return {
    name: 'Brainfuck',
    aliases: [ 'bf' ],
    contains: [
      hljs.COMMENT(
        /[^\[\]\.,\+\-<> \r\n]/,
        /[\[\]\.,\+\-<> \r\n]/,
        {
          contains: [
            {
              match: /[ ]+[^\[\]\.,\+\-<> \r\n]/,
              relevance: 0
            }
          ],
          returnEnd: true,
          relevance: 0
        }
      ),
      {
        className: 'title',
        begin: '[\\[\\]]',
        relevance: 0
      },
      {
        className: 'string',
        begin: '[\\.,]',
        relevance: 0
      },
      {
        // this mode works as the only relevance counter
        // it looks ahead to find the start of a run of literals
        // so only the runs are counted as relevant
        begin: /(?=\+\+|--)/,
        contains: [ LITERAL ]
      },
      LITERAL
    ]
  };
}

module.exports = brainfuck;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/c.js":
/*!******************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/c.js ***!
  \******************************************************/
/***/ (function(module) {

/*
Language: C
Category: common, system
Website: https://en.wikipedia.org/wiki/C_(programming_language)
*/

/** @type LanguageFn */
function c(hljs) {
  const regex = hljs.regex;
  // added for historic reasons because `hljs.C_LINE_COMMENT_MODE` does
  // not include such support nor can we be sure all the grammars depending
  // on it would desire this behavior
  const C_LINE_COMMENT_MODE = hljs.COMMENT('//', '$', { contains: [ { begin: /\\\n/ } ] });
  const DECLTYPE_AUTO_RE = 'decltype\\(auto\\)';
  const NAMESPACE_RE = '[a-zA-Z_]\\w*::';
  const TEMPLATE_ARGUMENT_RE = '<[^<>]+>';
  const FUNCTION_TYPE_RE = '('
    + DECLTYPE_AUTO_RE + '|'
    + regex.optional(NAMESPACE_RE)
    + '[a-zA-Z_]\\w*' + regex.optional(TEMPLATE_ARGUMENT_RE)
  + ')';


  const TYPES = {
    className: 'type',
    variants: [
      { begin: '\\b[a-z\\d_]*_t\\b' },
      { match: /\batomic_[a-z]{3,6}\b/ }
    ]

  };

  // https://en.cppreference.com/w/cpp/language/escape
  // \\ \x \xFF \u2837 \u00323747 \374
  const CHARACTER_ESCAPES = '\\\\(x[0-9A-Fa-f]{2}|u[0-9A-Fa-f]{4,8}|[0-7]{3}|\\S)';
  const STRINGS = {
    className: 'string',
    variants: [
      {
        begin: '(u8?|U|L)?"',
        end: '"',
        illegal: '\\n',
        contains: [ hljs.BACKSLASH_ESCAPE ]
      },
      {
        begin: '(u8?|U|L)?\'(' + CHARACTER_ESCAPES + "|.)",
        end: '\'',
        illegal: '.'
      },
      hljs.END_SAME_AS_BEGIN({
        begin: /(?:u8?|U|L)?R"([^()\\ ]{0,16})\(/,
        end: /\)([^()\\ ]{0,16})"/
      })
    ]
  };

  const NUMBERS = {
    className: 'number',
    variants: [
      { begin: '\\b(0b[01\']+)' },
      { begin: '(-?)\\b([\\d\']+(\\.[\\d\']*)?|\\.[\\d\']+)((ll|LL|l|L)(u|U)?|(u|U)(ll|LL|l|L)?|f|F|b|B)' },
      { begin: '(-?)(\\b0[xX][a-fA-F0-9\']+|(\\b[\\d\']+(\\.[\\d\']*)?|\\.[\\d\']+)([eE][-+]?[\\d\']+)?)' }
    ],
    relevance: 0
  };

  const PREPROCESSOR = {
    className: 'meta',
    begin: /#\s*[a-z]+\b/,
    end: /$/,
    keywords: { keyword:
        'if else elif endif define undef warning error line '
        + 'pragma _Pragma ifdef ifndef include' },
    contains: [
      {
        begin: /\\\n/,
        relevance: 0
      },
      hljs.inherit(STRINGS, { className: 'string' }),
      {
        className: 'string',
        begin: /<.*?>/
      },
      C_LINE_COMMENT_MODE,
      hljs.C_BLOCK_COMMENT_MODE
    ]
  };

  const TITLE_MODE = {
    className: 'title',
    begin: regex.optional(NAMESPACE_RE) + hljs.IDENT_RE,
    relevance: 0
  };

  const FUNCTION_TITLE = regex.optional(NAMESPACE_RE) + hljs.IDENT_RE + '\\s*\\(';

  const C_KEYWORDS = [
    "asm",
    "auto",
    "break",
    "case",
    "continue",
    "default",
    "do",
    "else",
    "enum",
    "extern",
    "for",
    "fortran",
    "goto",
    "if",
    "inline",
    "register",
    "restrict",
    "return",
    "sizeof",
    "struct",
    "switch",
    "typedef",
    "union",
    "volatile",
    "while",
    "_Alignas",
    "_Alignof",
    "_Atomic",
    "_Generic",
    "_Noreturn",
    "_Static_assert",
    "_Thread_local",
    // aliases
    "alignas",
    "alignof",
    "noreturn",
    "static_assert",
    "thread_local",
    // not a C keyword but is, for all intents and purposes, treated exactly like one.
    "_Pragma"
  ];

  const C_TYPES = [
    "float",
    "double",
    "signed",
    "unsigned",
    "int",
    "short",
    "long",
    "char",
    "void",
    "_Bool",
    "_Complex",
    "_Imaginary",
    "_Decimal32",
    "_Decimal64",
    "_Decimal128",
    // modifiers
    "const",
    "static",
    // aliases
    "complex",
    "bool",
    "imaginary"
  ];

  const KEYWORDS = {
    keyword: C_KEYWORDS,
    type: C_TYPES,
    literal: 'true false NULL',
    // TODO: apply hinting work similar to what was done in cpp.js
    built_in: 'std string wstring cin cout cerr clog stdin stdout stderr stringstream istringstream ostringstream '
      + 'auto_ptr deque list queue stack vector map set pair bitset multiset multimap unordered_set '
      + 'unordered_map unordered_multiset unordered_multimap priority_queue make_pair array shared_ptr abort terminate abs acos '
      + 'asin atan2 atan calloc ceil cosh cos exit exp fabs floor fmod fprintf fputs free frexp '
      + 'fscanf future isalnum isalpha iscntrl isdigit isgraph islower isprint ispunct isspace isupper '
      + 'isxdigit tolower toupper labs ldexp log10 log malloc realloc memchr memcmp memcpy memset modf pow '
      + 'printf putchar puts scanf sinh sin snprintf sprintf sqrt sscanf strcat strchr strcmp '
      + 'strcpy strcspn strlen strncat strncmp strncpy strpbrk strrchr strspn strstr tanh tan '
      + 'vfprintf vprintf vsprintf endl initializer_list unique_ptr',
  };

  const EXPRESSION_CONTAINS = [
    PREPROCESSOR,
    TYPES,
    C_LINE_COMMENT_MODE,
    hljs.C_BLOCK_COMMENT_MODE,
    NUMBERS,
    STRINGS
  ];

  const EXPRESSION_CONTEXT = {
    // This mode covers expression context where we can't expect a function
    // definition and shouldn't highlight anything that looks like one:
    // `return some()`, `else if()`, `(x*sum(1, 2))`
    variants: [
      {
        begin: /=/,
        end: /;/
      },
      {
        begin: /\(/,
        end: /\)/
      },
      {
        beginKeywords: 'new throw return else',
        end: /;/
      }
    ],
    keywords: KEYWORDS,
    contains: EXPRESSION_CONTAINS.concat([
      {
        begin: /\(/,
        end: /\)/,
        keywords: KEYWORDS,
        contains: EXPRESSION_CONTAINS.concat([ 'self' ]),
        relevance: 0
      }
    ]),
    relevance: 0
  };

  const FUNCTION_DECLARATION = {
    begin: '(' + FUNCTION_TYPE_RE + '[\\*&\\s]+)+' + FUNCTION_TITLE,
    returnBegin: true,
    end: /[{;=]/,
    excludeEnd: true,
    keywords: KEYWORDS,
    illegal: /[^\w\s\*&:<>.]/,
    contains: [
      { // to prevent it from being confused as the function title
        begin: DECLTYPE_AUTO_RE,
        keywords: KEYWORDS,
        relevance: 0
      },
      {
        begin: FUNCTION_TITLE,
        returnBegin: true,
        contains: [ hljs.inherit(TITLE_MODE, { className: "title.function" }) ],
        relevance: 0
      },
      // allow for multiple declarations, e.g.:
      // extern void f(int), g(char);
      {
        relevance: 0,
        match: /,/
      },
      {
        className: 'params',
        begin: /\(/,
        end: /\)/,
        keywords: KEYWORDS,
        relevance: 0,
        contains: [
          C_LINE_COMMENT_MODE,
          hljs.C_BLOCK_COMMENT_MODE,
          STRINGS,
          NUMBERS,
          TYPES,
          // Count matching parentheses.
          {
            begin: /\(/,
            end: /\)/,
            keywords: KEYWORDS,
            relevance: 0,
            contains: [
              'self',
              C_LINE_COMMENT_MODE,
              hljs.C_BLOCK_COMMENT_MODE,
              STRINGS,
              NUMBERS,
              TYPES
            ]
          }
        ]
      },
      TYPES,
      C_LINE_COMMENT_MODE,
      hljs.C_BLOCK_COMMENT_MODE,
      PREPROCESSOR
    ]
  };

  return {
    name: "C",
    aliases: [ 'h' ],
    keywords: KEYWORDS,
    // Until differentiations are added between `c` and `cpp`, `c` will
    // not be auto-detected to avoid auto-detect conflicts between C and C++
    disableAutodetect: true,
    illegal: '</',
    contains: [].concat(
      EXPRESSION_CONTEXT,
      FUNCTION_DECLARATION,
      EXPRESSION_CONTAINS,
      [
        PREPROCESSOR,
        {
          begin: hljs.IDENT_RE + '::',
          keywords: KEYWORDS
        },
        {
          className: 'class',
          beginKeywords: 'enum class struct union',
          end: /[{;:<>=]/,
          contains: [
            { beginKeywords: "final class struct" },
            hljs.TITLE_MODE
          ]
        }
      ]),
    exports: {
      preprocessor: PREPROCESSOR,
      strings: STRINGS,
      keywords: KEYWORDS
    }
  };
}

module.exports = c;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/cal.js":
/*!********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/cal.js ***!
  \********************************************************/
/***/ (function(module) {

/*
Language: C/AL
Author: Kenneth Fuglsang Christensen <kfuglsang@gmail.com>
Description: Provides highlighting of Microsoft Dynamics NAV C/AL code files
Website: https://docs.microsoft.com/en-us/dynamics-nav/programming-in-c-al
*/

/** @type LanguageFn */
function cal(hljs) {
  const regex = hljs.regex;
  const KEYWORDS = [
    "div",
    "mod",
    "in",
    "and",
    "or",
    "not",
    "xor",
    "asserterror",
    "begin",
    "case",
    "do",
    "downto",
    "else",
    "end",
    "exit",
    "for",
    "local",
    "if",
    "of",
    "repeat",
    "then",
    "to",
    "until",
    "while",
    "with",
    "var"
  ];
  const LITERALS = 'false true';
  const COMMENT_MODES = [
    hljs.C_LINE_COMMENT_MODE,
    hljs.COMMENT(
      /\{/,
      /\}/,
      { relevance: 0 }
    ),
    hljs.COMMENT(
      /\(\*/,
      /\*\)/,
      { relevance: 10 }
    )
  ];
  const STRING = {
    className: 'string',
    begin: /'/,
    end: /'/,
    contains: [ { begin: /''/ } ]
  };
  const CHAR_STRING = {
    className: 'string',
    begin: /(#\d+)+/
  };
  const DATE = {
    className: 'number',
    begin: '\\b\\d+(\\.\\d+)?(DT|D|T)',
    relevance: 0
  };
  const DBL_QUOTED_VARIABLE = {
    className: 'string', // not a string technically but makes sense to be highlighted in the same style
    begin: '"',
    end: '"'
  };

  const PROCEDURE = {
    match: [
      /procedure/,
      /\s+/,
      /[a-zA-Z_][\w@]*/,
      /\s*/
    ],
    scope: {
      1: "keyword",
      3: "title.function"
    },
    contains: [
      {
        className: 'params',
        begin: /\(/,
        end: /\)/,
        keywords: KEYWORDS,
        contains: [
          STRING,
          CHAR_STRING,
          hljs.NUMBER_MODE
        ]
      },
      ...COMMENT_MODES
    ]
  };

  const OBJECT_TYPES = [
    "Table",
    "Form",
    "Report",
    "Dataport",
    "Codeunit",
    "XMLport",
    "MenuSuite",
    "Page",
    "Query"
  ];
  const OBJECT = {
    match: [
      /OBJECT/,
      /\s+/,
      regex.either(...OBJECT_TYPES),
      /\s+/,
      /\d+/,
      /\s+(?=[^\s])/,
      /.*/,
      /$/
    ],
    relevance: 3,
    scope: {
      1: "keyword",
      3: "type",
      5: "number",
      7: "title"
    }
  };

  const PROPERTY = {
    match: /[\w]+(?=\=)/,
    scope: "attribute",
    relevance: 0
  };

  return {
    name: 'C/AL',
    case_insensitive: true,
    keywords: {
      keyword: KEYWORDS,
      literal: LITERALS
    },
    illegal: /\/\*/,
    contains: [
      PROPERTY,
      STRING,
      CHAR_STRING,
      DATE,
      DBL_QUOTED_VARIABLE,
      hljs.NUMBER_MODE,
      OBJECT,
      PROCEDURE
    ]
  };
}

module.exports = cal;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/capnproto.js":
/*!**************************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/capnproto.js ***!
  \**************************************************************/
/***/ (function(module) {

/*
Language: Cap’n Proto
Author: Oleg Efimov <efimovov@gmail.com>
Description: Cap’n Proto message definition format
Website: https://capnproto.org/capnp-tool.html
Category: protocols
*/

/** @type LanguageFn */
function capnproto(hljs) {
  const KEYWORDS = [
    "struct",
    "enum",
    "interface",
    "union",
    "group",
    "import",
    "using",
    "const",
    "annotation",
    "extends",
    "in",
    "of",
    "on",
    "as",
    "with",
    "from",
    "fixed"
  ];
  const TYPES = [
    "Void",
    "Bool",
    "Int8",
    "Int16",
    "Int32",
    "Int64",
    "UInt8",
    "UInt16",
    "UInt32",
    "UInt64",
    "Float32",
    "Float64",
    "Text",
    "Data",
    "AnyPointer",
    "AnyStruct",
    "Capability",
    "List"
  ];
  const LITERALS = [
    "true",
    "false"
  ];
  const CLASS_DEFINITION = {
    variants: [
      { match: [
        /(struct|enum|interface)/,
        /\s+/,
        hljs.IDENT_RE
      ] },
      { match: [
        /extends/,
        /\s*\(/,
        hljs.IDENT_RE,
        /\s*\)/
      ] }
    ],
    scope: {
      1: "keyword",
      3: "title.class"
    }
  };
  return {
    name: 'Cap’n Proto',
    aliases: [ 'capnp' ],
    keywords: {
      keyword: KEYWORDS,
      type: TYPES,
      literal: LITERALS
    },
    contains: [
      hljs.QUOTE_STRING_MODE,
      hljs.NUMBER_MODE,
      hljs.HASH_COMMENT_MODE,
      {
        className: 'meta',
        begin: /@0x[\w\d]{16};/,
        illegal: /\n/
      },
      {
        className: 'symbol',
        begin: /@\d+\b/
      },
      CLASS_DEFINITION
    ]
  };
}

module.exports = capnproto;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/ceylon.js":
/*!***********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/ceylon.js ***!
  \***********************************************************/
/***/ (function(module) {

/*
Language: Ceylon
Author: Lucas Werkmeister <mail@lucaswerkmeister.de>
Website: https://ceylon-lang.org
*/

/** @type LanguageFn */
function ceylon(hljs) {
  // 2.3. Identifiers and keywords
  const KEYWORDS = [
    "assembly",
    "module",
    "package",
    "import",
    "alias",
    "class",
    "interface",
    "object",
    "given",
    "value",
    "assign",
    "void",
    "function",
    "new",
    "of",
    "extends",
    "satisfies",
    "abstracts",
    "in",
    "out",
    "return",
    "break",
    "continue",
    "throw",
    "assert",
    "dynamic",
    "if",
    "else",
    "switch",
    "case",
    "for",
    "while",
    "try",
    "catch",
    "finally",
    "then",
    "let",
    "this",
    "outer",
    "super",
    "is",
    "exists",
    "nonempty"
  ];
  // 7.4.1 Declaration Modifiers
  const DECLARATION_MODIFIERS = [
    "shared",
    "abstract",
    "formal",
    "default",
    "actual",
    "variable",
    "late",
    "native",
    "deprecated",
    "final",
    "sealed",
    "annotation",
    "suppressWarnings",
    "small"
  ];
  // 7.4.2 Documentation
  const DOCUMENTATION = [
    "doc",
    "by",
    "license",
    "see",
    "throws",
    "tagged"
  ];
  const SUBST = {
    className: 'subst',
    excludeBegin: true,
    excludeEnd: true,
    begin: /``/,
    end: /``/,
    keywords: KEYWORDS,
    relevance: 10
  };
  const EXPRESSIONS = [
    {
      // verbatim string
      className: 'string',
      begin: '"""',
      end: '"""',
      relevance: 10
    },
    {
      // string literal or template
      className: 'string',
      begin: '"',
      end: '"',
      contains: [ SUBST ]
    },
    {
      // character literal
      className: 'string',
      begin: "'",
      end: "'"
    },
    {
      // numeric literal
      className: 'number',
      begin: '#[0-9a-fA-F_]+|\\$[01_]+|[0-9_]+(?:\\.[0-9_](?:[eE][+-]?\\d+)?)?[kMGTPmunpf]?',
      relevance: 0
    }
  ];
  SUBST.contains = EXPRESSIONS;

  return {
    name: 'Ceylon',
    keywords: {
      keyword: KEYWORDS.concat(DECLARATION_MODIFIERS),
      meta: DOCUMENTATION
    },
    illegal: '\\$[^01]|#[^0-9a-fA-F]',
    contains: [
      hljs.C_LINE_COMMENT_MODE,
      hljs.COMMENT('/\\*', '\\*/', { contains: [ 'self' ] }),
      {
        // compiler annotation
        className: 'meta',
        begin: '@[a-z]\\w*(?::"[^"]*")?'
      }
    ].concat(EXPRESSIONS)
  };
}

module.exports = ceylon;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/clean.js":
/*!**********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/clean.js ***!
  \**********************************************************/
/***/ (function(module) {

/*
Language: Clean
Author: Camil Staps <info@camilstaps.nl>
Category: functional
Website: http://clean.cs.ru.nl
*/

/** @type LanguageFn */
function clean(hljs) {
  const KEYWORDS = [
    "if",
    "let",
    "in",
    "with",
    "where",
    "case",
    "of",
    "class",
    "instance",
    "otherwise",
    "implementation",
    "definition",
    "system",
    "module",
    "from",
    "import",
    "qualified",
    "as",
    "special",
    "code",
    "inline",
    "foreign",
    "export",
    "ccall",
    "stdcall",
    "generic",
    "derive",
    "infix",
    "infixl",
    "infixr"
  ];
  return {
    name: 'Clean',
    aliases: [
      'icl',
      'dcl'
    ],
    keywords: {
      keyword: KEYWORDS,
      built_in:
        'Int Real Char Bool',
      literal:
        'True False'
    },
    contains: [
      hljs.C_LINE_COMMENT_MODE,
      hljs.C_BLOCK_COMMENT_MODE,
      hljs.APOS_STRING_MODE,
      hljs.QUOTE_STRING_MODE,
      hljs.C_NUMBER_MODE,
      { // relevance booster
        begin: '->|<-[|:]?|#!?|>>=|\\{\\||\\|\\}|:==|=:|<>' }
    ]
  };
}

module.exports = clean;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/clojure-repl.js":
/*!*****************************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/clojure-repl.js ***!
  \*****************************************************************/
/***/ (function(module) {

/*
Language: Clojure REPL
Description: Clojure REPL sessions
Author: Ivan Sagalaev <maniac@softwaremaniacs.org>
Requires: clojure.js
Website: https://clojure.org
Category: lisp
*/

/** @type LanguageFn */
function clojureRepl(hljs) {
  return {
    name: 'Clojure REPL',
    contains: [
      {
        className: 'meta.prompt',
        begin: /^([\w.-]+|\s*#_)?=>/,
        starts: {
          end: /$/,
          subLanguage: 'clojure'
        }
      }
    ]
  };
}

module.exports = clojureRepl;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/clojure.js":
/*!************************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/clojure.js ***!
  \************************************************************/
/***/ (function(module) {

/*
Language: Clojure
Description: Clojure syntax (based on lisp.js)
Author: mfornos
Website: https://clojure.org
Category: lisp
*/

/** @type LanguageFn */
function clojure(hljs) {
  const SYMBOLSTART = 'a-zA-Z_\\-!.?+*=<>&\'';
  const SYMBOL_RE = '[#]?[' + SYMBOLSTART + '][' + SYMBOLSTART + '0-9/;:$#]*';
  const globals = 'def defonce defprotocol defstruct defmulti defmethod defn- defn defmacro deftype defrecord';
  const keywords = {
    $pattern: SYMBOL_RE,
    built_in:
      // Clojure keywords
      globals + ' '
      + 'cond apply if-not if-let if not not= =|0 <|0 >|0 <=|0 >=|0 ==|0 +|0 /|0 *|0 -|0 rem '
      + 'quot neg? pos? delay? symbol? keyword? true? false? integer? empty? coll? list? '
      + 'set? ifn? fn? associative? sequential? sorted? counted? reversible? number? decimal? '
      + 'class? distinct? isa? float? rational? reduced? ratio? odd? even? char? seq? vector? '
      + 'string? map? nil? contains? zero? instance? not-every? not-any? libspec? -> ->> .. . '
      + 'inc compare do dotimes mapcat take remove take-while drop letfn drop-last take-last '
      + 'drop-while while intern condp case reduced cycle split-at split-with repeat replicate '
      + 'iterate range merge zipmap declare line-seq sort comparator sort-by dorun doall nthnext '
      + 'nthrest partition eval doseq await await-for let agent atom send send-off release-pending-sends '
      + 'add-watch mapv filterv remove-watch agent-error restart-agent set-error-handler error-handler '
      + 'set-error-mode! error-mode shutdown-agents quote var fn loop recur throw try monitor-enter '
      + 'monitor-exit macroexpand macroexpand-1 for dosync and or '
      + 'when when-not when-let comp juxt partial sequence memoize constantly complement identity assert '
      + 'peek pop doto proxy first rest cons cast coll last butlast '
      + 'sigs reify second ffirst fnext nfirst nnext meta with-meta ns in-ns create-ns import '
      + 'refer keys select-keys vals key val rseq name namespace promise into transient persistent! conj! '
      + 'assoc! dissoc! pop! disj! use class type num float double short byte boolean bigint biginteger '
      + 'bigdec print-method print-dup throw-if printf format load compile get-in update-in pr pr-on newline '
      + 'flush read slurp read-line subvec with-open memfn time re-find re-groups rand-int rand mod locking '
      + 'assert-valid-fdecl alias resolve ref deref refset swap! reset! set-validator! compare-and-set! alter-meta! '
      + 'reset-meta! commute get-validator alter ref-set ref-history-count ref-min-history ref-max-history ensure sync io! '
      + 'new next conj set! to-array future future-call into-array aset gen-class reduce map filter find empty '
      + 'hash-map hash-set sorted-map sorted-map-by sorted-set sorted-set-by vec vector seq flatten reverse assoc dissoc list '
      + 'disj get union difference intersection extend extend-type extend-protocol int nth delay count concat chunk chunk-buffer '
      + 'chunk-append chunk-first chunk-rest max min dec unchecked-inc-int unchecked-inc unchecked-dec-inc unchecked-dec unchecked-negate '
      + 'unchecked-add-int unchecked-add unchecked-subtract-int unchecked-subtract chunk-next chunk-cons chunked-seq? prn vary-meta '
      + 'lazy-seq spread list* str find-keyword keyword symbol gensym force rationalize'
  };

  const SYMBOL = {
    begin: SYMBOL_RE,
    relevance: 0
  };
  const NUMBER = {
    scope: 'number',
    relevance: 0,
    variants: [
      { match: /[-+]?0[xX][0-9a-fA-F]+N?/ }, // hexadecimal                 // 0x2a
      { match: /[-+]?0[0-7]+N?/ }, // octal                       // 052
      { match: /[-+]?[1-9][0-9]?[rR][0-9a-zA-Z]+N?/ }, // variable radix from 2 to 36 // 2r101010, 8r52, 36r16
      { match: /[-+]?[0-9]+\/[0-9]+N?/ }, // ratio                       // 1/2
      { match: /[-+]?[0-9]+((\.[0-9]*([eE][+-]?[0-9]+)?M?)|([eE][+-]?[0-9]+M?|M))/ }, // float        // 0.42 4.2E-1M 42E1 42M
      { match: /[-+]?([1-9][0-9]*|0)N?/ }, // int (don't match leading 0) // 42 42N
    ]
  };
  const CHARACTER = {
    scope: 'character',
    variants: [
      { match: /\\o[0-3]?[0-7]{1,2}/ }, // Unicode Octal 0 - 377
      { match: /\\u[0-9a-fA-F]{4}/ }, // Unicode Hex 0000 - FFFF
      { match: /\\(newline|space|tab|formfeed|backspace|return)/ }, // special characters
      {
        match: /\\\S/,
        relevance: 0
      } // any non-whitespace char
    ]
  };
  const REGEX = {
    scope: 'regex',
    begin: /#"/,
    end: /"/,
    contains: [ hljs.BACKSLASH_ESCAPE ]
  };
  const STRING = hljs.inherit(hljs.QUOTE_STRING_MODE, { illegal: null });
  const COMMA = {
    scope: 'punctuation',
    match: /,/,
    relevance: 0
  };
  const COMMENT = hljs.COMMENT(
    ';',
    '$',
    { relevance: 0 }
  );
  const LITERAL = {
    className: 'literal',
    begin: /\b(true|false|nil)\b/
  };
  const COLLECTION = {
    begin: "\\[|(#::?" + SYMBOL_RE + ")?\\{",
    end: '[\\]\\}]',
    relevance: 0
  };
  const KEY = {
    className: 'symbol',
    begin: '[:]{1,2}' + SYMBOL_RE
  };
  const LIST = {
    begin: '\\(',
    end: '\\)'
  };
  const BODY = {
    endsWithParent: true,
    relevance: 0
  };
  const NAME = {
    keywords: keywords,
    className: 'name',
    begin: SYMBOL_RE,
    relevance: 0,
    starts: BODY
  };
  const DEFAULT_CONTAINS = [
    COMMA,
    LIST,
    CHARACTER,
    REGEX,
    STRING,
    COMMENT,
    KEY,
    COLLECTION,
    NUMBER,
    LITERAL,
    SYMBOL
  ];

  const GLOBAL = {
    beginKeywords: globals,
    keywords: {
      $pattern: SYMBOL_RE,
      keyword: globals
    },
    end: '(\\[|#|\\d|"|:|\\{|\\)|\\(|$)',
    contains: [
      {
        className: 'title',
        begin: SYMBOL_RE,
        relevance: 0,
        excludeEnd: true,
        // we can only have a single title
        endsParent: true
      }
    ].concat(DEFAULT_CONTAINS)
  };

  LIST.contains = [
    GLOBAL,
    NAME,
    BODY
  ];
  BODY.contains = DEFAULT_CONTAINS;
  COLLECTION.contains = DEFAULT_CONTAINS;

  return {
    name: 'Clojure',
    aliases: [
      'clj',
      'edn'
    ],
    illegal: /\S/,
    contains: [
      COMMA,
      LIST,
      CHARACTER,
      REGEX,
      STRING,
      COMMENT,
      KEY,
      COLLECTION,
      NUMBER,
      LITERAL
    ]
  };
}

module.exports = clojure;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/cmake.js":
/*!**********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/cmake.js ***!
  \**********************************************************/
/***/ (function(module) {

/*
Language: CMake
Description: CMake is an open-source cross-platform system for build automation.
Author: Igor Kalnitsky <igor@kalnitsky.org>
Website: https://cmake.org
*/

/** @type LanguageFn */
function cmake(hljs) {
  return {
    name: 'CMake',
    aliases: [ 'cmake.in' ],
    case_insensitive: true,
    keywords: { keyword:
        // scripting commands
        'break cmake_host_system_information cmake_minimum_required cmake_parse_arguments '
        + 'cmake_policy configure_file continue elseif else endforeach endfunction endif endmacro '
        + 'endwhile execute_process file find_file find_library find_package find_path '
        + 'find_program foreach function get_cmake_property get_directory_property '
        + 'get_filename_component get_property if include include_guard list macro '
        + 'mark_as_advanced math message option return separate_arguments '
        + 'set_directory_properties set_property set site_name string unset variable_watch while '
        // project commands
        + 'add_compile_definitions add_compile_options add_custom_command add_custom_target '
        + 'add_definitions add_dependencies add_executable add_library add_link_options '
        + 'add_subdirectory add_test aux_source_directory build_command create_test_sourcelist '
        + 'define_property enable_language enable_testing export fltk_wrap_ui '
        + 'get_source_file_property get_target_property get_test_property include_directories '
        + 'include_external_msproject include_regular_expression install link_directories '
        + 'link_libraries load_cache project qt_wrap_cpp qt_wrap_ui remove_definitions '
        + 'set_source_files_properties set_target_properties set_tests_properties source_group '
        + 'target_compile_definitions target_compile_features target_compile_options '
        + 'target_include_directories target_link_directories target_link_libraries '
        + 'target_link_options target_sources try_compile try_run '
        // CTest commands
        + 'ctest_build ctest_configure ctest_coverage ctest_empty_binary_directory ctest_memcheck '
        + 'ctest_read_custom_files ctest_run_script ctest_sleep ctest_start ctest_submit '
        + 'ctest_test ctest_update ctest_upload '
        // deprecated commands
        + 'build_name exec_program export_library_dependencies install_files install_programs '
        + 'install_targets load_command make_directory output_required_files remove '
        + 'subdir_depends subdirs use_mangled_mesa utility_source variable_requires write_file '
        + 'qt5_use_modules qt5_use_package qt5_wrap_cpp '
        // core keywords
        + 'on off true false and or not command policy target test exists is_newer_than '
        + 'is_directory is_symlink is_absolute matches less greater equal less_equal '
        + 'greater_equal strless strgreater strequal strless_equal strgreater_equal version_less '
        + 'version_greater version_equal version_less_equal version_greater_equal in_list defined' },
    contains: [
      {
        className: 'variable',
        begin: /\$\{/,
        end: /\}/
      },
      hljs.COMMENT(/#\[\[/, /]]/),
      hljs.HASH_COMMENT_MODE,
      hljs.QUOTE_STRING_MODE,
      hljs.NUMBER_MODE
    ]
  };
}

module.exports = cmake;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/coffeescript.js":
/*!*****************************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/coffeescript.js ***!
  \*****************************************************************/
/***/ (function(module) {

const KEYWORDS = [
  "as", // for exports
  "in",
  "of",
  "if",
  "for",
  "while",
  "finally",
  "var",
  "new",
  "function",
  "do",
  "return",
  "void",
  "else",
  "break",
  "catch",
  "instanceof",
  "with",
  "throw",
  "case",
  "default",
  "try",
  "switch",
  "continue",
  "typeof",
  "delete",
  "let",
  "yield",
  "const",
  "class",
  // JS handles these with a special rule
  // "get",
  // "set",
  "debugger",
  "async",
  "await",
  "static",
  "import",
  "from",
  "export",
  "extends"
];
const LITERALS = [
  "true",
  "false",
  "null",
  "undefined",
  "NaN",
  "Infinity"
];

// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects
const TYPES = [
  // Fundamental objects
  "Object",
  "Function",
  "Boolean",
  "Symbol",
  // numbers and dates
  "Math",
  "Date",
  "Number",
  "BigInt",
  // text
  "String",
  "RegExp",
  // Indexed collections
  "Array",
  "Float32Array",
  "Float64Array",
  "Int8Array",
  "Uint8Array",
  "Uint8ClampedArray",
  "Int16Array",
  "Int32Array",
  "Uint16Array",
  "Uint32Array",
  "BigInt64Array",
  "BigUint64Array",
  // Keyed collections
  "Set",
  "Map",
  "WeakSet",
  "WeakMap",
  // Structured data
  "ArrayBuffer",
  "SharedArrayBuffer",
  "Atomics",
  "DataView",
  "JSON",
  // Control abstraction objects
  "Promise",
  "Generator",
  "GeneratorFunction",
  "AsyncFunction",
  // Reflection
  "Reflect",
  "Proxy",
  // Internationalization
  "Intl",
  // WebAssembly
  "WebAssembly"
];

const ERROR_TYPES = [
  "Error",
  "EvalError",
  "InternalError",
  "RangeError",
  "ReferenceError",
  "SyntaxError",
  "TypeError",
  "URIError"
];

const BUILT_IN_GLOBALS = [
  "setInterval",
  "setTimeout",
  "clearInterval",
  "clearTimeout",

  "require",
  "exports",

  "eval",
  "isFinite",
  "isNaN",
  "parseFloat",
  "parseInt",
  "decodeURI",
  "decodeURIComponent",
  "encodeURI",
  "encodeURIComponent",
  "escape",
  "unescape"
];

const BUILT_INS = [].concat(
  BUILT_IN_GLOBALS,
  TYPES,
  ERROR_TYPES
);

/*
Language: CoffeeScript
Author: Dmytrii Nagirniak <dnagir@gmail.com>
Contributors: Oleg Efimov <efimovov@gmail.com>, Cédric Néhémie <cedric.nehemie@gmail.com>
Description: CoffeeScript is a programming language that transcompiles to JavaScript. For info about language see http://coffeescript.org/
Category: scripting
Website: https://coffeescript.org
*/

/** @type LanguageFn */
function coffeescript(hljs) {
  const COFFEE_BUILT_INS = [
    'npm',
    'print'
  ];
  const COFFEE_LITERALS = [
    'yes',
    'no',
    'on',
    'off'
  ];
  const COFFEE_KEYWORDS = [
    'then',
    'unless',
    'until',
    'loop',
    'by',
    'when',
    'and',
    'or',
    'is',
    'isnt',
    'not'
  ];
  const NOT_VALID_KEYWORDS = [
    "var",
    "const",
    "let",
    "function",
    "static"
  ];
  const excluding = (list) =>
    (kw) => !list.includes(kw);
  const KEYWORDS$1 = {
    keyword: KEYWORDS.concat(COFFEE_KEYWORDS).filter(excluding(NOT_VALID_KEYWORDS)),
    literal: LITERALS.concat(COFFEE_LITERALS),
    built_in: BUILT_INS.concat(COFFEE_BUILT_INS)
  };
  const JS_IDENT_RE = '[A-Za-z$_][0-9A-Za-z$_]*';
  const SUBST = {
    className: 'subst',
    begin: /#\{/,
    end: /\}/,
    keywords: KEYWORDS$1
  };
  const EXPRESSIONS = [
    hljs.BINARY_NUMBER_MODE,
    hljs.inherit(hljs.C_NUMBER_MODE, { starts: {
      end: '(\\s*/)?',
      relevance: 0
    } }), // a number tries to eat the following slash to prevent treating it as a regexp
    {
      className: 'string',
      variants: [
        {
          begin: /'''/,
          end: /'''/,
          contains: [ hljs.BACKSLASH_ESCAPE ]
        },
        {
          begin: /'/,
          end: /'/,
          contains: [ hljs.BACKSLASH_ESCAPE ]
        },
        {
          begin: /"""/,
          end: /"""/,
          contains: [
            hljs.BACKSLASH_ESCAPE,
            SUBST
          ]
        },
        {
          begin: /"/,
          end: /"/,
          contains: [
            hljs.BACKSLASH_ESCAPE,
            SUBST
          ]
        }
      ]
    },
    {
      className: 'regexp',
      variants: [
        {
          begin: '///',
          end: '///',
          contains: [
            SUBST,
            hljs.HASH_COMMENT_MODE
          ]
        },
        {
          begin: '//[gim]{0,3}(?=\\W)',
          relevance: 0
        },
        {
          // regex can't start with space to parse x / 2 / 3 as two divisions
          // regex can't start with *, and it supports an "illegal" in the main mode
          begin: /\/(?![ *]).*?(?![\\]).\/[gim]{0,3}(?=\W)/ }
      ]
    },
    { begin: '@' + JS_IDENT_RE // relevance booster
    },
    {
      subLanguage: 'javascript',
      excludeBegin: true,
      excludeEnd: true,
      variants: [
        {
          begin: '```',
          end: '```'
        },
        {
          begin: '`',
          end: '`'
        }
      ]
    }
  ];
  SUBST.contains = EXPRESSIONS;

  const TITLE = hljs.inherit(hljs.TITLE_MODE, { begin: JS_IDENT_RE });
  const POSSIBLE_PARAMS_RE = '(\\(.*\\)\\s*)?\\B[-=]>';
  const PARAMS = {
    className: 'params',
    begin: '\\([^\\(]',
    returnBegin: true,
    /* We need another contained nameless mode to not have every nested
    pair of parens to be called "params" */
    contains: [
      {
        begin: /\(/,
        end: /\)/,
        keywords: KEYWORDS$1,
        contains: [ 'self' ].concat(EXPRESSIONS)
      }
    ]
  };

  const CLASS_DEFINITION = {
    variants: [
      { match: [
        /class\s+/,
        JS_IDENT_RE,
        /\s+extends\s+/,
        JS_IDENT_RE
      ] },
      { match: [
        /class\s+/,
        JS_IDENT_RE
      ] }
    ],
    scope: {
      2: "title.class",
      4: "title.class.inherited"
    },
    keywords: KEYWORDS$1
  };

  return {
    name: 'CoffeeScript',
    aliases: [
      'coffee',
      'cson',
      'iced'
    ],
    keywords: KEYWORDS$1,
    illegal: /\/\*/,
    contains: [
      ...EXPRESSIONS,
      hljs.COMMENT('###', '###'),
      hljs.HASH_COMMENT_MODE,
      {
        className: 'function',
        begin: '^\\s*' + JS_IDENT_RE + '\\s*=\\s*' + POSSIBLE_PARAMS_RE,
        end: '[-=]>',
        returnBegin: true,
        contains: [
          TITLE,
          PARAMS
        ]
      },
      {
        // anonymous function start
        begin: /[:\(,=]\s*/,
        relevance: 0,
        contains: [
          {
            className: 'function',
            begin: POSSIBLE_PARAMS_RE,
            end: '[-=]>',
            returnBegin: true,
            contains: [ PARAMS ]
          }
        ]
      },
      CLASS_DEFINITION,
      {
        begin: JS_IDENT_RE + ':',
        end: ':',
        returnBegin: true,
        returnEnd: true,
        relevance: 0
      }
    ]
  };
}

module.exports = coffeescript;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/coq.js":
/*!********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/coq.js ***!
  \********************************************************/
/***/ (function(module) {

/*
Language: Coq
Author: Stephan Boyer <stephan@stephanboyer.com>
Category: functional
Website: https://coq.inria.fr
*/

/** @type LanguageFn */
function coq(hljs) {
  const KEYWORDS = [
    "_|0",
    "as",
    "at",
    "cofix",
    "else",
    "end",
    "exists",
    "exists2",
    "fix",
    "for",
    "forall",
    "fun",
    "if",
    "IF",
    "in",
    "let",
    "match",
    "mod",
    "Prop",
    "return",
    "Set",
    "then",
    "Type",
    "using",
    "where",
    "with",
    "Abort",
    "About",
    "Add",
    "Admit",
    "Admitted",
    "All",
    "Arguments",
    "Assumptions",
    "Axiom",
    "Back",
    "BackTo",
    "Backtrack",
    "Bind",
    "Blacklist",
    "Canonical",
    "Cd",
    "Check",
    "Class",
    "Classes",
    "Close",
    "Coercion",
    "Coercions",
    "CoFixpoint",
    "CoInductive",
    "Collection",
    "Combined",
    "Compute",
    "Conjecture",
    "Conjectures",
    "Constant",
    "constr",
    "Constraint",
    "Constructors",
    "Context",
    "Corollary",
    "CreateHintDb",
    "Cut",
    "Declare",
    "Defined",
    "Definition",
    "Delimit",
    "Dependencies",
    "Dependent",
    "Derive",
    "Drop",
    "eauto",
    "End",
    "Equality",
    "Eval",
    "Example",
    "Existential",
    "Existentials",
    "Existing",
    "Export",
    "exporting",
    "Extern",
    "Extract",
    "Extraction",
    "Fact",
    "Field",
    "Fields",
    "File",
    "Fixpoint",
    "Focus",
    "for",
    "From",
    "Function",
    "Functional",
    "Generalizable",
    "Global",
    "Goal",
    "Grab",
    "Grammar",
    "Graph",
    "Guarded",
    "Heap",
    "Hint",
    "HintDb",
    "Hints",
    "Hypotheses",
    "Hypothesis",
    "ident",
    "Identity",
    "If",
    "Immediate",
    "Implicit",
    "Import",
    "Include",
    "Inductive",
    "Infix",
    "Info",
    "Initial",
    "Inline",
    "Inspect",
    "Instance",
    "Instances",
    "Intro",
    "Intros",
    "Inversion",
    "Inversion_clear",
    "Language",
    "Left",
    "Lemma",
    "Let",
    "Libraries",
    "Library",
    "Load",
    "LoadPath",
    "Local",
    "Locate",
    "Ltac",
    "ML",
    "Mode",
    "Module",
    "Modules",
    "Monomorphic",
    "Morphism",
    "Next",
    "NoInline",
    "Notation",
    "Obligation",
    "Obligations",
    "Opaque",
    "Open",
    "Optimize",
    "Options",
    "Parameter",
    "Parameters",
    "Parametric",
    "Path",
    "Paths",
    "pattern",
    "Polymorphic",
    "Preterm",
    "Print",
    "Printing",
    "Program",
    "Projections",
    "Proof",
    "Proposition",
    "Pwd",
    "Qed",
    "Quit",
    "Rec",
    "Record",
    "Recursive",
    "Redirect",
    "Relation",
    "Remark",
    "Remove",
    "Require",
    "Reserved",
    "Reset",
    "Resolve",
    "Restart",
    "Rewrite",
    "Right",
    "Ring",
    "Rings",
    "Save",
    "Scheme",
    "Scope",
    "Scopes",
    "Script",
    "Search",
    "SearchAbout",
    "SearchHead",
    "SearchPattern",
    "SearchRewrite",
    "Section",
    "Separate",
    "Set",
    "Setoid",
    "Show",
    "Solve",
    "Sorted",
    "Step",
    "Strategies",
    "Strategy",
    "Structure",
    "SubClass",
    "Table",
    "Tables",
    "Tactic",
    "Term",
    "Test",
    "Theorem",
    "Time",
    "Timeout",
    "Transparent",
    "Type",
    "Typeclasses",
    "Types",
    "Undelimit",
    "Undo",
    "Unfocus",
    "Unfocused",
    "Unfold",
    "Universe",
    "Universes",
    "Unset",
    "Unshelve",
    "using",
    "Variable",
    "Variables",
    "Variant",
    "Verbose",
    "Visibility",
    "where",
    "with"
  ];
  const BUILT_INS = [
    "abstract",
    "absurd",
    "admit",
    "after",
    "apply",
    "as",
    "assert",
    "assumption",
    "at",
    "auto",
    "autorewrite",
    "autounfold",
    "before",
    "bottom",
    "btauto",
    "by",
    "case",
    "case_eq",
    "cbn",
    "cbv",
    "change",
    "classical_left",
    "classical_right",
    "clear",
    "clearbody",
    "cofix",
    "compare",
    "compute",
    "congruence",
    "constr_eq",
    "constructor",
    "contradict",
    "contradiction",
    "cut",
    "cutrewrite",
    "cycle",
    "decide",
    "decompose",
    "dependent",
    "destruct",
    "destruction",
    "dintuition",
    "discriminate",
    "discrR",
    "do",
    "double",
    "dtauto",
    "eapply",
    "eassumption",
    "eauto",
    "ecase",
    "econstructor",
    "edestruct",
    "ediscriminate",
    "eelim",
    "eexact",
    "eexists",
    "einduction",
    "einjection",
    "eleft",
    "elim",
    "elimtype",
    "enough",
    "equality",
    "erewrite",
    "eright",
    "esimplify_eq",
    "esplit",
    "evar",
    "exact",
    "exactly_once",
    "exfalso",
    "exists",
    "f_equal",
    "fail",
    "field",
    "field_simplify",
    "field_simplify_eq",
    "first",
    "firstorder",
    "fix",
    "fold",
    "fourier",
    "functional",
    "generalize",
    "generalizing",
    "gfail",
    "give_up",
    "has_evar",
    "hnf",
    "idtac",
    "in",
    "induction",
    "injection",
    "instantiate",
    "intro",
    "intro_pattern",
    "intros",
    "intuition",
    "inversion",
    "inversion_clear",
    "is_evar",
    "is_var",
    "lapply",
    "lazy",
    "left",
    "lia",
    "lra",
    "move",
    "native_compute",
    "nia",
    "nsatz",
    "omega",
    "once",
    "pattern",
    "pose",
    "progress",
    "proof",
    "psatz",
    "quote",
    "record",
    "red",
    "refine",
    "reflexivity",
    "remember",
    "rename",
    "repeat",
    "replace",
    "revert",
    "revgoals",
    "rewrite",
    "rewrite_strat",
    "right",
    "ring",
    "ring_simplify",
    "rtauto",
    "set",
    "setoid_reflexivity",
    "setoid_replace",
    "setoid_rewrite",
    "setoid_symmetry",
    "setoid_transitivity",
    "shelve",
    "shelve_unifiable",
    "simpl",
    "simple",
    "simplify_eq",
    "solve",
    "specialize",
    "split",
    "split_Rabs",
    "split_Rmult",
    "stepl",
    "stepr",
    "subst",
    "sum",
    "swap",
    "symmetry",
    "tactic",
    "tauto",
    "time",
    "timeout",
    "top",
    "transitivity",
    "trivial",
    "try",
    "tryif",
    "unfold",
    "unify",
    "until",
    "using",
    "vm_compute",
    "with"
  ];
  return {
    name: 'Coq',
    keywords: {
      keyword: KEYWORDS,
      built_in: BUILT_INS
    },
    contains: [
      hljs.QUOTE_STRING_MODE,
      hljs.COMMENT('\\(\\*', '\\*\\)'),
      hljs.C_NUMBER_MODE,
      {
        className: 'type',
        excludeBegin: true,
        begin: '\\|\\s*',
        end: '\\w+'
      },
      { // relevance booster
        begin: /[-=]>/ }
    ]
  };
}

module.exports = coq;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/cos.js":
/*!********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/cos.js ***!
  \********************************************************/
/***/ (function(module) {

/*
Language: Caché Object Script
Author: Nikita Savchenko <zitros.lab@gmail.com>
Category: enterprise, scripting
Website: https://cedocs.intersystems.com/latest/csp/docbook/DocBook.UI.Page.cls
*/

/** @type LanguageFn */
function cos(hljs) {
  const STRINGS = {
    className: 'string',
    variants: [
      {
        begin: '"',
        end: '"',
        contains: [
          { // escaped
            begin: "\"\"",
            relevance: 0
          }
        ]
      }
    ]
  };

  const NUMBERS = {
    className: "number",
    begin: "\\b(\\d+(\\.\\d*)?|\\.\\d+)",
    relevance: 0
  };

  const COS_KEYWORDS =
    'property parameter class classmethod clientmethod extends as break '
    + 'catch close continue do d|0 else elseif for goto halt hang h|0 if job '
    + 'j|0 kill k|0 lock l|0 merge new open quit q|0 read r|0 return set s|0 '
    + 'tcommit throw trollback try tstart use view while write w|0 xecute x|0 '
    + 'zkill znspace zn ztrap zwrite zw zzdump zzwrite print zbreak zinsert '
    + 'zload zprint zremove zsave zzprint mv mvcall mvcrt mvdim mvprint zquit '
    + 'zsync ascii';

  // registered function - no need in them due to all functions are highlighted,
  // but I'll just leave this here.

  // "$bit", "$bitcount",
  // "$bitfind", "$bitlogic", "$case", "$char", "$classmethod", "$classname",
  // "$compile", "$data", "$decimal", "$double", "$extract", "$factor",
  // "$find", "$fnumber", "$get", "$increment", "$inumber", "$isobject",
  // "$isvaliddouble", "$isvalidnum", "$justify", "$length", "$list",
  // "$listbuild", "$listdata", "$listfind", "$listfromstring", "$listget",
  // "$listlength", "$listnext", "$listsame", "$listtostring", "$listvalid",
  // "$locate", "$match", "$method", "$name", "$nconvert", "$next",
  // "$normalize", "$now", "$number", "$order", "$parameter", "$piece",
  // "$prefetchoff", "$prefetchon", "$property", "$qlength", "$qsubscript",
  // "$query", "$random", "$replace", "$reverse", "$sconvert", "$select",
  // "$sortbegin", "$sortend", "$stack", "$text", "$translate", "$view",
  // "$wascii", "$wchar", "$wextract", "$wfind", "$wiswide", "$wlength",
  // "$wreverse", "$xecute", "$zabs", "$zarccos", "$zarcsin", "$zarctan",
  // "$zcos", "$zcot", "$zcsc", "$zdate", "$zdateh", "$zdatetime",
  // "$zdatetimeh", "$zexp", "$zhex", "$zln", "$zlog", "$zpower", "$zsec",
  // "$zsin", "$zsqr", "$ztan", "$ztime", "$ztimeh", "$zboolean",
  // "$zconvert", "$zcrc", "$zcyc", "$zdascii", "$zdchar", "$zf",
  // "$ziswide", "$zlascii", "$zlchar", "$zname", "$zposition", "$zqascii",
  // "$zqchar", "$zsearch", "$zseek", "$zstrip", "$zwascii", "$zwchar",
  // "$zwidth", "$zwpack", "$zwbpack", "$zwunpack", "$zwbunpack", "$zzenkaku",
  // "$change", "$mv", "$mvat", "$mvfmt", "$mvfmts", "$mviconv",
  // "$mviconvs", "$mvinmat", "$mvlover", "$mvoconv", "$mvoconvs", "$mvraise",
  // "$mvtrans", "$mvv", "$mvname", "$zbitand", "$zbitcount", "$zbitfind",
  // "$zbitget", "$zbitlen", "$zbitnot", "$zbitor", "$zbitset", "$zbitstr",
  // "$zbitxor", "$zincrement", "$znext", "$zorder", "$zprevious", "$zsort",
  // "device", "$ecode", "$estack", "$etrap", "$halt", "$horolog",
  // "$io", "$job", "$key", "$namespace", "$principal", "$quit", "$roles",
  // "$storage", "$system", "$test", "$this", "$tlevel", "$username",
  // "$x", "$y", "$za", "$zb", "$zchild", "$zeof", "$zeos", "$zerror",
  // "$zhorolog", "$zio", "$zjob", "$zmode", "$znspace", "$zparent", "$zpi",
  // "$zpos", "$zreference", "$zstorage", "$ztimestamp", "$ztimezone",
  // "$ztrap", "$zversion"

  return {
    name: 'Caché Object Script',
    case_insensitive: true,
    aliases: [ "cls" ],
    keywords: COS_KEYWORDS,
    contains: [
      NUMBERS,
      STRINGS,
      hljs.C_LINE_COMMENT_MODE,
      hljs.C_BLOCK_COMMENT_MODE,
      {
        className: "comment",
        begin: /;/,
        end: "$",
        relevance: 0
      },
      { // Functions and user-defined functions: write $ztime(60*60*3), $$myFunc(10), $$^Val(1)
        className: "built_in",
        begin: /(?:\$\$?|\.\.)\^?[a-zA-Z]+/
      },
      { // Macro command: quit $$$OK
        className: "built_in",
        begin: /\$\$\$[a-zA-Z]+/
      },
      { // Special (global) variables: write %request.Content; Built-in classes: %Library.Integer
        className: "built_in",
        begin: /%[a-z]+(?:\.[a-z]+)*/
      },
      { // Global variable: set ^globalName = 12 write ^globalName
        className: "symbol",
        begin: /\^%?[a-zA-Z][\w]*/
      },
      { // Some control constructions: do ##class(Package.ClassName).Method(), ##super()
        className: "keyword",
        begin: /##class|##super|#define|#dim/
      },
      // sub-languages: are not fully supported by hljs by 11/15/2015
      // left for the future implementation.
      {
        begin: /&sql\(/,
        end: /\)/,
        excludeBegin: true,
        excludeEnd: true,
        subLanguage: "sql"
      },
      {
        begin: /&(js|jscript|javascript)</,
        end: />/,
        excludeBegin: true,
        excludeEnd: true,
        subLanguage: "javascript"
      },
      {
        // this brakes first and last tag, but this is the only way to embed a valid html
        begin: /&html<\s*</,
        end: />\s*>/,
        subLanguage: "xml"
      }
    ]
  };
}

module.exports = cos;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/cpp.js":
/*!********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/cpp.js ***!
  \********************************************************/
/***/ (function(module) {

/*
Language: C++
Category: common, system
Website: https://isocpp.org
*/

/** @type LanguageFn */
function cpp(hljs) {
  const regex = hljs.regex;
  // added for historic reasons because `hljs.C_LINE_COMMENT_MODE` does
  // not include such support nor can we be sure all the grammars depending
  // on it would desire this behavior
  const C_LINE_COMMENT_MODE = hljs.COMMENT('//', '$', { contains: [ { begin: /\\\n/ } ] });
  const DECLTYPE_AUTO_RE = 'decltype\\(auto\\)';
  const NAMESPACE_RE = '[a-zA-Z_]\\w*::';
  const TEMPLATE_ARGUMENT_RE = '<[^<>]+>';
  const FUNCTION_TYPE_RE = '(?!struct)('
    + DECLTYPE_AUTO_RE + '|'
    + regex.optional(NAMESPACE_RE)
    + '[a-zA-Z_]\\w*' + regex.optional(TEMPLATE_ARGUMENT_RE)
  + ')';

  const CPP_PRIMITIVE_TYPES = {
    className: 'type',
    begin: '\\b[a-z\\d_]*_t\\b'
  };

  // https://en.cppreference.com/w/cpp/language/escape
  // \\ \x \xFF \u2837 \u00323747 \374
  const CHARACTER_ESCAPES = '\\\\(x[0-9A-Fa-f]{2}|u[0-9A-Fa-f]{4,8}|[0-7]{3}|\\S)';
  const STRINGS = {
    className: 'string',
    variants: [
      {
        begin: '(u8?|U|L)?"',
        end: '"',
        illegal: '\\n',
        contains: [ hljs.BACKSLASH_ESCAPE ]
      },
      {
        begin: '(u8?|U|L)?\'(' + CHARACTER_ESCAPES + '|.)',
        end: '\'',
        illegal: '.'
      },
      hljs.END_SAME_AS_BEGIN({
        begin: /(?:u8?|U|L)?R"([^()\\ ]{0,16})\(/,
        end: /\)([^()\\ ]{0,16})"/
      })
    ]
  };

  const NUMBERS = {
    className: 'number',
    variants: [
      { begin: '\\b(0b[01\']+)' },
      { begin: '(-?)\\b([\\d\']+(\\.[\\d\']*)?|\\.[\\d\']+)((ll|LL|l|L)(u|U)?|(u|U)(ll|LL|l|L)?|f|F|b|B)' },
      { begin: '(-?)(\\b0[xX][a-fA-F0-9\']+|(\\b[\\d\']+(\\.[\\d\']*)?|\\.[\\d\']+)([eE][-+]?[\\d\']+)?)' }
    ],
    relevance: 0
  };

  const PREPROCESSOR = {
    className: 'meta',
    begin: /#\s*[a-z]+\b/,
    end: /$/,
    keywords: { keyword:
        'if else elif endif define undef warning error line '
        + 'pragma _Pragma ifdef ifndef include' },
    contains: [
      {
        begin: /\\\n/,
        relevance: 0
      },
      hljs.inherit(STRINGS, { className: 'string' }),
      {
        className: 'string',
        begin: /<.*?>/
      },
      C_LINE_COMMENT_MODE,
      hljs.C_BLOCK_COMMENT_MODE
    ]
  };

  const TITLE_MODE = {
    className: 'title',
    begin: regex.optional(NAMESPACE_RE) + hljs.IDENT_RE,
    relevance: 0
  };

  const FUNCTION_TITLE = regex.optional(NAMESPACE_RE) + hljs.IDENT_RE + '\\s*\\(';

  // https://en.cppreference.com/w/cpp/keyword
  const RESERVED_KEYWORDS = [
    'alignas',
    'alignof',
    'and',
    'and_eq',
    'asm',
    'atomic_cancel',
    'atomic_commit',
    'atomic_noexcept',
    'auto',
    'bitand',
    'bitor',
    'break',
    'case',
    'catch',
    'class',
    'co_await',
    'co_return',
    'co_yield',
    'compl',
    'concept',
    'const_cast|10',
    'consteval',
    'constexpr',
    'constinit',
    'continue',
    'decltype',
    'default',
    'delete',
    'do',
    'dynamic_cast|10',
    'else',
    'enum',
    'explicit',
    'export',
    'extern',
    'false',
    'final',
    'for',
    'friend',
    'goto',
    'if',
    'import',
    'inline',
    'module',
    'mutable',
    'namespace',
    'new',
    'noexcept',
    'not',
    'not_eq',
    'nullptr',
    'operator',
    'or',
    'or_eq',
    'override',
    'private',
    'protected',
    'public',
    'reflexpr',
    'register',
    'reinterpret_cast|10',
    'requires',
    'return',
    'sizeof',
    'static_assert',
    'static_cast|10',
    'struct',
    'switch',
    'synchronized',
    'template',
    'this',
    'thread_local',
    'throw',
    'transaction_safe',
    'transaction_safe_dynamic',
    'true',
    'try',
    'typedef',
    'typeid',
    'typename',
    'union',
    'using',
    'virtual',
    'volatile',
    'while',
    'xor',
    'xor_eq'
  ];

  // https://en.cppreference.com/w/cpp/keyword
  const RESERVED_TYPES = [
    'bool',
    'char',
    'char16_t',
    'char32_t',
    'char8_t',
    'double',
    'float',
    'int',
    'long',
    'short',
    'void',
    'wchar_t',
    'unsigned',
    'signed',
    'const',
    'static'
  ];

  const TYPE_HINTS = [
    'any',
    'auto_ptr',
    'barrier',
    'binary_semaphore',
    'bitset',
    'complex',
    'condition_variable',
    'condition_variable_any',
    'counting_semaphore',
    'deque',
    'false_type',
    'future',
    'imaginary',
    'initializer_list',
    'istringstream',
    'jthread',
    'latch',
    'lock_guard',
    'multimap',
    'multiset',
    'mutex',
    'optional',
    'ostringstream',
    'packaged_task',
    'pair',
    'promise',
    'priority_queue',
    'queue',
    'recursive_mutex',
    'recursive_timed_mutex',
    'scoped_lock',
    'set',
    'shared_future',
    'shared_lock',
    'shared_mutex',
    'shared_timed_mutex',
    'shared_ptr',
    'stack',
    'string_view',
    'stringstream',
    'timed_mutex',
    'thread',
    'true_type',
    'tuple',
    'unique_lock',
    'unique_ptr',
    'unordered_map',
    'unordered_multimap',
    'unordered_multiset',
    'unordered_set',
    'variant',
    'vector',
    'weak_ptr',
    'wstring',
    'wstring_view'
  ];

  const FUNCTION_HINTS = [
    'abort',
    'abs',
    'acos',
    'apply',
    'as_const',
    'asin',
    'atan',
    'atan2',
    'calloc',
    'ceil',
    'cerr',
    'cin',
    'clog',
    'cos',
    'cosh',
    'cout',
    'declval',
    'endl',
    'exchange',
    'exit',
    'exp',
    'fabs',
    'floor',
    'fmod',
    'forward',
    'fprintf',
    'fputs',
    'free',
    'frexp',
    'fscanf',
    'future',
    'invoke',
    'isalnum',
    'isalpha',
    'iscntrl',
    'isdigit',
    'isgraph',
    'islower',
    'isprint',
    'ispunct',
    'isspace',
    'isupper',
    'isxdigit',
    'labs',
    'launder',
    'ldexp',
    'log',
    'log10',
    'make_pair',
    'make_shared',
    'make_shared_for_overwrite',
    'make_tuple',
    'make_unique',
    'malloc',
    'memchr',
    'memcmp',
    'memcpy',
    'memset',
    'modf',
    'move',
    'pow',
    'printf',
    'putchar',
    'puts',
    'realloc',
    'scanf',
    'sin',
    'sinh',
    'snprintf',
    'sprintf',
    'sqrt',
    'sscanf',
    'std',
    'stderr',
    'stdin',
    'stdout',
    'strcat',
    'strchr',
    'strcmp',
    'strcpy',
    'strcspn',
    'strlen',
    'strncat',
    'strncmp',
    'strncpy',
    'strpbrk',
    'strrchr',
    'strspn',
    'strstr',
    'swap',
    'tan',
    'tanh',
    'terminate',
    'to_underlying',
    'tolower',
    'toupper',
    'vfprintf',
    'visit',
    'vprintf',
    'vsprintf'
  ];

  const LITERALS = [
    'NULL',
    'false',
    'nullopt',
    'nullptr',
    'true'
  ];

  // https://en.cppreference.com/w/cpp/keyword
  const BUILT_IN = [ '_Pragma' ];

  const CPP_KEYWORDS = {
    type: RESERVED_TYPES,
    keyword: RESERVED_KEYWORDS,
    literal: LITERALS,
    built_in: BUILT_IN,
    _type_hints: TYPE_HINTS
  };

  const FUNCTION_DISPATCH = {
    className: 'function.dispatch',
    relevance: 0,
    keywords: {
      // Only for relevance, not highlighting.
      _hint: FUNCTION_HINTS },
    begin: regex.concat(
      /\b/,
      /(?!decltype)/,
      /(?!if)/,
      /(?!for)/,
      /(?!switch)/,
      /(?!while)/,
      hljs.IDENT_RE,
      regex.lookahead(/(<[^<>]+>|)\s*\(/))
  };

  const EXPRESSION_CONTAINS = [
    FUNCTION_DISPATCH,
    PREPROCESSOR,
    CPP_PRIMITIVE_TYPES,
    C_LINE_COMMENT_MODE,
    hljs.C_BLOCK_COMMENT_MODE,
    NUMBERS,
    STRINGS
  ];

  const EXPRESSION_CONTEXT = {
    // This mode covers expression context where we can't expect a function
    // definition and shouldn't highlight anything that looks like one:
    // `return some()`, `else if()`, `(x*sum(1, 2))`
    variants: [
      {
        begin: /=/,
        end: /;/
      },
      {
        begin: /\(/,
        end: /\)/
      },
      {
        beginKeywords: 'new throw return else',
        end: /;/
      }
    ],
    keywords: CPP_KEYWORDS,
    contains: EXPRESSION_CONTAINS.concat([
      {
        begin: /\(/,
        end: /\)/,
        keywords: CPP_KEYWORDS,
        contains: EXPRESSION_CONTAINS.concat([ 'self' ]),
        relevance: 0
      }
    ]),
    relevance: 0
  };

  const FUNCTION_DECLARATION = {
    className: 'function',
    begin: '(' + FUNCTION_TYPE_RE + '[\\*&\\s]+)+' + FUNCTION_TITLE,
    returnBegin: true,
    end: /[{;=]/,
    excludeEnd: true,
    keywords: CPP_KEYWORDS,
    illegal: /[^\w\s\*&:<>.]/,
    contains: [
      { // to prevent it from being confused as the function title
        begin: DECLTYPE_AUTO_RE,
        keywords: CPP_KEYWORDS,
        relevance: 0
      },
      {
        begin: FUNCTION_TITLE,
        returnBegin: true,
        contains: [ TITLE_MODE ],
        relevance: 0
      },
      // needed because we do not have look-behind on the below rule
      // to prevent it from grabbing the final : in a :: pair
      {
        begin: /::/,
        relevance: 0
      },
      // initializers
      {
        begin: /:/,
        endsWithParent: true,
        contains: [
          STRINGS,
          NUMBERS
        ]
      },
      // allow for multiple declarations, e.g.:
      // extern void f(int), g(char);
      {
        relevance: 0,
        match: /,/
      },
      {
        className: 'params',
        begin: /\(/,
        end: /\)/,
        keywords: CPP_KEYWORDS,
        relevance: 0,
        contains: [
          C_LINE_COMMENT_MODE,
          hljs.C_BLOCK_COMMENT_MODE,
          STRINGS,
          NUMBERS,
          CPP_PRIMITIVE_TYPES,
          // Count matching parentheses.
          {
            begin: /\(/,
            end: /\)/,
            keywords: CPP_KEYWORDS,
            relevance: 0,
            contains: [
              'self',
              C_LINE_COMMENT_MODE,
              hljs.C_BLOCK_COMMENT_MODE,
              STRINGS,
              NUMBERS,
              CPP_PRIMITIVE_TYPES
            ]
          }
        ]
      },
      CPP_PRIMITIVE_TYPES,
      C_LINE_COMMENT_MODE,
      hljs.C_BLOCK_COMMENT_MODE,
      PREPROCESSOR
    ]
  };

  return {
    name: 'C++',
    aliases: [
      'cc',
      'c++',
      'h++',
      'hpp',
      'hh',
      'hxx',
      'cxx'
    ],
    keywords: CPP_KEYWORDS,
    illegal: '</',
    classNameAliases: { 'function.dispatch': 'built_in' },
    contains: [].concat(
      EXPRESSION_CONTEXT,
      FUNCTION_DECLARATION,
      FUNCTION_DISPATCH,
      EXPRESSION_CONTAINS,
      [
        PREPROCESSOR,
        { // containers: ie, `vector <int> rooms (9);`
          begin: '\\b(deque|list|queue|priority_queue|pair|stack|vector|map|set|bitset|multiset|multimap|unordered_map|unordered_set|unordered_multiset|unordered_multimap|array|tuple|optional|variant|function)\\s*<(?!<)',
          end: '>',
          keywords: CPP_KEYWORDS,
          contains: [
            'self',
            CPP_PRIMITIVE_TYPES
          ]
        },
        {
          begin: hljs.IDENT_RE + '::',
          keywords: CPP_KEYWORDS
        },
        {
          match: [
            // extra complexity to deal with `enum class` and `enum struct`
            /\b(?:enum(?:\s+(?:class|struct))?|class|struct|union)/,
            /\s+/,
            /\w+/
          ],
          className: {
            1: 'keyword',
            3: 'title.class'
          }
        }
      ])
  };
}

module.exports = cpp;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/crmsh.js":
/*!**********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/crmsh.js ***!
  \**********************************************************/
/***/ (function(module) {

/*
Language: crmsh
Author: Kristoffer Gronlund <kgronlund@suse.com>
Website: http://crmsh.github.io
Description: Syntax Highlighting for the crmsh DSL
Category: config
*/

/** @type LanguageFn */
function crmsh(hljs) {
  const RESOURCES = 'primitive rsc_template';
  const COMMANDS = 'group clone ms master location colocation order fencing_topology '
      + 'rsc_ticket acl_target acl_group user role '
      + 'tag xml';
  const PROPERTY_SETS = 'property rsc_defaults op_defaults';
  const KEYWORDS = 'params meta operations op rule attributes utilization';
  const OPERATORS = 'read write deny defined not_defined in_range date spec in '
      + 'ref reference attribute type xpath version and or lt gt tag '
      + 'lte gte eq ne \\';
  const TYPES = 'number string';
  const LITERALS = 'Master Started Slave Stopped start promote demote stop monitor true false';

  return {
    name: 'crmsh',
    aliases: [
      'crm',
      'pcmk'
    ],
    case_insensitive: true,
    keywords: {
      keyword: KEYWORDS + ' ' + OPERATORS + ' ' + TYPES,
      literal: LITERALS
    },
    contains: [
      hljs.HASH_COMMENT_MODE,
      {
        beginKeywords: 'node',
        starts: {
          end: '\\s*([\\w_-]+:)?',
          starts: {
            className: 'title',
            end: '\\s*[\\$\\w_][\\w_-]*'
          }
        }
      },
      {
        beginKeywords: RESOURCES,
        starts: {
          className: 'title',
          end: '\\s*[\\$\\w_][\\w_-]*',
          starts: { end: '\\s*@?[\\w_][\\w_\\.:-]*' }
        }
      },
      {
        begin: '\\b(' + COMMANDS.split(' ').join('|') + ')\\s+',
        keywords: COMMANDS,
        starts: {
          className: 'title',
          end: '[\\$\\w_][\\w_-]*'
        }
      },
      {
        beginKeywords: PROPERTY_SETS,
        starts: {
          className: 'title',
          end: '\\s*([\\w_-]+:)?'
        }
      },
      hljs.QUOTE_STRING_MODE,
      {
        className: 'meta',
        begin: '(ocf|systemd|service|lsb):[\\w_:-]+',
        relevance: 0
      },
      {
        className: 'number',
        begin: '\\b\\d+(\\.\\d+)?(ms|s|h|m)?',
        relevance: 0
      },
      {
        className: 'literal',
        begin: '[-]?(infinity|inf)',
        relevance: 0
      },
      {
        className: 'attr',
        begin: /([A-Za-z$_#][\w_-]+)=/,
        relevance: 0
      },
      {
        className: 'tag',
        begin: '</?',
        end: '/?>',
        relevance: 0
      }
    ]
  };
}

module.exports = crmsh;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/crystal.js":
/*!************************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/crystal.js ***!
  \************************************************************/
/***/ (function(module) {

/*
Language: Crystal
Author: TSUYUSATO Kitsune <make.just.on@gmail.com>
Website: https://crystal-lang.org
*/

/** @type LanguageFn */
function crystal(hljs) {
  const INT_SUFFIX = '(_?[ui](8|16|32|64|128))?';
  const FLOAT_SUFFIX = '(_?f(32|64))?';
  const CRYSTAL_IDENT_RE = '[a-zA-Z_]\\w*[!?=]?';
  const CRYSTAL_METHOD_RE = '[a-zA-Z_]\\w*[!?=]?|[-+~]@|<<|>>|[=!]~|===?|<=>|[<>]=?|\\*\\*|[-/+%^&*~|]|//|//=|&[-+*]=?|&\\*\\*|\\[\\][=?]?';
  const CRYSTAL_PATH_RE = '[A-Za-z_]\\w*(::\\w+)*(\\?|!)?';
  const CRYSTAL_KEYWORDS = {
    $pattern: CRYSTAL_IDENT_RE,
    keyword:
      'abstract alias annotation as as? asm begin break case class def do else elsif end ensure enum extend for fun if '
      + 'include instance_sizeof is_a? lib macro module next nil? of out pointerof private protected rescue responds_to? '
      + 'return require select self sizeof struct super then type typeof union uninitialized unless until verbatim when while with yield '
      + '__DIR__ __END_LINE__ __FILE__ __LINE__',
    literal: 'false nil true'
  };
  const SUBST = {
    className: 'subst',
    begin: /#\{/,
    end: /\}/,
    keywords: CRYSTAL_KEYWORDS
  };
  // borrowed from Ruby
  const VARIABLE = {
    // negative-look forward attemps to prevent false matches like:
    // @ident@ or $ident$ that might indicate this is not ruby at all
    className: "variable",
    begin: '(\\$\\W)|((\\$|@@?)(\\w+))(?=[^@$?])' + `(?![A-Za-z])(?![@$?'])`
  };
  const EXPANSION = {
    className: 'template-variable',
    variants: [
      {
        begin: '\\{\\{',
        end: '\\}\\}'
      },
      {
        begin: '\\{%',
        end: '%\\}'
      }
    ],
    keywords: CRYSTAL_KEYWORDS
  };

  function recursiveParen(begin, end) {
    const
        contains = [
          {
            begin: begin,
            end: end
          }
        ];
    contains[0].contains = contains;
    return contains;
  }
  const STRING = {
    className: 'string',
    contains: [
      hljs.BACKSLASH_ESCAPE,
      SUBST
    ],
    variants: [
      {
        begin: /'/,
        end: /'/
      },
      {
        begin: /"/,
        end: /"/
      },
      {
        begin: /`/,
        end: /`/
      },
      {
        begin: '%[Qwi]?\\(',
        end: '\\)',
        contains: recursiveParen('\\(', '\\)')
      },
      {
        begin: '%[Qwi]?\\[',
        end: '\\]',
        contains: recursiveParen('\\[', '\\]')
      },
      {
        begin: '%[Qwi]?\\{',
        end: /\}/,
        contains: recursiveParen(/\{/, /\}/)
      },
      {
        begin: '%[Qwi]?<',
        end: '>',
        contains: recursiveParen('<', '>')
      },
      {
        begin: '%[Qwi]?\\|',
        end: '\\|'
      },
      {
        begin: /<<-\w+$/,
        end: /^\s*\w+$/
      }
    ],
    relevance: 0
  };
  const Q_STRING = {
    className: 'string',
    variants: [
      {
        begin: '%q\\(',
        end: '\\)',
        contains: recursiveParen('\\(', '\\)')
      },
      {
        begin: '%q\\[',
        end: '\\]',
        contains: recursiveParen('\\[', '\\]')
      },
      {
        begin: '%q\\{',
        end: /\}/,
        contains: recursiveParen(/\{/, /\}/)
      },
      {
        begin: '%q<',
        end: '>',
        contains: recursiveParen('<', '>')
      },
      {
        begin: '%q\\|',
        end: '\\|'
      },
      {
        begin: /<<-'\w+'$/,
        end: /^\s*\w+$/
      }
    ],
    relevance: 0
  };
  const REGEXP = {
    begin: '(?!%\\})(' + hljs.RE_STARTERS_RE + '|\\n|\\b(case|if|select|unless|until|when|while)\\b)\\s*',
    keywords: 'case if select unless until when while',
    contains: [
      {
        className: 'regexp',
        contains: [
          hljs.BACKSLASH_ESCAPE,
          SUBST
        ],
        variants: [
          {
            begin: '//[a-z]*',
            relevance: 0
          },
          {
            begin: '/(?!\\/)',
            end: '/[a-z]*'
          }
        ]
      }
    ],
    relevance: 0
  };
  const REGEXP2 = {
    className: 'regexp',
    contains: [
      hljs.BACKSLASH_ESCAPE,
      SUBST
    ],
    variants: [
      {
        begin: '%r\\(',
        end: '\\)',
        contains: recursiveParen('\\(', '\\)')
      },
      {
        begin: '%r\\[',
        end: '\\]',
        contains: recursiveParen('\\[', '\\]')
      },
      {
        begin: '%r\\{',
        end: /\}/,
        contains: recursiveParen(/\{/, /\}/)
      },
      {
        begin: '%r<',
        end: '>',
        contains: recursiveParen('<', '>')
      },
      {
        begin: '%r\\|',
        end: '\\|'
      }
    ],
    relevance: 0
  };
  const ATTRIBUTE = {
    className: 'meta',
    begin: '@\\[',
    end: '\\]',
    contains: [ hljs.inherit(hljs.QUOTE_STRING_MODE, { className: 'string' }) ]
  };
  const CRYSTAL_DEFAULT_CONTAINS = [
    EXPANSION,
    STRING,
    Q_STRING,
    REGEXP2,
    REGEXP,
    ATTRIBUTE,
    VARIABLE,
    hljs.HASH_COMMENT_MODE,
    {
      className: 'class',
      beginKeywords: 'class module struct',
      end: '$|;',
      illegal: /=/,
      contains: [
        hljs.HASH_COMMENT_MODE,
        hljs.inherit(hljs.TITLE_MODE, { begin: CRYSTAL_PATH_RE }),
        { // relevance booster for inheritance
          begin: '<' }
      ]
    },
    {
      className: 'class',
      beginKeywords: 'lib enum union',
      end: '$|;',
      illegal: /=/,
      contains: [
        hljs.HASH_COMMENT_MODE,
        hljs.inherit(hljs.TITLE_MODE, { begin: CRYSTAL_PATH_RE })
      ]
    },
    {
      beginKeywords: 'annotation',
      end: '$|;',
      illegal: /=/,
      contains: [
        hljs.HASH_COMMENT_MODE,
        hljs.inherit(hljs.TITLE_MODE, { begin: CRYSTAL_PATH_RE })
      ],
      relevance: 2
    },
    {
      className: 'function',
      beginKeywords: 'def',
      end: /\B\b/,
      contains: [
        hljs.inherit(hljs.TITLE_MODE, {
          begin: CRYSTAL_METHOD_RE,
          endsParent: true
        })
      ]
    },
    {
      className: 'function',
      beginKeywords: 'fun macro',
      end: /\B\b/,
      contains: [
        hljs.inherit(hljs.TITLE_MODE, {
          begin: CRYSTAL_METHOD_RE,
          endsParent: true
        })
      ],
      relevance: 2
    },
    {
      className: 'symbol',
      begin: hljs.UNDERSCORE_IDENT_RE + '(!|\\?)?:',
      relevance: 0
    },
    {
      className: 'symbol',
      begin: ':',
      contains: [
        STRING,
        { begin: CRYSTAL_METHOD_RE }
      ],
      relevance: 0
    },
    {
      className: 'number',
      variants: [
        { begin: '\\b0b([01_]+)' + INT_SUFFIX },
        { begin: '\\b0o([0-7_]+)' + INT_SUFFIX },
        { begin: '\\b0x([A-Fa-f0-9_]+)' + INT_SUFFIX },
        { begin: '\\b([1-9][0-9_]*[0-9]|[0-9])(\\.[0-9][0-9_]*)?([eE]_?[-+]?[0-9_]*)?' + FLOAT_SUFFIX + '(?!_)' },
        { begin: '\\b([1-9][0-9_]*|0)' + INT_SUFFIX }
      ],
      relevance: 0
    }
  ];
  SUBST.contains = CRYSTAL_DEFAULT_CONTAINS;
  EXPANSION.contains = CRYSTAL_DEFAULT_CONTAINS.slice(1); // without EXPANSION

  return {
    name: 'Crystal',
    aliases: [ 'cr' ],
    keywords: CRYSTAL_KEYWORDS,
    contains: CRYSTAL_DEFAULT_CONTAINS
  };
}

module.exports = crystal;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/csharp.js":
/*!***********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/csharp.js ***!
  \***********************************************************/
/***/ (function(module) {

/*
Language: C#
Author: Jason Diamond <jason@diamond.name>
Contributor: Nicolas LLOBERA <nllobera@gmail.com>, Pieter Vantorre <pietervantorre@gmail.com>, David Pine <david.pine@microsoft.com>
Website: https://docs.microsoft.com/dotnet/csharp/
Category: common
*/

/** @type LanguageFn */
function csharp(hljs) {
  const BUILT_IN_KEYWORDS = [
    'bool',
    'byte',
    'char',
    'decimal',
    'delegate',
    'double',
    'dynamic',
    'enum',
    'float',
    'int',
    'long',
    'nint',
    'nuint',
    'object',
    'sbyte',
    'short',
    'string',
    'ulong',
    'uint',
    'ushort'
  ];
  const FUNCTION_MODIFIERS = [
    'public',
    'private',
    'protected',
    'static',
    'internal',
    'protected',
    'abstract',
    'async',
    'extern',
    'override',
    'unsafe',
    'virtual',
    'new',
    'sealed',
    'partial'
  ];
  const LITERAL_KEYWORDS = [
    'default',
    'false',
    'null',
    'true'
  ];
  const NORMAL_KEYWORDS = [
    'abstract',
    'as',
    'base',
    'break',
    'case',
    'catch',
    'class',
    'const',
    'continue',
    'do',
    'else',
    'event',
    'explicit',
    'extern',
    'finally',
    'fixed',
    'for',
    'foreach',
    'goto',
    'if',
    'implicit',
    'in',
    'interface',
    'internal',
    'is',
    'lock',
    'namespace',
    'new',
    'operator',
    'out',
    'override',
    'params',
    'private',
    'protected',
    'public',
    'readonly',
    'record',
    'ref',
    'return',
    'scoped',
    'sealed',
    'sizeof',
    'stackalloc',
    'static',
    'struct',
    'switch',
    'this',
    'throw',
    'try',
    'typeof',
    'unchecked',
    'unsafe',
    'using',
    'virtual',
    'void',
    'volatile',
    'while'
  ];
  const CONTEXTUAL_KEYWORDS = [
    'add',
    'alias',
    'and',
    'ascending',
    'async',
    'await',
    'by',
    'descending',
    'equals',
    'from',
    'get',
    'global',
    'group',
    'init',
    'into',
    'join',
    'let',
    'nameof',
    'not',
    'notnull',
    'on',
    'or',
    'orderby',
    'partial',
    'remove',
    'select',
    'set',
    'unmanaged',
    'value|0',
    'var',
    'when',
    'where',
    'with',
    'yield'
  ];

  const KEYWORDS = {
    keyword: NORMAL_KEYWORDS.concat(CONTEXTUAL_KEYWORDS),
    built_in: BUILT_IN_KEYWORDS,
    literal: LITERAL_KEYWORDS
  };
  const TITLE_MODE = hljs.inherit(hljs.TITLE_MODE, { begin: '[a-zA-Z](\\.?\\w)*' });
  const NUMBERS = {
    className: 'number',
    variants: [
      { begin: '\\b(0b[01\']+)' },
      { begin: '(-?)\\b([\\d\']+(\\.[\\d\']*)?|\\.[\\d\']+)(u|U|l|L|ul|UL|f|F|b|B)' },
      { begin: '(-?)(\\b0[xX][a-fA-F0-9\']+|(\\b[\\d\']+(\\.[\\d\']*)?|\\.[\\d\']+)([eE][-+]?[\\d\']+)?)' }
    ],
    relevance: 0
  };
  const VERBATIM_STRING = {
    className: 'string',
    begin: '@"',
    end: '"',
    contains: [ { begin: '""' } ]
  };
  const VERBATIM_STRING_NO_LF = hljs.inherit(VERBATIM_STRING, { illegal: /\n/ });
  const SUBST = {
    className: 'subst',
    begin: /\{/,
    end: /\}/,
    keywords: KEYWORDS
  };
  const SUBST_NO_LF = hljs.inherit(SUBST, { illegal: /\n/ });
  const INTERPOLATED_STRING = {
    className: 'string',
    begin: /\$"/,
    end: '"',
    illegal: /\n/,
    contains: [
      { begin: /\{\{/ },
      { begin: /\}\}/ },
      hljs.BACKSLASH_ESCAPE,
      SUBST_NO_LF
    ]
  };
  const INTERPOLATED_VERBATIM_STRING = {
    className: 'string',
    begin: /\$@"/,
    end: '"',
    contains: [
      { begin: /\{\{/ },
      { begin: /\}\}/ },
      { begin: '""' },
      SUBST
    ]
  };
  const INTERPOLATED_VERBATIM_STRING_NO_LF = hljs.inherit(INTERPOLATED_VERBATIM_STRING, {
    illegal: /\n/,
    contains: [
      { begin: /\{\{/ },
      { begin: /\}\}/ },
      { begin: '""' },
      SUBST_NO_LF
    ]
  });
  SUBST.contains = [
    INTERPOLATED_VERBATIM_STRING,
    INTERPOLATED_STRING,
    VERBATIM_STRING,
    hljs.APOS_STRING_MODE,
    hljs.QUOTE_STRING_MODE,
    NUMBERS,
    hljs.C_BLOCK_COMMENT_MODE
  ];
  SUBST_NO_LF.contains = [
    INTERPOLATED_VERBATIM_STRING_NO_LF,
    INTERPOLATED_STRING,
    VERBATIM_STRING_NO_LF,
    hljs.APOS_STRING_MODE,
    hljs.QUOTE_STRING_MODE,
    NUMBERS,
    hljs.inherit(hljs.C_BLOCK_COMMENT_MODE, { illegal: /\n/ })
  ];
  const STRING = { variants: [
    INTERPOLATED_VERBATIM_STRING,
    INTERPOLATED_STRING,
    VERBATIM_STRING,
    hljs.APOS_STRING_MODE,
    hljs.QUOTE_STRING_MODE
  ] };

  const GENERIC_MODIFIER = {
    begin: "<",
    end: ">",
    contains: [
      { beginKeywords: "in out" },
      TITLE_MODE
    ]
  };
  const TYPE_IDENT_RE = hljs.IDENT_RE + '(<' + hljs.IDENT_RE + '(\\s*,\\s*' + hljs.IDENT_RE + ')*>)?(\\[\\])?';
  const AT_IDENTIFIER = {
    // prevents expressions like `@class` from incorrect flagging
    // `class` as a keyword
    begin: "@" + hljs.IDENT_RE,
    relevance: 0
  };

  return {
    name: 'C#',
    aliases: [
      'cs',
      'c#'
    ],
    keywords: KEYWORDS,
    illegal: /::/,
    contains: [
      hljs.COMMENT(
        '///',
        '$',
        {
          returnBegin: true,
          contains: [
            {
              className: 'doctag',
              variants: [
                {
                  begin: '///',
                  relevance: 0
                },
                { begin: '<!--|-->' },
                {
                  begin: '</?',
                  end: '>'
                }
              ]
            }
          ]
        }
      ),
      hljs.C_LINE_COMMENT_MODE,
      hljs.C_BLOCK_COMMENT_MODE,
      {
        className: 'meta',
        begin: '#',
        end: '$',
        keywords: { keyword: 'if else elif endif define undef warning error line region endregion pragma checksum' }
      },
      STRING,
      NUMBERS,
      {
        beginKeywords: 'class interface',
        relevance: 0,
        end: /[{;=]/,
        illegal: /[^\s:,]/,
        contains: [
          { beginKeywords: "where class" },
          TITLE_MODE,
          GENERIC_MODIFIER,
          hljs.C_LINE_COMMENT_MODE,
          hljs.C_BLOCK_COMMENT_MODE
        ]
      },
      {
        beginKeywords: 'namespace',
        relevance: 0,
        end: /[{;=]/,
        illegal: /[^\s:]/,
        contains: [
          TITLE_MODE,
          hljs.C_LINE_COMMENT_MODE,
          hljs.C_BLOCK_COMMENT_MODE
        ]
      },
      {
        beginKeywords: 'record',
        relevance: 0,
        end: /[{;=]/,
        illegal: /[^\s:]/,
        contains: [
          TITLE_MODE,
          GENERIC_MODIFIER,
          hljs.C_LINE_COMMENT_MODE,
          hljs.C_BLOCK_COMMENT_MODE
        ]
      },
      {
        // [Attributes("")]
        className: 'meta',
        begin: '^\\s*\\[(?=[\\w])',
        excludeBegin: true,
        end: '\\]',
        excludeEnd: true,
        contains: [
          {
            className: 'string',
            begin: /"/,
            end: /"/
          }
        ]
      },
      {
        // Expression keywords prevent 'keyword Name(...)' from being
        // recognized as a function definition
        beginKeywords: 'new return throw await else',
        relevance: 0
      },
      {
        className: 'function',
        begin: '(' + TYPE_IDENT_RE + '\\s+)+' + hljs.IDENT_RE + '\\s*(<[^=]+>\\s*)?\\(',
        returnBegin: true,
        end: /\s*[{;=]/,
        excludeEnd: true,
        keywords: KEYWORDS,
        contains: [
          // prevents these from being highlighted `title`
          {
            beginKeywords: FUNCTION_MODIFIERS.join(" "),
            relevance: 0
          },
          {
            begin: hljs.IDENT_RE + '\\s*(<[^=]+>\\s*)?\\(',
            returnBegin: true,
            contains: [
              hljs.TITLE_MODE,
              GENERIC_MODIFIER
            ],
            relevance: 0
          },
          { match: /\(\)/ },
          {
            className: 'params',
            begin: /\(/,
            end: /\)/,
            excludeBegin: true,
            excludeEnd: true,
            keywords: KEYWORDS,
            relevance: 0,
            contains: [
              STRING,
              NUMBERS,
              hljs.C_BLOCK_COMMENT_MODE
            ]
          },
          hljs.C_LINE_COMMENT_MODE,
          hljs.C_BLOCK_COMMENT_MODE
        ]
      },
      AT_IDENTIFIER
    ]
  };
}

module.exports = csharp;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/csp.js":
/*!********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/csp.js ***!
  \********************************************************/
/***/ (function(module) {

/*
Language: CSP
Description: Content Security Policy definition highlighting
Author: Taras <oxdef@oxdef.info>
Website: https://developer.mozilla.org/en-US/docs/Web/HTTP/CSP

vim: ts=2 sw=2 st=2
*/

/** @type LanguageFn */
function csp(hljs) {
  const KEYWORDS = [
    "base-uri",
    "child-src",
    "connect-src",
    "default-src",
    "font-src",
    "form-action",
    "frame-ancestors",
    "frame-src",
    "img-src",
    "manifest-src",
    "media-src",
    "object-src",
    "plugin-types",
    "report-uri",
    "sandbox",
    "script-src",
    "style-src",
    "trusted-types",
    "unsafe-hashes",
    "worker-src"
  ];
  return {
    name: 'CSP',
    case_insensitive: false,
    keywords: {
      $pattern: '[a-zA-Z][a-zA-Z0-9_-]*',
      keyword: KEYWORDS
    },
    contains: [
      {
        className: 'string',
        begin: "'",
        end: "'"
      },
      {
        className: 'attribute',
        begin: '^Content',
        end: ':',
        excludeEnd: true
      }
    ]
  };
}

module.exports = csp;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/css.js":
/*!********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/css.js ***!
  \********************************************************/
/***/ (function(module) {

const MODES = (hljs) => {
  return {
    IMPORTANT: {
      scope: 'meta',
      begin: '!important'
    },
    BLOCK_COMMENT: hljs.C_BLOCK_COMMENT_MODE,
    HEXCOLOR: {
      scope: 'number',
      begin: /#(([0-9a-fA-F]{3,4})|(([0-9a-fA-F]{2}){3,4}))\b/
    },
    FUNCTION_DISPATCH: {
      className: "built_in",
      begin: /[\w-]+(?=\()/
    },
    ATTRIBUTE_SELECTOR_MODE: {
      scope: 'selector-attr',
      begin: /\[/,
      end: /\]/,
      illegal: '$',
      contains: [
        hljs.APOS_STRING_MODE,
        hljs.QUOTE_STRING_MODE
      ]
    },
    CSS_NUMBER_MODE: {
      scope: 'number',
      begin: hljs.NUMBER_RE + '(' +
        '%|em|ex|ch|rem' +
        '|vw|vh|vmin|vmax' +
        '|cm|mm|in|pt|pc|px' +
        '|deg|grad|rad|turn' +
        '|s|ms' +
        '|Hz|kHz' +
        '|dpi|dpcm|dppx' +
        ')?',
      relevance: 0
    },
    CSS_VARIABLE: {
      className: "attr",
      begin: /--[A-Za-z][A-Za-z0-9_-]*/
    }
  };
};

const TAGS = [
  'a',
  'abbr',
  'address',
  'article',
  'aside',
  'audio',
  'b',
  'blockquote',
  'body',
  'button',
  'canvas',
  'caption',
  'cite',
  'code',
  'dd',
  'del',
  'details',
  'dfn',
  'div',
  'dl',
  'dt',
  'em',
  'fieldset',
  'figcaption',
  'figure',
  'footer',
  'form',
  'h1',
  'h2',
  'h3',
  'h4',
  'h5',
  'h6',
  'header',
  'hgroup',
  'html',
  'i',
  'iframe',
  'img',
  'input',
  'ins',
  'kbd',
  'label',
  'legend',
  'li',
  'main',
  'mark',
  'menu',
  'nav',
  'object',
  'ol',
  'p',
  'q',
  'quote',
  'samp',
  'section',
  'span',
  'strong',
  'summary',
  'sup',
  'table',
  'tbody',
  'td',
  'textarea',
  'tfoot',
  'th',
  'thead',
  'time',
  'tr',
  'ul',
  'var',
  'video'
];

const MEDIA_FEATURES = [
  'any-hover',
  'any-pointer',
  'aspect-ratio',
  'color',
  'color-gamut',
  'color-index',
  'device-aspect-ratio',
  'device-height',
  'device-width',
  'display-mode',
  'forced-colors',
  'grid',
  'height',
  'hover',
  'inverted-colors',
  'monochrome',
  'orientation',
  'overflow-block',
  'overflow-inline',
  'pointer',
  'prefers-color-scheme',
  'prefers-contrast',
  'prefers-reduced-motion',
  'prefers-reduced-transparency',
  'resolution',
  'scan',
  'scripting',
  'update',
  'width',
  // TODO: find a better solution?
  'min-width',
  'max-width',
  'min-height',
  'max-height'
];

// https://developer.mozilla.org/en-US/docs/Web/CSS/Pseudo-classes
const PSEUDO_CLASSES = [
  'active',
  'any-link',
  'blank',
  'checked',
  'current',
  'default',
  'defined',
  'dir', // dir()
  'disabled',
  'drop',
  'empty',
  'enabled',
  'first',
  'first-child',
  'first-of-type',
  'fullscreen',
  'future',
  'focus',
  'focus-visible',
  'focus-within',
  'has', // has()
  'host', // host or host()
  'host-context', // host-context()
  'hover',
  'indeterminate',
  'in-range',
  'invalid',
  'is', // is()
  'lang', // lang()
  'last-child',
  'last-of-type',
  'left',
  'link',
  'local-link',
  'not', // not()
  'nth-child', // nth-child()
  'nth-col', // nth-col()
  'nth-last-child', // nth-last-child()
  'nth-last-col', // nth-last-col()
  'nth-last-of-type', //nth-last-of-type()
  'nth-of-type', //nth-of-type()
  'only-child',
  'only-of-type',
  'optional',
  'out-of-range',
  'past',
  'placeholder-shown',
  'read-only',
  'read-write',
  'required',
  'right',
  'root',
  'scope',
  'target',
  'target-within',
  'user-invalid',
  'valid',
  'visited',
  'where' // where()
];

// https://developer.mozilla.org/en-US/docs/Web/CSS/Pseudo-elements
const PSEUDO_ELEMENTS = [
  'after',
  'backdrop',
  'before',
  'cue',
  'cue-region',
  'first-letter',
  'first-line',
  'grammar-error',
  'marker',
  'part',
  'placeholder',
  'selection',
  'slotted',
  'spelling-error'
];

const ATTRIBUTES = [
  'align-content',
  'align-items',
  'align-self',
  'all',
  'animation',
  'animation-delay',
  'animation-direction',
  'animation-duration',
  'animation-fill-mode',
  'animation-iteration-count',
  'animation-name',
  'animation-play-state',
  'animation-timing-function',
  'backface-visibility',
  'background',
  'background-attachment',
  'background-blend-mode',
  'background-clip',
  'background-color',
  'background-image',
  'background-origin',
  'background-position',
  'background-repeat',
  'background-size',
  'block-size',
  'border',
  'border-block',
  'border-block-color',
  'border-block-end',
  'border-block-end-color',
  'border-block-end-style',
  'border-block-end-width',
  'border-block-start',
  'border-block-start-color',
  'border-block-start-style',
  'border-block-start-width',
  'border-block-style',
  'border-block-width',
  'border-bottom',
  'border-bottom-color',
  'border-bottom-left-radius',
  'border-bottom-right-radius',
  'border-bottom-style',
  'border-bottom-width',
  'border-collapse',
  'border-color',
  'border-image',
  'border-image-outset',
  'border-image-repeat',
  'border-image-slice',
  'border-image-source',
  'border-image-width',
  'border-inline',
  'border-inline-color',
  'border-inline-end',
  'border-inline-end-color',
  'border-inline-end-style',
  'border-inline-end-width',
  'border-inline-start',
  'border-inline-start-color',
  'border-inline-start-style',
  'border-inline-start-width',
  'border-inline-style',
  'border-inline-width',
  'border-left',
  'border-left-color',
  'border-left-style',
  'border-left-width',
  'border-radius',
  'border-right',
  'border-right-color',
  'border-right-style',
  'border-right-width',
  'border-spacing',
  'border-style',
  'border-top',
  'border-top-color',
  'border-top-left-radius',
  'border-top-right-radius',
  'border-top-style',
  'border-top-width',
  'border-width',
  'bottom',
  'box-decoration-break',
  'box-shadow',
  'box-sizing',
  'break-after',
  'break-before',
  'break-inside',
  'caption-side',
  'caret-color',
  'clear',
  'clip',
  'clip-path',
  'clip-rule',
  'color',
  'column-count',
  'column-fill',
  'column-gap',
  'column-rule',
  'column-rule-color',
  'column-rule-style',
  'column-rule-width',
  'column-span',
  'column-width',
  'columns',
  'contain',
  'content',
  'content-visibility',
  'counter-increment',
  'counter-reset',
  'cue',
  'cue-after',
  'cue-before',
  'cursor',
  'direction',
  'display',
  'empty-cells',
  'filter',
  'flex',
  'flex-basis',
  'flex-direction',
  'flex-flow',
  'flex-grow',
  'flex-shrink',
  'flex-wrap',
  'float',
  'flow',
  'font',
  'font-display',
  'font-family',
  'font-feature-settings',
  'font-kerning',
  'font-language-override',
  'font-size',
  'font-size-adjust',
  'font-smoothing',
  'font-stretch',
  'font-style',
  'font-synthesis',
  'font-variant',
  'font-variant-caps',
  'font-variant-east-asian',
  'font-variant-ligatures',
  'font-variant-numeric',
  'font-variant-position',
  'font-variation-settings',
  'font-weight',
  'gap',
  'glyph-orientation-vertical',
  'grid',
  'grid-area',
  'grid-auto-columns',
  'grid-auto-flow',
  'grid-auto-rows',
  'grid-column',
  'grid-column-end',
  'grid-column-start',
  'grid-gap',
  'grid-row',
  'grid-row-end',
  'grid-row-start',
  'grid-template',
  'grid-template-areas',
  'grid-template-columns',
  'grid-template-rows',
  'hanging-punctuation',
  'height',
  'hyphens',
  'icon',
  'image-orientation',
  'image-rendering',
  'image-resolution',
  'ime-mode',
  'inline-size',
  'isolation',
  'justify-content',
  'left',
  'letter-spacing',
  'line-break',
  'line-height',
  'list-style',
  'list-style-image',
  'list-style-position',
  'list-style-type',
  'margin',
  'margin-block',
  'margin-block-end',
  'margin-block-start',
  'margin-bottom',
  'margin-inline',
  'margin-inline-end',
  'margin-inline-start',
  'margin-left',
  'margin-right',
  'margin-top',
  'marks',
  'mask',
  'mask-border',
  'mask-border-mode',
  'mask-border-outset',
  'mask-border-repeat',
  'mask-border-slice',
  'mask-border-source',
  'mask-border-width',
  'mask-clip',
  'mask-composite',
  'mask-image',
  'mask-mode',
  'mask-origin',
  'mask-position',
  'mask-repeat',
  'mask-size',
  'mask-type',
  'max-block-size',
  'max-height',
  'max-inline-size',
  'max-width',
  'min-block-size',
  'min-height',
  'min-inline-size',
  'min-width',
  'mix-blend-mode',
  'nav-down',
  'nav-index',
  'nav-left',
  'nav-right',
  'nav-up',
  'none',
  'normal',
  'object-fit',
  'object-position',
  'opacity',
  'order',
  'orphans',
  'outline',
  'outline-color',
  'outline-offset',
  'outline-style',
  'outline-width',
  'overflow',
  'overflow-wrap',
  'overflow-x',
  'overflow-y',
  'padding',
  'padding-block',
  'padding-block-end',
  'padding-block-start',
  'padding-bottom',
  'padding-inline',
  'padding-inline-end',
  'padding-inline-start',
  'padding-left',
  'padding-right',
  'padding-top',
  'page-break-after',
  'page-break-before',
  'page-break-inside',
  'pause',
  'pause-after',
  'pause-before',
  'perspective',
  'perspective-origin',
  'pointer-events',
  'position',
  'quotes',
  'resize',
  'rest',
  'rest-after',
  'rest-before',
  'right',
  'row-gap',
  'scroll-margin',
  'scroll-margin-block',
  'scroll-margin-block-end',
  'scroll-margin-block-start',
  'scroll-margin-bottom',
  'scroll-margin-inline',
  'scroll-margin-inline-end',
  'scroll-margin-inline-start',
  'scroll-margin-left',
  'scroll-margin-right',
  'scroll-margin-top',
  'scroll-padding',
  'scroll-padding-block',
  'scroll-padding-block-end',
  'scroll-padding-block-start',
  'scroll-padding-bottom',
  'scroll-padding-inline',
  'scroll-padding-inline-end',
  'scroll-padding-inline-start',
  'scroll-padding-left',
  'scroll-padding-right',
  'scroll-padding-top',
  'scroll-snap-align',
  'scroll-snap-stop',
  'scroll-snap-type',
  'scrollbar-color',
  'scrollbar-gutter',
  'scrollbar-width',
  'shape-image-threshold',
  'shape-margin',
  'shape-outside',
  'speak',
  'speak-as',
  'src', // @font-face
  'tab-size',
  'table-layout',
  'text-align',
  'text-align-all',
  'text-align-last',
  'text-combine-upright',
  'text-decoration',
  'text-decoration-color',
  'text-decoration-line',
  'text-decoration-style',
  'text-emphasis',
  'text-emphasis-color',
  'text-emphasis-position',
  'text-emphasis-style',
  'text-indent',
  'text-justify',
  'text-orientation',
  'text-overflow',
  'text-rendering',
  'text-shadow',
  'text-transform',
  'text-underline-position',
  'top',
  'transform',
  'transform-box',
  'transform-origin',
  'transform-style',
  'transition',
  'transition-delay',
  'transition-duration',
  'transition-property',
  'transition-timing-function',
  'unicode-bidi',
  'vertical-align',
  'visibility',
  'voice-balance',
  'voice-duration',
  'voice-family',
  'voice-pitch',
  'voice-range',
  'voice-rate',
  'voice-stress',
  'voice-volume',
  'white-space',
  'widows',
  'width',
  'will-change',
  'word-break',
  'word-spacing',
  'word-wrap',
  'writing-mode',
  'z-index'
  // reverse makes sure longer attributes `font-weight` are matched fully
  // instead of getting false positives on say `font`
].reverse();

/*
Language: CSS
Category: common, css, web
Website: https://developer.mozilla.org/en-US/docs/Web/CSS
*/

/** @type LanguageFn */
function css(hljs) {
  const regex = hljs.regex;
  const modes = MODES(hljs);
  const VENDOR_PREFIX = { begin: /-(webkit|moz|ms|o)-(?=[a-z])/ };
  const AT_MODIFIERS = "and or not only";
  const AT_PROPERTY_RE = /@-?\w[\w]*(-\w+)*/; // @-webkit-keyframes
  const IDENT_RE = '[a-zA-Z-][a-zA-Z0-9_-]*';
  const STRINGS = [
    hljs.APOS_STRING_MODE,
    hljs.QUOTE_STRING_MODE
  ];

  return {
    name: 'CSS',
    case_insensitive: true,
    illegal: /[=|'\$]/,
    keywords: { keyframePosition: "from to" },
    classNameAliases: {
      // for visual continuity with `tag {}` and because we
      // don't have a great class for this?
      keyframePosition: "selector-tag" },
    contains: [
      modes.BLOCK_COMMENT,
      VENDOR_PREFIX,
      // to recognize keyframe 40% etc which are outside the scope of our
      // attribute value mode
      modes.CSS_NUMBER_MODE,
      {
        className: 'selector-id',
        begin: /#[A-Za-z0-9_-]+/,
        relevance: 0
      },
      {
        className: 'selector-class',
        begin: '\\.' + IDENT_RE,
        relevance: 0
      },
      modes.ATTRIBUTE_SELECTOR_MODE,
      {
        className: 'selector-pseudo',
        variants: [
          { begin: ':(' + PSEUDO_CLASSES.join('|') + ')' },
          { begin: ':(:)?(' + PSEUDO_ELEMENTS.join('|') + ')' }
        ]
      },
      // we may actually need this (12/2020)
      // { // pseudo-selector params
      //   begin: /\(/,
      //   end: /\)/,
      //   contains: [ hljs.CSS_NUMBER_MODE ]
      // },
      modes.CSS_VARIABLE,
      {
        className: 'attribute',
        begin: '\\b(' + ATTRIBUTES.join('|') + ')\\b'
      },
      // attribute values
      {
        begin: /:/,
        end: /[;}{]/,
        contains: [
          modes.BLOCK_COMMENT,
          modes.HEXCOLOR,
          modes.IMPORTANT,
          modes.CSS_NUMBER_MODE,
          ...STRINGS,
          // needed to highlight these as strings and to avoid issues with
          // illegal characters that might be inside urls that would tigger the
          // languages illegal stack
          {
            begin: /(url|data-uri)\(/,
            end: /\)/,
            relevance: 0, // from keywords
            keywords: { built_in: "url data-uri" },
            contains: [
              ...STRINGS,
              {
                className: "string",
                // any character other than `)` as in `url()` will be the start
                // of a string, which ends with `)` (from the parent mode)
                begin: /[^)]/,
                endsWithParent: true,
                excludeEnd: true
              }
            ]
          },
          modes.FUNCTION_DISPATCH
        ]
      },
      {
        begin: regex.lookahead(/@/),
        end: '[{;]',
        relevance: 0,
        illegal: /:/, // break on Less variables @var: ...
        contains: [
          {
            className: 'keyword',
            begin: AT_PROPERTY_RE
          },
          {
            begin: /\s/,
            endsWithParent: true,
            excludeEnd: true,
            relevance: 0,
            keywords: {
              $pattern: /[a-z-]+/,
              keyword: AT_MODIFIERS,
              attribute: MEDIA_FEATURES.join(" ")
            },
            contains: [
              {
                begin: /[a-z-]+(?=:)/,
                className: "attribute"
              },
              ...STRINGS,
              modes.CSS_NUMBER_MODE
            ]
          }
        ]
      },
      {
        className: 'selector-tag',
        begin: '\\b(' + TAGS.join('|') + ')\\b'
      }
    ]
  };
}

module.exports = css;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/d.js":
/*!******************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/d.js ***!
  \******************************************************/
/***/ (function(module) {

/*
Language: D
Author: Aleksandar Ruzicic <aleksandar@ruzicic.info>
Description: D is a language with C-like syntax and static typing. It pragmatically combines efficiency, control, and modeling power, with safety and programmer productivity.
Version: 1.0a
Website: https://dlang.org
Date: 2012-04-08
*/

/**
 * Known issues:
 *
 * - invalid hex string literals will be recognized as a double quoted strings
 *   but 'x' at the beginning of string will not be matched
 *
 * - delimited string literals are not checked for matching end delimiter
 *   (not possible to do with js regexp)
 *
 * - content of token string is colored as a string (i.e. no keyword coloring inside a token string)
 *   also, content of token string is not validated to contain only valid D tokens
 *
 * - special token sequence rule is not strictly following D grammar (anything following #line
 *   up to the end of line is matched as special token sequence)
 */

/** @type LanguageFn */
function d(hljs) {
  /**
   * Language keywords
   *
   * @type {Object}
   */
  const D_KEYWORDS = {
    $pattern: hljs.UNDERSCORE_IDENT_RE,
    keyword:
      'abstract alias align asm assert auto body break byte case cast catch class '
      + 'const continue debug default delete deprecated do else enum export extern final '
      + 'finally for foreach foreach_reverse|10 goto if immutable import in inout int '
      + 'interface invariant is lazy macro mixin module new nothrow out override package '
      + 'pragma private protected public pure ref return scope shared static struct '
      + 'super switch synchronized template this throw try typedef typeid typeof union '
      + 'unittest version void volatile while with __FILE__ __LINE__ __gshared|10 '
      + '__thread __traits __DATE__ __EOF__ __TIME__ __TIMESTAMP__ __VENDOR__ __VERSION__',
    built_in:
      'bool cdouble cent cfloat char creal dchar delegate double dstring float function '
      + 'idouble ifloat ireal long real short string ubyte ucent uint ulong ushort wchar '
      + 'wstring',
    literal:
      'false null true'
  };

  /**
   * Number literal regexps
   *
   * @type {String}
   */
  const decimal_integer_re = '(0|[1-9][\\d_]*)';
  const decimal_integer_nosus_re = '(0|[1-9][\\d_]*|\\d[\\d_]*|[\\d_]+?\\d)';
  const binary_integer_re = '0[bB][01_]+';
  const hexadecimal_digits_re = '([\\da-fA-F][\\da-fA-F_]*|_[\\da-fA-F][\\da-fA-F_]*)';
  const hexadecimal_integer_re = '0[xX]' + hexadecimal_digits_re;

  const decimal_exponent_re = '([eE][+-]?' + decimal_integer_nosus_re + ')';
  const decimal_float_re = '(' + decimal_integer_nosus_re + '(\\.\\d*|' + decimal_exponent_re + ')|'
                + '\\d+\\.' + decimal_integer_nosus_re + '|'
                + '\\.' + decimal_integer_re + decimal_exponent_re + '?'
              + ')';
  const hexadecimal_float_re = '(0[xX]('
                  + hexadecimal_digits_re + '\\.' + hexadecimal_digits_re + '|'
                  + '\\.?' + hexadecimal_digits_re
                 + ')[pP][+-]?' + decimal_integer_nosus_re + ')';

  const integer_re = '('
      + decimal_integer_re + '|'
      + binary_integer_re + '|'
       + hexadecimal_integer_re
    + ')';

  const float_re = '('
      + hexadecimal_float_re + '|'
      + decimal_float_re
    + ')';

  /**
   * Escape sequence supported in D string and character literals
   *
   * @type {String}
   */
  const escape_sequence_re = '\\\\('
              + '[\'"\\?\\\\abfnrtv]|' // common escapes
              + 'u[\\dA-Fa-f]{4}|' // four hex digit unicode codepoint
              + '[0-7]{1,3}|' // one to three octal digit ascii char code
              + 'x[\\dA-Fa-f]{2}|' // two hex digit ascii char code
              + 'U[\\dA-Fa-f]{8}' // eight hex digit unicode codepoint
              + ')|'
              + '&[a-zA-Z\\d]{2,};'; // named character entity

  /**
   * D integer number literals
   *
   * @type {Object}
   */
  const D_INTEGER_MODE = {
    className: 'number',
    begin: '\\b' + integer_re + '(L|u|U|Lu|LU|uL|UL)?',
    relevance: 0
  };

  /**
   * [D_FLOAT_MODE description]
   * @type {Object}
   */
  const D_FLOAT_MODE = {
    className: 'number',
    begin: '\\b('
        + float_re + '([fF]|L|i|[fF]i|Li)?|'
        + integer_re + '(i|[fF]i|Li)'
      + ')',
    relevance: 0
  };

  /**
   * D character literal
   *
   * @type {Object}
   */
  const D_CHARACTER_MODE = {
    className: 'string',
    begin: '\'(' + escape_sequence_re + '|.)',
    end: '\'',
    illegal: '.'
  };

  /**
   * D string escape sequence
   *
   * @type {Object}
   */
  const D_ESCAPE_SEQUENCE = {
    begin: escape_sequence_re,
    relevance: 0
  };

  /**
   * D double quoted string literal
   *
   * @type {Object}
   */
  const D_STRING_MODE = {
    className: 'string',
    begin: '"',
    contains: [ D_ESCAPE_SEQUENCE ],
    end: '"[cwd]?'
  };

  /**
   * D wysiwyg and delimited string literals
   *
   * @type {Object}
   */
  const D_WYSIWYG_DELIMITED_STRING_MODE = {
    className: 'string',
    begin: '[rq]"',
    end: '"[cwd]?',
    relevance: 5
  };

  /**
   * D alternate wysiwyg string literal
   *
   * @type {Object}
   */
  const D_ALTERNATE_WYSIWYG_STRING_MODE = {
    className: 'string',
    begin: '`',
    end: '`[cwd]?'
  };

  /**
   * D hexadecimal string literal
   *
   * @type {Object}
   */
  const D_HEX_STRING_MODE = {
    className: 'string',
    begin: 'x"[\\da-fA-F\\s\\n\\r]*"[cwd]?',
    relevance: 10
  };

  /**
   * D delimited string literal
   *
   * @type {Object}
   */
  const D_TOKEN_STRING_MODE = {
    className: 'string',
    begin: 'q"\\{',
    end: '\\}"'
  };

  /**
   * Hashbang support
   *
   * @type {Object}
   */
  const D_HASHBANG_MODE = {
    className: 'meta',
    begin: '^#!',
    end: '$',
    relevance: 5
  };

  /**
   * D special token sequence
   *
   * @type {Object}
   */
  const D_SPECIAL_TOKEN_SEQUENCE_MODE = {
    className: 'meta',
    begin: '#(line)',
    end: '$',
    relevance: 5
  };

  /**
   * D attributes
   *
   * @type {Object}
   */
  const D_ATTRIBUTE_MODE = {
    className: 'keyword',
    begin: '@[a-zA-Z_][a-zA-Z_\\d]*'
  };

  /**
   * D nesting comment
   *
   * @type {Object}
   */
  const D_NESTING_COMMENT_MODE = hljs.COMMENT(
    '\\/\\+',
    '\\+\\/',
    {
      contains: [ 'self' ],
      relevance: 10
    }
  );

  return {
    name: 'D',
    keywords: D_KEYWORDS,
    contains: [
      hljs.C_LINE_COMMENT_MODE,
      hljs.C_BLOCK_COMMENT_MODE,
      D_NESTING_COMMENT_MODE,
      D_HEX_STRING_MODE,
      D_STRING_MODE,
      D_WYSIWYG_DELIMITED_STRING_MODE,
      D_ALTERNATE_WYSIWYG_STRING_MODE,
      D_TOKEN_STRING_MODE,
      D_FLOAT_MODE,
      D_INTEGER_MODE,
      D_CHARACTER_MODE,
      D_HASHBANG_MODE,
      D_SPECIAL_TOKEN_SEQUENCE_MODE,
      D_ATTRIBUTE_MODE
    ]
  };
}

module.exports = d;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/dart.js":
/*!*********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/dart.js ***!
  \*********************************************************/
/***/ (function(module) {

/*
Language: Dart
Requires: markdown.js
Author: Maxim Dikun <dikmax@gmail.com>
Description: Dart a modern, object-oriented language developed by Google. For more information see https://www.dartlang.org/
Website: https://dart.dev
Category: scripting
*/

/** @type LanguageFn */
function dart(hljs) {
  const SUBST = {
    className: 'subst',
    variants: [ { begin: '\\$[A-Za-z0-9_]+' } ]
  };

  const BRACED_SUBST = {
    className: 'subst',
    variants: [
      {
        begin: /\$\{/,
        end: /\}/
      }
    ],
    keywords: 'true false null this is new super'
  };

  const STRING = {
    className: 'string',
    variants: [
      {
        begin: 'r\'\'\'',
        end: '\'\'\''
      },
      {
        begin: 'r"""',
        end: '"""'
      },
      {
        begin: 'r\'',
        end: '\'',
        illegal: '\\n'
      },
      {
        begin: 'r"',
        end: '"',
        illegal: '\\n'
      },
      {
        begin: '\'\'\'',
        end: '\'\'\'',
        contains: [
          hljs.BACKSLASH_ESCAPE,
          SUBST,
          BRACED_SUBST
        ]
      },
      {
        begin: '"""',
        end: '"""',
        contains: [
          hljs.BACKSLASH_ESCAPE,
          SUBST,
          BRACED_SUBST
        ]
      },
      {
        begin: '\'',
        end: '\'',
        illegal: '\\n',
        contains: [
          hljs.BACKSLASH_ESCAPE,
          SUBST,
          BRACED_SUBST
        ]
      },
      {
        begin: '"',
        end: '"',
        illegal: '\\n',
        contains: [
          hljs.BACKSLASH_ESCAPE,
          SUBST,
          BRACED_SUBST
        ]
      }
    ]
  };
  BRACED_SUBST.contains = [
    hljs.C_NUMBER_MODE,
    STRING
  ];

  const BUILT_IN_TYPES = [
    // dart:core
    'Comparable',
    'DateTime',
    'Duration',
    'Function',
    'Iterable',
    'Iterator',
    'List',
    'Map',
    'Match',
    'Object',
    'Pattern',
    'RegExp',
    'Set',
    'Stopwatch',
    'String',
    'StringBuffer',
    'StringSink',
    'Symbol',
    'Type',
    'Uri',
    'bool',
    'double',
    'int',
    'num',
    // dart:html
    'Element',
    'ElementList'
  ];
  const NULLABLE_BUILT_IN_TYPES = BUILT_IN_TYPES.map((e) => `${e}?`);

  const BASIC_KEYWORDS = [
    "abstract",
    "as",
    "assert",
    "async",
    "await",
    "base",
    "break",
    "case",
    "catch",
    "class",
    "const",
    "continue",
    "covariant",
    "default",
    "deferred",
    "do",
    "dynamic",
    "else",
    "enum",
    "export",
    "extends",
    "extension",
    "external",
    "factory",
    "false",
    "final",
    "finally",
    "for",
    "Function",
    "get",
    "hide",
    "if",
    "implements",
    "import",
    "in",
    "interface",
    "is",
    "late",
    "library",
    "mixin",
    "new",
    "null",
    "on",
    "operator",
    "part",
    "required",
    "rethrow",
    "return",
    "sealed",
    "set",
    "show",
    "static",
    "super",
    "switch",
    "sync",
    "this",
    "throw",
    "true",
    "try",
    "typedef",
    "var",
    "void",
    "when",
    "while",
    "with",
    "yield"
  ];

  const KEYWORDS = {
    keyword: BASIC_KEYWORDS,
    built_in:
      BUILT_IN_TYPES
        .concat(NULLABLE_BUILT_IN_TYPES)
        .concat([
          // dart:core
          'Never',
          'Null',
          'dynamic',
          'print',
          // dart:html
          'document',
          'querySelector',
          'querySelectorAll',
          'window'
        ]),
    $pattern: /[A-Za-z][A-Za-z0-9_]*\??/
  };

  return {
    name: 'Dart',
    keywords: KEYWORDS,
    contains: [
      STRING,
      hljs.COMMENT(
        /\/\*\*(?!\/)/,
        /\*\//,
        {
          subLanguage: 'markdown',
          relevance: 0
        }
      ),
      hljs.COMMENT(
        /\/{3,} ?/,
        /$/, { contains: [
          {
            subLanguage: 'markdown',
            begin: '.',
            end: '$',
            relevance: 0
          }
        ] }
      ),
      hljs.C_LINE_COMMENT_MODE,
      hljs.C_BLOCK_COMMENT_MODE,
      {
        className: 'class',
        beginKeywords: 'class interface',
        end: /\{/,
        excludeEnd: true,
        contains: [
          { beginKeywords: 'extends implements' },
          hljs.UNDERSCORE_TITLE_MODE
        ]
      },
      hljs.C_NUMBER_MODE,
      {
        className: 'meta',
        begin: '@[A-Za-z]+'
      },
      { begin: '=>' // No markup, just a relevance booster
      }
    ]
  };
}

module.exports = dart;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/delphi.js":
/*!***********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/delphi.js ***!
  \***********************************************************/
/***/ (function(module) {

/*
Language: Delphi
Website: https://www.embarcadero.com/products/delphi
*/

/** @type LanguageFn */
function delphi(hljs) {
  const KEYWORDS = [
    "exports",
    "register",
    "file",
    "shl",
    "array",
    "record",
    "property",
    "for",
    "mod",
    "while",
    "set",
    "ally",
    "label",
    "uses",
    "raise",
    "not",
    "stored",
    "class",
    "safecall",
    "var",
    "interface",
    "or",
    "private",
    "static",
    "exit",
    "index",
    "inherited",
    "to",
    "else",
    "stdcall",
    "override",
    "shr",
    "asm",
    "far",
    "resourcestring",
    "finalization",
    "packed",
    "virtual",
    "out",
    "and",
    "protected",
    "library",
    "do",
    "xorwrite",
    "goto",
    "near",
    "function",
    "end",
    "div",
    "overload",
    "object",
    "unit",
    "begin",
    "string",
    "on",
    "inline",
    "repeat",
    "until",
    "destructor",
    "write",
    "message",
    "program",
    "with",
    "read",
    "initialization",
    "except",
    "default",
    "nil",
    "if",
    "case",
    "cdecl",
    "in",
    "downto",
    "threadvar",
    "of",
    "try",
    "pascal",
    "const",
    "external",
    "constructor",
    "type",
    "public",
    "then",
    "implementation",
    "finally",
    "published",
    "procedure",
    "absolute",
    "reintroduce",
    "operator",
    "as",
    "is",
    "abstract",
    "alias",
    "assembler",
    "bitpacked",
    "break",
    "continue",
    "cppdecl",
    "cvar",
    "enumerator",
    "experimental",
    "platform",
    "deprecated",
    "unimplemented",
    "dynamic",
    "export",
    "far16",
    "forward",
    "generic",
    "helper",
    "implements",
    "interrupt",
    "iochecks",
    "local",
    "name",
    "nodefault",
    "noreturn",
    "nostackframe",
    "oldfpccall",
    "otherwise",
    "saveregisters",
    "softfloat",
    "specialize",
    "strict",
    "unaligned",
    "varargs"
  ];
  const COMMENT_MODES = [
    hljs.C_LINE_COMMENT_MODE,
    hljs.COMMENT(/\{/, /\}/, { relevance: 0 }),
    hljs.COMMENT(/\(\*/, /\*\)/, { relevance: 10 })
  ];
  const DIRECTIVE = {
    className: 'meta',
    variants: [
      {
        begin: /\{\$/,
        end: /\}/
      },
      {
        begin: /\(\*\$/,
        end: /\*\)/
      }
    ]
  };
  const STRING = {
    className: 'string',
    begin: /'/,
    end: /'/,
    contains: [ { begin: /''/ } ]
  };
  const NUMBER = {
    className: 'number',
    relevance: 0,
    // Source: https://www.freepascal.org/docs-html/ref/refse6.html
    variants: [
      {
        // Hexadecimal notation, e.g., $7F.
        begin: '\\$[0-9A-Fa-f]+' },
      {
        // Octal notation, e.g., &42.
        begin: '&[0-7]+' },
      {
        // Binary notation, e.g., %1010.
        begin: '%[01]+' }
    ]
  };
  const CHAR_STRING = {
    className: 'string',
    begin: /(#\d+)+/
  };
  const CLASS = {
    begin: hljs.IDENT_RE + '\\s*=\\s*class\\s*\\(',
    returnBegin: true,
    contains: [ hljs.TITLE_MODE ]
  };
  const FUNCTION = {
    className: 'function',
    beginKeywords: 'function constructor destructor procedure',
    end: /[:;]/,
    keywords: 'function constructor|10 destructor|10 procedure|10',
    contains: [
      hljs.TITLE_MODE,
      {
        className: 'params',
        begin: /\(/,
        end: /\)/,
        keywords: KEYWORDS,
        contains: [
          STRING,
          CHAR_STRING,
          DIRECTIVE
        ].concat(COMMENT_MODES)
      },
      DIRECTIVE
    ].concat(COMMENT_MODES)
  };
  return {
    name: 'Delphi',
    aliases: [
      'dpr',
      'dfm',
      'pas',
      'pascal'
    ],
    case_insensitive: true,
    keywords: KEYWORDS,
    illegal: /"|\$[G-Zg-z]|\/\*|<\/|\|/,
    contains: [
      STRING,
      CHAR_STRING,
      hljs.NUMBER_MODE,
      NUMBER,
      CLASS,
      FUNCTION,
      DIRECTIVE
    ].concat(COMMENT_MODES)
  };
}

module.exports = delphi;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/diff.js":
/*!*********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/diff.js ***!
  \*********************************************************/
/***/ (function(module) {

/*
Language: Diff
Description: Unified and context diff
Author: Vasily Polovnyov <vast@whiteants.net>
Website: https://www.gnu.org/software/diffutils/
Category: common
*/

/** @type LanguageFn */
function diff(hljs) {
  const regex = hljs.regex;
  return {
    name: 'Diff',
    aliases: [ 'patch' ],
    contains: [
      {
        className: 'meta',
        relevance: 10,
        match: regex.either(
          /^@@ +-\d+,\d+ +\+\d+,\d+ +@@/,
          /^\*\*\* +\d+,\d+ +\*\*\*\*$/,
          /^--- +\d+,\d+ +----$/
        )
      },
      {
        className: 'comment',
        variants: [
          {
            begin: regex.either(
              /Index: /,
              /^index/,
              /={3,}/,
              /^-{3}/,
              /^\*{3} /,
              /^\+{3}/,
              /^diff --git/
            ),
            end: /$/
          },
          { match: /^\*{15}$/ }
        ]
      },
      {
        className: 'addition',
        begin: /^\+/,
        end: /$/
      },
      {
        className: 'deletion',
        begin: /^-/,
        end: /$/
      },
      {
        className: 'addition',
        begin: /^!/,
        end: /$/
      }
    ]
  };
}

module.exports = diff;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/django.js":
/*!***********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/django.js ***!
  \***********************************************************/
/***/ (function(module) {

/*
Language: Django
Description: Django is a high-level Python Web framework that encourages rapid development and clean, pragmatic design.
Requires: xml.js
Author: Ivan Sagalaev <maniac@softwaremaniacs.org>
Contributors: Ilya Baryshev <baryshev@gmail.com>
Website: https://www.djangoproject.com
Category: template
*/

/** @type LanguageFn */
function django(hljs) {
  const FILTER = {
    begin: /\|[A-Za-z]+:?/,
    keywords: { name:
        'truncatewords removetags linebreaksbr yesno get_digit timesince random striptags '
        + 'filesizeformat escape linebreaks length_is ljust rjust cut urlize fix_ampersands '
        + 'title floatformat capfirst pprint divisibleby add make_list unordered_list urlencode '
        + 'timeuntil urlizetrunc wordcount stringformat linenumbers slice date dictsort '
        + 'dictsortreversed default_if_none pluralize lower join center default '
        + 'truncatewords_html upper length phone2numeric wordwrap time addslashes slugify first '
        + 'escapejs force_escape iriencode last safe safeseq truncatechars localize unlocalize '
        + 'localtime utc timezone' },
    contains: [
      hljs.QUOTE_STRING_MODE,
      hljs.APOS_STRING_MODE
    ]
  };

  return {
    name: 'Django',
    aliases: [ 'jinja' ],
    case_insensitive: true,
    subLanguage: 'xml',
    contains: [
      hljs.COMMENT(/\{%\s*comment\s*%\}/, /\{%\s*endcomment\s*%\}/),
      hljs.COMMENT(/\{#/, /#\}/),
      {
        className: 'template-tag',
        begin: /\{%/,
        end: /%\}/,
        contains: [
          {
            className: 'name',
            begin: /\w+/,
            keywords: { name:
                'comment endcomment load templatetag ifchanged endifchanged if endif firstof for '
                + 'endfor ifnotequal endifnotequal widthratio extends include spaceless '
                + 'endspaceless regroup ifequal endifequal ssi now with cycle url filter '
                + 'endfilter debug block endblock else autoescape endautoescape csrf_token empty elif '
                + 'endwith static trans blocktrans endblocktrans get_static_prefix get_media_prefix '
                + 'plural get_current_language language get_available_languages '
                + 'get_current_language_bidi get_language_info get_language_info_list localize '
                + 'endlocalize localtime endlocaltime timezone endtimezone get_current_timezone '
                + 'verbatim' },
            starts: {
              endsWithParent: true,
              keywords: 'in by as',
              contains: [ FILTER ],
              relevance: 0
            }
          }
        ]
      },
      {
        className: 'template-variable',
        begin: /\{\{/,
        end: /\}\}/,
        contains: [ FILTER ]
      }
    ]
  };
}

module.exports = django;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/dns.js":
/*!********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/dns.js ***!
  \********************************************************/
/***/ (function(module) {

/*
Language: DNS Zone
Author: Tim Schumacher <tim@datenknoten.me>
Category: config
Website: https://en.wikipedia.org/wiki/Zone_file
*/

/** @type LanguageFn */
function dns(hljs) {
  const KEYWORDS = [
    "IN",
    "A",
    "AAAA",
    "AFSDB",
    "APL",
    "CAA",
    "CDNSKEY",
    "CDS",
    "CERT",
    "CNAME",
    "DHCID",
    "DLV",
    "DNAME",
    "DNSKEY",
    "DS",
    "HIP",
    "IPSECKEY",
    "KEY",
    "KX",
    "LOC",
    "MX",
    "NAPTR",
    "NS",
    "NSEC",
    "NSEC3",
    "NSEC3PARAM",
    "PTR",
    "RRSIG",
    "RP",
    "SIG",
    "SOA",
    "SRV",
    "SSHFP",
    "TA",
    "TKEY",
    "TLSA",
    "TSIG",
    "TXT"
  ];
  return {
    name: 'DNS Zone',
    aliases: [
      'bind',
      'zone'
    ],
    keywords: KEYWORDS,
    contains: [
      hljs.COMMENT(';', '$', { relevance: 0 }),
      {
        className: 'meta',
        begin: /^\$(TTL|GENERATE|INCLUDE|ORIGIN)\b/
      },
      // IPv6
      {
        className: 'number',
        begin: '((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))\\b'
      },
      // IPv4
      {
        className: 'number',
        begin: '((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\b'
      },
      hljs.inherit(hljs.NUMBER_MODE, { begin: /\b\d+[dhwm]?/ })
    ]
  };
}

module.exports = dns;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/dockerfile.js":
/*!***************************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/dockerfile.js ***!
  \***************************************************************/
/***/ (function(module) {

/*
Language: Dockerfile
Requires: bash.js
Author: Alexis Hénaut <alexis@henaut.net>
Description: language definition for Dockerfile files
Website: https://docs.docker.com/engine/reference/builder/
Category: config
*/

/** @type LanguageFn */
function dockerfile(hljs) {
  const KEYWORDS = [
    "from",
    "maintainer",
    "expose",
    "env",
    "arg",
    "user",
    "onbuild",
    "stopsignal"
  ];
  return {
    name: 'Dockerfile',
    aliases: [ 'docker' ],
    case_insensitive: true,
    keywords: KEYWORDS,
    contains: [
      hljs.HASH_COMMENT_MODE,
      hljs.APOS_STRING_MODE,
      hljs.QUOTE_STRING_MODE,
      hljs.NUMBER_MODE,
      {
        beginKeywords: 'run cmd entrypoint volume add copy workdir label healthcheck shell',
        starts: {
          end: /[^\\]$/,
          subLanguage: 'bash'
        }
      }
    ],
    illegal: '</'
  };
}

module.exports = dockerfile;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/dos.js":
/*!********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/dos.js ***!
  \********************************************************/
/***/ (function(module) {

/*
Language: Batch file (DOS)
Author: Alexander Makarov <sam@rmcreative.ru>
Contributors: Anton Kochkov <anton.kochkov@gmail.com>
Website: https://en.wikipedia.org/wiki/Batch_file
*/

/** @type LanguageFn */
function dos(hljs) {
  const COMMENT = hljs.COMMENT(
    /^\s*@?rem\b/, /$/,
    { relevance: 10 }
  );
  const LABEL = {
    className: 'symbol',
    begin: '^\\s*[A-Za-z._?][A-Za-z0-9_$#@~.?]*(:|\\s+label)',
    relevance: 0
  };
  const KEYWORDS = [
    "if",
    "else",
    "goto",
    "for",
    "in",
    "do",
    "call",
    "exit",
    "not",
    "exist",
    "errorlevel",
    "defined",
    "equ",
    "neq",
    "lss",
    "leq",
    "gtr",
    "geq"
  ];
  const BUILT_INS = [
    "prn",
    "nul",
    "lpt3",
    "lpt2",
    "lpt1",
    "con",
    "com4",
    "com3",
    "com2",
    "com1",
    "aux",
    "shift",
    "cd",
    "dir",
    "echo",
    "setlocal",
    "endlocal",
    "set",
    "pause",
    "copy",
    "append",
    "assoc",
    "at",
    "attrib",
    "break",
    "cacls",
    "cd",
    "chcp",
    "chdir",
    "chkdsk",
    "chkntfs",
    "cls",
    "cmd",
    "color",
    "comp",
    "compact",
    "convert",
    "date",
    "dir",
    "diskcomp",
    "diskcopy",
    "doskey",
    "erase",
    "fs",
    "find",
    "findstr",
    "format",
    "ftype",
    "graftabl",
    "help",
    "keyb",
    "label",
    "md",
    "mkdir",
    "mode",
    "more",
    "move",
    "path",
    "pause",
    "print",
    "popd",
    "pushd",
    "promt",
    "rd",
    "recover",
    "rem",
    "rename",
    "replace",
    "restore",
    "rmdir",
    "shift",
    "sort",
    "start",
    "subst",
    "time",
    "title",
    "tree",
    "type",
    "ver",
    "verify",
    "vol",
    // winutils
    "ping",
    "net",
    "ipconfig",
    "taskkill",
    "xcopy",
    "ren",
    "del"
  ];
  return {
    name: 'Batch file (DOS)',
    aliases: [
      'bat',
      'cmd'
    ],
    case_insensitive: true,
    illegal: /\/\*/,
    keywords: {
      keyword: KEYWORDS,
      built_in: BUILT_INS
    },
    contains: [
      {
        className: 'variable',
        begin: /%%[^ ]|%[^ ]+?%|![^ ]+?!/
      },
      {
        className: 'function',
        begin: LABEL.begin,
        end: 'goto:eof',
        contains: [
          hljs.inherit(hljs.TITLE_MODE, { begin: '([_a-zA-Z]\\w*\\.)*([_a-zA-Z]\\w*:)?[_a-zA-Z]\\w*' }),
          COMMENT
        ]
      },
      {
        className: 'number',
        begin: '\\b\\d+',
        relevance: 0
      },
      COMMENT
    ]
  };
}

module.exports = dos;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/dsconfig.js":
/*!*************************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/dsconfig.js ***!
  \*************************************************************/
/***/ (function(module) {

/*
 Language: dsconfig
 Description: dsconfig batch configuration language for LDAP directory servers
 Contributors: Jacob Childress <jacobc@gmail.com>
 Category: enterprise, config
 */

/** @type LanguageFn */
function dsconfig(hljs) {
  const QUOTED_PROPERTY = {
    className: 'string',
    begin: /"/,
    end: /"/
  };
  const APOS_PROPERTY = {
    className: 'string',
    begin: /'/,
    end: /'/
  };
  const UNQUOTED_PROPERTY = {
    className: 'string',
    begin: /[\w\-?]+:\w+/,
    end: /\W/,
    relevance: 0
  };
  const VALUELESS_PROPERTY = {
    className: 'string',
    begin: /\w+(\-\w+)*/,
    end: /(?=\W)/,
    relevance: 0
  };

  return {
    keywords: 'dsconfig',
    contains: [
      {
        className: 'keyword',
        begin: '^dsconfig',
        end: /\s/,
        excludeEnd: true,
        relevance: 10
      },
      {
        className: 'built_in',
        begin: /(list|create|get|set|delete)-(\w+)/,
        end: /\s/,
        excludeEnd: true,
        illegal: '!@#$%^&*()',
        relevance: 10
      },
      {
        className: 'built_in',
        begin: /--(\w+)/,
        end: /\s/,
        excludeEnd: true
      },
      QUOTED_PROPERTY,
      APOS_PROPERTY,
      UNQUOTED_PROPERTY,
      VALUELESS_PROPERTY,
      hljs.HASH_COMMENT_MODE
    ]
  };
}

module.exports = dsconfig;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/dts.js":
/*!********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/dts.js ***!
  \********************************************************/
/***/ (function(module) {

/*
Language: Device Tree
Description: *.dts files used in the Linux kernel
Author: Martin Braun <martin.braun@ettus.com>, Moritz Fischer <moritz.fischer@ettus.com>
Website: https://elinux.org/Device_Tree_Reference
Category: config
*/

/** @type LanguageFn */
function dts(hljs) {
  const STRINGS = {
    className: 'string',
    variants: [
      hljs.inherit(hljs.QUOTE_STRING_MODE, { begin: '((u8?|U)|L)?"' }),
      {
        begin: '(u8?|U)?R"',
        end: '"',
        contains: [ hljs.BACKSLASH_ESCAPE ]
      },
      {
        begin: '\'\\\\?.',
        end: '\'',
        illegal: '.'
      }
    ]
  };

  const NUMBERS = {
    className: 'number',
    variants: [
      { begin: '\\b(\\d+(\\.\\d*)?|\\.\\d+)(u|U|l|L|ul|UL|f|F)' },
      { begin: hljs.C_NUMBER_RE }
    ],
    relevance: 0
  };

  const PREPROCESSOR = {
    className: 'meta',
    begin: '#',
    end: '$',
    keywords: { keyword: 'if else elif endif define undef ifdef ifndef' },
    contains: [
      {
        begin: /\\\n/,
        relevance: 0
      },
      {
        beginKeywords: 'include',
        end: '$',
        keywords: { keyword: 'include' },
        contains: [
          hljs.inherit(STRINGS, { className: 'string' }),
          {
            className: 'string',
            begin: '<',
            end: '>',
            illegal: '\\n'
          }
        ]
      },
      STRINGS,
      hljs.C_LINE_COMMENT_MODE,
      hljs.C_BLOCK_COMMENT_MODE
    ]
  };

  const REFERENCE = {
    className: 'variable',
    begin: /&[a-z\d_]*\b/
  };

  const KEYWORD = {
    className: 'keyword',
    begin: '/[a-z][a-z\\d-]*/'
  };

  const LABEL = {
    className: 'symbol',
    begin: '^\\s*[a-zA-Z_][a-zA-Z\\d_]*:'
  };

  const CELL_PROPERTY = {
    className: 'params',
    relevance: 0,
    begin: '<',
    end: '>',
    contains: [
      NUMBERS,
      REFERENCE
    ]
  };

  const NODE = {
    className: 'title.class',
    begin: /[a-zA-Z_][a-zA-Z\d_@-]*(?=\s\{)/,
    relevance: 0.2
  };

  const ROOT_NODE = {
    className: 'title.class',
    begin: /^\/(?=\s*\{)/,
    relevance: 10
  };

  // TODO: `attribute` might be the right scope here, unsure
  // I'm not sure if all these key names have semantic meaning or not
  const ATTR_NO_VALUE = {
    match: /[a-z][a-z-,]+(?=;)/,
    relevance: 0,
    scope: "attr"
  };
  const ATTR = {
    relevance: 0,
    match: [
      /[a-z][a-z-,]+/,
      /\s*/,
      /=/
    ],
    scope: {
      1: "attr",
      3: "operator"
    }
  };

  const PUNC = {
    scope: "punctuation",
    relevance: 0,
    // `};` combined is just to avoid tons of useless punctuation nodes
    match: /\};|[;{}]/
  };

  return {
    name: 'Device Tree',
    contains: [
      ROOT_NODE,
      REFERENCE,
      KEYWORD,
      LABEL,
      NODE,
      ATTR,
      ATTR_NO_VALUE,
      CELL_PROPERTY,
      hljs.C_LINE_COMMENT_MODE,
      hljs.C_BLOCK_COMMENT_MODE,
      NUMBERS,
      STRINGS,
      PREPROCESSOR,
      PUNC,
      {
        begin: hljs.IDENT_RE + '::',
        keywords: ""
      }
    ]
  };
}

module.exports = dts;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/dust.js":
/*!*********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/dust.js ***!
  \*********************************************************/
/***/ (function(module) {

/*
Language: Dust
Requires: xml.js
Author: Michael Allen <michael.allen@benefitfocus.com>
Description: Matcher for dust.js templates.
Website: https://www.dustjs.com
Category: template
*/

/** @type LanguageFn */
function dust(hljs) {
  const EXPRESSION_KEYWORDS = 'if eq ne lt lte gt gte select default math sep';
  return {
    name: 'Dust',
    aliases: [ 'dst' ],
    case_insensitive: true,
    subLanguage: 'xml',
    contains: [
      {
        className: 'template-tag',
        begin: /\{[#\/]/,
        end: /\}/,
        illegal: /;/,
        contains: [
          {
            className: 'name',
            begin: /[a-zA-Z\.-]+/,
            starts: {
              endsWithParent: true,
              relevance: 0,
              contains: [ hljs.QUOTE_STRING_MODE ]
            }
          }
        ]
      },
      {
        className: 'template-variable',
        begin: /\{/,
        end: /\}/,
        illegal: /;/,
        keywords: EXPRESSION_KEYWORDS
      }
    ]
  };
}

module.exports = dust;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/ebnf.js":
/*!*********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/ebnf.js ***!
  \*********************************************************/
/***/ (function(module) {

/*
Language: Extended Backus-Naur Form
Author: Alex McKibben <alex@nullscope.net>
Website: https://en.wikipedia.org/wiki/Extended_Backus–Naur_form
*/

/** @type LanguageFn */
function ebnf(hljs) {
  const commentMode = hljs.COMMENT(/\(\*/, /\*\)/);

  const nonTerminalMode = {
    className: "attribute",
    begin: /^[ ]*[a-zA-Z]+([\s_-]+[a-zA-Z]+)*/
  };

  const specialSequenceMode = {
    className: "meta",
    begin: /\?.*\?/
  };

  const ruleBodyMode = {
    begin: /=/,
    end: /[.;]/,
    contains: [
      commentMode,
      specialSequenceMode,
      {
        // terminals
        className: 'string',
        variants: [
          hljs.APOS_STRING_MODE,
          hljs.QUOTE_STRING_MODE,
          {
            begin: '`',
            end: '`'
          }
        ]
      }
    ]
  };

  return {
    name: 'Extended Backus-Naur Form',
    illegal: /\S/,
    contains: [
      commentMode,
      nonTerminalMode,
      ruleBodyMode
    ]
  };
}

module.exports = ebnf;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/elixir.js":
/*!***********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/elixir.js ***!
  \***********************************************************/
/***/ (function(module) {

/*
Language: Elixir
Author: Josh Adams <josh@isotope11.com>
Description: language definition for Elixir source code files (.ex and .exs).  Based on ruby language support.
Category: functional
Website: https://elixir-lang.org
*/

/** @type LanguageFn */
function elixir(hljs) {
  const regex = hljs.regex;
  const ELIXIR_IDENT_RE = '[a-zA-Z_][a-zA-Z0-9_.]*(!|\\?)?';
  const ELIXIR_METHOD_RE = '[a-zA-Z_]\\w*[!?=]?|[-+~]@|<<|>>|=~|===?|<=>|[<>]=?|\\*\\*|[-/+%^&*~`|]|\\[\\]=?';
  const KEYWORDS = [
    "after",
    "alias",
    "and",
    "case",
    "catch",
    "cond",
    "defstruct",
    "defguard",
    "do",
    "else",
    "end",
    "fn",
    "for",
    "if",
    "import",
    "in",
    "not",
    "or",
    "quote",
    "raise",
    "receive",
    "require",
    "reraise",
    "rescue",
    "try",
    "unless",
    "unquote",
    "unquote_splicing",
    "use",
    "when",
    "with|0"
  ];
  const LITERALS = [
    "false",
    "nil",
    "true"
  ];
  const KWS = {
    $pattern: ELIXIR_IDENT_RE,
    keyword: KEYWORDS,
    literal: LITERALS
  };
  const SUBST = {
    className: 'subst',
    begin: /#\{/,
    end: /\}/,
    keywords: KWS
  };
  const NUMBER = {
    className: 'number',
    begin: '(\\b0o[0-7_]+)|(\\b0b[01_]+)|(\\b0x[0-9a-fA-F_]+)|(-?\\b[0-9][0-9_]*(\\.[0-9_]+([eE][-+]?[0-9]+)?)?)',
    relevance: 0
  };
  // TODO: could be tightened
  // https://elixir-lang.readthedocs.io/en/latest/intro/18.html
  // but you also need to include closing delemeters in the escape list per
  // individual sigil mode from what I can tell,
  // ie: \} might or might not be an escape depending on the sigil used
  const ESCAPES_RE = /\\[\s\S]/;
  // const ESCAPES_RE = /\\["'\\abdefnrstv0]/;
  const BACKSLASH_ESCAPE = {
    match: ESCAPES_RE,
    scope: "char.escape",
    relevance: 0
  };
  const SIGIL_DELIMITERS = '[/|([{<"\']';
  const SIGIL_DELIMITER_MODES = [
    {
      begin: /"/,
      end: /"/
    },
    {
      begin: /'/,
      end: /'/
    },
    {
      begin: /\//,
      end: /\//
    },
    {
      begin: /\|/,
      end: /\|/
    },
    {
      begin: /\(/,
      end: /\)/
    },
    {
      begin: /\[/,
      end: /\]/
    },
    {
      begin: /\{/,
      end: /\}/
    },
    {
      begin: /</,
      end: />/
    }
  ];
  const escapeSigilEnd = (end) => {
    return {
      scope: "char.escape",
      begin: regex.concat(/\\/, end),
      relevance: 0
    };
  };
  const LOWERCASE_SIGIL = {
    className: 'string',
    begin: '~[a-z]' + '(?=' + SIGIL_DELIMITERS + ')',
    contains: SIGIL_DELIMITER_MODES.map(x => hljs.inherit(x,
      { contains: [
        escapeSigilEnd(x.end),
        BACKSLASH_ESCAPE,
        SUBST
      ] }
    ))
  };

  const UPCASE_SIGIL = {
    className: 'string',
    begin: '~[A-Z]' + '(?=' + SIGIL_DELIMITERS + ')',
    contains: SIGIL_DELIMITER_MODES.map(x => hljs.inherit(x,
      { contains: [ escapeSigilEnd(x.end) ] }
    ))
  };

  const REGEX_SIGIL = {
    className: 'regex',
    variants: [
      {
        begin: '~r' + '(?=' + SIGIL_DELIMITERS + ')',
        contains: SIGIL_DELIMITER_MODES.map(x => hljs.inherit(x,
          {
            end: regex.concat(x.end, /[uismxfU]{0,7}/),
            contains: [
              escapeSigilEnd(x.end),
              BACKSLASH_ESCAPE,
              SUBST
            ]
          }
        ))
      },
      {
        begin: '~R' + '(?=' + SIGIL_DELIMITERS + ')',
        contains: SIGIL_DELIMITER_MODES.map(x => hljs.inherit(x,
          {
            end: regex.concat(x.end, /[uismxfU]{0,7}/),
            contains: [ escapeSigilEnd(x.end) ]
          })
        )
      }
    ]
  };

  const STRING = {
    className: 'string',
    contains: [
      hljs.BACKSLASH_ESCAPE,
      SUBST
    ],
    variants: [
      {
        begin: /"""/,
        end: /"""/
      },
      {
        begin: /'''/,
        end: /'''/
      },
      {
        begin: /~S"""/,
        end: /"""/,
        contains: [] // override default
      },
      {
        begin: /~S"/,
        end: /"/,
        contains: [] // override default
      },
      {
        begin: /~S'''/,
        end: /'''/,
        contains: [] // override default
      },
      {
        begin: /~S'/,
        end: /'/,
        contains: [] // override default
      },
      {
        begin: /'/,
        end: /'/
      },
      {
        begin: /"/,
        end: /"/
      }
    ]
  };
  const FUNCTION = {
    className: 'function',
    beginKeywords: 'def defp defmacro defmacrop',
    end: /\B\b/, // the mode is ended by the title
    contains: [
      hljs.inherit(hljs.TITLE_MODE, {
        begin: ELIXIR_IDENT_RE,
        endsParent: true
      })
    ]
  };
  const CLASS = hljs.inherit(FUNCTION, {
    className: 'class',
    beginKeywords: 'defimpl defmodule defprotocol defrecord',
    end: /\bdo\b|$|;/
  });
  const ELIXIR_DEFAULT_CONTAINS = [
    STRING,
    REGEX_SIGIL,
    UPCASE_SIGIL,
    LOWERCASE_SIGIL,
    hljs.HASH_COMMENT_MODE,
    CLASS,
    FUNCTION,
    { begin: '::' },
    {
      className: 'symbol',
      begin: ':(?![\\s:])',
      contains: [
        STRING,
        { begin: ELIXIR_METHOD_RE }
      ],
      relevance: 0
    },
    {
      className: 'symbol',
      begin: ELIXIR_IDENT_RE + ':(?!:)',
      relevance: 0
    },
    { // Usage of a module, struct, etc.
      className: 'title.class',
      begin: /(\b[A-Z][a-zA-Z0-9_]+)/,
      relevance: 0
    },
    NUMBER,
    {
      className: 'variable',
      begin: '(\\$\\W)|((\\$|@@?)(\\w+))'
    }
    // -> has been removed, capnproto always uses this grammar construct
  ];
  SUBST.contains = ELIXIR_DEFAULT_CONTAINS;

  return {
    name: 'Elixir',
    aliases: [
      'ex',
      'exs'
    ],
    keywords: KWS,
    contains: ELIXIR_DEFAULT_CONTAINS
  };
}

module.exports = elixir;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/elm.js":
/*!********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/elm.js ***!
  \********************************************************/
/***/ (function(module) {

/*
Language: Elm
Author: Janis Voigtlaender <janis.voigtlaender@gmail.com>
Website: https://elm-lang.org
Category: functional
*/

/** @type LanguageFn */
function elm(hljs) {
  const COMMENT = { variants: [
    hljs.COMMENT('--', '$'),
    hljs.COMMENT(
      /\{-/,
      /-\}/,
      { contains: [ 'self' ] }
    )
  ] };

  const CONSTRUCTOR = {
    className: 'type',
    begin: '\\b[A-Z][\\w\']*', // TODO: other constructors (built-in, infix).
    relevance: 0
  };

  const LIST = {
    begin: '\\(',
    end: '\\)',
    illegal: '"',
    contains: [
      {
        className: 'type',
        begin: '\\b[A-Z][\\w]*(\\((\\.\\.|,|\\w+)\\))?'
      },
      COMMENT
    ]
  };

  const RECORD = {
    begin: /\{/,
    end: /\}/,
    contains: LIST.contains
  };

  const CHARACTER = {
    className: 'string',
    begin: '\'\\\\?.',
    end: '\'',
    illegal: '.'
  };

  const KEYWORDS = [
    "let",
    "in",
    "if",
    "then",
    "else",
    "case",
    "of",
    "where",
    "module",
    "import",
    "exposing",
    "type",
    "alias",
    "as",
    "infix",
    "infixl",
    "infixr",
    "port",
    "effect",
    "command",
    "subscription"
  ];

  return {
    name: 'Elm',
    keywords: KEYWORDS,
    contains: [

      // Top-level constructions.

      {
        beginKeywords: 'port effect module',
        end: 'exposing',
        keywords: 'port effect module where command subscription exposing',
        contains: [
          LIST,
          COMMENT
        ],
        illegal: '\\W\\.|;'
      },
      {
        begin: 'import',
        end: '$',
        keywords: 'import as exposing',
        contains: [
          LIST,
          COMMENT
        ],
        illegal: '\\W\\.|;'
      },
      {
        begin: 'type',
        end: '$',
        keywords: 'type alias',
        contains: [
          CONSTRUCTOR,
          LIST,
          RECORD,
          COMMENT
        ]
      },
      {
        beginKeywords: 'infix infixl infixr',
        end: '$',
        contains: [
          hljs.C_NUMBER_MODE,
          COMMENT
        ]
      },
      {
        begin: 'port',
        end: '$',
        keywords: 'port',
        contains: [ COMMENT ]
      },

      // Literals and names.
      CHARACTER,
      hljs.QUOTE_STRING_MODE,
      hljs.C_NUMBER_MODE,
      CONSTRUCTOR,
      hljs.inherit(hljs.TITLE_MODE, { begin: '^[_a-z][\\w\']*' }),
      COMMENT,

      { // No markup, relevance booster
        begin: '->|<-' }
    ],
    illegal: /;/
  };
}

module.exports = elm;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/erb.js":
/*!********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/erb.js ***!
  \********************************************************/
/***/ (function(module) {

/*
Language: ERB (Embedded Ruby)
Requires: xml.js, ruby.js
Author: Lucas Mazza <lucastmazza@gmail.com>
Contributors: Kassio Borges <kassioborgesm@gmail.com>
Description: "Bridge" language defining fragments of Ruby in HTML within <% .. %>
Website: https://ruby-doc.org/stdlib-2.6.5/libdoc/erb/rdoc/ERB.html
Category: template
*/

/** @type LanguageFn */
function erb(hljs) {
  return {
    name: 'ERB',
    subLanguage: 'xml',
    contains: [
      hljs.COMMENT('<%#', '%>'),
      {
        begin: '<%[%=-]?',
        end: '[%-]?%>',
        subLanguage: 'ruby',
        excludeBegin: true,
        excludeEnd: true
      }
    ]
  };
}

module.exports = erb;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/erlang-repl.js":
/*!****************************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/erlang-repl.js ***!
  \****************************************************************/
/***/ (function(module) {

/*
Language: Erlang REPL
Author: Sergey Ignatov <sergey@ignatov.spb.su>
Website: https://www.erlang.org
Category: functional
*/

/** @type LanguageFn */
function erlangRepl(hljs) {
  const regex = hljs.regex;
  return {
    name: 'Erlang REPL',
    keywords: {
      built_in:
        'spawn spawn_link self',
      keyword:
        'after and andalso|10 band begin bnot bor bsl bsr bxor case catch cond div end fun if '
        + 'let not of or orelse|10 query receive rem try when xor'
    },
    contains: [
      {
        className: 'meta.prompt',
        begin: '^[0-9]+> ',
        relevance: 10
      },
      hljs.COMMENT('%', '$'),
      {
        className: 'number',
        begin: '\\b(\\d+(_\\d+)*#[a-fA-F0-9]+(_[a-fA-F0-9]+)*|\\d+(_\\d+)*(\\.\\d+(_\\d+)*)?([eE][-+]?\\d+)?)',
        relevance: 0
      },
      hljs.APOS_STRING_MODE,
      hljs.QUOTE_STRING_MODE,
      { begin: regex.concat(
        /\?(::)?/,
        /([A-Z]\w*)/, // at least one identifier
        /((::)[A-Z]\w*)*/ // perhaps more
      ) },
      { begin: '->' },
      { begin: 'ok' },
      { begin: '!' },
      {
        begin: '(\\b[a-z\'][a-zA-Z0-9_\']*:[a-z\'][a-zA-Z0-9_\']*)|(\\b[a-z\'][a-zA-Z0-9_\']*)',
        relevance: 0
      },
      {
        begin: '[A-Z][a-zA-Z0-9_\']*',
        relevance: 0
      }
    ]
  };
}

module.exports = erlangRepl;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/erlang.js":
/*!***********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/erlang.js ***!
  \***********************************************************/
/***/ (function(module) {

/*
Language: Erlang
Description: Erlang is a general-purpose functional language, with strict evaluation, single assignment, and dynamic typing.
Author: Nikolay Zakharov <nikolay.desh@gmail.com>, Dmitry Kovega <arhibot@gmail.com>
Website: https://www.erlang.org
Category: functional
*/

/** @type LanguageFn */
function erlang(hljs) {
  const BASIC_ATOM_RE = '[a-z\'][a-zA-Z0-9_\']*';
  const FUNCTION_NAME_RE = '(' + BASIC_ATOM_RE + ':' + BASIC_ATOM_RE + '|' + BASIC_ATOM_RE + ')';
  const ERLANG_RESERVED = {
    keyword:
      'after and andalso|10 band begin bnot bor bsl bzr bxor case catch cond div end fun if '
      + 'let not of orelse|10 query receive rem try when xor',
    literal:
      'false true'
  };

  const COMMENT = hljs.COMMENT('%', '$');
  const NUMBER = {
    className: 'number',
    begin: '\\b(\\d+(_\\d+)*#[a-fA-F0-9]+(_[a-fA-F0-9]+)*|\\d+(_\\d+)*(\\.\\d+(_\\d+)*)?([eE][-+]?\\d+)?)',
    relevance: 0
  };
  const NAMED_FUN = { begin: 'fun\\s+' + BASIC_ATOM_RE + '/\\d+' };
  const FUNCTION_CALL = {
    begin: FUNCTION_NAME_RE + '\\(',
    end: '\\)',
    returnBegin: true,
    relevance: 0,
    contains: [
      {
        begin: FUNCTION_NAME_RE,
        relevance: 0
      },
      {
        begin: '\\(',
        end: '\\)',
        endsWithParent: true,
        returnEnd: true,
        relevance: 0
        // "contains" defined later
      }
    ]
  };
  const TUPLE = {
    begin: /\{/,
    end: /\}/,
    relevance: 0
    // "contains" defined later
  };
  const VAR1 = {
    begin: '\\b_([A-Z][A-Za-z0-9_]*)?',
    relevance: 0
  };
  const VAR2 = {
    begin: '[A-Z][a-zA-Z0-9_]*',
    relevance: 0
  };
  const RECORD_ACCESS = {
    begin: '#' + hljs.UNDERSCORE_IDENT_RE,
    relevance: 0,
    returnBegin: true,
    contains: [
      {
        begin: '#' + hljs.UNDERSCORE_IDENT_RE,
        relevance: 0
      },
      {
        begin: /\{/,
        end: /\}/,
        relevance: 0
        // "contains" defined later
      }
    ]
  };

  const BLOCK_STATEMENTS = {
    beginKeywords: 'fun receive if try case',
    end: 'end',
    keywords: ERLANG_RESERVED
  };
  BLOCK_STATEMENTS.contains = [
    COMMENT,
    NAMED_FUN,
    hljs.inherit(hljs.APOS_STRING_MODE, { className: '' }),
    BLOCK_STATEMENTS,
    FUNCTION_CALL,
    hljs.QUOTE_STRING_MODE,
    NUMBER,
    TUPLE,
    VAR1,
    VAR2,
    RECORD_ACCESS
  ];

  const BASIC_MODES = [
    COMMENT,
    NAMED_FUN,
    BLOCK_STATEMENTS,
    FUNCTION_CALL,
    hljs.QUOTE_STRING_MODE,
    NUMBER,
    TUPLE,
    VAR1,
    VAR2,
    RECORD_ACCESS
  ];
  FUNCTION_CALL.contains[1].contains = BASIC_MODES;
  TUPLE.contains = BASIC_MODES;
  RECORD_ACCESS.contains[1].contains = BASIC_MODES;

  const DIRECTIVES = [
    "-module",
    "-record",
    "-undef",
    "-export",
    "-ifdef",
    "-ifndef",
    "-author",
    "-copyright",
    "-doc",
    "-vsn",
    "-import",
    "-include",
    "-include_lib",
    "-compile",
    "-define",
    "-else",
    "-endif",
    "-file",
    "-behaviour",
    "-behavior",
    "-spec"
  ];

  const PARAMS = {
    className: 'params',
    begin: '\\(',
    end: '\\)',
    contains: BASIC_MODES
  };
  return {
    name: 'Erlang',
    aliases: [ 'erl' ],
    keywords: ERLANG_RESERVED,
    illegal: '(</|\\*=|\\+=|-=|/\\*|\\*/|\\(\\*|\\*\\))',
    contains: [
      {
        className: 'function',
        begin: '^' + BASIC_ATOM_RE + '\\s*\\(',
        end: '->',
        returnBegin: true,
        illegal: '\\(|#|//|/\\*|\\\\|:|;',
        contains: [
          PARAMS,
          hljs.inherit(hljs.TITLE_MODE, { begin: BASIC_ATOM_RE })
        ],
        starts: {
          end: ';|\\.',
          keywords: ERLANG_RESERVED,
          contains: BASIC_MODES
        }
      },
      COMMENT,
      {
        begin: '^-',
        end: '\\.',
        relevance: 0,
        excludeEnd: true,
        returnBegin: true,
        keywords: {
          $pattern: '-' + hljs.IDENT_RE,
          keyword: DIRECTIVES.map(x => `${x}|1.5`).join(" ")
        },
        contains: [ PARAMS ]
      },
      NUMBER,
      hljs.QUOTE_STRING_MODE,
      RECORD_ACCESS,
      VAR1,
      VAR2,
      TUPLE,
      { begin: /\.$/ } // relevance booster
    ]
  };
}

module.exports = erlang;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/excel.js":
/*!**********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/excel.js ***!
  \**********************************************************/
/***/ (function(module) {

/*
Language: Excel formulae
Author: Victor Zhou <OiCMudkips@users.noreply.github.com>
Description: Excel formulae
Website: https://products.office.com/en-us/excel/
*/

/** @type LanguageFn */
function excel(hljs) {
  // built-in functions imported from https://web.archive.org/web/20160513042710/https://support.office.com/en-us/article/Excel-functions-alphabetical-b3944572-255d-4efb-bb96-c6d90033e188
  const BUILT_INS = [
    "ABS",
    "ACCRINT",
    "ACCRINTM",
    "ACOS",
    "ACOSH",
    "ACOT",
    "ACOTH",
    "AGGREGATE",
    "ADDRESS",
    "AMORDEGRC",
    "AMORLINC",
    "AND",
    "ARABIC",
    "AREAS",
    "ASC",
    "ASIN",
    "ASINH",
    "ATAN",
    "ATAN2",
    "ATANH",
    "AVEDEV",
    "AVERAGE",
    "AVERAGEA",
    "AVERAGEIF",
    "AVERAGEIFS",
    "BAHTTEXT",
    "BASE",
    "BESSELI",
    "BESSELJ",
    "BESSELK",
    "BESSELY",
    "BETADIST",
    "BETA.DIST",
    "BETAINV",
    "BETA.INV",
    "BIN2DEC",
    "BIN2HEX",
    "BIN2OCT",
    "BINOMDIST",
    "BINOM.DIST",
    "BINOM.DIST.RANGE",
    "BINOM.INV",
    "BITAND",
    "BITLSHIFT",
    "BITOR",
    "BITRSHIFT",
    "BITXOR",
    "CALL",
    "CEILING",
    "CEILING.MATH",
    "CEILING.PRECISE",
    "CELL",
    "CHAR",
    "CHIDIST",
    "CHIINV",
    "CHITEST",
    "CHISQ.DIST",
    "CHISQ.DIST.RT",
    "CHISQ.INV",
    "CHISQ.INV.RT",
    "CHISQ.TEST",
    "CHOOSE",
    "CLEAN",
    "CODE",
    "COLUMN",
    "COLUMNS",
    "COMBIN",
    "COMBINA",
    "COMPLEX",
    "CONCAT",
    "CONCATENATE",
    "CONFIDENCE",
    "CONFIDENCE.NORM",
    "CONFIDENCE.T",
    "CONVERT",
    "CORREL",
    "COS",
    "COSH",
    "COT",
    "COTH",
    "COUNT",
    "COUNTA",
    "COUNTBLANK",
    "COUNTIF",
    "COUNTIFS",
    "COUPDAYBS",
    "COUPDAYS",
    "COUPDAYSNC",
    "COUPNCD",
    "COUPNUM",
    "COUPPCD",
    "COVAR",
    "COVARIANCE.P",
    "COVARIANCE.S",
    "CRITBINOM",
    "CSC",
    "CSCH",
    "CUBEKPIMEMBER",
    "CUBEMEMBER",
    "CUBEMEMBERPROPERTY",
    "CUBERANKEDMEMBER",
    "CUBESET",
    "CUBESETCOUNT",
    "CUBEVALUE",
    "CUMIPMT",
    "CUMPRINC",
    "DATE",
    "DATEDIF",
    "DATEVALUE",
    "DAVERAGE",
    "DAY",
    "DAYS",
    "DAYS360",
    "DB",
    "DBCS",
    "DCOUNT",
    "DCOUNTA",
    "DDB",
    "DEC2BIN",
    "DEC2HEX",
    "DEC2OCT",
    "DECIMAL",
    "DEGREES",
    "DELTA",
    "DEVSQ",
    "DGET",
    "DISC",
    "DMAX",
    "DMIN",
    "DOLLAR",
    "DOLLARDE",
    "DOLLARFR",
    "DPRODUCT",
    "DSTDEV",
    "DSTDEVP",
    "DSUM",
    "DURATION",
    "DVAR",
    "DVARP",
    "EDATE",
    "EFFECT",
    "ENCODEURL",
    "EOMONTH",
    "ERF",
    "ERF.PRECISE",
    "ERFC",
    "ERFC.PRECISE",
    "ERROR.TYPE",
    "EUROCONVERT",
    "EVEN",
    "EXACT",
    "EXP",
    "EXPON.DIST",
    "EXPONDIST",
    "FACT",
    "FACTDOUBLE",
    "FALSE|0",
    "F.DIST",
    "FDIST",
    "F.DIST.RT",
    "FILTERXML",
    "FIND",
    "FINDB",
    "F.INV",
    "F.INV.RT",
    "FINV",
    "FISHER",
    "FISHERINV",
    "FIXED",
    "FLOOR",
    "FLOOR.MATH",
    "FLOOR.PRECISE",
    "FORECAST",
    "FORECAST.ETS",
    "FORECAST.ETS.CONFINT",
    "FORECAST.ETS.SEASONALITY",
    "FORECAST.ETS.STAT",
    "FORECAST.LINEAR",
    "FORMULATEXT",
    "FREQUENCY",
    "F.TEST",
    "FTEST",
    "FV",
    "FVSCHEDULE",
    "GAMMA",
    "GAMMA.DIST",
    "GAMMADIST",
    "GAMMA.INV",
    "GAMMAINV",
    "GAMMALN",
    "GAMMALN.PRECISE",
    "GAUSS",
    "GCD",
    "GEOMEAN",
    "GESTEP",
    "GETPIVOTDATA",
    "GROWTH",
    "HARMEAN",
    "HEX2BIN",
    "HEX2DEC",
    "HEX2OCT",
    "HLOOKUP",
    "HOUR",
    "HYPERLINK",
    "HYPGEOM.DIST",
    "HYPGEOMDIST",
    "IF",
    "IFERROR",
    "IFNA",
    "IFS",
    "IMABS",
    "IMAGINARY",
    "IMARGUMENT",
    "IMCONJUGATE",
    "IMCOS",
    "IMCOSH",
    "IMCOT",
    "IMCSC",
    "IMCSCH",
    "IMDIV",
    "IMEXP",
    "IMLN",
    "IMLOG10",
    "IMLOG2",
    "IMPOWER",
    "IMPRODUCT",
    "IMREAL",
    "IMSEC",
    "IMSECH",
    "IMSIN",
    "IMSINH",
    "IMSQRT",
    "IMSUB",
    "IMSUM",
    "IMTAN",
    "INDEX",
    "INDIRECT",
    "INFO",
    "INT",
    "INTERCEPT",
    "INTRATE",
    "IPMT",
    "IRR",
    "ISBLANK",
    "ISERR",
    "ISERROR",
    "ISEVEN",
    "ISFORMULA",
    "ISLOGICAL",
    "ISNA",
    "ISNONTEXT",
    "ISNUMBER",
    "ISODD",
    "ISREF",
    "ISTEXT",
    "ISO.CEILING",
    "ISOWEEKNUM",
    "ISPMT",
    "JIS",
    "KURT",
    "LARGE",
    "LCM",
    "LEFT",
    "LEFTB",
    "LEN",
    "LENB",
    "LINEST",
    "LN",
    "LOG",
    "LOG10",
    "LOGEST",
    "LOGINV",
    "LOGNORM.DIST",
    "LOGNORMDIST",
    "LOGNORM.INV",
    "LOOKUP",
    "LOWER",
    "MATCH",
    "MAX",
    "MAXA",
    "MAXIFS",
    "MDETERM",
    "MDURATION",
    "MEDIAN",
    "MID",
    "MIDBs",
    "MIN",
    "MINIFS",
    "MINA",
    "MINUTE",
    "MINVERSE",
    "MIRR",
    "MMULT",
    "MOD",
    "MODE",
    "MODE.MULT",
    "MODE.SNGL",
    "MONTH",
    "MROUND",
    "MULTINOMIAL",
    "MUNIT",
    "N",
    "NA",
    "NEGBINOM.DIST",
    "NEGBINOMDIST",
    "NETWORKDAYS",
    "NETWORKDAYS.INTL",
    "NOMINAL",
    "NORM.DIST",
    "NORMDIST",
    "NORMINV",
    "NORM.INV",
    "NORM.S.DIST",
    "NORMSDIST",
    "NORM.S.INV",
    "NORMSINV",
    "NOT",
    "NOW",
    "NPER",
    "NPV",
    "NUMBERVALUE",
    "OCT2BIN",
    "OCT2DEC",
    "OCT2HEX",
    "ODD",
    "ODDFPRICE",
    "ODDFYIELD",
    "ODDLPRICE",
    "ODDLYIELD",
    "OFFSET",
    "OR",
    "PDURATION",
    "PEARSON",
    "PERCENTILE.EXC",
    "PERCENTILE.INC",
    "PERCENTILE",
    "PERCENTRANK.EXC",
    "PERCENTRANK.INC",
    "PERCENTRANK",
    "PERMUT",
    "PERMUTATIONA",
    "PHI",
    "PHONETIC",
    "PI",
    "PMT",
    "POISSON.DIST",
    "POISSON",
    "POWER",
    "PPMT",
    "PRICE",
    "PRICEDISC",
    "PRICEMAT",
    "PROB",
    "PRODUCT",
    "PROPER",
    "PV",
    "QUARTILE",
    "QUARTILE.EXC",
    "QUARTILE.INC",
    "QUOTIENT",
    "RADIANS",
    "RAND",
    "RANDBETWEEN",
    "RANK.AVG",
    "RANK.EQ",
    "RANK",
    "RATE",
    "RECEIVED",
    "REGISTER.ID",
    "REPLACE",
    "REPLACEB",
    "REPT",
    "RIGHT",
    "RIGHTB",
    "ROMAN",
    "ROUND",
    "ROUNDDOWN",
    "ROUNDUP",
    "ROW",
    "ROWS",
    "RRI",
    "RSQ",
    "RTD",
    "SEARCH",
    "SEARCHB",
    "SEC",
    "SECH",
    "SECOND",
    "SERIESSUM",
    "SHEET",
    "SHEETS",
    "SIGN",
    "SIN",
    "SINH",
    "SKEW",
    "SKEW.P",
    "SLN",
    "SLOPE",
    "SMALL",
    "SQL.REQUEST",
    "SQRT",
    "SQRTPI",
    "STANDARDIZE",
    "STDEV",
    "STDEV.P",
    "STDEV.S",
    "STDEVA",
    "STDEVP",
    "STDEVPA",
    "STEYX",
    "SUBSTITUTE",
    "SUBTOTAL",
    "SUM",
    "SUMIF",
    "SUMIFS",
    "SUMPRODUCT",
    "SUMSQ",
    "SUMX2MY2",
    "SUMX2PY2",
    "SUMXMY2",
    "SWITCH",
    "SYD",
    "T",
    "TAN",
    "TANH",
    "TBILLEQ",
    "TBILLPRICE",
    "TBILLYIELD",
    "T.DIST",
    "T.DIST.2T",
    "T.DIST.RT",
    "TDIST",
    "TEXT",
    "TEXTJOIN",
    "TIME",
    "TIMEVALUE",
    "T.INV",
    "T.INV.2T",
    "TINV",
    "TODAY",
    "TRANSPOSE",
    "TREND",
    "TRIM",
    "TRIMMEAN",
    "TRUE|0",
    "TRUNC",
    "T.TEST",
    "TTEST",
    "TYPE",
    "UNICHAR",
    "UNICODE",
    "UPPER",
    "VALUE",
    "VAR",
    "VAR.P",
    "VAR.S",
    "VARA",
    "VARP",
    "VARPA",
    "VDB",
    "VLOOKUP",
    "WEBSERVICE",
    "WEEKDAY",
    "WEEKNUM",
    "WEIBULL",
    "WEIBULL.DIST",
    "WORKDAY",
    "WORKDAY.INTL",
    "XIRR",
    "XNPV",
    "XOR",
    "YEAR",
    "YEARFRAC",
    "YIELD",
    "YIELDDISC",
    "YIELDMAT",
    "Z.TEST",
    "ZTEST"
  ];
  return {
    name: 'Excel formulae',
    aliases: [
      'xlsx',
      'xls'
    ],
    case_insensitive: true,
    keywords: {
      $pattern: /[a-zA-Z][\w\.]*/,
      built_in: BUILT_INS
    },
    contains: [
      {
        /* matches a beginning equal sign found in Excel formula examples */
        begin: /^=/,
        end: /[^=]/,
        returnEnd: true,
        illegal: /=/, /* only allow single equal sign at front of line */
        relevance: 10
      },
      /* technically, there can be more than 2 letters in column names, but this prevents conflict with some keywords */
      {
        /* matches a reference to a single cell */
        className: 'symbol',
        begin: /\b[A-Z]{1,2}\d+\b/,
        end: /[^\d]/,
        excludeEnd: true,
        relevance: 0
      },
      {
        /* matches a reference to a range of cells */
        className: 'symbol',
        begin: /[A-Z]{0,2}\d*:[A-Z]{0,2}\d*/,
        relevance: 0
      },
      hljs.BACKSLASH_ESCAPE,
      hljs.QUOTE_STRING_MODE,
      {
        className: 'number',
        begin: hljs.NUMBER_RE + '(%)?',
        relevance: 0
      },
      /* Excel formula comments are done by putting the comment in a function call to N() */
      hljs.COMMENT(/\bN\(/, /\)/,
        {
          excludeBegin: true,
          excludeEnd: true,
          illegal: /\n/
        })
    ]
  };
}

module.exports = excel;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/fix.js":
/*!********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/fix.js ***!
  \********************************************************/
/***/ (function(module) {

/*
Language: FIX
Author: Brent Bradbury <brent@brentium.com>
*/

/** @type LanguageFn */
function fix(hljs) {
  return {
    name: 'FIX',
    contains: [
      {
        begin: /[^\u2401\u0001]+/,
        end: /[\u2401\u0001]/,
        excludeEnd: true,
        returnBegin: true,
        returnEnd: false,
        contains: [
          {
            begin: /([^\u2401\u0001=]+)/,
            end: /=([^\u2401\u0001=]+)/,
            returnEnd: true,
            returnBegin: false,
            className: 'attr'
          },
          {
            begin: /=/,
            end: /([\u2401\u0001])/,
            excludeEnd: true,
            excludeBegin: true,
            className: 'string'
          }
        ]
      }
    ],
    case_insensitive: true
  };
}

module.exports = fix;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/flix.js":
/*!*********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/flix.js ***!
  \*********************************************************/
/***/ (function(module) {

/*
 Language: Flix
 Category: functional
 Author: Magnus Madsen <mmadsen@uwaterloo.ca>
 Website: https://flix.dev/
 */

/** @type LanguageFn */
function flix(hljs) {
  const CHAR = {
    className: 'string',
    begin: /'(.|\\[xXuU][a-zA-Z0-9]+)'/
  };

  const STRING = {
    className: 'string',
    variants: [
      {
        begin: '"',
        end: '"'
      }
    ]
  };

  const NAME = {
    className: 'title',
    relevance: 0,
    begin: /[^0-9\n\t "'(),.`{}\[\]:;][^\n\t "'(),.`{}\[\]:;]+|[^0-9\n\t "'(),.`{}\[\]:;=]/
  };

  const METHOD = {
    className: 'function',
    beginKeywords: 'def',
    end: /[:={\[(\n;]/,
    excludeEnd: true,
    contains: [ NAME ]
  };

  return {
    name: 'Flix',
    keywords: {
      keyword: [
        "case",
        "class",
        "def",
        "else",
        "enum",
        "if",
        "impl",
        "import",
        "in",
        "lat",
        "rel",
        "index",
        "let",
        "match",
        "namespace",
        "switch",
        "type",
        "yield",
        "with"
      ],
      literal: [
        "true",
        "false"
      ]
    },
    contains: [
      hljs.C_LINE_COMMENT_MODE,
      hljs.C_BLOCK_COMMENT_MODE,
      CHAR,
      STRING,
      METHOD,
      hljs.C_NUMBER_MODE
    ]
  };
}

module.exports = flix;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/fortran.js":
/*!************************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/fortran.js ***!
  \************************************************************/
/***/ (function(module) {

/*
Language: Fortran
Author: Anthony Scemama <scemama@irsamc.ups-tlse.fr>
Website: https://en.wikipedia.org/wiki/Fortran
Category: scientific
*/

/** @type LanguageFn */
function fortran(hljs) {
  const regex = hljs.regex;
  const PARAMS = {
    className: 'params',
    begin: '\\(',
    end: '\\)'
  };

  const COMMENT = { variants: [
    hljs.COMMENT('!', '$', { relevance: 0 }),
    // allow FORTRAN 77 style comments
    hljs.COMMENT('^C[ ]', '$', { relevance: 0 }),
    hljs.COMMENT('^C$', '$', { relevance: 0 })
  ] };

  // regex in both fortran and irpf90 should match
  const OPTIONAL_NUMBER_SUFFIX = /(_[a-z_\d]+)?/;
  const OPTIONAL_NUMBER_EXP = /([de][+-]?\d+)?/;
  const NUMBER = {
    className: 'number',
    variants: [
      { begin: regex.concat(/\b\d+/, /\.(\d*)/, OPTIONAL_NUMBER_EXP, OPTIONAL_NUMBER_SUFFIX) },
      { begin: regex.concat(/\b\d+/, OPTIONAL_NUMBER_EXP, OPTIONAL_NUMBER_SUFFIX) },
      { begin: regex.concat(/\.\d+/, OPTIONAL_NUMBER_EXP, OPTIONAL_NUMBER_SUFFIX) }
    ],
    relevance: 0
  };

  const FUNCTION_DEF = {
    className: 'function',
    beginKeywords: 'subroutine function program',
    illegal: '[${=\\n]',
    contains: [
      hljs.UNDERSCORE_TITLE_MODE,
      PARAMS
    ]
  };

  const STRING = {
    className: 'string',
    relevance: 0,
    variants: [
      hljs.APOS_STRING_MODE,
      hljs.QUOTE_STRING_MODE
    ]
  };

  const KEYWORDS = [
    "kind",
    "do",
    "concurrent",
    "local",
    "shared",
    "while",
    "private",
    "call",
    "intrinsic",
    "where",
    "elsewhere",
    "type",
    "endtype",
    "endmodule",
    "endselect",
    "endinterface",
    "end",
    "enddo",
    "endif",
    "if",
    "forall",
    "endforall",
    "only",
    "contains",
    "default",
    "return",
    "stop",
    "then",
    "block",
    "endblock",
    "endassociate",
    "public",
    "subroutine|10",
    "function",
    "program",
    ".and.",
    ".or.",
    ".not.",
    ".le.",
    ".eq.",
    ".ge.",
    ".gt.",
    ".lt.",
    "goto",
    "save",
    "else",
    "use",
    "module",
    "select",
    "case",
    "access",
    "blank",
    "direct",
    "exist",
    "file",
    "fmt",
    "form",
    "formatted",
    "iostat",
    "name",
    "named",
    "nextrec",
    "number",
    "opened",
    "rec",
    "recl",
    "sequential",
    "status",
    "unformatted",
    "unit",
    "continue",
    "format",
    "pause",
    "cycle",
    "exit",
    "c_null_char",
    "c_alert",
    "c_backspace",
    "c_form_feed",
    "flush",
    "wait",
    "decimal",
    "round",
    "iomsg",
    "synchronous",
    "nopass",
    "non_overridable",
    "pass",
    "protected",
    "volatile",
    "abstract",
    "extends",
    "import",
    "non_intrinsic",
    "value",
    "deferred",
    "generic",
    "final",
    "enumerator",
    "class",
    "associate",
    "bind",
    "enum",
    "c_int",
    "c_short",
    "c_long",
    "c_long_long",
    "c_signed_char",
    "c_size_t",
    "c_int8_t",
    "c_int16_t",
    "c_int32_t",
    "c_int64_t",
    "c_int_least8_t",
    "c_int_least16_t",
    "c_int_least32_t",
    "c_int_least64_t",
    "c_int_fast8_t",
    "c_int_fast16_t",
    "c_int_fast32_t",
    "c_int_fast64_t",
    "c_intmax_t",
    "C_intptr_t",
    "c_float",
    "c_double",
    "c_long_double",
    "c_float_complex",
    "c_double_complex",
    "c_long_double_complex",
    "c_bool",
    "c_char",
    "c_null_ptr",
    "c_null_funptr",
    "c_new_line",
    "c_carriage_return",
    "c_horizontal_tab",
    "c_vertical_tab",
    "iso_c_binding",
    "c_loc",
    "c_funloc",
    "c_associated",
    "c_f_pointer",
    "c_ptr",
    "c_funptr",
    "iso_fortran_env",
    "character_storage_size",
    "error_unit",
    "file_storage_size",
    "input_unit",
    "iostat_end",
    "iostat_eor",
    "numeric_storage_size",
    "output_unit",
    "c_f_procpointer",
    "ieee_arithmetic",
    "ieee_support_underflow_control",
    "ieee_get_underflow_mode",
    "ieee_set_underflow_mode",
    "newunit",
    "contiguous",
    "recursive",
    "pad",
    "position",
    "action",
    "delim",
    "readwrite",
    "eor",
    "advance",
    "nml",
    "interface",
    "procedure",
    "namelist",
    "include",
    "sequence",
    "elemental",
    "pure",
    "impure",
    "integer",
    "real",
    "character",
    "complex",
    "logical",
    "codimension",
    "dimension",
    "allocatable|10",
    "parameter",
    "external",
    "implicit|10",
    "none",
    "double",
    "precision",
    "assign",
    "intent",
    "optional",
    "pointer",
    "target",
    "in",
    "out",
    "common",
    "equivalence",
    "data"
  ];
  const LITERALS = [
    ".False.",
    ".True."
  ];
  const BUILT_INS = [
    "alog",
    "alog10",
    "amax0",
    "amax1",
    "amin0",
    "amin1",
    "amod",
    "cabs",
    "ccos",
    "cexp",
    "clog",
    "csin",
    "csqrt",
    "dabs",
    "dacos",
    "dasin",
    "datan",
    "datan2",
    "dcos",
    "dcosh",
    "ddim",
    "dexp",
    "dint",
    "dlog",
    "dlog10",
    "dmax1",
    "dmin1",
    "dmod",
    "dnint",
    "dsign",
    "dsin",
    "dsinh",
    "dsqrt",
    "dtan",
    "dtanh",
    "float",
    "iabs",
    "idim",
    "idint",
    "idnint",
    "ifix",
    "isign",
    "max0",
    "max1",
    "min0",
    "min1",
    "sngl",
    "algama",
    "cdabs",
    "cdcos",
    "cdexp",
    "cdlog",
    "cdsin",
    "cdsqrt",
    "cqabs",
    "cqcos",
    "cqexp",
    "cqlog",
    "cqsin",
    "cqsqrt",
    "dcmplx",
    "dconjg",
    "derf",
    "derfc",
    "dfloat",
    "dgamma",
    "dimag",
    "dlgama",
    "iqint",
    "qabs",
    "qacos",
    "qasin",
    "qatan",
    "qatan2",
    "qcmplx",
    "qconjg",
    "qcos",
    "qcosh",
    "qdim",
    "qerf",
    "qerfc",
    "qexp",
    "qgamma",
    "qimag",
    "qlgama",
    "qlog",
    "qlog10",
    "qmax1",
    "qmin1",
    "qmod",
    "qnint",
    "qsign",
    "qsin",
    "qsinh",
    "qsqrt",
    "qtan",
    "qtanh",
    "abs",
    "acos",
    "aimag",
    "aint",
    "anint",
    "asin",
    "atan",
    "atan2",
    "char",
    "cmplx",
    "conjg",
    "cos",
    "cosh",
    "exp",
    "ichar",
    "index",
    "int",
    "log",
    "log10",
    "max",
    "min",
    "nint",
    "sign",
    "sin",
    "sinh",
    "sqrt",
    "tan",
    "tanh",
    "print",
    "write",
    "dim",
    "lge",
    "lgt",
    "lle",
    "llt",
    "mod",
    "nullify",
    "allocate",
    "deallocate",
    "adjustl",
    "adjustr",
    "all",
    "allocated",
    "any",
    "associated",
    "bit_size",
    "btest",
    "ceiling",
    "count",
    "cshift",
    "date_and_time",
    "digits",
    "dot_product",
    "eoshift",
    "epsilon",
    "exponent",
    "floor",
    "fraction",
    "huge",
    "iand",
    "ibclr",
    "ibits",
    "ibset",
    "ieor",
    "ior",
    "ishft",
    "ishftc",
    "lbound",
    "len_trim",
    "matmul",
    "maxexponent",
    "maxloc",
    "maxval",
    "merge",
    "minexponent",
    "minloc",
    "minval",
    "modulo",
    "mvbits",
    "nearest",
    "pack",
    "present",
    "product",
    "radix",
    "random_number",
    "random_seed",
    "range",
    "repeat",
    "reshape",
    "rrspacing",
    "scale",
    "scan",
    "selected_int_kind",
    "selected_real_kind",
    "set_exponent",
    "shape",
    "size",
    "spacing",
    "spread",
    "sum",
    "system_clock",
    "tiny",
    "transpose",
    "trim",
    "ubound",
    "unpack",
    "verify",
    "achar",
    "iachar",
    "transfer",
    "dble",
    "entry",
    "dprod",
    "cpu_time",
    "command_argument_count",
    "get_command",
    "get_command_argument",
    "get_environment_variable",
    "is_iostat_end",
    "ieee_arithmetic",
    "ieee_support_underflow_control",
    "ieee_get_underflow_mode",
    "ieee_set_underflow_mode",
    "is_iostat_eor",
    "move_alloc",
    "new_line",
    "selected_char_kind",
    "same_type_as",
    "extends_type_of",
    "acosh",
    "asinh",
    "atanh",
    "bessel_j0",
    "bessel_j1",
    "bessel_jn",
    "bessel_y0",
    "bessel_y1",
    "bessel_yn",
    "erf",
    "erfc",
    "erfc_scaled",
    "gamma",
    "log_gamma",
    "hypot",
    "norm2",
    "atomic_define",
    "atomic_ref",
    "execute_command_line",
    "leadz",
    "trailz",
    "storage_size",
    "merge_bits",
    "bge",
    "bgt",
    "ble",
    "blt",
    "dshiftl",
    "dshiftr",
    "findloc",
    "iall",
    "iany",
    "iparity",
    "image_index",
    "lcobound",
    "ucobound",
    "maskl",
    "maskr",
    "num_images",
    "parity",
    "popcnt",
    "poppar",
    "shifta",
    "shiftl",
    "shiftr",
    "this_image",
    "sync",
    "change",
    "team",
    "co_broadcast",
    "co_max",
    "co_min",
    "co_sum",
    "co_reduce"
  ];
  return {
    name: 'Fortran',
    case_insensitive: true,
    aliases: [
      'f90',
      'f95'
    ],
    keywords: {
      keyword: KEYWORDS,
      literal: LITERALS,
      built_in: BUILT_INS
    },
    illegal: /\/\*/,
    contains: [
      STRING,
      FUNCTION_DEF,
      // allow `C = value` for assignments so they aren't misdetected
      // as Fortran 77 style comments
      {
        begin: /^C\s*=(?!=)/,
        relevance: 0
      },
      COMMENT,
      NUMBER
    ]
  };
}

module.exports = fortran;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/fsharp.js":
/*!***********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/fsharp.js ***!
  \***********************************************************/
/***/ (function(module) {

/**
 * @param {string} value
 * @returns {RegExp}
 * */
function escape(value) {
  return new RegExp(value.replace(/[-/\\^$*+?.()|[\]{}]/g, '\\$&'), 'm');
}

/**
 * @param {RegExp | string } re
 * @returns {string}
 */
function source(re) {
  if (!re) return null;
  if (typeof re === "string") return re;

  return re.source;
}

/**
 * @param {RegExp | string } re
 * @returns {string}
 */
function lookahead(re) {
  return concat('(?=', re, ')');
}

/**
 * @param {...(RegExp | string) } args
 * @returns {string}
 */
function concat(...args) {
  const joined = args.map((x) => source(x)).join("");
  return joined;
}

/**
 * @param { Array<string | RegExp | Object> } args
 * @returns {object}
 */
function stripOptionsFromArgs(args) {
  const opts = args[args.length - 1];

  if (typeof opts === 'object' && opts.constructor === Object) {
    args.splice(args.length - 1, 1);
    return opts;
  } else {
    return {};
  }
}

/** @typedef { {capture?: boolean} } RegexEitherOptions */

/**
 * Any of the passed expresssions may match
 *
 * Creates a huge this | this | that | that match
 * @param {(RegExp | string)[] | [...(RegExp | string)[], RegexEitherOptions]} args
 * @returns {string}
 */
function either(...args) {
  /** @type { object & {capture?: boolean} }  */
  const opts = stripOptionsFromArgs(args);
  const joined = '('
    + (opts.capture ? "" : "?:")
    + args.map((x) => source(x)).join("|") + ")";
  return joined;
}

/*
Language: F#
Author: Jonas Follesø <jonas@follesoe.no>
Contributors: Troy Kershaw <hello@troykershaw.com>, Henrik Feldt <henrik@haf.se>, Melvyn Laïly <melvyn.laily@gmail.com>
Website: https://docs.microsoft.com/en-us/dotnet/fsharp/
Category: functional
*/

/** @type LanguageFn */
function fsharp(hljs) {
  const KEYWORDS = [
    "abstract",
    "and",
    "as",
    "assert",
    "base",
    "begin",
    "class",
    "default",
    "delegate",
    "do",
    "done",
    "downcast",
    "downto",
    "elif",
    "else",
    "end",
    "exception",
    "extern",
    // "false", // literal
    "finally",
    "fixed",
    "for",
    "fun",
    "function",
    "global",
    "if",
    "in",
    "inherit",
    "inline",
    "interface",
    "internal",
    "lazy",
    "let",
    "match",
    "member",
    "module",
    "mutable",
    "namespace",
    "new",
    // "not", // built_in
    // "null", // literal
    "of",
    "open",
    "or",
    "override",
    "private",
    "public",
    "rec",
    "return",
    "static",
    "struct",
    "then",
    "to",
    // "true", // literal
    "try",
    "type",
    "upcast",
    "use",
    "val",
    "void",
    "when",
    "while",
    "with",
    "yield"
  ];

  const BANG_KEYWORD_MODE = {
    // monad builder keywords (matches before non-bang keywords)
    scope: 'keyword',
    match: /\b(yield|return|let|do|match|use)!/
  };

  const PREPROCESSOR_KEYWORDS = [
    "if",
    "else",
    "endif",
    "line",
    "nowarn",
    "light",
    "r",
    "i",
    "I",
    "load",
    "time",
    "help",
    "quit"
  ];

  const LITERALS = [
    "true",
    "false",
    "null",
    "Some",
    "None",
    "Ok",
    "Error",
    "infinity",
    "infinityf",
    "nan",
    "nanf"
  ];

  const SPECIAL_IDENTIFIERS = [
    "__LINE__",
    "__SOURCE_DIRECTORY__",
    "__SOURCE_FILE__"
  ];

  // Since it's possible to re-bind/shadow names (e.g. let char = 'c'),
  // these builtin types should only be matched when a type name is expected.
  const KNOWN_TYPES = [
    // basic types
    "bool",
    "byte",
    "sbyte",
    "int8",
    "int16",
    "int32",
    "uint8",
    "uint16",
    "uint32",
    "int",
    "uint",
    "int64",
    "uint64",
    "nativeint",
    "unativeint",
    "decimal",
    "float",
    "double",
    "float32",
    "single",
    "char",
    "string",
    "unit",
    "bigint",
    // other native types or lowercase aliases
    "option",
    "voption",
    "list",
    "array",
    "seq",
    "byref",
    "exn",
    "inref",
    "nativeptr",
    "obj",
    "outref",
    "voidptr",
    // other important FSharp types
    "Result"
  ];

  const BUILTINS = [
    // Somewhat arbitrary list of builtin functions and values.
    // Most of them are declared in Microsoft.FSharp.Core
    // I tried to stay relevant by adding only the most idiomatic
    // and most used symbols that are not already declared as types.
    "not",
    "ref",
    "raise",
    "reraise",
    "dict",
    "readOnlyDict",
    "set",
    "get",
    "enum",
    "sizeof",
    "typeof",
    "typedefof",
    "nameof",
    "nullArg",
    "invalidArg",
    "invalidOp",
    "id",
    "fst",
    "snd",
    "ignore",
    "lock",
    "using",
    "box",
    "unbox",
    "tryUnbox",
    "printf",
    "printfn",
    "sprintf",
    "eprintf",
    "eprintfn",
    "fprintf",
    "fprintfn",
    "failwith",
    "failwithf"
  ];

  const ALL_KEYWORDS = {
    keyword: KEYWORDS,
    literal: LITERALS,
    built_in: BUILTINS,
    'variable.constant': SPECIAL_IDENTIFIERS
  };

  // (* potentially multi-line Meta Language style comment *)
  const ML_COMMENT =
    hljs.COMMENT(/\(\*(?!\))/, /\*\)/, {
      contains: ["self"]
    });
  // Either a multi-line (* Meta Language style comment *) or a single line // C style comment.
  const COMMENT = {
    variants: [
      ML_COMMENT,
      hljs.C_LINE_COMMENT_MODE,
    ]
  };

  // Most identifiers can contain apostrophes
  const IDENTIFIER_RE = /[a-zA-Z_](\w|')*/;

  const QUOTED_IDENTIFIER = {
    scope: 'variable',
    begin: /``/,
    end: /``/
  };

  // 'a or ^a where a can be a ``quoted identifier``
  const BEGIN_GENERIC_TYPE_SYMBOL_RE = /\B('|\^)/;
  const GENERIC_TYPE_SYMBOL = {
    scope: 'symbol',
    variants: [
      // the type name is a quoted identifier:
      { match: concat(BEGIN_GENERIC_TYPE_SYMBOL_RE, /``.*?``/) },
      // the type name is a normal identifier (we don't use IDENTIFIER_RE because there cannot be another apostrophe here):
      { match: concat(BEGIN_GENERIC_TYPE_SYMBOL_RE, hljs.UNDERSCORE_IDENT_RE) }
    ],
    relevance: 0
  };

  const makeOperatorMode = function({ includeEqual }) {
    // List or symbolic operator characters from the FSharp Spec 4.1, minus the dot, and with `?` added, used for nullable operators.
    let allOperatorChars;
    if (includeEqual)
      allOperatorChars = "!%&*+-/<=>@^|~?";
    else
      allOperatorChars = "!%&*+-/<>@^|~?";
    const OPERATOR_CHARS = Array.from(allOperatorChars);
    const OPERATOR_CHAR_RE = concat('[', ...OPERATOR_CHARS.map(escape), ']');
    // The lone dot operator is special. It cannot be redefined, and we don't want to highlight it. It can be used as part of a multi-chars operator though.
    const OPERATOR_CHAR_OR_DOT_RE = either(OPERATOR_CHAR_RE, /\./);
    // When a dot is present, it must be followed by another operator char:
    const OPERATOR_FIRST_CHAR_OF_MULTIPLE_RE = concat(OPERATOR_CHAR_OR_DOT_RE, lookahead(OPERATOR_CHAR_OR_DOT_RE));
    const SYMBOLIC_OPERATOR_RE = either(
      concat(OPERATOR_FIRST_CHAR_OF_MULTIPLE_RE, OPERATOR_CHAR_OR_DOT_RE, '*'), // Matches at least 2 chars operators
      concat(OPERATOR_CHAR_RE, '+'), // Matches at least one char operators
    );
    return {
      scope: 'operator',
      match: either(
        // symbolic operators:
        SYMBOLIC_OPERATOR_RE,
        // other symbolic keywords:
        // Type casting and conversion operators:
        /:\?>/,
        /:\?/,
        /:>/,
        /:=/, // Reference cell assignment
        /::?/, // : or ::
        /\$/), // A single $ can be used as an operator
      relevance: 0
    };
  };

  const OPERATOR = makeOperatorMode({ includeEqual: true });
  // This variant is used when matching '=' should end a parent mode:
  const OPERATOR_WITHOUT_EQUAL = makeOperatorMode({ includeEqual: false });

  const makeTypeAnnotationMode = function(prefix, prefixScope) {
    return {
      begin: concat( // a type annotation is a
        prefix,            // should be a colon or the 'of' keyword
        lookahead(   // that has to be followed by
          concat(
            /\s*/,         // optional space
            either(  // then either of:
              /\w/,        // word
              /'/,         // generic type name
              /\^/,        // generic type name
              /#/,         // flexible type name
              /``/,        // quoted type name
              /\(/,        // parens type expression
              /{\|/,       // anonymous type annotation
      )))),
      beginScope: prefixScope,
      // BUG: because ending with \n is necessary for some cases, multi-line type annotations are not properly supported.
      // Examples where \n is required at the end:
      // - abstract member definitions in classes: abstract Property : int * string
      // - return type annotations: let f f' = f' () : returnTypeAnnotation
      // - record fields definitions: { A : int \n B : string }
      end: lookahead(
        either(
          /\n/,
          /=/)),
      relevance: 0,
      // we need the known types, and we need the type constraint keywords and literals. e.g.: when 'a : null
      keywords: hljs.inherit(ALL_KEYWORDS, { type: KNOWN_TYPES }),
      contains: [
        COMMENT,
        GENERIC_TYPE_SYMBOL,
        hljs.inherit(QUOTED_IDENTIFIER, { scope: null }), // match to avoid strange patterns inside that may break the parsing
        OPERATOR_WITHOUT_EQUAL
      ]
    };
  };

  const TYPE_ANNOTATION = makeTypeAnnotationMode(/:/, 'operator');
  const DISCRIMINATED_UNION_TYPE_ANNOTATION = makeTypeAnnotationMode(/\bof\b/, 'keyword');

  // type MyType<'a> = ...
  const TYPE_DECLARATION = {
    begin: [
      /(^|\s+)/, // prevents matching the following: `match s.stype with`
      /type/,
      /\s+/,
      IDENTIFIER_RE
    ],
    beginScope: {
      2: 'keyword',
      4: 'title.class'
    },
    end: lookahead(/\(|=|$/),
    keywords: ALL_KEYWORDS, // match keywords in type constraints. e.g.: when 'a : null
    contains: [
      COMMENT,
      hljs.inherit(QUOTED_IDENTIFIER, { scope: null }), // match to avoid strange patterns inside that may break the parsing
      GENERIC_TYPE_SYMBOL,
      {
        // For visual consistency, highlight type brackets as operators.
        scope: 'operator',
        match: /<|>/
      },
      TYPE_ANNOTATION // generic types can have constraints, which are type annotations. e.g. type MyType<'T when 'T : delegate<obj * string>> =
    ]
  };

  const COMPUTATION_EXPRESSION = {
    // computation expressions:
    scope: 'computation-expression',
    // BUG: might conflict with record deconstruction. e.g. let f { Name = name } = name // will highlight f
    match: /\b[_a-z]\w*(?=\s*\{)/
  };

  const PREPROCESSOR = {
    // preprocessor directives and fsi commands:
    begin: [
      /^\s*/,
      concat(/#/, either(...PREPROCESSOR_KEYWORDS)),
      /\b/
    ],
    beginScope: { 2: 'meta' },
    end: lookahead(/\s|$/)
  };

  // TODO: this definition is missing support for type suffixes and octal notation.
  // BUG: range operator without any space is wrongly interpreted as a single number (e.g. 1..10 )
  const NUMBER = {
    variants: [
      hljs.BINARY_NUMBER_MODE,
      hljs.C_NUMBER_MODE
    ]
  };

  // All the following string definitions are potentially multi-line.
  // BUG: these definitions are missing support for byte strings (suffixed with B)

  // "..."
  const QUOTED_STRING = {
    scope: 'string',
    begin: /"/,
    end: /"/,
    contains: [
      hljs.BACKSLASH_ESCAPE
    ]
  };
  // @"..."
  const VERBATIM_STRING = {
    scope: 'string',
    begin: /@"/,
    end: /"/,
    contains: [
      {
        match: /""/ // escaped "
      },
      hljs.BACKSLASH_ESCAPE
    ]
  };
  // """..."""
  const TRIPLE_QUOTED_STRING = {
    scope: 'string',
    begin: /"""/,
    end: /"""/,
    relevance: 2
  };
  const SUBST = {
    scope: 'subst',
    begin: /\{/,
    end: /\}/,
    keywords: ALL_KEYWORDS
  };
  // $"...{1+1}..."
  const INTERPOLATED_STRING = {
    scope: 'string',
    begin: /\$"/,
    end: /"/,
    contains: [
      {
        match: /\{\{/ // escaped {
      },
      {
        match: /\}\}/ // escaped }
      },
      hljs.BACKSLASH_ESCAPE,
      SUBST
    ]
  };
  // $@"...{1+1}..."
  const INTERPOLATED_VERBATIM_STRING = {
    scope: 'string',
    begin: /(\$@|@\$)"/,
    end: /"/,
    contains: [
      {
        match: /\{\{/ // escaped {
      },
      {
        match: /\}\}/ // escaped }
      },
      {
        match: /""/
      },
      hljs.BACKSLASH_ESCAPE,
      SUBST
    ]
  };
  // $"""...{1+1}..."""
  const INTERPOLATED_TRIPLE_QUOTED_STRING = {
    scope: 'string',
    begin: /\$"""/,
    end: /"""/,
    contains: [
      {
        match: /\{\{/ // escaped {
      },
      {
        match: /\}\}/ // escaped }
      },
      SUBST
    ],
    relevance: 2
  };
  // '.'
  const CHAR_LITERAL = {
    scope: 'string',
    match: concat(
      /'/,
      either(
        /[^\\']/, // either a single non escaped char...
        /\\(?:.|\d{3}|x[a-fA-F\d]{2}|u[a-fA-F\d]{4}|U[a-fA-F\d]{8})/ // ...or an escape sequence
      ),
      /'/
    )
  };
  // F# allows a lot of things inside string placeholders.
  // Things that don't currently seem allowed by the compiler: types definition, attributes usage.
  // (Strictly speaking, some of the followings are only allowed inside triple quoted interpolated strings...)
  SUBST.contains = [
    INTERPOLATED_VERBATIM_STRING,
    INTERPOLATED_STRING,
    VERBATIM_STRING,
    QUOTED_STRING,
    CHAR_LITERAL,
    BANG_KEYWORD_MODE,
    COMMENT,
    QUOTED_IDENTIFIER,
    TYPE_ANNOTATION,
    COMPUTATION_EXPRESSION,
    PREPROCESSOR,
    NUMBER,
    GENERIC_TYPE_SYMBOL,
    OPERATOR
  ];
  const STRING = {
    variants: [
      INTERPOLATED_TRIPLE_QUOTED_STRING,
      INTERPOLATED_VERBATIM_STRING,
      INTERPOLATED_STRING,
      TRIPLE_QUOTED_STRING,
      VERBATIM_STRING,
      QUOTED_STRING,
      CHAR_LITERAL
    ]
  };

  return {
    name: 'F#',
    aliases: [
      'fs',
      'f#'
    ],
    keywords: ALL_KEYWORDS,
    illegal: /\/\*/,
    classNameAliases: {
      'computation-expression': 'keyword'
    },
    contains: [
      BANG_KEYWORD_MODE,
      STRING,
      COMMENT,
      QUOTED_IDENTIFIER,
      TYPE_DECLARATION,
      {
        // e.g. [<Attributes("")>] or [<``module``: MyCustomAttributeThatWorksOnModules>]
        // or [<Sealed; NoEquality; NoComparison; CompiledName("FSharpAsync`1")>]
        scope: 'meta',
        begin: /\[</,
        end: />\]/,
        relevance: 2,
        contains: [
          QUOTED_IDENTIFIER,
          // can contain any constant value
          TRIPLE_QUOTED_STRING,
          VERBATIM_STRING,
          QUOTED_STRING,
          CHAR_LITERAL,
          NUMBER
        ]
      },
      DISCRIMINATED_UNION_TYPE_ANNOTATION,
      TYPE_ANNOTATION,
      COMPUTATION_EXPRESSION,
      PREPROCESSOR,
      NUMBER,
      GENERIC_TYPE_SYMBOL,
      OPERATOR
    ]
  };
}

module.exports = fsharp;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/gams.js":
/*!*********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/gams.js ***!
  \*********************************************************/
/***/ (function(module) {

/*
 Language: GAMS
 Author: Stefan Bechert <stefan.bechert@gmx.net>
 Contributors: Oleg Efimov <efimovov@gmail.com>, Mikko Kouhia <mikko.kouhia@iki.fi>
 Description: The General Algebraic Modeling System language
 Website: https://www.gams.com
 Category: scientific
 */

/** @type LanguageFn */
function gams(hljs) {
  const regex = hljs.regex;
  const KEYWORDS = {
    keyword:
      'abort acronym acronyms alias all and assign binary card diag display '
      + 'else eq file files for free ge gt if integer le loop lt maximizing '
      + 'minimizing model models ne negative no not option options or ord '
      + 'positive prod put putpage puttl repeat sameas semicont semiint smax '
      + 'smin solve sos1 sos2 sum system table then until using while xor yes',
    literal:
      'eps inf na',
    built_in:
      'abs arccos arcsin arctan arctan2 Beta betaReg binomial ceil centropy '
      + 'cos cosh cvPower div div0 eDist entropy errorf execSeed exp fact '
      + 'floor frac gamma gammaReg log logBeta logGamma log10 log2 mapVal max '
      + 'min mod ncpCM ncpF ncpVUpow ncpVUsin normal pi poly power '
      + 'randBinomial randLinear randTriangle round rPower sigmoid sign '
      + 'signPower sin sinh slexp sllog10 slrec sqexp sqlog10 sqr sqrec sqrt '
      + 'tan tanh trunc uniform uniformInt vcPower bool_and bool_eqv bool_imp '
      + 'bool_not bool_or bool_xor ifThen rel_eq rel_ge rel_gt rel_le rel_lt '
      + 'rel_ne gday gdow ghour gleap gmillisec gminute gmonth gsecond gyear '
      + 'jdate jnow jstart jtime errorLevel execError gamsRelease gamsVersion '
      + 'handleCollect handleDelete handleStatus handleSubmit heapFree '
      + 'heapLimit heapSize jobHandle jobKill jobStatus jobTerminate '
      + 'licenseLevel licenseStatus maxExecError sleep timeClose timeComp '
      + 'timeElapsed timeExec timeStart'
  };
  const PARAMS = {
    className: 'params',
    begin: /\(/,
    end: /\)/,
    excludeBegin: true,
    excludeEnd: true
  };
  const SYMBOLS = {
    className: 'symbol',
    variants: [
      { begin: /=[lgenxc]=/ },
      { begin: /\$/ }
    ]
  };
  const QSTR = { // One-line quoted comment string
    className: 'comment',
    variants: [
      {
        begin: '\'',
        end: '\''
      },
      {
        begin: '"',
        end: '"'
      }
    ],
    illegal: '\\n',
    contains: [ hljs.BACKSLASH_ESCAPE ]
  };
  const ASSIGNMENT = {
    begin: '/',
    end: '/',
    keywords: KEYWORDS,
    contains: [
      QSTR,
      hljs.C_LINE_COMMENT_MODE,
      hljs.C_BLOCK_COMMENT_MODE,
      hljs.QUOTE_STRING_MODE,
      hljs.APOS_STRING_MODE,
      hljs.C_NUMBER_MODE
    ]
  };
  const COMMENT_WORD = /[a-z0-9&#*=?@\\><:,()$[\]_.{}!+%^-]+/;
  const DESCTEXT = { // Parameter/set/variable description text
    begin: /[a-z][a-z0-9_]*(\([a-z0-9_, ]*\))?[ \t]+/,
    excludeBegin: true,
    end: '$',
    endsWithParent: true,
    contains: [
      QSTR,
      ASSIGNMENT,
      {
        className: 'comment',
        // one comment word, then possibly more
        begin: regex.concat(
          COMMENT_WORD,
          // [ ] because \s would be too broad (matching newlines)
          regex.anyNumberOfTimes(regex.concat(/[ ]+/, COMMENT_WORD))
        ),
        relevance: 0
      }
    ]
  };

  return {
    name: 'GAMS',
    aliases: [ 'gms' ],
    case_insensitive: true,
    keywords: KEYWORDS,
    contains: [
      hljs.COMMENT(/^\$ontext/, /^\$offtext/),
      {
        className: 'meta',
        begin: '^\\$[a-z0-9]+',
        end: '$',
        returnBegin: true,
        contains: [
          {
            className: 'keyword',
            begin: '^\\$[a-z0-9]+'
          }
        ]
      },
      hljs.COMMENT('^\\*', '$'),
      hljs.C_LINE_COMMENT_MODE,
      hljs.C_BLOCK_COMMENT_MODE,
      hljs.QUOTE_STRING_MODE,
      hljs.APOS_STRING_MODE,
      // Declarations
      {
        beginKeywords:
          'set sets parameter parameters variable variables '
          + 'scalar scalars equation equations',
        end: ';',
        contains: [
          hljs.COMMENT('^\\*', '$'),
          hljs.C_LINE_COMMENT_MODE,
          hljs.C_BLOCK_COMMENT_MODE,
          hljs.QUOTE_STRING_MODE,
          hljs.APOS_STRING_MODE,
          ASSIGNMENT,
          DESCTEXT
        ]
      },
      { // table environment
        beginKeywords: 'table',
        end: ';',
        returnBegin: true,
        contains: [
          { // table header row
            beginKeywords: 'table',
            end: '$',
            contains: [ DESCTEXT ]
          },
          hljs.COMMENT('^\\*', '$'),
          hljs.C_LINE_COMMENT_MODE,
          hljs.C_BLOCK_COMMENT_MODE,
          hljs.QUOTE_STRING_MODE,
          hljs.APOS_STRING_MODE,
          hljs.C_NUMBER_MODE
          // Table does not contain DESCTEXT or ASSIGNMENT
        ]
      },
      // Function definitions
      {
        className: 'function',
        begin: /^[a-z][a-z0-9_,\-+' ()$]+\.{2}/,
        returnBegin: true,
        contains: [
          { // Function title
            className: 'title',
            begin: /^[a-z0-9_]+/
          },
          PARAMS,
          SYMBOLS
        ]
      },
      hljs.C_NUMBER_MODE,
      SYMBOLS
    ]
  };
}

module.exports = gams;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/gauss.js":
/*!**********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/gauss.js ***!
  \**********************************************************/
/***/ (function(module) {

/*
Language: GAUSS
Author: Matt Evans <matt@aptech.com>
Description: GAUSS Mathematical and Statistical language
Website: https://www.aptech.com
Category: scientific
*/
function gauss(hljs) {
  const KEYWORDS = {
    keyword: 'bool break call callexe checkinterrupt clear clearg closeall cls comlog compile '
              + 'continue create debug declare delete disable dlibrary dllcall do dos ed edit else '
              + 'elseif enable end endfor endif endp endo errorlog errorlogat expr external fn '
              + 'for format goto gosub graph if keyword let lib library line load loadarray loadexe '
              + 'loadf loadk loadm loadp loads loadx local locate loopnextindex lprint lpwidth lshow '
              + 'matrix msym ndpclex new open output outwidth plot plotsym pop prcsn print '
              + 'printdos proc push retp return rndcon rndmod rndmult rndseed run save saveall screen '
              + 'scroll setarray show sparse stop string struct system trace trap threadfor '
              + 'threadendfor threadbegin threadjoin threadstat threadend until use while winprint '
              + 'ne ge le gt lt and xor or not eq eqv',
    built_in: 'abs acf aconcat aeye amax amean AmericanBinomCall AmericanBinomCall_Greeks AmericanBinomCall_ImpVol '
              + 'AmericanBinomPut AmericanBinomPut_Greeks AmericanBinomPut_ImpVol AmericanBSCall AmericanBSCall_Greeks '
              + 'AmericanBSCall_ImpVol AmericanBSPut AmericanBSPut_Greeks AmericanBSPut_ImpVol amin amult annotationGetDefaults '
              + 'annotationSetBkd annotationSetFont annotationSetLineColor annotationSetLineStyle annotationSetLineThickness '
              + 'annualTradingDays arccos arcsin areshape arrayalloc arrayindex arrayinit arraytomat asciiload asclabel astd '
              + 'astds asum atan atan2 atranspose axmargin balance band bandchol bandcholsol bandltsol bandrv bandsolpd bar '
              + 'base10 begwind besselj bessely beta box boxcox cdfBeta cdfBetaInv cdfBinomial cdfBinomialInv cdfBvn cdfBvn2 '
              + 'cdfBvn2e cdfCauchy cdfCauchyInv cdfChic cdfChii cdfChinc cdfChincInv cdfExp cdfExpInv cdfFc cdfFnc cdfFncInv '
              + 'cdfGam cdfGenPareto cdfHyperGeo cdfLaplace cdfLaplaceInv cdfLogistic cdfLogisticInv cdfmControlCreate cdfMvn '
              + 'cdfMvn2e cdfMvnce cdfMvne cdfMvt2e cdfMvtce cdfMvte cdfN cdfN2 cdfNc cdfNegBinomial cdfNegBinomialInv cdfNi '
              + 'cdfPoisson cdfPoissonInv cdfRayleigh cdfRayleighInv cdfTc cdfTci cdfTnc cdfTvn cdfWeibull cdfWeibullInv cdir '
              + 'ceil ChangeDir chdir chiBarSquare chol choldn cholsol cholup chrs close code cols colsf combinate combinated '
              + 'complex con cond conj cons ConScore contour conv convertsatostr convertstrtosa corrm corrms corrvc corrx corrxs '
              + 'cos cosh counts countwts crossprd crout croutp csrcol csrlin csvReadM csvReadSA cumprodc cumsumc curve cvtos '
              + 'datacreate datacreatecomplex datalist dataload dataloop dataopen datasave date datestr datestring datestrymd '
              + 'dayinyr dayofweek dbAddDatabase dbClose dbCommit dbCreateQuery dbExecQuery dbGetConnectOptions dbGetDatabaseName '
              + 'dbGetDriverName dbGetDrivers dbGetHostName dbGetLastErrorNum dbGetLastErrorText dbGetNumericalPrecPolicy '
              + 'dbGetPassword dbGetPort dbGetTableHeaders dbGetTables dbGetUserName dbHasFeature dbIsDriverAvailable dbIsOpen '
              + 'dbIsOpenError dbOpen dbQueryBindValue dbQueryClear dbQueryCols dbQueryExecPrepared dbQueryFetchAllM dbQueryFetchAllSA '
              + 'dbQueryFetchOneM dbQueryFetchOneSA dbQueryFinish dbQueryGetBoundValue dbQueryGetBoundValues dbQueryGetField '
              + 'dbQueryGetLastErrorNum dbQueryGetLastErrorText dbQueryGetLastInsertID dbQueryGetLastQuery dbQueryGetPosition '
              + 'dbQueryIsActive dbQueryIsForwardOnly dbQueryIsNull dbQueryIsSelect dbQueryIsValid dbQueryPrepare dbQueryRows '
              + 'dbQuerySeek dbQuerySeekFirst dbQuerySeekLast dbQuerySeekNext dbQuerySeekPrevious dbQuerySetForwardOnly '
              + 'dbRemoveDatabase dbRollback dbSetConnectOptions dbSetDatabaseName dbSetHostName dbSetNumericalPrecPolicy '
              + 'dbSetPort dbSetUserName dbTransaction DeleteFile delif delrows denseToSp denseToSpRE denToZero design det detl '
              + 'dfft dffti diag diagrv digamma doswin DOSWinCloseall DOSWinOpen dotfeq dotfeqmt dotfge dotfgemt dotfgt dotfgtmt '
              + 'dotfle dotflemt dotflt dotfltmt dotfne dotfnemt draw drop dsCreate dstat dstatmt dstatmtControlCreate dtdate dtday '
              + 'dttime dttodtv dttostr dttoutc dtvnormal dtvtodt dtvtoutc dummy dummybr dummydn eig eigh eighv eigv elapsedTradingDays '
              + 'endwind envget eof eqSolve eqSolvemt eqSolvemtControlCreate eqSolvemtOutCreate eqSolveset erf erfc erfccplx erfcplx error '
              + 'etdays ethsec etstr EuropeanBinomCall EuropeanBinomCall_Greeks EuropeanBinomCall_ImpVol EuropeanBinomPut '
              + 'EuropeanBinomPut_Greeks EuropeanBinomPut_ImpVol EuropeanBSCall EuropeanBSCall_Greeks EuropeanBSCall_ImpVol '
              + 'EuropeanBSPut EuropeanBSPut_Greeks EuropeanBSPut_ImpVol exctsmpl exec execbg exp extern eye fcheckerr fclearerr feq '
              + 'feqmt fflush fft ffti fftm fftmi fftn fge fgemt fgets fgetsa fgetsat fgetst fgt fgtmt fileinfo filesa fle flemt '
              + 'floor flt fltmt fmod fne fnemt fonts fopen formatcv formatnv fputs fputst fseek fstrerror ftell ftocv ftos ftostrC '
              + 'gamma gammacplx gammaii gausset gdaAppend gdaCreate gdaDStat gdaDStatMat gdaGetIndex gdaGetName gdaGetNames gdaGetOrders '
              + 'gdaGetType gdaGetTypes gdaGetVarInfo gdaIsCplx gdaLoad gdaPack gdaRead gdaReadByIndex gdaReadSome gdaReadSparse '
              + 'gdaReadStruct gdaReportVarInfo gdaSave gdaUpdate gdaUpdateAndPack gdaVars gdaWrite gdaWrite32 gdaWriteSome getarray '
              + 'getdims getf getGAUSShome getmatrix getmatrix4D getname getnamef getNextTradingDay getNextWeekDay getnr getorders '
              + 'getpath getPreviousTradingDay getPreviousWeekDay getRow getscalar3D getscalar4D getTrRow getwind glm gradcplx gradMT '
              + 'gradMTm gradMTT gradMTTm gradp graphprt graphset hasimag header headermt hess hessMT hessMTg hessMTgw hessMTm '
              + 'hessMTmw hessMTT hessMTTg hessMTTgw hessMTTm hessMTw hessp hist histf histp hsec imag indcv indexcat indices indices2 '
              + 'indicesf indicesfn indnv indsav integrate1d integrateControlCreate intgrat2 intgrat3 inthp1 inthp2 inthp3 inthp4 '
              + 'inthpControlCreate intquad1 intquad2 intquad3 intrleav intrleavsa intrsect intsimp inv invpd invswp iscplx iscplxf '
              + 'isden isinfnanmiss ismiss key keyav keyw lag lag1 lagn lapEighb lapEighi lapEighvb lapEighvi lapgEig lapgEigh lapgEighv '
              + 'lapgEigv lapgSchur lapgSvdcst lapgSvds lapgSvdst lapSvdcusv lapSvds lapSvdusv ldlp ldlsol linSolve listwise ln lncdfbvn '
              + 'lncdfbvn2 lncdfmvn lncdfn lncdfn2 lncdfnc lnfact lngammacplx lnpdfmvn lnpdfmvt lnpdfn lnpdft loadd loadstruct loadwind '
              + 'loess loessmt loessmtControlCreate log loglog logx logy lower lowmat lowmat1 ltrisol lu lusol machEpsilon make makevars '
              + 'makewind margin matalloc matinit mattoarray maxbytes maxc maxindc maxv maxvec mbesselei mbesselei0 mbesselei1 mbesseli '
              + 'mbesseli0 mbesseli1 meanc median mergeby mergevar minc minindc minv miss missex missrv moment momentd movingave '
              + 'movingaveExpwgt movingaveWgt nextindex nextn nextnevn nextwind ntos null null1 numCombinations ols olsmt olsmtControlCreate '
              + 'olsqr olsqr2 olsqrmt ones optn optnevn orth outtyp pacf packedToSp packr parse pause pdfCauchy pdfChi pdfExp pdfGenPareto '
              + 'pdfHyperGeo pdfLaplace pdfLogistic pdfn pdfPoisson pdfRayleigh pdfWeibull pi pinv pinvmt plotAddArrow plotAddBar plotAddBox '
              + 'plotAddHist plotAddHistF plotAddHistP plotAddPolar plotAddScatter plotAddShape plotAddTextbox plotAddTS plotAddXY plotArea '
              + 'plotBar plotBox plotClearLayout plotContour plotCustomLayout plotGetDefaults plotHist plotHistF plotHistP plotLayout '
              + 'plotLogLog plotLogX plotLogY plotOpenWindow plotPolar plotSave plotScatter plotSetAxesPen plotSetBar plotSetBarFill '
              + 'plotSetBarStacked plotSetBkdColor plotSetFill plotSetGrid plotSetLegend plotSetLineColor plotSetLineStyle plotSetLineSymbol '
              + 'plotSetLineThickness plotSetNewWindow plotSetTitle plotSetWhichYAxis plotSetXAxisShow plotSetXLabel plotSetXRange '
              + 'plotSetXTicInterval plotSetXTicLabel plotSetYAxisShow plotSetYLabel plotSetYRange plotSetZAxisShow plotSetZLabel '
              + 'plotSurface plotTS plotXY polar polychar polyeval polygamma polyint polymake polymat polymroot polymult polyroot '
              + 'pqgwin previousindex princomp printfm printfmt prodc psi putarray putf putvals pvCreate pvGetIndex pvGetParNames '
              + 'pvGetParVector pvLength pvList pvPack pvPacki pvPackm pvPackmi pvPacks pvPacksi pvPacksm pvPacksmi pvPutParVector '
              + 'pvTest pvUnpack QNewton QNewtonmt QNewtonmtControlCreate QNewtonmtOutCreate QNewtonSet QProg QProgmt QProgmtInCreate '
              + 'qqr qqre qqrep qr qre qrep qrsol qrtsol qtyr qtyre qtyrep quantile quantiled qyr qyre qyrep qz rank rankindx readr '
              + 'real reclassify reclassifyCuts recode recserar recsercp recserrc rerun rescale reshape rets rev rfft rffti rfftip rfftn '
              + 'rfftnp rfftp rndBernoulli rndBeta rndBinomial rndCauchy rndChiSquare rndCon rndCreateState rndExp rndGamma rndGeo rndGumbel '
              + 'rndHyperGeo rndi rndKMbeta rndKMgam rndKMi rndKMn rndKMnb rndKMp rndKMu rndKMvm rndLaplace rndLCbeta rndLCgam rndLCi rndLCn '
              + 'rndLCnb rndLCp rndLCu rndLCvm rndLogNorm rndMTu rndMVn rndMVt rndn rndnb rndNegBinomial rndp rndPoisson rndRayleigh '
              + 'rndStateSkip rndu rndvm rndWeibull rndWishart rotater round rows rowsf rref sampleData satostrC saved saveStruct savewind '
              + 'scale scale3d scalerr scalinfnanmiss scalmiss schtoc schur searchsourcepath seekr select selif seqa seqm setdif setdifsa '
              + 'setvars setvwrmode setwind shell shiftr sin singleindex sinh sleep solpd sortc sortcc sortd sorthc sorthcc sortind '
              + 'sortindc sortmc sortr sortrc spBiconjGradSol spChol spConjGradSol spCreate spDenseSubmat spDiagRvMat spEigv spEye spLDL '
              + 'spline spLU spNumNZE spOnes spreadSheetReadM spreadSheetReadSA spreadSheetWrite spScale spSubmat spToDense spTrTDense '
              + 'spTScalar spZeros sqpSolve sqpSolveMT sqpSolveMTControlCreate sqpSolveMTlagrangeCreate sqpSolveMToutCreate sqpSolveSet '
              + 'sqrt statements stdc stdsc stocv stof strcombine strindx strlen strput strrindx strsect strsplit strsplitPad strtodt '
              + 'strtof strtofcplx strtriml strtrimr strtrunc strtruncl strtruncpad strtruncr submat subscat substute subvec sumc sumr '
              + 'surface svd svd1 svd2 svdcusv svds svdusv sysstate tab tan tanh tempname '
              + 'time timedt timestr timeutc title tkf2eps tkf2ps tocart todaydt toeplitz token topolar trapchk '
              + 'trigamma trimr trunc type typecv typef union unionsa uniqindx uniqindxsa unique uniquesa upmat upmat1 upper utctodt '
              + 'utctodtv utrisol vals varCovMS varCovXS varget vargetl varmall varmares varput varputl vartypef vcm vcms vcx vcxs '
              + 'vec vech vecr vector vget view viewxyz vlist vnamecv volume vput vread vtypecv wait waitc walkindex where window '
              + 'writer xlabel xlsGetSheetCount xlsGetSheetSize xlsGetSheetTypes xlsMakeRange xlsReadM xlsReadSA xlsWrite xlsWriteM '
              + 'xlsWriteSA xpnd xtics xy xyz ylabel ytics zeros zeta zlabel ztics cdfEmpirical dot h5create h5open h5read h5readAttribute '
              + 'h5write h5writeAttribute ldl plotAddErrorBar plotAddSurface plotCDFEmpirical plotSetColormap plotSetContourLabels '
              + 'plotSetLegendFont plotSetTextInterpreter plotSetXTicCount plotSetYTicCount plotSetZLevels powerm strjoin sylvester '
              + 'strtrim',
    literal: 'DB_AFTER_LAST_ROW DB_ALL_TABLES DB_BATCH_OPERATIONS DB_BEFORE_FIRST_ROW DB_BLOB DB_EVENT_NOTIFICATIONS '
             + 'DB_FINISH_QUERY DB_HIGH_PRECISION DB_LAST_INSERT_ID DB_LOW_PRECISION_DOUBLE DB_LOW_PRECISION_INT32 '
             + 'DB_LOW_PRECISION_INT64 DB_LOW_PRECISION_NUMBERS DB_MULTIPLE_RESULT_SETS DB_NAMED_PLACEHOLDERS '
             + 'DB_POSITIONAL_PLACEHOLDERS DB_PREPARED_QUERIES DB_QUERY_SIZE DB_SIMPLE_LOCKING DB_SYSTEM_TABLES DB_TABLES '
             + 'DB_TRANSACTIONS DB_UNICODE DB_VIEWS __STDIN __STDOUT __STDERR __FILE_DIR'
  };

  const AT_COMMENT_MODE = hljs.COMMENT('@', '@');

  const PREPROCESSOR =
  {
    className: 'meta',
    begin: '#',
    end: '$',
    keywords: { keyword: 'define definecs|10 undef ifdef ifndef iflight ifdllcall ifmac ifos2win ifunix else endif lineson linesoff srcfile srcline' },
    contains: [
      {
        begin: /\\\n/,
        relevance: 0
      },
      {
        beginKeywords: 'include',
        end: '$',
        keywords: { keyword: 'include' },
        contains: [
          {
            className: 'string',
            begin: '"',
            end: '"',
            illegal: '\\n'
          }
        ]
      },
      hljs.C_LINE_COMMENT_MODE,
      hljs.C_BLOCK_COMMENT_MODE,
      AT_COMMENT_MODE
    ]
  };

  const STRUCT_TYPE =
  {
    begin: /\bstruct\s+/,
    end: /\s/,
    keywords: "struct",
    contains: [
      {
        className: "type",
        begin: hljs.UNDERSCORE_IDENT_RE,
        relevance: 0
      }
    ]
  };

  // only for definitions
  const PARSE_PARAMS = [
    {
      className: 'params',
      begin: /\(/,
      end: /\)/,
      excludeBegin: true,
      excludeEnd: true,
      endsWithParent: true,
      relevance: 0,
      contains: [
        { // dots
          className: 'literal',
          begin: /\.\.\./
        },
        hljs.C_NUMBER_MODE,
        hljs.C_BLOCK_COMMENT_MODE,
        AT_COMMENT_MODE,
        STRUCT_TYPE
      ]
    }
  ];

  const FUNCTION_DEF =
  {
    className: "title",
    begin: hljs.UNDERSCORE_IDENT_RE,
    relevance: 0
  };

  const DEFINITION = function(beginKeywords, end, inherits) {
    const mode = hljs.inherit(
      {
        className: "function",
        beginKeywords: beginKeywords,
        end: end,
        excludeEnd: true,
        contains: [].concat(PARSE_PARAMS)
      },
      inherits || {}
    );
    mode.contains.push(FUNCTION_DEF);
    mode.contains.push(hljs.C_NUMBER_MODE);
    mode.contains.push(hljs.C_BLOCK_COMMENT_MODE);
    mode.contains.push(AT_COMMENT_MODE);
    return mode;
  };

  const BUILT_IN_REF =
  { // these are explicitly named internal function calls
    className: 'built_in',
    begin: '\\b(' + KEYWORDS.built_in.split(' ').join('|') + ')\\b'
  };

  const STRING_REF =
  {
    className: 'string',
    begin: '"',
    end: '"',
    contains: [ hljs.BACKSLASH_ESCAPE ],
    relevance: 0
  };

  const FUNCTION_REF =
  {
    // className: "fn_ref",
    begin: hljs.UNDERSCORE_IDENT_RE + '\\s*\\(',
    returnBegin: true,
    keywords: KEYWORDS,
    relevance: 0,
    contains: [
      { beginKeywords: KEYWORDS.keyword },
      BUILT_IN_REF,
      { // ambiguously named function calls get a relevance of 0
        className: 'built_in',
        begin: hljs.UNDERSCORE_IDENT_RE,
        relevance: 0
      }
    ]
  };

  const FUNCTION_REF_PARAMS =
  {
    // className: "fn_ref_params",
    begin: /\(/,
    end: /\)/,
    relevance: 0,
    keywords: {
      built_in: KEYWORDS.built_in,
      literal: KEYWORDS.literal
    },
    contains: [
      hljs.C_NUMBER_MODE,
      hljs.C_BLOCK_COMMENT_MODE,
      AT_COMMENT_MODE,
      BUILT_IN_REF,
      FUNCTION_REF,
      STRING_REF,
      'self'
    ]
  };

  FUNCTION_REF.contains.push(FUNCTION_REF_PARAMS);

  return {
    name: 'GAUSS',
    aliases: [ 'gss' ],
    case_insensitive: true, // language is case-insensitive
    keywords: KEYWORDS,
    illegal: /(\{[%#]|[%#]\}| <- )/,
    contains: [
      hljs.C_NUMBER_MODE,
      hljs.C_LINE_COMMENT_MODE,
      hljs.C_BLOCK_COMMENT_MODE,
      AT_COMMENT_MODE,
      STRING_REF,
      PREPROCESSOR,
      {
        className: 'keyword',
        begin: /\bexternal (matrix|string|array|sparse matrix|struct|proc|keyword|fn)/
      },
      DEFINITION('proc keyword', ';'),
      DEFINITION('fn', '='),
      {
        beginKeywords: 'for threadfor',
        end: /;/,
        // end: /\(/,
        relevance: 0,
        contains: [
          hljs.C_BLOCK_COMMENT_MODE,
          AT_COMMENT_MODE,
          FUNCTION_REF_PARAMS
        ]
      },
      { // custom method guard
        // excludes method names from keyword processing
        variants: [
          { begin: hljs.UNDERSCORE_IDENT_RE + '\\.' + hljs.UNDERSCORE_IDENT_RE },
          { begin: hljs.UNDERSCORE_IDENT_RE + '\\s*=' }
        ],
        relevance: 0
      },
      FUNCTION_REF,
      STRUCT_TYPE
    ]
  };
}

module.exports = gauss;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/gcode.js":
/*!**********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/gcode.js ***!
  \**********************************************************/
/***/ (function(module) {

/*
 Language: G-code (ISO 6983)
 Contributors: Adam Joseph Cook <adam.joseph.cook@gmail.com>
 Description: G-code syntax highlighter for Fanuc and other common CNC machine tool controls.
 Website: https://www.sis.se/api/document/preview/911952/
 */

function gcode(hljs) {
  const GCODE_IDENT_RE = '[A-Z_][A-Z0-9_.]*';
  const GCODE_CLOSE_RE = '%';
  const GCODE_KEYWORDS = {
    $pattern: GCODE_IDENT_RE,
    keyword: 'IF DO WHILE ENDWHILE CALL ENDIF SUB ENDSUB GOTO REPEAT ENDREPEAT '
      + 'EQ LT GT NE GE LE OR XOR'
  };
  const GCODE_START = {
    className: 'meta',
    begin: '([O])([0-9]+)'
  };
  const NUMBER = hljs.inherit(hljs.C_NUMBER_MODE, { begin: '([-+]?((\\.\\d+)|(\\d+)(\\.\\d*)?))|' + hljs.C_NUMBER_RE });
  const GCODE_CODE = [
    hljs.C_LINE_COMMENT_MODE,
    hljs.C_BLOCK_COMMENT_MODE,
    hljs.COMMENT(/\(/, /\)/),
    NUMBER,
    hljs.inherit(hljs.APOS_STRING_MODE, { illegal: null }),
    hljs.inherit(hljs.QUOTE_STRING_MODE, { illegal: null }),
    {
      className: 'name',
      begin: '([G])([0-9]+\\.?[0-9]?)'
    },
    {
      className: 'name',
      begin: '([M])([0-9]+\\.?[0-9]?)'
    },
    {
      className: 'attr',
      begin: '(VC|VS|#)',
      end: '(\\d+)'
    },
    {
      className: 'attr',
      begin: '(VZOFX|VZOFY|VZOFZ)'
    },
    {
      className: 'built_in',
      begin: '(ATAN|ABS|ACOS|ASIN|SIN|COS|EXP|FIX|FUP|ROUND|LN|TAN)(\\[)',
      contains: [ NUMBER ],
      end: '\\]'
    },
    {
      className: 'symbol',
      variants: [
        {
          begin: 'N',
          end: '\\d+',
          illegal: '\\W'
        }
      ]
    }
  ];

  return {
    name: 'G-code (ISO 6983)',
    aliases: [ 'nc' ],
    // Some implementations (CNC controls) of G-code are interoperable with uppercase and lowercase letters seamlessly.
    // However, most prefer all uppercase and uppercase is customary.
    case_insensitive: true,
    keywords: GCODE_KEYWORDS,
    contains: [
      {
        className: 'meta',
        begin: GCODE_CLOSE_RE
      },
      GCODE_START
    ].concat(GCODE_CODE)
  };
}

module.exports = gcode;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/gherkin.js":
/*!************************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/gherkin.js ***!
  \************************************************************/
/***/ (function(module) {

/*
 Language: Gherkin
 Author: Sam Pikesley (@pikesley) <sam.pikesley@theodi.org>
 Description: Gherkin is the format for cucumber specifications. It is a domain specific language which helps you to describe business behavior without the need to go into detail of implementation.
 Website: https://cucumber.io/docs/gherkin/
 */

function gherkin(hljs) {
  return {
    name: 'Gherkin',
    aliases: [ 'feature' ],
    keywords: 'Feature Background Ability Business\ Need Scenario Scenarios Scenario\ Outline Scenario\ Template Examples Given And Then But When',
    contains: [
      {
        className: 'symbol',
        begin: '\\*',
        relevance: 0
      },
      {
        className: 'meta',
        begin: '@[^@\\s]+'
      },
      {
        begin: '\\|',
        end: '\\|\\w*$',
        contains: [
          {
            className: 'string',
            begin: '[^|]+'
          }
        ]
      },
      {
        className: 'variable',
        begin: '<',
        end: '>'
      },
      hljs.HASH_COMMENT_MODE,
      {
        className: 'string',
        begin: '"""',
        end: '"""'
      },
      hljs.QUOTE_STRING_MODE
    ]
  };
}

module.exports = gherkin;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/glsl.js":
/*!*********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/glsl.js ***!
  \*********************************************************/
/***/ (function(module) {

/*
Language: GLSL
Description: OpenGL Shading Language
Author: Sergey Tikhomirov <sergey@tikhomirov.io>
Website: https://en.wikipedia.org/wiki/OpenGL_Shading_Language
Category: graphics
*/

function glsl(hljs) {
  return {
    name: 'GLSL',
    keywords: {
      keyword:
        // Statements
        'break continue discard do else for if return while switch case default '
        // Qualifiers
        + 'attribute binding buffer ccw centroid centroid varying coherent column_major const cw '
        + 'depth_any depth_greater depth_less depth_unchanged early_fragment_tests equal_spacing '
        + 'flat fractional_even_spacing fractional_odd_spacing highp in index inout invariant '
        + 'invocations isolines layout line_strip lines lines_adjacency local_size_x local_size_y '
        + 'local_size_z location lowp max_vertices mediump noperspective offset origin_upper_left '
        + 'out packed patch pixel_center_integer point_mode points precise precision quads r11f_g11f_b10f '
        + 'r16 r16_snorm r16f r16i r16ui r32f r32i r32ui r8 r8_snorm r8i r8ui readonly restrict '
        + 'rg16 rg16_snorm rg16f rg16i rg16ui rg32f rg32i rg32ui rg8 rg8_snorm rg8i rg8ui rgb10_a2 '
        + 'rgb10_a2ui rgba16 rgba16_snorm rgba16f rgba16i rgba16ui rgba32f rgba32i rgba32ui rgba8 '
        + 'rgba8_snorm rgba8i rgba8ui row_major sample shared smooth std140 std430 stream triangle_strip '
        + 'triangles triangles_adjacency uniform varying vertices volatile writeonly',
      type:
        'atomic_uint bool bvec2 bvec3 bvec4 dmat2 dmat2x2 dmat2x3 dmat2x4 dmat3 dmat3x2 dmat3x3 '
        + 'dmat3x4 dmat4 dmat4x2 dmat4x3 dmat4x4 double dvec2 dvec3 dvec4 float iimage1D iimage1DArray '
        + 'iimage2D iimage2DArray iimage2DMS iimage2DMSArray iimage2DRect iimage3D iimageBuffer '
        + 'iimageCube iimageCubeArray image1D image1DArray image2D image2DArray image2DMS image2DMSArray '
        + 'image2DRect image3D imageBuffer imageCube imageCubeArray int isampler1D isampler1DArray '
        + 'isampler2D isampler2DArray isampler2DMS isampler2DMSArray isampler2DRect isampler3D '
        + 'isamplerBuffer isamplerCube isamplerCubeArray ivec2 ivec3 ivec4 mat2 mat2x2 mat2x3 '
        + 'mat2x4 mat3 mat3x2 mat3x3 mat3x4 mat4 mat4x2 mat4x3 mat4x4 sampler1D sampler1DArray '
        + 'sampler1DArrayShadow sampler1DShadow sampler2D sampler2DArray sampler2DArrayShadow '
        + 'sampler2DMS sampler2DMSArray sampler2DRect sampler2DRectShadow sampler2DShadow sampler3D '
        + 'samplerBuffer samplerCube samplerCubeArray samplerCubeArrayShadow samplerCubeShadow '
        + 'image1D uimage1DArray uimage2D uimage2DArray uimage2DMS uimage2DMSArray uimage2DRect '
        + 'uimage3D uimageBuffer uimageCube uimageCubeArray uint usampler1D usampler1DArray '
        + 'usampler2D usampler2DArray usampler2DMS usampler2DMSArray usampler2DRect usampler3D '
        + 'samplerBuffer usamplerCube usamplerCubeArray uvec2 uvec3 uvec4 vec2 vec3 vec4 void',
      built_in:
        // Constants
        'gl_MaxAtomicCounterBindings gl_MaxAtomicCounterBufferSize gl_MaxClipDistances gl_MaxClipPlanes '
        + 'gl_MaxCombinedAtomicCounterBuffers gl_MaxCombinedAtomicCounters gl_MaxCombinedImageUniforms '
        + 'gl_MaxCombinedImageUnitsAndFragmentOutputs gl_MaxCombinedTextureImageUnits gl_MaxComputeAtomicCounterBuffers '
        + 'gl_MaxComputeAtomicCounters gl_MaxComputeImageUniforms gl_MaxComputeTextureImageUnits '
        + 'gl_MaxComputeUniformComponents gl_MaxComputeWorkGroupCount gl_MaxComputeWorkGroupSize '
        + 'gl_MaxDrawBuffers gl_MaxFragmentAtomicCounterBuffers gl_MaxFragmentAtomicCounters '
        + 'gl_MaxFragmentImageUniforms gl_MaxFragmentInputComponents gl_MaxFragmentInputVectors '
        + 'gl_MaxFragmentUniformComponents gl_MaxFragmentUniformVectors gl_MaxGeometryAtomicCounterBuffers '
        + 'gl_MaxGeometryAtomicCounters gl_MaxGeometryImageUniforms gl_MaxGeometryInputComponents '
        + 'gl_MaxGeometryOutputComponents gl_MaxGeometryOutputVertices gl_MaxGeometryTextureImageUnits '
        + 'gl_MaxGeometryTotalOutputComponents gl_MaxGeometryUniformComponents gl_MaxGeometryVaryingComponents '
        + 'gl_MaxImageSamples gl_MaxImageUnits gl_MaxLights gl_MaxPatchVertices gl_MaxProgramTexelOffset '
        + 'gl_MaxTessControlAtomicCounterBuffers gl_MaxTessControlAtomicCounters gl_MaxTessControlImageUniforms '
        + 'gl_MaxTessControlInputComponents gl_MaxTessControlOutputComponents gl_MaxTessControlTextureImageUnits '
        + 'gl_MaxTessControlTotalOutputComponents gl_MaxTessControlUniformComponents '
        + 'gl_MaxTessEvaluationAtomicCounterBuffers gl_MaxTessEvaluationAtomicCounters '
        + 'gl_MaxTessEvaluationImageUniforms gl_MaxTessEvaluationInputComponents gl_MaxTessEvaluationOutputComponents '
        + 'gl_MaxTessEvaluationTextureImageUnits gl_MaxTessEvaluationUniformComponents '
        + 'gl_MaxTessGenLevel gl_MaxTessPatchComponents gl_MaxTextureCoords gl_MaxTextureImageUnits '
        + 'gl_MaxTextureUnits gl_MaxVaryingComponents gl_MaxVaryingFloats gl_MaxVaryingVectors '
        + 'gl_MaxVertexAtomicCounterBuffers gl_MaxVertexAtomicCounters gl_MaxVertexAttribs gl_MaxVertexImageUniforms '
        + 'gl_MaxVertexOutputComponents gl_MaxVertexOutputVectors gl_MaxVertexTextureImageUnits '
        + 'gl_MaxVertexUniformComponents gl_MaxVertexUniformVectors gl_MaxViewports gl_MinProgramTexelOffset '
        // Variables
        + 'gl_BackColor gl_BackLightModelProduct gl_BackLightProduct gl_BackMaterial '
        + 'gl_BackSecondaryColor gl_ClipDistance gl_ClipPlane gl_ClipVertex gl_Color '
        + 'gl_DepthRange gl_EyePlaneQ gl_EyePlaneR gl_EyePlaneS gl_EyePlaneT gl_Fog gl_FogCoord '
        + 'gl_FogFragCoord gl_FragColor gl_FragCoord gl_FragData gl_FragDepth gl_FrontColor '
        + 'gl_FrontFacing gl_FrontLightModelProduct gl_FrontLightProduct gl_FrontMaterial '
        + 'gl_FrontSecondaryColor gl_GlobalInvocationID gl_InstanceID gl_InvocationID gl_Layer gl_LightModel '
        + 'gl_LightSource gl_LocalInvocationID gl_LocalInvocationIndex gl_ModelViewMatrix '
        + 'gl_ModelViewMatrixInverse gl_ModelViewMatrixInverseTranspose gl_ModelViewMatrixTranspose '
        + 'gl_ModelViewProjectionMatrix gl_ModelViewProjectionMatrixInverse gl_ModelViewProjectionMatrixInverseTranspose '
        + 'gl_ModelViewProjectionMatrixTranspose gl_MultiTexCoord0 gl_MultiTexCoord1 gl_MultiTexCoord2 '
        + 'gl_MultiTexCoord3 gl_MultiTexCoord4 gl_MultiTexCoord5 gl_MultiTexCoord6 gl_MultiTexCoord7 '
        + 'gl_Normal gl_NormalMatrix gl_NormalScale gl_NumSamples gl_NumWorkGroups gl_ObjectPlaneQ '
        + 'gl_ObjectPlaneR gl_ObjectPlaneS gl_ObjectPlaneT gl_PatchVerticesIn gl_Point gl_PointCoord '
        + 'gl_PointSize gl_Position gl_PrimitiveID gl_PrimitiveIDIn gl_ProjectionMatrix gl_ProjectionMatrixInverse '
        + 'gl_ProjectionMatrixInverseTranspose gl_ProjectionMatrixTranspose gl_SampleID gl_SampleMask '
        + 'gl_SampleMaskIn gl_SamplePosition gl_SecondaryColor gl_TessCoord gl_TessLevelInner gl_TessLevelOuter '
        + 'gl_TexCoord gl_TextureEnvColor gl_TextureMatrix gl_TextureMatrixInverse gl_TextureMatrixInverseTranspose '
        + 'gl_TextureMatrixTranspose gl_Vertex gl_VertexID gl_ViewportIndex gl_WorkGroupID gl_WorkGroupSize gl_in gl_out '
        // Functions
        + 'EmitStreamVertex EmitVertex EndPrimitive EndStreamPrimitive abs acos acosh all any asin '
        + 'asinh atan atanh atomicAdd atomicAnd atomicCompSwap atomicCounter atomicCounterDecrement '
        + 'atomicCounterIncrement atomicExchange atomicMax atomicMin atomicOr atomicXor barrier '
        + 'bitCount bitfieldExtract bitfieldInsert bitfieldReverse ceil clamp cos cosh cross '
        + 'dFdx dFdy degrees determinant distance dot equal exp exp2 faceforward findLSB findMSB '
        + 'floatBitsToInt floatBitsToUint floor fma fract frexp ftransform fwidth greaterThan '
        + 'greaterThanEqual groupMemoryBarrier imageAtomicAdd imageAtomicAnd imageAtomicCompSwap '
        + 'imageAtomicExchange imageAtomicMax imageAtomicMin imageAtomicOr imageAtomicXor imageLoad '
        + 'imageSize imageStore imulExtended intBitsToFloat interpolateAtCentroid interpolateAtOffset '
        + 'interpolateAtSample inverse inversesqrt isinf isnan ldexp length lessThan lessThanEqual log '
        + 'log2 matrixCompMult max memoryBarrier memoryBarrierAtomicCounter memoryBarrierBuffer '
        + 'memoryBarrierImage memoryBarrierShared min mix mod modf noise1 noise2 noise3 noise4 '
        + 'normalize not notEqual outerProduct packDouble2x32 packHalf2x16 packSnorm2x16 packSnorm4x8 '
        + 'packUnorm2x16 packUnorm4x8 pow radians reflect refract round roundEven shadow1D shadow1DLod '
        + 'shadow1DProj shadow1DProjLod shadow2D shadow2DLod shadow2DProj shadow2DProjLod sign sin sinh '
        + 'smoothstep sqrt step tan tanh texelFetch texelFetchOffset texture texture1D texture1DLod '
        + 'texture1DProj texture1DProjLod texture2D texture2DLod texture2DProj texture2DProjLod '
        + 'texture3D texture3DLod texture3DProj texture3DProjLod textureCube textureCubeLod '
        + 'textureGather textureGatherOffset textureGatherOffsets textureGrad textureGradOffset '
        + 'textureLod textureLodOffset textureOffset textureProj textureProjGrad textureProjGradOffset '
        + 'textureProjLod textureProjLodOffset textureProjOffset textureQueryLevels textureQueryLod '
        + 'textureSize transpose trunc uaddCarry uintBitsToFloat umulExtended unpackDouble2x32 '
        + 'unpackHalf2x16 unpackSnorm2x16 unpackSnorm4x8 unpackUnorm2x16 unpackUnorm4x8 usubBorrow',
      literal: 'true false'
    },
    illegal: '"',
    contains: [
      hljs.C_LINE_COMMENT_MODE,
      hljs.C_BLOCK_COMMENT_MODE,
      hljs.C_NUMBER_MODE,
      {
        className: 'meta',
        begin: '#',
        end: '$'
      }
    ]
  };
}

module.exports = glsl;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/gml.js":
/*!********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/gml.js ***!
  \********************************************************/
/***/ (function(module) {

/*
Language: GML
Author: Meseta <meseta@gmail.com>
Description: Game Maker Language for GameMaker Studio 2
Website: https://docs2.yoyogames.com
Category: scripting
*/

function gml(hljs) {
  const KEYWORDS = [
    "#endregion",
    "#macro",
    "#region",
    "and",
    "begin",
    "break",
    "case",
    "constructor",
    "continue",
    "default",
    "delete",
    "div",
    "do",
    "else",
    "end",
    "enum",
    "exit",
    "for",
    "function",
    "globalvar",
    "if",
    "mod",
    "not",
    "or",
    "repeat",
    "return",
    "switch",
    "then",
    "until",
    "var",
    "while",
    "with",
    "xor"
  ];
  const BUILT_INS = [
    "abs",
    "achievement_available",
    "achievement_event",
    "achievement_get_challenges",
    "achievement_get_info",
    "achievement_get_pic",
    "achievement_increment",
    "achievement_load_friends",
    "achievement_load_leaderboard",
    "achievement_load_progress",
    "achievement_login",
    "achievement_login_status",
    "achievement_logout",
    "achievement_post",
    "achievement_post_score",
    "achievement_reset",
    "achievement_send_challenge",
    "achievement_show",
    "achievement_show_achievements",
    "achievement_show_challenge_notifications",
    "achievement_show_leaderboards",
    "action_inherited",
    "action_kill_object",
    "ads_disable",
    "ads_enable",
    "ads_engagement_active",
    "ads_engagement_available",
    "ads_engagement_launch",
    "ads_event",
    "ads_event_preload",
    "ads_get_display_height",
    "ads_get_display_width",
    "ads_interstitial_available",
    "ads_interstitial_display",
    "ads_move",
    "ads_set_reward_callback",
    "ads_setup",
    "alarm_get",
    "alarm_set",
    "analytics_event",
    "analytics_event_ext",
    "angle_difference",
    "ansi_char",
    "application_get_position",
    "application_surface_draw_enable",
    "application_surface_enable",
    "application_surface_is_enabled",
    "arccos",
    "arcsin",
    "arctan",
    "arctan2",
    "array_copy",
    "array_create",
    "array_delete",
    "array_equals",
    "array_height_2d",
    "array_insert",
    "array_length",
    "array_length_1d",
    "array_length_2d",
    "array_pop",
    "array_push",
    "array_resize",
    "array_sort",
    "asset_get_index",
    "asset_get_type",
    "audio_channel_num",
    "audio_create_buffer_sound",
    "audio_create_play_queue",
    "audio_create_stream",
    "audio_create_sync_group",
    "audio_debug",
    "audio_destroy_stream",
    "audio_destroy_sync_group",
    "audio_emitter_create",
    "audio_emitter_exists",
    "audio_emitter_falloff",
    "audio_emitter_free",
    "audio_emitter_gain",
    "audio_emitter_get_gain",
    "audio_emitter_get_listener_mask",
    "audio_emitter_get_pitch",
    "audio_emitter_get_vx",
    "audio_emitter_get_vy",
    "audio_emitter_get_vz",
    "audio_emitter_get_x",
    "audio_emitter_get_y",
    "audio_emitter_get_z",
    "audio_emitter_pitch",
    "audio_emitter_position",
    "audio_emitter_set_listener_mask",
    "audio_emitter_velocity",
    "audio_exists",
    "audio_falloff_set_model",
    "audio_free_buffer_sound",
    "audio_free_play_queue",
    "audio_get_listener_count",
    "audio_get_listener_info",
    "audio_get_listener_mask",
    "audio_get_master_gain",
    "audio_get_name",
    "audio_get_recorder_count",
    "audio_get_recorder_info",
    "audio_get_type",
    "audio_group_is_loaded",
    "audio_group_load",
    "audio_group_load_progress",
    "audio_group_name",
    "audio_group_set_gain",
    "audio_group_stop_all",
    "audio_group_unload",
    "audio_is_paused",
    "audio_is_playing",
    "audio_listener_get_data",
    "audio_listener_orientation",
    "audio_listener_position",
    "audio_listener_set_orientation",
    "audio_listener_set_position",
    "audio_listener_set_velocity",
    "audio_listener_velocity",
    "audio_master_gain",
    "audio_music_gain",
    "audio_music_is_playing",
    "audio_pause_all",
    "audio_pause_music",
    "audio_pause_sound",
    "audio_pause_sync_group",
    "audio_play_in_sync_group",
    "audio_play_music",
    "audio_play_sound",
    "audio_play_sound_at",
    "audio_play_sound_on",
    "audio_queue_sound",
    "audio_resume_all",
    "audio_resume_music",
    "audio_resume_sound",
    "audio_resume_sync_group",
    "audio_set_listener_mask",
    "audio_set_master_gain",
    "audio_sound_gain",
    "audio_sound_get_gain",
    "audio_sound_get_listener_mask",
    "audio_sound_get_pitch",
    "audio_sound_get_track_position",
    "audio_sound_length",
    "audio_sound_pitch",
    "audio_sound_set_listener_mask",
    "audio_sound_set_track_position",
    "audio_start_recording",
    "audio_start_sync_group",
    "audio_stop_all",
    "audio_stop_music",
    "audio_stop_recording",
    "audio_stop_sound",
    "audio_stop_sync_group",
    "audio_sync_group_debug",
    "audio_sync_group_get_track_pos",
    "audio_sync_group_is_playing",
    "audio_system",
    "background_get_height",
    "background_get_width",
    "base64_decode",
    "base64_encode",
    "browser_input_capture",
    "buffer_async_group_begin",
    "buffer_async_group_end",
    "buffer_async_group_option",
    "buffer_base64_decode",
    "buffer_base64_decode_ext",
    "buffer_base64_encode",
    "buffer_copy",
    "buffer_copy_from_vertex_buffer",
    "buffer_create",
    "buffer_create_from_vertex_buffer",
    "buffer_create_from_vertex_buffer_ext",
    "buffer_delete",
    "buffer_exists",
    "buffer_fill",
    "buffer_get_address",
    "buffer_get_alignment",
    "buffer_get_size",
    "buffer_get_surface",
    "buffer_get_type",
    "buffer_load",
    "buffer_load_async",
    "buffer_load_ext",
    "buffer_load_partial",
    "buffer_md5",
    "buffer_peek",
    "buffer_poke",
    "buffer_read",
    "buffer_resize",
    "buffer_save",
    "buffer_save_async",
    "buffer_save_ext",
    "buffer_seek",
    "buffer_set_surface",
    "buffer_sha1",
    "buffer_sizeof",
    "buffer_tell",
    "buffer_write",
    "camera_apply",
    "camera_create",
    "camera_create_view",
    "camera_destroy",
    "camera_get_active",
    "camera_get_begin_script",
    "camera_get_default",
    "camera_get_end_script",
    "camera_get_proj_mat",
    "camera_get_update_script",
    "camera_get_view_angle",
    "camera_get_view_border_x",
    "camera_get_view_border_y",
    "camera_get_view_height",
    "camera_get_view_mat",
    "camera_get_view_speed_x",
    "camera_get_view_speed_y",
    "camera_get_view_target",
    "camera_get_view_width",
    "camera_get_view_x",
    "camera_get_view_y",
    "camera_set_begin_script",
    "camera_set_default",
    "camera_set_end_script",
    "camera_set_proj_mat",
    "camera_set_update_script",
    "camera_set_view_angle",
    "camera_set_view_border",
    "camera_set_view_mat",
    "camera_set_view_pos",
    "camera_set_view_size",
    "camera_set_view_speed",
    "camera_set_view_target",
    "ceil",
    "choose",
    "chr",
    "clamp",
    "clickable_add",
    "clickable_add_ext",
    "clickable_change",
    "clickable_change_ext",
    "clickable_delete",
    "clickable_exists",
    "clickable_set_style",
    "clipboard_get_text",
    "clipboard_has_text",
    "clipboard_set_text",
    "cloud_file_save",
    "cloud_string_save",
    "cloud_synchronise",
    "code_is_compiled",
    "collision_circle",
    "collision_circle_list",
    "collision_ellipse",
    "collision_ellipse_list",
    "collision_line",
    "collision_line_list",
    "collision_point",
    "collision_point_list",
    "collision_rectangle",
    "collision_rectangle_list",
    "color_get_blue",
    "color_get_green",
    "color_get_hue",
    "color_get_red",
    "color_get_saturation",
    "color_get_value",
    "colour_get_blue",
    "colour_get_green",
    "colour_get_hue",
    "colour_get_red",
    "colour_get_saturation",
    "colour_get_value",
    "cos",
    "darccos",
    "darcsin",
    "darctan",
    "darctan2",
    "date_compare_date",
    "date_compare_datetime",
    "date_compare_time",
    "date_create_datetime",
    "date_current_datetime",
    "date_date_of",
    "date_date_string",
    "date_datetime_string",
    "date_day_span",
    "date_days_in_month",
    "date_days_in_year",
    "date_get_day",
    "date_get_day_of_year",
    "date_get_hour",
    "date_get_hour_of_year",
    "date_get_minute",
    "date_get_minute_of_year",
    "date_get_month",
    "date_get_second",
    "date_get_second_of_year",
    "date_get_timezone",
    "date_get_week",
    "date_get_weekday",
    "date_get_year",
    "date_hour_span",
    "date_inc_day",
    "date_inc_hour",
    "date_inc_minute",
    "date_inc_month",
    "date_inc_second",
    "date_inc_week",
    "date_inc_year",
    "date_is_today",
    "date_leap_year",
    "date_minute_span",
    "date_month_span",
    "date_second_span",
    "date_set_timezone",
    "date_time_of",
    "date_time_string",
    "date_valid_datetime",
    "date_week_span",
    "date_year_span",
    "dcos",
    "debug_event",
    "debug_get_callstack",
    "degtorad",
    "device_get_tilt_x",
    "device_get_tilt_y",
    "device_get_tilt_z",
    "device_is_keypad_open",
    "device_mouse_check_button",
    "device_mouse_check_button_pressed",
    "device_mouse_check_button_released",
    "device_mouse_dbclick_enable",
    "device_mouse_raw_x",
    "device_mouse_raw_y",
    "device_mouse_x",
    "device_mouse_x_to_gui",
    "device_mouse_y",
    "device_mouse_y_to_gui",
    "directory_create",
    "directory_destroy",
    "directory_exists",
    "display_get_dpi_x",
    "display_get_dpi_y",
    "display_get_gui_height",
    "display_get_gui_width",
    "display_get_height",
    "display_get_orientation",
    "display_get_sleep_margin",
    "display_get_timing_method",
    "display_get_width",
    "display_mouse_get_x",
    "display_mouse_get_y",
    "display_mouse_set",
    "display_reset",
    "display_set_gui_maximise",
    "display_set_gui_maximize",
    "display_set_gui_size",
    "display_set_sleep_margin",
    "display_set_timing_method",
    "display_set_ui_visibility",
    "distance_to_object",
    "distance_to_point",
    "dot_product",
    "dot_product_3d",
    "dot_product_3d_normalised",
    "dot_product_3d_normalized",
    "dot_product_normalised",
    "dot_product_normalized",
    "draw_arrow",
    "draw_background",
    "draw_background_ext",
    "draw_background_part_ext",
    "draw_background_tiled",
    "draw_button",
    "draw_circle",
    "draw_circle_color",
    "draw_circle_colour",
    "draw_clear",
    "draw_clear_alpha",
    "draw_ellipse",
    "draw_ellipse_color",
    "draw_ellipse_colour",
    "draw_enable_alphablend",
    "draw_enable_drawevent",
    "draw_enable_swf_aa",
    "draw_flush",
    "draw_get_alpha",
    "draw_get_color",
    "draw_get_colour",
    "draw_get_lighting",
    "draw_get_swf_aa_level",
    "draw_getpixel",
    "draw_getpixel_ext",
    "draw_healthbar",
    "draw_highscore",
    "draw_light_define_ambient",
    "draw_light_define_direction",
    "draw_light_define_point",
    "draw_light_enable",
    "draw_light_get",
    "draw_light_get_ambient",
    "draw_line",
    "draw_line_color",
    "draw_line_colour",
    "draw_line_width",
    "draw_line_width_color",
    "draw_line_width_colour",
    "draw_path",
    "draw_point",
    "draw_point_color",
    "draw_point_colour",
    "draw_primitive_begin",
    "draw_primitive_begin_texture",
    "draw_primitive_end",
    "draw_rectangle",
    "draw_rectangle_color",
    "draw_rectangle_colour",
    "draw_roundrect",
    "draw_roundrect_color",
    "draw_roundrect_color_ext",
    "draw_roundrect_colour",
    "draw_roundrect_colour_ext",
    "draw_roundrect_ext",
    "draw_self",
    "draw_set_alpha",
    "draw_set_alpha_test",
    "draw_set_alpha_test_ref_value",
    "draw_set_blend_mode",
    "draw_set_blend_mode_ext",
    "draw_set_circle_precision",
    "draw_set_color",
    "draw_set_color_write_enable",
    "draw_set_colour",
    "draw_set_font",
    "draw_set_halign",
    "draw_set_lighting",
    "draw_set_swf_aa_level",
    "draw_set_valign",
    "draw_skeleton",
    "draw_skeleton_collision",
    "draw_skeleton_instance",
    "draw_skeleton_time",
    "draw_sprite",
    "draw_sprite_ext",
    "draw_sprite_general",
    "draw_sprite_part",
    "draw_sprite_part_ext",
    "draw_sprite_pos",
    "draw_sprite_stretched",
    "draw_sprite_stretched_ext",
    "draw_sprite_tiled",
    "draw_sprite_tiled_ext",
    "draw_surface",
    "draw_surface_ext",
    "draw_surface_general",
    "draw_surface_part",
    "draw_surface_part_ext",
    "draw_surface_stretched",
    "draw_surface_stretched_ext",
    "draw_surface_tiled",
    "draw_surface_tiled_ext",
    "draw_text",
    "draw_text_color",
    "draw_text_colour",
    "draw_text_ext",
    "draw_text_ext_color",
    "draw_text_ext_colour",
    "draw_text_ext_transformed",
    "draw_text_ext_transformed_color",
    "draw_text_ext_transformed_colour",
    "draw_text_transformed",
    "draw_text_transformed_color",
    "draw_text_transformed_colour",
    "draw_texture_flush",
    "draw_tile",
    "draw_tilemap",
    "draw_triangle",
    "draw_triangle_color",
    "draw_triangle_colour",
    "draw_vertex",
    "draw_vertex_color",
    "draw_vertex_colour",
    "draw_vertex_texture",
    "draw_vertex_texture_color",
    "draw_vertex_texture_colour",
    "ds_exists",
    "ds_grid_add",
    "ds_grid_add_disk",
    "ds_grid_add_grid_region",
    "ds_grid_add_region",
    "ds_grid_clear",
    "ds_grid_copy",
    "ds_grid_create",
    "ds_grid_destroy",
    "ds_grid_get",
    "ds_grid_get_disk_max",
    "ds_grid_get_disk_mean",
    "ds_grid_get_disk_min",
    "ds_grid_get_disk_sum",
    "ds_grid_get_max",
    "ds_grid_get_mean",
    "ds_grid_get_min",
    "ds_grid_get_sum",
    "ds_grid_height",
    "ds_grid_multiply",
    "ds_grid_multiply_disk",
    "ds_grid_multiply_grid_region",
    "ds_grid_multiply_region",
    "ds_grid_read",
    "ds_grid_resize",
    "ds_grid_set",
    "ds_grid_set_disk",
    "ds_grid_set_grid_region",
    "ds_grid_set_region",
    "ds_grid_shuffle",
    "ds_grid_sort",
    "ds_grid_value_disk_exists",
    "ds_grid_value_disk_x",
    "ds_grid_value_disk_y",
    "ds_grid_value_exists",
    "ds_grid_value_x",
    "ds_grid_value_y",
    "ds_grid_width",
    "ds_grid_write",
    "ds_list_add",
    "ds_list_clear",
    "ds_list_copy",
    "ds_list_create",
    "ds_list_delete",
    "ds_list_destroy",
    "ds_list_empty",
    "ds_list_find_index",
    "ds_list_find_value",
    "ds_list_insert",
    "ds_list_mark_as_list",
    "ds_list_mark_as_map",
    "ds_list_read",
    "ds_list_replace",
    "ds_list_set",
    "ds_list_shuffle",
    "ds_list_size",
    "ds_list_sort",
    "ds_list_write",
    "ds_map_add",
    "ds_map_add_list",
    "ds_map_add_map",
    "ds_map_clear",
    "ds_map_copy",
    "ds_map_create",
    "ds_map_delete",
    "ds_map_destroy",
    "ds_map_empty",
    "ds_map_exists",
    "ds_map_find_first",
    "ds_map_find_last",
    "ds_map_find_next",
    "ds_map_find_previous",
    "ds_map_find_value",
    "ds_map_read",
    "ds_map_replace",
    "ds_map_replace_list",
    "ds_map_replace_map",
    "ds_map_secure_load",
    "ds_map_secure_load_buffer",
    "ds_map_secure_save",
    "ds_map_secure_save_buffer",
    "ds_map_set",
    "ds_map_size",
    "ds_map_write",
    "ds_priority_add",
    "ds_priority_change_priority",
    "ds_priority_clear",
    "ds_priority_copy",
    "ds_priority_create",
    "ds_priority_delete_max",
    "ds_priority_delete_min",
    "ds_priority_delete_value",
    "ds_priority_destroy",
    "ds_priority_empty",
    "ds_priority_find_max",
    "ds_priority_find_min",
    "ds_priority_find_priority",
    "ds_priority_read",
    "ds_priority_size",
    "ds_priority_write",
    "ds_queue_clear",
    "ds_queue_copy",
    "ds_queue_create",
    "ds_queue_dequeue",
    "ds_queue_destroy",
    "ds_queue_empty",
    "ds_queue_enqueue",
    "ds_queue_head",
    "ds_queue_read",
    "ds_queue_size",
    "ds_queue_tail",
    "ds_queue_write",
    "ds_set_precision",
    "ds_stack_clear",
    "ds_stack_copy",
    "ds_stack_create",
    "ds_stack_destroy",
    "ds_stack_empty",
    "ds_stack_pop",
    "ds_stack_push",
    "ds_stack_read",
    "ds_stack_size",
    "ds_stack_top",
    "ds_stack_write",
    "dsin",
    "dtan",
    "effect_clear",
    "effect_create_above",
    "effect_create_below",
    "environment_get_variable",
    "event_inherited",
    "event_perform",
    "event_perform_object",
    "event_user",
    "exp",
    "external_call",
    "external_define",
    "external_free",
    "facebook_accesstoken",
    "facebook_check_permission",
    "facebook_dialog",
    "facebook_graph_request",
    "facebook_init",
    "facebook_launch_offerwall",
    "facebook_login",
    "facebook_logout",
    "facebook_post_message",
    "facebook_request_publish_permissions",
    "facebook_request_read_permissions",
    "facebook_send_invite",
    "facebook_status",
    "facebook_user_id",
    "file_attributes",
    "file_bin_close",
    "file_bin_open",
    "file_bin_position",
    "file_bin_read_byte",
    "file_bin_rewrite",
    "file_bin_seek",
    "file_bin_size",
    "file_bin_write_byte",
    "file_copy",
    "file_delete",
    "file_exists",
    "file_find_close",
    "file_find_first",
    "file_find_next",
    "file_rename",
    "file_text_close",
    "file_text_eof",
    "file_text_eoln",
    "file_text_open_append",
    "file_text_open_from_string",
    "file_text_open_read",
    "file_text_open_write",
    "file_text_read_real",
    "file_text_read_string",
    "file_text_readln",
    "file_text_write_real",
    "file_text_write_string",
    "file_text_writeln",
    "filename_change_ext",
    "filename_dir",
    "filename_drive",
    "filename_ext",
    "filename_name",
    "filename_path",
    "floor",
    "font_add",
    "font_add_enable_aa",
    "font_add_get_enable_aa",
    "font_add_sprite",
    "font_add_sprite_ext",
    "font_delete",
    "font_exists",
    "font_get_bold",
    "font_get_first",
    "font_get_fontname",
    "font_get_italic",
    "font_get_last",
    "font_get_name",
    "font_get_size",
    "font_get_texture",
    "font_get_uvs",
    "font_replace",
    "font_replace_sprite",
    "font_replace_sprite_ext",
    "font_set_cache_size",
    "font_texture_page_size",
    "frac",
    "game_end",
    "game_get_speed",
    "game_load",
    "game_load_buffer",
    "game_restart",
    "game_save",
    "game_save_buffer",
    "game_set_speed",
    "gamepad_axis_count",
    "gamepad_axis_value",
    "gamepad_button_check",
    "gamepad_button_check_pressed",
    "gamepad_button_check_released",
    "gamepad_button_count",
    "gamepad_button_value",
    "gamepad_get_axis_deadzone",
    "gamepad_get_button_threshold",
    "gamepad_get_description",
    "gamepad_get_device_count",
    "gamepad_is_connected",
    "gamepad_is_supported",
    "gamepad_set_axis_deadzone",
    "gamepad_set_button_threshold",
    "gamepad_set_color",
    "gamepad_set_colour",
    "gamepad_set_vibration",
    "gesture_double_tap_distance",
    "gesture_double_tap_time",
    "gesture_drag_distance",
    "gesture_drag_time",
    "gesture_flick_speed",
    "gesture_get_double_tap_distance",
    "gesture_get_double_tap_time",
    "gesture_get_drag_distance",
    "gesture_get_drag_time",
    "gesture_get_flick_speed",
    "gesture_get_pinch_angle_away",
    "gesture_get_pinch_angle_towards",
    "gesture_get_pinch_distance",
    "gesture_get_rotate_angle",
    "gesture_get_rotate_time",
    "gesture_get_tap_count",
    "gesture_pinch_angle_away",
    "gesture_pinch_angle_towards",
    "gesture_pinch_distance",
    "gesture_rotate_angle",
    "gesture_rotate_time",
    "gesture_tap_count",
    "get_integer",
    "get_integer_async",
    "get_login_async",
    "get_open_filename",
    "get_open_filename_ext",
    "get_save_filename",
    "get_save_filename_ext",
    "get_string",
    "get_string_async",
    "get_timer",
    "gml_pragma",
    "gml_release_mode",
    "gpu_get_alphatestenable",
    "gpu_get_alphatestfunc",
    "gpu_get_alphatestref",
    "gpu_get_blendenable",
    "gpu_get_blendmode",
    "gpu_get_blendmode_dest",
    "gpu_get_blendmode_destalpha",
    "gpu_get_blendmode_ext",
    "gpu_get_blendmode_ext_sepalpha",
    "gpu_get_blendmode_src",
    "gpu_get_blendmode_srcalpha",
    "gpu_get_colorwriteenable",
    "gpu_get_colourwriteenable",
    "gpu_get_cullmode",
    "gpu_get_fog",
    "gpu_get_lightingenable",
    "gpu_get_state",
    "gpu_get_tex_filter",
    "gpu_get_tex_filter_ext",
    "gpu_get_tex_max_aniso",
    "gpu_get_tex_max_aniso_ext",
    "gpu_get_tex_max_mip",
    "gpu_get_tex_max_mip_ext",
    "gpu_get_tex_min_mip",
    "gpu_get_tex_min_mip_ext",
    "gpu_get_tex_mip_bias",
    "gpu_get_tex_mip_bias_ext",
    "gpu_get_tex_mip_enable",
    "gpu_get_tex_mip_enable_ext",
    "gpu_get_tex_mip_filter",
    "gpu_get_tex_mip_filter_ext",
    "gpu_get_tex_repeat",
    "gpu_get_tex_repeat_ext",
    "gpu_get_texfilter",
    "gpu_get_texfilter_ext",
    "gpu_get_texrepeat",
    "gpu_get_texrepeat_ext",
    "gpu_get_zfunc",
    "gpu_get_ztestenable",
    "gpu_get_zwriteenable",
    "gpu_pop_state",
    "gpu_push_state",
    "gpu_set_alphatestenable",
    "gpu_set_alphatestfunc",
    "gpu_set_alphatestref",
    "gpu_set_blendenable",
    "gpu_set_blendmode",
    "gpu_set_blendmode_ext",
    "gpu_set_blendmode_ext_sepalpha",
    "gpu_set_colorwriteenable",
    "gpu_set_colourwriteenable",
    "gpu_set_cullmode",
    "gpu_set_fog",
    "gpu_set_lightingenable",
    "gpu_set_state",
    "gpu_set_tex_filter",
    "gpu_set_tex_filter_ext",
    "gpu_set_tex_max_aniso",
    "gpu_set_tex_max_aniso_ext",
    "gpu_set_tex_max_mip",
    "gpu_set_tex_max_mip_ext",
    "gpu_set_tex_min_mip",
    "gpu_set_tex_min_mip_ext",
    "gpu_set_tex_mip_bias",
    "gpu_set_tex_mip_bias_ext",
    "gpu_set_tex_mip_enable",
    "gpu_set_tex_mip_enable_ext",
    "gpu_set_tex_mip_filter",
    "gpu_set_tex_mip_filter_ext",
    "gpu_set_tex_repeat",
    "gpu_set_tex_repeat_ext",
    "gpu_set_texfilter",
    "gpu_set_texfilter_ext",
    "gpu_set_texrepeat",
    "gpu_set_texrepeat_ext",
    "gpu_set_zfunc",
    "gpu_set_ztestenable",
    "gpu_set_zwriteenable",
    "highscore_add",
    "highscore_clear",
    "highscore_name",
    "highscore_value",
    "http_get",
    "http_get_file",
    "http_post_string",
    "http_request",
    "iap_acquire",
    "iap_activate",
    "iap_consume",
    "iap_enumerate_products",
    "iap_product_details",
    "iap_purchase_details",
    "iap_restore_all",
    "iap_status",
    "ini_close",
    "ini_key_delete",
    "ini_key_exists",
    "ini_open",
    "ini_open_from_string",
    "ini_read_real",
    "ini_read_string",
    "ini_section_delete",
    "ini_section_exists",
    "ini_write_real",
    "ini_write_string",
    "instance_activate_all",
    "instance_activate_layer",
    "instance_activate_object",
    "instance_activate_region",
    "instance_change",
    "instance_copy",
    "instance_create",
    "instance_create_depth",
    "instance_create_layer",
    "instance_deactivate_all",
    "instance_deactivate_layer",
    "instance_deactivate_object",
    "instance_deactivate_region",
    "instance_destroy",
    "instance_exists",
    "instance_find",
    "instance_furthest",
    "instance_id_get",
    "instance_nearest",
    "instance_number",
    "instance_place",
    "instance_place_list",
    "instance_position",
    "instance_position_list",
    "int64",
    "io_clear",
    "irandom",
    "irandom_range",
    "is_array",
    "is_bool",
    "is_infinity",
    "is_int32",
    "is_int64",
    "is_matrix",
    "is_method",
    "is_nan",
    "is_numeric",
    "is_ptr",
    "is_real",
    "is_string",
    "is_struct",
    "is_undefined",
    "is_vec3",
    "is_vec4",
    "json_decode",
    "json_encode",
    "keyboard_check",
    "keyboard_check_direct",
    "keyboard_check_pressed",
    "keyboard_check_released",
    "keyboard_clear",
    "keyboard_get_map",
    "keyboard_get_numlock",
    "keyboard_key_press",
    "keyboard_key_release",
    "keyboard_set_map",
    "keyboard_set_numlock",
    "keyboard_unset_map",
    "keyboard_virtual_height",
    "keyboard_virtual_hide",
    "keyboard_virtual_show",
    "keyboard_virtual_status",
    "layer_add_instance",
    "layer_background_alpha",
    "layer_background_blend",
    "layer_background_change",
    "layer_background_create",
    "layer_background_destroy",
    "layer_background_exists",
    "layer_background_get_alpha",
    "layer_background_get_blend",
    "layer_background_get_htiled",
    "layer_background_get_id",
    "layer_background_get_index",
    "layer_background_get_speed",
    "layer_background_get_sprite",
    "layer_background_get_stretch",
    "layer_background_get_visible",
    "layer_background_get_vtiled",
    "layer_background_get_xscale",
    "layer_background_get_yscale",
    "layer_background_htiled",
    "layer_background_index",
    "layer_background_speed",
    "layer_background_sprite",
    "layer_background_stretch",
    "layer_background_visible",
    "layer_background_vtiled",
    "layer_background_xscale",
    "layer_background_yscale",
    "layer_create",
    "layer_depth",
    "layer_destroy",
    "layer_destroy_instances",
    "layer_element_move",
    "layer_exists",
    "layer_force_draw_depth",
    "layer_get_all",
    "layer_get_all_elements",
    "layer_get_depth",
    "layer_get_element_layer",
    "layer_get_element_type",
    "layer_get_forced_depth",
    "layer_get_hspeed",
    "layer_get_id",
    "layer_get_id_at_depth",
    "layer_get_name",
    "layer_get_script_begin",
    "layer_get_script_end",
    "layer_get_shader",
    "layer_get_target_room",
    "layer_get_visible",
    "layer_get_vspeed",
    "layer_get_x",
    "layer_get_y",
    "layer_has_instance",
    "layer_hspeed",
    "layer_instance_get_instance",
    "layer_is_draw_depth_forced",
    "layer_reset_target_room",
    "layer_script_begin",
    "layer_script_end",
    "layer_set_target_room",
    "layer_set_visible",
    "layer_shader",
    "layer_sprite_alpha",
    "layer_sprite_angle",
    "layer_sprite_blend",
    "layer_sprite_change",
    "layer_sprite_create",
    "layer_sprite_destroy",
    "layer_sprite_exists",
    "layer_sprite_get_alpha",
    "layer_sprite_get_angle",
    "layer_sprite_get_blend",
    "layer_sprite_get_id",
    "layer_sprite_get_index",
    "layer_sprite_get_speed",
    "layer_sprite_get_sprite",
    "layer_sprite_get_x",
    "layer_sprite_get_xscale",
    "layer_sprite_get_y",
    "layer_sprite_get_yscale",
    "layer_sprite_index",
    "layer_sprite_speed",
    "layer_sprite_x",
    "layer_sprite_xscale",
    "layer_sprite_y",
    "layer_sprite_yscale",
    "layer_tile_alpha",
    "layer_tile_blend",
    "layer_tile_change",
    "layer_tile_create",
    "layer_tile_destroy",
    "layer_tile_exists",
    "layer_tile_get_alpha",
    "layer_tile_get_blend",
    "layer_tile_get_region",
    "layer_tile_get_sprite",
    "layer_tile_get_visible",
    "layer_tile_get_x",
    "layer_tile_get_xscale",
    "layer_tile_get_y",
    "layer_tile_get_yscale",
    "layer_tile_region",
    "layer_tile_visible",
    "layer_tile_x",
    "layer_tile_xscale",
    "layer_tile_y",
    "layer_tile_yscale",
    "layer_tilemap_create",
    "layer_tilemap_destroy",
    "layer_tilemap_exists",
    "layer_tilemap_get_id",
    "layer_vspeed",
    "layer_x",
    "layer_y",
    "lengthdir_x",
    "lengthdir_y",
    "lerp",
    "ln",
    "load_csv",
    "log10",
    "log2",
    "logn",
    "make_color_hsv",
    "make_color_rgb",
    "make_colour_hsv",
    "make_colour_rgb",
    "math_get_epsilon",
    "math_set_epsilon",
    "matrix_build",
    "matrix_build_identity",
    "matrix_build_lookat",
    "matrix_build_projection_ortho",
    "matrix_build_projection_perspective",
    "matrix_build_projection_perspective_fov",
    "matrix_get",
    "matrix_multiply",
    "matrix_set",
    "matrix_stack_clear",
    "matrix_stack_is_empty",
    "matrix_stack_multiply",
    "matrix_stack_pop",
    "matrix_stack_push",
    "matrix_stack_set",
    "matrix_stack_top",
    "matrix_transform_vertex",
    "max",
    "md5_file",
    "md5_string_unicode",
    "md5_string_utf8",
    "mean",
    "median",
    "merge_color",
    "merge_colour",
    "min",
    "motion_add",
    "motion_set",
    "mouse_check_button",
    "mouse_check_button_pressed",
    "mouse_check_button_released",
    "mouse_clear",
    "mouse_wheel_down",
    "mouse_wheel_up",
    "move_bounce_all",
    "move_bounce_solid",
    "move_contact_all",
    "move_contact_solid",
    "move_outside_all",
    "move_outside_solid",
    "move_random",
    "move_snap",
    "move_towards_point",
    "move_wrap",
    "mp_grid_add_cell",
    "mp_grid_add_instances",
    "mp_grid_add_rectangle",
    "mp_grid_clear_all",
    "mp_grid_clear_cell",
    "mp_grid_clear_rectangle",
    "mp_grid_create",
    "mp_grid_destroy",
    "mp_grid_draw",
    "mp_grid_get_cell",
    "mp_grid_path",
    "mp_grid_to_ds_grid",
    "mp_linear_path",
    "mp_linear_path_object",
    "mp_linear_step",
    "mp_linear_step_object",
    "mp_potential_path",
    "mp_potential_path_object",
    "mp_potential_settings",
    "mp_potential_step",
    "mp_potential_step_object",
    "network_connect",
    "network_connect_raw",
    "network_create_server",
    "network_create_server_raw",
    "network_create_socket",
    "network_create_socket_ext",
    "network_destroy",
    "network_resolve",
    "network_send_broadcast",
    "network_send_packet",
    "network_send_raw",
    "network_send_udp",
    "network_send_udp_raw",
    "network_set_config",
    "network_set_timeout",
    "object_exists",
    "object_get_depth",
    "object_get_mask",
    "object_get_name",
    "object_get_parent",
    "object_get_persistent",
    "object_get_physics",
    "object_get_solid",
    "object_get_sprite",
    "object_get_visible",
    "object_is_ancestor",
    "object_set_mask",
    "object_set_persistent",
    "object_set_solid",
    "object_set_sprite",
    "object_set_visible",
    "ord",
    "os_get_config",
    "os_get_info",
    "os_get_language",
    "os_get_region",
    "os_is_network_connected",
    "os_is_paused",
    "os_lock_orientation",
    "os_powersave_enable",
    "parameter_count",
    "parameter_string",
    "part_emitter_burst",
    "part_emitter_clear",
    "part_emitter_create",
    "part_emitter_destroy",
    "part_emitter_destroy_all",
    "part_emitter_exists",
    "part_emitter_region",
    "part_emitter_stream",
    "part_particles_clear",
    "part_particles_count",
    "part_particles_create",
    "part_particles_create_color",
    "part_particles_create_colour",
    "part_system_automatic_draw",
    "part_system_automatic_update",
    "part_system_clear",
    "part_system_create",
    "part_system_create_layer",
    "part_system_depth",
    "part_system_destroy",
    "part_system_draw_order",
    "part_system_drawit",
    "part_system_exists",
    "part_system_get_layer",
    "part_system_layer",
    "part_system_position",
    "part_system_update",
    "part_type_alpha1",
    "part_type_alpha2",
    "part_type_alpha3",
    "part_type_blend",
    "part_type_clear",
    "part_type_color1",
    "part_type_color2",
    "part_type_color3",
    "part_type_color_hsv",
    "part_type_color_mix",
    "part_type_color_rgb",
    "part_type_colour1",
    "part_type_colour2",
    "part_type_colour3",
    "part_type_colour_hsv",
    "part_type_colour_mix",
    "part_type_colour_rgb",
    "part_type_create",
    "part_type_death",
    "part_type_destroy",
    "part_type_direction",
    "part_type_exists",
    "part_type_gravity",
    "part_type_life",
    "part_type_orientation",
    "part_type_scale",
    "part_type_shape",
    "part_type_size",
    "part_type_speed",
    "part_type_sprite",
    "part_type_step",
    "path_add",
    "path_add_point",
    "path_append",
    "path_assign",
    "path_change_point",
    "path_clear_points",
    "path_delete",
    "path_delete_point",
    "path_duplicate",
    "path_end",
    "path_exists",
    "path_flip",
    "path_get_closed",
    "path_get_kind",
    "path_get_length",
    "path_get_name",
    "path_get_number",
    "path_get_point_speed",
    "path_get_point_x",
    "path_get_point_y",
    "path_get_precision",
    "path_get_speed",
    "path_get_time",
    "path_get_x",
    "path_get_y",
    "path_insert_point",
    "path_mirror",
    "path_rescale",
    "path_reverse",
    "path_rotate",
    "path_set_closed",
    "path_set_kind",
    "path_set_precision",
    "path_shift",
    "path_start",
    "physics_apply_angular_impulse",
    "physics_apply_force",
    "physics_apply_impulse",
    "physics_apply_local_force",
    "physics_apply_local_impulse",
    "physics_apply_torque",
    "physics_draw_debug",
    "physics_fixture_add_point",
    "physics_fixture_bind",
    "physics_fixture_bind_ext",
    "physics_fixture_create",
    "physics_fixture_delete",
    "physics_fixture_set_angular_damping",
    "physics_fixture_set_awake",
    "physics_fixture_set_box_shape",
    "physics_fixture_set_chain_shape",
    "physics_fixture_set_circle_shape",
    "physics_fixture_set_collision_group",
    "physics_fixture_set_density",
    "physics_fixture_set_edge_shape",
    "physics_fixture_set_friction",
    "physics_fixture_set_kinematic",
    "physics_fixture_set_linear_damping",
    "physics_fixture_set_polygon_shape",
    "physics_fixture_set_restitution",
    "physics_fixture_set_sensor",
    "physics_get_density",
    "physics_get_friction",
    "physics_get_restitution",
    "physics_joint_delete",
    "physics_joint_distance_create",
    "physics_joint_enable_motor",
    "physics_joint_friction_create",
    "physics_joint_gear_create",
    "physics_joint_get_value",
    "physics_joint_prismatic_create",
    "physics_joint_pulley_create",
    "physics_joint_revolute_create",
    "physics_joint_rope_create",
    "physics_joint_set_value",
    "physics_joint_weld_create",
    "physics_joint_wheel_create",
    "physics_mass_properties",
    "physics_particle_count",
    "physics_particle_create",
    "physics_particle_delete",
    "physics_particle_delete_region_box",
    "physics_particle_delete_region_circle",
    "physics_particle_delete_region_poly",
    "physics_particle_draw",
    "physics_particle_draw_ext",
    "physics_particle_get_damping",
    "physics_particle_get_data",
    "physics_particle_get_data_particle",
    "physics_particle_get_density",
    "physics_particle_get_gravity_scale",
    "physics_particle_get_group_flags",
    "physics_particle_get_max_count",
    "physics_particle_get_radius",
    "physics_particle_group_add_point",
    "physics_particle_group_begin",
    "physics_particle_group_box",
    "physics_particle_group_circle",
    "physics_particle_group_count",
    "physics_particle_group_delete",
    "physics_particle_group_end",
    "physics_particle_group_get_ang_vel",
    "physics_particle_group_get_angle",
    "physics_particle_group_get_centre_x",
    "physics_particle_group_get_centre_y",
    "physics_particle_group_get_data",
    "physics_particle_group_get_inertia",
    "physics_particle_group_get_mass",
    "physics_particle_group_get_vel_x",
    "physics_particle_group_get_vel_y",
    "physics_particle_group_get_x",
    "physics_particle_group_get_y",
    "physics_particle_group_join",
    "physics_particle_group_polygon",
    "physics_particle_set_category_flags",
    "physics_particle_set_damping",
    "physics_particle_set_density",
    "physics_particle_set_flags",
    "physics_particle_set_gravity_scale",
    "physics_particle_set_group_flags",
    "physics_particle_set_max_count",
    "physics_particle_set_radius",
    "physics_pause_enable",
    "physics_remove_fixture",
    "physics_set_density",
    "physics_set_friction",
    "physics_set_restitution",
    "physics_test_overlap",
    "physics_world_create",
    "physics_world_draw_debug",
    "physics_world_gravity",
    "physics_world_update_iterations",
    "physics_world_update_speed",
    "place_empty",
    "place_free",
    "place_meeting",
    "place_snapped",
    "point_direction",
    "point_distance",
    "point_distance_3d",
    "point_in_circle",
    "point_in_rectangle",
    "point_in_triangle",
    "position_change",
    "position_destroy",
    "position_empty",
    "position_meeting",
    "power",
    "ptr",
    "push_cancel_local_notification",
    "push_get_first_local_notification",
    "push_get_next_local_notification",
    "push_local_notification",
    "radtodeg",
    "random",
    "random_get_seed",
    "random_range",
    "random_set_seed",
    "randomise",
    "randomize",
    "real",
    "rectangle_in_circle",
    "rectangle_in_rectangle",
    "rectangle_in_triangle",
    "room_add",
    "room_assign",
    "room_duplicate",
    "room_exists",
    "room_get_camera",
    "room_get_name",
    "room_get_viewport",
    "room_goto",
    "room_goto_next",
    "room_goto_previous",
    "room_instance_add",
    "room_instance_clear",
    "room_next",
    "room_previous",
    "room_restart",
    "room_set_background_color",
    "room_set_background_colour",
    "room_set_camera",
    "room_set_height",
    "room_set_persistent",
    "room_set_view",
    "room_set_view_enabled",
    "room_set_viewport",
    "room_set_width",
    "round",
    "screen_save",
    "screen_save_part",
    "script_execute",
    "script_exists",
    "script_get_name",
    "sha1_file",
    "sha1_string_unicode",
    "sha1_string_utf8",
    "shader_current",
    "shader_enable_corner_id",
    "shader_get_name",
    "shader_get_sampler_index",
    "shader_get_uniform",
    "shader_is_compiled",
    "shader_reset",
    "shader_set",
    "shader_set_uniform_f",
    "shader_set_uniform_f_array",
    "shader_set_uniform_i",
    "shader_set_uniform_i_array",
    "shader_set_uniform_matrix",
    "shader_set_uniform_matrix_array",
    "shaders_are_supported",
    "shop_leave_rating",
    "show_debug_message",
    "show_debug_overlay",
    "show_error",
    "show_message",
    "show_message_async",
    "show_question",
    "show_question_async",
    "sign",
    "sin",
    "skeleton_animation_clear",
    "skeleton_animation_get",
    "skeleton_animation_get_duration",
    "skeleton_animation_get_ext",
    "skeleton_animation_get_frame",
    "skeleton_animation_get_frames",
    "skeleton_animation_list",
    "skeleton_animation_mix",
    "skeleton_animation_set",
    "skeleton_animation_set_ext",
    "skeleton_animation_set_frame",
    "skeleton_attachment_create",
    "skeleton_attachment_get",
    "skeleton_attachment_set",
    "skeleton_bone_data_get",
    "skeleton_bone_data_set",
    "skeleton_bone_state_get",
    "skeleton_bone_state_set",
    "skeleton_collision_draw_set",
    "skeleton_get_bounds",
    "skeleton_get_minmax",
    "skeleton_get_num_bounds",
    "skeleton_skin_get",
    "skeleton_skin_list",
    "skeleton_skin_set",
    "skeleton_slot_data",
    "sprite_add",
    "sprite_add_from_surface",
    "sprite_assign",
    "sprite_collision_mask",
    "sprite_create_from_surface",
    "sprite_delete",
    "sprite_duplicate",
    "sprite_exists",
    "sprite_flush",
    "sprite_flush_multi",
    "sprite_get_bbox_bottom",
    "sprite_get_bbox_left",
    "sprite_get_bbox_right",
    "sprite_get_bbox_top",
    "sprite_get_height",
    "sprite_get_name",
    "sprite_get_number",
    "sprite_get_speed",
    "sprite_get_speed_type",
    "sprite_get_texture",
    "sprite_get_tpe",
    "sprite_get_uvs",
    "sprite_get_width",
    "sprite_get_xoffset",
    "sprite_get_yoffset",
    "sprite_merge",
    "sprite_prefetch",
    "sprite_prefetch_multi",
    "sprite_replace",
    "sprite_save",
    "sprite_save_strip",
    "sprite_set_alpha_from_sprite",
    "sprite_set_cache_size",
    "sprite_set_cache_size_ext",
    "sprite_set_offset",
    "sprite_set_speed",
    "sqr",
    "sqrt",
    "steam_activate_overlay",
    "steam_activate_overlay_browser",
    "steam_activate_overlay_store",
    "steam_activate_overlay_user",
    "steam_available_languages",
    "steam_clear_achievement",
    "steam_create_leaderboard",
    "steam_current_game_language",
    "steam_download_friends_scores",
    "steam_download_scores",
    "steam_download_scores_around_user",
    "steam_file_delete",
    "steam_file_exists",
    "steam_file_persisted",
    "steam_file_read",
    "steam_file_share",
    "steam_file_size",
    "steam_file_write",
    "steam_file_write_file",
    "steam_get_achievement",
    "steam_get_app_id",
    "steam_get_persona_name",
    "steam_get_quota_free",
    "steam_get_quota_total",
    "steam_get_stat_avg_rate",
    "steam_get_stat_float",
    "steam_get_stat_int",
    "steam_get_user_account_id",
    "steam_get_user_persona_name",
    "steam_get_user_steam_id",
    "steam_initialised",
    "steam_is_cloud_enabled_for_account",
    "steam_is_cloud_enabled_for_app",
    "steam_is_overlay_activated",
    "steam_is_overlay_enabled",
    "steam_is_screenshot_requested",
    "steam_is_user_logged_on",
    "steam_reset_all_stats",
    "steam_reset_all_stats_achievements",
    "steam_send_screenshot",
    "steam_set_achievement",
    "steam_set_stat_avg_rate",
    "steam_set_stat_float",
    "steam_set_stat_int",
    "steam_stats_ready",
    "steam_ugc_create_item",
    "steam_ugc_create_query_all",
    "steam_ugc_create_query_all_ex",
    "steam_ugc_create_query_user",
    "steam_ugc_create_query_user_ex",
    "steam_ugc_download",
    "steam_ugc_get_item_install_info",
    "steam_ugc_get_item_update_info",
    "steam_ugc_get_item_update_progress",
    "steam_ugc_get_subscribed_items",
    "steam_ugc_num_subscribed_items",
    "steam_ugc_query_add_excluded_tag",
    "steam_ugc_query_add_required_tag",
    "steam_ugc_query_set_allow_cached_response",
    "steam_ugc_query_set_cloud_filename_filter",
    "steam_ugc_query_set_match_any_tag",
    "steam_ugc_query_set_ranked_by_trend_days",
    "steam_ugc_query_set_return_long_description",
    "steam_ugc_query_set_return_total_only",
    "steam_ugc_query_set_search_text",
    "steam_ugc_request_item_details",
    "steam_ugc_send_query",
    "steam_ugc_set_item_content",
    "steam_ugc_set_item_description",
    "steam_ugc_set_item_preview",
    "steam_ugc_set_item_tags",
    "steam_ugc_set_item_title",
    "steam_ugc_set_item_visibility",
    "steam_ugc_start_item_update",
    "steam_ugc_submit_item_update",
    "steam_ugc_subscribe_item",
    "steam_ugc_unsubscribe_item",
    "steam_upload_score",
    "steam_upload_score_buffer",
    "steam_upload_score_buffer_ext",
    "steam_upload_score_ext",
    "steam_user_installed_dlc",
    "steam_user_owns_dlc",
    "string",
    "string_byte_at",
    "string_byte_length",
    "string_char_at",
    "string_copy",
    "string_count",
    "string_delete",
    "string_digits",
    "string_format",
    "string_hash_to_newline",
    "string_height",
    "string_height_ext",
    "string_insert",
    "string_length",
    "string_letters",
    "string_lettersdigits",
    "string_lower",
    "string_ord_at",
    "string_pos",
    "string_repeat",
    "string_replace",
    "string_replace_all",
    "string_set_byte_at",
    "string_upper",
    "string_width",
    "string_width_ext",
    "surface_copy",
    "surface_copy_part",
    "surface_create",
    "surface_create_ext",
    "surface_depth_disable",
    "surface_exists",
    "surface_free",
    "surface_get_depth_disable",
    "surface_get_height",
    "surface_get_texture",
    "surface_get_width",
    "surface_getpixel",
    "surface_getpixel_ext",
    "surface_reset_target",
    "surface_resize",
    "surface_save",
    "surface_save_part",
    "surface_set_target",
    "surface_set_target_ext",
    "tan",
    "texture_get_height",
    "texture_get_texel_height",
    "texture_get_texel_width",
    "texture_get_uvs",
    "texture_get_width",
    "texture_global_scale",
    "texture_set_stage",
    "tile_get_empty",
    "tile_get_flip",
    "tile_get_index",
    "tile_get_mirror",
    "tile_get_rotate",
    "tile_set_empty",
    "tile_set_flip",
    "tile_set_index",
    "tile_set_mirror",
    "tile_set_rotate",
    "tilemap_clear",
    "tilemap_get",
    "tilemap_get_at_pixel",
    "tilemap_get_cell_x_at_pixel",
    "tilemap_get_cell_y_at_pixel",
    "tilemap_get_frame",
    "tilemap_get_global_mask",
    "tilemap_get_height",
    "tilemap_get_mask",
    "tilemap_get_tile_height",
    "tilemap_get_tile_width",
    "tilemap_get_tileset",
    "tilemap_get_width",
    "tilemap_get_x",
    "tilemap_get_y",
    "tilemap_set",
    "tilemap_set_at_pixel",
    "tilemap_set_global_mask",
    "tilemap_set_mask",
    "tilemap_tileset",
    "tilemap_x",
    "tilemap_y",
    "timeline_add",
    "timeline_clear",
    "timeline_delete",
    "timeline_exists",
    "timeline_get_name",
    "timeline_max_moment",
    "timeline_moment_add_script",
    "timeline_moment_clear",
    "timeline_size",
    "typeof",
    "url_get_domain",
    "url_open",
    "url_open_ext",
    "url_open_full",
    "variable_global_exists",
    "variable_global_get",
    "variable_global_set",
    "variable_instance_exists",
    "variable_instance_get",
    "variable_instance_get_names",
    "variable_instance_set",
    "variable_struct_exists",
    "variable_struct_get",
    "variable_struct_get_names",
    "variable_struct_names_count",
    "variable_struct_remove",
    "variable_struct_set",
    "vertex_argb",
    "vertex_begin",
    "vertex_color",
    "vertex_colour",
    "vertex_create_buffer",
    "vertex_create_buffer_ext",
    "vertex_create_buffer_from_buffer",
    "vertex_create_buffer_from_buffer_ext",
    "vertex_delete_buffer",
    "vertex_end",
    "vertex_float1",
    "vertex_float2",
    "vertex_float3",
    "vertex_float4",
    "vertex_format_add_color",
    "vertex_format_add_colour",
    "vertex_format_add_custom",
    "vertex_format_add_normal",
    "vertex_format_add_position",
    "vertex_format_add_position_3d",
    "vertex_format_add_texcoord",
    "vertex_format_add_textcoord",
    "vertex_format_begin",
    "vertex_format_delete",
    "vertex_format_end",
    "vertex_freeze",
    "vertex_get_buffer_size",
    "vertex_get_number",
    "vertex_normal",
    "vertex_position",
    "vertex_position_3d",
    "vertex_submit",
    "vertex_texcoord",
    "vertex_ubyte4",
    "view_get_camera",
    "view_get_hport",
    "view_get_surface_id",
    "view_get_visible",
    "view_get_wport",
    "view_get_xport",
    "view_get_yport",
    "view_set_camera",
    "view_set_hport",
    "view_set_surface_id",
    "view_set_visible",
    "view_set_wport",
    "view_set_xport",
    "view_set_yport",
    "virtual_key_add",
    "virtual_key_delete",
    "virtual_key_hide",
    "virtual_key_show",
    "win8_appbar_add_element",
    "win8_appbar_enable",
    "win8_appbar_remove_element",
    "win8_device_touchscreen_available",
    "win8_license_initialize_sandbox",
    "win8_license_trial_version",
    "win8_livetile_badge_clear",
    "win8_livetile_badge_notification",
    "win8_livetile_notification_begin",
    "win8_livetile_notification_end",
    "win8_livetile_notification_expiry",
    "win8_livetile_notification_image_add",
    "win8_livetile_notification_secondary_begin",
    "win8_livetile_notification_tag",
    "win8_livetile_notification_text_add",
    "win8_livetile_queue_enable",
    "win8_livetile_tile_clear",
    "win8_livetile_tile_notification",
    "win8_search_add_suggestions",
    "win8_search_disable",
    "win8_search_enable",
    "win8_secondarytile_badge_notification",
    "win8_secondarytile_delete",
    "win8_secondarytile_pin",
    "win8_settingscharm_add_entry",
    "win8_settingscharm_add_html_entry",
    "win8_settingscharm_add_xaml_entry",
    "win8_settingscharm_get_xaml_property",
    "win8_settingscharm_remove_entry",
    "win8_settingscharm_set_xaml_property",
    "win8_share_file",
    "win8_share_image",
    "win8_share_screenshot",
    "win8_share_text",
    "win8_share_url",
    "window_center",
    "window_device",
    "window_get_caption",
    "window_get_color",
    "window_get_colour",
    "window_get_cursor",
    "window_get_fullscreen",
    "window_get_height",
    "window_get_visible_rects",
    "window_get_width",
    "window_get_x",
    "window_get_y",
    "window_handle",
    "window_has_focus",
    "window_mouse_get_x",
    "window_mouse_get_y",
    "window_mouse_set",
    "window_set_caption",
    "window_set_color",
    "window_set_colour",
    "window_set_cursor",
    "window_set_fullscreen",
    "window_set_max_height",
    "window_set_max_width",
    "window_set_min_height",
    "window_set_min_width",
    "window_set_position",
    "window_set_rectangle",
    "window_set_size",
    "window_view_mouse_get_x",
    "window_view_mouse_get_y",
    "window_views_mouse_get_x",
    "window_views_mouse_get_y",
    "winphone_license_trial_version",
    "winphone_tile_back_content",
    "winphone_tile_back_content_wide",
    "winphone_tile_back_image",
    "winphone_tile_back_image_wide",
    "winphone_tile_back_title",
    "winphone_tile_background_color",
    "winphone_tile_background_colour",
    "winphone_tile_count",
    "winphone_tile_cycle_images",
    "winphone_tile_front_image",
    "winphone_tile_front_image_small",
    "winphone_tile_front_image_wide",
    "winphone_tile_icon_image",
    "winphone_tile_small_background_image",
    "winphone_tile_small_icon_image",
    "winphone_tile_title",
    "winphone_tile_wide_content",
    "zip_unzip"
  ];
  const LITERALS = [
    "all",
    "false",
    "noone",
    "pointer_invalid",
    "pointer_null",
    "true",
    "undefined"
  ];
  // many of these look like enumerables to me (see comments below)
  const SYMBOLS = [
    "ANSI_CHARSET",
    "ARABIC_CHARSET",
    "BALTIC_CHARSET",
    "CHINESEBIG5_CHARSET",
    "DEFAULT_CHARSET",
    "EASTEUROPE_CHARSET",
    "GB2312_CHARSET",
    "GM_build_date",
    "GM_runtime_version",
    "GM_version",
    "GREEK_CHARSET",
    "HANGEUL_CHARSET",
    "HEBREW_CHARSET",
    "JOHAB_CHARSET",
    "MAC_CHARSET",
    "OEM_CHARSET",
    "RUSSIAN_CHARSET",
    "SHIFTJIS_CHARSET",
    "SYMBOL_CHARSET",
    "THAI_CHARSET",
    "TURKISH_CHARSET",
    "VIETNAMESE_CHARSET",
    "achievement_achievement_info",
    "achievement_filter_all_players",
    "achievement_filter_favorites_only",
    "achievement_filter_friends_only",
    "achievement_friends_info",
    "achievement_leaderboard_info",
    "achievement_our_info",
    "achievement_pic_loaded",
    "achievement_show_achievement",
    "achievement_show_bank",
    "achievement_show_friend_picker",
    "achievement_show_leaderboard",
    "achievement_show_profile",
    "achievement_show_purchase_prompt",
    "achievement_show_ui",
    "achievement_type_achievement_challenge",
    "achievement_type_score_challenge",
    "asset_font",
    "asset_object",
    "asset_path",
    "asset_room",
    "asset_script",
    "asset_shader",
    "asset_sound",
    "asset_sprite",
    "asset_tiles",
    "asset_timeline",
    "asset_unknown",
    "audio_3d",
    "audio_falloff_exponent_distance",
    "audio_falloff_exponent_distance_clamped",
    "audio_falloff_inverse_distance",
    "audio_falloff_inverse_distance_clamped",
    "audio_falloff_linear_distance",
    "audio_falloff_linear_distance_clamped",
    "audio_falloff_none",
    "audio_mono",
    "audio_new_system",
    "audio_old_system",
    "audio_stereo",
    "bm_add",
    "bm_complex",
    "bm_dest_alpha",
    "bm_dest_color",
    "bm_dest_colour",
    "bm_inv_dest_alpha",
    "bm_inv_dest_color",
    "bm_inv_dest_colour",
    "bm_inv_src_alpha",
    "bm_inv_src_color",
    "bm_inv_src_colour",
    "bm_max",
    "bm_normal",
    "bm_one",
    "bm_src_alpha",
    "bm_src_alpha_sat",
    "bm_src_color",
    "bm_src_colour",
    "bm_subtract",
    "bm_zero",
    "browser_chrome",
    "browser_edge",
    "browser_firefox",
    "browser_ie",
    "browser_ie_mobile",
    "browser_not_a_browser",
    "browser_opera",
    "browser_safari",
    "browser_safari_mobile",
    "browser_tizen",
    "browser_unknown",
    "browser_windows_store",
    "buffer_bool",
    "buffer_f16",
    "buffer_f32",
    "buffer_f64",
    "buffer_fast",
    "buffer_fixed",
    "buffer_generalerror",
    "buffer_grow",
    "buffer_invalidtype",
    "buffer_network",
    "buffer_outofbounds",
    "buffer_outofspace",
    "buffer_s16",
    "buffer_s32",
    "buffer_s8",
    "buffer_seek_end",
    "buffer_seek_relative",
    "buffer_seek_start",
    "buffer_string",
    "buffer_surface_copy",
    "buffer_text",
    "buffer_u16",
    "buffer_u32",
    "buffer_u64",
    "buffer_u8",
    "buffer_vbuffer",
    "buffer_wrap",
    "button_type",
    "c_aqua",
    "c_black",
    "c_blue",
    "c_dkgray",
    "c_fuchsia",
    "c_gray",
    "c_green",
    "c_lime",
    "c_ltgray",
    "c_maroon",
    "c_navy",
    "c_olive",
    "c_orange",
    "c_purple",
    "c_red",
    "c_silver",
    "c_teal",
    "c_white",
    "c_yellow",
    "cmpfunc_always",
    "cmpfunc_equal",
    "cmpfunc_greater",
    "cmpfunc_greaterequal",
    "cmpfunc_less",
    "cmpfunc_lessequal",
    "cmpfunc_never",
    "cmpfunc_notequal",
    "cr_appstart",
    "cr_arrow",
    "cr_beam",
    "cr_cross",
    "cr_default",
    "cr_drag",
    "cr_handpoint",
    "cr_hourglass",
    "cr_none",
    "cr_size_all",
    "cr_size_nesw",
    "cr_size_ns",
    "cr_size_nwse",
    "cr_size_we",
    "cr_uparrow",
    "cull_clockwise",
    "cull_counterclockwise",
    "cull_noculling",
    "device_emulator",
    "device_ios_ipad",
    "device_ios_ipad_retina",
    "device_ios_iphone",
    "device_ios_iphone5",
    "device_ios_iphone6",
    "device_ios_iphone6plus",
    "device_ios_iphone_retina",
    "device_ios_unknown",
    "device_tablet",
    "display_landscape",
    "display_landscape_flipped",
    "display_portrait",
    "display_portrait_flipped",
    "dll_cdecl",
    "dll_stdcall",
    "ds_type_grid",
    "ds_type_list",
    "ds_type_map",
    "ds_type_priority",
    "ds_type_queue",
    "ds_type_stack",
    "ef_cloud",
    "ef_ellipse",
    "ef_explosion",
    "ef_firework",
    "ef_flare",
    "ef_rain",
    "ef_ring",
    "ef_smoke",
    "ef_smokeup",
    "ef_snow",
    "ef_spark",
    "ef_star",
    // for example ev_ are types of events
    "ev_alarm",
    "ev_animation_end",
    "ev_boundary",
    "ev_cleanup",
    "ev_close_button",
    "ev_collision",
    "ev_create",
    "ev_destroy",
    "ev_draw",
    "ev_draw_begin",
    "ev_draw_end",
    "ev_draw_post",
    "ev_draw_pre",
    "ev_end_of_path",
    "ev_game_end",
    "ev_game_start",
    "ev_gesture",
    "ev_gesture_double_tap",
    "ev_gesture_drag_end",
    "ev_gesture_drag_start",
    "ev_gesture_dragging",
    "ev_gesture_flick",
    "ev_gesture_pinch_end",
    "ev_gesture_pinch_in",
    "ev_gesture_pinch_out",
    "ev_gesture_pinch_start",
    "ev_gesture_rotate_end",
    "ev_gesture_rotate_start",
    "ev_gesture_rotating",
    "ev_gesture_tap",
    "ev_global_gesture_double_tap",
    "ev_global_gesture_drag_end",
    "ev_global_gesture_drag_start",
    "ev_global_gesture_dragging",
    "ev_global_gesture_flick",
    "ev_global_gesture_pinch_end",
    "ev_global_gesture_pinch_in",
    "ev_global_gesture_pinch_out",
    "ev_global_gesture_pinch_start",
    "ev_global_gesture_rotate_end",
    "ev_global_gesture_rotate_start",
    "ev_global_gesture_rotating",
    "ev_global_gesture_tap",
    "ev_global_left_button",
    "ev_global_left_press",
    "ev_global_left_release",
    "ev_global_middle_button",
    "ev_global_middle_press",
    "ev_global_middle_release",
    "ev_global_right_button",
    "ev_global_right_press",
    "ev_global_right_release",
    "ev_gui",
    "ev_gui_begin",
    "ev_gui_end",
    "ev_joystick1_button1",
    "ev_joystick1_button2",
    "ev_joystick1_button3",
    "ev_joystick1_button4",
    "ev_joystick1_button5",
    "ev_joystick1_button6",
    "ev_joystick1_button7",
    "ev_joystick1_button8",
    "ev_joystick1_down",
    "ev_joystick1_left",
    "ev_joystick1_right",
    "ev_joystick1_up",
    "ev_joystick2_button1",
    "ev_joystick2_button2",
    "ev_joystick2_button3",
    "ev_joystick2_button4",
    "ev_joystick2_button5",
    "ev_joystick2_button6",
    "ev_joystick2_button7",
    "ev_joystick2_button8",
    "ev_joystick2_down",
    "ev_joystick2_left",
    "ev_joystick2_right",
    "ev_joystick2_up",
    "ev_keyboard",
    "ev_keypress",
    "ev_keyrelease",
    "ev_left_button",
    "ev_left_press",
    "ev_left_release",
    "ev_middle_button",
    "ev_middle_press",
    "ev_middle_release",
    "ev_mouse",
    "ev_mouse_enter",
    "ev_mouse_leave",
    "ev_mouse_wheel_down",
    "ev_mouse_wheel_up",
    "ev_no_button",
    "ev_no_more_health",
    "ev_no_more_lives",
    "ev_other",
    "ev_outside",
    "ev_right_button",
    "ev_right_press",
    "ev_right_release",
    "ev_room_end",
    "ev_room_start",
    "ev_step",
    "ev_step_begin",
    "ev_step_end",
    "ev_step_normal",
    "ev_trigger",
    "ev_user0",
    "ev_user1",
    "ev_user2",
    "ev_user3",
    "ev_user4",
    "ev_user5",
    "ev_user6",
    "ev_user7",
    "ev_user8",
    "ev_user9",
    "ev_user10",
    "ev_user11",
    "ev_user12",
    "ev_user13",
    "ev_user14",
    "ev_user15",
    "fa_archive",
    "fa_bottom",
    "fa_center",
    "fa_directory",
    "fa_hidden",
    "fa_left",
    "fa_middle",
    "fa_readonly",
    "fa_right",
    "fa_sysfile",
    "fa_top",
    "fa_volumeid",
    "fb_login_default",
    "fb_login_fallback_to_webview",
    "fb_login_forcing_safari",
    "fb_login_forcing_webview",
    "fb_login_no_fallback_to_webview",
    "fb_login_use_system_account",
    "gamespeed_fps",
    "gamespeed_microseconds",
    "ge_lose",
    "global",
    "gp_axislh",
    "gp_axislv",
    "gp_axisrh",
    "gp_axisrv",
    "gp_face1",
    "gp_face2",
    "gp_face3",
    "gp_face4",
    "gp_padd",
    "gp_padl",
    "gp_padr",
    "gp_padu",
    "gp_select",
    "gp_shoulderl",
    "gp_shoulderlb",
    "gp_shoulderr",
    "gp_shoulderrb",
    "gp_start",
    "gp_stickl",
    "gp_stickr",
    "iap_available",
    "iap_canceled",
    "iap_ev_consume",
    "iap_ev_product",
    "iap_ev_purchase",
    "iap_ev_restore",
    "iap_ev_storeload",
    "iap_failed",
    "iap_purchased",
    "iap_refunded",
    "iap_status_available",
    "iap_status_loading",
    "iap_status_processing",
    "iap_status_restoring",
    "iap_status_unavailable",
    "iap_status_uninitialised",
    "iap_storeload_failed",
    "iap_storeload_ok",
    "iap_unavailable",
    "input_type",
    "kbv_autocapitalize_characters",
    "kbv_autocapitalize_none",
    "kbv_autocapitalize_sentences",
    "kbv_autocapitalize_words",
    "kbv_returnkey_continue",
    "kbv_returnkey_default",
    "kbv_returnkey_done",
    "kbv_returnkey_emergency",
    "kbv_returnkey_go",
    "kbv_returnkey_google",
    "kbv_returnkey_join",
    "kbv_returnkey_next",
    "kbv_returnkey_route",
    "kbv_returnkey_search",
    "kbv_returnkey_send",
    "kbv_returnkey_yahoo",
    "kbv_type_ascii",
    "kbv_type_default",
    "kbv_type_email",
    "kbv_type_numbers",
    "kbv_type_phone",
    "kbv_type_phone_name",
    "kbv_type_url",
    "layerelementtype_background",
    "layerelementtype_instance",
    "layerelementtype_oldtilemap",
    "layerelementtype_particlesystem",
    "layerelementtype_sprite",
    "layerelementtype_tile",
    "layerelementtype_tilemap",
    "layerelementtype_undefined",
    "lb_disp_none",
    "lb_disp_numeric",
    "lb_disp_time_ms",
    "lb_disp_time_sec",
    "lb_sort_ascending",
    "lb_sort_descending",
    "lb_sort_none",
    "leaderboard_type_number",
    "leaderboard_type_time_mins_secs",
    "lighttype_dir",
    "lighttype_point",
    "local",
    "matrix_projection",
    "matrix_view",
    "matrix_world",
    "mb_any",
    "mb_left",
    "mb_middle",
    "mb_none",
    "mb_right",
    "mip_markedonly",
    "mip_off",
    "mip_on",
    "network_config_connect_timeout",
    "network_config_disable_reliable_udp",
    "network_config_enable_reliable_udp",
    "network_config_use_non_blocking_socket",
    "network_socket_bluetooth",
    "network_socket_tcp",
    "network_socket_udp",
    "network_type_connect",
    "network_type_data",
    "network_type_disconnect",
    "network_type_non_blocking_connect",
    "of_challen",
    "of_challenge_tie",
    "of_challenge_win",
    "os_3ds",
    "os_android",
    "os_bb10",
    "os_ios",
    "os_linux",
    "os_macosx",
    "os_ps3",
    "os_ps4",
    "os_psvita",
    "os_switch",
    "os_symbian",
    "os_tizen",
    "os_tvos",
    "os_unknown",
    "os_uwp",
    "os_wiiu",
    "os_win32",
    "os_win8native",
    "os_windows",
    "os_winphone",
    "os_xbox360",
    "os_xboxone",
    "other",
    "ov_achievements",
    "ov_community",
    "ov_friends",
    "ov_gamegroup",
    "ov_players",
    "ov_settings",
    "path_action_continue",
    "path_action_restart",
    "path_action_reverse",
    "path_action_stop",
    "phy_debug_render_aabb",
    "phy_debug_render_collision_pairs",
    "phy_debug_render_coms",
    "phy_debug_render_core_shapes",
    "phy_debug_render_joints",
    "phy_debug_render_obb",
    "phy_debug_render_shapes",
    "phy_joint_anchor_1_x",
    "phy_joint_anchor_1_y",
    "phy_joint_anchor_2_x",
    "phy_joint_anchor_2_y",
    "phy_joint_angle",
    "phy_joint_angle_limits",
    "phy_joint_damping_ratio",
    "phy_joint_frequency",
    "phy_joint_length_1",
    "phy_joint_length_2",
    "phy_joint_lower_angle_limit",
    "phy_joint_max_force",
    "phy_joint_max_length",
    "phy_joint_max_motor_force",
    "phy_joint_max_motor_torque",
    "phy_joint_max_torque",
    "phy_joint_motor_force",
    "phy_joint_motor_speed",
    "phy_joint_motor_torque",
    "phy_joint_reaction_force_x",
    "phy_joint_reaction_force_y",
    "phy_joint_reaction_torque",
    "phy_joint_speed",
    "phy_joint_translation",
    "phy_joint_upper_angle_limit",
    "phy_particle_data_flag_category",
    "phy_particle_data_flag_color",
    "phy_particle_data_flag_colour",
    "phy_particle_data_flag_position",
    "phy_particle_data_flag_typeflags",
    "phy_particle_data_flag_velocity",
    "phy_particle_flag_colormixing",
    "phy_particle_flag_colourmixing",
    "phy_particle_flag_elastic",
    "phy_particle_flag_powder",
    "phy_particle_flag_spring",
    "phy_particle_flag_tensile",
    "phy_particle_flag_viscous",
    "phy_particle_flag_wall",
    "phy_particle_flag_water",
    "phy_particle_flag_zombie",
    "phy_particle_group_flag_rigid",
    "phy_particle_group_flag_solid",
    "pi",
    "pr_linelist",
    "pr_linestrip",
    "pr_pointlist",
    "pr_trianglefan",
    "pr_trianglelist",
    "pr_trianglestrip",
    "ps_distr_gaussian",
    "ps_distr_invgaussian",
    "ps_distr_linear",
    "ps_shape_diamond",
    "ps_shape_ellipse",
    "ps_shape_line",
    "ps_shape_rectangle",
    "pt_shape_circle",
    "pt_shape_cloud",
    "pt_shape_disk",
    "pt_shape_explosion",
    "pt_shape_flare",
    "pt_shape_line",
    "pt_shape_pixel",
    "pt_shape_ring",
    "pt_shape_smoke",
    "pt_shape_snow",
    "pt_shape_spark",
    "pt_shape_sphere",
    "pt_shape_square",
    "pt_shape_star",
    "spritespeed_framespergameframe",
    "spritespeed_framespersecond",
    "text_type",
    "tf_anisotropic",
    "tf_linear",
    "tf_point",
    "tile_flip",
    "tile_index_mask",
    "tile_mirror",
    "tile_rotate",
    "timezone_local",
    "timezone_utc",
    "tm_countvsyncs",
    "tm_sleep",
    "ty_real",
    "ty_string",
    "ugc_filetype_community",
    "ugc_filetype_microtrans",
    "ugc_list_Favorited",
    "ugc_list_Followed",
    "ugc_list_Published",
    "ugc_list_Subscribed",
    "ugc_list_UsedOrPlayed",
    "ugc_list_VotedDown",
    "ugc_list_VotedOn",
    "ugc_list_VotedUp",
    "ugc_list_WillVoteLater",
    "ugc_match_AllGuides",
    "ugc_match_Artwork",
    "ugc_match_Collections",
    "ugc_match_ControllerBindings",
    "ugc_match_IntegratedGuides",
    "ugc_match_Items",
    "ugc_match_Items_Mtx",
    "ugc_match_Items_ReadyToUse",
    "ugc_match_Screenshots",
    "ugc_match_UsableInGame",
    "ugc_match_Videos",
    "ugc_match_WebGuides",
    "ugc_query_AcceptedForGameRankedByAcceptanceDate",
    "ugc_query_CreatedByFollowedUsersRankedByPublicationDate",
    "ugc_query_CreatedByFriendsRankedByPublicationDate",
    "ugc_query_FavoritedByFriendsRankedByPublicationDate",
    "ugc_query_NotYetRated",
    "ugc_query_RankedByNumTimesReported",
    "ugc_query_RankedByPublicationDate",
    "ugc_query_RankedByTextSearch",
    "ugc_query_RankedByTotalVotesAsc",
    "ugc_query_RankedByTrend",
    "ugc_query_RankedByVote",
    "ugc_query_RankedByVotesUp",
    "ugc_result_success",
    "ugc_sortorder_CreationOrderAsc",
    "ugc_sortorder_CreationOrderDesc",
    "ugc_sortorder_ForModeration",
    "ugc_sortorder_LastUpdatedDesc",
    "ugc_sortorder_SubscriptionDateDesc",
    "ugc_sortorder_TitleAsc",
    "ugc_sortorder_VoteScoreDesc",
    "ugc_visibility_friends_only",
    "ugc_visibility_private",
    "ugc_visibility_public",
    "vertex_type_color",
    "vertex_type_colour",
    "vertex_type_float1",
    "vertex_type_float2",
    "vertex_type_float3",
    "vertex_type_float4",
    "vertex_type_ubyte4",
    "vertex_usage_binormal",
    "vertex_usage_blendindices",
    "vertex_usage_blendweight",
    "vertex_usage_color",
    "vertex_usage_colour",
    "vertex_usage_depth",
    "vertex_usage_fog",
    "vertex_usage_normal",
    "vertex_usage_position",
    "vertex_usage_psize",
    "vertex_usage_sample",
    "vertex_usage_tangent",
    "vertex_usage_texcoord",
    "vertex_usage_textcoord",
    "vk_add",
    "vk_alt",
    "vk_anykey",
    "vk_backspace",
    "vk_control",
    "vk_decimal",
    "vk_delete",
    "vk_divide",
    "vk_down",
    "vk_end",
    "vk_enter",
    "vk_escape",
    "vk_f1",
    "vk_f2",
    "vk_f3",
    "vk_f4",
    "vk_f5",
    "vk_f6",
    "vk_f7",
    "vk_f8",
    "vk_f9",
    "vk_f10",
    "vk_f11",
    "vk_f12",
    "vk_home",
    "vk_insert",
    "vk_lalt",
    "vk_lcontrol",
    "vk_left",
    "vk_lshift",
    "vk_multiply",
    "vk_nokey",
    "vk_numpad0",
    "vk_numpad1",
    "vk_numpad2",
    "vk_numpad3",
    "vk_numpad4",
    "vk_numpad5",
    "vk_numpad6",
    "vk_numpad7",
    "vk_numpad8",
    "vk_numpad9",
    "vk_pagedown",
    "vk_pageup",
    "vk_pause",
    "vk_printscreen",
    "vk_ralt",
    "vk_rcontrol",
    "vk_return",
    "vk_right",
    "vk_rshift",
    "vk_shift",
    "vk_space",
    "vk_subtract",
    "vk_tab",
    "vk_up"
  ];
  const LANGUAGE_VARIABLES = [
    "alarm",
    "application_surface",
    "argument",
    "argument0",
    "argument1",
    "argument2",
    "argument3",
    "argument4",
    "argument5",
    "argument6",
    "argument7",
    "argument8",
    "argument9",
    "argument10",
    "argument11",
    "argument12",
    "argument13",
    "argument14",
    "argument15",
    "argument_count",
    "argument_relative",
    "async_load",
    "background_color",
    "background_colour",
    "background_showcolor",
    "background_showcolour",
    "bbox_bottom",
    "bbox_left",
    "bbox_right",
    "bbox_top",
    "browser_height",
    "browser_width",
    "caption_health",
    "caption_lives",
    "caption_score",
    "current_day",
    "current_hour",
    "current_minute",
    "current_month",
    "current_second",
    "current_time",
    "current_weekday",
    "current_year",
    "cursor_sprite",
    "debug_mode",
    "delta_time",
    "depth",
    "direction",
    "display_aa",
    "error_last",
    "error_occurred",
    "event_action",
    "event_data",
    "event_number",
    "event_object",
    "event_type",
    "fps",
    "fps_real",
    "friction",
    "game_display_name",
    "game_id",
    "game_project_name",
    "game_save_id",
    "gamemaker_pro",
    "gamemaker_registered",
    "gamemaker_version",
    "gravity",
    "gravity_direction",
    "health",
    "hspeed",
    "iap_data",
    "id|0",
    "image_alpha",
    "image_angle",
    "image_blend",
    "image_index",
    "image_number",
    "image_speed",
    "image_xscale",
    "image_yscale",
    "instance_count",
    "instance_id",
    "keyboard_key",
    "keyboard_lastchar",
    "keyboard_lastkey",
    "keyboard_string",
    "layer",
    "lives",
    "mask_index",
    "mouse_button",
    "mouse_lastbutton",
    "mouse_x",
    "mouse_y",
    "object_index",
    "os_browser",
    "os_device",
    "os_type",
    "os_version",
    "path_endaction",
    "path_index",
    "path_orientation",
    "path_position",
    "path_positionprevious",
    "path_scale",
    "path_speed",
    "persistent",
    "phy_active",
    "phy_angular_damping",
    "phy_angular_velocity",
    "phy_bullet",
    "phy_col_normal_x",
    "phy_col_normal_y",
    "phy_collision_points",
    "phy_collision_x",
    "phy_collision_y",
    "phy_com_x",
    "phy_com_y",
    "phy_dynamic",
    "phy_fixed_rotation",
    "phy_inertia",
    "phy_kinematic",
    "phy_linear_damping",
    "phy_linear_velocity_x",
    "phy_linear_velocity_y",
    "phy_mass",
    "phy_position_x",
    "phy_position_xprevious",
    "phy_position_y",
    "phy_position_yprevious",
    "phy_rotation",
    "phy_sleeping",
    "phy_speed",
    "phy_speed_x",
    "phy_speed_y",
    "program_directory",
    "room",
    "room_caption",
    "room_first",
    "room_height",
    "room_last",
    "room_persistent",
    "room_speed",
    "room_width",
    "score",
    "self",
    "show_health",
    "show_lives",
    "show_score",
    "solid",
    "speed",
    "sprite_height",
    "sprite_index",
    "sprite_width",
    "sprite_xoffset",
    "sprite_yoffset",
    "temp_directory",
    "timeline_index",
    "timeline_loop",
    "timeline_position",
    "timeline_running",
    "timeline_speed",
    "view_angle",
    "view_camera",
    "view_current",
    "view_enabled",
    "view_hborder",
    "view_hport",
    "view_hspeed",
    "view_hview",
    "view_object",
    "view_surface_id",
    "view_vborder",
    "view_visible",
    "view_vspeed",
    "view_wport",
    "view_wview",
    "view_xport",
    "view_xview",
    "view_yport",
    "view_yview",
    "visible",
    "vspeed",
    "webgl_enabled",
    "working_directory",
    "xprevious",
    "xstart",
    "x|0",
    "yprevious",
    "ystart",
    "y|0"
  ];

  return {
    name: 'GML',
    case_insensitive: false, // language is case-insensitive
    keywords: {
      keyword: KEYWORDS,
      built_in: BUILT_INS,
      literal: LITERALS,
      symbol: SYMBOLS,
      "variable.language": LANGUAGE_VARIABLES
    },
    contains: [
      hljs.C_LINE_COMMENT_MODE,
      hljs.C_BLOCK_COMMENT_MODE,
      hljs.APOS_STRING_MODE,
      hljs.QUOTE_STRING_MODE,
      hljs.C_NUMBER_MODE
    ]
  };
}

module.exports = gml;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/go.js":
/*!*******************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/go.js ***!
  \*******************************************************/
/***/ (function(module) {

/*
Language: Go
Author: Stephan Kountso aka StepLg <steplg@gmail.com>
Contributors: Evgeny Stepanischev <imbolk@gmail.com>
Description: Google go language (golang). For info about language
Website: http://golang.org/
Category: common, system
*/

function go(hljs) {
  const LITERALS = [
    "true",
    "false",
    "iota",
    "nil"
  ];
  const BUILT_INS = [
    "append",
    "cap",
    "close",
    "complex",
    "copy",
    "imag",
    "len",
    "make",
    "new",
    "panic",
    "print",
    "println",
    "real",
    "recover",
    "delete"
  ];
  const TYPES = [
    "bool",
    "byte",
    "complex64",
    "complex128",
    "error",
    "float32",
    "float64",
    "int8",
    "int16",
    "int32",
    "int64",
    "string",
    "uint8",
    "uint16",
    "uint32",
    "uint64",
    "int",
    "uint",
    "uintptr",
    "rune"
  ];
  const KWS = [
    "break",
    "case",
    "chan",
    "const",
    "continue",
    "default",
    "defer",
    "else",
    "fallthrough",
    "for",
    "func",
    "go",
    "goto",
    "if",
    "import",
    "interface",
    "map",
    "package",
    "range",
    "return",
    "select",
    "struct",
    "switch",
    "type",
    "var",
  ];
  const KEYWORDS = {
    keyword: KWS,
    type: TYPES,
    literal: LITERALS,
    built_in: BUILT_INS
  };
  return {
    name: 'Go',
    aliases: [ 'golang' ],
    keywords: KEYWORDS,
    illegal: '</',
    contains: [
      hljs.C_LINE_COMMENT_MODE,
      hljs.C_BLOCK_COMMENT_MODE,
      {
        className: 'string',
        variants: [
          hljs.QUOTE_STRING_MODE,
          hljs.APOS_STRING_MODE,
          {
            begin: '`',
            end: '`'
          }
        ]
      },
      {
        className: 'number',
        variants: [
          {
            begin: hljs.C_NUMBER_RE + '[i]',
            relevance: 1
          },
          hljs.C_NUMBER_MODE
        ]
      },
      { begin: /:=/ // relevance booster
      },
      {
        className: 'function',
        beginKeywords: 'func',
        end: '\\s*(\\{|$)',
        excludeEnd: true,
        contains: [
          hljs.TITLE_MODE,
          {
            className: 'params',
            begin: /\(/,
            end: /\)/,
            endsParent: true,
            keywords: KEYWORDS,
            illegal: /["']/
          }
        ]
      }
    ]
  };
}

module.exports = go;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/golo.js":
/*!*********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/golo.js ***!
  \*********************************************************/
/***/ (function(module) {

/*
Language: Golo
Author: Philippe Charriere <ph.charriere@gmail.com>
Description: a lightweight dynamic language for the JVM
Website: http://golo-lang.org/
*/

function golo(hljs) {
  const KEYWORDS = [
    "println",
    "readln",
    "print",
    "import",
    "module",
    "function",
    "local",
    "return",
    "let",
    "var",
    "while",
    "for",
    "foreach",
    "times",
    "in",
    "case",
    "when",
    "match",
    "with",
    "break",
    "continue",
    "augment",
    "augmentation",
    "each",
    "find",
    "filter",
    "reduce",
    "if",
    "then",
    "else",
    "otherwise",
    "try",
    "catch",
    "finally",
    "raise",
    "throw",
    "orIfNull",
    "DynamicObject|10",
    "DynamicVariable",
    "struct",
    "Observable",
    "map",
    "set",
    "vector",
    "list",
    "array"
  ];

  return {
    name: 'Golo',
    keywords: {
      keyword: KEYWORDS,
      literal: [
        "true",
        "false",
        "null"
      ]
    },
    contains: [
      hljs.HASH_COMMENT_MODE,
      hljs.QUOTE_STRING_MODE,
      hljs.C_NUMBER_MODE,
      {
        className: 'meta',
        begin: '@[A-Za-z]+'
      }
    ]
  };
}

module.exports = golo;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/gradle.js":
/*!***********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/gradle.js ***!
  \***********************************************************/
/***/ (function(module) {

/*
Language: Gradle
Description: Gradle is an open-source build automation tool focused on flexibility and performance.
Website: https://gradle.org
Author: Damian Mee <mee.damian@gmail.com>
*/

function gradle(hljs) {
  const KEYWORDS = [
    "task",
    "project",
    "allprojects",
    "subprojects",
    "artifacts",
    "buildscript",
    "configurations",
    "dependencies",
    "repositories",
    "sourceSets",
    "description",
    "delete",
    "from",
    "into",
    "include",
    "exclude",
    "source",
    "classpath",
    "destinationDir",
    "includes",
    "options",
    "sourceCompatibility",
    "targetCompatibility",
    "group",
    "flatDir",
    "doLast",
    "doFirst",
    "flatten",
    "todir",
    "fromdir",
    "ant",
    "def",
    "abstract",
    "break",
    "case",
    "catch",
    "continue",
    "default",
    "do",
    "else",
    "extends",
    "final",
    "finally",
    "for",
    "if",
    "implements",
    "instanceof",
    "native",
    "new",
    "private",
    "protected",
    "public",
    "return",
    "static",
    "switch",
    "synchronized",
    "throw",
    "throws",
    "transient",
    "try",
    "volatile",
    "while",
    "strictfp",
    "package",
    "import",
    "false",
    "null",
    "super",
    "this",
    "true",
    "antlrtask",
    "checkstyle",
    "codenarc",
    "copy",
    "boolean",
    "byte",
    "char",
    "class",
    "double",
    "float",
    "int",
    "interface",
    "long",
    "short",
    "void",
    "compile",
    "runTime",
    "file",
    "fileTree",
    "abs",
    "any",
    "append",
    "asList",
    "asWritable",
    "call",
    "collect",
    "compareTo",
    "count",
    "div",
    "dump",
    "each",
    "eachByte",
    "eachFile",
    "eachLine",
    "every",
    "find",
    "findAll",
    "flatten",
    "getAt",
    "getErr",
    "getIn",
    "getOut",
    "getText",
    "grep",
    "immutable",
    "inject",
    "inspect",
    "intersect",
    "invokeMethods",
    "isCase",
    "join",
    "leftShift",
    "minus",
    "multiply",
    "newInputStream",
    "newOutputStream",
    "newPrintWriter",
    "newReader",
    "newWriter",
    "next",
    "plus",
    "pop",
    "power",
    "previous",
    "print",
    "println",
    "push",
    "putAt",
    "read",
    "readBytes",
    "readLines",
    "reverse",
    "reverseEach",
    "round",
    "size",
    "sort",
    "splitEachLine",
    "step",
    "subMap",
    "times",
    "toInteger",
    "toList",
    "tokenize",
    "upto",
    "waitForOrKill",
    "withPrintWriter",
    "withReader",
    "withStream",
    "withWriter",
    "withWriterAppend",
    "write",
    "writeLine"
  ];
  return {
    name: 'Gradle',
    case_insensitive: true,
    keywords: KEYWORDS,
    contains: [
      hljs.C_LINE_COMMENT_MODE,
      hljs.C_BLOCK_COMMENT_MODE,
      hljs.APOS_STRING_MODE,
      hljs.QUOTE_STRING_MODE,
      hljs.NUMBER_MODE,
      hljs.REGEXP_MODE

    ]
  };
}

module.exports = gradle;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/graphql.js":
/*!************************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/graphql.js ***!
  \************************************************************/
/***/ (function(module) {

/*
 Language: GraphQL
 Author: John Foster (GH jf990), and others
 Description: GraphQL is a query language for APIs
 Category: web, common
*/

/** @type LanguageFn */
function graphql(hljs) {
  const regex = hljs.regex;
  const GQL_NAME = /[_A-Za-z][_0-9A-Za-z]*/;
  return {
    name: "GraphQL",
    aliases: [ "gql" ],
    case_insensitive: true,
    disableAutodetect: false,
    keywords: {
      keyword: [
        "query",
        "mutation",
        "subscription",
        "type",
        "input",
        "schema",
        "directive",
        "interface",
        "union",
        "scalar",
        "fragment",
        "enum",
        "on"
      ],
      literal: [
        "true",
        "false",
        "null"
      ]
    },
    contains: [
      hljs.HASH_COMMENT_MODE,
      hljs.QUOTE_STRING_MODE,
      hljs.NUMBER_MODE,
      {
        scope: "punctuation",
        match: /[.]{3}/,
        relevance: 0
      },
      {
        scope: "punctuation",
        begin: /[\!\(\)\:\=\[\]\{\|\}]{1}/,
        relevance: 0
      },
      {
        scope: "variable",
        begin: /\$/,
        end: /\W/,
        excludeEnd: true,
        relevance: 0
      },
      {
        scope: "meta",
        match: /@\w+/,
        excludeEnd: true
      },
      {
        scope: "symbol",
        begin: regex.concat(GQL_NAME, regex.lookahead(/\s*:/)),
        relevance: 0
      }
    ],
    illegal: [
      /[;<']/,
      /BEGIN/
    ]
  };
}

module.exports = graphql;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/groovy.js":
/*!***********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/groovy.js ***!
  \***********************************************************/
/***/ (function(module) {

/*
 Language: Groovy
 Author: Guillaume Laforge <glaforge@gmail.com>
 Description: Groovy programming language implementation inspired from Vsevolod's Java mode
 Website: https://groovy-lang.org
 */

function variants(variants, obj = {}) {
  obj.variants = variants;
  return obj;
}

function groovy(hljs) {
  const regex = hljs.regex;
  const IDENT_RE = '[A-Za-z0-9_$]+';
  const COMMENT = variants([
    hljs.C_LINE_COMMENT_MODE,
    hljs.C_BLOCK_COMMENT_MODE,
    hljs.COMMENT(
      '/\\*\\*',
      '\\*/',
      {
        relevance: 0,
        contains: [
          {
            // eat up @'s in emails to prevent them to be recognized as doctags
            begin: /\w+@/,
            relevance: 0
          },
          {
            className: 'doctag',
            begin: '@[A-Za-z]+'
          }
        ]
      }
    )
  ]);
  const REGEXP = {
    className: 'regexp',
    begin: /~?\/[^\/\n]+\//,
    contains: [ hljs.BACKSLASH_ESCAPE ]
  };
  const NUMBER = variants([
    hljs.BINARY_NUMBER_MODE,
    hljs.C_NUMBER_MODE
  ]);
  const STRING = variants([
    {
      begin: /"""/,
      end: /"""/
    },
    {
      begin: /'''/,
      end: /'''/
    },
    {
      begin: "\\$/",
      end: "/\\$",
      relevance: 10
    },
    hljs.APOS_STRING_MODE,
    hljs.QUOTE_STRING_MODE
  ],
  { className: "string" }
  );

  const CLASS_DEFINITION = {
    match: [
      /(class|interface|trait|enum|extends|implements)/,
      /\s+/,
      hljs.UNDERSCORE_IDENT_RE
    ],
    scope: {
      1: "keyword",
      3: "title.class",
    }
  };
  const TYPES = [
    "byte",
    "short",
    "char",
    "int",
    "long",
    "boolean",
    "float",
    "double",
    "void"
  ];
  const KEYWORDS = [
    // groovy specific keywords
    "def",
    "as",
    "in",
    "assert",
    "trait",
    // common keywords with Java
    "abstract",
    "static",
    "volatile",
    "transient",
    "public",
    "private",
    "protected",
    "synchronized",
    "final",
    "class",
    "interface",
    "enum",
    "if",
    "else",
    "for",
    "while",
    "switch",
    "case",
    "break",
    "default",
    "continue",
    "throw",
    "throws",
    "try",
    "catch",
    "finally",
    "implements",
    "extends",
    "new",
    "import",
    "package",
    "return",
    "instanceof"
  ];

  return {
    name: 'Groovy',
    keywords: {
      "variable.language": 'this super',
      literal: 'true false null',
      type: TYPES,
      keyword: KEYWORDS
    },
    contains: [
      hljs.SHEBANG({
        binary: "groovy",
        relevance: 10
      }),
      COMMENT,
      STRING,
      REGEXP,
      NUMBER,
      CLASS_DEFINITION,
      {
        className: 'meta',
        begin: '@[A-Za-z]+',
        relevance: 0
      },
      {
        // highlight map keys and named parameters as attrs
        className: 'attr',
        begin: IDENT_RE + '[ \t]*:',
        relevance: 0
      },
      {
        // catch middle element of the ternary operator
        // to avoid highlight it as a label, named parameter, or map key
        begin: /\?/,
        end: /:/,
        relevance: 0,
        contains: [
          COMMENT,
          STRING,
          REGEXP,
          NUMBER,
          'self'
        ]
      },
      {
        // highlight labeled statements
        className: 'symbol',
        begin: '^[ \t]*' + regex.lookahead(IDENT_RE + ':'),
        excludeBegin: true,
        end: IDENT_RE + ':',
        relevance: 0
      }
    ],
    illegal: /#|<\//
  };
}

module.exports = groovy;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/haml.js":
/*!*********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/haml.js ***!
  \*********************************************************/
/***/ (function(module) {

/*
Language: HAML
Requires: ruby.js
Author: Dan Allen <dan.j.allen@gmail.com>
Website: http://haml.info
Category: template
*/

// TODO support filter tags like :javascript, support inline HTML
function haml(hljs) {
  return {
    name: 'HAML',
    case_insensitive: true,
    contains: [
      {
        className: 'meta',
        begin: '^!!!( (5|1\\.1|Strict|Frameset|Basic|Mobile|RDFa|XML\\b.*))?$',
        relevance: 10
      },
      // FIXME these comments should be allowed to span indented lines
      hljs.COMMENT(
        '^\\s*(!=#|=#|-#|/).*$',
        null,
        { relevance: 0 }
      ),
      {
        begin: '^\\s*(-|=|!=)(?!#)',
        end: /$/,
        subLanguage: 'ruby',
        excludeBegin: true,
        excludeEnd: true
      },
      {
        className: 'tag',
        begin: '^\\s*%',
        contains: [
          {
            className: 'selector-tag',
            begin: '\\w+'
          },
          {
            className: 'selector-id',
            begin: '#[\\w-]+'
          },
          {
            className: 'selector-class',
            begin: '\\.[\\w-]+'
          },
          {
            begin: /\{\s*/,
            end: /\s*\}/,
            contains: [
              {
                begin: ':\\w+\\s*=>',
                end: ',\\s+',
                returnBegin: true,
                endsWithParent: true,
                contains: [
                  {
                    className: 'attr',
                    begin: ':\\w+'
                  },
                  hljs.APOS_STRING_MODE,
                  hljs.QUOTE_STRING_MODE,
                  {
                    begin: '\\w+',
                    relevance: 0
                  }
                ]
              }
            ]
          },
          {
            begin: '\\(\\s*',
            end: '\\s*\\)',
            excludeEnd: true,
            contains: [
              {
                begin: '\\w+\\s*=',
                end: '\\s+',
                returnBegin: true,
                endsWithParent: true,
                contains: [
                  {
                    className: 'attr',
                    begin: '\\w+',
                    relevance: 0
                  },
                  hljs.APOS_STRING_MODE,
                  hljs.QUOTE_STRING_MODE,
                  {
                    begin: '\\w+',
                    relevance: 0
                  }
                ]
              }
            ]
          }
        ]
      },
      { begin: '^\\s*[=~]\\s*' },
      {
        begin: /#\{/,
        end: /\}/,
        subLanguage: 'ruby',
        excludeBegin: true,
        excludeEnd: true
      }
    ]
  };
}

module.exports = haml;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/handlebars.js":
/*!***************************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/handlebars.js ***!
  \***************************************************************/
/***/ (function(module) {

/*
Language: Handlebars
Requires: xml.js
Author: Robin Ward <robin.ward@gmail.com>
Description: Matcher for Handlebars as well as EmberJS additions.
Website: https://handlebarsjs.com
Category: template
*/

function handlebars(hljs) {
  const regex = hljs.regex;
  const BUILT_INS = {
    $pattern: /[\w.\/]+/,
    built_in: [
      'action',
      'bindattr',
      'collection',
      'component',
      'concat',
      'debugger',
      'each',
      'each-in',
      'get',
      'hash',
      'if',
      'in',
      'input',
      'link-to',
      'loc',
      'log',
      'lookup',
      'mut',
      'outlet',
      'partial',
      'query-params',
      'render',
      'template',
      'textarea',
      'unbound',
      'unless',
      'view',
      'with',
      'yield'
    ]
  };

  const LITERALS = {
    $pattern: /[\w.\/]+/,
    literal: [
      'true',
      'false',
      'undefined',
      'null'
    ]
  };

  // as defined in https://handlebarsjs.com/guide/expressions.html#literal-segments
  // this regex matches literal segments like ' abc ' or [ abc ] as well as helpers and paths
  // like a/b, ./abc/cde, and abc.bcd

  const DOUBLE_QUOTED_ID_REGEX = /""|"[^"]+"/;
  const SINGLE_QUOTED_ID_REGEX = /''|'[^']+'/;
  const BRACKET_QUOTED_ID_REGEX = /\[\]|\[[^\]]+\]/;
  const PLAIN_ID_REGEX = /[^\s!"#%&'()*+,.\/;<=>@\[\\\]^`{|}~]+/;
  const PATH_DELIMITER_REGEX = /(\.|\/)/;
  const ANY_ID = regex.either(
    DOUBLE_QUOTED_ID_REGEX,
    SINGLE_QUOTED_ID_REGEX,
    BRACKET_QUOTED_ID_REGEX,
    PLAIN_ID_REGEX
  );

  const IDENTIFIER_REGEX = regex.concat(
    regex.optional(/\.|\.\/|\//), // relative or absolute path
    ANY_ID,
    regex.anyNumberOfTimes(regex.concat(
      PATH_DELIMITER_REGEX,
      ANY_ID
    ))
  );

  // identifier followed by a equal-sign (without the equal sign)
  const HASH_PARAM_REGEX = regex.concat(
    '(',
    BRACKET_QUOTED_ID_REGEX, '|',
    PLAIN_ID_REGEX,
    ')(?==)'
  );

  const HELPER_NAME_OR_PATH_EXPRESSION = { begin: IDENTIFIER_REGEX };

  const HELPER_PARAMETER = hljs.inherit(HELPER_NAME_OR_PATH_EXPRESSION, { keywords: LITERALS });

  const SUB_EXPRESSION = {
    begin: /\(/,
    end: /\)/
    // the "contains" is added below when all necessary sub-modes are defined
  };

  const HASH = {
    // fka "attribute-assignment", parameters of the form 'key=value'
    className: 'attr',
    begin: HASH_PARAM_REGEX,
    relevance: 0,
    starts: {
      begin: /=/,
      end: /=/,
      starts: { contains: [
        hljs.NUMBER_MODE,
        hljs.QUOTE_STRING_MODE,
        hljs.APOS_STRING_MODE,
        HELPER_PARAMETER,
        SUB_EXPRESSION
      ] }
    }
  };

  const BLOCK_PARAMS = {
    // parameters of the form '{{#with x as | y |}}...{{/with}}'
    begin: /as\s+\|/,
    keywords: { keyword: 'as' },
    end: /\|/,
    contains: [
      {
        // define sub-mode in order to prevent highlighting of block-parameter named "as"
        begin: /\w+/ }
    ]
  };

  const HELPER_PARAMETERS = {
    contains: [
      hljs.NUMBER_MODE,
      hljs.QUOTE_STRING_MODE,
      hljs.APOS_STRING_MODE,
      BLOCK_PARAMS,
      HASH,
      HELPER_PARAMETER,
      SUB_EXPRESSION
    ],
    returnEnd: true
    // the property "end" is defined through inheritance when the mode is used. If depends
    // on the surrounding mode, but "endsWithParent" does not work here (i.e. it includes the
    // end-token of the surrounding mode)
  };

  const SUB_EXPRESSION_CONTENTS = hljs.inherit(HELPER_NAME_OR_PATH_EXPRESSION, {
    className: 'name',
    keywords: BUILT_INS,
    starts: hljs.inherit(HELPER_PARAMETERS, { end: /\)/ })
  });

  SUB_EXPRESSION.contains = [ SUB_EXPRESSION_CONTENTS ];

  const OPENING_BLOCK_MUSTACHE_CONTENTS = hljs.inherit(HELPER_NAME_OR_PATH_EXPRESSION, {
    keywords: BUILT_INS,
    className: 'name',
    starts: hljs.inherit(HELPER_PARAMETERS, { end: /\}\}/ })
  });

  const CLOSING_BLOCK_MUSTACHE_CONTENTS = hljs.inherit(HELPER_NAME_OR_PATH_EXPRESSION, {
    keywords: BUILT_INS,
    className: 'name'
  });

  const BASIC_MUSTACHE_CONTENTS = hljs.inherit(HELPER_NAME_OR_PATH_EXPRESSION, {
    className: 'name',
    keywords: BUILT_INS,
    starts: hljs.inherit(HELPER_PARAMETERS, { end: /\}\}/ })
  });

  const ESCAPE_MUSTACHE_WITH_PRECEEDING_BACKSLASH = {
    begin: /\\\{\{/,
    skip: true
  };
  const PREVENT_ESCAPE_WITH_ANOTHER_PRECEEDING_BACKSLASH = {
    begin: /\\\\(?=\{\{)/,
    skip: true
  };

  return {
    name: 'Handlebars',
    aliases: [
      'hbs',
      'html.hbs',
      'html.handlebars',
      'htmlbars'
    ],
    case_insensitive: true,
    subLanguage: 'xml',
    contains: [
      ESCAPE_MUSTACHE_WITH_PRECEEDING_BACKSLASH,
      PREVENT_ESCAPE_WITH_ANOTHER_PRECEEDING_BACKSLASH,
      hljs.COMMENT(/\{\{!--/, /--\}\}/),
      hljs.COMMENT(/\{\{!/, /\}\}/),
      {
        // open raw block "{{{{raw}}}} content not evaluated {{{{/raw}}}}"
        className: 'template-tag',
        begin: /\{\{\{\{(?!\/)/,
        end: /\}\}\}\}/,
        contains: [ OPENING_BLOCK_MUSTACHE_CONTENTS ],
        starts: {
          end: /\{\{\{\{\//,
          returnEnd: true,
          subLanguage: 'xml'
        }
      },
      {
        // close raw block
        className: 'template-tag',
        begin: /\{\{\{\{\//,
        end: /\}\}\}\}/,
        contains: [ CLOSING_BLOCK_MUSTACHE_CONTENTS ]
      },
      {
        // open block statement
        className: 'template-tag',
        begin: /\{\{#/,
        end: /\}\}/,
        contains: [ OPENING_BLOCK_MUSTACHE_CONTENTS ]
      },
      {
        className: 'template-tag',
        begin: /\{\{(?=else\}\})/,
        end: /\}\}/,
        keywords: 'else'
      },
      {
        className: 'template-tag',
        begin: /\{\{(?=else if)/,
        end: /\}\}/,
        keywords: 'else if'
      },
      {
        // closing block statement
        className: 'template-tag',
        begin: /\{\{\//,
        end: /\}\}/,
        contains: [ CLOSING_BLOCK_MUSTACHE_CONTENTS ]
      },
      {
        // template variable or helper-call that is NOT html-escaped
        className: 'template-variable',
        begin: /\{\{\{/,
        end: /\}\}\}/,
        contains: [ BASIC_MUSTACHE_CONTENTS ]
      },
      {
        // template variable or helper-call that is html-escaped
        className: 'template-variable',
        begin: /\{\{/,
        end: /\}\}/,
        contains: [ BASIC_MUSTACHE_CONTENTS ]
      }
    ]
  };
}

module.exports = handlebars;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/haskell.js":
/*!************************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/haskell.js ***!
  \************************************************************/
/***/ (function(module) {

/*
Language: Haskell
Author: Jeremy Hull <sourdrums@gmail.com>
Contributors: Zena Treep <zena.treep@gmail.com>
Website: https://www.haskell.org
Category: functional
*/

function haskell(hljs) {
  const COMMENT = { variants: [
    hljs.COMMENT('--', '$'),
    hljs.COMMENT(
      /\{-/,
      /-\}/,
      { contains: [ 'self' ] }
    )
  ] };

  const PRAGMA = {
    className: 'meta',
    begin: /\{-#/,
    end: /#-\}/
  };

  const PREPROCESSOR = {
    className: 'meta',
    begin: '^#',
    end: '$'
  };

  const CONSTRUCTOR = {
    className: 'type',
    begin: '\\b[A-Z][\\w\']*', // TODO: other constructors (build-in, infix).
    relevance: 0
  };

  const LIST = {
    begin: '\\(',
    end: '\\)',
    illegal: '"',
    contains: [
      PRAGMA,
      PREPROCESSOR,
      {
        className: 'type',
        begin: '\\b[A-Z][\\w]*(\\((\\.\\.|,|\\w+)\\))?'
      },
      hljs.inherit(hljs.TITLE_MODE, { begin: '[_a-z][\\w\']*' }),
      COMMENT
    ]
  };

  const RECORD = {
    begin: /\{/,
    end: /\}/,
    contains: LIST.contains
  };

  /* See:

     - https://www.haskell.org/onlinereport/lexemes.html
     - https://downloads.haskell.org/ghc/9.0.1/docs/html/users_guide/exts/binary_literals.html
     - https://downloads.haskell.org/ghc/9.0.1/docs/html/users_guide/exts/numeric_underscores.html
     - https://downloads.haskell.org/ghc/9.0.1/docs/html/users_guide/exts/hex_float_literals.html

  */
  const decimalDigits = '([0-9]_*)+';
  const hexDigits = '([0-9a-fA-F]_*)+';
  const binaryDigits = '([01]_*)+';
  const octalDigits = '([0-7]_*)+';

  const NUMBER = {
    className: 'number',
    relevance: 0,
    variants: [
      // decimal floating-point-literal (subsumes decimal-literal)
      { match: `\\b(${decimalDigits})(\\.(${decimalDigits}))?` + `([eE][+-]?(${decimalDigits}))?\\b` },
      // hexadecimal floating-point-literal (subsumes hexadecimal-literal)
      { match: `\\b0[xX]_*(${hexDigits})(\\.(${hexDigits}))?` + `([pP][+-]?(${decimalDigits}))?\\b` },
      // octal-literal
      { match: `\\b0[oO](${octalDigits})\\b` },
      // binary-literal
      { match: `\\b0[bB](${binaryDigits})\\b` }
    ]
  };

  return {
    name: 'Haskell',
    aliases: [ 'hs' ],
    keywords:
      'let in if then else case of where do module import hiding '
      + 'qualified type data newtype deriving class instance as default '
      + 'infix infixl infixr foreign export ccall stdcall cplusplus '
      + 'jvm dotnet safe unsafe family forall mdo proc rec',
    contains: [
      // Top-level constructions.
      {
        beginKeywords: 'module',
        end: 'where',
        keywords: 'module where',
        contains: [
          LIST,
          COMMENT
        ],
        illegal: '\\W\\.|;'
      },
      {
        begin: '\\bimport\\b',
        end: '$',
        keywords: 'import qualified as hiding',
        contains: [
          LIST,
          COMMENT
        ],
        illegal: '\\W\\.|;'
      },
      {
        className: 'class',
        begin: '^(\\s*)?(class|instance)\\b',
        end: 'where',
        keywords: 'class family instance where',
        contains: [
          CONSTRUCTOR,
          LIST,
          COMMENT
        ]
      },
      {
        className: 'class',
        begin: '\\b(data|(new)?type)\\b',
        end: '$',
        keywords: 'data family type newtype deriving',
        contains: [
          PRAGMA,
          CONSTRUCTOR,
          LIST,
          RECORD,
          COMMENT
        ]
      },
      {
        beginKeywords: 'default',
        end: '$',
        contains: [
          CONSTRUCTOR,
          LIST,
          COMMENT
        ]
      },
      {
        beginKeywords: 'infix infixl infixr',
        end: '$',
        contains: [
          hljs.C_NUMBER_MODE,
          COMMENT
        ]
      },
      {
        begin: '\\bforeign\\b',
        end: '$',
        keywords: 'foreign import export ccall stdcall cplusplus jvm '
                  + 'dotnet safe unsafe',
        contains: [
          CONSTRUCTOR,
          hljs.QUOTE_STRING_MODE,
          COMMENT
        ]
      },
      {
        className: 'meta',
        begin: '#!\\/usr\\/bin\\/env\ runhaskell',
        end: '$'
      },
      // "Whitespaces".
      PRAGMA,
      PREPROCESSOR,

      // Literals and names.

      // Single characters.
      {
        scope: 'string',
        begin: /'(?=\\?.')/,
        end: /'/,
        contains: [
          {
            scope: 'char.escape',
            match: /\\./,
          },
        ]
      },
      hljs.QUOTE_STRING_MODE,
      NUMBER,
      CONSTRUCTOR,
      hljs.inherit(hljs.TITLE_MODE, { begin: '^[_a-z][\\w\']*' }),
      COMMENT,
      { // No markup, relevance booster
        begin: '->|<-' }
    ]
  };
}

module.exports = haskell;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/haxe.js":
/*!*********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/haxe.js ***!
  \*********************************************************/
/***/ (function(module) {

/*
Language: Haxe
Description: Haxe is an open source toolkit based on a modern, high level, strictly typed programming language.
Author: Christopher Kaster <ikasoki@gmail.com> (Based on the actionscript.js language file by Alexander Myadzel)
Contributors: Kenton Hamaluik <kentonh@gmail.com>
Website: https://haxe.org
*/

function haxe(hljs) {

  const HAXE_BASIC_TYPES = 'Int Float String Bool Dynamic Void Array ';

  return {
    name: 'Haxe',
    aliases: [ 'hx' ],
    keywords: {
      keyword: 'break case cast catch continue default do dynamic else enum extern '
               + 'for function here if import in inline never new override package private get set '
               + 'public return static super switch this throw trace try typedef untyped using var while '
               + HAXE_BASIC_TYPES,
      built_in:
        'trace this',
      literal:
        'true false null _'
    },
    contains: [
      {
        className: 'string', // interpolate-able strings
        begin: '\'',
        end: '\'',
        contains: [
          hljs.BACKSLASH_ESCAPE,
          {
            className: 'subst', // interpolation
            begin: '\\$\\{',
            end: '\\}'
          },
          {
            className: 'subst', // interpolation
            begin: '\\$',
            end: /\W\}/
          }
        ]
      },
      hljs.QUOTE_STRING_MODE,
      hljs.C_LINE_COMMENT_MODE,
      hljs.C_BLOCK_COMMENT_MODE,
      hljs.C_NUMBER_MODE,
      {
        className: 'meta', // compiler meta
        begin: '@:',
        end: '$'
      },
      {
        className: 'meta', // compiler conditionals
        begin: '#',
        end: '$',
        keywords: { keyword: 'if else elseif end error' }
      },
      {
        className: 'type', // function types
        begin: ':[ \t]*',
        end: '[^A-Za-z0-9_ \t\\->]',
        excludeBegin: true,
        excludeEnd: true,
        relevance: 0
      },
      {
        className: 'type', // types
        begin: ':[ \t]*',
        end: '\\W',
        excludeBegin: true,
        excludeEnd: true
      },
      {
        className: 'type', // instantiation
        begin: 'new *',
        end: '\\W',
        excludeBegin: true,
        excludeEnd: true
      },
      {
        className: 'class', // enums
        beginKeywords: 'enum',
        end: '\\{',
        contains: [ hljs.TITLE_MODE ]
      },
      {
        className: 'class', // abstracts
        beginKeywords: 'abstract',
        end: '[\\{$]',
        contains: [
          {
            className: 'type',
            begin: '\\(',
            end: '\\)',
            excludeBegin: true,
            excludeEnd: true
          },
          {
            className: 'type',
            begin: 'from +',
            end: '\\W',
            excludeBegin: true,
            excludeEnd: true
          },
          {
            className: 'type',
            begin: 'to +',
            end: '\\W',
            excludeBegin: true,
            excludeEnd: true
          },
          hljs.TITLE_MODE
        ],
        keywords: { keyword: 'abstract from to' }
      },
      {
        className: 'class', // classes
        begin: '\\b(class|interface) +',
        end: '[\\{$]',
        excludeEnd: true,
        keywords: 'class interface',
        contains: [
          {
            className: 'keyword',
            begin: '\\b(extends|implements) +',
            keywords: 'extends implements',
            contains: [
              {
                className: 'type',
                begin: hljs.IDENT_RE,
                relevance: 0
              }
            ]
          },
          hljs.TITLE_MODE
        ]
      },
      {
        className: 'function',
        beginKeywords: 'function',
        end: '\\(',
        excludeEnd: true,
        illegal: '\\S',
        contains: [ hljs.TITLE_MODE ]
      }
    ],
    illegal: /<\//
  };
}

module.exports = haxe;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/hsp.js":
/*!********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/hsp.js ***!
  \********************************************************/
/***/ (function(module) {

/*
Language: HSP
Author: prince <MC.prince.0203@gmail.com>
Website: https://en.wikipedia.org/wiki/Hot_Soup_Processor
Category: scripting
*/

function hsp(hljs) {
  return {
    name: 'HSP',
    case_insensitive: true,
    keywords: {
      $pattern: /[\w._]+/,
      keyword: 'goto gosub return break repeat loop continue wait await dim sdim foreach dimtype dup dupptr end stop newmod delmod mref run exgoto on mcall assert logmes newlab resume yield onexit onerror onkey onclick oncmd exist delete mkdir chdir dirlist bload bsave bcopy memfile if else poke wpoke lpoke getstr chdpm memexpand memcpy memset notesel noteadd notedel noteload notesave randomize noteunsel noteget split strrep setease button chgdisp exec dialog mmload mmplay mmstop mci pset pget syscolor mes print title pos circle cls font sysfont objsize picload color palcolor palette redraw width gsel gcopy gzoom gmode bmpsave hsvcolor getkey listbox chkbox combox input mesbox buffer screen bgscr mouse objsel groll line clrobj boxf objprm objmode stick grect grotate gsquare gradf objimage objskip objenable celload celdiv celput newcom querycom delcom cnvstow comres axobj winobj sendmsg comevent comevarg sarrayconv callfunc cnvwtos comevdisp libptr system hspstat hspver stat cnt err strsize looplev sublev iparam wparam lparam refstr refdval int rnd strlen length length2 length3 length4 vartype gettime peek wpeek lpeek varptr varuse noteinfo instr abs limit getease str strmid strf getpath strtrim sin cos tan atan sqrt double absf expf logf limitf powf geteasef mousex mousey mousew hwnd hinstance hdc ginfo objinfo dirinfo sysinfo thismod __hspver__ __hsp30__ __date__ __time__ __line__ __file__ _debug __hspdef__ and or xor not screen_normal screen_palette screen_hide screen_fixedsize screen_tool screen_frame gmode_gdi gmode_mem gmode_rgb0 gmode_alpha gmode_rgb0alpha gmode_add gmode_sub gmode_pixela ginfo_mx ginfo_my ginfo_act ginfo_sel ginfo_wx1 ginfo_wy1 ginfo_wx2 ginfo_wy2 ginfo_vx ginfo_vy ginfo_sizex ginfo_sizey ginfo_winx ginfo_winy ginfo_mesx ginfo_mesy ginfo_r ginfo_g ginfo_b ginfo_paluse ginfo_dispx ginfo_dispy ginfo_cx ginfo_cy ginfo_intid ginfo_newid ginfo_sx ginfo_sy objinfo_mode objinfo_bmscr objinfo_hwnd notemax notesize dir_cur dir_exe dir_win dir_sys dir_cmdline dir_desktop dir_mydoc dir_tv font_normal font_bold font_italic font_underline font_strikeout font_antialias objmode_normal objmode_guifont objmode_usefont gsquare_grad msgothic msmincho do until while wend for next _break _continue switch case default swbreak swend ddim ldim alloc m_pi rad2deg deg2rad ease_linear ease_quad_in ease_quad_out ease_quad_inout ease_cubic_in ease_cubic_out ease_cubic_inout ease_quartic_in ease_quartic_out ease_quartic_inout ease_bounce_in ease_bounce_out ease_bounce_inout ease_shake_in ease_shake_out ease_shake_inout ease_loop'
    },
    contains: [
      hljs.C_LINE_COMMENT_MODE,
      hljs.C_BLOCK_COMMENT_MODE,
      hljs.QUOTE_STRING_MODE,
      hljs.APOS_STRING_MODE,

      {
        // multi-line string
        className: 'string',
        begin: /\{"/,
        end: /"\}/,
        contains: [ hljs.BACKSLASH_ESCAPE ]
      },

      hljs.COMMENT(';', '$', { relevance: 0 }),

      {
        // pre-processor
        className: 'meta',
        begin: '#',
        end: '$',
        keywords: { keyword: 'addion cfunc cmd cmpopt comfunc const defcfunc deffunc define else endif enum epack func global if ifdef ifndef include modcfunc modfunc modinit modterm module pack packopt regcmd runtime undef usecom uselib' },
        contains: [
          hljs.inherit(hljs.QUOTE_STRING_MODE, { className: 'string' }),
          hljs.NUMBER_MODE,
          hljs.C_NUMBER_MODE,
          hljs.C_LINE_COMMENT_MODE,
          hljs.C_BLOCK_COMMENT_MODE
        ]
      },

      {
        // label
        className: 'symbol',
        begin: '^\\*(\\w+|@)'
      },

      hljs.NUMBER_MODE,
      hljs.C_NUMBER_MODE
    ]
  };
}

module.exports = hsp;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/http.js":
/*!*********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/http.js ***!
  \*********************************************************/
/***/ (function(module) {

/*
Language: HTTP
Description: HTTP request and response headers with automatic body highlighting
Author: Ivan Sagalaev <maniac@softwaremaniacs.org>
Category: protocols, web
Website: https://developer.mozilla.org/en-US/docs/Web/HTTP/Overview
*/

function http(hljs) {
  const regex = hljs.regex;
  const VERSION = 'HTTP/([32]|1\\.[01])';
  const HEADER_NAME = /[A-Za-z][A-Za-z0-9-]*/;
  const HEADER = {
    className: 'attribute',
    begin: regex.concat('^', HEADER_NAME, '(?=\\:\\s)'),
    starts: { contains: [
      {
        className: "punctuation",
        begin: /: /,
        relevance: 0,
        starts: {
          end: '$',
          relevance: 0
        }
      }
    ] }
  };
  const HEADERS_AND_BODY = [
    HEADER,
    {
      begin: '\\n\\n',
      starts: {
        subLanguage: [],
        endsWithParent: true
      }
    }
  ];

  return {
    name: 'HTTP',
    aliases: [ 'https' ],
    illegal: /\S/,
    contains: [
      // response
      {
        begin: '^(?=' + VERSION + " \\d{3})",
        end: /$/,
        contains: [
          {
            className: "meta",
            begin: VERSION
          },
          {
            className: 'number',
            begin: '\\b\\d{3}\\b'
          }
        ],
        starts: {
          end: /\b\B/,
          illegal: /\S/,
          contains: HEADERS_AND_BODY
        }
      },
      // request
      {
        begin: '(?=^[A-Z]+ (.*?) ' + VERSION + '$)',
        end: /$/,
        contains: [
          {
            className: 'string',
            begin: ' ',
            end: ' ',
            excludeBegin: true,
            excludeEnd: true
          },
          {
            className: "meta",
            begin: VERSION
          },
          {
            className: 'keyword',
            begin: '[A-Z]+'
          }
        ],
        starts: {
          end: /\b\B/,
          illegal: /\S/,
          contains: HEADERS_AND_BODY
        }
      },
      // to allow headers to work even without a preamble
      hljs.inherit(HEADER, { relevance: 0 })
    ]
  };
}

module.exports = http;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/hy.js":
/*!*******************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/hy.js ***!
  \*******************************************************/
/***/ (function(module) {

/*
Language: Hy
Description: Hy is a wonderful dialect of Lisp that’s embedded in Python.
Author: Sergey Sobko <s.sobko@profitware.ru>
Website: http://docs.hylang.org/en/stable/
Category: lisp
*/

function hy(hljs) {
  const SYMBOLSTART = 'a-zA-Z_\\-!.?+*=<>&#\'';
  const SYMBOL_RE = '[' + SYMBOLSTART + '][' + SYMBOLSTART + '0-9/;:]*';
  const keywords = {
    $pattern: SYMBOL_RE,
    built_in:
      // keywords
      '!= % %= & &= * ** **= *= *map '
      + '+ += , --build-class-- --import-- -= . / // //= '
      + '/= < << <<= <= = > >= >> >>= '
      + '@ @= ^ ^= abs accumulate all and any ap-compose '
      + 'ap-dotimes ap-each ap-each-while ap-filter ap-first ap-if ap-last ap-map ap-map-when ap-pipe '
      + 'ap-reduce ap-reject apply as-> ascii assert assoc bin break butlast '
      + 'callable calling-module-name car case cdr chain chr coll? combinations compile '
      + 'compress cond cons cons? continue count curry cut cycle dec '
      + 'def default-method defclass defmacro defmacro-alias defmacro/g! defmain defmethod defmulti defn '
      + 'defn-alias defnc defnr defreader defseq del delattr delete-route dict-comp dir '
      + 'disassemble dispatch-reader-macro distinct divmod do doto drop drop-last drop-while empty? '
      + 'end-sequence eval eval-and-compile eval-when-compile even? every? except exec filter first '
      + 'flatten float? fn fnc fnr for for* format fraction genexpr '
      + 'gensym get getattr global globals group-by hasattr hash hex id '
      + 'identity if if* if-not if-python2 import in inc input instance? '
      + 'integer integer-char? integer? interleave interpose is is-coll is-cons is-empty is-even '
      + 'is-every is-float is-instance is-integer is-integer-char is-iterable is-iterator is-keyword is-neg is-none '
      + 'is-not is-numeric is-odd is-pos is-string is-symbol is-zero isinstance islice issubclass '
      + 'iter iterable? iterate iterator? keyword keyword? lambda last len let '
      + 'lif lif-not list* list-comp locals loop macro-error macroexpand macroexpand-1 macroexpand-all '
      + 'map max merge-with method-decorator min multi-decorator multicombinations name neg? next '
      + 'none? nonlocal not not-in not? nth numeric? oct odd? open '
      + 'or ord partition permutations pos? post-route postwalk pow prewalk print '
      + 'product profile/calls profile/cpu put-route quasiquote quote raise range read read-str '
      + 'recursive-replace reduce remove repeat repeatedly repr require rest round route '
      + 'route-with-methods rwm second seq set-comp setattr setv some sorted string '
      + 'string? sum switch symbol? take take-nth take-while tee try unless '
      + 'unquote unquote-splicing vars walk when while with with* with-decorator with-gensyms '
      + 'xi xor yield yield-from zero? zip zip-longest | |= ~'
  };

  const SIMPLE_NUMBER_RE = '[-+]?\\d+(\\.\\d+)?';

  const SYMBOL = {
    begin: SYMBOL_RE,
    relevance: 0
  };
  const NUMBER = {
    className: 'number',
    begin: SIMPLE_NUMBER_RE,
    relevance: 0
  };
  const STRING = hljs.inherit(hljs.QUOTE_STRING_MODE, { illegal: null });
  const COMMENT = hljs.COMMENT(
    ';',
    '$',
    { relevance: 0 }
  );
  const LITERAL = {
    className: 'literal',
    begin: /\b([Tt]rue|[Ff]alse|nil|None)\b/
  };
  const COLLECTION = {
    begin: '[\\[\\{]',
    end: '[\\]\\}]',
    relevance: 0
  };
  const HINT = {
    className: 'comment',
    begin: '\\^' + SYMBOL_RE
  };
  const HINT_COL = hljs.COMMENT('\\^\\{', '\\}');
  const KEY = {
    className: 'symbol',
    begin: '[:]{1,2}' + SYMBOL_RE
  };
  const LIST = {
    begin: '\\(',
    end: '\\)'
  };
  const BODY = {
    endsWithParent: true,
    relevance: 0
  };
  const NAME = {
    className: 'name',
    relevance: 0,
    keywords: keywords,
    begin: SYMBOL_RE,
    starts: BODY
  };
  const DEFAULT_CONTAINS = [
    LIST,
    STRING,
    HINT,
    HINT_COL,
    COMMENT,
    KEY,
    COLLECTION,
    NUMBER,
    LITERAL,
    SYMBOL
  ];

  LIST.contains = [
    hljs.COMMENT('comment', ''),
    NAME,
    BODY
  ];
  BODY.contains = DEFAULT_CONTAINS;
  COLLECTION.contains = DEFAULT_CONTAINS;

  return {
    name: 'Hy',
    aliases: [ 'hylang' ],
    illegal: /\S/,
    contains: [
      hljs.SHEBANG(),
      LIST,
      STRING,
      HINT,
      HINT_COL,
      COMMENT,
      KEY,
      COLLECTION,
      NUMBER,
      LITERAL
    ]
  };
}

module.exports = hy;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/inform7.js":
/*!************************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/inform7.js ***!
  \************************************************************/
/***/ (function(module) {

/*
Language: Inform 7
Author: Bruno Dias <bruno.r.dias@gmail.com>
Description: Language definition for Inform 7, a DSL for writing parser interactive fiction.
Website: http://inform7.com
*/

function inform7(hljs) {
  const START_BRACKET = '\\[';
  const END_BRACKET = '\\]';
  return {
    name: 'Inform 7',
    aliases: [ 'i7' ],
    case_insensitive: true,
    keywords: {
      // Some keywords more or less unique to I7, for relevance.
      keyword:
        // kind:
        'thing room person man woman animal container '
        + 'supporter backdrop door '
        // characteristic:
        + 'scenery open closed locked inside gender '
        // verb:
        + 'is are say understand '
        // misc keyword:
        + 'kind of rule' },
    contains: [
      {
        className: 'string',
        begin: '"',
        end: '"',
        relevance: 0,
        contains: [
          {
            className: 'subst',
            begin: START_BRACKET,
            end: END_BRACKET
          }
        ]
      },
      {
        className: 'section',
        begin: /^(Volume|Book|Part|Chapter|Section|Table)\b/,
        end: '$'
      },
      {
        // Rule definition
        // This is here for relevance.
        begin: /^(Check|Carry out|Report|Instead of|To|Rule|When|Before|After)\b/,
        end: ':',
        contains: [
          {
            // Rule name
            begin: '\\(This',
            end: '\\)'
          }
        ]
      },
      {
        className: 'comment',
        begin: START_BRACKET,
        end: END_BRACKET,
        contains: [ 'self' ]
      }
    ]
  };
}

module.exports = inform7;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/ini.js":
/*!********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/ini.js ***!
  \********************************************************/
/***/ (function(module) {

/*
Language: TOML, also INI
Description: TOML aims to be a minimal configuration file format that's easy to read due to obvious semantics.
Contributors: Guillaume Gomez <guillaume1.gomez@gmail.com>
Category: common, config
Website: https://github.com/toml-lang/toml
*/

function ini(hljs) {
  const regex = hljs.regex;
  const NUMBERS = {
    className: 'number',
    relevance: 0,
    variants: [
      { begin: /([+-]+)?[\d]+_[\d_]+/ },
      { begin: hljs.NUMBER_RE }
    ]
  };
  const COMMENTS = hljs.COMMENT();
  COMMENTS.variants = [
    {
      begin: /;/,
      end: /$/
    },
    {
      begin: /#/,
      end: /$/
    }
  ];
  const VARIABLES = {
    className: 'variable',
    variants: [
      { begin: /\$[\w\d"][\w\d_]*/ },
      { begin: /\$\{(.*?)\}/ }
    ]
  };
  const LITERALS = {
    className: 'literal',
    begin: /\bon|off|true|false|yes|no\b/
  };
  const STRINGS = {
    className: "string",
    contains: [ hljs.BACKSLASH_ESCAPE ],
    variants: [
      {
        begin: "'''",
        end: "'''",
        relevance: 10
      },
      {
        begin: '"""',
        end: '"""',
        relevance: 10
      },
      {
        begin: '"',
        end: '"'
      },
      {
        begin: "'",
        end: "'"
      }
    ]
  };
  const ARRAY = {
    begin: /\[/,
    end: /\]/,
    contains: [
      COMMENTS,
      LITERALS,
      VARIABLES,
      STRINGS,
      NUMBERS,
      'self'
    ],
    relevance: 0
  };

  const BARE_KEY = /[A-Za-z0-9_-]+/;
  const QUOTED_KEY_DOUBLE_QUOTE = /"(\\"|[^"])*"/;
  const QUOTED_KEY_SINGLE_QUOTE = /'[^']*'/;
  const ANY_KEY = regex.either(
    BARE_KEY, QUOTED_KEY_DOUBLE_QUOTE, QUOTED_KEY_SINGLE_QUOTE
  );
  const DOTTED_KEY = regex.concat(
    ANY_KEY, '(\\s*\\.\\s*', ANY_KEY, ')*',
    regex.lookahead(/\s*=\s*[^#\s]/)
  );

  return {
    name: 'TOML, also INI',
    aliases: [ 'toml' ],
    case_insensitive: true,
    illegal: /\S/,
    contains: [
      COMMENTS,
      {
        className: 'section',
        begin: /\[+/,
        end: /\]+/
      },
      {
        begin: DOTTED_KEY,
        className: 'attr',
        starts: {
          end: /$/,
          contains: [
            COMMENTS,
            ARRAY,
            LITERALS,
            VARIABLES,
            STRINGS,
            NUMBERS
          ]
        }
      }
    ]
  };
}

module.exports = ini;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/irpf90.js":
/*!***********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/irpf90.js ***!
  \***********************************************************/
/***/ (function(module) {

/*
Language: IRPF90
Author: Anthony Scemama <scemama@irsamc.ups-tlse.fr>
Description: IRPF90 is an open-source Fortran code generator
Website: http://irpf90.ups-tlse.fr
Category: scientific
*/

/** @type LanguageFn */
function irpf90(hljs) {
  const regex = hljs.regex;
  const PARAMS = {
    className: 'params',
    begin: '\\(',
    end: '\\)'
  };

  // regex in both fortran and irpf90 should match
  const OPTIONAL_NUMBER_SUFFIX = /(_[a-z_\d]+)?/;
  const OPTIONAL_NUMBER_EXP = /([de][+-]?\d+)?/;
  const NUMBER = {
    className: 'number',
    variants: [
      { begin: regex.concat(/\b\d+/, /\.(\d*)/, OPTIONAL_NUMBER_EXP, OPTIONAL_NUMBER_SUFFIX) },
      { begin: regex.concat(/\b\d+/, OPTIONAL_NUMBER_EXP, OPTIONAL_NUMBER_SUFFIX) },
      { begin: regex.concat(/\.\d+/, OPTIONAL_NUMBER_EXP, OPTIONAL_NUMBER_SUFFIX) }
    ],
    relevance: 0
  };

  const F_KEYWORDS = {
    literal: '.False. .True.',
    keyword: 'kind do while private call intrinsic where elsewhere '
      + 'type endtype endmodule endselect endinterface end enddo endif if forall endforall only contains default return stop then '
      + 'public subroutine|10 function program .and. .or. .not. .le. .eq. .ge. .gt. .lt. '
      + 'goto save else use module select case '
      + 'access blank direct exist file fmt form formatted iostat name named nextrec number opened rec recl sequential status unformatted unit '
      + 'continue format pause cycle exit '
      + 'c_null_char c_alert c_backspace c_form_feed flush wait decimal round iomsg '
      + 'synchronous nopass non_overridable pass protected volatile abstract extends import '
      + 'non_intrinsic value deferred generic final enumerator class associate bind enum '
      + 'c_int c_short c_long c_long_long c_signed_char c_size_t c_int8_t c_int16_t c_int32_t c_int64_t c_int_least8_t c_int_least16_t '
      + 'c_int_least32_t c_int_least64_t c_int_fast8_t c_int_fast16_t c_int_fast32_t c_int_fast64_t c_intmax_t C_intptr_t c_float c_double '
      + 'c_long_double c_float_complex c_double_complex c_long_double_complex c_bool c_char c_null_ptr c_null_funptr '
      + 'c_new_line c_carriage_return c_horizontal_tab c_vertical_tab iso_c_binding c_loc c_funloc c_associated  c_f_pointer '
      + 'c_ptr c_funptr iso_fortran_env character_storage_size error_unit file_storage_size input_unit iostat_end iostat_eor '
      + 'numeric_storage_size output_unit c_f_procpointer ieee_arithmetic ieee_support_underflow_control '
      + 'ieee_get_underflow_mode ieee_set_underflow_mode newunit contiguous recursive '
      + 'pad position action delim readwrite eor advance nml interface procedure namelist include sequence elemental pure '
      + 'integer real character complex logical dimension allocatable|10 parameter '
      + 'external implicit|10 none double precision assign intent optional pointer '
      + 'target in out common equivalence data '
      // IRPF90 special keywords
      + 'begin_provider &begin_provider end_provider begin_shell end_shell begin_template end_template subst assert touch '
      + 'soft_touch provide no_dep free irp_if irp_else irp_endif irp_write irp_read',
    built_in: 'alog alog10 amax0 amax1 amin0 amin1 amod cabs ccos cexp clog csin csqrt dabs dacos dasin datan datan2 dcos dcosh ddim dexp dint '
      + 'dlog dlog10 dmax1 dmin1 dmod dnint dsign dsin dsinh dsqrt dtan dtanh float iabs idim idint idnint ifix isign max0 max1 min0 min1 sngl '
      + 'algama cdabs cdcos cdexp cdlog cdsin cdsqrt cqabs cqcos cqexp cqlog cqsin cqsqrt dcmplx dconjg derf derfc dfloat dgamma dimag dlgama '
      + 'iqint qabs qacos qasin qatan qatan2 qcmplx qconjg qcos qcosh qdim qerf qerfc qexp qgamma qimag qlgama qlog qlog10 qmax1 qmin1 qmod '
      + 'qnint qsign qsin qsinh qsqrt qtan qtanh abs acos aimag aint anint asin atan atan2 char cmplx conjg cos cosh exp ichar index int log '
      + 'log10 max min nint sign sin sinh sqrt tan tanh print write dim lge lgt lle llt mod nullify allocate deallocate '
      + 'adjustl adjustr all allocated any associated bit_size btest ceiling count cshift date_and_time digits dot_product '
      + 'eoshift epsilon exponent floor fraction huge iand ibclr ibits ibset ieor ior ishft ishftc lbound len_trim matmul '
      + 'maxexponent maxloc maxval merge minexponent minloc minval modulo mvbits nearest pack present product '
      + 'radix random_number random_seed range repeat reshape rrspacing scale scan selected_int_kind selected_real_kind '
      + 'set_exponent shape size spacing spread sum system_clock tiny transpose trim ubound unpack verify achar iachar transfer '
      + 'dble entry dprod cpu_time command_argument_count get_command get_command_argument get_environment_variable is_iostat_end '
      + 'ieee_arithmetic ieee_support_underflow_control ieee_get_underflow_mode ieee_set_underflow_mode '
      + 'is_iostat_eor move_alloc new_line selected_char_kind same_type_as extends_type_of '
      + 'acosh asinh atanh bessel_j0 bessel_j1 bessel_jn bessel_y0 bessel_y1 bessel_yn erf erfc erfc_scaled gamma log_gamma hypot norm2 '
      + 'atomic_define atomic_ref execute_command_line leadz trailz storage_size merge_bits '
      + 'bge bgt ble blt dshiftl dshiftr findloc iall iany iparity image_index lcobound ucobound maskl maskr '
      + 'num_images parity popcnt poppar shifta shiftl shiftr this_image '
      // IRPF90 special built_ins
      + 'IRP_ALIGN irp_here'
  };
  return {
    name: 'IRPF90',
    case_insensitive: true,
    keywords: F_KEYWORDS,
    illegal: /\/\*/,
    contains: [
      hljs.inherit(hljs.APOS_STRING_MODE, {
        className: 'string',
        relevance: 0
      }),
      hljs.inherit(hljs.QUOTE_STRING_MODE, {
        className: 'string',
        relevance: 0
      }),
      {
        className: 'function',
        beginKeywords: 'subroutine function program',
        illegal: '[${=\\n]',
        contains: [
          hljs.UNDERSCORE_TITLE_MODE,
          PARAMS
        ]
      },
      hljs.COMMENT('!', '$', { relevance: 0 }),
      hljs.COMMENT('begin_doc', 'end_doc', { relevance: 10 }),
      NUMBER
    ]
  };
}

module.exports = irpf90;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/isbl.js":
/*!*********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/isbl.js ***!
  \*********************************************************/
/***/ (function(module) {

/*
Language: ISBL
Author: Dmitriy Tarasov <dimatar@gmail.com>
Description: built-in language DIRECTUM
Category: enterprise
*/

function isbl(hljs) {
  // Определение идентификаторов
  const UNDERSCORE_IDENT_RE = "[A-Za-zА-Яа-яёЁ_!][A-Za-zА-Яа-яёЁ_0-9]*";

  // Определение имен функций
  const FUNCTION_NAME_IDENT_RE = "[A-Za-zА-Яа-яёЁ_][A-Za-zА-Яа-яёЁ_0-9]*";

  // keyword : ключевые слова
  const KEYWORD =
    "and и else иначе endexcept endfinally endforeach конецвсе endif конецесли endwhile конецпока "
    + "except exitfor finally foreach все if если in в not не or или try while пока ";

  // SYSRES Constants
  const sysres_constants =
    "SYSRES_CONST_ACCES_RIGHT_TYPE_EDIT "
    + "SYSRES_CONST_ACCES_RIGHT_TYPE_FULL "
    + "SYSRES_CONST_ACCES_RIGHT_TYPE_VIEW "
    + "SYSRES_CONST_ACCESS_MODE_REQUISITE_CODE "
    + "SYSRES_CONST_ACCESS_NO_ACCESS_VIEW "
    + "SYSRES_CONST_ACCESS_NO_ACCESS_VIEW_CODE "
    + "SYSRES_CONST_ACCESS_RIGHTS_ADD_REQUISITE_CODE "
    + "SYSRES_CONST_ACCESS_RIGHTS_ADD_REQUISITE_YES_CODE "
    + "SYSRES_CONST_ACCESS_RIGHTS_CHANGE_REQUISITE_CODE "
    + "SYSRES_CONST_ACCESS_RIGHTS_CHANGE_REQUISITE_YES_CODE "
    + "SYSRES_CONST_ACCESS_RIGHTS_DELETE_REQUISITE_CODE "
    + "SYSRES_CONST_ACCESS_RIGHTS_DELETE_REQUISITE_YES_CODE "
    + "SYSRES_CONST_ACCESS_RIGHTS_EXECUTE_REQUISITE_CODE "
    + "SYSRES_CONST_ACCESS_RIGHTS_EXECUTE_REQUISITE_YES_CODE "
    + "SYSRES_CONST_ACCESS_RIGHTS_NO_ACCESS_REQUISITE_CODE "
    + "SYSRES_CONST_ACCESS_RIGHTS_NO_ACCESS_REQUISITE_YES_CODE "
    + "SYSRES_CONST_ACCESS_RIGHTS_RATIFY_REQUISITE_CODE "
    + "SYSRES_CONST_ACCESS_RIGHTS_RATIFY_REQUISITE_YES_CODE "
    + "SYSRES_CONST_ACCESS_RIGHTS_REQUISITE_CODE "
    + "SYSRES_CONST_ACCESS_RIGHTS_VIEW "
    + "SYSRES_CONST_ACCESS_RIGHTS_VIEW_CODE "
    + "SYSRES_CONST_ACCESS_RIGHTS_VIEW_REQUISITE_CODE "
    + "SYSRES_CONST_ACCESS_RIGHTS_VIEW_REQUISITE_YES_CODE "
    + "SYSRES_CONST_ACCESS_TYPE_CHANGE "
    + "SYSRES_CONST_ACCESS_TYPE_CHANGE_CODE "
    + "SYSRES_CONST_ACCESS_TYPE_EXISTS "
    + "SYSRES_CONST_ACCESS_TYPE_EXISTS_CODE "
    + "SYSRES_CONST_ACCESS_TYPE_FULL "
    + "SYSRES_CONST_ACCESS_TYPE_FULL_CODE "
    + "SYSRES_CONST_ACCESS_TYPE_VIEW "
    + "SYSRES_CONST_ACCESS_TYPE_VIEW_CODE "
    + "SYSRES_CONST_ACTION_TYPE_ABORT "
    + "SYSRES_CONST_ACTION_TYPE_ACCEPT "
    + "SYSRES_CONST_ACTION_TYPE_ACCESS_RIGHTS "
    + "SYSRES_CONST_ACTION_TYPE_ADD_ATTACHMENT "
    + "SYSRES_CONST_ACTION_TYPE_CHANGE_CARD "
    + "SYSRES_CONST_ACTION_TYPE_CHANGE_KIND "
    + "SYSRES_CONST_ACTION_TYPE_CHANGE_STORAGE "
    + "SYSRES_CONST_ACTION_TYPE_CONTINUE "
    + "SYSRES_CONST_ACTION_TYPE_COPY "
    + "SYSRES_CONST_ACTION_TYPE_CREATE "
    + "SYSRES_CONST_ACTION_TYPE_CREATE_VERSION "
    + "SYSRES_CONST_ACTION_TYPE_DELETE "
    + "SYSRES_CONST_ACTION_TYPE_DELETE_ATTACHMENT "
    + "SYSRES_CONST_ACTION_TYPE_DELETE_VERSION "
    + "SYSRES_CONST_ACTION_TYPE_DISABLE_DELEGATE_ACCESS_RIGHTS "
    + "SYSRES_CONST_ACTION_TYPE_ENABLE_DELEGATE_ACCESS_RIGHTS "
    + "SYSRES_CONST_ACTION_TYPE_ENCRYPTION_BY_CERTIFICATE "
    + "SYSRES_CONST_ACTION_TYPE_ENCRYPTION_BY_CERTIFICATE_AND_PASSWORD "
    + "SYSRES_CONST_ACTION_TYPE_ENCRYPTION_BY_PASSWORD "
    + "SYSRES_CONST_ACTION_TYPE_EXPORT_WITH_LOCK "
    + "SYSRES_CONST_ACTION_TYPE_EXPORT_WITHOUT_LOCK "
    + "SYSRES_CONST_ACTION_TYPE_IMPORT_WITH_UNLOCK "
    + "SYSRES_CONST_ACTION_TYPE_IMPORT_WITHOUT_UNLOCK "
    + "SYSRES_CONST_ACTION_TYPE_LIFE_CYCLE_STAGE "
    + "SYSRES_CONST_ACTION_TYPE_LOCK "
    + "SYSRES_CONST_ACTION_TYPE_LOCK_FOR_SERVER "
    + "SYSRES_CONST_ACTION_TYPE_LOCK_MODIFY "
    + "SYSRES_CONST_ACTION_TYPE_MARK_AS_READED "
    + "SYSRES_CONST_ACTION_TYPE_MARK_AS_UNREADED "
    + "SYSRES_CONST_ACTION_TYPE_MODIFY "
    + "SYSRES_CONST_ACTION_TYPE_MODIFY_CARD "
    + "SYSRES_CONST_ACTION_TYPE_MOVE_TO_ARCHIVE "
    + "SYSRES_CONST_ACTION_TYPE_OFF_ENCRYPTION "
    + "SYSRES_CONST_ACTION_TYPE_PASSWORD_CHANGE "
    + "SYSRES_CONST_ACTION_TYPE_PERFORM "
    + "SYSRES_CONST_ACTION_TYPE_RECOVER_FROM_LOCAL_COPY "
    + "SYSRES_CONST_ACTION_TYPE_RESTART "
    + "SYSRES_CONST_ACTION_TYPE_RESTORE_FROM_ARCHIVE "
    + "SYSRES_CONST_ACTION_TYPE_REVISION "
    + "SYSRES_CONST_ACTION_TYPE_SEND_BY_MAIL "
    + "SYSRES_CONST_ACTION_TYPE_SIGN "
    + "SYSRES_CONST_ACTION_TYPE_START "
    + "SYSRES_CONST_ACTION_TYPE_UNLOCK "
    + "SYSRES_CONST_ACTION_TYPE_UNLOCK_FROM_SERVER "
    + "SYSRES_CONST_ACTION_TYPE_VERSION_STATE "
    + "SYSRES_CONST_ACTION_TYPE_VERSION_VISIBILITY "
    + "SYSRES_CONST_ACTION_TYPE_VIEW "
    + "SYSRES_CONST_ACTION_TYPE_VIEW_SHADOW_COPY "
    + "SYSRES_CONST_ACTION_TYPE_WORKFLOW_DESCRIPTION_MODIFY "
    + "SYSRES_CONST_ACTION_TYPE_WRITE_HISTORY "
    + "SYSRES_CONST_ACTIVE_VERSION_STATE_PICK_VALUE "
    + "SYSRES_CONST_ADD_REFERENCE_MODE_NAME "
    + "SYSRES_CONST_ADDITION_REQUISITE_CODE "
    + "SYSRES_CONST_ADDITIONAL_PARAMS_REQUISITE_CODE "
    + "SYSRES_CONST_ADITIONAL_JOB_END_DATE_REQUISITE_NAME "
    + "SYSRES_CONST_ADITIONAL_JOB_READ_REQUISITE_NAME "
    + "SYSRES_CONST_ADITIONAL_JOB_START_DATE_REQUISITE_NAME "
    + "SYSRES_CONST_ADITIONAL_JOB_STATE_REQUISITE_NAME "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_ADDING_USER_TO_GROUP_ACTION "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_ADDING_USER_TO_GROUP_ACTION_CODE "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_CREATION_COMP_ACTION "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_CREATION_COMP_ACTION_CODE "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_CREATION_GROUP_ACTION "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_CREATION_GROUP_ACTION_CODE "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_CREATION_USER_ACTION "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_CREATION_USER_ACTION_CODE "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_DATABASE_USER_CREATION "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_DATABASE_USER_CREATION_ACTION "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_DATABASE_USER_DELETION "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_DATABASE_USER_DELETION_ACTION "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_DELETION_COMP_ACTION "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_DELETION_COMP_ACTION_CODE "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_DELETION_GROUP_ACTION "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_DELETION_GROUP_ACTION_CODE "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_DELETION_USER_ACTION "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_DELETION_USER_ACTION_CODE "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_DELETION_USER_FROM_GROUP_ACTION "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_DELETION_USER_FROM_GROUP_ACTION_CODE "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_GRANTING_FILTERER_ACTION "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_GRANTING_FILTERER_ACTION_CODE "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_GRANTING_FILTERER_RESTRICTION_ACTION "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_GRANTING_FILTERER_RESTRICTION_ACTION_CODE "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_GRANTING_PRIVILEGE_ACTION "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_GRANTING_PRIVILEGE_ACTION_CODE "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_GRANTING_RIGHTS_ACTION "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_GRANTING_RIGHTS_ACTION_CODE "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_IS_MAIN_SERVER_CHANGED_ACTION "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_IS_MAIN_SERVER_CHANGED_ACTION_CODE "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_IS_PUBLIC_CHANGED_ACTION "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_IS_PUBLIC_CHANGED_ACTION_CODE "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_REMOVING_FILTERER_ACTION "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_REMOVING_FILTERER_ACTION_CODE "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_REMOVING_FILTERER_RESTRICTION_ACTION "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_REMOVING_FILTERER_RESTRICTION_ACTION_CODE "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_REMOVING_PRIVILEGE_ACTION "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_REMOVING_PRIVILEGE_ACTION_CODE "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_REMOVING_RIGHTS_ACTION "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_REMOVING_RIGHTS_ACTION_CODE "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_SERVER_LOGIN_CREATION "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_SERVER_LOGIN_CREATION_ACTION "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_SERVER_LOGIN_DELETION "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_SERVER_LOGIN_DELETION_ACTION "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_UPDATING_CATEGORY_ACTION "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_UPDATING_CATEGORY_ACTION_CODE "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_UPDATING_COMP_TITLE_ACTION "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_UPDATING_COMP_TITLE_ACTION_CODE "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_UPDATING_FULL_NAME_ACTION "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_UPDATING_FULL_NAME_ACTION_CODE "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_UPDATING_GROUP_ACTION "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_UPDATING_GROUP_ACTION_CODE "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_UPDATING_PARENT_GROUP_ACTION "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_UPDATING_PARENT_GROUP_ACTION_CODE "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_UPDATING_USER_AUTH_TYPE_ACTION "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_UPDATING_USER_AUTH_TYPE_ACTION_CODE "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_UPDATING_USER_LOGIN_ACTION "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_UPDATING_USER_LOGIN_ACTION_CODE "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_UPDATING_USER_STATUS_ACTION "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_UPDATING_USER_STATUS_ACTION_CODE "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_USER_PASSWORD_CHANGE "
    + "SYSRES_CONST_ADMINISTRATION_HISTORY_USER_PASSWORD_CHANGE_ACTION "
    + "SYSRES_CONST_ALL_ACCEPT_CONDITION_RUS "
    + "SYSRES_CONST_ALL_USERS_GROUP "
    + "SYSRES_CONST_ALL_USERS_GROUP_NAME "
    + "SYSRES_CONST_ALL_USERS_SERVER_GROUP_NAME "
    + "SYSRES_CONST_ALLOWED_ACCESS_TYPE_CODE "
    + "SYSRES_CONST_ALLOWED_ACCESS_TYPE_NAME "
    + "SYSRES_CONST_APP_VIEWER_TYPE_REQUISITE_CODE "
    + "SYSRES_CONST_APPROVING_SIGNATURE_NAME "
    + "SYSRES_CONST_APPROVING_SIGNATURE_REQUISITE_CODE "
    + "SYSRES_CONST_ASSISTANT_SUBSTITUE_TYPE "
    + "SYSRES_CONST_ASSISTANT_SUBSTITUE_TYPE_CODE "
    + "SYSRES_CONST_ATTACH_TYPE_COMPONENT_TOKEN "
    + "SYSRES_CONST_ATTACH_TYPE_DOC "
    + "SYSRES_CONST_ATTACH_TYPE_EDOC "
    + "SYSRES_CONST_ATTACH_TYPE_FOLDER "
    + "SYSRES_CONST_ATTACH_TYPE_JOB "
    + "SYSRES_CONST_ATTACH_TYPE_REFERENCE "
    + "SYSRES_CONST_ATTACH_TYPE_TASK "
    + "SYSRES_CONST_AUTH_ENCODED_PASSWORD "
    + "SYSRES_CONST_AUTH_ENCODED_PASSWORD_CODE "
    + "SYSRES_CONST_AUTH_NOVELL "
    + "SYSRES_CONST_AUTH_PASSWORD "
    + "SYSRES_CONST_AUTH_PASSWORD_CODE "
    + "SYSRES_CONST_AUTH_WINDOWS "
    + "SYSRES_CONST_AUTHENTICATING_SIGNATURE_NAME "
    + "SYSRES_CONST_AUTHENTICATING_SIGNATURE_REQUISITE_CODE "
    + "SYSRES_CONST_AUTO_ENUM_METHOD_FLAG "
    + "SYSRES_CONST_AUTO_NUMERATION_CODE "
    + "SYSRES_CONST_AUTO_STRONG_ENUM_METHOD_FLAG "
    + "SYSRES_CONST_AUTOTEXT_NAME_REQUISITE_CODE "
    + "SYSRES_CONST_AUTOTEXT_TEXT_REQUISITE_CODE "
    + "SYSRES_CONST_AUTOTEXT_USAGE_ALL "
    + "SYSRES_CONST_AUTOTEXT_USAGE_ALL_CODE "
    + "SYSRES_CONST_AUTOTEXT_USAGE_SIGN "
    + "SYSRES_CONST_AUTOTEXT_USAGE_SIGN_CODE "
    + "SYSRES_CONST_AUTOTEXT_USAGE_WORK "
    + "SYSRES_CONST_AUTOTEXT_USAGE_WORK_CODE "
    + "SYSRES_CONST_AUTOTEXT_USE_ANYWHERE_CODE "
    + "SYSRES_CONST_AUTOTEXT_USE_ON_SIGNING_CODE "
    + "SYSRES_CONST_AUTOTEXT_USE_ON_WORK_CODE "
    + "SYSRES_CONST_BEGIN_DATE_REQUISITE_CODE "
    + "SYSRES_CONST_BLACK_LIFE_CYCLE_STAGE_FONT_COLOR "
    + "SYSRES_CONST_BLUE_LIFE_CYCLE_STAGE_FONT_COLOR "
    + "SYSRES_CONST_BTN_PART "
    + "SYSRES_CONST_CALCULATED_ROLE_TYPE_CODE "
    + "SYSRES_CONST_CALL_TYPE_VARIABLE_BUTTON_VALUE "
    + "SYSRES_CONST_CALL_TYPE_VARIABLE_PROGRAM_VALUE "
    + "SYSRES_CONST_CANCEL_MESSAGE_FUNCTION_RESULT "
    + "SYSRES_CONST_CARD_PART "
    + "SYSRES_CONST_CARD_REFERENCE_MODE_NAME "
    + "SYSRES_CONST_CERTIFICATE_TYPE_REQUISITE_ENCRYPT_VALUE "
    + "SYSRES_CONST_CERTIFICATE_TYPE_REQUISITE_SIGN_AND_ENCRYPT_VALUE "
    + "SYSRES_CONST_CERTIFICATE_TYPE_REQUISITE_SIGN_VALUE "
    + "SYSRES_CONST_CHECK_PARAM_VALUE_DATE_PARAM_TYPE "
    + "SYSRES_CONST_CHECK_PARAM_VALUE_FLOAT_PARAM_TYPE "
    + "SYSRES_CONST_CHECK_PARAM_VALUE_INTEGER_PARAM_TYPE "
    + "SYSRES_CONST_CHECK_PARAM_VALUE_PICK_PARAM_TYPE "
    + "SYSRES_CONST_CHECK_PARAM_VALUE_REEFRENCE_PARAM_TYPE "
    + "SYSRES_CONST_CLOSED_RECORD_FLAG_VALUE_FEMININE "
    + "SYSRES_CONST_CLOSED_RECORD_FLAG_VALUE_MASCULINE "
    + "SYSRES_CONST_CODE_COMPONENT_TYPE_ADMIN "
    + "SYSRES_CONST_CODE_COMPONENT_TYPE_DEVELOPER "
    + "SYSRES_CONST_CODE_COMPONENT_TYPE_DOCS "
    + "SYSRES_CONST_CODE_COMPONENT_TYPE_EDOC_CARDS "
    + "SYSRES_CONST_CODE_COMPONENT_TYPE_EXTERNAL_EXECUTABLE "
    + "SYSRES_CONST_CODE_COMPONENT_TYPE_OTHER "
    + "SYSRES_CONST_CODE_COMPONENT_TYPE_REFERENCE "
    + "SYSRES_CONST_CODE_COMPONENT_TYPE_REPORT "
    + "SYSRES_CONST_CODE_COMPONENT_TYPE_SCRIPT "
    + "SYSRES_CONST_CODE_COMPONENT_TYPE_URL "
    + "SYSRES_CONST_CODE_REQUISITE_ACCESS "
    + "SYSRES_CONST_CODE_REQUISITE_CODE "
    + "SYSRES_CONST_CODE_REQUISITE_COMPONENT "
    + "SYSRES_CONST_CODE_REQUISITE_DESCRIPTION "
    + "SYSRES_CONST_CODE_REQUISITE_EXCLUDE_COMPONENT "
    + "SYSRES_CONST_CODE_REQUISITE_RECORD "
    + "SYSRES_CONST_COMMENT_REQ_CODE "
    + "SYSRES_CONST_COMMON_SETTINGS_REQUISITE_CODE "
    + "SYSRES_CONST_COMP_CODE_GRD "
    + "SYSRES_CONST_COMPONENT_GROUP_TYPE_REQUISITE_CODE "
    + "SYSRES_CONST_COMPONENT_TYPE_ADMIN_COMPONENTS "
    + "SYSRES_CONST_COMPONENT_TYPE_DEVELOPER_COMPONENTS "
    + "SYSRES_CONST_COMPONENT_TYPE_DOCS "
    + "SYSRES_CONST_COMPONENT_TYPE_EDOC_CARDS "
    + "SYSRES_CONST_COMPONENT_TYPE_EDOCS "
    + "SYSRES_CONST_COMPONENT_TYPE_EXTERNAL_EXECUTABLE "
    + "SYSRES_CONST_COMPONENT_TYPE_OTHER "
    + "SYSRES_CONST_COMPONENT_TYPE_REFERENCE_TYPES "
    + "SYSRES_CONST_COMPONENT_TYPE_REFERENCES "
    + "SYSRES_CONST_COMPONENT_TYPE_REPORTS "
    + "SYSRES_CONST_COMPONENT_TYPE_SCRIPTS "
    + "SYSRES_CONST_COMPONENT_TYPE_URL "
    + "SYSRES_CONST_COMPONENTS_REMOTE_SERVERS_VIEW_CODE "
    + "SYSRES_CONST_CONDITION_BLOCK_DESCRIPTION "
    + "SYSRES_CONST_CONST_FIRM_STATUS_COMMON "
    + "SYSRES_CONST_CONST_FIRM_STATUS_INDIVIDUAL "
    + "SYSRES_CONST_CONST_NEGATIVE_VALUE "
    + "SYSRES_CONST_CONST_POSITIVE_VALUE "
    + "SYSRES_CONST_CONST_SERVER_STATUS_DONT_REPLICATE "
    + "SYSRES_CONST_CONST_SERVER_STATUS_REPLICATE "
    + "SYSRES_CONST_CONTENTS_REQUISITE_CODE "
    + "SYSRES_CONST_DATA_TYPE_BOOLEAN "
    + "SYSRES_CONST_DATA_TYPE_DATE "
    + "SYSRES_CONST_DATA_TYPE_FLOAT "
    + "SYSRES_CONST_DATA_TYPE_INTEGER "
    + "SYSRES_CONST_DATA_TYPE_PICK "
    + "SYSRES_CONST_DATA_TYPE_REFERENCE "
    + "SYSRES_CONST_DATA_TYPE_STRING "
    + "SYSRES_CONST_DATA_TYPE_TEXT "
    + "SYSRES_CONST_DATA_TYPE_VARIANT "
    + "SYSRES_CONST_DATE_CLOSE_REQ_CODE "
    + "SYSRES_CONST_DATE_FORMAT_DATE_ONLY_CHAR "
    + "SYSRES_CONST_DATE_OPEN_REQ_CODE "
    + "SYSRES_CONST_DATE_REQUISITE "
    + "SYSRES_CONST_DATE_REQUISITE_CODE "
    + "SYSRES_CONST_DATE_REQUISITE_NAME "
    + "SYSRES_CONST_DATE_REQUISITE_TYPE "
    + "SYSRES_CONST_DATE_TYPE_CHAR "
    + "SYSRES_CONST_DATETIME_FORMAT_VALUE "
    + "SYSRES_CONST_DEA_ACCESS_RIGHTS_ACTION_CODE "
    + "SYSRES_CONST_DESCRIPTION_LOCALIZE_ID_REQUISITE_CODE "
    + "SYSRES_CONST_DESCRIPTION_REQUISITE_CODE "
    + "SYSRES_CONST_DET1_PART "
    + "SYSRES_CONST_DET2_PART "
    + "SYSRES_CONST_DET3_PART "
    + "SYSRES_CONST_DET4_PART "
    + "SYSRES_CONST_DET5_PART "
    + "SYSRES_CONST_DET6_PART "
    + "SYSRES_CONST_DETAIL_DATASET_KEY_REQUISITE_CODE "
    + "SYSRES_CONST_DETAIL_PICK_REQUISITE_CODE "
    + "SYSRES_CONST_DETAIL_REQ_CODE "
    + "SYSRES_CONST_DO_NOT_USE_ACCESS_TYPE_CODE "
    + "SYSRES_CONST_DO_NOT_USE_ACCESS_TYPE_NAME "
    + "SYSRES_CONST_DO_NOT_USE_ON_VIEW_ACCESS_TYPE_CODE "
    + "SYSRES_CONST_DO_NOT_USE_ON_VIEW_ACCESS_TYPE_NAME "
    + "SYSRES_CONST_DOCUMENT_STORAGES_CODE "
    + "SYSRES_CONST_DOCUMENT_TEMPLATES_TYPE_NAME "
    + "SYSRES_CONST_DOUBLE_REQUISITE_CODE "
    + "SYSRES_CONST_EDITOR_CLOSE_FILE_OBSERV_TYPE_CODE "
    + "SYSRES_CONST_EDITOR_CLOSE_PROCESS_OBSERV_TYPE_CODE "
    + "SYSRES_CONST_EDITOR_TYPE_REQUISITE_CODE "
    + "SYSRES_CONST_EDITORS_APPLICATION_NAME_REQUISITE_CODE "
    + "SYSRES_CONST_EDITORS_CREATE_SEVERAL_PROCESSES_REQUISITE_CODE "
    + "SYSRES_CONST_EDITORS_EXTENSION_REQUISITE_CODE "
    + "SYSRES_CONST_EDITORS_OBSERVER_BY_PROCESS_TYPE "
    + "SYSRES_CONST_EDITORS_REFERENCE_CODE "
    + "SYSRES_CONST_EDITORS_REPLACE_SPEC_CHARS_REQUISITE_CODE "
    + "SYSRES_CONST_EDITORS_USE_PLUGINS_REQUISITE_CODE "
    + "SYSRES_CONST_EDITORS_VIEW_DOCUMENT_OPENED_TO_EDIT_CODE "
    + "SYSRES_CONST_EDOC_CARD_TYPE_REQUISITE_CODE "
    + "SYSRES_CONST_EDOC_CARD_TYPES_LINK_REQUISITE_CODE "
    + "SYSRES_CONST_EDOC_CERTIFICATE_AND_PASSWORD_ENCODE_CODE "
    + "SYSRES_CONST_EDOC_CERTIFICATE_ENCODE_CODE "
    + "SYSRES_CONST_EDOC_DATE_REQUISITE_CODE "
    + "SYSRES_CONST_EDOC_KIND_REFERENCE_CODE "
    + "SYSRES_CONST_EDOC_KINDS_BY_TEMPLATE_ACTION_CODE "
    + "SYSRES_CONST_EDOC_MANAGE_ACCESS_CODE "
    + "SYSRES_CONST_EDOC_NONE_ENCODE_CODE "
    + "SYSRES_CONST_EDOC_NUMBER_REQUISITE_CODE "
    + "SYSRES_CONST_EDOC_PASSWORD_ENCODE_CODE "
    + "SYSRES_CONST_EDOC_READONLY_ACCESS_CODE "
    + "SYSRES_CONST_EDOC_SHELL_LIFE_TYPE_VIEW_VALUE "
    + "SYSRES_CONST_EDOC_SIZE_RESTRICTION_PRIORITY_REQUISITE_CODE "
    + "SYSRES_CONST_EDOC_STORAGE_CHECK_ACCESS_RIGHTS_REQUISITE_CODE "
    + "SYSRES_CONST_EDOC_STORAGE_COMPUTER_NAME_REQUISITE_CODE "
    + "SYSRES_CONST_EDOC_STORAGE_DATABASE_NAME_REQUISITE_CODE "
    + "SYSRES_CONST_EDOC_STORAGE_EDIT_IN_STORAGE_REQUISITE_CODE "
    + "SYSRES_CONST_EDOC_STORAGE_LOCAL_PATH_REQUISITE_CODE "
    + "SYSRES_CONST_EDOC_STORAGE_SHARED_SOURCE_NAME_REQUISITE_CODE "
    + "SYSRES_CONST_EDOC_TEMPLATE_REQUISITE_CODE "
    + "SYSRES_CONST_EDOC_TYPES_REFERENCE_CODE "
    + "SYSRES_CONST_EDOC_VERSION_ACTIVE_STAGE_CODE "
    + "SYSRES_CONST_EDOC_VERSION_DESIGN_STAGE_CODE "
    + "SYSRES_CONST_EDOC_VERSION_OBSOLETE_STAGE_CODE "
    + "SYSRES_CONST_EDOC_WRITE_ACCES_CODE "
    + "SYSRES_CONST_EDOCUMENT_CARD_REQUISITES_REFERENCE_CODE_SELECTED_REQUISITE "
    + "SYSRES_CONST_ENCODE_CERTIFICATE_TYPE_CODE "
    + "SYSRES_CONST_END_DATE_REQUISITE_CODE "
    + "SYSRES_CONST_ENUMERATION_TYPE_REQUISITE_CODE "
    + "SYSRES_CONST_EXECUTE_ACCESS_RIGHTS_TYPE_CODE "
    + "SYSRES_CONST_EXECUTIVE_FILE_STORAGE_TYPE "
    + "SYSRES_CONST_EXIST_CONST "
    + "SYSRES_CONST_EXIST_VALUE "
    + "SYSRES_CONST_EXPORT_LOCK_TYPE_ASK "
    + "SYSRES_CONST_EXPORT_LOCK_TYPE_WITH_LOCK "
    + "SYSRES_CONST_EXPORT_LOCK_TYPE_WITHOUT_LOCK "
    + "SYSRES_CONST_EXPORT_VERSION_TYPE_ASK "
    + "SYSRES_CONST_EXPORT_VERSION_TYPE_LAST "
    + "SYSRES_CONST_EXPORT_VERSION_TYPE_LAST_ACTIVE "
    + "SYSRES_CONST_EXTENSION_REQUISITE_CODE "
    + "SYSRES_CONST_FILTER_NAME_REQUISITE_CODE "
    + "SYSRES_CONST_FILTER_REQUISITE_CODE "
    + "SYSRES_CONST_FILTER_TYPE_COMMON_CODE "
    + "SYSRES_CONST_FILTER_TYPE_COMMON_NAME "
    + "SYSRES_CONST_FILTER_TYPE_USER_CODE "
    + "SYSRES_CONST_FILTER_TYPE_USER_NAME "
    + "SYSRES_CONST_FILTER_VALUE_REQUISITE_NAME "
    + "SYSRES_CONST_FLOAT_NUMBER_FORMAT_CHAR "
    + "SYSRES_CONST_FLOAT_REQUISITE_TYPE "
    + "SYSRES_CONST_FOLDER_AUTHOR_VALUE "
    + "SYSRES_CONST_FOLDER_KIND_ANY_OBJECTS "
    + "SYSRES_CONST_FOLDER_KIND_COMPONENTS "
    + "SYSRES_CONST_FOLDER_KIND_EDOCS "
    + "SYSRES_CONST_FOLDER_KIND_JOBS "
    + "SYSRES_CONST_FOLDER_KIND_TASKS "
    + "SYSRES_CONST_FOLDER_TYPE_COMMON "
    + "SYSRES_CONST_FOLDER_TYPE_COMPONENT "
    + "SYSRES_CONST_FOLDER_TYPE_FAVORITES "
    + "SYSRES_CONST_FOLDER_TYPE_INBOX "
    + "SYSRES_CONST_FOLDER_TYPE_OUTBOX "
    + "SYSRES_CONST_FOLDER_TYPE_QUICK_LAUNCH "
    + "SYSRES_CONST_FOLDER_TYPE_SEARCH "
    + "SYSRES_CONST_FOLDER_TYPE_SHORTCUTS "
    + "SYSRES_CONST_FOLDER_TYPE_USER "
    + "SYSRES_CONST_FROM_DICTIONARY_ENUM_METHOD_FLAG "
    + "SYSRES_CONST_FULL_SUBSTITUTE_TYPE "
    + "SYSRES_CONST_FULL_SUBSTITUTE_TYPE_CODE "
    + "SYSRES_CONST_FUNCTION_CANCEL_RESULT "
    + "SYSRES_CONST_FUNCTION_CATEGORY_SYSTEM "
    + "SYSRES_CONST_FUNCTION_CATEGORY_USER "
    + "SYSRES_CONST_FUNCTION_FAILURE_RESULT "
    + "SYSRES_CONST_FUNCTION_SAVE_RESULT "
    + "SYSRES_CONST_GENERATED_REQUISITE "
    + "SYSRES_CONST_GREEN_LIFE_CYCLE_STAGE_FONT_COLOR "
    + "SYSRES_CONST_GROUP_ACCOUNT_TYPE_VALUE_CODE "
    + "SYSRES_CONST_GROUP_CATEGORY_NORMAL_CODE "
    + "SYSRES_CONST_GROUP_CATEGORY_NORMAL_NAME "
    + "SYSRES_CONST_GROUP_CATEGORY_SERVICE_CODE "
    + "SYSRES_CONST_GROUP_CATEGORY_SERVICE_NAME "
    + "SYSRES_CONST_GROUP_COMMON_CATEGORY_FIELD_VALUE "
    + "SYSRES_CONST_GROUP_FULL_NAME_REQUISITE_CODE "
    + "SYSRES_CONST_GROUP_NAME_REQUISITE_CODE "
    + "SYSRES_CONST_GROUP_RIGHTS_T_REQUISITE_CODE "
    + "SYSRES_CONST_GROUP_SERVER_CODES_REQUISITE_CODE "
    + "SYSRES_CONST_GROUP_SERVER_NAME_REQUISITE_CODE "
    + "SYSRES_CONST_GROUP_SERVICE_CATEGORY_FIELD_VALUE "
    + "SYSRES_CONST_GROUP_USER_REQUISITE_CODE "
    + "SYSRES_CONST_GROUPS_REFERENCE_CODE "
    + "SYSRES_CONST_GROUPS_REQUISITE_CODE "
    + "SYSRES_CONST_HIDDEN_MODE_NAME "
    + "SYSRES_CONST_HIGH_LVL_REQUISITE_CODE "
    + "SYSRES_CONST_HISTORY_ACTION_CREATE_CODE "
    + "SYSRES_CONST_HISTORY_ACTION_DELETE_CODE "
    + "SYSRES_CONST_HISTORY_ACTION_EDIT_CODE "
    + "SYSRES_CONST_HOUR_CHAR "
    + "SYSRES_CONST_ID_REQUISITE_CODE "
    + "SYSRES_CONST_IDSPS_REQUISITE_CODE "
    + "SYSRES_CONST_IMAGE_MODE_COLOR "
    + "SYSRES_CONST_IMAGE_MODE_GREYSCALE "
    + "SYSRES_CONST_IMAGE_MODE_MONOCHROME "
    + "SYSRES_CONST_IMPORTANCE_HIGH "
    + "SYSRES_CONST_IMPORTANCE_LOW "
    + "SYSRES_CONST_IMPORTANCE_NORMAL "
    + "SYSRES_CONST_IN_DESIGN_VERSION_STATE_PICK_VALUE "
    + "SYSRES_CONST_INCOMING_WORK_RULE_TYPE_CODE "
    + "SYSRES_CONST_INT_REQUISITE "
    + "SYSRES_CONST_INT_REQUISITE_TYPE "
    + "SYSRES_CONST_INTEGER_NUMBER_FORMAT_CHAR "
    + "SYSRES_CONST_INTEGER_TYPE_CHAR "
    + "SYSRES_CONST_IS_GENERATED_REQUISITE_NEGATIVE_VALUE "
    + "SYSRES_CONST_IS_PUBLIC_ROLE_REQUISITE_CODE "
    + "SYSRES_CONST_IS_REMOTE_USER_NEGATIVE_VALUE "
    + "SYSRES_CONST_IS_REMOTE_USER_POSITIVE_VALUE "
    + "SYSRES_CONST_IS_STORED_REQUISITE_NEGATIVE_VALUE "
    + "SYSRES_CONST_IS_STORED_REQUISITE_STORED_VALUE "
    + "SYSRES_CONST_ITALIC_LIFE_CYCLE_STAGE_DRAW_STYLE "
    + "SYSRES_CONST_JOB_BLOCK_DESCRIPTION "
    + "SYSRES_CONST_JOB_KIND_CONTROL_JOB "
    + "SYSRES_CONST_JOB_KIND_JOB "
    + "SYSRES_CONST_JOB_KIND_NOTICE "
    + "SYSRES_CONST_JOB_STATE_ABORTED "
    + "SYSRES_CONST_JOB_STATE_COMPLETE "
    + "SYSRES_CONST_JOB_STATE_WORKING "
    + "SYSRES_CONST_KIND_REQUISITE_CODE "
    + "SYSRES_CONST_KIND_REQUISITE_NAME "
    + "SYSRES_CONST_KINDS_CREATE_SHADOW_COPIES_REQUISITE_CODE "
    + "SYSRES_CONST_KINDS_DEFAULT_EDOC_LIFE_STAGE_REQUISITE_CODE "
    + "SYSRES_CONST_KINDS_EDOC_ALL_TEPLATES_ALLOWED_REQUISITE_CODE "
    + "SYSRES_CONST_KINDS_EDOC_ALLOW_LIFE_CYCLE_STAGE_CHANGING_REQUISITE_CODE "
    + "SYSRES_CONST_KINDS_EDOC_ALLOW_MULTIPLE_ACTIVE_VERSIONS_REQUISITE_CODE "
    + "SYSRES_CONST_KINDS_EDOC_SHARE_ACCES_RIGHTS_BY_DEFAULT_CODE "
    + "SYSRES_CONST_KINDS_EDOC_TEMPLATE_REQUISITE_CODE "
    + "SYSRES_CONST_KINDS_EDOC_TYPE_REQUISITE_CODE "
    + "SYSRES_CONST_KINDS_SIGNERS_REQUISITES_CODE "
    + "SYSRES_CONST_KOD_INPUT_TYPE "
    + "SYSRES_CONST_LAST_UPDATE_DATE_REQUISITE_CODE "
    + "SYSRES_CONST_LIFE_CYCLE_START_STAGE_REQUISITE_CODE "
    + "SYSRES_CONST_LILAC_LIFE_CYCLE_STAGE_FONT_COLOR "
    + "SYSRES_CONST_LINK_OBJECT_KIND_COMPONENT "
    + "SYSRES_CONST_LINK_OBJECT_KIND_DOCUMENT "
    + "SYSRES_CONST_LINK_OBJECT_KIND_EDOC "
    + "SYSRES_CONST_LINK_OBJECT_KIND_FOLDER "
    + "SYSRES_CONST_LINK_OBJECT_KIND_JOB "
    + "SYSRES_CONST_LINK_OBJECT_KIND_REFERENCE "
    + "SYSRES_CONST_LINK_OBJECT_KIND_TASK "
    + "SYSRES_CONST_LINK_REF_TYPE_REQUISITE_CODE "
    + "SYSRES_CONST_LIST_REFERENCE_MODE_NAME "
    + "SYSRES_CONST_LOCALIZATION_DICTIONARY_MAIN_VIEW_CODE "
    + "SYSRES_CONST_MAIN_VIEW_CODE "
    + "SYSRES_CONST_MANUAL_ENUM_METHOD_FLAG "
    + "SYSRES_CONST_MASTER_COMP_TYPE_REQUISITE_CODE "
    + "SYSRES_CONST_MASTER_TABLE_REC_ID_REQUISITE_CODE "
    + "SYSRES_CONST_MAXIMIZED_MODE_NAME "
    + "SYSRES_CONST_ME_VALUE "
    + "SYSRES_CONST_MESSAGE_ATTENTION_CAPTION "
    + "SYSRES_CONST_MESSAGE_CONFIRMATION_CAPTION "
    + "SYSRES_CONST_MESSAGE_ERROR_CAPTION "
    + "SYSRES_CONST_MESSAGE_INFORMATION_CAPTION "
    + "SYSRES_CONST_MINIMIZED_MODE_NAME "
    + "SYSRES_CONST_MINUTE_CHAR "
    + "SYSRES_CONST_MODULE_REQUISITE_CODE "
    + "SYSRES_CONST_MONITORING_BLOCK_DESCRIPTION "
    + "SYSRES_CONST_MONTH_FORMAT_VALUE "
    + "SYSRES_CONST_NAME_LOCALIZE_ID_REQUISITE_CODE "
    + "SYSRES_CONST_NAME_REQUISITE_CODE "
    + "SYSRES_CONST_NAME_SINGULAR_REQUISITE_CODE "
    + "SYSRES_CONST_NAMEAN_INPUT_TYPE "
    + "SYSRES_CONST_NEGATIVE_PICK_VALUE "
    + "SYSRES_CONST_NEGATIVE_VALUE "
    + "SYSRES_CONST_NO "
    + "SYSRES_CONST_NO_PICK_VALUE "
    + "SYSRES_CONST_NO_SIGNATURE_REQUISITE_CODE "
    + "SYSRES_CONST_NO_VALUE "
    + "SYSRES_CONST_NONE_ACCESS_RIGHTS_TYPE_CODE "
    + "SYSRES_CONST_NONOPERATING_RECORD_FLAG_VALUE "
    + "SYSRES_CONST_NONOPERATING_RECORD_FLAG_VALUE_MASCULINE "
    + "SYSRES_CONST_NORMAL_ACCESS_RIGHTS_TYPE_CODE "
    + "SYSRES_CONST_NORMAL_LIFE_CYCLE_STAGE_DRAW_STYLE "
    + "SYSRES_CONST_NORMAL_MODE_NAME "
    + "SYSRES_CONST_NOT_ALLOWED_ACCESS_TYPE_CODE "
    + "SYSRES_CONST_NOT_ALLOWED_ACCESS_TYPE_NAME "
    + "SYSRES_CONST_NOTE_REQUISITE_CODE "
    + "SYSRES_CONST_NOTICE_BLOCK_DESCRIPTION "
    + "SYSRES_CONST_NUM_REQUISITE "
    + "SYSRES_CONST_NUM_STR_REQUISITE_CODE "
    + "SYSRES_CONST_NUMERATION_AUTO_NOT_STRONG "
    + "SYSRES_CONST_NUMERATION_AUTO_STRONG "
    + "SYSRES_CONST_NUMERATION_FROM_DICTONARY "
    + "SYSRES_CONST_NUMERATION_MANUAL "
    + "SYSRES_CONST_NUMERIC_TYPE_CHAR "
    + "SYSRES_CONST_NUMREQ_REQUISITE_CODE "
    + "SYSRES_CONST_OBSOLETE_VERSION_STATE_PICK_VALUE "
    + "SYSRES_CONST_OPERATING_RECORD_FLAG_VALUE "
    + "SYSRES_CONST_OPERATING_RECORD_FLAG_VALUE_CODE "
    + "SYSRES_CONST_OPERATING_RECORD_FLAG_VALUE_FEMININE "
    + "SYSRES_CONST_OPERATING_RECORD_FLAG_VALUE_MASCULINE "
    + "SYSRES_CONST_OPTIONAL_FORM_COMP_REQCODE_PREFIX "
    + "SYSRES_CONST_ORANGE_LIFE_CYCLE_STAGE_FONT_COLOR "
    + "SYSRES_CONST_ORIGINALREF_REQUISITE_CODE "
    + "SYSRES_CONST_OURFIRM_REF_CODE "
    + "SYSRES_CONST_OURFIRM_REQUISITE_CODE "
    + "SYSRES_CONST_OURFIRM_VAR "
    + "SYSRES_CONST_OUTGOING_WORK_RULE_TYPE_CODE "
    + "SYSRES_CONST_PICK_NEGATIVE_RESULT "
    + "SYSRES_CONST_PICK_POSITIVE_RESULT "
    + "SYSRES_CONST_PICK_REQUISITE "
    + "SYSRES_CONST_PICK_REQUISITE_TYPE "
    + "SYSRES_CONST_PICK_TYPE_CHAR "
    + "SYSRES_CONST_PLAN_STATUS_REQUISITE_CODE "
    + "SYSRES_CONST_PLATFORM_VERSION_COMMENT "
    + "SYSRES_CONST_PLUGINS_SETTINGS_DESCRIPTION_REQUISITE_CODE "
    + "SYSRES_CONST_POSITIVE_PICK_VALUE "
    + "SYSRES_CONST_POWER_TO_CREATE_ACTION_CODE "
    + "SYSRES_CONST_POWER_TO_SIGN_ACTION_CODE "
    + "SYSRES_CONST_PRIORITY_REQUISITE_CODE "
    + "SYSRES_CONST_QUALIFIED_TASK_TYPE "
    + "SYSRES_CONST_QUALIFIED_TASK_TYPE_CODE "
    + "SYSRES_CONST_RECSTAT_REQUISITE_CODE "
    + "SYSRES_CONST_RED_LIFE_CYCLE_STAGE_FONT_COLOR "
    + "SYSRES_CONST_REF_ID_T_REF_TYPE_REQUISITE_CODE "
    + "SYSRES_CONST_REF_REQUISITE "
    + "SYSRES_CONST_REF_REQUISITE_TYPE "
    + "SYSRES_CONST_REF_REQUISITES_REFERENCE_CODE_SELECTED_REQUISITE "
    + "SYSRES_CONST_REFERENCE_RECORD_HISTORY_CREATE_ACTION_CODE "
    + "SYSRES_CONST_REFERENCE_RECORD_HISTORY_DELETE_ACTION_CODE "
    + "SYSRES_CONST_REFERENCE_RECORD_HISTORY_MODIFY_ACTION_CODE "
    + "SYSRES_CONST_REFERENCE_TYPE_CHAR "
    + "SYSRES_CONST_REFERENCE_TYPE_REQUISITE_NAME "
    + "SYSRES_CONST_REFERENCES_ADD_PARAMS_REQUISITE_CODE "
    + "SYSRES_CONST_REFERENCES_DISPLAY_REQUISITE_REQUISITE_CODE "
    + "SYSRES_CONST_REMOTE_SERVER_STATUS_WORKING "
    + "SYSRES_CONST_REMOTE_SERVER_TYPE_MAIN "
    + "SYSRES_CONST_REMOTE_SERVER_TYPE_SECONDARY "
    + "SYSRES_CONST_REMOTE_USER_FLAG_VALUE_CODE "
    + "SYSRES_CONST_REPORT_APP_EDITOR_INTERNAL "
    + "SYSRES_CONST_REPORT_BASE_REPORT_ID_REQUISITE_CODE "
    + "SYSRES_CONST_REPORT_BASE_REPORT_REQUISITE_CODE "
    + "SYSRES_CONST_REPORT_SCRIPT_REQUISITE_CODE "
    + "SYSRES_CONST_REPORT_TEMPLATE_REQUISITE_CODE "
    + "SYSRES_CONST_REPORT_VIEWER_CODE_REQUISITE_CODE "
    + "SYSRES_CONST_REQ_ALLOW_COMPONENT_DEFAULT_VALUE "
    + "SYSRES_CONST_REQ_ALLOW_RECORD_DEFAULT_VALUE "
    + "SYSRES_CONST_REQ_ALLOW_SERVER_COMPONENT_DEFAULT_VALUE "
    + "SYSRES_CONST_REQ_MODE_AVAILABLE_CODE "
    + "SYSRES_CONST_REQ_MODE_EDIT_CODE "
    + "SYSRES_CONST_REQ_MODE_HIDDEN_CODE "
    + "SYSRES_CONST_REQ_MODE_NOT_AVAILABLE_CODE "
    + "SYSRES_CONST_REQ_MODE_VIEW_CODE "
    + "SYSRES_CONST_REQ_NUMBER_REQUISITE_CODE "
    + "SYSRES_CONST_REQ_SECTION_VALUE "
    + "SYSRES_CONST_REQ_TYPE_VALUE "
    + "SYSRES_CONST_REQUISITE_FORMAT_BY_UNIT "
    + "SYSRES_CONST_REQUISITE_FORMAT_DATE_FULL "
    + "SYSRES_CONST_REQUISITE_FORMAT_DATE_TIME "
    + "SYSRES_CONST_REQUISITE_FORMAT_LEFT "
    + "SYSRES_CONST_REQUISITE_FORMAT_RIGHT "
    + "SYSRES_CONST_REQUISITE_FORMAT_WITHOUT_UNIT "
    + "SYSRES_CONST_REQUISITE_NUMBER_REQUISITE_CODE "
    + "SYSRES_CONST_REQUISITE_SECTION_ACTIONS "
    + "SYSRES_CONST_REQUISITE_SECTION_BUTTON "
    + "SYSRES_CONST_REQUISITE_SECTION_BUTTONS "
    + "SYSRES_CONST_REQUISITE_SECTION_CARD "
    + "SYSRES_CONST_REQUISITE_SECTION_TABLE "
    + "SYSRES_CONST_REQUISITE_SECTION_TABLE10 "
    + "SYSRES_CONST_REQUISITE_SECTION_TABLE11 "
    + "SYSRES_CONST_REQUISITE_SECTION_TABLE12 "
    + "SYSRES_CONST_REQUISITE_SECTION_TABLE13 "
    + "SYSRES_CONST_REQUISITE_SECTION_TABLE14 "
    + "SYSRES_CONST_REQUISITE_SECTION_TABLE15 "
    + "SYSRES_CONST_REQUISITE_SECTION_TABLE16 "
    + "SYSRES_CONST_REQUISITE_SECTION_TABLE17 "
    + "SYSRES_CONST_REQUISITE_SECTION_TABLE18 "
    + "SYSRES_CONST_REQUISITE_SECTION_TABLE19 "
    + "SYSRES_CONST_REQUISITE_SECTION_TABLE2 "
    + "SYSRES_CONST_REQUISITE_SECTION_TABLE20 "
    + "SYSRES_CONST_REQUISITE_SECTION_TABLE21 "
    + "SYSRES_CONST_REQUISITE_SECTION_TABLE22 "
    + "SYSRES_CONST_REQUISITE_SECTION_TABLE23 "
    + "SYSRES_CONST_REQUISITE_SECTION_TABLE24 "
    + "SYSRES_CONST_REQUISITE_SECTION_TABLE3 "
    + "SYSRES_CONST_REQUISITE_SECTION_TABLE4 "
    + "SYSRES_CONST_REQUISITE_SECTION_TABLE5 "
    + "SYSRES_CONST_REQUISITE_SECTION_TABLE6 "
    + "SYSRES_CONST_REQUISITE_SECTION_TABLE7 "
    + "SYSRES_CONST_REQUISITE_SECTION_TABLE8 "
    + "SYSRES_CONST_REQUISITE_SECTION_TABLE9 "
    + "SYSRES_CONST_REQUISITES_PSEUDOREFERENCE_REQUISITE_NUMBER_REQUISITE_CODE "
    + "SYSRES_CONST_RIGHT_ALIGNMENT_CODE "
    + "SYSRES_CONST_ROLES_REFERENCE_CODE "
    + "SYSRES_CONST_ROUTE_STEP_AFTER_RUS "
    + "SYSRES_CONST_ROUTE_STEP_AND_CONDITION_RUS "
    + "SYSRES_CONST_ROUTE_STEP_OR_CONDITION_RUS "
    + "SYSRES_CONST_ROUTE_TYPE_COMPLEX "
    + "SYSRES_CONST_ROUTE_TYPE_PARALLEL "
    + "SYSRES_CONST_ROUTE_TYPE_SERIAL "
    + "SYSRES_CONST_SBDATASETDESC_NEGATIVE_VALUE "
    + "SYSRES_CONST_SBDATASETDESC_POSITIVE_VALUE "
    + "SYSRES_CONST_SBVIEWSDESC_POSITIVE_VALUE "
    + "SYSRES_CONST_SCRIPT_BLOCK_DESCRIPTION "
    + "SYSRES_CONST_SEARCH_BY_TEXT_REQUISITE_CODE "
    + "SYSRES_CONST_SEARCHES_COMPONENT_CONTENT "
    + "SYSRES_CONST_SEARCHES_CRITERIA_ACTION_NAME "
    + "SYSRES_CONST_SEARCHES_EDOC_CONTENT "
    + "SYSRES_CONST_SEARCHES_FOLDER_CONTENT "
    + "SYSRES_CONST_SEARCHES_JOB_CONTENT "
    + "SYSRES_CONST_SEARCHES_REFERENCE_CODE "
    + "SYSRES_CONST_SEARCHES_TASK_CONTENT "
    + "SYSRES_CONST_SECOND_CHAR "
    + "SYSRES_CONST_SECTION_REQUISITE_ACTIONS_VALUE "
    + "SYSRES_CONST_SECTION_REQUISITE_CARD_VALUE "
    + "SYSRES_CONST_SECTION_REQUISITE_CODE "
    + "SYSRES_CONST_SECTION_REQUISITE_DETAIL_1_VALUE "
    + "SYSRES_CONST_SECTION_REQUISITE_DETAIL_2_VALUE "
    + "SYSRES_CONST_SECTION_REQUISITE_DETAIL_3_VALUE "
    + "SYSRES_CONST_SECTION_REQUISITE_DETAIL_4_VALUE "
    + "SYSRES_CONST_SECTION_REQUISITE_DETAIL_5_VALUE "
    + "SYSRES_CONST_SECTION_REQUISITE_DETAIL_6_VALUE "
    + "SYSRES_CONST_SELECT_REFERENCE_MODE_NAME "
    + "SYSRES_CONST_SELECT_TYPE_SELECTABLE "
    + "SYSRES_CONST_SELECT_TYPE_SELECTABLE_ONLY_CHILD "
    + "SYSRES_CONST_SELECT_TYPE_SELECTABLE_WITH_CHILD "
    + "SYSRES_CONST_SELECT_TYPE_UNSLECTABLE "
    + "SYSRES_CONST_SERVER_TYPE_MAIN "
    + "SYSRES_CONST_SERVICE_USER_CATEGORY_FIELD_VALUE "
    + "SYSRES_CONST_SETTINGS_USER_REQUISITE_CODE "
    + "SYSRES_CONST_SIGNATURE_AND_ENCODE_CERTIFICATE_TYPE_CODE "
    + "SYSRES_CONST_SIGNATURE_CERTIFICATE_TYPE_CODE "
    + "SYSRES_CONST_SINGULAR_TITLE_REQUISITE_CODE "
    + "SYSRES_CONST_SQL_SERVER_AUTHENTIFICATION_FLAG_VALUE_CODE "
    + "SYSRES_CONST_SQL_SERVER_ENCODE_AUTHENTIFICATION_FLAG_VALUE_CODE "
    + "SYSRES_CONST_STANDART_ROUTE_REFERENCE_CODE "
    + "SYSRES_CONST_STANDART_ROUTE_REFERENCE_COMMENT_REQUISITE_CODE "
    + "SYSRES_CONST_STANDART_ROUTES_GROUPS_REFERENCE_CODE "
    + "SYSRES_CONST_STATE_REQ_NAME "
    + "SYSRES_CONST_STATE_REQUISITE_ACTIVE_VALUE "
    + "SYSRES_CONST_STATE_REQUISITE_CLOSED_VALUE "
    + "SYSRES_CONST_STATE_REQUISITE_CODE "
    + "SYSRES_CONST_STATIC_ROLE_TYPE_CODE "
    + "SYSRES_CONST_STATUS_PLAN_DEFAULT_VALUE "
    + "SYSRES_CONST_STATUS_VALUE_AUTOCLEANING "
    + "SYSRES_CONST_STATUS_VALUE_BLUE_SQUARE "
    + "SYSRES_CONST_STATUS_VALUE_COMPLETE "
    + "SYSRES_CONST_STATUS_VALUE_GREEN_SQUARE "
    + "SYSRES_CONST_STATUS_VALUE_ORANGE_SQUARE "
    + "SYSRES_CONST_STATUS_VALUE_PURPLE_SQUARE "
    + "SYSRES_CONST_STATUS_VALUE_RED_SQUARE "
    + "SYSRES_CONST_STATUS_VALUE_SUSPEND "
    + "SYSRES_CONST_STATUS_VALUE_YELLOW_SQUARE "
    + "SYSRES_CONST_STDROUTE_SHOW_TO_USERS_REQUISITE_CODE "
    + "SYSRES_CONST_STORAGE_TYPE_FILE "
    + "SYSRES_CONST_STORAGE_TYPE_SQL_SERVER "
    + "SYSRES_CONST_STR_REQUISITE "
    + "SYSRES_CONST_STRIKEOUT_LIFE_CYCLE_STAGE_DRAW_STYLE "
    + "SYSRES_CONST_STRING_FORMAT_LEFT_ALIGN_CHAR "
    + "SYSRES_CONST_STRING_FORMAT_RIGHT_ALIGN_CHAR "
    + "SYSRES_CONST_STRING_REQUISITE_CODE "
    + "SYSRES_CONST_STRING_REQUISITE_TYPE "
    + "SYSRES_CONST_STRING_TYPE_CHAR "
    + "SYSRES_CONST_SUBSTITUTES_PSEUDOREFERENCE_CODE "
    + "SYSRES_CONST_SUBTASK_BLOCK_DESCRIPTION "
    + "SYSRES_CONST_SYSTEM_SETTING_CURRENT_USER_PARAM_VALUE "
    + "SYSRES_CONST_SYSTEM_SETTING_EMPTY_VALUE_PARAM_VALUE "
    + "SYSRES_CONST_SYSTEM_VERSION_COMMENT "
    + "SYSRES_CONST_TASK_ACCESS_TYPE_ALL "
    + "SYSRES_CONST_TASK_ACCESS_TYPE_ALL_MEMBERS "
    + "SYSRES_CONST_TASK_ACCESS_TYPE_MANUAL "
    + "SYSRES_CONST_TASK_ENCODE_TYPE_CERTIFICATION "
    + "SYSRES_CONST_TASK_ENCODE_TYPE_CERTIFICATION_AND_PASSWORD "
    + "SYSRES_CONST_TASK_ENCODE_TYPE_NONE "
    + "SYSRES_CONST_TASK_ENCODE_TYPE_PASSWORD "
    + "SYSRES_CONST_TASK_ROUTE_ALL_CONDITION "
    + "SYSRES_CONST_TASK_ROUTE_AND_CONDITION "
    + "SYSRES_CONST_TASK_ROUTE_OR_CONDITION "
    + "SYSRES_CONST_TASK_STATE_ABORTED "
    + "SYSRES_CONST_TASK_STATE_COMPLETE "
    + "SYSRES_CONST_TASK_STATE_CONTINUED "
    + "SYSRES_CONST_TASK_STATE_CONTROL "
    + "SYSRES_CONST_TASK_STATE_INIT "
    + "SYSRES_CONST_TASK_STATE_WORKING "
    + "SYSRES_CONST_TASK_TITLE "
    + "SYSRES_CONST_TASK_TYPES_GROUPS_REFERENCE_CODE "
    + "SYSRES_CONST_TASK_TYPES_REFERENCE_CODE "
    + "SYSRES_CONST_TEMPLATES_REFERENCE_CODE "
    + "SYSRES_CONST_TEST_DATE_REQUISITE_NAME "
    + "SYSRES_CONST_TEST_DEV_DATABASE_NAME "
    + "SYSRES_CONST_TEST_DEV_SYSTEM_CODE "
    + "SYSRES_CONST_TEST_EDMS_DATABASE_NAME "
    + "SYSRES_CONST_TEST_EDMS_MAIN_CODE "
    + "SYSRES_CONST_TEST_EDMS_MAIN_DB_NAME "
    + "SYSRES_CONST_TEST_EDMS_SECOND_CODE "
    + "SYSRES_CONST_TEST_EDMS_SECOND_DB_NAME "
    + "SYSRES_CONST_TEST_EDMS_SYSTEM_CODE "
    + "SYSRES_CONST_TEST_NUMERIC_REQUISITE_NAME "
    + "SYSRES_CONST_TEXT_REQUISITE "
    + "SYSRES_CONST_TEXT_REQUISITE_CODE "
    + "SYSRES_CONST_TEXT_REQUISITE_TYPE "
    + "SYSRES_CONST_TEXT_TYPE_CHAR "
    + "SYSRES_CONST_TYPE_CODE_REQUISITE_CODE "
    + "SYSRES_CONST_TYPE_REQUISITE_CODE "
    + "SYSRES_CONST_UNDEFINED_LIFE_CYCLE_STAGE_FONT_COLOR "
    + "SYSRES_CONST_UNITS_SECTION_ID_REQUISITE_CODE "
    + "SYSRES_CONST_UNITS_SECTION_REQUISITE_CODE "
    + "SYSRES_CONST_UNOPERATING_RECORD_FLAG_VALUE_CODE "
    + "SYSRES_CONST_UNSTORED_DATA_REQUISITE_CODE "
    + "SYSRES_CONST_UNSTORED_DATA_REQUISITE_NAME "
    + "SYSRES_CONST_USE_ACCESS_TYPE_CODE "
    + "SYSRES_CONST_USE_ACCESS_TYPE_NAME "
    + "SYSRES_CONST_USER_ACCOUNT_TYPE_VALUE_CODE "
    + "SYSRES_CONST_USER_ADDITIONAL_INFORMATION_REQUISITE_CODE "
    + "SYSRES_CONST_USER_AND_GROUP_ID_FROM_PSEUDOREFERENCE_REQUISITE_CODE "
    + "SYSRES_CONST_USER_CATEGORY_NORMAL "
    + "SYSRES_CONST_USER_CERTIFICATE_REQUISITE_CODE "
    + "SYSRES_CONST_USER_CERTIFICATE_STATE_REQUISITE_CODE "
    + "SYSRES_CONST_USER_CERTIFICATE_SUBJECT_NAME_REQUISITE_CODE "
    + "SYSRES_CONST_USER_CERTIFICATE_THUMBPRINT_REQUISITE_CODE "
    + "SYSRES_CONST_USER_COMMON_CATEGORY "
    + "SYSRES_CONST_USER_COMMON_CATEGORY_CODE "
    + "SYSRES_CONST_USER_FULL_NAME_REQUISITE_CODE "
    + "SYSRES_CONST_USER_GROUP_TYPE_REQUISITE_CODE "
    + "SYSRES_CONST_USER_LOGIN_REQUISITE_CODE "
    + "SYSRES_CONST_USER_REMOTE_CONTROLLER_REQUISITE_CODE "
    + "SYSRES_CONST_USER_REMOTE_SYSTEM_REQUISITE_CODE "
    + "SYSRES_CONST_USER_RIGHTS_T_REQUISITE_CODE "
    + "SYSRES_CONST_USER_SERVER_NAME_REQUISITE_CODE "
    + "SYSRES_CONST_USER_SERVICE_CATEGORY "
    + "SYSRES_CONST_USER_SERVICE_CATEGORY_CODE "
    + "SYSRES_CONST_USER_STATUS_ADMINISTRATOR_CODE "
    + "SYSRES_CONST_USER_STATUS_ADMINISTRATOR_NAME "
    + "SYSRES_CONST_USER_STATUS_DEVELOPER_CODE "
    + "SYSRES_CONST_USER_STATUS_DEVELOPER_NAME "
    + "SYSRES_CONST_USER_STATUS_DISABLED_CODE "
    + "SYSRES_CONST_USER_STATUS_DISABLED_NAME "
    + "SYSRES_CONST_USER_STATUS_SYSTEM_DEVELOPER_CODE "
    + "SYSRES_CONST_USER_STATUS_USER_CODE "
    + "SYSRES_CONST_USER_STATUS_USER_NAME "
    + "SYSRES_CONST_USER_STATUS_USER_NAME_DEPRECATED "
    + "SYSRES_CONST_USER_TYPE_FIELD_VALUE_USER "
    + "SYSRES_CONST_USER_TYPE_REQUISITE_CODE "
    + "SYSRES_CONST_USERS_CONTROLLER_REQUISITE_CODE "
    + "SYSRES_CONST_USERS_IS_MAIN_SERVER_REQUISITE_CODE "
    + "SYSRES_CONST_USERS_REFERENCE_CODE "
    + "SYSRES_CONST_USERS_REGISTRATION_CERTIFICATES_ACTION_NAME "
    + "SYSRES_CONST_USERS_REQUISITE_CODE "
    + "SYSRES_CONST_USERS_SYSTEM_REQUISITE_CODE "
    + "SYSRES_CONST_USERS_USER_ACCESS_RIGHTS_TYPR_REQUISITE_CODE "
    + "SYSRES_CONST_USERS_USER_AUTHENTICATION_REQUISITE_CODE "
    + "SYSRES_CONST_USERS_USER_COMPONENT_REQUISITE_CODE "
    + "SYSRES_CONST_USERS_USER_GROUP_REQUISITE_CODE "
    + "SYSRES_CONST_USERS_VIEW_CERTIFICATES_ACTION_NAME "
    + "SYSRES_CONST_VIEW_DEFAULT_CODE "
    + "SYSRES_CONST_VIEW_DEFAULT_NAME "
    + "SYSRES_CONST_VIEWER_REQUISITE_CODE "
    + "SYSRES_CONST_WAITING_BLOCK_DESCRIPTION "
    + "SYSRES_CONST_WIZARD_FORM_LABEL_TEST_STRING  "
    + "SYSRES_CONST_WIZARD_QUERY_PARAM_HEIGHT_ETALON_STRING "
    + "SYSRES_CONST_WIZARD_REFERENCE_COMMENT_REQUISITE_CODE "
    + "SYSRES_CONST_WORK_RULES_DESCRIPTION_REQUISITE_CODE "
    + "SYSRES_CONST_WORK_TIME_CALENDAR_REFERENCE_CODE "
    + "SYSRES_CONST_WORK_WORKFLOW_HARD_ROUTE_TYPE_VALUE "
    + "SYSRES_CONST_WORK_WORKFLOW_HARD_ROUTE_TYPE_VALUE_CODE "
    + "SYSRES_CONST_WORK_WORKFLOW_HARD_ROUTE_TYPE_VALUE_CODE_RUS "
    + "SYSRES_CONST_WORK_WORKFLOW_SOFT_ROUTE_TYPE_VALUE_CODE_RUS "
    + "SYSRES_CONST_WORKFLOW_ROUTE_TYPR_HARD "
    + "SYSRES_CONST_WORKFLOW_ROUTE_TYPR_SOFT "
    + "SYSRES_CONST_XML_ENCODING "
    + "SYSRES_CONST_XREC_STAT_REQUISITE_CODE "
    + "SYSRES_CONST_XRECID_FIELD_NAME "
    + "SYSRES_CONST_YES "
    + "SYSRES_CONST_YES_NO_2_REQUISITE_CODE "
    + "SYSRES_CONST_YES_NO_REQUISITE_CODE "
    + "SYSRES_CONST_YES_NO_T_REF_TYPE_REQUISITE_CODE "
    + "SYSRES_CONST_YES_PICK_VALUE "
    + "SYSRES_CONST_YES_VALUE ";

  // Base constant
  const base_constants = "CR FALSE nil NO_VALUE NULL TAB TRUE YES_VALUE ";

  // Base group name
  const base_group_name_constants =
    "ADMINISTRATORS_GROUP_NAME CUSTOMIZERS_GROUP_NAME DEVELOPERS_GROUP_NAME SERVICE_USERS_GROUP_NAME ";

  // Decision block properties
  const decision_block_properties_constants =
    "DECISION_BLOCK_FIRST_OPERAND_PROPERTY DECISION_BLOCK_NAME_PROPERTY DECISION_BLOCK_OPERATION_PROPERTY "
    + "DECISION_BLOCK_RESULT_TYPE_PROPERTY DECISION_BLOCK_SECOND_OPERAND_PROPERTY ";

  // File extension
  const file_extension_constants =
    "ANY_FILE_EXTENTION COMPRESSED_DOCUMENT_EXTENSION EXTENDED_DOCUMENT_EXTENSION "
    + "SHORT_COMPRESSED_DOCUMENT_EXTENSION SHORT_EXTENDED_DOCUMENT_EXTENSION ";

  // Job block properties
  const job_block_properties_constants =
    "JOB_BLOCK_ABORT_DEADLINE_PROPERTY "
    + "JOB_BLOCK_AFTER_FINISH_EVENT "
    + "JOB_BLOCK_AFTER_QUERY_PARAMETERS_EVENT "
    + "JOB_BLOCK_ATTACHMENT_PROPERTY "
    + "JOB_BLOCK_ATTACHMENTS_RIGHTS_GROUP_PROPERTY "
    + "JOB_BLOCK_ATTACHMENTS_RIGHTS_TYPE_PROPERTY "
    + "JOB_BLOCK_BEFORE_QUERY_PARAMETERS_EVENT "
    + "JOB_BLOCK_BEFORE_START_EVENT "
    + "JOB_BLOCK_CREATED_JOBS_PROPERTY "
    + "JOB_BLOCK_DEADLINE_PROPERTY "
    + "JOB_BLOCK_EXECUTION_RESULTS_PROPERTY "
    + "JOB_BLOCK_IS_PARALLEL_PROPERTY "
    + "JOB_BLOCK_IS_RELATIVE_ABORT_DEADLINE_PROPERTY "
    + "JOB_BLOCK_IS_RELATIVE_DEADLINE_PROPERTY "
    + "JOB_BLOCK_JOB_TEXT_PROPERTY "
    + "JOB_BLOCK_NAME_PROPERTY "
    + "JOB_BLOCK_NEED_SIGN_ON_PERFORM_PROPERTY "
    + "JOB_BLOCK_PERFORMER_PROPERTY "
    + "JOB_BLOCK_RELATIVE_ABORT_DEADLINE_TYPE_PROPERTY "
    + "JOB_BLOCK_RELATIVE_DEADLINE_TYPE_PROPERTY "
    + "JOB_BLOCK_SUBJECT_PROPERTY ";

  // Language code
  const language_code_constants = "ENGLISH_LANGUAGE_CODE RUSSIAN_LANGUAGE_CODE ";

  // Launching external applications
  const launching_external_applications_constants =
    "smHidden smMaximized smMinimized smNormal wmNo wmYes ";

  // Link kind
  const link_kind_constants =
    "COMPONENT_TOKEN_LINK_KIND "
    + "DOCUMENT_LINK_KIND "
    + "EDOCUMENT_LINK_KIND "
    + "FOLDER_LINK_KIND "
    + "JOB_LINK_KIND "
    + "REFERENCE_LINK_KIND "
    + "TASK_LINK_KIND ";

  // Lock type
  const lock_type_constants =
    "COMPONENT_TOKEN_LOCK_TYPE EDOCUMENT_VERSION_LOCK_TYPE ";

  // Monitor block properties
  const monitor_block_properties_constants =
    "MONITOR_BLOCK_AFTER_FINISH_EVENT "
    + "MONITOR_BLOCK_BEFORE_START_EVENT "
    + "MONITOR_BLOCK_DEADLINE_PROPERTY "
    + "MONITOR_BLOCK_INTERVAL_PROPERTY "
    + "MONITOR_BLOCK_INTERVAL_TYPE_PROPERTY "
    + "MONITOR_BLOCK_IS_RELATIVE_DEADLINE_PROPERTY "
    + "MONITOR_BLOCK_NAME_PROPERTY "
    + "MONITOR_BLOCK_RELATIVE_DEADLINE_TYPE_PROPERTY "
    + "MONITOR_BLOCK_SEARCH_SCRIPT_PROPERTY ";

  // Notice block properties
  const notice_block_properties_constants =
    "NOTICE_BLOCK_AFTER_FINISH_EVENT "
    + "NOTICE_BLOCK_ATTACHMENT_PROPERTY "
    + "NOTICE_BLOCK_ATTACHMENTS_RIGHTS_GROUP_PROPERTY "
    + "NOTICE_BLOCK_ATTACHMENTS_RIGHTS_TYPE_PROPERTY "
    + "NOTICE_BLOCK_BEFORE_START_EVENT "
    + "NOTICE_BLOCK_CREATED_NOTICES_PROPERTY "
    + "NOTICE_BLOCK_DEADLINE_PROPERTY "
    + "NOTICE_BLOCK_IS_RELATIVE_DEADLINE_PROPERTY "
    + "NOTICE_BLOCK_NAME_PROPERTY "
    + "NOTICE_BLOCK_NOTICE_TEXT_PROPERTY "
    + "NOTICE_BLOCK_PERFORMER_PROPERTY "
    + "NOTICE_BLOCK_RELATIVE_DEADLINE_TYPE_PROPERTY "
    + "NOTICE_BLOCK_SUBJECT_PROPERTY ";

  // Object events
  const object_events_constants =
    "dseAfterCancel "
    + "dseAfterClose "
    + "dseAfterDelete "
    + "dseAfterDeleteOutOfTransaction "
    + "dseAfterInsert "
    + "dseAfterOpen "
    + "dseAfterScroll "
    + "dseAfterUpdate "
    + "dseAfterUpdateOutOfTransaction "
    + "dseBeforeCancel "
    + "dseBeforeClose "
    + "dseBeforeDelete "
    + "dseBeforeDetailUpdate "
    + "dseBeforeInsert "
    + "dseBeforeOpen "
    + "dseBeforeUpdate "
    + "dseOnAnyRequisiteChange "
    + "dseOnCloseRecord "
    + "dseOnDeleteError "
    + "dseOnOpenRecord "
    + "dseOnPrepareUpdate "
    + "dseOnUpdateError "
    + "dseOnUpdateRatifiedRecord "
    + "dseOnValidDelete "
    + "dseOnValidUpdate "
    + "reOnChange "
    + "reOnChangeValues "
    + "SELECTION_BEGIN_ROUTE_EVENT "
    + "SELECTION_END_ROUTE_EVENT ";

  // Object params
  const object_params_constants =
    "CURRENT_PERIOD_IS_REQUIRED "
    + "PREVIOUS_CARD_TYPE_NAME "
    + "SHOW_RECORD_PROPERTIES_FORM ";

  // Other
  const other_constants =
    "ACCESS_RIGHTS_SETTING_DIALOG_CODE "
    + "ADMINISTRATOR_USER_CODE "
    + "ANALYTIC_REPORT_TYPE "
    + "asrtHideLocal "
    + "asrtHideRemote "
    + "CALCULATED_ROLE_TYPE_CODE "
    + "COMPONENTS_REFERENCE_DEVELOPER_VIEW_CODE "
    + "DCTS_TEST_PROTOCOLS_FOLDER_PATH "
    + "E_EDOC_VERSION_ALREADY_APPROVINGLY_SIGNED "
    + "E_EDOC_VERSION_ALREADY_APPROVINGLY_SIGNED_BY_USER "
    + "E_EDOC_VERSION_ALREDY_SIGNED "
    + "E_EDOC_VERSION_ALREDY_SIGNED_BY_USER "
    + "EDOC_TYPES_CODE_REQUISITE_FIELD_NAME "
    + "EDOCUMENTS_ALIAS_NAME "
    + "FILES_FOLDER_PATH "
    + "FILTER_OPERANDS_DELIMITER "
    + "FILTER_OPERATIONS_DELIMITER "
    + "FORMCARD_NAME "
    + "FORMLIST_NAME "
    + "GET_EXTENDED_DOCUMENT_EXTENSION_CREATION_MODE "
    + "GET_EXTENDED_DOCUMENT_EXTENSION_IMPORT_MODE "
    + "INTEGRATED_REPORT_TYPE "
    + "IS_BUILDER_APPLICATION_ROLE "
    + "IS_BUILDER_APPLICATION_ROLE2 "
    + "IS_BUILDER_USERS "
    + "ISBSYSDEV "
    + "LOG_FOLDER_PATH "
    + "mbCancel "
    + "mbNo "
    + "mbNoToAll "
    + "mbOK "
    + "mbYes "
    + "mbYesToAll "
    + "MEMORY_DATASET_DESRIPTIONS_FILENAME "
    + "mrNo "
    + "mrNoToAll "
    + "mrYes "
    + "mrYesToAll "
    + "MULTIPLE_SELECT_DIALOG_CODE "
    + "NONOPERATING_RECORD_FLAG_FEMININE "
    + "NONOPERATING_RECORD_FLAG_MASCULINE "
    + "OPERATING_RECORD_FLAG_FEMININE "
    + "OPERATING_RECORD_FLAG_MASCULINE "
    + "PROFILING_SETTINGS_COMMON_SETTINGS_CODE_VALUE "
    + "PROGRAM_INITIATED_LOOKUP_ACTION "
    + "ratDelete "
    + "ratEdit "
    + "ratInsert "
    + "REPORT_TYPE "
    + "REQUIRED_PICK_VALUES_VARIABLE "
    + "rmCard "
    + "rmList "
    + "SBRTE_PROGID_DEV "
    + "SBRTE_PROGID_RELEASE "
    + "STATIC_ROLE_TYPE_CODE "
    + "SUPPRESS_EMPTY_TEMPLATE_CREATION "
    + "SYSTEM_USER_CODE "
    + "UPDATE_DIALOG_DATASET "
    + "USED_IN_OBJECT_HINT_PARAM "
    + "USER_INITIATED_LOOKUP_ACTION "
    + "USER_NAME_FORMAT "
    + "USER_SELECTION_RESTRICTIONS "
    + "WORKFLOW_TEST_PROTOCOLS_FOLDER_PATH "
    + "ELS_SUBTYPE_CONTROL_NAME "
    + "ELS_FOLDER_KIND_CONTROL_NAME "
    + "REPEAT_PROCESS_CURRENT_OBJECT_EXCEPTION_NAME ";

  // Privileges
  const privileges_constants =
    "PRIVILEGE_COMPONENT_FULL_ACCESS "
    + "PRIVILEGE_DEVELOPMENT_EXPORT "
    + "PRIVILEGE_DEVELOPMENT_IMPORT "
    + "PRIVILEGE_DOCUMENT_DELETE "
    + "PRIVILEGE_ESD "
    + "PRIVILEGE_FOLDER_DELETE "
    + "PRIVILEGE_MANAGE_ACCESS_RIGHTS "
    + "PRIVILEGE_MANAGE_REPLICATION "
    + "PRIVILEGE_MANAGE_SESSION_SERVER "
    + "PRIVILEGE_OBJECT_FULL_ACCESS "
    + "PRIVILEGE_OBJECT_VIEW "
    + "PRIVILEGE_RESERVE_LICENSE "
    + "PRIVILEGE_SYSTEM_CUSTOMIZE "
    + "PRIVILEGE_SYSTEM_DEVELOP "
    + "PRIVILEGE_SYSTEM_INSTALL "
    + "PRIVILEGE_TASK_DELETE "
    + "PRIVILEGE_USER_PLUGIN_SETTINGS_CUSTOMIZE "
    + "PRIVILEGES_PSEUDOREFERENCE_CODE ";

  // Pseudoreference code
  const pseudoreference_code_constants =
    "ACCESS_TYPES_PSEUDOREFERENCE_CODE "
    + "ALL_AVAILABLE_COMPONENTS_PSEUDOREFERENCE_CODE "
    + "ALL_AVAILABLE_PRIVILEGES_PSEUDOREFERENCE_CODE "
    + "ALL_REPLICATE_COMPONENTS_PSEUDOREFERENCE_CODE "
    + "AVAILABLE_DEVELOPERS_COMPONENTS_PSEUDOREFERENCE_CODE "
    + "COMPONENTS_PSEUDOREFERENCE_CODE "
    + "FILTRATER_SETTINGS_CONFLICTS_PSEUDOREFERENCE_CODE "
    + "GROUPS_PSEUDOREFERENCE_CODE "
    + "RECEIVE_PROTOCOL_PSEUDOREFERENCE_CODE "
    + "REFERENCE_REQUISITE_PSEUDOREFERENCE_CODE "
    + "REFERENCE_REQUISITES_PSEUDOREFERENCE_CODE "
    + "REFTYPES_PSEUDOREFERENCE_CODE "
    + "REPLICATION_SEANCES_DIARY_PSEUDOREFERENCE_CODE "
    + "SEND_PROTOCOL_PSEUDOREFERENCE_CODE "
    + "SUBSTITUTES_PSEUDOREFERENCE_CODE "
    + "SYSTEM_SETTINGS_PSEUDOREFERENCE_CODE "
    + "UNITS_PSEUDOREFERENCE_CODE "
    + "USERS_PSEUDOREFERENCE_CODE "
    + "VIEWERS_PSEUDOREFERENCE_CODE ";

  // Requisite ISBCertificateType values
  const requisite_ISBCertificateType_values_constants =
    "CERTIFICATE_TYPE_ENCRYPT "
    + "CERTIFICATE_TYPE_SIGN "
    + "CERTIFICATE_TYPE_SIGN_AND_ENCRYPT ";

  // Requisite ISBEDocStorageType values
  const requisite_ISBEDocStorageType_values_constants =
    "STORAGE_TYPE_FILE "
    + "STORAGE_TYPE_NAS_CIFS "
    + "STORAGE_TYPE_SAPERION "
    + "STORAGE_TYPE_SQL_SERVER ";

  // Requisite CompType2 values
  const requisite_compType2_values_constants =
    "COMPTYPE2_REQUISITE_DOCUMENTS_VALUE "
    + "COMPTYPE2_REQUISITE_TASKS_VALUE "
    + "COMPTYPE2_REQUISITE_FOLDERS_VALUE "
    + "COMPTYPE2_REQUISITE_REFERENCES_VALUE ";

  // Requisite name
  const requisite_name_constants =
    "SYSREQ_CODE "
    + "SYSREQ_COMPTYPE2 "
    + "SYSREQ_CONST_AVAILABLE_FOR_WEB "
    + "SYSREQ_CONST_COMMON_CODE "
    + "SYSREQ_CONST_COMMON_VALUE "
    + "SYSREQ_CONST_FIRM_CODE "
    + "SYSREQ_CONST_FIRM_STATUS "
    + "SYSREQ_CONST_FIRM_VALUE "
    + "SYSREQ_CONST_SERVER_STATUS "
    + "SYSREQ_CONTENTS "
    + "SYSREQ_DATE_OPEN "
    + "SYSREQ_DATE_CLOSE "
    + "SYSREQ_DESCRIPTION "
    + "SYSREQ_DESCRIPTION_LOCALIZE_ID "
    + "SYSREQ_DOUBLE "
    + "SYSREQ_EDOC_ACCESS_TYPE "
    + "SYSREQ_EDOC_AUTHOR "
    + "SYSREQ_EDOC_CREATED "
    + "SYSREQ_EDOC_DELEGATE_RIGHTS_REQUISITE_CODE "
    + "SYSREQ_EDOC_EDITOR "
    + "SYSREQ_EDOC_ENCODE_TYPE "
    + "SYSREQ_EDOC_ENCRYPTION_PLUGIN_NAME "
    + "SYSREQ_EDOC_ENCRYPTION_PLUGIN_VERSION "
    + "SYSREQ_EDOC_EXPORT_DATE "
    + "SYSREQ_EDOC_EXPORTER "
    + "SYSREQ_EDOC_KIND "
    + "SYSREQ_EDOC_LIFE_STAGE_NAME "
    + "SYSREQ_EDOC_LOCKED_FOR_SERVER_CODE "
    + "SYSREQ_EDOC_MODIFIED "
    + "SYSREQ_EDOC_NAME "
    + "SYSREQ_EDOC_NOTE "
    + "SYSREQ_EDOC_QUALIFIED_ID "
    + "SYSREQ_EDOC_SESSION_KEY "
    + "SYSREQ_EDOC_SESSION_KEY_ENCRYPTION_PLUGIN_NAME "
    + "SYSREQ_EDOC_SESSION_KEY_ENCRYPTION_PLUGIN_VERSION "
    + "SYSREQ_EDOC_SIGNATURE_TYPE "
    + "SYSREQ_EDOC_SIGNED "
    + "SYSREQ_EDOC_STORAGE "
    + "SYSREQ_EDOC_STORAGES_ARCHIVE_STORAGE "
    + "SYSREQ_EDOC_STORAGES_CHECK_RIGHTS "
    + "SYSREQ_EDOC_STORAGES_COMPUTER_NAME "
    + "SYSREQ_EDOC_STORAGES_EDIT_IN_STORAGE "
    + "SYSREQ_EDOC_STORAGES_EXECUTIVE_STORAGE "
    + "SYSREQ_EDOC_STORAGES_FUNCTION "
    + "SYSREQ_EDOC_STORAGES_INITIALIZED "
    + "SYSREQ_EDOC_STORAGES_LOCAL_PATH "
    + "SYSREQ_EDOC_STORAGES_SAPERION_DATABASE_NAME "
    + "SYSREQ_EDOC_STORAGES_SEARCH_BY_TEXT "
    + "SYSREQ_EDOC_STORAGES_SERVER_NAME "
    + "SYSREQ_EDOC_STORAGES_SHARED_SOURCE_NAME "
    + "SYSREQ_EDOC_STORAGES_TYPE "
    + "SYSREQ_EDOC_TEXT_MODIFIED "
    + "SYSREQ_EDOC_TYPE_ACT_CODE "
    + "SYSREQ_EDOC_TYPE_ACT_DESCRIPTION "
    + "SYSREQ_EDOC_TYPE_ACT_DESCRIPTION_LOCALIZE_ID "
    + "SYSREQ_EDOC_TYPE_ACT_ON_EXECUTE "
    + "SYSREQ_EDOC_TYPE_ACT_ON_EXECUTE_EXISTS "
    + "SYSREQ_EDOC_TYPE_ACT_SECTION "
    + "SYSREQ_EDOC_TYPE_ADD_PARAMS "
    + "SYSREQ_EDOC_TYPE_COMMENT "
    + "SYSREQ_EDOC_TYPE_EVENT_TEXT "
    + "SYSREQ_EDOC_TYPE_NAME_IN_SINGULAR "
    + "SYSREQ_EDOC_TYPE_NAME_IN_SINGULAR_LOCALIZE_ID "
    + "SYSREQ_EDOC_TYPE_NAME_LOCALIZE_ID "
    + "SYSREQ_EDOC_TYPE_NUMERATION_METHOD "
    + "SYSREQ_EDOC_TYPE_PSEUDO_REQUISITE_CODE "
    + "SYSREQ_EDOC_TYPE_REQ_CODE "
    + "SYSREQ_EDOC_TYPE_REQ_DESCRIPTION "
    + "SYSREQ_EDOC_TYPE_REQ_DESCRIPTION_LOCALIZE_ID "
    + "SYSREQ_EDOC_TYPE_REQ_IS_LEADING "
    + "SYSREQ_EDOC_TYPE_REQ_IS_REQUIRED "
    + "SYSREQ_EDOC_TYPE_REQ_NUMBER "
    + "SYSREQ_EDOC_TYPE_REQ_ON_CHANGE "
    + "SYSREQ_EDOC_TYPE_REQ_ON_CHANGE_EXISTS "
    + "SYSREQ_EDOC_TYPE_REQ_ON_SELECT "
    + "SYSREQ_EDOC_TYPE_REQ_ON_SELECT_KIND "
    + "SYSREQ_EDOC_TYPE_REQ_SECTION "
    + "SYSREQ_EDOC_TYPE_VIEW_CARD "
    + "SYSREQ_EDOC_TYPE_VIEW_CODE "
    + "SYSREQ_EDOC_TYPE_VIEW_COMMENT "
    + "SYSREQ_EDOC_TYPE_VIEW_IS_MAIN "
    + "SYSREQ_EDOC_TYPE_VIEW_NAME "
    + "SYSREQ_EDOC_TYPE_VIEW_NAME_LOCALIZE_ID "
    + "SYSREQ_EDOC_VERSION_AUTHOR "
    + "SYSREQ_EDOC_VERSION_CRC "
    + "SYSREQ_EDOC_VERSION_DATA "
    + "SYSREQ_EDOC_VERSION_EDITOR "
    + "SYSREQ_EDOC_VERSION_EXPORT_DATE "
    + "SYSREQ_EDOC_VERSION_EXPORTER "
    + "SYSREQ_EDOC_VERSION_HIDDEN "
    + "SYSREQ_EDOC_VERSION_LIFE_STAGE "
    + "SYSREQ_EDOC_VERSION_MODIFIED "
    + "SYSREQ_EDOC_VERSION_NOTE "
    + "SYSREQ_EDOC_VERSION_SIGNATURE_TYPE "
    + "SYSREQ_EDOC_VERSION_SIGNED "
    + "SYSREQ_EDOC_VERSION_SIZE "
    + "SYSREQ_EDOC_VERSION_SOURCE "
    + "SYSREQ_EDOC_VERSION_TEXT_MODIFIED "
    + "SYSREQ_EDOCKIND_DEFAULT_VERSION_STATE_CODE "
    + "SYSREQ_FOLDER_KIND "
    + "SYSREQ_FUNC_CATEGORY "
    + "SYSREQ_FUNC_COMMENT "
    + "SYSREQ_FUNC_GROUP "
    + "SYSREQ_FUNC_GROUP_COMMENT "
    + "SYSREQ_FUNC_GROUP_NUMBER "
    + "SYSREQ_FUNC_HELP "
    + "SYSREQ_FUNC_PARAM_DEF_VALUE "
    + "SYSREQ_FUNC_PARAM_IDENT "
    + "SYSREQ_FUNC_PARAM_NUMBER "
    + "SYSREQ_FUNC_PARAM_TYPE "
    + "SYSREQ_FUNC_TEXT "
    + "SYSREQ_GROUP_CATEGORY "
    + "SYSREQ_ID "
    + "SYSREQ_LAST_UPDATE "
    + "SYSREQ_LEADER_REFERENCE "
    + "SYSREQ_LINE_NUMBER "
    + "SYSREQ_MAIN_RECORD_ID "
    + "SYSREQ_NAME "
    + "SYSREQ_NAME_LOCALIZE_ID "
    + "SYSREQ_NOTE "
    + "SYSREQ_ORIGINAL_RECORD "
    + "SYSREQ_OUR_FIRM "
    + "SYSREQ_PROFILING_SETTINGS_BATCH_LOGING "
    + "SYSREQ_PROFILING_SETTINGS_BATCH_SIZE "
    + "SYSREQ_PROFILING_SETTINGS_PROFILING_ENABLED "
    + "SYSREQ_PROFILING_SETTINGS_SQL_PROFILING_ENABLED "
    + "SYSREQ_PROFILING_SETTINGS_START_LOGGED "
    + "SYSREQ_RECORD_STATUS "
    + "SYSREQ_REF_REQ_FIELD_NAME "
    + "SYSREQ_REF_REQ_FORMAT "
    + "SYSREQ_REF_REQ_GENERATED "
    + "SYSREQ_REF_REQ_LENGTH "
    + "SYSREQ_REF_REQ_PRECISION "
    + "SYSREQ_REF_REQ_REFERENCE "
    + "SYSREQ_REF_REQ_SECTION "
    + "SYSREQ_REF_REQ_STORED "
    + "SYSREQ_REF_REQ_TOKENS "
    + "SYSREQ_REF_REQ_TYPE "
    + "SYSREQ_REF_REQ_VIEW "
    + "SYSREQ_REF_TYPE_ACT_CODE "
    + "SYSREQ_REF_TYPE_ACT_DESCRIPTION "
    + "SYSREQ_REF_TYPE_ACT_DESCRIPTION_LOCALIZE_ID "
    + "SYSREQ_REF_TYPE_ACT_ON_EXECUTE "
    + "SYSREQ_REF_TYPE_ACT_ON_EXECUTE_EXISTS "
    + "SYSREQ_REF_TYPE_ACT_SECTION "
    + "SYSREQ_REF_TYPE_ADD_PARAMS "
    + "SYSREQ_REF_TYPE_COMMENT "
    + "SYSREQ_REF_TYPE_COMMON_SETTINGS "
    + "SYSREQ_REF_TYPE_DISPLAY_REQUISITE_NAME "
    + "SYSREQ_REF_TYPE_EVENT_TEXT "
    + "SYSREQ_REF_TYPE_MAIN_LEADING_REF "
    + "SYSREQ_REF_TYPE_NAME_IN_SINGULAR "
    + "SYSREQ_REF_TYPE_NAME_IN_SINGULAR_LOCALIZE_ID "
    + "SYSREQ_REF_TYPE_NAME_LOCALIZE_ID "
    + "SYSREQ_REF_TYPE_NUMERATION_METHOD "
    + "SYSREQ_REF_TYPE_REQ_CODE "
    + "SYSREQ_REF_TYPE_REQ_DESCRIPTION "
    + "SYSREQ_REF_TYPE_REQ_DESCRIPTION_LOCALIZE_ID "
    + "SYSREQ_REF_TYPE_REQ_IS_CONTROL "
    + "SYSREQ_REF_TYPE_REQ_IS_FILTER "
    + "SYSREQ_REF_TYPE_REQ_IS_LEADING "
    + "SYSREQ_REF_TYPE_REQ_IS_REQUIRED "
    + "SYSREQ_REF_TYPE_REQ_NUMBER "
    + "SYSREQ_REF_TYPE_REQ_ON_CHANGE "
    + "SYSREQ_REF_TYPE_REQ_ON_CHANGE_EXISTS "
    + "SYSREQ_REF_TYPE_REQ_ON_SELECT "
    + "SYSREQ_REF_TYPE_REQ_ON_SELECT_KIND "
    + "SYSREQ_REF_TYPE_REQ_SECTION "
    + "SYSREQ_REF_TYPE_VIEW_CARD "
    + "SYSREQ_REF_TYPE_VIEW_CODE "
    + "SYSREQ_REF_TYPE_VIEW_COMMENT "
    + "SYSREQ_REF_TYPE_VIEW_IS_MAIN "
    + "SYSREQ_REF_TYPE_VIEW_NAME "
    + "SYSREQ_REF_TYPE_VIEW_NAME_LOCALIZE_ID "
    + "SYSREQ_REFERENCE_TYPE_ID "
    + "SYSREQ_STATE "
    + "SYSREQ_STATЕ "
    + "SYSREQ_SYSTEM_SETTINGS_VALUE "
    + "SYSREQ_TYPE "
    + "SYSREQ_UNIT "
    + "SYSREQ_UNIT_ID "
    + "SYSREQ_USER_GROUPS_GROUP_FULL_NAME "
    + "SYSREQ_USER_GROUPS_GROUP_NAME "
    + "SYSREQ_USER_GROUPS_GROUP_SERVER_NAME "
    + "SYSREQ_USERS_ACCESS_RIGHTS "
    + "SYSREQ_USERS_AUTHENTICATION "
    + "SYSREQ_USERS_CATEGORY "
    + "SYSREQ_USERS_COMPONENT "
    + "SYSREQ_USERS_COMPONENT_USER_IS_PUBLIC "
    + "SYSREQ_USERS_DOMAIN "
    + "SYSREQ_USERS_FULL_USER_NAME "
    + "SYSREQ_USERS_GROUP "
    + "SYSREQ_USERS_IS_MAIN_SERVER "
    + "SYSREQ_USERS_LOGIN "
    + "SYSREQ_USERS_REFERENCE_USER_IS_PUBLIC "
    + "SYSREQ_USERS_STATUS "
    + "SYSREQ_USERS_USER_CERTIFICATE "
    + "SYSREQ_USERS_USER_CERTIFICATE_INFO "
    + "SYSREQ_USERS_USER_CERTIFICATE_PLUGIN_NAME "
    + "SYSREQ_USERS_USER_CERTIFICATE_PLUGIN_VERSION "
    + "SYSREQ_USERS_USER_CERTIFICATE_STATE "
    + "SYSREQ_USERS_USER_CERTIFICATE_SUBJECT_NAME "
    + "SYSREQ_USERS_USER_CERTIFICATE_THUMBPRINT "
    + "SYSREQ_USERS_USER_DEFAULT_CERTIFICATE "
    + "SYSREQ_USERS_USER_DESCRIPTION "
    + "SYSREQ_USERS_USER_GLOBAL_NAME "
    + "SYSREQ_USERS_USER_LOGIN "
    + "SYSREQ_USERS_USER_MAIN_SERVER "
    + "SYSREQ_USERS_USER_TYPE "
    + "SYSREQ_WORK_RULES_FOLDER_ID ";

  // Result
  const result_constants = "RESULT_VAR_NAME RESULT_VAR_NAME_ENG ";

  // Rule identification
  const rule_identification_constants =
    "AUTO_NUMERATION_RULE_ID "
    + "CANT_CHANGE_ID_REQUISITE_RULE_ID "
    + "CANT_CHANGE_OURFIRM_REQUISITE_RULE_ID "
    + "CHECK_CHANGING_REFERENCE_RECORD_USE_RULE_ID "
    + "CHECK_CODE_REQUISITE_RULE_ID "
    + "CHECK_DELETING_REFERENCE_RECORD_USE_RULE_ID "
    + "CHECK_FILTRATER_CHANGES_RULE_ID "
    + "CHECK_RECORD_INTERVAL_RULE_ID "
    + "CHECK_REFERENCE_INTERVAL_RULE_ID "
    + "CHECK_REQUIRED_DATA_FULLNESS_RULE_ID "
    + "CHECK_REQUIRED_REQUISITES_FULLNESS_RULE_ID "
    + "MAKE_RECORD_UNRATIFIED_RULE_ID "
    + "RESTORE_AUTO_NUMERATION_RULE_ID "
    + "SET_FIRM_CONTEXT_FROM_RECORD_RULE_ID "
    + "SET_FIRST_RECORD_IN_LIST_FORM_RULE_ID "
    + "SET_IDSPS_VALUE_RULE_ID "
    + "SET_NEXT_CODE_VALUE_RULE_ID "
    + "SET_OURFIRM_BOUNDS_RULE_ID "
    + "SET_OURFIRM_REQUISITE_RULE_ID ";

  // Script block properties
  const script_block_properties_constants =
    "SCRIPT_BLOCK_AFTER_FINISH_EVENT "
    + "SCRIPT_BLOCK_BEFORE_START_EVENT "
    + "SCRIPT_BLOCK_EXECUTION_RESULTS_PROPERTY "
    + "SCRIPT_BLOCK_NAME_PROPERTY "
    + "SCRIPT_BLOCK_SCRIPT_PROPERTY ";

  // Subtask block properties
  const subtask_block_properties_constants =
    "SUBTASK_BLOCK_ABORT_DEADLINE_PROPERTY "
    + "SUBTASK_BLOCK_AFTER_FINISH_EVENT "
    + "SUBTASK_BLOCK_ASSIGN_PARAMS_EVENT "
    + "SUBTASK_BLOCK_ATTACHMENTS_PROPERTY "
    + "SUBTASK_BLOCK_ATTACHMENTS_RIGHTS_GROUP_PROPERTY "
    + "SUBTASK_BLOCK_ATTACHMENTS_RIGHTS_TYPE_PROPERTY "
    + "SUBTASK_BLOCK_BEFORE_START_EVENT "
    + "SUBTASK_BLOCK_CREATED_TASK_PROPERTY "
    + "SUBTASK_BLOCK_CREATION_EVENT "
    + "SUBTASK_BLOCK_DEADLINE_PROPERTY "
    + "SUBTASK_BLOCK_IMPORTANCE_PROPERTY "
    + "SUBTASK_BLOCK_INITIATOR_PROPERTY "
    + "SUBTASK_BLOCK_IS_RELATIVE_ABORT_DEADLINE_PROPERTY "
    + "SUBTASK_BLOCK_IS_RELATIVE_DEADLINE_PROPERTY "
    + "SUBTASK_BLOCK_JOBS_TYPE_PROPERTY "
    + "SUBTASK_BLOCK_NAME_PROPERTY "
    + "SUBTASK_BLOCK_PARALLEL_ROUTE_PROPERTY "
    + "SUBTASK_BLOCK_PERFORMERS_PROPERTY "
    + "SUBTASK_BLOCK_RELATIVE_ABORT_DEADLINE_TYPE_PROPERTY "
    + "SUBTASK_BLOCK_RELATIVE_DEADLINE_TYPE_PROPERTY "
    + "SUBTASK_BLOCK_REQUIRE_SIGN_PROPERTY "
    + "SUBTASK_BLOCK_STANDARD_ROUTE_PROPERTY "
    + "SUBTASK_BLOCK_START_EVENT "
    + "SUBTASK_BLOCK_STEP_CONTROL_PROPERTY "
    + "SUBTASK_BLOCK_SUBJECT_PROPERTY "
    + "SUBTASK_BLOCK_TASK_CONTROL_PROPERTY "
    + "SUBTASK_BLOCK_TEXT_PROPERTY "
    + "SUBTASK_BLOCK_UNLOCK_ATTACHMENTS_ON_STOP_PROPERTY "
    + "SUBTASK_BLOCK_USE_STANDARD_ROUTE_PROPERTY "
    + "SUBTASK_BLOCK_WAIT_FOR_TASK_COMPLETE_PROPERTY ";

  // System component
  const system_component_constants =
    "SYSCOMP_CONTROL_JOBS "
    + "SYSCOMP_FOLDERS "
    + "SYSCOMP_JOBS "
    + "SYSCOMP_NOTICES "
    + "SYSCOMP_TASKS ";

  // System dialogs
  const system_dialogs_constants =
    "SYSDLG_CREATE_EDOCUMENT "
    + "SYSDLG_CREATE_EDOCUMENT_VERSION "
    + "SYSDLG_CURRENT_PERIOD "
    + "SYSDLG_EDIT_FUNCTION_HELP "
    + "SYSDLG_EDOCUMENT_KINDS_FOR_TEMPLATE "
    + "SYSDLG_EXPORT_MULTIPLE_EDOCUMENTS "
    + "SYSDLG_EXPORT_SINGLE_EDOCUMENT "
    + "SYSDLG_IMPORT_EDOCUMENT "
    + "SYSDLG_MULTIPLE_SELECT "
    + "SYSDLG_SETUP_ACCESS_RIGHTS "
    + "SYSDLG_SETUP_DEFAULT_RIGHTS "
    + "SYSDLG_SETUP_FILTER_CONDITION "
    + "SYSDLG_SETUP_SIGN_RIGHTS "
    + "SYSDLG_SETUP_TASK_OBSERVERS "
    + "SYSDLG_SETUP_TASK_ROUTE "
    + "SYSDLG_SETUP_USERS_LIST "
    + "SYSDLG_SIGN_EDOCUMENT "
    + "SYSDLG_SIGN_MULTIPLE_EDOCUMENTS ";

  // System reference names
  const system_reference_names_constants =
    "SYSREF_ACCESS_RIGHTS_TYPES "
    + "SYSREF_ADMINISTRATION_HISTORY "
    + "SYSREF_ALL_AVAILABLE_COMPONENTS "
    + "SYSREF_ALL_AVAILABLE_PRIVILEGES "
    + "SYSREF_ALL_REPLICATING_COMPONENTS "
    + "SYSREF_AVAILABLE_DEVELOPERS_COMPONENTS "
    + "SYSREF_CALENDAR_EVENTS "
    + "SYSREF_COMPONENT_TOKEN_HISTORY "
    + "SYSREF_COMPONENT_TOKENS "
    + "SYSREF_COMPONENTS "
    + "SYSREF_CONSTANTS "
    + "SYSREF_DATA_RECEIVE_PROTOCOL "
    + "SYSREF_DATA_SEND_PROTOCOL "
    + "SYSREF_DIALOGS "
    + "SYSREF_DIALOGS_REQUISITES "
    + "SYSREF_EDITORS "
    + "SYSREF_EDOC_CARDS "
    + "SYSREF_EDOC_TYPES "
    + "SYSREF_EDOCUMENT_CARD_REQUISITES "
    + "SYSREF_EDOCUMENT_CARD_TYPES "
    + "SYSREF_EDOCUMENT_CARD_TYPES_REFERENCE "
    + "SYSREF_EDOCUMENT_CARDS "
    + "SYSREF_EDOCUMENT_HISTORY "
    + "SYSREF_EDOCUMENT_KINDS "
    + "SYSREF_EDOCUMENT_REQUISITES "
    + "SYSREF_EDOCUMENT_SIGNATURES "
    + "SYSREF_EDOCUMENT_TEMPLATES "
    + "SYSREF_EDOCUMENT_TEXT_STORAGES "
    + "SYSREF_EDOCUMENT_VIEWS "
    + "SYSREF_FILTERER_SETUP_CONFLICTS "
    + "SYSREF_FILTRATER_SETTING_CONFLICTS "
    + "SYSREF_FOLDER_HISTORY "
    + "SYSREF_FOLDERS "
    + "SYSREF_FUNCTION_GROUPS "
    + "SYSREF_FUNCTION_PARAMS "
    + "SYSREF_FUNCTIONS "
    + "SYSREF_JOB_HISTORY "
    + "SYSREF_LINKS "
    + "SYSREF_LOCALIZATION_DICTIONARY "
    + "SYSREF_LOCALIZATION_LANGUAGES "
    + "SYSREF_MODULES "
    + "SYSREF_PRIVILEGES "
    + "SYSREF_RECORD_HISTORY "
    + "SYSREF_REFERENCE_REQUISITES "
    + "SYSREF_REFERENCE_TYPE_VIEWS "
    + "SYSREF_REFERENCE_TYPES "
    + "SYSREF_REFERENCES "
    + "SYSREF_REFERENCES_REQUISITES "
    + "SYSREF_REMOTE_SERVERS "
    + "SYSREF_REPLICATION_SESSIONS_LOG "
    + "SYSREF_REPLICATION_SESSIONS_PROTOCOL "
    + "SYSREF_REPORTS "
    + "SYSREF_ROLES "
    + "SYSREF_ROUTE_BLOCK_GROUPS "
    + "SYSREF_ROUTE_BLOCKS "
    + "SYSREF_SCRIPTS "
    + "SYSREF_SEARCHES "
    + "SYSREF_SERVER_EVENTS "
    + "SYSREF_SERVER_EVENTS_HISTORY "
    + "SYSREF_STANDARD_ROUTE_GROUPS "
    + "SYSREF_STANDARD_ROUTES "
    + "SYSREF_STATUSES "
    + "SYSREF_SYSTEM_SETTINGS "
    + "SYSREF_TASK_HISTORY "
    + "SYSREF_TASK_KIND_GROUPS "
    + "SYSREF_TASK_KINDS "
    + "SYSREF_TASK_RIGHTS "
    + "SYSREF_TASK_SIGNATURES "
    + "SYSREF_TASKS "
    + "SYSREF_UNITS "
    + "SYSREF_USER_GROUPS "
    + "SYSREF_USER_GROUPS_REFERENCE "
    + "SYSREF_USER_SUBSTITUTION "
    + "SYSREF_USERS "
    + "SYSREF_USERS_REFERENCE "
    + "SYSREF_VIEWERS "
    + "SYSREF_WORKING_TIME_CALENDARS ";

  // Table name
  const table_name_constants =
    "ACCESS_RIGHTS_TABLE_NAME "
    + "EDMS_ACCESS_TABLE_NAME "
    + "EDOC_TYPES_TABLE_NAME ";

  // Test
  const test_constants =
    "TEST_DEV_DB_NAME "
    + "TEST_DEV_SYSTEM_CODE "
    + "TEST_EDMS_DB_NAME "
    + "TEST_EDMS_MAIN_CODE "
    + "TEST_EDMS_MAIN_DB_NAME "
    + "TEST_EDMS_SECOND_CODE "
    + "TEST_EDMS_SECOND_DB_NAME "
    + "TEST_EDMS_SYSTEM_CODE "
    + "TEST_ISB5_MAIN_CODE "
    + "TEST_ISB5_SECOND_CODE "
    + "TEST_SQL_SERVER_2005_NAME "
    + "TEST_SQL_SERVER_NAME ";

  // Using the dialog windows
  const using_the_dialog_windows_constants =
    "ATTENTION_CAPTION "
    + "cbsCommandLinks "
    + "cbsDefault "
    + "CONFIRMATION_CAPTION "
    + "ERROR_CAPTION "
    + "INFORMATION_CAPTION "
    + "mrCancel "
    + "mrOk ";

  // Using the document
  const using_the_document_constants =
    "EDOC_VERSION_ACTIVE_STAGE_CODE "
    + "EDOC_VERSION_DESIGN_STAGE_CODE "
    + "EDOC_VERSION_OBSOLETE_STAGE_CODE ";

  // Using the EA and encryption
  const using_the_EA_and_encryption_constants =
    "cpDataEnciphermentEnabled "
    + "cpDigitalSignatureEnabled "
    + "cpID "
    + "cpIssuer "
    + "cpPluginVersion "
    + "cpSerial "
    + "cpSubjectName "
    + "cpSubjSimpleName "
    + "cpValidFromDate "
    + "cpValidToDate ";

  // Using the ISBL-editor
  const using_the_ISBL_editor_constants =
    "ISBL_SYNTAX " + "NO_SYNTAX " + "XML_SYNTAX ";

  // Wait block properties
  const wait_block_properties_constants =
    "WAIT_BLOCK_AFTER_FINISH_EVENT "
    + "WAIT_BLOCK_BEFORE_START_EVENT "
    + "WAIT_BLOCK_DEADLINE_PROPERTY "
    + "WAIT_BLOCK_IS_RELATIVE_DEADLINE_PROPERTY "
    + "WAIT_BLOCK_NAME_PROPERTY "
    + "WAIT_BLOCK_RELATIVE_DEADLINE_TYPE_PROPERTY ";

  // SYSRES Common
  const sysres_common_constants =
    "SYSRES_COMMON "
    + "SYSRES_CONST "
    + "SYSRES_MBFUNC "
    + "SYSRES_SBDATA "
    + "SYSRES_SBGUI "
    + "SYSRES_SBINTF "
    + "SYSRES_SBREFDSC "
    + "SYSRES_SQLERRORS "
    + "SYSRES_SYSCOMP ";

  // Константы ==> built_in
  const CONSTANTS =
    sysres_constants
    + base_constants
    + base_group_name_constants
    + decision_block_properties_constants
    + file_extension_constants
    + job_block_properties_constants
    + language_code_constants
    + launching_external_applications_constants
    + link_kind_constants
    + lock_type_constants
    + monitor_block_properties_constants
    + notice_block_properties_constants
    + object_events_constants
    + object_params_constants
    + other_constants
    + privileges_constants
    + pseudoreference_code_constants
    + requisite_ISBCertificateType_values_constants
    + requisite_ISBEDocStorageType_values_constants
    + requisite_compType2_values_constants
    + requisite_name_constants
    + result_constants
    + rule_identification_constants
    + script_block_properties_constants
    + subtask_block_properties_constants
    + system_component_constants
    + system_dialogs_constants
    + system_reference_names_constants
    + table_name_constants
    + test_constants
    + using_the_dialog_windows_constants
    + using_the_document_constants
    + using_the_EA_and_encryption_constants
    + using_the_ISBL_editor_constants
    + wait_block_properties_constants
    + sysres_common_constants;

  // enum TAccountType
  const TAccountType = "atUser atGroup atRole ";

  // enum TActionEnabledMode
  const TActionEnabledMode =
    "aemEnabledAlways "
    + "aemDisabledAlways "
    + "aemEnabledOnBrowse "
    + "aemEnabledOnEdit "
    + "aemDisabledOnBrowseEmpty ";

  // enum TAddPosition
  const TAddPosition = "apBegin apEnd ";

  // enum TAlignment
  const TAlignment = "alLeft alRight ";

  // enum TAreaShowMode
  const TAreaShowMode =
    "asmNever "
    + "asmNoButCustomize "
    + "asmAsLastTime "
    + "asmYesButCustomize "
    + "asmAlways ";

  // enum TCertificateInvalidationReason
  const TCertificateInvalidationReason = "cirCommon cirRevoked ";

  // enum TCertificateType
  const TCertificateType = "ctSignature ctEncode ctSignatureEncode ";

  // enum TCheckListBoxItemState
  const TCheckListBoxItemState = "clbUnchecked clbChecked clbGrayed ";

  // enum TCloseOnEsc
  const TCloseOnEsc = "ceISB ceAlways ceNever ";

  // enum TCompType
  const TCompType =
    "ctDocument "
    + "ctReference "
    + "ctScript "
    + "ctUnknown "
    + "ctReport "
    + "ctDialog "
    + "ctFunction "
    + "ctFolder "
    + "ctEDocument "
    + "ctTask "
    + "ctJob "
    + "ctNotice "
    + "ctControlJob ";

  // enum TConditionFormat
  const TConditionFormat = "cfInternal cfDisplay ";

  // enum TConnectionIntent
  const TConnectionIntent = "ciUnspecified ciWrite ciRead ";

  // enum TContentKind
  const TContentKind =
    "ckFolder "
    + "ckEDocument "
    + "ckTask "
    + "ckJob "
    + "ckComponentToken "
    + "ckAny "
    + "ckReference "
    + "ckScript "
    + "ckReport "
    + "ckDialog ";

  // enum TControlType
  const TControlType =
    "ctISBLEditor "
    + "ctBevel "
    + "ctButton "
    + "ctCheckListBox "
    + "ctComboBox "
    + "ctComboEdit "
    + "ctGrid "
    + "ctDBCheckBox "
    + "ctDBComboBox "
    + "ctDBEdit "
    + "ctDBEllipsis "
    + "ctDBMemo "
    + "ctDBNavigator "
    + "ctDBRadioGroup "
    + "ctDBStatusLabel "
    + "ctEdit "
    + "ctGroupBox "
    + "ctInplaceHint "
    + "ctMemo "
    + "ctPanel "
    + "ctListBox "
    + "ctRadioButton "
    + "ctRichEdit "
    + "ctTabSheet "
    + "ctWebBrowser "
    + "ctImage "
    + "ctHyperLink "
    + "ctLabel "
    + "ctDBMultiEllipsis "
    + "ctRibbon "
    + "ctRichView "
    + "ctInnerPanel "
    + "ctPanelGroup "
    + "ctBitButton ";

  // enum TCriterionContentType
  const TCriterionContentType =
    "cctDate "
    + "cctInteger "
    + "cctNumeric "
    + "cctPick "
    + "cctReference "
    + "cctString "
    + "cctText ";

  // enum TCultureType
  const TCultureType = "cltInternal cltPrimary cltGUI ";

  // enum TDataSetEventType
  const TDataSetEventType =
    "dseBeforeOpen "
    + "dseAfterOpen "
    + "dseBeforeClose "
    + "dseAfterClose "
    + "dseOnValidDelete "
    + "dseBeforeDelete "
    + "dseAfterDelete "
    + "dseAfterDeleteOutOfTransaction "
    + "dseOnDeleteError "
    + "dseBeforeInsert "
    + "dseAfterInsert "
    + "dseOnValidUpdate "
    + "dseBeforeUpdate "
    + "dseOnUpdateRatifiedRecord "
    + "dseAfterUpdate "
    + "dseAfterUpdateOutOfTransaction "
    + "dseOnUpdateError "
    + "dseAfterScroll "
    + "dseOnOpenRecord "
    + "dseOnCloseRecord "
    + "dseBeforeCancel "
    + "dseAfterCancel "
    + "dseOnUpdateDeadlockError "
    + "dseBeforeDetailUpdate "
    + "dseOnPrepareUpdate "
    + "dseOnAnyRequisiteChange ";

  // enum TDataSetState
  const TDataSetState = "dssEdit dssInsert dssBrowse dssInActive ";

  // enum TDateFormatType
  const TDateFormatType = "dftDate dftShortDate dftDateTime dftTimeStamp ";

  // enum TDateOffsetType
  const TDateOffsetType = "dotDays dotHours dotMinutes dotSeconds ";

  // enum TDateTimeKind
  const TDateTimeKind = "dtkndLocal dtkndUTC ";

  // enum TDeaAccessRights
  const TDeaAccessRights = "arNone arView arEdit arFull ";

  // enum TDocumentDefaultAction
  const TDocumentDefaultAction = "ddaView ddaEdit ";

  // enum TEditMode
  const TEditMode =
    "emLock "
    + "emEdit "
    + "emSign "
    + "emExportWithLock "
    + "emImportWithUnlock "
    + "emChangeVersionNote "
    + "emOpenForModify "
    + "emChangeLifeStage "
    + "emDelete "
    + "emCreateVersion "
    + "emImport "
    + "emUnlockExportedWithLock "
    + "emStart "
    + "emAbort "
    + "emReInit "
    + "emMarkAsReaded "
    + "emMarkAsUnreaded "
    + "emPerform "
    + "emAccept "
    + "emResume "
    + "emChangeRights "
    + "emEditRoute "
    + "emEditObserver "
    + "emRecoveryFromLocalCopy "
    + "emChangeWorkAccessType "
    + "emChangeEncodeTypeToCertificate "
    + "emChangeEncodeTypeToPassword "
    + "emChangeEncodeTypeToNone "
    + "emChangeEncodeTypeToCertificatePassword "
    + "emChangeStandardRoute "
    + "emGetText "
    + "emOpenForView "
    + "emMoveToStorage "
    + "emCreateObject "
    + "emChangeVersionHidden "
    + "emDeleteVersion "
    + "emChangeLifeCycleStage "
    + "emApprovingSign "
    + "emExport "
    + "emContinue "
    + "emLockFromEdit "
    + "emUnLockForEdit "
    + "emLockForServer "
    + "emUnlockFromServer "
    + "emDelegateAccessRights "
    + "emReEncode ";

  // enum TEditorCloseObservType
  const TEditorCloseObservType = "ecotFile ecotProcess ";

  // enum TEdmsApplicationAction
  const TEdmsApplicationAction = "eaGet eaCopy eaCreate eaCreateStandardRoute ";

  // enum TEDocumentLockType
  const TEDocumentLockType = "edltAll edltNothing edltQuery ";

  // enum TEDocumentStepShowMode
  const TEDocumentStepShowMode = "essmText essmCard ";

  // enum TEDocumentStepVersionType
  const TEDocumentStepVersionType = "esvtLast esvtLastActive esvtSpecified ";

  // enum TEDocumentStorageFunction
  const TEDocumentStorageFunction = "edsfExecutive edsfArchive ";

  // enum TEDocumentStorageType
  const TEDocumentStorageType = "edstSQLServer edstFile ";

  // enum TEDocumentVersionSourceType
  const TEDocumentVersionSourceType =
    "edvstNone edvstEDocumentVersionCopy edvstFile edvstTemplate edvstScannedFile ";

  // enum TEDocumentVersionState
  const TEDocumentVersionState = "vsDefault vsDesign vsActive vsObsolete ";

  // enum TEncodeType
  const TEncodeType = "etNone etCertificate etPassword etCertificatePassword ";

  // enum TExceptionCategory
  const TExceptionCategory = "ecException ecWarning ecInformation ";

  // enum TExportedSignaturesType
  const TExportedSignaturesType = "estAll estApprovingOnly ";

  // enum TExportedVersionType
  const TExportedVersionType = "evtLast evtLastActive evtQuery ";

  // enum TFieldDataType
  const TFieldDataType =
    "fdtString "
    + "fdtNumeric "
    + "fdtInteger "
    + "fdtDate "
    + "fdtText "
    + "fdtUnknown "
    + "fdtWideString "
    + "fdtLargeInteger ";

  // enum TFolderType
  const TFolderType =
    "ftInbox "
    + "ftOutbox "
    + "ftFavorites "
    + "ftCommonFolder "
    + "ftUserFolder "
    + "ftComponents "
    + "ftQuickLaunch "
    + "ftShortcuts "
    + "ftSearch ";

  // enum TGridRowHeight
  const TGridRowHeight = "grhAuto " + "grhX1 " + "grhX2 " + "grhX3 ";

  // enum THyperlinkType
  const THyperlinkType = "hltText " + "hltRTF " + "hltHTML ";

  // enum TImageFileFormat
  const TImageFileFormat =
    "iffBMP "
    + "iffJPEG "
    + "iffMultiPageTIFF "
    + "iffSinglePageTIFF "
    + "iffTIFF "
    + "iffPNG ";

  // enum TImageMode
  const TImageMode = "im8bGrayscale " + "im24bRGB " + "im1bMonochrome ";

  // enum TImageType
  const TImageType = "itBMP " + "itJPEG " + "itWMF " + "itPNG ";

  // enum TInplaceHintKind
  const TInplaceHintKind =
    "ikhInformation " + "ikhWarning " + "ikhError " + "ikhNoIcon ";

  // enum TISBLContext
  const TISBLContext =
    "icUnknown "
    + "icScript "
    + "icFunction "
    + "icIntegratedReport "
    + "icAnalyticReport "
    + "icDataSetEventHandler "
    + "icActionHandler "
    + "icFormEventHandler "
    + "icLookUpEventHandler "
    + "icRequisiteChangeEventHandler "
    + "icBeforeSearchEventHandler "
    + "icRoleCalculation "
    + "icSelectRouteEventHandler "
    + "icBlockPropertyCalculation "
    + "icBlockQueryParamsEventHandler "
    + "icChangeSearchResultEventHandler "
    + "icBlockEventHandler "
    + "icSubTaskInitEventHandler "
    + "icEDocDataSetEventHandler "
    + "icEDocLookUpEventHandler "
    + "icEDocActionHandler "
    + "icEDocFormEventHandler "
    + "icEDocRequisiteChangeEventHandler "
    + "icStructuredConversionRule "
    + "icStructuredConversionEventBefore "
    + "icStructuredConversionEventAfter "
    + "icWizardEventHandler "
    + "icWizardFinishEventHandler "
    + "icWizardStepEventHandler "
    + "icWizardStepFinishEventHandler "
    + "icWizardActionEnableEventHandler "
    + "icWizardActionExecuteEventHandler "
    + "icCreateJobsHandler "
    + "icCreateNoticesHandler "
    + "icBeforeLookUpEventHandler "
    + "icAfterLookUpEventHandler "
    + "icTaskAbortEventHandler "
    + "icWorkflowBlockActionHandler "
    + "icDialogDataSetEventHandler "
    + "icDialogActionHandler "
    + "icDialogLookUpEventHandler "
    + "icDialogRequisiteChangeEventHandler "
    + "icDialogFormEventHandler "
    + "icDialogValidCloseEventHandler "
    + "icBlockFormEventHandler "
    + "icTaskFormEventHandler "
    + "icReferenceMethod "
    + "icEDocMethod "
    + "icDialogMethod "
    + "icProcessMessageHandler ";

  // enum TItemShow
  const TItemShow = "isShow " + "isHide " + "isByUserSettings ";

  // enum TJobKind
  const TJobKind = "jkJob " + "jkNotice " + "jkControlJob ";

  // enum TJoinType
  const TJoinType = "jtInner " + "jtLeft " + "jtRight " + "jtFull " + "jtCross ";

  // enum TLabelPos
  const TLabelPos = "lbpAbove " + "lbpBelow " + "lbpLeft " + "lbpRight ";

  // enum TLicensingType
  const TLicensingType = "eltPerConnection " + "eltPerUser ";

  // enum TLifeCycleStageFontColor
  const TLifeCycleStageFontColor =
    "sfcUndefined "
    + "sfcBlack "
    + "sfcGreen "
    + "sfcRed "
    + "sfcBlue "
    + "sfcOrange "
    + "sfcLilac ";

  // enum TLifeCycleStageFontStyle
  const TLifeCycleStageFontStyle = "sfsItalic " + "sfsStrikeout " + "sfsNormal ";

  // enum TLockableDevelopmentComponentType
  const TLockableDevelopmentComponentType =
    "ldctStandardRoute "
    + "ldctWizard "
    + "ldctScript "
    + "ldctFunction "
    + "ldctRouteBlock "
    + "ldctIntegratedReport "
    + "ldctAnalyticReport "
    + "ldctReferenceType "
    + "ldctEDocumentType "
    + "ldctDialog "
    + "ldctServerEvents ";

  // enum TMaxRecordCountRestrictionType
  const TMaxRecordCountRestrictionType =
    "mrcrtNone " + "mrcrtUser " + "mrcrtMaximal " + "mrcrtCustom ";

  // enum TRangeValueType
  const TRangeValueType =
    "vtEqual " + "vtGreaterOrEqual " + "vtLessOrEqual " + "vtRange ";

  // enum TRelativeDate
  const TRelativeDate =
    "rdYesterday "
    + "rdToday "
    + "rdTomorrow "
    + "rdThisWeek "
    + "rdThisMonth "
    + "rdThisYear "
    + "rdNextMonth "
    + "rdNextWeek "
    + "rdLastWeek "
    + "rdLastMonth ";

  // enum TReportDestination
  const TReportDestination = "rdWindow " + "rdFile " + "rdPrinter ";

  // enum TReqDataType
  const TReqDataType =
    "rdtString "
    + "rdtNumeric "
    + "rdtInteger "
    + "rdtDate "
    + "rdtReference "
    + "rdtAccount "
    + "rdtText "
    + "rdtPick "
    + "rdtUnknown "
    + "rdtLargeInteger "
    + "rdtDocument ";

  // enum TRequisiteEventType
  const TRequisiteEventType = "reOnChange " + "reOnChangeValues ";

  // enum TSBTimeType
  const TSBTimeType = "ttGlobal " + "ttLocal " + "ttUser " + "ttSystem ";

  // enum TSearchShowMode
  const TSearchShowMode =
    "ssmBrowse " + "ssmSelect " + "ssmMultiSelect " + "ssmBrowseModal ";

  // enum TSelectMode
  const TSelectMode = "smSelect " + "smLike " + "smCard ";

  // enum TSignatureType
  const TSignatureType = "stNone " + "stAuthenticating " + "stApproving ";

  // enum TSignerContentType
  const TSignerContentType = "sctString " + "sctStream ";

  // enum TStringsSortType
  const TStringsSortType = "sstAnsiSort " + "sstNaturalSort ";

  // enum TStringValueType
  const TStringValueType = "svtEqual " + "svtContain ";

  // enum TStructuredObjectAttributeType
  const TStructuredObjectAttributeType =
    "soatString "
    + "soatNumeric "
    + "soatInteger "
    + "soatDatetime "
    + "soatReferenceRecord "
    + "soatText "
    + "soatPick "
    + "soatBoolean "
    + "soatEDocument "
    + "soatAccount "
    + "soatIntegerCollection "
    + "soatNumericCollection "
    + "soatStringCollection "
    + "soatPickCollection "
    + "soatDatetimeCollection "
    + "soatBooleanCollection "
    + "soatReferenceRecordCollection "
    + "soatEDocumentCollection "
    + "soatAccountCollection "
    + "soatContents "
    + "soatUnknown ";

  // enum TTaskAbortReason
  const TTaskAbortReason = "tarAbortByUser " + "tarAbortByWorkflowException ";

  // enum TTextValueType
  const TTextValueType = "tvtAllWords " + "tvtExactPhrase " + "tvtAnyWord ";

  // enum TUserObjectStatus
  const TUserObjectStatus =
    "usNone "
    + "usCompleted "
    + "usRedSquare "
    + "usBlueSquare "
    + "usYellowSquare "
    + "usGreenSquare "
    + "usOrangeSquare "
    + "usPurpleSquare "
    + "usFollowUp ";

  // enum TUserType
  const TUserType =
    "utUnknown "
    + "utUser "
    + "utDeveloper "
    + "utAdministrator "
    + "utSystemDeveloper "
    + "utDisconnected ";

  // enum TValuesBuildType
  const TValuesBuildType =
    "btAnd " + "btDetailAnd " + "btOr " + "btNotOr " + "btOnly ";

  // enum TViewMode
  const TViewMode = "vmView " + "vmSelect " + "vmNavigation ";

  // enum TViewSelectionMode
  const TViewSelectionMode =
    "vsmSingle " + "vsmMultiple " + "vsmMultipleCheck " + "vsmNoSelection ";

  // enum TWizardActionType
  const TWizardActionType =
    "wfatPrevious " + "wfatNext " + "wfatCancel " + "wfatFinish ";

  // enum TWizardFormElementProperty
  const TWizardFormElementProperty =
    "wfepUndefined "
    + "wfepText3 "
    + "wfepText6 "
    + "wfepText9 "
    + "wfepSpinEdit "
    + "wfepDropDown "
    + "wfepRadioGroup "
    + "wfepFlag "
    + "wfepText12 "
    + "wfepText15 "
    + "wfepText18 "
    + "wfepText21 "
    + "wfepText24 "
    + "wfepText27 "
    + "wfepText30 "
    + "wfepRadioGroupColumn1 "
    + "wfepRadioGroupColumn2 "
    + "wfepRadioGroupColumn3 ";

  // enum TWizardFormElementType
  const TWizardFormElementType =
    "wfetQueryParameter " + "wfetText " + "wfetDelimiter " + "wfetLabel ";

  // enum TWizardParamType
  const TWizardParamType =
    "wptString "
    + "wptInteger "
    + "wptNumeric "
    + "wptBoolean "
    + "wptDateTime "
    + "wptPick "
    + "wptText "
    + "wptUser "
    + "wptUserList "
    + "wptEDocumentInfo "
    + "wptEDocumentInfoList "
    + "wptReferenceRecordInfo "
    + "wptReferenceRecordInfoList "
    + "wptFolderInfo "
    + "wptTaskInfo "
    + "wptContents "
    + "wptFileName "
    + "wptDate ";

  // enum TWizardStepResult
  const TWizardStepResult =
    "wsrComplete "
    + "wsrGoNext "
    + "wsrGoPrevious "
    + "wsrCustom "
    + "wsrCancel "
    + "wsrGoFinal ";

  // enum TWizardStepType
  const TWizardStepType =
    "wstForm "
    + "wstEDocument "
    + "wstTaskCard "
    + "wstReferenceRecordCard "
    + "wstFinal ";

  // enum TWorkAccessType
  const TWorkAccessType = "waAll " + "waPerformers " + "waManual ";

  // enum TWorkflowBlockType
  const TWorkflowBlockType =
    "wsbStart "
    + "wsbFinish "
    + "wsbNotice "
    + "wsbStep "
    + "wsbDecision "
    + "wsbWait "
    + "wsbMonitor "
    + "wsbScript "
    + "wsbConnector "
    + "wsbSubTask "
    + "wsbLifeCycleStage "
    + "wsbPause ";

  // enum TWorkflowDataType
  const TWorkflowDataType =
    "wdtInteger "
    + "wdtFloat "
    + "wdtString "
    + "wdtPick "
    + "wdtDateTime "
    + "wdtBoolean "
    + "wdtTask "
    + "wdtJob "
    + "wdtFolder "
    + "wdtEDocument "
    + "wdtReferenceRecord "
    + "wdtUser "
    + "wdtGroup "
    + "wdtRole "
    + "wdtIntegerCollection "
    + "wdtFloatCollection "
    + "wdtStringCollection "
    + "wdtPickCollection "
    + "wdtDateTimeCollection "
    + "wdtBooleanCollection "
    + "wdtTaskCollection "
    + "wdtJobCollection "
    + "wdtFolderCollection "
    + "wdtEDocumentCollection "
    + "wdtReferenceRecordCollection "
    + "wdtUserCollection "
    + "wdtGroupCollection "
    + "wdtRoleCollection "
    + "wdtContents "
    + "wdtUserList "
    + "wdtSearchDescription "
    + "wdtDeadLine "
    + "wdtPickSet "
    + "wdtAccountCollection ";

  // enum TWorkImportance
  const TWorkImportance = "wiLow " + "wiNormal " + "wiHigh ";

  // enum TWorkRouteType
  const TWorkRouteType = "wrtSoft " + "wrtHard ";

  // enum TWorkState
  const TWorkState =
    "wsInit "
    + "wsRunning "
    + "wsDone "
    + "wsControlled "
    + "wsAborted "
    + "wsContinued ";

  // enum TWorkTextBuildingMode
  const TWorkTextBuildingMode =
    "wtmFull " + "wtmFromCurrent " + "wtmOnlyCurrent ";

  // Перечисления
  const ENUMS =
    TAccountType
    + TActionEnabledMode
    + TAddPosition
    + TAlignment
    + TAreaShowMode
    + TCertificateInvalidationReason
    + TCertificateType
    + TCheckListBoxItemState
    + TCloseOnEsc
    + TCompType
    + TConditionFormat
    + TConnectionIntent
    + TContentKind
    + TControlType
    + TCriterionContentType
    + TCultureType
    + TDataSetEventType
    + TDataSetState
    + TDateFormatType
    + TDateOffsetType
    + TDateTimeKind
    + TDeaAccessRights
    + TDocumentDefaultAction
    + TEditMode
    + TEditorCloseObservType
    + TEdmsApplicationAction
    + TEDocumentLockType
    + TEDocumentStepShowMode
    + TEDocumentStepVersionType
    + TEDocumentStorageFunction
    + TEDocumentStorageType
    + TEDocumentVersionSourceType
    + TEDocumentVersionState
    + TEncodeType
    + TExceptionCategory
    + TExportedSignaturesType
    + TExportedVersionType
    + TFieldDataType
    + TFolderType
    + TGridRowHeight
    + THyperlinkType
    + TImageFileFormat
    + TImageMode
    + TImageType
    + TInplaceHintKind
    + TISBLContext
    + TItemShow
    + TJobKind
    + TJoinType
    + TLabelPos
    + TLicensingType
    + TLifeCycleStageFontColor
    + TLifeCycleStageFontStyle
    + TLockableDevelopmentComponentType
    + TMaxRecordCountRestrictionType
    + TRangeValueType
    + TRelativeDate
    + TReportDestination
    + TReqDataType
    + TRequisiteEventType
    + TSBTimeType
    + TSearchShowMode
    + TSelectMode
    + TSignatureType
    + TSignerContentType
    + TStringsSortType
    + TStringValueType
    + TStructuredObjectAttributeType
    + TTaskAbortReason
    + TTextValueType
    + TUserObjectStatus
    + TUserType
    + TValuesBuildType
    + TViewMode
    + TViewSelectionMode
    + TWizardActionType
    + TWizardFormElementProperty
    + TWizardFormElementType
    + TWizardParamType
    + TWizardStepResult
    + TWizardStepType
    + TWorkAccessType
    + TWorkflowBlockType
    + TWorkflowDataType
    + TWorkImportance
    + TWorkRouteType
    + TWorkState
    + TWorkTextBuildingMode;

  // Системные функции ==> SYSFUNCTIONS
  const system_functions =
    "AddSubString "
    + "AdjustLineBreaks "
    + "AmountInWords "
    + "Analysis "
    + "ArrayDimCount "
    + "ArrayHighBound "
    + "ArrayLowBound "
    + "ArrayOf "
    + "ArrayReDim "
    + "Assert "
    + "Assigned "
    + "BeginOfMonth "
    + "BeginOfPeriod "
    + "BuildProfilingOperationAnalysis "
    + "CallProcedure "
    + "CanReadFile "
    + "CArrayElement "
    + "CDataSetRequisite "
    + "ChangeDate "
    + "ChangeReferenceDataset "
    + "Char "
    + "CharPos "
    + "CheckParam "
    + "CheckParamValue "
    + "CompareStrings "
    + "ConstantExists "
    + "ControlState "
    + "ConvertDateStr "
    + "Copy "
    + "CopyFile "
    + "CreateArray "
    + "CreateCachedReference "
    + "CreateConnection "
    + "CreateDialog "
    + "CreateDualListDialog "
    + "CreateEditor "
    + "CreateException "
    + "CreateFile "
    + "CreateFolderDialog "
    + "CreateInputDialog "
    + "CreateLinkFile "
    + "CreateList "
    + "CreateLock "
    + "CreateMemoryDataSet "
    + "CreateObject "
    + "CreateOpenDialog "
    + "CreateProgress "
    + "CreateQuery "
    + "CreateReference "
    + "CreateReport "
    + "CreateSaveDialog "
    + "CreateScript "
    + "CreateSQLPivotFunction "
    + "CreateStringList "
    + "CreateTreeListSelectDialog "
    + "CSelectSQL "
    + "CSQL "
    + "CSubString "
    + "CurrentUserID "
    + "CurrentUserName "
    + "CurrentVersion "
    + "DataSetLocateEx "
    + "DateDiff "
    + "DateTimeDiff "
    + "DateToStr "
    + "DayOfWeek "
    + "DeleteFile "
    + "DirectoryExists "
    + "DisableCheckAccessRights "
    + "DisableCheckFullShowingRestriction "
    + "DisableMassTaskSendingRestrictions "
    + "DropTable "
    + "DupeString "
    + "EditText "
    + "EnableCheckAccessRights "
    + "EnableCheckFullShowingRestriction "
    + "EnableMassTaskSendingRestrictions "
    + "EndOfMonth "
    + "EndOfPeriod "
    + "ExceptionExists "
    + "ExceptionsOff "
    + "ExceptionsOn "
    + "Execute "
    + "ExecuteProcess "
    + "Exit "
    + "ExpandEnvironmentVariables "
    + "ExtractFileDrive "
    + "ExtractFileExt "
    + "ExtractFileName "
    + "ExtractFilePath "
    + "ExtractParams "
    + "FileExists "
    + "FileSize "
    + "FindFile "
    + "FindSubString "
    + "FirmContext "
    + "ForceDirectories "
    + "Format "
    + "FormatDate "
    + "FormatNumeric "
    + "FormatSQLDate "
    + "FormatString "
    + "FreeException "
    + "GetComponent "
    + "GetComponentLaunchParam "
    + "GetConstant "
    + "GetLastException "
    + "GetReferenceRecord "
    + "GetRefTypeByRefID "
    + "GetTableID "
    + "GetTempFolder "
    + "IfThen "
    + "In "
    + "IndexOf "
    + "InputDialog "
    + "InputDialogEx "
    + "InteractiveMode "
    + "IsFileLocked "
    + "IsGraphicFile "
    + "IsNumeric "
    + "Length "
    + "LoadString "
    + "LoadStringFmt "
    + "LocalTimeToUTC "
    + "LowerCase "
    + "Max "
    + "MessageBox "
    + "MessageBoxEx "
    + "MimeDecodeBinary "
    + "MimeDecodeString "
    + "MimeEncodeBinary "
    + "MimeEncodeString "
    + "Min "
    + "MoneyInWords "
    + "MoveFile "
    + "NewID "
    + "Now "
    + "OpenFile "
    + "Ord "
    + "Precision "
    + "Raise "
    + "ReadCertificateFromFile "
    + "ReadFile "
    + "ReferenceCodeByID "
    + "ReferenceNumber "
    + "ReferenceRequisiteMode "
    + "ReferenceRequisiteValue "
    + "RegionDateSettings "
    + "RegionNumberSettings "
    + "RegionTimeSettings "
    + "RegRead "
    + "RegWrite "
    + "RenameFile "
    + "Replace "
    + "Round "
    + "SelectServerCode "
    + "SelectSQL "
    + "ServerDateTime "
    + "SetConstant "
    + "SetManagedFolderFieldsState "
    + "ShowConstantsInputDialog "
    + "ShowMessage "
    + "Sleep "
    + "Split "
    + "SQL "
    + "SQL2XLSTAB "
    + "SQLProfilingSendReport "
    + "StrToDate "
    + "SubString "
    + "SubStringCount "
    + "SystemSetting "
    + "Time "
    + "TimeDiff "
    + "Today "
    + "Transliterate "
    + "Trim "
    + "UpperCase "
    + "UserStatus "
    + "UTCToLocalTime "
    + "ValidateXML "
    + "VarIsClear "
    + "VarIsEmpty "
    + "VarIsNull "
    + "WorkTimeDiff "
    + "WriteFile "
    + "WriteFileEx "
    + "WriteObjectHistory "
    + "Анализ "
    + "БазаДанных "
    + "БлокЕсть "
    + "БлокЕстьРасш "
    + "БлокИнфо "
    + "БлокСнять "
    + "БлокСнятьРасш "
    + "БлокУстановить "
    + "Ввод "
    + "ВводМеню "
    + "ВедС "
    + "ВедСпр "
    + "ВерхняяГраницаМассива "
    + "ВнешПрогр "
    + "Восст "
    + "ВременнаяПапка "
    + "Время "
    + "ВыборSQL "
    + "ВыбратьЗапись "
    + "ВыделитьСтр "
    + "Вызвать "
    + "Выполнить "
    + "ВыпПрогр "
    + "ГрафическийФайл "
    + "ГруппаДополнительно "
    + "ДатаВремяСерв "
    + "ДеньНедели "
    + "ДиалогДаНет "
    + "ДлинаСтр "
    + "ДобПодстр "
    + "ЕПусто "
    + "ЕслиТо "
    + "ЕЧисло "
    + "ЗамПодстр "
    + "ЗаписьСправочника "
    + "ЗначПоляСпр "
    + "ИДТипСпр "
    + "ИзвлечьДиск "
    + "ИзвлечьИмяФайла "
    + "ИзвлечьПуть "
    + "ИзвлечьРасширение "
    + "ИзмДат "
    + "ИзменитьРазмерМассива "
    + "ИзмеренийМассива "
    + "ИмяОрг "
    + "ИмяПоляСпр "
    + "Индекс "
    + "ИндикаторЗакрыть "
    + "ИндикаторОткрыть "
    + "ИндикаторШаг "
    + "ИнтерактивныйРежим "
    + "ИтогТблСпр "
    + "КодВидВедСпр "
    + "КодВидСпрПоИД "
    + "КодПоAnalit "
    + "КодСимвола "
    + "КодСпр "
    + "КолПодстр "
    + "КолПроп "
    + "КонМес "
    + "Конст "
    + "КонстЕсть "
    + "КонстЗнач "
    + "КонТран "
    + "КопироватьФайл "
    + "КопияСтр "
    + "КПериод "
    + "КСтрТблСпр "
    + "Макс "
    + "МаксСтрТблСпр "
    + "Массив "
    + "Меню "
    + "МенюРасш "
    + "Мин "
    + "НаборДанныхНайтиРасш "
    + "НаимВидСпр "
    + "НаимПоAnalit "
    + "НаимСпр "
    + "НастроитьПереводыСтрок "
    + "НачМес "
    + "НачТран "
    + "НижняяГраницаМассива "
    + "НомерСпр "
    + "НПериод "
    + "Окно "
    + "Окр "
    + "Окружение "
    + "ОтлИнфДобавить "
    + "ОтлИнфУдалить "
    + "Отчет "
    + "ОтчетАнал "
    + "ОтчетИнт "
    + "ПапкаСуществует "
    + "Пауза "
    + "ПВыборSQL "
    + "ПереименоватьФайл "
    + "Переменные "
    + "ПереместитьФайл "
    + "Подстр "
    + "ПоискПодстр "
    + "ПоискСтр "
    + "ПолучитьИДТаблицы "
    + "ПользовательДополнительно "
    + "ПользовательИД "
    + "ПользовательИмя "
    + "ПользовательСтатус "
    + "Прервать "
    + "ПроверитьПараметр "
    + "ПроверитьПараметрЗнач "
    + "ПроверитьУсловие "
    + "РазбСтр "
    + "РазнВремя "
    + "РазнДат "
    + "РазнДатаВремя "
    + "РазнРабВремя "
    + "РегУстВрем "
    + "РегУстДат "
    + "РегУстЧсл "
    + "РедТекст "
    + "РеестрЗапись "
    + "РеестрСписокИменПарам "
    + "РеестрЧтение "
    + "РеквСпр "
    + "РеквСпрПр "
    + "Сегодня "
    + "Сейчас "
    + "Сервер "
    + "СерверПроцессИД "
    + "СертификатФайлСчитать "
    + "СжПроб "
    + "Символ "
    + "СистемаДиректумКод "
    + "СистемаИнформация "
    + "СистемаКод "
    + "Содержит "
    + "СоединениеЗакрыть "
    + "СоединениеОткрыть "
    + "СоздатьДиалог "
    + "СоздатьДиалогВыбораИзДвухСписков "
    + "СоздатьДиалогВыбораПапки "
    + "СоздатьДиалогОткрытияФайла "
    + "СоздатьДиалогСохраненияФайла "
    + "СоздатьЗапрос "
    + "СоздатьИндикатор "
    + "СоздатьИсключение "
    + "СоздатьКэшированныйСправочник "
    + "СоздатьМассив "
    + "СоздатьНаборДанных "
    + "СоздатьОбъект "
    + "СоздатьОтчет "
    + "СоздатьПапку "
    + "СоздатьРедактор "
    + "СоздатьСоединение "
    + "СоздатьСписок "
    + "СоздатьСписокСтрок "
    + "СоздатьСправочник "
    + "СоздатьСценарий "
    + "СоздСпр "
    + "СостСпр "
    + "Сохр "
    + "СохрСпр "
    + "СписокСистем "
    + "Спр "
    + "Справочник "
    + "СпрБлокЕсть "
    + "СпрБлокСнять "
    + "СпрБлокСнятьРасш "
    + "СпрБлокУстановить "
    + "СпрИзмНабДан "
    + "СпрКод "
    + "СпрНомер "
    + "СпрОбновить "
    + "СпрОткрыть "
    + "СпрОтменить "
    + "СпрПарам "
    + "СпрПолеЗнач "
    + "СпрПолеИмя "
    + "СпрРекв "
    + "СпрРеквВведЗн "
    + "СпрРеквНовые "
    + "СпрРеквПр "
    + "СпрРеквПредЗн "
    + "СпрРеквРежим "
    + "СпрРеквТипТекст "
    + "СпрСоздать "
    + "СпрСост "
    + "СпрСохранить "
    + "СпрТблИтог "
    + "СпрТблСтр "
    + "СпрТблСтрКол "
    + "СпрТблСтрМакс "
    + "СпрТблСтрМин "
    + "СпрТблСтрПред "
    + "СпрТблСтрСлед "
    + "СпрТблСтрСозд "
    + "СпрТблСтрУд "
    + "СпрТекПредст "
    + "СпрУдалить "
    + "СравнитьСтр "
    + "СтрВерхРегистр "
    + "СтрНижнРегистр "
    + "СтрТблСпр "
    + "СумПроп "
    + "Сценарий "
    + "СценарийПарам "
    + "ТекВерсия "
    + "ТекОрг "
    + "Точн "
    + "Тран "
    + "Транслитерация "
    + "УдалитьТаблицу "
    + "УдалитьФайл "
    + "УдСпр "
    + "УдСтрТблСпр "
    + "Уст "
    + "УстановкиКонстант "
    + "ФайлАтрибутСчитать "
    + "ФайлАтрибутУстановить "
    + "ФайлВремя "
    + "ФайлВремяУстановить "
    + "ФайлВыбрать "
    + "ФайлЗанят "
    + "ФайлЗаписать "
    + "ФайлИскать "
    + "ФайлКопировать "
    + "ФайлМожноЧитать "
    + "ФайлОткрыть "
    + "ФайлПереименовать "
    + "ФайлПерекодировать "
    + "ФайлПереместить "
    + "ФайлПросмотреть "
    + "ФайлРазмер "
    + "ФайлСоздать "
    + "ФайлСсылкаСоздать "
    + "ФайлСуществует "
    + "ФайлСчитать "
    + "ФайлУдалить "
    + "ФмтSQLДат "
    + "ФмтДат "
    + "ФмтСтр "
    + "ФмтЧсл "
    + "Формат "
    + "ЦМассивЭлемент "
    + "ЦНаборДанныхРеквизит "
    + "ЦПодстр ";

  // Предопределенные переменные ==> built_in
  const predefined_variables =
    "AltState "
    + "Application "
    + "CallType "
    + "ComponentTokens "
    + "CreatedJobs "
    + "CreatedNotices "
    + "ControlState "
    + "DialogResult "
    + "Dialogs "
    + "EDocuments "
    + "EDocumentVersionSource "
    + "Folders "
    + "GlobalIDs "
    + "Job "
    + "Jobs "
    + "InputValue "
    + "LookUpReference "
    + "LookUpRequisiteNames "
    + "LookUpSearch "
    + "Object "
    + "ParentComponent "
    + "Processes "
    + "References "
    + "Requisite "
    + "ReportName "
    + "Reports "
    + "Result "
    + "Scripts "
    + "Searches "
    + "SelectedAttachments "
    + "SelectedItems "
    + "SelectMode "
    + "Sender "
    + "ServerEvents "
    + "ServiceFactory "
    + "ShiftState "
    + "SubTask "
    + "SystemDialogs "
    + "Tasks "
    + "Wizard "
    + "Wizards "
    + "Work "
    + "ВызовСпособ "
    + "ИмяОтчета "
    + "РеквЗнач ";

  // Интерфейсы ==> type
  const interfaces =
    "IApplication "
    + "IAccessRights "
    + "IAccountRepository "
    + "IAccountSelectionRestrictions "
    + "IAction "
    + "IActionList "
    + "IAdministrationHistoryDescription "
    + "IAnchors "
    + "IApplication "
    + "IArchiveInfo "
    + "IAttachment "
    + "IAttachmentList "
    + "ICheckListBox "
    + "ICheckPointedList "
    + "IColumn "
    + "IComponent "
    + "IComponentDescription "
    + "IComponentToken "
    + "IComponentTokenFactory "
    + "IComponentTokenInfo "
    + "ICompRecordInfo "
    + "IConnection "
    + "IContents "
    + "IControl "
    + "IControlJob "
    + "IControlJobInfo "
    + "IControlList "
    + "ICrypto "
    + "ICrypto2 "
    + "ICustomJob "
    + "ICustomJobInfo "
    + "ICustomListBox "
    + "ICustomObjectWizardStep "
    + "ICustomWork "
    + "ICustomWorkInfo "
    + "IDataSet "
    + "IDataSetAccessInfo "
    + "IDataSigner "
    + "IDateCriterion "
    + "IDateRequisite "
    + "IDateRequisiteDescription "
    + "IDateValue "
    + "IDeaAccessRights "
    + "IDeaObjectInfo "
    + "IDevelopmentComponentLock "
    + "IDialog "
    + "IDialogFactory "
    + "IDialogPickRequisiteItems "
    + "IDialogsFactory "
    + "IDICSFactory "
    + "IDocRequisite "
    + "IDocumentInfo "
    + "IDualListDialog "
    + "IECertificate "
    + "IECertificateInfo "
    + "IECertificates "
    + "IEditControl "
    + "IEditorForm "
    + "IEdmsExplorer "
    + "IEdmsObject "
    + "IEdmsObjectDescription "
    + "IEdmsObjectFactory "
    + "IEdmsObjectInfo "
    + "IEDocument "
    + "IEDocumentAccessRights "
    + "IEDocumentDescription "
    + "IEDocumentEditor "
    + "IEDocumentFactory "
    + "IEDocumentInfo "
    + "IEDocumentStorage "
    + "IEDocumentVersion "
    + "IEDocumentVersionListDialog "
    + "IEDocumentVersionSource "
    + "IEDocumentWizardStep "
    + "IEDocVerSignature "
    + "IEDocVersionState "
    + "IEnabledMode "
    + "IEncodeProvider "
    + "IEncrypter "
    + "IEvent "
    + "IEventList "
    + "IException "
    + "IExternalEvents "
    + "IExternalHandler "
    + "IFactory "
    + "IField "
    + "IFileDialog "
    + "IFolder "
    + "IFolderDescription "
    + "IFolderDialog "
    + "IFolderFactory "
    + "IFolderInfo "
    + "IForEach "
    + "IForm "
    + "IFormTitle "
    + "IFormWizardStep "
    + "IGlobalIDFactory "
    + "IGlobalIDInfo "
    + "IGrid "
    + "IHasher "
    + "IHistoryDescription "
    + "IHyperLinkControl "
    + "IImageButton "
    + "IImageControl "
    + "IInnerPanel "
    + "IInplaceHint "
    + "IIntegerCriterion "
    + "IIntegerList "
    + "IIntegerRequisite "
    + "IIntegerValue "
    + "IISBLEditorForm "
    + "IJob "
    + "IJobDescription "
    + "IJobFactory "
    + "IJobForm "
    + "IJobInfo "
    + "ILabelControl "
    + "ILargeIntegerCriterion "
    + "ILargeIntegerRequisite "
    + "ILargeIntegerValue "
    + "ILicenseInfo "
    + "ILifeCycleStage "
    + "IList "
    + "IListBox "
    + "ILocalIDInfo "
    + "ILocalization "
    + "ILock "
    + "IMemoryDataSet "
    + "IMessagingFactory "
    + "IMetadataRepository "
    + "INotice "
    + "INoticeInfo "
    + "INumericCriterion "
    + "INumericRequisite "
    + "INumericValue "
    + "IObject "
    + "IObjectDescription "
    + "IObjectImporter "
    + "IObjectInfo "
    + "IObserver "
    + "IPanelGroup "
    + "IPickCriterion "
    + "IPickProperty "
    + "IPickRequisite "
    + "IPickRequisiteDescription "
    + "IPickRequisiteItem "
    + "IPickRequisiteItems "
    + "IPickValue "
    + "IPrivilege "
    + "IPrivilegeList "
    + "IProcess "
    + "IProcessFactory "
    + "IProcessMessage "
    + "IProgress "
    + "IProperty "
    + "IPropertyChangeEvent "
    + "IQuery "
    + "IReference "
    + "IReferenceCriterion "
    + "IReferenceEnabledMode "
    + "IReferenceFactory "
    + "IReferenceHistoryDescription "
    + "IReferenceInfo "
    + "IReferenceRecordCardWizardStep "
    + "IReferenceRequisiteDescription "
    + "IReferencesFactory "
    + "IReferenceValue "
    + "IRefRequisite "
    + "IReport "
    + "IReportFactory "
    + "IRequisite "
    + "IRequisiteDescription "
    + "IRequisiteDescriptionList "
    + "IRequisiteFactory "
    + "IRichEdit "
    + "IRouteStep "
    + "IRule "
    + "IRuleList "
    + "ISchemeBlock "
    + "IScript "
    + "IScriptFactory "
    + "ISearchCriteria "
    + "ISearchCriterion "
    + "ISearchDescription "
    + "ISearchFactory "
    + "ISearchFolderInfo "
    + "ISearchForObjectDescription "
    + "ISearchResultRestrictions "
    + "ISecuredContext "
    + "ISelectDialog "
    + "IServerEvent "
    + "IServerEventFactory "
    + "IServiceDialog "
    + "IServiceFactory "
    + "ISignature "
    + "ISignProvider "
    + "ISignProvider2 "
    + "ISignProvider3 "
    + "ISimpleCriterion "
    + "IStringCriterion "
    + "IStringList "
    + "IStringRequisite "
    + "IStringRequisiteDescription "
    + "IStringValue "
    + "ISystemDialogsFactory "
    + "ISystemInfo "
    + "ITabSheet "
    + "ITask "
    + "ITaskAbortReasonInfo "
    + "ITaskCardWizardStep "
    + "ITaskDescription "
    + "ITaskFactory "
    + "ITaskInfo "
    + "ITaskRoute "
    + "ITextCriterion "
    + "ITextRequisite "
    + "ITextValue "
    + "ITreeListSelectDialog "
    + "IUser "
    + "IUserList "
    + "IValue "
    + "IView "
    + "IWebBrowserControl "
    + "IWizard "
    + "IWizardAction "
    + "IWizardFactory "
    + "IWizardFormElement "
    + "IWizardParam "
    + "IWizardPickParam "
    + "IWizardReferenceParam "
    + "IWizardStep "
    + "IWorkAccessRights "
    + "IWorkDescription "
    + "IWorkflowAskableParam "
    + "IWorkflowAskableParams "
    + "IWorkflowBlock "
    + "IWorkflowBlockResult "
    + "IWorkflowEnabledMode "
    + "IWorkflowParam "
    + "IWorkflowPickParam "
    + "IWorkflowReferenceParam "
    + "IWorkState "
    + "IWorkTreeCustomNode "
    + "IWorkTreeJobNode "
    + "IWorkTreeTaskNode "
    + "IXMLEditorForm "
    + "SBCrypto ";

  // built_in : встроенные или библиотечные объекты (константы, перечисления)
  const BUILTIN = CONSTANTS + ENUMS;

  // class: встроенные наборы значений, системные объекты, фабрики
  const CLASS = predefined_variables;

  // literal : примитивные типы
  const LITERAL = "null true false nil ";

  // number : числа
  const NUMBERS = {
    className: "number",
    begin: hljs.NUMBER_RE,
    relevance: 0
  };

  // string : строки
  const STRINGS = {
    className: "string",
    variants: [
      {
        begin: '"',
        end: '"'
      },
      {
        begin: "'",
        end: "'"
      }
    ]
  };

  // Токены
  const DOCTAGS = {
    className: "doctag",
    begin: "\\b(?:TODO|DONE|BEGIN|END|STUB|CHG|FIXME|NOTE|BUG|XXX)\\b",
    relevance: 0
  };

  // Однострочный комментарий
  const ISBL_LINE_COMMENT_MODE = {
    className: "comment",
    begin: "//",
    end: "$",
    relevance: 0,
    contains: [
      hljs.PHRASAL_WORDS_MODE,
      DOCTAGS
    ]
  };

  // Многострочный комментарий
  const ISBL_BLOCK_COMMENT_MODE = {
    className: "comment",
    begin: "/\\*",
    end: "\\*/",
    relevance: 0,
    contains: [
      hljs.PHRASAL_WORDS_MODE,
      DOCTAGS
    ]
  };

  // comment : комментарии
  const COMMENTS = { variants: [
    ISBL_LINE_COMMENT_MODE,
    ISBL_BLOCK_COMMENT_MODE
  ] };

  // keywords : ключевые слова
  const KEYWORDS = {
    $pattern: UNDERSCORE_IDENT_RE,
    keyword: KEYWORD,
    built_in: BUILTIN,
    class: CLASS,
    literal: LITERAL
  };

  // methods : методы
  const METHODS = {
    begin: "\\.\\s*" + hljs.UNDERSCORE_IDENT_RE,
    keywords: KEYWORDS,
    relevance: 0
  };

  // type : встроенные типы
  const TYPES = {
    className: "type",
    begin: ":[ \\t]*(" + interfaces.trim().replace(/\s/g, "|") + ")",
    end: "[ \\t]*=",
    excludeEnd: true
  };

  // variables : переменные
  const VARIABLES = {
    className: "variable",
    keywords: KEYWORDS,
    begin: UNDERSCORE_IDENT_RE,
    relevance: 0,
    contains: [
      TYPES,
      METHODS
    ]
  };

  // Имена функций
  const FUNCTION_TITLE = FUNCTION_NAME_IDENT_RE + "\\(";

  const TITLE_MODE = {
    className: "title",
    keywords: {
      $pattern: UNDERSCORE_IDENT_RE,
      built_in: system_functions
    },
    begin: FUNCTION_TITLE,
    end: "\\(",
    returnBegin: true,
    excludeEnd: true
  };

  // function : функции
  const FUNCTIONS = {
    className: "function",
    begin: FUNCTION_TITLE,
    end: "\\)$",
    returnBegin: true,
    keywords: KEYWORDS,
    illegal: "[\\[\\]\\|\\$\\?%,~#@]",
    contains: [
      TITLE_MODE,
      METHODS,
      VARIABLES,
      STRINGS,
      NUMBERS,
      COMMENTS
    ]
  };

  return {
    name: 'ISBL',
    case_insensitive: true,
    keywords: KEYWORDS,
    illegal: "\\$|\\?|%|,|;$|~|#|@|</",
    contains: [
      FUNCTIONS,
      TYPES,
      METHODS,
      VARIABLES,
      STRINGS,
      NUMBERS,
      COMMENTS
    ]
  };
}

module.exports = isbl;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/java.js":
/*!*********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/java.js ***!
  \*********************************************************/
/***/ (function(module) {

// https://docs.oracle.com/javase/specs/jls/se15/html/jls-3.html#jls-3.10
var decimalDigits = '[0-9](_*[0-9])*';
var frac = `\\.(${decimalDigits})`;
var hexDigits = '[0-9a-fA-F](_*[0-9a-fA-F])*';
var NUMERIC = {
  className: 'number',
  variants: [
    // DecimalFloatingPointLiteral
    // including ExponentPart
    { begin: `(\\b(${decimalDigits})((${frac})|\\.)?|(${frac}))` +
      `[eE][+-]?(${decimalDigits})[fFdD]?\\b` },
    // excluding ExponentPart
    { begin: `\\b(${decimalDigits})((${frac})[fFdD]?\\b|\\.([fFdD]\\b)?)` },
    { begin: `(${frac})[fFdD]?\\b` },
    { begin: `\\b(${decimalDigits})[fFdD]\\b` },

    // HexadecimalFloatingPointLiteral
    { begin: `\\b0[xX]((${hexDigits})\\.?|(${hexDigits})?\\.(${hexDigits}))` +
      `[pP][+-]?(${decimalDigits})[fFdD]?\\b` },

    // DecimalIntegerLiteral
    { begin: '\\b(0|[1-9](_*[0-9])*)[lL]?\\b' },

    // HexIntegerLiteral
    { begin: `\\b0[xX](${hexDigits})[lL]?\\b` },

    // OctalIntegerLiteral
    { begin: '\\b0(_*[0-7])*[lL]?\\b' },

    // BinaryIntegerLiteral
    { begin: '\\b0[bB][01](_*[01])*[lL]?\\b' },
  ],
  relevance: 0
};

/*
Language: Java
Author: Vsevolod Solovyov <vsevolod.solovyov@gmail.com>
Category: common, enterprise
Website: https://www.java.com/
*/

/**
 * Allows recursive regex expressions to a given depth
 *
 * ie: recurRegex("(abc~~~)", /~~~/g, 2) becomes:
 * (abc(abc(abc)))
 *
 * @param {string} re
 * @param {RegExp} substitution (should be a g mode regex)
 * @param {number} depth
 * @returns {string}``
 */
function recurRegex(re, substitution, depth) {
  if (depth === -1) return "";

  return re.replace(substitution, _ => {
    return recurRegex(re, substitution, depth - 1);
  });
}

/** @type LanguageFn */
function java(hljs) {
  const regex = hljs.regex;
  const JAVA_IDENT_RE = '[\u00C0-\u02B8a-zA-Z_$][\u00C0-\u02B8a-zA-Z_$0-9]*';
  const GENERIC_IDENT_RE = JAVA_IDENT_RE
    + recurRegex('(?:<' + JAVA_IDENT_RE + '~~~(?:\\s*,\\s*' + JAVA_IDENT_RE + '~~~)*>)?', /~~~/g, 2);
  const MAIN_KEYWORDS = [
    'synchronized',
    'abstract',
    'private',
    'var',
    'static',
    'if',
    'const ',
    'for',
    'while',
    'strictfp',
    'finally',
    'protected',
    'import',
    'native',
    'final',
    'void',
    'enum',
    'else',
    'break',
    'transient',
    'catch',
    'instanceof',
    'volatile',
    'case',
    'assert',
    'package',
    'default',
    'public',
    'try',
    'switch',
    'continue',
    'throws',
    'protected',
    'public',
    'private',
    'module',
    'requires',
    'exports',
    'do',
    'sealed',
    'yield',
    'permits'
  ];

  const BUILT_INS = [
    'super',
    'this'
  ];

  const LITERALS = [
    'false',
    'true',
    'null'
  ];

  const TYPES = [
    'char',
    'boolean',
    'long',
    'float',
    'int',
    'byte',
    'short',
    'double'
  ];

  const KEYWORDS = {
    keyword: MAIN_KEYWORDS,
    literal: LITERALS,
    type: TYPES,
    built_in: BUILT_INS
  };

  const ANNOTATION = {
    className: 'meta',
    begin: '@' + JAVA_IDENT_RE,
    contains: [
      {
        begin: /\(/,
        end: /\)/,
        contains: [ "self" ] // allow nested () inside our annotation
      }
    ]
  };
  const PARAMS = {
    className: 'params',
    begin: /\(/,
    end: /\)/,
    keywords: KEYWORDS,
    relevance: 0,
    contains: [ hljs.C_BLOCK_COMMENT_MODE ],
    endsParent: true
  };

  return {
    name: 'Java',
    aliases: [ 'jsp' ],
    keywords: KEYWORDS,
    illegal: /<\/|#/,
    contains: [
      hljs.COMMENT(
        '/\\*\\*',
        '\\*/',
        {
          relevance: 0,
          contains: [
            {
              // eat up @'s in emails to prevent them to be recognized as doctags
              begin: /\w+@/,
              relevance: 0
            },
            {
              className: 'doctag',
              begin: '@[A-Za-z]+'
            }
          ]
        }
      ),
      // relevance boost
      {
        begin: /import java\.[a-z]+\./,
        keywords: "import",
        relevance: 2
      },
      hljs.C_LINE_COMMENT_MODE,
      hljs.C_BLOCK_COMMENT_MODE,
      {
        begin: /"""/,
        end: /"""/,
        className: "string",
        contains: [ hljs.BACKSLASH_ESCAPE ]
      },
      hljs.APOS_STRING_MODE,
      hljs.QUOTE_STRING_MODE,
      {
        match: [
          /\b(?:class|interface|enum|extends|implements|new)/,
          /\s+/,
          JAVA_IDENT_RE
        ],
        className: {
          1: "keyword",
          3: "title.class"
        }
      },
      {
        // Exceptions for hyphenated keywords
        match: /non-sealed/,
        scope: "keyword"
      },
      {
        begin: [
          regex.concat(/(?!else)/, JAVA_IDENT_RE),
          /\s+/,
          JAVA_IDENT_RE,
          /\s+/,
          /=(?!=)/
        ],
        className: {
          1: "type",
          3: "variable",
          5: "operator"
        }
      },
      {
        begin: [
          /record/,
          /\s+/,
          JAVA_IDENT_RE
        ],
        className: {
          1: "keyword",
          3: "title.class"
        },
        contains: [
          PARAMS,
          hljs.C_LINE_COMMENT_MODE,
          hljs.C_BLOCK_COMMENT_MODE
        ]
      },
      {
        // Expression keywords prevent 'keyword Name(...)' from being
        // recognized as a function definition
        beginKeywords: 'new throw return else',
        relevance: 0
      },
      {
        begin: [
          '(?:' + GENERIC_IDENT_RE + '\\s+)',
          hljs.UNDERSCORE_IDENT_RE,
          /\s*(?=\()/
        ],
        className: { 2: "title.function" },
        keywords: KEYWORDS,
        contains: [
          {
            className: 'params',
            begin: /\(/,
            end: /\)/,
            keywords: KEYWORDS,
            relevance: 0,
            contains: [
              ANNOTATION,
              hljs.APOS_STRING_MODE,
              hljs.QUOTE_STRING_MODE,
              NUMERIC,
              hljs.C_BLOCK_COMMENT_MODE
            ]
          },
          hljs.C_LINE_COMMENT_MODE,
          hljs.C_BLOCK_COMMENT_MODE
        ]
      },
      NUMERIC,
      ANNOTATION
    ]
  };
}

module.exports = java;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/javascript.js":
/*!***************************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/javascript.js ***!
  \***************************************************************/
/***/ (function(module) {

const IDENT_RE = '[A-Za-z$_][0-9A-Za-z$_]*';
const KEYWORDS = [
  "as", // for exports
  "in",
  "of",
  "if",
  "for",
  "while",
  "finally",
  "var",
  "new",
  "function",
  "do",
  "return",
  "void",
  "else",
  "break",
  "catch",
  "instanceof",
  "with",
  "throw",
  "case",
  "default",
  "try",
  "switch",
  "continue",
  "typeof",
  "delete",
  "let",
  "yield",
  "const",
  "class",
  // JS handles these with a special rule
  // "get",
  // "set",
  "debugger",
  "async",
  "await",
  "static",
  "import",
  "from",
  "export",
  "extends"
];
const LITERALS = [
  "true",
  "false",
  "null",
  "undefined",
  "NaN",
  "Infinity"
];

// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects
const TYPES = [
  // Fundamental objects
  "Object",
  "Function",
  "Boolean",
  "Symbol",
  // numbers and dates
  "Math",
  "Date",
  "Number",
  "BigInt",
  // text
  "String",
  "RegExp",
  // Indexed collections
  "Array",
  "Float32Array",
  "Float64Array",
  "Int8Array",
  "Uint8Array",
  "Uint8ClampedArray",
  "Int16Array",
  "Int32Array",
  "Uint16Array",
  "Uint32Array",
  "BigInt64Array",
  "BigUint64Array",
  // Keyed collections
  "Set",
  "Map",
  "WeakSet",
  "WeakMap",
  // Structured data
  "ArrayBuffer",
  "SharedArrayBuffer",
  "Atomics",
  "DataView",
  "JSON",
  // Control abstraction objects
  "Promise",
  "Generator",
  "GeneratorFunction",
  "AsyncFunction",
  // Reflection
  "Reflect",
  "Proxy",
  // Internationalization
  "Intl",
  // WebAssembly
  "WebAssembly"
];

const ERROR_TYPES = [
  "Error",
  "EvalError",
  "InternalError",
  "RangeError",
  "ReferenceError",
  "SyntaxError",
  "TypeError",
  "URIError"
];

const BUILT_IN_GLOBALS = [
  "setInterval",
  "setTimeout",
  "clearInterval",
  "clearTimeout",

  "require",
  "exports",

  "eval",
  "isFinite",
  "isNaN",
  "parseFloat",
  "parseInt",
  "decodeURI",
  "decodeURIComponent",
  "encodeURI",
  "encodeURIComponent",
  "escape",
  "unescape"
];

const BUILT_IN_VARIABLES = [
  "arguments",
  "this",
  "super",
  "console",
  "window",
  "document",
  "localStorage",
  "sessionStorage",
  "module",
  "global" // Node.js
];

const BUILT_INS = [].concat(
  BUILT_IN_GLOBALS,
  TYPES,
  ERROR_TYPES
);

/*
Language: JavaScript
Description: JavaScript (JS) is a lightweight, interpreted, or just-in-time compiled programming language with first-class functions.
Category: common, scripting, web
Website: https://developer.mozilla.org/en-US/docs/Web/JavaScript
*/

/** @type LanguageFn */
function javascript(hljs) {
  const regex = hljs.regex;
  /**
   * Takes a string like "<Booger" and checks to see
   * if we can find a matching "</Booger" later in the
   * content.
   * @param {RegExpMatchArray} match
   * @param {{after:number}} param1
   */
  const hasClosingTag = (match, { after }) => {
    const tag = "</" + match[0].slice(1);
    const pos = match.input.indexOf(tag, after);
    return pos !== -1;
  };

  const IDENT_RE$1 = IDENT_RE;
  const FRAGMENT = {
    begin: '<>',
    end: '</>'
  };
  // to avoid some special cases inside isTrulyOpeningTag
  const XML_SELF_CLOSING = /<[A-Za-z0-9\\._:-]+\s*\/>/;
  const XML_TAG = {
    begin: /<[A-Za-z0-9\\._:-]+/,
    end: /\/[A-Za-z0-9\\._:-]+>|\/>/,
    /**
     * @param {RegExpMatchArray} match
     * @param {CallbackResponse} response
     */
    isTrulyOpeningTag: (match, response) => {
      const afterMatchIndex = match[0].length + match.index;
      const nextChar = match.input[afterMatchIndex];
      if (
        // HTML should not include another raw `<` inside a tag
        // nested type?
        // `<Array<Array<number>>`, etc.
        nextChar === "<" ||
        // the , gives away that this is not HTML
        // `<T, A extends keyof T, V>`
        nextChar === ","
        ) {
        response.ignoreMatch();
        return;
      }

      // `<something>`
      // Quite possibly a tag, lets look for a matching closing tag...
      if (nextChar === ">") {
        // if we cannot find a matching closing tag, then we
        // will ignore it
        if (!hasClosingTag(match, { after: afterMatchIndex })) {
          response.ignoreMatch();
        }
      }

      // `<blah />` (self-closing)
      // handled by simpleSelfClosing rule

      let m;
      const afterMatch = match.input.substring(afterMatchIndex);

      // some more template typing stuff
      //  <T = any>(key?: string) => Modify<
      if ((m = afterMatch.match(/^\s*=/))) {
        response.ignoreMatch();
        return;
      }

      // `<From extends string>`
      // technically this could be HTML, but it smells like a type
      // NOTE: This is ugh, but added specifically for https://github.com/highlightjs/highlight.js/issues/3276
      if ((m = afterMatch.match(/^\s+extends\s+/))) {
        if (m.index === 0) {
          response.ignoreMatch();
          // eslint-disable-next-line no-useless-return
          return;
        }
      }
    }
  };
  const KEYWORDS$1 = {
    $pattern: IDENT_RE,
    keyword: KEYWORDS,
    literal: LITERALS,
    built_in: BUILT_INS,
    "variable.language": BUILT_IN_VARIABLES
  };

  // https://tc39.es/ecma262/#sec-literals-numeric-literals
  const decimalDigits = '[0-9](_?[0-9])*';
  const frac = `\\.(${decimalDigits})`;
  // DecimalIntegerLiteral, including Annex B NonOctalDecimalIntegerLiteral
  // https://tc39.es/ecma262/#sec-additional-syntax-numeric-literals
  const decimalInteger = `0|[1-9](_?[0-9])*|0[0-7]*[89][0-9]*`;
  const NUMBER = {
    className: 'number',
    variants: [
      // DecimalLiteral
      { begin: `(\\b(${decimalInteger})((${frac})|\\.)?|(${frac}))` +
        `[eE][+-]?(${decimalDigits})\\b` },
      { begin: `\\b(${decimalInteger})\\b((${frac})\\b|\\.)?|(${frac})\\b` },

      // DecimalBigIntegerLiteral
      { begin: `\\b(0|[1-9](_?[0-9])*)n\\b` },

      // NonDecimalIntegerLiteral
      { begin: "\\b0[xX][0-9a-fA-F](_?[0-9a-fA-F])*n?\\b" },
      { begin: "\\b0[bB][0-1](_?[0-1])*n?\\b" },
      { begin: "\\b0[oO][0-7](_?[0-7])*n?\\b" },

      // LegacyOctalIntegerLiteral (does not include underscore separators)
      // https://tc39.es/ecma262/#sec-additional-syntax-numeric-literals
      { begin: "\\b0[0-7]+n?\\b" },
    ],
    relevance: 0
  };

  const SUBST = {
    className: 'subst',
    begin: '\\$\\{',
    end: '\\}',
    keywords: KEYWORDS$1,
    contains: [] // defined later
  };
  const HTML_TEMPLATE = {
    begin: 'html`',
    end: '',
    starts: {
      end: '`',
      returnEnd: false,
      contains: [
        hljs.BACKSLASH_ESCAPE,
        SUBST
      ],
      subLanguage: 'xml'
    }
  };
  const CSS_TEMPLATE = {
    begin: 'css`',
    end: '',
    starts: {
      end: '`',
      returnEnd: false,
      contains: [
        hljs.BACKSLASH_ESCAPE,
        SUBST
      ],
      subLanguage: 'css'
    }
  };
  const GRAPHQL_TEMPLATE = {
    begin: 'gql`',
    end: '',
    starts: {
      end: '`',
      returnEnd: false,
      contains: [
        hljs.BACKSLASH_ESCAPE,
        SUBST
      ],
      subLanguage: 'graphql'
    }
  };
  const TEMPLATE_STRING = {
    className: 'string',
    begin: '`',
    end: '`',
    contains: [
      hljs.BACKSLASH_ESCAPE,
      SUBST
    ]
  };
  const JSDOC_COMMENT = hljs.COMMENT(
    /\/\*\*(?!\/)/,
    '\\*/',
    {
      relevance: 0,
      contains: [
        {
          begin: '(?=@[A-Za-z]+)',
          relevance: 0,
          contains: [
            {
              className: 'doctag',
              begin: '@[A-Za-z]+'
            },
            {
              className: 'type',
              begin: '\\{',
              end: '\\}',
              excludeEnd: true,
              excludeBegin: true,
              relevance: 0
            },
            {
              className: 'variable',
              begin: IDENT_RE$1 + '(?=\\s*(-)|$)',
              endsParent: true,
              relevance: 0
            },
            // eat spaces (not newlines) so we can find
            // types or variables
            {
              begin: /(?=[^\n])\s/,
              relevance: 0
            }
          ]
        }
      ]
    }
  );
  const COMMENT = {
    className: "comment",
    variants: [
      JSDOC_COMMENT,
      hljs.C_BLOCK_COMMENT_MODE,
      hljs.C_LINE_COMMENT_MODE
    ]
  };
  const SUBST_INTERNALS = [
    hljs.APOS_STRING_MODE,
    hljs.QUOTE_STRING_MODE,
    HTML_TEMPLATE,
    CSS_TEMPLATE,
    GRAPHQL_TEMPLATE,
    TEMPLATE_STRING,
    // Skip numbers when they are part of a variable name
    { match: /\$\d+/ },
    NUMBER,
    // This is intentional:
    // See https://github.com/highlightjs/highlight.js/issues/3288
    // hljs.REGEXP_MODE
  ];
  SUBST.contains = SUBST_INTERNALS
    .concat({
      // we need to pair up {} inside our subst to prevent
      // it from ending too early by matching another }
      begin: /\{/,
      end: /\}/,
      keywords: KEYWORDS$1,
      contains: [
        "self"
      ].concat(SUBST_INTERNALS)
    });
  const SUBST_AND_COMMENTS = [].concat(COMMENT, SUBST.contains);
  const PARAMS_CONTAINS = SUBST_AND_COMMENTS.concat([
    // eat recursive parens in sub expressions
    {
      begin: /\(/,
      end: /\)/,
      keywords: KEYWORDS$1,
      contains: ["self"].concat(SUBST_AND_COMMENTS)
    }
  ]);
  const PARAMS = {
    className: 'params',
    begin: /\(/,
    end: /\)/,
    excludeBegin: true,
    excludeEnd: true,
    keywords: KEYWORDS$1,
    contains: PARAMS_CONTAINS
  };

  // ES6 classes
  const CLASS_OR_EXTENDS = {
    variants: [
      // class Car extends vehicle
      {
        match: [
          /class/,
          /\s+/,
          IDENT_RE$1,
          /\s+/,
          /extends/,
          /\s+/,
          regex.concat(IDENT_RE$1, "(", regex.concat(/\./, IDENT_RE$1), ")*")
        ],
        scope: {
          1: "keyword",
          3: "title.class",
          5: "keyword",
          7: "title.class.inherited"
        }
      },
      // class Car
      {
        match: [
          /class/,
          /\s+/,
          IDENT_RE$1
        ],
        scope: {
          1: "keyword",
          3: "title.class"
        }
      },

    ]
  };

  const CLASS_REFERENCE = {
    relevance: 0,
    match:
    regex.either(
      // Hard coded exceptions
      /\bJSON/,
      // Float32Array, OutT
      /\b[A-Z][a-z]+([A-Z][a-z]*|\d)*/,
      // CSSFactory, CSSFactoryT
      /\b[A-Z]{2,}([A-Z][a-z]+|\d)+([A-Z][a-z]*)*/,
      // FPs, FPsT
      /\b[A-Z]{2,}[a-z]+([A-Z][a-z]+|\d)*([A-Z][a-z]*)*/,
      // P
      // single letters are not highlighted
      // BLAH
      // this will be flagged as a UPPER_CASE_CONSTANT instead
    ),
    className: "title.class",
    keywords: {
      _: [
        // se we still get relevance credit for JS library classes
        ...TYPES,
        ...ERROR_TYPES
      ]
    }
  };

  const USE_STRICT = {
    label: "use_strict",
    className: 'meta',
    relevance: 10,
    begin: /^\s*['"]use (strict|asm)['"]/
  };

  const FUNCTION_DEFINITION = {
    variants: [
      {
        match: [
          /function/,
          /\s+/,
          IDENT_RE$1,
          /(?=\s*\()/
        ]
      },
      // anonymous function
      {
        match: [
          /function/,
          /\s*(?=\()/
        ]
      }
    ],
    className: {
      1: "keyword",
      3: "title.function"
    },
    label: "func.def",
    contains: [ PARAMS ],
    illegal: /%/
  };

  const UPPER_CASE_CONSTANT = {
    relevance: 0,
    match: /\b[A-Z][A-Z_0-9]+\b/,
    className: "variable.constant"
  };

  function noneOf(list) {
    return regex.concat("(?!", list.join("|"), ")");
  }

  const FUNCTION_CALL = {
    match: regex.concat(
      /\b/,
      noneOf([
        ...BUILT_IN_GLOBALS,
        "super",
        "import"
      ]),
      IDENT_RE$1, regex.lookahead(/\(/)),
    className: "title.function",
    relevance: 0
  };

  const PROPERTY_ACCESS = {
    begin: regex.concat(/\./, regex.lookahead(
      regex.concat(IDENT_RE$1, /(?![0-9A-Za-z$_(])/)
    )),
    end: IDENT_RE$1,
    excludeBegin: true,
    keywords: "prototype",
    className: "property",
    relevance: 0
  };

  const GETTER_OR_SETTER = {
    match: [
      /get|set/,
      /\s+/,
      IDENT_RE$1,
      /(?=\()/
    ],
    className: {
      1: "keyword",
      3: "title.function"
    },
    contains: [
      { // eat to avoid empty params
        begin: /\(\)/
      },
      PARAMS
    ]
  };

  const FUNC_LEAD_IN_RE = '(\\(' +
    '[^()]*(\\(' +
    '[^()]*(\\(' +
    '[^()]*' +
    '\\)[^()]*)*' +
    '\\)[^()]*)*' +
    '\\)|' + hljs.UNDERSCORE_IDENT_RE + ')\\s*=>';

  const FUNCTION_VARIABLE = {
    match: [
      /const|var|let/, /\s+/,
      IDENT_RE$1, /\s*/,
      /=\s*/,
      /(async\s*)?/, // async is optional
      regex.lookahead(FUNC_LEAD_IN_RE)
    ],
    keywords: "async",
    className: {
      1: "keyword",
      3: "title.function"
    },
    contains: [
      PARAMS
    ]
  };

  return {
    name: 'JavaScript',
    aliases: ['js', 'jsx', 'mjs', 'cjs'],
    keywords: KEYWORDS$1,
    // this will be extended by TypeScript
    exports: { PARAMS_CONTAINS, CLASS_REFERENCE },
    illegal: /#(?![$_A-z])/,
    contains: [
      hljs.SHEBANG({
        label: "shebang",
        binary: "node",
        relevance: 5
      }),
      USE_STRICT,
      hljs.APOS_STRING_MODE,
      hljs.QUOTE_STRING_MODE,
      HTML_TEMPLATE,
      CSS_TEMPLATE,
      GRAPHQL_TEMPLATE,
      TEMPLATE_STRING,
      COMMENT,
      // Skip numbers when they are part of a variable name
      { match: /\$\d+/ },
      NUMBER,
      CLASS_REFERENCE,
      {
        className: 'attr',
        begin: IDENT_RE$1 + regex.lookahead(':'),
        relevance: 0
      },
      FUNCTION_VARIABLE,
      { // "value" container
        begin: '(' + hljs.RE_STARTERS_RE + '|\\b(case|return|throw)\\b)\\s*',
        keywords: 'return throw case',
        relevance: 0,
        contains: [
          COMMENT,
          hljs.REGEXP_MODE,
          {
            className: 'function',
            // we have to count the parens to make sure we actually have the
            // correct bounding ( ) before the =>.  There could be any number of
            // sub-expressions inside also surrounded by parens.
            begin: FUNC_LEAD_IN_RE,
            returnBegin: true,
            end: '\\s*=>',
            contains: [
              {
                className: 'params',
                variants: [
                  {
                    begin: hljs.UNDERSCORE_IDENT_RE,
                    relevance: 0
                  },
                  {
                    className: null,
                    begin: /\(\s*\)/,
                    skip: true
                  },
                  {
                    begin: /\(/,
                    end: /\)/,
                    excludeBegin: true,
                    excludeEnd: true,
                    keywords: KEYWORDS$1,
                    contains: PARAMS_CONTAINS
                  }
                ]
              }
            ]
          },
          { // could be a comma delimited list of params to a function call
            begin: /,/,
            relevance: 0
          },
          {
            match: /\s+/,
            relevance: 0
          },
          { // JSX
            variants: [
              { begin: FRAGMENT.begin, end: FRAGMENT.end },
              { match: XML_SELF_CLOSING },
              {
                begin: XML_TAG.begin,
                // we carefully check the opening tag to see if it truly
                // is a tag and not a false positive
                'on:begin': XML_TAG.isTrulyOpeningTag,
                end: XML_TAG.end
              }
            ],
            subLanguage: 'xml',
            contains: [
              {
                begin: XML_TAG.begin,
                end: XML_TAG.end,
                skip: true,
                contains: ['self']
              }
            ]
          }
        ],
      },
      FUNCTION_DEFINITION,
      {
        // prevent this from getting swallowed up by function
        // since they appear "function like"
        beginKeywords: "while if switch catch for"
      },
      {
        // we have to count the parens to make sure we actually have the correct
        // bounding ( ).  There could be any number of sub-expressions inside
        // also surrounded by parens.
        begin: '\\b(?!function)' + hljs.UNDERSCORE_IDENT_RE +
          '\\(' + // first parens
          '[^()]*(\\(' +
            '[^()]*(\\(' +
              '[^()]*' +
            '\\)[^()]*)*' +
          '\\)[^()]*)*' +
          '\\)\\s*\\{', // end parens
        returnBegin:true,
        label: "func.def",
        contains: [
          PARAMS,
          hljs.inherit(hljs.TITLE_MODE, { begin: IDENT_RE$1, className: "title.function" })
        ]
      },
      // catch ... so it won't trigger the property rule below
      {
        match: /\.\.\./,
        relevance: 0
      },
      PROPERTY_ACCESS,
      // hack: prevents detection of keywords in some circumstances
      // .keyword()
      // $keyword = x
      {
        match: '\\$' + IDENT_RE$1,
        relevance: 0
      },
      {
        match: [ /\bconstructor(?=\s*\()/ ],
        className: { 1: "title.function" },
        contains: [ PARAMS ]
      },
      FUNCTION_CALL,
      UPPER_CASE_CONSTANT,
      CLASS_OR_EXTENDS,
      GETTER_OR_SETTER,
      {
        match: /\$[(.]/ // relevance booster for a pattern common to JS libs: `$(something)` and `$.something`
      }
    ]
  };
}

module.exports = javascript;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/jboss-cli.js":
/*!**************************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/jboss-cli.js ***!
  \**************************************************************/
/***/ (function(module) {

/*
 Language: JBoss CLI
 Author: Raphaël Parrëe <rparree@edc4it.com>
 Description: language definition jboss cli
 Website: https://docs.jboss.org/author/display/WFLY/Command+Line+Interface
 Category: config
 */

function jbossCli(hljs) {
  const PARAM = {
    begin: /[\w-]+ *=/,
    returnBegin: true,
    relevance: 0,
    contains: [
      {
        className: 'attr',
        begin: /[\w-]+/
      }
    ]
  };
  const PARAMSBLOCK = {
    className: 'params',
    begin: /\(/,
    end: /\)/,
    contains: [ PARAM ],
    relevance: 0
  };
  const OPERATION = {
    className: 'function',
    begin: /:[\w\-.]+/,
    relevance: 0
  };
  const PATH = {
    className: 'string',
    begin: /\B([\/.])[\w\-.\/=]+/
  };
  const COMMAND_PARAMS = {
    className: 'params',
    begin: /--[\w\-=\/]+/
  };
  return {
    name: 'JBoss CLI',
    aliases: [ 'wildfly-cli' ],
    keywords: {
      $pattern: '[a-z\-]+',
      keyword: 'alias batch cd clear command connect connection-factory connection-info data-source deploy '
      + 'deployment-info deployment-overlay echo echo-dmr help history if jdbc-driver-info jms-queue|20 jms-topic|20 ls '
      + 'patch pwd quit read-attribute read-operation reload rollout-plan run-batch set shutdown try unalias '
      + 'undeploy unset version xa-data-source', // module
      literal: 'true false'
    },
    contains: [
      hljs.HASH_COMMENT_MODE,
      hljs.QUOTE_STRING_MODE,
      COMMAND_PARAMS,
      OPERATION,
      PATH,
      PARAMSBLOCK
    ]
  };
}

module.exports = jbossCli;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/json.js":
/*!*********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/json.js ***!
  \*********************************************************/
/***/ (function(module) {

/*
Language: JSON
Description: JSON (JavaScript Object Notation) is a lightweight data-interchange format.
Author: Ivan Sagalaev <maniac@softwaremaniacs.org>
Website: http://www.json.org
Category: common, protocols, web
*/

function json(hljs) {
  const ATTRIBUTE = {
    className: 'attr',
    begin: /"(\\.|[^\\"\r\n])*"(?=\s*:)/,
    relevance: 1.01
  };
  const PUNCTUATION = {
    match: /[{}[\],:]/,
    className: "punctuation",
    relevance: 0
  };
  const LITERALS = [
    "true",
    "false",
    "null"
  ];
  // NOTE: normally we would rely on `keywords` for this but using a mode here allows us
  // - to use the very tight `illegal: \S` rule later to flag any other character
  // - as illegal indicating that despite looking like JSON we do not truly have
  // - JSON and thus improve false-positively greatly since JSON will try and claim
  // - all sorts of JSON looking stuff
  const LITERALS_MODE = {
    scope: "literal",
    beginKeywords: LITERALS.join(" "),
  };

  return {
    name: 'JSON',
    keywords:{
      literal: LITERALS,
    },
    contains: [
      ATTRIBUTE,
      PUNCTUATION,
      hljs.QUOTE_STRING_MODE,
      LITERALS_MODE,
      hljs.C_NUMBER_MODE,
      hljs.C_LINE_COMMENT_MODE,
      hljs.C_BLOCK_COMMENT_MODE
    ],
    illegal: '\\S'
  };
}

module.exports = json;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/julia-repl.js":
/*!***************************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/julia-repl.js ***!
  \***************************************************************/
/***/ (function(module) {

/*
Language: Julia REPL
Description: Julia REPL sessions
Author: Morten Piibeleht <morten.piibeleht@gmail.com>
Website: https://julialang.org
Requires: julia.js

The Julia REPL code blocks look something like the following:

  julia> function foo(x)
             x + 1
         end
  foo (generic function with 1 method)

They start on a new line with "julia>". Usually there should also be a space after this, but
we also allow the code to start right after the > character. The code may run over multiple
lines, but the additional lines must start with six spaces (i.e. be indented to match
"julia>"). The rest of the code is assumed to be output from the executed code and will be
left un-highlighted.

Using simply spaces to identify line continuations may get a false-positive if the output
also prints out six spaces, but such cases should be rare.
*/

function juliaRepl(hljs) {
  return {
    name: 'Julia REPL',
    contains: [
      {
        className: 'meta.prompt',
        begin: /^julia>/,
        relevance: 10,
        starts: {
          // end the highlighting if we are on a new line and the line does not have at
          // least six spaces in the beginning
          end: /^(?![ ]{6})/,
          subLanguage: 'julia'
        },
      },
    ],
    // jldoctest Markdown blocks are used in the Julia manual and package docs indicate
    // code snippets that should be verified when the documentation is built. They can be
    // either REPL-like or script-like, but are usually REPL-like and therefore we apply
    // julia-repl highlighting to them. More information can be found in Documenter's
    // manual: https://juliadocs.github.io/Documenter.jl/latest/man/doctests.html
    aliases: [ 'jldoctest' ],
  };
}

module.exports = juliaRepl;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/julia.js":
/*!**********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/julia.js ***!
  \**********************************************************/
/***/ (function(module) {

/*
Language: Julia
Description: Julia is a high-level, high-performance, dynamic programming language.
Author: Kenta Sato <bicycle1885@gmail.com>
Contributors: Alex Arslan <ararslan@comcast.net>, Fredrik Ekre <ekrefredrik@gmail.com>
Website: https://julialang.org
*/

function julia(hljs) {
  // Since there are numerous special names in Julia, it is too much trouble
  // to maintain them by hand. Hence these names (i.e. keywords, literals and
  // built-ins) are automatically generated from Julia 1.5.2 itself through
  // the following scripts for each.

  // ref: https://docs.julialang.org/en/v1/manual/variables/#Allowed-Variable-Names
  const VARIABLE_NAME_RE = '[A-Za-z_\\u00A1-\\uFFFF][A-Za-z_0-9\\u00A1-\\uFFFF]*';

  // # keyword generator, multi-word keywords handled manually below (Julia 1.5.2)
  // import REPL.REPLCompletions
  // res = String["in", "isa", "where"]
  // for kw in collect(x.keyword for x in REPLCompletions.complete_keyword(""))
  //     if !(contains(kw, " ") || kw == "struct")
  //         push!(res, kw)
  //     end
  // end
  // sort!(unique!(res))
  // foreach(x -> println("\'", x, "\',"), res)
  const KEYWORD_LIST = [
    'baremodule',
    'begin',
    'break',
    'catch',
    'ccall',
    'const',
    'continue',
    'do',
    'else',
    'elseif',
    'end',
    'export',
    'false',
    'finally',
    'for',
    'function',
    'global',
    'if',
    'import',
    'in',
    'isa',
    'let',
    'local',
    'macro',
    'module',
    'quote',
    'return',
    'true',
    'try',
    'using',
    'where',
    'while',
  ];

  // # literal generator (Julia 1.5.2)
  // import REPL.REPLCompletions
  // res = String["true", "false"]
  // for compl in filter!(x -> isa(x, REPLCompletions.ModuleCompletion) && (x.parent === Base || x.parent === Core),
  //                     REPLCompletions.completions("", 0)[1])
  //     try
  //         v = eval(Symbol(compl.mod))
  //         if !(v isa Function || v isa Type || v isa TypeVar || v isa Module || v isa Colon)
  //             push!(res, compl.mod)
  //         end
  //     catch e
  //     end
  // end
  // sort!(unique!(res))
  // foreach(x -> println("\'", x, "\',"), res)
  const LITERAL_LIST = [
    'ARGS',
    'C_NULL',
    'DEPOT_PATH',
    'ENDIAN_BOM',
    'ENV',
    'Inf',
    'Inf16',
    'Inf32',
    'Inf64',
    'InsertionSort',
    'LOAD_PATH',
    'MergeSort',
    'NaN',
    'NaN16',
    'NaN32',
    'NaN64',
    'PROGRAM_FILE',
    'QuickSort',
    'RoundDown',
    'RoundFromZero',
    'RoundNearest',
    'RoundNearestTiesAway',
    'RoundNearestTiesUp',
    'RoundToZero',
    'RoundUp',
    'VERSION|0',
    'devnull',
    'false',
    'im',
    'missing',
    'nothing',
    'pi',
    'stderr',
    'stdin',
    'stdout',
    'true',
    'undef',
    'π',
    'ℯ',
  ];

  // # built_in generator (Julia 1.5.2)
  // import REPL.REPLCompletions
  // res = String[]
  // for compl in filter!(x -> isa(x, REPLCompletions.ModuleCompletion) && (x.parent === Base || x.parent === Core),
  //                     REPLCompletions.completions("", 0)[1])
  //     try
  //         v = eval(Symbol(compl.mod))
  //         if (v isa Type || v isa TypeVar) && (compl.mod != "=>")
  //             push!(res, compl.mod)
  //         end
  //     catch e
  //     end
  // end
  // sort!(unique!(res))
  // foreach(x -> println("\'", x, "\',"), res)
  const BUILT_IN_LIST = [
    'AbstractArray',
    'AbstractChannel',
    'AbstractChar',
    'AbstractDict',
    'AbstractDisplay',
    'AbstractFloat',
    'AbstractIrrational',
    'AbstractMatrix',
    'AbstractRange',
    'AbstractSet',
    'AbstractString',
    'AbstractUnitRange',
    'AbstractVecOrMat',
    'AbstractVector',
    'Any',
    'ArgumentError',
    'Array',
    'AssertionError',
    'BigFloat',
    'BigInt',
    'BitArray',
    'BitMatrix',
    'BitSet',
    'BitVector',
    'Bool',
    'BoundsError',
    'CapturedException',
    'CartesianIndex',
    'CartesianIndices',
    'Cchar',
    'Cdouble',
    'Cfloat',
    'Channel',
    'Char',
    'Cint',
    'Cintmax_t',
    'Clong',
    'Clonglong',
    'Cmd',
    'Colon',
    'Complex',
    'ComplexF16',
    'ComplexF32',
    'ComplexF64',
    'CompositeException',
    'Condition',
    'Cptrdiff_t',
    'Cshort',
    'Csize_t',
    'Cssize_t',
    'Cstring',
    'Cuchar',
    'Cuint',
    'Cuintmax_t',
    'Culong',
    'Culonglong',
    'Cushort',
    'Cvoid',
    'Cwchar_t',
    'Cwstring',
    'DataType',
    'DenseArray',
    'DenseMatrix',
    'DenseVecOrMat',
    'DenseVector',
    'Dict',
    'DimensionMismatch',
    'Dims',
    'DivideError',
    'DomainError',
    'EOFError',
    'Enum',
    'ErrorException',
    'Exception',
    'ExponentialBackOff',
    'Expr',
    'Float16',
    'Float32',
    'Float64',
    'Function',
    'GlobalRef',
    'HTML',
    'IO',
    'IOBuffer',
    'IOContext',
    'IOStream',
    'IdDict',
    'IndexCartesian',
    'IndexLinear',
    'IndexStyle',
    'InexactError',
    'InitError',
    'Int',
    'Int128',
    'Int16',
    'Int32',
    'Int64',
    'Int8',
    'Integer',
    'InterruptException',
    'InvalidStateException',
    'Irrational',
    'KeyError',
    'LinRange',
    'LineNumberNode',
    'LinearIndices',
    'LoadError',
    'MIME',
    'Matrix',
    'Method',
    'MethodError',
    'Missing',
    'MissingException',
    'Module',
    'NTuple',
    'NamedTuple',
    'Nothing',
    'Number',
    'OrdinalRange',
    'OutOfMemoryError',
    'OverflowError',
    'Pair',
    'PartialQuickSort',
    'PermutedDimsArray',
    'Pipe',
    'ProcessFailedException',
    'Ptr',
    'QuoteNode',
    'Rational',
    'RawFD',
    'ReadOnlyMemoryError',
    'Real',
    'ReentrantLock',
    'Ref',
    'Regex',
    'RegexMatch',
    'RoundingMode',
    'SegmentationFault',
    'Set',
    'Signed',
    'Some',
    'StackOverflowError',
    'StepRange',
    'StepRangeLen',
    'StridedArray',
    'StridedMatrix',
    'StridedVecOrMat',
    'StridedVector',
    'String',
    'StringIndexError',
    'SubArray',
    'SubString',
    'SubstitutionString',
    'Symbol',
    'SystemError',
    'Task',
    'TaskFailedException',
    'Text',
    'TextDisplay',
    'Timer',
    'Tuple',
    'Type',
    'TypeError',
    'TypeVar',
    'UInt',
    'UInt128',
    'UInt16',
    'UInt32',
    'UInt64',
    'UInt8',
    'UndefInitializer',
    'UndefKeywordError',
    'UndefRefError',
    'UndefVarError',
    'Union',
    'UnionAll',
    'UnitRange',
    'Unsigned',
    'Val',
    'Vararg',
    'VecElement',
    'VecOrMat',
    'Vector',
    'VersionNumber',
    'WeakKeyDict',
    'WeakRef',
  ];

  const KEYWORDS = {
    $pattern: VARIABLE_NAME_RE,
    keyword: KEYWORD_LIST,
    literal: LITERAL_LIST,
    built_in: BUILT_IN_LIST,
  };

  // placeholder for recursive self-reference
  const DEFAULT = {
    keywords: KEYWORDS,
    illegal: /<\//
  };

  // ref: https://docs.julialang.org/en/v1/manual/integers-and-floating-point-numbers/
  const NUMBER = {
    className: 'number',
    // supported numeric literals:
    //  * binary literal (e.g. 0x10)
    //  * octal literal (e.g. 0o76543210)
    //  * hexadecimal literal (e.g. 0xfedcba876543210)
    //  * hexadecimal floating point literal (e.g. 0x1p0, 0x1.2p2)
    //  * decimal literal (e.g. 9876543210, 100_000_000)
    //  * floating pointe literal (e.g. 1.2, 1.2f, .2, 1., 1.2e10, 1.2e-10)
    begin: /(\b0x[\d_]*(\.[\d_]*)?|0x\.\d[\d_]*)p[-+]?\d+|\b0[box][a-fA-F0-9][a-fA-F0-9_]*|(\b\d[\d_]*(\.[\d_]*)?|\.\d[\d_]*)([eEfF][-+]?\d+)?/,
    relevance: 0
  };

  const CHAR = {
    className: 'string',
    begin: /'(.|\\[xXuU][a-zA-Z0-9]+)'/
  };

  const INTERPOLATION = {
    className: 'subst',
    begin: /\$\(/,
    end: /\)/,
    keywords: KEYWORDS
  };

  const INTERPOLATED_VARIABLE = {
    className: 'variable',
    begin: '\\$' + VARIABLE_NAME_RE
  };

  // TODO: neatly escape normal code in string literal
  const STRING = {
    className: 'string',
    contains: [
      hljs.BACKSLASH_ESCAPE,
      INTERPOLATION,
      INTERPOLATED_VARIABLE
    ],
    variants: [
      {
        begin: /\w*"""/,
        end: /"""\w*/,
        relevance: 10
      },
      {
        begin: /\w*"/,
        end: /"\w*/
      }
    ]
  };

  const COMMAND = {
    className: 'string',
    contains: [
      hljs.BACKSLASH_ESCAPE,
      INTERPOLATION,
      INTERPOLATED_VARIABLE
    ],
    begin: '`',
    end: '`'
  };

  const MACROCALL = {
    className: 'meta',
    begin: '@' + VARIABLE_NAME_RE
  };

  const COMMENT = {
    className: 'comment',
    variants: [
      {
        begin: '#=',
        end: '=#',
        relevance: 10
      },
      {
        begin: '#',
        end: '$'
      }
    ]
  };

  DEFAULT.name = 'Julia';
  DEFAULT.contains = [
    NUMBER,
    CHAR,
    STRING,
    COMMAND,
    MACROCALL,
    COMMENT,
    hljs.HASH_COMMENT_MODE,
    {
      className: 'keyword',
      begin:
        '\\b(((abstract|primitive)\\s+)type|(mutable\\s+)?struct)\\b'
    },
    { begin: /<:/ } // relevance booster
  ];
  INTERPOLATION.contains = DEFAULT.contains;

  return DEFAULT;
}

module.exports = julia;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/kotlin.js":
/*!***********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/kotlin.js ***!
  \***********************************************************/
/***/ (function(module) {

// https://docs.oracle.com/javase/specs/jls/se15/html/jls-3.html#jls-3.10
var decimalDigits = '[0-9](_*[0-9])*';
var frac = `\\.(${decimalDigits})`;
var hexDigits = '[0-9a-fA-F](_*[0-9a-fA-F])*';
var NUMERIC = {
  className: 'number',
  variants: [
    // DecimalFloatingPointLiteral
    // including ExponentPart
    { begin: `(\\b(${decimalDigits})((${frac})|\\.)?|(${frac}))` +
      `[eE][+-]?(${decimalDigits})[fFdD]?\\b` },
    // excluding ExponentPart
    { begin: `\\b(${decimalDigits})((${frac})[fFdD]?\\b|\\.([fFdD]\\b)?)` },
    { begin: `(${frac})[fFdD]?\\b` },
    { begin: `\\b(${decimalDigits})[fFdD]\\b` },

    // HexadecimalFloatingPointLiteral
    { begin: `\\b0[xX]((${hexDigits})\\.?|(${hexDigits})?\\.(${hexDigits}))` +
      `[pP][+-]?(${decimalDigits})[fFdD]?\\b` },

    // DecimalIntegerLiteral
    { begin: '\\b(0|[1-9](_*[0-9])*)[lL]?\\b' },

    // HexIntegerLiteral
    { begin: `\\b0[xX](${hexDigits})[lL]?\\b` },

    // OctalIntegerLiteral
    { begin: '\\b0(_*[0-7])*[lL]?\\b' },

    // BinaryIntegerLiteral
    { begin: '\\b0[bB][01](_*[01])*[lL]?\\b' },
  ],
  relevance: 0
};

/*
 Language: Kotlin
 Description: Kotlin is an OSS statically typed programming language that targets the JVM, Android, JavaScript and Native.
 Author: Sergey Mashkov <cy6erGn0m@gmail.com>
 Website: https://kotlinlang.org
 Category: common
 */

function kotlin(hljs) {
  const KEYWORDS = {
    keyword:
      'abstract as val var vararg get set class object open private protected public noinline '
      + 'crossinline dynamic final enum if else do while for when throw try catch finally '
      + 'import package is in fun override companion reified inline lateinit init '
      + 'interface annotation data sealed internal infix operator out by constructor super '
      + 'tailrec where const inner suspend typealias external expect actual',
    built_in:
      'Byte Short Char Int Long Boolean Float Double Void Unit Nothing',
    literal:
      'true false null'
  };
  const KEYWORDS_WITH_LABEL = {
    className: 'keyword',
    begin: /\b(break|continue|return|this)\b/,
    starts: { contains: [
      {
        className: 'symbol',
        begin: /@\w+/
      }
    ] }
  };
  const LABEL = {
    className: 'symbol',
    begin: hljs.UNDERSCORE_IDENT_RE + '@'
  };

  // for string templates
  const SUBST = {
    className: 'subst',
    begin: /\$\{/,
    end: /\}/,
    contains: [ hljs.C_NUMBER_MODE ]
  };
  const VARIABLE = {
    className: 'variable',
    begin: '\\$' + hljs.UNDERSCORE_IDENT_RE
  };
  const STRING = {
    className: 'string',
    variants: [
      {
        begin: '"""',
        end: '"""(?=[^"])',
        contains: [
          VARIABLE,
          SUBST
        ]
      },
      // Can't use built-in modes easily, as we want to use STRING in the meta
      // context as 'meta-string' and there's no syntax to remove explicitly set
      // classNames in built-in modes.
      {
        begin: '\'',
        end: '\'',
        illegal: /\n/,
        contains: [ hljs.BACKSLASH_ESCAPE ]
      },
      {
        begin: '"',
        end: '"',
        illegal: /\n/,
        contains: [
          hljs.BACKSLASH_ESCAPE,
          VARIABLE,
          SUBST
        ]
      }
    ]
  };
  SUBST.contains.push(STRING);

  const ANNOTATION_USE_SITE = {
    className: 'meta',
    begin: '@(?:file|property|field|get|set|receiver|param|setparam|delegate)\\s*:(?:\\s*' + hljs.UNDERSCORE_IDENT_RE + ')?'
  };
  const ANNOTATION = {
    className: 'meta',
    begin: '@' + hljs.UNDERSCORE_IDENT_RE,
    contains: [
      {
        begin: /\(/,
        end: /\)/,
        contains: [
          hljs.inherit(STRING, { className: 'string' }),
          "self"
        ]
      }
    ]
  };

  // https://kotlinlang.org/docs/reference/whatsnew11.html#underscores-in-numeric-literals
  // According to the doc above, the number mode of kotlin is the same as java 8,
  // so the code below is copied from java.js
  const KOTLIN_NUMBER_MODE = NUMERIC;
  const KOTLIN_NESTED_COMMENT = hljs.COMMENT(
    '/\\*', '\\*/',
    { contains: [ hljs.C_BLOCK_COMMENT_MODE ] }
  );
  const KOTLIN_PAREN_TYPE = { variants: [
    {
      className: 'type',
      begin: hljs.UNDERSCORE_IDENT_RE
    },
    {
      begin: /\(/,
      end: /\)/,
      contains: [] // defined later
    }
  ] };
  const KOTLIN_PAREN_TYPE2 = KOTLIN_PAREN_TYPE;
  KOTLIN_PAREN_TYPE2.variants[1].contains = [ KOTLIN_PAREN_TYPE ];
  KOTLIN_PAREN_TYPE.variants[1].contains = [ KOTLIN_PAREN_TYPE2 ];

  return {
    name: 'Kotlin',
    aliases: [
      'kt',
      'kts'
    ],
    keywords: KEYWORDS,
    contains: [
      hljs.COMMENT(
        '/\\*\\*',
        '\\*/',
        {
          relevance: 0,
          contains: [
            {
              className: 'doctag',
              begin: '@[A-Za-z]+'
            }
          ]
        }
      ),
      hljs.C_LINE_COMMENT_MODE,
      KOTLIN_NESTED_COMMENT,
      KEYWORDS_WITH_LABEL,
      LABEL,
      ANNOTATION_USE_SITE,
      ANNOTATION,
      {
        className: 'function',
        beginKeywords: 'fun',
        end: '[(]|$',
        returnBegin: true,
        excludeEnd: true,
        keywords: KEYWORDS,
        relevance: 5,
        contains: [
          {
            begin: hljs.UNDERSCORE_IDENT_RE + '\\s*\\(',
            returnBegin: true,
            relevance: 0,
            contains: [ hljs.UNDERSCORE_TITLE_MODE ]
          },
          {
            className: 'type',
            begin: /</,
            end: />/,
            keywords: 'reified',
            relevance: 0
          },
          {
            className: 'params',
            begin: /\(/,
            end: /\)/,
            endsParent: true,
            keywords: KEYWORDS,
            relevance: 0,
            contains: [
              {
                begin: /:/,
                end: /[=,\/]/,
                endsWithParent: true,
                contains: [
                  KOTLIN_PAREN_TYPE,
                  hljs.C_LINE_COMMENT_MODE,
                  KOTLIN_NESTED_COMMENT
                ],
                relevance: 0
              },
              hljs.C_LINE_COMMENT_MODE,
              KOTLIN_NESTED_COMMENT,
              ANNOTATION_USE_SITE,
              ANNOTATION,
              STRING,
              hljs.C_NUMBER_MODE
            ]
          },
          KOTLIN_NESTED_COMMENT
        ]
      },
      {
        begin: [
          /class|interface|trait/,
          /\s+/,
          hljs.UNDERSCORE_IDENT_RE
        ],
        beginScope: {
          3: "title.class"
        },
        keywords: 'class interface trait',
        end: /[:\{(]|$/,
        excludeEnd: true,
        illegal: 'extends implements',
        contains: [
          { beginKeywords: 'public protected internal private constructor' },
          hljs.UNDERSCORE_TITLE_MODE,
          {
            className: 'type',
            begin: /</,
            end: />/,
            excludeBegin: true,
            excludeEnd: true,
            relevance: 0
          },
          {
            className: 'type',
            begin: /[,:]\s*/,
            end: /[<\(,){\s]|$/,
            excludeBegin: true,
            returnEnd: true
          },
          ANNOTATION_USE_SITE,
          ANNOTATION
        ]
      },
      STRING,
      {
        className: 'meta',
        begin: "^#!/usr/bin/env",
        end: '$',
        illegal: '\n'
      },
      KOTLIN_NUMBER_MODE
    ]
  };
}

module.exports = kotlin;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/lasso.js":
/*!**********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/lasso.js ***!
  \**********************************************************/
/***/ (function(module) {

/*
Language: Lasso
Author: Eric Knibbe <eric@lassosoft.com>
Description: Lasso is a language and server platform for database-driven web applications. This definition handles Lasso 9 syntax and LassoScript for Lasso 8.6 and earlier.
Website: http://www.lassosoft.com/What-Is-Lasso
*/

function lasso(hljs) {
  const LASSO_IDENT_RE = '[a-zA-Z_][\\w.]*';
  const LASSO_ANGLE_RE = '<\\?(lasso(script)?|=)';
  const LASSO_CLOSE_RE = '\\]|\\?>';
  const LASSO_KEYWORDS = {
    $pattern: LASSO_IDENT_RE + '|&[lg]t;',
    literal:
      'true false none minimal full all void and or not '
      + 'bw nbw ew new cn ncn lt lte gt gte eq neq rx nrx ft',
    built_in:
      'array date decimal duration integer map pair string tag xml null '
      + 'boolean bytes keyword list locale queue set stack staticarray '
      + 'local var variable global data self inherited currentcapture givenblock',
    keyword:
      'cache database_names database_schemanames database_tablenames '
      + 'define_tag define_type email_batch encode_set html_comment handle '
      + 'handle_error header if inline iterate ljax_target link '
      + 'link_currentaction link_currentgroup link_currentrecord link_detail '
      + 'link_firstgroup link_firstrecord link_lastgroup link_lastrecord '
      + 'link_nextgroup link_nextrecord link_prevgroup link_prevrecord log '
      + 'loop namespace_using output_none portal private protect records '
      + 'referer referrer repeating resultset rows search_args '
      + 'search_arguments select sort_args sort_arguments thread_atomic '
      + 'value_list while abort case else fail_if fail_ifnot fail if_empty '
      + 'if_false if_null if_true loop_abort loop_continue loop_count params '
      + 'params_up return return_value run_children soap_definetag '
      + 'soap_lastrequest soap_lastresponse tag_name ascending average by '
      + 'define descending do equals frozen group handle_failure import in '
      + 'into join let match max min on order parent protected provide public '
      + 'require returnhome skip split_thread sum take thread to trait type '
      + 'where with yield yieldhome'
  };
  const HTML_COMMENT = hljs.COMMENT(
    '<!--',
    '-->',
    { relevance: 0 }
  );
  const LASSO_NOPROCESS = {
    className: 'meta',
    begin: '\\[noprocess\\]',
    starts: {
      end: '\\[/noprocess\\]',
      returnEnd: true,
      contains: [ HTML_COMMENT ]
    }
  };
  const LASSO_START = {
    className: 'meta',
    begin: '\\[/noprocess|' + LASSO_ANGLE_RE
  };
  const LASSO_DATAMEMBER = {
    className: 'symbol',
    begin: '\'' + LASSO_IDENT_RE + '\''
  };
  const LASSO_CODE = [
    hljs.C_LINE_COMMENT_MODE,
    hljs.C_BLOCK_COMMENT_MODE,
    hljs.inherit(hljs.C_NUMBER_MODE, { begin: hljs.C_NUMBER_RE + '|(-?infinity|NaN)\\b' }),
    hljs.inherit(hljs.APOS_STRING_MODE, { illegal: null }),
    hljs.inherit(hljs.QUOTE_STRING_MODE, { illegal: null }),
    {
      className: 'string',
      begin: '`',
      end: '`'
    },
    { // variables
      variants: [
        { begin: '[#$]' + LASSO_IDENT_RE },
        {
          begin: '#',
          end: '\\d+',
          illegal: '\\W'
        }
      ] },
    {
      className: 'type',
      begin: '::\\s*',
      end: LASSO_IDENT_RE,
      illegal: '\\W'
    },
    {
      className: 'params',
      variants: [
        {
          begin: '-(?!infinity)' + LASSO_IDENT_RE,
          relevance: 0
        },
        { begin: '(\\.\\.\\.)' }
      ]
    },
    {
      begin: /(->|\.)\s*/,
      relevance: 0,
      contains: [ LASSO_DATAMEMBER ]
    },
    {
      className: 'class',
      beginKeywords: 'define',
      returnEnd: true,
      end: '\\(|=>',
      contains: [ hljs.inherit(hljs.TITLE_MODE, { begin: LASSO_IDENT_RE + '(=(?!>))?|[-+*/%](?!>)' }) ]
    }
  ];
  return {
    name: 'Lasso',
    aliases: [
      'ls',
      'lassoscript'
    ],
    case_insensitive: true,
    keywords: LASSO_KEYWORDS,
    contains: [
      {
        className: 'meta',
        begin: LASSO_CLOSE_RE,
        relevance: 0,
        starts: { // markup
          end: '\\[|' + LASSO_ANGLE_RE,
          returnEnd: true,
          relevance: 0,
          contains: [ HTML_COMMENT ]
        }
      },
      LASSO_NOPROCESS,
      LASSO_START,
      {
        className: 'meta',
        begin: '\\[no_square_brackets',
        starts: {
          end: '\\[/no_square_brackets\\]', // not implemented in the language
          keywords: LASSO_KEYWORDS,
          contains: [
            {
              className: 'meta',
              begin: LASSO_CLOSE_RE,
              relevance: 0,
              starts: {
                end: '\\[noprocess\\]|' + LASSO_ANGLE_RE,
                returnEnd: true,
                contains: [ HTML_COMMENT ]
              }
            },
            LASSO_NOPROCESS,
            LASSO_START
          ].concat(LASSO_CODE)
        }
      },
      {
        className: 'meta',
        begin: '\\[',
        relevance: 0
      },
      {
        className: 'meta',
        begin: '^#!',
        end: 'lasso9$',
        relevance: 10
      }
    ].concat(LASSO_CODE)
  };
}

module.exports = lasso;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/latex.js":
/*!**********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/latex.js ***!
  \**********************************************************/
/***/ (function(module) {

/*
Language: LaTeX
Author: Benedikt Wilde <bwilde@posteo.de>
Website: https://www.latex-project.org
Category: markup
*/

/** @type LanguageFn */
function latex(hljs) {
  const regex = hljs.regex;
  const KNOWN_CONTROL_WORDS = regex.either(...[
    '(?:NeedsTeXFormat|RequirePackage|GetIdInfo)',
    'Provides(?:Expl)?(?:Package|Class|File)',
    '(?:DeclareOption|ProcessOptions)',
    '(?:documentclass|usepackage|input|include)',
    'makeat(?:letter|other)',
    'ExplSyntax(?:On|Off)',
    '(?:new|renew|provide)?command',
    '(?:re)newenvironment',
    '(?:New|Renew|Provide|Declare)(?:Expandable)?DocumentCommand',
    '(?:New|Renew|Provide|Declare)DocumentEnvironment',
    '(?:(?:e|g|x)?def|let)',
    '(?:begin|end)',
    '(?:part|chapter|(?:sub){0,2}section|(?:sub)?paragraph)',
    'caption',
    '(?:label|(?:eq|page|name)?ref|(?:paren|foot|super)?cite)',
    '(?:alpha|beta|[Gg]amma|[Dd]elta|(?:var)?epsilon|zeta|eta|[Tt]heta|vartheta)',
    '(?:iota|(?:var)?kappa|[Ll]ambda|mu|nu|[Xx]i|[Pp]i|varpi|(?:var)rho)',
    '(?:[Ss]igma|varsigma|tau|[Uu]psilon|[Pp]hi|varphi|chi|[Pp]si|[Oo]mega)',
    '(?:frac|sum|prod|lim|infty|times|sqrt|leq|geq|left|right|middle|[bB]igg?)',
    '(?:[lr]angle|q?quad|[lcvdi]?dots|d?dot|hat|tilde|bar)'
  ].map(word => word + '(?![a-zA-Z@:_])'));
  const L3_REGEX = new RegExp([
    // A function \module_function_name:signature or \__module_function_name:signature,
    // where both module and function_name need at least two characters and
    // function_name may contain single underscores.
    '(?:__)?[a-zA-Z]{2,}_[a-zA-Z](?:_?[a-zA-Z])+:[a-zA-Z]*',
    // A variable \scope_module_and_name_type or \scope__module_ane_name_type,
    // where scope is one of l, g or c, type needs at least two characters
    // and module_and_name may contain single underscores.
    '[lgc]__?[a-zA-Z](?:_?[a-zA-Z])*_[a-zA-Z]{2,}',
    // A quark \q_the_name or \q__the_name or
    // scan mark \s_the_name or \s__vthe_name,
    // where variable_name needs at least two characters and
    // may contain single underscores.
    '[qs]__?[a-zA-Z](?:_?[a-zA-Z])+',
    // Other LaTeX3 macro names that are not covered by the three rules above.
    'use(?:_i)?:[a-zA-Z]*',
    '(?:else|fi|or):',
    '(?:if|cs|exp):w',
    '(?:hbox|vbox):n',
    '::[a-zA-Z]_unbraced',
    '::[a-zA-Z:]'
  ].map(pattern => pattern + '(?![a-zA-Z:_])').join('|'));
  const L2_VARIANTS = [
    { begin: /[a-zA-Z@]+/ }, // control word
    { begin: /[^a-zA-Z@]?/ } // control symbol
  ];
  const DOUBLE_CARET_VARIANTS = [
    { begin: /\^{6}[0-9a-f]{6}/ },
    { begin: /\^{5}[0-9a-f]{5}/ },
    { begin: /\^{4}[0-9a-f]{4}/ },
    { begin: /\^{3}[0-9a-f]{3}/ },
    { begin: /\^{2}[0-9a-f]{2}/ },
    { begin: /\^{2}[\u0000-\u007f]/ }
  ];
  const CONTROL_SEQUENCE = {
    className: 'keyword',
    begin: /\\/,
    relevance: 0,
    contains: [
      {
        endsParent: true,
        begin: KNOWN_CONTROL_WORDS
      },
      {
        endsParent: true,
        begin: L3_REGEX
      },
      {
        endsParent: true,
        variants: DOUBLE_CARET_VARIANTS
      },
      {
        endsParent: true,
        relevance: 0,
        variants: L2_VARIANTS
      }
    ]
  };
  const MACRO_PARAM = {
    className: 'params',
    relevance: 0,
    begin: /#+\d?/
  };
  const DOUBLE_CARET_CHAR = {
    // relevance: 1
    variants: DOUBLE_CARET_VARIANTS };
  const SPECIAL_CATCODE = {
    className: 'built_in',
    relevance: 0,
    begin: /[$&^_]/
  };
  const MAGIC_COMMENT = {
    className: 'meta',
    begin: /% ?!(T[eE]X|tex|BIB|bib)/,
    end: '$',
    relevance: 10
  };
  const COMMENT = hljs.COMMENT(
    '%',
    '$',
    { relevance: 0 }
  );
  const EVERYTHING_BUT_VERBATIM = [
    CONTROL_SEQUENCE,
    MACRO_PARAM,
    DOUBLE_CARET_CHAR,
    SPECIAL_CATCODE,
    MAGIC_COMMENT,
    COMMENT
  ];
  const BRACE_GROUP_NO_VERBATIM = {
    begin: /\{/,
    end: /\}/,
    relevance: 0,
    contains: [
      'self',
      ...EVERYTHING_BUT_VERBATIM
    ]
  };
  const ARGUMENT_BRACES = hljs.inherit(
    BRACE_GROUP_NO_VERBATIM,
    {
      relevance: 0,
      endsParent: true,
      contains: [
        BRACE_GROUP_NO_VERBATIM,
        ...EVERYTHING_BUT_VERBATIM
      ]
    }
  );
  const ARGUMENT_BRACKETS = {
    begin: /\[/,
    end: /\]/,
    endsParent: true,
    relevance: 0,
    contains: [
      BRACE_GROUP_NO_VERBATIM,
      ...EVERYTHING_BUT_VERBATIM
    ]
  };
  const SPACE_GOBBLER = {
    begin: /\s+/,
    relevance: 0
  };
  const ARGUMENT_M = [ ARGUMENT_BRACES ];
  const ARGUMENT_O = [ ARGUMENT_BRACKETS ];
  const ARGUMENT_AND_THEN = function(arg, starts_mode) {
    return {
      contains: [ SPACE_GOBBLER ],
      starts: {
        relevance: 0,
        contains: arg,
        starts: starts_mode
      }
    };
  };
  const CSNAME = function(csname, starts_mode) {
    return {
      begin: '\\\\' + csname + '(?![a-zA-Z@:_])',
      keywords: {
        $pattern: /\\[a-zA-Z]+/,
        keyword: '\\' + csname
      },
      relevance: 0,
      contains: [ SPACE_GOBBLER ],
      starts: starts_mode
    };
  };
  const BEGIN_ENV = function(envname, starts_mode) {
    return hljs.inherit(
      {
        begin: '\\\\begin(?=[ \t]*(\\r?\\n[ \t]*)?\\{' + envname + '\\})',
        keywords: {
          $pattern: /\\[a-zA-Z]+/,
          keyword: '\\begin'
        },
        relevance: 0,
      },
      ARGUMENT_AND_THEN(ARGUMENT_M, starts_mode)
    );
  };
  const VERBATIM_DELIMITED_EQUAL = (innerName = "string") => {
    return hljs.END_SAME_AS_BEGIN({
      className: innerName,
      begin: /(.|\r?\n)/,
      end: /(.|\r?\n)/,
      excludeBegin: true,
      excludeEnd: true,
      endsParent: true
    });
  };
  const VERBATIM_DELIMITED_ENV = function(envname) {
    return {
      className: 'string',
      end: '(?=\\\\end\\{' + envname + '\\})'
    };
  };

  const VERBATIM_DELIMITED_BRACES = (innerName = "string") => {
    return {
      relevance: 0,
      begin: /\{/,
      starts: {
        endsParent: true,
        contains: [
          {
            className: innerName,
            end: /(?=\})/,
            endsParent: true,
            contains: [
              {
                begin: /\{/,
                end: /\}/,
                relevance: 0,
                contains: [ "self" ]
              }
            ],
          }
        ]
      }
    };
  };
  const VERBATIM = [
    ...[
      'verb',
      'lstinline'
    ].map(csname => CSNAME(csname, { contains: [ VERBATIM_DELIMITED_EQUAL() ] })),
    CSNAME('mint', ARGUMENT_AND_THEN(ARGUMENT_M, { contains: [ VERBATIM_DELIMITED_EQUAL() ] })),
    CSNAME('mintinline', ARGUMENT_AND_THEN(ARGUMENT_M, { contains: [
      VERBATIM_DELIMITED_BRACES(),
      VERBATIM_DELIMITED_EQUAL()
    ] })),
    CSNAME('url', { contains: [
      VERBATIM_DELIMITED_BRACES("link"),
      VERBATIM_DELIMITED_BRACES("link")
    ] }),
    CSNAME('hyperref', { contains: [ VERBATIM_DELIMITED_BRACES("link") ] }),
    CSNAME('href', ARGUMENT_AND_THEN(ARGUMENT_O, { contains: [ VERBATIM_DELIMITED_BRACES("link") ] })),
    ...[].concat(...[
      '',
      '\\*'
    ].map(suffix => [
      BEGIN_ENV('verbatim' + suffix, VERBATIM_DELIMITED_ENV('verbatim' + suffix)),
      BEGIN_ENV('filecontents' + suffix, ARGUMENT_AND_THEN(ARGUMENT_M, VERBATIM_DELIMITED_ENV('filecontents' + suffix))),
      ...[
        '',
        'B',
        'L'
      ].map(prefix =>
        BEGIN_ENV(prefix + 'Verbatim' + suffix, ARGUMENT_AND_THEN(ARGUMENT_O, VERBATIM_DELIMITED_ENV(prefix + 'Verbatim' + suffix)))
      )
    ])),
    BEGIN_ENV('minted', ARGUMENT_AND_THEN(ARGUMENT_O, ARGUMENT_AND_THEN(ARGUMENT_M, VERBATIM_DELIMITED_ENV('minted')))),
  ];

  return {
    name: 'LaTeX',
    aliases: [ 'tex' ],
    contains: [
      ...VERBATIM,
      ...EVERYTHING_BUT_VERBATIM
    ]
  };
}

module.exports = latex;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/ldif.js":
/*!*********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/ldif.js ***!
  \*********************************************************/
/***/ (function(module) {

/*
Language: LDIF
Contributors: Jacob Childress <jacobc@gmail.com>
Category: enterprise, config
Website: https://en.wikipedia.org/wiki/LDAP_Data_Interchange_Format
*/

/** @type LanguageFn */
function ldif(hljs) {
  return {
    name: 'LDIF',
    contains: [
      {
        className: 'attribute',
        match: '^dn(?=:)',
        relevance: 10
      },
      {
        className: 'attribute',
        match: '^\\w+(?=:)'
      },
      {
        className: 'literal',
        match: '^-'
      },
      hljs.HASH_COMMENT_MODE
    ]
  };
}

module.exports = ldif;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/leaf.js":
/*!*********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/leaf.js ***!
  \*********************************************************/
/***/ (function(module) {

/*
Language: Leaf
Author: Hale Chan <halechan@qq.com>
Description: Based on the Leaf reference from https://vapor.github.io/documentation/guide/leaf.html.
*/

function leaf(hljs) {
  return {
    name: 'Leaf',
    contains: [
      {
        className: 'function',
        begin: '#+' + '[A-Za-z_0-9]*' + '\\(',
        end: / \{/,
        returnBegin: true,
        excludeEnd: true,
        contains: [
          {
            className: 'keyword',
            begin: '#+'
          },
          {
            className: 'title',
            begin: '[A-Za-z_][A-Za-z_0-9]*'
          },
          {
            className: 'params',
            begin: '\\(',
            end: '\\)',
            endsParent: true,
            contains: [
              {
                className: 'string',
                begin: '"',
                end: '"'
              },
              {
                className: 'variable',
                begin: '[A-Za-z_][A-Za-z_0-9]*'
              }
            ]
          }
        ]
      }
    ]
  };
}

module.exports = leaf;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/less.js":
/*!*********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/less.js ***!
  \*********************************************************/
/***/ (function(module) {

const MODES = (hljs) => {
  return {
    IMPORTANT: {
      scope: 'meta',
      begin: '!important'
    },
    BLOCK_COMMENT: hljs.C_BLOCK_COMMENT_MODE,
    HEXCOLOR: {
      scope: 'number',
      begin: /#(([0-9a-fA-F]{3,4})|(([0-9a-fA-F]{2}){3,4}))\b/
    },
    FUNCTION_DISPATCH: {
      className: "built_in",
      begin: /[\w-]+(?=\()/
    },
    ATTRIBUTE_SELECTOR_MODE: {
      scope: 'selector-attr',
      begin: /\[/,
      end: /\]/,
      illegal: '$',
      contains: [
        hljs.APOS_STRING_MODE,
        hljs.QUOTE_STRING_MODE
      ]
    },
    CSS_NUMBER_MODE: {
      scope: 'number',
      begin: hljs.NUMBER_RE + '(' +
        '%|em|ex|ch|rem' +
        '|vw|vh|vmin|vmax' +
        '|cm|mm|in|pt|pc|px' +
        '|deg|grad|rad|turn' +
        '|s|ms' +
        '|Hz|kHz' +
        '|dpi|dpcm|dppx' +
        ')?',
      relevance: 0
    },
    CSS_VARIABLE: {
      className: "attr",
      begin: /--[A-Za-z][A-Za-z0-9_-]*/
    }
  };
};

const TAGS = [
  'a',
  'abbr',
  'address',
  'article',
  'aside',
  'audio',
  'b',
  'blockquote',
  'body',
  'button',
  'canvas',
  'caption',
  'cite',
  'code',
  'dd',
  'del',
  'details',
  'dfn',
  'div',
  'dl',
  'dt',
  'em',
  'fieldset',
  'figcaption',
  'figure',
  'footer',
  'form',
  'h1',
  'h2',
  'h3',
  'h4',
  'h5',
  'h6',
  'header',
  'hgroup',
  'html',
  'i',
  'iframe',
  'img',
  'input',
  'ins',
  'kbd',
  'label',
  'legend',
  'li',
  'main',
  'mark',
  'menu',
  'nav',
  'object',
  'ol',
  'p',
  'q',
  'quote',
  'samp',
  'section',
  'span',
  'strong',
  'summary',
  'sup',
  'table',
  'tbody',
  'td',
  'textarea',
  'tfoot',
  'th',
  'thead',
  'time',
  'tr',
  'ul',
  'var',
  'video'
];

const MEDIA_FEATURES = [
  'any-hover',
  'any-pointer',
  'aspect-ratio',
  'color',
  'color-gamut',
  'color-index',
  'device-aspect-ratio',
  'device-height',
  'device-width',
  'display-mode',
  'forced-colors',
  'grid',
  'height',
  'hover',
  'inverted-colors',
  'monochrome',
  'orientation',
  'overflow-block',
  'overflow-inline',
  'pointer',
  'prefers-color-scheme',
  'prefers-contrast',
  'prefers-reduced-motion',
  'prefers-reduced-transparency',
  'resolution',
  'scan',
  'scripting',
  'update',
  'width',
  // TODO: find a better solution?
  'min-width',
  'max-width',
  'min-height',
  'max-height'
];

// https://developer.mozilla.org/en-US/docs/Web/CSS/Pseudo-classes
const PSEUDO_CLASSES = [
  'active',
  'any-link',
  'blank',
  'checked',
  'current',
  'default',
  'defined',
  'dir', // dir()
  'disabled',
  'drop',
  'empty',
  'enabled',
  'first',
  'first-child',
  'first-of-type',
  'fullscreen',
  'future',
  'focus',
  'focus-visible',
  'focus-within',
  'has', // has()
  'host', // host or host()
  'host-context', // host-context()
  'hover',
  'indeterminate',
  'in-range',
  'invalid',
  'is', // is()
  'lang', // lang()
  'last-child',
  'last-of-type',
  'left',
  'link',
  'local-link',
  'not', // not()
  'nth-child', // nth-child()
  'nth-col', // nth-col()
  'nth-last-child', // nth-last-child()
  'nth-last-col', // nth-last-col()
  'nth-last-of-type', //nth-last-of-type()
  'nth-of-type', //nth-of-type()
  'only-child',
  'only-of-type',
  'optional',
  'out-of-range',
  'past',
  'placeholder-shown',
  'read-only',
  'read-write',
  'required',
  'right',
  'root',
  'scope',
  'target',
  'target-within',
  'user-invalid',
  'valid',
  'visited',
  'where' // where()
];

// https://developer.mozilla.org/en-US/docs/Web/CSS/Pseudo-elements
const PSEUDO_ELEMENTS = [
  'after',
  'backdrop',
  'before',
  'cue',
  'cue-region',
  'first-letter',
  'first-line',
  'grammar-error',
  'marker',
  'part',
  'placeholder',
  'selection',
  'slotted',
  'spelling-error'
];

const ATTRIBUTES = [
  'align-content',
  'align-items',
  'align-self',
  'all',
  'animation',
  'animation-delay',
  'animation-direction',
  'animation-duration',
  'animation-fill-mode',
  'animation-iteration-count',
  'animation-name',
  'animation-play-state',
  'animation-timing-function',
  'backface-visibility',
  'background',
  'background-attachment',
  'background-blend-mode',
  'background-clip',
  'background-color',
  'background-image',
  'background-origin',
  'background-position',
  'background-repeat',
  'background-size',
  'block-size',
  'border',
  'border-block',
  'border-block-color',
  'border-block-end',
  'border-block-end-color',
  'border-block-end-style',
  'border-block-end-width',
  'border-block-start',
  'border-block-start-color',
  'border-block-start-style',
  'border-block-start-width',
  'border-block-style',
  'border-block-width',
  'border-bottom',
  'border-bottom-color',
  'border-bottom-left-radius',
  'border-bottom-right-radius',
  'border-bottom-style',
  'border-bottom-width',
  'border-collapse',
  'border-color',
  'border-image',
  'border-image-outset',
  'border-image-repeat',
  'border-image-slice',
  'border-image-source',
  'border-image-width',
  'border-inline',
  'border-inline-color',
  'border-inline-end',
  'border-inline-end-color',
  'border-inline-end-style',
  'border-inline-end-width',
  'border-inline-start',
  'border-inline-start-color',
  'border-inline-start-style',
  'border-inline-start-width',
  'border-inline-style',
  'border-inline-width',
  'border-left',
  'border-left-color',
  'border-left-style',
  'border-left-width',
  'border-radius',
  'border-right',
  'border-right-color',
  'border-right-style',
  'border-right-width',
  'border-spacing',
  'border-style',
  'border-top',
  'border-top-color',
  'border-top-left-radius',
  'border-top-right-radius',
  'border-top-style',
  'border-top-width',
  'border-width',
  'bottom',
  'box-decoration-break',
  'box-shadow',
  'box-sizing',
  'break-after',
  'break-before',
  'break-inside',
  'caption-side',
  'caret-color',
  'clear',
  'clip',
  'clip-path',
  'clip-rule',
  'color',
  'column-count',
  'column-fill',
  'column-gap',
  'column-rule',
  'column-rule-color',
  'column-rule-style',
  'column-rule-width',
  'column-span',
  'column-width',
  'columns',
  'contain',
  'content',
  'content-visibility',
  'counter-increment',
  'counter-reset',
  'cue',
  'cue-after',
  'cue-before',
  'cursor',
  'direction',
  'display',
  'empty-cells',
  'filter',
  'flex',
  'flex-basis',
  'flex-direction',
  'flex-flow',
  'flex-grow',
  'flex-shrink',
  'flex-wrap',
  'float',
  'flow',
  'font',
  'font-display',
  'font-family',
  'font-feature-settings',
  'font-kerning',
  'font-language-override',
  'font-size',
  'font-size-adjust',
  'font-smoothing',
  'font-stretch',
  'font-style',
  'font-synthesis',
  'font-variant',
  'font-variant-caps',
  'font-variant-east-asian',
  'font-variant-ligatures',
  'font-variant-numeric',
  'font-variant-position',
  'font-variation-settings',
  'font-weight',
  'gap',
  'glyph-orientation-vertical',
  'grid',
  'grid-area',
  'grid-auto-columns',
  'grid-auto-flow',
  'grid-auto-rows',
  'grid-column',
  'grid-column-end',
  'grid-column-start',
  'grid-gap',
  'grid-row',
  'grid-row-end',
  'grid-row-start',
  'grid-template',
  'grid-template-areas',
  'grid-template-columns',
  'grid-template-rows',
  'hanging-punctuation',
  'height',
  'hyphens',
  'icon',
  'image-orientation',
  'image-rendering',
  'image-resolution',
  'ime-mode',
  'inline-size',
  'isolation',
  'justify-content',
  'left',
  'letter-spacing',
  'line-break',
  'line-height',
  'list-style',
  'list-style-image',
  'list-style-position',
  'list-style-type',
  'margin',
  'margin-block',
  'margin-block-end',
  'margin-block-start',
  'margin-bottom',
  'margin-inline',
  'margin-inline-end',
  'margin-inline-start',
  'margin-left',
  'margin-right',
  'margin-top',
  'marks',
  'mask',
  'mask-border',
  'mask-border-mode',
  'mask-border-outset',
  'mask-border-repeat',
  'mask-border-slice',
  'mask-border-source',
  'mask-border-width',
  'mask-clip',
  'mask-composite',
  'mask-image',
  'mask-mode',
  'mask-origin',
  'mask-position',
  'mask-repeat',
  'mask-size',
  'mask-type',
  'max-block-size',
  'max-height',
  'max-inline-size',
  'max-width',
  'min-block-size',
  'min-height',
  'min-inline-size',
  'min-width',
  'mix-blend-mode',
  'nav-down',
  'nav-index',
  'nav-left',
  'nav-right',
  'nav-up',
  'none',
  'normal',
  'object-fit',
  'object-position',
  'opacity',
  'order',
  'orphans',
  'outline',
  'outline-color',
  'outline-offset',
  'outline-style',
  'outline-width',
  'overflow',
  'overflow-wrap',
  'overflow-x',
  'overflow-y',
  'padding',
  'padding-block',
  'padding-block-end',
  'padding-block-start',
  'padding-bottom',
  'padding-inline',
  'padding-inline-end',
  'padding-inline-start',
  'padding-left',
  'padding-right',
  'padding-top',
  'page-break-after',
  'page-break-before',
  'page-break-inside',
  'pause',
  'pause-after',
  'pause-before',
  'perspective',
  'perspective-origin',
  'pointer-events',
  'position',
  'quotes',
  'resize',
  'rest',
  'rest-after',
  'rest-before',
  'right',
  'row-gap',
  'scroll-margin',
  'scroll-margin-block',
  'scroll-margin-block-end',
  'scroll-margin-block-start',
  'scroll-margin-bottom',
  'scroll-margin-inline',
  'scroll-margin-inline-end',
  'scroll-margin-inline-start',
  'scroll-margin-left',
  'scroll-margin-right',
  'scroll-margin-top',
  'scroll-padding',
  'scroll-padding-block',
  'scroll-padding-block-end',
  'scroll-padding-block-start',
  'scroll-padding-bottom',
  'scroll-padding-inline',
  'scroll-padding-inline-end',
  'scroll-padding-inline-start',
  'scroll-padding-left',
  'scroll-padding-right',
  'scroll-padding-top',
  'scroll-snap-align',
  'scroll-snap-stop',
  'scroll-snap-type',
  'scrollbar-color',
  'scrollbar-gutter',
  'scrollbar-width',
  'shape-image-threshold',
  'shape-margin',
  'shape-outside',
  'speak',
  'speak-as',
  'src', // @font-face
  'tab-size',
  'table-layout',
  'text-align',
  'text-align-all',
  'text-align-last',
  'text-combine-upright',
  'text-decoration',
  'text-decoration-color',
  'text-decoration-line',
  'text-decoration-style',
  'text-emphasis',
  'text-emphasis-color',
  'text-emphasis-position',
  'text-emphasis-style',
  'text-indent',
  'text-justify',
  'text-orientation',
  'text-overflow',
  'text-rendering',
  'text-shadow',
  'text-transform',
  'text-underline-position',
  'top',
  'transform',
  'transform-box',
  'transform-origin',
  'transform-style',
  'transition',
  'transition-delay',
  'transition-duration',
  'transition-property',
  'transition-timing-function',
  'unicode-bidi',
  'vertical-align',
  'visibility',
  'voice-balance',
  'voice-duration',
  'voice-family',
  'voice-pitch',
  'voice-range',
  'voice-rate',
  'voice-stress',
  'voice-volume',
  'white-space',
  'widows',
  'width',
  'will-change',
  'word-break',
  'word-spacing',
  'word-wrap',
  'writing-mode',
  'z-index'
  // reverse makes sure longer attributes `font-weight` are matched fully
  // instead of getting false positives on say `font`
].reverse();

// some grammars use them all as a single group
const PSEUDO_SELECTORS = PSEUDO_CLASSES.concat(PSEUDO_ELEMENTS);

/*
Language: Less
Description: It's CSS, with just a little more.
Author:   Max Mikhailov <seven.phases.max@gmail.com>
Website: http://lesscss.org
Category: common, css, web
*/

/** @type LanguageFn */
function less(hljs) {
  const modes = MODES(hljs);
  const PSEUDO_SELECTORS$1 = PSEUDO_SELECTORS;

  const AT_MODIFIERS = "and or not only";
  const IDENT_RE = '[\\w-]+'; // yes, Less identifiers may begin with a digit
  const INTERP_IDENT_RE = '(' + IDENT_RE + '|@\\{' + IDENT_RE + '\\})';

  /* Generic Modes */

  const RULES = []; const VALUE_MODES = []; // forward def. for recursive modes

  const STRING_MODE = function(c) {
    return {
    // Less strings are not multiline (also include '~' for more consistent coloring of "escaped" strings)
      className: 'string',
      begin: '~?' + c + '.*?' + c
    };
  };

  const IDENT_MODE = function(name, begin, relevance) {
    return {
      className: name,
      begin: begin,
      relevance: relevance
    };
  };

  const AT_KEYWORDS = {
    $pattern: /[a-z-]+/,
    keyword: AT_MODIFIERS,
    attribute: MEDIA_FEATURES.join(" ")
  };

  const PARENS_MODE = {
    // used only to properly balance nested parens inside mixin call, def. arg list
    begin: '\\(',
    end: '\\)',
    contains: VALUE_MODES,
    keywords: AT_KEYWORDS,
    relevance: 0
  };

  // generic Less highlighter (used almost everywhere except selectors):
  VALUE_MODES.push(
    hljs.C_LINE_COMMENT_MODE,
    hljs.C_BLOCK_COMMENT_MODE,
    STRING_MODE("'"),
    STRING_MODE('"'),
    modes.CSS_NUMBER_MODE, // fixme: it does not include dot for numbers like .5em :(
    {
      begin: '(url|data-uri)\\(',
      starts: {
        className: 'string',
        end: '[\\)\\n]',
        excludeEnd: true
      }
    },
    modes.HEXCOLOR,
    PARENS_MODE,
    IDENT_MODE('variable', '@@?' + IDENT_RE, 10),
    IDENT_MODE('variable', '@\\{' + IDENT_RE + '\\}'),
    IDENT_MODE('built_in', '~?`[^`]*?`'), // inline javascript (or whatever host language) *multiline* string
    { // @media features (it’s here to not duplicate things in AT_RULE_MODE with extra PARENS_MODE overriding):
      className: 'attribute',
      begin: IDENT_RE + '\\s*:',
      end: ':',
      returnBegin: true,
      excludeEnd: true
    },
    modes.IMPORTANT,
    { beginKeywords: 'and not' },
    modes.FUNCTION_DISPATCH
  );

  const VALUE_WITH_RULESETS = VALUE_MODES.concat({
    begin: /\{/,
    end: /\}/,
    contains: RULES
  });

  const MIXIN_GUARD_MODE = {
    beginKeywords: 'when',
    endsWithParent: true,
    contains: [ { beginKeywords: 'and not' } ].concat(VALUE_MODES) // using this form to override VALUE’s 'function' match
  };

  /* Rule-Level Modes */

  const RULE_MODE = {
    begin: INTERP_IDENT_RE + '\\s*:',
    returnBegin: true,
    end: /[;}]/,
    relevance: 0,
    contains: [
      { begin: /-(webkit|moz|ms|o)-/ },
      modes.CSS_VARIABLE,
      {
        className: 'attribute',
        begin: '\\b(' + ATTRIBUTES.join('|') + ')\\b',
        end: /(?=:)/,
        starts: {
          endsWithParent: true,
          illegal: '[<=$]',
          relevance: 0,
          contains: VALUE_MODES
        }
      }
    ]
  };

  const AT_RULE_MODE = {
    className: 'keyword',
    begin: '@(import|media|charset|font-face|(-[a-z]+-)?keyframes|supports|document|namespace|page|viewport|host)\\b',
    starts: {
      end: '[;{}]',
      keywords: AT_KEYWORDS,
      returnEnd: true,
      contains: VALUE_MODES,
      relevance: 0
    }
  };

  // variable definitions and calls
  const VAR_RULE_MODE = {
    className: 'variable',
    variants: [
      // using more strict pattern for higher relevance to increase chances of Less detection.
      // this is *the only* Less specific statement used in most of the sources, so...
      // (we’ll still often loose to the css-parser unless there's '//' comment,
      // simply because 1 variable just can't beat 99 properties :)
      {
        begin: '@' + IDENT_RE + '\\s*:',
        relevance: 15
      },
      { begin: '@' + IDENT_RE }
    ],
    starts: {
      end: '[;}]',
      returnEnd: true,
      contains: VALUE_WITH_RULESETS
    }
  };

  const SELECTOR_MODE = {
    // first parse unambiguous selectors (i.e. those not starting with tag)
    // then fall into the scary lookahead-discriminator variant.
    // this mode also handles mixin definitions and calls
    variants: [
      {
        begin: '[\\.#:&\\[>]',
        end: '[;{}]' // mixin calls end with ';'
      },
      {
        begin: INTERP_IDENT_RE,
        end: /\{/
      }
    ],
    returnBegin: true,
    returnEnd: true,
    illegal: '[<=\'$"]',
    relevance: 0,
    contains: [
      hljs.C_LINE_COMMENT_MODE,
      hljs.C_BLOCK_COMMENT_MODE,
      MIXIN_GUARD_MODE,
      IDENT_MODE('keyword', 'all\\b'),
      IDENT_MODE('variable', '@\\{' + IDENT_RE + '\\}'), // otherwise it’s identified as tag
      
      {
        begin: '\\b(' + TAGS.join('|') + ')\\b',
        className: 'selector-tag'
      },
      modes.CSS_NUMBER_MODE,
      IDENT_MODE('selector-tag', INTERP_IDENT_RE, 0),
      IDENT_MODE('selector-id', '#' + INTERP_IDENT_RE),
      IDENT_MODE('selector-class', '\\.' + INTERP_IDENT_RE, 0),
      IDENT_MODE('selector-tag', '&', 0),
      modes.ATTRIBUTE_SELECTOR_MODE,
      {
        className: 'selector-pseudo',
        begin: ':(' + PSEUDO_CLASSES.join('|') + ')'
      },
      {
        className: 'selector-pseudo',
        begin: ':(:)?(' + PSEUDO_ELEMENTS.join('|') + ')'
      },
      {
        begin: /\(/,
        end: /\)/,
        relevance: 0,
        contains: VALUE_WITH_RULESETS
      }, // argument list of parametric mixins
      { begin: '!important' }, // eat !important after mixin call or it will be colored as tag
      modes.FUNCTION_DISPATCH
    ]
  };

  const PSEUDO_SELECTOR_MODE = {
    begin: IDENT_RE + ':(:)?' + `(${PSEUDO_SELECTORS$1.join('|')})`,
    returnBegin: true,
    contains: [ SELECTOR_MODE ]
  };

  RULES.push(
    hljs.C_LINE_COMMENT_MODE,
    hljs.C_BLOCK_COMMENT_MODE,
    AT_RULE_MODE,
    VAR_RULE_MODE,
    PSEUDO_SELECTOR_MODE,
    RULE_MODE,
    SELECTOR_MODE,
    MIXIN_GUARD_MODE,
    modes.FUNCTION_DISPATCH
  );

  return {
    name: 'Less',
    case_insensitive: true,
    illegal: '[=>\'/<($"]',
    contains: RULES
  };
}

module.exports = less;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/lisp.js":
/*!*********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/lisp.js ***!
  \*********************************************************/
/***/ (function(module) {

/*
Language: Lisp
Description: Generic lisp syntax
Author: Vasily Polovnyov <vast@whiteants.net>
Category: lisp
*/

function lisp(hljs) {
  const LISP_IDENT_RE = '[a-zA-Z_\\-+\\*\\/<=>&#][a-zA-Z0-9_\\-+*\\/<=>&#!]*';
  const MEC_RE = '\\|[^]*?\\|';
  const LISP_SIMPLE_NUMBER_RE = '(-|\\+)?\\d+(\\.\\d+|\\/\\d+)?((d|e|f|l|s|D|E|F|L|S)(\\+|-)?\\d+)?';
  const LITERAL = {
    className: 'literal',
    begin: '\\b(t{1}|nil)\\b'
  };
  const NUMBER = {
    className: 'number',
    variants: [
      {
        begin: LISP_SIMPLE_NUMBER_RE,
        relevance: 0
      },
      { begin: '#(b|B)[0-1]+(/[0-1]+)?' },
      { begin: '#(o|O)[0-7]+(/[0-7]+)?' },
      { begin: '#(x|X)[0-9a-fA-F]+(/[0-9a-fA-F]+)?' },
      {
        begin: '#(c|C)\\(' + LISP_SIMPLE_NUMBER_RE + ' +' + LISP_SIMPLE_NUMBER_RE,
        end: '\\)'
      }
    ]
  };
  const STRING = hljs.inherit(hljs.QUOTE_STRING_MODE, { illegal: null });
  const COMMENT = hljs.COMMENT(
    ';', '$',
    { relevance: 0 }
  );
  const VARIABLE = {
    begin: '\\*',
    end: '\\*'
  };
  const KEYWORD = {
    className: 'symbol',
    begin: '[:&]' + LISP_IDENT_RE
  };
  const IDENT = {
    begin: LISP_IDENT_RE,
    relevance: 0
  };
  const MEC = { begin: MEC_RE };
  const QUOTED_LIST = {
    begin: '\\(',
    end: '\\)',
    contains: [
      'self',
      LITERAL,
      STRING,
      NUMBER,
      IDENT
    ]
  };
  const QUOTED = {
    contains: [
      NUMBER,
      STRING,
      VARIABLE,
      KEYWORD,
      QUOTED_LIST,
      IDENT
    ],
    variants: [
      {
        begin: '[\'`]\\(',
        end: '\\)'
      },
      {
        begin: '\\(quote ',
        end: '\\)',
        keywords: { name: 'quote' }
      },
      { begin: '\'' + MEC_RE }
    ]
  };
  const QUOTED_ATOM = { variants: [
    { begin: '\'' + LISP_IDENT_RE },
    { begin: '#\'' + LISP_IDENT_RE + '(::' + LISP_IDENT_RE + ')*' }
  ] };
  const LIST = {
    begin: '\\(\\s*',
    end: '\\)'
  };
  const BODY = {
    endsWithParent: true,
    relevance: 0
  };
  LIST.contains = [
    {
      className: 'name',
      variants: [
        {
          begin: LISP_IDENT_RE,
          relevance: 0,
        },
        { begin: MEC_RE }
      ]
    },
    BODY
  ];
  BODY.contains = [
    QUOTED,
    QUOTED_ATOM,
    LIST,
    LITERAL,
    NUMBER,
    STRING,
    COMMENT,
    VARIABLE,
    KEYWORD,
    MEC,
    IDENT
  ];

  return {
    name: 'Lisp',
    illegal: /\S/,
    contains: [
      NUMBER,
      hljs.SHEBANG(),
      LITERAL,
      STRING,
      COMMENT,
      QUOTED,
      QUOTED_ATOM,
      LIST,
      IDENT
    ]
  };
}

module.exports = lisp;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/livecodeserver.js":
/*!*******************************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/livecodeserver.js ***!
  \*******************************************************************/
/***/ (function(module) {

/*
Language: LiveCode
Author: Ralf Bitter <rabit@revigniter.com>
Description: Language definition for LiveCode server accounting for revIgniter (a web application framework) characteristics.
Version: 1.1
Date: 2019-04-17
Category: enterprise
*/

function livecodeserver(hljs) {
  const VARIABLE = {
    className: 'variable',
    variants: [
      { begin: '\\b([gtps][A-Z]{1}[a-zA-Z0-9]*)(\\[.+\\])?(?:\\s*?)' },
      { begin: '\\$_[A-Z]+' }
    ],
    relevance: 0
  };
  const COMMENT_MODES = [
    hljs.C_BLOCK_COMMENT_MODE,
    hljs.HASH_COMMENT_MODE,
    hljs.COMMENT('--', '$'),
    hljs.COMMENT('[^:]//', '$')
  ];
  const TITLE1 = hljs.inherit(hljs.TITLE_MODE, { variants: [
    { begin: '\\b_*rig[A-Z][A-Za-z0-9_\\-]*' },
    { begin: '\\b_[a-z0-9\\-]+' }
  ] });
  const TITLE2 = hljs.inherit(hljs.TITLE_MODE, { begin: '\\b([A-Za-z0-9_\\-]+)\\b' });
  return {
    name: 'LiveCode',
    case_insensitive: false,
    keywords: {
      keyword:
        '$_COOKIE $_FILES $_GET $_GET_BINARY $_GET_RAW $_POST $_POST_BINARY $_POST_RAW $_SESSION $_SERVER '
        + 'codepoint codepoints segment segments codeunit codeunits sentence sentences trueWord trueWords paragraph '
        + 'after byte bytes english the until http forever descending using line real8 with seventh '
        + 'for stdout finally element word words fourth before black ninth sixth characters chars stderr '
        + 'uInt1 uInt1s uInt2 uInt2s stdin string lines relative rel any fifth items from middle mid '
        + 'at else of catch then third it file milliseconds seconds second secs sec int1 int1s int4 '
        + 'int4s internet int2 int2s normal text item last long detailed effective uInt4 uInt4s repeat '
        + 'end repeat URL in try into switch to words https token binfile each tenth as ticks tick '
        + 'system real4 by dateItems without char character ascending eighth whole dateTime numeric short '
        + 'first ftp integer abbreviated abbr abbrev private case while if '
        + 'div mod wrap and or bitAnd bitNot bitOr bitXor among not in a an within '
        + 'contains ends with begins the keys of keys',
      literal:
        'SIX TEN FORMFEED NINE ZERO NONE SPACE FOUR FALSE COLON CRLF PI COMMA ENDOFFILE EOF EIGHT FIVE '
        + 'QUOTE EMPTY ONE TRUE RETURN CR LINEFEED RIGHT BACKSLASH NULL SEVEN TAB THREE TWO '
        + 'six ten formfeed nine zero none space four false colon crlf pi comma endoffile eof eight five '
        + 'quote empty one true return cr linefeed right backslash null seven tab three two '
        + 'RIVERSION RISTATE FILE_READ_MODE FILE_WRITE_MODE FILE_WRITE_MODE DIR_WRITE_MODE FILE_READ_UMASK '
        + 'FILE_WRITE_UMASK DIR_READ_UMASK DIR_WRITE_UMASK',
      built_in:
        'put abs acos aliasReference annuity arrayDecode arrayEncode asin atan atan2 average avg avgDev base64Decode '
        + 'base64Encode baseConvert binaryDecode binaryEncode byteOffset byteToNum cachedURL cachedURLs charToNum '
        + 'cipherNames codepointOffset codepointProperty codepointToNum codeunitOffset commandNames compound compress '
        + 'constantNames cos date dateFormat decompress difference directories '
        + 'diskSpace DNSServers exp exp1 exp2 exp10 extents files flushEvents folders format functionNames geometricMean global '
        + 'globals hasMemory harmonicMean hostAddress hostAddressToName hostName hostNameToAddress isNumber ISOToMac itemOffset '
        + 'keys len length libURLErrorData libUrlFormData libURLftpCommand libURLLastHTTPHeaders libURLLastRHHeaders '
        + 'libUrlMultipartFormAddPart libUrlMultipartFormData libURLVersion lineOffset ln ln1 localNames log log2 log10 '
        + 'longFilePath lower macToISO matchChunk matchText matrixMultiply max md5Digest median merge messageAuthenticationCode messageDigest millisec '
        + 'millisecs millisecond milliseconds min monthNames nativeCharToNum normalizeText num number numToByte numToChar '
        + 'numToCodepoint numToNativeChar offset open openfiles openProcesses openProcessIDs openSockets '
        + 'paragraphOffset paramCount param params peerAddress pendingMessages platform popStdDev populationStandardDeviation '
        + 'populationVariance popVariance processID random randomBytes replaceText result revCreateXMLTree revCreateXMLTreeFromFile '
        + 'revCurrentRecord revCurrentRecordIsFirst revCurrentRecordIsLast revDatabaseColumnCount revDatabaseColumnIsNull '
        + 'revDatabaseColumnLengths revDatabaseColumnNames revDatabaseColumnNamed revDatabaseColumnNumbered '
        + 'revDatabaseColumnTypes revDatabaseConnectResult revDatabaseCursors revDatabaseID revDatabaseTableNames '
        + 'revDatabaseType revDataFromQuery revdb_closeCursor revdb_columnbynumber revdb_columncount revdb_columnisnull '
        + 'revdb_columnlengths revdb_columnnames revdb_columntypes revdb_commit revdb_connect revdb_connections '
        + 'revdb_connectionerr revdb_currentrecord revdb_cursorconnection revdb_cursorerr revdb_cursors revdb_dbtype '
        + 'revdb_disconnect revdb_execute revdb_iseof revdb_isbof revdb_movefirst revdb_movelast revdb_movenext '
        + 'revdb_moveprev revdb_query revdb_querylist revdb_recordcount revdb_rollback revdb_tablenames '
        + 'revGetDatabaseDriverPath revNumberOfRecords revOpenDatabase revOpenDatabases revQueryDatabase '
        + 'revQueryDatabaseBlob revQueryResult revQueryIsAtStart revQueryIsAtEnd revUnixFromMacPath revXMLAttribute '
        + 'revXMLAttributes revXMLAttributeValues revXMLChildContents revXMLChildNames revXMLCreateTreeFromFileWithNamespaces '
        + 'revXMLCreateTreeWithNamespaces revXMLDataFromXPathQuery revXMLEvaluateXPath revXMLFirstChild revXMLMatchingNode '
        + 'revXMLNextSibling revXMLNodeContents revXMLNumberOfChildren revXMLParent revXMLPreviousSibling '
        + 'revXMLRootNode revXMLRPC_CreateRequest revXMLRPC_Documents revXMLRPC_Error '
        + 'revXMLRPC_GetHost revXMLRPC_GetMethod revXMLRPC_GetParam revXMLText revXMLRPC_Execute '
        + 'revXMLRPC_GetParamCount revXMLRPC_GetParamNode revXMLRPC_GetParamType revXMLRPC_GetPath revXMLRPC_GetPort '
        + 'revXMLRPC_GetProtocol revXMLRPC_GetRequest revXMLRPC_GetResponse revXMLRPC_GetSocket revXMLTree '
        + 'revXMLTrees revXMLValidateDTD revZipDescribeItem revZipEnumerateItems revZipOpenArchives round sampVariance '
        + 'sec secs seconds sentenceOffset sha1Digest shell shortFilePath sin specialFolderPath sqrt standardDeviation statRound '
        + 'stdDev sum sysError systemVersion tan tempName textDecode textEncode tick ticks time to tokenOffset toLower toUpper '
        + 'transpose truewordOffset trunc uniDecode uniEncode upper URLDecode URLEncode URLStatus uuid value variableNames '
        + 'variance version waitDepth weekdayNames wordOffset xsltApplyStylesheet xsltApplyStylesheetFromFile xsltLoadStylesheet '
        + 'xsltLoadStylesheetFromFile add breakpoint cancel clear local variable file word line folder directory URL close socket process '
        + 'combine constant convert create new alias folder directory decrypt delete variable word line folder '
        + 'directory URL dispatch divide do encrypt filter get include intersect kill libURLDownloadToFile '
        + 'libURLFollowHttpRedirects libURLftpUpload libURLftpUploadFile libURLresetAll libUrlSetAuthCallback libURLSetDriver '
        + 'libURLSetCustomHTTPHeaders libUrlSetExpect100 libURLSetFTPListCommand libURLSetFTPMode libURLSetFTPStopTime '
        + 'libURLSetStatusCallback load extension loadedExtensions multiply socket prepare process post seek rel relative read from process rename '
        + 'replace require resetAll resolve revAddXMLNode revAppendXML revCloseCursor revCloseDatabase revCommitDatabase '
        + 'revCopyFile revCopyFolder revCopyXMLNode revDeleteFolder revDeleteXMLNode revDeleteAllXMLTrees '
        + 'revDeleteXMLTree revExecuteSQL revGoURL revInsertXMLNode revMoveFolder revMoveToFirstRecord revMoveToLastRecord '
        + 'revMoveToNextRecord revMoveToPreviousRecord revMoveToRecord revMoveXMLNode revPutIntoXMLNode revRollBackDatabase '
        + 'revSetDatabaseDriverPath revSetXMLAttribute revXMLRPC_AddParam revXMLRPC_DeleteAllDocuments revXMLAddDTD '
        + 'revXMLRPC_Free revXMLRPC_FreeAll revXMLRPC_DeleteDocument revXMLRPC_DeleteParam revXMLRPC_SetHost '
        + 'revXMLRPC_SetMethod revXMLRPC_SetPort revXMLRPC_SetProtocol revXMLRPC_SetSocket revZipAddItemWithData '
        + 'revZipAddItemWithFile revZipAddUncompressedItemWithData revZipAddUncompressedItemWithFile revZipCancel '
        + 'revZipCloseArchive revZipDeleteItem revZipExtractItemToFile revZipExtractItemToVariable revZipSetProgressCallback '
        + 'revZipRenameItem revZipReplaceItemWithData revZipReplaceItemWithFile revZipOpenArchive send set sort split start stop '
        + 'subtract symmetric union unload vectorDotProduct wait write'
    },
    contains: [
      VARIABLE,
      {
        className: 'keyword',
        begin: '\\bend\\sif\\b'
      },
      {
        className: 'function',
        beginKeywords: 'function',
        end: '$',
        contains: [
          VARIABLE,
          TITLE2,
          hljs.APOS_STRING_MODE,
          hljs.QUOTE_STRING_MODE,
          hljs.BINARY_NUMBER_MODE,
          hljs.C_NUMBER_MODE,
          TITLE1
        ]
      },
      {
        className: 'function',
        begin: '\\bend\\s+',
        end: '$',
        keywords: 'end',
        contains: [
          TITLE2,
          TITLE1
        ],
        relevance: 0
      },
      {
        beginKeywords: 'command on',
        end: '$',
        contains: [
          VARIABLE,
          TITLE2,
          hljs.APOS_STRING_MODE,
          hljs.QUOTE_STRING_MODE,
          hljs.BINARY_NUMBER_MODE,
          hljs.C_NUMBER_MODE,
          TITLE1
        ]
      },
      {
        className: 'meta',
        variants: [
          {
            begin: '<\\?(rev|lc|livecode)',
            relevance: 10
          },
          { begin: '<\\?' },
          { begin: '\\?>' }
        ]
      },
      hljs.APOS_STRING_MODE,
      hljs.QUOTE_STRING_MODE,
      hljs.BINARY_NUMBER_MODE,
      hljs.C_NUMBER_MODE,
      TITLE1
    ].concat(COMMENT_MODES),
    illegal: ';$|^\\[|^=|&|\\{'
  };
}

module.exports = livecodeserver;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/livescript.js":
/*!***************************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/livescript.js ***!
  \***************************************************************/
/***/ (function(module) {

const KEYWORDS = [
  "as", // for exports
  "in",
  "of",
  "if",
  "for",
  "while",
  "finally",
  "var",
  "new",
  "function",
  "do",
  "return",
  "void",
  "else",
  "break",
  "catch",
  "instanceof",
  "with",
  "throw",
  "case",
  "default",
  "try",
  "switch",
  "continue",
  "typeof",
  "delete",
  "let",
  "yield",
  "const",
  "class",
  // JS handles these with a special rule
  // "get",
  // "set",
  "debugger",
  "async",
  "await",
  "static",
  "import",
  "from",
  "export",
  "extends"
];
const LITERALS = [
  "true",
  "false",
  "null",
  "undefined",
  "NaN",
  "Infinity"
];

// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects
const TYPES = [
  // Fundamental objects
  "Object",
  "Function",
  "Boolean",
  "Symbol",
  // numbers and dates
  "Math",
  "Date",
  "Number",
  "BigInt",
  // text
  "String",
  "RegExp",
  // Indexed collections
  "Array",
  "Float32Array",
  "Float64Array",
  "Int8Array",
  "Uint8Array",
  "Uint8ClampedArray",
  "Int16Array",
  "Int32Array",
  "Uint16Array",
  "Uint32Array",
  "BigInt64Array",
  "BigUint64Array",
  // Keyed collections
  "Set",
  "Map",
  "WeakSet",
  "WeakMap",
  // Structured data
  "ArrayBuffer",
  "SharedArrayBuffer",
  "Atomics",
  "DataView",
  "JSON",
  // Control abstraction objects
  "Promise",
  "Generator",
  "GeneratorFunction",
  "AsyncFunction",
  // Reflection
  "Reflect",
  "Proxy",
  // Internationalization
  "Intl",
  // WebAssembly
  "WebAssembly"
];

const ERROR_TYPES = [
  "Error",
  "EvalError",
  "InternalError",
  "RangeError",
  "ReferenceError",
  "SyntaxError",
  "TypeError",
  "URIError"
];

const BUILT_IN_GLOBALS = [
  "setInterval",
  "setTimeout",
  "clearInterval",
  "clearTimeout",

  "require",
  "exports",

  "eval",
  "isFinite",
  "isNaN",
  "parseFloat",
  "parseInt",
  "decodeURI",
  "decodeURIComponent",
  "encodeURI",
  "encodeURIComponent",
  "escape",
  "unescape"
];

const BUILT_INS = [].concat(
  BUILT_IN_GLOBALS,
  TYPES,
  ERROR_TYPES
);

/*
Language: LiveScript
Author: Taneli Vatanen <taneli.vatanen@gmail.com>
Contributors: Jen Evers-Corvina <jen@sevvie.net>
Origin: coffeescript.js
Description: LiveScript is a programming language that transcompiles to JavaScript. For info about language see http://livescript.net/
Website: https://livescript.net
Category: scripting
*/

function livescript(hljs) {
  const LIVESCRIPT_BUILT_INS = [
    'npm',
    'print'
  ];
  const LIVESCRIPT_LITERALS = [
    'yes',
    'no',
    'on',
    'off',
    'it',
    'that',
    'void'
  ];
  const LIVESCRIPT_KEYWORDS = [
    'then',
    'unless',
    'until',
    'loop',
    'of',
    'by',
    'when',
    'and',
    'or',
    'is',
    'isnt',
    'not',
    'it',
    'that',
    'otherwise',
    'from',
    'to',
    'til',
    'fallthrough',
    'case',
    'enum',
    'native',
    'list',
    'map',
    '__hasProp',
    '__extends',
    '__slice',
    '__bind',
    '__indexOf'
  ];
  const KEYWORDS$1 = {
    keyword: KEYWORDS.concat(LIVESCRIPT_KEYWORDS),
    literal: LITERALS.concat(LIVESCRIPT_LITERALS),
    built_in: BUILT_INS.concat(LIVESCRIPT_BUILT_INS)
  };
  const JS_IDENT_RE = '[A-Za-z$_](?:-[0-9A-Za-z$_]|[0-9A-Za-z$_])*';
  const TITLE = hljs.inherit(hljs.TITLE_MODE, { begin: JS_IDENT_RE });
  const SUBST = {
    className: 'subst',
    begin: /#\{/,
    end: /\}/,
    keywords: KEYWORDS$1
  };
  const SUBST_SIMPLE = {
    className: 'subst',
    begin: /#[A-Za-z$_]/,
    end: /(?:-[0-9A-Za-z$_]|[0-9A-Za-z$_])*/,
    keywords: KEYWORDS$1
  };
  const EXPRESSIONS = [
    hljs.BINARY_NUMBER_MODE,
    {
      className: 'number',
      begin: '(\\b0[xX][a-fA-F0-9_]+)|(\\b\\d(\\d|_\\d)*(\\.(\\d(\\d|_\\d)*)?)?(_*[eE]([-+]\\d(_\\d|\\d)*)?)?[_a-z]*)',
      relevance: 0,
      starts: {
        end: '(\\s*/)?',
        relevance: 0
      } // a number tries to eat the following slash to prevent treating it as a regexp
    },
    {
      className: 'string',
      variants: [
        {
          begin: /'''/,
          end: /'''/,
          contains: [ hljs.BACKSLASH_ESCAPE ]
        },
        {
          begin: /'/,
          end: /'/,
          contains: [ hljs.BACKSLASH_ESCAPE ]
        },
        {
          begin: /"""/,
          end: /"""/,
          contains: [
            hljs.BACKSLASH_ESCAPE,
            SUBST,
            SUBST_SIMPLE
          ]
        },
        {
          begin: /"/,
          end: /"/,
          contains: [
            hljs.BACKSLASH_ESCAPE,
            SUBST,
            SUBST_SIMPLE
          ]
        },
        {
          begin: /\\/,
          end: /(\s|$)/,
          excludeEnd: true
        }
      ]
    },
    {
      className: 'regexp',
      variants: [
        {
          begin: '//',
          end: '//[gim]*',
          contains: [
            SUBST,
            hljs.HASH_COMMENT_MODE
          ]
        },
        {
          // regex can't start with space to parse x / 2 / 3 as two divisions
          // regex can't start with *, and it supports an "illegal" in the main mode
          begin: /\/(?![ *])(\\.|[^\\\n])*?\/[gim]*(?=\W)/ }
      ]
    },
    { begin: '@' + JS_IDENT_RE },
    {
      begin: '``',
      end: '``',
      excludeBegin: true,
      excludeEnd: true,
      subLanguage: 'javascript'
    }
  ];
  SUBST.contains = EXPRESSIONS;

  const PARAMS = {
    className: 'params',
    begin: '\\(',
    returnBegin: true,
    /* We need another contained nameless mode to not have every nested
    pair of parens to be called "params" */
    contains: [
      {
        begin: /\(/,
        end: /\)/,
        keywords: KEYWORDS$1,
        contains: [ 'self' ].concat(EXPRESSIONS)
      }
    ]
  };

  const SYMBOLS = { begin: '(#=>|=>|\\|>>|-?->|!->)' };

  const CLASS_DEFINITION = {
    variants: [
      { match: [
        /class\s+/,
        JS_IDENT_RE,
        /\s+extends\s+/,
        JS_IDENT_RE
      ] },
      { match: [
        /class\s+/,
        JS_IDENT_RE
      ] }
    ],
    scope: {
      2: "title.class",
      4: "title.class.inherited"
    },
    keywords: KEYWORDS$1
  };

  return {
    name: 'LiveScript',
    aliases: [ 'ls' ],
    keywords: KEYWORDS$1,
    illegal: /\/\*/,
    contains: EXPRESSIONS.concat([
      hljs.COMMENT('\\/\\*', '\\*\\/'),
      hljs.HASH_COMMENT_MODE,
      SYMBOLS, // relevance booster
      {
        className: 'function',
        contains: [
          TITLE,
          PARAMS
        ],
        returnBegin: true,
        variants: [
          {
            begin: '(' + JS_IDENT_RE + '\\s*(?:=|:=)\\s*)?(\\(.*\\)\\s*)?\\B->\\*?',
            end: '->\\*?'
          },
          {
            begin: '(' + JS_IDENT_RE + '\\s*(?:=|:=)\\s*)?!?(\\(.*\\)\\s*)?\\B[-~]{1,2}>\\*?',
            end: '[-~]{1,2}>\\*?'
          },
          {
            begin: '(' + JS_IDENT_RE + '\\s*(?:=|:=)\\s*)?(\\(.*\\)\\s*)?\\B!?[-~]{1,2}>\\*?',
            end: '!?[-~]{1,2}>\\*?'
          }
        ]
      },
      CLASS_DEFINITION,
      {
        begin: JS_IDENT_RE + ':',
        end: ':',
        returnBegin: true,
        returnEnd: true,
        relevance: 0
      }
    ])
  };
}

module.exports = livescript;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/llvm.js":
/*!*********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/llvm.js ***!
  \*********************************************************/
/***/ (function(module) {

/*
Language: LLVM IR
Author: Michael Rodler <contact@f0rki.at>
Description: language used as intermediate representation in the LLVM compiler framework
Website: https://llvm.org/docs/LangRef.html
Category: assembler
Audit: 2020
*/

/** @type LanguageFn */
function llvm(hljs) {
  const regex = hljs.regex;
  const IDENT_RE = /([-a-zA-Z$._][\w$.-]*)/;
  const TYPE = {
    className: 'type',
    begin: /\bi\d+(?=\s|\b)/
  };
  const OPERATOR = {
    className: 'operator',
    relevance: 0,
    begin: /=/
  };
  const PUNCTUATION = {
    className: 'punctuation',
    relevance: 0,
    begin: /,/
  };
  const NUMBER = {
    className: 'number',
    variants: [
      { begin: /[su]?0[xX][KMLHR]?[a-fA-F0-9]+/ },
      { begin: /[-+]?\d+(?:[.]\d+)?(?:[eE][-+]?\d+(?:[.]\d+)?)?/ }
    ],
    relevance: 0
  };
  const LABEL = {
    className: 'symbol',
    variants: [ { begin: /^\s*[a-z]+:/ }, // labels
    ],
    relevance: 0
  };
  const VARIABLE = {
    className: 'variable',
    variants: [
      { begin: regex.concat(/%/, IDENT_RE) },
      { begin: /%\d+/ },
      { begin: /#\d+/ },
    ]
  };
  const FUNCTION = {
    className: 'title',
    variants: [
      { begin: regex.concat(/@/, IDENT_RE) },
      { begin: /@\d+/ },
      { begin: regex.concat(/!/, IDENT_RE) },
      { begin: regex.concat(/!\d+/, IDENT_RE) },
      // https://llvm.org/docs/LangRef.html#namedmetadatastructure
      // obviously a single digit can also be used in this fashion
      { begin: /!\d+/ }
    ]
  };

  return {
    name: 'LLVM IR',
    // TODO: split into different categories of keywords
    keywords:
      'begin end true false declare define global '
      + 'constant private linker_private internal '
      + 'available_externally linkonce linkonce_odr weak '
      + 'weak_odr appending dllimport dllexport common '
      + 'default hidden protected extern_weak external '
      + 'thread_local zeroinitializer undef null to tail '
      + 'target triple datalayout volatile nuw nsw nnan '
      + 'ninf nsz arcp fast exact inbounds align '
      + 'addrspace section alias module asm sideeffect '
      + 'gc dbg linker_private_weak attributes blockaddress '
      + 'initialexec localdynamic localexec prefix unnamed_addr '
      + 'ccc fastcc coldcc x86_stdcallcc x86_fastcallcc '
      + 'arm_apcscc arm_aapcscc arm_aapcs_vfpcc ptx_device '
      + 'ptx_kernel intel_ocl_bicc msp430_intrcc spir_func '
      + 'spir_kernel x86_64_sysvcc x86_64_win64cc x86_thiscallcc '
      + 'cc c signext zeroext inreg sret nounwind '
      + 'noreturn noalias nocapture byval nest readnone '
      + 'readonly inlinehint noinline alwaysinline optsize ssp '
      + 'sspreq noredzone noimplicitfloat naked builtin cold '
      + 'nobuiltin noduplicate nonlazybind optnone returns_twice '
      + 'sanitize_address sanitize_memory sanitize_thread sspstrong '
      + 'uwtable returned type opaque eq ne slt sgt '
      + 'sle sge ult ugt ule uge oeq one olt ogt '
      + 'ole oge ord uno ueq une x acq_rel acquire '
      + 'alignstack atomic catch cleanup filter inteldialect '
      + 'max min monotonic nand personality release seq_cst '
      + 'singlethread umax umin unordered xchg add fadd '
      + 'sub fsub mul fmul udiv sdiv fdiv urem srem '
      + 'frem shl lshr ashr and or xor icmp fcmp '
      + 'phi call trunc zext sext fptrunc fpext uitofp '
      + 'sitofp fptoui fptosi inttoptr ptrtoint bitcast '
      + 'addrspacecast select va_arg ret br switch invoke '
      + 'unwind unreachable indirectbr landingpad resume '
      + 'malloc alloca free load store getelementptr '
      + 'extractelement insertelement shufflevector getresult '
      + 'extractvalue insertvalue atomicrmw cmpxchg fence '
      + 'argmemonly double',
    contains: [
      TYPE,
      // this matches "empty comments"...
      // ...because it's far more likely this is a statement terminator in
      // another language than an actual comment
      hljs.COMMENT(/;\s*$/, null, { relevance: 0 }),
      hljs.COMMENT(/;/, /$/),
      {
        className: 'string',
        begin: /"/,
        end: /"/,
        contains: [
          {
            className: 'char.escape',
            match: /\\\d\d/
          }
        ]
      },
      FUNCTION,
      PUNCTUATION,
      OPERATOR,
      VARIABLE,
      LABEL,
      NUMBER
    ]
  };
}

module.exports = llvm;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/lsl.js":
/*!********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/lsl.js ***!
  \********************************************************/
/***/ (function(module) {

/*
Language: LSL (Linden Scripting Language)
Description: The Linden Scripting Language is used in Second Life by Linden Labs.
Author: Builder's Brewery <buildersbrewery@gmail.com>
Website: http://wiki.secondlife.com/wiki/LSL_Portal
Category: scripting
*/

function lsl(hljs) {
  const LSL_STRING_ESCAPE_CHARS = {
    className: 'subst',
    begin: /\\[tn"\\]/
  };

  const LSL_STRINGS = {
    className: 'string',
    begin: '"',
    end: '"',
    contains: [ LSL_STRING_ESCAPE_CHARS ]
  };

  const LSL_NUMBERS = {
    className: 'number',
    relevance: 0,
    begin: hljs.C_NUMBER_RE
  };

  const LSL_CONSTANTS = {
    className: 'literal',
    variants: [
      { begin: '\\b(PI|TWO_PI|PI_BY_TWO|DEG_TO_RAD|RAD_TO_DEG|SQRT2)\\b' },
      { begin: '\\b(XP_ERROR_(EXPERIENCES_DISABLED|EXPERIENCE_(DISABLED|SUSPENDED)|INVALID_(EXPERIENCE|PARAMETERS)|KEY_NOT_FOUND|MATURITY_EXCEEDED|NONE|NOT_(FOUND|PERMITTED(_LAND)?)|NO_EXPERIENCE|QUOTA_EXCEEDED|RETRY_UPDATE|STORAGE_EXCEPTION|STORE_DISABLED|THROTTLED|UNKNOWN_ERROR)|JSON_APPEND|STATUS_(PHYSICS|ROTATE_[XYZ]|PHANTOM|SANDBOX|BLOCK_GRAB(_OBJECT)?|(DIE|RETURN)_AT_EDGE|CAST_SHADOWS|OK|MALFORMED_PARAMS|TYPE_MISMATCH|BOUNDS_ERROR|NOT_(FOUND|SUPPORTED)|INTERNAL_ERROR|WHITELIST_FAILED)|AGENT(_(BY_(LEGACY_|USER)NAME|FLYING|ATTACHMENTS|SCRIPTED|MOUSELOOK|SITTING|ON_OBJECT|AWAY|WALKING|IN_AIR|TYPING|CROUCHING|BUSY|ALWAYS_RUN|AUTOPILOT|LIST_(PARCEL(_OWNER)?|REGION)))?|CAMERA_(PITCH|DISTANCE|BEHINDNESS_(ANGLE|LAG)|(FOCUS|POSITION)(_(THRESHOLD|LOCKED|LAG))?|FOCUS_OFFSET|ACTIVE)|ANIM_ON|LOOP|REVERSE|PING_PONG|SMOOTH|ROTATE|SCALE|ALL_SIDES|LINK_(ROOT|SET|ALL_(OTHERS|CHILDREN)|THIS)|ACTIVE|PASS(IVE|_(ALWAYS|IF_NOT_HANDLED|NEVER))|SCRIPTED|CONTROL_(FWD|BACK|(ROT_)?(LEFT|RIGHT)|UP|DOWN|(ML_)?LBUTTON)|PERMISSION_(RETURN_OBJECTS|DEBIT|OVERRIDE_ANIMATIONS|SILENT_ESTATE_MANAGEMENT|TAKE_CONTROLS|TRIGGER_ANIMATION|ATTACH|CHANGE_LINKS|(CONTROL|TRACK)_CAMERA|TELEPORT)|INVENTORY_(TEXTURE|SOUND|OBJECT|SCRIPT|LANDMARK|CLOTHING|NOTECARD|BODYPART|ANIMATION|GESTURE|ALL|NONE)|CHANGED_(INVENTORY|COLOR|SHAPE|SCALE|TEXTURE|LINK|ALLOWED_DROP|OWNER|REGION(_START)?|TELEPORT|MEDIA)|OBJECT_(CLICK_ACTION|HOVER_HEIGHT|LAST_OWNER_ID|(PHYSICS|SERVER|STREAMING)_COST|UNKNOWN_DETAIL|CHARACTER_TIME|PHANTOM|PHYSICS|TEMP_(ATTACHED|ON_REZ)|NAME|DESC|POS|PRIM_(COUNT|EQUIVALENCE)|RETURN_(PARCEL(_OWNER)?|REGION)|REZZER_KEY|ROO?T|VELOCITY|OMEGA|OWNER|GROUP(_TAG)?|CREATOR|ATTACHED_(POINT|SLOTS_AVAILABLE)|RENDER_WEIGHT|(BODY_SHAPE|PATHFINDING)_TYPE|(RUNNING|TOTAL)_SCRIPT_COUNT|TOTAL_INVENTORY_COUNT|SCRIPT_(MEMORY|TIME))|TYPE_(INTEGER|FLOAT|STRING|KEY|VECTOR|ROTATION|INVALID)|(DEBUG|PUBLIC)_CHANNEL|ATTACH_(AVATAR_CENTER|CHEST|HEAD|BACK|PELVIS|MOUTH|CHIN|NECK|NOSE|BELLY|[LR](SHOULDER|HAND|FOOT|EAR|EYE|[UL](ARM|LEG)|HIP)|(LEFT|RIGHT)_PEC|HUD_(CENTER_[12]|TOP_(RIGHT|CENTER|LEFT)|BOTTOM(_(RIGHT|LEFT))?)|[LR]HAND_RING1|TAIL_(BASE|TIP)|[LR]WING|FACE_(JAW|[LR]EAR|[LR]EYE|TOUNGE)|GROIN|HIND_[LR]FOOT)|LAND_(LEVEL|RAISE|LOWER|SMOOTH|NOISE|REVERT)|DATA_(ONLINE|NAME|BORN|SIM_(POS|STATUS|RATING)|PAYINFO)|PAYMENT_INFO_(ON_FILE|USED)|REMOTE_DATA_(CHANNEL|REQUEST|REPLY)|PSYS_(PART_(BF_(ZERO|ONE(_MINUS_(DEST_COLOR|SOURCE_(ALPHA|COLOR)))?|DEST_COLOR|SOURCE_(ALPHA|COLOR))|BLEND_FUNC_(DEST|SOURCE)|FLAGS|(START|END)_(COLOR|ALPHA|SCALE|GLOW)|MAX_AGE|(RIBBON|WIND|INTERP_(COLOR|SCALE)|BOUNCE|FOLLOW_(SRC|VELOCITY)|TARGET_(POS|LINEAR)|EMISSIVE)_MASK)|SRC_(MAX_AGE|PATTERN|ANGLE_(BEGIN|END)|BURST_(RATE|PART_COUNT|RADIUS|SPEED_(MIN|MAX))|ACCEL|TEXTURE|TARGET_KEY|OMEGA|PATTERN_(DROP|EXPLODE|ANGLE(_CONE(_EMPTY)?)?)))|VEHICLE_(REFERENCE_FRAME|TYPE_(NONE|SLED|CAR|BOAT|AIRPLANE|BALLOON)|(LINEAR|ANGULAR)_(FRICTION_TIMESCALE|MOTOR_DIRECTION)|LINEAR_MOTOR_OFFSET|HOVER_(HEIGHT|EFFICIENCY|TIMESCALE)|BUOYANCY|(LINEAR|ANGULAR)_(DEFLECTION_(EFFICIENCY|TIMESCALE)|MOTOR_(DECAY_)?TIMESCALE)|VERTICAL_ATTRACTION_(EFFICIENCY|TIMESCALE)|BANKING_(EFFICIENCY|MIX|TIMESCALE)|FLAG_(NO_DEFLECTION_UP|LIMIT_(ROLL_ONLY|MOTOR_UP)|HOVER_((WATER|TERRAIN|UP)_ONLY|GLOBAL_HEIGHT)|MOUSELOOK_(STEER|BANK)|CAMERA_DECOUPLED))|PRIM_(ALLOW_UNSIT|ALPHA_MODE(_(BLEND|EMISSIVE|MASK|NONE))?|NORMAL|SPECULAR|TYPE(_(BOX|CYLINDER|PRISM|SPHERE|TORUS|TUBE|RING|SCULPT))?|HOLE_(DEFAULT|CIRCLE|SQUARE|TRIANGLE)|MATERIAL(_(STONE|METAL|GLASS|WOOD|FLESH|PLASTIC|RUBBER))?|SHINY_(NONE|LOW|MEDIUM|HIGH)|BUMP_(NONE|BRIGHT|DARK|WOOD|BARK|BRICKS|CHECKER|CONCRETE|TILE|STONE|DISKS|GRAVEL|BLOBS|SIDING|LARGETILE|STUCCO|SUCTION|WEAVE)|TEXGEN_(DEFAULT|PLANAR)|SCRIPTED_SIT_ONLY|SCULPT_(TYPE_(SPHERE|TORUS|PLANE|CYLINDER|MASK)|FLAG_(MIRROR|INVERT))|PHYSICS(_(SHAPE_(CONVEX|NONE|PRIM|TYPE)))?|(POS|ROT)_LOCAL|SLICE|TEXT|FLEXIBLE|POINT_LIGHT|TEMP_ON_REZ|PHANTOM|POSITION|SIT_TARGET|SIZE|ROTATION|TEXTURE|NAME|OMEGA|DESC|LINK_TARGET|COLOR|BUMP_SHINY|FULLBRIGHT|TEXGEN|GLOW|MEDIA_(ALT_IMAGE_ENABLE|CONTROLS|(CURRENT|HOME)_URL|AUTO_(LOOP|PLAY|SCALE|ZOOM)|FIRST_CLICK_INTERACT|(WIDTH|HEIGHT)_PIXELS|WHITELIST(_ENABLE)?|PERMS_(INTERACT|CONTROL)|PARAM_MAX|CONTROLS_(STANDARD|MINI)|PERM_(NONE|OWNER|GROUP|ANYONE)|MAX_(URL_LENGTH|WHITELIST_(SIZE|COUNT)|(WIDTH|HEIGHT)_PIXELS)))|MASK_(BASE|OWNER|GROUP|EVERYONE|NEXT)|PERM_(TRANSFER|MODIFY|COPY|MOVE|ALL)|PARCEL_(MEDIA_COMMAND_(STOP|PAUSE|PLAY|LOOP|TEXTURE|URL|TIME|AGENT|UNLOAD|AUTO_ALIGN|TYPE|SIZE|DESC|LOOP_SET)|FLAG_(ALLOW_(FLY|(GROUP_)?SCRIPTS|LANDMARK|TERRAFORM|DAMAGE|CREATE_(GROUP_)?OBJECTS)|USE_(ACCESS_(GROUP|LIST)|BAN_LIST|LAND_PASS_LIST)|LOCAL_SOUND_ONLY|RESTRICT_PUSHOBJECT|ALLOW_(GROUP|ALL)_OBJECT_ENTRY)|COUNT_(TOTAL|OWNER|GROUP|OTHER|SELECTED|TEMP)|DETAILS_(NAME|DESC|OWNER|GROUP|AREA|ID|SEE_AVATARS))|LIST_STAT_(MAX|MIN|MEAN|MEDIAN|STD_DEV|SUM(_SQUARES)?|NUM_COUNT|GEOMETRIC_MEAN|RANGE)|PAY_(HIDE|DEFAULT)|REGION_FLAG_(ALLOW_DAMAGE|FIXED_SUN|BLOCK_TERRAFORM|SANDBOX|DISABLE_(COLLISIONS|PHYSICS)|BLOCK_FLY|ALLOW_DIRECT_TELEPORT|RESTRICT_PUSHOBJECT)|HTTP_(METHOD|MIMETYPE|BODY_(MAXLENGTH|TRUNCATED)|CUSTOM_HEADER|PRAGMA_NO_CACHE|VERBOSE_THROTTLE|VERIFY_CERT)|SIT_(INVALID_(AGENT|LINK_OBJECT)|NO(T_EXPERIENCE|_(ACCESS|EXPERIENCE_PERMISSION|SIT_TARGET)))|STRING_(TRIM(_(HEAD|TAIL))?)|CLICK_ACTION_(NONE|TOUCH|SIT|BUY|PAY|OPEN(_MEDIA)?|PLAY|ZOOM)|TOUCH_INVALID_FACE|PROFILE_(NONE|SCRIPT_MEMORY)|RC_(DATA_FLAGS|DETECT_PHANTOM|GET_(LINK_NUM|NORMAL|ROOT_KEY)|MAX_HITS|REJECT_(TYPES|AGENTS|(NON)?PHYSICAL|LAND))|RCERR_(CAST_TIME_EXCEEDED|SIM_PERF_LOW|UNKNOWN)|ESTATE_ACCESS_(ALLOWED_(AGENT|GROUP)_(ADD|REMOVE)|BANNED_AGENT_(ADD|REMOVE))|DENSITY|FRICTION|RESTITUTION|GRAVITY_MULTIPLIER|KFM_(COMMAND|CMD_(PLAY|STOP|PAUSE)|MODE|FORWARD|LOOP|PING_PONG|REVERSE|DATA|ROTATION|TRANSLATION)|ERR_(GENERIC|PARCEL_PERMISSIONS|MALFORMED_PARAMS|RUNTIME_PERMISSIONS|THROTTLED)|CHARACTER_(CMD_((SMOOTH_)?STOP|JUMP)|DESIRED_(TURN_)?SPEED|RADIUS|STAY_WITHIN_PARCEL|LENGTH|ORIENTATION|ACCOUNT_FOR_SKIPPED_FRAMES|AVOIDANCE_MODE|TYPE(_([ABCD]|NONE))?|MAX_(DECEL|TURN_RADIUS|(ACCEL|SPEED)))|PURSUIT_(OFFSET|FUZZ_FACTOR|GOAL_TOLERANCE|INTERCEPT)|REQUIRE_LINE_OF_SIGHT|FORCE_DIRECT_PATH|VERTICAL|HORIZONTAL|AVOID_(CHARACTERS|DYNAMIC_OBSTACLES|NONE)|PU_(EVADE_(HIDDEN|SPOTTED)|FAILURE_(DYNAMIC_PATHFINDING_DISABLED|INVALID_(GOAL|START)|NO_(NAVMESH|VALID_DESTINATION)|OTHER|TARGET_GONE|(PARCEL_)?UNREACHABLE)|(GOAL|SLOWDOWN_DISTANCE)_REACHED)|TRAVERSAL_TYPE(_(FAST|NONE|SLOW))?|CONTENT_TYPE_(ATOM|FORM|HTML|JSON|LLSD|RSS|TEXT|XHTML|XML)|GCNP_(RADIUS|STATIC)|(PATROL|WANDER)_PAUSE_AT_WAYPOINTS|OPT_(AVATAR|CHARACTER|EXCLUSION_VOLUME|LEGACY_LINKSET|MATERIAL_VOLUME|OTHER|STATIC_OBSTACLE|WALKABLE)|SIM_STAT_PCT_CHARS_STEPPED)\\b' },
      { begin: '\\b(FALSE|TRUE)\\b' },
      { begin: '\\b(ZERO_ROTATION)\\b' },
      { begin: '\\b(EOF|JSON_(ARRAY|DELETE|FALSE|INVALID|NULL|NUMBER|OBJECT|STRING|TRUE)|NULL_KEY|TEXTURE_(BLANK|DEFAULT|MEDIA|PLYWOOD|TRANSPARENT)|URL_REQUEST_(GRANTED|DENIED))\\b' },
      { begin: '\\b(ZERO_VECTOR|TOUCH_INVALID_(TEXCOORD|VECTOR))\\b' }
    ]
  };

  const LSL_FUNCTIONS = {
    className: 'built_in',
    begin: '\\b(ll(AgentInExperience|(Create|DataSize|Delete|KeyCount|Keys|Read|Update)KeyValue|GetExperience(Details|ErrorMessage)|ReturnObjectsBy(ID|Owner)|Json(2List|[GS]etValue|ValueType)|Sin|Cos|Tan|Atan2|Sqrt|Pow|Abs|Fabs|Frand|Floor|Ceil|Round|Vec(Mag|Norm|Dist)|Rot(Between|2(Euler|Fwd|Left|Up))|(Euler|Axes)2Rot|Whisper|(Region|Owner)?Say|Shout|Listen(Control|Remove)?|Sensor(Repeat|Remove)?|Detected(Name|Key|Owner|Type|Pos|Vel|Grab|Rot|Group|LinkNumber)|Die|Ground|Wind|([GS]et)(AnimationOverride|MemoryLimit|PrimMediaParams|ParcelMusicURL|Object(Desc|Name)|PhysicsMaterial|Status|Scale|Color|Alpha|Texture|Pos|Rot|Force|Torque)|ResetAnimationOverride|(Scale|Offset|Rotate)Texture|(Rot)?Target(Remove)?|(Stop)?MoveToTarget|Apply(Rotational)?Impulse|Set(KeyframedMotion|ContentType|RegionPos|(Angular)?Velocity|Buoyancy|HoverHeight|ForceAndTorque|TimerEvent|ScriptState|Damage|TextureAnim|Sound(Queueing|Radius)|Vehicle(Type|(Float|Vector|Rotation)Param)|(Touch|Sit)?Text|Camera(Eye|At)Offset|PrimitiveParams|ClickAction|Link(Alpha|Color|PrimitiveParams(Fast)?|Texture(Anim)?|Camera|Media)|RemoteScriptAccessPin|PayPrice|LocalRot)|ScaleByFactor|Get((Max|Min)ScaleFactor|ClosestNavPoint|StaticPath|SimStats|Env|PrimitiveParams|Link(PrimitiveParams|Number(OfSides)?|Key|Name|Media)|HTTPHeader|FreeURLs|Object(Details|PermMask|PrimCount)|Parcel(MaxPrims|Details|Prim(Count|Owners))|Attached(List)?|(SPMax|Free|Used)Memory|Region(Name|TimeDilation|FPS|Corner|AgentCount)|Root(Position|Rotation)|UnixTime|(Parcel|Region)Flags|(Wall|GMT)clock|SimulatorHostname|BoundingBox|GeometricCenter|Creator|NumberOf(Prims|NotecardLines|Sides)|Animation(List)?|(Camera|Local)(Pos|Rot)|Vel|Accel|Omega|Time(stamp|OfDay)|(Object|CenterOf)?Mass|MassMKS|Energy|Owner|(Owner)?Key|SunDirection|Texture(Offset|Scale|Rot)|Inventory(Number|Name|Key|Type|Creator|PermMask)|Permissions(Key)?|StartParameter|List(Length|EntryType)|Date|Agent(Size|Info|Language|List)|LandOwnerAt|NotecardLine|Script(Name|State))|(Get|Reset|GetAndReset)Time|PlaySound(Slave)?|LoopSound(Master|Slave)?|(Trigger|Stop|Preload)Sound|((Get|Delete)Sub|Insert)String|To(Upper|Lower)|Give(InventoryList|Money)|RezObject|(Stop)?LookAt|Sleep|CollisionFilter|(Take|Release)Controls|DetachFromAvatar|AttachToAvatar(Temp)?|InstantMessage|(GetNext)?Email|StopHover|MinEventDelay|RotLookAt|String(Length|Trim)|(Start|Stop)Animation|TargetOmega|Request(Experience)?Permissions|(Create|Break)Link|BreakAllLinks|(Give|Remove)Inventory|Water|PassTouches|Request(Agent|Inventory)Data|TeleportAgent(Home|GlobalCoords)?|ModifyLand|CollisionSound|ResetScript|MessageLinked|PushObject|PassCollisions|AxisAngle2Rot|Rot2(Axis|Angle)|A(cos|sin)|AngleBetween|AllowInventoryDrop|SubStringIndex|List2(CSV|Integer|Json|Float|String|Key|Vector|Rot|List(Strided)?)|DeleteSubList|List(Statistics|Sort|Randomize|(Insert|Find|Replace)List)|EdgeOfWorld|AdjustSoundVolume|Key2Name|TriggerSoundLimited|EjectFromLand|(CSV|ParseString)2List|OverMyLand|SameGroup|UnSit|Ground(Slope|Normal|Contour)|GroundRepel|(Set|Remove)VehicleFlags|SitOnLink|(AvatarOn)?(Link)?SitTarget|Script(Danger|Profiler)|Dialog|VolumeDetect|ResetOtherScript|RemoteLoadScriptPin|(Open|Close)RemoteDataChannel|SendRemoteData|RemoteDataReply|(Integer|String)ToBase64|XorBase64|Log(10)?|Base64To(String|Integer)|ParseStringKeepNulls|RezAtRoot|RequestSimulatorData|ForceMouselook|(Load|Release|(E|Une)scape)URL|ParcelMedia(CommandList|Query)|ModPow|MapDestination|(RemoveFrom|AddTo|Reset)Land(Pass|Ban)List|(Set|Clear)CameraParams|HTTP(Request|Response)|TextBox|DetectedTouch(UV|Face|Pos|(N|Bin)ormal|ST)|(MD5|SHA1|DumpList2)String|Request(Secure)?URL|Clear(Prim|Link)Media|(Link)?ParticleSystem|(Get|Request)(Username|DisplayName)|RegionSayTo|CastRay|GenerateKey|TransferLindenDollars|ManageEstateAccess|(Create|Delete)Character|ExecCharacterCmd|Evade|FleeFrom|NavigateTo|PatrolPoints|Pursue|UpdateCharacter|WanderWithin))\\b'
  };

  return {
    name: 'LSL (Linden Scripting Language)',
    illegal: ':',
    contains: [
      LSL_STRINGS,
      {
        className: 'comment',
        variants: [
          hljs.COMMENT('//', '$'),
          hljs.COMMENT('/\\*', '\\*/')
        ],
        relevance: 0
      },
      LSL_NUMBERS,
      {
        className: 'section',
        variants: [
          { begin: '\\b(state|default)\\b' },
          { begin: '\\b(state_(entry|exit)|touch(_(start|end))?|(land_)?collision(_(start|end))?|timer|listen|(no_)?sensor|control|(not_)?at_(rot_)?target|money|email|experience_permissions(_denied)?|run_time_permissions|changed|attach|dataserver|moving_(start|end)|link_message|(on|object)_rez|remote_data|http_re(sponse|quest)|path_update|transaction_result)\\b' }
        ]
      },
      LSL_FUNCTIONS,
      LSL_CONSTANTS,
      {
        className: 'type',
        begin: '\\b(integer|float|string|key|vector|quaternion|rotation|list)\\b'
      }
    ]
  };
}

module.exports = lsl;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/lua.js":
/*!********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/lua.js ***!
  \********************************************************/
/***/ (function(module) {

/*
Language: Lua
Description: Lua is a powerful, efficient, lightweight, embeddable scripting language.
Author: Andrew Fedorov <dmmdrs@mail.ru>
Category: common, scripting
Website: https://www.lua.org
*/

function lua(hljs) {
  const OPENING_LONG_BRACKET = '\\[=*\\[';
  const CLOSING_LONG_BRACKET = '\\]=*\\]';
  const LONG_BRACKETS = {
    begin: OPENING_LONG_BRACKET,
    end: CLOSING_LONG_BRACKET,
    contains: [ 'self' ]
  };
  const COMMENTS = [
    hljs.COMMENT('--(?!' + OPENING_LONG_BRACKET + ')', '$'),
    hljs.COMMENT(
      '--' + OPENING_LONG_BRACKET,
      CLOSING_LONG_BRACKET,
      {
        contains: [ LONG_BRACKETS ],
        relevance: 10
      }
    )
  ];
  return {
    name: 'Lua',
    keywords: {
      $pattern: hljs.UNDERSCORE_IDENT_RE,
      literal: "true false nil",
      keyword: "and break do else elseif end for goto if in local not or repeat return then until while",
      built_in:
        // Metatags and globals:
        '_G _ENV _VERSION __index __newindex __mode __call __metatable __tostring __len '
        + '__gc __add __sub __mul __div __mod __pow __concat __unm __eq __lt __le assert '
        // Standard methods and properties:
        + 'collectgarbage dofile error getfenv getmetatable ipairs load loadfile loadstring '
        + 'module next pairs pcall print rawequal rawget rawset require select setfenv '
        + 'setmetatable tonumber tostring type unpack xpcall arg self '
        // Library methods and properties (one line per library):
        + 'coroutine resume yield status wrap create running debug getupvalue '
        + 'debug sethook getmetatable gethook setmetatable setlocal traceback setfenv getinfo setupvalue getlocal getregistry getfenv '
        + 'io lines write close flush open output type read stderr stdin input stdout popen tmpfile '
        + 'math log max acos huge ldexp pi cos tanh pow deg tan cosh sinh random randomseed frexp ceil floor rad abs sqrt modf asin min mod fmod log10 atan2 exp sin atan '
        + 'os exit setlocale date getenv difftime remove time clock tmpname rename execute package preload loadlib loaded loaders cpath config path seeall '
        + 'string sub upper len gfind rep find match char dump gmatch reverse byte format gsub lower '
        + 'table setn insert getn foreachi maxn foreach concat sort remove'
    },
    contains: COMMENTS.concat([
      {
        className: 'function',
        beginKeywords: 'function',
        end: '\\)',
        contains: [
          hljs.inherit(hljs.TITLE_MODE, { begin: '([_a-zA-Z]\\w*\\.)*([_a-zA-Z]\\w*:)?[_a-zA-Z]\\w*' }),
          {
            className: 'params',
            begin: '\\(',
            endsWithParent: true,
            contains: COMMENTS
          }
        ].concat(COMMENTS)
      },
      hljs.C_NUMBER_MODE,
      hljs.APOS_STRING_MODE,
      hljs.QUOTE_STRING_MODE,
      {
        className: 'string',
        begin: OPENING_LONG_BRACKET,
        end: CLOSING_LONG_BRACKET,
        contains: [ LONG_BRACKETS ],
        relevance: 5
      }
    ])
  };
}

module.exports = lua;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/makefile.js":
/*!*************************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/makefile.js ***!
  \*************************************************************/
/***/ (function(module) {

/*
Language: Makefile
Author: Ivan Sagalaev <maniac@softwaremaniacs.org>
Contributors: Joël Porquet <joel@porquet.org>
Website: https://www.gnu.org/software/make/manual/html_node/Introduction.html
Category: common
*/

function makefile(hljs) {
  /* Variables: simple (eg $(var)) and special (eg $@) */
  const VARIABLE = {
    className: 'variable',
    variants: [
      {
        begin: '\\$\\(' + hljs.UNDERSCORE_IDENT_RE + '\\)',
        contains: [ hljs.BACKSLASH_ESCAPE ]
      },
      { begin: /\$[@%<?\^\+\*]/ }
    ]
  };
  /* Quoted string with variables inside */
  const QUOTE_STRING = {
    className: 'string',
    begin: /"/,
    end: /"/,
    contains: [
      hljs.BACKSLASH_ESCAPE,
      VARIABLE
    ]
  };
  /* Function: $(func arg,...) */
  const FUNC = {
    className: 'variable',
    begin: /\$\([\w-]+\s/,
    end: /\)/,
    keywords: { built_in:
        'subst patsubst strip findstring filter filter-out sort '
        + 'word wordlist firstword lastword dir notdir suffix basename '
        + 'addsuffix addprefix join wildcard realpath abspath error warning '
        + 'shell origin flavor foreach if or and call eval file value' },
    contains: [ VARIABLE ]
  };
  /* Variable assignment */
  const ASSIGNMENT = { begin: '^' + hljs.UNDERSCORE_IDENT_RE + '\\s*(?=[:+?]?=)' };
  /* Meta targets (.PHONY) */
  const META = {
    className: 'meta',
    begin: /^\.PHONY:/,
    end: /$/,
    keywords: {
      $pattern: /[\.\w]+/,
      keyword: '.PHONY'
    }
  };
  /* Targets */
  const TARGET = {
    className: 'section',
    begin: /^[^\s]+:/,
    end: /$/,
    contains: [ VARIABLE ]
  };
  return {
    name: 'Makefile',
    aliases: [
      'mk',
      'mak',
      'make',
    ],
    keywords: {
      $pattern: /[\w-]+/,
      keyword: 'define endef undefine ifdef ifndef ifeq ifneq else endif '
      + 'include -include sinclude override export unexport private vpath'
    },
    contains: [
      hljs.HASH_COMMENT_MODE,
      VARIABLE,
      QUOTE_STRING,
      FUNC,
      ASSIGNMENT,
      META,
      TARGET
    ]
  };
}

module.exports = makefile;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/markdown.js":
/*!*************************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/markdown.js ***!
  \*************************************************************/
/***/ (function(module) {

/*
Language: Markdown
Requires: xml.js
Author: John Crepezzi <john.crepezzi@gmail.com>
Website: https://daringfireball.net/projects/markdown/
Category: common, markup
*/

function markdown(hljs) {
  const regex = hljs.regex;
  const INLINE_HTML = {
    begin: /<\/?[A-Za-z_]/,
    end: '>',
    subLanguage: 'xml',
    relevance: 0
  };
  const HORIZONTAL_RULE = {
    begin: '^[-\\*]{3,}',
    end: '$'
  };
  const CODE = {
    className: 'code',
    variants: [
      // TODO: fix to allow these to work with sublanguage also
      { begin: '(`{3,})[^`](.|\\n)*?\\1`*[ ]*' },
      { begin: '(~{3,})[^~](.|\\n)*?\\1~*[ ]*' },
      // needed to allow markdown as a sublanguage to work
      {
        begin: '```',
        end: '```+[ ]*$'
      },
      {
        begin: '~~~',
        end: '~~~+[ ]*$'
      },
      { begin: '`.+?`' },
      {
        begin: '(?=^( {4}|\\t))',
        // use contains to gobble up multiple lines to allow the block to be whatever size
        // but only have a single open/close tag vs one per line
        contains: [
          {
            begin: '^( {4}|\\t)',
            end: '(\\n)$'
          }
        ],
        relevance: 0
      }
    ]
  };
  const LIST = {
    className: 'bullet',
    begin: '^[ \t]*([*+-]|(\\d+\\.))(?=\\s+)',
    end: '\\s+',
    excludeEnd: true
  };
  const LINK_REFERENCE = {
    begin: /^\[[^\n]+\]:/,
    returnBegin: true,
    contains: [
      {
        className: 'symbol',
        begin: /\[/,
        end: /\]/,
        excludeBegin: true,
        excludeEnd: true
      },
      {
        className: 'link',
        begin: /:\s*/,
        end: /$/,
        excludeBegin: true
      }
    ]
  };
  const URL_SCHEME = /[A-Za-z][A-Za-z0-9+.-]*/;
  const LINK = {
    variants: [
      // too much like nested array access in so many languages
      // to have any real relevance
      {
        begin: /\[.+?\]\[.*?\]/,
        relevance: 0
      },
      // popular internet URLs
      {
        begin: /\[.+?\]\(((data|javascript|mailto):|(?:http|ftp)s?:\/\/).*?\)/,
        relevance: 2
      },
      {
        begin: regex.concat(/\[.+?\]\(/, URL_SCHEME, /:\/\/.*?\)/),
        relevance: 2
      },
      // relative urls
      {
        begin: /\[.+?\]\([./?&#].*?\)/,
        relevance: 1
      },
      // whatever else, lower relevance (might not be a link at all)
      {
        begin: /\[.*?\]\(.*?\)/,
        relevance: 0
      }
    ],
    returnBegin: true,
    contains: [
      {
        // empty strings for alt or link text
        match: /\[(?=\])/ },
      {
        className: 'string',
        relevance: 0,
        begin: '\\[',
        end: '\\]',
        excludeBegin: true,
        returnEnd: true
      },
      {
        className: 'link',
        relevance: 0,
        begin: '\\]\\(',
        end: '\\)',
        excludeBegin: true,
        excludeEnd: true
      },
      {
        className: 'symbol',
        relevance: 0,
        begin: '\\]\\[',
        end: '\\]',
        excludeBegin: true,
        excludeEnd: true
      }
    ]
  };
  const BOLD = {
    className: 'strong',
    contains: [], // defined later
    variants: [
      {
        begin: /_{2}(?!\s)/,
        end: /_{2}/
      },
      {
        begin: /\*{2}(?!\s)/,
        end: /\*{2}/
      }
    ]
  };
  const ITALIC = {
    className: 'emphasis',
    contains: [], // defined later
    variants: [
      {
        begin: /\*(?![*\s])/,
        end: /\*/
      },
      {
        begin: /_(?![_\s])/,
        end: /_/,
        relevance: 0
      }
    ]
  };

  // 3 level deep nesting is not allowed because it would create confusion
  // in cases like `***testing***` because where we don't know if the last
  // `***` is starting a new bold/italic or finishing the last one
  const BOLD_WITHOUT_ITALIC = hljs.inherit(BOLD, { contains: [] });
  const ITALIC_WITHOUT_BOLD = hljs.inherit(ITALIC, { contains: [] });
  BOLD.contains.push(ITALIC_WITHOUT_BOLD);
  ITALIC.contains.push(BOLD_WITHOUT_ITALIC);

  let CONTAINABLE = [
    INLINE_HTML,
    LINK
  ];

  [
    BOLD,
    ITALIC,
    BOLD_WITHOUT_ITALIC,
    ITALIC_WITHOUT_BOLD
  ].forEach(m => {
    m.contains = m.contains.concat(CONTAINABLE);
  });

  CONTAINABLE = CONTAINABLE.concat(BOLD, ITALIC);

  const HEADER = {
    className: 'section',
    variants: [
      {
        begin: '^#{1,6}',
        end: '$',
        contains: CONTAINABLE
      },
      {
        begin: '(?=^.+?\\n[=-]{2,}$)',
        contains: [
          { begin: '^[=-]*$' },
          {
            begin: '^',
            end: "\\n",
            contains: CONTAINABLE
          }
        ]
      }
    ]
  };

  const BLOCKQUOTE = {
    className: 'quote',
    begin: '^>\\s+',
    contains: CONTAINABLE,
    end: '$'
  };

  return {
    name: 'Markdown',
    aliases: [
      'md',
      'mkdown',
      'mkd'
    ],
    contains: [
      HEADER,
      INLINE_HTML,
      LIST,
      BOLD,
      ITALIC,
      BLOCKQUOTE,
      CODE,
      HORIZONTAL_RULE,
      LINK,
      LINK_REFERENCE
    ]
  };
}

module.exports = markdown;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/mathematica.js":
/*!****************************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/mathematica.js ***!
  \****************************************************************/
/***/ (function(module) {

const SYSTEM_SYMBOLS = [
  "AASTriangle",
  "AbelianGroup",
  "Abort",
  "AbortKernels",
  "AbortProtect",
  "AbortScheduledTask",
  "Above",
  "Abs",
  "AbsArg",
  "AbsArgPlot",
  "Absolute",
  "AbsoluteCorrelation",
  "AbsoluteCorrelationFunction",
  "AbsoluteCurrentValue",
  "AbsoluteDashing",
  "AbsoluteFileName",
  "AbsoluteOptions",
  "AbsolutePointSize",
  "AbsoluteThickness",
  "AbsoluteTime",
  "AbsoluteTiming",
  "AcceptanceThreshold",
  "AccountingForm",
  "Accumulate",
  "Accuracy",
  "AccuracyGoal",
  "AcousticAbsorbingValue",
  "AcousticImpedanceValue",
  "AcousticNormalVelocityValue",
  "AcousticPDEComponent",
  "AcousticPressureCondition",
  "AcousticRadiationValue",
  "AcousticSoundHardValue",
  "AcousticSoundSoftCondition",
  "ActionDelay",
  "ActionMenu",
  "ActionMenuBox",
  "ActionMenuBoxOptions",
  "Activate",
  "Active",
  "ActiveClassification",
  "ActiveClassificationObject",
  "ActiveItem",
  "ActivePrediction",
  "ActivePredictionObject",
  "ActiveStyle",
  "AcyclicGraphQ",
  "AddOnHelpPath",
  "AddSides",
  "AddTo",
  "AddToSearchIndex",
  "AddUsers",
  "AdjacencyGraph",
  "AdjacencyList",
  "AdjacencyMatrix",
  "AdjacentMeshCells",
  "Adjugate",
  "AdjustmentBox",
  "AdjustmentBoxOptions",
  "AdjustTimeSeriesForecast",
  "AdministrativeDivisionData",
  "AffineHalfSpace",
  "AffineSpace",
  "AffineStateSpaceModel",
  "AffineTransform",
  "After",
  "AggregatedEntityClass",
  "AggregationLayer",
  "AircraftData",
  "AirportData",
  "AirPressureData",
  "AirSoundAttenuation",
  "AirTemperatureData",
  "AiryAi",
  "AiryAiPrime",
  "AiryAiZero",
  "AiryBi",
  "AiryBiPrime",
  "AiryBiZero",
  "AlgebraicIntegerQ",
  "AlgebraicNumber",
  "AlgebraicNumberDenominator",
  "AlgebraicNumberNorm",
  "AlgebraicNumberPolynomial",
  "AlgebraicNumberTrace",
  "AlgebraicRules",
  "AlgebraicRulesData",
  "Algebraics",
  "AlgebraicUnitQ",
  "Alignment",
  "AlignmentMarker",
  "AlignmentPoint",
  "All",
  "AllowAdultContent",
  "AllowChatServices",
  "AllowedCloudExtraParameters",
  "AllowedCloudParameterExtensions",
  "AllowedDimensions",
  "AllowedFrequencyRange",
  "AllowedHeads",
  "AllowGroupClose",
  "AllowIncomplete",
  "AllowInlineCells",
  "AllowKernelInitialization",
  "AllowLooseGrammar",
  "AllowReverseGroupClose",
  "AllowScriptLevelChange",
  "AllowVersionUpdate",
  "AllTrue",
  "Alphabet",
  "AlphabeticOrder",
  "AlphabeticSort",
  "AlphaChannel",
  "AlternateImage",
  "AlternatingFactorial",
  "AlternatingGroup",
  "AlternativeHypothesis",
  "Alternatives",
  "AltitudeMethod",
  "AmbientLight",
  "AmbiguityFunction",
  "AmbiguityList",
  "Analytic",
  "AnatomyData",
  "AnatomyForm",
  "AnatomyPlot3D",
  "AnatomySkinStyle",
  "AnatomyStyling",
  "AnchoredSearch",
  "And",
  "AndersonDarlingTest",
  "AngerJ",
  "AngleBisector",
  "AngleBracket",
  "AnglePath",
  "AnglePath3D",
  "AngleVector",
  "AngularGauge",
  "Animate",
  "AnimatedImage",
  "AnimationCycleOffset",
  "AnimationCycleRepetitions",
  "AnimationDirection",
  "AnimationDisplayTime",
  "AnimationRate",
  "AnimationRepetitions",
  "AnimationRunning",
  "AnimationRunTime",
  "AnimationTimeIndex",
  "AnimationVideo",
  "Animator",
  "AnimatorBox",
  "AnimatorBoxOptions",
  "AnimatorElements",
  "Annotate",
  "Annotation",
  "AnnotationDelete",
  "AnnotationKeys",
  "AnnotationRules",
  "AnnotationValue",
  "Annuity",
  "AnnuityDue",
  "Annulus",
  "AnomalyDetection",
  "AnomalyDetector",
  "AnomalyDetectorFunction",
  "Anonymous",
  "Antialiasing",
  "Antihermitian",
  "AntihermitianMatrixQ",
  "Antisymmetric",
  "AntisymmetricMatrixQ",
  "Antonyms",
  "AnyOrder",
  "AnySubset",
  "AnyTrue",
  "Apart",
  "ApartSquareFree",
  "APIFunction",
  "Appearance",
  "AppearanceElements",
  "AppearanceRules",
  "AppellF1",
  "Append",
  "AppendCheck",
  "AppendLayer",
  "AppendTo",
  "Application",
  "Apply",
  "ApplyReaction",
  "ApplySides",
  "ApplyTo",
  "ArcCos",
  "ArcCosh",
  "ArcCot",
  "ArcCoth",
  "ArcCsc",
  "ArcCsch",
  "ArcCurvature",
  "ARCHProcess",
  "ArcLength",
  "ArcSec",
  "ArcSech",
  "ArcSin",
  "ArcSinDistribution",
  "ArcSinh",
  "ArcTan",
  "ArcTanh",
  "Area",
  "Arg",
  "ArgMax",
  "ArgMin",
  "ArgumentCountQ",
  "ArgumentsOptions",
  "ARIMAProcess",
  "ArithmeticGeometricMean",
  "ARMAProcess",
  "Around",
  "AroundReplace",
  "ARProcess",
  "Array",
  "ArrayComponents",
  "ArrayDepth",
  "ArrayFilter",
  "ArrayFlatten",
  "ArrayMesh",
  "ArrayPad",
  "ArrayPlot",
  "ArrayPlot3D",
  "ArrayQ",
  "ArrayReduce",
  "ArrayResample",
  "ArrayReshape",
  "ArrayRules",
  "Arrays",
  "Arrow",
  "Arrow3DBox",
  "ArrowBox",
  "Arrowheads",
  "ASATriangle",
  "Ask",
  "AskAppend",
  "AskConfirm",
  "AskDisplay",
  "AskedQ",
  "AskedValue",
  "AskFunction",
  "AskState",
  "AskTemplateDisplay",
  "AspectRatio",
  "AspectRatioFixed",
  "Assert",
  "AssessmentFunction",
  "AssessmentResultObject",
  "AssociateTo",
  "Association",
  "AssociationFormat",
  "AssociationMap",
  "AssociationQ",
  "AssociationThread",
  "AssumeDeterministic",
  "Assuming",
  "Assumptions",
  "AstroAngularSeparation",
  "AstroBackground",
  "AstroCenter",
  "AstroDistance",
  "AstroGraphics",
  "AstroGridLines",
  "AstroGridLinesStyle",
  "AstronomicalData",
  "AstroPosition",
  "AstroProjection",
  "AstroRange",
  "AstroRangePadding",
  "AstroReferenceFrame",
  "AstroStyling",
  "AstroZoomLevel",
  "Asymptotic",
  "AsymptoticDSolveValue",
  "AsymptoticEqual",
  "AsymptoticEquivalent",
  "AsymptoticExpectation",
  "AsymptoticGreater",
  "AsymptoticGreaterEqual",
  "AsymptoticIntegrate",
  "AsymptoticLess",
  "AsymptoticLessEqual",
  "AsymptoticOutputTracker",
  "AsymptoticProbability",
  "AsymptoticProduct",
  "AsymptoticRSolveValue",
  "AsymptoticSolve",
  "AsymptoticSum",
  "Asynchronous",
  "AsynchronousTaskObject",
  "AsynchronousTasks",
  "Atom",
  "AtomCoordinates",
  "AtomCount",
  "AtomDiagramCoordinates",
  "AtomLabels",
  "AtomLabelStyle",
  "AtomList",
  "AtomQ",
  "AttachCell",
  "AttachedCell",
  "AttentionLayer",
  "Attributes",
  "Audio",
  "AudioAmplify",
  "AudioAnnotate",
  "AudioAnnotationLookup",
  "AudioBlockMap",
  "AudioCapture",
  "AudioChannelAssignment",
  "AudioChannelCombine",
  "AudioChannelMix",
  "AudioChannels",
  "AudioChannelSeparate",
  "AudioData",
  "AudioDelay",
  "AudioDelete",
  "AudioDevice",
  "AudioDistance",
  "AudioEncoding",
  "AudioFade",
  "AudioFrequencyShift",
  "AudioGenerator",
  "AudioIdentify",
  "AudioInputDevice",
  "AudioInsert",
  "AudioInstanceQ",
  "AudioIntervals",
  "AudioJoin",
  "AudioLabel",
  "AudioLength",
  "AudioLocalMeasurements",
  "AudioLooping",
  "AudioLoudness",
  "AudioMeasurements",
  "AudioNormalize",
  "AudioOutputDevice",
  "AudioOverlay",
  "AudioPad",
  "AudioPan",
  "AudioPartition",
  "AudioPause",
  "AudioPitchShift",
  "AudioPlay",
  "AudioPlot",
  "AudioQ",
  "AudioRecord",
  "AudioReplace",
  "AudioResample",
  "AudioReverb",
  "AudioReverse",
  "AudioSampleRate",
  "AudioSpectralMap",
  "AudioSpectralTransformation",
  "AudioSplit",
  "AudioStop",
  "AudioStream",
  "AudioStreams",
  "AudioTimeStretch",
  "AudioTrackApply",
  "AudioTrackSelection",
  "AudioTrim",
  "AudioType",
  "AugmentedPolyhedron",
  "AugmentedSymmetricPolynomial",
  "Authenticate",
  "Authentication",
  "AuthenticationDialog",
  "AutoAction",
  "Autocomplete",
  "AutocompletionFunction",
  "AutoCopy",
  "AutocorrelationTest",
  "AutoDelete",
  "AutoEvaluateEvents",
  "AutoGeneratedPackage",
  "AutoIndent",
  "AutoIndentSpacings",
  "AutoItalicWords",
  "AutoloadPath",
  "AutoMatch",
  "Automatic",
  "AutomaticImageSize",
  "AutoMultiplicationSymbol",
  "AutoNumberFormatting",
  "AutoOpenNotebooks",
  "AutoOpenPalettes",
  "AutoOperatorRenderings",
  "AutoQuoteCharacters",
  "AutoRefreshed",
  "AutoRemove",
  "AutorunSequencing",
  "AutoScaling",
  "AutoScroll",
  "AutoSpacing",
  "AutoStyleOptions",
  "AutoStyleWords",
  "AutoSubmitting",
  "Axes",
  "AxesEdge",
  "AxesLabel",
  "AxesOrigin",
  "AxesStyle",
  "AxiomaticTheory",
  "Axis",
  "Axis3DBox",
  "Axis3DBoxOptions",
  "AxisBox",
  "AxisBoxOptions",
  "AxisLabel",
  "AxisObject",
  "AxisStyle",
  "BabyMonsterGroupB",
  "Back",
  "BackFaceColor",
  "BackFaceGlowColor",
  "BackFaceOpacity",
  "BackFaceSpecularColor",
  "BackFaceSpecularExponent",
  "BackFaceSurfaceAppearance",
  "BackFaceTexture",
  "Background",
  "BackgroundAppearance",
  "BackgroundTasksSettings",
  "Backslash",
  "Backsubstitution",
  "Backward",
  "Ball",
  "Band",
  "BandpassFilter",
  "BandstopFilter",
  "BarabasiAlbertGraphDistribution",
  "BarChart",
  "BarChart3D",
  "BarcodeImage",
  "BarcodeRecognize",
  "BaringhausHenzeTest",
  "BarLegend",
  "BarlowProschanImportance",
  "BarnesG",
  "BarOrigin",
  "BarSpacing",
  "BartlettHannWindow",
  "BartlettWindow",
  "BaseDecode",
  "BaseEncode",
  "BaseForm",
  "Baseline",
  "BaselinePosition",
  "BaseStyle",
  "BasicRecurrentLayer",
  "BatchNormalizationLayer",
  "BatchSize",
  "BatesDistribution",
  "BattleLemarieWavelet",
  "BayesianMaximization",
  "BayesianMaximizationObject",
  "BayesianMinimization",
  "BayesianMinimizationObject",
  "Because",
  "BeckmannDistribution",
  "Beep",
  "Before",
  "Begin",
  "BeginDialogPacket",
  "BeginPackage",
  "BellB",
  "BellY",
  "Below",
  "BenfordDistribution",
  "BeniniDistribution",
  "BenktanderGibratDistribution",
  "BenktanderWeibullDistribution",
  "BernoulliB",
  "BernoulliDistribution",
  "BernoulliGraphDistribution",
  "BernoulliProcess",
  "BernsteinBasis",
  "BesagL",
  "BesselFilterModel",
  "BesselI",
  "BesselJ",
  "BesselJZero",
  "BesselK",
  "BesselY",
  "BesselYZero",
  "Beta",
  "BetaBinomialDistribution",
  "BetaDistribution",
  "BetaNegativeBinomialDistribution",
  "BetaPrimeDistribution",
  "BetaRegularized",
  "Between",
  "BetweennessCentrality",
  "Beveled",
  "BeveledPolyhedron",
  "BezierCurve",
  "BezierCurve3DBox",
  "BezierCurve3DBoxOptions",
  "BezierCurveBox",
  "BezierCurveBoxOptions",
  "BezierFunction",
  "BilateralFilter",
  "BilateralLaplaceTransform",
  "BilateralZTransform",
  "Binarize",
  "BinaryDeserialize",
  "BinaryDistance",
  "BinaryFormat",
  "BinaryImageQ",
  "BinaryRead",
  "BinaryReadList",
  "BinarySerialize",
  "BinaryWrite",
  "BinCounts",
  "BinLists",
  "BinnedVariogramList",
  "Binomial",
  "BinomialDistribution",
  "BinomialPointProcess",
  "BinomialProcess",
  "BinormalDistribution",
  "BiorthogonalSplineWavelet",
  "BioSequence",
  "BioSequenceBackTranslateList",
  "BioSequenceComplement",
  "BioSequenceInstances",
  "BioSequenceModify",
  "BioSequencePlot",
  "BioSequenceQ",
  "BioSequenceReverseComplement",
  "BioSequenceTranscribe",
  "BioSequenceTranslate",
  "BipartiteGraphQ",
  "BiquadraticFilterModel",
  "BirnbaumImportance",
  "BirnbaumSaundersDistribution",
  "BitAnd",
  "BitClear",
  "BitGet",
  "BitLength",
  "BitNot",
  "BitOr",
  "BitRate",
  "BitSet",
  "BitShiftLeft",
  "BitShiftRight",
  "BitXor",
  "BiweightLocation",
  "BiweightMidvariance",
  "Black",
  "BlackmanHarrisWindow",
  "BlackmanNuttallWindow",
  "BlackmanWindow",
  "Blank",
  "BlankForm",
  "BlankNullSequence",
  "BlankSequence",
  "Blend",
  "Block",
  "BlockchainAddressData",
  "BlockchainBase",
  "BlockchainBlockData",
  "BlockchainContractValue",
  "BlockchainData",
  "BlockchainGet",
  "BlockchainKeyEncode",
  "BlockchainPut",
  "BlockchainTokenData",
  "BlockchainTransaction",
  "BlockchainTransactionData",
  "BlockchainTransactionSign",
  "BlockchainTransactionSubmit",
  "BlockDiagonalMatrix",
  "BlockLowerTriangularMatrix",
  "BlockMap",
  "BlockRandom",
  "BlockUpperTriangularMatrix",
  "BlomqvistBeta",
  "BlomqvistBetaTest",
  "Blue",
  "Blur",
  "Blurring",
  "BodePlot",
  "BohmanWindow",
  "Bold",
  "Bond",
  "BondCount",
  "BondLabels",
  "BondLabelStyle",
  "BondList",
  "BondQ",
  "Bookmarks",
  "Boole",
  "BooleanConsecutiveFunction",
  "BooleanConvert",
  "BooleanCountingFunction",
  "BooleanFunction",
  "BooleanGraph",
  "BooleanMaxterms",
  "BooleanMinimize",
  "BooleanMinterms",
  "BooleanQ",
  "BooleanRegion",
  "Booleans",
  "BooleanStrings",
  "BooleanTable",
  "BooleanVariables",
  "BorderDimensions",
  "BorelTannerDistribution",
  "Bottom",
  "BottomHatTransform",
  "BoundaryDiscretizeGraphics",
  "BoundaryDiscretizeRegion",
  "BoundaryMesh",
  "BoundaryMeshRegion",
  "BoundaryMeshRegionQ",
  "BoundaryStyle",
  "BoundedRegionQ",
  "BoundingRegion",
  "Bounds",
  "Box",
  "BoxBaselineShift",
  "BoxData",
  "BoxDimensions",
  "Boxed",
  "Boxes",
  "BoxForm",
  "BoxFormFormatTypes",
  "BoxFrame",
  "BoxID",
  "BoxMargins",
  "BoxMatrix",
  "BoxObject",
  "BoxRatios",
  "BoxRotation",
  "BoxRotationPoint",
  "BoxStyle",
  "BoxWhiskerChart",
  "Bra",
  "BracketingBar",
  "BraKet",
  "BrayCurtisDistance",
  "BreadthFirstScan",
  "Break",
  "BridgeData",
  "BrightnessEqualize",
  "BroadcastStationData",
  "Brown",
  "BrownForsytheTest",
  "BrownianBridgeProcess",
  "BrowserCategory",
  "BSplineBasis",
  "BSplineCurve",
  "BSplineCurve3DBox",
  "BSplineCurve3DBoxOptions",
  "BSplineCurveBox",
  "BSplineCurveBoxOptions",
  "BSplineFunction",
  "BSplineSurface",
  "BSplineSurface3DBox",
  "BSplineSurface3DBoxOptions",
  "BubbleChart",
  "BubbleChart3D",
  "BubbleScale",
  "BubbleSizes",
  "BuckyballGraph",
  "BuildCompiledComponent",
  "BuildingData",
  "BulletGauge",
  "BusinessDayQ",
  "ButterflyGraph",
  "ButterworthFilterModel",
  "Button",
  "ButtonBar",
  "ButtonBox",
  "ButtonBoxOptions",
  "ButtonCell",
  "ButtonContents",
  "ButtonData",
  "ButtonEvaluator",
  "ButtonExpandable",
  "ButtonFrame",
  "ButtonFunction",
  "ButtonMargins",
  "ButtonMinHeight",
  "ButtonNote",
  "ButtonNotebook",
  "ButtonSource",
  "ButtonStyle",
  "ButtonStyleMenuListing",
  "Byte",
  "ByteArray",
  "ByteArrayFormat",
  "ByteArrayFormatQ",
  "ByteArrayQ",
  "ByteArrayToString",
  "ByteCount",
  "ByteOrdering",
  "C",
  "CachedValue",
  "CacheGraphics",
  "CachePersistence",
  "CalendarConvert",
  "CalendarData",
  "CalendarType",
  "Callout",
  "CalloutMarker",
  "CalloutStyle",
  "CallPacket",
  "CanberraDistance",
  "Cancel",
  "CancelButton",
  "CandlestickChart",
  "CanonicalGraph",
  "CanonicalizePolygon",
  "CanonicalizePolyhedron",
  "CanonicalizeRegion",
  "CanonicalName",
  "CanonicalWarpingCorrespondence",
  "CanonicalWarpingDistance",
  "CantorMesh",
  "CantorStaircase",
  "Canvas",
  "Cap",
  "CapForm",
  "CapitalDifferentialD",
  "Capitalize",
  "CapsuleShape",
  "CaptureRunning",
  "CaputoD",
  "CardinalBSplineBasis",
  "CarlemanLinearize",
  "CarlsonRC",
  "CarlsonRD",
  "CarlsonRE",
  "CarlsonRF",
  "CarlsonRG",
  "CarlsonRJ",
  "CarlsonRK",
  "CarlsonRM",
  "CarmichaelLambda",
  "CaseOrdering",
  "Cases",
  "CaseSensitive",
  "Cashflow",
  "Casoratian",
  "Cast",
  "Catalan",
  "CatalanNumber",
  "Catch",
  "CategoricalDistribution",
  "Catenate",
  "CatenateLayer",
  "CauchyDistribution",
  "CauchyMatrix",
  "CauchyPointProcess",
  "CauchyWindow",
  "CayleyGraph",
  "CDF",
  "CDFDeploy",
  "CDFInformation",
  "CDFWavelet",
  "Ceiling",
  "CelestialSystem",
  "Cell",
  "CellAutoOverwrite",
  "CellBaseline",
  "CellBoundingBox",
  "CellBracketOptions",
  "CellChangeTimes",
  "CellContents",
  "CellContext",
  "CellDingbat",
  "CellDingbatMargin",
  "CellDynamicExpression",
  "CellEditDuplicate",
  "CellElementsBoundingBox",
  "CellElementSpacings",
  "CellEpilog",
  "CellEvaluationDuplicate",
  "CellEvaluationFunction",
  "CellEvaluationLanguage",
  "CellEventActions",
  "CellFrame",
  "CellFrameColor",
  "CellFrameLabelMargins",
  "CellFrameLabels",
  "CellFrameMargins",
  "CellFrameStyle",
  "CellGroup",
  "CellGroupData",
  "CellGrouping",
  "CellGroupingRules",
  "CellHorizontalScrolling",
  "CellID",
  "CellInsertionPointCell",
  "CellLabel",
  "CellLabelAutoDelete",
  "CellLabelMargins",
  "CellLabelPositioning",
  "CellLabelStyle",
  "CellLabelTemplate",
  "CellMargins",
  "CellObject",
  "CellOpen",
  "CellPrint",
  "CellProlog",
  "Cells",
  "CellSize",
  "CellStyle",
  "CellTags",
  "CellTrayPosition",
  "CellTrayWidgets",
  "CellularAutomaton",
  "CensoredDistribution",
  "Censoring",
  "Center",
  "CenterArray",
  "CenterDot",
  "CenteredInterval",
  "CentralFeature",
  "CentralMoment",
  "CentralMomentGeneratingFunction",
  "Cepstrogram",
  "CepstrogramArray",
  "CepstrumArray",
  "CForm",
  "ChampernowneNumber",
  "ChangeOptions",
  "ChannelBase",
  "ChannelBrokerAction",
  "ChannelDatabin",
  "ChannelHistoryLength",
  "ChannelListen",
  "ChannelListener",
  "ChannelListeners",
  "ChannelListenerWait",
  "ChannelObject",
  "ChannelPreSendFunction",
  "ChannelReceiverFunction",
  "ChannelSend",
  "ChannelSubscribers",
  "ChanVeseBinarize",
  "Character",
  "CharacterCounts",
  "CharacterEncoding",
  "CharacterEncodingsPath",
  "CharacteristicFunction",
  "CharacteristicPolynomial",
  "CharacterName",
  "CharacterNormalize",
  "CharacterRange",
  "Characters",
  "ChartBaseStyle",
  "ChartElementData",
  "ChartElementDataFunction",
  "ChartElementFunction",
  "ChartElements",
  "ChartLabels",
  "ChartLayout",
  "ChartLegends",
  "ChartStyle",
  "Chebyshev1FilterModel",
  "Chebyshev2FilterModel",
  "ChebyshevDistance",
  "ChebyshevT",
  "ChebyshevU",
  "Check",
  "CheckAbort",
  "CheckAll",
  "CheckArguments",
  "Checkbox",
  "CheckboxBar",
  "CheckboxBox",
  "CheckboxBoxOptions",
  "ChemicalConvert",
  "ChemicalData",
  "ChemicalFormula",
  "ChemicalInstance",
  "ChemicalReaction",
  "ChessboardDistance",
  "ChiDistribution",
  "ChineseRemainder",
  "ChiSquareDistribution",
  "ChoiceButtons",
  "ChoiceDialog",
  "CholeskyDecomposition",
  "Chop",
  "ChromaticityPlot",
  "ChromaticityPlot3D",
  "ChromaticPolynomial",
  "Circle",
  "CircleBox",
  "CircleDot",
  "CircleMinus",
  "CirclePlus",
  "CirclePoints",
  "CircleThrough",
  "CircleTimes",
  "CirculantGraph",
  "CircularArcThrough",
  "CircularOrthogonalMatrixDistribution",
  "CircularQuaternionMatrixDistribution",
  "CircularRealMatrixDistribution",
  "CircularSymplecticMatrixDistribution",
  "CircularUnitaryMatrixDistribution",
  "Circumsphere",
  "CityData",
  "ClassifierFunction",
  "ClassifierInformation",
  "ClassifierMeasurements",
  "ClassifierMeasurementsObject",
  "Classify",
  "ClassPriors",
  "Clear",
  "ClearAll",
  "ClearAttributes",
  "ClearCookies",
  "ClearPermissions",
  "ClearSystemCache",
  "ClebschGordan",
  "ClickPane",
  "ClickToCopy",
  "ClickToCopyEnabled",
  "Clip",
  "ClipboardNotebook",
  "ClipFill",
  "ClippingStyle",
  "ClipPlanes",
  "ClipPlanesStyle",
  "ClipRange",
  "Clock",
  "ClockGauge",
  "ClockwiseContourIntegral",
  "Close",
  "Closed",
  "CloseKernels",
  "ClosenessCentrality",
  "Closing",
  "ClosingAutoSave",
  "ClosingEvent",
  "CloudAccountData",
  "CloudBase",
  "CloudConnect",
  "CloudConnections",
  "CloudDeploy",
  "CloudDirectory",
  "CloudDisconnect",
  "CloudEvaluate",
  "CloudExport",
  "CloudExpression",
  "CloudExpressions",
  "CloudFunction",
  "CloudGet",
  "CloudImport",
  "CloudLoggingData",
  "CloudObject",
  "CloudObjectInformation",
  "CloudObjectInformationData",
  "CloudObjectNameFormat",
  "CloudObjects",
  "CloudObjectURLType",
  "CloudPublish",
  "CloudPut",
  "CloudRenderingMethod",
  "CloudSave",
  "CloudShare",
  "CloudSubmit",
  "CloudSymbol",
  "CloudUnshare",
  "CloudUserID",
  "ClusterClassify",
  "ClusterDissimilarityFunction",
  "ClusteringComponents",
  "ClusteringMeasurements",
  "ClusteringTree",
  "CMYKColor",
  "Coarse",
  "CodeAssistOptions",
  "Coefficient",
  "CoefficientArrays",
  "CoefficientDomain",
  "CoefficientList",
  "CoefficientRules",
  "CoifletWavelet",
  "Collect",
  "CollinearPoints",
  "Colon",
  "ColonForm",
  "ColorBalance",
  "ColorCombine",
  "ColorConvert",
  "ColorCoverage",
  "ColorData",
  "ColorDataFunction",
  "ColorDetect",
  "ColorDistance",
  "ColorFunction",
  "ColorFunctionBinning",
  "ColorFunctionScaling",
  "Colorize",
  "ColorNegate",
  "ColorOutput",
  "ColorProfileData",
  "ColorQ",
  "ColorQuantize",
  "ColorReplace",
  "ColorRules",
  "ColorSelectorSettings",
  "ColorSeparate",
  "ColorSetter",
  "ColorSetterBox",
  "ColorSetterBoxOptions",
  "ColorSlider",
  "ColorsNear",
  "ColorSpace",
  "ColorToneMapping",
  "Column",
  "ColumnAlignments",
  "ColumnBackgrounds",
  "ColumnForm",
  "ColumnLines",
  "ColumnsEqual",
  "ColumnSpacings",
  "ColumnWidths",
  "CombinatorB",
  "CombinatorC",
  "CombinatorI",
  "CombinatorK",
  "CombinatorS",
  "CombinatorW",
  "CombinatorY",
  "CombinedEntityClass",
  "CombinerFunction",
  "CometData",
  "CommonDefaultFormatTypes",
  "Commonest",
  "CommonestFilter",
  "CommonName",
  "CommonUnits",
  "CommunityBoundaryStyle",
  "CommunityGraphPlot",
  "CommunityLabels",
  "CommunityRegionStyle",
  "CompanyData",
  "CompatibleUnitQ",
  "CompilationOptions",
  "CompilationTarget",
  "Compile",
  "Compiled",
  "CompiledCodeFunction",
  "CompiledComponent",
  "CompiledExpressionDeclaration",
  "CompiledFunction",
  "CompiledLayer",
  "CompilerCallback",
  "CompilerEnvironment",
  "CompilerEnvironmentAppend",
  "CompilerEnvironmentAppendTo",
  "CompilerEnvironmentObject",
  "CompilerOptions",
  "Complement",
  "ComplementedEntityClass",
  "CompleteGraph",
  "CompleteGraphQ",
  "CompleteIntegral",
  "CompleteKaryTree",
  "CompletionsListPacket",
  "Complex",
  "ComplexArrayPlot",
  "ComplexContourPlot",
  "Complexes",
  "ComplexExpand",
  "ComplexInfinity",
  "ComplexityFunction",
  "ComplexListPlot",
  "ComplexPlot",
  "ComplexPlot3D",
  "ComplexRegionPlot",
  "ComplexStreamPlot",
  "ComplexVectorPlot",
  "ComponentMeasurements",
  "ComponentwiseContextMenu",
  "Compose",
  "ComposeList",
  "ComposeSeries",
  "CompositeQ",
  "Composition",
  "CompoundElement",
  "CompoundExpression",
  "CompoundPoissonDistribution",
  "CompoundPoissonProcess",
  "CompoundRenewalProcess",
  "Compress",
  "CompressedData",
  "CompressionLevel",
  "ComputeUncertainty",
  "ConcaveHullMesh",
  "Condition",
  "ConditionalExpression",
  "Conditioned",
  "Cone",
  "ConeBox",
  "ConfidenceLevel",
  "ConfidenceRange",
  "ConfidenceTransform",
  "ConfigurationPath",
  "Confirm",
  "ConfirmAssert",
  "ConfirmBy",
  "ConfirmMatch",
  "ConfirmQuiet",
  "ConformationMethod",
  "ConformAudio",
  "ConformImages",
  "Congruent",
  "ConicGradientFilling",
  "ConicHullRegion",
  "ConicHullRegion3DBox",
  "ConicHullRegion3DBoxOptions",
  "ConicHullRegionBox",
  "ConicHullRegionBoxOptions",
  "ConicOptimization",
  "Conjugate",
  "ConjugateTranspose",
  "Conjunction",
  "Connect",
  "ConnectedComponents",
  "ConnectedGraphComponents",
  "ConnectedGraphQ",
  "ConnectedMeshComponents",
  "ConnectedMoleculeComponents",
  "ConnectedMoleculeQ",
  "ConnectionSettings",
  "ConnectLibraryCallbackFunction",
  "ConnectSystemModelComponents",
  "ConnectSystemModelController",
  "ConnesWindow",
  "ConoverTest",
  "ConservativeConvectionPDETerm",
  "ConsoleMessage",
  "Constant",
  "ConstantArray",
  "ConstantArrayLayer",
  "ConstantImage",
  "ConstantPlusLayer",
  "ConstantRegionQ",
  "Constants",
  "ConstantTimesLayer",
  "ConstellationData",
  "ConstrainedMax",
  "ConstrainedMin",
  "Construct",
  "Containing",
  "ContainsAll",
  "ContainsAny",
  "ContainsExactly",
  "ContainsNone",
  "ContainsOnly",
  "ContentDetectorFunction",
  "ContentFieldOptions",
  "ContentLocationFunction",
  "ContentObject",
  "ContentPadding",
  "ContentsBoundingBox",
  "ContentSelectable",
  "ContentSize",
  "Context",
  "ContextMenu",
  "Contexts",
  "ContextToFileName",
  "Continuation",
  "Continue",
  "ContinuedFraction",
  "ContinuedFractionK",
  "ContinuousAction",
  "ContinuousMarkovProcess",
  "ContinuousTask",
  "ContinuousTimeModelQ",
  "ContinuousWaveletData",
  "ContinuousWaveletTransform",
  "ContourDetect",
  "ContourGraphics",
  "ContourIntegral",
  "ContourLabels",
  "ContourLines",
  "ContourPlot",
  "ContourPlot3D",
  "Contours",
  "ContourShading",
  "ContourSmoothing",
  "ContourStyle",
  "ContraharmonicMean",
  "ContrastiveLossLayer",
  "Control",
  "ControlActive",
  "ControlAlignment",
  "ControlGroupContentsBox",
  "ControllabilityGramian",
  "ControllabilityMatrix",
  "ControllableDecomposition",
  "ControllableModelQ",
  "ControllerDuration",
  "ControllerInformation",
  "ControllerInformationData",
  "ControllerLinking",
  "ControllerManipulate",
  "ControllerMethod",
  "ControllerPath",
  "ControllerState",
  "ControlPlacement",
  "ControlsRendering",
  "ControlType",
  "ConvectionPDETerm",
  "Convergents",
  "ConversionOptions",
  "ConversionRules",
  "ConvertToPostScript",
  "ConvertToPostScriptPacket",
  "ConvexHullMesh",
  "ConvexHullRegion",
  "ConvexOptimization",
  "ConvexPolygonQ",
  "ConvexPolyhedronQ",
  "ConvexRegionQ",
  "ConvolutionLayer",
  "Convolve",
  "ConwayGroupCo1",
  "ConwayGroupCo2",
  "ConwayGroupCo3",
  "CookieFunction",
  "Cookies",
  "CoordinateBoundingBox",
  "CoordinateBoundingBoxArray",
  "CoordinateBounds",
  "CoordinateBoundsArray",
  "CoordinateChartData",
  "CoordinatesToolOptions",
  "CoordinateTransform",
  "CoordinateTransformData",
  "CoplanarPoints",
  "CoprimeQ",
  "Coproduct",
  "CopulaDistribution",
  "Copyable",
  "CopyDatabin",
  "CopyDirectory",
  "CopyFile",
  "CopyFunction",
  "CopyTag",
  "CopyToClipboard",
  "CoreNilpotentDecomposition",
  "CornerFilter",
  "CornerNeighbors",
  "Correlation",
  "CorrelationDistance",
  "CorrelationFunction",
  "CorrelationTest",
  "Cos",
  "Cosh",
  "CoshIntegral",
  "CosineDistance",
  "CosineWindow",
  "CosIntegral",
  "Cot",
  "Coth",
  "CoulombF",
  "CoulombG",
  "CoulombH1",
  "CoulombH2",
  "Count",
  "CountDistinct",
  "CountDistinctBy",
  "CounterAssignments",
  "CounterBox",
  "CounterBoxOptions",
  "CounterClockwiseContourIntegral",
  "CounterEvaluator",
  "CounterFunction",
  "CounterIncrements",
  "CounterStyle",
  "CounterStyleMenuListing",
  "CountRoots",
  "CountryData",
  "Counts",
  "CountsBy",
  "Covariance",
  "CovarianceEstimatorFunction",
  "CovarianceFunction",
  "CoxianDistribution",
  "CoxIngersollRossProcess",
  "CoxModel",
  "CoxModelFit",
  "CramerVonMisesTest",
  "CreateArchive",
  "CreateCellID",
  "CreateChannel",
  "CreateCloudExpression",
  "CreateCompilerEnvironment",
  "CreateDatabin",
  "CreateDataStructure",
  "CreateDataSystemModel",
  "CreateDialog",
  "CreateDirectory",
  "CreateDocument",
  "CreateFile",
  "CreateIntermediateDirectories",
  "CreateLicenseEntitlement",
  "CreateManagedLibraryExpression",
  "CreateNotebook",
  "CreatePacletArchive",
  "CreatePalette",
  "CreatePermissionsGroup",
  "CreateScheduledTask",
  "CreateSearchIndex",
  "CreateSystemModel",
  "CreateTemporary",
  "CreateTypeInstance",
  "CreateUUID",
  "CreateWindow",
  "CriterionFunction",
  "CriticalityFailureImportance",
  "CriticalitySuccessImportance",
  "CriticalSection",
  "Cross",
  "CrossEntropyLossLayer",
  "CrossingCount",
  "CrossingDetect",
  "CrossingPolygon",
  "CrossMatrix",
  "Csc",
  "Csch",
  "CSGRegion",
  "CSGRegionQ",
  "CSGRegionTree",
  "CTCLossLayer",
  "Cube",
  "CubeRoot",
  "Cubics",
  "Cuboid",
  "CuboidBox",
  "CuboidBoxOptions",
  "Cumulant",
  "CumulantGeneratingFunction",
  "CumulativeFeatureImpactPlot",
  "Cup",
  "CupCap",
  "Curl",
  "CurlyDoubleQuote",
  "CurlyQuote",
  "CurrencyConvert",
  "CurrentDate",
  "CurrentImage",
  "CurrentNotebookImage",
  "CurrentScreenImage",
  "CurrentValue",
  "Curry",
  "CurryApplied",
  "CurvatureFlowFilter",
  "CurveClosed",
  "Cyan",
  "CycleGraph",
  "CycleIndexPolynomial",
  "Cycles",
  "CyclicGroup",
  "Cyclotomic",
  "Cylinder",
  "CylinderBox",
  "CylinderBoxOptions",
  "CylindricalDecomposition",
  "CylindricalDecompositionFunction",
  "D",
  "DagumDistribution",
  "DamData",
  "DamerauLevenshteinDistance",
  "DampingFactor",
  "Darker",
  "Dashed",
  "Dashing",
  "DatabaseConnect",
  "DatabaseDisconnect",
  "DatabaseReference",
  "Databin",
  "DatabinAdd",
  "DatabinRemove",
  "Databins",
  "DatabinSubmit",
  "DatabinUpload",
  "DataCompression",
  "DataDistribution",
  "DataRange",
  "DataReversed",
  "Dataset",
  "DatasetDisplayPanel",
  "DatasetTheme",
  "DataStructure",
  "DataStructureQ",
  "Date",
  "DateBounds",
  "Dated",
  "DateDelimiters",
  "DateDifference",
  "DatedUnit",
  "DateFormat",
  "DateFunction",
  "DateGranularity",
  "DateHistogram",
  "DateInterval",
  "DateList",
  "DateListLogPlot",
  "DateListPlot",
  "DateListStepPlot",
  "DateObject",
  "DateObjectQ",
  "DateOverlapsQ",
  "DatePattern",
  "DatePlus",
  "DateRange",
  "DateReduction",
  "DateScale",
  "DateSelect",
  "DateString",
  "DateTicksFormat",
  "DateValue",
  "DateWithinQ",
  "DaubechiesWavelet",
  "DavisDistribution",
  "DawsonF",
  "DayCount",
  "DayCountConvention",
  "DayHemisphere",
  "DaylightQ",
  "DayMatchQ",
  "DayName",
  "DayNightTerminator",
  "DayPlus",
  "DayRange",
  "DayRound",
  "DeBruijnGraph",
  "DeBruijnSequence",
  "Debug",
  "DebugTag",
  "Decapitalize",
  "Decimal",
  "DecimalForm",
  "DeclareCompiledComponent",
  "DeclareKnownSymbols",
  "DeclarePackage",
  "Decompose",
  "DeconvolutionLayer",
  "Decrement",
  "Decrypt",
  "DecryptFile",
  "DedekindEta",
  "DeepSpaceProbeData",
  "Default",
  "Default2DTool",
  "Default3DTool",
  "DefaultAttachedCellStyle",
  "DefaultAxesStyle",
  "DefaultBaseStyle",
  "DefaultBoxStyle",
  "DefaultButton",
  "DefaultColor",
  "DefaultControlPlacement",
  "DefaultDockedCellStyle",
  "DefaultDuplicateCellStyle",
  "DefaultDuration",
  "DefaultElement",
  "DefaultFaceGridsStyle",
  "DefaultFieldHintStyle",
  "DefaultFont",
  "DefaultFontProperties",
  "DefaultFormatType",
  "DefaultFrameStyle",
  "DefaultFrameTicksStyle",
  "DefaultGridLinesStyle",
  "DefaultInlineFormatType",
  "DefaultInputFormatType",
  "DefaultLabelStyle",
  "DefaultMenuStyle",
  "DefaultNaturalLanguage",
  "DefaultNewCellStyle",
  "DefaultNewInlineCellStyle",
  "DefaultNotebook",
  "DefaultOptions",
  "DefaultOutputFormatType",
  "DefaultPrintPrecision",
  "DefaultStyle",
  "DefaultStyleDefinitions",
  "DefaultTextFormatType",
  "DefaultTextInlineFormatType",
  "DefaultTicksStyle",
  "DefaultTooltipStyle",
  "DefaultValue",
  "DefaultValues",
  "Defer",
  "DefineExternal",
  "DefineInputStreamMethod",
  "DefineOutputStreamMethod",
  "DefineResourceFunction",
  "Definition",
  "Degree",
  "DegreeCentrality",
  "DegreeGraphDistribution",
  "DegreeLexicographic",
  "DegreeReverseLexicographic",
  "DEigensystem",
  "DEigenvalues",
  "Deinitialization",
  "Del",
  "DelaunayMesh",
  "Delayed",
  "Deletable",
  "Delete",
  "DeleteAdjacentDuplicates",
  "DeleteAnomalies",
  "DeleteBorderComponents",
  "DeleteCases",
  "DeleteChannel",
  "DeleteCloudExpression",
  "DeleteContents",
  "DeleteDirectory",
  "DeleteDuplicates",
  "DeleteDuplicatesBy",
  "DeleteElements",
  "DeleteFile",
  "DeleteMissing",
  "DeleteObject",
  "DeletePermissionsKey",
  "DeleteSearchIndex",
  "DeleteSmallComponents",
  "DeleteStopwords",
  "DeleteWithContents",
  "DeletionWarning",
  "DelimitedArray",
  "DelimitedSequence",
  "Delimiter",
  "DelimiterAutoMatching",
  "DelimiterFlashTime",
  "DelimiterMatching",
  "Delimiters",
  "DeliveryFunction",
  "Dendrogram",
  "Denominator",
  "DensityGraphics",
  "DensityHistogram",
  "DensityPlot",
  "DensityPlot3D",
  "DependentVariables",
  "Deploy",
  "Deployed",
  "Depth",
  "DepthFirstScan",
  "Derivative",
  "DerivativeFilter",
  "DerivativePDETerm",
  "DerivedKey",
  "DescriptorStateSpace",
  "DesignMatrix",
  "DestroyAfterEvaluation",
  "Det",
  "DeviceClose",
  "DeviceConfigure",
  "DeviceExecute",
  "DeviceExecuteAsynchronous",
  "DeviceObject",
  "DeviceOpen",
  "DeviceOpenQ",
  "DeviceRead",
  "DeviceReadBuffer",
  "DeviceReadLatest",
  "DeviceReadList",
  "DeviceReadTimeSeries",
  "Devices",
  "DeviceStreams",
  "DeviceWrite",
  "DeviceWriteBuffer",
  "DGaussianWavelet",
  "DiacriticalPositioning",
  "Diagonal",
  "DiagonalizableMatrixQ",
  "DiagonalMatrix",
  "DiagonalMatrixQ",
  "Dialog",
  "DialogIndent",
  "DialogInput",
  "DialogLevel",
  "DialogNotebook",
  "DialogProlog",
  "DialogReturn",
  "DialogSymbols",
  "Diamond",
  "DiamondMatrix",
  "DiceDissimilarity",
  "DictionaryLookup",
  "DictionaryWordQ",
  "DifferenceDelta",
  "DifferenceOrder",
  "DifferenceQuotient",
  "DifferenceRoot",
  "DifferenceRootReduce",
  "Differences",
  "DifferentialD",
  "DifferentialRoot",
  "DifferentialRootReduce",
  "DifferentiatorFilter",
  "DiffusionPDETerm",
  "DiggleGatesPointProcess",
  "DiggleGrattonPointProcess",
  "DigitalSignature",
  "DigitBlock",
  "DigitBlockMinimum",
  "DigitCharacter",
  "DigitCount",
  "DigitQ",
  "DihedralAngle",
  "DihedralGroup",
  "Dilation",
  "DimensionalCombinations",
  "DimensionalMeshComponents",
  "DimensionReduce",
  "DimensionReducerFunction",
  "DimensionReduction",
  "Dimensions",
  "DiracComb",
  "DiracDelta",
  "DirectedEdge",
  "DirectedEdges",
  "DirectedGraph",
  "DirectedGraphQ",
  "DirectedInfinity",
  "Direction",
  "DirectionalLight",
  "Directive",
  "Directory",
  "DirectoryName",
  "DirectoryQ",
  "DirectoryStack",
  "DirichletBeta",
  "DirichletCharacter",
  "DirichletCondition",
  "DirichletConvolve",
  "DirichletDistribution",
  "DirichletEta",
  "DirichletL",
  "DirichletLambda",
  "DirichletTransform",
  "DirichletWindow",
  "DisableConsolePrintPacket",
  "DisableFormatting",
  "DiscreteAsymptotic",
  "DiscreteChirpZTransform",
  "DiscreteConvolve",
  "DiscreteDelta",
  "DiscreteHadamardTransform",
  "DiscreteIndicator",
  "DiscreteInputOutputModel",
  "DiscreteLimit",
  "DiscreteLQEstimatorGains",
  "DiscreteLQRegulatorGains",
  "DiscreteLyapunovSolve",
  "DiscreteMarkovProcess",
  "DiscreteMaxLimit",
  "DiscreteMinLimit",
  "DiscretePlot",
  "DiscretePlot3D",
  "DiscreteRatio",
  "DiscreteRiccatiSolve",
  "DiscreteShift",
  "DiscreteTimeModelQ",
  "DiscreteUniformDistribution",
  "DiscreteVariables",
  "DiscreteWaveletData",
  "DiscreteWaveletPacketTransform",
  "DiscreteWaveletTransform",
  "DiscretizeGraphics",
  "DiscretizeRegion",
  "Discriminant",
  "DisjointQ",
  "Disjunction",
  "Disk",
  "DiskBox",
  "DiskBoxOptions",
  "DiskMatrix",
  "DiskSegment",
  "Dispatch",
  "DispatchQ",
  "DispersionEstimatorFunction",
  "Display",
  "DisplayAllSteps",
  "DisplayEndPacket",
  "DisplayForm",
  "DisplayFunction",
  "DisplayPacket",
  "DisplayRules",
  "DisplayString",
  "DisplayTemporary",
  "DisplayWith",
  "DisplayWithRef",
  "DisplayWithVariable",
  "DistanceFunction",
  "DistanceMatrix",
  "DistanceTransform",
  "Distribute",
  "Distributed",
  "DistributedContexts",
  "DistributeDefinitions",
  "DistributionChart",
  "DistributionDomain",
  "DistributionFitTest",
  "DistributionParameterAssumptions",
  "DistributionParameterQ",
  "Dithering",
  "Div",
  "Divergence",
  "Divide",
  "DivideBy",
  "Dividers",
  "DivideSides",
  "Divisible",
  "Divisors",
  "DivisorSigma",
  "DivisorSum",
  "DMSList",
  "DMSString",
  "Do",
  "DockedCell",
  "DockedCells",
  "DocumentGenerator",
  "DocumentGeneratorInformation",
  "DocumentGeneratorInformationData",
  "DocumentGenerators",
  "DocumentNotebook",
  "DocumentWeightingRules",
  "Dodecahedron",
  "DomainRegistrationInformation",
  "DominantColors",
  "DominatorTreeGraph",
  "DominatorVertexList",
  "DOSTextFormat",
  "Dot",
  "DotDashed",
  "DotEqual",
  "DotLayer",
  "DotPlusLayer",
  "Dotted",
  "DoubleBracketingBar",
  "DoubleContourIntegral",
  "DoubleDownArrow",
  "DoubleLeftArrow",
  "DoubleLeftRightArrow",
  "DoubleLeftTee",
  "DoubleLongLeftArrow",
  "DoubleLongLeftRightArrow",
  "DoubleLongRightArrow",
  "DoubleRightArrow",
  "DoubleRightTee",
  "DoubleUpArrow",
  "DoubleUpDownArrow",
  "DoubleVerticalBar",
  "DoublyInfinite",
  "Down",
  "DownArrow",
  "DownArrowBar",
  "DownArrowUpArrow",
  "DownLeftRightVector",
  "DownLeftTeeVector",
  "DownLeftVector",
  "DownLeftVectorBar",
  "DownRightTeeVector",
  "DownRightVector",
  "DownRightVectorBar",
  "Downsample",
  "DownTee",
  "DownTeeArrow",
  "DownValues",
  "DownValuesFunction",
  "DragAndDrop",
  "DrawBackFaces",
  "DrawEdges",
  "DrawFrontFaces",
  "DrawHighlighted",
  "DrazinInverse",
  "Drop",
  "DropoutLayer",
  "DropShadowing",
  "DSolve",
  "DSolveChangeVariables",
  "DSolveValue",
  "Dt",
  "DualLinearProgramming",
  "DualPlanarGraph",
  "DualPolyhedron",
  "DualSystemsModel",
  "DumpGet",
  "DumpSave",
  "DuplicateFreeQ",
  "Duration",
  "Dynamic",
  "DynamicBox",
  "DynamicBoxOptions",
  "DynamicEvaluationTimeout",
  "DynamicGeoGraphics",
  "DynamicImage",
  "DynamicLocation",
  "DynamicModule",
  "DynamicModuleBox",
  "DynamicModuleBoxOptions",
  "DynamicModuleParent",
  "DynamicModuleValues",
  "DynamicName",
  "DynamicNamespace",
  "DynamicReference",
  "DynamicSetting",
  "DynamicUpdating",
  "DynamicWrapper",
  "DynamicWrapperBox",
  "DynamicWrapperBoxOptions",
  "E",
  "EarthImpactData",
  "EarthquakeData",
  "EccentricityCentrality",
  "Echo",
  "EchoEvaluation",
  "EchoFunction",
  "EchoLabel",
  "EchoTiming",
  "EclipseType",
  "EdgeAdd",
  "EdgeBetweennessCentrality",
  "EdgeCapacity",
  "EdgeCapForm",
  "EdgeChromaticNumber",
  "EdgeColor",
  "EdgeConnectivity",
  "EdgeContract",
  "EdgeCost",
  "EdgeCount",
  "EdgeCoverQ",
  "EdgeCycleMatrix",
  "EdgeDashing",
  "EdgeDelete",
  "EdgeDetect",
  "EdgeForm",
  "EdgeIndex",
  "EdgeJoinForm",
  "EdgeLabeling",
  "EdgeLabels",
  "EdgeLabelStyle",
  "EdgeList",
  "EdgeOpacity",
  "EdgeQ",
  "EdgeRenderingFunction",
  "EdgeRules",
  "EdgeShapeFunction",
  "EdgeStyle",
  "EdgeTaggedGraph",
  "EdgeTaggedGraphQ",
  "EdgeTags",
  "EdgeThickness",
  "EdgeTransitiveGraphQ",
  "EdgeValueRange",
  "EdgeValueSizes",
  "EdgeWeight",
  "EdgeWeightedGraphQ",
  "Editable",
  "EditButtonSettings",
  "EditCellTagsSettings",
  "EditDistance",
  "EffectiveInterest",
  "Eigensystem",
  "Eigenvalues",
  "EigenvectorCentrality",
  "Eigenvectors",
  "Element",
  "ElementData",
  "ElementwiseLayer",
  "ElidedForms",
  "Eliminate",
  "EliminationOrder",
  "Ellipsoid",
  "EllipticE",
  "EllipticExp",
  "EllipticExpPrime",
  "EllipticF",
  "EllipticFilterModel",
  "EllipticK",
  "EllipticLog",
  "EllipticNomeQ",
  "EllipticPi",
  "EllipticReducedHalfPeriods",
  "EllipticTheta",
  "EllipticThetaPrime",
  "EmbedCode",
  "EmbeddedHTML",
  "EmbeddedService",
  "EmbeddedSQLEntityClass",
  "EmbeddedSQLExpression",
  "EmbeddingLayer",
  "EmbeddingObject",
  "EmitSound",
  "EmphasizeSyntaxErrors",
  "EmpiricalDistribution",
  "Empty",
  "EmptyGraphQ",
  "EmptyRegion",
  "EmptySpaceF",
  "EnableConsolePrintPacket",
  "Enabled",
  "Enclose",
  "Encode",
  "Encrypt",
  "EncryptedObject",
  "EncryptFile",
  "End",
  "EndAdd",
  "EndDialogPacket",
  "EndOfBuffer",
  "EndOfFile",
  "EndOfLine",
  "EndOfString",
  "EndPackage",
  "EngineEnvironment",
  "EngineeringForm",
  "Enter",
  "EnterExpressionPacket",
  "EnterTextPacket",
  "Entity",
  "EntityClass",
  "EntityClassList",
  "EntityCopies",
  "EntityFunction",
  "EntityGroup",
  "EntityInstance",
  "EntityList",
  "EntityPrefetch",
  "EntityProperties",
  "EntityProperty",
  "EntityPropertyClass",
  "EntityRegister",
  "EntityStore",
  "EntityStores",
  "EntityTypeName",
  "EntityUnregister",
  "EntityValue",
  "Entropy",
  "EntropyFilter",
  "Environment",
  "Epilog",
  "EpilogFunction",
  "Equal",
  "EqualColumns",
  "EqualRows",
  "EqualTilde",
  "EqualTo",
  "EquatedTo",
  "Equilibrium",
  "EquirippleFilterKernel",
  "Equivalent",
  "Erf",
  "Erfc",
  "Erfi",
  "ErlangB",
  "ErlangC",
  "ErlangDistribution",
  "Erosion",
  "ErrorBox",
  "ErrorBoxOptions",
  "ErrorNorm",
  "ErrorPacket",
  "ErrorsDialogSettings",
  "EscapeRadius",
  "EstimatedBackground",
  "EstimatedDistribution",
  "EstimatedPointNormals",
  "EstimatedPointProcess",
  "EstimatedProcess",
  "EstimatedVariogramModel",
  "EstimatorGains",
  "EstimatorRegulator",
  "EuclideanDistance",
  "EulerAngles",
  "EulerCharacteristic",
  "EulerE",
  "EulerGamma",
  "EulerianGraphQ",
  "EulerMatrix",
  "EulerPhi",
  "Evaluatable",
  "Evaluate",
  "Evaluated",
  "EvaluatePacket",
  "EvaluateScheduledTask",
  "EvaluationBox",
  "EvaluationCell",
  "EvaluationCompletionAction",
  "EvaluationData",
  "EvaluationElements",
  "EvaluationEnvironment",
  "EvaluationMode",
  "EvaluationMonitor",
  "EvaluationNotebook",
  "EvaluationObject",
  "EvaluationOrder",
  "EvaluationPrivileges",
  "EvaluationRateLimit",
  "Evaluator",
  "EvaluatorNames",
  "EvenQ",
  "EventData",
  "EventEvaluator",
  "EventHandler",
  "EventHandlerTag",
  "EventLabels",
  "EventSeries",
  "ExactBlackmanWindow",
  "ExactNumberQ",
  "ExactRootIsolation",
  "ExampleData",
  "Except",
  "ExcludedContexts",
  "ExcludedForms",
  "ExcludedLines",
  "ExcludedPhysicalQuantities",
  "ExcludePods",
  "Exclusions",
  "ExclusionsStyle",
  "Exists",
  "Exit",
  "ExitDialog",
  "ExoplanetData",
  "Exp",
  "Expand",
  "ExpandAll",
  "ExpandDenominator",
  "ExpandFileName",
  "ExpandNumerator",
  "Expectation",
  "ExpectationE",
  "ExpectedValue",
  "ExpGammaDistribution",
  "ExpIntegralE",
  "ExpIntegralEi",
  "ExpirationDate",
  "Exponent",
  "ExponentFunction",
  "ExponentialDistribution",
  "ExponentialFamily",
  "ExponentialGeneratingFunction",
  "ExponentialMovingAverage",
  "ExponentialPowerDistribution",
  "ExponentPosition",
  "ExponentStep",
  "Export",
  "ExportAutoReplacements",
  "ExportByteArray",
  "ExportForm",
  "ExportPacket",
  "ExportString",
  "Expression",
  "ExpressionCell",
  "ExpressionGraph",
  "ExpressionPacket",
  "ExpressionTree",
  "ExpressionUUID",
  "ExpToTrig",
  "ExtendedEntityClass",
  "ExtendedGCD",
  "Extension",
  "ExtentElementFunction",
  "ExtentMarkers",
  "ExtentSize",
  "ExternalBundle",
  "ExternalCall",
  "ExternalDataCharacterEncoding",
  "ExternalEvaluate",
  "ExternalFunction",
  "ExternalFunctionName",
  "ExternalIdentifier",
  "ExternalObject",
  "ExternalOptions",
  "ExternalSessionObject",
  "ExternalSessions",
  "ExternalStorageBase",
  "ExternalStorageDownload",
  "ExternalStorageGet",
  "ExternalStorageObject",
  "ExternalStoragePut",
  "ExternalStorageUpload",
  "ExternalTypeSignature",
  "ExternalValue",
  "Extract",
  "ExtractArchive",
  "ExtractLayer",
  "ExtractPacletArchive",
  "ExtremeValueDistribution",
  "FaceAlign",
  "FaceForm",
  "FaceGrids",
  "FaceGridsStyle",
  "FaceRecognize",
  "FacialFeatures",
  "Factor",
  "FactorComplete",
  "Factorial",
  "Factorial2",
  "FactorialMoment",
  "FactorialMomentGeneratingFunction",
  "FactorialPower",
  "FactorInteger",
  "FactorList",
  "FactorSquareFree",
  "FactorSquareFreeList",
  "FactorTerms",
  "FactorTermsList",
  "Fail",
  "Failure",
  "FailureAction",
  "FailureDistribution",
  "FailureQ",
  "False",
  "FareySequence",
  "FARIMAProcess",
  "FeatureDistance",
  "FeatureExtract",
  "FeatureExtraction",
  "FeatureExtractor",
  "FeatureExtractorFunction",
  "FeatureImpactPlot",
  "FeatureNames",
  "FeatureNearest",
  "FeatureSpacePlot",
  "FeatureSpacePlot3D",
  "FeatureTypes",
  "FeatureValueDependencyPlot",
  "FeatureValueImpactPlot",
  "FEDisableConsolePrintPacket",
  "FeedbackLinearize",
  "FeedbackSector",
  "FeedbackSectorStyle",
  "FeedbackType",
  "FEEnableConsolePrintPacket",
  "FetalGrowthData",
  "Fibonacci",
  "Fibonorial",
  "FieldCompletionFunction",
  "FieldHint",
  "FieldHintStyle",
  "FieldMasked",
  "FieldSize",
  "File",
  "FileBaseName",
  "FileByteCount",
  "FileConvert",
  "FileDate",
  "FileExistsQ",
  "FileExtension",
  "FileFormat",
  "FileFormatProperties",
  "FileFormatQ",
  "FileHandler",
  "FileHash",
  "FileInformation",
  "FileName",
  "FileNameDepth",
  "FileNameDialogSettings",
  "FileNameDrop",
  "FileNameForms",
  "FileNameJoin",
  "FileNames",
  "FileNameSetter",
  "FileNameSplit",
  "FileNameTake",
  "FileNameToFormatList",
  "FilePrint",
  "FileSize",
  "FileSystemMap",
  "FileSystemScan",
  "FileSystemTree",
  "FileTemplate",
  "FileTemplateApply",
  "FileType",
  "FilledCurve",
  "FilledCurveBox",
  "FilledCurveBoxOptions",
  "FilledTorus",
  "FillForm",
  "Filling",
  "FillingStyle",
  "FillingTransform",
  "FilteredEntityClass",
  "FilterRules",
  "FinancialBond",
  "FinancialData",
  "FinancialDerivative",
  "FinancialIndicator",
  "Find",
  "FindAnomalies",
  "FindArgMax",
  "FindArgMin",
  "FindChannels",
  "FindClique",
  "FindClusters",
  "FindCookies",
  "FindCurvePath",
  "FindCycle",
  "FindDevices",
  "FindDistribution",
  "FindDistributionParameters",
  "FindDivisions",
  "FindEdgeColoring",
  "FindEdgeCover",
  "FindEdgeCut",
  "FindEdgeIndependentPaths",
  "FindEquationalProof",
  "FindEulerianCycle",
  "FindExternalEvaluators",
  "FindFaces",
  "FindFile",
  "FindFit",
  "FindFormula",
  "FindFundamentalCycles",
  "FindGeneratingFunction",
  "FindGeoLocation",
  "FindGeometricConjectures",
  "FindGeometricTransform",
  "FindGraphCommunities",
  "FindGraphIsomorphism",
  "FindGraphPartition",
  "FindHamiltonianCycle",
  "FindHamiltonianPath",
  "FindHiddenMarkovStates",
  "FindImageText",
  "FindIndependentEdgeSet",
  "FindIndependentVertexSet",
  "FindInstance",
  "FindIntegerNullVector",
  "FindIsomers",
  "FindIsomorphicSubgraph",
  "FindKClan",
  "FindKClique",
  "FindKClub",
  "FindKPlex",
  "FindLibrary",
  "FindLinearRecurrence",
  "FindList",
  "FindMatchingColor",
  "FindMaximum",
  "FindMaximumCut",
  "FindMaximumFlow",
  "FindMaxValue",
  "FindMeshDefects",
  "FindMinimum",
  "FindMinimumCostFlow",
  "FindMinimumCut",
  "FindMinValue",
  "FindMoleculeSubstructure",
  "FindPath",
  "FindPeaks",
  "FindPermutation",
  "FindPlanarColoring",
  "FindPointProcessParameters",
  "FindPostmanTour",
  "FindProcessParameters",
  "FindRegionTransform",
  "FindRepeat",
  "FindRoot",
  "FindSequenceFunction",
  "FindSettings",
  "FindShortestPath",
  "FindShortestTour",
  "FindSpanningTree",
  "FindSubgraphIsomorphism",
  "FindSystemModelEquilibrium",
  "FindTextualAnswer",
  "FindThreshold",
  "FindTransientRepeat",
  "FindVertexColoring",
  "FindVertexCover",
  "FindVertexCut",
  "FindVertexIndependentPaths",
  "Fine",
  "FinishDynamic",
  "FiniteAbelianGroupCount",
  "FiniteGroupCount",
  "FiniteGroupData",
  "First",
  "FirstCase",
  "FirstPassageTimeDistribution",
  "FirstPosition",
  "FischerGroupFi22",
  "FischerGroupFi23",
  "FischerGroupFi24Prime",
  "FisherHypergeometricDistribution",
  "FisherRatioTest",
  "FisherZDistribution",
  "Fit",
  "FitAll",
  "FitRegularization",
  "FittedModel",
  "FixedOrder",
  "FixedPoint",
  "FixedPointList",
  "FlashSelection",
  "Flat",
  "FlatShading",
  "Flatten",
  "FlattenAt",
  "FlattenLayer",
  "FlatTopWindow",
  "FlightData",
  "FlipView",
  "Floor",
  "FlowPolynomial",
  "Fold",
  "FoldList",
  "FoldPair",
  "FoldPairList",
  "FoldWhile",
  "FoldWhileList",
  "FollowRedirects",
  "Font",
  "FontColor",
  "FontFamily",
  "FontForm",
  "FontName",
  "FontOpacity",
  "FontPostScriptName",
  "FontProperties",
  "FontReencoding",
  "FontSize",
  "FontSlant",
  "FontSubstitutions",
  "FontTracking",
  "FontVariations",
  "FontWeight",
  "For",
  "ForAll",
  "ForAllType",
  "ForceVersionInstall",
  "Format",
  "FormatRules",
  "FormatType",
  "FormatTypeAutoConvert",
  "FormatValues",
  "FormBox",
  "FormBoxOptions",
  "FormControl",
  "FormFunction",
  "FormLayoutFunction",
  "FormObject",
  "FormPage",
  "FormProtectionMethod",
  "FormTheme",
  "FormulaData",
  "FormulaLookup",
  "FortranForm",
  "Forward",
  "ForwardBackward",
  "ForwardCloudCredentials",
  "Fourier",
  "FourierCoefficient",
  "FourierCosCoefficient",
  "FourierCosSeries",
  "FourierCosTransform",
  "FourierDCT",
  "FourierDCTFilter",
  "FourierDCTMatrix",
  "FourierDST",
  "FourierDSTMatrix",
  "FourierMatrix",
  "FourierParameters",
  "FourierSequenceTransform",
  "FourierSeries",
  "FourierSinCoefficient",
  "FourierSinSeries",
  "FourierSinTransform",
  "FourierTransform",
  "FourierTrigSeries",
  "FoxH",
  "FoxHReduce",
  "FractionalBrownianMotionProcess",
  "FractionalD",
  "FractionalGaussianNoiseProcess",
  "FractionalPart",
  "FractionBox",
  "FractionBoxOptions",
  "FractionLine",
  "Frame",
  "FrameBox",
  "FrameBoxOptions",
  "Framed",
  "FrameInset",
  "FrameLabel",
  "Frameless",
  "FrameListVideo",
  "FrameMargins",
  "FrameRate",
  "FrameStyle",
  "FrameTicks",
  "FrameTicksStyle",
  "FRatioDistribution",
  "FrechetDistribution",
  "FreeQ",
  "FrenetSerretSystem",
  "FrequencySamplingFilterKernel",
  "FresnelC",
  "FresnelF",
  "FresnelG",
  "FresnelS",
  "Friday",
  "FrobeniusNumber",
  "FrobeniusSolve",
  "FromAbsoluteTime",
  "FromCharacterCode",
  "FromCoefficientRules",
  "FromContinuedFraction",
  "FromDate",
  "FromDateString",
  "FromDigits",
  "FromDMS",
  "FromEntity",
  "FromJulianDate",
  "FromLetterNumber",
  "FromPolarCoordinates",
  "FromRawPointer",
  "FromRomanNumeral",
  "FromSphericalCoordinates",
  "FromUnixTime",
  "Front",
  "FrontEndDynamicExpression",
  "FrontEndEventActions",
  "FrontEndExecute",
  "FrontEndObject",
  "FrontEndResource",
  "FrontEndResourceString",
  "FrontEndStackSize",
  "FrontEndToken",
  "FrontEndTokenExecute",
  "FrontEndValueCache",
  "FrontEndVersion",
  "FrontFaceColor",
  "FrontFaceGlowColor",
  "FrontFaceOpacity",
  "FrontFaceSpecularColor",
  "FrontFaceSpecularExponent",
  "FrontFaceSurfaceAppearance",
  "FrontFaceTexture",
  "Full",
  "FullAxes",
  "FullDefinition",
  "FullForm",
  "FullGraphics",
  "FullInformationOutputRegulator",
  "FullOptions",
  "FullRegion",
  "FullSimplify",
  "Function",
  "FunctionAnalytic",
  "FunctionBijective",
  "FunctionCompile",
  "FunctionCompileExport",
  "FunctionCompileExportByteArray",
  "FunctionCompileExportLibrary",
  "FunctionCompileExportString",
  "FunctionContinuous",
  "FunctionConvexity",
  "FunctionDeclaration",
  "FunctionDiscontinuities",
  "FunctionDomain",
  "FunctionExpand",
  "FunctionInjective",
  "FunctionInterpolation",
  "FunctionLayer",
  "FunctionMeromorphic",
  "FunctionMonotonicity",
  "FunctionPeriod",
  "FunctionPoles",
  "FunctionRange",
  "FunctionSign",
  "FunctionSingularities",
  "FunctionSpace",
  "FunctionSurjective",
  "FussellVeselyImportance",
  "GaborFilter",
  "GaborMatrix",
  "GaborWavelet",
  "GainMargins",
  "GainPhaseMargins",
  "GalaxyData",
  "GalleryView",
  "Gamma",
  "GammaDistribution",
  "GammaRegularized",
  "GapPenalty",
  "GARCHProcess",
  "GatedRecurrentLayer",
  "Gather",
  "GatherBy",
  "GaugeFaceElementFunction",
  "GaugeFaceStyle",
  "GaugeFrameElementFunction",
  "GaugeFrameSize",
  "GaugeFrameStyle",
  "GaugeLabels",
  "GaugeMarkers",
  "GaugeStyle",
  "GaussianFilter",
  "GaussianIntegers",
  "GaussianMatrix",
  "GaussianOrthogonalMatrixDistribution",
  "GaussianSymplecticMatrixDistribution",
  "GaussianUnitaryMatrixDistribution",
  "GaussianWindow",
  "GCD",
  "GegenbauerC",
  "General",
  "GeneralizedLinearModelFit",
  "GenerateAsymmetricKeyPair",
  "GenerateConditions",
  "GeneratedAssetFormat",
  "GeneratedAssetLocation",
  "GeneratedCell",
  "GeneratedCellStyles",
  "GeneratedDocumentBinding",
  "GenerateDerivedKey",
  "GenerateDigitalSignature",
  "GenerateDocument",
  "GeneratedParameters",
  "GeneratedQuantityMagnitudes",
  "GenerateFileSignature",
  "GenerateHTTPResponse",
  "GenerateSecuredAuthenticationKey",
  "GenerateSymmetricKey",
  "GeneratingFunction",
  "GeneratorDescription",
  "GeneratorHistoryLength",
  "GeneratorOutputType",
  "Generic",
  "GenericCylindricalDecomposition",
  "GenomeData",
  "GenomeLookup",
  "GeoAntipode",
  "GeoArea",
  "GeoArraySize",
  "GeoBackground",
  "GeoBoundary",
  "GeoBoundingBox",
  "GeoBounds",
  "GeoBoundsRegion",
  "GeoBoundsRegionBoundary",
  "GeoBubbleChart",
  "GeoCenter",
  "GeoCircle",
  "GeoContourPlot",
  "GeoDensityPlot",
  "GeodesicClosing",
  "GeodesicDilation",
  "GeodesicErosion",
  "GeodesicOpening",
  "GeodesicPolyhedron",
  "GeoDestination",
  "GeodesyData",
  "GeoDirection",
  "GeoDisk",
  "GeoDisplacement",
  "GeoDistance",
  "GeoDistanceList",
  "GeoElevationData",
  "GeoEntities",
  "GeoGraphics",
  "GeoGraphPlot",
  "GeoGraphValuePlot",
  "GeogravityModelData",
  "GeoGridDirectionDifference",
  "GeoGridLines",
  "GeoGridLinesStyle",
  "GeoGridPosition",
  "GeoGridRange",
  "GeoGridRangePadding",
  "GeoGridUnitArea",
  "GeoGridUnitDistance",
  "GeoGridVector",
  "GeoGroup",
  "GeoHemisphere",
  "GeoHemisphereBoundary",
  "GeoHistogram",
  "GeoIdentify",
  "GeoImage",
  "GeoLabels",
  "GeoLength",
  "GeoListPlot",
  "GeoLocation",
  "GeologicalPeriodData",
  "GeomagneticModelData",
  "GeoMarker",
  "GeometricAssertion",
  "GeometricBrownianMotionProcess",
  "GeometricDistribution",
  "GeometricMean",
  "GeometricMeanFilter",
  "GeometricOptimization",
  "GeometricScene",
  "GeometricStep",
  "GeometricStylingRules",
  "GeometricTest",
  "GeometricTransformation",
  "GeometricTransformation3DBox",
  "GeometricTransformation3DBoxOptions",
  "GeometricTransformationBox",
  "GeometricTransformationBoxOptions",
  "GeoModel",
  "GeoNearest",
  "GeoOrientationData",
  "GeoPath",
  "GeoPolygon",
  "GeoPosition",
  "GeoPositionENU",
  "GeoPositionXYZ",
  "GeoProjection",
  "GeoProjectionData",
  "GeoRange",
  "GeoRangePadding",
  "GeoRegionValuePlot",
  "GeoResolution",
  "GeoScaleBar",
  "GeoServer",
  "GeoSmoothHistogram",
  "GeoStreamPlot",
  "GeoStyling",
  "GeoStylingImageFunction",
  "GeoVariant",
  "GeoVector",
  "GeoVectorENU",
  "GeoVectorPlot",
  "GeoVectorXYZ",
  "GeoVisibleRegion",
  "GeoVisibleRegionBoundary",
  "GeoWithinQ",
  "GeoZoomLevel",
  "GestureHandler",
  "GestureHandlerTag",
  "Get",
  "GetContext",
  "GetEnvironment",
  "GetFileName",
  "GetLinebreakInformationPacket",
  "GibbsPointProcess",
  "Glaisher",
  "GlobalClusteringCoefficient",
  "GlobalPreferences",
  "GlobalSession",
  "Glow",
  "GoldenAngle",
  "GoldenRatio",
  "GompertzMakehamDistribution",
  "GoochShading",
  "GoodmanKruskalGamma",
  "GoodmanKruskalGammaTest",
  "Goto",
  "GouraudShading",
  "Grad",
  "Gradient",
  "GradientFilter",
  "GradientFittedMesh",
  "GradientOrientationFilter",
  "GrammarApply",
  "GrammarRules",
  "GrammarToken",
  "Graph",
  "Graph3D",
  "GraphAssortativity",
  "GraphAutomorphismGroup",
  "GraphCenter",
  "GraphComplement",
  "GraphData",
  "GraphDensity",
  "GraphDiameter",
  "GraphDifference",
  "GraphDisjointUnion",
  "GraphDistance",
  "GraphDistanceMatrix",
  "GraphEmbedding",
  "GraphHighlight",
  "GraphHighlightStyle",
  "GraphHub",
  "Graphics",
  "Graphics3D",
  "Graphics3DBox",
  "Graphics3DBoxOptions",
  "GraphicsArray",
  "GraphicsBaseline",
  "GraphicsBox",
  "GraphicsBoxOptions",
  "GraphicsColor",
  "GraphicsColumn",
  "GraphicsComplex",
  "GraphicsComplex3DBox",
  "GraphicsComplex3DBoxOptions",
  "GraphicsComplexBox",
  "GraphicsComplexBoxOptions",
  "GraphicsContents",
  "GraphicsData",
  "GraphicsGrid",
  "GraphicsGridBox",
  "GraphicsGroup",
  "GraphicsGroup3DBox",
  "GraphicsGroup3DBoxOptions",
  "GraphicsGroupBox",
  "GraphicsGroupBoxOptions",
  "GraphicsGrouping",
  "GraphicsHighlightColor",
  "GraphicsRow",
  "GraphicsSpacing",
  "GraphicsStyle",
  "GraphIntersection",
  "GraphJoin",
  "GraphLayerLabels",
  "GraphLayers",
  "GraphLayerStyle",
  "GraphLayout",
  "GraphLinkEfficiency",
  "GraphPeriphery",
  "GraphPlot",
  "GraphPlot3D",
  "GraphPower",
  "GraphProduct",
  "GraphPropertyDistribution",
  "GraphQ",
  "GraphRadius",
  "GraphReciprocity",
  "GraphRoot",
  "GraphStyle",
  "GraphSum",
  "GraphTree",
  "GraphUnion",
  "Gray",
  "GrayLevel",
  "Greater",
  "GreaterEqual",
  "GreaterEqualLess",
  "GreaterEqualThan",
  "GreaterFullEqual",
  "GreaterGreater",
  "GreaterLess",
  "GreaterSlantEqual",
  "GreaterThan",
  "GreaterTilde",
  "GreekStyle",
  "Green",
  "GreenFunction",
  "Grid",
  "GridBaseline",
  "GridBox",
  "GridBoxAlignment",
  "GridBoxBackground",
  "GridBoxDividers",
  "GridBoxFrame",
  "GridBoxItemSize",
  "GridBoxItemStyle",
  "GridBoxOptions",
  "GridBoxSpacings",
  "GridCreationSettings",
  "GridDefaultElement",
  "GridElementStyleOptions",
  "GridFrame",
  "GridFrameMargins",
  "GridGraph",
  "GridLines",
  "GridLinesStyle",
  "GridVideo",
  "GroebnerBasis",
  "GroupActionBase",
  "GroupBy",
  "GroupCentralizer",
  "GroupElementFromWord",
  "GroupElementPosition",
  "GroupElementQ",
  "GroupElements",
  "GroupElementToWord",
  "GroupGenerators",
  "Groupings",
  "GroupMultiplicationTable",
  "GroupOpenerColor",
  "GroupOpenerInsideFrame",
  "GroupOrbits",
  "GroupOrder",
  "GroupPageBreakWithin",
  "GroupSetwiseStabilizer",
  "GroupStabilizer",
  "GroupStabilizerChain",
  "GroupTogetherGrouping",
  "GroupTogetherNestedGrouping",
  "GrowCutComponents",
  "Gudermannian",
  "GuidedFilter",
  "GumbelDistribution",
  "HaarWavelet",
  "HadamardMatrix",
  "HalfLine",
  "HalfNormalDistribution",
  "HalfPlane",
  "HalfSpace",
  "HalftoneShading",
  "HamiltonianGraphQ",
  "HammingDistance",
  "HammingWindow",
  "HandlerFunctions",
  "HandlerFunctionsKeys",
  "HankelH1",
  "HankelH2",
  "HankelMatrix",
  "HankelTransform",
  "HannPoissonWindow",
  "HannWindow",
  "HaradaNortonGroupHN",
  "HararyGraph",
  "HardcorePointProcess",
  "HarmonicMean",
  "HarmonicMeanFilter",
  "HarmonicNumber",
  "Hash",
  "HatchFilling",
  "HatchShading",
  "Haversine",
  "HazardFunction",
  "Head",
  "HeadCompose",
  "HeaderAlignment",
  "HeaderBackground",
  "HeaderDisplayFunction",
  "HeaderLines",
  "Headers",
  "HeaderSize",
  "HeaderStyle",
  "Heads",
  "HeatFluxValue",
  "HeatInsulationValue",
  "HeatOutflowValue",
  "HeatRadiationValue",
  "HeatSymmetryValue",
  "HeatTemperatureCondition",
  "HeatTransferPDEComponent",
  "HeatTransferValue",
  "HeavisideLambda",
  "HeavisidePi",
  "HeavisideTheta",
  "HeldGroupHe",
  "HeldPart",
  "HelmholtzPDEComponent",
  "HelpBrowserLookup",
  "HelpBrowserNotebook",
  "HelpBrowserSettings",
  "HelpViewerSettings",
  "Here",
  "HermiteDecomposition",
  "HermiteH",
  "Hermitian",
  "HermitianMatrixQ",
  "HessenbergDecomposition",
  "Hessian",
  "HeunB",
  "HeunBPrime",
  "HeunC",
  "HeunCPrime",
  "HeunD",
  "HeunDPrime",
  "HeunG",
  "HeunGPrime",
  "HeunT",
  "HeunTPrime",
  "HexadecimalCharacter",
  "Hexahedron",
  "HexahedronBox",
  "HexahedronBoxOptions",
  "HiddenItems",
  "HiddenMarkovProcess",
  "HiddenSurface",
  "Highlighted",
  "HighlightGraph",
  "HighlightImage",
  "HighlightMesh",
  "HighlightString",
  "HighpassFilter",
  "HigmanSimsGroupHS",
  "HilbertCurve",
  "HilbertFilter",
  "HilbertMatrix",
  "Histogram",
  "Histogram3D",
  "HistogramDistribution",
  "HistogramList",
  "HistogramPointDensity",
  "HistogramTransform",
  "HistogramTransformInterpolation",
  "HistoricalPeriodData",
  "HitMissTransform",
  "HITSCentrality",
  "HjorthDistribution",
  "HodgeDual",
  "HoeffdingD",
  "HoeffdingDTest",
  "Hold",
  "HoldAll",
  "HoldAllComplete",
  "HoldComplete",
  "HoldFirst",
  "HoldForm",
  "HoldPattern",
  "HoldRest",
  "HolidayCalendar",
  "HomeDirectory",
  "HomePage",
  "Horizontal",
  "HorizontalForm",
  "HorizontalGauge",
  "HorizontalScrollPosition",
  "HornerForm",
  "HostLookup",
  "HotellingTSquareDistribution",
  "HoytDistribution",
  "HTMLSave",
  "HTTPErrorResponse",
  "HTTPRedirect",
  "HTTPRequest",
  "HTTPRequestData",
  "HTTPResponse",
  "Hue",
  "HumanGrowthData",
  "HumpDownHump",
  "HumpEqual",
  "HurwitzLerchPhi",
  "HurwitzZeta",
  "HyperbolicDistribution",
  "HypercubeGraph",
  "HyperexponentialDistribution",
  "Hyperfactorial",
  "Hypergeometric0F1",
  "Hypergeometric0F1Regularized",
  "Hypergeometric1F1",
  "Hypergeometric1F1Regularized",
  "Hypergeometric2F1",
  "Hypergeometric2F1Regularized",
  "HypergeometricDistribution",
  "HypergeometricPFQ",
  "HypergeometricPFQRegularized",
  "HypergeometricU",
  "Hyperlink",
  "HyperlinkAction",
  "HyperlinkCreationSettings",
  "Hyperplane",
  "Hyphenation",
  "HyphenationOptions",
  "HypoexponentialDistribution",
  "HypothesisTestData",
  "I",
  "IconData",
  "Iconize",
  "IconizedObject",
  "IconRules",
  "Icosahedron",
  "Identity",
  "IdentityMatrix",
  "If",
  "IfCompiled",
  "IgnoreCase",
  "IgnoreDiacritics",
  "IgnoreIsotopes",
  "IgnorePunctuation",
  "IgnoreSpellCheck",
  "IgnoreStereochemistry",
  "IgnoringInactive",
  "Im",
  "Image",
  "Image3D",
  "Image3DProjection",
  "Image3DSlices",
  "ImageAccumulate",
  "ImageAdd",
  "ImageAdjust",
  "ImageAlign",
  "ImageApply",
  "ImageApplyIndexed",
  "ImageAspectRatio",
  "ImageAssemble",
  "ImageAugmentationLayer",
  "ImageBoundingBoxes",
  "ImageCache",
  "ImageCacheValid",
  "ImageCapture",
  "ImageCaptureFunction",
  "ImageCases",
  "ImageChannels",
  "ImageClip",
  "ImageCollage",
  "ImageColorSpace",
  "ImageCompose",
  "ImageContainsQ",
  "ImageContents",
  "ImageConvolve",
  "ImageCooccurrence",
  "ImageCorners",
  "ImageCorrelate",
  "ImageCorrespondingPoints",
  "ImageCrop",
  "ImageData",
  "ImageDeconvolve",
  "ImageDemosaic",
  "ImageDifference",
  "ImageDimensions",
  "ImageDisplacements",
  "ImageDistance",
  "ImageEditMode",
  "ImageEffect",
  "ImageExposureCombine",
  "ImageFeatureTrack",
  "ImageFileApply",
  "ImageFileFilter",
  "ImageFileScan",
  "ImageFilter",
  "ImageFocusCombine",
  "ImageForestingComponents",
  "ImageFormattingWidth",
  "ImageForwardTransformation",
  "ImageGraphics",
  "ImageHistogram",
  "ImageIdentify",
  "ImageInstanceQ",
  "ImageKeypoints",
  "ImageLabels",
  "ImageLegends",
  "ImageLevels",
  "ImageLines",
  "ImageMargins",
  "ImageMarker",
  "ImageMarkers",
  "ImageMeasurements",
  "ImageMesh",
  "ImageMultiply",
  "ImageOffset",
  "ImagePad",
  "ImagePadding",
  "ImagePartition",
  "ImagePeriodogram",
  "ImagePerspectiveTransformation",
  "ImagePosition",
  "ImagePreviewFunction",
  "ImagePyramid",
  "ImagePyramidApply",
  "ImageQ",
  "ImageRangeCache",
  "ImageRecolor",
  "ImageReflect",
  "ImageRegion",
  "ImageResize",
  "ImageResolution",
  "ImageRestyle",
  "ImageRotate",
  "ImageRotated",
  "ImageSaliencyFilter",
  "ImageScaled",
  "ImageScan",
  "ImageSize",
  "ImageSizeAction",
  "ImageSizeCache",
  "ImageSizeMultipliers",
  "ImageSizeRaw",
  "ImageStitch",
  "ImageSubtract",
  "ImageTake",
  "ImageTransformation",
  "ImageTrim",
  "ImageType",
  "ImageValue",
  "ImageValuePositions",
  "ImageVectorscopePlot",
  "ImageWaveformPlot",
  "ImagingDevice",
  "ImplicitD",
  "ImplicitRegion",
  "Implies",
  "Import",
  "ImportAutoReplacements",
  "ImportByteArray",
  "ImportedObject",
  "ImportOptions",
  "ImportString",
  "ImprovementImportance",
  "In",
  "Inactivate",
  "Inactive",
  "InactiveStyle",
  "IncidenceGraph",
  "IncidenceList",
  "IncidenceMatrix",
  "IncludeAromaticBonds",
  "IncludeConstantBasis",
  "IncludedContexts",
  "IncludeDefinitions",
  "IncludeDirectories",
  "IncludeFileExtension",
  "IncludeGeneratorTasks",
  "IncludeHydrogens",
  "IncludeInflections",
  "IncludeMetaInformation",
  "IncludePods",
  "IncludeQuantities",
  "IncludeRelatedTables",
  "IncludeSingularSolutions",
  "IncludeSingularTerm",
  "IncludeWindowTimes",
  "Increment",
  "IndefiniteMatrixQ",
  "Indent",
  "IndentingNewlineSpacings",
  "IndentMaxFraction",
  "IndependenceTest",
  "IndependentEdgeSetQ",
  "IndependentPhysicalQuantity",
  "IndependentUnit",
  "IndependentUnitDimension",
  "IndependentVertexSetQ",
  "Indeterminate",
  "IndeterminateThreshold",
  "IndexCreationOptions",
  "Indexed",
  "IndexEdgeTaggedGraph",
  "IndexGraph",
  "IndexTag",
  "Inequality",
  "InertEvaluate",
  "InertExpression",
  "InexactNumberQ",
  "InexactNumbers",
  "InfiniteFuture",
  "InfiniteLine",
  "InfiniteLineThrough",
  "InfinitePast",
  "InfinitePlane",
  "Infinity",
  "Infix",
  "InflationAdjust",
  "InflationMethod",
  "Information",
  "InformationData",
  "InformationDataGrid",
  "Inherited",
  "InheritScope",
  "InhomogeneousPoissonPointProcess",
  "InhomogeneousPoissonProcess",
  "InitialEvaluationHistory",
  "Initialization",
  "InitializationCell",
  "InitializationCellEvaluation",
  "InitializationCellWarning",
  "InitializationObject",
  "InitializationObjects",
  "InitializationValue",
  "Initialize",
  "InitialSeeding",
  "InlineCounterAssignments",
  "InlineCounterIncrements",
  "InlineRules",
  "Inner",
  "InnerPolygon",
  "InnerPolyhedron",
  "Inpaint",
  "Input",
  "InputAliases",
  "InputAssumptions",
  "InputAutoReplacements",
  "InputField",
  "InputFieldBox",
  "InputFieldBoxOptions",
  "InputForm",
  "InputGrouping",
  "InputNamePacket",
  "InputNotebook",
  "InputPacket",
  "InputPorts",
  "InputSettings",
  "InputStream",
  "InputString",
  "InputStringPacket",
  "InputToBoxFormPacket",
  "Insert",
  "InsertionFunction",
  "InsertionPointObject",
  "InsertLinebreaks",
  "InsertResults",
  "Inset",
  "Inset3DBox",
  "Inset3DBoxOptions",
  "InsetBox",
  "InsetBoxOptions",
  "Insphere",
  "Install",
  "InstallService",
  "InstanceNormalizationLayer",
  "InString",
  "Integer",
  "IntegerDigits",
  "IntegerExponent",
  "IntegerLength",
  "IntegerName",
  "IntegerPart",
  "IntegerPartitions",
  "IntegerQ",
  "IntegerReverse",
  "Integers",
  "IntegerString",
  "Integral",
  "Integrate",
  "IntegrateChangeVariables",
  "Interactive",
  "InteractiveTradingChart",
  "InterfaceSwitched",
  "Interlaced",
  "Interleaving",
  "InternallyBalancedDecomposition",
  "InterpolatingFunction",
  "InterpolatingPolynomial",
  "Interpolation",
  "InterpolationOrder",
  "InterpolationPoints",
  "InterpolationPrecision",
  "Interpretation",
  "InterpretationBox",
  "InterpretationBoxOptions",
  "InterpretationFunction",
  "Interpreter",
  "InterpretTemplate",
  "InterquartileRange",
  "Interrupt",
  "InterruptSettings",
  "IntersectedEntityClass",
  "IntersectingQ",
  "Intersection",
  "Interval",
  "IntervalIntersection",
  "IntervalMarkers",
  "IntervalMarkersStyle",
  "IntervalMemberQ",
  "IntervalSlider",
  "IntervalUnion",
  "Into",
  "Inverse",
  "InverseBetaRegularized",
  "InverseBilateralLaplaceTransform",
  "InverseBilateralZTransform",
  "InverseCDF",
  "InverseChiSquareDistribution",
  "InverseContinuousWaveletTransform",
  "InverseDistanceTransform",
  "InverseEllipticNomeQ",
  "InverseErf",
  "InverseErfc",
  "InverseFourier",
  "InverseFourierCosTransform",
  "InverseFourierSequenceTransform",
  "InverseFourierSinTransform",
  "InverseFourierTransform",
  "InverseFunction",
  "InverseFunctions",
  "InverseGammaDistribution",
  "InverseGammaRegularized",
  "InverseGaussianDistribution",
  "InverseGudermannian",
  "InverseHankelTransform",
  "InverseHaversine",
  "InverseImagePyramid",
  "InverseJacobiCD",
  "InverseJacobiCN",
  "InverseJacobiCS",
  "InverseJacobiDC",
  "InverseJacobiDN",
  "InverseJacobiDS",
  "InverseJacobiNC",
  "InverseJacobiND",
  "InverseJacobiNS",
  "InverseJacobiSC",
  "InverseJacobiSD",
  "InverseJacobiSN",
  "InverseLaplaceTransform",
  "InverseMellinTransform",
  "InversePermutation",
  "InverseRadon",
  "InverseRadonTransform",
  "InverseSeries",
  "InverseShortTimeFourier",
  "InverseSpectrogram",
  "InverseSurvivalFunction",
  "InverseTransformedRegion",
  "InverseWaveletTransform",
  "InverseWeierstrassP",
  "InverseWishartMatrixDistribution",
  "InverseZTransform",
  "Invisible",
  "InvisibleApplication",
  "InvisibleTimes",
  "IPAddress",
  "IrreduciblePolynomialQ",
  "IslandData",
  "IsolatingInterval",
  "IsomorphicGraphQ",
  "IsomorphicSubgraphQ",
  "IsotopeData",
  "Italic",
  "Item",
  "ItemAspectRatio",
  "ItemBox",
  "ItemBoxOptions",
  "ItemDisplayFunction",
  "ItemSize",
  "ItemStyle",
  "ItoProcess",
  "JaccardDissimilarity",
  "JacobiAmplitude",
  "Jacobian",
  "JacobiCD",
  "JacobiCN",
  "JacobiCS",
  "JacobiDC",
  "JacobiDN",
  "JacobiDS",
  "JacobiEpsilon",
  "JacobiNC",
  "JacobiND",
  "JacobiNS",
  "JacobiP",
  "JacobiSC",
  "JacobiSD",
  "JacobiSN",
  "JacobiSymbol",
  "JacobiZeta",
  "JacobiZN",
  "JankoGroupJ1",
  "JankoGroupJ2",
  "JankoGroupJ3",
  "JankoGroupJ4",
  "JarqueBeraALMTest",
  "JohnsonDistribution",
  "Join",
  "JoinAcross",
  "Joined",
  "JoinedCurve",
  "JoinedCurveBox",
  "JoinedCurveBoxOptions",
  "JoinForm",
  "JordanDecomposition",
  "JordanModelDecomposition",
  "JulianDate",
  "JuliaSetBoettcher",
  "JuliaSetIterationCount",
  "JuliaSetPlot",
  "JuliaSetPoints",
  "K",
  "KagiChart",
  "KaiserBesselWindow",
  "KaiserWindow",
  "KalmanEstimator",
  "KalmanFilter",
  "KarhunenLoeveDecomposition",
  "KaryTree",
  "KatzCentrality",
  "KCoreComponents",
  "KDistribution",
  "KEdgeConnectedComponents",
  "KEdgeConnectedGraphQ",
  "KeepExistingVersion",
  "KelvinBei",
  "KelvinBer",
  "KelvinKei",
  "KelvinKer",
  "KendallTau",
  "KendallTauTest",
  "KernelConfiguration",
  "KernelExecute",
  "KernelFunction",
  "KernelMixtureDistribution",
  "KernelObject",
  "Kernels",
  "Ket",
  "Key",
  "KeyCollisionFunction",
  "KeyComplement",
  "KeyDrop",
  "KeyDropFrom",
  "KeyExistsQ",
  "KeyFreeQ",
  "KeyIntersection",
  "KeyMap",
  "KeyMemberQ",
  "KeypointStrength",
  "Keys",
  "KeySelect",
  "KeySort",
  "KeySortBy",
  "KeyTake",
  "KeyUnion",
  "KeyValueMap",
  "KeyValuePattern",
  "Khinchin",
  "KillProcess",
  "KirchhoffGraph",
  "KirchhoffMatrix",
  "KleinInvariantJ",
  "KnapsackSolve",
  "KnightTourGraph",
  "KnotData",
  "KnownUnitQ",
  "KochCurve",
  "KolmogorovSmirnovTest",
  "KroneckerDelta",
  "KroneckerModelDecomposition",
  "KroneckerProduct",
  "KroneckerSymbol",
  "KuiperTest",
  "KumaraswamyDistribution",
  "Kurtosis",
  "KuwaharaFilter",
  "KVertexConnectedComponents",
  "KVertexConnectedGraphQ",
  "LABColor",
  "Label",
  "Labeled",
  "LabeledSlider",
  "LabelingFunction",
  "LabelingSize",
  "LabelStyle",
  "LabelVisibility",
  "LaguerreL",
  "LakeData",
  "LambdaComponents",
  "LambertW",
  "LameC",
  "LameCPrime",
  "LameEigenvalueA",
  "LameEigenvalueB",
  "LameS",
  "LameSPrime",
  "LaminaData",
  "LanczosWindow",
  "LandauDistribution",
  "Language",
  "LanguageCategory",
  "LanguageData",
  "LanguageIdentify",
  "LanguageOptions",
  "LaplaceDistribution",
  "LaplaceTransform",
  "Laplacian",
  "LaplacianFilter",
  "LaplacianGaussianFilter",
  "LaplacianPDETerm",
  "Large",
  "Larger",
  "Last",
  "Latitude",
  "LatitudeLongitude",
  "LatticeData",
  "LatticeReduce",
  "Launch",
  "LaunchKernels",
  "LayeredGraphPlot",
  "LayeredGraphPlot3D",
  "LayerSizeFunction",
  "LayoutInformation",
  "LCHColor",
  "LCM",
  "LeaderSize",
  "LeafCount",
  "LeapVariant",
  "LeapYearQ",
  "LearnDistribution",
  "LearnedDistribution",
  "LearningRate",
  "LearningRateMultipliers",
  "LeastSquares",
  "LeastSquaresFilterKernel",
  "Left",
  "LeftArrow",
  "LeftArrowBar",
  "LeftArrowRightArrow",
  "LeftDownTeeVector",
  "LeftDownVector",
  "LeftDownVectorBar",
  "LeftRightArrow",
  "LeftRightVector",
  "LeftTee",
  "LeftTeeArrow",
  "LeftTeeVector",
  "LeftTriangle",
  "LeftTriangleBar",
  "LeftTriangleEqual",
  "LeftUpDownVector",
  "LeftUpTeeVector",
  "LeftUpVector",
  "LeftUpVectorBar",
  "LeftVector",
  "LeftVectorBar",
  "LegendAppearance",
  "Legended",
  "LegendFunction",
  "LegendLabel",
  "LegendLayout",
  "LegendMargins",
  "LegendMarkers",
  "LegendMarkerSize",
  "LegendreP",
  "LegendreQ",
  "LegendreType",
  "Length",
  "LengthWhile",
  "LerchPhi",
  "Less",
  "LessEqual",
  "LessEqualGreater",
  "LessEqualThan",
  "LessFullEqual",
  "LessGreater",
  "LessLess",
  "LessSlantEqual",
  "LessThan",
  "LessTilde",
  "LetterCharacter",
  "LetterCounts",
  "LetterNumber",
  "LetterQ",
  "Level",
  "LeveneTest",
  "LeviCivitaTensor",
  "LevyDistribution",
  "Lexicographic",
  "LexicographicOrder",
  "LexicographicSort",
  "LibraryDataType",
  "LibraryFunction",
  "LibraryFunctionDeclaration",
  "LibraryFunctionError",
  "LibraryFunctionInformation",
  "LibraryFunctionLoad",
  "LibraryFunctionUnload",
  "LibraryLoad",
  "LibraryUnload",
  "LicenseEntitlementObject",
  "LicenseEntitlements",
  "LicenseID",
  "LicensingSettings",
  "LiftingFilterData",
  "LiftingWaveletTransform",
  "LightBlue",
  "LightBrown",
  "LightCyan",
  "Lighter",
  "LightGray",
  "LightGreen",
  "Lighting",
  "LightingAngle",
  "LightMagenta",
  "LightOrange",
  "LightPink",
  "LightPurple",
  "LightRed",
  "LightSources",
  "LightYellow",
  "Likelihood",
  "Limit",
  "LimitsPositioning",
  "LimitsPositioningTokens",
  "LindleyDistribution",
  "Line",
  "Line3DBox",
  "Line3DBoxOptions",
  "LinearFilter",
  "LinearFractionalOptimization",
  "LinearFractionalTransform",
  "LinearGradientFilling",
  "LinearGradientImage",
  "LinearizingTransformationData",
  "LinearLayer",
  "LinearModelFit",
  "LinearOffsetFunction",
  "LinearOptimization",
  "LinearProgramming",
  "LinearRecurrence",
  "LinearSolve",
  "LinearSolveFunction",
  "LineBox",
  "LineBoxOptions",
  "LineBreak",
  "LinebreakAdjustments",
  "LineBreakChart",
  "LinebreakSemicolonWeighting",
  "LineBreakWithin",
  "LineColor",
  "LineGraph",
  "LineIndent",
  "LineIndentMaxFraction",
  "LineIntegralConvolutionPlot",
  "LineIntegralConvolutionScale",
  "LineLegend",
  "LineOpacity",
  "LineSpacing",
  "LineWrapParts",
  "LinkActivate",
  "LinkClose",
  "LinkConnect",
  "LinkConnectedQ",
  "LinkCreate",
  "LinkError",
  "LinkFlush",
  "LinkFunction",
  "LinkHost",
  "LinkInterrupt",
  "LinkLaunch",
  "LinkMode",
  "LinkObject",
  "LinkOpen",
  "LinkOptions",
  "LinkPatterns",
  "LinkProtocol",
  "LinkRankCentrality",
  "LinkRead",
  "LinkReadHeld",
  "LinkReadyQ",
  "Links",
  "LinkService",
  "LinkWrite",
  "LinkWriteHeld",
  "LiouvilleLambda",
  "List",
  "Listable",
  "ListAnimate",
  "ListContourPlot",
  "ListContourPlot3D",
  "ListConvolve",
  "ListCorrelate",
  "ListCurvePathPlot",
  "ListDeconvolve",
  "ListDensityPlot",
  "ListDensityPlot3D",
  "Listen",
  "ListFormat",
  "ListFourierSequenceTransform",
  "ListInterpolation",
  "ListLineIntegralConvolutionPlot",
  "ListLinePlot",
  "ListLinePlot3D",
  "ListLogLinearPlot",
  "ListLogLogPlot",
  "ListLogPlot",
  "ListPicker",
  "ListPickerBox",
  "ListPickerBoxBackground",
  "ListPickerBoxOptions",
  "ListPlay",
  "ListPlot",
  "ListPlot3D",
  "ListPointPlot3D",
  "ListPolarPlot",
  "ListQ",
  "ListSliceContourPlot3D",
  "ListSliceDensityPlot3D",
  "ListSliceVectorPlot3D",
  "ListStepPlot",
  "ListStreamDensityPlot",
  "ListStreamPlot",
  "ListStreamPlot3D",
  "ListSurfacePlot3D",
  "ListVectorDensityPlot",
  "ListVectorDisplacementPlot",
  "ListVectorDisplacementPlot3D",
  "ListVectorPlot",
  "ListVectorPlot3D",
  "ListZTransform",
  "Literal",
  "LiteralSearch",
  "LiteralType",
  "LoadCompiledComponent",
  "LocalAdaptiveBinarize",
  "LocalCache",
  "LocalClusteringCoefficient",
  "LocalEvaluate",
  "LocalizeDefinitions",
  "LocalizeVariables",
  "LocalObject",
  "LocalObjects",
  "LocalResponseNormalizationLayer",
  "LocalSubmit",
  "LocalSymbol",
  "LocalTime",
  "LocalTimeZone",
  "LocationEquivalenceTest",
  "LocationTest",
  "Locator",
  "LocatorAutoCreate",
  "LocatorBox",
  "LocatorBoxOptions",
  "LocatorCentering",
  "LocatorPane",
  "LocatorPaneBox",
  "LocatorPaneBoxOptions",
  "LocatorRegion",
  "Locked",
  "Log",
  "Log10",
  "Log2",
  "LogBarnesG",
  "LogGamma",
  "LogGammaDistribution",
  "LogicalExpand",
  "LogIntegral",
  "LogisticDistribution",
  "LogisticSigmoid",
  "LogitModelFit",
  "LogLikelihood",
  "LogLinearPlot",
  "LogLogisticDistribution",
  "LogLogPlot",
  "LogMultinormalDistribution",
  "LogNormalDistribution",
  "LogPlot",
  "LogRankTest",
  "LogSeriesDistribution",
  "LongEqual",
  "Longest",
  "LongestCommonSequence",
  "LongestCommonSequencePositions",
  "LongestCommonSubsequence",
  "LongestCommonSubsequencePositions",
  "LongestMatch",
  "LongestOrderedSequence",
  "LongForm",
  "Longitude",
  "LongLeftArrow",
  "LongLeftRightArrow",
  "LongRightArrow",
  "LongShortTermMemoryLayer",
  "Lookup",
  "Loopback",
  "LoopFreeGraphQ",
  "Looping",
  "LossFunction",
  "LowerCaseQ",
  "LowerLeftArrow",
  "LowerRightArrow",
  "LowerTriangularize",
  "LowerTriangularMatrix",
  "LowerTriangularMatrixQ",
  "LowpassFilter",
  "LQEstimatorGains",
  "LQGRegulator",
  "LQOutputRegulatorGains",
  "LQRegulatorGains",
  "LUBackSubstitution",
  "LucasL",
  "LuccioSamiComponents",
  "LUDecomposition",
  "LunarEclipse",
  "LUVColor",
  "LyapunovSolve",
  "LyonsGroupLy",
  "MachineID",
  "MachineName",
  "MachineNumberQ",
  "MachinePrecision",
  "MacintoshSystemPageSetup",
  "Magenta",
  "Magnification",
  "Magnify",
  "MailAddressValidation",
  "MailExecute",
  "MailFolder",
  "MailItem",
  "MailReceiverFunction",
  "MailResponseFunction",
  "MailSearch",
  "MailServerConnect",
  "MailServerConnection",
  "MailSettings",
  "MainSolve",
  "MaintainDynamicCaches",
  "Majority",
  "MakeBoxes",
  "MakeExpression",
  "MakeRules",
  "ManagedLibraryExpressionID",
  "ManagedLibraryExpressionQ",
  "MandelbrotSetBoettcher",
  "MandelbrotSetDistance",
  "MandelbrotSetIterationCount",
  "MandelbrotSetMemberQ",
  "MandelbrotSetPlot",
  "MangoldtLambda",
  "ManhattanDistance",
  "Manipulate",
  "Manipulator",
  "MannedSpaceMissionData",
  "MannWhitneyTest",
  "MantissaExponent",
  "Manual",
  "Map",
  "MapAll",
  "MapApply",
  "MapAt",
  "MapIndexed",
  "MAProcess",
  "MapThread",
  "MarchenkoPasturDistribution",
  "MarcumQ",
  "MardiaCombinedTest",
  "MardiaKurtosisTest",
  "MardiaSkewnessTest",
  "MarginalDistribution",
  "MarkovProcessProperties",
  "Masking",
  "MassConcentrationCondition",
  "MassFluxValue",
  "MassImpermeableBoundaryValue",
  "MassOutflowValue",
  "MassSymmetryValue",
  "MassTransferValue",
  "MassTransportPDEComponent",
  "MatchingDissimilarity",
  "MatchLocalNameQ",
  "MatchLocalNames",
  "MatchQ",
  "Material",
  "MaterialShading",
  "MaternPointProcess",
  "MathematicalFunctionData",
  "MathematicaNotation",
  "MathieuC",
  "MathieuCharacteristicA",
  "MathieuCharacteristicB",
  "MathieuCharacteristicExponent",
  "MathieuCPrime",
  "MathieuGroupM11",
  "MathieuGroupM12",
  "MathieuGroupM22",
  "MathieuGroupM23",
  "MathieuGroupM24",
  "MathieuS",
  "MathieuSPrime",
  "MathMLForm",
  "MathMLText",
  "Matrices",
  "MatrixExp",
  "MatrixForm",
  "MatrixFunction",
  "MatrixLog",
  "MatrixNormalDistribution",
  "MatrixPlot",
  "MatrixPower",
  "MatrixPropertyDistribution",
  "MatrixQ",
  "MatrixRank",
  "MatrixTDistribution",
  "Max",
  "MaxBend",
  "MaxCellMeasure",
  "MaxColorDistance",
  "MaxDate",
  "MaxDetect",
  "MaxDisplayedChildren",
  "MaxDuration",
  "MaxExtraBandwidths",
  "MaxExtraConditions",
  "MaxFeatureDisplacement",
  "MaxFeatures",
  "MaxFilter",
  "MaximalBy",
  "Maximize",
  "MaxItems",
  "MaxIterations",
  "MaxLimit",
  "MaxMemoryUsed",
  "MaxMixtureKernels",
  "MaxOverlapFraction",
  "MaxPlotPoints",
  "MaxPoints",
  "MaxRecursion",
  "MaxStableDistribution",
  "MaxStepFraction",
  "MaxSteps",
  "MaxStepSize",
  "MaxTrainingRounds",
  "MaxValue",
  "MaxwellDistribution",
  "MaxWordGap",
  "McLaughlinGroupMcL",
  "Mean",
  "MeanAbsoluteLossLayer",
  "MeanAround",
  "MeanClusteringCoefficient",
  "MeanDegreeConnectivity",
  "MeanDeviation",
  "MeanFilter",
  "MeanGraphDistance",
  "MeanNeighborDegree",
  "MeanPointDensity",
  "MeanShift",
  "MeanShiftFilter",
  "MeanSquaredLossLayer",
  "Median",
  "MedianDeviation",
  "MedianFilter",
  "MedicalTestData",
  "Medium",
  "MeijerG",
  "MeijerGReduce",
  "MeixnerDistribution",
  "MellinConvolve",
  "MellinTransform",
  "MemberQ",
  "MemoryAvailable",
  "MemoryConstrained",
  "MemoryConstraint",
  "MemoryInUse",
  "MengerMesh",
  "Menu",
  "MenuAppearance",
  "MenuCommandKey",
  "MenuEvaluator",
  "MenuItem",
  "MenuList",
  "MenuPacket",
  "MenuSortingValue",
  "MenuStyle",
  "MenuView",
  "Merge",
  "MergeDifferences",
  "MergingFunction",
  "MersennePrimeExponent",
  "MersennePrimeExponentQ",
  "Mesh",
  "MeshCellCentroid",
  "MeshCellCount",
  "MeshCellHighlight",
  "MeshCellIndex",
  "MeshCellLabel",
  "MeshCellMarker",
  "MeshCellMeasure",
  "MeshCellQuality",
  "MeshCells",
  "MeshCellShapeFunction",
  "MeshCellStyle",
  "MeshConnectivityGraph",
  "MeshCoordinates",
  "MeshFunctions",
  "MeshPrimitives",
  "MeshQualityGoal",
  "MeshRange",
  "MeshRefinementFunction",
  "MeshRegion",
  "MeshRegionQ",
  "MeshShading",
  "MeshStyle",
  "Message",
  "MessageDialog",
  "MessageList",
  "MessageName",
  "MessageObject",
  "MessageOptions",
  "MessagePacket",
  "Messages",
  "MessagesNotebook",
  "MetaCharacters",
  "MetaInformation",
  "MeteorShowerData",
  "Method",
  "MethodOptions",
  "MexicanHatWavelet",
  "MeyerWavelet",
  "Midpoint",
  "MIMETypeToFormatList",
  "Min",
  "MinColorDistance",
  "MinDate",
  "MinDetect",
  "MineralData",
  "MinFilter",
  "MinimalBy",
  "MinimalPolynomial",
  "MinimalStateSpaceModel",
  "Minimize",
  "MinimumTimeIncrement",
  "MinIntervalSize",
  "MinkowskiQuestionMark",
  "MinLimit",
  "MinMax",
  "MinorPlanetData",
  "Minors",
  "MinPointSeparation",
  "MinRecursion",
  "MinSize",
  "MinStableDistribution",
  "Minus",
  "MinusPlus",
  "MinValue",
  "Missing",
  "MissingBehavior",
  "MissingDataMethod",
  "MissingDataRules",
  "MissingQ",
  "MissingString",
  "MissingStyle",
  "MissingValuePattern",
  "MissingValueSynthesis",
  "MittagLefflerE",
  "MixedFractionParts",
  "MixedGraphQ",
  "MixedMagnitude",
  "MixedRadix",
  "MixedRadixQuantity",
  "MixedUnit",
  "MixtureDistribution",
  "Mod",
  "Modal",
  "Mode",
  "ModelPredictiveController",
  "Modular",
  "ModularInverse",
  "ModularLambda",
  "Module",
  "Modulus",
  "MoebiusMu",
  "Molecule",
  "MoleculeAlign",
  "MoleculeContainsQ",
  "MoleculeDraw",
  "MoleculeEquivalentQ",
  "MoleculeFreeQ",
  "MoleculeGraph",
  "MoleculeMatchQ",
  "MoleculeMaximumCommonSubstructure",
  "MoleculeModify",
  "MoleculeName",
  "MoleculePattern",
  "MoleculePlot",
  "MoleculePlot3D",
  "MoleculeProperty",
  "MoleculeQ",
  "MoleculeRecognize",
  "MoleculeSubstructureCount",
  "MoleculeValue",
  "Moment",
  "MomentConvert",
  "MomentEvaluate",
  "MomentGeneratingFunction",
  "MomentOfInertia",
  "Monday",
  "Monitor",
  "MonomialList",
  "MonomialOrder",
  "MonsterGroupM",
  "MoonPhase",
  "MoonPosition",
  "MorletWavelet",
  "MorphologicalBinarize",
  "MorphologicalBranchPoints",
  "MorphologicalComponents",
  "MorphologicalEulerNumber",
  "MorphologicalGraph",
  "MorphologicalPerimeter",
  "MorphologicalTransform",
  "MortalityData",
  "Most",
  "MountainData",
  "MouseAnnotation",
  "MouseAppearance",
  "MouseAppearanceTag",
  "MouseButtons",
  "Mouseover",
  "MousePointerNote",
  "MousePosition",
  "MovieData",
  "MovingAverage",
  "MovingMap",
  "MovingMedian",
  "MoyalDistribution",
  "MultiaxisArrangement",
  "Multicolumn",
  "MultiedgeStyle",
  "MultigraphQ",
  "MultilaunchWarning",
  "MultiLetterItalics",
  "MultiLetterStyle",
  "MultilineFunction",
  "Multinomial",
  "MultinomialDistribution",
  "MultinormalDistribution",
  "MultiplicativeOrder",
  "Multiplicity",
  "MultiplySides",
  "MultiscriptBoxOptions",
  "Multiselection",
  "MultivariateHypergeometricDistribution",
  "MultivariatePoissonDistribution",
  "MultivariateTDistribution",
  "N",
  "NakagamiDistribution",
  "NameQ",
  "Names",
  "NamespaceBox",
  "NamespaceBoxOptions",
  "Nand",
  "NArgMax",
  "NArgMin",
  "NBernoulliB",
  "NBodySimulation",
  "NBodySimulationData",
  "NCache",
  "NCaputoD",
  "NDEigensystem",
  "NDEigenvalues",
  "NDSolve",
  "NDSolveValue",
  "Nearest",
  "NearestFunction",
  "NearestMeshCells",
  "NearestNeighborG",
  "NearestNeighborGraph",
  "NearestTo",
  "NebulaData",
  "NeedlemanWunschSimilarity",
  "Needs",
  "Negative",
  "NegativeBinomialDistribution",
  "NegativeDefiniteMatrixQ",
  "NegativeIntegers",
  "NegativelyOrientedPoints",
  "NegativeMultinomialDistribution",
  "NegativeRationals",
  "NegativeReals",
  "NegativeSemidefiniteMatrixQ",
  "NeighborhoodData",
  "NeighborhoodGraph",
  "Nest",
  "NestedGreaterGreater",
  "NestedLessLess",
  "NestedScriptRules",
  "NestGraph",
  "NestList",
  "NestTree",
  "NestWhile",
  "NestWhileList",
  "NetAppend",
  "NetArray",
  "NetArrayLayer",
  "NetBidirectionalOperator",
  "NetChain",
  "NetDecoder",
  "NetDelete",
  "NetDrop",
  "NetEncoder",
  "NetEvaluationMode",
  "NetExternalObject",
  "NetExtract",
  "NetFlatten",
  "NetFoldOperator",
  "NetGANOperator",
  "NetGraph",
  "NetInformation",
  "NetInitialize",
  "NetInsert",
  "NetInsertSharedArrays",
  "NetJoin",
  "NetMapOperator",
  "NetMapThreadOperator",
  "NetMeasurements",
  "NetModel",
  "NetNestOperator",
  "NetPairEmbeddingOperator",
  "NetPort",
  "NetPortGradient",
  "NetPrepend",
  "NetRename",
  "NetReplace",
  "NetReplacePart",
  "NetSharedArray",
  "NetStateObject",
  "NetTake",
  "NetTrain",
  "NetTrainResultsObject",
  "NetUnfold",
  "NetworkPacketCapture",
  "NetworkPacketRecording",
  "NetworkPacketRecordingDuring",
  "NetworkPacketTrace",
  "NeumannValue",
  "NevilleThetaC",
  "NevilleThetaD",
  "NevilleThetaN",
  "NevilleThetaS",
  "NewPrimitiveStyle",
  "NExpectation",
  "Next",
  "NextCell",
  "NextDate",
  "NextPrime",
  "NextScheduledTaskTime",
  "NeymanScottPointProcess",
  "NFractionalD",
  "NHoldAll",
  "NHoldFirst",
  "NHoldRest",
  "NicholsGridLines",
  "NicholsPlot",
  "NightHemisphere",
  "NIntegrate",
  "NMaximize",
  "NMaxValue",
  "NMinimize",
  "NMinValue",
  "NominalScale",
  "NominalVariables",
  "NonAssociative",
  "NoncentralBetaDistribution",
  "NoncentralChiSquareDistribution",
  "NoncentralFRatioDistribution",
  "NoncentralStudentTDistribution",
  "NonCommutativeMultiply",
  "NonConstants",
  "NondimensionalizationTransform",
  "None",
  "NoneTrue",
  "NonlinearModelFit",
  "NonlinearStateSpaceModel",
  "NonlocalMeansFilter",
  "NonNegative",
  "NonNegativeIntegers",
  "NonNegativeRationals",
  "NonNegativeReals",
  "NonPositive",
  "NonPositiveIntegers",
  "NonPositiveRationals",
  "NonPositiveReals",
  "Nor",
  "NorlundB",
  "Norm",
  "Normal",
  "NormalDistribution",
  "NormalGrouping",
  "NormalizationLayer",
  "Normalize",
  "Normalized",
  "NormalizedSquaredEuclideanDistance",
  "NormalMatrixQ",
  "NormalsFunction",
  "NormFunction",
  "Not",
  "NotCongruent",
  "NotCupCap",
  "NotDoubleVerticalBar",
  "Notebook",
  "NotebookApply",
  "NotebookAutoSave",
  "NotebookBrowseDirectory",
  "NotebookClose",
  "NotebookConvertSettings",
  "NotebookCreate",
  "NotebookDefault",
  "NotebookDelete",
  "NotebookDirectory",
  "NotebookDynamicExpression",
  "NotebookEvaluate",
  "NotebookEventActions",
  "NotebookFileName",
  "NotebookFind",
  "NotebookGet",
  "NotebookImport",
  "NotebookInformation",
  "NotebookInterfaceObject",
  "NotebookLocate",
  "NotebookObject",
  "NotebookOpen",
  "NotebookPath",
  "NotebookPrint",
  "NotebookPut",
  "NotebookRead",
  "Notebooks",
  "NotebookSave",
  "NotebookSelection",
  "NotebooksMenu",
  "NotebookTemplate",
  "NotebookWrite",
  "NotElement",
  "NotEqualTilde",
  "NotExists",
  "NotGreater",
  "NotGreaterEqual",
  "NotGreaterFullEqual",
  "NotGreaterGreater",
  "NotGreaterLess",
  "NotGreaterSlantEqual",
  "NotGreaterTilde",
  "Nothing",
  "NotHumpDownHump",
  "NotHumpEqual",
  "NotificationFunction",
  "NotLeftTriangle",
  "NotLeftTriangleBar",
  "NotLeftTriangleEqual",
  "NotLess",
  "NotLessEqual",
  "NotLessFullEqual",
  "NotLessGreater",
  "NotLessLess",
  "NotLessSlantEqual",
  "NotLessTilde",
  "NotNestedGreaterGreater",
  "NotNestedLessLess",
  "NotPrecedes",
  "NotPrecedesEqual",
  "NotPrecedesSlantEqual",
  "NotPrecedesTilde",
  "NotReverseElement",
  "NotRightTriangle",
  "NotRightTriangleBar",
  "NotRightTriangleEqual",
  "NotSquareSubset",
  "NotSquareSubsetEqual",
  "NotSquareSuperset",
  "NotSquareSupersetEqual",
  "NotSubset",
  "NotSubsetEqual",
  "NotSucceeds",
  "NotSucceedsEqual",
  "NotSucceedsSlantEqual",
  "NotSucceedsTilde",
  "NotSuperset",
  "NotSupersetEqual",
  "NotTilde",
  "NotTildeEqual",
  "NotTildeFullEqual",
  "NotTildeTilde",
  "NotVerticalBar",
  "Now",
  "NoWhitespace",
  "NProbability",
  "NProduct",
  "NProductFactors",
  "NRoots",
  "NSolve",
  "NSolveValues",
  "NSum",
  "NSumTerms",
  "NuclearExplosionData",
  "NuclearReactorData",
  "Null",
  "NullRecords",
  "NullSpace",
  "NullWords",
  "Number",
  "NumberCompose",
  "NumberDecompose",
  "NumberDigit",
  "NumberExpand",
  "NumberFieldClassNumber",
  "NumberFieldDiscriminant",
  "NumberFieldFundamentalUnits",
  "NumberFieldIntegralBasis",
  "NumberFieldNormRepresentatives",
  "NumberFieldRegulator",
  "NumberFieldRootsOfUnity",
  "NumberFieldSignature",
  "NumberForm",
  "NumberFormat",
  "NumberLinePlot",
  "NumberMarks",
  "NumberMultiplier",
  "NumberPadding",
  "NumberPoint",
  "NumberQ",
  "NumberSeparator",
  "NumberSigns",
  "NumberString",
  "Numerator",
  "NumeratorDenominator",
  "NumericalOrder",
  "NumericalSort",
  "NumericArray",
  "NumericArrayQ",
  "NumericArrayType",
  "NumericFunction",
  "NumericQ",
  "NuttallWindow",
  "NValues",
  "NyquistGridLines",
  "NyquistPlot",
  "O",
  "ObjectExistsQ",
  "ObservabilityGramian",
  "ObservabilityMatrix",
  "ObservableDecomposition",
  "ObservableModelQ",
  "OceanData",
  "Octahedron",
  "OddQ",
  "Off",
  "Offset",
  "OLEData",
  "On",
  "ONanGroupON",
  "Once",
  "OneIdentity",
  "Opacity",
  "OpacityFunction",
  "OpacityFunctionScaling",
  "Open",
  "OpenAppend",
  "Opener",
  "OpenerBox",
  "OpenerBoxOptions",
  "OpenerView",
  "OpenFunctionInspectorPacket",
  "Opening",
  "OpenRead",
  "OpenSpecialOptions",
  "OpenTemporary",
  "OpenWrite",
  "Operate",
  "OperatingSystem",
  "OperatorApplied",
  "OptimumFlowData",
  "Optional",
  "OptionalElement",
  "OptionInspectorSettings",
  "OptionQ",
  "Options",
  "OptionsPacket",
  "OptionsPattern",
  "OptionValue",
  "OptionValueBox",
  "OptionValueBoxOptions",
  "Or",
  "Orange",
  "Order",
  "OrderDistribution",
  "OrderedQ",
  "Ordering",
  "OrderingBy",
  "OrderingLayer",
  "Orderless",
  "OrderlessPatternSequence",
  "OrdinalScale",
  "OrnsteinUhlenbeckProcess",
  "Orthogonalize",
  "OrthogonalMatrixQ",
  "Out",
  "Outer",
  "OuterPolygon",
  "OuterPolyhedron",
  "OutputAutoOverwrite",
  "OutputControllabilityMatrix",
  "OutputControllableModelQ",
  "OutputForm",
  "OutputFormData",
  "OutputGrouping",
  "OutputMathEditExpression",
  "OutputNamePacket",
  "OutputPorts",
  "OutputResponse",
  "OutputSizeLimit",
  "OutputStream",
  "Over",
  "OverBar",
  "OverDot",
  "Overflow",
  "OverHat",
  "Overlaps",
  "Overlay",
  "OverlayBox",
  "OverlayBoxOptions",
  "OverlayVideo",
  "Overscript",
  "OverscriptBox",
  "OverscriptBoxOptions",
  "OverTilde",
  "OverVector",
  "OverwriteTarget",
  "OwenT",
  "OwnValues",
  "Package",
  "PackingMethod",
  "PackPaclet",
  "PacletDataRebuild",
  "PacletDirectoryAdd",
  "PacletDirectoryLoad",
  "PacletDirectoryRemove",
  "PacletDirectoryUnload",
  "PacletDisable",
  "PacletEnable",
  "PacletFind",
  "PacletFindRemote",
  "PacletInformation",
  "PacletInstall",
  "PacletInstallSubmit",
  "PacletNewerQ",
  "PacletObject",
  "PacletObjectQ",
  "PacletSite",
  "PacletSiteObject",
  "PacletSiteRegister",
  "PacletSites",
  "PacletSiteUnregister",
  "PacletSiteUpdate",
  "PacletSymbol",
  "PacletUninstall",
  "PacletUpdate",
  "PaddedForm",
  "Padding",
  "PaddingLayer",
  "PaddingSize",
  "PadeApproximant",
  "PadLeft",
  "PadRight",
  "PageBreakAbove",
  "PageBreakBelow",
  "PageBreakWithin",
  "PageFooterLines",
  "PageFooters",
  "PageHeaderLines",
  "PageHeaders",
  "PageHeight",
  "PageRankCentrality",
  "PageTheme",
  "PageWidth",
  "Pagination",
  "PairCorrelationG",
  "PairedBarChart",
  "PairedHistogram",
  "PairedSmoothHistogram",
  "PairedTTest",
  "PairedZTest",
  "PaletteNotebook",
  "PalettePath",
  "PalettesMenuSettings",
  "PalindromeQ",
  "Pane",
  "PaneBox",
  "PaneBoxOptions",
  "Panel",
  "PanelBox",
  "PanelBoxOptions",
  "Paneled",
  "PaneSelector",
  "PaneSelectorBox",
  "PaneSelectorBoxOptions",
  "PaperWidth",
  "ParabolicCylinderD",
  "ParagraphIndent",
  "ParagraphSpacing",
  "ParallelArray",
  "ParallelAxisPlot",
  "ParallelCombine",
  "ParallelDo",
  "Parallelepiped",
  "ParallelEvaluate",
  "Parallelization",
  "Parallelize",
  "ParallelKernels",
  "ParallelMap",
  "ParallelNeeds",
  "Parallelogram",
  "ParallelProduct",
  "ParallelSubmit",
  "ParallelSum",
  "ParallelTable",
  "ParallelTry",
  "Parameter",
  "ParameterEstimator",
  "ParameterMixtureDistribution",
  "ParameterVariables",
  "ParametricConvexOptimization",
  "ParametricFunction",
  "ParametricNDSolve",
  "ParametricNDSolveValue",
  "ParametricPlot",
  "ParametricPlot3D",
  "ParametricRampLayer",
  "ParametricRegion",
  "ParentBox",
  "ParentCell",
  "ParentConnect",
  "ParentDirectory",
  "ParentEdgeLabel",
  "ParentEdgeLabelFunction",
  "ParentEdgeLabelStyle",
  "ParentEdgeShapeFunction",
  "ParentEdgeStyle",
  "ParentEdgeStyleFunction",
  "ParentForm",
  "Parenthesize",
  "ParentList",
  "ParentNotebook",
  "ParetoDistribution",
  "ParetoPickandsDistribution",
  "ParkData",
  "Part",
  "PartBehavior",
  "PartialCorrelationFunction",
  "PartialD",
  "ParticleAcceleratorData",
  "ParticleData",
  "Partition",
  "PartitionGranularity",
  "PartitionsP",
  "PartitionsQ",
  "PartLayer",
  "PartOfSpeech",
  "PartProtection",
  "ParzenWindow",
  "PascalDistribution",
  "PassEventsDown",
  "PassEventsUp",
  "Paste",
  "PasteAutoQuoteCharacters",
  "PasteBoxFormInlineCells",
  "PasteButton",
  "Path",
  "PathGraph",
  "PathGraphQ",
  "Pattern",
  "PatternFilling",
  "PatternReaction",
  "PatternSequence",
  "PatternTest",
  "PauliMatrix",
  "PaulWavelet",
  "Pause",
  "PausedTime",
  "PDF",
  "PeakDetect",
  "PeanoCurve",
  "PearsonChiSquareTest",
  "PearsonCorrelationTest",
  "PearsonDistribution",
  "PenttinenPointProcess",
  "PercentForm",
  "PerfectNumber",
  "PerfectNumberQ",
  "PerformanceGoal",
  "Perimeter",
  "PeriodicBoundaryCondition",
  "PeriodicInterpolation",
  "Periodogram",
  "PeriodogramArray",
  "Permanent",
  "Permissions",
  "PermissionsGroup",
  "PermissionsGroupMemberQ",
  "PermissionsGroups",
  "PermissionsKey",
  "PermissionsKeys",
  "PermutationCycles",
  "PermutationCyclesQ",
  "PermutationGroup",
  "PermutationLength",
  "PermutationList",
  "PermutationListQ",
  "PermutationMatrix",
  "PermutationMax",
  "PermutationMin",
  "PermutationOrder",
  "PermutationPower",
  "PermutationProduct",
  "PermutationReplace",
  "Permutations",
  "PermutationSupport",
  "Permute",
  "PeronaMalikFilter",
  "Perpendicular",
  "PerpendicularBisector",
  "PersistenceLocation",
  "PersistenceTime",
  "PersistentObject",
  "PersistentObjects",
  "PersistentSymbol",
  "PersistentValue",
  "PersonData",
  "PERTDistribution",
  "PetersenGraph",
  "PhaseMargins",
  "PhaseRange",
  "PhongShading",
  "PhysicalSystemData",
  "Pi",
  "Pick",
  "PickedElements",
  "PickMode",
  "PIDData",
  "PIDDerivativeFilter",
  "PIDFeedforward",
  "PIDTune",
  "Piecewise",
  "PiecewiseExpand",
  "PieChart",
  "PieChart3D",
  "PillaiTrace",
  "PillaiTraceTest",
  "PingTime",
  "Pink",
  "PitchRecognize",
  "Pivoting",
  "PixelConstrained",
  "PixelValue",
  "PixelValuePositions",
  "Placed",
  "Placeholder",
  "PlaceholderLayer",
  "PlaceholderReplace",
  "Plain",
  "PlanarAngle",
  "PlanarFaceList",
  "PlanarGraph",
  "PlanarGraphQ",
  "PlanckRadiationLaw",
  "PlaneCurveData",
  "PlanetaryMoonData",
  "PlanetData",
  "PlantData",
  "Play",
  "PlaybackSettings",
  "PlayRange",
  "Plot",
  "Plot3D",
  "Plot3Matrix",
  "PlotDivision",
  "PlotJoined",
  "PlotLabel",
  "PlotLabels",
  "PlotLayout",
  "PlotLegends",
  "PlotMarkers",
  "PlotPoints",
  "PlotRange",
  "PlotRangeClipping",
  "PlotRangeClipPlanesStyle",
  "PlotRangePadding",
  "PlotRegion",
  "PlotStyle",
  "PlotTheme",
  "Pluralize",
  "Plus",
  "PlusMinus",
  "Pochhammer",
  "PodStates",
  "PodWidth",
  "Point",
  "Point3DBox",
  "Point3DBoxOptions",
  "PointBox",
  "PointBoxOptions",
  "PointCountDistribution",
  "PointDensity",
  "PointDensityFunction",
  "PointFigureChart",
  "PointLegend",
  "PointLight",
  "PointProcessEstimator",
  "PointProcessFitTest",
  "PointProcessParameterAssumptions",
  "PointProcessParameterQ",
  "PointSize",
  "PointStatisticFunction",
  "PointValuePlot",
  "PoissonConsulDistribution",
  "PoissonDistribution",
  "PoissonPDEComponent",
  "PoissonPointProcess",
  "PoissonProcess",
  "PoissonWindow",
  "PolarAxes",
  "PolarAxesOrigin",
  "PolarGridLines",
  "PolarPlot",
  "PolarTicks",
  "PoleZeroMarkers",
  "PolyaAeppliDistribution",
  "PolyGamma",
  "Polygon",
  "Polygon3DBox",
  "Polygon3DBoxOptions",
  "PolygonalNumber",
  "PolygonAngle",
  "PolygonBox",
  "PolygonBoxOptions",
  "PolygonCoordinates",
  "PolygonDecomposition",
  "PolygonHoleScale",
  "PolygonIntersections",
  "PolygonScale",
  "Polyhedron",
  "PolyhedronAngle",
  "PolyhedronBox",
  "PolyhedronBoxOptions",
  "PolyhedronCoordinates",
  "PolyhedronData",
  "PolyhedronDecomposition",
  "PolyhedronGenus",
  "PolyLog",
  "PolynomialExpressionQ",
  "PolynomialExtendedGCD",
  "PolynomialForm",
  "PolynomialGCD",
  "PolynomialLCM",
  "PolynomialMod",
  "PolynomialQ",
  "PolynomialQuotient",
  "PolynomialQuotientRemainder",
  "PolynomialReduce",
  "PolynomialRemainder",
  "Polynomials",
  "PolynomialSumOfSquaresList",
  "PoolingLayer",
  "PopupMenu",
  "PopupMenuBox",
  "PopupMenuBoxOptions",
  "PopupView",
  "PopupWindow",
  "Position",
  "PositionIndex",
  "PositionLargest",
  "PositionSmallest",
  "Positive",
  "PositiveDefiniteMatrixQ",
  "PositiveIntegers",
  "PositivelyOrientedPoints",
  "PositiveRationals",
  "PositiveReals",
  "PositiveSemidefiniteMatrixQ",
  "PossibleZeroQ",
  "Postfix",
  "PostScript",
  "Power",
  "PowerDistribution",
  "PowerExpand",
  "PowerMod",
  "PowerModList",
  "PowerRange",
  "PowerSpectralDensity",
  "PowersRepresentations",
  "PowerSymmetricPolynomial",
  "Precedence",
  "PrecedenceForm",
  "Precedes",
  "PrecedesEqual",
  "PrecedesSlantEqual",
  "PrecedesTilde",
  "Precision",
  "PrecisionGoal",
  "PreDecrement",
  "Predict",
  "PredictionRoot",
  "PredictorFunction",
  "PredictorInformation",
  "PredictorMeasurements",
  "PredictorMeasurementsObject",
  "PreemptProtect",
  "PreferencesPath",
  "PreferencesSettings",
  "Prefix",
  "PreIncrement",
  "Prepend",
  "PrependLayer",
  "PrependTo",
  "PreprocessingRules",
  "PreserveColor",
  "PreserveImageOptions",
  "Previous",
  "PreviousCell",
  "PreviousDate",
  "PriceGraphDistribution",
  "PrimaryPlaceholder",
  "Prime",
  "PrimeNu",
  "PrimeOmega",
  "PrimePi",
  "PrimePowerQ",
  "PrimeQ",
  "Primes",
  "PrimeZetaP",
  "PrimitivePolynomialQ",
  "PrimitiveRoot",
  "PrimitiveRootList",
  "PrincipalComponents",
  "PrincipalValue",
  "Print",
  "PrintableASCIIQ",
  "PrintAction",
  "PrintForm",
  "PrintingCopies",
  "PrintingOptions",
  "PrintingPageRange",
  "PrintingStartingPageNumber",
  "PrintingStyleEnvironment",
  "Printout3D",
  "Printout3DPreviewer",
  "PrintPrecision",
  "PrintTemporary",
  "Prism",
  "PrismBox",
  "PrismBoxOptions",
  "PrivateCellOptions",
  "PrivateEvaluationOptions",
  "PrivateFontOptions",
  "PrivateFrontEndOptions",
  "PrivateKey",
  "PrivateNotebookOptions",
  "PrivatePaths",
  "Probability",
  "ProbabilityDistribution",
  "ProbabilityPlot",
  "ProbabilityPr",
  "ProbabilityScalePlot",
  "ProbitModelFit",
  "ProcessConnection",
  "ProcessDirectory",
  "ProcessEnvironment",
  "Processes",
  "ProcessEstimator",
  "ProcessInformation",
  "ProcessObject",
  "ProcessParameterAssumptions",
  "ProcessParameterQ",
  "ProcessStateDomain",
  "ProcessStatus",
  "ProcessTimeDomain",
  "Product",
  "ProductDistribution",
  "ProductLog",
  "ProgressIndicator",
  "ProgressIndicatorBox",
  "ProgressIndicatorBoxOptions",
  "ProgressReporting",
  "Projection",
  "Prolog",
  "PromptForm",
  "ProofObject",
  "PropagateAborts",
  "Properties",
  "Property",
  "PropertyList",
  "PropertyValue",
  "Proportion",
  "Proportional",
  "Protect",
  "Protected",
  "ProteinData",
  "Pruning",
  "PseudoInverse",
  "PsychrometricPropertyData",
  "PublicKey",
  "PublisherID",
  "PulsarData",
  "PunctuationCharacter",
  "Purple",
  "Put",
  "PutAppend",
  "Pyramid",
  "PyramidBox",
  "PyramidBoxOptions",
  "QBinomial",
  "QFactorial",
  "QGamma",
  "QHypergeometricPFQ",
  "QnDispersion",
  "QPochhammer",
  "QPolyGamma",
  "QRDecomposition",
  "QuadraticIrrationalQ",
  "QuadraticOptimization",
  "Quantile",
  "QuantilePlot",
  "Quantity",
  "QuantityArray",
  "QuantityDistribution",
  "QuantityForm",
  "QuantityMagnitude",
  "QuantityQ",
  "QuantityUnit",
  "QuantityVariable",
  "QuantityVariableCanonicalUnit",
  "QuantityVariableDimensions",
  "QuantityVariableIdentifier",
  "QuantityVariablePhysicalQuantity",
  "Quartics",
  "QuartileDeviation",
  "Quartiles",
  "QuartileSkewness",
  "Query",
  "QuestionGenerator",
  "QuestionInterface",
  "QuestionObject",
  "QuestionSelector",
  "QueueingNetworkProcess",
  "QueueingProcess",
  "QueueProperties",
  "Quiet",
  "QuietEcho",
  "Quit",
  "Quotient",
  "QuotientRemainder",
  "RadialAxisPlot",
  "RadialGradientFilling",
  "RadialGradientImage",
  "RadialityCentrality",
  "RadicalBox",
  "RadicalBoxOptions",
  "RadioButton",
  "RadioButtonBar",
  "RadioButtonBox",
  "RadioButtonBoxOptions",
  "Radon",
  "RadonTransform",
  "RamanujanTau",
  "RamanujanTauL",
  "RamanujanTauTheta",
  "RamanujanTauZ",
  "Ramp",
  "Random",
  "RandomArrayLayer",
  "RandomChoice",
  "RandomColor",
  "RandomComplex",
  "RandomDate",
  "RandomEntity",
  "RandomFunction",
  "RandomGeneratorState",
  "RandomGeoPosition",
  "RandomGraph",
  "RandomImage",
  "RandomInstance",
  "RandomInteger",
  "RandomPermutation",
  "RandomPoint",
  "RandomPointConfiguration",
  "RandomPolygon",
  "RandomPolyhedron",
  "RandomPrime",
  "RandomReal",
  "RandomSample",
  "RandomSeed",
  "RandomSeeding",
  "RandomTime",
  "RandomTree",
  "RandomVariate",
  "RandomWalkProcess",
  "RandomWord",
  "Range",
  "RangeFilter",
  "RangeSpecification",
  "RankedMax",
  "RankedMin",
  "RarerProbability",
  "Raster",
  "Raster3D",
  "Raster3DBox",
  "Raster3DBoxOptions",
  "RasterArray",
  "RasterBox",
  "RasterBoxOptions",
  "Rasterize",
  "RasterSize",
  "Rational",
  "RationalExpressionQ",
  "RationalFunctions",
  "Rationalize",
  "Rationals",
  "Ratios",
  "RawArray",
  "RawBoxes",
  "RawData",
  "RawMedium",
  "RayleighDistribution",
  "Re",
  "ReactionBalance",
  "ReactionBalancedQ",
  "ReactionPDETerm",
  "Read",
  "ReadByteArray",
  "ReadLine",
  "ReadList",
  "ReadProtected",
  "ReadString",
  "Real",
  "RealAbs",
  "RealBlockDiagonalForm",
  "RealDigits",
  "RealExponent",
  "Reals",
  "RealSign",
  "Reap",
  "RebuildPacletData",
  "RecalibrationFunction",
  "RecognitionPrior",
  "RecognitionThreshold",
  "ReconstructionMesh",
  "Record",
  "RecordLists",
  "RecordSeparators",
  "Rectangle",
  "RectangleBox",
  "RectangleBoxOptions",
  "RectangleChart",
  "RectangleChart3D",
  "RectangularRepeatingElement",
  "RecurrenceFilter",
  "RecurrenceTable",
  "RecurringDigitsForm",
  "Red",
  "Reduce",
  "RefBox",
  "ReferenceLineStyle",
  "ReferenceMarkers",
  "ReferenceMarkerStyle",
  "Refine",
  "ReflectionMatrix",
  "ReflectionTransform",
  "Refresh",
  "RefreshRate",
  "Region",
  "RegionBinarize",
  "RegionBoundary",
  "RegionBoundaryStyle",
  "RegionBounds",
  "RegionCentroid",
  "RegionCongruent",
  "RegionConvert",
  "RegionDifference",
  "RegionDilation",
  "RegionDimension",
  "RegionDisjoint",
  "RegionDistance",
  "RegionDistanceFunction",
  "RegionEmbeddingDimension",
  "RegionEqual",
  "RegionErosion",
  "RegionFillingStyle",
  "RegionFit",
  "RegionFunction",
  "RegionImage",
  "RegionIntersection",
  "RegionMeasure",
  "RegionMember",
  "RegionMemberFunction",
  "RegionMoment",
  "RegionNearest",
  "RegionNearestFunction",
  "RegionPlot",
  "RegionPlot3D",
  "RegionProduct",
  "RegionQ",
  "RegionResize",
  "RegionSimilar",
  "RegionSize",
  "RegionSymmetricDifference",
  "RegionUnion",
  "RegionWithin",
  "RegisterExternalEvaluator",
  "RegularExpression",
  "Regularization",
  "RegularlySampledQ",
  "RegularPolygon",
  "ReIm",
  "ReImLabels",
  "ReImPlot",
  "ReImStyle",
  "Reinstall",
  "RelationalDatabase",
  "RelationGraph",
  "Release",
  "ReleaseHold",
  "ReliabilityDistribution",
  "ReliefImage",
  "ReliefPlot",
  "RemoteAuthorizationCaching",
  "RemoteBatchJobAbort",
  "RemoteBatchJobObject",
  "RemoteBatchJobs",
  "RemoteBatchMapSubmit",
  "RemoteBatchSubmissionEnvironment",
  "RemoteBatchSubmit",
  "RemoteConnect",
  "RemoteConnectionObject",
  "RemoteEvaluate",
  "RemoteFile",
  "RemoteInputFiles",
  "RemoteKernelObject",
  "RemoteProviderSettings",
  "RemoteRun",
  "RemoteRunProcess",
  "RemovalConditions",
  "Remove",
  "RemoveAlphaChannel",
  "RemoveAsynchronousTask",
  "RemoveAudioStream",
  "RemoveBackground",
  "RemoveChannelListener",
  "RemoveChannelSubscribers",
  "Removed",
  "RemoveDiacritics",
  "RemoveInputStreamMethod",
  "RemoveOutputStreamMethod",
  "RemoveProperty",
  "RemoveScheduledTask",
  "RemoveUsers",
  "RemoveVideoStream",
  "RenameDirectory",
  "RenameFile",
  "RenderAll",
  "RenderingOptions",
  "RenewalProcess",
  "RenkoChart",
  "RepairMesh",
  "Repeated",
  "RepeatedNull",
  "RepeatedString",
  "RepeatedTiming",
  "RepeatingElement",
  "Replace",
  "ReplaceAll",
  "ReplaceAt",
  "ReplaceHeldPart",
  "ReplaceImageValue",
  "ReplaceList",
  "ReplacePart",
  "ReplacePixelValue",
  "ReplaceRepeated",
  "ReplicateLayer",
  "RequiredPhysicalQuantities",
  "Resampling",
  "ResamplingAlgorithmData",
  "ResamplingMethod",
  "Rescale",
  "RescalingTransform",
  "ResetDirectory",
  "ResetScheduledTask",
  "ReshapeLayer",
  "Residue",
  "ResidueSum",
  "ResizeLayer",
  "Resolve",
  "ResolveContextAliases",
  "ResourceAcquire",
  "ResourceData",
  "ResourceFunction",
  "ResourceObject",
  "ResourceRegister",
  "ResourceRemove",
  "ResourceSearch",
  "ResourceSubmissionObject",
  "ResourceSubmit",
  "ResourceSystemBase",
  "ResourceSystemPath",
  "ResourceUpdate",
  "ResourceVersion",
  "ResponseForm",
  "Rest",
  "RestartInterval",
  "Restricted",
  "Resultant",
  "ResumePacket",
  "Return",
  "ReturnCreatesNewCell",
  "ReturnEntersInput",
  "ReturnExpressionPacket",
  "ReturnInputFormPacket",
  "ReturnPacket",
  "ReturnReceiptFunction",
  "ReturnTextPacket",
  "Reverse",
  "ReverseApplied",
  "ReverseBiorthogonalSplineWavelet",
  "ReverseElement",
  "ReverseEquilibrium",
  "ReverseGraph",
  "ReverseSort",
  "ReverseSortBy",
  "ReverseUpEquilibrium",
  "RevolutionAxis",
  "RevolutionPlot3D",
  "RGBColor",
  "RiccatiSolve",
  "RiceDistribution",
  "RidgeFilter",
  "RiemannR",
  "RiemannSiegelTheta",
  "RiemannSiegelZ",
  "RiemannXi",
  "Riffle",
  "Right",
  "RightArrow",
  "RightArrowBar",
  "RightArrowLeftArrow",
  "RightComposition",
  "RightCosetRepresentative",
  "RightDownTeeVector",
  "RightDownVector",
  "RightDownVectorBar",
  "RightTee",
  "RightTeeArrow",
  "RightTeeVector",
  "RightTriangle",
  "RightTriangleBar",
  "RightTriangleEqual",
  "RightUpDownVector",
  "RightUpTeeVector",
  "RightUpVector",
  "RightUpVectorBar",
  "RightVector",
  "RightVectorBar",
  "RipleyK",
  "RipleyRassonRegion",
  "RiskAchievementImportance",
  "RiskReductionImportance",
  "RobustConvexOptimization",
  "RogersTanimotoDissimilarity",
  "RollPitchYawAngles",
  "RollPitchYawMatrix",
  "RomanNumeral",
  "Root",
  "RootApproximant",
  "RootIntervals",
  "RootLocusPlot",
  "RootMeanSquare",
  "RootOfUnityQ",
  "RootReduce",
  "Roots",
  "RootSum",
  "RootTree",
  "Rotate",
  "RotateLabel",
  "RotateLeft",
  "RotateRight",
  "RotationAction",
  "RotationBox",
  "RotationBoxOptions",
  "RotationMatrix",
  "RotationTransform",
  "Round",
  "RoundImplies",
  "RoundingRadius",
  "Row",
  "RowAlignments",
  "RowBackgrounds",
  "RowBox",
  "RowHeights",
  "RowLines",
  "RowMinHeight",
  "RowReduce",
  "RowsEqual",
  "RowSpacings",
  "RSolve",
  "RSolveValue",
  "RudinShapiro",
  "RudvalisGroupRu",
  "Rule",
  "RuleCondition",
  "RuleDelayed",
  "RuleForm",
  "RulePlot",
  "RulerUnits",
  "RulesTree",
  "Run",
  "RunProcess",
  "RunScheduledTask",
  "RunThrough",
  "RuntimeAttributes",
  "RuntimeOptions",
  "RussellRaoDissimilarity",
  "SameAs",
  "SameQ",
  "SameTest",
  "SameTestProperties",
  "SampledEntityClass",
  "SampleDepth",
  "SampledSoundFunction",
  "SampledSoundList",
  "SampleRate",
  "SamplingPeriod",
  "SARIMAProcess",
  "SARMAProcess",
  "SASTriangle",
  "SatelliteData",
  "SatisfiabilityCount",
  "SatisfiabilityInstances",
  "SatisfiableQ",
  "Saturday",
  "Save",
  "Saveable",
  "SaveAutoDelete",
  "SaveConnection",
  "SaveDefinitions",
  "SavitzkyGolayMatrix",
  "SawtoothWave",
  "Scale",
  "Scaled",
  "ScaleDivisions",
  "ScaledMousePosition",
  "ScaleOrigin",
  "ScalePadding",
  "ScaleRanges",
  "ScaleRangeStyle",
  "ScalingFunctions",
  "ScalingMatrix",
  "ScalingTransform",
  "Scan",
  "ScheduledTask",
  "ScheduledTaskActiveQ",
  "ScheduledTaskInformation",
  "ScheduledTaskInformationData",
  "ScheduledTaskObject",
  "ScheduledTasks",
  "SchurDecomposition",
  "ScientificForm",
  "ScientificNotationThreshold",
  "ScorerGi",
  "ScorerGiPrime",
  "ScorerHi",
  "ScorerHiPrime",
  "ScreenRectangle",
  "ScreenStyleEnvironment",
  "ScriptBaselineShifts",
  "ScriptForm",
  "ScriptLevel",
  "ScriptMinSize",
  "ScriptRules",
  "ScriptSizeMultipliers",
  "Scrollbars",
  "ScrollingOptions",
  "ScrollPosition",
  "SearchAdjustment",
  "SearchIndexObject",
  "SearchIndices",
  "SearchQueryString",
  "SearchResultObject",
  "Sec",
  "Sech",
  "SechDistribution",
  "SecondOrderConeOptimization",
  "SectionGrouping",
  "SectorChart",
  "SectorChart3D",
  "SectorOrigin",
  "SectorSpacing",
  "SecuredAuthenticationKey",
  "SecuredAuthenticationKeys",
  "SecurityCertificate",
  "SeedRandom",
  "Select",
  "Selectable",
  "SelectComponents",
  "SelectedCells",
  "SelectedNotebook",
  "SelectFirst",
  "Selection",
  "SelectionAnimate",
  "SelectionCell",
  "SelectionCellCreateCell",
  "SelectionCellDefaultStyle",
  "SelectionCellParentStyle",
  "SelectionCreateCell",
  "SelectionDebuggerTag",
  "SelectionEvaluate",
  "SelectionEvaluateCreateCell",
  "SelectionMove",
  "SelectionPlaceholder",
  "SelectWithContents",
  "SelfLoops",
  "SelfLoopStyle",
  "SemanticImport",
  "SemanticImportString",
  "SemanticInterpretation",
  "SemialgebraicComponentInstances",
  "SemidefiniteOptimization",
  "SendMail",
  "SendMessage",
  "Sequence",
  "SequenceAlignment",
  "SequenceAttentionLayer",
  "SequenceCases",
  "SequenceCount",
  "SequenceFold",
  "SequenceFoldList",
  "SequenceForm",
  "SequenceHold",
  "SequenceIndicesLayer",
  "SequenceLastLayer",
  "SequenceMostLayer",
  "SequencePosition",
  "SequencePredict",
  "SequencePredictorFunction",
  "SequenceReplace",
  "SequenceRestLayer",
  "SequenceReverseLayer",
  "SequenceSplit",
  "Series",
  "SeriesCoefficient",
  "SeriesData",
  "SeriesTermGoal",
  "ServiceConnect",
  "ServiceDisconnect",
  "ServiceExecute",
  "ServiceObject",
  "ServiceRequest",
  "ServiceResponse",
  "ServiceSubmit",
  "SessionSubmit",
  "SessionTime",
  "Set",
  "SetAccuracy",
  "SetAlphaChannel",
  "SetAttributes",
  "Setbacks",
  "SetCloudDirectory",
  "SetCookies",
  "SetDelayed",
  "SetDirectory",
  "SetEnvironment",
  "SetFileDate",
  "SetFileFormatProperties",
  "SetOptions",
  "SetOptionsPacket",
  "SetPermissions",
  "SetPrecision",
  "SetProperty",
  "SetSecuredAuthenticationKey",
  "SetSelectedNotebook",
  "SetSharedFunction",
  "SetSharedVariable",
  "SetStreamPosition",
  "SetSystemModel",
  "SetSystemOptions",
  "Setter",
  "SetterBar",
  "SetterBox",
  "SetterBoxOptions",
  "Setting",
  "SetUsers",
  "Shading",
  "Shallow",
  "ShannonWavelet",
  "ShapiroWilkTest",
  "Share",
  "SharingList",
  "Sharpen",
  "ShearingMatrix",
  "ShearingTransform",
  "ShellRegion",
  "ShenCastanMatrix",
  "ShiftedGompertzDistribution",
  "ShiftRegisterSequence",
  "Short",
  "ShortDownArrow",
  "Shortest",
  "ShortestMatch",
  "ShortestPathFunction",
  "ShortLeftArrow",
  "ShortRightArrow",
  "ShortTimeFourier",
  "ShortTimeFourierData",
  "ShortUpArrow",
  "Show",
  "ShowAutoConvert",
  "ShowAutoSpellCheck",
  "ShowAutoStyles",
  "ShowCellBracket",
  "ShowCellLabel",
  "ShowCellTags",
  "ShowClosedCellArea",
  "ShowCodeAssist",
  "ShowContents",
  "ShowControls",
  "ShowCursorTracker",
  "ShowGroupOpenCloseIcon",
  "ShowGroupOpener",
  "ShowInvisibleCharacters",
  "ShowPageBreaks",
  "ShowPredictiveInterface",
  "ShowSelection",
  "ShowShortBoxForm",
  "ShowSpecialCharacters",
  "ShowStringCharacters",
  "ShowSyntaxStyles",
  "ShrinkingDelay",
  "ShrinkWrapBoundingBox",
  "SiderealTime",
  "SiegelTheta",
  "SiegelTukeyTest",
  "SierpinskiCurve",
  "SierpinskiMesh",
  "Sign",
  "Signature",
  "SignedRankTest",
  "SignedRegionDistance",
  "SignificanceLevel",
  "SignPadding",
  "SignTest",
  "SimilarityRules",
  "SimpleGraph",
  "SimpleGraphQ",
  "SimplePolygonQ",
  "SimplePolyhedronQ",
  "Simplex",
  "Simplify",
  "Sin",
  "Sinc",
  "SinghMaddalaDistribution",
  "SingleEvaluation",
  "SingleLetterItalics",
  "SingleLetterStyle",
  "SingularValueDecomposition",
  "SingularValueList",
  "SingularValuePlot",
  "SingularValues",
  "Sinh",
  "SinhIntegral",
  "SinIntegral",
  "SixJSymbol",
  "Skeleton",
  "SkeletonTransform",
  "SkellamDistribution",
  "Skewness",
  "SkewNormalDistribution",
  "SkinStyle",
  "Skip",
  "SliceContourPlot3D",
  "SliceDensityPlot3D",
  "SliceDistribution",
  "SliceVectorPlot3D",
  "Slider",
  "Slider2D",
  "Slider2DBox",
  "Slider2DBoxOptions",
  "SliderBox",
  "SliderBoxOptions",
  "SlideShowVideo",
  "SlideView",
  "Slot",
  "SlotSequence",
  "Small",
  "SmallCircle",
  "Smaller",
  "SmithDecomposition",
  "SmithDelayCompensator",
  "SmithWatermanSimilarity",
  "SmoothDensityHistogram",
  "SmoothHistogram",
  "SmoothHistogram3D",
  "SmoothKernelDistribution",
  "SmoothPointDensity",
  "SnDispersion",
  "Snippet",
  "SnippetsVideo",
  "SnubPolyhedron",
  "SocialMediaData",
  "Socket",
  "SocketConnect",
  "SocketListen",
  "SocketListener",
  "SocketObject",
  "SocketOpen",
  "SocketReadMessage",
  "SocketReadyQ",
  "Sockets",
  "SocketWaitAll",
  "SocketWaitNext",
  "SoftmaxLayer",
  "SokalSneathDissimilarity",
  "SolarEclipse",
  "SolarSystemFeatureData",
  "SolarTime",
  "SolidAngle",
  "SolidBoundaryLoadValue",
  "SolidData",
  "SolidDisplacementCondition",
  "SolidFixedCondition",
  "SolidMechanicsPDEComponent",
  "SolidMechanicsStrain",
  "SolidMechanicsStress",
  "SolidRegionQ",
  "Solve",
  "SolveAlways",
  "SolveDelayed",
  "SolveValues",
  "Sort",
  "SortBy",
  "SortedBy",
  "SortedEntityClass",
  "Sound",
  "SoundAndGraphics",
  "SoundNote",
  "SoundVolume",
  "SourceLink",
  "SourcePDETerm",
  "Sow",
  "Space",
  "SpaceCurveData",
  "SpaceForm",
  "Spacer",
  "Spacings",
  "Span",
  "SpanAdjustments",
  "SpanCharacterRounding",
  "SpanFromAbove",
  "SpanFromBoth",
  "SpanFromLeft",
  "SpanLineThickness",
  "SpanMaxSize",
  "SpanMinSize",
  "SpanningCharacters",
  "SpanSymmetric",
  "SparseArray",
  "SparseArrayQ",
  "SpatialBinnedPointData",
  "SpatialBoundaryCorrection",
  "SpatialEstimate",
  "SpatialEstimatorFunction",
  "SpatialGraphDistribution",
  "SpatialJ",
  "SpatialMedian",
  "SpatialNoiseLevel",
  "SpatialObservationRegionQ",
  "SpatialPointData",
  "SpatialPointSelect",
  "SpatialRandomnessTest",
  "SpatialTransformationLayer",
  "SpatialTrendFunction",
  "Speak",
  "SpeakerMatchQ",
  "SpearmanRankTest",
  "SpearmanRho",
  "SpeciesData",
  "SpecificityGoal",
  "SpectralLineData",
  "Spectrogram",
  "SpectrogramArray",
  "Specularity",
  "SpeechCases",
  "SpeechInterpreter",
  "SpeechRecognize",
  "SpeechSynthesize",
  "SpellingCorrection",
  "SpellingCorrectionList",
  "SpellingDictionaries",
  "SpellingDictionariesPath",
  "SpellingOptions",
  "Sphere",
  "SphereBox",
  "SphereBoxOptions",
  "SpherePoints",
  "SphericalBesselJ",
  "SphericalBesselY",
  "SphericalHankelH1",
  "SphericalHankelH2",
  "SphericalHarmonicY",
  "SphericalPlot3D",
  "SphericalRegion",
  "SphericalShell",
  "SpheroidalEigenvalue",
  "SpheroidalJoiningFactor",
  "SpheroidalPS",
  "SpheroidalPSPrime",
  "SpheroidalQS",
  "SpheroidalQSPrime",
  "SpheroidalRadialFactor",
  "SpheroidalS1",
  "SpheroidalS1Prime",
  "SpheroidalS2",
  "SpheroidalS2Prime",
  "Splice",
  "SplicedDistribution",
  "SplineClosed",
  "SplineDegree",
  "SplineKnots",
  "SplineWeights",
  "Split",
  "SplitBy",
  "SpokenString",
  "SpotLight",
  "Sqrt",
  "SqrtBox",
  "SqrtBoxOptions",
  "Square",
  "SquaredEuclideanDistance",
  "SquareFreeQ",
  "SquareIntersection",
  "SquareMatrixQ",
  "SquareRepeatingElement",
  "SquaresR",
  "SquareSubset",
  "SquareSubsetEqual",
  "SquareSuperset",
  "SquareSupersetEqual",
  "SquareUnion",
  "SquareWave",
  "SSSTriangle",
  "StabilityMargins",
  "StabilityMarginsStyle",
  "StableDistribution",
  "Stack",
  "StackBegin",
  "StackComplete",
  "StackedDateListPlot",
  "StackedListPlot",
  "StackInhibit",
  "StadiumShape",
  "StandardAtmosphereData",
  "StandardDeviation",
  "StandardDeviationFilter",
  "StandardForm",
  "Standardize",
  "Standardized",
  "StandardOceanData",
  "StandbyDistribution",
  "Star",
  "StarClusterData",
  "StarData",
  "StarGraph",
  "StartAsynchronousTask",
  "StartExternalSession",
  "StartingStepSize",
  "StartOfLine",
  "StartOfString",
  "StartProcess",
  "StartScheduledTask",
  "StartupSound",
  "StartWebSession",
  "StateDimensions",
  "StateFeedbackGains",
  "StateOutputEstimator",
  "StateResponse",
  "StateSpaceModel",
  "StateSpaceRealization",
  "StateSpaceTransform",
  "StateTransformationLinearize",
  "StationaryDistribution",
  "StationaryWaveletPacketTransform",
  "StationaryWaveletTransform",
  "StatusArea",
  "StatusCentrality",
  "StepMonitor",
  "StereochemistryElements",
  "StieltjesGamma",
  "StippleShading",
  "StirlingS1",
  "StirlingS2",
  "StopAsynchronousTask",
  "StoppingPowerData",
  "StopScheduledTask",
  "StrataVariables",
  "StratonovichProcess",
  "StraussHardcorePointProcess",
  "StraussPointProcess",
  "StreamColorFunction",
  "StreamColorFunctionScaling",
  "StreamDensityPlot",
  "StreamMarkers",
  "StreamPlot",
  "StreamPlot3D",
  "StreamPoints",
  "StreamPosition",
  "Streams",
  "StreamScale",
  "StreamStyle",
  "StrictInequalities",
  "String",
  "StringBreak",
  "StringByteCount",
  "StringCases",
  "StringContainsQ",
  "StringCount",
  "StringDelete",
  "StringDrop",
  "StringEndsQ",
  "StringExpression",
  "StringExtract",
  "StringForm",
  "StringFormat",
  "StringFormatQ",
  "StringFreeQ",
  "StringInsert",
  "StringJoin",
  "StringLength",
  "StringMatchQ",
  "StringPadLeft",
  "StringPadRight",
  "StringPart",
  "StringPartition",
  "StringPosition",
  "StringQ",
  "StringRepeat",
  "StringReplace",
  "StringReplaceList",
  "StringReplacePart",
  "StringReverse",
  "StringRiffle",
  "StringRotateLeft",
  "StringRotateRight",
  "StringSkeleton",
  "StringSplit",
  "StringStartsQ",
  "StringTake",
  "StringTakeDrop",
  "StringTemplate",
  "StringToByteArray",
  "StringToStream",
  "StringTrim",
  "StripBoxes",
  "StripOnInput",
  "StripStyleOnPaste",
  "StripWrapperBoxes",
  "StrokeForm",
  "Struckthrough",
  "StructuralImportance",
  "StructuredArray",
  "StructuredArrayHeadQ",
  "StructuredSelection",
  "StruveH",
  "StruveL",
  "Stub",
  "StudentTDistribution",
  "Style",
  "StyleBox",
  "StyleBoxAutoDelete",
  "StyleData",
  "StyleDefinitions",
  "StyleForm",
  "StyleHints",
  "StyleKeyMapping",
  "StyleMenuListing",
  "StyleNameDialogSettings",
  "StyleNames",
  "StylePrint",
  "StyleSheetPath",
  "Subdivide",
  "Subfactorial",
  "Subgraph",
  "SubMinus",
  "SubPlus",
  "SubresultantPolynomialRemainders",
  "SubresultantPolynomials",
  "Subresultants",
  "Subscript",
  "SubscriptBox",
  "SubscriptBoxOptions",
  "Subscripted",
  "Subsequences",
  "Subset",
  "SubsetCases",
  "SubsetCount",
  "SubsetEqual",
  "SubsetMap",
  "SubsetPosition",
  "SubsetQ",
  "SubsetReplace",
  "Subsets",
  "SubStar",
  "SubstitutionSystem",
  "Subsuperscript",
  "SubsuperscriptBox",
  "SubsuperscriptBoxOptions",
  "SubtitleEncoding",
  "SubtitleTrackSelection",
  "Subtract",
  "SubtractFrom",
  "SubtractSides",
  "SubValues",
  "Succeeds",
  "SucceedsEqual",
  "SucceedsSlantEqual",
  "SucceedsTilde",
  "Success",
  "SuchThat",
  "Sum",
  "SumConvergence",
  "SummationLayer",
  "Sunday",
  "SunPosition",
  "Sunrise",
  "Sunset",
  "SuperDagger",
  "SuperMinus",
  "SupernovaData",
  "SuperPlus",
  "Superscript",
  "SuperscriptBox",
  "SuperscriptBoxOptions",
  "Superset",
  "SupersetEqual",
  "SuperStar",
  "Surd",
  "SurdForm",
  "SurfaceAppearance",
  "SurfaceArea",
  "SurfaceColor",
  "SurfaceData",
  "SurfaceGraphics",
  "SurvivalDistribution",
  "SurvivalFunction",
  "SurvivalModel",
  "SurvivalModelFit",
  "SuspendPacket",
  "SuzukiDistribution",
  "SuzukiGroupSuz",
  "SwatchLegend",
  "Switch",
  "Symbol",
  "SymbolName",
  "SymletWavelet",
  "Symmetric",
  "SymmetricDifference",
  "SymmetricGroup",
  "SymmetricKey",
  "SymmetricMatrixQ",
  "SymmetricPolynomial",
  "SymmetricReduction",
  "Symmetrize",
  "SymmetrizedArray",
  "SymmetrizedArrayRules",
  "SymmetrizedDependentComponents",
  "SymmetrizedIndependentComponents",
  "SymmetrizedReplacePart",
  "SynchronousInitialization",
  "SynchronousUpdating",
  "Synonyms",
  "Syntax",
  "SyntaxForm",
  "SyntaxInformation",
  "SyntaxLength",
  "SyntaxPacket",
  "SyntaxQ",
  "SynthesizeMissingValues",
  "SystemCredential",
  "SystemCredentialData",
  "SystemCredentialKey",
  "SystemCredentialKeys",
  "SystemCredentialStoreObject",
  "SystemDialogInput",
  "SystemException",
  "SystemGet",
  "SystemHelpPath",
  "SystemInformation",
  "SystemInformationData",
  "SystemInstall",
  "SystemModel",
  "SystemModeler",
  "SystemModelExamples",
  "SystemModelLinearize",
  "SystemModelMeasurements",
  "SystemModelParametricSimulate",
  "SystemModelPlot",
  "SystemModelProgressReporting",
  "SystemModelReliability",
  "SystemModels",
  "SystemModelSimulate",
  "SystemModelSimulateSensitivity",
  "SystemModelSimulationData",
  "SystemOpen",
  "SystemOptions",
  "SystemProcessData",
  "SystemProcesses",
  "SystemsConnectionsModel",
  "SystemsModelControllerData",
  "SystemsModelDelay",
  "SystemsModelDelayApproximate",
  "SystemsModelDelete",
  "SystemsModelDimensions",
  "SystemsModelExtract",
  "SystemsModelFeedbackConnect",
  "SystemsModelLabels",
  "SystemsModelLinearity",
  "SystemsModelMerge",
  "SystemsModelOrder",
  "SystemsModelParallelConnect",
  "SystemsModelSeriesConnect",
  "SystemsModelStateFeedbackConnect",
  "SystemsModelVectorRelativeOrders",
  "SystemStub",
  "SystemTest",
  "Tab",
  "TabFilling",
  "Table",
  "TableAlignments",
  "TableDepth",
  "TableDirections",
  "TableForm",
  "TableHeadings",
  "TableSpacing",
  "TableView",
  "TableViewBox",
  "TableViewBoxAlignment",
  "TableViewBoxBackground",
  "TableViewBoxHeaders",
  "TableViewBoxItemSize",
  "TableViewBoxItemStyle",
  "TableViewBoxOptions",
  "TabSpacings",
  "TabView",
  "TabViewBox",
  "TabViewBoxOptions",
  "TagBox",
  "TagBoxNote",
  "TagBoxOptions",
  "TaggingRules",
  "TagSet",
  "TagSetDelayed",
  "TagStyle",
  "TagUnset",
  "Take",
  "TakeDrop",
  "TakeLargest",
  "TakeLargestBy",
  "TakeList",
  "TakeSmallest",
  "TakeSmallestBy",
  "TakeWhile",
  "Tally",
  "Tan",
  "Tanh",
  "TargetDevice",
  "TargetFunctions",
  "TargetSystem",
  "TargetUnits",
  "TaskAbort",
  "TaskExecute",
  "TaskObject",
  "TaskRemove",
  "TaskResume",
  "Tasks",
  "TaskSuspend",
  "TaskWait",
  "TautologyQ",
  "TelegraphProcess",
  "TemplateApply",
  "TemplateArgBox",
  "TemplateBox",
  "TemplateBoxOptions",
  "TemplateEvaluate",
  "TemplateExpression",
  "TemplateIf",
  "TemplateObject",
  "TemplateSequence",
  "TemplateSlot",
  "TemplateSlotSequence",
  "TemplateUnevaluated",
  "TemplateVerbatim",
  "TemplateWith",
  "TemporalData",
  "TemporalRegularity",
  "Temporary",
  "TemporaryVariable",
  "TensorContract",
  "TensorDimensions",
  "TensorExpand",
  "TensorProduct",
  "TensorQ",
  "TensorRank",
  "TensorReduce",
  "TensorSymmetry",
  "TensorTranspose",
  "TensorWedge",
  "TerminatedEvaluation",
  "TernaryListPlot",
  "TernaryPlotCorners",
  "TestID",
  "TestReport",
  "TestReportObject",
  "TestResultObject",
  "Tetrahedron",
  "TetrahedronBox",
  "TetrahedronBoxOptions",
  "TeXForm",
  "TeXSave",
  "Text",
  "Text3DBox",
  "Text3DBoxOptions",
  "TextAlignment",
  "TextBand",
  "TextBoundingBox",
  "TextBox",
  "TextCases",
  "TextCell",
  "TextClipboardType",
  "TextContents",
  "TextData",
  "TextElement",
  "TextForm",
  "TextGrid",
  "TextJustification",
  "TextLine",
  "TextPacket",
  "TextParagraph",
  "TextPosition",
  "TextRecognize",
  "TextSearch",
  "TextSearchReport",
  "TextSentences",
  "TextString",
  "TextStructure",
  "TextStyle",
  "TextTranslation",
  "Texture",
  "TextureCoordinateFunction",
  "TextureCoordinateScaling",
  "TextWords",
  "Therefore",
  "ThermodynamicData",
  "ThermometerGauge",
  "Thick",
  "Thickness",
  "Thin",
  "Thinning",
  "ThisLink",
  "ThomasPointProcess",
  "ThompsonGroupTh",
  "Thread",
  "Threaded",
  "ThreadingLayer",
  "ThreeJSymbol",
  "Threshold",
  "Through",
  "Throw",
  "ThueMorse",
  "Thumbnail",
  "Thursday",
  "TickDirection",
  "TickLabelOrientation",
  "TickLabelPositioning",
  "TickLabels",
  "TickLengths",
  "TickPositions",
  "Ticks",
  "TicksStyle",
  "TideData",
  "Tilde",
  "TildeEqual",
  "TildeFullEqual",
  "TildeTilde",
  "TimeConstrained",
  "TimeConstraint",
  "TimeDirection",
  "TimeFormat",
  "TimeGoal",
  "TimelinePlot",
  "TimeObject",
  "TimeObjectQ",
  "TimeRemaining",
  "Times",
  "TimesBy",
  "TimeSeries",
  "TimeSeriesAggregate",
  "TimeSeriesForecast",
  "TimeSeriesInsert",
  "TimeSeriesInvertibility",
  "TimeSeriesMap",
  "TimeSeriesMapThread",
  "TimeSeriesModel",
  "TimeSeriesModelFit",
  "TimeSeriesResample",
  "TimeSeriesRescale",
  "TimeSeriesShift",
  "TimeSeriesThread",
  "TimeSeriesWindow",
  "TimeSystem",
  "TimeSystemConvert",
  "TimeUsed",
  "TimeValue",
  "TimeWarpingCorrespondence",
  "TimeWarpingDistance",
  "TimeZone",
  "TimeZoneConvert",
  "TimeZoneOffset",
  "Timing",
  "Tiny",
  "TitleGrouping",
  "TitsGroupT",
  "ToBoxes",
  "ToCharacterCode",
  "ToColor",
  "ToContinuousTimeModel",
  "ToDate",
  "Today",
  "ToDiscreteTimeModel",
  "ToEntity",
  "ToeplitzMatrix",
  "ToExpression",
  "ToFileName",
  "Together",
  "Toggle",
  "ToggleFalse",
  "Toggler",
  "TogglerBar",
  "TogglerBox",
  "TogglerBoxOptions",
  "ToHeldExpression",
  "ToInvertibleTimeSeries",
  "TokenWords",
  "Tolerance",
  "ToLowerCase",
  "Tomorrow",
  "ToNumberField",
  "TooBig",
  "Tooltip",
  "TooltipBox",
  "TooltipBoxOptions",
  "TooltipDelay",
  "TooltipStyle",
  "ToonShading",
  "Top",
  "TopHatTransform",
  "ToPolarCoordinates",
  "TopologicalSort",
  "ToRadicals",
  "ToRawPointer",
  "ToRules",
  "Torus",
  "TorusGraph",
  "ToSphericalCoordinates",
  "ToString",
  "Total",
  "TotalHeight",
  "TotalLayer",
  "TotalVariationFilter",
  "TotalWidth",
  "TouchPosition",
  "TouchscreenAutoZoom",
  "TouchscreenControlPlacement",
  "ToUpperCase",
  "TourVideo",
  "Tr",
  "Trace",
  "TraceAbove",
  "TraceAction",
  "TraceBackward",
  "TraceDepth",
  "TraceDialog",
  "TraceForward",
  "TraceInternal",
  "TraceLevel",
  "TraceOff",
  "TraceOn",
  "TraceOriginal",
  "TracePrint",
  "TraceScan",
  "TrackCellChangeTimes",
  "TrackedSymbols",
  "TrackingFunction",
  "TracyWidomDistribution",
  "TradingChart",
  "TraditionalForm",
  "TraditionalFunctionNotation",
  "TraditionalNotation",
  "TraditionalOrder",
  "TrainImageContentDetector",
  "TrainingProgressCheckpointing",
  "TrainingProgressFunction",
  "TrainingProgressMeasurements",
  "TrainingProgressReporting",
  "TrainingStoppingCriterion",
  "TrainingUpdateSchedule",
  "TrainTextContentDetector",
  "TransferFunctionCancel",
  "TransferFunctionExpand",
  "TransferFunctionFactor",
  "TransferFunctionModel",
  "TransferFunctionPoles",
  "TransferFunctionTransform",
  "TransferFunctionZeros",
  "TransformationClass",
  "TransformationFunction",
  "TransformationFunctions",
  "TransformationMatrix",
  "TransformedDistribution",
  "TransformedField",
  "TransformedProcess",
  "TransformedRegion",
  "TransitionDirection",
  "TransitionDuration",
  "TransitionEffect",
  "TransitiveClosureGraph",
  "TransitiveReductionGraph",
  "Translate",
  "TranslationOptions",
  "TranslationTransform",
  "Transliterate",
  "Transparent",
  "TransparentColor",
  "Transpose",
  "TransposeLayer",
  "TrapEnterKey",
  "TrapSelection",
  "TravelDirections",
  "TravelDirectionsData",
  "TravelDistance",
  "TravelDistanceList",
  "TravelMethod",
  "TravelTime",
  "Tree",
  "TreeCases",
  "TreeChildren",
  "TreeCount",
  "TreeData",
  "TreeDelete",
  "TreeDepth",
  "TreeElementCoordinates",
  "TreeElementLabel",
  "TreeElementLabelFunction",
  "TreeElementLabelStyle",
  "TreeElementShape",
  "TreeElementShapeFunction",
  "TreeElementSize",
  "TreeElementSizeFunction",
  "TreeElementStyle",
  "TreeElementStyleFunction",
  "TreeExpression",
  "TreeExtract",
  "TreeFold",
  "TreeForm",
  "TreeGraph",
  "TreeGraphQ",
  "TreeInsert",
  "TreeLayout",
  "TreeLeafCount",
  "TreeLeafQ",
  "TreeLeaves",
  "TreeLevel",
  "TreeMap",
  "TreeMapAt",
  "TreeOutline",
  "TreePlot",
  "TreePosition",
  "TreeQ",
  "TreeReplacePart",
  "TreeRules",
  "TreeScan",
  "TreeSelect",
  "TreeSize",
  "TreeTraversalOrder",
  "TrendStyle",
  "Triangle",
  "TriangleCenter",
  "TriangleConstruct",
  "TriangleMeasurement",
  "TriangleWave",
  "TriangularDistribution",
  "TriangulateMesh",
  "Trig",
  "TrigExpand",
  "TrigFactor",
  "TrigFactorList",
  "Trigger",
  "TrigReduce",
  "TrigToExp",
  "TrimmedMean",
  "TrimmedVariance",
  "TropicalStormData",
  "True",
  "TrueQ",
  "TruncatedDistribution",
  "TruncatedPolyhedron",
  "TsallisQExponentialDistribution",
  "TsallisQGaussianDistribution",
  "TTest",
  "Tube",
  "TubeBezierCurveBox",
  "TubeBezierCurveBoxOptions",
  "TubeBox",
  "TubeBoxOptions",
  "TubeBSplineCurveBox",
  "TubeBSplineCurveBoxOptions",
  "Tuesday",
  "TukeyLambdaDistribution",
  "TukeyWindow",
  "TunnelData",
  "Tuples",
  "TuranGraph",
  "TuringMachine",
  "TuttePolynomial",
  "TwoWayRule",
  "Typed",
  "TypeDeclaration",
  "TypeEvaluate",
  "TypeHint",
  "TypeOf",
  "TypeSpecifier",
  "UnateQ",
  "Uncompress",
  "UnconstrainedParameters",
  "Undefined",
  "UnderBar",
  "Underflow",
  "Underlined",
  "Underoverscript",
  "UnderoverscriptBox",
  "UnderoverscriptBoxOptions",
  "Underscript",
  "UnderscriptBox",
  "UnderscriptBoxOptions",
  "UnderseaFeatureData",
  "UndirectedEdge",
  "UndirectedGraph",
  "UndirectedGraphQ",
  "UndoOptions",
  "UndoTrackedVariables",
  "Unequal",
  "UnequalTo",
  "Unevaluated",
  "UniformDistribution",
  "UniformGraphDistribution",
  "UniformPolyhedron",
  "UniformSumDistribution",
  "Uninstall",
  "Union",
  "UnionedEntityClass",
  "UnionPlus",
  "Unique",
  "UniqueElements",
  "UnitaryMatrixQ",
  "UnitBox",
  "UnitConvert",
  "UnitDimensions",
  "Unitize",
  "UnitRootTest",
  "UnitSimplify",
  "UnitStep",
  "UnitSystem",
  "UnitTriangle",
  "UnitVector",
  "UnitVectorLayer",
  "UnityDimensions",
  "UniverseModelData",
  "UniversityData",
  "UnixTime",
  "UnlabeledTree",
  "UnmanageObject",
  "Unprotect",
  "UnregisterExternalEvaluator",
  "UnsameQ",
  "UnsavedVariables",
  "Unset",
  "UnsetShared",
  "Until",
  "UntrackedVariables",
  "Up",
  "UpArrow",
  "UpArrowBar",
  "UpArrowDownArrow",
  "Update",
  "UpdateDynamicObjects",
  "UpdateDynamicObjectsSynchronous",
  "UpdateInterval",
  "UpdatePacletSites",
  "UpdateSearchIndex",
  "UpDownArrow",
  "UpEquilibrium",
  "UpperCaseQ",
  "UpperLeftArrow",
  "UpperRightArrow",
  "UpperTriangularize",
  "UpperTriangularMatrix",
  "UpperTriangularMatrixQ",
  "Upsample",
  "UpSet",
  "UpSetDelayed",
  "UpTee",
  "UpTeeArrow",
  "UpTo",
  "UpValues",
  "URL",
  "URLBuild",
  "URLDecode",
  "URLDispatcher",
  "URLDownload",
  "URLDownloadSubmit",
  "URLEncode",
  "URLExecute",
  "URLExpand",
  "URLFetch",
  "URLFetchAsynchronous",
  "URLParse",
  "URLQueryDecode",
  "URLQueryEncode",
  "URLRead",
  "URLResponseTime",
  "URLSave",
  "URLSaveAsynchronous",
  "URLShorten",
  "URLSubmit",
  "UseEmbeddedLibrary",
  "UseGraphicsRange",
  "UserDefinedWavelet",
  "Using",
  "UsingFrontEnd",
  "UtilityFunction",
  "V2Get",
  "ValenceErrorHandling",
  "ValenceFilling",
  "ValidationLength",
  "ValidationSet",
  "ValueBox",
  "ValueBoxOptions",
  "ValueDimensions",
  "ValueForm",
  "ValuePreprocessingFunction",
  "ValueQ",
  "Values",
  "ValuesData",
  "VandermondeMatrix",
  "Variables",
  "Variance",
  "VarianceEquivalenceTest",
  "VarianceEstimatorFunction",
  "VarianceGammaDistribution",
  "VarianceGammaPointProcess",
  "VarianceTest",
  "VariogramFunction",
  "VariogramModel",
  "VectorAngle",
  "VectorAround",
  "VectorAspectRatio",
  "VectorColorFunction",
  "VectorColorFunctionScaling",
  "VectorDensityPlot",
  "VectorDisplacementPlot",
  "VectorDisplacementPlot3D",
  "VectorGlyphData",
  "VectorGreater",
  "VectorGreaterEqual",
  "VectorLess",
  "VectorLessEqual",
  "VectorMarkers",
  "VectorPlot",
  "VectorPlot3D",
  "VectorPoints",
  "VectorQ",
  "VectorRange",
  "Vectors",
  "VectorScale",
  "VectorScaling",
  "VectorSizes",
  "VectorStyle",
  "Vee",
  "Verbatim",
  "Verbose",
  "VerificationTest",
  "VerifyConvergence",
  "VerifyDerivedKey",
  "VerifyDigitalSignature",
  "VerifyFileSignature",
  "VerifyInterpretation",
  "VerifySecurityCertificates",
  "VerifySolutions",
  "VerifyTestAssumptions",
  "VersionedPreferences",
  "VertexAdd",
  "VertexCapacity",
  "VertexChromaticNumber",
  "VertexColors",
  "VertexComponent",
  "VertexConnectivity",
  "VertexContract",
  "VertexCoordinateRules",
  "VertexCoordinates",
  "VertexCorrelationSimilarity",
  "VertexCosineSimilarity",
  "VertexCount",
  "VertexCoverQ",
  "VertexDataCoordinates",
  "VertexDegree",
  "VertexDelete",
  "VertexDiceSimilarity",
  "VertexEccentricity",
  "VertexInComponent",
  "VertexInComponentGraph",
  "VertexInDegree",
  "VertexIndex",
  "VertexJaccardSimilarity",
  "VertexLabeling",
  "VertexLabels",
  "VertexLabelStyle",
  "VertexList",
  "VertexNormals",
  "VertexOutComponent",
  "VertexOutComponentGraph",
  "VertexOutDegree",
  "VertexQ",
  "VertexRenderingFunction",
  "VertexReplace",
  "VertexShape",
  "VertexShapeFunction",
  "VertexSize",
  "VertexStyle",
  "VertexTextureCoordinates",
  "VertexTransitiveGraphQ",
  "VertexWeight",
  "VertexWeightedGraphQ",
  "Vertical",
  "VerticalBar",
  "VerticalForm",
  "VerticalGauge",
  "VerticalSeparator",
  "VerticalSlider",
  "VerticalTilde",
  "Video",
  "VideoCapture",
  "VideoCombine",
  "VideoDelete",
  "VideoEncoding",
  "VideoExtractFrames",
  "VideoFrameList",
  "VideoFrameMap",
  "VideoGenerator",
  "VideoInsert",
  "VideoIntervals",
  "VideoJoin",
  "VideoMap",
  "VideoMapList",
  "VideoMapTimeSeries",
  "VideoPadding",
  "VideoPause",
  "VideoPlay",
  "VideoQ",
  "VideoRecord",
  "VideoReplace",
  "VideoScreenCapture",
  "VideoSplit",
  "VideoStop",
  "VideoStream",
  "VideoStreams",
  "VideoTimeStretch",
  "VideoTrackSelection",
  "VideoTranscode",
  "VideoTransparency",
  "VideoTrim",
  "ViewAngle",
  "ViewCenter",
  "ViewMatrix",
  "ViewPoint",
  "ViewPointSelectorSettings",
  "ViewPort",
  "ViewProjection",
  "ViewRange",
  "ViewVector",
  "ViewVertical",
  "VirtualGroupData",
  "Visible",
  "VisibleCell",
  "VoiceStyleData",
  "VoigtDistribution",
  "VolcanoData",
  "Volume",
  "VonMisesDistribution",
  "VoronoiMesh",
  "WaitAll",
  "WaitAsynchronousTask",
  "WaitNext",
  "WaitUntil",
  "WakebyDistribution",
  "WalleniusHypergeometricDistribution",
  "WaringYuleDistribution",
  "WarpingCorrespondence",
  "WarpingDistance",
  "WatershedComponents",
  "WatsonUSquareTest",
  "WattsStrogatzGraphDistribution",
  "WaveletBestBasis",
  "WaveletFilterCoefficients",
  "WaveletImagePlot",
  "WaveletListPlot",
  "WaveletMapIndexed",
  "WaveletMatrixPlot",
  "WaveletPhi",
  "WaveletPsi",
  "WaveletScale",
  "WaveletScalogram",
  "WaveletThreshold",
  "WavePDEComponent",
  "WeaklyConnectedComponents",
  "WeaklyConnectedGraphComponents",
  "WeaklyConnectedGraphQ",
  "WeakStationarity",
  "WeatherData",
  "WeatherForecastData",
  "WebAudioSearch",
  "WebColumn",
  "WebElementObject",
  "WeberE",
  "WebExecute",
  "WebImage",
  "WebImageSearch",
  "WebItem",
  "WebPageMetaInformation",
  "WebRow",
  "WebSearch",
  "WebSessionObject",
  "WebSessions",
  "WebWindowObject",
  "Wedge",
  "Wednesday",
  "WeibullDistribution",
  "WeierstrassE1",
  "WeierstrassE2",
  "WeierstrassE3",
  "WeierstrassEta1",
  "WeierstrassEta2",
  "WeierstrassEta3",
  "WeierstrassHalfPeriods",
  "WeierstrassHalfPeriodW1",
  "WeierstrassHalfPeriodW2",
  "WeierstrassHalfPeriodW3",
  "WeierstrassInvariantG2",
  "WeierstrassInvariantG3",
  "WeierstrassInvariants",
  "WeierstrassP",
  "WeierstrassPPrime",
  "WeierstrassSigma",
  "WeierstrassZeta",
  "WeightedAdjacencyGraph",
  "WeightedAdjacencyMatrix",
  "WeightedData",
  "WeightedGraphQ",
  "Weights",
  "WelchWindow",
  "WheelGraph",
  "WhenEvent",
  "Which",
  "While",
  "White",
  "WhiteNoiseProcess",
  "WhitePoint",
  "Whitespace",
  "WhitespaceCharacter",
  "WhittakerM",
  "WhittakerW",
  "WholeCellGroupOpener",
  "WienerFilter",
  "WienerProcess",
  "WignerD",
  "WignerSemicircleDistribution",
  "WikidataData",
  "WikidataSearch",
  "WikipediaData",
  "WikipediaSearch",
  "WilksW",
  "WilksWTest",
  "WindDirectionData",
  "WindingCount",
  "WindingPolygon",
  "WindowClickSelect",
  "WindowElements",
  "WindowFloating",
  "WindowFrame",
  "WindowFrameElements",
  "WindowMargins",
  "WindowMovable",
  "WindowOpacity",
  "WindowPersistentStyles",
  "WindowSelected",
  "WindowSize",
  "WindowStatusArea",
  "WindowTitle",
  "WindowToolbars",
  "WindowWidth",
  "WindSpeedData",
  "WindVectorData",
  "WinsorizedMean",
  "WinsorizedVariance",
  "WishartMatrixDistribution",
  "With",
  "WithCleanup",
  "WithLock",
  "WolframAlpha",
  "WolframAlphaDate",
  "WolframAlphaQuantity",
  "WolframAlphaResult",
  "WolframCloudSettings",
  "WolframLanguageData",
  "Word",
  "WordBoundary",
  "WordCharacter",
  "WordCloud",
  "WordCount",
  "WordCounts",
  "WordData",
  "WordDefinition",
  "WordFrequency",
  "WordFrequencyData",
  "WordList",
  "WordOrientation",
  "WordSearch",
  "WordSelectionFunction",
  "WordSeparators",
  "WordSpacings",
  "WordStem",
  "WordTranslation",
  "WorkingPrecision",
  "WrapAround",
  "Write",
  "WriteLine",
  "WriteString",
  "Wronskian",
  "XMLElement",
  "XMLObject",
  "XMLTemplate",
  "Xnor",
  "Xor",
  "XYZColor",
  "Yellow",
  "Yesterday",
  "YuleDissimilarity",
  "ZernikeR",
  "ZeroSymmetric",
  "ZeroTest",
  "ZeroWidthTimes",
  "Zeta",
  "ZetaZero",
  "ZIPCodeData",
  "ZipfDistribution",
  "ZoomCenter",
  "ZoomFactor",
  "ZTest",
  "ZTransform",
  "$Aborted",
  "$ActivationGroupID",
  "$ActivationKey",
  "$ActivationUserRegistered",
  "$AddOnsDirectory",
  "$AllowDataUpdates",
  "$AllowExternalChannelFunctions",
  "$AllowInternet",
  "$AssertFunction",
  "$Assumptions",
  "$AsynchronousTask",
  "$AudioDecoders",
  "$AudioEncoders",
  "$AudioInputDevices",
  "$AudioOutputDevices",
  "$BaseDirectory",
  "$BasePacletsDirectory",
  "$BatchInput",
  "$BatchOutput",
  "$BlockchainBase",
  "$BoxForms",
  "$ByteOrdering",
  "$CacheBaseDirectory",
  "$Canceled",
  "$ChannelBase",
  "$CharacterEncoding",
  "$CharacterEncodings",
  "$CloudAccountName",
  "$CloudBase",
  "$CloudConnected",
  "$CloudConnection",
  "$CloudCreditsAvailable",
  "$CloudEvaluation",
  "$CloudExpressionBase",
  "$CloudObjectNameFormat",
  "$CloudObjectURLType",
  "$CloudRootDirectory",
  "$CloudSymbolBase",
  "$CloudUserID",
  "$CloudUserUUID",
  "$CloudVersion",
  "$CloudVersionNumber",
  "$CloudWolframEngineVersionNumber",
  "$CommandLine",
  "$CompilationTarget",
  "$CompilerEnvironment",
  "$ConditionHold",
  "$ConfiguredKernels",
  "$Context",
  "$ContextAliases",
  "$ContextPath",
  "$ControlActiveSetting",
  "$Cookies",
  "$CookieStore",
  "$CreationDate",
  "$CryptographicEllipticCurveNames",
  "$CurrentLink",
  "$CurrentTask",
  "$CurrentWebSession",
  "$DataStructures",
  "$DateStringFormat",
  "$DefaultAudioInputDevice",
  "$DefaultAudioOutputDevice",
  "$DefaultFont",
  "$DefaultFrontEnd",
  "$DefaultImagingDevice",
  "$DefaultKernels",
  "$DefaultLocalBase",
  "$DefaultLocalKernel",
  "$DefaultMailbox",
  "$DefaultNetworkInterface",
  "$DefaultPath",
  "$DefaultProxyRules",
  "$DefaultRemoteBatchSubmissionEnvironment",
  "$DefaultRemoteKernel",
  "$DefaultSystemCredentialStore",
  "$Display",
  "$DisplayFunction",
  "$DistributedContexts",
  "$DynamicEvaluation",
  "$Echo",
  "$EmbedCodeEnvironments",
  "$EmbeddableServices",
  "$EntityStores",
  "$Epilog",
  "$EvaluationCloudBase",
  "$EvaluationCloudObject",
  "$EvaluationEnvironment",
  "$ExportFormats",
  "$ExternalIdentifierTypes",
  "$ExternalStorageBase",
  "$Failed",
  "$FinancialDataSource",
  "$FontFamilies",
  "$FormatType",
  "$FrontEnd",
  "$FrontEndSession",
  "$GeneratedAssetLocation",
  "$GeoEntityTypes",
  "$GeoLocation",
  "$GeoLocationCity",
  "$GeoLocationCountry",
  "$GeoLocationPrecision",
  "$GeoLocationSource",
  "$HistoryLength",
  "$HomeDirectory",
  "$HTMLExportRules",
  "$HTTPCookies",
  "$HTTPRequest",
  "$IgnoreEOF",
  "$ImageFormattingWidth",
  "$ImageResolution",
  "$ImagingDevice",
  "$ImagingDevices",
  "$ImportFormats",
  "$IncomingMailSettings",
  "$InitialDirectory",
  "$Initialization",
  "$InitializationContexts",
  "$Input",
  "$InputFileName",
  "$InputStreamMethods",
  "$Inspector",
  "$InstallationDate",
  "$InstallationDirectory",
  "$InterfaceEnvironment",
  "$InterpreterTypes",
  "$IterationLimit",
  "$KernelCount",
  "$KernelID",
  "$Language",
  "$LaunchDirectory",
  "$LibraryPath",
  "$LicenseExpirationDate",
  "$LicenseID",
  "$LicenseProcesses",
  "$LicenseServer",
  "$LicenseSubprocesses",
  "$LicenseType",
  "$Line",
  "$Linked",
  "$LinkSupported",
  "$LoadedFiles",
  "$LocalBase",
  "$LocalSymbolBase",
  "$MachineAddresses",
  "$MachineDomain",
  "$MachineDomains",
  "$MachineEpsilon",
  "$MachineID",
  "$MachineName",
  "$MachinePrecision",
  "$MachineType",
  "$MaxDisplayedChildren",
  "$MaxExtraPrecision",
  "$MaxLicenseProcesses",
  "$MaxLicenseSubprocesses",
  "$MaxMachineNumber",
  "$MaxNumber",
  "$MaxPiecewiseCases",
  "$MaxPrecision",
  "$MaxRootDegree",
  "$MessageGroups",
  "$MessageList",
  "$MessagePrePrint",
  "$Messages",
  "$MinMachineNumber",
  "$MinNumber",
  "$MinorReleaseNumber",
  "$MinPrecision",
  "$MobilePhone",
  "$ModuleNumber",
  "$NetworkConnected",
  "$NetworkInterfaces",
  "$NetworkLicense",
  "$NewMessage",
  "$NewSymbol",
  "$NotebookInlineStorageLimit",
  "$Notebooks",
  "$NoValue",
  "$NumberMarks",
  "$Off",
  "$OperatingSystem",
  "$Output",
  "$OutputForms",
  "$OutputSizeLimit",
  "$OutputStreamMethods",
  "$Packages",
  "$ParentLink",
  "$ParentProcessID",
  "$PasswordFile",
  "$PatchLevelID",
  "$Path",
  "$PathnameSeparator",
  "$PerformanceGoal",
  "$Permissions",
  "$PermissionsGroupBase",
  "$PersistenceBase",
  "$PersistencePath",
  "$PipeSupported",
  "$PlotTheme",
  "$Post",
  "$Pre",
  "$PreferencesDirectory",
  "$PreInitialization",
  "$PrePrint",
  "$PreRead",
  "$PrintForms",
  "$PrintLiteral",
  "$Printout3DPreviewer",
  "$ProcessID",
  "$ProcessorCount",
  "$ProcessorType",
  "$ProductInformation",
  "$ProgramName",
  "$ProgressReporting",
  "$PublisherID",
  "$RandomGeneratorState",
  "$RandomState",
  "$RecursionLimit",
  "$RegisteredDeviceClasses",
  "$RegisteredUserName",
  "$ReleaseNumber",
  "$RequesterAddress",
  "$RequesterCloudUserID",
  "$RequesterCloudUserUUID",
  "$RequesterWolframID",
  "$RequesterWolframUUID",
  "$ResourceSystemBase",
  "$ResourceSystemPath",
  "$RootDirectory",
  "$ScheduledTask",
  "$ScriptCommandLine",
  "$ScriptInputString",
  "$SecuredAuthenticationKeyTokens",
  "$ServiceCreditsAvailable",
  "$Services",
  "$SessionID",
  "$SetParentLink",
  "$SharedFunctions",
  "$SharedVariables",
  "$SoundDisplay",
  "$SoundDisplayFunction",
  "$SourceLink",
  "$SSHAuthentication",
  "$SubtitleDecoders",
  "$SubtitleEncoders",
  "$SummaryBoxDataSizeLimit",
  "$SuppressInputFormHeads",
  "$SynchronousEvaluation",
  "$SyntaxHandler",
  "$System",
  "$SystemCharacterEncoding",
  "$SystemCredentialStore",
  "$SystemID",
  "$SystemMemory",
  "$SystemShell",
  "$SystemTimeZone",
  "$SystemWordLength",
  "$TargetSystems",
  "$TemplatePath",
  "$TemporaryDirectory",
  "$TemporaryPrefix",
  "$TestFileName",
  "$TextStyle",
  "$TimedOut",
  "$TimeUnit",
  "$TimeZone",
  "$TimeZoneEntity",
  "$TopDirectory",
  "$TraceOff",
  "$TraceOn",
  "$TracePattern",
  "$TracePostAction",
  "$TracePreAction",
  "$UnitSystem",
  "$Urgent",
  "$UserAddOnsDirectory",
  "$UserAgentLanguages",
  "$UserAgentMachine",
  "$UserAgentName",
  "$UserAgentOperatingSystem",
  "$UserAgentString",
  "$UserAgentVersion",
  "$UserBaseDirectory",
  "$UserBasePacletsDirectory",
  "$UserDocumentsDirectory",
  "$Username",
  "$UserName",
  "$UserURLBase",
  "$Version",
  "$VersionNumber",
  "$VideoDecoders",
  "$VideoEncoders",
  "$VoiceStyles",
  "$WolframDocumentsDirectory",
  "$WolframID",
  "$WolframUUID"
];

/*
Language: Wolfram Language
Description: The Wolfram Language is the programming language used in Wolfram Mathematica, a modern technical computing system spanning most areas of technical computing.
Authors: Patrick Scheibe <patrick@halirutan.de>, Robert Jacobson <robertjacobson@acm.org>
Website: https://www.wolfram.com/mathematica/
Category: scientific
*/

/** @type LanguageFn */
function mathematica(hljs) {
  const regex = hljs.regex;
  /*
  This rather scary looking matching of Mathematica numbers is carefully explained by Robert Jacobson here:
  https://wltools.github.io/LanguageSpec/Specification/Syntax/Number-representations/
   */
  const BASE_RE = /([2-9]|[1-2]\d|[3][0-5])\^\^/;
  const BASE_DIGITS_RE = /(\w*\.\w+|\w+\.\w*|\w+)/;
  const NUMBER_RE = /(\d*\.\d+|\d+\.\d*|\d+)/;
  const BASE_NUMBER_RE = regex.either(regex.concat(BASE_RE, BASE_DIGITS_RE), NUMBER_RE);

  const ACCURACY_RE = /``[+-]?(\d*\.\d+|\d+\.\d*|\d+)/;
  const PRECISION_RE = /`([+-]?(\d*\.\d+|\d+\.\d*|\d+))?/;
  const APPROXIMATE_NUMBER_RE = regex.either(ACCURACY_RE, PRECISION_RE);

  const SCIENTIFIC_NOTATION_RE = /\*\^[+-]?\d+/;

  const MATHEMATICA_NUMBER_RE = regex.concat(
    BASE_NUMBER_RE,
    regex.optional(APPROXIMATE_NUMBER_RE),
    regex.optional(SCIENTIFIC_NOTATION_RE)
  );

  const NUMBERS = {
    className: 'number',
    relevance: 0,
    begin: MATHEMATICA_NUMBER_RE
  };

  const SYMBOL_RE = /[a-zA-Z$][a-zA-Z0-9$]*/;
  const SYSTEM_SYMBOLS_SET = new Set(SYSTEM_SYMBOLS);
  /** @type {Mode} */
  const SYMBOLS = { variants: [
    {
      className: 'builtin-symbol',
      begin: SYMBOL_RE,
      // for performance out of fear of regex.either(...Mathematica.SYSTEM_SYMBOLS)
      "on:begin": (match, response) => {
        if (!SYSTEM_SYMBOLS_SET.has(match[0])) response.ignoreMatch();
      }
    },
    {
      className: 'symbol',
      relevance: 0,
      begin: SYMBOL_RE
    }
  ] };

  const NAMED_CHARACTER = {
    className: 'named-character',
    begin: /\\\[[$a-zA-Z][$a-zA-Z0-9]+\]/
  };

  const OPERATORS = {
    className: 'operator',
    relevance: 0,
    begin: /[+\-*/,;.:@~=><&|_`'^?!%]+/
  };
  const PATTERNS = {
    className: 'pattern',
    relevance: 0,
    begin: /([a-zA-Z$][a-zA-Z0-9$]*)?_+([a-zA-Z$][a-zA-Z0-9$]*)?/
  };

  const SLOTS = {
    className: 'slot',
    relevance: 0,
    begin: /#[a-zA-Z$][a-zA-Z0-9$]*|#+[0-9]?/
  };

  const BRACES = {
    className: 'brace',
    relevance: 0,
    begin: /[[\](){}]/
  };

  const MESSAGES = {
    className: 'message-name',
    relevance: 0,
    begin: regex.concat("::", SYMBOL_RE)
  };

  return {
    name: 'Mathematica',
    aliases: [
      'mma',
      'wl'
    ],
    classNameAliases: {
      brace: 'punctuation',
      pattern: 'type',
      slot: 'type',
      symbol: 'variable',
      'named-character': 'variable',
      'builtin-symbol': 'built_in',
      'message-name': 'string'
    },
    contains: [
      hljs.COMMENT(/\(\*/, /\*\)/, { contains: [ 'self' ] }),
      PATTERNS,
      SLOTS,
      MESSAGES,
      SYMBOLS,
      NAMED_CHARACTER,
      hljs.QUOTE_STRING_MODE,
      NUMBERS,
      OPERATORS,
      BRACES
    ]
  };
}

module.exports = mathematica;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/matlab.js":
/*!***********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/matlab.js ***!
  \***********************************************************/
/***/ (function(module) {

/*
Language: Matlab
Author: Denis Bardadym <bardadymchik@gmail.com>
Contributors: Eugene Nizhibitsky <nizhibitsky@ya.ru>, Egor Rogov <e.rogov@postgrespro.ru>
Website: https://www.mathworks.com/products/matlab.html
Category: scientific
*/

/*
  Formal syntax is not published, helpful link:
  https://github.com/kornilova-l/matlab-IntelliJ-plugin/blob/master/src/main/grammar/Matlab.bnf
*/
function matlab(hljs) {
  const TRANSPOSE_RE = '(\'|\\.\')+';
  const TRANSPOSE = {
    relevance: 0,
    contains: [ { begin: TRANSPOSE_RE } ]
  };

  return {
    name: 'Matlab',
    keywords: {
      keyword:
        'arguments break case catch classdef continue else elseif end enumeration events for function '
        + 'global if methods otherwise parfor persistent properties return spmd switch try while',
      built_in:
        'sin sind sinh asin asind asinh cos cosd cosh acos acosd acosh tan tand tanh atan '
        + 'atand atan2 atanh sec secd sech asec asecd asech csc cscd csch acsc acscd acsch cot '
        + 'cotd coth acot acotd acoth hypot exp expm1 log log1p log10 log2 pow2 realpow reallog '
        + 'realsqrt sqrt nthroot nextpow2 abs angle complex conj imag real unwrap isreal '
        + 'cplxpair fix floor ceil round mod rem sign airy besselj bessely besselh besseli '
        + 'besselk beta betainc betaln ellipj ellipke erf erfc erfcx erfinv expint gamma '
        + 'gammainc gammaln psi legendre cross dot factor isprime primes gcd lcm rat rats perms '
        + 'nchoosek factorial cart2sph cart2pol pol2cart sph2cart hsv2rgb rgb2hsv zeros ones '
        + 'eye repmat rand randn linspace logspace freqspace meshgrid accumarray size length '
        + 'ndims numel disp isempty isequal isequalwithequalnans cat reshape diag blkdiag tril '
        + 'triu fliplr flipud flipdim rot90 find sub2ind ind2sub bsxfun ndgrid permute ipermute '
        + 'shiftdim circshift squeeze isscalar isvector ans eps realmax realmin pi i|0 inf nan '
        + 'isnan isinf isfinite j|0 why compan gallery hadamard hankel hilb invhilb magic pascal '
        + 'rosser toeplitz vander wilkinson max min nanmax nanmin mean nanmean type table '
        + 'readtable writetable sortrows sort figure plot plot3 scatter scatter3 cellfun '
        + 'legend intersect ismember procrustes hold num2cell '
    },
    illegal: '(//|"|#|/\\*|\\s+/\\w+)',
    contains: [
      {
        className: 'function',
        beginKeywords: 'function',
        end: '$',
        contains: [
          hljs.UNDERSCORE_TITLE_MODE,
          {
            className: 'params',
            variants: [
              {
                begin: '\\(',
                end: '\\)'
              },
              {
                begin: '\\[',
                end: '\\]'
              }
            ]
          }
        ]
      },
      {
        className: 'built_in',
        begin: /true|false/,
        relevance: 0,
        starts: TRANSPOSE
      },
      {
        begin: '[a-zA-Z][a-zA-Z_0-9]*' + TRANSPOSE_RE,
        relevance: 0
      },
      {
        className: 'number',
        begin: hljs.C_NUMBER_RE,
        relevance: 0,
        starts: TRANSPOSE
      },
      {
        className: 'string',
        begin: '\'',
        end: '\'',
        contains: [ { begin: '\'\'' } ]
      },
      {
        begin: /\]|\}|\)/,
        relevance: 0,
        starts: TRANSPOSE
      },
      {
        className: 'string',
        begin: '"',
        end: '"',
        contains: [ { begin: '""' } ],
        starts: TRANSPOSE
      },
      hljs.COMMENT('^\\s*%\\{\\s*$', '^\\s*%\\}\\s*$'),
      hljs.COMMENT('%', '$')
    ]
  };
}

module.exports = matlab;


/***/ }),

/***/ "./node_modules/highlight.js/lib/languages/maxima.js":
/*!***********************************************************!*\
  !*** ./node_modules/highlight.js/lib/languages/maxima.js ***!
  \***********************************************************/
/***/ (function(module) {

/*
Language: Maxima
Author: Robert Dodier <robert.dodier@gmail.com>
Website: http://maxima.sourceforge.net
Category: scientific
*/

function maxima(hljs) {
  const KEYWORDS =
    'if then else elseif for thru do while unless step in and or not';
  const LITERALS =
    'true false unknown inf minf ind und %e %i %pi %phi %gamma';
  const BUILTIN_FUNCTIONS =
    ' abasep abs absint absolute_real_time acos acosh acot acoth acsc acsch activate'
    + ' addcol add_edge add_edges addmatrices addrow add_vertex add_vertices adjacency_matrix'
    + ' adjoin adjoint af agd airy airy_ai airy_bi airy_dai airy_dbi algsys alg_type'
    + ' alias allroots alphacharp alphanumericp amortization %and annuity_fv'
    + ' annuity_pv antid antidiff AntiDifference append appendfile apply apply1 apply2'
    + ' applyb1 apropos args arit_amortization arithmetic arithsum array arrayapply'
    + ' arrayinfo arraymake arraysetapply ascii asec asech asin asinh askinteger'
    + ' asksign assoc assoc_legendre_p assoc_legendre_q assume assume_external_byte_order'
    + ' asympa at atan atan2 atanh atensimp atom atvalue augcoefmatrix augmented_lagrangian_method'
    + ' av average_degree backtrace bars barsplot barsplot_description base64 base64_decode'
    + ' bashindices batch batchload bc2 bdvac belln benefit_cost bern bernpoly bernstein_approx'
    + ' bernstein_expand bernstein_poly bessel bessel_i bessel_j bessel_k bessel_simplify'
    + ' bessel_y beta beta_incomplete beta_incomplete_generalized beta_incomplete_regularized'
    + ' bezout bfallroots bffac bf_find_root bf_fmin_cobyla bfhzeta bfloat bfloatp'
    + ' bfpsi bfpsi0 bfzeta biconnected_components bimetric binomial bipartition'
    + ' block blockmatrixp bode_gain bode_phase bothcoef box boxplot boxplot_description'
    + ' break bug_report build_info|10 buildq build_sample burn cabs canform canten'
    + ' cardinality carg cartan cartesian_product catch cauchy_matrix cbffac cdf_bernoulli'
    + ' cdf_beta cdf_binomial cdf_cauchy cdf_chi2 cdf_continuous_uniform cdf_discrete_uniform'
    + ' cdf_exp cdf_f cdf_gamma cdf_general_finite_discrete cdf_geometric cdf_gumbel'
    + ' cdf_hypergeometric cdf_laplace cdf_logistic cdf_lognormal cdf_negative_binomial'
    + ' cdf_noncentral_chi2 cdf_noncentral_student_t cdf_normal cdf_pareto cdf_poisson'
    + ' cdf_rank_sum cdf_rayleigh cdf_signed_rank cdf_student_t cdf_weibull cdisplay'
    + ' ceiling central_moment cequal cequalignore cf cfdisrep cfexpand cgeodesic'
    + ' cgreaterp cgreaterpignore changename changevar chaosgame charat charfun charfun2'
    + ' charlist charp charpoly chdir chebyshev_t chebyshev_u checkdiv check_overlaps'
    + ' chinese cholesky christof chromatic_index chromatic_number cint circulant_graph'
    + ' clear_edge_weight clear_rules clear_vertex_label clebsch_gordan clebsch_graph'
    + ' clessp clesspignore close closefile cmetric coeff coefmatrix cograd col collapse'
    + ' collectterms columnop columnspace columnswap columnvector combination combine'
    + ' comp2pui compare compfile compile compile_file complement_graph complete_bipartite_graph'
    + ' complete_graph complex_number_p components compose_functions concan concat'
    + ' conjugate conmetderiv connected_components connect_vertices cons constant'
    + ' constantp constituent constvalue cont2part content continuous_freq contortion'
    + ' contour_plot contract contract_edge contragrad contrib_ode convert coord'
    + ' copy copy_file copy_graph copylist copymatrix cor cos cosh cot coth cov cov1'
    + ' covdiff covect covers crc24sum create_graph create_list csc csch csetup cspline'
    + ' ctaylor ct_coordsys ctransform ctranspose cube_graph cuboctahedron_graph'
    + ' cunlisp cv cycle_digraph cycle_graph cylindrical days360 dblint deactivate'
    + ' declare declare_constvalue declare_dimensions declare_fundamental_dimensions'
    + ' declare_fundamental_units declare_qty declare_translated declare_unit_conversion'
    + ' declare_units declare_weights decsym defcon define define_alt_display define_variable'
    + ' defint defmatch defrule defstruct deftaylor degree_sequence del delete deleten'
    + ' delta demo demoivre denom depends derivdegree derivlist describe desolve'
    + ' determinant dfloat dgauss_a dgauss_b dgeev dgemm dgeqrf dgesv dgesvd diag'
    + ' diagmatrix diag_matrix diagmatrixp diameter diff digitcharp dimacs_export'
    + ' dimacs_import dimension dimensionless dimensions dimensions_as_list direct'
    + ' directory discrete_freq disjoin disjointp disolate disp dispcon dispform'
    + ' dispfun dispJordan display disprule dispterms distrib divide divisors divsum'
    + ' dkummer_m dkummer_u dlange dodecahedron_graph dotproduct dotsimp dpart'
    + ' draw draw2d draw3d drawdf draw_file draw_graph dscalar echelon edge_coloring'
    + ' edge_connectivity edges eigens_by_jacobi eigenvalues eigenvectors eighth'
    + ' einstein eivals eivects elapsed_real_time elapsed_run_time ele2comp ele2polynome'
    + ' ele2pui elem elementp elevation_grid elim elim_allbut eliminate eliminate_using'
    + ' ellipse elliptic_e elliptic_ec elliptic_eu elliptic_f elliptic_kc elliptic_pi'
    + ' ematrix empty_graph emptyp endcons entermatrix entertensor entier equal equalp'
    + ' equiv_classes erf erfc erf_generalized erfi errcatch error errormsg errors'
    + ' euler ev eval_string evenp every evolution evolution2d evundiff example exp'
    + ' expand expandwrt expandwrt_factored expint expintegral_chi expintegral_ci'
    + ' expintegral_e expintegral_e1 expintegral_ei expintegral_e_simplify expintegral_li'
    + ' expintegral_shi expintegral_si explicit explose exponentialize express expt'
    + ' exsec extdiff extract_linear_equations extremal_subset ezgcd %f f90 facsum'
    + ' factcomb factor factorfacsum factorial factorout factorsum facts fast_central_elements'
    + ' fast_linsolve fasttimes featurep fernfale fft fib fibtophi fifth filename_merge'
    + ' file_search file_type fillarray findde find_root find_root_abs find_root_error'
    + ' find_root_rel first fix flatten flength float floatnump floor flower_snark'
    + ' flush flush1deriv flushd flushnd flush_output fmin_cobyla forget fortran'
    + ' fourcos fourexpand fourier fourier_elim fourint fourintcos fourintsin foursimp'
    + ' foursin fourth fposition frame_bracket freeof freshline fresnel_c fresnel_s'
    + ' from_adjacency_matrix frucht_graph full_listify fullmap fullmapl fullratsimp'
    + ' fullratsubst fullsetify funcsolve fundamental_dimensions fundamental_units'
    + ' fundef funmake funp fv g0 g1 gamma gamma_greek gamma_incomplete gamma_incomplete_generalized'
    + ' gamma_incomplete_regularized gauss gauss_a gauss_b gaussprob gcd gcdex gcdivide'
    + ' gcfac gcfactor gd generalized_lambert_w genfact gen_laguerre genmatrix gensym'
    + ' geo_amortization geo_annuity_fv geo_annuity_pv geomap geometric geometric_mean'
    + ' geosum get getcurrentdirectory get_edge_weight getenv get_lu_factors get_output_stream_string'
    + ' get_pixel get_plot_option get_tex_environment get_tex_environment_default'
    + ' get_vertex_label gfactor gfactorsum ggf girth global_variances gn gnuplot_close'
    + ' gnuplot_replot gnuplot_reset gnuplot_restart gnuplot_start go Gosper GosperSum'
    + ' gr2d gr3d gradef gramschmidt graph6_decode graph6_encode graph6_export graph6_import'
    + ' graph_center graph_charpoly graph_eigenvalues graph_flow graph_order graph_periphery'
    + ' graph_product graph_size graph_union great_rhombicosidodecahedron_graph great_rhombicuboctahedron_graph'
    + ' grid_graph grind grobner_basis grotzch_graph hamilton_cycle hamilton_path'
    + ' hankel hankel_1 hankel_2 harmonic harmonic_mean hav heawood_graph hermite'
    + ' hessian hgfred hilbertmap hilbert_matrix hipow histogram histogram_description'
    + ' hodge horner hypergeometric i0 i1 %ibes ic1 ic2 ic_convert ichr1 ichr2 icosahedron_graph'
    + ' icosidodecahedron_graph icurvature ident identfor identity idiff idim idummy'
    + ' ieqn %if ifactors iframes ifs igcdex igeodesic_coords ilt image imagpart'
    + ' imetric implicit implicit_derivative implicit_plot indexed_tensor indices'
    + ' induced_subgraph inferencep inference_result infix info_display init_atensor'
    + ' init_ctensor in_neighbors innerproduct inpart inprod inrt integerp integer_partitions'
    + ' integrate intersect intersection intervalp intopois intosum invariant1 invariant2'
    + ' inverse_fft inverse_jacobi_cd inverse_jacobi_cn inverse_jacobi_cs inverse_jacobi_dc'
    + ' inverse_jacobi_dn inverse_jacobi_ds inverse_jacobi_nc inverse_jacobi_nd inverse_jacobi_ns'
    + ' inverse_jacobi_sc inverse_jacobi_sd inverse_jacobi_sn invert invert_by_adjoint'
    + ' invert_by_lu inv_mod irr is is_biconnected is_bipartite is_connected is_digraph'
    + ' is_edge_in_graph is_graph is_graph_or_digraph ishow is_isomorphic isolate'
    + ' isomorphism is_planar isqrt isreal_p is_sconnected is_tree is_vertex_in_graph'
    + ' items_inference %j j0 j1 jacobi jacobian jacobi_cd jacobi_cn jacobi_cs jacobi_dc'
    + ' jacobi_dn jacobi_ds jacobi_nc jacobi_nd jacobi_ns jacobi_p jacobi_sc jacobi_sd'
    + ' jacobi_sn JF jn join jordan julia julia_set julia_sin %k kdels kdelta kill'
    + ' killcontext kostka kron_delta kronecker_product kummer_m kummer_u kurtosis'
    + ' kurtosis_bernoulli kurtosis_beta kurtosis_binomial kurtosis_chi2 kurtosis_continuous_uniform'
    + ' kurtosis_discrete_uniform kurtosis_exp kurtosis_f kurtosis_gamma kurtosis_general_finite_discrete'
    + ' kurtosis_geometric kurtosis_gumbel kurtosis_hypergeometric kurtosis_laplace'
    + ' kurtosis_logistic kurtosis_lognormal kurtosis_negative_binomial kurtosis_noncentral_chi2'
    + ' kurtosis_noncentral_student_t kurtosis_normal kurtosis_pareto kurtosis_poisson'
    + ' kurtosis_rayleigh kurtosis_student_t kurtosis_weibull label labels lagrange'
    + ' laguerre lambda lambert_w laplace laplacian_matrix last lbfgs lc2kdt lcharp'
    + ' lc_l lcm lc_u ldefint ldisp ldisplay legendre_p legendre_q leinstein length'
    + ' let letrules letsimp levi_civita lfreeof lgtreillis lhs li liediff limit'
    + ' Lindstedt linear linearinterpol linear_program linear_regression line_graph'
    + ' linsolve listarray list_correlations listify list_matrix_entries list_nc_monomials'
    + ' listoftens listofvars listp lmax lmin load loadfile local locate_matrix_entry'
    + ' log logcontract log_gamma lopow lorentz_gauge lowercasep lpart lratsubst'
    + ' lreduce lriemann lsquares_estimates lsquares_estimates_approximate lsquares_estimates_exact'
    + ' lsquares_mse lsquares_residual_mse lsquares_residuals lsum ltreillis lu_backsub'
    + ' lucas lu_factor %m macroexpand macroexpand1 make_array makebox makefact makegamma'
    + ' make_graph make_level_picture makelist makeOrders make_poly_continent make_poly_country'
    + ' make_polygon make_random_state make_rgb_picture makeset make_string_input_stream'
    + ' make_string_output_stream make_transform mandelbrot mandelbrot_set map mapatom'
    + ' maplist matchdeclare matchfix mat_cond mat_fullunblocker mat_function mathml_display'
    + ' mat_norm matrix matrixmap matrixp matrix_size mattrace mat_trace mat_unblocker'
    + ' max max_clique max_degree max_flow maximize_lp max_independent_set max_matching'
    + ' maybe md5sum mean mean_bernoulli mean_beta mean_binomial mean_chi2 mean_continuous_uniform'
    + ' mean_deviation mean_discrete_uniform mean_exp mean_f mean_gamma mean_general_finite_discrete'
    + ' mean_geometric mean_gumbel mean_hypergeometric mean_laplace mean_logistic'
    + ' mean_lognormal mean_negative_binomial mean_noncentral_chi2 mean_noncentral_student_t'
    + ' mean_normal mean_pareto mean_poisson mean_rayleigh mean_student_t mean_weibull'
    + ' median median_deviation member mesh metricexpandall mgf1_sha1 min min_degree'
    + ' min_edge_cut minfactorial minimalPoly minimize_lp minimum_spanning_tree minor'
    + ' minpack_lsquares minpack_solve min_vertex_cover min_vertex_cut mkdir mnewton'
    + ' mod mode_declare mode_identity ModeMatrix moebius mon2schur mono monomial_dimensions'
    + ' multibernstein_poly multi_display_for_texinfo multi_elem multinomial multinomial_coeff'
    + ' multi_orbit multiplot_mode multi_pui multsym multthru mycielski_graph nary'
    + ' natural_unit nc_degree ncexpt ncharpoly negative_picture neighbors new newcontext'
    + ' newdet new_graph newline newton new_variable next_prime nicedummies niceindices'
    + ' ninth nofix nonarray noncentral_moment nonmetricity nonnegintegerp nonscalarp'
    + ' nonzeroandfreeof notequal nounify nptetrad npv nroots nterms ntermst'
    + ' nthroot nullity nullspace num numbered_boundaries numberp number_to_octets'
    + ' num_distinct_partitions numerval numfactor num_partitions nusum nzeta nzetai'
    + ' nzetar octets_to_number octets_to_oid odd_girth oddp ode2 ode_check odelin'
    + ' oid_to_octets op opena opena_binary openr openr_binary openw openw_binary'
    + ' operatorp opsubst optimize %or orbit orbits ordergreat ordergreatp orderless'
    + ' orderlessp orthogonal_complement orthopoly_recur orthopoly_weight outermap'
    + ' out_neighbors outofpois pade parabolic_cylinder_d parametric parametric_surface'
    + ' parg parGosper parse_string parse_timedate part part2cont partfrac partition'
    + ' partition_set partpol path_digraph path_graph pathname_directory pathname_name'
    + ' pathname_type pdf_bernoulli pdf_beta pdf_binomial pdf_cauchy pdf_chi2 pdf_continuous_uniform'
    + ' pdf_discrete_uniform pdf_exp pdf_f pdf_gamma pdf_general_finite_discrete'
    + ' pdf_geometric pdf_gumbel pdf_hypergeometric pdf_laplace pdf_logistic pdf_lognormal'
    + ' pdf_negative_binomial pdf_noncentral_chi2 pdf_noncentral_student_t pdf_normal'
    + ' pdf_pareto pdf_poisson pdf_rank_sum pdf_rayleigh pdf_signed_rank pdf_student_t'
    + ' pdf_weibull pearson_skewness permanent permut permutation permutations petersen_graph'
    + ' petrov pickapart picture_equalp picturep piechart piechart_description planar_embedding'
    + ' playback plog plot2d plot3d plotdf ploteq plsquares pochhammer points poisdiff'
    + ' poisexpt poisint poismap poisplus poissimp poissubst poistimes poistrim polar'
    + ' polarform polartorect polar_to_xy poly_add poly_buchberger poly_buchberger_criterion'
    + ' poly_colon_ideal poly_content polydecomp poly_depends_p poly_elimination_ideal'
    + ' poly_exact_divide poly_expand poly_expt poly_gcd polygon poly_grobner poly_grobner_equal'
    + ' poly_grobner_member poly_grobner_subsetp poly_ideal_intersection poly_ideal_polysaturation'
    + ' poly_ideal_polysaturation1 poly_ideal_saturation poly_ideal_saturation1 poly_lcm'
    + ' poly_minimization polymod poly_multiply polynome2ele polynomialp poly_normal_form'
    + ' poly_normalize poly_normalize_list poly_polysaturation_extension poly_primitive_part'
    + ' poly_pseudo_divide poly_reduced_grobner poly_reduction poly_saturation_extension'
    + ' poly_s_polynomial poly_subtract polytocompanion pop postfix potential power_mod'
    + ' powerseries powerset prefix prev_prime primep primes principal_components'
    + ' print printf printfile print_graph printpois printprops prodrac product properties'
    + ' propvars psi psubst ptriangularize pui pui2comp pui2ele pui2polynome pui_direct'
    + ' puireduc push put pv qput qrange qty quad_control quad_qag quad_qagi quad_qagp'
    + ' quad_qags quad_qawc quad_qawf quad_qawo quad_qaws quadrilateral quantile'
    + ' quantile_bernoulli quantile_beta quantile_binomial quantile_cauchy quantile_chi2'
    + ' quantile_continuous_uniform quantile_discrete_uniform quantile_exp quantile_f'
    + ' quantile_gamma quantile_general_finite_discrete quantile_geometric quantile_gumbel'
    + ' quantile_hypergeometric quantile_laplace quantile_logistic quantile_lognormal'
    + ' quantile_negative_binomial quantile_noncentral_chi2 quantile_noncentral_student_t'
    + ' quantile_normal quantile_pareto quantile_poisson quantile_rayleigh quantile_student_t'
    + ' quantile_weibull quartile_skewness quit qunit quotient racah_v racah_w radcan'
    + ' radius random random_bernoulli random_beta random_binomial random_bipartite_graph'
    + ' random_cauchy random_chi2 random_continuous_uniform random_digraph random_discrete_uniform'
    + ' random_exp random_f random_gamma random_general_finite_discrete random_geometric'
    + ' random_graph random_graph1 random_gumbel random_hypergeometric random_laplace'
    + ' random_logistic random_lognormal random_negative_binomial random_network'
    + ' random_noncentral_chi2 random_noncentral_student_t random_normal random_pareto'
    + ' random_permutation random_poisson random_rayleigh random_regular_graph random_student_t'
    + ' random_tournament random_tree random_weibull range rank rat ratcoef ratdenom'
    + ' ratdiff ratdisrep ratexpand ratinterpol rational rationalize ratnumer ratnump'
    + ' ratp ratsimp ratsubst ratvars ratweight read read_array read_binary_array'
    + ' read_binary_list read_binary_matrix readbyte readchar read_hashed_array readline'
    + ' read_list read_matrix read_nested_list readonly read_xpm real_imagpart_to_conjugate'
    + ' realpart realroots rearray rectangle rectform rectform_log_if_constant recttopolar'
    + ' rediff reduce_consts reduce_order region region_boundaries region_boundaries_plus'
    + ' rem remainder remarray rembox remcomps remcon remcoord remfun remfunction'
    + ' remlet remove remove_constvalue remove_dimensions remove_edge remove_fundamental_dimensions'
    + ' remove_fundamental_units remove_plot_option remove_vertex rempart remrule'
    + ' remsym remvalue rename rename_file reset reset_displays residue resolvante'
    + ' resolvante_alternee1 resolvante_bipartite resolvante_diedrale resolvante_klein'
    + ' resolvante_klein3 resolvante_produit_sym resolvante_unitaire resolvante_vierer'
    + ' rest resultant return reveal reverse revert revert2 rgb2level rhs ricci riemann'
    + ' rinvariant risch rk rmdir rncombine romberg room rootscontract round row'
    + ' rowop rowswap rreduce run_testsuite %s save saving scalarp scaled_bessel_i'
    + ' scaled_bessel_i0 scaled_bessel_i1 scalefactors scanmap scatterplot scatterplot_description'
    + ' scene schur2comp sconcat scopy scsimp scurvature sdowncase sec sech second'
    + ' sequal sequalignore set_alt_display setdifference set_draw_defaults set_edge_weight'
    + ' setelmx setequalp setify setp set_partitions set_plot_option set_prompt set_random_state'
    + ' set_tex_environment set_tex_environment_default setunits setup_autoload set_up_dot_simplifications'
    + ' set_vertex_label seventh sexplode sf sha1sum sha256sum shortest_path shortest_weighted_path'
    + ' show showcomps showratvars sierpinskiale sierpinskimap sign signum similaritytransform'
    + ' simp_inequality simplify_sum simplode simpmetderiv simtran sin sinh sinsert'
    + ' sinvertcase sixth skewness skewness_bernoulli skewness_beta skewness_binomial'
    + ' skewness_chi2 skewness_continuous_uniform skewness_discrete_uniform skewness_exp'
    + ' skewness_f skewness_gamma skewness_general_finite_discrete skewness_geometric'
    + ' skewness_gumbel skewness_hypergeometric skewness_laplace skewness_logistic'
    + ' skewness_lognormal skewness_negative_binomial skewness_noncentral_chi2 skewness_noncentral_student_t'
    + ' skewness_normal skewness_pareto skewness_poisson skewness_rayleigh skewness_student_t'
    + ' skewness_weibull slength smake small_rhombicosidodecahedron_graph small_rhombicuboctahedron_graph'
    + ' smax smin smismatch snowmap snub_cube_graph snub_dodecahedron_graph solve'
    + ' solve_rec solve_rec_rat some somrac sort sparse6_decode sparse6_encode sparse6_export'
    + ' sparse6_import specint spherical spherical_bessel_j spherical_bessel_y spherical_hankel1'
    + ' spherical_hankel2 spherical_harmonic spherical_to_xyz splice split sposition'
    + ' sprint sqfr sqrt sqrtdenest sremove sremovefirst sreverse ssearch ssort sstatus'
    + ' ssubst ssubstfirst staircase standardize standardize_inverse_trig starplot'
    + ' starplot_description status std std1 std_bernoulli std_beta std_binomial'
    + ' std_chi2 std_continuous_uniform std_discrete_uniform std_exp std_f std_gamma'
    + ' std_general_finite_discrete std_geometric std_gumbel std_hypergeometric std_laplace'
    + ' std_logistic std_lognormal std_negative_binomial std_noncentral_chi2 std_noncentral_student_t'
    + ' std_normal std_pareto std_poisson std_rayleigh std_student_t std_weibull'
    + ' stemplot stirling stirling1 stirling2 strim striml strimr string stringout'
    + ' stringp strong_components struve_h struve_l sublis sublist sublist_indices'
    + ' submatrix subsample subset subsetp subst substinpart subst_parallel substpart'
    + ' substring subvar subvarp sum sumcontract summand_to_rec supcase supcontext'
    + ' symbolp symmdifference symmetricp system take_channel take_inference tan'
    + ' tanh taylor taylorinfo taylorp taylor_simplifier taytorat tcl_output tcontract'
    + ' tellrat tellsimp tellsimpafter tentex tenth test_mean test_means_difference'
    + ' test_normality test_proportion test_proportions_difference test_rank_sum'
    + ' test_sign test_signed_rank test_variance test_variance_ratio tex tex1 tex_display'
    + ' texput %th third throw time timedate timer timer_info tldefint tlimit todd_coxeter'
    + ' toeplitz tokens to_lisp topological_sort to_poly to_poly_solve totaldisrep'
    + ' totalfourier totient tpartpol trace tracematrix trace_options transform_sample'
    + ' translate translate_file transpose treefale tree_reduce treillis treinat'
    + ' triangle triangularize trigexpand trigrat trigreduce trigsimp trunc truncate'
    + ' truncated_cube_graph truncated_dodecahedron_graph truncated_icosahedron_graph'
    + ' truncated_tetrahedron_graph tr_warnings_get tube tutte_graph ueivects uforget'
    + ' ultraspherical underlying_graph undiff union unique uniteigenvectors unitp'
    + ' units unit_step unitvector unorder unsum untellrat untimer'
    + ' untrace uppercasep uricci uriemann uvect vandermonde_matrix var var1 var_bernoulli'
    + ' var_beta var_binomial var_chi2 var_continuous_uniform var_discrete_uniform'
    + ' var_exp var_f var_gamma var_general_finite_discrete var_geometric var_gumbel'
    + ' var_hypergeometric var_laplace var_logistic var_lognormal var_negative_binomial'
    + ' var_noncentral_chi2 var_noncentral_student_t var_normal var_pareto var_poisson'
    + ' var_rayleigh var_student_t var_weibull vector vectorpotential vectorsimp'
    + ' verbify vers vertex_coloring vertex_connectivity vertex_degree vertex_distance'
    + ' vertex_eccentricity vertex_in_degree vertex_out_degree vertices vertices_to_cycle'
    + ' vertices_to_path %w weyl wheel_graph wiener_index wigner_3j wigner_6j'
    + ' wigner_9j with_stdout write_binary_data writebyte write_data writefile wronskian'
    + ' xreduce xthru %y Zeilberger zeroequiv zerofor zeromatrix zeromatrixp zeta'
    + ' zgeev zheev zlange zn_add_table zn_carmichael_lambda zn_characteristic_factors'
    + ' zn_determinant zn_factor_generators zn_invert_by_lu zn_log zn_mult_table'
    + '