var products = {};

document.addEventListener('DOMContentLoaded', function () {
    $.ajax({
      url: '/api_yemekler',
      method: 'POST',
      dataType: 'json',
      data : {
        '_token': $('meta[name="csrf-token"]').attr('content')
      },
      success: function(response) {
        if (response.success) {
          console.log('burada');
          products = response.data;
        }else{
          console.error('Bir hata oluştu: ');
        }
      },
      error: function(xhr, status, error) {
        console.error(error);
      }
    });
});


function showProducts(category) {
  const container = document.getElementById('product-container');
  container.innerHTML = '';

  products[category].forEach(product => {
      const productCard = `
      <div class="col-md-4 my-3">
          <div class="card">
              <img src="${product.img}" class="card-img-top" alt="${product.name}" onclick="showImageModal('${product.id}')">
              <div class="card-body">
                  <h4 class="card-title font-weight-bold">${product.name}</h4>
                  <p class="card-text">${product.description}</p>
                  <p class="card-text price"><strong>${product.price}</strong></p>
              </div>
          </div>
      </div>
      `;
      container.innerHTML += productCard;
  });

  document.querySelectorAll('.category-item').forEach(item => {
      item.classList.remove('active');
  });
  document.querySelector(`.category-item[onclick="showProducts('${category}')"]`).classList.add('active');
}

function showImageModal(pid) {
  document.getElementById('modalImage').src = '';
  document.getElementById('modalTitle').textContent = '';
  document.getElementById('modalDescription').textContent = '';
  $.ajax({
    url: '/api_yemek/' + pid,
    method: 'POST',
    dataType: 'json',
    data : {
      '_token': $('meta[name="csrf-token"]').attr('content')
    },
    success: function(response) {
      if (response.success) {
        const product = response.data;
        document.getElementById('modalImage').src = product.img;
        document.getElementById('modalTitle').textContent = product.name;
        document.getElementById('modalDescription').textContent = product.description;
      }else{
        console.error('Bir hata oluştu: ');
      }
    },
    error: function(xhr, status, error) {
      console.error(error);
    }
  });
  
  $('#imageModal').modal('show');
}

let isGridView = false;

function toggleView() {
  const categoryContainer = document.getElementById('category-container');
  const toggleButton = document.getElementById('toggleViewBtn');

  if (isGridView) {
      categoryContainer.classList.remove('category-grid');
      categoryContainer.classList.add('category-scroll');
      toggleButton.textContent = 'Hepsini Göster';
  } else {
      categoryContainer.classList.remove('category-scroll');
      categoryContainer.classList.add('category-grid');
      toggleButton.textContent = 'Kaydırarak Göster';
  }

  isGridView = !isGridView;
}


var products = {};
document.addEventListener('DOMContentLoaded', function () {
  $.ajax({
    url: '/api_yemekler',
    method: 'POST',
    dataType: 'json',
    data : {
      '_token': $('meta[name="csrf-token"]').attr('content')
    },
    success: function(response) {
      if (response.success) {
        products = response.data;
        showProducts(Object.keys(products)[0]);
      }else{
        console.error('Bir hata oluştu: ');
      }
    },
    error: function(xhr, status, error) {
      console.error(error);
    }
  });
});

const scrollToTopBtn = document.getElementById('scrollToTopBtn');

window.onscroll = function() {
    if (document.body.scrollTop > 200 || document.documentElement.scrollTop > 200) {
        scrollToTopBtn.style.display = "block";
    } else {
        scrollToTopBtn.style.display = "none";
    }
};

scrollToTopBtn.addEventListener('click', function(event) {
    event.preventDefault();
    window.scrollTo({
        top: 0,
        behavior: 'smooth'
    });
});
