!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?module.exports=t():"function"==typeof define&&define.amd?define(t):(e="undefined"!=typeof globalThis?globalThis:e||self).mapboxgl=t()}(this,(function(){"use strict";var e="undefined"!=typeof self?self:{},t="2.15.0";let i;const r={API_URL:"https://api.mapbox.com",get API_URL_REGEX(){if(null==i){const e=/^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/|\?|$)/i;try{i=null!=process.env.API_URL_REGEX?new RegExp(process.env.API_URL_REGEX):e}catch(t){i=e}}return i},get API_TILEJSON_REGEX(){return/^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/v[0-9]*\/.*\.json.*$)/i},get API_SPRITE_REGEX(){return/^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/styles\/v[0-9]*\/)(.*\/sprite.*\..*$)/i},get API_FONTS_REGEX(){return/^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/fonts\/v[0-9]*\/)(.*\.pbf.*$)/i},get API_STYLE_REGEX(){return/^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/styles\/v[0-9]*\/)(.*$)/i},get API_CDN_URL_REGEX(){return/^((https?:)?\/\/)?api\.mapbox\.c(n|om)(\/mapbox-gl-js\/)(.*$)/i},get EVENTS_URL(){if(!r.API_URL)return null;try{const e=new URL(r.API_URL);return"api.mapbox.cn"===e.hostname?"https://events.mapbox.cn/events/v2":"api.mapbox.com"===e.hostname?"https://events.mapbox.com/events/v2":null}catch(e){return null}},SESSION_PATH:"/map-sessions/v1",FEEDBACK_URL:"https://apps.mapbox.com/feedback",TILE_URL_VERSION:"v4",RASTER_URL_PREFIX:"raster/v1",REQUIRE_ACCESS_TOKEN:!0,ACCESS_TOKEN:null,MAX_PARALLEL_IMAGE_REQUESTS:16},n={supported:!1,testSupport:function(e){!a&&s&&(l?c(e):o=e)}};let o,s,a=!1,l=!1;function c(e){const t=e.createTexture();e.bindTexture(e.TEXTURE_2D,t);try{if(e.texImage2D(e.TEXTURE_2D,0,e.RGBA,e.RGBA,e.UNSIGNED_BYTE,s),e.isContextLost())return;n.supported=!0}catch(e){}e.deleteTexture(t),a=!0}e.document&&(s=e.document.createElement("img"),s.onload=function(){o&&c(o),o=null,l=!0},s.onerror=function(){a=!0,o=null},s.src="data:image/webp;base64,UklGRh4AAABXRUJQVlA4TBEAAAAvAQAAAAfQ//73v/+BiOh/AAA=");const u="01";function h(e){return e&&e.__esModule&&Object.prototype.hasOwnProperty.call(e,"default")?e.default:e}var d=p;function p(e,t,i,r){this.cx=3*e,this.bx=3*(i-e)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*t,this.by=3*(r-t)-this.cy,this.ay=1-this.cy-this.by,this.p1x=e,this.p1y=t,this.p2x=i,this.p2y=r}p.prototype={sampleCurveX:function(e){return((this.ax*e+this.bx)*e+this.cx)*e},sampleCurveY:function(e){return((this.ay*e+this.by)*e+this.cy)*e},sampleCurveDerivativeX:function(e){return(3*this.ax*e+2*this.bx)*e+this.cx},solveCurveX:function(e,t){if(void 0===t&&(t=1e-6),e<0)return 0;if(e>1)return 1;for(var i=e,r=0;r<8;r++){var n=this.sampleCurveX(i)-e;if(Math.abs(n)<t)return i;var o=this.sampleCurveDerivativeX(i);if(Math.abs(o)<1e-6)break;i-=n/o}var s=0,a=1;for(i=e,r=0;r<20&&(n=this.sampleCurveX(i),!(Math.abs(n-e)<t));r++)e>n?s=i:a=i,i=.5*(a-s)+s;return i},solve:function(e,t){return this.sampleCurveY(this.solveCurveX(e,t))}};var f=h(d),m=_;function _(e,t){this.x=e,this.y=t}_.prototype={clone:function(){return new _(this.x,this.y)},add:function(e){return this.clone()._add(e)},sub:function(e){return this.clone()._sub(e)},multByPoint:function(e){return this.clone()._multByPoint(e)},divByPoint:function(e){return this.clone()._divByPoint(e)},mult:function(e){return this.clone()._mult(e)},div:function(e){return this.clone()._div(e)},rotate:function(e){return this.clone()._rotate(e)},rotateAround:function(e,t){return this.clone()._rotateAround(e,t)},matMult:function(e){return this.clone()._matMult(e)},unit:function(){return this.clone()._unit()},perp:function(){return this.clone()._perp()},round:function(){return this.clone()._round()},mag:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals:function(e){return this.x===e.x&&this.y===e.y},dist:function(e){return Math.sqrt(this.distSqr(e))},distSqr:function(e){var t=e.x-this.x,i=e.y-this.y;return t*t+i*i},angle:function(){return Math.atan2(this.y,this.x)},angleTo:function(e){return Math.atan2(this.y-e.y,this.x-e.x)},angleWith:function(e){return this.angleWithSep(e.x,e.y)},angleWithSep:function(e,t){return Math.atan2(this.x*t-this.y*e,this.x*e+this.y*t)},_matMult:function(e){var t=e[2]*this.x+e[3]*this.y;return this.x=e[0]*this.x+e[1]*this.y,this.y=t,this},_add:function(e){return this.x+=e.x,this.y+=e.y,this},_sub:function(e){return this.x-=e.x,this.y-=e.y,this},_mult:function(e){return this.x*=e,this.y*=e,this},_div:function(e){return this.x/=e,this.y/=e,this},_multByPoint:function(e){return this.x*=e.x,this.y*=e.y,this},_divByPoint:function(e){return this.x/=e.x,this.y/=e.y,this},_unit:function(){return this._div(this.mag()),this},_perp:function(){var e=this.y;return this.y=this.x,this.x=-e,this},_rotate:function(e){var t=Math.cos(e),i=Math.sin(e),r=i*this.x+t*this.y;return this.x=t*this.x-i*this.y,this.y=r,this},_rotateAround:function(e,t){var i=Math.cos(e),r=Math.sin(e),n=t.y+r*(this.x-t.x)+i*(this.y-t.y);return this.x=t.x+i*(this.x-t.x)-r*(this.y-t.y),this.y=n,this},_round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this}},_.convert=function(e){return e instanceof _?e:Array.isArray(e)?new _(e[0],e[1]):e};var g=h(m);function y(e,t){if(Array.isArray(e)){if(!Array.isArray(t)||e.length!==t.length)return!1;for(let i=0;i<e.length;i++)if(!y(e[i],t[i]))return!1;return!0}if("object"==typeof e&&null!==e&&null!==t){if("object"!=typeof t)return!1;if(Object.keys(e).length!==Object.keys(t).length)return!1;for(const i in e)if(!y(e[i],t[i]))return!1;return!0}return e===t}const x=Math.PI/180,v=180/Math.PI;function b(e){return e*x}function w(e){return e*v}const E=[[0,0],[1,0],[1,1],[0,1]];function T(e){if(e<=0)return 0;if(e>=1)return 1;const t=e*e,i=t*e;return 4*(e<.5?i:3*(e-t)+i-.75)}function S(e){let t=1/0,i=1/0,r=-1/0,n=-1/0;for(const o of e)t=Math.min(t,o.x),i=Math.min(i,o.y),r=Math.max(r,o.x),n=Math.max(n,o.y);return{min:new g(t,i),max:new g(r,n)}}function A(e,t,i=0,r=!0){const n=new g(i,i),o=e.sub(n),s=t.add(n),a=[o,new g(s.x,o.y),s,new g(o.x,s.y)];return r&&a.push(o.clone()),a}function C(e,t,i,r){const n=new f(e,t,i,r);return function(e){return n.solve(e)}}const I=C(.25,.1,.25,1);function M(e,t,i){return Math.min(i,Math.max(t,e))}function P(e,t,i){return(i=M((i-e)/(t-e),0,1))*i*(3-2*i)}function D(e,t,i){const r=i-t,n=((e-t)%r+r)%r+t;return n===t?i:n}function z(e,t,i){if(!e.length)return i(null,[]);let r=e.length;const n=new Array(e.length);let o=null;e.forEach(((e,s)=>{t(e,((e,t)=>{e&&(o=e),n[s]=t,0==--r&&i(o,n)}))}))}function k(e){const t=[];for(const i in e)t.push(e[i]);return t}function L(e,...t){for(const i of t)for(const t in i)e[t]=i[t];return e}function B(e,t){const i={};for(let r=0;r<t.length;r++){const n=t[r];n in e&&(i[n]=e[n])}return i}let R=1;function F(){return R++}function O(){return function e(t){return t?(t^Math.random()*(16>>t/4)).toString(16):([1e7]+-[1e3]+-4e3+-8e3+-1e11).replace(/[018]/g,e)}()}function U(e){return e<=1?1:Math.pow(2,Math.ceil(Math.log(e)/Math.LN2))}function V(e){return!!e&&/^[0-9a-f]{8}-[0-9a-f]{4}-[4][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/i.test(e)}function j(e,t){e.forEach((e=>{t[e]&&(t[e]=t[e].bind(t))}))}function N(e,t){return-1!==e.indexOf(t,e.length-t.length)}function G(e,t,i){const r={};for(const n in e)r[n]=t.call(i||this,e[n],n,e);return r}function q(e,t,i){const r={};for(const n in e)t.call(i||this,e[n],n,e)&&(r[n]=e[n]);return r}function Z(e){return Array.isArray(e)?e.map(Z):"object"==typeof e&&e?G(e,Z):e}function $(e,t,i,r,n){return M((e-t)/(i-t)*(n-r)+r,r,n)}const W={};function H(e){W[e]||("undefined"!=typeof console&&console.warn(e),W[e]=!0)}function X(e,t,i){return(i.y-e.y)*(t.x-e.x)>(t.y-e.y)*(i.x-e.x)}function K(e){let t=0;for(let i,r,n=0,o=e.length,s=o-1;n<o;s=n++)i=e[n],r=e[s],t+=(r.x-i.x)*(i.y+r.y);return t}function J(){return"undefined"!=typeof WorkerGlobalScope&&"undefined"!=typeof self&&self instanceof WorkerGlobalScope}function Y(e){const t={};if(e.replace(/(?:^|(?:\s*\,\s*))([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)(?:\=(?:([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)|(?:\"((?:[^"\\]|\\.)*)\")))?/g,((e,i,r,n)=>{const o=r||n;return t[i]=!o||o.toLowerCase(),""})),t["max-age"]){const e=parseInt(t["max-age"],10);isNaN(e)?delete t["max-age"]:t["max-age"]=e}return t}let Q=null;function ee(e){if(null==Q){const t=e.navigator?e.navigator.userAgent:null;Q=!!e.safari||!(!t||!(/\b(iPad|iPhone|iPod)\b/.test(t)||t.match("Safari")&&!t.match("Chrome")))}return Q}function te(){return!!e.document.fullscreenElement||!!e.document.webkitFullscreenElement}function ie(t){try{const i=e[t];return i.setItem("_mapbox_test_",1),i.removeItem("_mapbox_test_"),!0}catch(e){return!1}}function re(e,t){return[e[4*t],e[4*t+1],e[4*t+2],e[4*t+3]]}function ne(e,t,i){e[4*t+0]=i[0],e[4*t+1]=i[1],e[4*t+2]=i[2],e[4*t+3]=i[3]}const oe="mapbox-tiles";let se=500,ae=50;let le,ce;function ue(){try{return e.caches}catch(e){}}function he(){ue()&&!le&&(le=e.caches.open(oe))}function de(e){const t=e.indexOf("?");if(t<0)return e;const i=function(e){const t=e.indexOf("?");return t>0?e.slice(t+1).split("&"):[]}(e),r=i.filter((e=>{const t=e.split("=");return"language"===t[0]||"worldview"===t[0]}));return r.length?`${e.slice(0,t)}?${r.join("&")}`:e.slice(0,t)}let pe=1/0;function fe(e){pe++,pe>ae&&(e.getActor().send("enforceCacheSizeLimit",se),pe=0)}const me={Unknown:"Unknown",Style:"Style",Source:"Source",Tile:"Tile",Glyphs:"Glyphs",SpriteImage:"SpriteImage",SpriteJSON:"SpriteJSON",Image:"Image"};"function"==typeof Object.freeze&&Object.freeze(me);class AJAXError extends Error{constructor(e,t,i){401===t&&Ce(i)&&(e+=": you may have provided an invalid Mapbox access token. See https://docs.mapbox.com/api/overview/#access-tokens-and-token-scopes"),super(e),this.status=t,this.url=i}toString(){return`${this.name}: ${this.message} (${this.status}): ${this.url}`}}const _e=J()?()=>self.worker&&self.worker.referrer:()=>("blob:"===e.location.protocol?e.parent:e).location.href;const ge=function(t,i){if(!(/^file:/.test(r=t.url)||/^file:/.test(_e())&&!/^\w+:/.test(r))){if(e.fetch&&e.Request&&e.AbortController&&e.Request.prototype.hasOwnProperty("signal"))return function(t,i){const r=new e.AbortController,n=new e.Request(t.url,{method:t.method||"GET",body:t.body,credentials:t.credentials,headers:t.headers,referrer:_e(),referrerPolicy:t.referrerPolicy,signal:r.signal});let o=!1,s=!1;const a=(l=n.url).indexOf("sku=")>0&&Ce(l);var l;"json"===t.type&&n.headers.set("Accept","application/json");const c=(r,o,l)=>{if(s)return;if(r&&"SecurityError"!==r.message&&H(r.toString()),o&&l)return u(o);const c=Date.now();e.fetch(n).then((e=>{if(e.ok){const t=a?e.clone():null;return u(e,t,c)}return i(new AJAXError(e.statusText,e.status,t.url))})).catch((e=>{"AbortError"!==e.name&&i(new Error(`${e.message} ${t.url}`))}))},u=(r,a,l)=>{("arrayBuffer"===t.type?r.arrayBuffer():"json"===t.type?r.json():r.text()).then((t=>{s||(a&&l&&function(t,i,r){if(he(),!le)return;const n={status:i.status,statusText:i.statusText,headers:new e.Headers};i.headers.forEach(((e,t)=>n.headers.set(t,e)));const o=Y(i.headers.get("Cache-Control")||"");if(o["no-store"])return;o["max-age"]&&n.headers.set("Expires",new Date(r+1e3*o["max-age"]).toUTCString());const s=n.headers.get("Expires");s&&(new Date(s).getTime()-r<42e4||function(e,t){if(void 0===ce)try{new Response(new ReadableStream),ce=!0}catch(e){ce=!1}ce?t(e.body):e.blob().then(t)}(i,(i=>{const r=new e.Response(i,n);he(),le&&le.then((e=>e.put(de(t.url),r))).catch((e=>H(e.message)))})))}(n,a,l),o=!0,i(null,t,r.headers.get("Cache-Control"),r.headers.get("Expires")))})).catch((e=>{s||i(new Error(e.message))}))};return a?function(e,t){if(he(),!le)return t(null);const i=de(e.url);le.then((e=>{e.match(i).then((r=>{const n=function(e){if(!e)return!1;const t=new Date(e.headers.get("Expires")||0),i=Y(e.headers.get("Cache-Control")||"");return t>Date.now()&&!i["no-cache"]}(r);e.delete(i),n&&e.put(i,r.clone()),t(null,r,n)})).catch(t)})).catch(t)}(n,c):c(null,null),{cancel:()=>{s=!0,o||r.abort()}}}(t,i);if(J()&&self.worker&&self.worker.actor)return self.worker.actor.send("getResource",t,i,void 0,!0)}var r;return function(t,i){const r=new e.XMLHttpRequest;r.open(t.method||"GET",t.url,!0),"arrayBuffer"===t.type&&(r.responseType="arraybuffer");for(const e in t.headers)r.setRequestHeader(e,t.headers[e]);return"json"===t.type&&(r.responseType="text",r.setRequestHeader("Accept","application/json")),r.withCredentials="include"===t.credentials,r.onerror=()=>{i(new Error(r.statusText))},r.onload=()=>{if((r.status>=200&&r.status<300||0===r.status)&&null!==r.response){let e=r.response;if("json"===t.type)try{e=JSON.parse(r.response)}catch(e){return i(e)}i(null,e,r.getResponseHeader("Cache-Control"),r.getResponseHeader("Expires"))}else i(new AJAXError(r.statusText,r.status,t.url))},r.send(t.body),{cancel:()=>r.abort()}}(t,i)},ye=function(e,t){return ge(L(e,{type:"json"}),t)},xe=function(e,t){return ge(L(e,{type:"arrayBuffer"}),t)};function ve(t){const i=e.document.createElement("a");return i.href=t,i.protocol===e.document.location.protocol&&i.host===e.document.location.host}const be="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAC0lEQVQYV2NgAAIAAAUAAarVyFEAAAAASUVORK5CYII=";let we,Ee;we=[],Ee=0;const Te=function(t,i){if(n.supported&&(t.headers||(t.headers={}),t.headers.accept="image/webp,*/*"),Ee>=r.MAX_PARALLEL_IMAGE_REQUESTS){const e={requestParameters:t,callback:i,cancelled:!1,cancel(){this.cancelled=!0}};return we.push(e),e}Ee++;let o=!1;const s=()=>{if(!o)for(o=!0,Ee--;we.length&&Ee<r.MAX_PARALLEL_IMAGE_REQUESTS;){const e=we.shift(),{requestParameters:t,callback:i,cancelled:r}=e;r||(e.cancel=Te(t,i).cancel)}},a=xe(t,((t,r,n,o)=>{s(),t?i(t):r&&(e.createImageBitmap?function(t,i){const r=new e.Blob([new Uint8Array(t)],{type:"image/png"});e.createImageBitmap(r).then((e=>{i(null,e)})).catch((e=>{i(new Error(`Could not load image because of ${e.message}. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported.`))}))}(r,((e,t)=>i(e,t,n,o))):function(t,i){const r=new e.Image,n=e.URL;r.onload=()=>{i(null,r),n.revokeObjectURL(r.src),r.onload=null,e.requestAnimationFrame((()=>{r.src=be}))},r.onerror=()=>i(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));const o=new e.Blob([new Uint8Array(t)],{type:"image/png"});r.src=t.byteLength?n.createObjectURL(o):be}(r,((e,t)=>i(e,t,n,o))))}));return{cancel:()=>{a.cancel(),s()}}},Se="NO_ACCESS_TOKEN";class RequestManager{constructor(e,t,i){this._transformRequestFn=e,this._customAccessToken=t,this._silenceAuthErrors=!!i,this._createSkuToken()}_createSkuToken(){const e=function(){let e="";for(let t=0;t<10;t++)e+="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"[Math.floor(62*Math.random())];return{token:["1",u,e].join(""),tokenExpiresAt:Date.now()+432e5}}();this._skuToken=e.token,this._skuTokenExpiresAt=e.tokenExpiresAt}_isSkuTokenExpired(){return Date.now()>this._skuTokenExpiresAt}transformRequest(e,t){return this._transformRequestFn&&this._transformRequestFn(e,t)||{url:e}}normalizeStyleURL(e,t){if(!Ae(e))return e;const i=ze(e);return i.path=`/styles/v1${i.path}`,this._makeAPIURL(i,this._customAccessToken||t)}normalizeGlyphsURL(e,t){if(!Ae(e))return e;const i=ze(e);return i.path=`/fonts/v1${i.path}`,this._makeAPIURL(i,this._customAccessToken||t)}normalizeSourceURL(e,t,i,r){if(!Ae(e))return e;const n=ze(e);return n.path=`/v4/${n.authority}.json`,n.params.push("secure"),i&&n.params.push(`language=${i}`),r&&n.params.push(`worldview=${r}`),this._makeAPIURL(n,this._customAccessToken||t)}normalizeSpriteURL(e,t,i,r){const n=ze(e);return Ae(e)?(n.path=`/styles/v1${n.path}/sprite${t}${i}`,this._makeAPIURL(n,this._customAccessToken||r)):(n.path+=`${t}${i}`,ke(n))}normalizeTileURL(e,t,i){if(this._isSkuTokenExpired()&&this._createSkuToken(),e&&!Ae(e))return e;const o=ze(e);o.path=o.path.replace(/(\.(png|jpg)\d*)(?=$)/,`${t||i&&"raster"!==o.authority&&512===i?"@2x":""}${n.supported?".webp":"$1"}`),"raster"===o.authority?o.path=`/${r.RASTER_URL_PREFIX}${o.path}`:(o.path=o.path.replace(/^.+\/v4\//,"/"),o.path=`/${r.TILE_URL_VERSION}${o.path}`);const s=this._customAccessToken||function(e){for(const t of e){const e=t.match(/^access_token=(.*)$/);if(e)return e[1]}return null}(o.params)||r.ACCESS_TOKEN;return r.REQUIRE_ACCESS_TOKEN&&s&&this._skuToken&&o.params.push(`sku=${this._skuToken}`),this._makeAPIURL(o,s)}canonicalizeTileURL(e,t){const i=ze(e);if(!i.path.match(/^(\/v4\/|\/raster\/v1\/)/)||!i.path.match(/\.[\w]+$/))return e;let n="mapbox://";i.path.match(/^\/raster\/v1\//)?n+=`raster/${i.path.replace(`/${r.RASTER_URL_PREFIX}/`,"")}`:n+=`tiles/${i.path.replace(`/${r.TILE_URL_VERSION}/`,"")}`;let o=i.params;return t&&(o=o.filter((e=>!e.match(/^access_token=/)))),o.length&&(n+=`?${o.join("&")}`),n}canonicalizeTileset(e,t){const i=!!t&&Ae(t),r=[];for(const t of e.tiles||[])Ce(t)?r.push(this.canonicalizeTileURL(t,i)):r.push(t);return r}_makeAPIURL(e,t){const i="See https://docs.mapbox.com/api/overview/#access-tokens-and-token-scopes",n=ze(r.API_URL);if(e.protocol=n.protocol,e.authority=n.authority,"http"===e.protocol){const t=e.params.indexOf("secure");t>=0&&e.params.splice(t,1)}if("/"!==n.path&&(e.path=`${n.path}${e.path}`),!r.REQUIRE_ACCESS_TOKEN)return ke(e);if(t=t||r.ACCESS_TOKEN,!this._silenceAuthErrors){if(!t)throw new Error(`An API access token is required to use Mapbox GL. ${i}`);if("s"===t[0])throw new Error(`Use a public access token (pk.*) with Mapbox GL, not a secret access token (sk.*). ${i}`)}return e.params=e.params.filter((e=>-1===e.indexOf("access_token"))),e.params.push(`access_token=${t||""}`),ke(e)}}function Ae(e){return 0===e.indexOf("mapbox:")}function Ce(e){return r.API_URL_REGEX.test(e)}function Ie(e){return r.API_CDN_URL_REGEX.test(e)}function Me(e){return r.API_STYLE_REGEX.test(e)&&!Pe(e)}function Pe(e){return r.API_SPRITE_REGEX.test(e)}const De=/^(\w+):\/\/([^/?]*)(\/[^?]+)?\??(.+)?/;function ze(e){const t=e.match(De);if(!t)throw new Error("Unable to parse URL object");return{protocol:t[1],authority:t[2],path:t[3]||"/",params:t[4]?t[4].split("&"):[]}}function ke(e){const t=e.params.length?`?${e.params.join("&")}`:"";return`${e.protocol}://${e.authority}${e.path}${t}`}const Le="mapbox.eventData";function Be(t){if(!t)return null;const i=t.split(".");if(!i||3!==i.length)return null;try{return JSON.parse(decodeURIComponent(e.atob(i[1]).split("").map((e=>"%"+("00"+e.charCodeAt(0).toString(16)).slice(-2))).join("")))}catch(e){return null}}class TelemetryEvent{constructor(e){this.type=e,this.anonId=null,this.eventData={},this.queue=[],this.pendingRequest=null}getStorageKey(t){const i=Be(r.ACCESS_TOKEN);let n="";return n=i&&i.u?e.btoa(encodeURIComponent(i.u).replace(/%([0-9A-F]{2})/g,((e,t)=>String.fromCharCode(Number("0x"+t))))):r.ACCESS_TOKEN||"",t?`${Le}.${t}:${n}`:`${Le}:${n}`}fetchEventData(){const t=ie("localStorage"),i=this.getStorageKey(),r=this.getStorageKey("uuid");if(t)try{const t=e.localStorage.getItem(i);t&&(this.eventData=JSON.parse(t));const n=e.localStorage.getItem(r);n&&(this.anonId=n)}catch(e){H("Unable to read from LocalStorage")}}saveEventData(){const t=ie("localStorage"),i=this.getStorageKey(),r=this.getStorageKey("uuid");if(t)try{e.localStorage.setItem(r,this.anonId),Object.keys(this.eventData).length>=1&&e.localStorage.setItem(i,JSON.stringify(this.eventData))}catch(e){H("Unable to write to LocalStorage")}}processRequests(e){}postEvent(e,t,i,n){if(!r.EVENTS_URL)return;const o=ze(r.EVENTS_URL);o.params.push(`access_token=${n||r.ACCESS_TOKEN||""}`);const s={event:this.type,created:new Date(e).toISOString()},a=t?L(s,t):s,l={url:ke(o),headers:{"Content-Type":"text/plain"},body:JSON.stringify([a])};this.pendingRequest=function(e,t){return ge(L(e,{method:"POST"}),t)}(l,(e=>{this.pendingRequest=null,i(e),this.saveEventData(),this.processRequests(n)}))}queueRequest(e,t){this.queue.push(e),this.processRequests(t)}}const Re=new class TurnstileEvent extends TelemetryEvent{constructor(e){super("appUserTurnstile"),this._customAccessToken=e}postTurnstileEvent(e,t){r.EVENTS_URL&&r.ACCESS_TOKEN&&Array.isArray(e)&&e.some((e=>Ae(e)||Ce(e)))&&this.queueRequest(Date.now(),t)}processRequests(e){if(this.pendingRequest||0===this.queue.length)return;this.anonId&&this.eventData.lastSuccess&&this.eventData.tokenU||this.fetchEventData();const i=Be(r.ACCESS_TOKEN),n=i?i.u:r.ACCESS_TOKEN;let o=n!==this.eventData.tokenU;V(this.anonId)||(this.anonId=O(),o=!0);const s=this.queue.shift();if(this.eventData.lastSuccess){const e=new Date(this.eventData.lastSuccess),t=new Date(s),i=(s-this.eventData.lastSuccess)/864e5;o=o||i>=1||i<-1||e.getDate()!==t.getDate()}else o=!0;o?this.postEvent(s,{sdkIdentifier:"mapbox-gl-js",sdkVersion:t,skuId:u,"enabled.telemetry":!1,userId:this.anonId},(e=>{e||(this.eventData.lastSuccess=s,this.eventData.tokenU=n)}),e):this.processRequests()}},Fe=Re.postTurnstileEvent.bind(Re),Oe=new class MapLoadEvent extends TelemetryEvent{constructor(){super("map.load"),this.success={},this.skuToken=""}postMapLoadEvent(e,t,i,n){this.skuToken=t,this.errorCb=n,r.EVENTS_URL&&(i||r.ACCESS_TOKEN?this.queueRequest({id:e,timestamp:Date.now()},i):this.errorCb(new Error(Se)))}processRequests(e){if(this.pendingRequest||0===this.queue.length)return;const{id:i,timestamp:r}=this.queue.shift();i&&this.success[i]||(this.anonId||this.fetchEventData(),V(this.anonId)||(this.anonId=O()),this.postEvent(r,{sdkIdentifier:"mapbox-gl-js",sdkVersion:t,skuId:u,skuToken:this.skuToken,userId:this.anonId},(e=>{e?this.errorCb(e):i&&(this.success[i]=!0)}),e))}},Ue=Oe.postMapLoadEvent.bind(Oe),Ve=new class PerformanceEvent extends TelemetryEvent{constructor(){super("gljs.performance")}postPerformanceEvent(e,t){r.EVENTS_URL&&(e||r.ACCESS_TOKEN)&&this.queueRequest({timestamp:Date.now(),performanceData:t},e)}processRequests(i){if(this.pendingRequest||0===this.queue.length)return;const{timestamp:r,performanceData:n}=this.queue.shift(),o=function(i){const r=e.performance.getEntriesByType("resource"),n=e.performance.getEntriesByType("mark"),o=function(e){const t={};if(e)for(const i in e)if("other"!==i)for(const r of e[i]){const e=`${i}ResolveRangeMin`,n=`${i}ResolveRangeMax`,o=`${i}RequestCount`,s=`${i}RequestCachedCount`;t[e]=Math.min(t[e]||1/0,r.startTime),t[n]=Math.max(t[n]||-1/0,r.responseEnd);const a=e=>{void 0===t[e]&&(t[e]=0),++t[e]};void 0!==r.transferSize&&0===r.transferSize&&a(s),a(o)}return t}(function(e,t){const i={};if(e)for(const r of e){const e=t(r);void 0===i[e]&&(i[e]=[]),i[e].push(r)}return i}(r,He)),s=e.devicePixelRatio,a=e.navigator.connection||e.navigator.mozConnection||e.navigator.webkitConnection,l={counters:[],metadata:[],attributes:[]},c=(e,t,i)=>{null!=i&&e.push({name:t,value:i.toString()})};for(const e in o)c(l.counters,e,o[e]);if(i.interactionRange[0]!==1/0&&i.interactionRange[1]!==-1/0&&(c(l.counters,"interactionRangeMin",i.interactionRange[0]),c(l.counters,"interactionRangeMax",i.interactionRange[1])),n)for(const e of Object.keys($e)){const t=$e[e],i=n.find((e=>e.name===t));i&&c(l.counters,t,i.startTime)}return c(l.counters,"visibilityHidden",i.visibilityHidden),c(l.attributes,"style",function(e){if(e)for(const t of e){const e=t.name.split("?")[0];if(Me(e)){const t=e.split("/").slice(-2);if(2===t.length)return`mapbox://styles/${t[0]}/${t[1]}`}}}(r)),c(l.attributes,"terrainEnabled",i.terrainEnabled?"true":"false"),c(l.attributes,"fogEnabled",i.fogEnabled?"true":"false"),c(l.attributes,"projection",i.projection),c(l.attributes,"zoom",i.zoom),c(l.metadata,"devicePixelRatio",s),c(l.metadata,"connectionEffectiveType",a?a.effectiveType:void 0),c(l.metadata,"navigatorUserAgent",e.navigator.userAgent),c(l.metadata,"screenWidth",e.screen.width),c(l.metadata,"screenHeight",e.screen.height),c(l.metadata,"windowWidth",e.innerWidth),c(l.metadata,"windowHeight",e.innerHeight),c(l.metadata,"mapWidth",i.width/s),c(l.metadata,"mapHeight",i.height/s),c(l.metadata,"webglRenderer",i.renderer),c(l.metadata,"webglVendor",i.vendor),c(l.metadata,"sdkVersion",t),c(l.metadata,"sdkIdentifier","mapbox-gl-js"),l}(n);for(const e of o.metadata);for(const e of o.counters);for(const e of o.attributes);this.postEvent(r,o,(()=>{}),i)}},je=Ve.postPerformanceEvent.bind(Ve),Ne=new class MapSessionAPI extends TelemetryEvent{constructor(){super("map.auth"),this.success={},this.skuToken=""}getSession(e,t,i,n){if(!r.API_URL||!r.SESSION_PATH)return;const o=ze(r.API_URL+r.SESSION_PATH);o.params.push(`sku=${t||""}`),o.params.push(`access_token=${n||r.ACCESS_TOKEN||""}`);const s={url:ke(o),headers:{"Content-Type":"text/plain"}};this.pendingRequest=function(e,t){return ge(L(e,{method:"GET"}),t)}(s,(e=>{this.pendingRequest=null,i(e),this.saveEventData(),this.processRequests(n)}))}getSessionAPI(e,t,i,n){this.skuToken=t,this.errorCb=n,r.SESSION_PATH&&r.API_URL&&(i||r.ACCESS_TOKEN?this.queueRequest({id:e,timestamp:Date.now()},i):this.errorCb(new Error(Se)))}processRequests(e){if(this.pendingRequest||0===this.queue.length)return;const{id:t,timestamp:i}=this.queue.shift();t&&this.success[t]||this.getSession(i,this.skuToken,(e=>{e?this.errorCb(e):t&&(this.success[t]=!0)}),e)}},Ge=Ne.getSessionAPI.bind(Ne),qe=new Set;function Ze(e,t){t?qe.add(e):qe.delete(e)}const $e={create:"create",load:"load",fullLoad:"fullLoad"},We={mark(t){e.performance.mark(t)},measure(t,i,r){e.performance.measure(t,i,r)}};function He(e){const t=e.name.split("?")[0];return Ie(t)&&t.includes("mapbox-gl.js")?"javascript":Ie(t)&&t.includes("mapbox-gl.css")?"css":function(e){return r.API_FONTS_REGEX.test(e)}(t)?"fontRange":Pe(t)?"sprite":Me(t)?"style":function(e){return r.API_TILEJSON_REGEX.test(e)}(t)?"tilejson":"other"}var Xe=Ke;function Ke(e){return!function(e){return"undefined"==typeof window||"undefined"==typeof document?"not a browser":Array.prototype&&Array.prototype.every&&Array.prototype.filter&&Array.prototype.forEach&&Array.prototype.indexOf&&Array.prototype.lastIndexOf&&Array.prototype.map&&Array.prototype.some&&Array.prototype.reduce&&Array.prototype.reduceRight&&Array.isArray?Function.prototype&&Function.prototype.bind?Object.keys&&Object.create&&Object.getPrototypeOf&&Object.getOwnPropertyNames&&Object.isSealed&&Object.isFrozen&&Object.isExtensible&&Object.getOwnPropertyDescriptor&&Object.defineProperty&&Object.defineProperties&&Object.seal&&Object.freeze&&Object.preventExtensions?"JSON"in window&&"parse"in JSON&&"stringify"in JSON?function(){if(!("Worker"in window&&"Blob"in window&&"URL"in window))return!1;var e,t,i=new Blob([""],{type:"text/javascript"}),r=URL.createObjectURL(i);try{t=new Worker(r),e=!0}catch(t){e=!1}return t&&t.terminate(),URL.revokeObjectURL(r),e}()?"Uint8ClampedArray"in window?ArrayBuffer.isView?function(){var e=document.createElement("canvas");e.width=e.height=1;var t=e.getContext("2d");if(!t)return!1;var i=t.getImageData(0,0,1,1);return i&&i.width===e.width}()?(void 0===Je[t=e&&e.failIfMajorPerformanceCaveat]&&(Je[t]=function(e){var t,i=function(e){var t=document.createElement("canvas"),i=Object.create(Ke.webGLContextAttributes);return i.failIfMajorPerformanceCaveat=e,t.getContext("webgl",i)||t.getContext("experimental-webgl",i)}(e);if(!i)return!1;try{t=i.createShader(i.VERTEX_SHADER)}catch(e){return!1}return!(!t||i.isContextLost())&&(i.shaderSource(t,"void main() {}"),i.compileShader(t),!0===i.getShaderParameter(t,i.COMPILE_STATUS))}(t)),Je[t]?document.documentMode?"insufficient ECMAScript 6 support":void 0:"insufficient WebGL support"):"insufficient Canvas/getImageData support":"insufficient ArrayBuffer support":"insufficient Uint8ClampedArray support":"insufficient worker support":"insufficient JSON support":"insufficient Object support":"insufficient Function support":"insufficent Array support";var t}(e)}var Je={};let Ye,Qe,et,tt;Ke.webGLContextAttributes={antialias:!1,alpha:!0,stencil:!0,depth:!0};const it={now:()=>void 0!==et?et:e.performance.now(),setNow(e){et=e},restoreNow(){et=void 0},frame(t){const i=e.requestAnimationFrame(t);return{cancel:()=>e.cancelAnimationFrame(i)}},getImageData(t,i=0){const{width:r,height:n}=t;tt||(tt=e.document.createElement("canvas"));const o=tt.getContext("2d",{willReadFrequently:!0});if(!o)throw new Error("failed to create canvas 2d context");return(r>tt.width||n>tt.height)&&(tt.width=r,tt.height=n),o.clearRect(-i,-i,r+2*i,n+2*i),o.drawImage(t,0,0,r,n),o.getImageData(-i,-i,r+2*i,n+2*i)},resolveURL:t=>(Ye||(Ye=e.document.createElement("a")),Ye.href=t,Ye.href),get devicePixelRatio(){return e.devicePixelRatio},get prefersReducedMotion(){return!!e.matchMedia&&(null==Qe&&(Qe=e.matchMedia("(prefers-reduced-motion: reduce)")),Qe.matches)}};function rt(t,i,r){const n=e.document.createElement(t);return void 0!==i&&(n.className=i),r&&r.appendChild(n),n}function nt(t,i,r){const n=e.document.createElementNS("http://www.w3.org/2000/svg",t);for(const e of Object.keys(i))n.setAttributeNS(null,e,i[e]);return r&&r.appendChild(n),n}const ot=e.document&&e.document.documentElement.style,st=ot&&void 0!==ot.userSelect?"userSelect":"WebkitUserSelect";let at;function lt(){ot&&st&&(at=ot[st],ot[st]="none")}function ct(){ot&&st&&(ot[st]=at)}function ut(t){t.preventDefault(),t.stopPropagation(),e.removeEventListener("click",ut,!0)}function ht(){e.addEventListener("click",ut,!0),e.setTimeout((()=>{e.removeEventListener("click",ut,!0)}),0)}function dt(e,t){const i=e.getBoundingClientRect();return mt(e,i,t)}function pt(e,t){const i=e.getBoundingClientRect(),r=[];for(let n=0;n<t.length;n++)r.push(mt(e,i,t[n]));return r}function ft(t){return void 0!==e.InstallTrigger&&2===t.button&&t.ctrlKey&&e.navigator.platform.toUpperCase().indexOf("MAC")>=0?0:t.button}function mt(e,t,i){const r=e.offsetWidth===t.width?1:e.offsetWidth/t.width;return new g((i.clientX-t.left)*r,(i.clientY-t.top)*r)}function _t(e,t,i){i[e]&&-1!==i[e].indexOf(t)||(i[e]=i[e]||[],i[e].push(t))}function gt(e,t,i){if(i&&i[e]){const r=i[e].indexOf(t);-1!==r&&i[e].splice(r,1)}}class Event{constructor(e,t={}){L(this,t),this.type=e}}class ErrorEvent extends Event{constructor(e,t={}){super("error",L({error:e},t))}}class Evented{on(e,t){return this._listeners=this._listeners||{},_t(e,t,this._listeners),this}off(e,t){return gt(e,t,this._listeners),gt(e,t,this._oneTimeListeners),this}once(e,t){return t?(this._oneTimeListeners=this._oneTimeListeners||{},_t(e,t,this._oneTimeListeners),this):new Promise((t=>this.once(e,t)))}fire(e,t){"string"==typeof e&&(e=new Event(e,t||{}));const i=e.type;if(this.listens(i)){e.target=this;const t=this._listeners&&this._listeners[i]?this._listeners[i].slice():[];for(const i of t)i.call(this,e);const r=this._oneTimeListeners&&this._oneTimeListeners[i]?this._oneTimeListeners[i].slice():[];for(const t of r)gt(i,t,this._oneTimeListeners),t.call(this,e);const n=this._eventedParent;n&&(L(e,"function"==typeof this._eventedParentData?this._eventedParentData():this._eventedParentData),n.fire(e))}else e instanceof ErrorEvent&&console.error(e.error);return this}listens(e){return!!(this._listeners&&this._listeners[e]&&this._listeners[e].length>0||this._oneTimeListeners&&this._oneTimeListeners[e]&&this._oneTimeListeners[e].length>0||this._eventedParent&&this._eventedParent.listens(e))}setEventedParent(e,t){return this._eventedParent=e,this._eventedParentData=t,this}}var yt=JSON.parse('{"$version":8,"$root":{"version":{"required":true,"type":"enum","values":[8]},"name":{"type":"string"},"metadata":{"type":"*"},"center":{"type":"array","value":"number"},"zoom":{"type":"number"},"bearing":{"type":"number","default":0,"period":360,"units":"degrees"},"pitch":{"type":"number","default":0,"units":"degrees"},"light":{"type":"light"},"terrain":{"type":"terrain"},"fog":{"type":"fog"},"sources":{"required":true,"type":"sources"},"sprite":{"type":"string"},"glyphs":{"type":"string"},"transition":{"type":"transition"},"projection":{"type":"projection"},"layers":{"required":true,"type":"array","value":"layer"}},"sources":{"*":{"type":"source"}},"source":["source_vector","source_raster","source_raster_dem","source_geojson","source_video","source_image"],"source_vector":{"type":{"required":true,"type":"enum","values":{"vector":{}}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"scheme":{"type":"enum","values":{"xyz":{},"tms":{}},"default":"xyz"},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"attribution":{"type":"string"},"promoteId":{"type":"promoteId"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_raster":{"type":{"required":true,"type":"enum","values":{"raster":{}}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"tileSize":{"type":"number","default":512,"units":"pixels"},"scheme":{"type":"enum","values":{"xyz":{},"tms":{}},"default":"xyz"},"attribution":{"type":"string"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_raster_dem":{"type":{"required":true,"type":"enum","values":{"raster-dem":{}}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"tileSize":{"type":"number","default":512,"units":"pixels"},"attribution":{"type":"string"},"encoding":{"type":"enum","values":{"terrarium":{},"mapbox":{}},"default":"mapbox"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_geojson":{"type":{"required":true,"type":"enum","values":{"geojson":{}}},"data":{"type":"*"},"maxzoom":{"type":"number","default":18},"attribution":{"type":"string"},"buffer":{"type":"number","default":128,"maximum":512,"minimum":0},"filter":{"type":"*"},"tolerance":{"type":"number","default":0.375},"cluster":{"type":"boolean","default":false},"clusterRadius":{"type":"number","default":50,"minimum":0},"clusterMaxZoom":{"type":"number"},"clusterMinPoints":{"type":"number"},"clusterProperties":{"type":"*"},"lineMetrics":{"type":"boolean","default":false},"generateId":{"type":"boolean","default":false},"promoteId":{"type":"promoteId"}},"source_video":{"type":{"required":true,"type":"enum","values":{"video":{}}},"urls":{"required":true,"type":"array","value":"string"},"coordinates":{"required":true,"type":"array","length":4,"value":{"type":"array","length":2,"value":"number"}}},"source_image":{"type":{"required":true,"type":"enum","values":{"image":{}}},"url":{"required":true,"type":"string"},"coordinates":{"required":true,"type":"array","length":4,"value":{"type":"array","length":2,"value":"number"}}},"layer":{"id":{"type":"string","required":true},"type":{"type":"enum","values":{"fill":{},"line":{},"symbol":{},"circle":{},"heatmap":{},"fill-extrusion":{},"raster":{},"hillshade":{},"background":{},"sky":{}},"required":true},"metadata":{"type":"*"},"source":{"type":"string"},"source-layer":{"type":"string"},"minzoom":{"type":"number","minimum":0,"maximum":24},"maxzoom":{"type":"number","minimum":0,"maximum":24},"filter":{"type":"filter"},"layout":{"type":"layout"},"paint":{"type":"paint"}},"layout":["layout_fill","layout_line","layout_circle","layout_heatmap","layout_fill-extrusion","layout_symbol","layout_raster","layout_hillshade","layout_background","layout_sky"],"layout_background":{"visibility":{"type":"enum","values":{"visible":{},"none":{}},"default":"visible","property-type":"constant"}},"layout_sky":{"visibility":{"type":"enum","values":{"visible":{},"none":{}},"default":"visible","property-type":"constant"}},"layout_fill":{"fill-sort-key":{"type":"number","expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"visibility":{"type":"enum","values":{"visible":{},"none":{}},"default":"visible","property-type":"constant"}},"layout_circle":{"circle-sort-key":{"type":"number","expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"visibility":{"type":"enum","values":{"visible":{},"none":{}},"default":"visible","property-type":"constant"}},"layout_heatmap":{"visibility":{"type":"enum","values":{"visible":{},"none":{}},"default":"visible","property-type":"constant"}},"layout_fill-extrusion":{"visibility":{"type":"enum","values":{"visible":{},"none":{}},"default":"visible","property-type":"constant"},"fill-extrusion-edge-radius":{"type":"number","private":true,"default":0,"minimum":0,"maximum":1,"property-type":"constant"}},"layout_line":{"line-cap":{"type":"enum","values":{"butt":{},"round":{},"square":{}},"default":"butt","expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-join":{"type":"enum","values":{"bevel":{},"round":{},"miter":{}},"default":"miter","expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-miter-limit":{"type":"number","default":2,"requires":[{"line-join":"miter"}],"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"line-round-limit":{"type":"number","default":1.05,"requires":[{"line-join":"round"}],"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"line-sort-key":{"type":"number","expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"visibility":{"type":"enum","values":{"visible":{},"none":{}},"default":"visible","property-type":"constant"}},"layout_symbol":{"symbol-placement":{"type":"enum","values":{"point":{},"line":{},"line-center":{}},"default":"point","expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"symbol-spacing":{"type":"number","default":250,"minimum":1,"units":"pixels","requires":[{"symbol-placement":"line"}],"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"symbol-avoid-edges":{"type":"boolean","default":false,"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"symbol-sort-key":{"type":"number","expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"symbol-z-order":{"type":"enum","values":{"auto":{},"viewport-y":{},"source":{}},"default":"auto","expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"icon-allow-overlap":{"type":"boolean","default":false,"requires":["icon-image"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"icon-ignore-placement":{"type":"boolean","default":false,"requires":["icon-image"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"icon-optional":{"type":"boolean","default":false,"requires":["icon-image","text-field"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"icon-rotation-alignment":{"type":"enum","values":{"map":{},"viewport":{},"auto":{}},"default":"auto","requires":["icon-image"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"icon-size":{"type":"number","default":1,"minimum":0,"units":"factor of the original icon size","requires":["icon-image"],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit":{"type":"enum","values":{"none":{},"width":{},"height":{},"both":{}},"default":"none","requires":["icon-image","text-field"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"icon-text-fit-padding":{"type":"array","value":"number","length":4,"default":[0,0,0,0],"units":"pixels","requires":["icon-image","text-field",{"icon-text-fit":["both","width","height"]}],"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"icon-image":{"type":"resolvedImage","tokens":true,"expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-rotate":{"type":"number","default":0,"period":360,"units":"degrees","requires":["icon-image"],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-padding":{"type":"number","default":2,"minimum":0,"units":"pixels","requires":["icon-image"],"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"icon-keep-upright":{"type":"boolean","default":false,"requires":["icon-image",{"icon-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"icon-offset":{"type":"array","value":"number","length":2,"default":[0,0],"requires":["icon-image"],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-anchor":{"type":"enum","values":{"center":{},"left":{},"right":{},"top":{},"bottom":{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},"default":"center","requires":["icon-image"],"expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-pitch-alignment":{"type":"enum","values":{"map":{},"viewport":{},"auto":{}},"default":"auto","requires":["icon-image"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"text-pitch-alignment":{"type":"enum","values":{"map":{},"viewport":{},"auto":{}},"default":"auto","requires":["text-field"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"text-rotation-alignment":{"type":"enum","values":{"map":{},"viewport":{},"auto":{}},"default":"auto","requires":["text-field"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"text-field":{"type":"formatted","default":"","tokens":true,"expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-font":{"type":"array","value":"string","default":["Open Sans Regular","Arial Unicode MS Regular"],"requires":["text-field"],"expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-size":{"type":"number","default":16,"minimum":0,"units":"pixels","requires":["text-field"],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-max-width":{"type":"number","default":10,"minimum":0,"units":"ems","requires":["text-field",{"symbol-placement":["point"]}],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-line-height":{"type":"number","default":1.2,"units":"ems","requires":["text-field"],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-letter-spacing":{"type":"number","default":0,"units":"ems","requires":["text-field"],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-justify":{"type":"enum","values":{"auto":{},"left":{},"center":{},"right":{}},"default":"center","requires":["text-field"],"expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-radial-offset":{"type":"number","units":"ems","default":0,"requires":["text-field"],"property-type":"data-driven","expression":{"interpolated":true,"parameters":["zoom","feature"]}},"text-variable-anchor":{"type":"array","value":"enum","values":{"center":{},"left":{},"right":{},"top":{},"bottom":{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},"requires":["text-field",{"symbol-placement":["point"]}],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"text-anchor":{"type":"enum","values":{"center":{},"left":{},"right":{},"top":{},"bottom":{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},"default":"center","requires":["text-field",{"!":"text-variable-anchor"}],"expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-max-angle":{"type":"number","default":45,"units":"degrees","requires":["text-field",{"symbol-placement":["line","line-center"]}],"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"text-writing-mode":{"type":"array","value":"enum","values":{"horizontal":{},"vertical":{}},"requires":["text-field"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"text-rotate":{"type":"number","default":0,"period":360,"units":"degrees","requires":["text-field"],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-padding":{"type":"number","default":2,"minimum":0,"units":"pixels","requires":["text-field"],"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"text-keep-upright":{"type":"boolean","default":true,"requires":["text-field",{"text-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"text-transform":{"type":"enum","values":{"none":{},"uppercase":{},"lowercase":{}},"default":"none","requires":["text-field"],"expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-offset":{"type":"array","value":"number","units":"ems","length":2,"default":[0,0],"requires":["text-field",{"!":"text-radial-offset"}],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-allow-overlap":{"type":"boolean","default":false,"requires":["text-field"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"text-ignore-placement":{"type":"boolean","default":false,"requires":["text-field"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"text-optional":{"type":"boolean","default":false,"requires":["text-field","icon-image"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"visibility":{"type":"enum","values":{"visible":{},"none":{}},"default":"visible","property-type":"constant"}},"layout_raster":{"visibility":{"type":"enum","values":{"visible":{},"none":{}},"default":"visible","property-type":"constant"}},"layout_hillshade":{"visibility":{"type":"enum","values":{"visible":{},"none":{}},"default":"visible","property-type":"constant"}},"filter":{"type":"array","value":"*"},"filter_symbol":{"type":"boolean","default":false,"transition":false,"property-type":"data-driven","expression":{"interpolated":false,"parameters":["zoom","feature","pitch","distance-from-center"]}},"filter_fill":{"type":"boolean","default":false,"transition":false,"property-type":"data-driven","expression":{"interpolated":false,"parameters":["zoom","feature"]}},"filter_line":{"type":"boolean","default":false,"transition":false,"property-type":"data-driven","expression":{"interpolated":false,"parameters":["zoom","feature"]}},"filter_circle":{"type":"boolean","default":false,"transition":false,"property-type":"data-driven","expression":{"interpolated":false,"parameters":["zoom","feature"]}},"filter_fill-extrusion":{"type":"boolean","default":false,"transition":false,"property-type":"data-driven","expression":{"interpolated":false,"parameters":["zoom","feature"]}},"filter_heatmap":{"type":"boolean","default":false,"transition":false,"property-type":"data-driven","expression":{"interpolated":false,"parameters":["zoom","feature"]}},"filter_operator":{"type":"enum","values":{"==":{},"!=":{},">":{},">=":{},"<":{},"<=":{},"in":{},"!in":{},"all":{},"any":{},"none":{},"has":{},"!has":{},"within":{}}},"geometry_type":{"type":"enum","values":{"Point":{},"LineString":{},"Polygon":{}}},"function":{"expression":{"type":"expression"},"stops":{"type":"array","value":"function_stop"},"base":{"type":"number","default":1,"minimum":0},"property":{"type":"string","default":"$zoom"},"type":{"type":"enum","values":{"identity":{},"exponential":{},"interval":{},"categorical":{}},"default":"exponential"},"colorSpace":{"type":"enum","values":{"rgb":{},"lab":{},"hcl":{}},"default":"rgb"},"default":{"type":"*","required":false}},"function_stop":{"type":"array","minimum":0,"maximum":24,"value":["number","color"],"length":2},"expression":{"type":"array","value":"*","minimum":1},"fog":{"range":{"type":"array","default":[0.5,10],"minimum":-20,"maximum":20,"length":2,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"high-color":{"type":"color","property-type":"data-constant","default":"#245cdf","expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"space-color":{"type":"color","property-type":"data-constant","default":["interpolate",["linear"],["zoom"],4,"#010b19",7,"#367ab9"],"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"horizon-blend":{"type":"number","property-type":"data-constant","default":["interpolate",["linear"],["zoom"],4,0.2,7,0.1],"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"star-intensity":{"type":"number","property-type":"data-constant","default":["interpolate",["linear"],["zoom"],5,0.35,6,0],"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"light":{"anchor":{"type":"enum","default":"viewport","values":{"map":{},"viewport":{}},"property-type":"data-constant","transition":false,"expression":{"interpolated":false,"parameters":["zoom"]}},"position":{"type":"array","default":[1.15,210,30],"length":3,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"intensity":{"type":"number","property-type":"data-constant","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"projection":{"name":{"type":"enum","values":{"albers":{},"equalEarth":{},"equirectangular":{},"lambertConformalConic":{},"mercator":{},"naturalEarth":{},"winkelTripel":{},"globe":{}},"default":"mercator","required":true},"center":{"type":"array","length":2,"value":"number","property-type":"data-constant","minimum":[-180,-90],"maximum":[180,90],"transition":false,"requires":[{"name":["albers","lambertConformalConic"]}]},"parallels":{"type":"array","length":2,"value":"number","property-type":"data-constant","minimum":[-90,-90],"maximum":[90,90],"transition":false,"requires":[{"name":["albers","lambertConformalConic"]}]}},"terrain":{"source":{"type":"string","required":true},"exaggeration":{"type":"number","property-type":"data-constant","default":1,"minimum":0,"maximum":1000,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true,"requires":["source"]}},"paint":["paint_fill","paint_line","paint_circle","paint_heatmap","paint_fill-extrusion","paint_symbol","paint_raster","paint_hillshade","paint_background","paint_sky"],"paint_fill":{"fill-antialias":{"type":"boolean","default":true,"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"fill-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-color":{"type":"color","default":"#000000","transition":true,"requires":[{"!":"fill-pattern"}],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-outline-color":{"type":"color","transition":true,"requires":[{"!":"fill-pattern"},{"fill-antialias":true}],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"units":"pixels","expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"fill-translate-anchor":{"type":"enum","values":{"map":{},"viewport":{}},"default":"map","requires":["fill-translate"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"fill-pattern":{"type":"resolvedImage","transition":false,"expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"}},"paint_fill-extrusion":{"fill-extrusion-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-color":{"type":"color","default":"#000000","transition":true,"requires":[{"!":"fill-extrusion-pattern"}],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"units":"pixels","expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-translate-anchor":{"type":"enum","values":{"map":{},"viewport":{}},"default":"map","requires":["fill-extrusion-translate"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-pattern":{"type":"resolvedImage","transition":false,"expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"fill-extrusion-height":{"type":"number","default":0,"minimum":0,"units":"meters","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-base":{"type":"number","default":0,"minimum":0,"units":"meters","transition":true,"requires":["fill-extrusion-height"],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-vertical-gradient":{"type":"boolean","default":true,"transition":false,"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-ambient-occlusion-intensity":{"property-type":"data-constant","type":"number","private":true,"default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"fill-extrusion-ambient-occlusion-radius":{"property-type":"data-constant","type":"number","private":true,"default":3,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true,"requires":["fill-extrusion-edge-radius"]},"fill-extrusion-rounded-roof":{"type":"boolean","default":true,"requires":["fill-extrusion-edge-radius"],"transition":false,"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_line":{"line-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-color":{"type":"color","default":"#000000","transition":true,"requires":[{"!":"line-pattern"}],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"units":"pixels","expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"line-translate-anchor":{"type":"enum","values":{"map":{},"viewport":{}},"default":"map","requires":["line-translate"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"line-width":{"type":"number","default":1,"minimum":0,"transition":true,"units":"pixels","expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-gap-width":{"type":"number","default":0,"minimum":0,"transition":true,"units":"pixels","expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-offset":{"type":"number","default":0,"transition":true,"units":"pixels","expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-blur":{"type":"number","default":0,"minimum":0,"transition":true,"units":"pixels","expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-dasharray":{"type":"array","value":"number","minimum":0,"transition":false,"units":"line widths","requires":[{"!":"line-pattern"}],"expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-pattern":{"type":"resolvedImage","transition":false,"expression":{"interpolated":false,"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-gradient":{"type":"color","transition":false,"requires":[{"!":"line-pattern"},{"source":"geojson","has":{"lineMetrics":true}}],"expression":{"interpolated":true,"parameters":["line-progress"]},"property-type":"color-ramp"},"line-trim-offset":{"type":"array","value":"number","length":2,"default":[0,0],"minimum":[0,0],"maximum":[1,1],"transition":false,"requires":[{"source":"geojson","has":{"lineMetrics":true}}],"property-type":"constant"}},"paint_circle":{"circle-radius":{"type":"number","default":5,"minimum":0,"transition":true,"units":"pixels","expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-blur":{"type":"number","default":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"units":"pixels","expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"circle-translate-anchor":{"type":"enum","values":{"map":{},"viewport":{}},"default":"map","requires":["circle-translate"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"circle-pitch-scale":{"type":"enum","values":{"map":{},"viewport":{}},"default":"map","expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"circle-pitch-alignment":{"type":"enum","values":{"map":{},"viewport":{}},"default":"viewport","expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"circle-stroke-width":{"type":"number","default":0,"minimum":0,"transition":true,"units":"pixels","expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"}},"paint_heatmap":{"heatmap-radius":{"type":"number","default":30,"minimum":1,"transition":true,"units":"pixels","expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-weight":{"type":"number","default":1,"minimum":0,"transition":false,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-intensity":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"heatmap-color":{"type":"color","default":["interpolate",["linear"],["heatmap-density"],0,"rgba(0, 0, 255, 0)",0.1,"royalblue",0.3,"cyan",0.5,"lime",0.7,"yellow",1,"red"],"transition":false,"expression":{"interpolated":true,"parameters":["heatmap-density"]},"property-type":"color-ramp"},"heatmap-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_symbol":{"icon-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"requires":["icon-image"],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-color":{"type":"color","default":"#000000","transition":true,"requires":["icon-image"],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-color":{"type":"color","default":"rgba(0, 0, 0, 0)","transition":true,"requires":["icon-image"],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-width":{"type":"number","default":0,"minimum":0,"transition":true,"units":"pixels","requires":["icon-image"],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-blur":{"type":"number","default":0,"minimum":0,"transition":true,"units":"pixels","requires":["icon-image"],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"units":"pixels","requires":["icon-image"],"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"icon-translate-anchor":{"type":"enum","values":{"map":{},"viewport":{}},"default":"map","requires":["icon-image","icon-translate"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"text-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"requires":["text-field"],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-color":{"type":"color","default":"#000000","transition":true,"overridable":true,"requires":["text-field"],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-color":{"type":"color","default":"rgba(0, 0, 0, 0)","transition":true,"requires":["text-field"],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-width":{"type":"number","default":0,"minimum":0,"transition":true,"units":"pixels","requires":["text-field"],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-blur":{"type":"number","default":0,"minimum":0,"transition":true,"units":"pixels","requires":["text-field"],"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"units":"pixels","requires":["text-field"],"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"text-translate-anchor":{"type":"enum","values":{"map":{},"viewport":{}},"default":"map","requires":["text-field","text-translate"],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_raster":{"raster-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-hue-rotate":{"type":"number","default":0,"period":360,"transition":true,"units":"degrees","expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-brightness-min":{"type":"number","default":0,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-brightness-max":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-saturation":{"type":"number","default":0,"minimum":-1,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-contrast":{"type":"number","default":0,"minimum":-1,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-resampling":{"type":"enum","values":{"linear":{},"nearest":{}},"default":"linear","expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"raster-fade-duration":{"type":"number","default":300,"minimum":0,"transition":false,"units":"milliseconds","expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_hillshade":{"hillshade-illumination-direction":{"type":"number","default":335,"minimum":0,"maximum":359,"transition":false,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"hillshade-illumination-anchor":{"type":"enum","values":{"map":{},"viewport":{}},"default":"viewport","expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"hillshade-exaggeration":{"type":"number","default":0.5,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"hillshade-shadow-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"hillshade-highlight-color":{"type":"color","default":"#FFFFFF","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"hillshade-accent-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_background":{"background-color":{"type":"color","default":"#000000","transition":true,"requires":[{"!":"background-pattern"}],"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"background-pattern":{"type":"resolvedImage","transition":false,"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"background-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_sky":{"sky-type":{"type":"enum","values":{"gradient":{},"atmosphere":{}},"default":"atmosphere","expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"sky-atmosphere-sun":{"type":"array","value":"number","length":2,"units":"degrees","minimum":[0,0],"maximum":[360,180],"transition":false,"requires":[{"sky-type":"atmosphere"}],"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"sky-atmosphere-sun-intensity":{"type":"number","requires":[{"sky-type":"atmosphere"}],"default":10,"minimum":0,"maximum":100,"transition":false,"property-type":"data-constant"},"sky-gradient-center":{"type":"array","requires":[{"sky-type":"gradient"}],"value":"number","default":[0,0],"length":2,"units":"degrees","minimum":[0,0],"maximum":[360,180],"transition":false,"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"sky-gradient-radius":{"type":"number","requires":[{"sky-type":"gradient"}],"default":90,"minimum":0,"maximum":180,"transition":false,"expression":{"interpolated":false,"parameters":["zoom"]},"property-type":"data-constant"},"sky-gradient":{"type":"color","default":["interpolate",["linear"],["sky-radial-progress"],0.8,"#87ceeb",1,"white"],"transition":false,"requires":[{"sky-type":"gradient"}],"expression":{"interpolated":true,"parameters":["sky-radial-progress"]},"property-type":"color-ramp"},"sky-atmosphere-halo-color":{"type":"color","default":"white","transition":false,"requires":[{"sky-type":"atmosphere"}],"property-type":"data-constant"},"sky-atmosphere-color":{"type":"color","default":"white","transition":false,"requires":[{"sky-type":"atmosphere"}],"property-type":"data-constant"},"sky-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"transition":{"duration":{"type":"number","default":300,"minimum":0,"units":"milliseconds"},"delay":{"type":"number","default":0,"minimum":0,"units":"milliseconds"}},"property-type":{"data-driven":{"type":"property-type"},"color-ramp":{"type":"property-type"},"data-constant":{"type":"property-type"},"constant":{"type":"property-type"}},"promoteId":{"*":{"type":"string"}}}');function xt(e,...t){for(const i of t)for(const t in i)e[t]=i[t];return e}function vt(e){return e instanceof Number||e instanceof String||e instanceof Boolean?e.valueOf():e}function bt(e){if(Array.isArray(e))return e.map(bt);if(e instanceof Object&&!(e instanceof Number||e instanceof String||e instanceof Boolean)){const t={};for(const i in e)t[i]=bt(e[i]);return t}return vt(e)}class ParsingError extends Error{constructor(e,t){super(t),this.message=t,this.key=e}}var wt=ParsingError;class Scope{constructor(e,t=[]){this.parent=e,this.bindings={};for(const[e,i]of t)this.bindings[e]=i}concat(e){return new Scope(this,e)}get(e){if(this.bindings[e])return this.bindings[e];if(this.parent)return this.parent.get(e);throw new Error(`${e} not found in scope.`)}has(e){return!!this.bindings[e]||!!this.parent&&this.parent.has(e)}}var Et=Scope;const Tt={kind:"null"},St={kind:"number"},Ct={kind:"string"},It={kind:"boolean"},Mt={kind:"color"},Pt={kind:"object"},Dt={kind:"value"},zt={kind:"collator"},kt={kind:"formatted"},Lt={kind:"resolvedImage"};function Bt(e,t){return{kind:"array",itemType:e,N:t}}function Rt(e){if("array"===e.kind){const t=Rt(e.itemType);return"number"==typeof e.N?`array<${t}, ${e.N}>`:"value"===e.itemType.kind?"array":`array<${t}>`}return e.kind}const Ft=[Tt,St,Ct,It,Mt,kt,Pt,Bt(Dt),Lt];function Ot(e,t){if("error"===t.kind)return null;if("array"===e.kind){if("array"===t.kind&&(0===t.N&&"value"===t.itemType.kind||!Ot(e.itemType,t.itemType))&&("number"!=typeof e.N||e.N===t.N))return null}else{if(e.kind===t.kind)return null;if("value"===e.kind)for(const e of Ft)if(!Ot(e,t))return null}return`Expected ${Rt(e)} but found ${Rt(t)} instead.`}function Ut(e,t){return t.some((t=>t.kind===e.kind))}function Vt(e,t){return t.some((t=>"null"===t?null===e:"array"===t?Array.isArray(e):"object"===t?e&&!Array.isArray(e)&&"object"==typeof e:t===typeof e))}var jt,Nt={transparent:[0,0,0,0],aliceblue:[240,248,255,1],antiquewhite:[250,235,215,1],aqua:[0,255,255,1],aquamarine:[127,255,212,1],azure:[240,255,255,1],beige:[245,245,220,1],bisque:[255,228,196,1],black:[0,0,0,1],blanchedalmond:[255,235,205,1],blue:[0,0,255,1],blueviolet:[138,43,226,1],brown:[165,42,42,1],burlywood:[222,184,135,1],cadetblue:[95,158,160,1],chartreuse:[127,255,0,1],chocolate:[210,105,30,1],coral:[255,127,80,1],cornflowerblue:[100,149,237,1],cornsilk:[255,248,220,1],crimson:[220,20,60,1],cyan:[0,255,255,1],darkblue:[0,0,139,1],darkcyan:[0,139,139,1],darkgoldenrod:[184,134,11,1],darkgray:[169,169,169,1],darkgreen:[0,100,0,1],darkgrey:[169,169,169,1],darkkhaki:[189,183,107,1],darkmagenta:[139,0,139,1],darkolivegreen:[85,107,47,1],darkorange:[255,140,0,1],darkorchid:[153,50,204,1],darkred:[139,0,0,1],darksalmon:[233,150,122,1],darkseagreen:[143,188,143,1],darkslateblue:[72,61,139,1],darkslategray:[47,79,79,1],darkslategrey:[47,79,79,1],darkturquoise:[0,206,209,1],darkviolet:[148,0,211,1],deeppink:[255,20,147,1],deepskyblue:[0,191,255,1],dimgray:[105,105,105,1],dimgrey:[105,105,105,1],dodgerblue:[30,144,255,1],firebrick:[178,34,34,1],floralwhite:[255,250,240,1],forestgreen:[34,139,34,1],fuchsia:[255,0,255,1],gainsboro:[220,220,220,1],ghostwhite:[248,248,255,1],gold:[255,215,0,1],goldenrod:[218,165,32,1],gray:[128,128,128,1],green:[0,128,0,1],greenyellow:[173,255,47,1],grey:[128,128,128,1],honeydew:[240,255,240,1],hotpink:[255,105,180,1],indianred:[205,92,92,1],indigo:[75,0,130,1],ivory:[255,255,240,1],khaki:[240,230,140,1],lavender:[230,230,250,1],lavenderblush:[255,240,245,1],lawngreen:[124,252,0,1],lemonchiffon:[255,250,205,1],lightblue:[173,216,230,1],lightcoral:[240,128,128,1],lightcyan:[224,255,255,1],lightgoldenrodyellow:[250,250,210,1],lightgray:[211,211,211,1],lightgreen:[144,238,144,1],lightgrey:[211,211,211,1],lightpink:[255,182,193,1],lightsalmon:[255,160,122,1],lightseagreen:[32,178,170,1],lightskyblue:[135,206,250,1],lightslategray:[119,136,153,1],lightslategrey:[119,136,153,1],lightsteelblue:[176,196,222,1],lightyellow:[255,255,224,1],lime:[0,255,0,1],limegreen:[50,205,50,1],linen:[250,240,230,1],magenta:[255,0,255,1],maroon:[128,0,0,1],mediumaquamarine:[102,205,170,1],mediumblue:[0,0,205,1],mediumorchid:[186,85,211,1],mediumpurple:[147,112,219,1],mediumseagreen:[60,179,113,1],mediumslateblue:[123,104,238,1],mediumspringgreen:[0,250,154,1],mediumturquoise:[72,209,204,1],mediumvioletred:[199,21,133,1],midnightblue:[25,25,112,1],mintcream:[245,255,250,1],mistyrose:[255,228,225,1],moccasin:[255,228,181,1],navajowhite:[255,222,173,1],navy:[0,0,128,1],oldlace:[253,245,230,1],olive:[128,128,0,1],olivedrab:[107,142,35,1],orange:[255,165,0,1],orangered:[255,69,0,1],orchid:[218,112,214,1],palegoldenrod:[238,232,170,1],palegreen:[152,251,152,1],paleturquoise:[175,238,238,1],palevioletred:[219,112,147,1],papayawhip:[255,239,213,1],peachpuff:[255,218,185,1],peru:[205,133,63,1],pink:[255,192,203,1],plum:[221,160,221,1],powderblue:[176,224,230,1],purple:[128,0,128,1],rebeccapurple:[102,51,153,1],red:[255,0,0,1],rosybrown:[188,143,143,1],royalblue:[65,105,225,1],saddlebrown:[139,69,19,1],salmon:[250,128,114,1],sandybrown:[244,164,96,1],seagreen:[46,139,87,1],seashell:[255,245,238,1],sienna:[160,82,45,1],silver:[192,192,192,1],skyblue:[135,206,235,1],slateblue:[106,90,205,1],slategray:[112,128,144,1],slategrey:[112,128,144,1],snow:[255,250,250,1],springgreen:[0,255,127,1],steelblue:[70,130,180,1],tan:[210,180,140,1],teal:[0,128,128,1],thistle:[216,191,216,1],tomato:[255,99,71,1],turquoise:[64,224,208,1],violet:[238,130,238,1],wheat:[245,222,179,1],white:[255,255,255,1],whitesmoke:[245,245,245,1],yellow:[255,255,0,1],yellowgreen:[154,205,50,1]};function Gt(e){return(e=Math.round(e))<0?0:e>255?255:e}function qt(e){return Gt("%"===e[e.length-1]?parseFloat(e)/100*255:parseInt(e))}function Zt(e){return(t="%"===e[e.length-1]?parseFloat(e)/100:parseFloat(e))<0?0:t>1?1:t;var t}function $t(e,t,i){return i<0?i+=1:i>1&&(i-=1),6*i<1?e+(t-e)*i*6:2*i<1?t:3*i<2?e+(t-e)*(2/3-i)*6:e}try{jt={}.parseCSSColor=function(e){var t,i=e.replace(/ /g,"").toLowerCase();if(i in Nt)return Nt[i].slice();if("#"===i[0])return 4===i.length?(t=parseInt(i.substr(1),16))>=0&&t<=4095?[(3840&t)>>4|(3840&t)>>8,240&t|(240&t)>>4,15&t|(15&t)<<4,1]:null:7===i.length&&(t=parseInt(i.substr(1),16))>=0&&t<=16777215?[(16711680&t)>>16,(65280&t)>>8,255&t,1]:null;var r=i.indexOf("("),n=i.indexOf(")");if(-1!==r&&n+1===i.length){var o=i.substr(0,r),s=i.substr(r+1,n-(r+1)).split(","),a=1;switch(o){case"rgba":if(4!==s.length)return null;a=Zt(s.pop());case"rgb":return 3!==s.length?null:[qt(s[0]),qt(s[1]),qt(s[2]),a];case"hsla":if(4!==s.length)return null;a=Zt(s.pop());case"hsl":if(3!==s.length)return null;var l=(parseFloat(s[0])%360+360)%360/360,c=Zt(s[1]),u=Zt(s[2]),h=u<=.5?u*(c+1):u+c-u*c,d=2*u-h;return[Gt(255*$t(d,h,l+1/3)),Gt(255*$t(d,h,l)),Gt(255*$t(d,h,l-1/3)),a];default:return null}}return null}}catch(e){}class Color{constructor(e,t,i,r=1){this.r=e,this.g=t,this.b=i,this.a=r}static parse(e){if(!e)return;if(e instanceof Color)return e;if("string"!=typeof e)return;const t=jt(e);return t?new Color(t[0]/255*t[3],t[1]/255*t[3],t[2]/255*t[3],t[3]):void 0}toString(){const[e,t,i,r]=this.toArray();return`rgba(${Math.round(e)},${Math.round(t)},${Math.round(i)},${r})`}toArray(){const{r:e,g:t,b:i,a:r}=this;return 0===r?[0,0,0,0]:[255*e/r,255*t/r,255*i/r,r]}toArray01(){const{r:e,g:t,b:i,a:r}=this;return 0===r?[0,0,0,0]:[e/r,t/r,i/r,r]}toArray01PremultipliedAlpha(){const{r:e,g:t,b:i,a:r}=this;return[e,t,i,r]}}Color.black=new Color(0,0,0,1),Color.white=new Color(1,1,1,1),Color.transparent=new Color(0,0,0,0),Color.red=new Color(1,0,0,1),Color.blue=new Color(0,0,1,1);var Wt=Color;class Collator{constructor(e,t,i){this.sensitivity=e?t?"variant":"case":t?"accent":"base",this.locale=i,this.collator=new Intl.Collator(this.locale?this.locale:[],{sensitivity:this.sensitivity,usage:"search"})}compare(e,t){return this.collator.compare(e,t)}resolvedLocale(){return new Intl.Collator(this.locale?this.locale:[]).resolvedOptions().locale}}class FormattedSection{constructor(e,t,i,r,n){this.text=e.normalize?e.normalize():e,this.image=t,this.scale=i,this.fontStack=r,this.textColor=n}}class Formatted{constructor(e){this.sections=e}static fromString(e){return new Formatted([new FormattedSection(e,null,null,null,null)])}isEmpty(){return 0===this.sections.length||!this.sections.some((e=>0!==e.text.length||e.image&&0!==e.image.name.length))}static factory(e){return e instanceof Formatted?e:Formatted.fromString(e)}toString(){return 0===this.sections.length?"":this.sections.map((e=>e.text)).join("")}serialize(){const e=["format"];for(const t of this.sections){if(t.image){e.push(["image",t.image.name]);continue}e.push(t.text);const i={};t.fontStack&&(i["text-font"]=["literal",t.fontStack.split(",")]),t.scale&&(i["font-scale"]=t.scale),t.textColor&&(i["text-color"]=["rgba"].concat(t.textColor.toArray())),e.push(i)}return e}}class ResolvedImage{constructor(e){this.name=e.name,this.available=e.available}toString(){return this.name}static fromString(e){return e?new ResolvedImage({name:e,available:!1}):null}serialize(){return["image",this.name]}}function Ht(e,t,i,r){return"number"==typeof e&&e>=0&&e<=255&&"number"==typeof t&&t>=0&&t<=255&&"number"==typeof i&&i>=0&&i<=255?void 0===r||"number"==typeof r&&r>=0&&r<=1?null:`Invalid rgba value [${[e,t,i,r].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid rgba value [${("number"==typeof r?[e,t,i,r]:[e,t,i]).join(", ")}]: 'r', 'g', and 'b' must be between 0 and 255.`}function Xt(e){if(null===e)return!0;if("string"==typeof e)return!0;if("boolean"==typeof e)return!0;if("number"==typeof e)return!0;if(e instanceof Wt)return!0;if(e instanceof Collator)return!0;if(e instanceof Formatted)return!0;if(e instanceof ResolvedImage)return!0;if(Array.isArray(e)){for(const t of e)if(!Xt(t))return!1;return!0}if("object"==typeof e){for(const t in e)if(!Xt(e[t]))return!1;return!0}return!1}function Kt(e){if(null===e)return Tt;if("string"==typeof e)return Ct;if("boolean"==typeof e)return It;if("number"==typeof e)return St;if(e instanceof Wt)return Mt;if(e instanceof Collator)return zt;if(e instanceof Formatted)return kt;if(e instanceof ResolvedImage)return Lt;if(Array.isArray(e)){const t=e.length;let i;for(const t of e){const e=Kt(t);if(i){if(i===e)continue;i=Dt;break}i=e}return Bt(i||Dt,t)}return Pt}function Jt(e){const t=typeof e;return null===e?"":"string"===t||"number"===t||"boolean"===t?String(e):e instanceof Wt||e instanceof Formatted||e instanceof ResolvedImage?e.toString():JSON.stringify(e)}class Literal{constructor(e,t){this.type=e,this.value=t}static parse(e,t){if(2!==e.length)return t.error(`'literal' expression requires exactly one argument, but found ${e.length-1} instead.`);if(!Xt(e[1]))return t.error("invalid value");const i=e[1];let r=Kt(i);const n=t.expectedType;return"array"!==r.kind||0!==r.N||!n||"array"!==n.kind||"number"==typeof n.N&&0!==n.N||(r=n),new Literal(r,i)}evaluate(){return this.value}eachChild(){}outputDefined(){return!0}serialize(){return"array"===this.type.kind||"object"===this.type.kind?["literal",this.value]:this.value instanceof Wt?["rgba"].concat(this.value.toArray()):this.value instanceof Formatted?this.value.serialize():this.value}}var Yt=Literal,Qt=class RuntimeError{constructor(e){this.name="ExpressionEvaluationError",this.message=e}toJSON(){return this.message}};const ei={string:Ct,number:St,boolean:It,object:Pt};class Assertion{constructor(e,t){this.type=e,this.args=t}static parse(e,t){if(e.length<2)return t.error("Expected at least one argument.");let i,r=1;const n=e[0];if("array"===n){let n,o;if(e.length>2){const i=e[1];if("string"!=typeof i||!(i in ei)||"object"===i)return t.error('The item type argument of "array" must be one of string, number, boolean',1);n=ei[i],r++}else n=Dt;if(e.length>3){if(null!==e[2]&&("number"!=typeof e[2]||e[2]<0||e[2]!==Math.floor(e[2])))return t.error('The length argument to "array" must be a positive integer literal',2);o=e[2],r++}i=Bt(n,o)}else i=ei[n];const o=[];for(;r<e.length;r++){const i=t.parse(e[r],r,Dt);if(!i)return null;o.push(i)}return new Assertion(i,o)}evaluate(e){for(let t=0;t<this.args.length;t++){const i=this.args[t].evaluate(e);if(!Ot(this.type,Kt(i)))return i;if(t===this.args.length-1)throw new Qt(`Expected value to be of type ${Rt(this.type)}, but found ${Rt(Kt(i))} instead.`)}return null}eachChild(e){this.args.forEach(e)}outputDefined(){return this.args.every((e=>e.outputDefined()))}serialize(){const e=this.type,t=[e.kind];if("array"===e.kind){const i=e.itemType;if("string"===i.kind||"number"===i.kind||"boolean"===i.kind){t.push(i.kind);const r=e.N;("number"==typeof r||this.args.length>1)&&t.push(r)}}return t.concat(this.args.map((e=>e.serialize())))}}var ti=Assertion;class FormatExpression{constructor(e){this.type=kt,this.sections=e}static parse(e,t){if(e.length<2)return t.error("Expected at least one argument.");const i=e[1];if(!Array.isArray(i)&&"object"==typeof i)return t.error("First argument must be an image or text section.");const r=[];let n=!1;for(let i=1;i<=e.length-1;++i){const o=e[i];if(n&&"object"==typeof o&&!Array.isArray(o)){n=!1;let e=null;if(o["font-scale"]&&(e=t.parse(o["font-scale"],1,St),!e))return null;let i=null;if(o["text-font"]&&(i=t.parse(o["text-font"],1,Bt(Ct)),!i))return null;let s=null;if(o["text-color"]&&(s=t.parse(o["text-color"],1,Mt),!s))return null;const a=r[r.length-1];a.scale=e,a.font=i,a.textColor=s}else{const o=t.parse(e[i],1,Dt);if(!o)return null;const s=o.type.kind;if("string"!==s&&"value"!==s&&"null"!==s&&"resolvedImage"!==s)return t.error("Formatted text type must be 'string', 'value', 'image' or 'null'.");n=!0,r.push({content:o,scale:null,font:null,textColor:null})}}return new FormatExpression(r)}evaluate(e){return new Formatted(this.sections.map((t=>{const i=t.content.evaluate(e);return Kt(i)===Lt?new FormattedSection("",i,null,null,null):new FormattedSection(Jt(i),null,t.scale?t.scale.evaluate(e):null,t.font?t.font.evaluate(e).join(","):null,t.textColor?t.textColor.evaluate(e):null)})))}eachChild(e){for(const t of this.sections)e(t.content),t.scale&&e(t.scale),t.font&&e(t.font),t.textColor&&e(t.textColor)}outputDefined(){return!1}serialize(){const e=["format"];for(const t of this.sections){e.push(t.content.serialize());const i={};t.scale&&(i["font-scale"]=t.scale.serialize()),t.font&&(i["text-font"]=t.font.serialize()),t.textColor&&(i["text-color"]=t.textColor.serialize()),e.push(i)}return e}}class ImageExpression{constructor(e){this.type=Lt,this.input=e}static parse(e,t){if(2!==e.length)return t.error("Expected two arguments.");const i=t.parse(e[1],1,Ct);return i?new ImageExpression(i):t.error("No image name provided.")}evaluate(e){const t=this.input.evaluate(e),i=ResolvedImage.fromString(t);return i&&e.availableImages&&(i.available=e.availableImages.indexOf(t)>-1),i}eachChild(e){e(this.input)}outputDefined(){return!1}serialize(){return["image",this.input.serialize()]}}const ii={"to-boolean":It,"to-color":Mt,"to-number":St,"to-string":Ct};class Coercion{constructor(e,t){this.type=e,this.args=t}static parse(e,t){if(e.length<2)return t.error("Expected at least one argument.");const i=e[0];if(("to-boolean"===i||"to-string"===i)&&2!==e.length)return t.error("Expected one argument.");const r=ii[i],n=[];for(let i=1;i<e.length;i++){const r=t.parse(e[i],i,Dt);if(!r)return null;n.push(r)}return new Coercion(r,n)}evaluate(e){if("boolean"===this.type.kind)return Boolean(this.args[0].evaluate(e));if("color"===this.type.kind){let t,i;for(const r of this.args){if(t=r.evaluate(e),i=null,t instanceof Wt)return t;if("string"==typeof t){const i=e.parseColor(t);if(i)return i}else if(Array.isArray(t)&&(i=t.length<3||t.length>4?`Invalid rbga value ${JSON.stringify(t)}: expected an array containing either three or four numeric values.`:Ht(t[0],t[1],t[2],t[3]),!i))return new Wt(t[0]/255,t[1]/255,t[2]/255,t[3])}throw new Qt(i||`Could not parse color from value '${"string"==typeof t?t:String(JSON.stringify(t))}'`)}if("number"===this.type.kind){let t=null;for(const i of this.args){if(t=i.evaluate(e),null===t)return 0;const r=Number(t);if(!isNaN(r))return r}throw new Qt(`Could not convert ${JSON.stringify(t)} to number.`)}return"formatted"===this.type.kind?Formatted.fromString(Jt(this.args[0].evaluate(e))):"resolvedImage"===this.type.kind?ResolvedImage.fromString(Jt(this.args[0].evaluate(e))):Jt(this.args[0].evaluate(e))}eachChild(e){this.args.forEach(e)}outputDefined(){return this.args.every((e=>e.outputDefined()))}serialize(){if("formatted"===this.type.kind)return new FormatExpression([{content:this.args[0],scale:null,font:null,textColor:null}]).serialize();if("resolvedImage"===this.type.kind)return new ImageExpression(this.args[0]).serialize();const e=[`to-${this.type.kind}`];return this.eachChild((t=>{e.push(t.serialize())})),e}}var ri=Coercion;const ni=["Unknown","Point","LineString","Polygon"];var oi=class EvaluationContext{constructor(){this.globals=null,this.feature=null,this.featureState=null,this.formattedSection=null,this._parseColorCache={},this.availableImages=null,this.canonical=null,this.featureTileCoord=null,this.featureDistanceData=null}id(){return this.feature&&void 0!==this.feature.id?this.feature.id:null}geometryType(){return this.feature?"number"==typeof this.feature.type?ni[this.feature.type]:this.feature.type:null}geometry(){return this.feature&&"geometry"in this.feature?this.feature.geometry:null}canonicalID(){return this.canonical}properties(){return this.feature&&this.feature.properties||{}}distanceFromCenter(){if(this.featureTileCoord&&this.featureDistanceData){const e=this.featureDistanceData.center,t=this.featureDistanceData.scale,{x:i,y:r}=this.featureTileCoord;return this.featureDistanceData.bearing[0]*(i*t-e[0])+this.featureDistanceData.bearing[1]*(r*t-e[1])}return 0}parseColor(e){let t=this._parseColorCache[e];return t||(t=this._parseColorCache[e]=Wt.parse(e)),t}};class CompoundExpression{constructor(e,t,i,r){this.name=e,this.type=t,this._evaluate=i,this.args=r}evaluate(e){return this._evaluate(e,this.args)}eachChild(e){this.args.forEach(e)}outputDefined(){return!1}serialize(){return[this.name].concat(this.args.map((e=>e.serialize())))}static parse(e,t){const i=e[0],r=CompoundExpression.definitions[i];if(!r)return t.error(`Unknown expression "${i}". If you wanted a literal array, use ["literal", [...]].`,0);const n=Array.isArray(r)?r[0]:r.type,o=Array.isArray(r)?[[r[1],r[2]]]:r.overloads,s=o.filter((([t])=>!Array.isArray(t)||t.length===e.length-1));let a=null;for(const[r,o]of s){a=new Ii(t.registry,t.path,null,t.scope);const s=[];let l=!1;for(let t=1;t<e.length;t++){const i=e[t],n=Array.isArray(r)?r[t-1]:r.type,o=a.parse(i,1+s.length,n);if(!o){l=!0;break}s.push(o)}if(!l)if(Array.isArray(r)&&r.length!==s.length)a.error(`Expected ${r.length} arguments, but found ${s.length} instead.`);else{for(let e=0;e<s.length;e++){const t=Array.isArray(r)?r[e]:r.type,i=s[e];a.concat(e+1).checkSubtype(t,i.type)}if(0===a.errors.length)return new CompoundExpression(i,n,o,s)}}if(1===s.length)t.errors.push(...a.errors);else{const i=(s.length?s:o).map((([e])=>{return t=e,Array.isArray(t)?`(${t.map(Rt).join(", ")})`:`(${Rt(t.type)}...)`;var t})).join(" | "),r=[];for(let i=1;i<e.length;i++){const n=t.parse(e[i],1+r.length);if(!n)return null;r.push(Rt(n.type))}t.error(`Expected arguments of type ${i}, but found (${r.join(", ")}) instead.`)}return null}static register(e,t){CompoundExpression.definitions=t;for(const i in t)e[i]=CompoundExpression}}var si=CompoundExpression;class CollatorExpression{constructor(e,t,i){this.type=zt,this.locale=i,this.caseSensitive=e,this.diacriticSensitive=t}static parse(e,t){if(2!==e.length)return t.error("Expected one argument.");const i=e[1];if("object"!=typeof i||Array.isArray(i))return t.error("Collator options argument must be an object.");const r=t.parse(void 0!==i["case-sensitive"]&&i["case-sensitive"],1,It);if(!r)return null;const n=t.parse(void 0!==i["diacritic-sensitive"]&&i["diacritic-sensitive"],1,It);if(!n)return null;let o=null;return i.locale&&(o=t.parse(i.locale,1,Ct),!o)?null:new CollatorExpression(r,n,o)}evaluate(e){return new Collator(this.caseSensitive.evaluate(e),this.diacriticSensitive.evaluate(e),this.locale?this.locale.evaluate(e):null)}eachChild(e){e(this.caseSensitive),e(this.diacriticSensitive),this.locale&&e(this.locale)}outputDefined(){return!1}serialize(){const e={};return e["case-sensitive"]=this.caseSensitive.serialize(),e["diacritic-sensitive"]=this.diacriticSensitive.serialize(),this.locale&&(e.locale=this.locale.serialize()),["collator",e]}}const ai=8192;function li(e,t){e[0]=Math.min(e[0],t[0]),e[1]=Math.min(e[1],t[1]),e[2]=Math.max(e[2],t[0]),e[3]=Math.max(e[3],t[1])}function ci(e,t){return!(e[0]<=t[0]||e[2]>=t[2]||e[1]<=t[1]||e[3]>=t[3])}function ui(e,t){const i=(180+e[0])/360,r=(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+e[1]*Math.PI/360)))/360,n=Math.pow(2,t.z);return[Math.round(i*n*ai),Math.round(r*n*ai)]}function hi(e,t,i){const r=e[0]-t[0],n=e[1]-t[1],o=e[0]-i[0],s=e[1]-i[1];return r*s-o*n==0&&r*o<=0&&n*s<=0}function di(e,t){let i=!1;for(let s=0,a=t.length;s<a;s++){const a=t[s];for(let t=0,s=a.length;t<s-1;t++){if(hi(e,a[t],a[t+1]))return!1;(n=a[t])[1]>(r=e)[1]!=(o=a[t+1])[1]>r[1]&&r[0]<(o[0]-n[0])*(r[1]-n[1])/(o[1]-n[1])+n[0]&&(i=!i)}}var r,n,o;return i}function pi(e,t){for(let i=0;i<t.length;i++)if(di(e,t[i]))return!0;return!1}function fi(e,t,i,r){const n=r[0]-i[0],o=r[1]-i[1],s=(e[0]-i[0])*o-n*(e[1]-i[1]),a=(t[0]-i[0])*o-n*(t[1]-i[1]);return s>0&&a<0||s<0&&a>0}function mi(e,t,i){for(const c of i)for(let i=0;i<c.length-1;++i)if(0!=(a=[(s=c[i+1])[0]-(o=c[i])[0],s[1]-o[1]])[0]*(l=[(n=t)[0]-(r=e)[0],n[1]-r[1]])[1]-a[1]*l[0]&&fi(r,n,o,s)&&fi(o,s,r,n))return!0;var r,n,o,s,a,l;return!1}function _i(e,t){for(let i=0;i<e.length;++i)if(!di(e[i],t))return!1;for(let i=0;i<e.length-1;++i)if(mi(e[i],e[i+1],t))return!1;return!0}function gi(e,t){for(let i=0;i<t.length;i++)if(_i(e,t[i]))return!0;return!1}function yi(e,t,i){const r=[];for(let n=0;n<e.length;n++){const o=[];for(let r=0;r<e[n].length;r++){const s=ui(e[n][r],i);li(t,s),o.push(s)}r.push(o)}return r}function xi(e,t,i){const r=[];for(let n=0;n<e.length;n++){const o=yi(e[n],t,i);r.push(o)}return r}function vi(e,t,i,r){if(e[0]<i[0]||e[0]>i[2]){const t=.5*r;let n=e[0]-i[0]>t?-r:i[0]-e[0]>t?r:0;0===n&&(n=e[0]-i[2]>t?-r:i[2]-e[0]>t?r:0),e[0]+=n}li(t,e)}function bi(e,t,i,r){const n=Math.pow(2,r.z)*ai,o=[r.x*ai,r.y*ai],s=[];if(!e)return s;for(const r of e)for(const e of r){const r=[e.x+o[0],e.y+o[1]];vi(r,t,i,n),s.push(r)}return s}function wi(e,t,i,r){const n=Math.pow(2,r.z)*ai,o=[r.x*ai,r.y*ai],s=[];if(!e)return s;for(const i of e){const e=[];for(const r of i){const i=[r.x+o[0],r.y+o[1]];li(t,i),e.push(i)}s.push(e)}if(t[2]-t[0]<=n/2){(a=t)[0]=a[1]=1/0,a[2]=a[3]=-1/0;for(const e of s)for(const r of e)vi(r,t,i,n)}var a;return s}class Within{constructor(e,t){this.type=It,this.geojson=e,this.geometries=t}static parse(e,t){if(2!==e.length)return t.error(`'within' expression requires exactly one argument, but found ${e.length-1} instead.`);if(Xt(e[1])){const t=e[1];if("FeatureCollection"===t.type)for(let e=0;e<t.features.length;++e){const i=t.features[e].geometry.type;if("Polygon"===i||"MultiPolygon"===i)return new Within(t,t.features[e].geometry)}else if("Feature"===t.type){const e=t.geometry.type;if("Polygon"===e||"MultiPolygon"===e)return new Within(t,t.geometry)}else if("Polygon"===t.type||"MultiPolygon"===t.type)return new Within(t,t)}return t.error("'within' expression requires valid geojson object that contains polygon geometry type.")}evaluate(e){if(null!=e.geometry()&&null!=e.canonicalID()){if("Point"===e.geometryType())return function(e,t){const i=[1/0,1/0,-1/0,-1/0],r=[1/0,1/0,-1/0,-1/0],n=e.canonicalID();if(!n)return!1;if("Polygon"===t.type){const o=yi(t.coordinates,r,n),s=bi(e.geometry(),i,r,n);if(!ci(i,r))return!1;for(const e of s)if(!di(e,o))return!1}if("MultiPolygon"===t.type){const o=xi(t.coordinates,r,n),s=bi(e.geometry(),i,r,n);if(!ci(i,r))return!1;for(const e of s)if(!pi(e,o))return!1}return!0}(e,this.geometries);if("LineString"===e.geometryType())return function(e,t){const i=[1/0,1/0,-1/0,-1/0],r=[1/0,1/0,-1/0,-1/0],n=e.canonicalID();if(!n)return!1;if("Polygon"===t.type){const o=yi(t.coordinates,r,n),s=wi(e.geometry(),i,r,n);if(!ci(i,r))return!1;for(const e of s)if(!_i(e,o))return!1}if("MultiPolygon"===t.type){const o=xi(t.coordinates,r,n),s=wi(e.geometry(),i,r,n);if(!ci(i,r))return!1;for(const e of s)if(!gi(e,o))return!1}return!0}(e,this.geometries)}return!1}eachChild(){}outputDefined(){return!0}serialize(){return["within",this.geojson]}}var Ei=Within;function Ti(e){if(e instanceof si){if("get"===e.name&&1===e.args.length)return!1;if("feature-state"===e.name)return!1;if("has"===e.name&&1===e.args.length)return!1;if("properties"===e.name||"geometry-type"===e.name||"id"===e.name)return!1;if(/^filter-/.test(e.name))return!1}if(e instanceof Ei)return!1;let t=!0;return e.eachChild((e=>{t&&!Ti(e)&&(t=!1)})),t}function Si(e){if(e instanceof si&&"feature-state"===e.name)return!1;let t=!0;return e.eachChild((e=>{t&&!Si(e)&&(t=!1)})),t}function Ai(e,t){if(e instanceof si&&t.indexOf(e.name)>=0)return!1;let i=!0;return e.eachChild((e=>{i&&!Ai(e,t)&&(i=!1)})),i}class Var{constructor(e,t){this.type=t.type,this.name=e,this.boundExpression=t}static parse(e,t){if(2!==e.length||"string"!=typeof e[1])return t.error("'var' expression requires exactly one string literal argument.");const i=e[1];return t.scope.has(i)?new Var(i,t.scope.get(i)):t.error(`Unknown variable "${i}". Make sure "${i}" has been bound in an enclosing "let" expression before using it.`,1)}evaluate(e){return this.boundExpression.evaluate(e)}eachChild(){}outputDefined(){return!1}serialize(){return["var",this.name]}}var Ci=Var;class ParsingContext{constructor(e,t=[],i,r=new Et,n=[]){this.registry=e,this.path=t,this.key=t.map((e=>`[${e}]`)).join(""),this.scope=r,this.errors=n,this.expectedType=i}parse(e,t,i,r,n={}){return t?this.concat(t,i,r)._parse(e,n):this._parse(e,n)}_parse(e,t){function i(e,t,i){return"assert"===i?new ti(t,[e]):"coerce"===i?new ri(t,[e]):e}if(null!==e&&"string"!=typeof e&&"boolean"!=typeof e&&"number"!=typeof e||(e=["literal",e]),Array.isArray(e)){if(0===e.length)return this.error('Expected an array with at least one element. If you wanted a literal array, use ["literal", []].');const r=e[0];if("string"!=typeof r)return this.error(`Expression name must be a string, but found ${typeof r} instead. If you wanted a literal array, use ["literal", [...]].`,0),null;const n=this.registry[r];if(n){let r=n.parse(e,this);if(!r)return null;if(this.expectedType){const e=this.expectedType,n=r.type;if("string"!==e.kind&&"number"!==e.kind&&"boolean"!==e.kind&&"object"!==e.kind&&"array"!==e.kind||"value"!==n.kind)if("color"!==e.kind&&"formatted"!==e.kind&&"resolvedImage"!==e.kind||"value"!==n.kind&&"string"!==n.kind){if(this.checkSubtype(e,n))return null}else r=i(r,e,t.typeAnnotation||"coerce");else r=i(r,e,t.typeAnnotation||"assert")}if(!(r instanceof Yt)&&"resolvedImage"!==r.type.kind&&Mi(r)){const e=new oi;try{r=new Yt(r.type,r.evaluate(e))}catch(e){return this.error(e.message),null}}return r}return this.error(`Unknown expression "${r}". If you wanted a literal array, use ["literal", [...]].`,0)}return this.error(void 0===e?"'undefined' value invalid. Use null instead.":"object"==typeof e?'Bare objects invalid. Use ["literal", {...}] instead.':`Expected an array, but found ${typeof e} instead.`)}concat(e,t,i){const r="number"==typeof e?this.path.concat(e):this.path,n=i?this.scope.concat(i):this.scope;return new ParsingContext(this.registry,r,t||null,n,this.errors)}error(e,...t){const i=`${this.key}${t.map((e=>`[${e}]`)).join("")}`;this.errors.push(new wt(i,e))}checkSubtype(e,t){const i=Ot(e,t);return i&&this.error(i),i}}var Ii=ParsingContext;function Mi(e){if(e instanceof Ci)return Mi(e.boundExpression);if(e instanceof si&&"error"===e.name)return!1;if(e instanceof CollatorExpression)return!1;if(e instanceof Ei)return!1;const t=e instanceof ri||e instanceof ti;let i=!0;return e.eachChild((e=>{i=t?i&&Mi(e):i&&e instanceof Yt})),!!i&&Ti(e)&&Ai(e,["zoom","heatmap-density","line-progress","sky-radial-progress","accumulated","is-supported-script","pitch","distance-from-center"])}function Pi(e,t){const i=e.length-1;let r,n,o=0,s=i,a=0;for(;o<=s;)if(a=Math.floor((o+s)/2),r=e[a],n=e[a+1],r<=t){if(a===i||t<n)return a;o=a+1}else{if(!(r>t))throw new Qt("Input is not a number.");s=a-1}return 0}class Step{constructor(e,t,i){this.type=e,this.input=t,this.labels=[],this.outputs=[];for(const[e,t]of i)this.labels.push(e),this.outputs.push(t)}static parse(e,t){if(e.length-1<4)return t.error(`Expected at least 4 arguments, but found only ${e.length-1}.`);if((e.length-1)%2!=0)return t.error("Expected an even number of arguments.");const i=t.parse(e[1],1,St);if(!i)return null;const r=[];let n=null;t.expectedType&&"value"!==t.expectedType.kind&&(n=t.expectedType);for(let i=1;i<e.length;i+=2){const o=1===i?-1/0:e[i],s=e[i+1],a=i,l=i+1;if("number"!=typeof o)return t.error('Input/output pairs for "step" expressions must be defined using literal numeric values (not computed expressions) for the input values.',a);if(r.length&&r[r.length-1][0]>=o)return t.error('Input/output pairs for "step" expressions must be arranged with input values in strictly ascending order.',a);const c=t.parse(s,l,n);if(!c)return null;n=n||c.type,r.push([o,c])}return new Step(n,i,r)}evaluate(e){const t=this.labels,i=this.outputs;if(1===t.length)return i[0].evaluate(e);const r=this.input.evaluate(e);if(r<=t[0])return i[0].evaluate(e);const n=t.length;return r>=t[n-1]?i[n-1].evaluate(e):i[Pi(t,r)].evaluate(e)}eachChild(e){e(this.input);for(const t of this.outputs)e(t)}outputDefined(){return this.outputs.every((e=>e.outputDefined()))}serialize(){const e=["step",this.input.serialize()];for(let t=0;t<this.labels.length;t++)t>0&&e.push(this.labels[t]),e.push(this.outputs[t].serialize());return e}}var Di=Step;function zi(e,t,i){return e*(1-i)+t*i}var ki=Object.freeze({__proto__:null,array:function(e,t,i){return e.map(((e,r)=>zi(e,t[r],i)))},color:function(e,t,i){return new Wt(zi(e.r,t.r,i),zi(e.g,t.g,i),zi(e.b,t.b,i),zi(e.a,t.a,i))},number:zi});const Li=.95047,Bi=1.08883,Ri=4/29,Fi=6/29,Oi=3*Fi*Fi,Ui=Fi*Fi*Fi,Vi=Math.PI/180,ji=180/Math.PI;function Ni(e){return e>Ui?Math.pow(e,1/3):e/Oi+Ri}function Gi(e){return e>Fi?e*e*e:Oi*(e-Ri)}function qi(e){return 255*(e<=.0031308?12.92*e:1.055*Math.pow(e,1/2.4)-.055)}function Zi(e){return(e/=255)<=.04045?e/12.92:Math.pow((e+.055)/1.055,2.4)}function $i(e){const t=Zi(e.r),i=Zi(e.g),r=Zi(e.b),n=Ni((.4124564*t+.3575761*i+.1804375*r)/Li),o=Ni((.2126729*t+.7151522*i+.072175*r)/1);return{l:116*o-16,a:500*(n-o),b:200*(o-Ni((.0193339*t+.119192*i+.9503041*r)/Bi)),alpha:e.a}}function Wi(e){let t=(e.l+16)/116,i=isNaN(e.a)?t:t+e.a/500,r=isNaN(e.b)?t:t-e.b/200;return t=1*Gi(t),i=Li*Gi(i),r=Bi*Gi(r),new Wt(qi(3.2404542*i-1.5371385*t-.4985314*r),qi(-.969266*i+1.8760108*t+.041556*r),qi(.0556434*i-.2040259*t+1.0572252*r),e.alpha)}function Hi(e,t,i){const r=t-e;return e+i*(r>180||r<-180?r-360*Math.round(r/360):r)}const Xi={forward:$i,reverse:Wi,interpolate:function(e,t,i){return{l:zi(e.l,t.l,i),a:zi(e.a,t.a,i),b:zi(e.b,t.b,i),alpha:zi(e.alpha,t.alpha,i)}}},Ki={forward:function(e){const{l:t,a:i,b:r}=$i(e),n=Math.atan2(r,i)*ji;return{h:n<0?n+360:n,c:Math.sqrt(i*i+r*r),l:t,alpha:e.a}},reverse:function(e){const t=e.h*Vi,i=e.c;return Wi({l:e.l,a:Math.cos(t)*i,b:Math.sin(t)*i,alpha:e.alpha})},interpolate:function(e,t,i){return{h:Hi(e.h,t.h,i),c:zi(e.c,t.c,i),l:zi(e.l,t.l,i),alpha:zi(e.alpha,t.alpha,i)}}};var Ji=Object.freeze({__proto__:null,hcl:Ki,lab:Xi});class Interpolate{constructor(e,t,i,r,n){this.type=e,this.operator=t,this.interpolation=i,this.input=r,this.labels=[],this.outputs=[];for(const[e,t]of n)this.labels.push(e),this.outputs.push(t)}static interpolationFactor(e,t,i,r){let n=0;if("exponential"===e.name)n=Yi(t,e.base,i,r);else if("linear"===e.name)n=Yi(t,1,i,r);else if("cubic-bezier"===e.name){const o=e.controlPoints;n=new f(o[0],o[1],o[2],o[3]).solve(Yi(t,1,i,r))}return n}static parse(e,t){let[i,r,n,...o]=e;if(!Array.isArray(r)||0===r.length)return t.error("Expected an interpolation type expression.",1);if("linear"===r[0])r={name:"linear"};else if("exponential"===r[0]){const e=r[1];if("number"!=typeof e)return t.error("Exponential interpolation requires a numeric base.",1,1);r={name:"exponential",base:e}}else{if("cubic-bezier"!==r[0])return t.error(`Unknown interpolation type ${String(r[0])}`,1,0);{const e=r.slice(1);if(4!==e.length||e.some((e=>"number"!=typeof e||e<0||e>1)))return t.error("Cubic bezier interpolation requires four numeric arguments with values between 0 and 1.",1);r={name:"cubic-bezier",controlPoints:e}}}if(e.length-1<4)return t.error(`Expected at least 4 arguments, but found only ${e.length-1}.`);if((e.length-1)%2!=0)return t.error("Expected an even number of arguments.");if(n=t.parse(n,2,St),!n)return null;const s=[];let a=null;"interpolate-hcl"===i||"interpolate-lab"===i?a=Mt:t.expectedType&&"value"!==t.expectedType.kind&&(a=t.expectedType);for(let e=0;e<o.length;e+=2){const i=o[e],r=o[e+1],n=e+3,l=e+4;if("number"!=typeof i)return t.error('Input/output pairs for "interpolate" expressions must be defined using literal numeric values (not computed expressions) for the input values.',n);if(s.length&&s[s.length-1][0]>=i)return t.error('Input/output pairs for "interpolate" expressions must be arranged with input values in strictly ascending order.',n);const c=t.parse(r,l,a);if(!c)return null;a=a||c.type,s.push([i,c])}return"number"===a.kind||"color"===a.kind||"array"===a.kind&&"number"===a.itemType.kind&&"number"==typeof a.N?new Interpolate(a,i,r,n,s):t.error(`Type ${Rt(a)} is not interpolatable.`)}evaluate(e){const t=this.labels,i=this.outputs;if(1===t.length)return i[0].evaluate(e);const r=this.input.evaluate(e);if(r<=t[0])return i[0].evaluate(e);const n=t.length;if(r>=t[n-1])return i[n-1].evaluate(e);const o=Pi(t,r),s=Interpolate.interpolationFactor(this.interpolation,r,t[o],t[o+1]),a=i[o].evaluate(e),l=i[o+1].evaluate(e);return"interpolate"===this.operator?ki[this.type.kind.toLowerCase()](a,l,s):"interpolate-hcl"===this.operator?Ki.reverse(Ki.interpolate(Ki.forward(a),Ki.forward(l),s)):Xi.reverse(Xi.interpolate(Xi.forward(a),Xi.forward(l),s))}eachChild(e){e(this.input);for(const t of this.outputs)e(t)}outputDefined(){return this.outputs.every((e=>e.outputDefined()))}serialize(){let e;e="linear"===this.interpolation.name?["linear"]:"exponential"===this.interpolation.name?1===this.interpolation.base?["linear"]:["exponential",this.interpolation.base]:["cubic-bezier"].concat(this.interpolation.controlPoints);const t=[this.operator,e,this.input.serialize()];for(let e=0;e<this.labels.length;e++)t.push(this.labels[e],this.outputs[e].serialize());return t}}function Yi(e,t,i,r){const n=r-i,o=e-i;return 0===n?0:1===t?o/n:(Math.pow(t,o)-1)/(Math.pow(t,n)-1)}var Qi=Interpolate;class Coalesce{constructor(e,t){this.type=e,this.args=t}static parse(e,t){if(e.length<2)return t.error("Expectected at least one argument.");let i=null;const r=t.expectedType;r&&"value"!==r.kind&&(i=r);const n=[];for(const r of e.slice(1)){const e=t.parse(r,1+n.length,i,void 0,{typeAnnotation:"omit"});if(!e)return null;i=i||e.type,n.push(e)}const o=r&&n.some((e=>Ot(r,e.type)));return new Coalesce(o?Dt:i,n)}evaluate(e){let t,i=null,r=0;for(const n of this.args){if(r++,i=n.evaluate(e),i&&i instanceof ResolvedImage&&!i.available&&(t||(t=i),i=null,r===this.args.length))return t;if(null!==i)break}return i}eachChild(e){this.args.forEach(e)}outputDefined(){return this.args.every((e=>e.outputDefined()))}serialize(){const e=["coalesce"];return this.eachChild((t=>{e.push(t.serialize())})),e}}var er=Coalesce;class Let{constructor(e,t){this.type=t.type,this.bindings=[].concat(e),this.result=t}evaluate(e){return this.result.evaluate(e)}eachChild(e){for(const t of this.bindings)e(t[1]);e(this.result)}static parse(e,t){if(e.length<4)return t.error(`Expected at least 3 arguments, but found ${e.length-1} instead.`);const i=[];for(let r=1;r<e.length-1;r+=2){const n=e[r];if("string"!=typeof n)return t.error(`Expected string, but found ${typeof n} instead.`,r);if(/[^a-zA-Z0-9_]/.test(n))return t.error("Variable names must contain only alphanumeric characters or '_'.",r);const o=t.parse(e[r+1],r+1);if(!o)return null;i.push([n,o])}const r=t.parse(e[e.length-1],e.length-1,t.expectedType,i);return r?new Let(i,r):null}outputDefined(){return this.result.outputDefined()}serialize(){const e=["let"];for(const[t,i]of this.bindings)e.push(t,i.serialize());return e.push(this.result.serialize()),e}}var tr=Let;class At{constructor(e,t,i){this.type=e,this.index=t,this.input=i}static parse(e,t){if(3!==e.length)return t.error(`Expected 2 arguments, but found ${e.length-1} instead.`);const i=t.parse(e[1],1,St),r=t.parse(e[2],2,Bt(t.expectedType||Dt));return i&&r?new At(r.type.itemType,i,r):null}evaluate(e){const t=this.index.evaluate(e),i=this.input.evaluate(e);if(t<0)throw new Qt(`Array index out of bounds: ${t} < 0.`);if(t>=i.length)throw new Qt(`Array index out of bounds: ${t} > ${i.length-1}.`);if(t!==Math.floor(t))throw new Qt(`Array index must be an integer, but found ${t} instead.`);return i[t]}eachChild(e){e(this.index),e(this.input)}outputDefined(){return!1}serialize(){return["at",this.index.serialize(),this.input.serialize()]}}var ir=At;class In{constructor(e,t){this.type=It,this.needle=e,this.haystack=t}static parse(e,t){if(3!==e.length)return t.error(`Expected 2 arguments, but found ${e.length-1} instead.`);const i=t.parse(e[1],1,Dt),r=t.parse(e[2],2,Dt);return i&&r?Ut(i.type,[It,Ct,St,Tt,Dt])?new In(i,r):t.error(`Expected first argument to be of type boolean, string, number or null, but found ${Rt(i.type)} instead`):null}evaluate(e){const t=this.needle.evaluate(e),i=this.haystack.evaluate(e);if(null==i)return!1;if(!Vt(t,["boolean","string","number","null"]))throw new Qt(`Expected first argument to be of type boolean, string, number or null, but found ${Rt(Kt(t))} instead.`);if(!Vt(i,["string","array"]))throw new Qt(`Expected second argument to be of type array or string, but found ${Rt(Kt(i))} instead.`);return i.indexOf(t)>=0}eachChild(e){e(this.needle),e(this.haystack)}outputDefined(){return!0}serialize(){return["in",this.needle.serialize(),this.haystack.serialize()]}}var rr=In;class IndexOf{constructor(e,t,i){this.type=St,this.needle=e,this.haystack=t,this.fromIndex=i}static parse(e,t){if(e.length<=2||e.length>=5)return t.error(`Expected 3 or 4 arguments, but found ${e.length-1} instead.`);const i=t.parse(e[1],1,Dt),r=t.parse(e[2],2,Dt);if(!i||!r)return null;if(!Ut(i.type,[It,Ct,St,Tt,Dt]))return t.error(`Expected first argument to be of type boolean, string, number or null, but found ${Rt(i.type)} instead`);if(4===e.length){const n=t.parse(e[3],3,St);return n?new IndexOf(i,r,n):null}return new IndexOf(i,r)}evaluate(e){const t=this.needle.evaluate(e),i=this.haystack.evaluate(e);if(!Vt(t,["boolean","string","number","null"]))throw new Qt(`Expected first argument to be of type boolean, string, number or null, but found ${Rt(Kt(t))} instead.`);if(!Vt(i,["string","array"]))throw new Qt(`Expected second argument to be of type array or string, but found ${Rt(Kt(i))} instead.`);if(this.fromIndex){const r=this.fromIndex.evaluate(e);return i.indexOf(t,r)}return i.indexOf(t)}eachChild(e){e(this.needle),e(this.haystack),this.fromIndex&&e(this.fromIndex)}outputDefined(){return!1}serialize(){if(null!=this.fromIndex&&void 0!==this.fromIndex){const e=this.fromIndex.serialize();return["index-of",this.needle.serialize(),this.haystack.serialize(),e]}return["index-of",this.needle.serialize(),this.haystack.serialize()]}}var nr=IndexOf;class Match{constructor(e,t,i,r,n,o){this.inputType=e,this.type=t,this.input=i,this.cases=r,this.outputs=n,this.otherwise=o}static parse(e,t){if(e.length<5)return t.error(`Expected at least 4 arguments, but found only ${e.length-1}.`);if(e.length%2!=1)return t.error("Expected an even number of arguments.");let i,r;t.expectedType&&"value"!==t.expectedType.kind&&(r=t.expectedType);const n={},o=[];for(let s=2;s<e.length-1;s+=2){let a=e[s];const l=e[s+1];Array.isArray(a)||(a=[a]);const c=t.concat(s);if(0===a.length)return c.error("Expected at least one branch label.");for(const e of a){if("number"!=typeof e&&"string"!=typeof e)return c.error("Branch labels must be numbers or strings.");if("number"==typeof e&&Math.abs(e)>Number.MAX_SAFE_INTEGER)return c.error(`Branch labels must be integers no larger than ${Number.MAX_SAFE_INTEGER}.`);if("number"==typeof e&&Math.floor(e)!==e)return c.error("Numeric branch labels must be integer values.");if(i){if(c.checkSubtype(i,Kt(e)))return null}else i=Kt(e);if(void 0!==n[String(e)])return c.error("Branch labels must be unique.");n[String(e)]=o.length}const u=t.parse(l,s,r);if(!u)return null;r=r||u.type,o.push(u)}const s=t.parse(e[1],1,Dt);if(!s)return null;const a=t.parse(e[e.length-1],e.length-1,r);return a?"value"!==s.type.kind&&t.concat(1).checkSubtype(i,s.type)?null:new Match(i,r,s,n,o,a):null}evaluate(e){const t=this.input.evaluate(e);return(Kt(t)===this.inputType&&this.outputs[this.cases[t]]||this.otherwise).evaluate(e)}eachChild(e){e(this.input),this.outputs.forEach(e),e(this.otherwise)}outputDefined(){return this.outputs.every((e=>e.outputDefined()))&&this.otherwise.outputDefined()}serialize(){const e=["match",this.input.serialize()],t=Object.keys(this.cases).sort(),i=[],r={};for(const e of t){const t=r[this.cases[e]];void 0===t?(r[this.cases[e]]=i.length,i.push([this.cases[e],[e]])):i[t][1].push(e)}const n=e=>"number"===this.inputType.kind?Number(e):e;for(const[t,r]of i)e.push(1===r.length?n(r[0]):r.map(n)),e.push(this.outputs[t].serialize());return e.push(this.otherwise.serialize()),e}}var or=Match;class Case{constructor(e,t,i){this.type=e,this.branches=t,this.otherwise=i}static parse(e,t){if(e.length<4)return t.error(`Expected at least 3 arguments, but found only ${e.length-1}.`);if(e.length%2!=0)return t.error("Expected an odd number of arguments.");let i;t.expectedType&&"value"!==t.expectedType.kind&&(i=t.expectedType);const r=[];for(let n=1;n<e.length-1;n+=2){const o=t.parse(e[n],n,It);if(!o)return null;const s=t.parse(e[n+1],n+1,i);if(!s)return null;r.push([o,s]),i=i||s.type}const n=t.parse(e[e.length-1],e.length-1,i);return n?new Case(i,r,n):null}evaluate(e){for(const[t,i]of this.branches)if(t.evaluate(e))return i.evaluate(e);return this.otherwise.evaluate(e)}eachChild(e){for(const[t,i]of this.branches)e(t),e(i);e(this.otherwise)}outputDefined(){return this.branches.every((([e,t])=>t.outputDefined()))&&this.otherwise.outputDefined()}serialize(){const e=["case"];return this.eachChild((t=>{e.push(t.serialize())})),e}}var sr=Case;class Slice{constructor(e,t,i,r){this.type=e,this.input=t,this.beginIndex=i,this.endIndex=r}static parse(e,t){if(e.length<=2||e.length>=5)return t.error(`Expected 3 or 4 arguments, but found ${e.length-1} instead.`);const i=t.parse(e[1],1,Dt),r=t.parse(e[2],2,St);if(!i||!r)return null;if(!Ut(i.type,[Bt(Dt),Ct,Dt]))return t.error(`Expected first argument to be of type array or string, but found ${Rt(i.type)} instead`);if(4===e.length){const n=t.parse(e[3],3,St);return n?new Slice(i.type,i,r,n):null}return new Slice(i.type,i,r)}evaluate(e){const t=this.input.evaluate(e),i=this.beginIndex.evaluate(e);if(!Vt(t,["string","array"]))throw new Qt(`Expected first argument to be of type array or string, but found ${Rt(Kt(t))} instead.`);if(this.endIndex){const r=this.endIndex.evaluate(e);return t.slice(i,r)}return t.slice(i)}eachChild(e){e(this.input),e(this.beginIndex),this.endIndex&&e(this.endIndex)}outputDefined(){return!1}serialize(){if(null!=this.endIndex&&void 0!==this.endIndex){const e=this.endIndex.serialize();return["slice",this.input.serialize(),this.beginIndex.serialize(),e]}return["slice",this.input.serialize(),this.beginIndex.serialize()]}}var ar=Slice;function lr(e,t){return"=="===e||"!="===e?"boolean"===t.kind||"string"===t.kind||"number"===t.kind||"null"===t.kind||"value"===t.kind:"string"===t.kind||"number"===t.kind||"value"===t.kind}function cr(e,t,i,r){return 0===r.compare(t,i)}function ur(e,t,i){const r="=="!==e&&"!="!==e;return class Comparison{constructor(e,t,i){this.type=It,this.lhs=e,this.rhs=t,this.collator=i,this.hasUntypedArgument="value"===e.type.kind||"value"===t.type.kind}static parse(e,t){if(3!==e.length&&4!==e.length)return t.error("Expected two or three arguments.");const i=e[0];let n=t.parse(e[1],1,Dt);if(!n)return null;if(!lr(i,n.type))return t.concat(1).error(`"${i}" comparisons are not supported for type '${Rt(n.type)}'.`);let o=t.parse(e[2],2,Dt);if(!o)return null;if(!lr(i,o.type))return t.concat(2).error(`"${i}" comparisons are not supported for type '${Rt(o.type)}'.`);if(n.type.kind!==o.type.kind&&"value"!==n.type.kind&&"value"!==o.type.kind)return t.error(`Cannot compare types '${Rt(n.type)}' and '${Rt(o.type)}'.`);r&&("value"===n.type.kind&&"value"!==o.type.kind?n=new ti(o.type,[n]):"value"!==n.type.kind&&"value"===o.type.kind&&(o=new ti(n.type,[o])));let s=null;if(4===e.length){if("string"!==n.type.kind&&"string"!==o.type.kind&&"value"!==n.type.kind&&"value"!==o.type.kind)return t.error("Cannot use collator to compare non-string types.");if(s=t.parse(e[3],3,zt),!s)return null}return new Comparison(n,o,s)}evaluate(n){const o=this.lhs.evaluate(n),s=this.rhs.evaluate(n);if(r&&this.hasUntypedArgument){const t=Kt(o),i=Kt(s);if(t.kind!==i.kind||"string"!==t.kind&&"number"!==t.kind)throw new Qt(`Expected arguments for "${e}" to be (string, string) or (number, number), but found (${t.kind}, ${i.kind}) instead.`)}if(this.collator&&!r&&this.hasUntypedArgument){const e=Kt(o),i=Kt(s);if("string"!==e.kind||"string"!==i.kind)return t(n,o,s)}return this.collator?i(n,o,s,this.collator.evaluate(n)):t(n,o,s)}eachChild(e){e(this.lhs),e(this.rhs),this.collator&&e(this.collator)}outputDefined(){return!0}serialize(){const t=[e];return this.eachChild((e=>{t.push(e.serialize())})),t}}}const hr=ur("==",(function(e,t,i){return t===i}),cr),dr=ur("!=",(function(e,t,i){return t!==i}),(function(e,t,i,r){return!cr(0,t,i,r)})),pr=ur("<",(function(e,t,i){return t<i}),(function(e,t,i,r){return r.compare(t,i)<0})),fr=ur(">",(function(e,t,i){return t>i}),(function(e,t,i,r){return r.compare(t,i)>0})),mr=ur("<=",(function(e,t,i){return t<=i}),(function(e,t,i,r){return r.compare(t,i)<=0})),_r=ur(">=",(function(e,t,i){return t>=i}),(function(e,t,i,r){return r.compare(t,i)>=0}));class NumberFormat{constructor(e,t,i,r,n,o){this.type=Ct,this.number=e,this.locale=t,this.currency=i,this.unit=r,this.minFractionDigits=n,this.maxFractionDigits=o}static parse(e,t){if(3!==e.length)return t.error("Expected two arguments.");const i=t.parse(e[1],1,St);if(!i)return null;const r=e[2];if("object"!=typeof r||Array.isArray(r))return t.error("NumberFormat options argument must be an object.");let n=null;if(r.locale&&(n=t.parse(r.locale,1,Ct),!n))return null;let o=null;if(r.currency&&(o=t.parse(r.currency,1,Ct),!o))return null;let s=null;if(r.unit&&(s=t.parse(r.unit,1,Ct),!s))return null;let a=null;if(r["min-fraction-digits"]&&(a=t.parse(r["min-fraction-digits"],1,St),!a))return null;let l=null;return r["max-fraction-digits"]&&(l=t.parse(r["max-fraction-digits"],1,St),!l)?null:new NumberFormat(i,n,o,s,a,l)}evaluate(e){return new Intl.NumberFormat(this.locale?this.locale.evaluate(e):[],{style:(this.currency?"currency":this.unit&&"unit")||"decimal",currency:this.currency?this.currency.evaluate(e):void 0,unit:this.unit?this.unit.evaluate(e):void 0,minimumFractionDigits:this.minFractionDigits?this.minFractionDigits.evaluate(e):void 0,maximumFractionDigits:this.maxFractionDigits?this.maxFractionDigits.evaluate(e):void 0}).format(this.number.evaluate(e))}eachChild(e){e(this.number),this.locale&&e(this.locale),this.currency&&e(this.currency),this.unit&&e(this.unit),this.minFractionDigits&&e(this.minFractionDigits),this.maxFractionDigits&&e(this.maxFractionDigits)}outputDefined(){return!1}serialize(){const e={};return this.locale&&(e.locale=this.locale.serialize()),this.currency&&(e.currency=this.currency.serialize()),this.unit&&(e.unit=this.unit.serialize()),this.minFractionDigits&&(e["min-fraction-digits"]=this.minFractionDigits.serialize()),this.maxFractionDigits&&(e["max-fraction-digits"]=this.maxFractionDigits.serialize()),["number-format",this.number.serialize(),e]}}class Length{constructor(e){this.type=St,this.input=e}static parse(e,t){if(2!==e.length)return t.error(`Expected 1 argument, but found ${e.length-1} instead.`);const i=t.parse(e[1],1);return i?"array"!==i.type.kind&&"string"!==i.type.kind&&"value"!==i.type.kind?t.error(`Expected argument of type string or array, but found ${Rt(i.type)} instead.`):new Length(i):null}evaluate(e){const t=this.input.evaluate(e);if("string"==typeof t)return t.length;if(Array.isArray(t))return t.length;throw new Qt(`Expected value to be of type string or array, but found ${Rt(Kt(t))} instead.`)}eachChild(e){e(this.input)}outputDefined(){return!1}serialize(){const e=["length"];return this.eachChild((t=>{e.push(t.serialize())})),e}}const gr={"==":hr,"!=":dr,">":fr,"<":pr,">=":_r,"<=":mr,array:ti,at:ir,boolean:ti,case:sr,coalesce:er,collator:CollatorExpression,format:FormatExpression,image:ImageExpression,in:rr,"index-of":nr,interpolate:Qi,"interpolate-hcl":Qi,"interpolate-lab":Qi,length:Length,let:tr,literal:Yt,match:or,number:ti,"number-format":NumberFormat,object:ti,slice:ar,step:Di,string:ti,"to-boolean":ri,"to-color":ri,"to-number":ri,"to-string":ri,var:Ci,within:Ei};function yr(e,[t,i,r,n]){t=t.evaluate(e),i=i.evaluate(e),r=r.evaluate(e);const o=n?n.evaluate(e):1,s=Ht(t,i,r,o);if(s)throw new Qt(s);return new Wt(t/255*o,i/255*o,r/255*o,o)}function xr(e,t){return e in t}function vr(e,t){const i=t[e];return void 0===i?null:i}function br(e){return{type:e}}si.register(gr,{error:[{kind:"error"},[Ct],(e,[t])=>{throw new Qt(t.evaluate(e))}],typeof:[Ct,[Dt],(e,[t])=>Rt(Kt(t.evaluate(e)))],"to-rgba":[Bt(St,4),[Mt],(e,[t])=>t.evaluate(e).toArray()],rgb:[Mt,[St,St,St],yr],rgba:[Mt,[St,St,St,St],yr],has:{type:It,overloads:[[[Ct],(e,[t])=>xr(t.evaluate(e),e.properties())],[[Ct,Pt],(e,[t,i])=>xr(t.evaluate(e),i.evaluate(e))]]},get:{type:Dt,overloads:[[[Ct],(e,[t])=>vr(t.evaluate(e),e.properties())],[[Ct,Pt],(e,[t,i])=>vr(t.evaluate(e),i.evaluate(e))]]},"feature-state":[Dt,[Ct],(e,[t])=>vr(t.evaluate(e),e.featureState||{})],properties:[Pt,[],e=>e.properties()],"geometry-type":[Ct,[],e=>e.geometryType()],id:[Dt,[],e=>e.id()],zoom:[St,[],e=>e.globals.zoom],pitch:[St,[],e=>e.globals.pitch||0],"distance-from-center":[St,[],e=>e.distanceFromCenter()],"heatmap-density":[St,[],e=>e.globals.heatmapDensity||0],"line-progress":[St,[],e=>e.globals.lineProgress||0],"sky-radial-progress":[St,[],e=>e.globals.skyRadialProgress||0],accumulated:[Dt,[],e=>void 0===e.globals.accumulated?null:e.globals.accumulated],"+":[St,br(St),(e,t)=>{let i=0;for(const r of t)i+=r.evaluate(e);return i}],"*":[St,br(St),(e,t)=>{let i=1;for(const r of t)i*=r.evaluate(e);return i}],"-":{type:St,overloads:[[[St,St],(e,[t,i])=>t.evaluate(e)-i.evaluate(e)],[[St],(e,[t])=>-t.evaluate(e)]]},"/":[St,[St,St],(e,[t,i])=>t.evaluate(e)/i.evaluate(e)],"%":[St,[St,St],(e,[t,i])=>t.evaluate(e)%i.evaluate(e)],ln2:[St,[],()=>Math.LN2],pi:[St,[],()=>Math.PI],e:[St,[],()=>Math.E],"^":[St,[St,St],(e,[t,i])=>Math.pow(t.evaluate(e),i.evaluate(e))],sqrt:[St,[St],(e,[t])=>Math.sqrt(t.evaluate(e))],log10:[St,[St],(e,[t])=>Math.log(t.evaluate(e))/Math.LN10],ln:[St,[St],(e,[t])=>Math.log(t.evaluate(e))],log2:[St,[St],(e,[t])=>Math.log(t.evaluate(e))/Math.LN2],sin:[St,[St],(e,[t])=>Math.sin(t.evaluate(e))],cos:[St,[St],(e,[t])=>Math.cos(t.evaluate(e))],tan:[St,[St],(e,[t])=>Math.tan(t.evaluate(e))],asin:[St,[St],(e,[t])=>Math.asin(t.evaluate(e))],acos:[St,[St],(e,[t])=>Math.acos(t.evaluate(e))],atan:[St,[St],(e,[t])=>Math.atan(t.evaluate(e))],min:[St,br(St),(e,t)=>Math.min(...t.map((t=>t.evaluate(e))))],max:[St,br(St),(e,t)=>Math.max(...t.map((t=>t.evaluate(e))))],abs:[St,[St],(e,[t])=>Math.abs(t.evaluate(e))],round:[St,[St],(e,[t])=>{const i=t.evaluate(e);return i<0?-Math.round(-i):Math.round(i)}],floor:[St,[St],(e,[t])=>Math.floor(t.evaluate(e))],ceil:[St,[St],(e,[t])=>Math.ceil(t.evaluate(e))],"filter-==":[It,[Ct,Dt],(e,[t,i])=>e.properties()[t.value]===i.value],"filter-id-==":[It,[Dt],(e,[t])=>e.id()===t.value],"filter-type-==":[It,[Ct],(e,[t])=>e.geometryType()===t.value],"filter-<":[It,[Ct,Dt],(e,[t,i])=>{const r=e.properties()[t.value],n=i.value;return typeof r==typeof n&&r<n}],"filter-id-<":[It,[Dt],(e,[t])=>{const i=e.id(),r=t.value;return typeof i==typeof r&&i<r}],"filter->":[It,[Ct,Dt],(e,[t,i])=>{const r=e.properties()[t.value],n=i.value;return typeof r==typeof n&&r>n}],"filter-id->":[It,[Dt],(e,[t])=>{const i=e.id(),r=t.value;return typeof i==typeof r&&i>r}],"filter-<=":[It,[Ct,Dt],(e,[t,i])=>{const r=e.properties()[t.value],n=i.value;return typeof r==typeof n&&r<=n}],"filter-id-<=":[It,[Dt],(e,[t])=>{const i=e.id(),r=t.value;return typeof i==typeof r&&i<=r}],"filter->=":[It,[Ct,Dt],(e,[t,i])=>{const r=e.properties()[t.value],n=i.value;return typeof r==typeof n&&r>=n}],"filter-id->=":[It,[Dt],(e,[t])=>{const i=e.id(),r=t.value;return typeof i==typeof r&&i>=r}],"filter-has":[It,[Dt],(e,[t])=>t.value in e.properties()],"filter-has-id":[It,[],e=>null!==e.id()&&void 0!==e.id()],"filter-type-in":[It,[Bt(Ct)],(e,[t])=>t.value.indexOf(e.geometryType())>=0],"filter-id-in":[It,[Bt(Dt)],(e,[t])=>t.value.indexOf(e.id())>=0],"filter-in-small":[It,[Ct,Bt(Dt)],(e,[t,i])=>i.value.indexOf(e.properties()[t.value])>=0],"filter-in-large":[It,[Ct,Bt(Dt)],(e,[t,i])=>function(e,t,i,r){for(;i<=r;){const n=i+r>>1;if(t[n]===e)return!0;t[n]>e?r=n-1:i=n+1}return!1}(e.properties()[t.value],i.value,0,i.value.length-1)],all:{type:It,overloads:[[[It,It],(e,[t,i])=>t.evaluate(e)&&i.evaluate(e)],[br(It),(e,t)=>{for(const i of t)if(!i.evaluate(e))return!1;return!0}]]},any:{type:It,overloads:[[[It,It],(e,[t,i])=>t.evaluate(e)||i.evaluate(e)],[br(It),(e,t)=>{for(const i of t)if(i.evaluate(e))return!0;return!1}]]},"!":[It,[It],(e,[t])=>!t.evaluate(e)],"is-supported-script":[It,[Ct],(e,[t])=>{const i=e.globals&&e.globals.isSupportedScript;return!i||i(t.evaluate(e))}],upcase:[Ct,[Ct],(e,[t])=>t.evaluate(e).toUpperCase()],downcase:[Ct,[Ct],(e,[t])=>t.evaluate(e).toLowerCase()],concat:[Ct,br(Dt),(e,t)=>t.map((t=>Jt(t.evaluate(e)))).join("")],"resolved-locale":[Ct,[zt],(e,[t])=>t.evaluate(e).resolvedLocale()]});var wr=gr;function Er(e){return{result:"success",value:e}}function Tr(e){return{result:"error",value:e}}function Sr(e){return"data-driven"===e["property-type"]}function Ar(e){return!!e.expression&&e.expression.parameters.indexOf("zoom")>-1}function Cr(e){return!!e.expression&&e.expression.interpolated}function Ir(e){return e instanceof Number?"number":e instanceof String?"string":e instanceof Boolean?"boolean":Array.isArray(e)?"array":null===e?"null":typeof e}function Mr(e){return"object"==typeof e&&null!==e&&!Array.isArray(e)}function Pr(e){return e}function Dr(e,t){const i="color"===t.type,r=e.stops&&"object"==typeof e.stops[0][0],n=r||!(r||void 0!==e.property),o=e.type||(Cr(t)?"exponential":"interval");if(i&&((e=xt({},e)).stops&&(e.stops=e.stops.map((e=>[e[0],Wt.parse(e[1])]))),e.default=Wt.parse(e.default?e.default:t.default)),e.colorSpace&&"rgb"!==e.colorSpace&&!Ji[e.colorSpace])throw new Error(`Unknown color space: ${e.colorSpace}`);let s,a,l;if("exponential"===o)s=Br;else if("interval"===o)s=Lr;else if("categorical"===o){s=kr,a=Object.create(null);for(const t of e.stops)a[t[0]]=t[1];l=typeof e.stops[0][0]}else{if("identity"!==o)throw new Error(`Unknown function type "${o}"`);s=Rr}if(r){const i={},r=[];for(let t=0;t<e.stops.length;t++){const n=e.stops[t],o=n[0].zoom;void 0===i[o]&&(i[o]={zoom:o,type:e.type,property:e.property,default:e.default,stops:[]},r.push(o)),i[o].stops.push([n[0].value,n[1]])}const n=[];for(const e of r)n.push([i[e].zoom,Dr(i[e],t)]);const o={name:"linear"};return{kind:"composite",interpolationType:o,interpolationFactor:Qi.interpolationFactor.bind(void 0,o),zoomStops:n.map((e=>e[0])),evaluate:({zoom:i},r)=>Br({stops:n,base:e.base},t,i).evaluate(i,r)}}if(n){const i="exponential"===o?{name:"exponential",base:void 0!==e.base?e.base:1}:null;return{kind:"camera",interpolationType:i,interpolationFactor:Qi.interpolationFactor.bind(void 0,i),zoomStops:e.stops.map((e=>e[0])),evaluate:({zoom:i})=>s(e,t,i,a,l)}}return{kind:"source",evaluate(i,r){const n=r&&r.properties?r.properties[e.property]:void 0;return void 0===n?zr(e.default,t.default):s(e,t,n,a,l)}}}function zr(e,t,i){return void 0!==e?e:void 0!==t?t:void 0!==i?i:void 0}function kr(e,t,i,r,n){return zr(typeof i===n?r[i]:void 0,e.default,t.default)}function Lr(e,t,i){if("number"!==Ir(i))return zr(e.default,t.default);const r=e.stops.length;if(1===r)return e.stops[0][1];if(i<=e.stops[0][0])return e.stops[0][1];if(i>=e.stops[r-1][0])return e.stops[r-1][1];const n=Pi(e.stops.map((e=>e[0])),i);return e.stops[n][1]}function Br(e,t,i){const r=void 0!==e.base?e.base:1;if("number"!==Ir(i))return zr(e.default,t.default);const n=e.stops.length;if(1===n)return e.stops[0][1];if(i<=e.stops[0][0])return e.stops[0][1];if(i>=e.stops[n-1][0])return e.stops[n-1][1];const o=Pi(e.stops.map((e=>e[0])),i),s=function(e,t,i,r){const n=r-i,o=e-i;return 0===n?0:1===t?o/n:(Math.pow(t,o)-1)/(Math.pow(t,n)-1)}(i,r,e.stops[o][0],e.stops[o+1][0]),a=e.stops[o][1],l=e.stops[o+1][1];let c=ki[t.type]||Pr;if(e.colorSpace&&"rgb"!==e.colorSpace){const t=Ji[e.colorSpace];c=(e,i)=>t.reverse(t.interpolate(t.forward(e),t.forward(i),s))}return"function"==typeof a.evaluate?{evaluate(...e){const t=a.evaluate.apply(void 0,e),i=l.evaluate.apply(void 0,e);if(void 0!==t&&void 0!==i)return c(t,i,s)}}:c(a,l,s)}function Rr(e,t,i){return"color"===t.type?i=Wt.parse(i):"formatted"===t.type?i=Formatted.fromString(i.toString()):"resolvedImage"===t.type?i=ResolvedImage.fromString(i.toString()):Ir(i)===t.type||"enum"===t.type&&t.values[i]||(i=void 0),zr(i,e.default,t.default)}class StyleExpression{constructor(e,t){this.expression=e,this._warningHistory={},this._evaluator=new oi,this._defaultValue=t?function(e){return"color"===e.type&&(Mr(e.default)||Array.isArray(e.default))?new Wt(0,0,0,0):"color"===e.type?Wt.parse(e.default)||null:void 0===e.default?null:e.default}(t):null,this._enumValues=t&&"enum"===t.type?t.values:null}evaluateWithoutErrorHandling(e,t,i,r,n,o,s,a){return this._evaluator.globals=e,this._evaluator.feature=t,this._evaluator.featureState=i,this._evaluator.canonical=r||null,this._evaluator.availableImages=n||null,this._evaluator.formattedSection=o,this._evaluator.featureTileCoord=s||null,this._evaluator.featureDistanceData=a||null,this.expression.evaluate(this._evaluator)}evaluate(e,t,i,r,n,o,s,a){this._evaluator.globals=e,this._evaluator.feature=t||null,this._evaluator.featureState=i||null,this._evaluator.canonical=r||null,this._evaluator.availableImages=n||null,this._evaluator.formattedSection=o||null,this._evaluator.featureTileCoord=s||null,this._evaluator.featureDistanceData=a||null;try{const e=this.expression.evaluate(this._evaluator);if(null==e||"number"==typeof e&&e!=e)return this._defaultValue;if(this._enumValues&&!(e in this._enumValues))throw new Qt(`Expected value to be one of ${Object.keys(this._enumValues).map((e=>JSON.stringify(e))).join(", ")}, but found ${JSON.stringify(e)} instead.`);return e}catch(e){return this._warningHistory[e.message]||(this._warningHistory[e.message]=!0,"undefined"!=typeof console&&console.warn(e.message)),this._defaultValue}}}function Fr(e){return Array.isArray(e)&&e.length>0&&"string"==typeof e[0]&&e[0]in wr}function Or(e,t){const i=new Ii(wr,[],t?function(e){const t={color:Mt,string:Ct,number:St,enum:Ct,boolean:It,formatted:kt,resolvedImage:Lt};return"array"===e.type?Bt(t[e.value]||Dt,e.length):t[e.type]}(t):void 0),r=i.parse(e,void 0,void 0,void 0,t&&"string"===t.type?{typeAnnotation:"coerce"}:void 0);return r?Er(new StyleExpression(r,t)):Tr(i.errors)}class ZoomConstantExpression{constructor(e,t){this.kind=e,this._styleExpression=t,this.isStateDependent="constant"!==e&&!Si(t.expression)}evaluateWithoutErrorHandling(e,t,i,r,n,o){return this._styleExpression.evaluateWithoutErrorHandling(e,t,i,r,n,o)}evaluate(e,t,i,r,n,o){return this._styleExpression.evaluate(e,t,i,r,n,o)}}class ZoomDependentExpression{constructor(e,t,i,r){this.kind=e,this.zoomStops=i,this._styleExpression=t,this.isStateDependent="camera"!==e&&!Si(t.expression),this.interpolationType=r}evaluateWithoutErrorHandling(e,t,i,r,n,o){return this._styleExpression.evaluateWithoutErrorHandling(e,t,i,r,n,o)}evaluate(e,t,i,r,n,o){return this._styleExpression.evaluate(e,t,i,r,n,o)}interpolationFactor(e,t,i){return this.interpolationType?Qi.interpolationFactor(this.interpolationType,e,t,i):0}}function Ur(e,t){if("error"===(e=Or(e,t)).result)return e;const i=e.value.expression,r=Ti(i);if(!r&&!Sr(t))return Tr([new wt("","data expressions not supported")]);const n=Ai(i,["zoom","pitch","distance-from-center"]);if(!n&&!Ar(t))return Tr([new wt("","zoom expressions not supported")]);const o=Vr(i);return o||n?o instanceof wt?Tr([o]):o instanceof Qi&&!Cr(t)?Tr([new wt("",'"interpolate" expressions cannot be used with this property')]):Er(o?new ZoomDependentExpression(r?"camera":"composite",e.value,o.labels,o instanceof Qi?o.interpolation:void 0):new ZoomConstantExpression(r?"constant":"source",e.value)):Tr([new wt("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.')])}class StylePropertyFunction{constructor(e,t){this._parameters=e,this._specification=t,xt(this,Dr(this._parameters,this._specification))}static deserialize(e){return new StylePropertyFunction(e._parameters,e._specification)}static serialize(e){return{_parameters:e._parameters,_specification:e._specification}}}function Vr(e){let t=null;if(e instanceof tr)t=Vr(e.result);else if(e instanceof er){for(const i of e.args)if(t=Vr(i),t)break}else(e instanceof Di||e instanceof Qi)&&e.input instanceof si&&"zoom"===e.input.name&&(t=e);return t instanceof wt||e.eachChild((e=>{const i=Vr(e);i instanceof wt?t=i:!t&&i?t=new wt("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.'):t&&i&&t!==i&&(t=new wt("",'Only one zoom-based "step" or "interpolate" subexpression may be used in an expression.'))})),t}class ValidationError{constructor(e,t,i,r){this.message=(e?`${e}: `:"")+i,r&&(this.identifier=r),null!=t&&t.__line__&&(this.line=t.__line__)}}function jr(e){const t=e.key,i=e.value,r=e.valueSpec||{},n=e.objectElementValidators||{},o=e.style,s=e.styleSpec;let a=[];const l=Ir(i);if("object"!==l)return[new ValidationError(t,i,`object expected, ${l} found`)];for(const e in i){const l=e.split(".")[0];let c;n[l]?c=n[l]:r[l]?c=wn:n["*"]?c=n["*"]:r["*"]&&(c=wn),c?a=a.concat(c({key:(t?`${t}.`:t)+e,value:i[e],valueSpec:r[l]||r["*"],style:o,styleSpec:s,object:i,objectKey:e},i)):a.push(new ValidationError(t,i[e],`unknown property "${e}"`))}for(const e in r)n[e]||r[e].required&&void 0===r[e].default&&void 0===i[e]&&a.push(new ValidationError(t,i,`missing required property "${e}"`));return a}function Nr(e){const t=e.value,i=e.valueSpec,r=e.style,n=e.styleSpec,o=e.key,s=e.arrayElementValidator||wn;if("array"!==Ir(t))return[new ValidationError(o,t,`array expected, ${Ir(t)} found`)];if(i.length&&t.length!==i.length)return[new ValidationError(o,t,`array length ${i.length} expected, length ${t.length} found`)];if(i["min-length"]&&t.length<i["min-length"])return[new ValidationError(o,t,`array length at least ${i["min-length"]} expected, length ${t.length} found`)];let a={type:i.value,values:i.values,minimum:i.minimum,maximum:i.maximum,function:void 0};n.$version<7&&(a.function=i.function),"object"===Ir(i.value)&&(a=i.value);let l=[];for(let e=0;e<t.length;e++)l=l.concat(s({array:t,arrayIndex:e,value:t[e],valueSpec:a,style:r,styleSpec:n,key:`${o}[${e}]`}));return l}function Gr(e){const t=e.key,i=e.value,r=e.valueSpec;let n=Ir(i);if("number"===n&&i!=i&&(n="NaN"),"number"!==n)return[new ValidationError(t,i,`number expected, ${n} found`)];if("minimum"in r){let n=r.minimum;if("array"===Ir(r.minimum)&&(n=r.minimum[e.arrayIndex]),i<n)return[new ValidationError(t,i,`${i} is less than the minimum value ${n}`)]}if("maximum"in r){let n=r.maximum;if("array"===Ir(r.maximum)&&(n=r.maximum[e.arrayIndex]),i>n)return[new ValidationError(t,i,`${i} is greater than the maximum value ${n}`)]}return[]}function qr(e){const t=e.valueSpec,i=vt(e.value.type);let r,n,o,s={};const a="categorical"!==i&&void 0===e.value.property,l=!a,c="array"===Ir(e.value.stops)&&"array"===Ir(e.value.stops[0])&&"object"===Ir(e.value.stops[0][0]),u=jr({key:e.key,value:e.value,valueSpec:e.styleSpec.function,style:e.style,styleSpec:e.styleSpec,objectElementValidators:{stops:function(e){if("identity"===i)return[new ValidationError(e.key,e.value,'identity function may not have a "stops" property')];let t=[];const r=e.value;return t=t.concat(Nr({key:e.key,value:r,valueSpec:e.valueSpec,style:e.style,styleSpec:e.styleSpec,arrayElementValidator:h})),"array"===Ir(r)&&0===r.length&&t.push(new ValidationError(e.key,r,"array must have at least one stop")),t},default:function(e){return wn({key:e.key,value:e.value,valueSpec:t,style:e.style,styleSpec:e.styleSpec})}}});return"identity"===i&&a&&u.push(new ValidationError(e.key,e.value,'missing required property "property"')),"identity"===i||e.value.stops||u.push(new ValidationError(e.key,e.value,'missing required property "stops"')),"exponential"===i&&e.valueSpec.expression&&!Cr(e.valueSpec)&&u.push(new ValidationError(e.key,e.value,"exponential functions not supported")),e.styleSpec.$version>=8&&(l&&!Sr(e.valueSpec)?u.push(new ValidationError(e.key,e.value,"property functions not supported")):a&&!Ar(e.valueSpec)&&u.push(new ValidationError(e.key,e.value,"zoom functions not supported"))),"categorical"!==i&&!c||void 0!==e.value.property||u.push(new ValidationError(e.key,e.value,'"property" property is required')),u;function h(e){let i=[];const r=e.value,a=e.key;if("array"!==Ir(r))return[new ValidationError(a,r,`array expected, ${Ir(r)} found`)];if(2!==r.length)return[new ValidationError(a,r,`array length 2 expected, length ${r.length} found`)];if(c){if("object"!==Ir(r[0]))return[new ValidationError(a,r,`object expected, ${Ir(r[0])} found`)];if(void 0===r[0].zoom)return[new ValidationError(a,r,"object stop key must have zoom")];if(void 0===r[0].value)return[new ValidationError(a,r,"object stop key must have value")];const t=vt(r[0].zoom);if("number"!=typeof t)return[new ValidationError(a,r[0].zoom,"stop zoom values must be numbers")];if(o&&o>t)return[new ValidationError(a,r[0].zoom,"stop zoom values must appear in ascending order")];t!==o&&(o=t,n=void 0,s={}),i=i.concat(jr({key:`${a}[0]`,value:r[0],valueSpec:{zoom:{}},style:e.style,styleSpec:e.styleSpec,objectElementValidators:{zoom:Gr,value:d}}))}else i=i.concat(d({key:`${a}[0]`,value:r[0],valueSpec:{},style:e.style,styleSpec:e.styleSpec},r));return Fr(bt(r[1]))?i.concat([new ValidationError(`${a}[1]`,r[1],"expressions are not allowed in function stops.")]):i.concat(wn({key:`${a}[1]`,value:r[1],valueSpec:t,style:e.style,styleSpec:e.styleSpec}))}function d(e,o){const a=Ir(e.value),l=vt(e.value),c=null!==e.value?e.value:o;if(r){if(a!==r)return[new ValidationError(e.key,c,`${a} stop domain type must match previous stop domain type ${r}`)]}else r=a;if("number"!==a&&"string"!==a&&"boolean"!==a&&"number"!=typeof l&&"string"!=typeof l&&"boolean"!=typeof l)return[new ValidationError(e.key,c,"stop domain value must be a number, string, or boolean")];if("number"!==a&&"categorical"!==i){let r=`number expected, ${a} found`;return Sr(t)&&void 0===i&&(r+='\nIf you intended to use a categorical function, specify `"type": "categorical"`.'),[new ValidationError(e.key,c,r)]}return"categorical"!==i||"number"!==a||"number"==typeof l&&isFinite(l)&&Math.floor(l)===l?"categorical"!==i&&"number"===a&&"number"==typeof l&&"number"==typeof n&&void 0!==n&&l<n?[new ValidationError(e.key,c,"stop domain values must appear in ascending order")]:(n=l,"categorical"===i&&l in s?[new ValidationError(e.key,c,"stop domain values must be unique")]:(s[l]=!0,[])):[new ValidationError(e.key,c,`integer expected, found ${String(l)}`)]}}function Zr(e){const t=("property"===e.expressionContext?Ur:Or)(bt(e.value),e.valueSpec);if("error"===t.result)return t.value.map((t=>new ValidationError(`${e.key}${t.key}`,e.value,t.message)));const i=t.value.expression||t.value._styleExpression.expression;if("property"===e.expressionContext&&"text-font"===e.propertyKey&&!i.outputDefined())return[new ValidationError(e.key,e.value,`Invalid data expression for "${e.propertyKey}". Output values must be contained as literals within the expression.`)];if("property"===e.expressionContext&&"layout"===e.propertyType&&!Si(i))return[new ValidationError(e.key,e.value,'"feature-state" data expressions are not supported with layout properties.')];if("filter"===e.expressionContext)return $r(i,e);if(e.expressionContext&&0===e.expressionContext.indexOf("cluster")){if(!Ai(i,["zoom","feature-state"]))return[new ValidationError(e.key,e.value,'"zoom" and "feature-state" expressions are not supported with cluster properties.')];if("cluster-initial"===e.expressionContext&&!Ti(i))return[new ValidationError(e.key,e.value,"Feature data expressions are not supported with initial expression part of cluster properties.")]}return[]}function $r(e,t){const i=new Set(["zoom","feature-state","pitch","distance-from-center"]);if(t.valueSpec&&t.valueSpec.expression)for(const e of t.valueSpec.expression.parameters)i.delete(e);if(0===i.size)return[];const r=[];return e instanceof si&&i.has(e.name)?[new ValidationError(t.key,t.value,`["${e.name}"] expression is not supported in a filter for a ${t.object.type} layer with id: ${t.object.id}`)]:(e.eachChild((e=>{r.push(...$r(e,t))})),r)}function Wr(e){const t=e.key,i=e.value,r=e.valueSpec,n=[];return Array.isArray(r.values)?-1===r.values.indexOf(vt(i))&&n.push(new ValidationError(t,i,`expected one of [${r.values.join(", ")}], ${JSON.stringify(i)} found`)):-1===Object.keys(r.values).indexOf(vt(i))&&n.push(new ValidationError(t,i,`expected one of [${Object.keys(r.values).join(", ")}], ${JSON.stringify(i)} found`)),n}function Hr(e){if(!0===e||!1===e)return!0;if(!Array.isArray(e)||0===e.length)return!1;switch(e[0]){case"has":return e.length>=2&&"$id"!==e[1]&&"$type"!==e[1];case"in":return e.length>=3&&("string"!=typeof e[1]||Array.isArray(e[2]));case"!in":case"!has":case"none":return!1;case"==":case"!=":case">":case">=":case"<":case"<=":return 3!==e.length||Array.isArray(e[1])||Array.isArray(e[2]);case"any":case"all":for(const t of e.slice(1))if(!Hr(t)&&"boolean"!=typeof t)return!1;return!0;default:return!0}}function Xr(e,t="fill"){if(null==e)return{filter:()=>!0,needGeometry:!1,needFeature:!1};Hr(e)||(e=rn(e));const i=e;let r=!0;try{r=function(e){if(!Yr(e))return e;let t=bt(e);return Jr(t),t=Kr(t),t}(i)}catch(e){console.warn(`Failed to extract static filter. Filter will continue working, but at higher memory usage and slower framerate.\nThis is most likely a bug, please report this via https://github.com/mapbox/mapbox-gl-js/issues/new?assignees=&labels=&template=Bug_report.md\nand paste the contents of this message in the report.\nThank you!\nFilter Expression:\n${JSON.stringify(i,null,2)}\n        `)}const n=yt[`filter_${t}`],o=Or(r,n);let s=null;if("error"===o.result)throw new Error(o.value.map((e=>`${e.key}: ${e.message}`)).join(", "));s=(e,t,i)=>o.value.evaluate(e,t,{},i);let a=null,l=null;if(r!==i){const e=Or(i,n);if("error"===e.result)throw new Error(e.value.map((e=>`${e.key}: ${e.message}`)).join(", "));a=(t,i,r,n,o)=>e.value.evaluate(t,i,{},r,void 0,void 0,n,o),l=!Ti(e.value.expression)}return{filter:s,dynamicFilter:a||void 0,needGeometry:tn(r),needFeature:!!l}}function Kr(e){if(!Array.isArray(e))return e;const t=function(e){if(Qr.has(e[0]))for(let t=1;t<e.length;t++)if(Yr(e[t]))return!0;return e}(e);return!0===t?t:t.map((e=>Kr(e)))}function Jr(e){let t=!1;const i=[];if("case"===e[0]){for(let r=1;r<e.length-1;r+=2)t=t||Yr(e[r]),i.push(e[r+1]);i.push(e[e.length-1])}else if("match"===e[0]){t=t||Yr(e[1]);for(let t=2;t<e.length-1;t+=2)i.push(e[t+1]);i.push(e[e.length-1])}else if("step"===e[0]){t=t||Yr(e[1]);for(let t=1;t<e.length-1;t+=2)i.push(e[t+1])}t&&(e.length=0,e.push("any",...i));for(let t=1;t<e.length;t++)Jr(e[t])}function Yr(e){if(!Array.isArray(e))return!1;if("pitch"===(t=e[0])||"distance-from-center"===t)return!0;var t;for(let t=1;t<e.length;t++)if(Yr(e[t]))return!0;return!1}const Qr=new Set(["in","==","!=",">",">=","<","<=","to-boolean"]);function en(e,t){return e<t?-1:e>t?1:0}function tn(e){if(!Array.isArray(e))return!1;if("within"===e[0])return!0;for(let t=1;t<e.length;t++)if(tn(e[t]))return!0;return!1}function rn(e){if(!e)return!0;const t=e[0];return e.length<=1?"any"!==t:"=="===t?nn(e[1],e[2],"=="):"!="===t?an(nn(e[1],e[2],"==")):"<"===t||">"===t||"<="===t||">="===t?nn(e[1],e[2],t):"any"===t?(i=e.slice(1),["any"].concat(i.map(rn))):"all"===t?["all"].concat(e.slice(1).map(rn)):"none"===t?["all"].concat(e.slice(1).map(rn).map(an)):"in"===t?on(e[1],e.slice(2)):"!in"===t?an(on(e[1],e.slice(2))):"has"===t?sn(e[1]):"!has"===t?an(sn(e[1])):"within"!==t||e;var i}function nn(e,t,i){switch(e){case"$type":return[`filter-type-${i}`,t];case"$id":return[`filter-id-${i}`,t];default:return[`filter-${i}`,e,t]}}function on(e,t){if(0===t.length)return!1;switch(e){case"$type":return["filter-type-in",["literal",t]];case"$id":return["filter-id-in",["literal",t]];default:return t.length>200&&!t.some((e=>typeof e!=typeof t[0]))?["filter-in-large",e,["literal",t.sort(en)]]:["filter-in-small",e,["literal",t]]}}function sn(e){switch(e){case"$type":return!0;case"$id":return["filter-has-id"];default:return["filter-has",e]}}function an(e){return["!",e]}function ln(e){return Hr(bt(e.value))?Zr(xt({},e,{expressionContext:"filter",valueSpec:e.styleSpec[`filter_${e.layerType||"fill"}`]})):cn(e)}function cn(e){const t=e.value,i=e.key;if("array"!==Ir(t))return[new ValidationError(i,t,`array expected, ${Ir(t)} found`)];const r=e.styleSpec;let n,o=[];if(t.length<1)return[new ValidationError(i,t,"filter array must have at least 1 element")];switch(o=o.concat(Wr({key:`${i}[0]`,value:t[0],valueSpec:r.filter_operator,style:e.style,styleSpec:e.styleSpec})),vt(t[0])){case"<":case"<=":case">":case">=":t.length>=2&&"$type"===vt(t[1])&&o.push(new ValidationError(i,t,`"$type" cannot be use with operator "${t[0]}"`));case"==":case"!=":3!==t.length&&o.push(new ValidationError(i,t,`filter array for operator "${t[0]}" must have 3 elements`));case"in":case"!in":t.length>=2&&(n=Ir(t[1]),"string"!==n&&o.push(new ValidationError(`${i}[1]`,t[1],`string expected, ${n} found`)));for(let s=2;s<t.length;s++)n=Ir(t[s]),"$type"===vt(t[1])?o=o.concat(Wr({key:`${i}[${s}]`,value:t[s],valueSpec:r.geometry_type,style:e.style,styleSpec:e.styleSpec})):"string"!==n&&"number"!==n&&"boolean"!==n&&o.push(new ValidationError(`${i}[${s}]`,t[s],`string, number, or boolean expected, ${n} found`));break;case"any":case"all":case"none":for(let r=1;r<t.length;r++)o=o.concat(cn({key:`${i}[${r}]`,value:t[r],style:e.style,styleSpec:e.styleSpec}));break;case"has":case"!has":n=Ir(t[1]),2!==t.length?o.push(new ValidationError(i,t,`filter array for "${t[0]}" operator must have 2 elements`)):"string"!==n&&o.push(new ValidationError(`${i}[1]`,t[1],`string expected, ${n} found`));break;case"within":n=Ir(t[1]),2!==t.length?o.push(new ValidationError(i,t,`filter array for "${t[0]}" operator must have 2 elements`)):"object"!==n&&o.push(new ValidationError(`${i}[1]`,t[1],`object expected, ${n} found`))}return o}function un(e,t){const i=e.key,r=e.style,n=e.styleSpec,o=e.value,s=e.objectKey,a=n[`${t}_${e.layerType}`];if(!a)return[];const l=s.match(/^(.*)-transition$/);if("paint"===t&&l&&a[l[1]]&&a[l[1]].transition)return wn({key:i,value:o,valueSpec:n.transition,style:r,styleSpec:n});const c=e.valueSpec||a[s];if(!c)return[new ValidationError(i,o,`unknown property "${s}"`)];let u;if("string"===Ir(o)&&Sr(c)&&!c.tokens&&(u=/^{([^}]+)}$/.exec(o))){const e=`\`{ "type": "identity", "property": ${u?JSON.stringify(u[1]):'"_"'} }\``;return[new ValidationError(i,o,`"${s}" does not support interpolation syntax\nUse an identity property function instead: ${e}.`)]}const h=[];return"symbol"===e.layerType&&("text-field"===s&&r&&!r.glyphs&&h.push(new ValidationError(i,o,'use of "text-field" requires a style "glyphs" property')),"text-font"===s&&Mr(bt(o))&&"identity"===vt(o.type)&&h.push(new ValidationError(i,o,'"text-font" does not support identity functions'))),h.concat(wn({key:e.key,value:o,valueSpec:c,style:r,styleSpec:n,expressionContext:"property",propertyType:t,propertyKey:s}))}function hn(e){return un(e,"paint")}function dn(e){return un(e,"layout")}function pn(e){let t=[];const i=e.value,r=e.key,n=e.style,o=e.styleSpec;i.type||i.ref||t.push(new ValidationError(r,i,'either "type" or "ref" is required'));let s=vt(i.type);const a=vt(i.ref);if(i.id){const o=vt(i.id);for(let s=0;s<e.arrayIndex;s++){const e=n.layers[s];vt(e.id)===o&&t.push(new ValidationError(r,i.id,`duplicate layer id "${i.id}", previously used at line ${e.id.__line__}`))}}if("ref"in i){let e;["type","source","source-layer","filter","layout"].forEach((e=>{e in i&&t.push(new ValidationError(r,i[e],`"${e}" is prohibited for ref layers`))})),n.layers.forEach((t=>{vt(t.id)===a&&(e=t)})),e?e.ref?t.push(new ValidationError(r,i.ref,"ref cannot reference another ref layer")):s=vt(e.type):"string"==typeof a&&t.push(new ValidationError(r,i.ref,`ref layer "${a}" not found`))}else if("background"!==s&&"sky"!==s)if(i.source){const e=n.sources&&n.sources[i.source],o=e&&vt(e.type);e?"vector"===o&&"raster"===s?t.push(new ValidationError(r,i.source,`layer "${i.id}" requires a raster source`)):"raster"===o&&"raster"!==s?t.push(new ValidationError(r,i.source,`layer "${i.id}" requires a vector source`)):"vector"!==o||i["source-layer"]?"raster-dem"===o&&"hillshade"!==s?t.push(new ValidationError(r,i.source,"raster-dem source can only be used with layer type 'hillshade'.")):"line"!==s||!i.paint||!i.paint["line-gradient"]&&!i.paint["line-trim-offset"]||"geojson"===o&&e.lineMetrics||t.push(new ValidationError(r,i,`layer "${i.id}" specifies a line-gradient, which requires a GeoJSON source with \`lineMetrics\` enabled.`)):t.push(new ValidationError(r,i,`layer "${i.id}" must specify a "source-layer"`)):t.push(new ValidationError(r,i.source,`source "${i.source}" not found`))}else t.push(new ValidationError(r,i,'missing required property "source"'));return t=t.concat(jr({key:r,value:i,valueSpec:o.layer,style:e.style,styleSpec:e.styleSpec,objectElementValidators:{"*":()=>[],type:()=>wn({key:`${r}.type`,value:i.type,valueSpec:o.layer.type,style:e.style,styleSpec:e.styleSpec,object:i,objectKey:"type"}),filter:e=>ln(xt({layerType:s},e)),layout:e=>jr({layer:i,key:e.key,value:e.value,valueSpec:{},style:e.style,styleSpec:e.styleSpec,objectElementValidators:{"*":e=>dn(xt({layerType:s},e))}}),paint:e=>jr({layer:i,key:e.key,value:e.value,valueSpec:{},style:e.style,styleSpec:e.styleSpec,objectElementValidators:{"*":e=>hn(xt({layerType:s},e))}})}})),t}function fn(e){const t=e.value,i=e.key,r=Ir(t);return"string"!==r?[new ValidationError(i,t,`string expected, ${r} found`)]:[]}const mn={promoteId:function({key:e,value:t}){if("string"===Ir(t))return fn({key:e,value:t});{const i=[];for(const r in t)i.push(...fn({key:`${e}.${r}`,value:t[r]}));return i}}};function _n(e){const t=e.value,i=e.key,r=e.styleSpec,n=e.style;if(!t.type)return[new ValidationError(i,t,'"type" is required')];const o=vt(t.type);let s;switch(o){case"vector":case"raster":case"raster-dem":return s=jr({key:i,value:t,valueSpec:r[`source_${o.replace("-","_")}`],style:e.style,styleSpec:r,objectElementValidators:mn}),s;case"geojson":if(s=jr({key:i,value:t,valueSpec:r.source_geojson,style:n,styleSpec:r,objectElementValidators:mn}),t.cluster)for(const e in t.clusterProperties){const[r,n]=t.clusterProperties[e],o="string"==typeof r?[r,["accumulated"],["get",e]]:r;s.push(...Zr({key:`${i}.${e}.map`,value:n,expressionContext:"cluster-map"})),s.push(...Zr({key:`${i}.${e}.reduce`,value:o,expressionContext:"cluster-reduce"}))}return s;case"video":return jr({key:i,value:t,valueSpec:r.source_video,style:n,styleSpec:r});case"image":return jr({key:i,value:t,valueSpec:r.source_image,style:n,styleSpec:r});case"canvas":return[new ValidationError(i,null,"Please use runtime APIs to add canvas sources, rather than including them in stylesheets.","source.canvas")];default:return Wr({key:`${i}.type`,value:t.type,valueSpec:{values:gn(r)},style:n,styleSpec:r})}}function gn(e){return e.source.reduce(((t,i)=>{const r=e[i];return"enum"===r.type.type&&(t=t.concat(Object.keys(r.type.values))),t}),[])}function yn(e){const t=e.value,i=e.styleSpec,r=i.light,n=e.style;let o=[];const s=Ir(t);if(void 0===t)return o;if("object"!==s)return o=o.concat([new ValidationError("light",t,`object expected, ${s} found`)]),o;for(const e in t){const s=e.match(/^(.*)-transition$/);o=o.concat(s&&r[s[1]]&&r[s[1]].transition?wn({key:e,value:t[e],valueSpec:i.transition,style:n,styleSpec:i}):r[e]?wn({key:e,value:t[e],valueSpec:r[e],style:n,styleSpec:i}):[new ValidationError(e,t[e],`unknown property "${e}"`)])}return o}function xn(e){const t=e.value,i=e.key,r=e.style,n=e.styleSpec,o=n.terrain;let s=[];const a=Ir(t);if(void 0===t)return s;if("object"!==a)return s=s.concat([new ValidationError("terrain",t,`object expected, ${a} found`)]),s;for(const e in t){const i=e.match(/^(.*)-transition$/);s=s.concat(i&&o[i[1]]&&o[i[1]].transition?wn({key:e,value:t[e],valueSpec:n.transition,style:r,styleSpec:n}):o[e]?wn({key:e,value:t[e],valueSpec:o[e],style:r,styleSpec:n}):[new ValidationError(e,t[e],`unknown property "${e}"`)])}if(t.source){const e=r.sources&&r.sources[t.source],n=e&&vt(e.type);e?"raster-dem"!==n&&s.push(new ValidationError(i,t.source,`terrain cannot be used with a source of type ${String(n)}, it only be used with a "raster-dem" source type`)):s.push(new ValidationError(i,t.source,`source "${t.source}" not found`))}else s.push(new ValidationError(i,t,'terrain is missing required property "source"'));return s}function vn(e){const t=e.value,i=e.style,r=e.styleSpec,n=r.fog;let o=[];const s=Ir(t);if(void 0===t)return o;if("object"!==s)return o=o.concat([new ValidationError("fog",t,`object expected, ${s} found`)]),o;for(const e in t){const s=e.match(/^(.*)-transition$/);o=o.concat(s&&n[s[1]]&&n[s[1]].transition?wn({key:e,value:t[e],valueSpec:r.transition,style:i,styleSpec:r}):n[e]?wn({key:e,value:t[e],valueSpec:n[e],style:i,styleSpec:r}):[new ValidationError(e,t[e],`unknown property "${e}"`)])}return o}const bn={"*":()=>[],array:Nr,boolean:function(e){const t=e.value,i=e.key,r=Ir(t);return"boolean"!==r?[new ValidationError(i,t,`boolean expected, ${r} found`)]:[]},number:Gr,color:function(e){const t=e.key,i=e.value,r=Ir(i);return"string"!==r?[new ValidationError(t,i,`color expected, ${r} found`)]:null===jt(i)?[new ValidationError(t,i,`color expected, "${i}" found`)]:[]},enum:Wr,filter:ln,function:qr,layer:pn,object:jr,source:_n,light:yn,terrain:xn,fog:vn,string:fn,formatted:function(e){return 0===fn(e).length?[]:Zr(e)},resolvedImage:function(e){return 0===fn(e).length?[]:Zr(e)},projection:function(e){const t=e.value,i=e.styleSpec,r=i.projection,n=e.style;let o=[];const s=Ir(t);if("object"===s)for(const e in t)o=o.concat(wn({key:e,value:t[e],valueSpec:r[e],style:n,styleSpec:i}));else"string"!==s&&(o=o.concat([new ValidationError("projection",t,`object or string expected, ${s} found`)]));return o}};function wn(e){const t=e.value,i=e.valueSpec,r=e.styleSpec;return i.expression&&Mr(vt(t))?qr(e):i.expression&&Fr(bt(t))?Zr(e):i.type&&bn[i.type]?bn[i.type](e):jr(xt({},e,{valueSpec:i.type?r[i.type]:i}))}function En(e){const t=e.value,i=e.key,r=fn(e);return r.length||(-1===t.indexOf("{fontstack}")&&r.push(new ValidationError(i,t,'"glyphs" url must include a "{fontstack}" token')),-1===t.indexOf("{range}")&&r.push(new ValidationError(i,t,'"glyphs" url must include a "{range}" token'))),r}function Tn(e,t=yt){return Ln(wn({key:"",value:e,valueSpec:t.$root,styleSpec:t,style:e,objectElementValidators:{glyphs:En,"*":()=>[]}}))}const Sn=e=>Ln(_n(e)),An=e=>Ln(yn(e)),Cn=e=>Ln(xn(e)),Mn=e=>Ln(vn(e)),Pn=e=>Ln(pn(e)),Dn=e=>Ln(ln(e)),zn=e=>Ln(hn(e)),kn=e=>Ln(dn(e));function Ln(e){return e.slice().sort(((e,t)=>e.line&&t.line?e.line-t.line:0))}function Bn(e,t){let i=!1;if(t&&t.length)for(const r of t)e.fire(new ErrorEvent(new Error(r.message))),i=!0;return i}var Rn=On,Fn=3;function On(e,t,i){var r=this.cells=[];if(e instanceof ArrayBuffer){this.arrayBuffer=e;var n=new Int32Array(this.arrayBuffer);e=n[0],this.d=(t=n[1])+2*(i=n[2]);for(var o=0;o<this.d*this.d;o++){var s=n[Fn+o],a=n[Fn+o+1];r.push(s===a?null:n.subarray(s,a))}var l=n[Fn+r.length+1];this.keys=n.subarray(n[Fn+r.length],l),this.bboxes=n.subarray(l),this.insert=this._insertReadonly}else{this.d=t+2*i;for(var c=0;c<this.d*this.d;c++)r.push([]);this.keys=[],this.bboxes=[]}this.n=t,this.extent=e,this.padding=i,this.scale=t/e,this.uid=0;var u=i/t*e;this.min=-u,this.max=e+u}On.prototype.insert=function(e,t,i,r,n){this._forEachCell(t,i,r,n,this._insertCell,this.uid++),this.keys.push(e),this.bboxes.push(t),this.bboxes.push(i),this.bboxes.push(r),this.bboxes.push(n)},On.prototype._insertReadonly=function(){throw"Cannot insert into a GridIndex created from an ArrayBuffer."},On.prototype._insertCell=function(e,t,i,r,n,o){this.cells[n].push(o)},On.prototype.query=function(e,t,i,r,n){var o=this.min,s=this.max;if(e<=o&&t<=o&&s<=i&&s<=r&&!n)return Array.prototype.slice.call(this.keys);var a=[];return this._forEachCell(e,t,i,r,this._queryCell,a,{},n),a},On.prototype._queryCell=function(e,t,i,r,n,o,s,a){var l=this.cells[n];if(null!==l)for(var c=this.keys,u=this.bboxes,h=0;h<l.length;h++){var d=l[h];if(void 0===s[d]){var p=4*d;(a?a(u[p+0],u[p+1],u[p+2],u[p+3]):e<=u[p+2]&&t<=u[p+3]&&i>=u[p+0]&&r>=u[p+1])?(s[d]=!0,o.push(c[d])):s[d]=!1}}},On.prototype._forEachCell=function(e,t,i,r,n,o,s,a){for(var l=this._convertToCellCoord(e),c=this._convertToCellCoord(t),u=this._convertToCellCoord(i),h=this._convertToCellCoord(r),d=l;d<=u;d++)for(var p=c;p<=h;p++){var f=this.d*p+d;if((!a||a(this._convertFromCellCoord(d),this._convertFromCellCoord(p),this._convertFromCellCoord(d+1),this._convertFromCellCoord(p+1)))&&n.call(this,e,t,i,r,f,o,s,a))return}},On.prototype._convertFromCellCoord=function(e){return(e-this.padding)/this.scale},On.prototype._convertToCellCoord=function(e){return Math.max(0,Math.min(this.d-1,Math.floor(e*this.scale)+this.padding))},On.prototype.toArrayBuffer=function(){if(this.arrayBuffer)return this.arrayBuffer;for(var e=this.cells,t=Fn+this.cells.length+1+1,i=0,r=0;r<this.cells.length;r++)i+=this.cells[r].length;var n=new Int32Array(t+i+this.keys.length+this.bboxes.length);n[0]=this.extent,n[1]=this.n,n[2]=this.padding;for(var o=t,s=0;s<e.length;s++){var a=e[s];n[Fn+s]=o,n.set(a,o),o+=a.length}return n[Fn+e.length]=o,n.set(this.keys,o),n[Fn+e.length+1]=o+=this.keys.length,n.set(this.bboxes,o),o+=this.bboxes.length,n.buffer};var Un=h(Rn);const Vn={};function jn(e,t,i={}){Object.defineProperty(e,"_classRegistryKey",{value:t,writeable:!1}),Vn[t]={klass:e,omit:i.omit||[]}}jn(Object,"Object"),Un.serialize=function(e,t){const i=e.toArrayBuffer();return t&&t.push(i),{buffer:i}},Un.deserialize=function(e){return new Un(e.buffer)},Object.defineProperty(Un,"name",{value:"Grid"}),jn(Un,"Grid"),jn(Wt,"Color"),jn(Error,"Error"),jn(AJAXError,"AJAXError"),jn(ResolvedImage,"ResolvedImage"),jn(StylePropertyFunction,"StylePropertyFunction"),jn(StyleExpression,"StyleExpression",{omit:["_evaluator"]}),jn(ZoomDependentExpression,"ZoomDependentExpression"),jn(ZoomConstantExpression,"ZoomConstantExpression"),jn(si,"CompoundExpression",{omit:["_evaluate"]});for(const e in wr)Vn[wr[e]._classRegistryKey]||jn(wr[e],`Expression${e}`);function Nn(e){return e&&"undefined"!=typeof ArrayBuffer&&(e instanceof ArrayBuffer||e.constructor&&"ArrayBuffer"===e.constructor.name)}function Gn(t){return e.ImageBitmap&&t instanceof e.ImageBitmap}function qn(t,i){if(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp)return t;if(Nn(t)||Gn(t))return i&&i.push(t),t;if(ArrayBuffer.isView(t)){const e=t;return i&&i.push(e.buffer),e}if(t instanceof e.ImageData)return i&&i.push(t.data.buffer),t;if(Array.isArray(t)){const e=[];for(const r of t)e.push(qn(r,i));return e}if("object"==typeof t){const e=t.constructor,r=e._classRegistryKey;if(!r)throw new Error(`can't serialize object of unregistered class ${r}`);const n=e.serialize?e.serialize(t,i):{};if(!e.serialize){for(const e in t)t.hasOwnProperty(e)&&(Vn[r].omit.indexOf(e)>=0||(n[e]=qn(t[e],i)));t instanceof Error&&(n.message=t.message)}if(n.$name)throw new Error("$name property is reserved for worker serialization logic.");return"Object"!==r&&(n.$name=r),n}throw new Error("can't serialize object of type "+typeof t)}function Zn(t){if(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp||Nn(t)||Gn(t)||ArrayBuffer.isView(t)||t instanceof e.ImageData)return t;if(Array.isArray(t))return t.map(Zn);if("object"==typeof t){const e=t.$name||"Object",{klass:i}=Vn[e];if(!i)throw new Error(`can't deserialize unregistered class ${e}`);if(i.deserialize)return i.deserialize(t);const r=Object.create(i.prototype);for(const e of Object.keys(t))"$name"!==e&&(r[e]=Zn(t[e]));return r}throw new Error("can't deserialize object of type "+typeof t)}const $n={"Latin-1 Supplement":e=>e>=128&&e<=255,Arabic:e=>e>=1536&&e<=1791,"Arabic Supplement":e=>e>=1872&&e<=1919,"Arabic Extended-A":e=>e>=2208&&e<=2303,"Hangul Jamo":e=>e>=4352&&e<=4607,"Unified Canadian Aboriginal Syllabics":e=>e>=5120&&e<=5759,Khmer:e=>e>=6016&&e<=6143,"Unified Canadian Aboriginal Syllabics Extended":e=>e>=6320&&e<=6399,"General Punctuation":e=>e>=8192&&e<=8303,"Letterlike Symbols":e=>e>=8448&&e<=8527,"Number Forms":e=>e>=8528&&e<=8591,"Miscellaneous Technical":e=>e>=8960&&e<=9215,"Control Pictures":e=>e>=9216&&e<=9279,"Optical Character Recognition":e=>e>=9280&&e<=9311,"Enclosed Alphanumerics":e=>e>=9312&&e<=9471,"Geometric Shapes":e=>e>=9632&&e<=9727,"Miscellaneous Symbols":e=>e>=9728&&e<=9983,"Miscellaneous Symbols and Arrows":e=>e>=11008&&e<=11263,"CJK Radicals Supplement":e=>e>=11904&&e<=12031,"Kangxi Radicals":e=>e>=12032&&e<=12255,"Ideographic Description Characters":e=>e>=12272&&e<=12287,"CJK Symbols and Punctuation":e=>e>=12288&&e<=12351,Hiragana:e=>e>=12352&&e<=12447,Katakana:e=>e>=12448&&e<=12543,Bopomofo:e=>e>=12544&&e<=12591,"Hangul Compatibility Jamo":e=>e>=12592&&e<=12687,Kanbun:e=>e>=12688&&e<=12703,"Bopomofo Extended":e=>e>=12704&&e<=12735,"CJK Strokes":e=>e>=12736&&e<=12783,"Katakana Phonetic Extensions":e=>e>=12784&&e<=12799,"Enclosed CJK Letters and Months":e=>e>=12800&&e<=13055,"CJK Compatibility":e=>e>=13056&&e<=13311,"CJK Unified Ideographs Extension A":e=>e>=13312&&e<=19903,"Yijing Hexagram Symbols":e=>e>=19904&&e<=19967,"CJK Unified Ideographs":e=>e>=19968&&e<=40959,"Yi Syllables":e=>e>=40960&&e<=42127,"Yi Radicals":e=>e>=42128&&e<=42191,"Hangul Jamo Extended-A":e=>e>=43360&&e<=43391,"Hangul Syllables":e=>e>=44032&&e<=55215,"Hangul Jamo Extended-B":e=>e>=55216&&e<=55295,"Private Use Area":e=>e>=57344&&e<=63743,"CJK Compatibility Ideographs":e=>e>=63744&&e<=64255,"Arabic Presentation Forms-A":e=>e>=64336&&e<=65023,"Vertical Forms":e=>e>=65040&&e<=65055,"CJK Compatibility Forms":e=>e>=65072&&e<=65103,"Small Form Variants":e=>e>=65104&&e<=65135,"Arabic Presentation Forms-B":e=>e>=65136&&e<=65279,"Halfwidth and Fullwidth Forms":e=>e>=65280&&e<=65519};function Wn(e){for(const t of e)if(Hn(t.charCodeAt(0)))return!0;return!1}function Hn(e){return!(746!==e&&747!==e&&(e<4352||!($n["Bopomofo Extended"](e)||$n.Bopomofo(e)||$n["CJK Compatibility Forms"](e)&&!(e>=65097&&e<=65103)||$n["CJK Compatibility Ideographs"](e)||$n["CJK Compatibility"](e)||$n["CJK Radicals Supplement"](e)||$n["CJK Strokes"](e)||!(!$n["CJK Symbols and Punctuation"](e)||e>=12296&&e<=12305||e>=12308&&e<=12319||12336===e)||$n["CJK Unified Ideographs Extension A"](e)||$n["CJK Unified Ideographs"](e)||$n["Enclosed CJK Letters and Months"](e)||$n["Hangul Compatibility Jamo"](e)||$n["Hangul Jamo Extended-A"](e)||$n["Hangul Jamo Extended-B"](e)||$n["Hangul Jamo"](e)||$n["Hangul Syllables"](e)||$n.Hiragana(e)||$n["Ideographic Description Characters"](e)||$n.Kanbun(e)||$n["Kangxi Radicals"](e)||$n["Katakana Phonetic Extensions"](e)||$n.Katakana(e)&&12540!==e||!(!$n["Halfwidth and Fullwidth Forms"](e)||65288===e||65289===e||65293===e||e>=65306&&e<=65310||65339===e||65341===e||65343===e||e>=65371&&e<=65503||65507===e||e>=65512&&e<=65519)||!(!$n["Small Form Variants"](e)||e>=65112&&e<=65118||e>=65123&&e<=65126)||$n["Unified Canadian Aboriginal Syllabics"](e)||$n["Unified Canadian Aboriginal Syllabics Extended"](e)||$n["Vertical Forms"](e)||$n["Yijing Hexagram Symbols"](e)||$n["Yi Syllables"](e)||$n["Yi Radicals"](e))))}function Xn(e){return e>=1424&&e<=2303||$n["Arabic Presentation Forms-A"](e)||$n["Arabic Presentation Forms-B"](e)}function Kn(e,t){return!(!t&&Xn(e)||e>=2304&&e<=3583||e>=3840&&e<=4255||$n.Khmer(e))}function Jn(e){for(const t of e)if(Xn(t.charCodeAt(0)))return!0;return!1}const Yn="deferred",Qn="loading",eo="loaded";let to=null,io="unavailable",ro=null;const no=function(e){e&&"string"==typeof e&&e.indexOf("NetworkError")>-1&&(io="error"),to&&to(e)};function oo(){so.fire(new Event("pluginStateChange",{pluginStatus:io,pluginURL:ro}))}const so=new Evented,ao=function(){return io},lo=function(){if(io!==Yn||!ro)throw new Error("rtl-text-plugin cannot be downloaded unless a pluginURL is specified");io=Qn,oo(),ro&&xe({url:ro},(e=>{e?no(e):(io=eo,oo())}))},co={applyArabicShaping:null,processBidirectionalText:null,processStyledBidirectionalText:null,isLoaded:()=>io===eo||null!=co.applyArabicShaping,isLoading:()=>io===Qn,setState(e){io=e.pluginStatus,ro=e.pluginURL},isParsed:()=>null!=co.applyArabicShaping,getPluginURL:()=>ro};class EvaluationParameters{constructor(e,t){this.zoom=e,t?(this.now=t.now,this.fadeDuration=t.fadeDuration,this.transition=t.transition,this.pitch=t.pitch):(this.now=0,this.fadeDuration=0,this.transition={},this.pitch=0)}isSupportedScript(e){return function(e,t){for(const i of e)if(!Kn(i.charCodeAt(0),t))return!1;return!0}(e,co.isLoaded())}}class PropertyValue{constructor(e,t){this.property=e,this.value=t,this.expression=function(e,t){if(Mr(e))return new StylePropertyFunction(e,t);if(Fr(e)){const i=Ur(e,t);if("error"===i.result)throw new Error(i.value.map((e=>`${e.key}: ${e.message}`)).join(", "));return i.value}{let i=e;return"string"==typeof e&&"color"===t.type&&(i=Wt.parse(e)),{kind:"constant",evaluate:()=>i}}}(void 0===t?e.specification.default:t,e.specification)}isDataDriven(){return"source"===this.expression.kind||"composite"===this.expression.kind}possiblyEvaluate(e,t,i){return this.property.possiblyEvaluate(this,e,t,i)}}class TransitionablePropertyValue{constructor(e){this.property=e,this.value=new PropertyValue(e,void 0)}transitioned(e,t){return new TransitioningPropertyValue(this.property,this.value,t,L({},e.transition,this.transition),e.now)}untransitioned(){return new TransitioningPropertyValue(this.property,this.value,null,{},0)}}class Transitionable{constructor(e){this._properties=e,this._values=Object.create(e.defaultTransitionablePropertyValues)}getValue(e){return Z(this._values[e].value.value)}setValue(e,t){this._values.hasOwnProperty(e)||(this._values[e]=new TransitionablePropertyValue(this._values[e].property)),this._values[e].value=new PropertyValue(this._values[e].property,null===t?void 0:Z(t))}getTransition(e){return Z(this._values[e].transition)}setTransition(e,t){this._values.hasOwnProperty(e)||(this._values[e]=new TransitionablePropertyValue(this._values[e].property)),this._values[e].transition=Z(t)||void 0}serialize(){const e={};for(const t of Object.keys(this._values)){const i=this.getValue(t);void 0!==i&&(e[t]=i);const r=this.getTransition(t);void 0!==r&&(e[`${t}-transition`]=r)}return e}transitioned(e,t){const i=new Transitioning(this._properties);for(const r of Object.keys(this._values))i._values[r]=this._values[r].transitioned(e,t._values[r]);return i}untransitioned(){const e=new Transitioning(this._properties);for(const t of Object.keys(this._values))e._values[t]=this._values[t].untransitioned();return e}}class TransitioningPropertyValue{constructor(e,t,i,r,n){const o=r.delay||0,s=r.duration||0;n=n||0,this.property=e,this.value=t,this.begin=n+o,this.end=this.begin+s,e.specification.transition&&(r.delay||r.duration)&&(this.prior=i)}possiblyEvaluate(e,t,i){const r=e.now||0,n=this.value.possiblyEvaluate(e,t,i),o=this.prior;if(o){if(r>this.end)return this.prior=null,n;if(this.value.isDataDriven())return this.prior=null,n;if(r<this.begin)return o.possiblyEvaluate(e,t,i);{const s=(r-this.begin)/(this.end-this.begin);return this.property.interpolate(o.possiblyEvaluate(e,t,i),n,T(s))}}return n}}class Transitioning{constructor(e){this._properties=e,this._values=Object.create(e.defaultTransitioningPropertyValues)}possiblyEvaluate(e,t,i){const r=new PossiblyEvaluated(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].possiblyEvaluate(e,t,i);return r}hasTransition(){for(const e of Object.keys(this._values))if(this._values[e].prior)return!0;return!1}}class Layout{constructor(e){this._properties=e,this._values=Object.create(e.defaultPropertyValues)}getValue(e){return Z(this._values[e].value)}setValue(e,t){this._values[e]=new PropertyValue(this._values[e].property,null===t?void 0:Z(t))}serialize(){const e={};for(const t of Object.keys(this._values)){const i=this.getValue(t);void 0!==i&&(e[t]=i)}return e}possiblyEvaluate(e,t,i){const r=new PossiblyEvaluated(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].possiblyEvaluate(e,t,i);return r}}class PossiblyEvaluatedPropertyValue{constructor(e,t,i){this.property=e,this.value=t,this.parameters=i}isConstant(){return"constant"===this.value.kind}constantOr(e){return"constant"===this.value.kind?this.value.value:e}evaluate(e,t,i,r){return this.property.evaluate(this.value,this.parameters,e,t,i,r)}}class PossiblyEvaluated{constructor(e){this._properties=e,this._values=Object.create(e.defaultPossiblyEvaluatedValues)}get(e){return this._values[e]}}class DataConstantProperty{constructor(e){this.specification=e}possiblyEvaluate(e,t){return e.expression.evaluate(t)}interpolate(e,t,i){const r=ki[this.specification.type];return r?r(e,t,i):e}}class DataDrivenProperty{constructor(e,t){this.specification=e,this.overrides=t}possiblyEvaluate(e,t,i,r){return new PossiblyEvaluatedPropertyValue(this,"constant"===e.expression.kind||"camera"===e.expression.kind?{kind:"constant",value:e.expression.evaluate(t,null,{},i,r)}:e.expression,t)}interpolate(e,t,i){if("constant"!==e.value.kind||"constant"!==t.value.kind)return e;if(void 0===e.value.value||void 0===t.value.value)return new PossiblyEvaluatedPropertyValue(this,{kind:"constant",value:void 0},e.parameters);const r=ki[this.specification.type];return r?new PossiblyEvaluatedPropertyValue(this,{kind:"constant",value:r(e.value.value,t.value.value,i)},e.parameters):e}evaluate(e,t,i,r,n,o){return"constant"===e.kind?e.value:e.evaluate(t,i,r,n,o)}}class ColorRampProperty{constructor(e){this.specification=e}possiblyEvaluate(e,t,i,r){return!!e.expression.evaluate(t,null,{},i,r)}interpolate(){return!1}}class Properties{constructor(e){this.properties=e,this.defaultPropertyValues={},this.defaultTransitionablePropertyValues={},this.defaultTransitioningPropertyValues={},this.defaultPossiblyEvaluatedValues={},this.overridableProperties=[];const t=new EvaluationParameters(0,{});for(const i in e){const r=e[i];r.specification.overridable&&this.overridableProperties.push(i);const n=this.defaultPropertyValues[i]=new PropertyValue(r,void 0),o=this.defaultTransitionablePropertyValues[i]=new TransitionablePropertyValue(r);this.defaultTransitioningPropertyValues[i]=o.untransitioned(),this.defaultPossiblyEvaluatedValues[i]=n.possiblyEvaluate(t)}}}function uo(e,t){return 256*(e=M(Math.floor(e),0,255))+M(Math.floor(t),0,255)}jn(DataDrivenProperty,"DataDrivenProperty"),jn(DataConstantProperty,"DataConstantProperty"),jn(ColorRampProperty,"ColorRampProperty");const ho={Int8:Int8Array,Uint8:Uint8Array,Int16:Int16Array,Uint16:Uint16Array,Int32:Int32Array,Uint32:Uint32Array,Float32:Float32Array};class Struct{constructor(e,t){this._structArray=e,this._pos1=t*this.size,this._pos2=this._pos1/2,this._pos4=this._pos1/4,this._pos8=this._pos1/8}}class StructArray{constructor(){this.isTransferred=!1,this.capacity=-1,this.resize(0)}static serialize(e,t){return e._trim(),t&&(e.isTransferred=!0,t.push(e.arrayBuffer)),{length:e.length,arrayBuffer:e.arrayBuffer}}static deserialize(e){const t=Object.create(this.prototype);return t.arrayBuffer=e.arrayBuffer,t.length=e.length,t.capacity=e.arrayBuffer.byteLength/t.bytesPerElement,t._refreshViews(),t}_trim(){this.length!==this.capacity&&(this.capacity=this.length,this.arrayBuffer=this.arrayBuffer.slice(0,this.length*this.bytesPerElement),this._refreshViews())}clear(){this.length=0}resize(e){this.reserve(e),this.length=e}reserve(e){if(e>this.capacity){this.capacity=Math.max(e,Math.floor(5*this.capacity),128),this.arrayBuffer=new ArrayBuffer(this.capacity*this.bytesPerElement);const t=this.uint8;this._refreshViews(),t&&this.uint8.set(t)}}_refreshViews(){throw new Error("_refreshViews() must be implemented by each concrete StructArray layout")}destroy(){this.int8=this.uint8=this.int16=this.uint16=this.int32=this.uint32=this.float32=null,this.arrayBuffer=null}}function po(e,t=1){let i=0,r=0;return{members:e.map((e=>{const n=ho[e.type].BYTES_PER_ELEMENT,o=i=fo(i,Math.max(t,n)),s=e.components||1;return r=Math.max(r,n),i+=n*s,{name:e.name,type:e.type,components:s,offset:o}})),size:fo(i,Math.max(r,t)),alignment:t}}function fo(e,t){return Math.ceil(e/t)*t}class StructArrayLayout2i4 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(e,t){const i=this.length;return this.resize(i+1),this.emplace(i,e,t)}emplace(e,t,i){const r=2*e;return this.int16[r+0]=t,this.int16[r+1]=i,e}}StructArrayLayout2i4.prototype.bytesPerElement=4,jn(StructArrayLayout2i4,"StructArrayLayout2i4");class StructArrayLayout3i6 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(e,t,i){const r=this.length;return this.resize(r+1),this.emplace(r,e,t,i)}emplace(e,t,i,r){const n=3*e;return this.int16[n+0]=t,this.int16[n+1]=i,this.int16[n+2]=r,e}}StructArrayLayout3i6.prototype.bytesPerElement=6,jn(StructArrayLayout3i6,"StructArrayLayout3i6");class StructArrayLayout4i8 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(e,t,i,r){const n=this.length;return this.resize(n+1),this.emplace(n,e,t,i,r)}emplace(e,t,i,r,n){const o=4*e;return this.int16[o+0]=t,this.int16[o+1]=i,this.int16[o+2]=r,this.int16[o+3]=n,e}}StructArrayLayout4i8.prototype.bytesPerElement=8,jn(StructArrayLayout4i8,"StructArrayLayout4i8");class StructArrayLayout2i4ub1f12 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n,o,s){const a=this.length;return this.resize(a+1),this.emplace(a,e,t,i,r,n,o,s)}emplace(e,t,i,r,n,o,s,a){const l=6*e,c=12*e,u=3*e;return this.int16[l+0]=t,this.int16[l+1]=i,this.uint8[c+4]=r,this.uint8[c+5]=n,this.uint8[c+6]=o,this.uint8[c+7]=s,this.float32[u+2]=a,e}}StructArrayLayout2i4ub1f12.prototype.bytesPerElement=12,jn(StructArrayLayout2i4ub1f12,"StructArrayLayout2i4ub1f12");class StructArrayLayout4f16 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e,t,i,r){const n=this.length;return this.resize(n+1),this.emplace(n,e,t,i,r)}emplace(e,t,i,r,n){const o=4*e;return this.float32[o+0]=t,this.float32[o+1]=i,this.float32[o+2]=r,this.float32[o+3]=n,e}}StructArrayLayout4f16.prototype.bytesPerElement=16,jn(StructArrayLayout4f16,"StructArrayLayout4f16");class StructArrayLayout4ui1f12 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n){const o=this.length;return this.resize(o+1),this.emplace(o,e,t,i,r,n)}emplace(e,t,i,r,n,o){const s=6*e,a=3*e;return this.uint16[s+0]=t,this.uint16[s+1]=i,this.uint16[s+2]=r,this.uint16[s+3]=n,this.float32[a+2]=o,e}}StructArrayLayout4ui1f12.prototype.bytesPerElement=12,jn(StructArrayLayout4ui1f12,"StructArrayLayout4ui1f12");class StructArrayLayout4ui8 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(e,t,i,r){const n=this.length;return this.resize(n+1),this.emplace(n,e,t,i,r)}emplace(e,t,i,r,n){const o=4*e;return this.uint16[o+0]=t,this.uint16[o+1]=i,this.uint16[o+2]=r,this.uint16[o+3]=n,e}}StructArrayLayout4ui8.prototype.bytesPerElement=8,jn(StructArrayLayout4ui8,"StructArrayLayout4ui8");class StructArrayLayout6i12 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n,o){const s=this.length;return this.resize(s+1),this.emplace(s,e,t,i,r,n,o)}emplace(e,t,i,r,n,o,s){const a=6*e;return this.int16[a+0]=t,this.int16[a+1]=i,this.int16[a+2]=r,this.int16[a+3]=n,this.int16[a+4]=o,this.int16[a+5]=s,e}}StructArrayLayout6i12.prototype.bytesPerElement=12,jn(StructArrayLayout6i12,"StructArrayLayout6i12");class StructArrayLayout4i4ui4i24 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n,o,s,a,l,c,u,h){const d=this.length;return this.resize(d+1),this.emplace(d,e,t,i,r,n,o,s,a,l,c,u,h)}emplace(e,t,i,r,n,o,s,a,l,c,u,h,d){const p=12*e;return this.int16[p+0]=t,this.int16[p+1]=i,this.int16[p+2]=r,this.int16[p+3]=n,this.uint16[p+4]=o,this.uint16[p+5]=s,this.uint16[p+6]=a,this.uint16[p+7]=l,this.int16[p+8]=c,this.int16[p+9]=u,this.int16[p+10]=h,this.int16[p+11]=d,e}}StructArrayLayout4i4ui4i24.prototype.bytesPerElement=24,jn(StructArrayLayout4i4ui4i24,"StructArrayLayout4i4ui4i24");class StructArrayLayout3i3f20 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n,o){const s=this.length;return this.resize(s+1),this.emplace(s,e,t,i,r,n,o)}emplace(e,t,i,r,n,o,s){const a=10*e,l=5*e;return this.int16[a+0]=t,this.int16[a+1]=i,this.int16[a+2]=r,this.float32[l+2]=n,this.float32[l+3]=o,this.float32[l+4]=s,e}}StructArrayLayout3i3f20.prototype.bytesPerElement=20,jn(StructArrayLayout3i3f20,"StructArrayLayout3i3f20");class StructArrayLayout1ul4 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer)}emplaceBack(e){const t=this.length;return this.resize(t+1),this.emplace(t,e)}emplace(e,t){return this.uint32[1*e+0]=t,e}}StructArrayLayout1ul4.prototype.bytesPerElement=4,jn(StructArrayLayout1ul4,"StructArrayLayout1ul4");class StructArrayLayout5i4f1i1ul2ui40 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n,o,s,a,l,c,u,h,d){const p=this.length;return this.resize(p+1),this.emplace(p,e,t,i,r,n,o,s,a,l,c,u,h,d)}emplace(e,t,i,r,n,o,s,a,l,c,u,h,d,p){const f=20*e,m=10*e;return this.int16[f+0]=t,this.int16[f+1]=i,this.int16[f+2]=r,this.int16[f+3]=n,this.int16[f+4]=o,this.float32[m+3]=s,this.float32[m+4]=a,this.float32[m+5]=l,this.float32[m+6]=c,this.int16[f+14]=u,this.uint32[m+8]=h,this.uint16[f+18]=d,this.uint16[f+19]=p,e}}StructArrayLayout5i4f1i1ul2ui40.prototype.bytesPerElement=40,jn(StructArrayLayout5i4f1i1ul2ui40,"StructArrayLayout5i4f1i1ul2ui40");class StructArrayLayout3i2i2i16 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n,o,s){const a=this.length;return this.resize(a+1),this.emplace(a,e,t,i,r,n,o,s)}emplace(e,t,i,r,n,o,s,a){const l=8*e;return this.int16[l+0]=t,this.int16[l+1]=i,this.int16[l+2]=r,this.int16[l+4]=n,this.int16[l+5]=o,this.int16[l+6]=s,this.int16[l+7]=a,e}}StructArrayLayout3i2i2i16.prototype.bytesPerElement=16,jn(StructArrayLayout3i2i2i16,"StructArrayLayout3i2i2i16");class StructArrayLayout2f1f2i16 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n){const o=this.length;return this.resize(o+1),this.emplace(o,e,t,i,r,n)}emplace(e,t,i,r,n,o){const s=4*e,a=8*e;return this.float32[s+0]=t,this.float32[s+1]=i,this.float32[s+2]=r,this.int16[a+6]=n,this.int16[a+7]=o,e}}StructArrayLayout2f1f2i16.prototype.bytesPerElement=16,jn(StructArrayLayout2f1f2i16,"StructArrayLayout2f1f2i16");class StructArrayLayout2ub2f12 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e,t,i,r){const n=this.length;return this.resize(n+1),this.emplace(n,e,t,i,r)}emplace(e,t,i,r,n){const o=12*e,s=3*e;return this.uint8[o+0]=t,this.uint8[o+1]=i,this.float32[s+1]=r,this.float32[s+2]=n,e}}StructArrayLayout2ub2f12.prototype.bytesPerElement=12,jn(StructArrayLayout2ub2f12,"StructArrayLayout2ub2f12");class StructArrayLayout3f12 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e,t,i){const r=this.length;return this.resize(r+1),this.emplace(r,e,t,i)}emplace(e,t,i,r){const n=3*e;return this.float32[n+0]=t,this.float32[n+1]=i,this.float32[n+2]=r,e}}StructArrayLayout3f12.prototype.bytesPerElement=12,jn(StructArrayLayout3f12,"StructArrayLayout3f12");class StructArrayLayout3ui6 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(e,t,i){const r=this.length;return this.resize(r+1),this.emplace(r,e,t,i)}emplace(e,t,i,r){const n=3*e;return this.uint16[n+0]=t,this.uint16[n+1]=i,this.uint16[n+2]=r,e}}StructArrayLayout3ui6.prototype.bytesPerElement=6,jn(StructArrayLayout3ui6,"StructArrayLayout3ui6");class StructArrayLayout3i2f2ui3ul3ui2f3ub1ul1i1ub60 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n,o,s,a,l,c,u,h,d,p,f,m,_,g,y,x,v){const b=this.length;return this.resize(b+1),this.emplace(b,e,t,i,r,n,o,s,a,l,c,u,h,d,p,f,m,_,g,y,x,v)}emplace(e,t,i,r,n,o,s,a,l,c,u,h,d,p,f,m,_,g,y,x,v,b){const w=30*e,E=15*e,T=60*e;return this.int16[w+0]=t,this.int16[w+1]=i,this.int16[w+2]=r,this.float32[E+2]=n,this.float32[E+3]=o,this.uint16[w+8]=s,this.uint16[w+9]=a,this.uint32[E+5]=l,this.uint32[E+6]=c,this.uint32[E+7]=u,this.uint16[w+16]=h,this.uint16[w+17]=d,this.uint16[w+18]=p,this.float32[E+10]=f,this.float32[E+11]=m,this.uint8[T+48]=_,this.uint8[T+49]=g,this.uint8[T+50]=y,this.uint32[E+13]=x,this.int16[w+28]=v,this.uint8[T+58]=b,e}}StructArrayLayout3i2f2ui3ul3ui2f3ub1ul1i1ub60.prototype.bytesPerElement=60,jn(StructArrayLayout3i2f2ui3ul3ui2f3ub1ul1i1ub60,"StructArrayLayout3i2f2ui3ul3ui2f3ub1ul1i1ub60");class StructArrayLayout3i2f6i15ui1ul3f76 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n,o,s,a,l,c,u,h,d,p,f,m,_,g,y,x,v,b,w,E,T,S,A,C,I,M){const P=this.length;return this.resize(P+1),this.emplace(P,e,t,i,r,n,o,s,a,l,c,u,h,d,p,f,m,_,g,y,x,v,b,w,E,T,S,A,C,I,M)}emplace(e,t,i,r,n,o,s,a,l,c,u,h,d,p,f,m,_,g,y,x,v,b,w,E,T,S,A,C,I,M,P){const D=38*e,z=19*e;return this.int16[D+0]=t,this.int16[D+1]=i,this.int16[D+2]=r,this.float32[z+2]=n,this.float32[z+3]=o,this.int16[D+8]=s,this.int16[D+9]=a,this.int16[D+10]=l,this.int16[D+11]=c,this.int16[D+12]=u,this.int16[D+13]=h,this.uint16[D+14]=d,this.uint16[D+15]=p,this.uint16[D+16]=f,this.uint16[D+17]=m,this.uint16[D+18]=_,this.uint16[D+19]=g,this.uint16[D+20]=y,this.uint16[D+21]=x,this.uint16[D+22]=v,this.uint16[D+23]=b,this.uint16[D+24]=w,this.uint16[D+25]=E,this.uint16[D+26]=T,this.uint16[D+27]=S,this.uint16[D+28]=A,this.uint32[z+15]=C,this.float32[z+16]=I,this.float32[z+17]=M,this.float32[z+18]=P,e}}StructArrayLayout3i2f6i15ui1ul3f76.prototype.bytesPerElement=76,jn(StructArrayLayout3i2f6i15ui1ul3f76,"StructArrayLayout3i2f6i15ui1ul3f76");class StructArrayLayout1f4 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e){const t=this.length;return this.resize(t+1),this.emplace(t,e)}emplace(e,t){return this.float32[1*e+0]=t,e}}StructArrayLayout1f4.prototype.bytesPerElement=4,jn(StructArrayLayout1f4,"StructArrayLayout1f4");class StructArrayLayout5f20 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n){const o=this.length;return this.resize(o+1),this.emplace(o,e,t,i,r,n)}emplace(e,t,i,r,n,o){const s=5*e;return this.float32[s+0]=t,this.float32[s+1]=i,this.float32[s+2]=r,this.float32[s+3]=n,this.float32[s+4]=o,e}}StructArrayLayout5f20.prototype.bytesPerElement=20,jn(StructArrayLayout5f20,"StructArrayLayout5f20");class StructArrayLayout1ul3ui12 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(e,t,i,r){const n=this.length;return this.resize(n+1),this.emplace(n,e,t,i,r)}emplace(e,t,i,r,n){const o=6*e;return this.uint32[3*e+0]=t,this.uint16[o+2]=i,this.uint16[o+3]=r,this.uint16[o+4]=n,e}}StructArrayLayout1ul3ui12.prototype.bytesPerElement=12,jn(StructArrayLayout1ul3ui12,"StructArrayLayout1ul3ui12");class StructArrayLayout2ui4 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(e,t){const i=this.length;return this.resize(i+1),this.emplace(i,e,t)}emplace(e,t,i){const r=2*e;return this.uint16[r+0]=t,this.uint16[r+1]=i,e}}StructArrayLayout2ui4.prototype.bytesPerElement=4,jn(StructArrayLayout2ui4,"StructArrayLayout2ui4");class StructArrayLayout1ui2 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(e){const t=this.length;return this.resize(t+1),this.emplace(t,e)}emplace(e,t){return this.uint16[1*e+0]=t,e}}StructArrayLayout1ui2.prototype.bytesPerElement=2,jn(StructArrayLayout1ui2,"StructArrayLayout1ui2");class StructArrayLayout2f8 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e,t){const i=this.length;return this.resize(i+1),this.emplace(i,e,t)}emplace(e,t,i){const r=2*e;return this.float32[r+0]=t,this.float32[r+1]=i,e}}StructArrayLayout2f8.prototype.bytesPerElement=8,jn(StructArrayLayout2f8,"StructArrayLayout2f8");class CollisionBoxStruct extends Struct{get projectedAnchorX(){return this._structArray.int16[this._pos2+0]}get projectedAnchorY(){return this._structArray.int16[this._pos2+1]}get projectedAnchorZ(){return this._structArray.int16[this._pos2+2]}get tileAnchorX(){return this._structArray.int16[this._pos2+3]}get tileAnchorY(){return this._structArray.int16[this._pos2+4]}get x1(){return this._structArray.float32[this._pos4+3]}get y1(){return this._structArray.float32[this._pos4+4]}get x2(){return this._structArray.float32[this._pos4+5]}get y2(){return this._structArray.float32[this._pos4+6]}get padding(){return this._structArray.int16[this._pos2+14]}get featureIndex(){return this._structArray.uint32[this._pos4+8]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+18]}get bucketIndex(){return this._structArray.uint16[this._pos2+19]}}CollisionBoxStruct.prototype.size=40;class CollisionBoxArray extends StructArrayLayout5i4f1i1ul2ui40{get(e){return new CollisionBoxStruct(this,e)}}jn(CollisionBoxArray,"CollisionBoxArray");class PlacedSymbolStruct extends Struct{get projectedAnchorX(){return this._structArray.int16[this._pos2+0]}get projectedAnchorY(){return this._structArray.int16[this._pos2+1]}get projectedAnchorZ(){return this._structArray.int16[this._pos2+2]}get tileAnchorX(){return this._structArray.float32[this._pos4+2]}get tileAnchorY(){return this._structArray.float32[this._pos4+3]}get glyphStartIndex(){return this._structArray.uint16[this._pos2+8]}get numGlyphs(){return this._structArray.uint16[this._pos2+9]}get vertexStartIndex(){return this._structArray.uint32[this._pos4+5]}get lineStartIndex(){return this._structArray.uint32[this._pos4+6]}get lineLength(){return this._structArray.uint32[this._pos4+7]}get segment(){return this._structArray.uint16[this._pos2+16]}get lowerSize(){return this._structArray.uint16[this._pos2+17]}get upperSize(){return this._structArray.uint16[this._pos2+18]}get lineOffsetX(){return this._structArray.float32[this._pos4+10]}get lineOffsetY(){return this._structArray.float32[this._pos4+11]}get writingMode(){return this._structArray.uint8[this._pos1+48]}get placedOrientation(){return this._structArray.uint8[this._pos1+49]}set placedOrientation(e){this._structArray.uint8[this._pos1+49]=e}get hidden(){return this._structArray.uint8[this._pos1+50]}set hidden(e){this._structArray.uint8[this._pos1+50]=e}get crossTileID(){return this._structArray.uint32[this._pos4+13]}set crossTileID(e){this._structArray.uint32[this._pos4+13]=e}get associatedIconIndex(){return this._structArray.int16[this._pos2+28]}get flipState(){return this._structArray.uint8[this._pos1+58]}set flipState(e){this._structArray.uint8[this._pos1+58]=e}}PlacedSymbolStruct.prototype.size=60;class PlacedSymbolArray extends StructArrayLayout3i2f2ui3ul3ui2f3ub1ul1i1ub60{get(e){return new PlacedSymbolStruct(this,e)}}jn(PlacedSymbolArray,"PlacedSymbolArray");class SymbolInstanceStruct extends Struct{get projectedAnchorX(){return this._structArray.int16[this._pos2+0]}get projectedAnchorY(){return this._structArray.int16[this._pos2+1]}get projectedAnchorZ(){return this._structArray.int16[this._pos2+2]}get tileAnchorX(){return this._structArray.float32[this._pos4+2]}get tileAnchorY(){return this._structArray.float32[this._pos4+3]}get rightJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+8]}get centerJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+9]}get leftJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+10]}get verticalPlacedTextSymbolIndex(){return this._structArray.int16[this._pos2+11]}get placedIconSymbolIndex(){return this._structArray.int16[this._pos2+12]}get verticalPlacedIconSymbolIndex(){return this._structArray.int16[this._pos2+13]}get key(){return this._structArray.uint16[this._pos2+14]}get textBoxStartIndex(){return this._structArray.uint16[this._pos2+15]}get textBoxEndIndex(){return this._structArray.uint16[this._pos2+16]}get verticalTextBoxStartIndex(){return this._structArray.uint16[this._pos2+17]}get verticalTextBoxEndIndex(){return this._structArray.uint16[this._pos2+18]}get iconBoxStartIndex(){return this._structArray.uint16[this._pos2+19]}get iconBoxEndIndex(){return this._structArray.uint16[this._pos2+20]}get verticalIconBoxStartIndex(){return this._structArray.uint16[this._pos2+21]}get verticalIconBoxEndIndex(){return this._structArray.uint16[this._pos2+22]}get featureIndex(){return this._structArray.uint16[this._pos2+23]}get numHorizontalGlyphVertices(){return this._structArray.uint16[this._pos2+24]}get numVerticalGlyphVertices(){return this._structArray.uint16[this._pos2+25]}get numIconVertices(){return this._structArray.uint16[this._pos2+26]}get numVerticalIconVertices(){return this._structArray.uint16[this._pos2+27]}get useRuntimeCollisionCircles(){return this._structArray.uint16[this._pos2+28]}get crossTileID(){return this._structArray.uint32[this._pos4+15]}set crossTileID(e){this._structArray.uint32[this._pos4+15]=e}get textOffset0(){return this._structArray.float32[this._pos4+16]}get textOffset1(){return this._structArray.float32[this._pos4+17]}get collisionCircleDiameter(){return this._structArray.float32[this._pos4+18]}}SymbolInstanceStruct.prototype.size=76;class SymbolInstanceArray extends StructArrayLayout3i2f6i15ui1ul3f76{get(e){return new SymbolInstanceStruct(this,e)}}jn(SymbolInstanceArray,"SymbolInstanceArray");class GlyphOffsetArray extends StructArrayLayout1f4{getoffsetX(e){return this.float32[1*e+0]}}jn(GlyphOffsetArray,"GlyphOffsetArray");class SymbolLineVertexArray extends StructArrayLayout2i4{getx(e){return this.int16[2*e+0]}gety(e){return this.int16[2*e+1]}}jn(SymbolLineVertexArray,"SymbolLineVertexArray");class FeatureIndexStruct extends Struct{get featureIndex(){return this._structArray.uint32[this._pos4+0]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+2]}get bucketIndex(){return this._structArray.uint16[this._pos2+3]}get layoutVertexArrayOffset(){return this._structArray.uint16[this._pos2+4]}}FeatureIndexStruct.prototype.size=12;class FeatureIndexArray extends StructArrayLayout1ul3ui12{get(e){return new FeatureIndexStruct(this,e)}}jn(FeatureIndexArray,"FeatureIndexArray");class FillExtrusionCentroidArray extends StructArrayLayout2ui4{geta_centroid_pos0(e){return this.uint16[2*e+0]}geta_centroid_pos1(e){return this.uint16[2*e+1]}}jn(FillExtrusionCentroidArray,"FillExtrusionCentroidArray");const mo=po([{name:"a_pattern",components:4,type:"Uint16"},{name:"a_pixel_ratio",components:1,type:"Float32"}]),_o=po([{name:"a_dash",components:4,type:"Uint16"}]);var go={exports:{}},yo={exports:{}};!function(e){e.exports=function(e,t){var i,r,n,o,s,a,l,c;for(r=e.length-(i=3&e.length),n=t,s=3432918353,a=461845907,c=0;c<r;)l=255&e.charCodeAt(c)|(255&e.charCodeAt(++c))<<8|(255&e.charCodeAt(++c))<<16|(255&e.charCodeAt(++c))<<24,++c,n=27492+(65535&(o=5*(65535&(n=(n^=l=(65535&(l=(l=(65535&l)*s+(((l>>>16)*s&65535)<<16)&4294967295)<<15|l>>>17))*a+(((l>>>16)*a&65535)<<16)&4294967295)<<13|n>>>19))+((5*(n>>>16)&65535)<<16)&4294967295))+((58964+(o>>>16)&65535)<<16);switch(l=0,i){case 3:l^=(255&e.charCodeAt(c+2))<<16;case 2:l^=(255&e.charCodeAt(c+1))<<8;case 1:n^=l=(65535&(l=(l=(65535&(l^=255&e.charCodeAt(c)))*s+(((l>>>16)*s&65535)<<16)&4294967295)<<15|l>>>17))*a+(((l>>>16)*a&65535)<<16)&4294967295}return n^=e.length,n=2246822507*(65535&(n^=n>>>16))+((2246822507*(n>>>16)&65535)<<16)&4294967295,n=3266489909*(65535&(n^=n>>>13))+((3266489909*(n>>>16)&65535)<<16)&4294967295,(n^=n>>>16)>>>0}}(yo);var xo=yo.exports,vo={exports:{}};!function(e){e.exports=function(e,t){for(var i,r=e.length,n=t^r,o=0;r>=4;)i=1540483477*(65535&(i=255&e.charCodeAt(o)|(255&e.charCodeAt(++o))<<8|(255&e.charCodeAt(++o))<<16|(255&e.charCodeAt(++o))<<24))+((1540483477*(i>>>16)&65535)<<16),n=1540483477*(65535&n)+((1540483477*(n>>>16)&65535)<<16)^(i=1540483477*(65535&(i^=i>>>24))+((1540483477*(i>>>16)&65535)<<16)),r-=4,++o;switch(r){case 3:n^=(255&e.charCodeAt(o+2))<<16;case 2:n^=(255&e.charCodeAt(o+1))<<8;case 1:n=1540483477*(65535&(n^=255&e.charCodeAt(o)))+((1540483477*(n>>>16)&65535)<<16)}return n=1540483477*(65535&(n^=n>>>13))+((1540483477*(n>>>16)&65535)<<16),(n^=n>>>15)>>>0}}(vo);var bo=xo,wo=vo.exports;go.exports=bo,go.exports.murmur3=bo,go.exports.murmur2=wo;var Eo=h(go.exports);class FeaturePositionMap{constructor(){this.ids=[],this.positions=[],this.indexed=!1}add(e,t,i,r){this.ids.push(To(e)),this.positions.push(t,i,r)}getPositions(e){const t=To(e);let i=0,r=this.ids.length-1;for(;i<r;){const e=i+r>>1;this.ids[e]>=t?r=e:i=e+1}const n=[];for(;this.ids[i]===t;)n.push({index:this.positions[3*i],start:this.positions[3*i+1],end:this.positions[3*i+2]}),i++;return n}static serialize(e,t){const i=new Float64Array(e.ids),r=new Uint32Array(e.positions);return So(i,r,0,i.length-1),t&&t.push(i.buffer,r.buffer),{ids:i,positions:r}}static deserialize(e){const t=new FeaturePositionMap;return t.ids=e.ids,t.positions=e.positions,t.indexed=!0,t}}function To(e){const t=+e;return!isNaN(t)&&Number.MIN_SAFE_INTEGER<=t&&t<=Number.MAX_SAFE_INTEGER?t:Eo(String(e))}function So(e,t,i,r){for(;i<r;){const n=e[i+r>>1];let o=i-1,s=r+1;for(;;){do{o++}while(e[o]<n);do{s--}while(e[s]>n);if(o>=s)break;Ao(e,o,s),Ao(t,3*o,3*s),Ao(t,3*o+1,3*s+1),Ao(t,3*o+2,3*s+2)}s-i<r-s?(So(e,t,i,s),i=s+1):(So(e,t,s+1,r),r=s)}}function Ao(e,t,i){const r=e[t];e[t]=e[i],e[i]=r}jn(FeaturePositionMap,"FeaturePositionMap");class Uniform{constructor(e){this.gl=e.gl,this.initialized=!1}fetchUniformLocation(e,t){return this.location||this.initialized||(this.location=this.gl.getUniformLocation(e,t),this.initialized=!0),!!this.location}}class Uniform1i extends Uniform{constructor(e){super(e),this.current=0}set(e,t,i){this.fetchUniformLocation(e,t)&&this.current!==i&&(this.current=i,this.gl.uniform1i(this.location,i))}}class Uniform1f extends Uniform{constructor(e){super(e),this.current=0}set(e,t,i){this.fetchUniformLocation(e,t)&&this.current!==i&&(this.current=i,this.gl.uniform1f(this.location,i))}}class Uniform2f extends Uniform{constructor(e){super(e),this.current=[0,0]}set(e,t,i){this.fetchUniformLocation(e,t)&&(i[0]===this.current[0]&&i[1]===this.current[1]||(this.current=i,this.gl.uniform2f(this.location,i[0],i[1])))}}class Uniform3f extends Uniform{constructor(e){super(e),this.current=[0,0,0]}set(e,t,i){this.fetchUniformLocation(e,t)&&(i[0]===this.current[0]&&i[1]===this.current[1]&&i[2]===this.current[2]||(this.current=i,this.gl.uniform3f(this.location,i[0],i[1],i[2])))}}class Uniform4f extends Uniform{constructor(e){super(e),this.current=[0,0,0,0]}set(e,t,i){this.fetchUniformLocation(e,t)&&(i[0]===this.current[0]&&i[1]===this.current[1]&&i[2]===this.current[2]&&i[3]===this.current[3]||(this.current=i,this.gl.uniform4f(this.location,i[0],i[1],i[2],i[3])))}}class UniformColor extends Uniform{constructor(e){super(e),this.current=Wt.transparent}set(e,t,i){this.fetchUniformLocation(e,t)&&(i.r===this.current.r&&i.g===this.current.g&&i.b===this.current.b&&i.a===this.current.a||(this.current=i,this.gl.uniform4f(this.location,i.r,i.g,i.b,i.a)))}}const Co=new Float32Array(16);class UniformMatrix4f extends Uniform{constructor(e){super(e),this.current=Co}set(e,t,i){if(this.fetchUniformLocation(e,t)){if(i[12]!==this.current[12]||i[0]!==this.current[0])return this.current=i,void this.gl.uniformMatrix4fv(this.location,!1,i);for(let e=1;e<16;e++)if(i[e]!==this.current[e]){this.current=i,this.gl.uniformMatrix4fv(this.location,!1,i);break}}}}const Io=new Float32Array(9);class UniformMatrix3f extends Uniform{constructor(e){super(e),this.current=Io}set(e,t,i){if(this.fetchUniformLocation(e,t))for(let e=0;e<9;e++)if(i[e]!==this.current[e]){this.current=i,this.gl.uniformMatrix3fv(this.location,!1,i);break}}}const Mo=new Float32Array(4);class UniformMatrix2f extends Uniform{constructor(e){super(e),this.current=Mo}set(e,t,i){if(this.fetchUniformLocation(e,t))for(let e=0;e<4;e++)if(i[e]!==this.current[e]){this.current=i,this.gl.uniformMatrix2fv(this.location,!1,i);break}}}function Po(e){return[uo(255*e.r,255*e.g),uo(255*e.b,255*e.a)]}class ConstantBinder{constructor(e,t,i){this.value=e,this.uniformNames=t.map((e=>`u_${e}`)),this.type=i}setUniform(e,t,i,r,n){t.set(e,n,r.constantOr(this.value))}getBinding(e,t){return"color"===this.type?new UniformColor(e):new Uniform1f(e)}}class PatternConstantBinder{constructor(e,t){this.uniformNames=t.map((e=>`u_${e}`)),this.pattern=null,this.pixelRatio=1}setConstantPatternPositions(e){this.pixelRatio=e.pixelRatio||1,this.pattern=e.tl.concat(e.br)}setUniform(e,t,i,r,n){const o="u_pattern"===n||"u_dash"===n?this.pattern:"u_pixel_ratio"===n?this.pixelRatio:null;o&&t.set(e,n,o)}getBinding(e,t){return"u_pattern"===t||"u_dash"===t?new Uniform4f(e):new Uniform1f(e)}}class SourceExpressionBinder{constructor(e,t,i,r){this.expression=e,this.type=i,this.maxValue=0,this.paintVertexAttributes=t.map((e=>({name:`a_${e}`,type:"Float32",components:"color"===i?2:1,offset:0}))),this.paintVertexArray=new r}populatePaintArray(e,t,i,r,n,o){const s=this.paintVertexArray.length,a=this.expression.evaluate(new EvaluationParameters(0),t,{},n,r,o);this.paintVertexArray.resize(e),this._setPaintValue(s,e,a)}updatePaintArray(e,t,i,r,n){const o=this.expression.evaluate({zoom:0},i,r,void 0,n);this._setPaintValue(e,t,o)}_setPaintValue(e,t,i){if("color"===this.type){const r=Po(i);for(let i=e;i<t;i++)this.paintVertexArray.emplace(i,r[0],r[1])}else{for(let r=e;r<t;r++)this.paintVertexArray.emplace(r,i);this.maxValue=Math.max(this.maxValue,Math.abs(i))}}upload(e){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=e.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent))}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy()}}class CompositeExpressionBinder{constructor(e,t,i,r,n,o){this.expression=e,this.uniformNames=t.map((e=>`u_${e}_t`)),this.type=i,this.useIntegerZoom=r,this.zoom=n,this.maxValue=0,this.paintVertexAttributes=t.map((e=>({name:`a_${e}`,type:"Float32",components:"color"===i?4:2,offset:0}))),this.paintVertexArray=new o}populatePaintArray(e,t,i,r,n,o){const s=this.expression.evaluate(new EvaluationParameters(this.zoom),t,{},n,r,o),a=this.expression.evaluate(new EvaluationParameters(this.zoom+1),t,{},n,r,o),l=this.paintVertexArray.length;this.paintVertexArray.resize(e),this._setPaintValue(l,e,s,a)}updatePaintArray(e,t,i,r,n){const o=this.expression.evaluate({zoom:this.zoom},i,r,void 0,n),s=this.expression.evaluate({zoom:this.zoom+1},i,r,void 0,n);this._setPaintValue(e,t,o,s)}_setPaintValue(e,t,i,r){if("color"===this.type){const n=Po(i),o=Po(r);for(let i=e;i<t;i++)this.paintVertexArray.emplace(i,n[0],n[1],o[0],o[1])}else{for(let n=e;n<t;n++)this.paintVertexArray.emplace(n,i,r);this.maxValue=Math.max(this.maxValue,Math.abs(i),Math.abs(r))}}upload(e){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=e.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent))}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy()}setUniform(e,t,i,r,n){const o=this.useIntegerZoom?Math.floor(i.zoom):i.zoom,s=M(this.expression.interpolationFactor(o,this.zoom,this.zoom+1),0,1);t.set(e,n,s)}getBinding(e,t){return new Uniform1f(e)}}class PatternCompositeBinder{constructor(e,t,i,r,n){this.expression=e,this.layerId=n,this.paintVertexAttributes=("array"===i?_o:mo).members;for(let e=0;e<t.length;++e);this.paintVertexArray=new r}populatePaintArray(e,t,i){const r=this.paintVertexArray.length;this.paintVertexArray.resize(e),this._setPaintValues(r,e,t.patterns&&t.patterns[this.layerId],i)}updatePaintArray(e,t,i,r,n,o){this._setPaintValues(e,t,i.patterns&&i.patterns[this.layerId],o)}_setPaintValues(e,t,i,r){if(!r||!i)return;const n=r[i];if(!n)return;const{tl:o,br:s,pixelRatio:a}=n;for(let i=e;i<t;i++)this.paintVertexArray.emplace(i,o[0],o[1],s[0],s[1],a)}upload(e){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer=e.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent))}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy()}}class ProgramConfiguration{constructor(e,t,i=(()=>!0)){this.binders={},this._buffers=[];const r=[];for(const n in e.paint._values){if(!i(n))continue;const o=e.paint.get(n);if(!(o instanceof PossiblyEvaluatedPropertyValue&&Sr(o.property.specification)))continue;const s=zo(n,e.type),a=o.value,l=o.property.specification.type,c=!!o.property.useIntegerZoom,u="line-dasharray"===n||n.endsWith("pattern"),h="line-dasharray"===n&&"constant"!==e.layout.get("line-cap").value.kind;if("constant"!==a.kind||h)if("source"===a.kind||h||u){const t=Bo(n,l,"source");this.binders[n]=u?new PatternCompositeBinder(a,s,l,t,e.id):new SourceExpressionBinder(a,s,l,t),r.push(`/a_${n}`)}else{const e=Bo(n,l,"composite");this.binders[n]=new CompositeExpressionBinder(a,s,l,c,t,e),r.push(`/z_${n}`)}else this.binders[n]=u?new PatternConstantBinder(a.value,s):new ConstantBinder(a.value,s,l),r.push(`/u_${n}`)}this.cacheKey=r.sort().join("")}getMaxValue(e){const t=this.binders[e];return t instanceof SourceExpressionBinder||t instanceof CompositeExpressionBinder?t.maxValue:0}populatePaintArrays(e,t,i,r,n,o){for(const s in this.binders){const a=this.binders[s];(a instanceof SourceExpressionBinder||a instanceof CompositeExpressionBinder||a instanceof PatternCompositeBinder)&&a.populatePaintArray(e,t,i,r,n,o)}}setConstantPatternPositions(e){for(const t in this.binders){const i=this.binders[t];i instanceof PatternConstantBinder&&i.setConstantPatternPositions(e)}}updatePaintArrays(e,t,i,r,n,o){let s=!1;for(const a in e){const l=t.getPositions(a);for(const t of l){const l=i.feature(t.index);for(const i in this.binders){const c=this.binders[i];if((c instanceof SourceExpressionBinder||c instanceof CompositeExpressionBinder||c instanceof PatternCompositeBinder)&&!0===c.expression.isStateDependent){const u=r.paint.get(i);c.expression=u.value,c.updatePaintArray(t.start,t.end,l,e[a],n,o),s=!0}}}}return s}defines(){const e=[];for(const t in this.binders){const i=this.binders[t];(i instanceof ConstantBinder||i instanceof PatternConstantBinder)&&e.push(...i.uniformNames.map((e=>`#define HAS_UNIFORM_${e}`)))}return e}getBinderAttributes(){const e=[];for(const t in this.binders){const i=this.binders[t];if(i instanceof SourceExpressionBinder||i instanceof CompositeExpressionBinder||i instanceof PatternCompositeBinder)for(let t=0;t<i.paintVertexAttributes.length;t++)e.push(i.paintVertexAttributes[t].name)}return e}getBinderUniforms(){const e=[];for(const t in this.binders){const i=this.binders[t];if(i instanceof ConstantBinder||i instanceof PatternConstantBinder||i instanceof CompositeExpressionBinder)for(const t of i.uniformNames)e.push(t)}return e}getPaintVertexBuffers(){return this._buffers}getUniforms(e){const t=[];for(const i in this.binders){const r=this.binders[i];if(r instanceof ConstantBinder||r instanceof PatternConstantBinder||r instanceof CompositeExpressionBinder)for(const n of r.uniformNames)t.push({name:n,property:i,binding:r.getBinding(e,n)})}return t}setUniforms(e,t,i,r,n){for(const{name:t,property:o,binding:s}of i)this.binders[o].setUniform(e,s,n,r.get(o),t)}updatePaintBuffers(){this._buffers=[];for(const e in this.binders){const t=this.binders[e];(t instanceof SourceExpressionBinder||t instanceof CompositeExpressionBinder||t instanceof PatternCompositeBinder)&&t.paintVertexBuffer&&this._buffers.push(t.paintVertexBuffer)}}upload(e){for(const t in this.binders){const i=this.binders[t];(i instanceof SourceExpressionBinder||i instanceof CompositeExpressionBinder||i instanceof PatternCompositeBinder)&&i.upload(e)}this.updatePaintBuffers()}destroy(){for(const e in this.binders){const t=this.binders[e];(t instanceof SourceExpressionBinder||t instanceof CompositeExpressionBinder||t instanceof PatternCompositeBinder)&&t.destroy()}}}class ProgramConfigurationSet{constructor(e,t,i=(()=>!0)){this.programConfigurations={};for(const r of e)this.programConfigurations[r.id]=new ProgramConfiguration(r,t,i);this.needsUpload=!1,this._featureMap=new FeaturePositionMap,this._bufferOffset=0}populatePaintArrays(e,t,i,r,n,o,s){for(const i in this.programConfigurations)this.programConfigurations[i].populatePaintArrays(e,t,r,n,o,s);void 0!==t.id&&this._featureMap.add(t.id,i,this._bufferOffset,e),this._bufferOffset=e,this.needsUpload=!0}updatePaintArrays(e,t,i,r,n){for(const o of i)this.needsUpload=this.programConfigurations[o.id].updatePaintArrays(e,this._featureMap,t,o,r,n)||this.needsUpload}get(e){return this.programConfigurations[e]}upload(e){if(this.needsUpload){for(const t in this.programConfigurations)this.programConfigurations[t].upload(e);this.needsUpload=!1}}destroy(){for(const e in this.programConfigurations)this.programConfigurations[e].destroy()}}const Do={"text-opacity":["opacity"],"icon-opacity":["opacity"],"text-color":["fill_color"],"icon-color":["fill_color"],"text-halo-color":["halo_color"],"icon-halo-color":["halo_color"],"text-halo-blur":["halo_blur"],"icon-halo-blur":["halo_blur"],"text-halo-width":["halo_width"],"icon-halo-width":["halo_width"],"line-gap-width":["gapwidth"],"line-pattern":["pattern","pixel_ratio"],"fill-pattern":["pattern","pixel_ratio"],"fill-extrusion-pattern":["pattern","pixel_ratio"],"line-dasharray":["dash"]};function zo(e,t){return Do[e]||[e.replace(`${t}-`,"").replace(/-/g,"_")]}const ko={"line-pattern":{source:StructArrayLayout4ui1f12,composite:StructArrayLayout4ui1f12},"fill-pattern":{source:StructArrayLayout4ui1f12,composite:StructArrayLayout4ui1f12},"fill-extrusion-pattern":{source:StructArrayLayout4ui1f12,composite:StructArrayLayout4ui1f12},"line-dasharray":{source:StructArrayLayout4ui8,composite:StructArrayLayout4ui8}},Lo={color:{source:StructArrayLayout2f8,composite:StructArrayLayout4f16},number:{source:StructArrayLayout1f4,composite:StructArrayLayout2f8}};function Bo(e,t,i){const r=ko[e];return r&&r[i]||Lo[t][i]}jn(ConstantBinder,"ConstantBinder"),jn(PatternConstantBinder,"PatternConstantBinder"),jn(SourceExpressionBinder,"SourceExpressionBinder"),jn(PatternCompositeBinder,"PatternCompositeBinder"),jn(CompositeExpressionBinder,"CompositeExpressionBinder"),jn(ProgramConfiguration,"ProgramConfiguration",{omit:["_buffers"]}),jn(ProgramConfigurationSet,"ProgramConfigurationSet");const Ro="-transition";class StyleLayer extends Evented{constructor(e,t){if(super(),this.id=e.id,this.type=e.type,this._featureFilter={filter:()=>!0,needGeometry:!1,needFeature:!1},this._filterCompiled=!1,"custom"!==e.type&&(this.metadata=e.metadata,this.minzoom=e.minzoom,this.maxzoom=e.maxzoom,"background"!==e.type&&"sky"!==e.type&&(this.source=e.source,this.sourceLayer=e["source-layer"],this.filter=e.filter),t.layout&&(this._unevaluatedLayout=new Layout(t.layout)),t.paint)){this._transitionablePaint=new Transitionable(t.paint);for(const t in e.paint)this.setPaintProperty(t,e.paint[t],{validate:!1});for(const t in e.layout)this.setLayoutProperty(t,e.layout[t],{validate:!1});this._transitioningPaint=this._transitionablePaint.untransitioned(),this.paint=new PossiblyEvaluated(t.paint)}}getLayoutProperty(e){return"visibility"===e?this.visibility:this._unevaluatedLayout.getValue(e)}setLayoutProperty(e,t,i={}){null!=t&&this._validate(kn,`layers.${this.id}.layout.${e}`,e,t,i)||("visibility"!==e?this._unevaluatedLayout.setValue(e,t):this.visibility=t)}getPaintProperty(e){return N(e,Ro)?this._transitionablePaint.getTransition(e.slice(0,-11)):this._transitionablePaint.getValue(e)}setPaintProperty(e,t,i={}){if(null!=t&&this._validate(zn,`layers.${this.id}.paint.${e}`,e,t,i))return!1;if(N(e,Ro))return this._transitionablePaint.setTransition(e.slice(0,-11),t||void 0),!1;{const i=this._transitionablePaint._values[e],r=i.value.isDataDriven(),n=i.value;this._transitionablePaint.setValue(e,t),this._handleSpecialPaintPropertyUpdate(e);const o=this._transitionablePaint._values[e].value,s=o.isDataDriven(),a=N(e,"pattern")||"line-dasharray"===e;return s||r||a||this._handleOverridablePaintPropertyUpdate(e,n,o)}}_handleSpecialPaintPropertyUpdate(e){}getProgramIds(){return null}getProgramConfiguration(e){return null}_handleOverridablePaintPropertyUpdate(e,t,i){return!1}isHidden(e){return!!(this.minzoom&&e<this.minzoom)||!!(this.maxzoom&&e>=this.maxzoom)||"none"===this.visibility}updateTransitions(e){this._transitioningPaint=this._transitionablePaint.transitioned(e,this._transitioningPaint)}hasTransition(){return this._transitioningPaint.hasTransition()}recalculate(e,t){this._unevaluatedLayout&&(this.layout=this._unevaluatedLayout.possiblyEvaluate(e,void 0,t)),this.paint=this._transitioningPaint.possiblyEvaluate(e,void 0,t)}serialize(){const e={id:this.id,type:this.type,source:this.source,"source-layer":this.sourceLayer,metadata:this.metadata,minzoom:this.minzoom,maxzoom:this.maxzoom,filter:this.filter,layout:this._unevaluatedLayout&&this._unevaluatedLayout.serialize(),paint:this._transitionablePaint&&this._transitionablePaint.serialize()};return this.visibility&&(e.layout=e.layout||{},e.layout.visibility=this.visibility),q(e,((e,t)=>!(void 0===e||"layout"===t&&!Object.keys(e).length||"paint"===t&&!Object.keys(e).length)))}_validate(e,t,i,r,n={}){return(!n||!1!==n.validate)&&Bn(this,e.call(Tn,{key:t,layerType:this.type,objectKey:i,value:r,styleSpec:yt,style:{glyphs:!0,sprite:!0}}))}is3D(){return!1}isSky(){return!1}isTileClipped(){return!1}hasOffscreenPass(){return!1}resize(){}isStateDependent(){for(const e in this.paint._values){const t=this.paint.get(e);if(t instanceof PossiblyEvaluatedPropertyValue&&Sr(t.property.specification)&&("source"===t.value.kind||"composite"===t.value.kind)&&t.value.isStateDependent)return!0}return!1}compileFilter(){this._filterCompiled||(this._featureFilter=Xr(this.filter),this._filterCompiled=!0)}invalidateCompiledFilter(){this._filterCompiled=!1}dynamicFilter(){return this._featureFilter.dynamicFilter}dynamicFilterNeedsFeature(){return this._featureFilter.needFeature}}const Fo=po([{name:"a_pos",components:2,type:"Int16"}],4),Oo=po([{name:"a_pos_3",components:3,type:"Int16"},{name:"a_pos_normal_3",components:3,type:"Int16"}]);class SegmentVector{constructor(e=[]){this.segments=e}prepareSegment(e,t,i,r){let n=this.segments[this.segments.length-1];return e>SegmentVector.MAX_VERTEX_ARRAY_LENGTH&&H(`Max vertices per segment is ${SegmentVector.MAX_VERTEX_ARRAY_LENGTH}: bucket requested ${e}`),(!n||n.vertexLength+e>SegmentVector.MAX_VERTEX_ARRAY_LENGTH||n.sortKey!==r)&&(n={vertexOffset:t.length,primitiveOffset:i.length,vertexLength:0,primitiveLength:0},void 0!==r&&(n.sortKey=r),this.segments.push(n)),n}get(){return this.segments}destroy(){for(const e of this.segments)for(const t in e.vaos)e.vaos[t].destroy()}static simpleSegment(e,t,i,r){return new SegmentVector([{vertexOffset:e,primitiveOffset:t,vertexLength:i,primitiveLength:r,vaos:{},sortKey:0}])}}SegmentVector.MAX_VERTEX_ARRAY_LENGTH=Math.pow(2,16)-1,jn(SegmentVector,"SegmentVector");var Uo=8192;class LngLatBounds{constructor(e,t){e&&(t?this.setSouthWest(e).setNorthEast(t):4===e.length?this.setSouthWest([e[0],e[1]]).setNorthEast([e[2],e[3]]):this.setSouthWest(e[0]).setNorthEast(e[1]))}setNorthEast(e){return this._ne=e instanceof Pa?new Pa(e.lng,e.lat):Pa.convert(e),this}setSouthWest(e){return this._sw=e instanceof Pa?new Pa(e.lng,e.lat):Pa.convert(e),this}extend(e){const t=this._sw,i=this._ne;let r,n;if(e instanceof Pa)r=e,n=e;else{if(!(e instanceof LngLatBounds))return Array.isArray(e)?4===e.length||e.every(Array.isArray)?this.extend(LngLatBounds.convert(e)):this.extend(Pa.convert(e)):"object"==typeof e&&null!==e&&e.hasOwnProperty("lat")&&(e.hasOwnProperty("lon")||e.hasOwnProperty("lng"))?this.extend(Pa.convert(e)):this;if(r=e._sw,n=e._ne,!r||!n)return this}return t||i?(t.lng=Math.min(r.lng,t.lng),t.lat=Math.min(r.lat,t.lat),i.lng=Math.max(n.lng,i.lng),i.lat=Math.max(n.lat,i.lat)):(this._sw=new Pa(r.lng,r.lat),this._ne=new Pa(n.lng,n.lat)),this}getCenter(){return new Pa((this._sw.lng+this._ne.lng)/2,(this._sw.lat+this._ne.lat)/2)}getSouthWest(){return this._sw}getNorthEast(){return this._ne}getNorthWest(){return new Pa(this.getWest(),this.getNorth())}getSouthEast(){return new Pa(this.getEast(),this.getSouth())}getWest(){return this._sw.lng}getSouth(){return this._sw.lat}getEast(){return this._ne.lng}getNorth(){return this._ne.lat}toArray(){return[this._sw.toArray(),this._ne.toArray()]}toString(){return`LngLatBounds(${this._sw.toString()}, ${this._ne.toString()})`}isEmpty(){return!(this._sw&&this._ne)}contains(e){const{lng:t,lat:i}=Pa.convert(e);let r=this._sw.lng<=t&&t<=this._ne.lng;return this._sw.lng>this._ne.lng&&(r=this._sw.lng>=t&&t>=this._ne.lng),this._sw.lat<=i&&i<=this._ne.lat&&r}static convert(e){return!e||e instanceof LngLatBounds?e:new LngLatBounds(e)}}var Vo=1e-6,jo="undefined"!=typeof Float32Array?Float32Array:Array;function No(e,t){var i=t[0],r=t[1],n=t[2],o=t[3],s=i*o-n*r;return s?(e[0]=o*(s=1/s),e[1]=-r*s,e[2]=-n*s,e[3]=i*s,e):null}function Go(){var e=new jo(9);return jo!=Float32Array&&(e[1]=0,e[2]=0,e[3]=0,e[5]=0,e[6]=0,e[7]=0),e[0]=1,e[4]=1,e[8]=1,e}function qo(e,t){var i=t[0],r=t[1],n=t[2],o=t[3],s=t[4],a=t[5],l=t[6],c=t[7],u=t[8];return e[0]=s*u-a*c,e[1]=n*c-r*u,e[2]=r*a-n*s,e[3]=a*l-o*u,e[4]=i*u-n*l,e[5]=n*o-i*a,e[6]=o*c-s*l,e[7]=r*l-i*c,e[8]=i*s-r*o,e}function Zo(e,t,i){var r=t[0],n=t[1],o=t[2],s=t[3],a=t[4],l=t[5],c=t[6],u=t[7],h=t[8],d=i[0],p=i[1],f=i[2],m=i[3],_=i[4],g=i[5],y=i[6],x=i[7],v=i[8];return e[0]=d*r+p*s+f*c,e[1]=d*n+p*a+f*u,e[2]=d*o+p*l+f*h,e[3]=m*r+_*s+g*c,e[4]=m*n+_*a+g*u,e[5]=m*o+_*l+g*h,e[6]=y*r+x*s+v*c,e[7]=y*n+x*a+v*u,e[8]=y*o+x*l+v*h,e}function $o(){var e=new jo(16);return jo!=Float32Array&&(e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[11]=0,e[12]=0,e[13]=0,e[14]=0),e[0]=1,e[5]=1,e[10]=1,e[15]=1,e}function Wo(e){return e[0]=1,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=1,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=1,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,e}function Ho(e,t){var i=t[0],r=t[1],n=t[2],o=t[3],s=t[4],a=t[5],l=t[6],c=t[7],u=t[8],h=t[9],d=t[10],p=t[11],f=t[12],m=t[13],_=t[14],g=t[15],y=i*a-r*s,x=i*l-n*s,v=i*c-o*s,b=r*l-n*a,w=r*c-o*a,E=n*c-o*l,T=u*m-h*f,S=u*_-d*f,A=u*g-p*f,C=h*_-d*m,I=h*g-p*m,M=d*g-p*_,P=y*M-x*I+v*C+b*A-w*S+E*T;return P?(e[0]=(a*M-l*I+c*C)*(P=1/P),e[1]=(n*I-r*M-o*C)*P,e[2]=(m*E-_*w+g*b)*P,e[3]=(d*w-h*E-p*b)*P,e[4]=(l*A-s*M-c*S)*P,e[5]=(i*M-n*A+o*S)*P,e[6]=(_*v-f*E-g*x)*P,e[7]=(u*E-d*v+p*x)*P,e[8]=(s*I-a*A+c*T)*P,e[9]=(r*A-i*I-o*T)*P,e[10]=(f*w-m*v+g*y)*P,e[11]=(h*v-u*w-p*y)*P,e[12]=(a*S-s*C-l*T)*P,e[13]=(i*C-r*S+n*T)*P,e[14]=(m*x-f*b-_*y)*P,e[15]=(u*b-h*x+d*y)*P,e):null}function Xo(e,t,i){var r=t[0],n=t[1],o=t[2],s=t[3],a=t[4],l=t[5],c=t[6],u=t[7],h=t[8],d=t[9],p=t[10],f=t[11],m=t[12],_=t[13],g=t[14],y=t[15],x=i[0],v=i[1],b=i[2],w=i[3];return e[0]=x*r+v*a+b*h+w*m,e[1]=x*n+v*l+b*d+w*_,e[2]=x*o+v*c+b*p+w*g,e[3]=x*s+v*u+b*f+w*y,e[4]=(x=i[4])*r+(v=i[5])*a+(b=i[6])*h+(w=i[7])*m,e[5]=x*n+v*l+b*d+w*_,e[6]=x*o+v*c+b*p+w*g,e[7]=x*s+v*u+b*f+w*y,e[8]=(x=i[8])*r+(v=i[9])*a+(b=i[10])*h+(w=i[11])*m,e[9]=x*n+v*l+b*d+w*_,e[10]=x*o+v*c+b*p+w*g,e[11]=x*s+v*u+b*f+w*y,e[12]=(x=i[12])*r+(v=i[13])*a+(b=i[14])*h+(w=i[15])*m,e[13]=x*n+v*l+b*d+w*_,e[14]=x*o+v*c+b*p+w*g,e[15]=x*s+v*u+b*f+w*y,e}function Ko(e,t,i){var r,n,o,s,a,l,c,u,h,d,p,f,m=i[0],_=i[1],g=i[2];return t===e?(e[12]=t[0]*m+t[4]*_+t[8]*g+t[12],e[13]=t[1]*m+t[5]*_+t[9]*g+t[13],e[14]=t[2]*m+t[6]*_+t[10]*g+t[14],e[15]=t[3]*m+t[7]*_+t[11]*g+t[15]):(n=t[1],o=t[2],s=t[3],a=t[4],l=t[5],c=t[6],u=t[7],h=t[8],d=t[9],p=t[10],f=t[11],e[0]=r=t[0],e[1]=n,e[2]=o,e[3]=s,e[4]=a,e[5]=l,e[6]=c,e[7]=u,e[8]=h,e[9]=d,e[10]=p,e[11]=f,e[12]=r*m+a*_+h*g+t[12],e[13]=n*m+l*_+d*g+t[13],e[14]=o*m+c*_+p*g+t[14],e[15]=s*m+u*_+f*g+t[15]),e}function Jo(e,t,i){var r=i[0],n=i[1],o=i[2];return e[0]=t[0]*r,e[1]=t[1]*r,e[2]=t[2]*r,e[3]=t[3]*r,e[4]=t[4]*n,e[5]=t[5]*n,e[6]=t[6]*n,e[7]=t[7]*n,e[8]=t[8]*o,e[9]=t[9]*o,e[10]=t[10]*o,e[11]=t[11]*o,e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e}function Yo(e,t,i){var r=Math.sin(i),n=Math.cos(i),o=t[4],s=t[5],a=t[6],l=t[7],c=t[8],u=t[9],h=t[10],d=t[11];return t!==e&&(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15]),e[4]=o*n+c*r,e[5]=s*n+u*r,e[6]=a*n+h*r,e[7]=l*n+d*r,e[8]=c*n-o*r,e[9]=u*n-s*r,e[10]=h*n-a*r,e[11]=d*n-l*r,e}function Qo(e,t,i){var r=Math.sin(i),n=Math.cos(i),o=t[0],s=t[1],a=t[2],l=t[3],c=t[8],u=t[9],h=t[10],d=t[11];return t!==e&&(e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15]),e[0]=o*n-c*r,e[1]=s*n-u*r,e[2]=a*n-h*r,e[3]=l*n-d*r,e[8]=o*r+c*n,e[9]=s*r+u*n,e[10]=a*r+h*n,e[11]=l*r+d*n,e}function es(e,t,i){var r=Math.sin(i),n=Math.cos(i),o=t[0],s=t[1],a=t[2],l=t[3],c=t[4],u=t[5],h=t[6],d=t[7];return t!==e&&(e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15]),e[0]=o*n+c*r,e[1]=s*n+u*r,e[2]=a*n+h*r,e[3]=l*n+d*r,e[4]=c*n-o*r,e[5]=u*n-s*r,e[6]=h*n-a*r,e[7]=d*n-l*r,e}function ts(e,t){return e[0]=t[0],e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=t[1],e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=t[2],e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,e}function is(e,t,i){var r,n,o,s=i[0],a=i[1],l=i[2],c=Math.hypot(s,a,l);return c<Vo?null:(s*=c=1/c,a*=c,l*=c,r=Math.sin(t),n=Math.cos(t),e[0]=s*s*(o=1-n)+n,e[1]=a*s*o+l*r,e[2]=l*s*o-a*r,e[3]=0,e[4]=s*a*o-l*r,e[5]=a*a*o+n,e[6]=l*a*o+s*r,e[7]=0,e[8]=s*l*o+a*r,e[9]=a*l*o-s*r,e[10]=l*l*o+n,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,e)}function rs(e,t){var i=t[0],r=t[1],n=t[2],o=t[3],s=i+i,a=r+r,l=n+n,c=i*s,u=r*s,h=r*a,d=n*s,p=n*a,f=n*l,m=o*s,_=o*a,g=o*l;return e[0]=1-h-f,e[1]=u+g,e[2]=d-_,e[3]=0,e[4]=u-g,e[5]=1-c-f,e[6]=p+m,e[7]=0,e[8]=d+_,e[9]=p-m,e[10]=1-c-h,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,e}Math.hypot||(Math.hypot=function(){for(var e=0,t=arguments.length;t--;)e+=arguments[t]*arguments[t];return Math.sqrt(e)});var ns=function(e,t,i,r,n){var o,s=1/Math.tan(t/2);return e[0]=s/i,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=s,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[11]=-1,e[12]=0,e[13]=0,e[15]=0,null!=n&&n!==1/0?(e[10]=(n+r)*(o=1/(r-n)),e[14]=2*n*r*o):(e[10]=-1,e[14]=-2*r),e},os=function(e,t,i,r,n,o,s){var a=1/(t-i),l=1/(r-n),c=1/(o-s);return e[0]=-2*a,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=-2*l,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=2*c,e[11]=0,e[12]=(t+i)*a,e[13]=(n+r)*l,e[14]=(s+o)*c,e[15]=1,e},ss=Xo;function as(){var e=new jo(3);return jo!=Float32Array&&(e[0]=0,e[1]=0,e[2]=0),e}function ls(e){var t=new jo(3);return t[0]=e[0],t[1]=e[1],t[2]=e[2],t}function cs(e){return Math.hypot(e[0],e[1],e[2])}function us(e,t,i){var r=new jo(3);return r[0]=e,r[1]=t,r[2]=i,r}function hs(e,t,i){return e[0]=t[0]+i[0],e[1]=t[1]+i[1],e[2]=t[2]+i[2],e}function ds(e,t,i){return e[0]=t[0]-i[0],e[1]=t[1]-i[1],e[2]=t[2]-i[2],e}function ps(e,t,i){return e[0]=t[0]*i[0],e[1]=t[1]*i[1],e[2]=t[2]*i[2],e}function fs(e,t,i){return e[0]=Math.min(t[0],i[0]),e[1]=Math.min(t[1],i[1]),e[2]=Math.min(t[2],i[2]),e}function ms(e,t,i){return e[0]=Math.max(t[0],i[0]),e[1]=Math.max(t[1],i[1]),e[2]=Math.max(t[2],i[2]),e}function _s(e,t,i){return e[0]=t[0]*i,e[1]=t[1]*i,e[2]=t[2]*i,e}function gs(e,t,i,r){return e[0]=t[0]+i[0]*r,e[1]=t[1]+i[1]*r,e[2]=t[2]+i[2]*r,e}function ys(e,t){return Math.hypot(t[0]-e[0],t[1]-e[1],t[2]-e[2])}function xs(e,t){var i=t[0],r=t[1],n=t[2],o=i*i+r*r+n*n;return o>0&&(o=1/Math.sqrt(o)),e[0]=t[0]*o,e[1]=t[1]*o,e[2]=t[2]*o,e}function vs(e,t){return e[0]*t[0]+e[1]*t[1]+e[2]*t[2]}function bs(e,t,i){var r=t[0],n=t[1],o=t[2],s=i[0],a=i[1],l=i[2];return e[0]=n*l-o*a,e[1]=o*s-r*l,e[2]=r*a-n*s,e}function ws(e,t,i){var r=t[0],n=t[1],o=t[2],s=i[3]*r+i[7]*n+i[11]*o+i[15];return e[0]=(i[0]*r+i[4]*n+i[8]*o+i[12])/(s=s||1),e[1]=(i[1]*r+i[5]*n+i[9]*o+i[13])/s,e[2]=(i[2]*r+i[6]*n+i[10]*o+i[14])/s,e}function Es(e,t,i){var r=t[0],n=t[1],o=t[2];return e[0]=r*i[0]+n*i[3]+o*i[6],e[1]=r*i[1]+n*i[4]+o*i[7],e[2]=r*i[2]+n*i[5]+o*i[8],e}function Ts(e,t,i){var r=i[0],n=i[1],o=i[2],s=t[0],a=t[1],l=t[2],c=n*l-o*a,u=o*s-r*l,h=r*a-n*s,d=n*h-o*u,p=o*c-r*h,f=r*u-n*c,m=2*i[3];return u*=m,h*=m,p*=2,f*=2,e[0]=s+(c*=m)+(d*=2),e[1]=a+u+p,e[2]=l+h+f,e}var Ss,As=ds,Cs=ps,Is=function(e,t,i){return e[0]=t[0]/i[0],e[1]=t[1]/i[1],e[2]=t[2]/i[2],e},Ms=cs;function Ps(e,t,i){return e[0]=t[0]*i,e[1]=t[1]*i,e[2]=t[2]*i,e[3]=t[3]*i,e}function Ds(e,t){var i=t[0],r=t[1],n=t[2],o=t[3],s=i*i+r*r+n*n+o*o;return s>0&&(s=1/Math.sqrt(s)),e[0]=i*s,e[1]=r*s,e[2]=n*s,e[3]=o*s,e}function zs(e,t,i){var r=t[0],n=t[1],o=t[2],s=t[3];return e[0]=i[0]*r+i[4]*n+i[8]*o+i[12]*s,e[1]=i[1]*r+i[5]*n+i[9]*o+i[13]*s,e[2]=i[2]*r+i[6]*n+i[10]*o+i[14]*s,e[3]=i[3]*r+i[7]*n+i[11]*o+i[15]*s,e}function ks(){var e=new jo(4);return jo!=Float32Array&&(e[0]=0,e[1]=0,e[2]=0),e[3]=1,e}function Ls(e){return e[0]=0,e[1]=0,e[2]=0,e[3]=1,e}function Bs(e,t,i){i*=.5;var r=t[0],n=t[1],o=t[2],s=t[3],a=Math.sin(i),l=Math.cos(i);return e[0]=r*l+s*a,e[1]=n*l+o*a,e[2]=o*l-n*a,e[3]=s*l-r*a,e}function Rs(e,t,i){i*=.5;var r=t[0],n=t[1],o=t[2],s=t[3],a=Math.sin(i),l=Math.cos(i);return e[0]=r*l-o*a,e[1]=n*l+s*a,e[2]=o*l+r*a,e[3]=s*l-n*a,e}function Fs(e,t,i){i*=.5;var r=t[0],n=t[1],o=t[2],s=t[3],a=Math.sin(i),l=Math.cos(i);return e[0]=r*l+n*a,e[1]=n*l-r*a,e[2]=o*l+s*a,e[3]=s*l-o*a,e}as(),Ss=new jo(4),jo!=Float32Array&&(Ss[0]=0,Ss[1]=0,Ss[2]=0,Ss[3]=0);var Os=Ds;as(),us(1,0,0),us(0,1,0),ks(),ks(),Go();const Us=po([{type:"Float32",name:"a_globe_pos",components:3},{type:"Float32",name:"a_uv",components:2}]),{members:Vs}=Us,js=po([{name:"a_pos_3",components:3,type:"Int16"}]);var Ns=po([{name:"a_pos",type:"Int16",components:2}]);class Ray{constructor(e,t){this.pos=e,this.dir=t}intersectsPlane(e,t,i){const r=vs(t,this.dir);if(Math.abs(r)<1e-6)return!1;const n=((e[0]-this.pos[0])*t[0]+(e[1]-this.pos[1])*t[1]+(e[2]-this.pos[2])*t[2])/r;return i[0]=this.pos[0]+this.dir[0]*n,i[1]=this.pos[1]+this.dir[1]*n,i[2]=this.pos[2]+this.dir[2]*n,!0}closestPointOnSphere(e,t,i){if(function(e,t){var i=e[0],r=e[1],n=e[2],o=t[0],s=t[1],a=t[2];return Math.abs(i-o)<=Vo*Math.max(1,Math.abs(i),Math.abs(o))&&Math.abs(r-s)<=Vo*Math.max(1,Math.abs(r),Math.abs(s))&&Math.abs(n-a)<=Vo*Math.max(1,Math.abs(n),Math.abs(a))}(this.pos,e)||0===t)return i[0]=i[1]=i[2]=0,!1;const[r,n,o]=this.dir,s=this.pos[0]-e[0],a=this.pos[1]-e[1],l=this.pos[2]-e[2],c=r*r+n*n+o*o,u=2*(s*r+a*n+l*o),h=u*u-4*c*(s*s+a*a+l*l-t*t);if(h<0){const e=Math.max(-u/2,0),c=s+r*e,h=a+n*e,d=l+o*e,p=Math.hypot(c,h,d);return i[0]=c*t/p,i[1]=h*t/p,i[2]=d*t/p,!1}{const e=(-u-Math.sqrt(h))/(2*c);if(e<0){const e=Math.hypot(s,a,l);return i[0]=s*t/e,i[1]=a*t/e,i[2]=l*t/e,!1}return i[0]=s+r*e,i[1]=a+n*e,i[2]=l+o*e,!0}}}class FrustumCorners{constructor(e,t,i,r,n){this.TL=e,this.TR=t,this.BR=i,this.BL=r,this.horizon=n}static fromInvProjectionMatrix(e,t,i){const r=[-1,1,1],n=[1,1,1],o=[1,-1,1],s=[-1,-1,1],a=ws(r,r,e),l=ws(n,n,e),c=ws(o,o,e),u=ws(s,s,e);return new FrustumCorners(a,l,c,u,t/i)}}class Frustum{constructor(e,t){this.points=e,this.planes=t}static fromInvProjectionMatrix(e,t,i,r){const n=Math.pow(2,i),o=[[-1,1,-1,1],[1,1,-1,1],[1,-1,-1,1],[-1,-1,-1,1],[-1,1,1,1],[1,1,1,1],[1,-1,1,1],[-1,-1,1,1]].map((i=>{const o=zs([],i,e),s=1/o[3]/t*n;return function(e,t,i){return e[0]=t[0]*i[0],e[1]=t[1]*i[1],e[2]=t[2]*i[2],e[3]=t[3]*i[3],e}(o,o,[s,s,r?1/o[3]:s,s])})),s=[[0,1,2],[6,5,4],[0,3,7],[2,1,5],[3,2,6],[0,4,5]].map((e=>{const t=xs([],bs([],As([],o[e[0]],o[e[1]]),As([],o[e[2]],o[e[1]]))),i=-vs(t,o[e[1]]);return t.concat(i)}));return new Frustum(o,s)}}class Aabb{static fromPoints(e){const t=[1/0,1/0,1/0],i=[-1/0,-1/0,-1/0];for(const r of e)fs(t,t,r),ms(i,i,r);return new Aabb(t,i)}static applyTransform(e,t){const i=e.getCorners();for(let e=0;e<i.length;++e)ws(i[e],i[e],t);return Aabb.fromPoints(i)}constructor(e,t){this.min=e,this.max=t,this.center=_s([],hs([],this.min,this.max),.5)}quadrant(e){const t=[e%2==0,e<2],i=ls(this.min),r=ls(this.max);for(let e=0;e<t.length;e++)i[e]=t[e]?this.min[e]:this.center[e],r[e]=t[e]?this.center[e]:this.max[e];return r[2]=this.max[2],new Aabb(i,r)}distanceX(e){return Math.max(Math.min(this.max[0],e[0]),this.min[0])-e[0]}distanceY(e){return Math.max(Math.min(this.max[1],e[1]),this.min[1])-e[1]}distanceZ(e){return Math.max(Math.min(this.max[2],e[2]),this.min[2])-e[2]}getCorners(){const e=this.min,t=this.max;return[[e[0],e[1],e[2]],[t[0],e[1],e[2]],[t[0],t[1],e[2]],[e[0],t[1],e[2]],[e[0],e[1],t[2]],[t[0],e[1],t[2]],[t[0],t[1],t[2]],[e[0],t[1],t[2]]]}intersects(e){const t=this.getCorners();let i=!0;for(let r=0;r<e.planes.length;r++){const n=e.planes[r];let o=0;for(let e=0;e<t.length;e++)o+=vs(n,t[e])+n[3]>=0;if(0===o)return 0;o!==t.length&&(i=!1)}if(i)return 2;for(let t=0;t<3;t++){let i=Number.MAX_VALUE,r=-Number.MAX_VALUE;for(let n=0;n<e.points.length;n++){const o=e.points[n][t]-this.min[t];i=Math.min(i,o),r=Math.max(r,o)}if(r<0||i>this.max[t]-this.min[t])return 0}return 1}}const Gs=5,qs=6,Zs=Uo/Math.PI/2,$s=16383,Ws=64,Hs=[Ws,32,16],Xs=-Zs,Ks=Zs,Js=[new Aabb([Xs,Xs,Xs],[Ks,Ks,Ks]),new Aabb([Xs,Xs,Xs],[0,0,Ks]),new Aabb([0,Xs,Xs],[Ks,0,Ks]),new Aabb([Xs,0,Xs],[0,Ks,Ks]),new Aabb([0,0,Xs],[Ks,Ks,Ks])];function Ys(e){return e*Zs/Ia}function Qs(e,t,i,r=!0){const n=_s([],e._camera.position,e.worldSize),o=[t,i,1,1];zs(o,o,e.pixelMatrixInverse),Ps(o,o,1/o[3]);const s=xs([],As([],o,n)),a=e.globeMatrix,l=[a[12],a[13],a[14]],c=As([],l,n),u=cs(c),h=xs([],c),d=e.worldSize/(2*Math.PI),p=vs(h,s),f=Math.asin(d/u);if(f<Math.acos(p)){if(!r)return null;const e=[],t=[];_s(e,s,u/p),xs(t,As(t,e,c)),xs(s,hs(s,c,_s(s,t,Math.tan(f)*u)))}const m=[];new Ray(n,s).closestPointOnSphere(l,d,m);const _=xs([],re(a,0)),g=xs([],re(a,1)),y=xs([],re(a,2)),x=vs(_,m),v=vs(g,m),b=vs(y,m),E=w(Math.asin(-v/d));let T=w(Math.atan2(x,b));T=e.center.lng+function(e,t){const i=(t-e+180)%360-180;return i<-180?i+360:i}(e.center.lng,T);const S=za(T),A=M(ka(E),0,1);return new MercatorCoordinate(S,A)}class Arc{constructor(e,t,i){this.a=As([],e,i),this.b=As([],t,i),this.center=i;const r=xs([],this.a),n=xs([],this.b);this.angle=Math.acos(vs(r,n))}}function ea(e,t){if(0===e.angle)return null;let i;return i=0===e.a[t]?1/e.angle*.5*Math.PI:1/e.angle*Math.atan(e.b[t]/e.a[t]/Math.sin(e.angle)-1/Math.tan(e.angle)),i<0||i>1?null:function(e,t,i,r){const n=Math.sin(i);return e*(Math.sin((1-r)*i)/n)+t*(Math.sin(r*i)/n)}(e.a[t],e.b[t],e.angle,M(i,0,1))+e.center[t]}function ta(e){if(e.z<=1)return Js[e.z+2*e.y+e.x];const t=aa(sa(e));return Aabb.fromPoints(t)}function ia(e,t,i){return _s(e,e,1-i),gs(e,e,t,i)}function ra(e,t){const i=ga(t.zoom);if(0===i)return ta(e);const r=sa(e),n=aa(r),o=za(r.getWest())*t.worldSize,s=za(r.getEast())*t.worldSize,a=ka(r.getNorth())*t.worldSize,l=ka(r.getSouth())*t.worldSize,c=[o,a,0],u=[s,a,0],h=[o,l,0],d=[s,l,0],p=Ho([],t.globeMatrix);return ws(c,c,p),ws(u,u,p),ws(h,h,p),ws(d,d,p),n[0]=ia(n[0],h,i),n[1]=ia(n[1],d,i),n[2]=ia(n[2],u,i),n[3]=ia(n[3],c,i),Aabb.fromPoints(n)}function na(e,t,i){for(const r of e)ws(r,r,t),_s(r,r,i)}function oa(e,t,i){const r=t/e.worldSize,n=e.globeMatrix;if(i.z<=1){const e=ta(i).getCorners();return na(e,n,r),Aabb.fromPoints(e)}const o=sa(i),s=aa(o);na(s,n,r);const a=Number.MAX_VALUE,l=[-a,-a,-a],c=[a,a,a];if(o.contains(e.center)){for(const e of s)fs(c,c,e),ms(l,l,e);l[2]=0;const t=e.point,i=[t.x*r,t.y*r,0];return fs(c,c,i),ms(l,l,i),new Aabb(c,l)}const u=[n[12]*r,n[13]*r,n[14]*r],h=o.getCenter(),d=M(e.center.lat,-Oa,Oa),p=M(h.lat,-Oa,Oa),f=za(e.center.lng),m=ka(d);let _=f-za(h.lng);const g=m-ka(p);_>.5?_-=1:_<-.5&&(_+=1);let y=0;Math.abs(_)>Math.abs(g)?y=_>=0?1:3:(y=g>=0?0:2,gs(u,u,[n[4]*r,n[5]*r,n[6]*r],-Math.sin(b(g>=0?o.getSouth():o.getNorth()))*Zs));const x=s[y],v=s[(y+1)%4],w=new Arc(x,v,u),E=[ea(w,0)||x[0],ea(w,1)||x[1],ea(w,2)||x[2]],T=ga(e.zoom);if(T>0){const r=function({x:e,y:t,z:i},r,n,o,s){const a=1/(1<<i);let l=e*a,c=l+a,u=t*a,h=u+a,d=0;const p=(l+c)/2-o;return p>.5?d=-1:p<-.5&&(d=1),l=((l+d)*r-(o*=r))*n+o,c=((c+d)*r-o)*n+o,u=(u*r-(s*=r))*n+s,h=(h*r-s)*n+s,[[l,h,0],[c,h,0],[c,u,0],[l,u,0]]}(i,t,e._pixelsPerMercatorPixel,f,m);for(let e=0;e<s.length;e++)ia(s[e],r[e],T);const n=hs([],r[y],r[(y+1)%4]);_s(n,n,.5),ia(E,n,T)}for(const e of s)fs(c,c,e),ms(l,l,e);return c[2]=Math.min(x[2],v[2]),fs(c,c,E),ms(l,l,E),new Aabb(c,l)}function sa({x:e,y:t,z:i}){const r=1/(1<<i),n=new Pa(Ba(e*r),Ra((t+1)*r)),o=new Pa(Ba((e+1)*r),Ra(t*r));return new LngLatBounds(n,o)}function aa(e){const t=b(e.getNorth()),i=b(e.getSouth()),r=Math.cos(t),n=Math.cos(i),o=Math.sin(t),s=Math.sin(i),a=e.getWest(),l=e.getEast();return[la(n,s,a),la(n,s,l),la(r,o,l),la(r,o,a)]}function la(e,t,i,r=Zs){return i=b(i),[e*Math.sin(i)*r,-t*r,e*Math.cos(i)*r]}function ca(e,t,i){return la(Math.cos(b(e)),Math.sin(b(e)),t,i)}function ua(e,t,i,r){const n=1<<i.z,o=(e/Uo+i.x)/n;return ca(Ra((t/Uo+i.y)/n),Ba(o),r)}function ha({min:e,max:t}){return $s/Math.max(t[0]-e[0],t[1]-e[1],t[2]-e[2])}const da=new Float64Array(16);function pa(e){const t=ha(e),i=ts(da,[t,t,t]);return Ko(i,i,((r=[])[0]=-(n=e.min)[0],r[1]=-n[1],r[2]=-n[2],r));var r,n}function fa(e){const t=(r=e.min,(i=da)[0]=1,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=1,i[6]=0,i[7]=0,i[8]=0,i[9]=0,i[10]=1,i[11]=0,i[12]=r[0],i[13]=r[1],i[14]=r[2],i[15]=1,i);var i,r;const n=1/ha(e);return Jo(t,t,[n,n,n])}function ma(e,t){return Uo/(512*Math.pow(2,e))*ha(ta(t))}function _a(e,t,i,r,n){const o=function(e){const t=Uo/(2*Math.PI);return e/(2*Math.PI)/t}(i),s=[e,t,-i/(2*Math.PI)],a=Wo(new Float64Array(16));return Ko(a,a,s),Jo(a,a,[o,o,o]),Yo(a,a,b(-n)),Qo(a,a,b(-r)),a}function ga(e){return P(Gs,qs,e)}function ya(e,t,i){const r=Wo(new Float64Array(16)),n=(t/(1<<e)-.5)*Math.PI*2;return Qo(r,i.globeMatrix,n),Float32Array.from(r)}function xa(e,t,i){const r=ga(i.zoom),n=e.style.map._antialias,o=!!t.extStandardDerivatives,s=t.extStandardDerivativesForceOff||e.terrain&&e.terrain.exaggeration()>0;return 0===r&&!n&&!s&&o}function va(e,t,i,r){const n=t.getNorth(),o=t.getSouth(),s=t.getWest(),a=t.getEast(),l=1<<e.z,c=a-s,u=n-o,h=c/Ws,d=-u/Hs[i],p=[0,h,0,d,0,0,n,s,0];if(e.z>0){const e=180/r;Zo(p,p,[e/c+1,0,0,0,e/u+1,0,-.5*e/h,.5*e/d,1])}return p[2]=l,p[5]=e.x,p[8]=e.y,p}function ba(e){const t=Oa-5;e=M(e,-t,t)/t*90;const i=Math.pow(Math.abs(Math.sin(b(e))),3);return Math.round(i*(Hs.length-1))}function wa(e){const t=[0,0,0],i=Wo(new Float64Array(16));return Xo(i,e.pixelMatrix,e.globeMatrix),ws(t,t,i),new g(t[0],t[1])}function Ea(e,t){const i=ca(t.lat,t.lng),r=function(e){const t=ca(e._center.lat,e._center.lng);let i=bs([],us(0,1,0),t);const r=is([],-e.angle,t);i=ws(i,i,r),is(r,-e._pitch,i);const n=xs([],t);return _s(n,n,Ys(e.cameraToCenterDistance/e.pixelsPerMeter)),ws(n,n,r),hs([],t,n)}(e);return s=(n=ds([],r,i))[0],a=n[1],l=n[2],c=(o=i)[0],u=o[1],h=o[2],p=(d=Math.sqrt(s*s+a*a+l*l)*Math.sqrt(c*c+u*u+h*h))&&vs(n,o)/d,Math.acos(Math.min(Math.max(p,-1),1));var n,o,s,a,l,c,u,h,d,p}function Ta(e,t){return Ea(e,t)>Math.PI/2*1.01}const Sa=b(85),Aa=Math.cos(Sa),Ca=Math.sin(Sa);class GlobeSharedBuffers{constructor(e){this._createGrid(e),this._createPoles(e)}destroy(){this._poleIndexBuffer.destroy(),this._gridBuffer.destroy(),this._gridIndexBuffer.destroy(),this._poleNorthVertexBuffer.destroy(),this._poleSouthVertexBuffer.destroy();for(const e of this._poleSegments)e.destroy();for(const e of this._gridSegments)e.withSkirts.destroy(),e.withoutSkirts.destroy();if(this._wireframeIndexBuffer){this._wireframeIndexBuffer.destroy();for(const e of this._wireframeSegments)e.destroy()}}_fillGridMeshWithLods(e,t){const i=new StructArrayLayout2i4,r=new StructArrayLayout3ui6,n=[],o=e+1+2,s=t[0]+1,a=t[0]+1+(1+t.length),l=(e,t,i)=>{let r=e===o-1?e-2:0===e?e:e-1;return r+=i?24575:0,[r,t]};for(let e=0;e<o;++e)i.emplaceBack(...l(e,0,!0));for(let e=0;e<s;++e)for(let t=0;t<o;++t)i.emplaceBack(...l(t,e,(0===t||t===o-1)&&!0));for(let e=0;e<t.length;++e){const r=t[e];for(let e=0;e<o;++e)i.emplaceBack(...l(e,r,!0))}for(let e=0;e<t.length;++e){const s=r.length,l=t[e]+1+2,c=new StructArrayLayout3ui6;for(let i=0;i<l-1;i++){const n=i===l-2,s=n?o*(a-t.length+e-i):o;for(let e=0;e<o-1;e++){const t=i*o+e;0===i||n||0===e||e===o-2?(c.emplaceBack(t+1,t,t+s),c.emplaceBack(t+s,t+s+1,t+1)):(r.emplaceBack(t+1,t,t+s),r.emplaceBack(t+s,t+s+1,t+1))}}const u=SegmentVector.simpleSegment(0,s,i.length,r.length-s);for(let e=0;e<c.uint16.length;e+=3)r.emplaceBack(c.uint16[e],c.uint16[e+1],c.uint16[e+2]);const h=SegmentVector.simpleSegment(0,s,i.length,r.length-s);n.push({withoutSkirts:u,withSkirts:h})}return{vertices:i,indices:r,segments:n}}_createGrid(e){const t=this._fillGridMeshWithLods(Ws,Hs);this._gridSegments=t.segments,this._gridBuffer=e.createVertexBuffer(t.vertices,Ns.members),this._gridIndexBuffer=e.createIndexBuffer(t.indices,!0)}_createPoles(e){const t=new StructArrayLayout3ui6;for(let e=0;e<=Ws;e++)t.emplaceBack(0,e+1,e+2);this._poleIndexBuffer=e.createIndexBuffer(t,!0);const i=new StructArrayLayout5f20,r=new StructArrayLayout5f20;this._poleSegments=[];for(let e=0,t=0;e<Gs;e++){const n=360/(1<<e);i.emplaceBack(0,-Zs,0,.5,0),r.emplaceBack(0,-Zs,0,.5,1);for(let e=0;e<=Ws;e++){const t=e/Ws,o=zi(0,n,t),[s,a,l]=la(Aa,Ca,o,Zs);i.emplaceBack(s,a,l,t,0),r.emplaceBack(s,a,l,t,1)}this._poleSegments.push(SegmentVector.simpleSegment(t,0,66,64)),t+=66}this._poleNorthVertexBuffer=e.createVertexBuffer(i,Vs,!1),this._poleSouthVertexBuffer=e.createVertexBuffer(r,Vs,!1)}getGridBuffers(e,t){return[this._gridBuffer,this._gridIndexBuffer,t?this._gridSegments[e].withSkirts:this._gridSegments[e].withoutSkirts]}getPoleBuffers(e){return[this._poleNorthVertexBuffer,this._poleSouthVertexBuffer,this._poleIndexBuffer,this._poleSegments[e]]}getWirefameBuffers(e,t){if(!this._wireframeSegments){const t=new StructArrayLayout2ui4,i=Ws,r=i+1+2,n=1;this._wireframeSegments=[];for(let e=0,o=0;e<Hs.length;e++){const s=Hs[e];for(let e=n;e<s+n;e++)for(let o=n;o<i+n;o++){const i=e*r+o;t.emplaceBack(i,i+1),t.emplaceBack(i,i+r),t.emplaceBack(i,i+r+1)}const a=s*i*3;this._wireframeSegments.push(SegmentVector.simpleSegment(0,o,(s+1)*r,a)),o+=a}this._wireframeIndexBuffer=e.createIndexBuffer(t)}return[this._gridBuffer,this._wireframeIndexBuffer,this._wireframeSegments[t]]}}const Ia=6371008.8,Ma=2*Math.PI*Ia;class LngLat{constructor(e,t){if(isNaN(e)||isNaN(t))throw new Error(`Invalid LngLat object: (${e}, ${t})`);if(this.lng=+e,this.lat=+t,this.lat>90||this.lat<-90)throw new Error("Invalid LngLat latitude value: must be between -90 and 90")}wrap(){return new LngLat(D(this.lng,-180,180),this.lat)}toArray(){return[this.lng,this.lat]}toString(){return`LngLat(${this.lng}, ${this.lat})`}distanceTo(e){const t=Math.PI/180,i=this.lat*t,r=e.lat*t,n=Math.sin(i)*Math.sin(r)+Math.cos(i)*Math.cos(r)*Math.cos((e.lng-this.lng)*t);return Ia*Math.acos(Math.min(n,1))}toBounds(e=0){const t=360*e/40075017,i=t/Math.cos(Math.PI/180*this.lat);return new LngLatBounds(new LngLat(this.lng-i,this.lat-t),new LngLat(this.lng+i,this.lat+t))}toEcef(e){const t=Ys(e);return ca(this.lat,this.lng,Zs+t)}static convert(e){if(e instanceof LngLat)return e;if(Array.isArray(e)&&(2===e.length||3===e.length))return new LngLat(Number(e[0]),Number(e[1]));if(!Array.isArray(e)&&"object"==typeof e&&null!==e)return new LngLat(Number("lng"in e?e.lng:e.lon),Number(e.lat));throw new Error("`LngLatLike` argument must be specified as a LngLat instance, an object {lng: <lng>, lat: <lat>}, an object {lon: <lng>, lat: <lat>}, or an array of [<lng>, <lat>]")}}var Pa=LngLat;function Da(e){return Ma*Math.cos(e*Math.PI/180)}function za(e){return(180+e)/360}function ka(e){return(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+e*Math.PI/360)))/360}function La(e,t){return e/Da(t)}function Ba(e){return 360*e-180}function Ra(e){return 360/Math.PI*Math.atan(Math.exp((180-360*e)*Math.PI/180))-90}function Fa(e,t){return e*Da(Ra(t))}const Oa=85.051129;function Ua(e){return 1/Math.cos(e*Math.PI/180)}class MercatorCoordinate{constructor(e,t,i=0){this.x=+e,this.y=+t,this.z=+i}static fromLngLat(e,t=0){const i=Pa.convert(e);return new MercatorCoordinate(za(i.lng),ka(i.lat),La(t,i.lat))}toLngLat(){return new Pa(Ba(this.x),Ra(this.y))}toAltitude(){return Fa(this.z,this.y)}meterInMercatorCoordinateUnits(){return 1/Ma*Ua(Ra(this.y))}}function Va(e,t,i,r,n,o,s,a,l){const c=(t+r)/2,u=(i+n)/2,h=new g(c,u);a(h),function(e,t,i,r,n,o){const s=i-n,a=r-o;return Math.abs((r-t)*s-(i-e)*a)/Math.hypot(s,a)}(h.x,h.y,o.x,o.y,s.x,s.y)>=l?(Va(e,t,i,c,u,o,h,a,l),Va(e,c,u,r,n,h,s,a,l)):e.push(s)}function ja(e,t,i){let r=e[0],n=r.x,o=r.y;t(r);const s=[r];for(let a=1;a<e.length;a++){const l=e[a],{x:c,y:u}=l;t(l),Va(s,n,o,c,u,r,l,t,i),n=c,o=u,r=l}return s}function Na(e,t,i,r){if(r(t,i)){const n=t.add(i)._mult(.5);Na(e,t,n,r),Na(e,n,i,r)}else e.push(i)}function Ga(e,t){let i=e[0];const r=[i];for(let n=1;n<e.length;n++){const o=e[n];Na(r,i,o,t),i=o}return r}const qa=Math.pow(2,14)-1,Za=-qa-1;function $a(e,t){const i=Math.round(e.x*t),r=Math.round(e.y*t);return e.x=M(i,Za,qa),e.y=M(r,Za,qa),(i<e.x||i>e.x+1||r<e.y||r>e.y+1)&&H("Geometry exceeds allowed extent, reduce your vector tile buffer size"),e}function Wa(e,t,i){const r=e.loadGeometry(),n=e.extent,o=Uo/n;if(t&&i&&i.projection.isReprojectedInTileSpace){const o=1<<t.z,{scale:s,x:a,y:l,projection:c}=i,u=e=>{const i=Ba((t.x+e.x/n)/o),r=Ra((t.y+e.y/n)/o),u=c.project(i,r);e.x=(u.x*s-a)*n,e.y=(u.y*s-l)*n};for(let t=0;t<r.length;t++)if(1!==e.type)r[t]=ja(r[t],u,1);else{const e=[];for(const i of r[t])i.x<0||i.x>=n||i.y<0||i.y>=n||(u(i),e.push(i));r[t]=e}}for(const e of r)for(const t of e)$a(t,o);return r}function Ha(e,t){return{type:e.type,id:e.id,properties:e.properties,geometry:t?Wa(e):[]}}function Xa(e,t,i,r,n){e.emplaceBack(2*t+(r+1)/2,2*i+(n+1)/2)}function Ka(e,t,i){const r=16384;e.emplaceBack(t.x,t.y,t.z,i[0]*r,i[1]*r,i[2]*r)}class CircleBucket{constructor(e){this.zoom=e.zoom,this.overscaling=e.overscaling,this.layers=e.layers,this.layerIds=this.layers.map((e=>e.id)),this.index=e.index,this.hasPattern=!1,this.projection=e.projection,this.layoutVertexArray=new StructArrayLayout2i4,this.indexArray=new StructArrayLayout3ui6,this.segments=new SegmentVector,this.programConfigurations=new ProgramConfigurationSet(e.layers,e.zoom),this.stateDependentLayerIds=this.layers.filter((e=>e.isStateDependent())).map((e=>e.id))}populate(e,t,i,r){const n=this.layers[0],o=[];let s=null;"circle"===n.type&&(s=n.layout.get("circle-sort-key"));for(const{feature:t,id:n,index:a,sourceLayerIndex:l}of e){const e=this.layers[0]._featureFilter.needGeometry,c=Ha(t,e);if(!this.layers[0]._featureFilter.filter(new EvaluationParameters(this.zoom),c,i))continue;const u=s?s.evaluate(c,{},i):void 0,h={id:n,properties:t.properties,type:t.type,sourceLayerIndex:l,index:a,geometry:e?c.geometry:Wa(t,i,r),patterns:{},sortKey:u};o.push(h)}s&&o.sort(((e,t)=>e.sortKey-t.sortKey));let a=null;"globe"===r.projection.name&&(this.globeExtVertexArray=new StructArrayLayout6i12,a=r.projection);for(const r of o){const{geometry:n,index:o,sourceLayerIndex:s}=r,l=e[o].feature;this.addFeature(r,n,o,t.availableImages,i,a),t.featureIndex.insert(l,n,o,s,this.index)}}update(e,t,i,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(e,t,this.stateDependentLayers,i,r)}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(e){this.uploaded||(this.layoutVertexBuffer=e.createVertexBuffer(this.layoutVertexArray,Fo.members),this.indexBuffer=e.createIndexBuffer(this.indexArray),this.globeExtVertexArray&&(this.globeExtVertexBuffer=e.createVertexBuffer(this.globeExtVertexArray,Oo.members))),this.programConfigurations.upload(e),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.globeExtVertexBuffer&&this.globeExtVertexBuffer.destroy())}addFeature(e,t,i,r,n,o){for(const i of t)for(const t of i){const i=t.x,r=t.y;if(i<0||i>=Uo||r<0||r>=Uo)continue;if(o){const e=o.projectTilePoint(i,r,n),t=o.upVector(n,i,r),s=this.globeExtVertexArray;Ka(s,e,t),Ka(s,e,t),Ka(s,e,t),Ka(s,e,t)}const s=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray,e.sortKey),a=s.vertexLength;Xa(this.layoutVertexArray,i,r,-1,-1),Xa(this.layoutVertexArray,i,r,1,-1),Xa(this.layoutVertexArray,i,r,1,1),Xa(this.layoutVertexArray,i,r,-1,1),this.indexArray.emplaceBack(a,a+1,a+2),this.indexArray.emplaceBack(a,a+2,a+3),s.vertexLength+=4,s.primitiveLength+=2}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,e,i,{},r,n)}}function Ja(e,t){for(let i=0;i<e.length;i++)if(sl(t,e[i]))return!0;for(let i=0;i<t.length;i++)if(sl(e,t[i]))return!0;return!!tl(e,t)}function Ya(e,t,i){return!!sl(e,t)||!!rl(t,e,i)}function Qa(e,t){if(1===e.length)return ol(t,e[0]);for(let i=0;i<t.length;i++){const r=t[i];for(let t=0;t<r.length;t++)if(sl(e,r[t]))return!0}for(let i=0;i<e.length;i++)if(ol(t,e[i]))return!0;for(let i=0;i<t.length;i++)if(tl(e,t[i]))return!0;return!1}function el(e,t,i){if(e.length>1){if(tl(e,t))return!0;for(let r=0;r<t.length;r++)if(rl(t[r],e,i))return!0}for(let r=0;r<e.length;r++)if(rl(e[r],t,i))return!0;return!1}function tl(e,t){if(0===e.length||0===t.length)return!1;for(let i=0;i<e.length-1;i++){const r=e[i],n=e[i+1];for(let e=0;e<t.length-1;e++)if(il(r,n,t[e],t[e+1]))return!0}return!1}function il(e,t,i,r){return X(e,i,r)!==X(t,i,r)&&X(e,t,i)!==X(e,t,r)}function rl(e,t,i){const r=i*i;if(1===t.length)return e.distSqr(t[0])<r;for(let i=1;i<t.length;i++)if(nl(e,t[i-1],t[i])<r)return!0;return!1}function nl(e,t,i){const r=t.distSqr(i);if(0===r)return e.distSqr(t);const n=((e.x-t.x)*(i.x-t.x)+(e.y-t.y)*(i.y-t.y))/r;return e.distSqr(n<0?t:n>1?i:i.sub(t)._mult(n)._add(t))}function ol(e,t){let i,r,n,o=!1;for(let s=0;s<e.length;s++){i=e[s];for(let e=0,s=i.length-1;e<i.length;s=e++)r=i[e],n=i[s],r.y>t.y!=n.y>t.y&&t.x<(n.x-r.x)*(t.y-r.y)/(n.y-r.y)+r.x&&(o=!o)}return o}function sl(e,t){let i=!1;for(let r=0,n=e.length-1;r<e.length;n=r++){const o=e[r],s=e[n];o.y>t.y!=s.y>t.y&&t.x<(s.x-o.x)*(t.y-o.y)/(s.y-o.y)+o.x&&(i=!i)}return i}function al(e,t,i,r,n){for(const o of e)if(t<=o.x&&i<=o.y&&r>=o.x&&n>=o.y)return!0;const o=[new g(t,i),new g(t,n),new g(r,n),new g(r,i)];if(e.length>2)for(const t of o)if(sl(e,t))return!0;for(let t=0;t<e.length-1;t++)if(ll(e[t],e[t+1],o))return!0;return!1}function ll(e,t,i){const r=i[0],n=i[2];if(e.x<r.x&&t.x<r.x||e.x>n.x&&t.x>n.x||e.y<r.y&&t.y<r.y||e.y>n.y&&t.y>n.y)return!1;const o=X(e,t,i[0]);return o!==X(e,t,i[1])||o!==X(e,t,i[2])||o!==X(e,t,i[3])}function cl(e,t,i){const r=t.paint.get(e).value;return"constant"===r.kind?r.value:i.programConfigurations.get(t.id).getMaxValue(e)}function ul(e){return Math.sqrt(e[0]*e[0]+e[1]*e[1])}function hl(e,t,i,r,n){if(!t[0]&&!t[1])return e;const o=g.convert(t)._mult(n);"viewport"===i&&o._rotate(-r);const s=[];for(let t=0;t<e.length;t++)s.push(e[t].sub(o));return s}function dl(e,t,i,r){const n=g.convert(e)._mult(r);return"viewport"===t&&n._rotate(-i),n}jn(CircleBucket,"CircleBucket",{omit:["layers"]});const pl=new Properties({"circle-sort-key":new DataDrivenProperty(yt.layout_circle["circle-sort-key"])});var fl={paint:new Properties({"circle-radius":new DataDrivenProperty(yt.paint_circle["circle-radius"]),"circle-color":new DataDrivenProperty(yt.paint_circle["circle-color"]),"circle-blur":new DataDrivenProperty(yt.paint_circle["circle-blur"]),"circle-opacity":new DataDrivenProperty(yt.paint_circle["circle-opacity"]),"circle-translate":new DataConstantProperty(yt.paint_circle["circle-translate"]),"circle-translate-anchor":new DataConstantProperty(yt.paint_circle["circle-translate-anchor"]),"circle-pitch-scale":new DataConstantProperty(yt.paint_circle["circle-pitch-scale"]),"circle-pitch-alignment":new DataConstantProperty(yt.paint_circle["circle-pitch-alignment"]),"circle-stroke-width":new DataDrivenProperty(yt.paint_circle["circle-stroke-width"]),"circle-stroke-color":new DataDrivenProperty(yt.paint_circle["circle-stroke-color"]),"circle-stroke-opacity":new DataDrivenProperty(yt.paint_circle["circle-stroke-opacity"])}),layout:pl};function ml(e,t,i,r,n,o,s,a,l){if(o&&e.queryGeometry.isAboveHorizon)return!1;o&&(l*=e.pixelToTileUnitsFactor);const c=e.tileID.canonical,u=i.projection.upVectorScale(c,i.center.lat,i.worldSize).metersToTile;for(const h of t)for(const t of h){const h=t.add(a),d=n&&i.elevation?i.elevation.exaggeration()*n.getElevationAt(h.x,h.y,!0):0,p=i.projection.projectTilePoint(h.x,h.y,c);if(d>0){const e=i.projection.upVector(c,h.x,h.y);p.x+=e[0]*u*d,p.y+=e[1]*u*d,p.z+=e[2]*u*d}const f=o?h:_l(p.x,p.y,p.z,r),m=o?e.tilespaceRays.map((e=>xl(e,d))):e.queryGeometry.screenGeometry,_=zs([],[p.x,p.y,p.z,1],r);if(!s&&o?l*=_[3]/i.cameraToCenterDistance:s&&!o&&(l*=i.cameraToCenterDistance/_[3]),o){const e=Ra((t.y/Uo+c.y)/(1<<c.z));l/=i.projection.pixelsPerMeter(e,1)/La(1,e)}if(Ya(m,f,l))return!0}return!1}function _l(e,t,i,r){const n=zs([],[e,t,i,1],r);return new g(n[0]/n[3],n[1]/n[3])}const gl=us(0,0,0),yl=us(0,0,1);function xl(e,t){const i=as();return gl[2]=t,e.intersectsPlane(gl,yl,i),new g(i[0],i[1])}class HeatmapBucket extends CircleBucket{}function vl(e,{width:t,height:i},r,n){if(n){if(n instanceof Uint8ClampedArray)n=new Uint8Array(n.buffer);else if(n.length!==t*i*r)throw new RangeError("mismatched image size")}else n=new Uint8Array(t*i*r);return e.width=t,e.height=i,e.data=n,e}function bl(e,t,i){const{width:r,height:n}=t;r===e.width&&n===e.height||(wl(e,t,{x:0,y:0},{x:0,y:0},{width:Math.min(e.width,r),height:Math.min(e.height,n)},i),e.width=r,e.height=n,e.data=t.data)}function wl(e,t,i,r,n,o){if(0===n.width||0===n.height)return t;if(n.width>e.width||n.height>e.height||i.x>e.width-n.width||i.y>e.height-n.height)throw new RangeError("out of range source coordinates for image copy");if(n.width>t.width||n.height>t.height||r.x>t.width-n.width||r.y>t.height-n.height)throw new RangeError("out of range destination coordinates for image copy");const s=e.data,a=t.data;for(let l=0;l<n.height;l++){const c=((i.y+l)*e.width+i.x)*o,u=((r.y+l)*t.width+r.x)*o;for(let e=0;e<n.width*o;e++)a[u+e]=s[c+e]}return t}jn(HeatmapBucket,"HeatmapBucket",{omit:["layers"]});class AlphaImage{constructor(e,t){vl(this,e,1,t)}resize(e){bl(this,new AlphaImage(e),1)}clone(){return new AlphaImage({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(e,t,i,r,n){wl(e,t,i,r,n,1)}}class RGBAImage{constructor(e,t){vl(this,e,4,t)}resize(e){bl(this,new RGBAImage(e),4)}replace(e,t){t?this.data.set(e):this.data=e instanceof Uint8ClampedArray?new Uint8Array(e.buffer):e}clone(){return new RGBAImage({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(e,t,i,r,n){wl(e,t,i,r,n,4)}}jn(AlphaImage,"AlphaImage"),jn(RGBAImage,"RGBAImage");var El={paint:new Properties({"heatmap-radius":new DataDrivenProperty(yt.paint_heatmap["heatmap-radius"]),"heatmap-weight":new DataDrivenProperty(yt.paint_heatmap["heatmap-weight"]),"heatmap-intensity":new DataConstantProperty(yt.paint_heatmap["heatmap-intensity"]),"heatmap-color":new ColorRampProperty(yt.paint_heatmap["heatmap-color"]),"heatmap-opacity":new DataConstantProperty(yt.paint_heatmap["heatmap-opacity"])})};function Tl(e){const t={},i=e.resolution||256,r=e.clips?e.clips.length:1,n=e.image||new RGBAImage({width:i,height:r}),o=(i,r,o)=>{t[e.evaluationKey]=o;const s=e.expression.evaluate(t);n.data[i+r+0]=Math.floor(255*s.r/s.a),n.data[i+r+1]=Math.floor(255*s.g/s.a),n.data[i+r+2]=Math.floor(255*s.b/s.a),n.data[i+r+3]=Math.floor(255*s.a)};if(e.clips)for(let t=0,n=0;t<r;++t,n+=4*i)for(let r=0,s=0;r<i;r++,s+=4){const a=r/(i-1),{start:l,end:c}=e.clips[t];o(n,s,l*(1-a)+c*a)}else for(let e=0,t=0;e<i;e++,t+=4)o(0,t,e/(i-1));return n}var Sl={paint:new Properties({"hillshade-illumination-direction":new DataConstantProperty(yt.paint_hillshade["hillshade-illumination-direction"]),"hillshade-illumination-anchor":new DataConstantProperty(yt.paint_hillshade["hillshade-illumination-anchor"]),"hillshade-exaggeration":new DataConstantProperty(yt.paint_hillshade["hillshade-exaggeration"]),"hillshade-shadow-color":new DataConstantProperty(yt.paint_hillshade["hillshade-shadow-color"]),"hillshade-highlight-color":new DataConstantProperty(yt.paint_hillshade["hillshade-highlight-color"]),"hillshade-accent-color":new DataConstantProperty(yt.paint_hillshade["hillshade-accent-color"])})};const Al=po([{name:"a_pos",components:2,type:"Int16"}],4),{members:Cl}=Al;var Il={exports:{}};function Ml(e,t,i){i=i||2;var r,n,o,s,a,l,c,u=t&&t.length,h=u?t[0]*i:e.length,d=Pl(e,0,h,i,!0),p=[];if(!d||d.next===d.prev)return p;if(u&&(d=function(e,t,i,r){var n,o,s,a=[];for(n=0,o=t.length;n<o;n++)(s=Pl(e,t[n]*r,n<o-1?t[n+1]*r:e.length,r,!1))===s.next&&(s.steiner=!0),a.push(jl(s));for(a.sort(Fl),n=0;n<a.length;n++)i=Ol(a[n],i);return i}(e,t,d,i)),e.length>80*i){r=o=e[0],n=s=e[1];for(var f=i;f<h;f+=i)(a=e[f])<r&&(r=a),(l=e[f+1])<n&&(n=l),a>o&&(o=a),l>s&&(s=l);c=0!==(c=Math.max(o-r,s-n))?32767/c:0}return zl(d,p,i,r,n,c,0),p}function Pl(e,t,i,r,n){var o,s;if(n===ec(e,t,i,r)>0)for(o=t;o<i;o+=r)s=Jl(o,e[o],e[o+1],s);else for(o=i-r;o>=t;o-=r)s=Jl(o,e[o],e[o+1],s);return s&&Zl(s,s.next)&&(Yl(s),s=s.next),s}function Dl(e,t){if(!e)return e;t||(t=e);var i,r=e;do{if(i=!1,r.steiner||!Zl(r,r.next)&&0!==ql(r.prev,r,r.next))r=r.next;else{if(Yl(r),(r=t=r.prev)===r.next)break;i=!0}}while(i||r!==t);return t}function zl(e,t,i,r,n,o,s){if(e){!s&&o&&function(e,t,i,r){var n=e;do{0===n.z&&(n.z=Vl(n.x,n.y,t,i,r)),n.prevZ=n.prev,n.nextZ=n.next,n=n.next}while(n!==e);n.prevZ.nextZ=null,n.prevZ=null,function(e){var t,i,r,n,o,s,a,l,c=1;do{for(i=e,e=null,o=null,s=0;i;){for(s++,r=i,a=0,t=0;t<c&&(a++,r=r.nextZ);t++);for(l=c;a>0||l>0&&r;)0!==a&&(0===l||!r||i.z<=r.z)?(n=i,i=i.nextZ,a--):(n=r,r=r.nextZ,l--),o?o.nextZ=n:e=n,n.prevZ=o,o=n;i=r}o.nextZ=null,c*=2}while(s>1)}(n)}(e,r,n,o);for(var a,l,c=e;e.prev!==e.next;)if(a=e.prev,l=e.next,o?Ll(e,r,n,o):kl(e))t.push(a.i/i|0),t.push(e.i/i|0),t.push(l.i/i|0),Yl(e),e=l.next,c=l.next;else if((e=l)===c){s?1===s?zl(e=Bl(Dl(e),t,i),t,i,r,n,o,2):2===s&&Rl(e,t,i,r,n,o):zl(Dl(e),t,i,r,n,o,1);break}}}function kl(e){var t=e.prev,i=e,r=e.next;if(ql(t,i,r)>=0)return!1;for(var n=t.x,o=i.x,s=r.x,a=t.y,l=i.y,c=r.y,u=n<o?n<s?n:s:o<s?o:s,h=a<l?a<c?a:c:l<c?l:c,d=n>o?n>s?n:s:o>s?o:s,p=a>l?a>c?a:c:l>c?l:c,f=r.next;f!==t;){if(f.x>=u&&f.x<=d&&f.y>=h&&f.y<=p&&Nl(n,a,o,l,s,c,f.x,f.y)&&ql(f.prev,f,f.next)>=0)return!1;f=f.next}return!0}function Ll(e,t,i,r){var n=e.prev,o=e,s=e.next;if(ql(n,o,s)>=0)return!1;for(var a=n.x,l=o.x,c=s.x,u=n.y,h=o.y,d=s.y,p=a<l?a<c?a:c:l<c?l:c,f=u<h?u<d?u:d:h<d?h:d,m=a>l?a>c?a:c:l>c?l:c,_=u>h?u>d?u:d:h>d?h:d,g=Vl(p,f,t,i,r),y=Vl(m,_,t,i,r),x=e.prevZ,v=e.nextZ;x&&x.z>=g&&v&&v.z<=y;){if(x.x>=p&&x.x<=m&&x.y>=f&&x.y<=_&&x!==n&&x!==s&&Nl(a,u,l,h,c,d,x.x,x.y)&&ql(x.prev,x,x.next)>=0)return!1;if(x=x.prevZ,v.x>=p&&v.x<=m&&v.y>=f&&v.y<=_&&v!==n&&v!==s&&Nl(a,u,l,h,c,d,v.x,v.y)&&ql(v.prev,v,v.next)>=0)return!1;v=v.nextZ}for(;x&&x.z>=g;){if(x.x>=p&&x.x<=m&&x.y>=f&&x.y<=_&&x!==n&&x!==s&&Nl(a,u,l,h,c,d,x.x,x.y)&&ql(x.prev,x,x.next)>=0)return!1;x=x.prevZ}for(;v&&v.z<=y;){if(v.x>=p&&v.x<=m&&v.y>=f&&v.y<=_&&v!==n&&v!==s&&Nl(a,u,l,h,c,d,v.x,v.y)&&ql(v.prev,v,v.next)>=0)return!1;v=v.nextZ}return!0}function Bl(e,t,i){var r=e;do{var n=r.prev,o=r.next.next;!Zl(n,o)&&$l(n,r,r.next,o)&&Xl(n,o)&&Xl(o,n)&&(t.push(n.i/i|0),t.push(r.i/i|0),t.push(o.i/i|0),Yl(r),Yl(r.next),r=e=o),r=r.next}while(r!==e);return Dl(r)}function Rl(e,t,i,r,n,o){var s=e;do{for(var a=s.next.next;a!==s.prev;){if(s.i!==a.i&&Gl(s,a)){var l=Kl(s,a);return s=Dl(s,s.next),l=Dl(l,l.next),zl(s,t,i,r,n,o,0),void zl(l,t,i,r,n,o,0)}a=a.next}s=s.next}while(s!==e)}function Fl(e,t){return e.x-t.x}function Ol(e,t){var i=function(e,t){var i,r=t,n=e.x,o=e.y,s=-1/0;do{if(o<=r.y&&o>=r.next.y&&r.next.y!==r.y){var a=r.x+(o-r.y)*(r.next.x-r.x)/(r.next.y-r.y);if(a<=n&&a>s&&(s=a,i=r.x<r.next.x?r:r.next,a===n))return i}r=r.next}while(r!==t);if(!i)return null;var l,c=i,u=i.x,h=i.y,d=1/0;r=i;do{n>=r.x&&r.x>=u&&n!==r.x&&Nl(o<h?n:s,o,u,h,o<h?s:n,o,r.x,r.y)&&(l=Math.abs(o-r.y)/(n-r.x),Xl(r,e)&&(l<d||l===d&&(r.x>i.x||r.x===i.x&&Ul(i,r)))&&(i=r,d=l)),r=r.next}while(r!==c);return i}(e,t);if(!i)return t;var r=Kl(i,e);return Dl(r,r.next),Dl(i,i.next)}function Ul(e,t){return ql(e.prev,e,t.prev)<0&&ql(t.next,e,e.next)<0}function Vl(e,t,i,r,n){return(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=(e-i)*n|0)|e<<8))|e<<4))|e<<2))|e<<1))|(t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=(t-r)*n|0)|t<<8))|t<<4))|t<<2))|t<<1))<<1}function jl(e){var t=e,i=e;do{(t.x<i.x||t.x===i.x&&t.y<i.y)&&(i=t),t=t.next}while(t!==e);return i}function Nl(e,t,i,r,n,o,s,a){return(n-s)*(t-a)>=(e-s)*(o-a)&&(e-s)*(r-a)>=(i-s)*(t-a)&&(i-s)*(o-a)>=(n-s)*(r-a)}function Gl(e,t){return e.next.i!==t.i&&e.prev.i!==t.i&&!function(e,t){var i=e;do{if(i.i!==e.i&&i.next.i!==e.i&&i.i!==t.i&&i.next.i!==t.i&&$l(i,i.next,e,t))return!0;i=i.next}while(i!==e);return!1}(e,t)&&(Xl(e,t)&&Xl(t,e)&&function(e,t){var i=e,r=!1,n=(e.x+t.x)/2,o=(e.y+t.y)/2;do{i.y>o!=i.next.y>o&&i.next.y!==i.y&&n<(i.next.x-i.x)*(o-i.y)/(i.next.y-i.y)+i.x&&(r=!r),i=i.next}while(i!==e);return r}(e,t)&&(ql(e.prev,e,t.prev)||ql(e,t.prev,t))||Zl(e,t)&&ql(e.prev,e,e.next)>0&&ql(t.prev,t,t.next)>0)}function ql(e,t,i){return(t.y-e.y)*(i.x-t.x)-(t.x-e.x)*(i.y-t.y)}function Zl(e,t){return e.x===t.x&&e.y===t.y}function $l(e,t,i,r){var n=Hl(ql(e,t,i)),o=Hl(ql(e,t,r)),s=Hl(ql(i,r,e)),a=Hl(ql(i,r,t));return n!==o&&s!==a||!(0!==n||!Wl(e,i,t))||!(0!==o||!Wl(e,r,t))||!(0!==s||!Wl(i,e,r))||!(0!==a||!Wl(i,t,r))}function Wl(e,t,i){return t.x<=Math.max(e.x,i.x)&&t.x>=Math.min(e.x,i.x)&&t.y<=Math.max(e.y,i.y)&&t.y>=Math.min(e.y,i.y)}function Hl(e){return e>0?1:e<0?-1:0}function Xl(e,t){return ql(e.prev,e,e.next)<0?ql(e,t,e.next)>=0&&ql(e,e.prev,t)>=0:ql(e,t,e.prev)<0||ql(e,e.next,t)<0}function Kl(e,t){var i=new Ql(e.i,e.x,e.y),r=new Ql(t.i,t.x,t.y),n=e.next,o=t.prev;return e.next=t,t.prev=e,i.next=n,n.prev=i,r.next=i,i.prev=r,o.next=r,r.prev=o,r}function Jl(e,t,i,r){var n=new Ql(e,t,i);return r?(n.next=r.next,n.prev=r,r.next.prev=n,r.next=n):(n.prev=n,n.next=n),n}function Yl(e){e.next.prev=e.prev,e.prev.next=e.next,e.prevZ&&(e.prevZ.nextZ=e.nextZ),e.nextZ&&(e.nextZ.prevZ=e.prevZ)}function Ql(e,t,i){this.i=e,this.x=t,this.y=i,this.prev=null,this.next=null,this.z=0,this.prevZ=null,this.nextZ=null,this.steiner=!1}function ec(e,t,i,r){for(var n=0,o=t,s=i-r;o<i;o+=r)n+=(e[s]-e[o])*(e[o+1]+e[s+1]),s=o;return n}Il.exports=Ml,Il.exports.default=Ml,Ml.deviation=function(e,t,i,r){var n=t&&t.length,o=Math.abs(ec(e,0,n?t[0]*i:e.length,i));if(n)for(var s=0,a=t.length;s<a;s++)o-=Math.abs(ec(e,t[s]*i,s<a-1?t[s+1]*i:e.length,i));var l=0;for(s=0;s<r.length;s+=3){var c=r[s]*i,u=r[s+1]*i,h=r[s+2]*i;l+=Math.abs((e[c]-e[h])*(e[u+1]-e[c+1])-(e[c]-e[u])*(e[h+1]-e[c+1]))}return 0===o&&0===l?0:Math.abs((l-o)/o)},Ml.flatten=function(e){for(var t=e[0][0].length,i={vertices:[],holes:[],dimensions:t},r=0,n=0;n<e.length;n++){for(var o=0;o<e[n].length;o++)for(var s=0;s<t;s++)i.vertices.push(e[n][o][s]);n>0&&i.holes.push(r+=e[n-1].length)}return i};var tc=h(Il.exports);function ic(e,t,i,r,n){rc(e,t,i||0,r||e.length-1,n||oc)}function rc(e,t,i,r,n){for(;r>i;){if(r-i>600){var o=r-i+1,s=t-i+1,a=Math.log(o),l=.5*Math.exp(2*a/3),c=.5*Math.sqrt(a*l*(o-l)/o)*(s-o/2<0?-1:1);rc(e,t,Math.max(i,Math.floor(t-s*l/o+c)),Math.min(r,Math.floor(t+(o-s)*l/o+c)),n)}var u=e[t],h=i,d=r;for(nc(e,i,t),n(e[r],u)>0&&nc(e,i,r);h<d;){for(nc(e,h,d),h++,d--;n(e[h],u)<0;)h++;for(;n(e[d],u)>0;)d--}0===n(e[i],u)?nc(e,i,d):nc(e,++d,r),d<=t&&(i=d+1),t<=d&&(r=d-1)}}function nc(e,t,i){var r=e[t];e[t]=e[i],e[i]=r}function oc(e,t){return e<t?-1:e>t?1:0}function sc(e,t){const i=e.length;if(i<=1)return[e];const r=[];let n,o;for(let t=0;t<i;t++){const i=K(e[t]);0!==i&&(e[t].area=Math.abs(i),void 0===o&&(o=i<0),o===i<0?(n&&r.push(n),n=[e[t]]):n.push(e[t]))}if(n&&r.push(n),t>1)for(let e=0;e<r.length;e++)r[e].length<=t||(ic(r[e],t,1,r[e].length-1,ac),r[e]=r[e].slice(0,t));return r}function ac(e,t){return t.area-e.area}function lc(e,t,i){const r=i.patternDependencies;let n=!1;for(const i of t){const t=i.paint.get(`${e}-pattern`);t.isConstant()||(n=!0);const o=t.constantOr(null);o&&(n=!0,r[o]=!0)}return n}function cc(e,t,i,r,n){const o=n.patternDependencies;for(const s of t){const t=s.paint.get(`${e}-pattern`).value;if("constant"!==t.kind){let e=t.evaluate({zoom:r},i,{},n.availableImages);e=e&&e.name?e.name:e,o[e]=!0,i.patterns[s.id]=e}}return i}class FillBucket{constructor(e){this.zoom=e.zoom,this.overscaling=e.overscaling,this.layers=e.layers,this.layerIds=this.layers.map((e=>e.id)),this.index=e.index,this.hasPattern=!1,this.patternFeatures=[],this.layoutVertexArray=new StructArrayLayout2i4,this.indexArray=new StructArrayLayout3ui6,this.indexArray2=new StructArrayLayout2ui4,this.programConfigurations=new ProgramConfigurationSet(e.layers,e.zoom),this.segments=new SegmentVector,this.segments2=new SegmentVector,this.stateDependentLayerIds=this.layers.filter((e=>e.isStateDependent())).map((e=>e.id)),this.projection=e.projection}populate(e,t,i,r){this.hasPattern=lc("fill",this.layers,t);const n=this.layers[0].layout.get("fill-sort-key"),o=[];for(const{feature:s,id:a,index:l,sourceLayerIndex:c}of e){const e=this.layers[0]._featureFilter.needGeometry,u=Ha(s,e);if(!this.layers[0]._featureFilter.filter(new EvaluationParameters(this.zoom),u,i))continue;const h=n?n.evaluate(u,{},i,t.availableImages):void 0,d={id:a,properties:s.properties,type:s.type,sourceLayerIndex:c,index:l,geometry:e?u.geometry:Wa(s,i,r),patterns:{},sortKey:h};o.push(d)}n&&o.sort(((e,t)=>e.sortKey-t.sortKey));for(const r of o){const{geometry:n,index:o,sourceLayerIndex:s}=r;if(this.hasPattern){const e=cc("fill",this.layers,r,this.zoom,t);this.patternFeatures.push(e)}else this.addFeature(r,n,o,i,{},t.availableImages);t.featureIndex.insert(e[o].feature,n,o,s,this.index)}}update(e,t,i,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(e,t,this.stateDependentLayers,i,r)}addFeatures(e,t,i,r,n){for(const e of this.patternFeatures)this.addFeature(e,e.geometry,e.index,t,i,r)}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(e){this.uploaded||(this.layoutVertexBuffer=e.createVertexBuffer(this.layoutVertexArray,Cl),this.indexBuffer=e.createIndexBuffer(this.indexArray),this.indexBuffer2=e.createIndexBuffer(this.indexArray2)),this.programConfigurations.upload(e),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.indexBuffer2.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.segments2.destroy())}addFeature(e,t,i,r,n,o=[]){for(const e of sc(t,500)){let t=0;for(const i of e)t+=i.length;const i=this.segments.prepareSegment(t,this.layoutVertexArray,this.indexArray),r=i.vertexLength,n=[],o=[];for(const t of e){if(0===t.length)continue;t!==e[0]&&o.push(n.length/2);const i=this.segments2.prepareSegment(t.length,this.layoutVertexArray,this.indexArray2),r=i.vertexLength;this.layoutVertexArray.emplaceBack(t[0].x,t[0].y),this.indexArray2.emplaceBack(r+t.length-1,r),n.push(t[0].x),n.push(t[0].y);for(let e=1;e<t.length;e++)this.layoutVertexArray.emplaceBack(t[e].x,t[e].y),this.indexArray2.emplaceBack(r+e-1,r+e),n.push(t[e].x),n.push(t[e].y);i.vertexLength+=t.length,i.primitiveLength+=t.length}const s=tc(n,o);for(let e=0;e<s.length;e+=3)this.indexArray.emplaceBack(r+s[e],r+s[e+1],r+s[e+2]);i.vertexLength+=t,i.primitiveLength+=s.length/3}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,e,i,n,o,r)}}jn(FillBucket,"FillBucket",{omit:["layers","patternFeatures"]});const uc=new Properties({"fill-sort-key":new DataDrivenProperty(yt.layout_fill["fill-sort-key"])});var hc={paint:new Properties({"fill-antialias":new DataConstantProperty(yt.paint_fill["fill-antialias"]),"fill-opacity":new DataDrivenProperty(yt.paint_fill["fill-opacity"]),"fill-color":new DataDrivenProperty(yt.paint_fill["fill-color"]),"fill-outline-color":new DataDrivenProperty(yt.paint_fill["fill-outline-color"]),"fill-translate":new DataConstantProperty(yt.paint_fill["fill-translate"]),"fill-translate-anchor":new DataConstantProperty(yt.paint_fill["fill-translate-anchor"]),"fill-pattern":new DataDrivenProperty(yt.paint_fill["fill-pattern"])}),layout:uc};const dc=po([{name:"a_pos_normal_ed",components:4,type:"Int16"}]),pc=po([{name:"a_centroid_pos",components:2,type:"Uint16"}]),fc=po([{name:"a_pos_3",components:3,type:"Int16"},{name:"a_pos_normal_3",components:3,type:"Int16"}]),{members:mc}=dc;var _c=m,gc=yc;function yc(e,t,i,r,n){this.properties={},this.extent=i,this.type=0,this._pbf=e,this._geometry=-1,this._keys=r,this._values=n,e.readFields(xc,this,t)}function xc(e,t,i){1==e?t.id=i.readVarint():2==e?function(e,t){for(var i=e.readVarint()+e.pos;e.pos<i;){var r=t._keys[e.readVarint()],n=t._values[e.readVarint()];t.properties[r]=n}}(i,t):3==e?t.type=i.readVarint():4==e&&(t._geometry=i.pos)}function vc(e){for(var t,i,r=0,n=0,o=e.length,s=o-1;n<o;s=n++)r+=((i=e[s]).x-(t=e[n]).x)*(t.y+i.y);return r}yc.types=["Unknown","Point","LineString","Polygon"],yc.prototype.loadGeometry=function(){var e=this._pbf;e.pos=this._geometry;for(var t,i=e.readVarint()+e.pos,r=1,n=0,o=0,s=0,a=[];e.pos<i;){if(n<=0){var l=e.readVarint();r=7&l,n=l>>3}if(n--,1===r||2===r)o+=e.readSVarint(),s+=e.readSVarint(),1===r&&(t&&a.push(t),t=[]),t.push(new _c(o,s));else{if(7!==r)throw new Error("unknown command "+r);t&&t.push(t[0].clone())}}return t&&a.push(t),a},yc.prototype.bbox=function(){var e=this._pbf;e.pos=this._geometry;for(var t=e.readVarint()+e.pos,i=1,r=0,n=0,o=0,s=1/0,a=-1/0,l=1/0,c=-1/0;e.pos<t;){if(r<=0){var u=e.readVarint();i=7&u,r=u>>3}if(r--,1===i||2===i)(n+=e.readSVarint())<s&&(s=n),n>a&&(a=n),(o+=e.readSVarint())<l&&(l=o),o>c&&(c=o);else if(7!==i)throw new Error("unknown command "+i)}return[s,l,a,c]},yc.prototype.toGeoJSON=function(e,t,i){var r,n,o=this.extent*Math.pow(2,i),s=this.extent*e,a=this.extent*t,l=this.loadGeometry(),c=yc.types[this.type];function u(e){for(var t=0;t<e.length;t++){var i=e[t];e[t]=[360*(i.x+s)/o-180,360/Math.PI*Math.atan(Math.exp((180-360*(i.y+a)/o)*Math.PI/180))-90]}}switch(this.type){case 1:var h=[];for(r=0;r<l.length;r++)h[r]=l[r][0];u(l=h);break;case 2:for(r=0;r<l.length;r++)u(l[r]);break;case 3:for(l=function(e){var t=e.length;if(t<=1)return[e];for(var i,r,n=[],o=0;o<t;o++){var s=vc(e[o]);0!==s&&(void 0===r&&(r=s<0),r===s<0?(i&&n.push(i),i=[e[o]]):i.push(e[o]))}return i&&n.push(i),n}(l),r=0;r<l.length;r++)for(n=0;n<l[r].length;n++)u(l[r][n])}1===l.length?l=l[0]:c="Multi"+c;var d={type:"Feature",geometry:{type:c,coordinates:l},properties:this.properties};return"id"in this&&(d.id=this.id),d};var bc=gc,wc=Ec;function Ec(e,t){this.version=1,this.name=null,this.extent=4096,this.length=0,this._pbf=e,this._keys=[],this._values=[],this._features=[],e.readFields(Tc,this,t),this.length=this._features.length}function Tc(e,t,i){15===e?t.version=i.readVarint():1===e?t.name=i.readString():5===e?t.extent=i.readVarint():2===e?t._features.push(i.pos):3===e?t._keys.push(i.readString()):4===e&&t._values.push(function(e){for(var t=null,i=e.readVarint()+e.pos;e.pos<i;){var r=e.readVarint()>>3;t=1===r?e.readString():2===r?e.readFloat():3===r?e.readDouble():4===r?e.readVarint64():5===r?e.readVarint():6===r?e.readSVarint():7===r?e.readBoolean():null}return t}(i))}Ec.prototype.feature=function(e){if(e<0||e>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[e];var t=this._pbf.readVarint()+this._pbf.pos;return new bc(this._pbf,t,this.extent,this._keys,this._values)};var Sc=wc;function Ac(e,t,i){if(3===e){var r=new Sc(i,i.readVarint()+i.pos);r.length&&(t[r.name]=r)}}var Cc=function(e,t){this.layers=e.readFields(Ac,{},t)},Ic=gc;function Mc(e,t,i,r){const n=[],o=0===r?(e,t,i,r,n,o)=>{e.push(new g(o,i+(o-t)/(r-t)*(n-i)))}:(e,t,i,r,n,o)=>{e.push(new g(t+(o-i)/(n-i)*(r-t),o))};for(const s of e){const e=[];for(const n of s){if(n.length<=2)continue;const s=[];for(let e=0;e<n.length-1;e++){const a=n[e].x,l=n[e].y,c=n[e+1].x,u=n[e+1].y,h=0===r?a:l,d=0===r?c:u;h<t?d>t&&o(s,a,l,c,u,t):h>i?d<i&&o(s,a,l,c,u,i):s.push(n[e]),d<t&&h>=t&&o(s,a,l,c,u,t),d>i&&h<=i&&o(s,a,l,c,u,i)}let a=n[n.length-1];const l=0===r?a.x:a.y;l>=t&&l<=i&&s.push(a),s.length&&(a=s[s.length-1],s[0].x===a.x&&s[0].y===a.y||s.push(s[0]),e.push(s))}e.length&&n.push(e)}return n}const Pc=Ic.types,Dc=Math.pow(2,13);function zc(e,t,i,r,n,o,s,a){e.emplaceBack((t<<1)+s,(i<<1)+o,(Math.floor(r*Dc)<<1)+n,Math.round(a))}function kc(e,t,i){const r=16384;e.emplaceBack(t.x,t.y,t.z,i[0]*r,i[1]*r,i[2]*r)}class PartMetadata{constructor(){this.acc=new g(0,0),this.polyCount=[]}startRing(e){this.currentPolyCount={edges:0,top:0},this.polyCount.push(this.currentPolyCount),this.min||(this.min=new g(e.x,e.y),this.max=new g(e.x,e.y))}append(e,t){this.currentPolyCount.edges++,this.acc._add(e);const i=this.min,r=this.max;e.x<i.x?i.x=e.x:e.x>r.x&&(r.x=e.x),e.y<i.y?i.y=e.y:e.y>r.y&&(r.y=e.y),((0===e.x||e.x===Uo)&&e.x===t.x)!=((0===e.y||e.y===Uo)&&e.y===t.y)&&this.processBorderOverlap(e,t),t.x<0!=e.x<0&&this.addBorderIntersection(0,zi(t.y,e.y,(0-t.x)/(e.x-t.x))),t.x>Uo!=e.x>Uo&&this.addBorderIntersection(1,zi(t.y,e.y,(Uo-t.x)/(e.x-t.x))),t.y<0!=e.y<0&&this.addBorderIntersection(2,zi(t.x,e.x,(0-t.y)/(e.y-t.y))),t.y>Uo!=e.y>Uo&&this.addBorderIntersection(3,zi(t.x,e.x,(Uo-t.y)/(e.y-t.y)))}addBorderIntersection(e,t){this.borders||(this.borders=[[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE]]);const i=this.borders[e];t<i[0]&&(i[0]=t),t>i[1]&&(i[1]=t)}processBorderOverlap(e,t){if(e.x===t.x){if(e.y===t.y)return;const i=0===e.x?0:1;this.addBorderIntersection(i,t.y),this.addBorderIntersection(i,e.y)}else{const i=0===e.y?2:3;this.addBorderIntersection(i,t.x),this.addBorderIntersection(i,e.x)}}centroid(){const e=this.polyCount.reduce(((e,t)=>e+t.edges),0);return 0!==e?this.acc.div(e)._round():new g(0,0)}span(){return new g(this.max.x-this.min.x,this.max.y-this.min.y)}intersectsCount(){return this.borders.reduce(((e,t)=>e+ +(t[0]!==Number.MAX_VALUE)),0)}}class FillExtrusionBucket{constructor(e){this.zoom=e.zoom,this.canonical=e.canonical,this.overscaling=e.overscaling,this.layers=e.layers,this.layerIds=this.layers.map((e=>e.id)),this.index=e.index,this.hasPattern=!1,this.edgeRadius=0,this.projection=e.projection,this.layoutVertexArray=new StructArrayLayout4i8,this.centroidVertexArray=new FillExtrusionCentroidArray,this.indexArray=new StructArrayLayout3ui6,this.programConfigurations=new ProgramConfigurationSet(e.layers,e.zoom),this.segments=new SegmentVector,this.stateDependentLayerIds=this.layers.filter((e=>e.isStateDependent())).map((e=>e.id)),this.enableTerrain=e.enableTerrain}populate(e,t,i,r){this.features=[],this.hasPattern=lc("fill-extrusion",this.layers,t),this.featuresOnBorder=[],this.borders=[[],[],[],[]],this.borderDoneWithNeighborZ=[-1,-1,-1,-1],this.tileToMeter=function(e){const t=Math.exp(Math.PI*(1-e.y/(1<<e.z)*2));return 80150034*t/(t*t+1)/Uo/(1<<e.z)}(i),this.edgeRadius=this.layers[0].layout.get("fill-extrusion-edge-radius")/this.tileToMeter;for(const{feature:n,id:o,index:s,sourceLayerIndex:a}of e){const e=this.layers[0]._featureFilter.needGeometry,l=Ha(n,e);if(!this.layers[0]._featureFilter.filter(new EvaluationParameters(this.zoom),l,i))continue;const c={id:o,sourceLayerIndex:a,index:s,geometry:e?l.geometry:Wa(n,i,r),properties:n.properties,type:n.type,patterns:{}},u=this.layoutVertexArray.length;this.hasPattern?this.features.push(cc("fill-extrusion",this.layers,c,this.zoom,t)):this.addFeature(c,c.geometry,s,i,{},t.availableImages,r),t.featureIndex.insert(n,c.geometry,s,a,this.index,u)}this.sortBorders()}addFeatures(e,t,i,r,n){for(const e of this.features){const{geometry:o}=e;this.addFeature(e,o,e.index,t,i,r,n)}this.sortBorders()}update(e,t,i,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(e,t,this.stateDependentLayers,i,r)}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(e){this.uploaded||(this.layoutVertexBuffer=e.createVertexBuffer(this.layoutVertexArray,mc),this.indexBuffer=e.createIndexBuffer(this.indexArray),this.layoutVertexExtArray&&(this.layoutVertexExtBuffer=e.createVertexBuffer(this.layoutVertexExtArray,fc.members,!0))),this.programConfigurations.upload(e),this.uploaded=!0}uploadCentroid(e){0!==this.centroidVertexArray.length&&(this.centroidVertexBuffer?this.needsCentroidUpdate&&this.centroidVertexBuffer.updateData(this.centroidVertexArray):this.centroidVertexBuffer=e.createVertexBuffer(this.centroidVertexArray,pc.members,!0),this.needsCentroidUpdate=!1)}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.centroidVertexBuffer&&this.centroidVertexBuffer.destroy(),this.layoutVertexExtBuffer&&this.layoutVertexExtBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy())}addFeature(e,t,i,r,n,o,s){const a=[new g(0,0),new g(Uo,Uo)],l=s.projection,c="globe"===l.name,u=this.enableTerrain&&!c?new PartMetadata:null,h="Polygon"===Pc[e.type];c&&!this.layoutVertexExtArray&&(this.layoutVertexExtArray=new StructArrayLayout6i12);const d=sc(t,500);for(let e=d.length-1;e>=0;e--){const t=d[e];(0===t.length||(p=t[0]).every((e=>e.x<=0))||p.every((e=>e.x>=Uo))||p.every((e=>e.y<=0))||p.every((e=>e.y>=Uo)))&&d.splice(e,1)}var p;let f;if(c)f=jc(d,a,r);else{f=[];for(const e of d)f.push({polygon:e,bounds:a})}const m=h?this.edgeRadius:0;for(const{polygon:e,bounds:t}of f){let i=0,n=0;for(const t of e)h&&!t[0].equals(t[t.length-1])&&t.push(t[0]),n+=h?t.length-1:t.length;const o=this.segments.prepareSegment((h?5:4)*n,this.layoutVertexArray,this.indexArray);if(h){const t=[],n=[];i=o.vertexLength;for(const i of e){let s,a;i.length&&i!==e[0]&&n.push(t.length/2),s=i[1].sub(i[0])._perp()._unit();for(let e=1;e<i.length;e++){const n=i[e],u=i[e===i.length-1?1:e+1];let{x:h,y:d}=n;if(m){a=u.sub(n)._perp()._unit();const e=s.add(a)._unit(),t=m*Math.min(4,1/(s.x*e.x+s.y*e.y));h+=t*e.x,d+=t*e.y,s=a}zc(this.layoutVertexArray,h,d,0,0,1,1,0),o.vertexLength++,t.push(n.x,n.y),c&&kc(this.layoutVertexExtArray,l.projectTilePoint(h,d,r),l.upVector(r,h,d))}}const s=tc(t,n);for(let e=0;e<s.length;e+=3)this.indexArray.emplaceBack(i+s[e],i+s[e+2],i+s[e+1]),o.primitiveLength++}for(const n of e){u&&n.length&&u.startRing(n[0]);let e,s,a,d=n.length>4&&Oc(n[n.length-2],n[0],n[1]),p=m?Bc(n[n.length-2],n[0],n[1],m):0;s=n[1].sub(n[0])._perp()._unit();let f=!0;for(let _=1,g=0;_<n.length;_++){let y=n[_-1],x=n[_];const v=n[_===n.length-1?1:_+1];if(u&&h&&u.currentPolyCount.top++,Fc(x,y,t)){m&&(s=v.sub(x)._perp()._unit(),f=!f);continue}u&&u.append(x,y);const b=x.sub(y)._perp(),w=b.x/(Math.abs(b.x)+Math.abs(b.y)),E=b.y>0?1:0,T=y.dist(x);if(g+T>32768&&(g=0),m){a=v.sub(x)._perp()._unit();let e=Rc(y,x,v,Lc(s,a),m);isNaN(e)&&(e=0);const t=x.sub(y)._unit();y=y.add(t.mult(p))._round(),x=x.add(t.mult(-e))._round(),p=e,s=a}const S=o.vertexLength,A=n.length>4&&Oc(y,x,v);let C=Uc(g,d,f);if(zc(this.layoutVertexArray,y.x,y.y,w,E,0,0,C),zc(this.layoutVertexArray,y.x,y.y,w,E,0,1,C),g+=T,C=Uc(g,A,!f),d=A,zc(this.layoutVertexArray,x.x,x.y,w,E,0,0,C),zc(this.layoutVertexArray,x.x,x.y,w,E,0,1,C),o.vertexLength+=4,this.indexArray.emplaceBack(S+0,S+1,S+2),this.indexArray.emplaceBack(S+1,S+3,S+2),o.primitiveLength+=2,m){const r=i+(1===_?n.length-2:_-2),s=1===_?i:r+1;if(this.indexArray.emplaceBack(S+1,r,S+3),this.indexArray.emplaceBack(r,s,S+3),o.primitiveLength+=2,void 0===e&&(e=S),!Fc(v,n[_],t)){const t=_===n.length-1?e:o.vertexLength;this.indexArray.emplaceBack(S+2,S+3,t),this.indexArray.emplaceBack(S+3,t+1,t),this.indexArray.emplaceBack(S+3,s,t+1),o.primitiveLength+=3}f=!f}if(c){const e=this.layoutVertexExtArray,t=l.projectTilePoint(y.x,y.y,r),i=l.projectTilePoint(x.x,x.y,r),n=l.upVector(r,y.x,y.y),o=l.upVector(r,x.x,x.y);kc(e,t,n),kc(e,t,n),kc(e,i,o),kc(e,i,o)}}h&&(i+=n.length-1)}}if(u&&u.polyCount.length>0){if(u.borders){u.vertexArrayOffset=this.centroidVertexArray.length;const e=u.borders,t=this.featuresOnBorder.push(u)-1;for(let i=0;i<4;i++)e[i][0]!==Number.MAX_VALUE&&this.borders[i].push(t)}this.encodeCentroid(u.borders?void 0:u.centroid(),u)}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,e,i,n,o,r)}sortBorders(){for(let e=0;e<4;e++)this.borders[e].sort(((t,i)=>this.featuresOnBorder[t].borders[e][0]-this.featuresOnBorder[i].borders[e][0]))}encodeCentroid(e,t,i=!0){let r,n;if(e)if(0!==e.y){const i=t.span()._mult(this.tileToMeter);r=(Math.max(e.x,1)<<3)+Math.min(7,Math.round(i.x/10)),n=(Math.max(e.y,1)<<3)+Math.min(7,Math.round(i.y/10))}else r=Math.ceil(7*(e.x+450)),n=0;else r=0,n=+i;let o=i?this.centroidVertexArray.length:t.vertexArrayOffset;for(const e of t.polyCount){i&&this.centroidVertexArray.resize(this.centroidVertexArray.length+4*e.edges+e.top);for(let t=0;t<e.top;t++)this.centroidVertexArray.emplace(o++,r,n);for(let t=0;t<2*e.edges;t++)this.centroidVertexArray.emplace(o++,0,n),this.centroidVertexArray.emplace(o++,r,n)}}}function Lc(e,t){const i=e.add(t)._unit();return e.x*i.x+e.y*i.y}function Bc(e,t,i,r){const n=t.sub(e)._perp()._unit(),o=i.sub(t)._perp()._unit();return Rc(e,t,i,Lc(n,o),r)}function Rc(e,t,i,r,n){const o=Math.sqrt(1-r*r);return Math.min(e.dist(t)/3,t.dist(i)/3,n*o/r)}function Fc(e,t,i){return e.x<i[0].x&&t.x<i[0].x||e.x>i[1].x&&t.x>i[1].x||e.y<i[0].y&&t.y<i[0].y||e.y>i[1].y&&t.y>i[1].y}function Oc(e,t,i){if(e.x<0||e.x>=Uo||t.x<0||t.x>=Uo||i.x<0||i.x>=Uo)return!1;const r=i.sub(t),n=r.perp(),o=e.sub(t);return(r.x*o.x+r.y*o.y)/Math.sqrt((r.x*r.x+r.y*r.y)*(o.x*o.x+o.y*o.y))>-.866&&n.x*o.x+n.y*o.y<0}function Uc(e,t,i){const r=t?2|e:-3&e;return i?1|r:-2&r}function Vc(){const e=Math.PI/32,t=Math.tan(e),i=Ia;return i*Math.sqrt(1+2*t*t)-i}function jc(e,t,i){const r=1<<i.z,n=Ba(i.x/r),o=Ba((i.x+1)/r),s=Ra(i.y/r),a=Ra((i.y+1)/r);return function(e,t,i,r,n=0,o){const s=[];if(!e.length||!i||!r)return s;const a=(e,t)=>{for(const i of e)s.push({polygon:i,bounds:t})},l=Math.ceil(Math.log2(i)),c=Math.ceil(Math.log2(r)),u=l-c,h=[];for(let e=0;e<Math.abs(u);e++)h.push(u>0?0:1);for(let e=0;e<Math.min(l,c);e++)h.push(0),h.push(1);let d=e;if(d=Mc(d,t[0].y-n,t[1].y+n,1),d=Mc(d,t[0].x-n,t[1].x+n,0),!d.length)return s;const p=[];for(h.length?p.push({polygons:d,bounds:t,depth:0}):a(d,t);p.length;){const e=p.pop(),t=e.depth,i=h[t],r=e.bounds[0],s=e.bounds[1],l=0===i?r.x:r.y,c=0===i?s.x:s.y,u=o?o(i,l,c):.5*(l+c),d=Mc(e.polygons,l-n,u+n,i),f=Mc(e.polygons,u-n,c+n,i);if(d.length){const e=[r,new g(0===i?u:s.x,1===i?u:s.y)];h.length>t+1?p.push({polygons:d,bounds:e,depth:t+1}):a(d,e)}if(f.length){const e=[new g(0===i?u:r.x,1===i?u:r.y),s];h.length>t+1?p.push({polygons:f,bounds:e,depth:t+1}):a(f,e)}}return s}(e,t,Math.ceil((o-n)/11.25),Math.ceil((s-a)/11.25),1,((e,t,n)=>{if(0===e)return.5*(t+n);{const e=Ra((i.y+t/Uo)/r);return(ka(.5*(Ra((i.y+n/Uo)/r)+e))*r-i.y)*Uo}}))}jn(FillExtrusionBucket,"FillExtrusionBucket",{omit:["layers","features"]}),jn(PartMetadata,"PartMetadata");const Nc=new Properties({"fill-extrusion-edge-radius":new DataConstantProperty(yt["layout_fill-extrusion"]["fill-extrusion-edge-radius"])});var Gc={paint:new Properties({"fill-extrusion-opacity":new DataConstantProperty(yt["paint_fill-extrusion"]["fill-extrusion-opacity"]),"fill-extrusion-color":new DataDrivenProperty(yt["paint_fill-extrusion"]["fill-extrusion-color"]),"fill-extrusion-translate":new DataConstantProperty(yt["paint_fill-extrusion"]["fill-extrusion-translate"]),"fill-extrusion-translate-anchor":new DataConstantProperty(yt["paint_fill-extrusion"]["fill-extrusion-translate-anchor"]),"fill-extrusion-pattern":new DataDrivenProperty(yt["paint_fill-extrusion"]["fill-extrusion-pattern"]),"fill-extrusion-height":new DataDrivenProperty(yt["paint_fill-extrusion"]["fill-extrusion-height"]),"fill-extrusion-base":new DataDrivenProperty(yt["paint_fill-extrusion"]["fill-extrusion-base"]),"fill-extrusion-vertical-gradient":new DataConstantProperty(yt["paint_fill-extrusion"]["fill-extrusion-vertical-gradient"]),"fill-extrusion-ambient-occlusion-intensity":new DataConstantProperty(yt["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-intensity"]),"fill-extrusion-ambient-occlusion-radius":new DataConstantProperty(yt["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-radius"]),"fill-extrusion-rounded-roof":new DataConstantProperty(yt["paint_fill-extrusion"]["fill-extrusion-rounded-roof"])}),layout:Nc};function qc(e,t,i){var r=2*Math.PI*6378137/256/Math.pow(2,i);return[e*r-2*Math.PI*6378137/2,t*r-2*Math.PI*6378137/2]}class CanonicalTileID{constructor(e,t,i){this.z=e,this.x=t,this.y=i,this.key=Zc(0,e,e,t,i)}equals(e){return this.z===e.z&&this.x===e.x&&this.y===e.y}url(e,t){const i=function(e,t,i){var r=qc(256*e,256*(t=Math.pow(2,i)-t-1),i),n=qc(256*(e+1),256*(t+1),i);return r[0]+","+r[1]+","+n[0]+","+n[1]}(this.x,this.y,this.z),r=function(e,t,i){let r,n="";for(let o=e;o>0;o--)r=1<<o-1,n+=(t&r?1:0)+(i&r?2:0);return n}(this.z,this.x,this.y);return e[(this.x+this.y)%e.length].replace("{prefix}",(this.x%16).toString(16)+(this.y%16).toString(16)).replace(/{z}/g,String(this.z)).replace(/{x}/g,String(this.x)).replace(/{y}/g,String("tms"===t?Math.pow(2,this.z)-this.y-1:this.y)).replace("{quadkey}",r).replace("{bbox-epsg-3857}",i)}toString(){return`${this.z}/${this.x}/${this.y}`}}class UnwrappedTileID{constructor(e,t){this.wrap=e,this.canonical=t,this.key=Zc(e,t.z,t.z,t.x,t.y)}}class OverscaledTileID{constructor(e,t,i,r,n){this.overscaledZ=e,this.wrap=t,this.canonical=new CanonicalTileID(i,+r,+n),this.key=0===t&&e===i?this.canonical.key:Zc(t,e,i,r,n)}equals(e){return this.overscaledZ===e.overscaledZ&&this.wrap===e.wrap&&this.canonical.equals(e.canonical)}scaledTo(e){const t=this.canonical.z-e;return e>this.canonical.z?new OverscaledTileID(e,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y):new OverscaledTileID(e,this.wrap,e,this.canonical.x>>t,this.canonical.y>>t)}calculateScaledKey(e,t=!0){if(this.overscaledZ===e&&t)return this.key;if(e>this.canonical.z)return Zc(this.wrap*+t,e,this.canonical.z,this.canonical.x,this.canonical.y);{const i=this.canonical.z-e;return Zc(this.wrap*+t,e,e,this.canonical.x>>i,this.canonical.y>>i)}}isChildOf(e){if(e.wrap!==this.wrap)return!1;const t=this.canonical.z-e.canonical.z;return 0===e.overscaledZ||e.overscaledZ<this.overscaledZ&&e.canonical.x===this.canonical.x>>t&&e.canonical.y===this.canonical.y>>t}children(e){if(this.overscaledZ>=e)return[new OverscaledTileID(this.overscaledZ+1,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)];const t=this.canonical.z+1,i=2*this.canonical.x,r=2*this.canonical.y;return[new OverscaledTileID(t,this.wrap,t,i,r),new OverscaledTileID(t,this.wrap,t,i+1,r),new OverscaledTileID(t,this.wrap,t,i,r+1),new OverscaledTileID(t,this.wrap,t,i+1,r+1)]}isLessThan(e){return this.wrap<e.wrap||!(this.wrap>e.wrap)&&(this.overscaledZ<e.overscaledZ||!(this.overscaledZ>e.overscaledZ)&&(this.canonical.x<e.canonical.x||!(this.canonical.x>e.canonical.x)&&this.canonical.y<e.canonical.y))}wrapped(){return new OverscaledTileID(this.overscaledZ,0,this.canonical.z,this.canonical.x,this.canonical.y)}unwrapTo(e){return new OverscaledTileID(this.overscaledZ,e,this.canonical.z,this.canonical.x,this.canonical.y)}overscaleFactor(){return Math.pow(2,this.overscaledZ-this.canonical.z)}toUnwrapped(){return new UnwrappedTileID(this.wrap,this.canonical)}toString(){return`${this.overscaledZ}/${this.canonical.x}/${this.canonical.y}`}}function Zc(e,t,i,r,n){const o=1<<Math.min(i,22);let s=o*(n%o)+r%o;return e&&i<22&&(s+=o*o*((e<0?-2*e-1:2*e)%(1<<2*(22-i)))),16*(32*s+i)+(t-i)}jn(CanonicalTileID,"CanonicalTileID"),jn(OverscaledTileID,"OverscaledTileID",{omit:["projMatrix"]});class Point3D extends g{constructor(e,t,i){super(e,t),this.z=i}}function $c(e,t){return e.x*t.x+e.y*t.y}function Wc(e,t){if(1===e.length){let i=0;const r=t[i++];let n;for(;!n||r.equals(n);)if(n=t[i++],!n)return 1/0;for(;i<t.length;i++){const o=t[i],s=e[0],a=n.sub(r),l=o.sub(r),c=s.sub(r),u=$c(a,a),h=$c(a,l),d=$c(l,l),p=$c(c,a),f=$c(c,l),m=u*d-h*h,_=(d*p-h*f)/m,g=(u*f-h*p)/m,y=r.z*(1-_-g)+n.z*_+o.z*g;if(isFinite(y))return y}return 1/0}{let e=1/0;for(const i of t)e=Math.min(e,i.z);return e}}function Hc(e,t,i,r,n,o,s,a){const l=s*n.getElevationAt(e,t,!0,!0),c=0!==o[0],u=c?0===o[1]?s*(o[0]/7-450):s*function(e,t,i){const r=Math.floor(t[0]/8),n=Math.floor(t[1]/8),o=10*(t[0]-8*r),s=10*(t[1]-8*n),a=e.getElevationAt(r,n,!0,!0),l=e.getMeterToDEM(i),c=Math.floor(.5*(o*l-1)),u=Math.floor(.5*(s*l-1)),h=e.tileCoordToPixel(r,n),d=2*c+1,p=2*u+1,f=function(e,t,i,r,n){return[e.getElevationAtPixel(t,i,!0),e.getElevationAtPixel(t+n,i,!0),e.getElevationAtPixel(t,i+n,!0),e.getElevationAtPixel(t+r,i+n,!0)]}(e,h.x-c,h.y-u,d,p),m=Math.abs(f[0]-f[1]),_=Math.abs(f[2]-f[3]),g=Math.abs(f[0]-f[2])+Math.abs(f[1]-f[3]),y=Math.min(.25,.5*l*(m+_)/d),x=Math.min(.25,.5*l*g/p);return a+Math.max(y*o,x*s)}(n,o,a):l;return{base:l+(0===i)?-1:i,top:c?Math.max(u+r,l+i+2):l+r}}const Xc=po([{name:"a_pos_normal",components:2,type:"Int16"},{name:"a_data",components:4,type:"Uint8"},{name:"a_linesofar",components:1,type:"Float32"}],4),{members:Kc}=Xc,Jc=po([{name:"a_packed",components:4,type:"Float32"}]),{members:Yc}=Jc,Qc=Ic.types,eu=Math.cos(Math.PI/180*37.5);class LineBucket{constructor(e){this.zoom=e.zoom,this.overscaling=e.overscaling,this.layers=e.layers,this.layerIds=this.layers.map((e=>e.id)),this.index=e.index,this.projection=e.projection,this.hasPattern=!1,this.patternFeatures=[],this.lineClipsArray=[],this.gradients={},this.layers.forEach((e=>{this.gradients[e.id]={}})),this.layoutVertexArray=new StructArrayLayout2i4ub1f12,this.layoutVertexArray2=new StructArrayLayout4f16,this.indexArray=new StructArrayLayout3ui6,this.programConfigurations=new ProgramConfigurationSet(e.layers,e.zoom),this.segments=new SegmentVector,this.maxLineLength=0,this.stateDependentLayerIds=this.layers.filter((e=>e.isStateDependent())).map((e=>e.id))}populate(e,t,i,r){this.hasPattern=lc("line",this.layers,t);const n=this.layers[0].layout.get("line-sort-key"),o=[];for(const{feature:t,id:s,index:a,sourceLayerIndex:l}of e){const e=this.layers[0]._featureFilter.needGeometry,c=Ha(t,e);if(!this.layers[0]._featureFilter.filter(new EvaluationParameters(this.zoom),c,i))continue;const u=n?n.evaluate(c,{},i):void 0,h={id:s,properties:t.properties,type:t.type,sourceLayerIndex:l,index:a,geometry:e?c.geometry:Wa(t,i,r),patterns:{},sortKey:u};o.push(h)}n&&o.sort(((e,t)=>e.sortKey-t.sortKey));const{lineAtlas:s,featureIndex:a}=t,l=this.addConstantDashes(s);for(const r of o){const{geometry:n,index:o,sourceLayerIndex:c}=r;if(l&&this.addFeatureDashes(r,s),this.hasPattern){const e=cc("line",this.layers,r,this.zoom,t);this.patternFeatures.push(e)}else this.addFeature(r,n,o,i,s.positions,t.availableImages);a.insert(e[o].feature,n,o,c,this.index)}}addConstantDashes(e){let t=!1;for(const i of this.layers){const r=i.paint.get("line-dasharray").value,n=i.layout.get("line-cap").value;if("constant"!==r.kind||"constant"!==n.kind)t=!0;else{const t=n.value,i=r.value;if(!i)continue;e.addDash(i,t)}}return t}addFeatureDashes(e,t){const i=this.zoom;for(const r of this.layers){const n=r.paint.get("line-dasharray").value,o=r.layout.get("line-cap").value;if("constant"===n.kind&&"constant"===o.kind)continue;let s,a;if("constant"===n.kind){if(s=n.value,!s)continue}else s=n.evaluate({zoom:i},e);a="constant"===o.kind?o.value:o.evaluate({zoom:i},e),t.addDash(s,a),e.patterns[r.id]=t.getKey(s,a)}}update(e,t,i,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(e,t,this.stateDependentLayers,i,r)}addFeatures(e,t,i,r,n){for(const e of this.patternFeatures)this.addFeature(e,e.geometry,e.index,t,i,r)}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(e){this.uploaded||(0!==this.layoutVertexArray2.length&&(this.layoutVertexBuffer2=e.createVertexBuffer(this.layoutVertexArray2,Yc)),this.layoutVertexBuffer=e.createVertexBuffer(this.layoutVertexArray,Kc),this.indexBuffer=e.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(e),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy())}lineFeatureClips(e){if(e.properties&&e.properties.hasOwnProperty("mapbox_clip_start")&&e.properties.hasOwnProperty("mapbox_clip_end"))return{start:+e.properties.mapbox_clip_start,end:+e.properties.mapbox_clip_end}}addFeature(e,t,i,r,n,o){const s=this.layers[0].layout,a=s.get("line-join").evaluate(e,{}),l=s.get("line-cap").evaluate(e,{}),c=s.get("line-miter-limit"),u=s.get("line-round-limit");this.lineClips=this.lineFeatureClips(e);for(const i of t)this.addLine(i,e,a,l,c,u);this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,e,i,n,o,r)}addLine(e,t,i,r,n,o){if(this.distance=0,this.scaledDistance=0,this.totalDistance=0,this.lineSoFar=0,this.lineClips){this.lineClipsArray.push(this.lineClips);for(let t=0;t<e.length-1;t++)this.totalDistance+=e[t].dist(e[t+1]);this.updateScaledDistance(),this.maxLineLength=Math.max(this.maxLineLength,this.totalDistance)}const s="Polygon"===Qc[t.type];let a=e.length;for(;a>=2&&e[a-1].equals(e[a-2]);)a--;let l=0;for(;l<a-1&&e[l].equals(e[l+1]);)l++;if(a<(s?3:2))return;"bevel"===i&&(n=1.05);const c=this.overscaling<=16?15*Uo/(512*this.overscaling):0,u=this.segments.prepareSegment(10*a,this.layoutVertexArray,this.indexArray);let h,d,p,f,m;this.e1=this.e2=-1,s&&(h=e[a-2],m=e[l].sub(h)._unit()._perp());for(let t=l;t<a;t++){if(p=t===a-1?s?e[l+1]:void 0:e[t+1],p&&e[t].equals(p))continue;m&&(f=m),h&&(d=h),h=e[t],m=p?p.sub(h)._unit()._perp():f,f=f||m;let _=f.add(m);0===_.x&&0===_.y||_._unit();const g=f.x*m.x+f.y*m.y,y=_.x*m.x+_.y*m.y,x=0!==y?1/y:1/0,v=2*Math.sqrt(2-2*y),b=y<eu&&d&&p,w=f.x*m.y-f.y*m.x>0;if(b&&t>l){const e=h.dist(d);if(e>2*c){const t=h.sub(h.sub(d)._mult(c/e)._round());this.updateDistance(d,t),this.addCurrentVertex(t,f,0,0,u),d=t}}const E=d&&p;let T=E?i:s?"butt":r;if(E&&"round"===T&&(x<o?T="miter":x<=2&&(T="fakeround")),"miter"===T&&x>n&&(T="bevel"),"bevel"===T&&(x>2&&(T="flipbevel"),x<n&&(T="miter")),d&&this.updateDistance(d,h),"miter"===T)_._mult(x),this.addCurrentVertex(h,_,0,0,u);else if("flipbevel"===T){if(x>100)_=m.mult(-1);else{const e=x*f.add(m).mag()/f.sub(m).mag();_._perp()._mult(e*(w?-1:1))}this.addCurrentVertex(h,_,0,0,u),this.addCurrentVertex(h,_.mult(-1),0,0,u)}else if("bevel"===T||"fakeround"===T){const e=-Math.sqrt(x*x-1),t=w?e:0,i=w?0:e;if(d&&this.addCurrentVertex(h,f,t,i,u),"fakeround"===T){const e=Math.round(180*v/Math.PI/20);for(let t=1;t<e;t++){let i=t/e;if(.5!==i){const e=i-.5;i+=i*e*(i-1)*((1.0904+g*(g*(3.55645-1.43519*g)-3.2452))*e*e+(.848013+g*(.215638*g-1.06021)))}const r=m.sub(f)._mult(i)._add(f)._unit()._mult(w?-1:1);this.addHalfVertex(h,r.x,r.y,!1,w,0,u)}}p&&this.addCurrentVertex(h,m,-t,-i,u)}else if("butt"===T)this.addCurrentVertex(h,_,0,0,u);else if("square"===T){const e=d?1:-1;d||this.addCurrentVertex(h,_,e,e,u),this.addCurrentVertex(h,_,0,0,u),d&&this.addCurrentVertex(h,_,e,e,u)}else"round"===T&&(d&&(this.addCurrentVertex(h,f,0,0,u),this.addCurrentVertex(h,f,1,1,u,!0)),p&&(this.addCurrentVertex(h,m,-1,-1,u,!0),this.addCurrentVertex(h,m,0,0,u)));if(b&&t<a-1){const e=h.dist(p);if(e>2*c){const t=h.add(p.sub(h)._mult(c/e)._round());this.updateDistance(h,t),this.addCurrentVertex(t,m,0,0,u),h=t}}}}addCurrentVertex(e,t,i,r,n,o=!1){const s=t.y*r-t.x,a=-t.y-t.x*r;this.addHalfVertex(e,t.x+t.y*i,t.y-t.x*i,o,!1,i,n),this.addHalfVertex(e,s,a,o,!0,-r,n)}addHalfVertex({x:e,y:t},i,r,n,o,s,a){this.layoutVertexArray.emplaceBack((e<<1)+(n?1:0),(t<<1)+(o?1:0),Math.round(63*i)+128,Math.round(63*r)+128,1+(0===s?0:s<0?-1:1),0,this.lineSoFar),this.lineClips&&this.layoutVertexArray2.emplaceBack(this.scaledDistance,this.lineClipsArray.length,this.lineClips.start,this.lineClips.end);const l=a.vertexLength++;this.e1>=0&&this.e2>=0&&(this.indexArray.emplaceBack(this.e1,this.e2,l),a.primitiveLength++),o?this.e2=l:this.e1=l}updateScaledDistance(){if(this.lineClips){const e=this.totalDistance/(this.lineClips.end-this.lineClips.start);this.scaledDistance=this.distance/this.totalDistance,this.lineSoFar=e*this.lineClips.start+this.distance}else this.lineSoFar=this.distance}updateDistance(e,t){this.distance+=e.dist(t),this.updateScaledDistance()}}jn(LineBucket,"LineBucket",{omit:["layers","patternFeatures"]});const tu=new Properties({"line-cap":new DataDrivenProperty(yt.layout_line["line-cap"]),"line-join":new DataDrivenProperty(yt.layout_line["line-join"]),"line-miter-limit":new DataConstantProperty(yt.layout_line["line-miter-limit"]),"line-round-limit":new DataConstantProperty(yt.layout_line["line-round-limit"]),"line-sort-key":new DataDrivenProperty(yt.layout_line["line-sort-key"])});var iu={paint:new Properties({"line-opacity":new DataDrivenProperty(yt.paint_line["line-opacity"]),"line-color":new DataDrivenProperty(yt.paint_line["line-color"]),"line-translate":new DataConstantProperty(yt.paint_line["line-translate"]),"line-translate-anchor":new DataConstantProperty(yt.paint_line["line-translate-anchor"]),"line-width":new DataDrivenProperty(yt.paint_line["line-width"]),"line-gap-width":new DataDrivenProperty(yt.paint_line["line-gap-width"]),"line-offset":new DataDrivenProperty(yt.paint_line["line-offset"]),"line-blur":new DataDrivenProperty(yt.paint_line["line-blur"]),"line-dasharray":new DataDrivenProperty(yt.paint_line["line-dasharray"]),"line-pattern":new DataDrivenProperty(yt.paint_line["line-pattern"]),"line-gradient":new ColorRampProperty(yt.paint_line["line-gradient"]),"line-trim-offset":new DataConstantProperty(yt.paint_line["line-trim-offset"])}),layout:tu};const ru=new class LineFloorwidthProperty extends DataDrivenProperty{possiblyEvaluate(e,t){return t=new EvaluationParameters(Math.floor(t.zoom),{now:t.now,fadeDuration:t.fadeDuration,transition:t.transition}),super.possiblyEvaluate(e,t)}evaluate(e,t,i,r){return t=L({},t,{zoom:Math.floor(t.zoom)}),super.evaluate(e,t,i,r)}}(iu.paint.properties["line-width"].specification);function nu(e,t){return t>0?t+2*e:e}ru.useIntegerZoom=!0;const ou=po([{name:"a_pos_offset",components:4,type:"Int16"},{name:"a_tex_size",components:4,type:"Uint16"},{name:"a_pixeloffset",components:4,type:"Int16"}],4),su=po([{name:"a_globe_anchor",components:3,type:"Int16"},{name:"a_globe_normal",components:3,type:"Float32"}],4),au=po([{name:"a_projected_pos",components:4,type:"Float32"}],4);po([{name:"a_fade_opacity",components:1,type:"Uint32"}],4);const lu=po([{name:"a_placed",components:2,type:"Uint8"},{name:"a_shift",components:2,type:"Float32"}]),cu=po([{name:"a_size_scale",components:1,type:"Float32"},{name:"a_padding",components:2,type:"Float32"}]);po([{type:"Int16",name:"projectedAnchorX"},{type:"Int16",name:"projectedAnchorY"},{type:"Int16",name:"projectedAnchorZ"},{type:"Int16",name:"tileAnchorX"},{type:"Int16",name:"tileAnchorY"},{type:"Float32",name:"x1"},{type:"Float32",name:"y1"},{type:"Float32",name:"x2"},{type:"Float32",name:"y2"},{type:"Int16",name:"padding"},{type:"Uint32",name:"featureIndex"},{type:"Uint16",name:"sourceLayerIndex"},{type:"Uint16",name:"bucketIndex"}]);const uu=po([{name:"a_pos",components:3,type:"Int16"},{name:"a_anchor_pos",components:2,type:"Int16"},{name:"a_extrude",components:2,type:"Int16"}],4),hu=po([{name:"a_pos_2f",components:2,type:"Float32"},{name:"a_radius",components:1,type:"Float32"},{name:"a_flags",components:2,type:"Int16"}],4);po([{name:"triangle",components:3,type:"Uint16"}]),po([{type:"Int16",name:"projectedAnchorX"},{type:"Int16",name:"projectedAnchorY"},{type:"Int16",name:"projectedAnchorZ"},{type:"Float32",name:"tileAnchorX"},{type:"Float32",name:"tileAnchorY"},{type:"Uint16",name:"glyphStartIndex"},{type:"Uint16",name:"numGlyphs"},{type:"Uint32",name:"vertexStartIndex"},{type:"Uint32",name:"lineStartIndex"},{type:"Uint32",name:"lineLength"},{type:"Uint16",name:"segment"},{type:"Uint16",name:"lowerSize"},{type:"Uint16",name:"upperSize"},{type:"Float32",name:"lineOffsetX"},{type:"Float32",name:"lineOffsetY"},{type:"Uint8",name:"writingMode"},{type:"Uint8",name:"placedOrientation"},{type:"Uint8",name:"hidden"},{type:"Uint32",name:"crossTileID"},{type:"Int16",name:"associatedIconIndex"},{type:"Uint8",name:"flipState"}]),po([{type:"Int16",name:"projectedAnchorX"},{type:"Int16",name:"projectedAnchorY"},{type:"Int16",name:"projectedAnchorZ"},{type:"Float32",name:"tileAnchorX"},{type:"Float32",name:"tileAnchorY"},{type:"Int16",name:"rightJustifiedTextSymbolIndex"},{type:"Int16",name:"centerJustifiedTextSymbolIndex"},{type:"Int16",name:"leftJustifiedTextSymbolIndex"},{type:"Int16",name:"verticalPlacedTextSymbolIndex"},{type:"Int16",name:"placedIconSymbolIndex"},{type:"Int16",name:"verticalPlacedIconSymbolIndex"},{type:"Uint16",name:"key"},{type:"Uint16",name:"textBoxStartIndex"},{type:"Uint16",name:"textBoxEndIndex"},{type:"Uint16",name:"verticalTextBoxStartIndex"},{type:"Uint16",name:"verticalTextBoxEndIndex"},{type:"Uint16",name:"iconBoxStartIndex"},{type:"Uint16",name:"iconBoxEndIndex"},{type:"Uint16",name:"verticalIconBoxStartIndex"},{type:"Uint16",name:"verticalIconBoxEndIndex"},{type:"Uint16",name:"featureIndex"},{type:"Uint16",name:"numHorizontalGlyphVertices"},{type:"Uint16",name:"numVerticalGlyphVertices"},{type:"Uint16",name:"numIconVertices"},{type:"Uint16",name:"numVerticalIconVertices"},{type:"Uint16",name:"useRuntimeCollisionCircles"},{type:"Uint32",name:"crossTileID"},{type:"Float32",components:2,name:"textOffset"},{type:"Float32",name:"collisionCircleDiameter"}]),po([{type:"Float32",name:"offsetX"}]),po([{type:"Int16",name:"x"},{type:"Int16",name:"y"}]);const du=128;function pu(e,t){const{expression:i}=t;if("constant"===i.kind)return{kind:"constant",layoutSize:i.evaluate(new EvaluationParameters(e+1))};if("source"===i.kind)return{kind:"source"};{const{zoomStops:t,interpolationType:r}=i;let n=0;for(;n<t.length&&t[n]<=e;)n++;n=Math.max(0,n-1);let o=n;for(;o<t.length&&t[o]<e+1;)o++;o=Math.min(t.length-1,o);const s=t[n],a=t[o];return"composite"===i.kind?{kind:"composite",minZoom:s,maxZoom:a,interpolationType:r}:{kind:"camera",minZoom:s,maxZoom:a,minSize:i.evaluate(new EvaluationParameters(s)),maxSize:i.evaluate(new EvaluationParameters(a)),interpolationType:r}}}function fu(e,{uSize:t,uSizeT:i},{lowerSize:r,upperSize:n}){return"source"===e.kind?r/du:"composite"===e.kind?zi(r/du,n/du,i):t}function mu(e,t){let i=0,r=0;if("constant"===e.kind)r=e.layoutSize;else if("source"!==e.kind){const{interpolationType:n,minZoom:o,maxZoom:s}=e,a=n?M(Qi.interpolationFactor(n,t,o,s),0,1):0;"camera"===e.kind?r=zi(e.minSize,e.maxSize,a):i=a}return{uSizeT:i,uSize:r}}var _u=Object.freeze({__proto__:null,SIZE_PACK_FACTOR:du,evaluateSizeForFeature:fu,evaluateSizeForZoom:mu,getSizeData:pu});function gu(e,t,i){return e.sections.forEach((e=>{e.text=function(e,t,i){const r=t.layout.get("text-transform").evaluate(i,{});return"uppercase"===r?e=e.toLocaleUpperCase():"lowercase"===r&&(e=e.toLocaleLowerCase()),e}(e.text,t,i)})),e}const yu={"!":"︕","#":"＃",$:"＄","%":"％","&":"＆","(":"︵",")":"︶","*":"＊","+":"＋",",":"︐","-":"︲",".":"・","/":"／",":":"︓",";":"︔","<":"︿","=":"＝",">":"﹀","?":"︖","@":"＠","[":"﹇","\\":"＼","]":"﹈","^":"＾",_:"︳","`":"｀","{":"︷","|":"―","}":"︸","~":"～","¢":"￠","£":"￡","¥":"￥","¦":"￤","¬":"￢","¯":"￣","–":"︲","—":"︱","‘":"﹃","’":"﹄","“":"﹁","”":"﹂","…":"︙","‧":"・","₩":"￦","、":"︑","。":"︒","〈":"︿","〉":"﹀","《":"︽","》":"︾","「":"﹁","」":"﹂","『":"﹃","』":"﹄","【":"︻","】":"︼","〔":"︹","〕":"︺","〖":"︗","〗":"︘","！":"︕","（":"︵","）":"︶","，":"︐","－":"︲","．":"・","：":"︓","；":"︔","＜":"︿","＞":"﹀","？":"︖","［":"﹇","］":"﹈","＿":"︳","｛":"︷","｜":"―","｝":"︸","｟":"︵","｠":"︶","｡":"︒","｢":"﹁","｣":"﹂","←":"↑","→":"↓"};var xu={
/*! ieee754. BSD-3-Clause License. Feross Aboukhadijeh <https://feross.org/opensource> */
read:function(e,t,i,r,n){var o,s,a=8*n-r-1,l=(1<<a)-1,c=l>>1,u=-7,h=i?n-1:0,d=i?-1:1,p=e[t+h];for(h+=d,o=p&(1<<-u)-1,p>>=-u,u+=a;u>0;o=256*o+e[t+h],h+=d,u-=8);for(s=o&(1<<-u)-1,o>>=-u,u+=r;u>0;s=256*s+e[t+h],h+=d,u-=8);if(0===o)o=1-c;else{if(o===l)return s?NaN:1/0*(p?-1:1);s+=Math.pow(2,r),o-=c}return(p?-1:1)*s*Math.pow(2,o-r)},write:function(e,t,i,r,n,o){var s,a,l,c=8*o-n-1,u=(1<<c)-1,h=u>>1,d=23===n?Math.pow(2,-24)-Math.pow(2,-77):0,p=r?0:o-1,f=r?1:-1,m=t<0||0===t&&1/t<0?1:0;for(t=Math.abs(t),isNaN(t)||t===1/0?(a=isNaN(t)?1:0,s=u):(s=Math.floor(Math.log(t)/Math.LN2),t*(l=Math.pow(2,-s))<1&&(s--,l*=2),(t+=s+h>=1?d/l:d*Math.pow(2,1-h))*l>=2&&(s++,l/=2),s+h>=u?(a=0,s=u):s+h>=1?(a=(t*l-1)*Math.pow(2,n),s+=h):(a=t*Math.pow(2,h-1)*Math.pow(2,n),s=0));n>=8;e[i+p]=255&a,p+=f,a/=256,n-=8);for(s=s<<n|a,c+=n;c>0;e[i+p]=255&s,p+=f,s/=256,c-=8);e[i+p-f]|=128*m}},vu=wu,bu=xu;function wu(e){this.buf=ArrayBuffer.isView&&ArrayBuffer.isView(e)?e:new Uint8Array(e||0),this.pos=0,this.type=0,this.length=this.buf.length}wu.Varint=0,wu.Fixed64=1,wu.Bytes=2,wu.Fixed32=5;var Eu=4294967296,Tu=1/Eu,Su="undefined"==typeof TextDecoder?null:new TextDecoder("utf8");function Au(e){return e.type===wu.Bytes?e.readVarint()+e.pos:e.pos+1}function Cu(e,t,i){return i?4294967296*t+(e>>>0):4294967296*(t>>>0)+(e>>>0)}function Iu(e,t,i){var r=t<=16383?1:t<=2097151?2:t<=268435455?3:Math.floor(Math.log(t)/(7*Math.LN2));i.realloc(r);for(var n=i.pos-1;n>=e;n--)i.buf[n+r]=i.buf[n]}function Mu(e,t){for(var i=0;i<e.length;i++)t.writeVarint(e[i])}function Pu(e,t){for(var i=0;i<e.length;i++)t.writeSVarint(e[i])}function Du(e,t){for(var i=0;i<e.length;i++)t.writeFloat(e[i])}function zu(e,t){for(var i=0;i<e.length;i++)t.writeDouble(e[i])}function ku(e,t){for(var i=0;i<e.length;i++)t.writeBoolean(e[i])}function Lu(e,t){for(var i=0;i<e.length;i++)t.writeFixed32(e[i])}function Bu(e,t){for(var i=0;i<e.length;i++)t.writeSFixed32(e[i])}function Ru(e,t){for(var i=0;i<e.length;i++)t.writeFixed64(e[i])}function Fu(e,t){for(var i=0;i<e.length;i++)t.writeSFixed64(e[i])}function Ou(e,t){return(e[t]|e[t+1]<<8|e[t+2]<<16)+16777216*e[t+3]}function Uu(e,t,i){e[i]=t,e[i+1]=t>>>8,e[i+2]=t>>>16,e[i+3]=t>>>24}function Vu(e,t){return(e[t]|e[t+1]<<8|e[t+2]<<16)+(e[t+3]<<24)}wu.prototype={destroy:function(){this.buf=null},readFields:function(e,t,i){for(i=i||this.length;this.pos<i;){var r=this.readVarint(),n=r>>3,o=this.pos;this.type=7&r,e(n,t,this),this.pos===o&&this.skip(r)}return t},readMessage:function(e,t){return this.readFields(e,t,this.readVarint()+this.pos)},readFixed32:function(){var e=Ou(this.buf,this.pos);return this.pos+=4,e},readSFixed32:function(){var e=Vu(this.buf,this.pos);return this.pos+=4,e},readFixed64:function(){var e=Ou(this.buf,this.pos)+Ou(this.buf,this.pos+4)*Eu;return this.pos+=8,e},readSFixed64:function(){var e=Ou(this.buf,this.pos)+Vu(this.buf,this.pos+4)*Eu;return this.pos+=8,e},readFloat:function(){var e=bu.read(this.buf,this.pos,!0,23,4);return this.pos+=4,e},readDouble:function(){var e=bu.read(this.buf,this.pos,!0,52,8);return this.pos+=8,e},readVarint:function(e){var t,i,r=this.buf;return t=127&(i=r[this.pos++]),i<128?t:(t|=(127&(i=r[this.pos++]))<<7,i<128?t:(t|=(127&(i=r[this.pos++]))<<14,i<128?t:(t|=(127&(i=r[this.pos++]))<<21,i<128?t:function(e,t,i){var r,n,o=i.buf;if(r=(112&(n=o[i.pos++]))>>4,n<128)return Cu(e,r,t);if(r|=(127&(n=o[i.pos++]))<<3,n<128)return Cu(e,r,t);if(r|=(127&(n=o[i.pos++]))<<10,n<128)return Cu(e,r,t);if(r|=(127&(n=o[i.pos++]))<<17,n<128)return Cu(e,r,t);if(r|=(127&(n=o[i.pos++]))<<24,n<128)return Cu(e,r,t);if(r|=(1&(n=o[i.pos++]))<<31,n<128)return Cu(e,r,t);throw new Error("Expected varint not more than 10 bytes")}(t|=(15&(i=r[this.pos]))<<28,e,this))))},readVarint64:function(){return this.readVarint(!0)},readSVarint:function(){var e=this.readVarint();return e%2==1?(e+1)/-2:e/2},readBoolean:function(){return Boolean(this.readVarint())},readString:function(){var e=this.readVarint()+this.pos,t=this.pos;return this.pos=e,e-t>=12&&Su?function(e,t,i){return Su.decode(e.subarray(t,i))}(this.buf,t,e):function(e,t,i){for(var r="",n=t;n<i;){var o,s,a,l=e[n],c=null,u=l>239?4:l>223?3:l>191?2:1;if(n+u>i)break;1===u?l<128&&(c=l):2===u?128==(192&(o=e[n+1]))&&(c=(31&l)<<6|63&o)<=127&&(c=null):3===u?(s=e[n+2],128==(192&(o=e[n+1]))&&128==(192&s)&&((c=(15&l)<<12|(63&o)<<6|63&s)<=2047||c>=55296&&c<=57343)&&(c=null)):4===u&&(s=e[n+2],a=e[n+3],128==(192&(o=e[n+1]))&&128==(192&s)&&128==(192&a)&&((c=(15&l)<<18|(63&o)<<12|(63&s)<<6|63&a)<=65535||c>=1114112)&&(c=null)),null===c?(c=65533,u=1):c>65535&&(c-=65536,r+=String.fromCharCode(c>>>10&1023|55296),c=56320|1023&c),r+=String.fromCharCode(c),n+=u}return r}(this.buf,t,e)},readBytes:function(){var e=this.readVarint()+this.pos,t=this.buf.subarray(this.pos,e);return this.pos=e,t},readPackedVarint:function(e,t){if(this.type!==wu.Bytes)return e.push(this.readVarint(t));var i=Au(this);for(e=e||[];this.pos<i;)e.push(this.readVarint(t));return e},readPackedSVarint:function(e){if(this.type!==wu.Bytes)return e.push(this.readSVarint());var t=Au(this);for(e=e||[];this.pos<t;)e.push(this.readSVarint());return e},readPackedBoolean:function(e){if(this.type!==wu.Bytes)return e.push(this.readBoolean());var t=Au(this);for(e=e||[];this.pos<t;)e.push(this.readBoolean());return e},readPackedFloat:function(e){if(this.type!==wu.Bytes)return e.push(this.readFloat());var t=Au(this);for(e=e||[];this.pos<t;)e.push(this.readFloat());return e},readPackedDouble:function(e){if(this.type!==wu.Bytes)return e.push(this.readDouble());var t=Au(this);for(e=e||[];this.pos<t;)e.push(this.readDouble());return e},readPackedFixed32:function(e){if(this.type!==wu.Bytes)return e.push(this.readFixed32());var t=Au(this);for(e=e||[];this.pos<t;)e.push(this.readFixed32());return e},readPackedSFixed32:function(e){if(this.type!==wu.Bytes)return e.push(this.readSFixed32());var t=Au(this);for(e=e||[];this.pos<t;)e.push(this.readSFixed32());return e},readPackedFixed64:function(e){if(this.type!==wu.Bytes)return e.push(this.readFixed64());var t=Au(this);for(e=e||[];this.pos<t;)e.push(this.readFixed64());return e},readPackedSFixed64:function(e){if(this.type!==wu.Bytes)return e.push(this.readSFixed64());var t=Au(this);for(e=e||[];this.pos<t;)e.push(this.readSFixed64());return e},skip:function(e){var t=7&e;if(t===wu.Varint)for(;this.buf[this.pos++]>127;);else if(t===wu.Bytes)this.pos=this.readVarint()+this.pos;else if(t===wu.Fixed32)this.pos+=4;else{if(t!==wu.Fixed64)throw new Error("Unimplemented type: "+t);this.pos+=8}},writeTag:function(e,t){this.writeVarint(e<<3|t)},realloc:function(e){for(var t=this.length||16;t<this.pos+e;)t*=2;if(t!==this.length){var i=new Uint8Array(t);i.set(this.buf),this.buf=i,this.length=t}},finish:function(){return this.length=this.pos,this.pos=0,this.buf.subarray(0,this.length)},writeFixed32:function(e){this.realloc(4),Uu(this.buf,e,this.pos),this.pos+=4},writeSFixed32:function(e){this.realloc(4),Uu(this.buf,e,this.pos),this.pos+=4},writeFixed64:function(e){this.realloc(8),Uu(this.buf,-1&e,this.pos),Uu(this.buf,Math.floor(e*Tu),this.pos+4),this.pos+=8},writeSFixed64:function(e){this.realloc(8),Uu(this.buf,-1&e,this.pos),Uu(this.buf,Math.floor(e*Tu),this.pos+4),this.pos+=8},writeVarint:function(e){(e=+e||0)>268435455||e<0?function(e,t){var i,r;if(e>=0?(i=e%4294967296|0,r=e/4294967296|0):(r=~(-e/4294967296),4294967295^(i=~(-e%4294967296))?i=i+1|0:(i=0,r=r+1|0)),e>=0x10000000000000000||e<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");t.realloc(10),function(e,t,i){i.buf[i.pos++]=127&e|128,e>>>=7,i.buf[i.pos++]=127&e|128,e>>>=7,i.buf[i.pos++]=127&e|128,e>>>=7,i.buf[i.pos++]=127&e|128,i.buf[i.pos]=127&(e>>>=7)}(i,0,t),function(e,t){var i=(7&e)<<4;t.buf[t.pos++]|=i|((e>>>=3)?128:0),e&&(t.buf[t.pos++]=127&e|((e>>>=7)?128:0),e&&(t.buf[t.pos++]=127&e|((e>>>=7)?128:0),e&&(t.buf[t.pos++]=127&e|((e>>>=7)?128:0),e&&(t.buf[t.pos++]=127&e|((e>>>=7)?128:0),e&&(t.buf[t.pos++]=127&e)))))}(r,t)}(e,this):(this.realloc(4),this.buf[this.pos++]=127&e|(e>127?128:0),e<=127||(this.buf[this.pos++]=127&(e>>>=7)|(e>127?128:0),e<=127||(this.buf[this.pos++]=127&(e>>>=7)|(e>127?128:0),e<=127||(this.buf[this.pos++]=e>>>7&127))))},writeSVarint:function(e){this.writeVarint(e<0?2*-e-1:2*e)},writeBoolean:function(e){this.writeVarint(Boolean(e))},writeString:function(e){e=String(e),this.realloc(4*e.length),this.pos++;var t=this.pos;this.pos=function(e,t,i){for(var r,n,o=0;o<t.length;o++){if((r=t.charCodeAt(o))>55295&&r<57344){if(!n){r>56319||o+1===t.length?(e[i++]=239,e[i++]=191,e[i++]=189):n=r;continue}if(r<56320){e[i++]=239,e[i++]=191,e[i++]=189,n=r;continue}r=n-55296<<10|r-56320|65536,n=null}else n&&(e[i++]=239,e[i++]=191,e[i++]=189,n=null);r<128?e[i++]=r:(r<2048?e[i++]=r>>6|192:(r<65536?e[i++]=r>>12|224:(e[i++]=r>>18|240,e[i++]=r>>12&63|128),e[i++]=r>>6&63|128),e[i++]=63&r|128)}return i}(this.buf,e,this.pos);var i=this.pos-t;i>=128&&Iu(t,i,this),this.pos=t-1,this.writeVarint(i),this.pos+=i},writeFloat:function(e){this.realloc(4),bu.write(this.buf,e,this.pos,!0,23,4),this.pos+=4},writeDouble:function(e){this.realloc(8),bu.write(this.buf,e,this.pos,!0,52,8),this.pos+=8},writeBytes:function(e){var t=e.length;this.writeVarint(t),this.realloc(t);for(var i=0;i<t;i++)this.buf[this.pos++]=e[i]},writeRawMessage:function(e,t){this.pos++;var i=this.pos;e(t,this);var r=this.pos-i;r>=128&&Iu(i,r,this),this.pos=i-1,this.writeVarint(r),this.pos+=r},writeMessage:function(e,t,i){this.writeTag(e,wu.Bytes),this.writeRawMessage(t,i)},writePackedVarint:function(e,t){t.length&&this.writeMessage(e,Mu,t)},writePackedSVarint:function(e,t){t.length&&this.writeMessage(e,Pu,t)},writePackedBoolean:function(e,t){t.length&&this.writeMessage(e,ku,t)},writePackedFloat:function(e,t){t.length&&this.writeMessage(e,Du,t)},writePackedDouble:function(e,t){t.length&&this.writeMessage(e,zu,t)},writePackedFixed32:function(e,t){t.length&&this.writeMessage(e,Lu,t)},writePackedSFixed32:function(e,t){t.length&&this.writeMessage(e,Bu,t)},writePackedFixed64:function(e,t){t.length&&this.writeMessage(e,Ru,t)},writePackedSFixed64:function(e,t){t.length&&this.writeMessage(e,Fu,t)},writeBytesField:function(e,t){this.writeTag(e,wu.Bytes),this.writeBytes(t)},writeFixed32Field:function(e,t){this.writeTag(e,wu.Fixed32),this.writeFixed32(t)},writeSFixed32Field:function(e,t){this.writeTag(e,wu.Fixed32),this.writeSFixed32(t)},writeFixed64Field:function(e,t){this.writeTag(e,wu.Fixed64),this.writeFixed64(t)},writeSFixed64Field:function(e,t){this.writeTag(e,wu.Fixed64),this.writeSFixed64(t)},writeVarintField:function(e,t){this.writeTag(e,wu.Varint),this.writeVarint(t)},writeSVarintField:function(e,t){this.writeTag(e,wu.Varint),this.writeSVarint(t)},writeStringField:function(e,t){this.writeTag(e,wu.Bytes),this.writeString(t)},writeFloatField:function(e,t){this.writeTag(e,wu.Fixed32),this.writeFloat(t)},writeDoubleField:function(e,t){this.writeTag(e,wu.Fixed64),this.writeDouble(t)},writeBooleanField:function(e,t){this.writeVarintField(e,Boolean(t))}};var ju=h(vu);const Nu=3;function Gu(e,t,i){t.glyphs=[],1===e&&i.readMessage(qu,t)}function qu(e,t,i){if(3===e){const{id:e,bitmap:r,width:n,height:o,left:s,top:a,advance:l}=i.readMessage(Zu,{});t.glyphs.push({id:e,bitmap:new AlphaImage({width:n+2*Nu,height:o+2*Nu},r),metrics:{width:n,height:o,left:s,top:a,advance:l}})}else 4===e?t.ascender=i.readSVarint():5===e&&(t.descender=i.readSVarint())}function Zu(e,t,i){1===e?t.id=i.readVarint():2===e?t.bitmap=i.readBytes():3===e?t.width=i.readVarint():4===e?t.height=i.readVarint():5===e?t.left=i.readSVarint():6===e?t.top=i.readSVarint():7===e&&(t.advance=i.readVarint())}function $u(e){let t=0,i=0;for(const r of e)t+=r.w*r.h,i=Math.max(i,r.w);e.sort(((e,t)=>t.h-e.h));const r=[{x:0,y:0,w:Math.max(Math.ceil(Math.sqrt(t/.95)),i),h:1/0}];let n=0,o=0;for(const t of e)for(let e=r.length-1;e>=0;e--){const i=r[e];if(!(t.w>i.w||t.h>i.h)){if(t.x=i.x,t.y=i.y,o=Math.max(o,t.y+t.h),n=Math.max(n,t.x+t.w),t.w===i.w&&t.h===i.h){const t=r.pop();e<r.length&&(r[e]=t)}else t.h===i.h?(i.x+=t.w,i.w-=t.w):t.w===i.w?(i.y+=t.h,i.h-=t.h):(r.push({x:i.x+t.w,y:i.y,w:i.w-t.w,h:t.h}),i.y+=t.h,i.h-=t.h);break}}return{w:n,h:o,fill:t/(n*o)||0}}class ImagePosition{constructor(e,{pixelRatio:t,version:i,stretchX:r,stretchY:n,content:o}){this.paddedRect=e,this.pixelRatio=t,this.stretchX=r,this.stretchY=n,this.content=o,this.version=i}get tl(){return[this.paddedRect.x+1,this.paddedRect.y+1]}get br(){return[this.paddedRect.x+this.paddedRect.w-1,this.paddedRect.y+this.paddedRect.h-1]}get displaySize(){return[(this.paddedRect.w-2)/this.pixelRatio,(this.paddedRect.h-2)/this.pixelRatio]}}jn(ImagePosition,"ImagePosition"),jn(class ImageAtlas{constructor(e,t){const i={},r={};this.haveRenderCallbacks=[];const n=[];this.addImages(e,i,n),this.addImages(t,r,n);const{w:o,h:s}=$u(n),a=new RGBAImage({width:o||1,height:s||1});for(const t in e){const r=e[t],n=i[t].paddedRect;RGBAImage.copy(r.data,a,{x:0,y:0},{x:n.x+1,y:n.y+1},r.data)}for(const e in t){const i=t[e],n=r[e].paddedRect,o=n.x+1,s=n.y+1,l=i.data.width,c=i.data.height;RGBAImage.copy(i.data,a,{x:0,y:0},{x:o,y:s},i.data),RGBAImage.copy(i.data,a,{x:0,y:c-1},{x:o,y:s-1},{width:l,height:1}),RGBAImage.copy(i.data,a,{x:0,y:0},{x:o,y:s+c},{width:l,height:1}),RGBAImage.copy(i.data,a,{x:l-1,y:0},{x:o-1,y:s},{width:1,height:c}),RGBAImage.copy(i.data,a,{x:0,y:0},{x:o+l,y:s},{width:1,height:c})}this.image=a,this.iconPositions=i,this.patternPositions=r}addImages(e,t,i){for(const r in e){const n=e[r],o={x:0,y:0,w:n.data.width+2,h:n.data.height+2};i.push(o),t[r]=new ImagePosition(o,n),n.hasRenderCallback&&this.haveRenderCallbacks.push(r)}}patchUpdatedImages(e,t){this.haveRenderCallbacks=this.haveRenderCallbacks.filter((t=>e.hasImage(t))),e.dispatchRenderCallbacks(this.haveRenderCallbacks);for(const i in e.updatedImages)this.patchUpdatedImage(this.iconPositions[i],e.getImage(i),t),this.patchUpdatedImage(this.patternPositions[i],e.getImage(i),t)}patchUpdatedImage(e,t,i){if(!e||!t)return;if(e.version===t.version)return;e.version=t.version;const[r,n]=e.tl;i.update(t.data,void 0,{x:r,y:n})}},"ImageAtlas");const Wu={horizontal:1,vertical:2,horizontalOnly:3};function Hu(e){let t=.5,i=.5;switch(e){case"right":case"top-right":case"bottom-right":t=1;break;case"left":case"top-left":case"bottom-left":t=0}switch(e){case"bottom":case"bottom-right":case"bottom-left":i=1;break;case"top":case"top-right":case"top-left":i=0}return{horizontalAlign:t,verticalAlign:i}}class Anchor extends g{constructor(e,t,i,r,n){super(e,t),this.angle=r,this.z=i,void 0!==n&&(this.segment=n)}clone(){return new Anchor(this.x,this.y,this.z,this.angle,this.segment)}}jn(Anchor,"Anchor");const Xu=1e20;function Ku(e,t,i,r,n,o,s,a,l){for(let c=t;c<t+r;c++)Ju(e,i*o+c,o,n,s,a,l);for(let c=i;c<i+n;c++)Ju(e,c*o+t,1,r,s,a,l)}function Ju(e,t,i,r,n,o,s){o[0]=0,s[0]=-Xu,s[1]=Xu,n[0]=e[t];for(let a=1,l=0,c=0;a<r;a++){n[a]=e[t+a*i];const r=a*a;do{const e=o[l];c=(n[a]-n[e]+r-e*e)/(a-e)/2}while(c<=s[l]&&--l>-1);l++,o[l]=a,s[l]=c,s[l+1]=Xu}for(let a=0,l=0;a<r;a++){for(;s[l+1]<a;)l++;const r=o[l],c=a-r;e[t+a*i]=n[r]+c*c}}class GlyphManager{constructor(e,t,i){this.requestManager=e,this.localGlyphMode=t,this.localFontFamily=i,this.entries={},this.localGlyphs={200:{},400:{},500:{},900:{}}}setURL(e){this.url=e}getGlyphs(e,t){const i=[];for(const t in e)for(const r of e[t])i.push({stack:t,id:r});z(i,(({stack:e,id:t},i)=>{let r=this.entries[e];r||(r=this.entries[e]={glyphs:{},requests:{},ranges:{},ascender:void 0,descender:void 0});let n=r.glyphs[t];if(void 0!==n)return void i(null,{stack:e,id:t,glyph:n});if(n=this._tinySDF(r,e,t),n)return r.glyphs[t]=n,void i(null,{stack:e,id:t,glyph:n});const o=Math.floor(t/256);if(256*o>65535)return void i(new Error("glyphs > 65535 not supported"));if(r.ranges[o])return void i(null,{stack:e,id:t,glyph:n});let s=r.requests[o];s||(s=r.requests[o]=[],GlyphManager.loadGlyphRange(e,o,this.url,this.requestManager,((e,t)=>{if(t){r.ascender=t.ascender,r.descender=t.descender;for(const e in t.glyphs)this._doesCharSupportLocalGlyph(+e)||(r.glyphs[+e]=t.glyphs[+e]);r.ranges[o]=!0}for(const i of s)i(e,t);delete r.requests[o]}))),s.push(((r,n)=>{r?i(r):n&&i(null,{stack:e,id:t,glyph:n.glyphs[t]||null})}))}),((e,i)=>{if(e)t(e);else if(i){const e={};for(const{stack:t,id:r,glyph:n}of i)void 0===e[t]&&(e[t]={}),void 0===e[t].glyphs&&(e[t].glyphs={}),e[t].glyphs[r]=n&&{id:n.id,bitmap:n.bitmap.clone(),metrics:n.metrics},e[t].ascender=this.entries[t].ascender,e[t].descender=this.entries[t].descender;t(null,e)}}))}_doesCharSupportLocalGlyph(e){return 0!==this.localGlyphMode&&(2===this.localGlyphMode?!!this.localFontFamily:!!this.localFontFamily&&($n["CJK Unified Ideographs"](e)||$n["Hangul Syllables"](e)||$n.Hiragana(e)||$n.Katakana(e)||$n["CJK Symbols and Punctuation"](e)))}_tinySDF(e,t,i){const r=this.localFontFamily;if(!r||!this._doesCharSupportLocalGlyph(i))return;let n=e.tinySDF;if(!n){let i="400";/bold/i.test(t)?i="900":/medium/i.test(t)?i="500":/light/i.test(t)&&(i="200"),n=e.tinySDF=new GlyphManager.TinySDF({fontFamily:r,fontWeight:i,fontSize:48,buffer:6,radius:16}),n.fontWeight=i}if(this.localGlyphs[n.fontWeight][i])return this.localGlyphs[n.fontWeight][i];const o=String.fromCharCode(i),{data:s,width:a,height:l,glyphWidth:c,glyphHeight:u,glyphLeft:h,glyphTop:d,glyphAdvance:p}=n.draw(o);return this.localGlyphs[n.fontWeight][i]={id:i,bitmap:new AlphaImage({width:a,height:l},s),metrics:{width:c/2,height:u/2,left:h/2,top:d/2-27,advance:p/2,localGlyph:!0}}}}GlyphManager.loadGlyphRange=function(e,t,i,r,n){const o=256*t,s=o+255,a=r.transformRequest(r.normalizeGlyphsURL(i).replace("{fontstack}",e).replace("{range}",`${o}-${s}`),me.Glyphs);xe(a,((e,t)=>{if(e)n(e);else if(t){const e={},i=function(e){return new ju(e).readFields(Gu,{})}(t);for(const t of i.glyphs)e[t.id]=t;n(null,{glyphs:e,ascender:i.ascender,descender:i.descender})}}))},GlyphManager.TinySDF=class TinySDF{constructor({fontSize:e=24,buffer:t=3,radius:i=8,cutoff:r=.25,fontFamily:n="sans-serif",fontWeight:o="normal",fontStyle:s="normal"}={}){this.buffer=t,this.cutoff=r,this.radius=i;const a=this.size=e+4*t,l=this._createCanvas(a),c=this.ctx=l.getContext("2d",{willReadFrequently:!0});c.font=`${s} ${o} ${e}px ${n}`,c.textBaseline="alphabetic",c.textAlign="left",c.fillStyle="black",this.gridOuter=new Float64Array(a*a),this.gridInner=new Float64Array(a*a),this.f=new Float64Array(a),this.z=new Float64Array(a+1),this.v=new Uint16Array(a)}_createCanvas(e){const t=document.createElement("canvas");return t.width=t.height=e,t}draw(e){const{width:t,actualBoundingBoxAscent:i,actualBoundingBoxDescent:r,actualBoundingBoxLeft:n,actualBoundingBoxRight:o}=this.ctx.measureText(e),s=Math.ceil(i),a=Math.max(0,Math.min(this.size-this.buffer,Math.ceil(o-n))),l=Math.min(this.size-this.buffer,s+Math.ceil(r)),c=a+2*this.buffer,u=l+2*this.buffer,h=Math.max(c*u,0),d=new Uint8ClampedArray(h),p={data:d,width:c,height:u,glyphWidth:a,glyphHeight:l,glyphTop:s,glyphLeft:0,glyphAdvance:t};if(0===a||0===l)return p;const{ctx:f,buffer:m,gridInner:_,gridOuter:g}=this;f.clearRect(m,m,a,l),f.fillText(e,m,m+s);const y=f.getImageData(m,m,a,l);g.fill(Xu,0,h),_.fill(0,0,h);for(let e=0;e<l;e++)for(let t=0;t<a;t++){const i=y.data[4*(e*a+t)+3]/255;if(0===i)continue;const r=(e+m)*c+t+m;if(1===i)g[r]=0,_[r]=Xu;else{const e=.5-i;g[r]=e>0?e*e:0,_[r]=e<0?e*e:0}}Ku(g,0,0,c,u,c,this.f,this.v,this.z),Ku(_,m,m,a,l,c,this.f,this.v,this.z);for(let e=0;e<h;e++){const t=Math.sqrt(g[e])-Math.sqrt(_[e]);d[e]=Math.round(255-255*(t/this.radius+this.cutoff))}return p}};const Yu=7,Qu=Number.POSITIVE_INFINITY,eh=Math.sqrt(2);function th(e,[t,i]){let r=0,n=0;if(i===Qu){t<0&&(t=0);const i=t/eh;switch(e){case"top-right":case"top-left":n=i-Yu;break;case"bottom-right":case"bottom-left":n=-i+Yu;break;case"bottom":n=-t+Yu;break;case"top":n=t-Yu}switch(e){case"top-right":case"bottom-right":r=-i;break;case"top-left":case"bottom-left":r=i;break;case"left":r=t;break;case"right":r=-t}}else{switch(t=Math.abs(t),i=Math.abs(i),e){case"top-right":case"top-left":case"top":n=i-Yu;break;case"bottom-right":case"bottom-left":case"bottom":n=-i+Yu}switch(e){case"top-right":case"bottom-right":case"right":r=-t;break;case"top-left":case"bottom-left":case"left":r=t}}return[r,n]}const ih=255*du;function rh(e,t){const i=e.fovAboveCenter,r=e.elevation?e.elevation.getMinElevationBelowMSL()*t:0,n=(e._camera.position[2]*e.worldSize-r)/Math.cos(e._pitch),o=Math.sin(i)*n/Math.sin(Math.max(Math.PI/2-e._pitch-i,.01)),s=Math.sin(e._pitch)*o+n;return Math.min(1.01*s,n*(1/e._horizonShift))}function nh(e,t){if(!t.isReprojectedInTileSpace)return{scale:1<<e.z,x:e.x,y:e.y,x2:e.x+1,y2:e.y+1,projection:t};const i=Math.pow(2,-e.z),r=e.x*i,n=(e.x+1)*i,o=e.y*i,s=(e.y+1)*i,a=Ba(r),l=Ba(n),c=Ra(o),u=Ra(s),h=t.project(a,c),d=t.project(l,c),p=t.project(l,u),f=t.project(a,u);let m=Math.min(h.x,d.x,p.x,f.x),_=Math.min(h.y,d.y,p.y,f.y),g=Math.max(h.x,d.x,p.x,f.x),y=Math.max(h.y,d.y,p.y,f.y);const x=i/16;function v(e,i,r,n,o,s){const a=(r+o)/2,l=(n+s)/2,c=t.project(Ba(a),Ra(l)),u=Math.max(0,m-c.x,_-c.y,c.x-g,c.y-y);m=Math.min(m,c.x),g=Math.max(g,c.x),_=Math.min(_,c.y),y=Math.max(y,c.y),u>x&&(v(e,c,r,n,a,l),v(c,i,a,l,o,s))}v(h,d,r,o,n,o),v(d,p,n,o,n,s),v(p,f,n,s,r,s),v(f,h,r,s,r,o),m-=x,_-=x,g+=x,y+=x;const b=1/Math.max(g-m,y-_);return{scale:b,x:m*b,y:_*b,x2:g*b,y2:y*b,projection:t}}function oh(e,t,i,r,n,o,s,a,l){if("globe"===l.name)return oa(e,t,new CanonicalTileID(i,r,n));const c=nh({z:i,x:r,y:n},l);return new Aabb([(o+c.x/c.scale)*t,t*(c.y/c.scale),s],[(o+c.x2/c.scale)*t,t*(c.y2/c.scale),a])}function sh(e,{x:t,y:i},r=0){return new g(((t-r)*e.scale-e.x)*Uo,(i*e.scale-e.y)*Uo)}function ah(e,t,i=0){return us(((t.x-i)*e.scale-e.x)*Uo,(t.y*e.scale-e.y)*Uo,Fa(t.z,t.y))}const lh=Wo(new Float32Array(16));class Projection{constructor(e){this.spec=e,this.name=e.name,this.wrap=!1,this.requiresDraping=!1,this.supportsWorldCopies=!1,this.supportsTerrain=!1,this.supportsFog=!1,this.supportsFreeCamera=!1,this.zAxisUnit="meters",this.isReprojectedInTileSpace=!0,this.unsupportedLayers=["custom"],this.center=[0,0],this.range=[3.5,7]}project(e,t){return{x:0,y:0,z:0}}unproject(e,t){return new Pa(0,0)}projectTilePoint(e,t,i){return{x:e,y:t,z:0}}locationPoint(e,t,i=!0){return e._coordinatePoint(e.locationCoordinate(t),i)}pixelsPerMeter(e,t){return La(1,e)*t}pixelSpaceConversion(e,t,i){return 1}farthestPixelDistance(e){return rh(e,e.pixelsPerMeter)}pointCoordinate(e,t,i,r){const n=e.horizonLineFromTop(!1),o=new g(t,Math.max(n,i));return e.rayIntersectionCoordinate(e.pointRayIntersection(o,r))}pointCoordinate3D(e,t,i){const r=new g(t,i);if(e.elevation)return e.elevation.pointCoordinate(r);{const t=this.pointCoordinate(e,r.x,r.y,0);return[t.x,t.y,t.z]}}isPointAboveHorizon(e,t){if(e.elevation)return!this.pointCoordinate3D(e,t.x,t.y);const i=e.horizonLineFromTop();return t.y<i}createInversionMatrix(e,t){return lh}createTileMatrix(e,t,i){let r,n,o;const s=i.canonical,a=Wo(new Float64Array(16));if(this.isReprojectedInTileSpace){const l=nh(s,this);r=1,n=l.x+i.wrap*l.scale,o=l.y,Jo(a,a,[r/l.scale,r/l.scale,e.pixelsPerMeter/t])}else r=t/e.zoomScale(s.z),n=(s.x+Math.pow(2,s.z)*i.wrap)*r,o=s.y*r;return Ko(a,a,[n,o,0]),Jo(a,a,[r/Uo,r/Uo,1]),a}upVector(e,t,i){return[0,0,1]}upVectorScale(e,t,i){return{metersToTile:1}}}class Albers extends Projection{constructor(e){super(e),this.range=[4,7],this.center=e.center||[-96,37.5];const[t,i]=this.parallels=e.parallels||[29.5,45.5],r=Math.sin(b(t));this.n=(r+Math.sin(b(i)))/2,this.c=1+r*(2*this.n-r),this.r0=Math.sqrt(this.c)/this.n}project(e,t){const{n:i,c:r,r0:n}=this,o=b(e-this.center[0]),s=b(t),a=Math.sqrt(r-2*i*Math.sin(s))/i;return{x:a*Math.sin(o*i),y:a*Math.cos(o*i)-n,z:0}}unproject(e,t){const{n:i,c:r,r0:n}=this,o=n+t;let s=Math.atan2(e,Math.abs(o))*Math.sign(o);o*i<0&&(s-=Math.PI*Math.sign(e)*Math.sign(o));const a=b(this.center[0])*i;s=D(s,-Math.PI-a,Math.PI-a);const l=M(w(s/i)+this.center[0],-180,180),c=Math.asin(M((r-(e*e+o*o)*i*i)/(2*i),-1,1)),u=M(w(c),-Oa,Oa);return new Pa(l,u)}}const ch=1.340264,uh=-.081106,hh=893e-6,dh=.003796,ph=Math.sqrt(3)/2;class EqualEarth extends Projection{project(e,t){t=t/180*Math.PI,e=e/180*Math.PI;const i=Math.asin(ph*Math.sin(t)),r=i*i,n=r*r*r;return{x:.5*(e*Math.cos(i)/(ph*(ch+3*uh*r+n*(7*hh+9*dh*r)))/Math.PI+.5),y:1-.5*(i*(ch+uh*r+n*(hh+dh*r))/Math.PI+1),z:0}}unproject(e,t){e=(2*e-.5)*Math.PI;let i=t=(2*(1-t)-1)*Math.PI,r=i*i,n=r*r*r;for(let e,o,s,a=0;a<12&&(o=i*(ch+uh*r+n*(hh+dh*r))-t,s=ch+3*uh*r+n*(7*hh+9*dh*r),e=o/s,i=M(i-e,-Math.PI/3,Math.PI/3),r=i*i,n=r*r*r,!(Math.abs(e)<1e-12));++a);const o=ph*e*(ch+3*uh*r+n*(7*hh+9*dh*r))/Math.cos(i),s=Math.asin(Math.sin(i)/ph),a=M(180*o/Math.PI,-180,180),l=M(180*s/Math.PI,-Oa,Oa);return new Pa(a,l)}}class Equirectangular extends Projection{constructor(e){super(e),this.wrap=!0,this.supportsWorldCopies=!0}project(e,t){return{x:.5+e/360,y:.5-t/360,z:0}}unproject(e,t){const i=360*(e-.5),r=M(360*(.5-t),-Oa,Oa);return new Pa(i,r)}}const fh=Math.PI/2;function mh(e){return Math.tan((fh+e)/2)}class LambertConformalConic extends Projection{constructor(e){super(e),this.center=e.center||[0,30];const[t,i]=this.parallels=e.parallels||[30,30];let r=b(t),n=b(i);this.southernCenter=r+n<0,this.southernCenter&&(r=-r,n=-n);const o=Math.cos(r),s=mh(r);this.n=r===n?Math.sin(r):Math.log(o/Math.cos(n))/Math.log(mh(n)/s),this.f=o*Math.pow(mh(r),this.n)/this.n}project(e,t){t=b(t),this.southernCenter&&(t=-t),e=b(e-this.center[0]);const i=1e-6,{n:r,f:n}=this;n>0?t<-fh+i&&(t=-fh+i):t>fh-i&&(t=fh-i);const o=n/Math.pow(mh(t),r);let s=o*Math.sin(r*e),a=n-o*Math.cos(r*e);return s=.5*(s/Math.PI+.5),a=.5*(a/Math.PI+.5),{x:s,y:this.southernCenter?a:1-a,z:0}}unproject(e,t){e=(2*e-.5)*Math.PI,this.southernCenter&&(t=1-t),t=(2*(1-t)-.5)*Math.PI;const{n:i,f:r}=this,n=r-t,o=Math.sign(n),s=Math.sign(i)*Math.sqrt(e*e+n*n);let a=Math.atan2(e,Math.abs(n))*o;n*i<0&&(a-=Math.PI*Math.sign(e)*o);const l=M(w(a/i)+this.center[0],-180,180),c=M(w(2*Math.atan(Math.pow(r/s,1/i))-fh),-Oa,Oa);return new Pa(l,this.southernCenter?-c:c)}}class Mercator extends Projection{constructor(e){super(e),this.wrap=!0,this.supportsWorldCopies=!0,this.supportsTerrain=!0,this.supportsFog=!0,this.supportsFreeCamera=!0,this.isReprojectedInTileSpace=!1,this.unsupportedLayers=[],this.range=null}project(e,t){return{x:za(e),y:ka(t),z:0}}unproject(e,t){const i=Ba(e),r=Ra(t);return new Pa(i,r)}}const _h=b(Oa);class NaturalEarth extends Projection{project(e,t){const i=(t=b(t))*t,r=i*i;return{x:.5*((e=b(e))*(.8707-.131979*i+r*(r*(.003971*i-.001529*r)-.013791))/Math.PI+.5),y:1-.5*(t*(1.007226+i*(.015085+r*(.028874*i-.044475-.005916*r)))/Math.PI+1),z:0}}unproject(e,t){e=(2*e-.5)*Math.PI;let i=t=(2*(1-t)-1)*Math.PI,r=25,n=0,o=i*i;do{o=i*i;const e=o*o;n=(i*(1.007226+o*(.015085+e*(.028874*o-.044475-.005916*e)))-t)/(1.007226+o*(.045255+e*(.259866*o-.311325-.005916*11*e))),i=M(i-n,-_h,_h)}while(Math.abs(n)>1e-6&&--r>0);o=i*i;const s=M(w(e/(.8707+o*(o*(o*o*o*(.003971-.001529*o)-.013791)-.131979))),-180,180),a=w(i);return new Pa(s,a)}}const gh=b(Oa);class WinkelTripel extends Projection{project(e,t){t=b(t),e=b(e);const i=Math.cos(t),r=2/Math.PI,n=Math.acos(i*Math.cos(e/2)),o=Math.sin(n)/n,s=.5*(e*r+2*i*Math.sin(e/2)/o)||0,a=.5*(t+Math.sin(t)/o)||0;return{x:.5*(s/Math.PI+.5),y:1-.5*(a/Math.PI+1),z:0}}unproject(e,t){let i=e=(2*e-.5)*Math.PI,r=t=(2*(1-t)-1)*Math.PI,n=25;const o=1e-6;let s=0,a=0;do{const n=Math.cos(r),o=Math.sin(r),l=2*o*n,c=o*o,u=n*n,h=Math.cos(i/2),d=Math.sin(i/2),p=2*h*d,f=d*d,m=1-u*h*h,_=m?1/m:0,g=m?Math.acos(n*h)*Math.sqrt(1/m):0,y=.5*(2*g*n*d+2*i/Math.PI)-e,x=.5*(g*o+r)-t,v=.5*_*(u*f+g*n*h*c)+1/Math.PI,b=_*(p*l/4-g*o*d),w=.125*_*(l*d-g*o*u*p),E=.5*_*(c*h+g*f*n)+.5,T=b*w-E*v;s=(x*b-y*E)/T,a=(y*w-x*v)/T,i=M(i-s,-Math.PI,Math.PI),r=M(r-a,-gh,gh)}while((Math.abs(s)>o||Math.abs(a)>o)&&--n>0);return new Pa(w(i),w(r))}}class CylindricalEqualArea extends Projection{constructor(e){super(e),this.center=e.center||[0,0],this.parallels=e.parallels||[0,0],this.cosPhi=Math.max(.01,Math.cos(b(this.parallels[0]))),this.scale=1/(2*Math.max(Math.PI*this.cosPhi,1/this.cosPhi)),this.wrap=!0,this.supportsWorldCopies=!0}project(e,t){const{scale:i,cosPhi:r}=this;return{x:b(e)*r*i+.5,y:-Math.sin(b(t))/r*i+.5,z:0}}unproject(e,t){const{scale:i,cosPhi:r}=this,n=-(t-.5)/i,o=M(w((e-.5)/i)/r,-180,180),s=Math.asin(M(n*r,-1,1)),a=M(w(s),-Oa,Oa);return new Pa(o,a)}}class Globe extends Mercator{constructor(e){super(e),this.requiresDraping=!0,this.supportsWorldCopies=!1,this.supportsFog=!0,this.zAxisUnit="pixels",this.unsupportedLayers=["debug"],this.range=[3,5]}projectTilePoint(e,t,i){const r=ua(e,t,i);return ws(r,r,pa(ta(i))),{x:r[0],y:r[1],z:r[2]}}locationPoint(e,t){const i=ca(t.lat,t.lng),r=xs([],i),n=e.elevation?e.elevation.getAtPointOrZero(e.locationCoordinate(t),e._centerAltitude):e._centerAltitude;gs(i,i,r,La(1,0)*Uo*n);const o=Wo(new Float64Array(16));return Xo(o,e.pixelMatrix,e.globeMatrix),ws(i,i,o),new g(i[0],i[1])}pixelsPerMeter(e,t){return La(1,0)*t}pixelSpaceConversion(e,t,i){const r=La(1,e)*t,n=zi(La(1,45)*t,r,i);return this.pixelsPerMeter(e,t)/n}createTileMatrix(e,t,i){const r=fa(ta(i.canonical));return Xo(new Float64Array(16),e.globeMatrix,r)}createInversionMatrix(e,t){const{center:i}=e,r=pa(ta(t));return Qo(r,r,b(i.lng)),Yo(r,r,b(i.lat)),Jo(r,r,[e._pixelsPerMercatorPixel,e._pixelsPerMercatorPixel,1]),Float32Array.from(r)}pointCoordinate(e,t,i,r){return Qs(e,t,i,!0)||new MercatorCoordinate(0,0)}pointCoordinate3D(e,t,i){const r=this.pointCoordinate(e,t,i,0);return[r.x,r.y,r.z]}isPointAboveHorizon(e,t){return!Qs(e,t.x,t.y,!1)}farthestPixelDistance(e){const t=function(e,t){const i=e.cameraToCenterDistance,r=e._centerAltitude*t,n=e._camera,o=e._camera.forward(),s=hs([],_s([],o,-i),[0,0,r]),a=e.worldSize/(2*Math.PI),l=[0,0,-a],c=e.width/e.height,u=Math.tan(e.fovAboveCenter),h=_s([],n.up(),u),d=_s([],n.right(),u*c),p=xs([],hs([],hs([],o,h),d)),f=[];let m;if(new Ray(s,p).closestPointOnSphere(l,a,f)){const t=hs([],f,l),i=As([],t,s);m=Math.cos(e.fovAboveCenter)*cs(i)}else{const e=As([],s,l),t=As([],l,s);xs(t,t);const i=cs(e)-a;m=Math.sqrt(i*(i+2*a));const r=Math.acos(m/(a+i))-Math.acos(vs(o,t));m*=Math.cos(r)}return 1.01*m}(e,this.pixelsPerMeter(e.center.lat,e.worldSize)),i=ga(e.zoom);if(i>0){const r=rh(e,La(1,e.center.lat)*e.worldSize),n=e.worldSize/(2*Math.PI),o=Math.max(e.width,e.height)/e.worldSize*Math.PI;return zi(t,r+n*(1-Math.cos(o)),Math.pow(i,10))}return t}upVector(e,t,i){return ua(t,i,e,1)}upVectorScale(e){return{metersToTile:Ys(ha(ta(e)))}}}function yh(e){const t=e.parallels,i=!!t&&Math.abs(t[0]+t[1])<.01;switch(e.name){case"mercator":return new Mercator(e);case"equirectangular":return new Equirectangular(e);case"naturalEarth":return new NaturalEarth(e);case"equalEarth":return new EqualEarth(e);case"winkelTripel":return new WinkelTripel(e);case"albers":return i?new CylindricalEqualArea(e):new Albers(e);case"lambertConformalConic":return i?new CylindricalEqualArea(e):new LambertConformalConic(e);case"globe":return new Globe(e)}throw new Error(`Invalid projection name: ${e.name}`)}const xh=Ic.types,vh=[{name:"a_fade_opacity",components:1,type:"Uint8",offset:0}];function bh(e,t,i,r,n,o,s,a,l,c,u,h,d){const p=a?Math.min(ih,Math.round(a[0])):0,f=a?Math.min(ih,Math.round(a[1])):0;e.emplaceBack(t,i,Math.round(32*r),Math.round(32*n),o,s,(p<<1)+(l?1:0),f,16*c,16*u,256*h,256*d)}function wh(e,t,i,r,n,o,s){e.emplaceBack(t,i,r,n,o,s)}function Eh(e,t,i,r,n){const o=5*t+2;e.float32[o+0]=i,e.float32[o+1]=r,e.float32[o+2]=n}function Th(e,t,i,r,n){e.emplaceBack(t,i,r,n),e.emplaceBack(t,i,r,n),e.emplaceBack(t,i,r,n),e.emplaceBack(t,i,r,n)}function Sh(e){for(const t of e.sections)if(Jn(t.text))return!0;return!1}class SymbolBuffers{constructor(e){this.layoutVertexArray=new StructArrayLayout4i4ui4i24,this.indexArray=new StructArrayLayout3ui6,this.programConfigurations=e,this.segments=new SegmentVector,this.dynamicLayoutVertexArray=new StructArrayLayout4f16,this.opacityVertexArray=new StructArrayLayout1ul4,this.placedSymbolArray=new PlacedSymbolArray,this.globeExtVertexArray=new StructArrayLayout3i3f20}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.indexArray.length&&0===this.dynamicLayoutVertexArray.length&&0===this.opacityVertexArray.length}upload(e,t,i,r){this.isEmpty()||(i&&(this.layoutVertexBuffer=e.createVertexBuffer(this.layoutVertexArray,ou.members),this.indexBuffer=e.createIndexBuffer(this.indexArray,t),this.dynamicLayoutVertexBuffer=e.createVertexBuffer(this.dynamicLayoutVertexArray,au.members,!0),this.opacityVertexBuffer=e.createVertexBuffer(this.opacityVertexArray,vh,!0),this.globeExtVertexArray.length>0&&(this.globeExtVertexBuffer=e.createVertexBuffer(this.globeExtVertexArray,su.members,!0)),this.opacityVertexBuffer.itemSize=1),(i||r)&&this.programConfigurations.upload(e))}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.dynamicLayoutVertexBuffer.destroy(),this.opacityVertexBuffer.destroy(),this.globeExtVertexBuffer&&this.globeExtVertexBuffer.destroy())}}jn(SymbolBuffers,"SymbolBuffers");class CollisionBuffers{constructor(e,t,i){this.layoutVertexArray=new e,this.layoutAttributes=t,this.indexArray=new i,this.segments=new SegmentVector,this.collisionVertexArray=new StructArrayLayout2ub2f12,this.collisionVertexArrayExt=new StructArrayLayout3f12}upload(e){this.layoutVertexBuffer=e.createVertexBuffer(this.layoutVertexArray,this.layoutAttributes),this.indexBuffer=e.createIndexBuffer(this.indexArray),this.collisionVertexBuffer=e.createVertexBuffer(this.collisionVertexArray,lu.members,!0),this.collisionVertexBufferExt=e.createVertexBuffer(this.collisionVertexArrayExt,cu.members,!0)}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.collisionVertexBuffer.destroy(),this.collisionVertexBufferExt.destroy())}}jn(CollisionBuffers,"CollisionBuffers");class SymbolBucket{constructor(e){this.collisionBoxArray=e.collisionBoxArray,this.zoom=e.zoom,this.overscaling=e.overscaling,this.layers=e.layers,this.layerIds=this.layers.map((e=>e.id)),this.index=e.index,this.pixelRatio=e.pixelRatio,this.sourceLayerIndex=e.sourceLayerIndex,this.hasPattern=!1,this.hasRTLText=!1,this.fullyClipped=!1,this.sortKeyRanges=[],this.collisionCircleArray=[],this.placementInvProjMatrix=Wo([]),this.placementViewportMatrix=Wo([]);const t=this.layers[0]._unevaluatedLayout._values;this.textSizeData=pu(this.zoom,t["text-size"]),this.iconSizeData=pu(this.zoom,t["icon-size"]);const i=this.layers[0].layout,r=i.get("symbol-sort-key"),n=i.get("symbol-z-order");this.canOverlap=i.get("text-allow-overlap")||i.get("icon-allow-overlap")||i.get("text-ignore-placement")||i.get("icon-ignore-placement"),this.sortFeaturesByKey="viewport-y"!==n&&void 0!==r.constantOr(1),this.sortFeaturesByY=("viewport-y"===n||"auto"===n&&!this.sortFeaturesByKey)&&this.canOverlap,this.writingModes=i.get("text-writing-mode").map((e=>Wu[e])),this.stateDependentLayerIds=this.layers.filter((e=>e.isStateDependent())).map((e=>e.id)),this.sourceID=e.sourceID,this.projection=e.projection}createArrays(){this.text=new SymbolBuffers(new ProgramConfigurationSet(this.layers,this.zoom,(e=>/^text/.test(e)))),this.icon=new SymbolBuffers(new ProgramConfigurationSet(this.layers,this.zoom,(e=>/^icon/.test(e)))),this.glyphOffsetArray=new GlyphOffsetArray,this.lineVertexArray=new SymbolLineVertexArray,this.symbolInstances=new SymbolInstanceArray}calculateGlyphDependencies(e,t,i,r,n){for(let i=0;i<e.length;i++)if(t[e.charCodeAt(i)]=!0,r&&n){const r=yu[e.charAt(i)];r&&(t[r.charCodeAt(0)]=!0)}}populate(e,t,i,r){const n=this.layers[0],o=n.layout,s="globe"===this.projection.name,a=o.get("text-font"),l=o.get("text-field"),c=o.get("icon-image"),u=("constant"!==l.value.kind||l.value.value instanceof Formatted&&!l.value.value.isEmpty()||l.value.value.toString().length>0)&&("constant"!==a.value.kind||a.value.value.length>0),h="constant"!==c.value.kind||!!c.value.value||Object.keys(c.parameters).length>0,d=o.get("symbol-sort-key");if(this.features=[],!u&&!h)return;const p=t.iconDependencies,f=t.glyphDependencies,m=t.availableImages,_=new EvaluationParameters(this.zoom);for(const{feature:t,id:l,index:c,sourceLayerIndex:g}of e){const e=n._featureFilter.needGeometry,y=Ha(t,e);if(!n._featureFilter.filter(_,y,i))continue;if(e||(y.geometry=Wa(t,i,r)),s&&1!==t.type&&i.z<=5){const e=y.geometry,t=.98078528056,r=(e,r)=>vs(ua(e.x,e.y,i,1),ua(r.x,r.y,i,1))<t;for(let t=0;t<e.length;t++)e[t]=Ga(e[t],r)}let x,v;if(u){const e=n.getValueAndResolveTokens("text-field",y,i,m),t=Formatted.factory(e);Sh(t)&&(this.hasRTLText=!0),(!this.hasRTLText||"unavailable"===ao()||this.hasRTLText&&co.isParsed())&&(x=gu(t,n,y))}if(h){const e=n.getValueAndResolveTokens("icon-image",y,i,m);v=e instanceof ResolvedImage?e:ResolvedImage.fromString(e)}if(!x&&!v)continue;const b=this.sortFeaturesByKey?d.evaluate(y,{},i):void 0;if(this.features.push({id:l,text:x,icon:v,index:c,sourceLayerIndex:g,geometry:y.geometry,properties:t.properties,type:xh[t.type],sortKey:b}),v&&(p[v.name]=!0),x){const e=a.evaluate(y,{},i).join(","),t="map"===o.get("text-rotation-alignment")&&"point"!==o.get("symbol-placement");this.allowVerticalPlacement=this.writingModes&&this.writingModes.indexOf(Wu.vertical)>=0;for(const i of x.sections)if(i.image)p[i.image.name]=!0;else{const r=Wn(x.toString()),n=i.fontStack||e,o=f[n]=f[n]||{};this.calculateGlyphDependencies(i.text,o,t,this.allowVerticalPlacement,r)}}}"line"===o.get("symbol-placement")&&(this.features=function(e){const t={},i={},r=[];let n=0;function o(t){r.push(e[t]),n++}function s(e,t,n){const o=i[e];return delete i[e],i[t]=o,r[o].geometry[0].pop(),r[o].geometry[0]=r[o].geometry[0].concat(n[0]),o}function a(e,i,n){const o=t[i];return delete t[i],t[e]=o,r[o].geometry[0].shift(),r[o].geometry[0]=n[0].concat(r[o].geometry[0]),o}function l(e,t,i){const r=i?t[0][t[0].length-1]:t[0][0];return`${e}:${r.x}:${r.y}`}for(let c=0;c<e.length;c++){const u=e[c],h=u.geometry,d=u.text?u.text.toString():null;if(!d){o(c);continue}const p=l(d,h),f=l(d,h,!0);if(p in i&&f in t&&i[p]!==t[f]){const e=a(p,f,h),n=s(p,f,r[e].geometry);delete t[p],delete i[f],i[l(d,r[n].geometry,!0)]=n,r[e].geometry=null}else p in i?s(p,f,h):f in t?a(p,f,h):(o(c),t[p]=n-1,i[f]=n-1)}return r.filter((e=>e.geometry))}(this.features)),this.sortFeaturesByKey&&this.features.sort(((e,t)=>e.sortKey-t.sortKey))}update(e,t,i,r){this.stateDependentLayers.length&&(this.text.programConfigurations.updatePaintArrays(e,t,this.layers,i,r),this.icon.programConfigurations.updatePaintArrays(e,t,this.layers,i,r))}isEmpty(){return 0===this.symbolInstances.length&&!this.hasRTLText}uploadPending(){return!this.uploaded||this.text.programConfigurations.needsUpload||this.icon.programConfigurations.needsUpload}upload(e){!this.uploaded&&this.hasDebugData()&&(this.textCollisionBox.upload(e),this.iconCollisionBox.upload(e)),this.text.upload(e,this.sortFeaturesByY,!this.uploaded,this.text.programConfigurations.needsUpload),this.icon.upload(e,this.sortFeaturesByY,!this.uploaded,this.icon.programConfigurations.needsUpload),this.uploaded=!0}destroyDebugData(){this.textCollisionBox.destroy(),this.iconCollisionBox.destroy()}getProjection(){return this.projectionInstance||(this.projectionInstance=yh(this.projection)),this.projectionInstance}destroy(){this.text.destroy(),this.icon.destroy(),this.hasDebugData()&&this.destroyDebugData()}addToLineVertexArray(e,t){const i=this.lineVertexArray.length;if(void 0!==e.segment)for(const{x:e,y:i}of t)this.lineVertexArray.emplaceBack(e,i);return{lineStartIndex:i,lineLength:this.lineVertexArray.length-i}}addSymbols(e,t,i,r,n,o,s,a,l,c,u,h,d,p){const f=e.indexArray,m=e.layoutVertexArray,_=e.globeExtVertexArray,g=e.segments.prepareSegment(4*t.length,m,f,this.canOverlap?o.sortKey:void 0),y=this.glyphOffsetArray.length,x=g.vertexLength,v=this.allowVerticalPlacement&&s===Wu.vertical?Math.PI/2:0,b=o.text&&o.text.sections;for(let r=0;r<t.length;r++){const{tl:n,tr:s,bl:c,br:u,tex:h,pixelOffsetTL:y,pixelOffsetBR:x,minFontScaleX:w,minFontScaleY:E,glyphOffset:T,isSDF:S,sectionIndex:A}=t[r],C=g.vertexLength,I=T[1];if(bh(m,l.x,l.y,n.x,I+n.y,h.x,h.y,i,S,y.x,y.y,w,E),bh(m,l.x,l.y,s.x,I+s.y,h.x+h.w,h.y,i,S,x.x,y.y,w,E),bh(m,l.x,l.y,c.x,I+c.y,h.x,h.y+h.h,i,S,y.x,x.y,w,E),bh(m,l.x,l.y,u.x,I+u.y,h.x+h.w,h.y+h.h,i,S,x.x,x.y,w,E),a){const{x:t,y:i,z:r}=a.anchor,[n,o,s]=a.up;wh(_,t,i,r,n,o,s),wh(_,t,i,r,n,o,s),wh(_,t,i,r,n,o,s),wh(_,t,i,r,n,o,s),Th(e.dynamicLayoutVertexArray,t,i,r,v)}else Th(e.dynamicLayoutVertexArray,l.x,l.y,l.z,v);f.emplaceBack(C,C+1,C+2),f.emplaceBack(C+1,C+2,C+3),g.vertexLength+=4,g.primitiveLength+=2,this.glyphOffsetArray.emplaceBack(T[0]),r!==t.length-1&&A===t[r+1].sectionIndex||e.programConfigurations.populatePaintArrays(m.length,o,o.index,{},d,p,b&&b[A])}const w=a?a.anchor:l;e.placedSymbolArray.emplaceBack(w.x,w.y,w.z,l.x,l.y,y,this.glyphOffsetArray.length-y,x,c,u,l.segment,i?i[0]:0,i?i[1]:0,r[0],r[1],s,0,!1,0,h,0)}_commitLayoutVertex(e,t,i,r,n,o,s){e.emplaceBack(t,i,r,n,o,Math.round(s.x),Math.round(s.y))}_addCollisionDebugVertices(e,t,i,r,n,o,s){const a=i.segments.prepareSegment(4,i.layoutVertexArray,i.indexArray),l=a.vertexLength,c=s.tileAnchorX,u=s.tileAnchorY;for(let e=0;e<4;e++)i.collisionVertexArray.emplaceBack(0,0,0,0);i.collisionVertexArrayExt.emplaceBack(t,-e.padding,-e.padding),i.collisionVertexArrayExt.emplaceBack(t,e.padding,-e.padding),i.collisionVertexArrayExt.emplaceBack(t,e.padding,e.padding),i.collisionVertexArrayExt.emplaceBack(t,-e.padding,e.padding),this._commitLayoutVertex(i.layoutVertexArray,r,n,o,c,u,new g(e.x1,e.y1)),this._commitLayoutVertex(i.layoutVertexArray,r,n,o,c,u,new g(e.x2,e.y1)),this._commitLayoutVertex(i.layoutVertexArray,r,n,o,c,u,new g(e.x2,e.y2)),this._commitLayoutVertex(i.layoutVertexArray,r,n,o,c,u,new g(e.x1,e.y2)),a.vertexLength+=4;const h=i.indexArray;h.emplaceBack(l,l+1),h.emplaceBack(l+1,l+2),h.emplaceBack(l+2,l+3),h.emplaceBack(l+3,l),a.primitiveLength+=4}_addTextDebugCollisionBoxes(e,t,i,r,n,o){for(let s=r;s<n;s++){const r=i.get(s),n=this.getSymbolInstanceTextSize(e,o,t,s);this._addCollisionDebugVertices(r,n,this.textCollisionBox,r.projectedAnchorX,r.projectedAnchorY,r.projectedAnchorZ,o)}}_addIconDebugCollisionBoxes(e,t,i,r,n,o){for(let s=r;s<n;s++){const r=i.get(s),n=this.getSymbolInstanceIconSize(e,t,o.placedIconSymbolIndex);this._addCollisionDebugVertices(r,n,this.iconCollisionBox,r.projectedAnchorX,r.projectedAnchorY,r.projectedAnchorZ,o)}}generateCollisionDebugBuffers(e,t){this.hasDebugData()&&this.destroyDebugData(),this.textCollisionBox=new CollisionBuffers(StructArrayLayout3i2i2i16,uu.members,StructArrayLayout2ui4),this.iconCollisionBox=new CollisionBuffers(StructArrayLayout3i2i2i16,uu.members,StructArrayLayout2ui4);const i=mu(this.iconSizeData,e),r=mu(this.textSizeData,e);for(let n=0;n<this.symbolInstances.length;n++){const o=this.symbolInstances.get(n);this._addTextDebugCollisionBoxes(r,e,t,o.textBoxStartIndex,o.textBoxEndIndex,o),this._addTextDebugCollisionBoxes(r,e,t,o.verticalTextBoxStartIndex,o.verticalTextBoxEndIndex,o),this._addIconDebugCollisionBoxes(i,e,t,o.iconBoxStartIndex,o.iconBoxEndIndex,o),this._addIconDebugCollisionBoxes(i,e,t,o.verticalIconBoxStartIndex,o.verticalIconBoxEndIndex,o)}}getSymbolInstanceTextSize(e,t,i,r){const n=this.text.placedSymbolArray.get(t.rightJustifiedTextSymbolIndex>=0?t.rightJustifiedTextSymbolIndex:t.centerJustifiedTextSymbolIndex>=0?t.centerJustifiedTextSymbolIndex:t.leftJustifiedTextSymbolIndex>=0?t.leftJustifiedTextSymbolIndex:t.verticalPlacedTextSymbolIndex>=0?t.verticalPlacedTextSymbolIndex:r),o=fu(this.textSizeData,e,n)/24;return this.tilePixelRatio*o}getSymbolInstanceIconSize(e,t,i){const r=this.icon.placedSymbolArray.get(i),n=fu(this.iconSizeData,e,r);return this.tilePixelRatio*n}_commitDebugCollisionVertexUpdate(e,t,i){e.emplaceBack(t,-i,-i),e.emplaceBack(t,i,-i),e.emplaceBack(t,i,i),e.emplaceBack(t,-i,i)}_updateTextDebugCollisionBoxes(e,t,i,r,n,o){for(let s=r;s<n;s++){const r=i.get(s),n=this.getSymbolInstanceTextSize(e,o,t,s);this._commitDebugCollisionVertexUpdate(this.textCollisionBox.collisionVertexArrayExt,n,r.padding)}}_updateIconDebugCollisionBoxes(e,t,i,r,n,o){for(let s=r;s<n;s++){const r=i.get(s),n=this.getSymbolInstanceIconSize(e,t,o);this._commitDebugCollisionVertexUpdate(this.iconCollisionBox.collisionVertexArrayExt,n,r.padding)}}updateCollisionDebugBuffers(e,t){if(!this.hasDebugData())return;this.hasTextCollisionBoxData()&&this.textCollisionBox.collisionVertexArrayExt.clear(),this.hasIconCollisionBoxData()&&this.iconCollisionBox.collisionVertexArrayExt.clear();const i=mu(this.iconSizeData,e),r=mu(this.textSizeData,e);for(let n=0;n<this.symbolInstances.length;n++){const o=this.symbolInstances.get(n);this._updateTextDebugCollisionBoxes(r,e,t,o.textBoxStartIndex,o.textBoxEndIndex,o),this._updateTextDebugCollisionBoxes(r,e,t,o.verticalTextBoxStartIndex,o.verticalTextBoxEndIndex,o),this._updateIconDebugCollisionBoxes(i,e,t,o.iconBoxStartIndex,o.iconBoxEndIndex,o.placedIconSymbolIndex),this._updateIconDebugCollisionBoxes(i,e,t,o.verticalIconBoxStartIndex,o.verticalIconBoxEndIndex,o.placedIconSymbolIndex)}this.hasTextCollisionBoxData()&&this.textCollisionBox.collisionVertexBufferExt&&this.textCollisionBox.collisionVertexBufferExt.updateData(this.textCollisionBox.collisionVertexArrayExt),this.hasIconCollisionBoxData()&&this.iconCollisionBox.collisionVertexBufferExt&&this.iconCollisionBox.collisionVertexBufferExt.updateData(this.iconCollisionBox.collisionVertexArrayExt)}_deserializeCollisionBoxesForSymbol(e,t,i,r,n,o,s,a,l){const c={};if(t<i){const{x1:i,y1:r,x2:n,y2:o,padding:s,projectedAnchorX:a,projectedAnchorY:l,projectedAnchorZ:u,tileAnchorX:h,tileAnchorY:d,featureIndex:p}=e.get(t);c.textBox={x1:i,y1:r,x2:n,y2:o,padding:s,projectedAnchorX:a,projectedAnchorY:l,projectedAnchorZ:u,tileAnchorX:h,tileAnchorY:d},c.textFeatureIndex=p}if(r<n){const{x1:t,y1:i,x2:n,y2:o,padding:s,projectedAnchorX:a,projectedAnchorY:l,projectedAnchorZ:u,tileAnchorX:h,tileAnchorY:d,featureIndex:p}=e.get(r);c.verticalTextBox={x1:t,y1:i,x2:n,y2:o,padding:s,projectedAnchorX:a,projectedAnchorY:l,projectedAnchorZ:u,tileAnchorX:h,tileAnchorY:d},c.verticalTextFeatureIndex=p}if(o<s){const{x1:t,y1:i,x2:r,y2:n,padding:s,projectedAnchorX:a,projectedAnchorY:l,projectedAnchorZ:u,tileAnchorX:h,tileAnchorY:d,featureIndex:p}=e.get(o);c.iconBox={x1:t,y1:i,x2:r,y2:n,padding:s,projectedAnchorX:a,projectedAnchorY:l,projectedAnchorZ:u,tileAnchorX:h,tileAnchorY:d},c.iconFeatureIndex=p}if(a<l){const{x1:t,y1:i,x2:r,y2:n,padding:o,projectedAnchorX:s,projectedAnchorY:l,projectedAnchorZ:u,tileAnchorX:h,tileAnchorY:d,featureIndex:p}=e.get(a);c.verticalIconBox={x1:t,y1:i,x2:r,y2:n,padding:o,projectedAnchorX:s,projectedAnchorY:l,projectedAnchorZ:u,tileAnchorX:h,tileAnchorY:d},c.verticalIconFeatureIndex=p}return c}deserializeCollisionBoxes(e){this.collisionArrays=[];for(let t=0;t<this.symbolInstances.length;t++){const i=this.symbolInstances.get(t);this.collisionArrays.push(this._deserializeCollisionBoxesForSymbol(e,i.textBoxStartIndex,i.textBoxEndIndex,i.verticalTextBoxStartIndex,i.verticalTextBoxEndIndex,i.iconBoxStartIndex,i.iconBoxEndIndex,i.verticalIconBoxStartIndex,i.verticalIconBoxEndIndex))}}hasTextData(){return this.text.segments.get().length>0}hasIconData(){return this.icon.segments.get().length>0}hasDebugData(){return this.textCollisionBox&&this.iconCollisionBox}hasTextCollisionBoxData(){return this.hasDebugData()&&this.textCollisionBox.segments.get().length>0}hasIconCollisionBoxData(){return this.hasDebugData()&&this.iconCollisionBox.segments.get().length>0}addIndicesForPlacedSymbol(e,t){const i=e.placedSymbolArray.get(t),r=i.vertexStartIndex+4*i.numGlyphs;for(let t=i.vertexStartIndex;t<r;t+=4)e.indexArray.emplaceBack(t,t+1,t+2),e.indexArray.emplaceBack(t+1,t+2,t+3)}getSortedSymbolIndexes(e){if(this.sortedAngle===e&&void 0!==this.symbolInstanceIndexes)return this.symbolInstanceIndexes;const t=Math.sin(e),i=Math.cos(e),r=[],n=[],o=[];for(let e=0;e<this.symbolInstances.length;++e){o.push(e);const s=this.symbolInstances.get(e);r.push(0|Math.round(t*s.tileAnchorX+i*s.tileAnchorY)),n.push(s.featureIndex)}return o.sort(((e,t)=>r[e]-r[t]||n[t]-n[e])),o}addToSortKeyRanges(e,t){const i=this.sortKeyRanges[this.sortKeyRanges.length-1];i&&i.sortKey===t?i.symbolInstanceEnd=e+1:this.sortKeyRanges.push({sortKey:t,symbolInstanceStart:e,symbolInstanceEnd:e+1})}sortFeatures(e){if(this.sortFeaturesByY&&this.sortedAngle!==e&&!(this.text.segments.get().length>1||this.icon.segments.get().length>1)){this.symbolInstanceIndexes=this.getSortedSymbolIndexes(e),this.sortedAngle=e,this.text.indexArray.clear(),this.icon.indexArray.clear(),this.featureSortOrder=[];for(const e of this.symbolInstanceIndexes){const t=this.symbolInstances.get(e);this.featureSortOrder.push(t.featureIndex);const{rightJustifiedTextSymbolIndex:i,centerJustifiedTextSymbolIndex:r,leftJustifiedTextSymbolIndex:n,verticalPlacedTextSymbolIndex:o,placedIconSymbolIndex:s,verticalPlacedIconSymbolIndex:a}=t;i>=0&&this.addIndicesForPlacedSymbol(this.text,i),r>=0&&r!==i&&this.addIndicesForPlacedSymbol(this.text,r),n>=0&&n!==r&&n!==i&&this.addIndicesForPlacedSymbol(this.text,n),o>=0&&this.addIndicesForPlacedSymbol(this.text,o),s>=0&&this.addIndicesForPlacedSymbol(this.icon,s),a>=0&&this.addIndicesForPlacedSymbol(this.icon,a)}this.text.indexBuffer&&this.text.indexBuffer.updateData(this.text.indexArray),this.icon.indexBuffer&&this.icon.indexBuffer.updateData(this.icon.indexArray)}}}jn(SymbolBucket,"SymbolBucket",{omit:["layers","collisionBoxArray","features","compareText"]}),SymbolBucket.MAX_GLYPHS=65535,SymbolBucket.addDynamicAttributes=Th;const Ah=new Properties({"symbol-placement":new DataConstantProperty(yt.layout_symbol["symbol-placement"]),"symbol-spacing":new DataConstantProperty(yt.layout_symbol["symbol-spacing"]),"symbol-avoid-edges":new DataConstantProperty(yt.layout_symbol["symbol-avoid-edges"]),"symbol-sort-key":new DataDrivenProperty(yt.layout_symbol["symbol-sort-key"]),"symbol-z-order":new DataConstantProperty(yt.layout_symbol["symbol-z-order"]),"icon-allow-overlap":new DataConstantProperty(yt.layout_symbol["icon-allow-overlap"]),"icon-ignore-placement":new DataConstantProperty(yt.layout_symbol["icon-ignore-placement"]),"icon-optional":new DataConstantProperty(yt.layout_symbol["icon-optional"]),"icon-rotation-alignment":new DataConstantProperty(yt.layout_symbol["icon-rotation-alignment"]),"icon-size":new DataDrivenProperty(yt.layout_symbol["icon-size"]),"icon-text-fit":new DataConstantProperty(yt.layout_symbol["icon-text-fit"]),"icon-text-fit-padding":new DataConstantProperty(yt.layout_symbol["icon-text-fit-padding"]),"icon-image":new DataDrivenProperty(yt.layout_symbol["icon-image"]),"icon-rotate":new DataDrivenProperty(yt.layout_symbol["icon-rotate"]),"icon-padding":new DataConstantProperty(yt.layout_symbol["icon-padding"]),"icon-keep-upright":new DataConstantProperty(yt.layout_symbol["icon-keep-upright"]),"icon-offset":new DataDrivenProperty(yt.layout_symbol["icon-offset"]),"icon-anchor":new DataDrivenProperty(yt.layout_symbol["icon-anchor"]),"icon-pitch-alignment":new DataConstantProperty(yt.layout_symbol["icon-pitch-alignment"]),"text-pitch-alignment":new DataConstantProperty(yt.layout_symbol["text-pitch-alignment"]),"text-rotation-alignment":new DataConstantProperty(yt.layout_symbol["text-rotation-alignment"]),"text-field":new DataDrivenProperty(yt.layout_symbol["text-field"]),"text-font":new DataDrivenProperty(yt.layout_symbol["text-font"]),"text-size":new DataDrivenProperty(yt.layout_symbol["text-size"]),"text-max-width":new DataDrivenProperty(yt.layout_symbol["text-max-width"]),"text-line-height":new DataDrivenProperty(yt.layout_symbol["text-line-height"]),"text-letter-spacing":new DataDrivenProperty(yt.layout_symbol["text-letter-spacing"]),"text-justify":new DataDrivenProperty(yt.layout_symbol["text-justify"]),"text-radial-offset":new DataDrivenProperty(yt.layout_symbol["text-radial-offset"]),"text-variable-anchor":new DataConstantProperty(yt.layout_symbol["text-variable-anchor"]),"text-anchor":new DataDrivenProperty(yt.layout_symbol["text-anchor"]),"text-max-angle":new DataConstantProperty(yt.layout_symbol["text-max-angle"]),"text-writing-mode":new DataConstantProperty(yt.layout_symbol["text-writing-mode"]),"text-rotate":new DataDrivenProperty(yt.layout_symbol["text-rotate"]),"text-padding":new DataConstantProperty(yt.layout_symbol["text-padding"]),"text-keep-upright":new DataConstantProperty(yt.layout_symbol["text-keep-upright"]),"text-transform":new DataDrivenProperty(yt.layout_symbol["text-transform"]),"text-offset":new DataDrivenProperty(yt.layout_symbol["text-offset"]),"text-allow-overlap":new DataConstantProperty(yt.layout_symbol["text-allow-overlap"]),"text-ignore-placement":new DataConstantProperty(yt.layout_symbol["text-ignore-placement"]),"text-optional":new DataConstantProperty(yt.layout_symbol["text-optional"])});var Ch={paint:new Properties({"icon-opacity":new DataDrivenProperty(yt.paint_symbol["icon-opacity"]),"icon-color":new DataDrivenProperty(yt.paint_symbol["icon-color"]),"icon-halo-color":new DataDrivenProperty(yt.paint_symbol["icon-halo-color"]),"icon-halo-width":new DataDrivenProperty(yt.paint_symbol["icon-halo-width"]),"icon-halo-blur":new DataDrivenProperty(yt.paint_symbol["icon-halo-blur"]),"icon-translate":new DataConstantProperty(yt.paint_symbol["icon-translate"]),"icon-translate-anchor":new DataConstantProperty(yt.paint_symbol["icon-translate-anchor"]),"text-opacity":new DataDrivenProperty(yt.paint_symbol["text-opacity"]),"text-color":new DataDrivenProperty(yt.paint_symbol["text-color"],{runtimeType:Mt,getOverride:e=>e.textColor,hasOverride:e=>!!e.textColor}),"text-halo-color":new DataDrivenProperty(yt.paint_symbol["text-halo-color"]),"text-halo-width":new DataDrivenProperty(yt.paint_symbol["text-halo-width"]),"text-halo-blur":new DataDrivenProperty(yt.paint_symbol["text-halo-blur"]),"text-translate":new DataConstantProperty(yt.paint_symbol["text-translate"]),"text-translate-anchor":new DataConstantProperty(yt.paint_symbol["text-translate-anchor"])}),layout:Ah};class FormatSectionOverride{constructor(e){this.type=e.property.overrides?e.property.overrides.runtimeType:Tt,this.defaultValue=e}evaluate(e){if(e.formattedSection){const t=this.defaultValue.property.overrides;if(t&&t.hasOverride(e.formattedSection))return t.getOverride(e.formattedSection)}return e.feature&&e.featureState?this.defaultValue.evaluate(e.feature,e.featureState):this.defaultValue.property.specification.default}eachChild(e){this.defaultValue.isConstant()||e(this.defaultValue.value._styleExpression.expression)}outputDefined(){return!1}serialize(){return null}}jn(FormatSectionOverride,"FormatSectionOverride",{omit:["defaultValue"]});class SymbolStyleLayer extends StyleLayer{constructor(e){super(e,Ch)}recalculate(e,t){super.recalculate(e,t),"auto"===this.layout.get("icon-rotation-alignment")&&(this.layout._values["icon-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-rotation-alignment")&&(this.layout._values["text-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-pitch-alignment")&&(this.layout._values["text-pitch-alignment"]=this.layout.get("text-rotation-alignment")),"auto"===this.layout.get("icon-pitch-alignment")&&(this.layout._values["icon-pitch-alignment"]=this.layout.get("icon-rotation-alignment"));const i=this.layout.get("text-writing-mode");if(i){const e=[];for(const t of i)e.indexOf(t)<0&&e.push(t);this.layout._values["text-writing-mode"]=e}else this.layout._values["text-writing-mode"]="point"===this.layout.get("symbol-placement")?["horizontal"]:["horizontal","vertical"];this._setPaintOverrides()}getValueAndResolveTokens(e,t,i,r){const n=this.layout.get(e).evaluate(t,{},i,r),o=this._unevaluatedLayout._values[e];return o.isDataDriven()||Fr(o.value)||!n?n:function(e,t){return t.replace(/{([^{}]+)}/g,((t,i)=>i in e?String(e[i]):""))}(t.properties,n)}createBucket(e){return new SymbolBucket(e)}queryRadius(){return 0}queryIntersectsFeature(){return!1}_setPaintOverrides(){for(const e of Ch.paint.overridableProperties){if(!SymbolStyleLayer.hasPaintOverride(this.layout,e))continue;const t=this.paint.get(e),i=new FormatSectionOverride(t),r=new StyleExpression(i,t.property.specification);let n=null;n="constant"===t.value.kind||"source"===t.value.kind?new ZoomConstantExpression("source",r):new ZoomDependentExpression("composite",r,t.value.zoomStops,t.value._interpolationType),this.paint._values[e]=new PossiblyEvaluatedPropertyValue(t.property,n,t.parameters)}}_handleOverridablePaintPropertyUpdate(e,t,i){return!(!this.layout||t.isDataDriven()||i.isDataDriven())&&SymbolStyleLayer.hasPaintOverride(this.layout,e)}static hasPaintOverride(e,t){const i=e.get("text-field"),r=Ch.paint.properties[t];let n=!1;const o=e=>{for(const t of e)if(r.overrides&&r.overrides.hasOverride(t))return void(n=!0)};if("constant"===i.value.kind&&i.value.value instanceof Formatted)o(i.value.value.sections);else if("source"===i.value.kind){const e=t=>{n||(t instanceof Yt&&Kt(t.value)===kt?o(t.value.sections):t instanceof FormatExpression?o(t.sections):t.eachChild(e))},t=i.value;t._styleExpression&&e(t._styleExpression.expression)}return n}getProgramConfiguration(e){return new ProgramConfiguration(this,e)}}var Ih={paint:new Properties({"background-color":new DataConstantProperty(yt.paint_background["background-color"]),"background-pattern":new DataConstantProperty(yt.paint_background["background-pattern"]),"background-opacity":new DataConstantProperty(yt.paint_background["background-opacity"])})},Mh={paint:new Properties({"raster-opacity":new DataConstantProperty(yt.paint_raster["raster-opacity"]),"raster-hue-rotate":new DataConstantProperty(yt.paint_raster["raster-hue-rotate"]),"raster-brightness-min":new DataConstantProperty(yt.paint_raster["raster-brightness-min"]),"raster-brightness-max":new DataConstantProperty(yt.paint_raster["raster-brightness-max"]),"raster-saturation":new DataConstantProperty(yt.paint_raster["raster-saturation"]),"raster-contrast":new DataConstantProperty(yt.paint_raster["raster-contrast"]),"raster-resampling":new DataConstantProperty(yt.paint_raster["raster-resampling"]),"raster-fade-duration":new DataConstantProperty(yt.paint_raster["raster-fade-duration"])})};class CustomStyleLayer extends StyleLayer{constructor(e){super(e,{}),this.implementation=e}is3D(){return"3d"===this.implementation.renderingMode}hasOffscreenPass(){return void 0!==this.implementation.prerender}isLayerDraped(){return void 0!==this.implementation.renderToTile}shouldRedrape(){return!!this.implementation.shouldRerenderTiles&&this.implementation.shouldRerenderTiles()}recalculate(){}updateTransitions(){}hasTransition(){return!1}serialize(){}onAdd(e){this.implementation.onAdd&&this.implementation.onAdd(e,e.painter.context.gl)}onRemove(e){this.implementation.onRemove&&this.implementation.onRemove(e,e.painter.context.gl)}}var Ph={paint:new Properties({"sky-type":new DataConstantProperty(yt.paint_sky["sky-type"]),"sky-atmosphere-sun":new DataConstantProperty(yt.paint_sky["sky-atmosphere-sun"]),"sky-atmosphere-sun-intensity":new DataConstantProperty(yt.paint_sky["sky-atmosphere-sun-intensity"]),"sky-gradient-center":new DataConstantProperty(yt.paint_sky["sky-gradient-center"]),"sky-gradient-radius":new DataConstantProperty(yt.paint_sky["sky-gradient-radius"]),"sky-gradient":new ColorRampProperty(yt.paint_sky["sky-gradient"]),"sky-atmosphere-halo-color":new DataConstantProperty(yt.paint_sky["sky-atmosphere-halo-color"]),"sky-atmosphere-color":new DataConstantProperty(yt.paint_sky["sky-atmosphere-color"]),"sky-opacity":new DataConstantProperty(yt.paint_sky["sky-opacity"])})};function Dh(e,t,i){const r=[0,0,1],n=Ls([]);return Rs(n,n,i?-b(e)+Math.PI:b(e)),Bs(n,n,-b(t)),Ts(r,r,n),xs(r,r)}const zh={circle:class CircleStyleLayer extends StyleLayer{constructor(e){super(e,fl)}createBucket(e){return new CircleBucket(e)}queryRadius(e){const t=e;return cl("circle-radius",this,t)+cl("circle-stroke-width",this,t)+ul(this.paint.get("circle-translate"))}queryIntersectsFeature(e,t,i,r,n,o,s,a){const l=dl(this.paint.get("circle-translate"),this.paint.get("circle-translate-anchor"),o.angle,e.pixelToTileUnitsFactor),c=this.paint.get("circle-radius").evaluate(t,i)+this.paint.get("circle-stroke-width").evaluate(t,i);return ml(e,r,o,s,a,"map"===this.paint.get("circle-pitch-alignment"),"map"===this.paint.get("circle-pitch-scale"),l,c)}getProgramIds(){return["circle"]}getProgramConfiguration(e){return new ProgramConfiguration(this,e)}},heatmap:class HeatmapStyleLayer extends StyleLayer{createBucket(e){return new HeatmapBucket(e)}constructor(e){super(e,El),this._updateColorRamp()}_handleSpecialPaintPropertyUpdate(e){"heatmap-color"===e&&this._updateColorRamp()}_updateColorRamp(){this.colorRamp=Tl({expression:this._transitionablePaint._values["heatmap-color"].value.expression,evaluationKey:"heatmapDensity",image:this.colorRamp}),this.colorRampTexture=null}resize(){this.heatmapFbo&&(this.heatmapFbo.destroy(),this.heatmapFbo=null)}queryRadius(e){return cl("heatmap-radius",this,e)}queryIntersectsFeature(e,t,i,r,n,o,s,a){const l=this.paint.get("heatmap-radius").evaluate(t,i);return ml(e,r,o,s,a,!0,!0,new g(0,0),l)}hasOffscreenPass(){return 0!==this.paint.get("heatmap-opacity")&&"none"!==this.visibility}getProgramIds(){return["heatmap","heatmapTexture"]}getProgramConfiguration(e){return new ProgramConfiguration(this,e)}},hillshade:class HillshadeStyleLayer extends StyleLayer{constructor(e){super(e,Sl)}hasOffscreenPass(){return 0!==this.paint.get("hillshade-exaggeration")&&"none"!==this.visibility}getProgramIds(){return["hillshade","hillshadePrepare"]}},fill:class FillStyleLayer extends StyleLayer{constructor(e){super(e,hc)}getProgramIds(){const e=this.paint.get("fill-pattern"),t=e&&e.constantOr(1),i=[t?"fillPattern":"fill"];return this.paint.get("fill-antialias")&&i.push(t&&!this.getPaintProperty("fill-outline-color")?"fillOutlinePattern":"fillOutline"),i}getProgramConfiguration(e){return new ProgramConfiguration(this,e)}recalculate(e,t){super.recalculate(e,t);const i=this.paint._values["fill-outline-color"];"constant"===i.value.kind&&void 0===i.value.value&&(this.paint._values["fill-outline-color"]=this.paint._values["fill-color"])}createBucket(e){return new FillBucket(e)}queryRadius(){return ul(this.paint.get("fill-translate"))}queryIntersectsFeature(e,t,i,r,n,o){return!e.queryGeometry.isAboveHorizon&&Qa(hl(e.tilespaceGeometry,this.paint.get("fill-translate"),this.paint.get("fill-translate-anchor"),o.angle,e.pixelToTileUnitsFactor),r)}isTileClipped(){return!0}},"fill-extrusion":class FillExtrusionStyleLayer extends StyleLayer{constructor(e){super(e,Gc)}createBucket(e){return new FillExtrusionBucket(e)}queryRadius(){return ul(this.paint.get("fill-extrusion-translate"))}is3D(){return!0}getProgramIds(){return[this.paint.get("fill-extrusion-pattern").constantOr(1)?"fillExtrusionPattern":"fillExtrusion"]}getProgramConfiguration(e){return new ProgramConfiguration(this,e)}queryIntersectsFeature(e,t,i,r,n,o,s,a,l){const c=dl(this.paint.get("fill-extrusion-translate"),this.paint.get("fill-extrusion-translate-anchor"),o.angle,e.pixelToTileUnitsFactor),u=this.paint.get("fill-extrusion-height").evaluate(t,i),h=this.paint.get("fill-extrusion-base").evaluate(t,i),d=[0,0],p=a&&o.elevation,f=o.elevation?o.elevation.exaggeration():1,m=e.tile.getBucket(this);if(p&&m instanceof FillExtrusionBucket){const e=m.centroidVertexArray,t=l+1;t<e.length&&(d[0]=e.geta_centroid_pos0(t),d[1]=e.geta_centroid_pos1(t))}if(0===d[0]&&1===d[1])return!1;"globe"===o.projection.name&&(r=jc([r],[new g(0,0),new g(Uo,Uo)],e.tileID.canonical).map((e=>e.polygon)).flat());const _=p?a:null,[y,x]=function(e,t,i,r,n,o,s,a,l,c,u){return"globe"===e.projection.name?function(e,t,i,r,n,o,s,a,l,c,u){const h=[],d=[],p=e.projection.upVectorScale(u,e.center.lat,e.worldSize).metersToTile,f=[0,0,0,1],m=[0,0,0,1],_=(e,t,i,r)=>{e[0]=t,e[1]=i,e[2]=r,e[3]=1},g=Vc();i>0&&(i+=g),r+=g;for(const g of t){const t=[],y=[];for(const h of g){const d=h.x+n.x,g=h.y+n.y,x=e.projection.projectTilePoint(d,g,u),v=e.projection.upVector(u,h.x,h.y);let b=i,w=r;if(s){const e=Hc(d,g,i,r,s,a,l,c);b+=e.base,w+=e.top}0!==i?_(f,x.x+v[0]*p*b,x.y+v[1]*p*b,x.z+v[2]*p*b):_(f,x.x,x.y,x.z),_(m,x.x+v[0]*p*w,x.y+v[1]*p*w,x.z+v[2]*p*w),ws(f,f,o),ws(m,m,o),t.push(new Point3D(f[0],f[1],f[2])),y.push(new Point3D(m[0],m[1],m[2]))}h.push(t),d.push(y)}return[h,d]}(e,t,i,r,n,o,s,a,l,c,u):s?function(e,t,i,r,n,o,s,a,l){const c=[],u=[],h=[0,0,0,1];for(const d of e){const e=[],p=[];for(const c of d){const u=c.x+r.x,d=c.y+r.y,f=Hc(u,d,t,i,o,s,a,l);h[0]=u,h[1]=d,h[2]=f.base,h[3]=1,zs(h,h,n),h[3]=Math.max(h[3],1e-5);const m=new Point3D(h[0]/h[3],h[1]/h[3],h[2]/h[3]);h[0]=u,h[1]=d,h[2]=f.top,h[3]=1,zs(h,h,n),h[3]=Math.max(h[3],1e-5);const _=new Point3D(h[0]/h[3],h[1]/h[3],h[2]/h[3]);e.push(m),p.push(_)}c.push(e),u.push(p)}return[c,u]}(t,i,r,n,o,s,a,l,c):function(e,t,i,r,n){const o=[],s=[],a=n[8]*t,l=n[9]*t,c=n[10]*t,u=n[11]*t,h=n[8]*i,d=n[9]*i,p=n[10]*i,f=n[11]*i;for(const t of e){const e=[],i=[];for(const o of t){const t=o.x+r.x,s=o.y+r.y,m=n[0]*t+n[4]*s+n[12],_=n[1]*t+n[5]*s+n[13],g=n[2]*t+n[6]*s+n[14],y=n[3]*t+n[7]*s+n[15],x=m+a,v=_+l,b=g+c,w=Math.max(y+u,1e-5),E=m+h,T=_+d,S=g+p,A=Math.max(y+f,1e-5);e.push(new Point3D(x/w,v/w,b/w)),i.push(new Point3D(E/A,T/A,S/A))}o.push(e),s.push(i)}return[o,s]}(t,i,r,n,o)}(o,r,h,u,c,s,_,d,f,o.center.lat,e.tileID.canonical),v=e.queryGeometry;return function(e,t,i){let r=1/0;Qa(i,t)&&(r=Wc(i,t[0]));for(let n=0;n<t.length;n++){const o=t[n],s=e[n];for(let e=0;e<o.length-1;e++){const t=o[e],n=[t,o[e+1],s[e+1],s[e],t];Ja(i,n)&&(r=Math.min(r,Wc(i,n)))}}return r!==1/0&&r}(y,x,v.isPointQuery()?v.screenBounds:v.screenGeometry)}},line:class LineStyleLayer extends StyleLayer{constructor(e){super(e,iu),this.gradientVersion=0}_handleSpecialPaintPropertyUpdate(e){if("line-gradient"===e){const e=this._transitionablePaint._values["line-gradient"].value.expression;this.stepInterpolant=e._styleExpression&&e._styleExpression.expression instanceof Di,this.gradientVersion=(this.gradientVersion+1)%Number.MAX_SAFE_INTEGER}}gradientExpression(){return this._transitionablePaint._values["line-gradient"].value.expression}widthExpression(){return this._transitionablePaint._values["line-width"].value.expression}recalculate(e,t){super.recalculate(e,t),this.paint._values["line-floorwidth"]=ru.possiblyEvaluate(this._transitioningPaint._values["line-width"].value,e)}createBucket(e){return new LineBucket(e)}getProgramIds(){return[this.paint.get("line-pattern").constantOr(1)?"linePattern":"line"]}getProgramConfiguration(e){return new ProgramConfiguration(this,e)}queryRadius(e){const t=e,i=nu(cl("line-width",this,t),cl("line-gap-width",this,t)),r=cl("line-offset",this,t);return i/2+Math.abs(r)+ul(this.paint.get("line-translate"))}queryIntersectsFeature(e,t,i,r,n,o){if(e.queryGeometry.isAboveHorizon)return!1;const s=hl(e.tilespaceGeometry,this.paint.get("line-translate"),this.paint.get("line-translate-anchor"),o.angle,e.pixelToTileUnitsFactor),a=e.pixelToTileUnitsFactor/2*nu(this.paint.get("line-width").evaluate(t,i),this.paint.get("line-gap-width").evaluate(t,i)),l=this.paint.get("line-offset").evaluate(t,i);return l&&(r=function(e,t){const i=[],r=new g(0,0);for(let n=0;n<e.length;n++){const o=e[n],s=[];for(let e=0;e<o.length;e++){const i=o[e],n=o[e+1],a=0===e?r:i.sub(o[e-1])._unit()._perp(),l=e===o.length-1?r:n.sub(i)._unit()._perp(),c=a._add(l)._unit();c._mult(1/(c.x*l.x+c.y*l.y)),s.push(c._mult(t)._add(i))}i.push(s)}return i}(r,l*e.pixelToTileUnitsFactor)),function(e,t,i){for(let r=0;r<t.length;r++){const n=t[r];if(e.length>=3)for(let t=0;t<n.length;t++)if(sl(e,n[t]))return!0;if(el(e,n,i))return!0}return!1}(s,r,a)}isTileClipped(){return!0}},symbol:SymbolStyleLayer,background:class BackgroundStyleLayer extends StyleLayer{constructor(e){super(e,Ih)}getProgramIds(){return[this.paint.get("background-pattern")?"backgroundPattern":"background"]}},raster:class RasterStyleLayer extends StyleLayer{constructor(e){super(e,Mh)}getProgramIds(){return["raster"]}},sky:class SkyLayer extends StyleLayer{constructor(e){super(e,Ph),this._updateColorRamp()}_handleSpecialPaintPropertyUpdate(e){"sky-gradient"===e?this._updateColorRamp():"sky-atmosphere-sun"!==e&&"sky-atmosphere-halo-color"!==e&&"sky-atmosphere-color"!==e&&"sky-atmosphere-sun-intensity"!==e||(this._skyboxInvalidated=!0)}_updateColorRamp(){this.colorRamp=Tl({expression:this._transitionablePaint._values["sky-gradient"].value.expression,evaluationKey:"skyRadialProgress"}),this.colorRampTexture&&(this.colorRampTexture.destroy(),this.colorRampTexture=null)}needsSkyboxCapture(e){if(this._skyboxInvalidated||!this.skyboxTexture||!this.skyboxGeometry)return!0;if(!this.paint.get("sky-atmosphere-sun")){const t=e.style.light.properties.get("position");return this._lightPosition.azimuthal!==t.azimuthal||this._lightPosition.polar!==t.polar}return!1}getCenter(e,t){if("atmosphere"===this.paint.get("sky-type")){const i=this.paint.get("sky-atmosphere-sun"),r=!i,n=e.style.light,o=n.properties.get("position");return r&&"viewport"===n.properties.get("anchor")&&H("The sun direction is attached to a light with viewport anchor, lighting may behave unexpectedly."),r?Dh(o.azimuthal,90-o.polar,t):Dh(i[0],90-i[1],t)}const i=this.paint.get("sky-gradient-center");return Dh(i[0],90-i[1],t)}is3D(){return!1}isSky(){return!0}markSkyboxValid(e){this._skyboxInvalidated=!1,this._lightPosition=e.style.light.properties.get("position")}hasOffscreenPass(){return!0}getProgramIds(){const e=this.paint.get("sky-type");return"atmosphere"===e?["skyboxCapture","skybox"]:"gradient"===e?["skyboxGradient"]:null}}};function kh(e){return"custom"===e.type?new CustomStyleLayer(e):new zh[e.type](e)}class Texture{constructor(e,t,i,r){this.context=e,this.format=i,this.texture=e.gl.createTexture(),this.update(t,r)}update(t,i,r){const{width:n,height:o}=t,{context:s}=this,{gl:a}=s,{HTMLImageElement:l,HTMLCanvasElement:c,HTMLVideoElement:u,ImageData:h,ImageBitmap:d}=e;if(a.bindTexture(a.TEXTURE_2D,this.texture),s.pixelStoreUnpackFlipY.set(!1),s.pixelStoreUnpack.set(1),s.pixelStoreUnpackPremultiplyAlpha.set(this.format===a.RGBA&&(!i||!1!==i.premultiply)),r||this.size&&this.size[0]===n&&this.size[1]===o){const{x:e,y:i}=r||{x:0,y:0};t instanceof l||t instanceof c||t instanceof u||t instanceof h||d&&t instanceof d?a.texSubImage2D(a.TEXTURE_2D,0,e,i,a.RGBA,a.UNSIGNED_BYTE,t):a.texSubImage2D(a.TEXTURE_2D,0,e,i,n,o,a.RGBA,a.UNSIGNED_BYTE,t.data)}else this.size=[n,o],t instanceof l||t instanceof c||t instanceof u||t instanceof h||d&&t instanceof d?a.texImage2D(a.TEXTURE_2D,0,this.format,this.format,a.UNSIGNED_BYTE,t):a.texImage2D(a.TEXTURE_2D,0,this.format,n,o,0,this.format,a.UNSIGNED_BYTE,t.data);this.useMipmap=Boolean(i&&i.useMipmap&&this.isSizePowerOfTwo()),this.useMipmap&&a.generateMipmap(a.TEXTURE_2D)}bind(e,t){const{context:i}=this,{gl:r}=i;r.bindTexture(r.TEXTURE_2D,this.texture),e!==this.filter&&(r.texParameteri(r.TEXTURE_2D,r.TEXTURE_MAG_FILTER,e),r.texParameteri(r.TEXTURE_2D,r.TEXTURE_MIN_FILTER,this.useMipmap?e===r.NEAREST?r.NEAREST_MIPMAP_NEAREST:r.LINEAR_MIPMAP_NEAREST:e),this.filter=e),t!==this.wrap&&(r.texParameteri(r.TEXTURE_2D,r.TEXTURE_WRAP_S,t),r.texParameteri(r.TEXTURE_2D,r.TEXTURE_WRAP_T,t),this.wrap=t)}isSizePowerOfTwo(){return this.size[0]===this.size[1]&&Math.log(this.size[0])/Math.LN2%1==0}destroy(){const{gl:e}=this.context;e.deleteTexture(this.texture),this.texture=null}}function Lh(e){const{userImage:t}=e;return!!(t&&t.render&&t.render())&&(e.data.replace(new Uint8Array(t.data.buffer)),!0)}class ImageManager extends Evented{constructor(){super(),this.images={},this.updatedImages={},this.callbackDispatchedThisFrame={},this.loaded=!1,this.requestors=[],this.patterns={},this.atlasImage=new RGBAImage({width:1,height:1}),this.dirty=!0}isLoaded(){return this.loaded}setLoaded(e){if(this.loaded!==e&&(this.loaded=e,e)){for(const{ids:e,callback:t}of this.requestors)this._notify(e,t);this.requestors=[]}}hasImage(e){return!!this.getImage(e)}getImage(e){return this.images[e]}addImage(e,t){this._validate(e,t)&&(this.images[e]=t)}_validate(e,t){let i=!0;return this._validateStretch(t.stretchX,t.data&&t.data.width)||(this.fire(new ErrorEvent(new Error(`Image "${e}" has invalid "stretchX" value`))),i=!1),this._validateStretch(t.stretchY,t.data&&t.data.height)||(this.fire(new ErrorEvent(new Error(`Image "${e}" has invalid "stretchY" value`))),i=!1),this._validateContent(t.content,t)||(this.fire(new ErrorEvent(new Error(`Image "${e}" has invalid "content" value`))),i=!1),i}_validateStretch(e,t){if(!e)return!0;let i=0;for(const r of e){if(r[0]<i||r[1]<r[0]||t<r[1])return!1;i=r[1]}return!0}_validateContent(e,t){return!(e&&(4!==e.length||e[0]<0||t.data.width<e[0]||e[1]<0||t.data.height<e[1]||e[2]<0||t.data.width<e[2]||e[3]<0||t.data.height<e[3]||e[2]<e[0]||e[3]<e[1]))}updateImage(e,t){t.version=this.images[e].version+1,this.images[e]=t,this.updatedImages[e]=!0}removeImage(e){const t=this.images[e];delete this.images[e],delete this.patterns[e],t.userImage&&t.userImage.onRemove&&t.userImage.onRemove()}listImages(){return Object.keys(this.images)}getImages(e,t){let i=!0;if(!this.isLoaded())for(const t of e)this.images[t]||(i=!1);this.isLoaded()||i?this._notify(e,t):this.requestors.push({ids:e,callback:t})}_notify(e,t){const i={};for(const t of e){this.images[t]||this.fire(new Event("styleimagemissing",{id:t}));const e=this.images[t];e?i[t]={data:e.data.clone(),pixelRatio:e.pixelRatio,sdf:e.sdf,version:e.version,stretchX:e.stretchX,stretchY:e.stretchY,content:e.content,hasRenderCallback:Boolean(e.userImage&&e.userImage.render)}:H(`Image "${t}" could not be loaded. Please make sure you have added the image with map.addImage() or a "sprite" property in your style. You can provide missing images by listening for the "styleimagemissing" map event.`)}t(null,i)}getPixelSize(){const{width:e,height:t}=this.atlasImage;return{width:e,height:t}}getPattern(e){const t=this.patterns[e],i=this.getImage(e);if(!i)return null;if(t&&t.position.version===i.version)return t.position;if(t)t.position.version=i.version;else{const t={w:i.data.width+2,h:i.data.height+2,x:0,y:0},r=new ImagePosition(t,i);this.patterns[e]={bin:t,position:r}}return this._updatePatternAtlas(),this.patterns[e].position}bind(e){const t=e.gl;this.atlasTexture?this.dirty&&(this.atlasTexture.update(this.atlasImage),this.dirty=!1):this.atlasTexture=new Texture(e,this.atlasImage,t.RGBA),this.atlasTexture&&this.atlasTexture.bind(t.LINEAR,t.CLAMP_TO_EDGE)}_updatePatternAtlas(){const e=[];for(const t in this.patterns)e.push(this.patterns[t].bin);const{w:t,h:i}=$u(e),r=this.atlasImage;r.resize({width:t||1,height:i||1});for(const e in this.patterns){const{bin:t}=this.patterns[e],i=t.x+1,n=t.y+1,o=this.images[e].data,s=o.width,a=o.height;RGBAImage.copy(o,r,{x:0,y:0},{x:i,y:n},{width:s,height:a}),RGBAImage.copy(o,r,{x:0,y:a-1},{x:i,y:n-1},{width:s,height:1}),RGBAImage.copy(o,r,{x:0,y:0},{x:i,y:n+a},{width:s,height:1}),RGBAImage.copy(o,r,{x:s-1,y:0},{x:i-1,y:n},{width:1,height:a}),RGBAImage.copy(o,r,{x:0,y:0},{x:i+s,y:n},{width:1,height:a})}this.dirty=!0}beginFrame(){this.callbackDispatchedThisFrame={}}dispatchRenderCallbacks(e){for(const t of e){if(this.callbackDispatchedThisFrame[t])continue;this.callbackDispatchedThisFrame[t]=!0;const e=this.images[t];Lh(e)&&this.updateImage(t,e)}}}const Bh=new Properties({anchor:new DataConstantProperty(yt.light.anchor),position:new class LightPositionProperty{constructor(){this.specification=yt.light.position}possiblyEvaluate(e,t){return function([e,t,i]){const r=b(t+90),n=b(i);return{x:e*Math.cos(r)*Math.sin(n),y:e*Math.sin(r)*Math.sin(n),z:e*Math.cos(n),azimuthal:t,polar:i}}(e.expression.evaluate(t))}interpolate(e,t,i){return{x:zi(e.x,t.x,i),y:zi(e.y,t.y,i),z:zi(e.z,t.z,i),azimuthal:zi(e.azimuthal,t.azimuthal,i),polar:zi(e.polar,t.polar,i)}}},color:new DataConstantProperty(yt.light.color),intensity:new DataConstantProperty(yt.light.intensity)});class Light extends Evented{constructor(e){super(),this._transitionable=new Transitionable(Bh),this.setLight(e),this._transitioning=this._transitionable.untransitioned()}getLight(){return this._transitionable.serialize()}setLight(e,t={}){if(!this._validate(An,e,t))for(const t in e){const i=e[t];N(t,"-transition")?this._transitionable.setTransition(t.slice(0,-11),i):this._transitionable.setValue(t,i)}}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning)}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e)}_validate(e,t,i){return(!i||!1!==i.validate)&&Bn(this,e.call(Tn,L({value:t,style:{glyphs:!0,sprite:!0},styleSpec:yt})))}}const Rh=new Properties({source:new DataConstantProperty(yt.terrain.source),exaggeration:new DataConstantProperty(yt.terrain.exaggeration)});let Fh=class Terrain extends Evented{constructor(e,t){super(),this._transitionable=new Transitionable(Rh),this.set(e),this._transitioning=this._transitionable.untransitioned(),this.drapeRenderMode=t}get(){return this._transitionable.serialize()}set(e){for(const t in e){const i=e[t];N(t,"-transition")?this._transitionable.setTransition(t.slice(0,-11),i):this._transitionable.setValue(t,i)}}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning)}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e)}};function Oh(e,t,i,r){const n=P(45,65,i),[o,s]=Uh(e,r),a=cs(t);let l=1-Math.min(1,Math.exp((a-o)/(s-o)*-6));return l*=l*l,l=Math.min(1,1.00747*l),l*n*e.alpha}function Uh(e,t){const i=.5/Math.tan(.5*t);return[e.range[0]+i,e.range[1]+i]}const Vh=new Properties({range:new DataConstantProperty(yt.fog.range),color:new DataConstantProperty(yt.fog.color),"high-color":new DataConstantProperty(yt.fog["high-color"]),"space-color":new DataConstantProperty(yt.fog["space-color"]),"horizon-blend":new DataConstantProperty(yt.fog["horizon-blend"]),"star-intensity":new DataConstantProperty(yt.fog["star-intensity"])});class Fog extends Evented{constructor(e,t){super(),this._transitionable=new Transitionable(Vh),this.set(e),this._transitioning=this._transitionable.untransitioned(),this._transform=t}get state(){const e=this._transform,t="globe"===e.projection.name,i=ga(e.zoom),r=this.properties.get("range"),n=[.5,3];return{range:t?[zi(n[0],r[0],i),zi(n[1],r[1],i)]:r,horizonBlend:this.properties.get("horizon-blend"),alpha:this.properties.get("color").a}}get(){return this._transitionable.serialize()}set(e,t={}){if(!this._validate(Mn,e,t)){for(const t of Object.keys(yt.fog))e&&void 0===e[t]&&(e[t]=yt.fog[t].default);for(const t in e){const i=e[t];N(t,"-transition")?this._transitionable.setTransition(t.slice(0,-11),i):this._transitionable.setValue(t,i)}}}getOpacity(e){if(!this._transform.projection.supportsFog)return 0;const t=this.properties&&this.properties.get("color")||1;return("globe"===this._transform.projection.name?1:P(45,65,e))*t.a}getOpacityAtLatLng(e,t){return this._transform.projection.supportsFog?function(e,t,i){const r=MercatorCoordinate.fromLngLat(t),n=i.elevation?i.elevation.getAtPointOrZero(r):0,o=[r.x,r.y,n];return ws(o,o,i.mercatorFogMatrix),Oh(e,o,i.pitch,i._fov)}(this.state,e,t):0}getFovAdjustedRange(e){return this._transform.projection.supportsFog?Uh(this.state,e):[0,1]}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning)}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e)}_validate(e,t,i){return(!i||!1!==i.validate)&&Bn(this,e.call(Tn,L({value:t,style:{glyphs:!0,sprite:!0},styleSpec:yt})))}}class ThrottledInvoker{constructor(e){this._callback=e,this._triggered=!1,"undefined"!=typeof MessageChannel&&(this._channel=new MessageChannel,this._channel.port2.onmessage=()=>{this._triggered=!1,this._callback()})}trigger(){this._triggered||(this._triggered=!0,this._channel?this._channel.port1.postMessage(!0):setTimeout((()=>{this._triggered=!1,this._callback()}),0))}remove(){this._channel=void 0,this._callback=()=>{}}}class Scheduler{constructor(){this.tasks={},this.taskQueue=[],j(["process"],this),this.invoker=new ThrottledInvoker(this.process),this.nextId=0}add(e,t){const i=this.nextId++,r=function({type:e,isSymbolTile:t,zoom:i}){return i=i||0,"message"===e?0:"maybePrepare"!==e||t?"parseTile"!==e||t?"parseTile"===e&&t?300-i:"maybePrepare"===e&&t?400-i:500:200-i:100-i}(t);if(0===r){J();try{e()}finally{}return{cancel:()=>{}}}return this.tasks[i]={fn:e,metadata:t,priority:r,id:i},this.taskQueue.push(i),this.invoker.trigger(),{cancel:()=>{delete this.tasks[i]}}}process(){J();try{if(this.taskQueue=this.taskQueue.filter((e=>!!this.tasks[e])),!this.taskQueue.length)return;const e=this.pick();if(null===e)return;const t=this.tasks[e];if(delete this.tasks[e],this.taskQueue.length&&this.invoker.trigger(),!t)return;t.fn()}finally{}}pick(){let e=null,t=1/0;for(let i=0;i<this.taskQueue.length;i++){const r=this.tasks[this.taskQueue[i]];r.priority<t&&(t=r.priority,e=i)}if(null===e)return null;const i=this.taskQueue[e];return this.taskQueue.splice(e,1),i}remove(){this.invoker.remove()}}class Dispatcher{constructor(e,t){this.workerPool=e,this.actors=[],this.currentActor=0,this.id=F();const i=this.workerPool.acquire(this.id);for(let e=0;e<i.length;e++){const r=new Dispatcher.Actor(i[e],t,this.id);r.name=`Worker ${e}`,this.actors.push(r)}this.ready=!1,this.broadcast("checkIfReady",null,(()=>{this.ready=!0}))}broadcast(e,t,i){z(this.actors,((i,r)=>{i.send(e,t,r)}),i=i||function(){})}getActor(){return this.currentActor=(this.currentActor+1)%this.actors.length,this.actors[this.currentActor]}remove(){this.actors.forEach((e=>{e.remove()})),this.actors=[],this.workerPool.release(this.id)}}function jh(e,t,i){return t*(Uo/(e.tileSize*Math.pow(2,i-e.tileID.overscaledZ)))}Dispatcher.Actor=class Actor{constructor(t,i,r){this.target=t,this.parent=i,this.mapId=r,this.callbacks={},this.cancelCallbacks={},j(["receive"],this),this.target.addEventListener("message",this.receive,!1),this.globalScope=J()?t:e,this.scheduler=new Scheduler}send(e,t,i,r,n=!1,o){const s=Math.round(1e18*Math.random()).toString(36).substring(0,10);i&&(i.metadata=o,this.callbacks[s]=i);const a=ee(this.globalScope)?void 0:[];return this.target.postMessage({id:s,type:e,hasCallback:!!i,targetMapId:r,mustQueue:n,sourceMapId:this.mapId,data:qn(t,a)},a),{cancel:()=>{i&&delete this.callbacks[s],this.target.postMessage({id:s,type:"<cancel>",targetMapId:r,sourceMapId:this.mapId})}}}receive(e){const t=e.data,i=t.id;if(i&&(!t.targetMapId||this.mapId===t.targetMapId))if("<cancel>"===t.type){const e=this.cancelCallbacks[i];delete this.cancelCallbacks[i],e&&e.cancel()}else if(t.mustQueue||J()){const e=this.callbacks[i];this.cancelCallbacks[i]=this.scheduler.add((()=>this.processTask(i,t)),e&&e.metadata||{type:"message"})}else this.processTask(i,t)}processTask(e,t){if("<response>"===t.type){const i=this.callbacks[e];delete this.callbacks[e],i&&(t.error?i(Zn(t.error)):i(null,Zn(t.data)))}else{const i=ee(this.globalScope)?void 0:[],r=t.hasCallback?(t,r)=>{delete this.cancelCallbacks[e],this.target.postMessage({id:e,type:"<response>",sourceMapId:this.mapId,error:t?qn(t):null,data:qn(r,i)},i)}:e=>{},n=Zn(t.data);if(this.parent[t.type])this.parent[t.type](t.sourceMapId,n,r);else if(this.parent.getWorkerSource){const e=t.type.split(".");this.parent.getWorkerSource(t.sourceMapId,e[0],n.source)[e[1]](n,r)}else r(new Error(`Could not find function ${t.type}`))}}remove(){this.scheduler.remove(),this.target.removeEventListener("message",this.receive,!1)}};class QueryGeometry{constructor(e,t,i,r){this.screenBounds=e,this.cameraPoint=t,this._screenRaycastCache={},this._cameraRaycastCache={},this.isAboveHorizon=i,this.screenGeometry=this.bufferedScreenGeometry(0),this.screenGeometryMercator=this._bufferedScreenMercator(0,r)}static createFromScreenPoints(e,t){let i,r;if(e instanceof g||"number"==typeof e[0]){const n=g.convert(e);i=[n],r=t.isPointAboveHorizon(n)}else{const n=g.convert(e[0]),o=g.convert(e[1]);i=[n,o],r=A(n,o).every((e=>t.isPointAboveHorizon(e)))}return new QueryGeometry(i,t.getCameraPoint(),r,t)}isPointQuery(){return 1===this.screenBounds.length}bufferedScreenGeometry(e){return A(this.screenBounds[0],1===this.screenBounds.length?this.screenBounds[0]:this.screenBounds[1],e)}bufferedCameraGeometry(e){const t=this.screenBounds[0],i=1===this.screenBounds.length?this.screenBounds[0].add(new g(1,1)):this.screenBounds[1],r=A(t,i,0,!1);return this.cameraPoint.y>i.y&&(this.cameraPoint.x>t.x&&this.cameraPoint.x<i.x?r.splice(3,0,this.cameraPoint):this.cameraPoint.x>=i.x?r[2]=this.cameraPoint:this.cameraPoint.x<=t.x&&(r[3]=this.cameraPoint)),function(e,t){const i=[];for(let r=0;r<e.length;r++){const n=D(r-1,-1,e.length-1),o=D(r+1,-1,e.length-1),s=e[r],a=e[o],l=e[n].sub(s).unit(),c=a.sub(s).unit(),u=c.angleWithSep(l.x,l.y),h=l.add(c).unit().mult(-1*t/Math.sin(u/2));i.push(s.add(h))}return i}(r,e)}bufferedCameraGeometryGlobe(e){const t=this.screenBounds[0],i=1===this.screenBounds.length?this.screenBounds[0].add(new g(1,1)):this.screenBounds[1],r=A(t,i,e),n=this.cameraPoint.clone();switch(3*((n.y>t.y)+(n.y>i.y))+((n.x>t.x)+(n.x>i.x))){case 0:r[0]=n,r[4]=n.clone();break;case 1:r.splice(1,0,n);break;case 2:r[1]=n;break;case 3:r.splice(4,0,n);break;case 5:r.splice(2,0,n);break;case 6:r[3]=n;break;case 7:r.splice(3,0,n);break;case 8:r[2]=n}return r}containsTile(e,t,i,r=0){const n=e.queryPadding/t._pixelsPerMercatorPixel+1,o=i?this._bufferedCameraMercator(n,t):this._bufferedScreenMercator(n,t);let s=e.tileID.wrap+(o.unwrapped?r:0);const a=o.polygon.map((t=>sh(e.tileTransform,t,s)));if(!al(a,0,0,Uo,Uo))return;s=e.tileID.wrap+(this.screenGeometryMercator.unwrapped?r:0);const l=this.screenGeometryMercator.polygon.map((t=>ah(e.tileTransform,t,s))),c=l.map((e=>new g(e[0],e[1]))),u=t.getFreeCameraOptions().position||new MercatorCoordinate(0,0,0),h=ah(e.tileTransform,u,s),d=l.map((e=>{const t=As(e,e,h);return xs(t,t),new Ray(h,t)})),p=jh(e,1,t.zoom)*t._pixelsPerMercatorPixel;return{queryGeometry:this,tilespaceGeometry:c,tilespaceRays:d,bufferedTilespaceGeometry:a,bufferedTilespaceBounds:(f=S(a),f.min.x=M(f.min.x,0,Uo),f.min.y=M(f.min.y,0,Uo),f.max.x=M(f.max.x,0,Uo),f.max.y=M(f.max.y,0,Uo),f),tile:e,tileID:e.tileID,pixelToTileUnitsFactor:p};var f}_bufferedScreenMercator(e,t){const i=qh(e);if(this._screenRaycastCache[i])return this._screenRaycastCache[i];{let r;return r="globe"===t.projection.name?this._projectAndResample(this.bufferedScreenGeometry(e),t):{polygon:this.bufferedScreenGeometry(e).map((e=>t.pointCoordinate3D(e))),unwrapped:!0},this._screenRaycastCache[i]=r,r}}_bufferedCameraMercator(e,t){const i=qh(e);if(this._cameraRaycastCache[i])return this._cameraRaycastCache[i];{let r;return r="globe"===t.projection.name?this._projectAndResample(this.bufferedCameraGeometryGlobe(e),t):{polygon:this.bufferedCameraGeometry(e).map((e=>t.pointCoordinate3D(e))),unwrapped:!0},this._cameraRaycastCache[i]=r,r}}_projectAndResample(e,t){const i=function(e,t){const i=Xo([],t.pixelMatrix,t.globeMatrix),r=[0,-Zs,0,1],n=[0,Zs,0,1],o=[0,0,0,1];zs(r,r,i),zs(n,n,i),zs(o,o,i);const s=new g(r[0]/r[3],r[1]/r[3]),a=new g(n[0]/n[3],n[1]/n[3]),l=sl(e,s)&&r[3]<o[3],c=sl(e,a)&&n[3]<o[3];if(!l&&!c)return null;const u=function(e,t,i){for(let r=1;r<e.length;r++){const n=Gh(t.pointCoordinate3D(e[r-1]).x),o=Gh(t.pointCoordinate3D(e[r]).x);if(i<0){if(n<o)return{idx:r,t:-n/(o-1-n)}}else if(o<n)return{idx:r,t:(1-n)/(o+1-n)}}return null}(e,t,l?-1:1);if(!u)return null;const{idx:h,t:d}=u;let p=h>1?Nh(e.slice(0,h),t):[],f=h<e.length?Nh(e.slice(h),t):[];p=p.map((e=>new g(Gh(e.x),e.y))),f=f.map((e=>new g(Gh(e.x),e.y)));const m=[...p];0===m.length&&m.push(f[f.length-1]);const _=zi(m[m.length-1].y,(0===f.length?p[0]:f[0]).y,d);let y;return y=l?[new g(0,_),new g(0,0),new g(1,0),new g(1,_)]:[new g(1,_),new g(1,1),new g(0,1),new g(0,_)],m.push(...y),0===f.length?m.push(p[0]):m.push(...f),{polygon:m.map((e=>new MercatorCoordinate(e.x,e.y))),unwrapped:!1}}(e,t);if(i)return i;const r=function(e,t){let i=!1,r=-1/0,n=0;for(let t=0;t<e.length-1;t++)e[t].x>r&&(r=e[t].x,n=t);for(let t=0;t<e.length-1;t++){const r=(n+t)%(e.length-1),o=e[r],s=e[r+1];Math.abs(o.x-s.x)>.5&&(o.x<s.x?(o.x+=1,0===r&&(e[e.length-1].x+=1)):(s.x+=1,r+1===e.length-1&&(e[0].x+=1)),i=!0)}const o=za(t.center.lng);return i&&o<Math.abs(o-1)&&e.forEach((e=>{e.x-=1})),{polygon:e,unwrapped:i}}(Nh(e,t).map((e=>new g(Gh(e.x),e.y))),t);return{polygon:r.polygon.map((e=>new MercatorCoordinate(e.x,e.y))),unwrapped:r.unwrapped}}}function Nh(e,t){return ja(e,(e=>{const i=t.pointCoordinate3D(e);e.x=i.x,e.y=i.y}),1/256)}function Gh(e){return e<0?1+e%1:e%1}function qh(e){return 100*e|0}function Zh(e,t,i,r,n){const o=function(i,r){if(i)return n(i);if(r){e.url&&r.tiles&&e.tiles&&delete e.tiles;const i=B(L(r,e),["tiles","minzoom","maxzoom","attribution","mapbox_logo","bounds","scheme","tileSize","encoding"]);r.vector_layers&&(i.vectorLayers=r.vector_layers,i.vectorLayerIds=i.vectorLayers.map((e=>e.id))),i.tiles=t.canonicalizeTileset(i,e.url),n(null,i)}};return e.url?ye(t.transformRequest(t.normalizeSourceURL(e.url,null,i,r),me.Source),o):it.frame((()=>o(null,e)))}class TileBounds{constructor(e,t,i){this.bounds=LngLatBounds.convert(this.validateBounds(e)),this.minzoom=t||0,this.maxzoom=i||24}validateBounds(e){return Array.isArray(e)&&4===e.length?[Math.max(-180,e[0]),Math.max(-90,e[1]),Math.min(180,e[2]),Math.min(90,e[3])]:[-180,-90,180,90]}contains(e){const t=Math.pow(2,e.z),i=Math.floor(za(this.bounds.getWest())*t),r=Math.floor(ka(this.bounds.getNorth())*t),n=Math.ceil(za(this.bounds.getEast())*t),o=Math.ceil(ka(this.bounds.getSouth())*t);return e.x>=i&&e.x<n&&e.y>=r&&e.y<o}}class DictionaryCoder{constructor(e){this._stringToNumber={},this._numberToString=[];for(let t=0;t<e.length;t++){const i=e[t];this._stringToNumber[i]=t,this._numberToString[t]=i}}encode(e){return this._stringToNumber[e]}decode(e){return this._numberToString[e]}}const $h=["tile","layer","source","sourceLayer","state"];class Feature{constructor(e,t,i,r,n){this.type="Feature",this._vectorTileFeature=e,this._z=t,this._x=i,this._y=r,this.properties=e.properties,this.id=n}get geometry(){return void 0===this._geometry&&(this._geometry=this._vectorTileFeature.toGeoJSON(this._x,this._y,this._z).geometry),this._geometry}set geometry(e){this._geometry=e}toJSON(){const e={type:"Feature",state:void 0,geometry:this.geometry,properties:this.properties};void 0!==this.id&&(e.id=this.id);for(const t of $h)void 0!==this[t]&&(e[t]=this[t]);return e}}const Wh=32,Hh=33,Xh=new Uint16Array(8184);for(let e=0;e<2046;e++){let t=e+2,i=0,r=0,n=0,o=0,s=0,a=0;for(1&t?n=o=s=Wh:i=r=a=Wh;(t>>=1)>1;){const e=i+n>>1,l=r+o>>1;1&t?(n=i,o=r,i=s,r=a):(i=n,r=o,n=s,o=a),s=e,a=l}const l=4*e;Xh[l+0]=i,Xh[l+1]=r,Xh[l+2]=n,Xh[l+3]=o}const Kh=new Uint16Array(2178),Jh=new Uint8Array(1089),Yh=new Uint16Array(1089);function Qh(e){return 0===e?-.03125:32===e?.03125:0}var ed=po([{name:"a_pos",type:"Int16",components:2},{name:"a_texture_pos",type:"Int16",components:2}]);const td={type:2,extent:Uo,loadGeometry:()=>[[new g(0,0),new g(Uo+1,0),new g(Uo+1,Uo+1),new g(0,Uo+1),new g(0,0)]]};class Tile{constructor(e,t,i,r,n){this.tileID=e,this.uid=F(),this.uses=0,this.tileSize=t,this.tileZoom=i,this.buckets={},this.expirationTime=null,this.queryPadding=0,this.hasSymbolBuckets=!1,this.hasRTLText=!1,this.dependencies={},this.isRaster=n,this.expiredRequestCount=0,this.state="loading",r&&r.transform&&(this.projection=r.transform.projection)}registerFadeDuration(e){const t=e+this.timeAdded;t<it.now()||this.fadeEndTime&&t<this.fadeEndTime||(this.fadeEndTime=t)}wasRequested(){return"errored"===this.state||"loaded"===this.state||"reloading"===this.state}get tileTransform(){return this._tileTransform||(this._tileTransform=nh(this.tileID.canonical,this.projection)),this._tileTransform}loadVectorData(e,t,i){if(this.unloadVectorData(),this.state="loaded",e){e.featureIndex&&(this.latestFeatureIndex=e.featureIndex,e.rawTileData?(this.latestRawTileData=e.rawTileData,this.latestFeatureIndex.rawTileData=e.rawTileData):this.latestRawTileData&&(this.latestFeatureIndex.rawTileData=this.latestRawTileData)),this.collisionBoxArray=e.collisionBoxArray,this.buckets=function(e,t){const i={};if(!t)return i;for(const r of e){const e=r.layerIds.map((e=>t.getLayer(e))).filter(Boolean);if(0!==e.length){r.layers=e,r.stateDependentLayerIds&&(r.stateDependentLayers=r.stateDependentLayerIds.map((t=>e.filter((e=>e.id===t))[0])));for(const t of e)i[t.id]=r}}return i}(e.buckets,t.style),this.hasSymbolBuckets=!1;for(const e in this.buckets){const t=this.buckets[e];if(t instanceof SymbolBucket){if(this.hasSymbolBuckets=!0,!i)break;t.justReloaded=!0}}if(this.hasRTLText=!1,this.hasSymbolBuckets)for(const e in this.buckets){const t=this.buckets[e];if(t instanceof SymbolBucket&&t.hasRTLText){this.hasRTLText=!0,co.isLoading()||co.isLoaded()||"deferred"!==ao()||lo();break}}this.queryPadding=0;for(const e in this.buckets){const i=this.buckets[e];this.queryPadding=Math.max(this.queryPadding,t.style.getLayer(e).queryRadius(i))}e.imageAtlas&&(this.imageAtlas=e.imageAtlas),e.glyphAtlasImage&&(this.glyphAtlasImage=e.glyphAtlasImage),e.lineAtlas&&(this.lineAtlas=e.lineAtlas)}else this.collisionBoxArray=new CollisionBoxArray}unloadVectorData(){if(this.hasData()){for(const e in this.buckets)this.buckets[e].destroy();this.buckets={},this.imageAtlas&&(this.imageAtlas=null),this.lineAtlas&&(this.lineAtlas=null),this.imageAtlasTexture&&this.imageAtlasTexture.destroy(),this.glyphAtlasTexture&&this.glyphAtlasTexture.destroy(),this.lineAtlasTexture&&this.lineAtlasTexture.destroy(),this._tileBoundsBuffer&&(this._tileBoundsBuffer.destroy(),this._tileBoundsIndexBuffer.destroy(),this._tileBoundsSegments.destroy(),this._tileBoundsBuffer=null),this._tileDebugBuffer&&(this._tileDebugBuffer.destroy(),this._tileDebugSegments.destroy(),this._tileDebugBuffer=null),this._tileDebugIndexBuffer&&(this._tileDebugIndexBuffer.destroy(),this._tileDebugIndexBuffer=null),this._globeTileDebugBorderBuffer&&(this._globeTileDebugBorderBuffer.destroy(),this._globeTileDebugBorderBuffer=null),this._tileDebugTextBuffer&&(this._tileDebugTextBuffer.destroy(),this._tileDebugTextSegments.destroy(),this._tileDebugTextIndexBuffer.destroy(),this._tileDebugTextBuffer=null),this._globeTileDebugTextBuffer&&(this._globeTileDebugTextBuffer.destroy(),this._globeTileDebugTextBuffer=null),this.latestFeatureIndex=null,this.state="unloaded"}}getBucket(e){return this.buckets[e.id]}upload(e){for(const t in this.buckets){const i=this.buckets[t];i.uploadPending()&&i.upload(e)}const t=e.gl;this.imageAtlas&&!this.imageAtlas.uploaded&&(this.imageAtlasTexture=new Texture(e,this.imageAtlas.image,t.RGBA),this.imageAtlas.uploaded=!0),this.glyphAtlasImage&&(this.glyphAtlasTexture=new Texture(e,this.glyphAtlasImage,t.ALPHA),this.glyphAtlasImage=null),this.lineAtlas&&!this.lineAtlas.uploaded&&(this.lineAtlasTexture=new Texture(e,this.lineAtlas.image,t.ALPHA),this.lineAtlas.uploaded=!0)}prepare(e){this.imageAtlas&&this.imageAtlas.patchUpdatedImages(e,this.imageAtlasTexture)}queryRenderedFeatures(e,t,i,r,n,o,s,a){return this.latestFeatureIndex&&this.latestFeatureIndex.rawTileData?this.latestFeatureIndex.query({tileResult:r,pixelPosMatrix:s,transform:o,params:n,tileTransform:this.tileTransform},e,t,i):{}}querySourceFeatures(e,t){const i=this.latestFeatureIndex;if(!i||!i.rawTileData)return;const r=i.loadVTLayers(),n=t?t.sourceLayer:"",o=r._geojsonTileLayer||r[n];if(!o)return;const s=Xr(t&&t.filter),{z:a,x:l,y:c}=this.tileID.canonical,u={z:a,x:l,y:c};for(let t=0;t<o.length;t++){const r=o.feature(t);if(s.needGeometry){const e=Ha(r,!0);if(!s.filter(new EvaluationParameters(this.tileID.overscaledZ),e,this.tileID.canonical))continue}else if(!s.filter(new EvaluationParameters(this.tileID.overscaledZ),r))continue;const h=i.getId(r,n),d=new Feature(r,a,l,c,h);d.tile=u,e.push(d)}}hasData(){return"loaded"===this.state||"reloading"===this.state||"expired"===this.state}patternsLoaded(){return!!this.imageAtlas&&!!Object.keys(this.imageAtlas.patternPositions).length}setExpiryData(e){const t=this.expirationTime;if(e.cacheControl){const t=Y(e.cacheControl);t["max-age"]&&(this.expirationTime=Date.now()+1e3*t["max-age"])}else e.expires&&(this.expirationTime=new Date(e.expires).getTime());if(this.expirationTime){const e=Date.now();let i=!1;if(this.expirationTime>e)i=!1;else if(t)if(this.expirationTime<t)i=!0;else{const r=this.expirationTime-t;r?this.expirationTime=e+Math.max(r,3e4):i=!0}else i=!0;i?(this.expiredRequestCount++,this.state="expired"):this.expiredRequestCount=0}}getExpiryTimeout(){if(this.expirationTime)return this.expiredRequestCount?1e3*(1<<Math.min(this.expiredRequestCount-1,31)):Math.min(this.expirationTime-(new Date).getTime(),Math.pow(2,31)-1)}setFeatureState(e,t){if(!this.latestFeatureIndex||!this.latestFeatureIndex.rawTileData||0===Object.keys(e).length||!t)return;const i=this.latestFeatureIndex.loadVTLayers(),r=t.style.listImages();for(const n in this.buckets){if(!t.style.hasLayer(n))continue;const o=this.buckets[n],s=o.layers[0].sourceLayer||"_geojsonTileLayer",a=i[s],l=e[s];if(!a||!l||0===Object.keys(l).length)continue;if(o.update(l,a,r,this.imageAtlas&&this.imageAtlas.patternPositions||{}),o instanceof LineBucket||o instanceof FillBucket){const e=t.style._getSourceCache(o.layers[0].source);t._terrain&&t._terrain.enabled&&e&&o.programConfigurations.needsUpload&&t._terrain._clearRenderCacheForTile(e.id,this.tileID)}const c=t&&t.style&&t.style.getLayer(n);c&&(this.queryPadding=Math.max(this.queryPadding,c.queryRadius(o)))}}holdingForFade(){return void 0!==this.symbolFadeHoldUntil}symbolFadeFinished(){return!this.symbolFadeHoldUntil||this.symbolFadeHoldUntil<it.now()}clearFadeHold(){this.symbolFadeHoldUntil=void 0}setHoldDuration(e){this.symbolFadeHoldUntil=it.now()+e}setTexture(e,t){const i=t.context,r=i.gl;this.texture=this.texture||t.getTileTexture(e.width),this.texture?this.texture.update(e,{useMipmap:!0}):(this.texture=new Texture(i,e,r.RGBA,{useMipmap:!0}),this.texture.bind(r.LINEAR,r.CLAMP_TO_EDGE))}setDependencies(e,t){const i={};for(const e of t)i[e]=!0;this.dependencies[e]=i}hasDependency(e,t){for(const i of e){const e=this.dependencies[i];if(e)for(const i of t)if(e[i])return!0}return!1}clearQueryDebugViz(){}_makeDebugTileBoundsBuffers(e,t){if(!t||"mercator"===t.name||this._tileDebugBuffer)return;const i=Wa(td,this.tileID.canonical,this.tileTransform)[0],r=new StructArrayLayout2i4,n=new StructArrayLayout1ui2;for(let e=0;e<i.length;e++){const{x:t,y:o}=i[e];r.emplaceBack(t,o),n.emplaceBack(e)}n.emplaceBack(0),this._tileDebugIndexBuffer=e.createIndexBuffer(n),this._tileDebugBuffer=e.createVertexBuffer(r,Ns.members),this._tileDebugSegments=SegmentVector.simpleSegment(0,0,r.length,n.length)}_makeTileBoundsBuffers(e,t){if(this._tileBoundsBuffer||!t||"mercator"===t.name)return;const i=Wa(td,this.tileID.canonical,this.tileTransform)[0];let r,n;if(this.isRaster){const e=function(e,t){const i=nh(e,t),r=Math.pow(2,e.z);for(let n=0;n<Hh;n++)for(let o=0;o<Hh;o++){const s=Ba((e.x+(o+Qh(o))/Wh)/r),a=Ra((e.y+(n+Qh(n))/Wh)/r),l=t.project(s,a),c=n*Hh+o;Kh[2*c+0]=Math.round((l.x*i.scale-i.x)*Uo),Kh[2*c+1]=Math.round((l.y*i.scale-i.y)*Uo)}Jh.fill(0),Yh.fill(0);for(let e=2045;e>=0;e--){const t=4*e,i=Xh[t+0],r=Xh[t+1],n=Xh[t+2],o=Xh[t+3],s=i+n>>1,a=r+o>>1,l=s+a-r,c=a+i-s,u=r*Hh+i,h=o*Hh+n,d=a*Hh+s,p=Math.hypot((Kh[2*u+0]+Kh[2*h+0])/2-Kh[2*d+0],(Kh[2*u+1]+Kh[2*h+1])/2-Kh[2*d+1])>=16;Jh[d]=Jh[d]||(p?1:0),e<1022&&(Jh[d]=Jh[d]||Jh[(r+c>>1)*Hh+(i+l>>1)]||Jh[(o+c>>1)*Hh+(n+l>>1)])}const n=new StructArrayLayout4i8,o=new StructArrayLayout3ui6;let s=0;function a(e,t){const i=t*Hh+e;return 0===Yh[i]&&(n.emplaceBack(Kh[2*i+0],Kh[2*i+1],e*Uo/Wh,t*Uo/Wh),Yh[i]=++s),Yh[i]-1}function l(e,t,i,r,n,s){const c=e+i>>1,u=t+r>>1;if(Math.abs(e-n)+Math.abs(t-s)>1&&Jh[u*Hh+c])l(n,s,e,t,c,u),l(i,r,n,s,c,u);else{const l=a(e,t),c=a(i,r),u=a(n,s);o.emplaceBack(l,c,u)}}return l(0,0,Wh,Wh,Wh,0),l(Wh,Wh,0,0,0,Wh),{vertices:n,indices:o}}(this.tileID.canonical,t);r=e.vertices,n=e.indices}else{r=new StructArrayLayout4i8,n=new StructArrayLayout3ui6;for(const{x:e,y:t}of i)r.emplaceBack(e,t,0,0);const e=tc(r.int16,void 0,4);for(let t=0;t<e.length;t+=3)n.emplaceBack(e[t],e[t+1],e[t+2])}this._tileBoundsBuffer=e.createVertexBuffer(r,ed.members),this._tileBoundsIndexBuffer=e.createIndexBuffer(n),this._tileBoundsSegments=SegmentVector.simpleSegment(0,0,r.length,n.length)}_makeGlobeTileDebugBuffers(e,t){const i=t.projection;if(!i||"globe"!==i.name||t.freezeTileCoverage)return;const r=this.tileID.canonical,n=pa(ra(r,t)),o=ga(t.zoom);let s;o>0&&(s=Ho(new Float64Array(16),t.globeMatrix)),this._makeGlobeTileDebugBorderBuffer(e,r,t,n,s,o),this._makeGlobeTileDebugTextBuffer(e,r,t,n,s,o)}_globePoint(e,t,i,r,n,o,s){let a=ua(e,t,i);if(o){const n=1<<i.z,l=za(r.center.lng),c=ka(r.center.lat),u=(i.x+.5)/n-l;let h=0;u>.5?h=-1:u<-.5&&(h=1);let d=(e/Uo+i.x)/n+h,p=(t/Uo+i.y)/n;d=(d-l)*r._pixelsPerMercatorPixel+l,p=(p-c)*r._pixelsPerMercatorPixel+c;const f=[d*r.worldSize,p*r.worldSize,0];ws(f,f,o),a=ia(a,f,s)}return ws(a,a,n)}_makeGlobeTileDebugBorderBuffer(e,t,i,r,n,o){const s=new StructArrayLayout2i4,a=new StructArrayLayout1ui2,l=new StructArrayLayout3i6,c=(e,c,u,h,d)=>{const p=(u-e)/(d-1),f=(h-c)/(d-1),m=s.length;for(let u=0;u<d;u++){const h=e+u*p,d=c+u*f;s.emplaceBack(h,d);const _=this._globePoint(h,d,t,i,r,n,o);l.emplaceBack(_[0],_[1],_[2]),a.emplaceBack(m+u)}},u=Uo;c(0,0,u,0,16),c(u,0,u,u,16),c(u,u,0,u,16),c(0,u,0,0,16),this._tileDebugIndexBuffer=e.createIndexBuffer(a),this._tileDebugBuffer=e.createVertexBuffer(s,Ns.members),this._globeTileDebugBorderBuffer=e.createVertexBuffer(l,js.members),this._tileDebugSegments=SegmentVector.simpleSegment(0,0,s.length,a.length)}_makeGlobeTileDebugTextBuffer(e,t,i,r,n,o){const s=Uo/4,a=new StructArrayLayout2i4,l=new StructArrayLayout3ui6,c=new StructArrayLayout3i6,u=25;l.reserve(32),a.reserve(u),c.reserve(u);const h=(e,t)=>u*e+t;for(let e=0;e<u;e++){const l=e*s;for(let e=0;e<u;e++){const u=e*s;a.emplaceBack(u,l);const h=this._globePoint(u,l,t,i,r,n,o);c.emplaceBack(h[0],h[1],h[2])}}for(let e=0;e<4;e++)for(let t=0;t<4;t++){const i=h(e,t),r=h(e,t+1),n=h(e+1,t),o=h(e+1,t+1);l.emplaceBack(i,r,n),l.emplaceBack(n,r,o)}this._tileDebugTextIndexBuffer=e.createIndexBuffer(l),this._tileDebugTextBuffer=e.createVertexBuffer(a,Ns.members),this._globeTileDebugTextBuffer=e.createVertexBuffer(c,js.members),this._tileDebugTextSegments=SegmentVector.simpleSegment(0,0,u,32)}}class SourceFeatureState{constructor(){this.state={},this.stateChanges={},this.deletedStates={}}updateState(e,t,i){const r=String(t);if(this.stateChanges[e]=this.stateChanges[e]||{},this.stateChanges[e][r]=this.stateChanges[e][r]||{},L(this.stateChanges[e][r],i),null===this.deletedStates[e]){this.deletedStates[e]={};for(const t in this.state[e])t!==r&&(this.deletedStates[e][t]=null)}else if(this.deletedStates[e]&&null===this.deletedStates[e][r]){this.deletedStates[e][r]={};for(const t in this.state[e][r])i[t]||(this.deletedStates[e][r][t]=null)}else for(const t in i)this.deletedStates[e]&&this.deletedStates[e][r]&&null===this.deletedStates[e][r][t]&&delete this.deletedStates[e][r][t]}removeFeatureState(e,t,i){if(null===this.deletedStates[e])return;const r=String(t);if(this.deletedStates[e]=this.deletedStates[e]||{},i&&void 0!==t)null!==this.deletedStates[e][r]&&(this.deletedStates[e][r]=this.deletedStates[e][r]||{},this.deletedStates[e][r][i]=null);else if(void 0!==t)if(this.stateChanges[e]&&this.stateChanges[e][r])for(i in this.deletedStates[e][r]={},this.stateChanges[e][r])this.deletedStates[e][r][i]=null;else this.deletedStates[e][r]=null;else this.deletedStates[e]=null}getState(e,t){const i=String(t),r=L({},(this.state[e]||{})[i],(this.stateChanges[e]||{})[i]);if(null===this.deletedStates[e])return{};if(this.deletedStates[e]){const i=this.deletedStates[e][t];if(null===i)return{};for(const e in i)delete r[e]}return r}initializeTileState(e,t){e.setFeatureState(this.state,t)}coalesceChanges(e,t){const i={};for(const e in this.stateChanges){this.state[e]=this.state[e]||{};const t={};for(const i in this.stateChanges[e])this.state[e][i]||(this.state[e][i]={}),L(this.state[e][i],this.stateChanges[e][i]),t[i]=this.state[e][i];i[e]=t}for(const e in this.deletedStates){this.state[e]=this.state[e]||{};const t={};if(null===this.deletedStates[e])for(const i in this.state[e])t[i]={},this.state[e][i]={};else for(const i in this.deletedStates[e]){if(null===this.deletedStates[e][i])this.state[e][i]={};else if(this.state[e][i])for(const t of Object.keys(this.deletedStates[e][i]))delete this.state[e][i][t];t[i]=this.state[e][i]}i[e]=i[e]||{},L(i[e],t)}if(this.stateChanges={},this.deletedStates={},0!==Object.keys(i).length)for(const r in e)e[r].setFeatureState(i,t)}}class MipLevel{constructor(e){this.size=e,this.minimums=[],this.maximums=[],this.leaves=[]}getElevation(e,t){const i=this.toIdx(e,t);return{min:this.minimums[i],max:this.maximums[i]}}isLeaf(e,t){return this.leaves[this.toIdx(e,t)]}toIdx(e,t){return t*this.size+e}}function id(e,t,i,r){let n=0,o=Number.MAX_VALUE;for(let s=0;s<3;s++)if(Math.abs(r[s])<1e-15){if(i[s]<e[s]||i[s]>t[s])return null}else{const a=1/r[s];let l=(e[s]-i[s])*a,c=(t[s]-i[s])*a;if(l>c){const e=l;l=c,c=e}if(l>n&&(n=l),c<o&&(o=c),n>o)return null}return n}function rd(e,t,i,r,n,o,s,a,l,c,u){const h=r-e,d=n-t,p=o-i,f=s-e,m=a-t,_=l-i,g=u[1]*_-u[2]*m,y=u[2]*f-u[0]*_,x=u[0]*m-u[1]*f,v=h*g+d*y+p*x;if(Math.abs(v)<1e-15)return null;const b=1/v,w=c[0]-e,E=c[1]-t,T=c[2]-i,S=(w*g+E*y+T*x)*b;if(S<0||S>1)return null;const A=E*p-T*d,C=T*h-w*p,I=w*d-E*h,M=(u[0]*A+u[1]*C+u[2]*I)*b;return M<0||S+M>1?null:(f*A+m*C+_*I)*b}function nd(e,t,i){return(e-t)/(i-t)}function od(e,t,i,r,n,o,s,a,l){const c=1<<i,u=o-r,h=s-n,d=(e+1)/c*u+r,p=(t+0)/c*h+n,f=(t+1)/c*h+n;a[0]=(e+0)/c*u+r,a[1]=p,l[0]=d,l[1]=f}class DemMinMaxQuadTree{constructor(e){if(this.maximums=[],this.minimums=[],this.leaves=[],this.childOffsets=[],this.nodeCount=0,this.dem=e,this._siblingOffset=[[0,0],[1,0],[0,1],[1,1]],!this.dem)return;const t=function(e){const t=Math.ceil(Math.log2(e.dim/8)),i=[];let r=Math.ceil(Math.pow(2,t));const n=1/r,o=(e,t,i,r,n)=>{const o=r?1:0,s=(e+1)*i-o,a=t*i,l=(t+1)*i-o;n[0]=e*i,n[1]=a,n[2]=s,n[3]=l};let s=new MipLevel(r);const a=[];for(let t=0;t<r*r;t++){o(t%r,Math.floor(t/r),n,!1,a);const i=ad(a[0],a[1],e),l=ad(a[2],a[1],e),c=ad(a[2],a[3],e),u=ad(a[0],a[3],e);s.minimums.push(Math.min(i,l,c,u)),s.maximums.push(Math.max(i,l,c,u)),s.leaves.push(1)}for(i.push(s),r/=2;r>=1;r/=2){const e=i[i.length-1];s=new MipLevel(r);for(let t=0;t<r*r;t++){o(t%r,Math.floor(t/r),2,!0,a);const i=e.getElevation(a[0],a[1]),n=e.getElevation(a[2],a[1]),l=e.getElevation(a[2],a[3]),c=e.getElevation(a[0],a[3]),u=e.isLeaf(a[0],a[1]),h=e.isLeaf(a[2],a[1]),d=e.isLeaf(a[2],a[3]),p=e.isLeaf(a[0],a[3]),f=Math.min(i.min,n.min,l.min,c.min),m=Math.max(i.max,n.max,l.max,c.max),_=u&&h&&d&&p;s.maximums.push(m),s.minimums.push(f),s.leaves.push(m-f<=5&&_?1:0)}i.push(s)}return i}(this.dem),i=t.length-1,r=t[i];this._addNode(r.minimums[0],r.maximums[0],r.leaves[0]),this._construct(t,0,0,i,0)}raycastRoot(e,t,i,r,n,o,s=1){return id([e,t,-100],[i,r,this.maximums[0]*s],n,o)}raycast(e,t,i,r,n,o,s=1){if(!this.nodeCount)return null;const a=this.raycastRoot(e,t,i,r,n,o,s);if(null==a)return null;const l=[],c=[],u=[],h=[],d=[{idx:0,t:a,nodex:0,nodey:0,depth:0}];for(;d.length>0;){const{idx:a,t:p,nodex:f,nodey:m,depth:_}=d.pop();if(this.leaves[a]){od(f,m,_,e,t,i,r,u,h);const a=1<<_,l=(f+0)/a,c=(f+1)/a,d=(m+0)/a,g=(m+1)/a,y=ad(l,d,this.dem)*s,x=ad(c,d,this.dem)*s,v=ad(c,g,this.dem)*s,b=ad(l,g,this.dem)*s,w=rd(u[0],u[1],y,h[0],u[1],x,h[0],h[1],v,n,o),E=rd(h[0],h[1],v,u[0],h[1],b,u[0],u[1],y,n,o),T=Math.min(null!==w?w:Number.MAX_VALUE,null!==E?E:Number.MAX_VALUE);if(T!==Number.MAX_VALUE)return T;{const e=gs([],n,o,p);if(sd(y,x,b,v,nd(e[0],u[0],h[0]),nd(e[1],u[1],h[1]))>=e[2])return p}continue}let g=0;for(let d=0;d<this._siblingOffset.length;d++){od((f<<1)+this._siblingOffset[d][0],(m<<1)+this._siblingOffset[d][1],_+1,e,t,i,r,u,h),u[2]=-100,h[2]=this.maximums[this.childOffsets[a]+d]*s;const p=id(u,h,n,o);if(null!=p){const e=p;l[d]=e;let t=!1;for(let i=0;i<g&&!t;i++)e>=l[c[i]]&&(c.splice(i,0,d),t=!0);t||(c[g]=d),g++}}for(let e=0;e<g;e++){const t=c[e];d.push({idx:this.childOffsets[a]+t,t:l[t],nodex:(f<<1)+this._siblingOffset[t][0],nodey:(m<<1)+this._siblingOffset[t][1],depth:_+1})}}return null}_addNode(e,t,i){return this.minimums.push(e),this.maximums.push(t),this.leaves.push(i),this.childOffsets.push(0),this.nodeCount++}_construct(e,t,i,r,n){if(1===e[r].isLeaf(t,i))return;this.childOffsets[n]||(this.childOffsets[n]=this.nodeCount);const o=r-1,s=e[o];let a=0,l=0;for(let e=0;e<this._siblingOffset.length;e++){const r=2*t+this._siblingOffset[e][0],n=2*i+this._siblingOffset[e][1],o=s.getElevation(r,n),c=s.isLeaf(r,n),u=this._addNode(o.min,o.max,c);c&&(a|=1<<e),l||(l=u)}for(let r=0;r<this._siblingOffset.length;r++)a&1<<r||this._construct(e,2*t+this._siblingOffset[r][0],2*i+this._siblingOffset[r][1],o,l+r)}}function sd(e,t,i,r,n,o){return zi(zi(e,i,o),zi(t,r,o),n)}function ad(e,t,i){const r=i.dim,n=M(e*r-.5,0,r-1),o=M(t*r-.5,0,r-1),s=Math.floor(n),a=Math.floor(o),l=Math.min(s+1,r-1),c=Math.min(a+1,r-1);return sd(i.get(s,a),i.get(l,a),i.get(s,c),i.get(l,c),n-s,o-a)}const ld={mapbox:[6553.6,25.6,.1,1e4],terrarium:[256,1,1/256,32768]};function cd(e,t,i){return(256*e*256+256*t+i)/10-1e4}function ud(e,t,i){return 256*e+t+i/256-32768}class DEMData{get tree(){return this._tree||this._buildQuadTree(),this._tree}constructor(e,t,i,r=!1,n=!1){if(this.uid=e,t.height!==t.width)throw new RangeError("DEM tiles must be square");if(i&&"mapbox"!==i&&"terrarium"!==i)return H(`"${i}" is not a valid encoding type. Valid types include "mapbox" and "terrarium".`);this.stride=t.height;const o=this.dim=t.height-2,s=new Uint32Array(t.data.buffer);if(this.pixels=new Uint8Array(t.data.buffer),this.encoding=i||"mapbox",this.borderReady=r,!r){for(let e=0;e<o;e++)s[this._idx(-1,e)]=s[this._idx(0,e)],s[this._idx(o,e)]=s[this._idx(o-1,e)],s[this._idx(e,-1)]=s[this._idx(e,0)],s[this._idx(e,o)]=s[this._idx(e,o-1)];s[this._idx(-1,-1)]=s[this._idx(0,0)],s[this._idx(o,-1)]=s[this._idx(o-1,0)],s[this._idx(-1,o)]=s[this._idx(0,o-1)],s[this._idx(o,o)]=s[this._idx(o-1,o-1)],n&&this._buildQuadTree()}}_buildQuadTree(){this._tree=new DemMinMaxQuadTree(this)}get(e,t,i=!1){i&&(e=M(e,-1,this.dim),t=M(t,-1,this.dim));const r=4*this._idx(e,t);return("terrarium"===this.encoding?ud:cd)(this.pixels[r],this.pixels[r+1],this.pixels[r+2])}static getUnpackVector(e){return ld[e]}get unpackVector(){return ld[this.encoding]}_idx(e,t){if(e<-1||e>=this.dim+1||t<-1||t>=this.dim+1)throw new RangeError("out of range source coordinates for DEM data");return(t+1)*this.stride+(e+1)}static pack(e,t){const i=[0,0,0,0],r=DEMData.getUnpackVector(t);let n=Math.floor((e+r[3])/r[2]);return i[2]=n%256,n=Math.floor(n/256),i[1]=n%256,n=Math.floor(n/256),i[0]=n,i}getPixels(){return new RGBAImage({width:this.stride,height:this.stride},this.pixels)}backfillBorder(e,t,i){if(this.dim!==e.dim)throw new Error("dem dimension mismatch");let r=t*this.dim,n=t*this.dim+this.dim,o=i*this.dim,s=i*this.dim+this.dim;switch(t){case-1:r=n-1;break;case 1:n=r+1}switch(i){case-1:o=s-1;break;case 1:s=o+1}const a=-t*this.dim,l=-i*this.dim;for(let t=o;t<s;t++)for(let i=r;i<n;i++){const r=4*this._idx(i,t),n=4*this._idx(i+a,t+l);this.pixels[r+0]=e.pixels[n+0],this.pixels[r+1]=e.pixels[n+1],this.pixels[r+2]=e.pixels[n+2],this.pixels[r+3]=e.pixels[n+3]}}onDeserialize(){this._tree&&(this._tree.dem=this)}}jn(DEMData,"DEMData"),jn(DemMinMaxQuadTree,"DemMinMaxQuadTree",{omit:["dem"]});class TileCache{constructor(e,t){this.max=e,this.onRemove=t,this.reset()}reset(){for(const e in this.data)for(const t of this.data[e])t.timeout&&clearTimeout(t.timeout),this.onRemove(t.value);return this.data={},this.order=[],this}add(e,t,i){const r=e.wrapped().key;void 0===this.data[r]&&(this.data[r]=[]);const n={value:t,timeout:void 0};if(void 0!==i&&(n.timeout=setTimeout((()=>{this.remove(e,n)}),i)),this.data[r].push(n),this.order.push(r),this.order.length>this.max){const e=this._getAndRemoveByKey(this.order[0]);e&&this.onRemove(e)}return this}has(e){return e.wrapped().key in this.data}getAndRemove(e){return this.has(e)?this._getAndRemoveByKey(e.wrapped().key):null}_getAndRemoveByKey(e){const t=this.data[e].shift();return t.timeout&&clearTimeout(t.timeout),0===this.data[e].length&&delete this.data[e],this.order.splice(this.order.indexOf(e),1),t.value}getByKey(e){const t=this.data[e];return t?t[0].value:null}get(e){return this.has(e)?this.data[e.wrapped().key][0].value:null}remove(e,t){if(!this.has(e))return this;const i=e.wrapped().key,r=void 0===t?0:this.data[i].indexOf(t),n=this.data[i][r];return this.data[i].splice(r,1),n.timeout&&clearTimeout(n.timeout),0===this.data[i].length&&delete this.data[i],this.onRemove(n.value),this.order.splice(this.order.indexOf(i),1),this}setMaxSize(e){for(this.max=e;this.order.length>this.max;){const e=this._getAndRemoveByKey(this.order[0]);e&&this.onRemove(e)}return this}filter(e){const t=[];for(const i in this.data)for(const r of this.data[i])e(r.value)||t.push(r);for(const e of t)this.remove(e.value.tileID,e)}}class IndexBuffer{constructor(e,t,i){this.context=e;const r=e.gl;this.buffer=r.createBuffer(),this.dynamicDraw=Boolean(i),this.context.unbindVAO(),e.bindElementBuffer.set(this.buffer),r.bufferData(r.ELEMENT_ARRAY_BUFFER,t.arrayBuffer,this.dynamicDraw?r.DYNAMIC_DRAW:r.STATIC_DRAW),this.dynamicDraw||t.destroy()}bind(){this.context.bindElementBuffer.set(this.buffer)}updateData(e){const t=this.context.gl;this.context.unbindVAO(),this.bind(),t.bufferSubData(t.ELEMENT_ARRAY_BUFFER,0,e.arrayBuffer)}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer)}}const hd={Int8:"BYTE",Uint8:"UNSIGNED_BYTE",Int16:"SHORT",Uint16:"UNSIGNED_SHORT",Int32:"INT",Uint32:"UNSIGNED_INT",Float32:"FLOAT"};class VertexBuffer{constructor(e,t,i,r){this.length=t.length,this.attributes=i,this.itemSize=t.bytesPerElement,this.dynamicDraw=r,this.context=e;const n=e.gl;this.buffer=n.createBuffer(),e.bindVertexBuffer.set(this.buffer),n.bufferData(n.ARRAY_BUFFER,t.arrayBuffer,this.dynamicDraw?n.DYNAMIC_DRAW:n.STATIC_DRAW),this.dynamicDraw||t.destroy()}bind(){this.context.bindVertexBuffer.set(this.buffer)}updateData(e){const t=this.context.gl;this.bind(),t.bufferSubData(t.ARRAY_BUFFER,0,e.arrayBuffer)}enableAttributes(e,t){for(let i=0;i<this.attributes.length;i++){const r=t.attributes[this.attributes[i].name];void 0!==r&&e.enableVertexAttribArray(r)}}setVertexAttribPointers(e,t,i){for(let r=0;r<this.attributes.length;r++){const n=this.attributes[r],o=t.attributes[n.name];void 0!==o&&e.vertexAttribPointer(o,n.components,e[hd[n.type]],!1,this.itemSize,n.offset+this.itemSize*(i||0))}}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer)}}class BaseValue{constructor(e){this.gl=e.gl,this.default=this.getDefault(),this.current=this.default,this.dirty=!1}get(){return this.current}set(e){}getDefault(){return this.default}setDefault(){this.set(this.default)}}class ClearColor extends BaseValue{getDefault(){return Wt.transparent}set(e){const t=this.current;(e.r!==t.r||e.g!==t.g||e.b!==t.b||e.a!==t.a||this.dirty)&&(this.gl.clearColor(e.r,e.g,e.b,e.a),this.current=e,this.dirty=!1)}}class ClearDepth extends BaseValue{getDefault(){return 1}set(e){(e!==this.current||this.dirty)&&(this.gl.clearDepth(e),this.current=e,this.dirty=!1)}}class ClearStencil extends BaseValue{getDefault(){return 0}set(e){(e!==this.current||this.dirty)&&(this.gl.clearStencil(e),this.current=e,this.dirty=!1)}}class ColorMask extends BaseValue{getDefault(){return[!0,!0,!0,!0]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||e[3]!==t[3]||this.dirty)&&(this.gl.colorMask(e[0],e[1],e[2],e[3]),this.current=e,this.dirty=!1)}}class DepthMask extends BaseValue{getDefault(){return!0}set(e){(e!==this.current||this.dirty)&&(this.gl.depthMask(e),this.current=e,this.dirty=!1)}}class StencilMask extends BaseValue{getDefault(){return 255}set(e){(e!==this.current||this.dirty)&&(this.gl.stencilMask(e),this.current=e,this.dirty=!1)}}class StencilFunc extends BaseValue{getDefault(){return{func:this.gl.ALWAYS,ref:0,mask:255}}set(e){const t=this.current;(e.func!==t.func||e.ref!==t.ref||e.mask!==t.mask||this.dirty)&&(this.gl.stencilFunc(e.func,e.ref,e.mask),this.current=e,this.dirty=!1)}}class StencilOp extends BaseValue{getDefault(){const e=this.gl;return[e.KEEP,e.KEEP,e.KEEP]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||this.dirty)&&(this.gl.stencilOp(e[0],e[1],e[2]),this.current=e,this.dirty=!1)}}class StencilTest extends BaseValue{getDefault(){return!1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.STENCIL_TEST):t.disable(t.STENCIL_TEST),this.current=e,this.dirty=!1}}class DepthRange extends BaseValue{getDefault(){return[0,1]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||this.dirty)&&(this.gl.depthRange(e[0],e[1]),this.current=e,this.dirty=!1)}}class DepthTest extends BaseValue{getDefault(){return!1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.DEPTH_TEST):t.disable(t.DEPTH_TEST),this.current=e,this.dirty=!1}}class DepthFunc extends BaseValue{getDefault(){return this.gl.LESS}set(e){(e!==this.current||this.dirty)&&(this.gl.depthFunc(e),this.current=e,this.dirty=!1)}}class Blend extends BaseValue{getDefault(){return!1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.BLEND):t.disable(t.BLEND),this.current=e,this.dirty=!1}}class BlendFunc extends BaseValue{getDefault(){const e=this.gl;return[e.ONE,e.ZERO]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||this.dirty)&&(this.gl.blendFunc(e[0],e[1]),this.current=e,this.dirty=!1)}}class BlendColor extends BaseValue{getDefault(){return Wt.transparent}set(e){const t=this.current;(e.r!==t.r||e.g!==t.g||e.b!==t.b||e.a!==t.a||this.dirty)&&(this.gl.blendColor(e.r,e.g,e.b,e.a),this.current=e,this.dirty=!1)}}class BlendEquation extends BaseValue{getDefault(){return this.gl.FUNC_ADD}set(e){(e!==this.current||this.dirty)&&(this.gl.blendEquation(e),this.current=e,this.dirty=!1)}}class CullFace extends BaseValue{getDefault(){return!1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.CULL_FACE):t.disable(t.CULL_FACE),this.current=e,this.dirty=!1}}class CullFaceSide extends BaseValue{getDefault(){return this.gl.BACK}set(e){(e!==this.current||this.dirty)&&(this.gl.cullFace(e),this.current=e,this.dirty=!1)}}class FrontFace extends BaseValue{getDefault(){return this.gl.CCW}set(e){(e!==this.current||this.dirty)&&(this.gl.frontFace(e),this.current=e,this.dirty=!1)}}let dd=class Program extends BaseValue{getDefault(){return null}set(e){(e!==this.current||this.dirty)&&(this.gl.useProgram(e),this.current=e,this.dirty=!1)}};class ActiveTextureUnit extends BaseValue{getDefault(){return this.gl.TEXTURE0}set(e){(e!==this.current||this.dirty)&&(this.gl.activeTexture(e),this.current=e,this.dirty=!1)}}class Viewport extends BaseValue{getDefault(){const e=this.gl;return[0,0,e.drawingBufferWidth,e.drawingBufferHeight]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||e[3]!==t[3]||this.dirty)&&(this.gl.viewport(e[0],e[1],e[2],e[3]),this.current=e,this.dirty=!1)}}class BindFramebuffer extends BaseValue{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindFramebuffer(t.FRAMEBUFFER,e),this.current=e,this.dirty=!1}}class BindRenderbuffer extends BaseValue{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindRenderbuffer(t.RENDERBUFFER,e),this.current=e,this.dirty=!1}}class BindTexture extends BaseValue{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindTexture(t.TEXTURE_2D,e),this.current=e,this.dirty=!1}}class BindVertexBuffer extends BaseValue{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindBuffer(t.ARRAY_BUFFER,e),this.current=e,this.dirty=!1}}class BindElementBuffer extends BaseValue{getDefault(){return null}set(e){const t=this.gl;t.bindBuffer(t.ELEMENT_ARRAY_BUFFER,e),this.current=e,this.dirty=!1}}class BindVertexArrayOES extends BaseValue{constructor(e){super(e),this.vao=e.extVertexArrayObject}getDefault(){return null}set(e){this.vao&&(e!==this.current||this.dirty)&&(this.vao.bindVertexArrayOES(e),this.current=e,this.dirty=!1)}}class PixelStoreUnpack extends BaseValue{getDefault(){return 4}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.pixelStorei(t.UNPACK_ALIGNMENT,e),this.current=e,this.dirty=!1}}class PixelStoreUnpackPremultiplyAlpha extends BaseValue{getDefault(){return!1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.pixelStorei(t.UNPACK_PREMULTIPLY_ALPHA_WEBGL,e),this.current=e,this.dirty=!1}}class PixelStoreUnpackFlipY extends BaseValue{getDefault(){return!1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.pixelStorei(t.UNPACK_FLIP_Y_WEBGL,e),this.current=e,this.dirty=!1}}class FramebufferAttachment extends BaseValue{constructor(e,t){super(e),this.context=e,this.parent=t}getDefault(){return null}}class ColorAttachment extends FramebufferAttachment{setDirty(){this.dirty=!0}set(e){if(e===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const t=this.gl;t.framebufferTexture2D(t.FRAMEBUFFER,t.COLOR_ATTACHMENT0,t.TEXTURE_2D,e,0),this.current=e,this.dirty=!1}}class DepthAttachment extends FramebufferAttachment{attachment(){return this.gl.DEPTH_ATTACHMENT}set(e){if(e===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const t=this.gl;t.framebufferRenderbuffer(t.FRAMEBUFFER,this.attachment(),t.RENDERBUFFER,e),this.current=e,this.dirty=!1}}class DepthStencilAttachment extends DepthAttachment{attachment(){return this.gl.DEPTH_STENCIL_ATTACHMENT}}class Framebuffer{constructor(e,t,i,r){this.context=e,this.width=t,this.height=i;const n=this.framebuffer=e.gl.createFramebuffer();this.colorAttachment=new ColorAttachment(e,n),r&&(this.depthAttachment=new DepthAttachment(e,n))}destroy(){const e=this.context.gl,t=this.colorAttachment.get();if(t&&e.deleteTexture(t),this.depthAttachment){const t=this.depthAttachment.get();t&&e.deleteRenderbuffer(t)}e.deleteFramebuffer(this.framebuffer)}}class DepthMode{constructor(e,t,i){this.func=e,this.mask=t,this.range=i}}DepthMode.ReadOnly=!1,DepthMode.ReadWrite=!0,DepthMode.disabled=new DepthMode(519,DepthMode.ReadOnly,[0,1]);const pd=7680;class StencilMode{constructor(e,t,i,r,n,o){this.test=e,this.ref=t,this.mask=i,this.fail=r,this.depthFail=n,this.pass=o}}StencilMode.disabled=new StencilMode({func:519,mask:0},0,0,pd,pd,pd);class ColorMode{constructor(e,t,i){this.blendFunction=e,this.blendColor=t,this.mask=i}}ColorMode.Replace=[1,0],ColorMode.disabled=new ColorMode(ColorMode.Replace,Wt.transparent,[!1,!1,!1,!1]),ColorMode.unblended=new ColorMode(ColorMode.Replace,Wt.transparent,[!0,!0,!0,!0]),ColorMode.alphaBlended=new ColorMode([1,771],Wt.transparent,[!0,!0,!0,!0]);const fd=1029,md=2305;class CullFaceMode{constructor(e,t,i){this.enable=e,this.mode=t,this.frontFace=i}}CullFaceMode.disabled=new CullFaceMode(!1,fd,md),CullFaceMode.backCCW=new CullFaceMode(!0,fd,md),CullFaceMode.backCW=new CullFaceMode(!0,fd,2304),CullFaceMode.frontCW=new CullFaceMode(!0,1028,2304),CullFaceMode.frontCCW=new CullFaceMode(!0,1028,md);class Context{constructor(e,t=!1){if(this.gl=e,this.isWebGL2=t,this.extVertexArrayObject=this.gl.getExtension("OES_vertex_array_object"),t){const t=e;this.extVertexArrayObject={createVertexArrayOES:t.createVertexArray.bind(e),deleteVertexArrayOES:t.deleteVertexArray.bind(e),bindVertexArrayOES:t.bindVertexArray.bind(e)}}this.clearColor=new ClearColor(this),this.clearDepth=new ClearDepth(this),this.clearStencil=new ClearStencil(this),this.colorMask=new ColorMask(this),this.depthMask=new DepthMask(this),this.stencilMask=new StencilMask(this),this.stencilFunc=new StencilFunc(this),this.stencilOp=new StencilOp(this),this.stencilTest=new StencilTest(this),this.depthRange=new DepthRange(this),this.depthTest=new DepthTest(this),this.depthFunc=new DepthFunc(this),this.blend=new Blend(this),this.blendFunc=new BlendFunc(this),this.blendColor=new BlendColor(this),this.blendEquation=new BlendEquation(this),this.cullFace=new CullFace(this),this.cullFaceSide=new CullFaceSide(this),this.frontFace=new FrontFace(this),this.program=new dd(this),this.activeTexture=new ActiveTextureUnit(this),this.viewport=new Viewport(this),this.bindFramebuffer=new BindFramebuffer(this),this.bindRenderbuffer=new BindRenderbuffer(this),this.bindTexture=new BindTexture(this),this.bindVertexBuffer=new BindVertexBuffer(this),this.bindElementBuffer=new BindElementBuffer(this),this.bindVertexArrayOES=this.extVertexArrayObject&&new BindVertexArrayOES(this),this.pixelStoreUnpack=new PixelStoreUnpack(this),this.pixelStoreUnpackPremultiplyAlpha=new PixelStoreUnpackPremultiplyAlpha(this),this.pixelStoreUnpackFlipY=new PixelStoreUnpackFlipY(this),this.extTextureFilterAnisotropic=e.getExtension("EXT_texture_filter_anisotropic")||e.getExtension("MOZ_EXT_texture_filter_anisotropic")||e.getExtension("WEBKIT_EXT_texture_filter_anisotropic"),this.extTextureFilterAnisotropic&&(this.extTextureFilterAnisotropicMax=e.getParameter(this.extTextureFilterAnisotropic.MAX_TEXTURE_MAX_ANISOTROPY_EXT)),this.extTextureFilterAnisotropicForceOff=!1,this.extStandardDerivativesForceOff=!1,this.extDebugRendererInfo=e.getExtension("WEBGL_debug_renderer_info"),this.extDebugRendererInfo&&(this.renderer=e.getParameter(this.extDebugRendererInfo.UNMASKED_RENDERER_WEBGL),this.vendor=e.getParameter(this.extDebugRendererInfo.UNMASKED_VENDOR_WEBGL)),t||(this.extTextureHalfFloat=e.getExtension("OES_texture_half_float")),(t||this.extTextureHalfFloat&&e.getExtension("OES_texture_half_float_linear"))&&(this.extRenderToTextureHalfFloat=e.getExtension("EXT_color_buffer_half_float")),this.extStandardDerivatives=t||e.getExtension("OES_standard_derivatives"),this.extTimerQuery=e.getExtension("EXT_disjoint_timer_query"),this.maxTextureSize=e.getParameter(e.MAX_TEXTURE_SIZE)}setDefault(){this.unbindVAO(),this.clearColor.setDefault(),this.clearDepth.setDefault(),this.clearStencil.setDefault(),this.colorMask.setDefault(),this.depthMask.setDefault(),this.stencilMask.setDefault(),this.stencilFunc.setDefault(),this.stencilOp.setDefault(),this.stencilTest.setDefault(),this.depthRange.setDefault(),this.depthTest.setDefault(),this.depthFunc.setDefault(),this.blend.setDefault(),this.blendFunc.setDefault(),this.blendColor.setDefault(),this.blendEquation.setDefault(),this.cullFace.setDefault(),this.cullFaceSide.setDefault(),this.frontFace.setDefault(),this.program.setDefault(),this.activeTexture.setDefault(),this.bindFramebuffer.setDefault(),this.pixelStoreUnpack.setDefault(),this.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.pixelStoreUnpackFlipY.setDefault()}setDirty(){this.clearColor.dirty=!0,this.clearDepth.dirty=!0,this.clearStencil.dirty=!0,this.colorMask.dirty=!0,this.depthMask.dirty=!0,this.stencilMask.dirty=!0,this.stencilFunc.dirty=!0,this.stencilOp.dirty=!0,this.stencilTest.dirty=!0,this.depthRange.dirty=!0,this.depthTest.dirty=!0,this.depthFunc.dirty=!0,this.blend.dirty=!0,this.blendFunc.dirty=!0,this.blendColor.dirty=!0,this.blendEquation.dirty=!0,this.cullFace.dirty=!0,this.cullFaceSide.dirty=!0,this.frontFace.dirty=!0,this.program.dirty=!0,this.activeTexture.dirty=!0,this.viewport.dirty=!0,this.bindFramebuffer.dirty=!0,this.bindRenderbuffer.dirty=!0,this.bindTexture.dirty=!0,this.bindVertexBuffer.dirty=!0,this.bindElementBuffer.dirty=!0,this.extVertexArrayObject&&(this.bindVertexArrayOES.dirty=!0),this.pixelStoreUnpack.dirty=!0,this.pixelStoreUnpackPremultiplyAlpha.dirty=!0,this.pixelStoreUnpackFlipY.dirty=!0}createIndexBuffer(e,t){return new IndexBuffer(this,e,t)}createVertexBuffer(e,t,i){return new VertexBuffer(this,e,t,i)}createRenderbuffer(e,t,i){const r=this.gl,n=r.createRenderbuffer();return this.bindRenderbuffer.set(n),r.renderbufferStorage(r.RENDERBUFFER,e,t,i),this.bindRenderbuffer.set(null),n}createFramebuffer(e,t,i){return new Framebuffer(this,e,t,i)}clear({color:e,depth:t,stencil:i}){const r=this.gl;let n=0;e&&(n|=r.COLOR_BUFFER_BIT,this.clearColor.set(e),this.colorMask.set([!0,!0,!0,!0])),void 0!==t&&(n|=r.DEPTH_BUFFER_BIT,this.depthRange.set([0,1]),this.clearDepth.set(t),this.depthMask.set(!0)),void 0!==i&&(n|=r.STENCIL_BUFFER_BIT,this.clearStencil.set(i),this.stencilMask.set(255)),r.clear(n)}setCullFace(e){!1===e.enable?this.cullFace.set(!1):(this.cullFace.set(!0),this.cullFaceSide.set(e.mode),this.frontFace.set(e.frontFace))}setDepthMode(e){e.func!==this.gl.ALWAYS||e.mask?(this.depthTest.set(!0),this.depthFunc.set(e.func),this.depthMask.set(e.mask),this.depthRange.set(e.range)):this.depthTest.set(!1)}setStencilMode(e){e.test.func!==this.gl.ALWAYS||e.mask?(this.stencilTest.set(!0),this.stencilMask.set(e.mask),this.stencilOp.set([e.fail,e.depthFail,e.pass]),this.stencilFunc.set({func:e.test.func,ref:e.ref,mask:e.test.mask})):this.stencilTest.set(!1)}setColorMode(e){y(e.blendFunction,ColorMode.Replace)?this.blend.set(!1):(this.blend.set(!0),this.blendFunc.set(e.blendFunction),this.blendColor.set(e.blendColor)),this.colorMask.set(e.mask)}unbindVAO(){this.extVertexArrayObject&&this.bindVertexArrayOES.set(null)}}class SourceCache extends Evented{constructor(e,t,i){super(),this.id=e,this._onlySymbols=i,t.on("data",(e=>{"source"===e.dataType&&"metadata"===e.sourceDataType&&(this._sourceLoaded=!0),this._sourceLoaded&&!this._paused&&"source"===e.dataType&&"content"===e.sourceDataType&&(this.reload(),this.transform&&this.update(this.transform))})),t.on("error",(()=>{this._sourceErrored=!0})),this._source=t,this._tiles={},this._cache=new TileCache(0,this._unloadTile.bind(this)),this._timers={},this._cacheTimers={},this._minTileCacheSize=t.minTileCacheSize,this._maxTileCacheSize=t.maxTileCacheSize,this._loadedParentTiles={},this._coveredTiles={},this._state=new SourceFeatureState,this._isRaster="raster"===this._source.type||"raster-dem"===this._source.type||"custom"===this._source.type&&"raster"===this._source._dataType}onAdd(e){this.map=e,this._minTileCacheSize=void 0===this._minTileCacheSize&&e?e._minTileCacheSize:this._minTileCacheSize,this._maxTileCacheSize=void 0===this._maxTileCacheSize&&e?e._maxTileCacheSize:this._maxTileCacheSize}loaded(){if(this._sourceErrored)return!0;if(!this._sourceLoaded)return!1;if(!this._source.loaded())return!1;for(const e in this._tiles){const t=this._tiles[e];if("loaded"!==t.state&&"errored"!==t.state)return!1}return!0}getSource(){return this._source}pause(){this._paused=!0}resume(){if(!this._paused)return;const e=this._shouldReloadOnResume;this._paused=!1,this._shouldReloadOnResume=!1,e&&this.reload(),this.transform&&this.update(this.transform)}_loadTile(e,t){return e.isSymbolTile=this._onlySymbols,this._source.loadTile(e,t)}_unloadTile(e){if(this._source.unloadTile)return this._source.unloadTile(e,(()=>{}))}_abortTile(e){if(this._source.abortTile)return this._source.abortTile(e,(()=>{}))}serialize(){return this._source.serialize()}prepare(e){this._source.prepare&&this._source.prepare(),this._state.coalesceChanges(this._tiles,this.map?this.map.painter:null);for(const t in this._tiles){const i=this._tiles[t];i.upload(e),i.prepare(this.map.style.imageManager)}}getIds(){return k(this._tiles).map((e=>e.tileID)).sort(_d).map((e=>e.key))}getRenderableIds(e){const t=[];for(const i in this._tiles)this._isIdRenderable(+i,e)&&t.push(this._tiles[i]);return e?t.sort(((e,t)=>{const i=e.tileID,r=t.tileID,n=new g(i.canonical.x,i.canonical.y)._rotate(this.transform.angle),o=new g(r.canonical.x,r.canonical.y)._rotate(this.transform.angle);return i.overscaledZ-r.overscaledZ||o.y-n.y||o.x-n.x})).map((e=>e.tileID.key)):t.map((e=>e.tileID)).sort(_d).map((e=>e.key))}hasRenderableParent(e){const t=this.findLoadedParent(e,0);return!!t&&this._isIdRenderable(t.tileID.key)}_isIdRenderable(e,t){return this._tiles[e]&&this._tiles[e].hasData()&&!this._coveredTiles[e]&&(t||!this._tiles[e].holdingForFade())}reload(){if(this._paused)this._shouldReloadOnResume=!0;else{this._cache.reset();for(const e in this._tiles)"errored"!==this._tiles[e].state&&this._reloadTile(+e,"reloading")}}_reloadTile(e,t){const i=this._tiles[e];i&&("loading"!==i.state&&(i.state=t),this._loadTile(i,this._tileLoaded.bind(this,i,e,t)))}_tileLoaded(e,t,i,r){if(r)if(e.state="errored",404!==r.status)this._source.fire(new ErrorEvent(r,{tile:e}));else if("raster-dem"===this._source.type&&this.usedForTerrain&&this.map.painter.terrain){const e=this.map.painter.terrain;this.update(this.transform,e.getScaledDemTileSize(),!0),e.resetTileLookupCache(this.id)}else this.update(this.transform);else e.timeAdded=it.now(),"expired"===i&&(e.refreshedUponExpiration=!0),this._setTileReloadTimer(t,e),"raster-dem"===this._source.type&&e.dem&&this._backfillDEM(e),this._state.initializeTileState(e,this.map?this.map.painter:null),this._source.fire(new Event("data",{dataType:"source",tile:e,coord:e.tileID,sourceCacheId:this.id}))}_backfillDEM(e){const t=this.getRenderableIds();for(let r=0;r<t.length;r++){const n=t[r];if(e.neighboringTiles&&e.neighboringTiles[n]){const t=this.getTileByID(n);i(e,t),i(t,e)}}function i(e,t){if(!e.dem||e.dem.borderReady)return;e.needsHillshadePrepare=!0,e.needsDEMTextureUpload=!0;let i=t.tileID.canonical.x-e.tileID.canonical.x;const r=t.tileID.canonical.y-e.tileID.canonical.y,n=Math.pow(2,e.tileID.canonical.z),o=t.tileID.key;0===i&&0===r||Math.abs(r)>1||(Math.abs(i)>1&&(1===Math.abs(i+n)?i+=n:1===Math.abs(i-n)&&(i-=n)),t.dem&&e.dem&&(e.dem.backfillBorder(t.dem,i,r),e.neighboringTiles&&e.neighboringTiles[o]&&(e.neighboringTiles[o].backfilled=!0)))}}getTile(e){return this.getTileByID(e.key)}getTileByID(e){return this._tiles[e]}_retainLoadedChildren(e,t,i,r){for(const n in this._tiles){let o=this._tiles[n];if(r[n]||!o.hasData()||o.tileID.overscaledZ<=t||o.tileID.overscaledZ>i)continue;let s=o.tileID;for(;o&&o.tileID.overscaledZ>t+1;){const e=o.tileID.scaledTo(o.tileID.overscaledZ-1);o=this._tiles[e.key],o&&o.hasData()&&(s=e)}let a=s;for(;a.overscaledZ>t;)if(a=a.scaledTo(a.overscaledZ-1),e[a.key]){r[s.key]=s;break}}}findLoadedParent(e,t){if(e.key in this._loadedParentTiles){const i=this._loadedParentTiles[e.key];return i&&i.tileID.overscaledZ>=t?i:null}for(let i=e.overscaledZ-1;i>=t;i--){const t=e.scaledTo(i),r=this._getLoadedTile(t);if(r)return r}}_getLoadedTile(e){const t=this._tiles[e.key];return t&&t.hasData()?t:this._cache.getByKey(this._source.reparseOverscaled?e.wrapped().key:e.canonical.key)}updateCacheSize(e,t){t=t||this._source.tileSize;const i=Math.ceil(e.width/t)+1,r=Math.ceil(e.height/t)+1,n=Math.floor(i*r*5),o="number"==typeof this._minTileCacheSize?Math.max(this._minTileCacheSize,n):n,s="number"==typeof this._maxTileCacheSize?Math.min(this._maxTileCacheSize,o):o;this._cache.setMaxSize(s)}handleWrapJump(e){const t=Math.round((e-(void 0===this._prevLng?e:this._prevLng))/360);if(this._prevLng=e,t){const e={};for(const i in this._tiles){const r=this._tiles[i];r.tileID=r.tileID.unwrapTo(r.tileID.wrap+t),e[r.tileID.key]=r}this._tiles=e;for(const e in this._timers)clearTimeout(this._timers[e]),delete this._timers[e];for(const e in this._tiles)this._setTileReloadTimer(+e,this._tiles[e])}}update(e,t,i){if(this.transform=e,!this._sourceLoaded||this._paused||this.transform.freezeTileCoverage)return;if(this.usedForTerrain&&!i)return;let r;this.updateCacheSize(e,t),"globe"!==this.transform.projection.name&&this.handleWrapJump(this.transform.center.lng),this._coveredTiles={},this.used||this.usedForTerrain?this._source.tileID?r=e.getVisibleUnwrappedCoordinates(this._source.tileID).map((e=>new OverscaledTileID(e.canonical.z,e.wrap,e.canonical.z,e.canonical.x,e.canonical.y))):(r=e.coveringTiles({tileSize:t||this._source.tileSize,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:this._source.roundZoom&&!i,reparseOverscaled:this._source.reparseOverscaled,isTerrainDEM:this.usedForTerrain}),this._source.hasTile&&(r=r.filter((e=>this._source.hasTile(e))))):r=[];const n=this._updateRetainedTiles(r);if(gd(this._source.type)&&0!==r.length){const e={},t={},i=Object.keys(n);for(const r of i){const i=n[r],o=this._tiles[r];if(!o||o.fadeEndTime&&o.fadeEndTime<=it.now())continue;const s=this.findLoadedParent(i,Math.max(i.overscaledZ-SourceCache.maxOverzooming,this._source.minzoom));s&&(this._addTile(s.tileID),e[s.tileID.key]=s.tileID),t[r]=i}const o=r[r.length-1].overscaledZ;for(const e in this._tiles){const i=this._tiles[e];if(n[e]||!i.hasData())continue;let r=i.tileID;for(;r.overscaledZ>o;){r=r.scaledTo(r.overscaledZ-1);const o=this._tiles[r.key];if(o&&o.hasData()&&t[r.key]){n[e]=i.tileID;break}}}for(const t in e)n[t]||(this._coveredTiles[t]=!0,n[t]=e[t])}for(const e in n)this._tiles[e].clearFadeHold();const o=function(e,t){const i=[];for(const r in e)r in t||i.push(r);return i}(this._tiles,n);for(const e of o){const t=this._tiles[e];t.hasSymbolBuckets&&!t.holdingForFade()?t.setHoldDuration(this.map._fadeDuration):t.hasSymbolBuckets&&!t.symbolFadeFinished()||this._removeTile(+e)}this._updateLoadedParentTileCache(),this._onlySymbols&&this._source.afterUpdate&&this._source.afterUpdate()}releaseSymbolFadeTiles(){for(const e in this._tiles)this._tiles[e].holdingForFade()&&this._removeTile(+e)}_updateRetainedTiles(e){const t={};if(0===e.length)return t;const i={},r=e.reduce(((e,t)=>Math.min(e,t.overscaledZ)),1/0),n=e[0].overscaledZ,o=Math.max(n-SourceCache.maxOverzooming,this._source.minzoom),s=Math.max(n+SourceCache.maxUnderzooming,this._source.minzoom),a={};for(const i of e){const e=this._addTile(i);t[i.key]=i,e.hasData()||r<this._source.maxzoom&&(a[i.key]=i)}this._retainLoadedChildren(a,r,s,t);for(const r of e){let e=this._tiles[r.key];if(e.hasData())continue;if(r.canonical.z>=this._source.maxzoom){const e=r.children(this._source.maxzoom)[0],i=this.getTile(e);if(i&&i.hasData()){t[e.key]=e;continue}}else{const e=r.children(this._source.maxzoom);if(t[e[0].key]&&t[e[1].key]&&t[e[2].key]&&t[e[3].key])continue}let n=e.wasRequested();for(let s=r.overscaledZ-1;s>=o;--s){const o=r.scaledTo(s);if(i[o.key])break;if(i[o.key]=!0,e=this.getTile(o),!e&&n&&(e=this._addTile(o)),e&&(t[o.key]=o,n=e.wasRequested(),e.hasData()))break}}return t}_updateLoadedParentTileCache(){this._loadedParentTiles={};for(const e in this._tiles){const t=[];let i,r=this._tiles[e].tileID;for(;r.overscaledZ>0;){if(r.key in this._loadedParentTiles){i=this._loadedParentTiles[r.key];break}t.push(r.key);const e=r.scaledTo(r.overscaledZ-1);if(i=this._getLoadedTile(e),i)break;r=e}for(const e of t)this._loadedParentTiles[e]=i}}_addTile(e){let t=this._tiles[e.key];if(t)return t;t=this._cache.getAndRemove(e),t&&(this._setTileReloadTimer(e.key,t),t.tileID=e,this._state.initializeTileState(t,this.map?this.map.painter:null),this._cacheTimers[e.key]&&(clearTimeout(this._cacheTimers[e.key]),delete this._cacheTimers[e.key],this._setTileReloadTimer(e.key,t)));const i=Boolean(t);if(!i){const i=this.map?this.map.painter:null;t=new Tile(e,this._source.tileSize*e.overscaleFactor(),this.transform.tileZoom,i,this._isRaster),this._loadTile(t,this._tileLoaded.bind(this,t,e.key,t.state))}return t?(t.uses++,this._tiles[e.key]=t,i||this._source.fire(new Event("dataloading",{tile:t,coord:t.tileID,dataType:"source"})),t):null}_setTileReloadTimer(e,t){e in this._timers&&(clearTimeout(this._timers[e]),delete this._timers[e]);const i=t.getExpiryTimeout();i&&(this._timers[e]=setTimeout((()=>{this._reloadTile(e,"expired"),delete this._timers[e]}),i))}_removeTile(e){const t=this._tiles[e];t&&(t.uses--,delete this._tiles[e],this._timers[e]&&(clearTimeout(this._timers[e]),delete this._timers[e]),t.uses>0||(t.hasData()&&"reloading"!==t.state?this._cache.add(t.tileID,t,t.getExpiryTimeout()):(t.aborted=!0,this._abortTile(t),this._unloadTile(t))))}clearTiles(){this._shouldReloadOnResume=!1,this._paused=!1;for(const e in this._tiles)this._removeTile(+e);this._source._clear&&this._source._clear(),this._cache.reset(),this.map&&this.usedForTerrain&&this.map.painter.terrain&&this.map.painter.terrain.resetTileLookupCache(this.id)}tilesIn(e,t,i){const r=[],n=this.transform;if(!n)return r;const o="globe"===n.projection.name,s=za(n.center.lng);for(const a in this._tiles){const l=this._tiles[a];if(i&&l.clearQueryDebugViz(),l.holdingForFade())continue;let c;if(o){const e=l.tileID.canonical;if(0===e.z){const t=[Math.abs(M(s,...yd(e,-1))-s),Math.abs(M(s,...yd(e,1))-s)];c=[0,2*t.indexOf(Math.min(...t))-1]}else{const t=[Math.abs(M(s,...yd(e,-1))-s),Math.abs(M(s,...yd(e,0))-s),Math.abs(M(s,...yd(e,1))-s)];c=[t.indexOf(Math.min(...t))-1]}}else c=[0];for(const i of c){const o=e.containsTile(l,n,t,i);o&&r.push(o)}}return r}getVisibleCoordinates(e){const t=this.getRenderableIds(e).map((e=>this._tiles[e].tileID));for(const e of t)e.projMatrix=this.transform.calculateProjMatrix(e.toUnwrapped());return t}hasTransition(){if(this._source.hasTransition())return!0;if(gd(this._source.type))for(const e in this._tiles){const t=this._tiles[e];if(void 0!==t.fadeEndTime&&t.fadeEndTime>=it.now())return!0}return!1}setFeatureState(e,t,i){this._state.updateState(e=e||"_geojsonTileLayer",t,i)}removeFeatureState(e,t,i){this._state.removeFeatureState(e=e||"_geojsonTileLayer",t,i)}getFeatureState(e,t){return this._state.getState(e=e||"_geojsonTileLayer",t)}setDependencies(e,t,i){const r=this._tiles[e];r&&r.setDependencies(t,i)}reloadTilesForDependencies(e,t){for(const i in this._tiles)this._tiles[i].hasDependency(e,t)&&this._reloadTile(+i,"reloading");this._cache.filter((i=>!i.hasDependency(e,t)))}_preloadTiles(e,t){if(!this._sourceLoaded){const i=()=>{this._sourceLoaded&&(this._source.off("data",i),this._preloadTiles(e,t))};return void this._source.on("data",i)}const i=new Map,r=Array.isArray(e)?e:[e],n=this.map.painter.terrain,o=this.usedForTerrain&&n?n.getScaledDemTileSize():this._source.tileSize;for(const e of r){const t=e.coveringTiles({tileSize:o,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:this._source.roundZoom&&!this.usedForTerrain,reparseOverscaled:this._source.reparseOverscaled,isTerrainDEM:this.usedForTerrain});for(const e of t)i.set(e.key,e);this.usedForTerrain&&e.updateElevation(!1)}z(Array.from(i.values()),((e,t)=>{const i=new Tile(e,this._source.tileSize*e.overscaleFactor(),this.transform.tileZoom,this.map.painter,this._isRaster);this._loadTile(i,(e=>{"raster-dem"===this._source.type&&i.dem&&this._backfillDEM(i),t(e,i)}))}),t)}}function _d(e,t){const i=Math.abs(2*e.wrap)-+(e.wrap<0),r=Math.abs(2*t.wrap)-+(t.wrap<0);return e.overscaledZ-t.overscaledZ||r-i||t.canonical.y-e.canonical.y||t.canonical.x-e.canonical.x}function gd(e){return"raster"===e||"image"===e||"video"===e||"custom"===e}function yd(e,t){const i=1<<e.z;return[e.x/i+t,(e.x+1)/i+t]}SourceCache.maxOverzooming=10,SourceCache.maxUnderzooming=3;class Elevation{isDataAvailableAtPoint(e){const t=this._source();if(this.isUsingMockSource()||!t||e.y<0||e.y>1)return!1;const i=t.getSource().maxzoom,r=1<<i,n=Math.floor(e.x),o=Math.floor((e.x-n)*r),s=Math.floor(e.y*r),a=this.findDEMTileFor(new OverscaledTileID(i,n,i,o,s));return!(!a||!a.dem)}getAtPointOrZero(e,t=0){return this.getAtPoint(e,t)||0}getAtPoint(e,t,i=!0){if(this.isUsingMockSource())return null;null==t&&(t=null);const r=this._source();if(!r)return t;if(e.y<0||e.y>1)return t;const n=r.getSource().maxzoom,o=1<<n,s=Math.floor(e.x),a=e.x-s,l=new OverscaledTileID(n,s,n,Math.floor(a*o),Math.floor(e.y*o)),c=this.findDEMTileFor(l);if(!c||!c.dem)return t;const u=c.dem,h=1<<c.tileID.canonical.z,d=(a*h-c.tileID.canonical.x)*u.dim,p=(e.y*h-c.tileID.canonical.y)*u.dim,f=Math.floor(d),m=Math.floor(p);return(i?this.exaggeration():1)*zi(zi(u.get(f,m),u.get(f,m+1),p-m),zi(u.get(f+1,m),u.get(f+1,m+1),p-m),d-f)}getAtTileOffset(e,t,i){const r=1<<e.canonical.z;return this.getAtPointOrZero(new MercatorCoordinate(e.wrap+(e.canonical.x+t/Uo)/r,(e.canonical.y+i/Uo)/r))}getAtTileOffsetFunc(e,t,i,r){return n=>{const o=this.getAtTileOffset(e,n.x,n.y),s=r.upVector(e.canonical,n.x,n.y);return _s(s,s,o*r.upVectorScale(e.canonical,t,i).metersToTile),s}}getForTilePoints(e,t,i,r){if(this.isUsingMockSource())return!1;const n=DEMSampler.create(this,e,r);return!!n&&(t.forEach((e=>{e[2]=this.exaggeration()*n.getElevationAt(e[0],e[1],i)})),!0)}getMinMaxForTile(e){if(this.isUsingMockSource())return null;const t=this.findDEMTileFor(e);if(!t||!t.dem)return null;const i=t.dem.tree,r=t.tileID,n=1<<e.canonical.z-r.canonical.z;let o=e.canonical.x/n-r.canonical.x,s=e.canonical.y/n-r.canonical.y,a=0;for(let t=0;t<e.canonical.z-r.canonical.z&&!i.leaves[a];t++){o*=2,s*=2;const e=2*Math.floor(s)+Math.floor(o);a=i.childOffsets[a]+e,o%=1,s%=1}return{min:this.exaggeration()*i.minimums[a],max:this.exaggeration()*i.maximums[a]}}getMinElevationBelowMSL(){throw new Error("Pure virtual method called.")}raycast(e,t,i){throw new Error("Pure virtual method called.")}pointCoordinate(e){throw new Error("Pure virtual method called.")}_source(){throw new Error("Pure virtual method called.")}isUsingMockSource(){throw new Error("Pure virtual method called.")}exaggeration(){throw new Error("Pure virtual method called.")}findDEMTileFor(e){throw new Error("Pure virtual method called.")}get visibleDemTiles(){throw new Error("Getter must be implemented in subclass.")}}class DEMSampler{constructor(e,t,i){this._demTile=e,this._dem=this._demTile.dem,this._scale=t,this._offset=i}static create(e,t,i){const r=i||e.findDEMTileFor(t);if(!r||!r.dem)return;const n=r.dem,o=r.tileID,s=1<<t.canonical.z-o.canonical.z;return new DEMSampler(r,r.tileSize/Uo/s,[(t.canonical.x/s-o.canonical.x)*n.dim,(t.canonical.y/s-o.canonical.y)*n.dim])}tileCoordToPixel(e,t){const i=t*this._scale+this._offset[1],r=Math.floor(e*this._scale+this._offset[0]),n=Math.floor(i);return new g(r,n)}getElevationAt(e,t,i,r){const n=e*this._scale+this._offset[0],o=t*this._scale+this._offset[1],s=Math.floor(n),a=Math.floor(o),l=this._dem;return r=!!r,i?zi(zi(l.get(s,a,r),l.get(s,a+1,r),o-a),zi(l.get(s+1,a,r),l.get(s+1,a+1,r),o-a),n-s):l.get(s,a,r)}getElevationAtPixel(e,t,i){return this._dem.get(e,t,!!i)}getMeterToDEM(e){return(1<<this._demTile.tileID.canonical.z)*La(1,e)*this._dem.stride}}function xd(e,t,i,r,n){return G(e,((e,o)=>{const s=t instanceof PossiblyEvaluated?t.get(o):null;return s&&s.evaluate?s.evaluate(i,r,n):s}))}function vd(e,t){return t-e}jn(class FeatureIndex{constructor(e,t){this.tileID=e,this.x=e.canonical.x,this.y=e.canonical.y,this.z=e.canonical.z,this.grid=new Un(Uo,16,0),this.featureIndexArray=new FeatureIndexArray,this.promoteId=t}insert(e,t,i,r,n,o=0){const s=this.featureIndexArray.length;this.featureIndexArray.emplaceBack(i,r,n,o);const a=this.grid;for(let e=0;e<t.length;e++){const i=t[e],r=[1/0,1/0,-1/0,-1/0];for(let e=0;e<i.length;e++){const t=i[e];r[0]=Math.min(r[0],t.x),r[1]=Math.min(r[1],t.y),r[2]=Math.max(r[2],t.x),r[3]=Math.max(r[3],t.y)}r[0]<Uo&&r[1]<Uo&&r[2]>=0&&r[3]>=0&&a.insert(s,r[0],r[1],r[2],r[3])}}loadVTLayers(){if(!this.vtLayers){this.vtLayers=new Cc(new ju(this.rawTileData)).layers,this.sourceLayerCoder=new DictionaryCoder(this.vtLayers?Object.keys(this.vtLayers).sort():["_geojsonTileLayer"]),this.vtFeatures={};for(const e in this.vtLayers)this.vtFeatures[e]=[]}return this.vtLayers}query(e,t,i,r){this.loadVTLayers();const n=e.params||{},o=Xr(n.filter),s=e.tileResult,a=e.transform,l=s.bufferedTilespaceBounds,c=this.grid.query(l.min.x,l.min.y,l.max.x,l.max.y,((e,t,i,r)=>al(s.bufferedTilespaceGeometry,e,t,i,r)));c.sort(vd);let u=null;a.elevation&&c.length>0&&(u=DEMSampler.create(a.elevation,this.tileID));const h={};let d;for(let a=0;a<c.length;a++){const l=c[a];if(l===d)continue;d=l;const p=this.featureIndexArray.get(l);let f=null;this.loadMatchingFeature(h,p,o,n.layers,n.availableImages,t,i,r,((t,i,r,n=0)=>(f||(f=Wa(t,this.tileID.canonical,e.tileTransform)),i.queryIntersectsFeature(s,t,r,f,this.z,e.transform,e.pixelPosMatrix,u,n))))}return h}loadMatchingFeature(e,t,i,r,n,o,s,a,l){const{featureIndex:c,bucketIndex:u,sourceLayerIndex:h,layoutVertexArrayOffset:d}=t,p=this.bucketLayerIDs[u];if(r&&!function(e,t){for(let i=0;i<e.length;i++)if(t.indexOf(e[i])>=0)return!0;return!1}(r,p))return;const f=this.sourceLayerCoder.decode(h),m=this.vtLayers[f].feature(c);if(i.needGeometry){const e=Ha(m,!0);if(!i.filter(new EvaluationParameters(this.tileID.overscaledZ),e,this.tileID.canonical))return}else if(!i.filter(new EvaluationParameters(this.tileID.overscaledZ),m))return;const _=this.getId(m,f);for(let t=0;t<p.length;t++){const i=p[t];if(r&&r.indexOf(i)<0)continue;const u=o[i];if(!u)continue;let h={};void 0!==_&&a&&(h=a.getState(u.sourceLayer||"_geojsonTileLayer",_));const f=L({},s[i]);f.paint=xd(f.paint,u.paint,m,h,n),f.layout=xd(f.layout,u.layout,m,h,n);const g=!l||l(m,u,h,d);if(!g)continue;const y=new Feature(m,this.z,this.x,this.y,_);y.layer=f;let x=e[i];void 0===x&&(x=e[i]=[]),x.push({featureIndex:c,feature:y,intersectionZ:g})}}lookupSymbolFeatures(e,t,i,r,n,o,s,a){const l={};this.loadVTLayers();const c=Xr(n);for(const n of e)this.loadMatchingFeature(l,{bucketIndex:i,sourceLayerIndex:r,featureIndex:n,layoutVertexArrayOffset:0},c,o,s,a,t);return l}loadFeature(e){const{featureIndex:t,sourceLayerIndex:i}=e;this.loadVTLayers();const r=this.sourceLayerCoder.decode(i),n=this.vtFeatures[r];if(n[t])return n[t];const o=this.vtLayers[r].feature(t);return n[t]=o,o}hasLayer(e){for(const t of this.bucketLayerIDs)for(const i of t)if(e===i)return!0;return!1}getId(e,t){let i=e.id;if(this.promoteId){const r="string"==typeof this.promoteId?this.promoteId:this.promoteId[t];null!=r&&(i=e.properties[r]),"boolean"==typeof i&&(i=Number(i))}return i}},"FeatureIndex",{omit:["rawTileData","sourceLayerCoder"]}),jn(class LineAtlas{constructor(e,t){this.width=e,this.height=t,this.nextRow=0,this.image=new AlphaImage({width:e,height:t}),this.positions={},this.uploaded=!1}getDash(e,t){const i=this.getKey(e,t);return this.positions[i]}trim(){const e=this.width,t=this.height=U(this.nextRow);this.image.resize({width:e,height:t})}getKey(e,t){return e.join(",")+t}getDashRanges(e,t,i){const r=[];let n=e.length%2==1?-e[e.length-1]*i:0,o=e[0]*i,s=!0;r.push({left:n,right:o,isDash:s,zeroLength:0===e[0]});let a=e[0];for(let t=1;t<e.length;t++){s=!s;const l=e[t];n=a*i,a+=l,o=a*i,r.push({left:n,right:o,isDash:s,zeroLength:0===l})}return r}addRoundDash(e,t,i){const r=t/2;for(let t=-i;t<=i;t++){const n=this.width*(this.nextRow+i+t);let o=0,s=e[o];for(let a=0;a<this.width;a++){a/s.right>1&&(s=e[++o]);const l=Math.abs(a-s.left),c=Math.abs(a-s.right),u=Math.min(l,c);let h;const d=t/i*(r+1);if(s.isDash){const e=r-Math.abs(d);h=Math.sqrt(u*u+e*e)}else h=r-Math.sqrt(u*u+d*d);this.image.data[n+a]=Math.max(0,Math.min(255,h+128))}}}addRegularDash(e,t){for(let t=e.length-1;t>=0;--t){const i=e[t],r=e[t+1];i.zeroLength?e.splice(t,1):r&&r.isDash===i.isDash&&(r.left=i.left,e.splice(t,1))}const i=e[0],r=e[e.length-1];i.isDash===r.isDash&&(i.left=r.left-this.width,r.right=i.right+this.width);const n=this.width*this.nextRow;let o=0,s=e[o];for(let i=0;i<this.width;i++){i/s.right>1&&(s=e[++o]);const r=Math.abs(i-s.left),a=Math.abs(i-s.right),l=Math.min(r,a);this.image.data[n+i]=Math.max(0,Math.min(255,(s.isDash?l:-l)+t+128))}}addDash(e,t){const i=this.getKey(e,t);if(this.positions[i])return this.positions[i];const r="round"===t,n=r?7:0,o=2*n+1;if(this.nextRow+o>this.height)return H("LineAtlas out of space"),null;0===e.length&&e.push(1);let s=0;for(let t=0;t<e.length;t++)e[t]<0&&(H("Negative value is found in line dasharray, replacing values with 0"),e[t]=0),s+=e[t];if(0!==s){const i=this.width/s,o=this.getDashRanges(e,this.width,i);r?this.addRoundDash(o,i,n):this.addRegularDash(o,"square"===t?.5*i:0)}const a=this.nextRow+n;this.nextRow+=o;const l={tl:[a,n],br:[s,0]};return this.positions[i]=l,l}},"LineAtlas"),jn(class GlyphAtlas{constructor(e){const t={},i=[];for(const r in e){const n=e[r],o=t[r]={};for(const e in n.glyphs){const t=n.glyphs[+e];if(!t||0===t.bitmap.width||0===t.bitmap.height)continue;const r=t.metrics.localGlyph?2:1,s={x:0,y:0,w:t.bitmap.width+2*r,h:t.bitmap.height+2*r};i.push(s),o[e]=s}}const{w:r,h:n}=$u(i),o=new AlphaImage({width:r||1,height:n||1});for(const i in e){const r=e[i];for(const e in r.glyphs){const n=r.glyphs[+e];if(!n||0===n.bitmap.width||0===n.bitmap.height)continue;const s=t[i][e],a=n.metrics.localGlyph?2:1;AlphaImage.copy(n.bitmap,o,{x:0,y:0},{x:s.x+a,y:s.y+a},n.bitmap)}}this.image=o,this.positions=t}},"GlyphAtlas");class DedupedRequest{constructor(e){this.entries={},this.scheduler=e}request(e,t,i,r){const n=this.entries[e]=this.entries[e]||{callbacks:[]};if(n.result){const[e,i]=n.result;return this.scheduler?this.scheduler.add((()=>{r(e,i)}),t):r(e,i),()=>{}}return n.callbacks.push(r),n.cancel||(n.cancel=i(((i,r)=>{n.result=[i,r];for(const e of n.callbacks)this.scheduler?this.scheduler.add((()=>{e(i,r)}),t):e(i,r);setTimeout((()=>delete this.entries[e]),3e3)}))),()=>{n.result||(n.callbacks=n.callbacks.filter((e=>e!==r)),n.callbacks.length||(n.cancel(),delete this.entries[e]))}}}function bd(e,t,i){const r=JSON.stringify(e.request);return e.data&&(this.deduped.entries[r]={result:[null,e.data]}),this.deduped.request(r,{type:"parseTile",isSymbolTile:e.isSymbolTile,zoom:e.tileZoom},(t=>{const r=xe(e.request,((e,r,n,o)=>{e?t(e):r&&t(null,{vectorTile:i?void 0:new Cc(new ju(r)),rawData:r,cacheControl:n,expires:o})}));return()=>{r.cancel(),t()}}),t)}class VectorTileSource extends Evented{constructor(e,t,i,r){if(super(),this.id=e,this.dispatcher=i,this.type="vector",this.minzoom=0,this.maxzoom=22,this.scheme="xyz",this.tileSize=512,this.reparseOverscaled=!0,this.isTileClipped=!0,this._loaded=!1,L(this,B(t,["url","scheme","tileSize","promoteId"])),this._options=L({type:"vector"},t),this._collectResourceTiming=t.collectResourceTiming,512!==this.tileSize)throw new Error("vector tile sources must have a tileSize of 512");this.setEventedParent(r),this._tileWorkers={},this._deduped=new DedupedRequest}load(e){this._loaded=!1,this.fire(new Event("dataloading",{dataType:"source"}));const t=Array.isArray(this.map._language)?this.map._language.join():this.map._language,i=this.map._worldview;this._tileJSONRequest=Zh(this._options,this.map._requestManager,t,i,((r,n)=>{this._tileJSONRequest=null,this._loaded=!0,r?(t&&console.warn(`Ensure that your requested language string is a valid BCP-47 code or list of codes. Found: ${t}`),i&&2!==i.length&&console.warn(`Requested worldview strings must be a valid ISO alpha-2 code. Found: ${i}`),this.fire(new ErrorEvent(r))):n&&(L(this,n),n.bounds&&(this.tileBounds=new TileBounds(n.bounds,this.minzoom,this.maxzoom)),Fe(n.tiles,this.map._requestManager._customAccessToken),this.fire(new Event("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new Event("data",{dataType:"source",sourceDataType:"content"}))),e&&e(r)}))}loaded(){return this._loaded}hasTile(e){return!this.tileBounds||this.tileBounds.contains(e.canonical)}onAdd(e){this.map=e,this.load()}reload(){this.cancelTileJSONRequest(),this.load((()=>this.map.style._clearSource(this.id)))}setTiles(e){return this._options.tiles=e,this.reload(),this}setUrl(e){return this.url=e,this._options.url=e,this.reload(),this}onRemove(){this.cancelTileJSONRequest()}serialize(){return L({},this._options)}loadTile(e,t){const i=this.map._requestManager.normalizeTileURL(e.tileID.canonical.url(this.tiles,this.scheme)),r={request:this.map._requestManager.transformRequest(i,me.Tile),data:void 0,uid:e.uid,tileID:e.tileID,tileZoom:e.tileZoom,zoom:e.tileID.overscaledZ,tileSize:this.tileSize*e.tileID.overscaleFactor(),type:this.type,source:this.id,pixelRatio:it.devicePixelRatio,showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,isSymbolTile:e.isSymbolTile};if(r.request.collectResourceTiming=this._collectResourceTiming,e.actor&&"expired"!==e.state)"loading"===e.state?e.reloadCallback=t:e.request=e.actor.send("reloadTile",r,n.bind(this));else if(e.actor=this._tileWorkers[i]=this._tileWorkers[i]||this.dispatcher.getActor(),this.dispatcher.ready)e.request=e.actor.send("loadTile",r,n.bind(this),void 0,!0);else{const t=bd.call({deduped:this._deduped},r,((t,i)=>{t||!i?n.call(this,t):(r.data={cacheControl:i.cacheControl,expires:i.expires,rawData:i.rawData.slice(0)},e.actor&&e.actor.send("loadTile",r,n.bind(this),void 0,!0))}),!0);e.request={cancel:t}}function n(i,r){return delete e.request,e.aborted?t(null):i&&404!==i.status?t(i):(r&&r.resourceTiming&&(e.resourceTiming=r.resourceTiming),this.map._refreshExpiredTiles&&r&&e.setExpiryData(r),e.loadVectorData(r,this.map.painter),fe(this.dispatcher),t(null),void(e.reloadCallback&&(this.loadTile(e,e.reloadCallback),e.reloadCallback=null)))}}abortTile(e){e.request&&(e.request.cancel(),delete e.request),e.actor&&e.actor.send("abortTile",{uid:e.uid,type:this.type,source:this.id})}unloadTile(e){e.unloadVectorData(),e.actor&&e.actor.send("removeTile",{uid:e.uid,type:this.type,source:this.id})}hasTransition(){return!1}afterUpdate(){this._tileWorkers={}}cancelTileJSONRequest(){this._tileJSONRequest&&(this._tileJSONRequest.cancel(),this._tileJSONRequest=null)}}class RasterTileSource extends Evented{constructor(e,t,i,r){super(),this.id=e,this.dispatcher=i,this.setEventedParent(r),this.type="raster",this.minzoom=0,this.maxzoom=22,this.roundZoom=!0,this.scheme="xyz",this.tileSize=512,this._loaded=!1,this._options=L({type:"raster"},t),L(this,B(t,["url","scheme","tileSize"]))}load(e){this._loaded=!1,this.fire(new Event("dataloading",{dataType:"source"})),this._tileJSONRequest=Zh(this._options,this.map._requestManager,null,null,((t,i)=>{this._tileJSONRequest=null,this._loaded=!0,t?this.fire(new ErrorEvent(t)):i&&(L(this,i),i.bounds&&(this.tileBounds=new TileBounds(i.bounds,this.minzoom,this.maxzoom)),Fe(i.tiles),this.fire(new Event("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new Event("data",{dataType:"source",sourceDataType:"content"}))),e&&e(t)}))}loaded(){return this._loaded}onAdd(e){this.map=e,this.load()}reload(){this.cancelTileJSONRequest(),this.load((()=>this.map.style._clearSource(this.id)))}setTiles(e){return this._options.tiles=e,this.reload(),this}setUrl(e){return this.url=e,this._options.url=e,this.reload(),this}onRemove(){this.cancelTileJSONRequest()}serialize(){return L({},this._options)}hasTile(e){return!this.tileBounds||this.tileBounds.contains(e.canonical)}loadTile(e,t){const i=it.devicePixelRatio>=2,r=this.map._requestManager.normalizeTileURL(e.tileID.canonical.url(this.tiles,this.scheme),i,this.tileSize);e.request=Te(this.map._requestManager.transformRequest(r,me.Tile),((i,r,n,o)=>(delete e.request,e.aborted?(e.state="unloaded",t(null)):i?(e.state="errored",t(i)):r?(this.map._refreshExpiredTiles&&e.setExpiryData({cacheControl:n,expires:o}),e.setTexture(r,this.map.painter),e.state="loaded",fe(this.dispatcher),void t(null)):t(null))))}static loadTileData(e,t,i){e.setTexture(t,i)}static unloadTileData(e,t){e.texture&&t.saveTileTexture(e.texture)}abortTile(e,t){e.request&&(e.request.cancel(),delete e.request),t()}unloadTile(e,t){e.texture&&this.map.painter.saveTileTexture(e.texture),t()}hasTransition(){return!1}cancelTileJSONRequest(){this._tileJSONRequest&&(this._tileJSONRequest.cancel(),this._tileJSONRequest=null)}}let wd;function Ed(e,t,i,r,n,o,s,a){const l=[e,i,n,t,r,o,1,1,1],c=[s,a,1],u=qo([],l),[h,d,p]=Es(c,c,function(e,t){if(e===t){var i=t[1],r=t[2],n=t[5];e[1]=t[3],e[2]=t[6],e[3]=i,e[5]=t[7],e[6]=r,e[7]=n}else e[0]=t[0],e[1]=t[3],e[2]=t[6],e[3]=t[1],e[4]=t[4],e[5]=t[7],e[6]=t[2],e[7]=t[5],e[8]=t[8];return e}(u,u));return Zo(l,[h,0,0,0,d,0,0,0,p],l)}class ImageSource extends Evented{constructor(e,t,i,r){super(),this.id=e,this.dispatcher=i,this.coordinates=t.coordinates,this.type="image",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this.tiles={},this._loaded=!1,this.setEventedParent(r),this.options=t,this._dirty=!1}load(t,i){this._loaded=i||!1,this.fire(new Event("dataloading",{dataType:"source"})),this.url=this.options.url,this._imageRequest=Te(this.map._requestManager.transformRequest(this.url,me.Image),((i,r)=>{if(this._imageRequest=null,this._loaded=!0,i)this.fire(new ErrorEvent(i));else if(r){const{HTMLImageElement:i}=e;this.image=r instanceof i?it.getImageData(r):r,this._dirty=!0,this.width=this.image.width,this.height=this.image.height,t&&(this.coordinates=t),this._finishLoading()}}))}loaded(){return this._loaded}updateImage(e){return this.image&&e.url?(this._imageRequest&&e.url!==this.options.url&&(this._imageRequest.cancel(),this._imageRequest=null),this.options.url=e.url,this.load(e.coordinates,this._loaded),this):this}_finishLoading(){this.map&&(this.setCoordinates(this.coordinates),this.fire(new Event("data",{dataType:"source",sourceDataType:"metadata"})))}onAdd(e){this.map=e,this.load()}onRemove(){this._imageRequest&&(this._imageRequest.cancel(),this._imageRequest=null),this.texture&&this.texture.destroy()}setCoordinates(e){this.coordinates=e,this._boundsArray=void 0;const t=e.map(MercatorCoordinate.fromLngLat);return this.tileID=function(e){let t=1/0,i=1/0,r=-1/0,n=-1/0;for(const o of e)t=Math.min(t,o.x),i=Math.min(i,o.y),r=Math.max(r,o.x),n=Math.max(n,o.y);const o=Math.max(r-t,n-i),s=Math.max(0,Math.floor(-Math.log(o)/Math.LN2)),a=Math.pow(2,s);return new CanonicalTileID(s,Math.floor((t+r)/2*a),Math.floor((i+n)/2*a))}(t),this.minzoom=this.maxzoom=this.tileID.z,this.fire(new Event("data",{dataType:"source",sourceDataType:"content"})),this}_clear(){this._boundsArray=void 0}_prepareData(e){for(const e in this.tiles){const t=this.tiles[e];"loaded"!==t.state&&(t.state="loaded",t.texture=this.texture)}if(this._boundsArray)return;const t=nh(this.tileID,this.map.transform.projection),[i,r,n,o]=this.coordinates.map((e=>{const i=t.projection.project(e[0],e[1]);return sh(t,i)._round()}));this.perspectiveTransform=function(e,t,i,r,n,o,s,a,l,c){const u=Ed(0,0,e,0,0,t,e,t),h=Ed(i,r,n,o,s,a,l,c);return Zo(h,qo(u,u),h),[h[6]/h[8]*e/Uo,h[7]/h[8]*t/Uo]}(this.width,this.height,i.x,i.y,r.x,r.y,o.x,o.y,n.x,n.y);const s=this._boundsArray=new StructArrayLayout4i8;s.emplaceBack(i.x,i.y,0,0),s.emplaceBack(r.x,r.y,Uo,0),s.emplaceBack(o.x,o.y,0,Uo),s.emplaceBack(n.x,n.y,Uo,Uo),this.boundsBuffer&&this.boundsBuffer.destroy(),this.boundsBuffer=e.createVertexBuffer(s,ed.members),this.boundsSegments=SegmentVector.simpleSegment(0,0,4,2)}prepare(){if(0===Object.keys(this.tiles).length||!this.image)return;const e=this.map.painter.context,t=e.gl;this._dirty&&(this.texture?this.texture.update(this.image):(this.texture=new Texture(e,this.image,t.RGBA),this.texture.bind(t.LINEAR,t.CLAMP_TO_EDGE)),this._dirty=!1),this._prepareData(e)}loadTile(e,t){this.tileID&&this.tileID.equals(e.tileID.canonical)?(this.tiles[String(e.tileID.wrap)]=e,e.buckets={},t(null)):(e.state="errored",t(null))}serialize(){return{type:"image",url:this.options.url,coordinates:this.coordinates}}hasTransition(){return!1}}const Td={vector:VectorTileSource,raster:RasterTileSource,"raster-dem":class RasterDEMTileSource extends RasterTileSource{constructor(e,t,i,r){super(e,t,i,r),this.type="raster-dem",this.maxzoom=22,this._options=L({type:"raster-dem"},t),this.encoding=t.encoding||"mapbox"}loadTile(t,i){const r=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme),!1,this.tileSize);function n(e,r){e&&(t.state="errored",i(e)),r&&(t.dem=r,t.dem.onDeserialize(),t.needsHillshadePrepare=!0,t.needsDEMTextureUpload=!0,t.state="loaded",i(null))}t.request=Te(this.map._requestManager.transformRequest(r,me.Tile),function(r,o,s,a){if(delete t.request,t.aborted)t.state="unloaded",i(null);else if(r)t.state="errored",i(r);else if(o){this.map._refreshExpiredTiles&&t.setExpiryData({cacheControl:s,expires:a});const i=e.ImageBitmap&&o instanceof e.ImageBitmap&&(null==wd&&(wd=e.OffscreenCanvas&&new e.OffscreenCanvas(1,1).getContext("2d")&&"function"==typeof e.createImageBitmap),wd),r=1-(o.width-((l=o.width)<=1?1:Math.pow(2,Math.floor(Math.log(l)/Math.LN2))))/2;r<1||t.neighboringTiles||(t.neighboringTiles=this._getNeighboringTiles(t.tileID));const c=i?o:it.getImageData(o,r),u={uid:t.uid,coord:t.tileID,source:this.id,rawImageData:c,encoding:this.encoding,padding:r};t.actor&&"expired"!==t.state||(t.actor=this.dispatcher.getActor(),t.actor.send("loadDEMTile",u,n.bind(this),void 0,!0))}var l}.bind(this))}_getNeighboringTiles(e){const t=e.canonical,i=Math.pow(2,t.z),r=(t.x-1+i)%i,n=0===t.x?e.wrap-1:e.wrap,o=(t.x+1+i)%i,s=t.x+1===i?e.wrap+1:e.wrap,a={};return a[new OverscaledTileID(e.overscaledZ,n,t.z,r,t.y).key]={backfilled:!1},a[new OverscaledTileID(e.overscaledZ,s,t.z,o,t.y).key]={backfilled:!1},t.y>0&&(a[new OverscaledTileID(e.overscaledZ,n,t.z,r,t.y-1).key]={backfilled:!1},a[new OverscaledTileID(e.overscaledZ,e.wrap,t.z,t.x,t.y-1).key]={backfilled:!1},a[new OverscaledTileID(e.overscaledZ,s,t.z,o,t.y-1).key]={backfilled:!1}),t.y+1<i&&(a[new OverscaledTileID(e.overscaledZ,n,t.z,r,t.y+1).key]={backfilled:!1},a[new OverscaledTileID(e.overscaledZ,e.wrap,t.z,t.x,t.y+1).key]={backfilled:!1},a[new OverscaledTileID(e.overscaledZ,s,t.z,o,t.y+1).key]={backfilled:!1}),a}unloadTile(e){e.demTexture&&this.map.painter.saveTileTexture(e.demTexture),e.fbo&&(e.fbo.destroy(),delete e.fbo),e.dem&&delete e.dem,delete e.neighboringTiles,e.state="unloaded"}},geojson:class GeoJSONSource extends Evented{constructor(e,t,i,r){super(),this.id=e,this.type="geojson",this.minzoom=0,this.maxzoom=18,this.tileSize=512,this.isTileClipped=!0,this.reparseOverscaled=!0,this._loaded=!1,this.actor=i.getActor(),this.setEventedParent(r),this._data=t.data,this._options=L({},t),this._collectResourceTiming=t.collectResourceTiming,void 0!==t.maxzoom&&(this.maxzoom=t.maxzoom),t.type&&(this.type=t.type),t.attribution&&(this.attribution=t.attribution),this.promoteId=t.promoteId;const n=Uo/this.tileSize;this.workerOptions=L({source:this.id,cluster:t.cluster||!1,geojsonVtOptions:{buffer:(void 0!==t.buffer?t.buffer:128)*n,tolerance:(void 0!==t.tolerance?t.tolerance:.375)*n,extent:Uo,maxZoom:this.maxzoom,lineMetrics:t.lineMetrics||!1,generateId:t.generateId||!1},superclusterOptions:{maxZoom:void 0!==t.clusterMaxZoom?t.clusterMaxZoom:this.maxzoom-1,minPoints:Math.max(2,t.clusterMinPoints||2),extent:Uo,radius:(void 0!==t.clusterRadius?t.clusterRadius:50)*n,log:!1,generateId:t.generateId||!1},clusterProperties:t.clusterProperties,filter:t.filter},t.workerOptions)}onAdd(e){this.map=e,this.setData(this._data)}setData(e){return this._data=e,this._updateWorkerData(),this}getClusterExpansionZoom(e,t){return this.actor.send("geojson.getClusterExpansionZoom",{clusterId:e,source:this.id},t),this}getClusterChildren(e,t){return this.actor.send("geojson.getClusterChildren",{clusterId:e,source:this.id},t),this}getClusterLeaves(e,t,i,r){return this.actor.send("geojson.getClusterLeaves",{source:this.id,clusterId:e,limit:t,offset:i},r),this}_updateWorkerData(){if(this._pendingLoad)return void(this._coalesce=!0);this.fire(new Event("dataloading",{dataType:"source"})),this._loaded=!1;const e=L({},this.workerOptions),t=this._data;"string"==typeof t?(e.request=this.map._requestManager.transformRequest(it.resolveURL(t),me.Source),e.request.collectResourceTiming=this._collectResourceTiming):e.data=JSON.stringify(t),this._pendingLoad=this.actor.send(`${this.type}.loadData`,e,((e,t)=>{if(this._loaded=!0,this._pendingLoad=null,e)this.fire(new ErrorEvent(e));else{const e={dataType:"source",sourceDataType:this._metadataFired?"content":"metadata"};this._collectResourceTiming&&t&&t.resourceTiming&&t.resourceTiming[this.id]&&(e.resourceTiming=t.resourceTiming[this.id]),this.fire(new Event("data",e)),this._metadataFired=!0}this._coalesce&&(this._updateWorkerData(),this._coalesce=!1)}))}loaded(){return this._loaded}loadTile(e,t){const i=e.actor?"reloadTile":"loadTile";e.actor=this.actor,e.request=this.actor.send(i,{type:this.type,uid:e.uid,tileID:e.tileID,tileZoom:e.tileZoom,zoom:e.tileID.overscaledZ,maxZoom:this.maxzoom,tileSize:this.tileSize,source:this.id,pixelRatio:it.devicePixelRatio,showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId},((r,n)=>(delete e.request,e.unloadVectorData(),e.aborted?t(null):r?t(r):(e.loadVectorData(n,this.map.painter,"reloadTile"===i),t(null)))),void 0,"loadTile"===i)}abortTile(e){e.request&&(e.request.cancel(),delete e.request),e.aborted=!0}unloadTile(e){e.unloadVectorData(),this.actor.send("removeTile",{uid:e.uid,type:this.type,source:this.id})}onRemove(){this._pendingLoad&&this._pendingLoad.cancel()}serialize(){return L({},this._options,{type:this.type,data:this._data})}hasTransition(){return!1}},video:class VideoSource extends ImageSource{constructor(e,t,i,r){super(e,t,i,r),this.roundZoom=!0,this.type="video",this.options=t}load(){this._loaded=!1;const t=this.options;this.urls=[];for(const e of t.urls)this.urls.push(this.map._requestManager.transformRequest(e,me.Source).url);!function(t,i){const r=e.document.createElement("video");r.muted=!0,r.onloadstart=function(){i(null,r)};for(let i=0;i<t.length;i++){const n=e.document.createElement("source");ve(t[i])||(r.crossOrigin="Anonymous"),n.src=t[i],r.appendChild(n)}}(this.urls,((e,t)=>{this._loaded=!0,e?this.fire(new ErrorEvent(e)):t&&(this.video=t,this.video.loop=!0,this.video.setAttribute("playsinline",""),this.video.addEventListener("playing",(()=>{this.map.triggerRepaint()})),this.map&&this.video.play(),this._finishLoading())}))}pause(){this.video&&this.video.pause()}play(){this.video&&this.video.play()}seek(e){if(this.video){const t=this.video.seekable;e<t.start(0)||e>t.end(0)?this.fire(new ErrorEvent(new ValidationError(`sources.${this.id}`,null,`Playback for this video can be set only between the ${t.start(0)} and ${t.end(0)}-second mark.`))):this.video.currentTime=e}}getVideo(){return this.video}onAdd(e){this.map||(this.map=e,this.load(),this.video&&(this.video.play(),this.setCoordinates(this.coordinates)))}prepare(){if(0===Object.keys(this.tiles).length||this.video.readyState<2)return;const e=this.map.painter.context,t=e.gl;this.texture?this.video.paused||(this.texture.bind(t.LINEAR,t.CLAMP_TO_EDGE),t.texSubImage2D(t.TEXTURE_2D,0,0,0,t.RGBA,t.UNSIGNED_BYTE,this.video)):(this.texture=new Texture(e,this.video,t.RGBA),this.texture.bind(t.LINEAR,t.CLAMP_TO_EDGE),this.width=this.video.videoWidth,this.height=this.video.videoHeight),this._prepareData(e)}serialize(){return{type:"video",urls:this.urls,coordinates:this.coordinates}}hasTransition(){return this.video&&!this.video.paused}},image:ImageSource,canvas:class CanvasSource extends ImageSource{constructor(t,i,r,n){super(t,i,r,n),i.coordinates?Array.isArray(i.coordinates)&&4===i.coordinates.length&&!i.coordinates.some((e=>!Array.isArray(e)||2!==e.length||e.some((e=>"number"!=typeof e))))||this.fire(new ErrorEvent(new ValidationError(`sources.${t}`,null,'"coordinates" property must be an array of 4 longitude/latitude array pairs'))):this.fire(new ErrorEvent(new ValidationError(`sources.${t}`,null,'missing required property "coordinates"'))),i.animate&&"boolean"!=typeof i.animate&&this.fire(new ErrorEvent(new ValidationError(`sources.${t}`,null,'optional "animate" property must be a boolean value'))),i.canvas?"string"==typeof i.canvas||i.canvas instanceof e.HTMLCanvasElement||this.fire(new ErrorEvent(new ValidationError(`sources.${t}`,null,'"canvas" must be either a string representing the ID of the canvas element from which to read, or an HTMLCanvasElement instance'))):this.fire(new ErrorEvent(new ValidationError(`sources.${t}`,null,'missing required property "canvas"'))),this.options=i,this.animate=void 0===i.animate||i.animate}load(){this._loaded=!0,this.canvas||(this.canvas=this.options.canvas instanceof e.HTMLCanvasElement?this.options.canvas:e.document.getElementById(this.options.canvas)),this.width=this.canvas.width,this.height=this.canvas.height,this._hasInvalidDimensions()?this.fire(new ErrorEvent(new Error("Canvas dimensions cannot be less than or equal to zero."))):(this.play=function(){this._playing=!0,this.map.triggerRepaint()},this.pause=function(){this._playing&&(this.prepare(),this._playing=!1)},this._finishLoading())}getCanvas(){return this.canvas}onAdd(e){this.map=e,this.load(),this.canvas&&this.animate&&this.play()}onRemove(){this.pause()}prepare(){let e=!1;if(this.canvas.width!==this.width&&(this.width=this.canvas.width,e=!0),this.canvas.height!==this.height&&(this.height=this.canvas.height,e=!0),this._hasInvalidDimensions())return;if(0===Object.keys(this.tiles).length)return;const t=this.map.painter.context;this.texture?(e||this._playing)&&this.texture.update(this.canvas,{premultiply:!0}):this.texture=new Texture(t,this.canvas,t.gl.RGBA,{premultiply:!0}),this._prepareData(t)}serialize(){return{type:"canvas",coordinates:this.coordinates}}hasTransition(){return this._playing}_hasInvalidDimensions(){for(const e of[this.canvas.width,this.canvas.height])if(isNaN(e)||e<=0)return!0;return!1}},custom:class CustomSource extends Evented{constructor(e,t,i,r){super(),this.id=e,this.type="custom",this._dataType="raster",this._dispatcher=i,this._implementation=t,this.setEventedParent(r),this.scheme="xyz",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this._loaded=!1,this.roundZoom=!0,this._implementation||this.fire(new ErrorEvent(new Error(`Missing implementation for ${this.id} custom source`))),this._implementation.loadTile||this.fire(new ErrorEvent(new Error(`Missing loadTile implementation for ${this.id} custom source`))),this._implementation.bounds&&(this.tileBounds=new TileBounds(this._implementation.bounds,this.minzoom,this.maxzoom)),t.update=this._update.bind(this),t.clearTiles=this._clearTiles.bind(this),t.coveringTiles=this._coveringTiles.bind(this),L(this,B(t,["dataType","scheme","minzoom","maxzoom","tileSize","attribution","minTileCacheSize","maxTileCacheSize"]))}serialize(){return B(this,["type","scheme","minzoom","maxzoom","tileSize","attribution"])}load(){this._loaded=!0,this.fire(new Event("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new Event("data",{dataType:"source",sourceDataType:"content"}))}loaded(){return this._loaded}onAdd(e){this._map=e,this._loaded=!1,this.fire(new Event("dataloading",{dataType:"source"})),this._implementation.onAdd&&this._implementation.onAdd(e),this.load()}onRemove(e){this._implementation.onRemove&&this._implementation.onRemove(e)}hasTile(e){if(this._implementation.hasTile){const{x:t,y:i,z:r}=e.canonical;return this._implementation.hasTile({x:t,y:i,z:r})}return!this.tileBounds||this.tileBounds.contains(e.canonical)}loadTile(t,i){const{x:r,y:n,z:o}=t.tileID.canonical,s=new e.AbortController;t.request=Promise.resolve(this._implementation.loadTile({x:r,y:n,z:o},{signal:s.signal})).then(function(r){return delete t.request,t.aborted?(t.state="unloaded",i(null)):void 0===r?(t.state="errored",i(null)):null===r?(this.loadTileData(t,{width:this.tileSize,height:this.tileSize,data:null}),t.state="loaded",i(null)):function(t){return t instanceof e.ImageData||t instanceof e.HTMLCanvasElement||t instanceof e.ImageBitmap||t instanceof e.HTMLImageElement}(r)?(this.loadTileData(t,r),t.state="loaded",void i(null)):(t.state="errored",i(new Error(`Can't infer data type for ${this.id}, only raster data supported at the moment`)))}.bind(this)).catch((e=>{20!==e.code&&(t.state="errored",i(e))})),t.request.cancel=()=>s.abort()}loadTileData(e,t){RasterTileSource.loadTileData(e,t,this._map.painter)}unloadTileData(e){RasterTileSource.unloadTileData(e,this._map.painter)}unloadTile(e,t){if(this.unloadTileData(e),this._implementation.unloadTile){const{x:t,y:i,z:r}=e.tileID.canonical;this._implementation.unloadTile({x:t,y:i,z:r})}t()}abortTile(e,t){e.request&&e.request.cancel&&(e.request.cancel(),delete e.request),t()}hasTransition(){return!1}_coveringTiles(){return this._map.transform.coveringTiles({tileSize:this.tileSize,minzoom:this.minzoom,maxzoom:this.maxzoom,roundZoom:this.roundZoom}).map((e=>({x:e.canonical.x,y:e.canonical.y,z:e.canonical.z})))}_clearTiles(){this._map.style._clearSource(this.id)}_update(){this.fire(new Event("data",{dataType:"source",sourceDataType:"content"}))}}},Sd=function(e,t,i,r){const n=new Td[t.type](e,t,i,r);if(n.id!==e)throw new Error(`Expected Source id to be ${e} instead of ${n.id}`);return j(["load","abort","unload","serialize","prepare"],n),n};function Ad(e,t){const i=Wo([]);return Jo(i,i,[.5*e.width,.5*-e.height,1]),Ko(i,i,[1,-1,0]),Xo(i,i,e.calculateProjMatrix(t.toUnwrapped())),Float32Array.from(i)}function Cd(e,t,i,r,n,o,s,a=!1){const l=e.tilesIn(r,s,a);l.sort(Md);const c=[];for(const r of l)c.push({wrappedTileID:r.tile.tileID.wrapped().key,queryResults:r.tile.queryRenderedFeatures(t,i,e._state,r,n,o,Ad(e.transform,r.tile.tileID),a)});const u=function(e){const t={},i={};for(const r of e){const e=r.queryResults,n=r.wrappedTileID,o=i[n]=i[n]||{};for(const i in e){const r=e[i],n=o[i]=o[i]||{},s=t[i]=t[i]||[];for(const e of r)n[e.featureIndex]||(n[e.featureIndex]=!0,s.push(e))}}return t}(c);for(const t in u)u[t].forEach((t=>{const i=t.feature,r=i.layer;r&&"background"!==r.type&&"sky"!==r.type&&(i.source=r.source,r["source-layer"]&&(i.sourceLayer=r["source-layer"]),i.state=void 0!==i.id?e.getFeatureState(r["source-layer"],i.id):{})}));return u}function Id(e,t){const i=e.getRenderableIds().map((t=>e.getTileByID(t))),r=[],n={};for(let e=0;e<i.length;e++){const o=i[e],s=o.tileID.canonical.key;n[s]||(n[s]=!0,o.querySourceFeatures(r,t))}return r}function Md(e,t){const i=e.tileID,r=t.tileID;return i.overscaledZ-r.overscaledZ||i.canonical.y-r.canonical.y||i.wrap-r.wrap||i.canonical.x-r.canonical.x}function Pd(){return null!=Qm.workerClass?new Qm.workerClass:new e.Worker(Qm.workerUrl)}const Dd="mapboxgl_preloaded_worker_pool";class WorkerPool{constructor(){this.active={}}acquire(e){if(!this.workers)for(this.workers=[];this.workers.length<WorkerPool.workerCount;)this.workers.push(new Pd);return this.active[e]=!0,this.workers.slice()}release(e){delete this.active[e],0===this.numActive()&&(this.workers.forEach((e=>{e.terminate()})),this.workers=null)}isPreloaded(){return!!this.active[Dd]}numActive(){return Object.keys(this.active).length}}let zd;function kd(){return zd||(zd=new WorkerPool),zd}WorkerPool.workerCount=2;var Ld=["type","source","source-layer","minzoom","maxzoom","filter","layout"];function Bd(e,t){const i={};for(const t in e)"ref"!==t&&(i[t]=e[t]);return Ld.forEach((e=>{e in t&&(i[e]=t[e])})),i}function Rd(e){e=e.slice();const t=Object.create(null);for(let i=0;i<e.length;i++)t[e[i].id]=e[i];for(let i=0;i<e.length;i++)"ref"in e[i]&&(e[i]=Bd(e[i],t[e[i].ref]));return e}const Fd={setStyle:"setStyle",addLayer:"addLayer",removeLayer:"removeLayer",setPaintProperty:"setPaintProperty",setLayoutProperty:"setLayoutProperty",setFilter:"setFilter",addSource:"addSource",removeSource:"removeSource",setGeoJSONSourceData:"setGeoJSONSourceData",setLayerZoomRange:"setLayerZoomRange",setLayerProperty:"setLayerProperty",setCenter:"setCenter",setZoom:"setZoom",setBearing:"setBearing",setPitch:"setPitch",setSprite:"setSprite",setGlyphs:"setGlyphs",setTransition:"setTransition",setLight:"setLight",setTerrain:"setTerrain",setFog:"setFog",setProjection:"setProjection"};function Od(e,t,i){i.push({command:Fd.addSource,args:[e,t[e]]})}function Ud(e,t,i){t.push({command:Fd.removeSource,args:[e]}),i[e]=!0}function Vd(e,t,i,r){Ud(e,i,r),Od(e,t,i)}function jd(e,t,i){let r;for(r in e[i])if(e[i].hasOwnProperty(r)&&"data"!==r&&!y(e[i][r],t[i][r]))return!1;for(r in t[i])if(t[i].hasOwnProperty(r)&&"data"!==r&&!y(e[i][r],t[i][r]))return!1;return!0}function Nd(e,t,i,r,n,o){let s;for(s in t=t||{},e=e||{})e.hasOwnProperty(s)&&(y(e[s],t[s])||i.push({command:o,args:[r,s,t[s],n]}));for(s in t)t.hasOwnProperty(s)&&!e.hasOwnProperty(s)&&(y(e[s],t[s])||i.push({command:o,args:[r,s,t[s],n]}))}function Gd(e){return e.id}function qd(e,t){return e[t.id]=t,e}class PathInterpolator{constructor(e,t){this.reset(e,t)}reset(e,t){this.points=e||[],this._distances=[0];for(let e=1;e<this.points.length;e++)this._distances[e]=this._distances[e-1]+this.points[e].dist(this.points[e-1]);this.length=this._distances[this._distances.length-1],this.padding=Math.min(t||0,.5*this.length),this.paddedLength=this.length-2*this.padding}lerp(e){if(1===this.points.length)return this.points[0];e=M(e,0,1);let t=1,i=this._distances[t];const r=e*this.paddedLength+this.padding;for(;i<r&&t<this._distances.length;)i=this._distances[++t];const n=t-1,o=this._distances[n],s=i-o,a=s>0?(r-o)/s:0;return this.points[n].mult(1-a).add(this.points[t].mult(a))}}class GridIndex{constructor(e,t,i){const r=this.boxCells=[],n=this.circleCells=[];this.xCellCount=Math.ceil(e/i),this.yCellCount=Math.ceil(t/i);for(let e=0;e<this.xCellCount*this.yCellCount;e++)r.push([]),n.push([]);this.circleKeys=[],this.boxKeys=[],this.bboxes=[],this.circles=[],this.width=e,this.height=t,this.xScale=this.xCellCount/e,this.yScale=this.yCellCount/t,this.boxUid=0,this.circleUid=0}keysLength(){return this.boxKeys.length+this.circleKeys.length}insert(e,t,i,r,n){this._forEachCell(t,i,r,n,this._insertBoxCell,this.boxUid++),this.boxKeys.push(e),this.bboxes.push(t),this.bboxes.push(i),this.bboxes.push(r),this.bboxes.push(n)}insertCircle(e,t,i,r){this._forEachCell(t-r,i-r,t+r,i+r,this._insertCircleCell,this.circleUid++),this.circleKeys.push(e),this.circles.push(t),this.circles.push(i),this.circles.push(r)}_insertBoxCell(e,t,i,r,n,o){this.boxCells[n].push(o)}_insertCircleCell(e,t,i,r,n,o){this.circleCells[n].push(o)}_query(e,t,i,r,n,o){if(i<0||e>this.width||r<0||t>this.height)return!n&&[];const s=[];if(e<=0&&t<=0&&this.width<=i&&this.height<=r){if(n)return!0;for(let e=0;e<this.boxKeys.length;e++)s.push({key:this.boxKeys[e],x1:this.bboxes[4*e],y1:this.bboxes[4*e+1],x2:this.bboxes[4*e+2],y2:this.bboxes[4*e+3]});for(let e=0;e<this.circleKeys.length;e++){const t=this.circles[3*e],i=this.circles[3*e+1],r=this.circles[3*e+2];s.push({key:this.circleKeys[e],x1:t-r,y1:i-r,x2:t+r,y2:i+r})}return o?s.filter(o):s}return this._forEachCell(e,t,i,r,this._queryCell,s,{hitTest:n,seenUids:{box:{},circle:{}}},o),n?s.length>0:s}_queryCircle(e,t,i,r,n){const o=e-i,s=e+i,a=t-i,l=t+i;if(s<0||o>this.width||l<0||a>this.height)return!r&&[];const c=[];return this._forEachCell(o,a,s,l,this._queryCellCircle,c,{hitTest:r,circle:{x:e,y:t,radius:i},seenUids:{box:{},circle:{}}},n),r?c.length>0:c}query(e,t,i,r,n){return this._query(e,t,i,r,!1,n)}hitTest(e,t,i,r,n){return this._query(e,t,i,r,!0,n)}hitTestCircle(e,t,i,r){return this._queryCircle(e,t,i,!0,r)}_queryCell(e,t,i,r,n,o,s,a){const l=s.seenUids,c=this.boxCells[n];if(null!==c){const n=this.bboxes;for(const u of c)if(!l.box[u]){l.box[u]=!0;const c=4*u;if(e<=n[c+2]&&t<=n[c+3]&&i>=n[c+0]&&r>=n[c+1]&&(!a||a(this.boxKeys[u]))){if(s.hitTest)return o.push(!0),!0;o.push({key:this.boxKeys[u],x1:n[c],y1:n[c+1],x2:n[c+2],y2:n[c+3]})}}}const u=this.circleCells[n];if(null!==u){const n=this.circles;for(const c of u)if(!l.circle[c]){l.circle[c]=!0;const u=3*c;if(this._circleAndRectCollide(n[u],n[u+1],n[u+2],e,t,i,r)&&(!a||a(this.circleKeys[c]))){if(s.hitTest)return o.push(!0),!0;{const e=n[u],t=n[u+1],i=n[u+2];o.push({key:this.circleKeys[c],x1:e-i,y1:t-i,x2:e+i,y2:t+i})}}}}}_queryCellCircle(e,t,i,r,n,o,s,a){const l=s.circle,c=s.seenUids,u=this.boxCells[n];if(null!==u){const e=this.bboxes;for(const t of u)if(!c.box[t]){c.box[t]=!0;const i=4*t;if(this._circleAndRectCollide(l.x,l.y,l.radius,e[i+0],e[i+1],e[i+2],e[i+3])&&(!a||a(this.boxKeys[t])))return o.push(!0),!0}}const h=this.circleCells[n];if(null!==h){const e=this.circles;for(const t of h)if(!c.circle[t]){c.circle[t]=!0;const i=3*t;if(this._circlesCollide(e[i],e[i+1],e[i+2],l.x,l.y,l.radius)&&(!a||a(this.circleKeys[t])))return o.push(!0),!0}}}_forEachCell(e,t,i,r,n,o,s,a){const l=this._convertToXCellCoord(e),c=this._convertToYCellCoord(t),u=this._convertToXCellCoord(i),h=this._convertToYCellCoord(r);for(let d=l;d<=u;d++)for(let l=c;l<=h;l++)if(n.call(this,e,t,i,r,this.xCellCount*l+d,o,s,a))return}_convertToXCellCoord(e){return Math.max(0,Math.min(this.xCellCount-1,Math.floor(e*this.xScale)))}_convertToYCellCoord(e){return Math.max(0,Math.min(this.yCellCount-1,Math.floor(e*this.yScale)))}_circlesCollide(e,t,i,r,n,o){const s=r-e,a=n-t,l=i+o;return l*l>s*s+a*a}_circleAndRectCollide(e,t,i,r,n,o,s){const a=(o-r)/2,l=Math.abs(e-(r+a));if(l>a+i)return!1;const c=(s-n)/2,u=Math.abs(t-(n+c));if(u>c+i)return!1;if(l<=a||u<=c)return!0;const h=l-a,d=u-c;return h*h+d*d<=i*i}}const Zd={unknown:0,flipRequired:1,flipNotRequired:2},$d=Math.tan(85*Math.PI/180);function Wd(e,t,i,r,n,o,s){const a=$o();if(i)if("globe"===o.name){const e=function(e,t){const{x:i,y:r}=e.point,n=_a(i,r,e.worldSize/e._pixelsPerMercatorPixel,0,0);return Xo(n,n,fa(ta(t)))}(n,t);Xo(a,a,e)}else{const e=No([],s);a[0]=e[0],a[1]=e[1],a[4]=e[2],a[5]=e[3],r||es(a,a,n.angle)}else Xo(a,n.labelPlaneMatrix,e);return a}function Hd(e,t,i,r,n,o,s){const a=Wd(e,t,i,r,n,o,s);return"globe"===o.name&&i||(a[2]=a[6]=a[10]=a[14]=0),a}function Xd(e,t,i,r,n,o,s){if(i){if("globe"===o.name){const a=Wd(e,t,i,r,n,o,s);return Ho(a,a),Xo(a,e,a),a}{const t=(a=e,(l=new jo(16))[0]=a[0],l[1]=a[1],l[2]=a[2],l[3]=a[3],l[4]=a[4],l[5]=a[5],l[6]=a[6],l[7]=a[7],l[8]=a[8],l[9]=a[9],l[10]=a[10],l[11]=a[11],l[12]=a[12],l[13]=a[13],l[14]=a[14],l[15]=a[15],l),i=Wo([]);return i[0]=s[0],i[1]=s[1],i[4]=s[2],i[5]=s[3],Xo(t,t,i),r||es(t,t,-n.angle),t}}return n.glCoordMatrix;var a,l}function Kd(e,t,i,r){const n=[e,t,i,1];i?zs(n,n,r):ap(n,n,r);const o=n[3];return n[0]/=o,n[1]/=o,n[2]/=o,n}function Jd(e,t){return Math.min(.5+e/t*.5,1.5)}function Yd(e,t){const i=e[0]/e[3],r=e[1]/e[3];return i>=-t[0]&&i<=t[0]&&r>=-t[1]&&r<=t[1]}function Qd(e,t,i,r,n,o,s,a,l,c){const u=i.transform,h=r?e.textSizeData:e.iconSizeData,d=mu(h,i.transform.zoom),p="globe"===u.projection.name,f=[256/i.width*2+1,256/i.height*2+1],m=r?e.text.dynamicLayoutVertexArray:e.icon.dynamicLayoutVertexArray;m.clear();let _=null;p&&(_=r?e.text.globeExtVertexArray:e.icon.globeExtVertexArray);const y=e.lineVertexArray,x=r?e.text.placedSymbolArray:e.icon.placedSymbolArray,v=i.transform.width/i.transform.height;let b,w=!1;for(let r=0;r<x.length;r++){const p=x.get(r),{numGlyphs:E,writingMode:T}=p;if(T!==Wu.vertical||w||b===Wu.horizontal||(w=!0),b=T,(p.hidden||T===Wu.vertical)&&!w){sp(E,m);continue}w=!1;const S=new g(p.tileAnchorX,p.tileAnchorY);let{x:A,y:C,z:I}=u.projection.projectTilePoint(S.x,S.y,c.canonical);if(l){const[e,t,i]=l(S);A+=e,C+=t,I+=i}const M=[A,C,I,1];if(zs(M,M,t),!Yd(M,f)){sp(E,m);continue}const P=Jd(i.transform.cameraToCenterDistance,M[3]),D=fu(h,d,p),z=s?D/P:D*P,k=Kd(A,C,I,n);if(k[3]<=0){sp(E,m);continue}let L={};const B=s?null:l,R=ip(p,z,!1,a,t,n,o,e.glyphOffsetArray,y,m,_,k,S,L,v,B,u.projection,c,s);w=R.useVertical,B&&R.needsFlipping&&(L={}),(R.notEnoughRoom||w||R.needsFlipping&&ip(p,z,!0,a,t,n,o,e.glyphOffsetArray,y,m,_,k,S,L,v,B,u.projection,c,s).notEnoughRoom)&&sp(E,m)}r?(e.text.dynamicLayoutVertexBuffer.updateData(m),_&&e.text.globeExtVertexBuffer.updateData(_)):(e.icon.dynamicLayoutVertexBuffer.updateData(m),_&&e.icon.globeExtVertexBuffer.updateData(_))}function ep(e,t,i,r,n,o,s,a,l,c,u,h,d,p,f,m){const{lineStartIndex:_,glyphStartIndex:g,segment:y}=a,x=g+a.numGlyphs,v=_+a.lineLength,b=t.getoffsetX(g),w=t.getoffsetX(x-1),E=op(e*b,i,r,n,o,s,y,_,v,l,c,u,h,d,!0,p,f,m);if(!E)return null;const T=op(e*w,i,r,n,o,s,y,_,v,l,c,u,h,d,!0,p,f,m);return T?{first:E,last:T}:null}function tp(e,t,i,r){return e===Wu.horizontal&&Math.abs(r)>Math.abs(i)?{useVertical:!0}:e===Wu.vertical?r>0?{needsFlipping:!0}:null:t!==Zd.unknown&&function(e,t){return 0===e||Math.abs(t/e)>$d}(i,r)?t===Zd.flipRequired?{needsFlipping:!0}:null:i<0?{needsFlipping:!0}:null}function ip(e,t,i,r,n,o,s,a,l,c,u,h,d,p,f,m,_,y,x){const v=t/24,b=e.lineOffsetX*v,w=e.lineOffsetY*v,{lineStartIndex:E,glyphStartIndex:T,numGlyphs:S,segment:A,writingMode:C,flipState:I}=e,M=E+e.lineLength,P=e=>{if(u){const[t,i,r]=e.up,n=c.length;Eh(u,n+0,t,i,r),Eh(u,n+1,t,i,r),Eh(u,n+2,t,i,r),Eh(u,n+3,t,i,r)}const[t,i,r]=e.point;Th(c,t,i,r,e.angle)};if(S>1){const t=ep(v,a,b,w,i,h,d,e,l,o,p,m,!1,_,y,x);if(!t)return{notEnoughRoom:!0};if(r&&!i){let[i,r,n]=t.first.point,[o,a,l]=t.last.point;[i,r]=Kd(i,r,n,s),[o,a]=Kd(o,a,l,s);const c=tp(C,I,(o-i)*f,a-r);if(e.flipState=c&&c.needsFlipping?Zd.flipRequired:Zd.flipNotRequired,c)return c}P(t.first);for(let e=T+1;e<T+S-1;e++){const t=op(v*a.getoffsetX(e),b,w,i,h,d,A,E,M,l,o,p,m,!1,!1,_,y,x);if(!t)return c.length-=4*(e-T),{notEnoughRoom:!0};P(t)}P(t.last)}else{if(r&&!i){const t=Kd(d.x,d.y,0,n),i=E+A+1,r=new g(l.getx(i),l.gety(i)),o=Kd(r.x,r.y,0,n),s=o[3]>0?o:np(d,r,t,1,n,void 0,_,y.canonical),a=tp(C,I,(s[0]-t[0])*f,s[1]-t[1]);if(e.flipState=a&&a.needsFlipping?Zd.flipRequired:Zd.flipNotRequired,a)return a}const t=op(v*a.getoffsetX(T),b,w,i,h,d,A,E,M,l,o,p,m,!1,!1,_,y,x);if(!t)return{notEnoughRoom:!0};P(t)}return{}}function rp(e,t,i,r,n){const{x:o,y:s,z:a}=r.projectTilePoint(e.x,e.y,t);if(!n)return Kd(o,s,a,i);const[l,c,u]=n(e);return Kd(o+l,s+c,a+u,i)}function np(e,t,i,r,n,o,s,a){const l=rp(e.sub(t)._unit()._add(e),a,n,s,o);return As(l,i,l),xs(l,l),gs(l,i,l,r)}function op(e,t,i,r,n,o,s,a,l,c,u,h,d,p,f,m,_,y){const x=r?e-t:e+t;let v=x>0?1:-1,b=0;r&&(v*=-1,b=Math.PI),v<0&&(b+=Math.PI);let w=a+s+(v>0?0:1)|0,E=n,T=n,S=0,A=0;const C=Math.abs(x),I=[],M=[];let P=o,D=P;const z=()=>np(D,P,T,C-S+1,u,d,m,_.canonical);for(;S+A<=C;){if(w+=v,w<a||w>=l)return null;if(T=E,D=P,I.push(T),p&&M.push(D),P=new g(c.getx(w),c.gety(w)),E=h[w],!E){const e=rp(P,_.canonical,u,m,d);E=e[3]>0?h[w]=e:z()}S+=A,A=ys(T,E)}f&&d&&(h[w]&&(E=z(),A=ys(T,E)),h[w]=E);const k=(C-S)/A,L=P.sub(D)._mult(k)._add(D),B=As([],E,T),R=gs([],T,B,k);let F=[0,0,1],O=B[0],U=B[1];if(y&&(F=m.upVector(_.canonical,L.x,L.y),0!==F[0]||0!==F[1]||1!==F[2])){const e=[F[2],0,-F[0]],t=bs([],F,e);xs(e,e),xs(t,t),O=vs(B,e),U=vs(B,t)}if(i){const e=bs([],F,B);xs(e,e),gs(R,R,e,i*v)}const V=b+Math.atan2(U,O);return I.push(R),p&&M.push(L),{point:R,angle:V,path:I,tilePath:M,up:F}}function sp(e,t){const i=t.length,r=i+4*e;t.resize(r),t.float32.fill(-1/0,4*i,4*r)}function ap(e,t,i){const r=t[0],n=t[1];return e[0]=i[0]*r+i[4]*n+i[12],e[1]=i[1]*r+i[5]*n+i[13],e[3]=i[3]*r+i[7]*n+i[15],e}const lp=100;class CollisionIndex{constructor(e,t,i=new GridIndex(e.width+200,e.height+200,25),r=new GridIndex(e.width+200,e.height+200,25)){this.transform=e,this.grid=i,this.ignoredGrid=r,this.pitchfactor=Math.cos(e._pitch)*e.cameraToCenterDistance,this.screenRightBoundary=e.width+lp,this.screenBottomBoundary=e.height+lp,this.gridRightBoundary=e.width+200,this.gridBottomBoundary=e.height+200,this.fogState=t}placeCollisionBox(e,t,i,r,n,o,s,a){let l=i.projectedAnchorX,c=i.projectedAnchorY,u=i.projectedAnchorZ;const h=i.elevation,d=i.tileID,p=e.getProjection();if(h&&d){const[e,t,r]=p.upVector(d.canonical,i.tileAnchorX,i.tileAnchorY),n=p.upVectorScale(d.canonical,this.transform.center.lat,this.transform.worldSize).metersToTile;l+=e*h*n,c+=t*h*n,u+=r*h*n}const f=this.projectAndGetPerspectiveRatio(s,l,c,u,i.tileID,"globe"===p.name||!!h||this.transform.pitch>0,p),m=o*f.perspectiveRatio,_=(i.x1*t+r.x-i.padding)*m+f.point.x,g=(i.y1*t+r.y-i.padding)*m+f.point.y,y=(i.x2*t+r.x+i.padding)*m+f.point.x,x=(i.y2*t+r.y+i.padding)*m+f.point.y,v=f.perspectiveRatio<=.55||f.occluded;return!this.isInsideGrid(_,g,y,x)||!n&&this.grid.hitTest(_,g,y,x,a)||v?{box:[],offscreen:!1,occluded:f.occluded}:{box:[_,g,y,x],offscreen:this.isOffscreen(_,g,y,x),occluded:!1}}placeCollisionCircles(e,t,i,r,n,o,s,a,l,c,u,h,d,p,f){const m=[],_=this.transform.elevation,y=e.getProjection(),x=_?_.getAtTileOffsetFunc(f,this.transform.center.lat,this.transform.worldSize,y):null,v=new g(i.tileAnchorX,i.tileAnchorY);let{x:b,y:w,z:E}=y.projectTilePoint(v.x,v.y,f.canonical);if(x){const[e,t,i]=x(v);b+=e,w+=t,E+=i}const T="globe"===y.name,S=this.projectAndGetPerspectiveRatio(s,b,w,E,f,T||!!_||this.transform.pitch>0,y),{perspectiveRatio:A}=S,C=(u?o/A:o*A)/24,I=Kd(b,w,E,a),M=S.signedDistanceFromCamera>0?ep(C,n,i.lineOffsetX*C,i.lineOffsetY*C,!1,I,v,i,r,a,{},_&&!u?x:null,u&&!!_,y,f,u):null;let P=!1,D=!1,z=!0;if(M&&!S.occluded){const e=.5*d*A+p,i=new g(-100,-100),r=new g(this.screenRightBoundary,this.screenBottomBoundary),n=new PathInterpolator,{first:o,last:s}=M,a=o.path.length;let u=[];for(let e=a-1;e>=1;e--)u.push(o.path[e]);for(let e=1;e<s.path.length;e++)u.push(s.path[e]);const f=2.5*e;l&&(u=u.map((([e,t,i],r)=>(x&&!T&&(i=x(r<a-1?o.tilePath[a-1-r]:s.tilePath[r-a+2])[2]),Kd(e,t,i,l)))),u.some((e=>e[3]<=0))&&(u=[]));let _=[];if(u.length>0){let e=1/0,t=-1/0,n=1/0,o=-1/0;for(const i of u)e=Math.min(e,i[0]),n=Math.min(n,i[1]),t=Math.max(t,i[0]),o=Math.max(o,i[1]);t>=i.x&&e<=r.x&&o>=i.y&&n<=r.y&&(_=[u.map((e=>new g(e[0],e[1])))],(e<i.x||t>r.x||n<i.y||o>r.y)&&(_=function(e,t,i,r,n){const o=[];for(let s=0;s<e.length;s++){const a=e[s];let l;for(let e=0;e<a.length-1;e++){let s=a[e],c=a[e+1];s.x<t&&c.x<t||(s.x<t?s=new g(t,s.y+(t-s.x)/(c.x-s.x)*(c.y-s.y))._round():c.x<t&&(c=new g(t,s.y+(t-s.x)/(c.x-s.x)*(c.y-s.y))._round()),s.y<i&&c.y<i||(s.y<i?s=new g(s.x+(i-s.y)/(c.y-s.y)*(c.x-s.x),i)._round():c.y<i&&(c=new g(s.x+(i-s.y)/(c.y-s.y)*(c.x-s.x),i)._round()),s.x>=r&&c.x>=r||(s.x>=r?s=new g(r,s.y+(r-s.x)/(c.x-s.x)*(c.y-s.y))._round():c.x>=r&&(c=new g(r,s.y+(r-s.x)/(c.x-s.x)*(c.y-s.y))._round()),s.y>=n&&c.y>=n||(s.y>=n?s=new g(s.x+(n-s.y)/(c.y-s.y)*(c.x-s.x),n)._round():c.y>=n&&(c=new g(s.x+(n-s.y)/(c.y-s.y)*(c.x-s.x),n)._round()),l&&s.equals(l[l.length-1])||(l=[s],o.push(l)),l.push(c)))))}}return o}(_,i.x,i.y,r.x,r.y)))}for(const i of _){n.reset(i,.25*e);let r=0;r=n.length<=.5*e?1:Math.ceil(n.paddedLength/f)+1;for(let i=0;i<r;i++){const o=i/Math.max(r-1,1),s=n.lerp(o),a=s.x+lp,l=s.y+lp;m.push(a,l,e,0);const u=a-e,d=l-e,p=a+e,f=l+e;if(z=z&&this.isOffscreen(u,d,p,f),D=D||this.isInsideGrid(u,d,p,f),!t&&this.grid.hitTestCircle(a,l,e,h)&&(P=!0,!c))return{circles:[],offscreen:!1,collisionDetected:P,occluded:!1}}}}return{circles:!c&&P||!D?[]:m,offscreen:z,collisionDetected:P,occluded:S.occluded}}queryRenderedSymbols(e){if(0===e.length||0===this.grid.keysLength()&&0===this.ignoredGrid.keysLength())return{};const t=[];let i=1/0,r=1/0,n=-1/0,o=-1/0;for(const s of e){const e=new g(s.x+lp,s.y+lp);i=Math.min(i,e.x),r=Math.min(r,e.y),n=Math.max(n,e.x),o=Math.max(o,e.y),t.push(e)}const s=this.grid.query(i,r,n,o).concat(this.ignoredGrid.query(i,r,n,o)),a={},l={};for(const e of s){const i=e.key;void 0===a[i.bucketInstanceId]&&(a[i.bucketInstanceId]={}),a[i.bucketInstanceId][i.featureIndex]||Ja(t,[new g(e.x1,e.y1),new g(e.x2,e.y1),new g(e.x2,e.y2),new g(e.x1,e.y2)])&&(a[i.bucketInstanceId][i.featureIndex]=!0,void 0===l[i.bucketInstanceId]&&(l[i.bucketInstanceId]=[]),l[i.bucketInstanceId].push(i.featureIndex))}return l}insertCollisionBox(e,t,i,r,n){(t?this.ignoredGrid:this.grid).insert({bucketInstanceId:i,featureIndex:r,collisionGroupID:n},e[0],e[1],e[2],e[3])}insertCollisionCircles(e,t,i,r,n){const o=t?this.ignoredGrid:this.grid,s={bucketInstanceId:i,featureIndex:r,collisionGroupID:n};for(let t=0;t<e.length;t+=4)o.insertCircle(s,e[t],e[t+1],e[t+2])}projectAndGetPerspectiveRatio(e,t,i,r,n,o,s){const a=[t,i,r,1];let l=!1;if(r||this.transform.pitch>0){if(zs(a,a,e),this.fogState&&n&&"globe"!==s.name){const e=function(e,t,i,r,n,o){const s=[t,i,r];return ws(s,s,o.calculateFogTileMatrix(n)),Oh(e,s,o.pitch,o._fov)}(this.fogState,t,i,r,n.toUnwrapped(),this.transform);l=e>.9}}else ap(a,a,e);const c=a[3];return{point:new g((a[0]/c+1)/2*this.transform.width+lp,(-a[1]/c+1)/2*this.transform.height+lp),perspectiveRatio:Math.min(.5+this.transform.getCameraToCenterDistance(s)/c*.5,1.5),signedDistanceFromCamera:c,occluded:o&&a[2]>c||l}}isOffscreen(e,t,i,r){return i<lp||e>=this.screenRightBoundary||r<lp||t>this.screenBottomBoundary}isInsideGrid(e,t,i,r){return i>=0&&e<this.gridRightBoundary&&r>=0&&t<this.gridBottomBoundary}getViewportMatrix(){const e=Wo([]);return Ko(e,e,[-100,-100,0]),e}}function cp(e,t,i){const r=t.createTileMatrix(e,e.worldSize,i.toUnwrapped());return Xo(new Float32Array(16),e.projMatrix,r)}function up(e,t,i){if(t.projection.name===i.projection.name)return e.projMatrix;const r=i.clone();return r.setProjection(t.projection),cp(r,t.getProjection(),e)}function hp(e,t,i){return t.name===i.projection.name?e.projMatrix:cp(i,t,e)}class OpacityState{constructor(e,t,i,r){this.opacity=e?Math.max(0,Math.min(1,e.opacity+(e.placed?t:-t))):r&&i?1:0,this.placed=i}isHidden(){return 0===this.opacity&&!this.placed}}class JointOpacityState{constructor(e,t,i,r,n,o=!1){this.text=new OpacityState(e?e.text:null,t,i,n),this.icon=new OpacityState(e?e.icon:null,t,r,n),this.clipped=o}isHidden(){return this.text.isHidden()&&this.icon.isHidden()}}class JointPlacement{constructor(e,t,i,r=!1){this.text=e,this.icon=t,this.skipFade=i,this.clipped=r}}class CollisionCircleArray{constructor(){this.invProjMatrix=$o(),this.viewportMatrix=$o(),this.circles=[]}}class RetainedQueryData{constructor(e,t,i,r,n){this.bucketInstanceId=e,this.featureIndex=t,this.sourceLayerIndex=i,this.bucketIndex=r,this.tileID=n}}class CollisionGroups{constructor(e){this.crossSourceCollisions=e,this.maxGroupID=0,this.collisionGroups={}}get(e){if(this.crossSourceCollisions)return{ID:0,predicate:null};if(!this.collisionGroups[e]){const t=++this.maxGroupID;this.collisionGroups[e]={ID:t,predicate:e=>e.collisionGroupID===t}}return this.collisionGroups[e]}}function dp(e,t,i,r,n){const{horizontalAlign:o,verticalAlign:s}=Hu(e),a=-(o-.5)*t,l=-(s-.5)*i,c=th(e,r);return new g(a+c[0]*n,l+c[1]*n)}function pp(e,t,i,r,n){const o=new g(e,t);return i&&o._rotate(r?n:-n),o}class Placement{constructor(e,t,i,r,n){this.transform=e.clone(),this.projection=e.projection.name,this.collisionIndex=new CollisionIndex(this.transform,n),this.placements={},this.opacities={},this.variableOffsets={},this.stale=!1,this.commitTime=0,this.fadeDuration=t,this.retainedQueryData={},this.collisionGroups=new CollisionGroups(i),this.collisionCircleArrays={},this.prevPlacement=r,r&&(r.prevPlacement=void 0),this.placedOrientations={}}getBucketParts(e,t,i,r){const n=i.getBucket(t),o=i.latestFeatureIndex;if(!n||!o||t.id!==n.layerIds[0])return;const s=n.layers[0].layout,a=i.collisionBoxArray,l=Math.pow(2,this.transform.zoom-i.tileID.overscaledZ),c=i.tileSize/Uo,u=i.tileID.toUnwrapped();this.transform.setProjection(n.projection);const h=(d=i.tileID,p=n.getProjection(),f=this.transform,p.name===this.projection?f.calculateProjMatrix(d.toUnwrapped()):cp(f,p,d));var d,p,f;const m="map"===s.get("text-pitch-alignment"),_="map"===s.get("text-rotation-alignment");t.compileFilter();const g=t.dynamicFilter(),y=t.dynamicFilterNeedsFeature(),x=this.transform.calculatePixelsToTileUnitsMatrix(i),v=Hd(h,i.tileID.canonical,m,_,this.transform,n.getProjection(),x);let b=null;if(m){const e=Xd(h,i.tileID.canonical,m,_,this.transform,n.getProjection(),x);b=Xo([],this.transform.labelPlaneMatrix,e)}let w=null;g&&i.latestFeatureIndex&&(w={unwrappedTileID:u,dynamicFilter:g,dynamicFilterNeedsFeature:y,featureIndex:i.latestFeatureIndex}),this.retainedQueryData[n.bucketInstanceId]=new RetainedQueryData(n.bucketInstanceId,o,n.sourceLayerIndex,n.index,i.tileID);const E={bucket:n,layout:s,posMatrix:h,textLabelPlaneMatrix:v,labelToScreenMatrix:b,clippingData:w,scale:l,textPixelRatio:c,holdingForFade:i.holdingForFade(),collisionBoxArray:a,partiallyEvaluatedTextSize:mu(n.textSizeData,this.transform.zoom),partiallyEvaluatedIconSize:mu(n.iconSizeData,this.transform.zoom),collisionGroup:this.collisionGroups.get(n.sourceID)};if(r)for(const t of n.sortKeyRanges){const{sortKey:i,symbolInstanceStart:r,symbolInstanceEnd:n}=t;e.push({sortKey:i,symbolInstanceStart:r,symbolInstanceEnd:n,parameters:E})}else e.push({symbolInstanceStart:0,symbolInstanceEnd:n.symbolInstances.length,parameters:E})}attemptAnchorPlacement(e,t,i,r,n,o,s,a,l,c,u,h,d,p,f,m,_,g){const{textOffset0:y,textOffset1:x,crossTileID:v}=h,b=[y,x],w=dp(e,i,r,b,n),E=this.collisionIndex.placeCollisionBox(p,n,t,pp(w.x,w.y,o,s,this.transform.angle),u,a,l,c.predicate);if(m){const e=p.getSymbolInstanceIconSize(g,this.transform.zoom,h.placedIconSymbolIndex);if(0===this.collisionIndex.placeCollisionBox(p,e,m,pp(w.x,w.y,o,s,this.transform.angle),u,a,l,c.predicate).box.length)return}if(E.box.length>0){let t;return this.prevPlacement&&this.prevPlacement.variableOffsets[v]&&this.prevPlacement.placements[v]&&this.prevPlacement.placements[v].text&&(t=this.prevPlacement.variableOffsets[v].anchor),this.variableOffsets[v]={textOffset:b,width:i,height:r,anchor:e,textScale:n,prevAnchor:t},this.markUsedJustification(p,e,h,f),p.allowVerticalPlacement&&(this.markUsedOrientation(p,f,h),this.placedOrientations[v]=f),{shift:w,placedGlyphBoxes:E}}}placeLayerBucketPart(e,t,i,r){const{bucket:n,layout:o,posMatrix:s,textLabelPlaneMatrix:a,labelToScreenMatrix:l,clippingData:c,textPixelRatio:u,holdingForFade:h,collisionBoxArray:d,partiallyEvaluatedTextSize:p,partiallyEvaluatedIconSize:f,collisionGroup:m}=e.parameters,_=o.get("text-optional"),y=o.get("icon-optional"),x=o.get("text-allow-overlap"),v=o.get("icon-allow-overlap"),b="map"===o.get("text-rotation-alignment"),w="map"===o.get("text-pitch-alignment"),E="none"!==o.get("icon-text-fit"),T="viewport-y"===o.get("symbol-z-order");this.transform.setProjection(n.projection);let S=x&&(v||!n.hasIconData()||y),A=v&&(x||!n.hasTextData()||_);!n.collisionArrays&&d&&n.deserializeCollisionBoxes(d),i&&r&&n.updateCollisionDebugBuffers(this.transform.zoom,d);const C=(e,r,d)=>{const{crossTileID:T,numVerticalGlyphVertices:C}=e;if(c){const i={zoom:this.transform.zoom,pitch:this.transform.pitch};let r=null;if(c.dynamicFilterNeedsFeature){const t=this.retainedQueryData[n.bucketInstanceId];r=c.featureIndex.loadFeature({featureIndex:e.featureIndex,bucketIndex:t.bucketIndex,sourceLayerIndex:t.sourceLayerIndex,layoutVertexArrayOffset:0})}if(!(0,c.dynamicFilter)(i,r,this.retainedQueryData[n.bucketInstanceId].tileID.canonical,new g(e.tileAnchorX,e.tileAnchorY),this.transform.calculateDistanceTileData(c.unwrappedTileID)))return this.placements[T]=new JointPlacement(!1,!1,!1,!0),void t.add(T)}if(t.has(T))return;if(h)return void(this.placements[T]=new JointPlacement(!1,!1,!1));let I=!1,M=!1,P=!0,D=!1,z=!1,k=null,L={box:null,offscreen:null,occluded:null},B={box:null,offscreen:null,occluded:null},R=null,F=null,O=null,U=0,V=0,j=0;d.textFeatureIndex?U=d.textFeatureIndex:e.useRuntimeCollisionCircles&&(U=e.featureIndex),d.verticalTextFeatureIndex&&(V=d.verticalTextFeatureIndex);const N=e=>{e.tileID=this.retainedQueryData[n.bucketInstanceId].tileID;const t=this.transform.elevation;(t||e.elevation)&&(e.elevation=t?t.getAtTileOffset(e.tileID,e.tileAnchorX,e.tileAnchorY):0)},G=d.textBox;if(G){N(G);const t=t=>{let i=Wu.horizontal;if(n.allowVerticalPlacement&&!t&&this.prevPlacement){const t=this.prevPlacement.placedOrientations[T];t&&(this.placedOrientations[T]=t,i=t,this.markUsedOrientation(n,i,e))}return i},i=(e,t)=>{if(n.allowVerticalPlacement&&C>0&&d.verticalTextBox){for(const i of n.writingModes)if(i===Wu.vertical?(L=t(),B=L):L=e(),L&&L.box&&L.box.length)break}else L=e()};if(o.get("text-variable-anchor")){let a=o.get("text-variable-anchor");if(this.prevPlacement&&this.prevPlacement.variableOffsets[T]){const e=this.prevPlacement.variableOffsets[T];a.indexOf(e.anchor)>0&&(a=a.filter((t=>t!==e.anchor)),a.unshift(e.anchor))}const l=(t,i,o)=>{const l=n.getSymbolInstanceTextSize(p,e,this.transform.zoom,r),c=(t.x2-t.x1)*l+2*t.padding,h=(t.y2-t.y1)*l+2*t.padding,d=E&&!v?i:null;d&&N(d);let _={box:[],offscreen:!1,occluded:!1};const g=x?2*a.length:a.length;for(let i=0;i<g;++i){const g=this.attemptAnchorPlacement(a[i%a.length],t,c,h,l,b,w,u,s,m,i>=a.length,e,r,n,o,d,p,f);if(g&&(_=g.placedGlyphBoxes,_&&_.box&&_.box.length)){I=!0,k=g.shift;break}}return _};i((()=>l(G,d.iconBox,Wu.horizontal)),(()=>{const e=d.verticalTextBox;return e&&N(e),n.allowVerticalPlacement&&!(L&&L.box&&L.box.length)&&C>0&&e?l(e,d.verticalIconBox,Wu.vertical):{box:null,offscreen:null,occluded:null}})),L&&(I=L.box,P=L.offscreen,D=L.occluded);const c=t(!(!L||!L.box));if(!I&&this.prevPlacement){const t=this.prevPlacement.variableOffsets[T];t&&(this.variableOffsets[T]=t,this.markUsedJustification(n,t.anchor,e,c))}}else{const o=(t,i)=>{const o=n.getSymbolInstanceTextSize(p,e,this.transform.zoom,r),a=this.collisionIndex.placeCollisionBox(n,o,t,new g(0,0),x,u,s,m.predicate);return a&&a.box&&a.box.length&&(this.markUsedOrientation(n,i,e),this.placedOrientations[T]=i),a};i((()=>o(G,Wu.horizontal)),(()=>{const e=d.verticalTextBox;return n.allowVerticalPlacement&&C>0&&e?(N(e),o(e,Wu.vertical)):{box:null,offscreen:null,occluded:null}})),t(!!(L&&L.box&&L.box.length))}}if(R=L,I=R&&R.box&&R.box.length>0,P=R&&R.offscreen,D=R&&R.occluded,e.useRuntimeCollisionCircles){const t=n.text.placedSymbolArray.get(e.centerJustifiedTextSymbolIndex>=0?e.centerJustifiedTextSymbolIndex:e.verticalPlacedTextSymbolIndex),r=fu(n.textSizeData,p,t),c=o.get("text-padding");F=this.collisionIndex.placeCollisionCircles(n,x,t,n.lineVertexArray,n.glyphOffsetArray,r,s,a,l,i,w,m.predicate,e.collisionCircleDiameter*r/24,c,this.retainedQueryData[n.bucketInstanceId].tileID),I=x||F.circles.length>0&&!F.collisionDetected,P=P&&F.offscreen,D=F.occluded}if(d.iconFeatureIndex&&(j=d.iconFeatureIndex),d.iconBox){const t=t=>{N(t);const i=E&&k?pp(k.x,k.y,b,w,this.transform.angle):new g(0,0),r=n.getSymbolInstanceIconSize(f,this.transform.zoom,e.placedIconSymbolIndex);return this.collisionIndex.placeCollisionBox(n,r,t,i,v,u,s,m.predicate)};B&&B.box&&B.box.length&&d.verticalIconBox?(O=t(d.verticalIconBox),M=O.box.length>0):(O=t(d.iconBox),M=O.box.length>0),P=P&&O.offscreen,z=O.occluded}const q=_||0===e.numHorizontalGlyphVertices&&0===C,Z=y||0===e.numIconVertices;if(q||Z?Z?q||(M=M&&I):I=M&&I:M=I=M&&I,I&&R&&R.box&&this.collisionIndex.insertCollisionBox(R.box,o.get("text-ignore-placement"),n.bucketInstanceId,B&&B.box&&V?V:U,m.ID),M&&O&&this.collisionIndex.insertCollisionBox(O.box,o.get("icon-ignore-placement"),n.bucketInstanceId,j,m.ID),F&&(I&&this.collisionIndex.insertCollisionCircles(F.circles,o.get("text-ignore-placement"),n.bucketInstanceId,U,m.ID),i)){const e=n.bucketInstanceId;let t=this.collisionCircleArrays[e];void 0===t&&(t=this.collisionCircleArrays[e]=new CollisionCircleArray);for(let e=0;e<F.circles.length;e+=4)t.circles.push(F.circles[e+0]),t.circles.push(F.circles[e+1]),t.circles.push(F.circles[e+2]),t.circles.push(F.collisionDetected?1:0)}const $="globe"!==n.projection.name;S=S&&($||!D),A=A&&($||!z),this.placements[T]=new JointPlacement(I||S,M||A,P||n.justReloaded),t.add(T)};if(T){const e=n.getSortedSymbolIndexes(this.transform.angle);for(let t=e.length-1;t>=0;--t){const i=e[t];C(n.symbolInstances.get(i),i,n.collisionArrays[i])}}else for(let t=e.symbolInstanceStart;t<e.symbolInstanceEnd;t++)C(n.symbolInstances.get(t),t,n.collisionArrays[t]);if(i&&n.bucketInstanceId in this.collisionCircleArrays){const e=this.collisionCircleArrays[n.bucketInstanceId];Ho(e.invProjMatrix,s),e.viewportMatrix=this.collisionIndex.getViewportMatrix()}n.justReloaded=!1}markUsedJustification(e,t,i,r){const{leftJustifiedTextSymbolIndex:n,centerJustifiedTextSymbolIndex:o,rightJustifiedTextSymbolIndex:s,verticalPlacedTextSymbolIndex:a,crossTileID:l}=i,c=function(e){switch(e){case"right":case"top-right":case"bottom-right":return"right";case"left":case"top-left":case"bottom-left":return"left"}return"center"}(t),u=r===Wu.vertical?a:"left"===c?n:"center"===c?o:"right"===c?s:-1;n>=0&&(e.text.placedSymbolArray.get(n).crossTileID=u>=0&&n!==u?0:l),o>=0&&(e.text.placedSymbolArray.get(o).crossTileID=u>=0&&o!==u?0:l),s>=0&&(e.text.placedSymbolArray.get(s).crossTileID=u>=0&&s!==u?0:l),a>=0&&(e.text.placedSymbolArray.get(a).crossTileID=u>=0&&a!==u?0:l)}markUsedOrientation(e,t,i){const r=t===Wu.horizontal||t===Wu.horizontalOnly?t:0,n=t===Wu.vertical?t:0,{leftJustifiedTextSymbolIndex:o,centerJustifiedTextSymbolIndex:s,rightJustifiedTextSymbolIndex:a,verticalPlacedTextSymbolIndex:l}=i,c=e.text.placedSymbolArray;o>=0&&(c.get(o).placedOrientation=r),s>=0&&(c.get(s).placedOrientation=r),a>=0&&(c.get(a).placedOrientation=r),l>=0&&(c.get(l).placedOrientation=n)}commit(e){this.commitTime=e,this.zoomAtLastRecencyCheck=this.transform.zoom;const t=this.prevPlacement;let i=!1;this.prevZoomAdjustment=t?t.zoomAdjustment(this.transform.zoom):0;const r=t?t.symbolFadeChange(e):1,n=t?t.opacities:{},o=t?t.variableOffsets:{},s=t?t.placedOrientations:{};for(const e in this.placements){const t=this.placements[e],o=n[e];o?(this.opacities[e]=new JointOpacityState(o,r,t.text,t.icon,null,t.clipped),i=i||t.text!==o.text.placed||t.icon!==o.icon.placed):(this.opacities[e]=new JointOpacityState(null,r,t.text,t.icon,t.skipFade,t.clipped),i=i||t.text||t.icon)}for(const e in n){const t=n[e];if(!this.opacities[e]){const n=new JointOpacityState(t,r,!1,!1);n.isHidden()||(this.opacities[e]=n,i=i||t.text.placed||t.icon.placed)}}for(const e in o)this.variableOffsets[e]||!this.opacities[e]||this.opacities[e].isHidden()||(this.variableOffsets[e]=o[e]);for(const e in s)this.placedOrientations[e]||!this.opacities[e]||this.opacities[e].isHidden()||(this.placedOrientations[e]=s[e]);i?this.lastPlacementChangeTime=e:"number"!=typeof this.lastPlacementChangeTime&&(this.lastPlacementChangeTime=t?t.lastPlacementChangeTime:e)}updateLayerOpacities(e,t){const i=new Set;for(const r of t){const t=r.getBucket(e);t&&r.latestFeatureIndex&&e.id===t.layerIds[0]&&this.updateBucketOpacities(t,i,r.collisionBoxArray)}}updateBucketOpacities(e,t,i){e.hasTextData()&&e.text.opacityVertexArray.clear(),e.hasIconData()&&e.icon.opacityVertexArray.clear(),e.hasIconCollisionBoxData()&&e.iconCollisionBox.collisionVertexArray.clear(),e.hasTextCollisionBoxData()&&e.textCollisionBox.collisionVertexArray.clear();const r=e.layers[0].layout,n=!!e.layers[0].dynamicFilter(),o=new JointOpacityState(null,0,!1,!1,!0),s=r.get("text-allow-overlap"),a=r.get("icon-allow-overlap"),l=r.get("text-variable-anchor"),c="map"===r.get("text-rotation-alignment"),u="map"===r.get("text-pitch-alignment"),h="none"!==r.get("icon-text-fit"),d=new JointOpacityState(null,0,s&&(a||!e.hasIconData()||r.get("icon-optional")),a&&(s||!e.hasTextData()||r.get("text-optional")),!0);!e.collisionArrays&&i&&(e.hasIconCollisionBoxData()||e.hasTextCollisionBoxData())&&e.deserializeCollisionBoxes(i);const p=(e,t,i)=>{for(let r=0;r<t/4;r++)e.opacityVertexArray.emplaceBack(i)};let f=0;for(let i=0;i<e.symbolInstances.length;i++){const r=e.symbolInstances.get(i),{numHorizontalGlyphVertices:s,numVerticalGlyphVertices:a,crossTileID:m,numIconVertices:_}=r,y=t.has(m);let x=this.opacities[m];y?x=o:x||(x=d,this.opacities[m]=x),t.add(m);const v=s>0||a>0,b=_>0,w=this.placedOrientations[m],E=w===Wu.vertical,T=w===Wu.horizontal||w===Wu.horizontalOnly;if(!v&&!b||x.isHidden()||f++,v){const t=wp(x.text);p(e.text,s,E?Ep:t),p(e.text,a,T?Ep:t);const i=x.text.isHidden(),{leftJustifiedTextSymbolIndex:n,centerJustifiedTextSymbolIndex:o,rightJustifiedTextSymbolIndex:l,verticalPlacedTextSymbolIndex:c}=r,u=e.text.placedSymbolArray,h=i||E?1:0;n>=0&&(u.get(n).hidden=h),o>=0&&(u.get(o).hidden=h),l>=0&&(u.get(l).hidden=h),c>=0&&(u.get(c).hidden=i||T?1:0);const d=this.variableOffsets[m];d&&this.markUsedJustification(e,d.anchor,r,w);const f=this.placedOrientations[m];f&&(this.markUsedJustification(e,"left",r,f),this.markUsedOrientation(e,f,r))}if(b){const t=wp(x.icon),{placedIconSymbolIndex:i,verticalPlacedIconSymbolIndex:n}=r,o=e.icon.placedSymbolArray,s=x.icon.isHidden()?1:0;i>=0&&(p(e.icon,_,E?Ep:t),o.get(i).hidden=s),n>=0&&(p(e.icon,r.numVerticalIconVertices,T?Ep:t),o.get(n).hidden=s)}if(e.hasIconCollisionBoxData()||e.hasTextCollisionBoxData()){const t=e.collisionArrays[i];if(t){let i=new g(0,0),r=!0;if(t.textBox||t.verticalTextBox){if(l){const e=this.variableOffsets[m];e?(i=dp(e.anchor,e.width,e.height,e.textOffset,e.textScale),c&&i._rotate(u?this.transform.angle:-this.transform.angle)):r=!1}n&&(r=!x.clipped),t.textBox&&fp(e.textCollisionBox.collisionVertexArray,x.text.placed,!r||E,i.x,i.y),t.verticalTextBox&&fp(e.textCollisionBox.collisionVertexArray,x.text.placed,!r||T,i.x,i.y)}const o=r&&Boolean(!T&&t.verticalIconBox);t.iconBox&&fp(e.iconCollisionBox.collisionVertexArray,x.icon.placed,o,h?i.x:0,h?i.y:0),t.verticalIconBox&&fp(e.iconCollisionBox.collisionVertexArray,x.icon.placed,!o,h?i.x:0,h?i.y:0)}}}if(e.fullyClipped=0===f,e.sortFeatures(this.transform.angle),this.retainedQueryData[e.bucketInstanceId]&&(this.retainedQueryData[e.bucketInstanceId].featureSortOrder=e.featureSortOrder),e.hasTextData()&&e.text.opacityVertexBuffer&&e.text.opacityVertexBuffer.updateData(e.text.opacityVertexArray),e.hasIconData()&&e.icon.opacityVertexBuffer&&e.icon.opacityVertexBuffer.updateData(e.icon.opacityVertexArray),e.hasIconCollisionBoxData()&&e.iconCollisionBox.collisionVertexBuffer&&e.iconCollisionBox.collisionVertexBuffer.updateData(e.iconCollisionBox.collisionVertexArray),e.hasTextCollisionBoxData()&&e.textCollisionBox.collisionVertexBuffer&&e.textCollisionBox.collisionVertexBuffer.updateData(e.textCollisionBox.collisionVertexArray),e.bucketInstanceId in this.collisionCircleArrays){const t=this.collisionCircleArrays[e.bucketInstanceId];e.placementInvProjMatrix=t.invProjMatrix,e.placementViewportMatrix=t.viewportMatrix,e.collisionCircleArray=t.circles,delete this.collisionCircleArrays[e.bucketInstanceId]}}symbolFadeChange(e){return 0===this.fadeDuration?1:(e-this.commitTime)/this.fadeDuration+this.prevZoomAdjustment}zoomAdjustment(e){return Math.max(0,(this.transform.zoom-e)/1.5)}hasTransitions(e){return this.stale||e-this.lastPlacementChangeTime<this.fadeDuration}stillRecent(e,t){const i=this.zoomAtLastRecencyCheck===t?1-this.zoomAdjustment(t):1;return this.zoomAtLastRecencyCheck=t,this.commitTime+this.fadeDuration*i>e}setStale(){this.stale=!0}}function fp(e,t,i,r,n){e.emplaceBack(t?1:0,i?1:0,r||0,n||0),e.emplaceBack(t?1:0,i?1:0,r||0,n||0),e.emplaceBack(t?1:0,i?1:0,r||0,n||0),e.emplaceBack(t?1:0,i?1:0,r||0,n||0)}const mp=Math.pow(2,25),_p=Math.pow(2,24),gp=Math.pow(2,17),yp=Math.pow(2,16),xp=Math.pow(2,9),vp=Math.pow(2,8),bp=Math.pow(2,1);function wp(e){if(0===e.opacity&&!e.placed)return 0;if(1===e.opacity&&e.placed)return 4294967295;const t=e.placed?1:0,i=Math.floor(127*e.opacity);return i*mp+t*_p+i*gp+t*yp+i*xp+t*vp+i*bp+t}const Ep=0;class LayerPlacement{constructor(e){this._sortAcrossTiles="viewport-y"!==e.layout.get("symbol-z-order")&&void 0!==e.layout.get("symbol-sort-key").constantOr(1),this._currentTileIndex=0,this._currentPartIndex=0,this._seenCrossTileIDs=new Set,this._bucketParts=[]}continuePlacement(e,t,i,r,n){const o=this._bucketParts;for(;this._currentTileIndex<e.length;)if(t.getBucketParts(o,r,e[this._currentTileIndex],this._sortAcrossTiles),this._currentTileIndex++,n())return!0;for(this._sortAcrossTiles&&(this._sortAcrossTiles=!1,o.sort(((e,t)=>e.sortKey-t.sortKey)));this._currentPartIndex<o.length;){const e=o[this._currentPartIndex];if(t.placeLayerBucketPart(e,this._seenCrossTileIDs,i,0===e.symbolInstanceStart),this._currentPartIndex++,n())return!0}return!1}}class PauseablePlacement{constructor(e,t,i,r,n,o,s,a){this.placement=new Placement(e,n,o,s,a),this._currentPlacementIndex=t.length-1,this._forceFullPlacement=i,this._showCollisionBoxes=r,this._done=!1}isDone(){return this._done}continuePlacement(e,t,i){const r=it.now(),n=()=>{const e=it.now()-r;return!this._forceFullPlacement&&e>2};for(;this._currentPlacementIndex>=0;){const r=t[e[this._currentPlacementIndex]],o=this.placement.collisionIndex.transform.zoom;if("symbol"===r.type&&(!r.minzoom||r.minzoom<=o)&&(!r.maxzoom||r.maxzoom>o)){if(this._inProgressLayer||(this._inProgressLayer=new LayerPlacement(r)),this._inProgressLayer.continuePlacement(i[r.source],this.placement,this._showCollisionBoxes,r,n))return;delete this._inProgressLayer}this._currentPlacementIndex--}this._done=!0}commit(e){return this.placement.commit(e),this.placement}}const Tp=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];class KDBush{static from(e){if(!(e instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");const[t,i]=new Uint8Array(e,0,2);if(219!==t)throw new Error("Data does not appear to be in a KDBush format.");const r=i>>4;if(1!==r)throw new Error(`Got v${r} data when expected v1.`);const n=Tp[15&i];if(!n)throw new Error("Unrecognized array type.");const[o]=new Uint16Array(e,2,1),[s]=new Uint32Array(e,4,1);return new KDBush(s,o,n,e)}constructor(e,t=64,i=Float64Array,r){if(isNaN(e)||e<0)throw new Error(`Unpexpected numItems value: ${e}.`);this.numItems=+e,this.nodeSize=Math.min(Math.max(+t,2),65535),this.ArrayType=i,this.IndexArrayType=e<65536?Uint16Array:Uint32Array;const n=Tp.indexOf(this.ArrayType),o=2*e*this.ArrayType.BYTES_PER_ELEMENT,s=e*this.IndexArrayType.BYTES_PER_ELEMENT,a=(8-s%8)%8;if(n<0)throw new Error(`Unexpected typed array class: ${i}.`);r&&r instanceof ArrayBuffer?(this.data=r,this.ids=new this.IndexArrayType(this.data,8,e),this.coords=new this.ArrayType(this.data,8+s+a,2*e),this._pos=2*e,this._finished=!0):(this.data=new ArrayBuffer(8+o+s+a),this.ids=new this.IndexArrayType(this.data,8,e),this.coords=new this.ArrayType(this.data,8+s+a,2*e),this._pos=0,this._finished=!1,new Uint8Array(this.data,0,2).set([219,16+n]),new Uint16Array(this.data,2,1)[0]=t,new Uint32Array(this.data,4,1)[0]=e)}add(e,t){const i=this._pos>>1;return this.ids[i]=i,this.coords[this._pos++]=e,this.coords[this._pos++]=t,i}finish(){const e=this._pos>>1;if(e!==this.numItems)throw new Error(`Added ${e} items when expected ${this.numItems}.`);return Sp(this.ids,this.coords,this.nodeSize,0,this.numItems-1,0),this._finished=!0,this}range(e,t,i,r){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:n,coords:o,nodeSize:s}=this,a=[0,n.length-1,0],l=[];for(;a.length;){const c=a.pop()||0,u=a.pop()||0,h=a.pop()||0;if(u-h<=s){for(let s=h;s<=u;s++){const a=o[2*s],c=o[2*s+1];a>=e&&a<=i&&c>=t&&c<=r&&l.push(n[s])}continue}const d=h+u>>1,p=o[2*d],f=o[2*d+1];p>=e&&p<=i&&f>=t&&f<=r&&l.push(n[d]),(0===c?e<=p:t<=f)&&(a.push(h),a.push(d-1),a.push(1-c)),(0===c?i>=p:r>=f)&&(a.push(d+1),a.push(u),a.push(1-c))}return l}within(e,t,i){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:r,coords:n,nodeSize:o}=this,s=[0,r.length-1,0],a=[],l=i*i;for(;s.length;){const c=s.pop()||0,u=s.pop()||0,h=s.pop()||0;if(u-h<=o){for(let i=h;i<=u;i++)Mp(n[2*i],n[2*i+1],e,t)<=l&&a.push(r[i]);continue}const d=h+u>>1,p=n[2*d],f=n[2*d+1];Mp(p,f,e,t)<=l&&a.push(r[d]),(0===c?e-i<=p:t-i<=f)&&(s.push(h),s.push(d-1),s.push(1-c)),(0===c?e+i>=p:t+i>=f)&&(s.push(d+1),s.push(u),s.push(1-c))}return a}}function Sp(e,t,i,r,n,o){if(n-r<=i)return;const s=r+n>>1;Ap(e,t,s,r,n,o),Sp(e,t,i,r,s-1,1-o),Sp(e,t,i,s+1,n,1-o)}function Ap(e,t,i,r,n,o){for(;n>r;){if(n-r>600){const s=n-r+1,a=i-r+1,l=Math.log(s),c=.5*Math.exp(2*l/3),u=.5*Math.sqrt(l*c*(s-c)/s)*(a-s/2<0?-1:1);Ap(e,t,i,Math.max(r,Math.floor(i-a*c/s+u)),Math.min(n,Math.floor(i+(s-a)*c/s+u)),o)}const s=t[2*i+o];let a=r,l=n;for(Cp(e,t,r,i),t[2*n+o]>s&&Cp(e,t,r,n);a<l;){for(Cp(e,t,a,l),a++,l--;t[2*a+o]<s;)a++;for(;t[2*l+o]>s;)l--}t[2*r+o]===s?Cp(e,t,r,l):(l++,Cp(e,t,l,n)),l<=i&&(r=l+1),i<=l&&(n=l-1)}}function Cp(e,t,i,r){Ip(e,i,r),Ip(t,2*i,2*r),Ip(t,2*i+1,2*r+1)}function Ip(e,t,i){const r=e[t];e[t]=e[i],e[i]=r}function Mp(e,t,i,r){const n=e-i,o=t-r;return n*n+o*o}const Pp=512/Uo/2;class TileLayerIndex{constructor(e,t,i){this.tileID=e,this.bucketInstanceId=i,this.index=new KDBush(t.length,16,Int32Array),this.keys=[],this.crossTileIDs=[];const r=e.canonical.x*Uo,n=e.canonical.y*Uo;for(let e=0;e<t.length;e++){const{key:i,crossTileID:o,tileAnchorX:s,tileAnchorY:a}=t.get(e),l=Math.floor((r+s)*Pp),c=Math.floor((n+a)*Pp);this.index.add(l,c),this.keys.push(i),this.crossTileIDs.push(o)}this.index.finish()}findMatches(e,t,i){const r=this.tileID.canonical.z<t.canonical.z?1:Math.pow(2,this.tileID.canonical.z-t.canonical.z),n=Pp/Math.pow(2,t.canonical.z-this.tileID.canonical.z),o=t.canonical.x*Uo,s=t.canonical.y*Uo;for(let t=0;t<e.length;t++){const a=e.get(t);if(a.crossTileID)continue;const{key:l,tileAnchorX:c,tileAnchorY:u}=a,h=Math.floor((o+c)*n),d=Math.floor((s+u)*n),p=this.index.range(h-r,d-r,h+r,d+r);for(const e of p){const t=this.crossTileIDs[e];if(this.keys[e]===l&&!i.has(t)){i.add(t),a.crossTileID=t;break}}}}}class CrossTileIDs{constructor(){this.maxCrossTileID=0}generate(){return++this.maxCrossTileID}}class CrossTileSymbolLayerIndex{constructor(){this.indexes={},this.usedCrossTileIDs={},this.lng=0}handleWrapJump(e){const t=Math.round((e-this.lng)/360);if(0!==t)for(const e in this.indexes){const i=this.indexes[e],r={};for(const e in i){const n=i[e];n.tileID=n.tileID.unwrapTo(n.tileID.wrap+t),r[n.tileID.key]=n}this.indexes[e]=r}this.lng=e}addBucket(e,t,i){if(this.indexes[e.overscaledZ]&&this.indexes[e.overscaledZ][e.key]){if(this.indexes[e.overscaledZ][e.key].bucketInstanceId===t.bucketInstanceId)return!1;this.removeBucketCrossTileIDs(e.overscaledZ,this.indexes[e.overscaledZ][e.key])}for(let e=0;e<t.symbolInstances.length;e++)t.symbolInstances.get(e).crossTileID=0;this.usedCrossTileIDs[e.overscaledZ]||(this.usedCrossTileIDs[e.overscaledZ]=new Set);const r=this.usedCrossTileIDs[e.overscaledZ];for(const i in this.indexes){const n=this.indexes[i];if(Number(i)>e.overscaledZ)for(const i in n){const o=n[i];o.tileID.isChildOf(e)&&o.findMatches(t.symbolInstances,e,r)}else{const o=n[e.scaledTo(Number(i)).key];o&&o.findMatches(t.symbolInstances,e,r)}}for(let e=0;e<t.symbolInstances.length;e++){const n=t.symbolInstances.get(e);n.crossTileID||(n.crossTileID=i.generate(),r.add(n.crossTileID))}return void 0===this.indexes[e.overscaledZ]&&(this.indexes[e.overscaledZ]={}),this.indexes[e.overscaledZ][e.key]=new TileLayerIndex(e,t.symbolInstances,t.bucketInstanceId),!0}removeBucketCrossTileIDs(e,t){for(const i of t.crossTileIDs)this.usedCrossTileIDs[e].delete(i)}removeStaleBuckets(e){let t=!1;for(const i in this.indexes){const r=this.indexes[i];for(const n in r)e[r[n].bucketInstanceId]||(this.removeBucketCrossTileIDs(i,r[n]),delete r[n],t=!0)}return t}}class CrossTileSymbolIndex{constructor(){this.layerIndexes={},this.crossTileIDs=new CrossTileIDs,this.maxBucketInstanceId=0,this.bucketsInCurrentPlacement={}}addLayer(e,t,i,r){let n=this.layerIndexes[e.id];void 0===n&&(n=this.layerIndexes[e.id]=new CrossTileSymbolLayerIndex);let o=!1;const s={};"globe"!==r.name&&n.handleWrapJump(i);for(const i of t){const t=i.getBucket(e);t&&e.id===t.layerIds[0]&&(t.bucketInstanceId||(t.bucketInstanceId=++this.maxBucketInstanceId),n.addBucket(i.tileID,t,this.crossTileIDs)&&(o=!0),s[t.bucketInstanceId]=!0)}return n.removeStaleBuckets(s)&&(o=!0),o}pruneUnusedLayers(e){const t={};e.forEach((e=>{t[e]=!0}));for(const e in this.layerIndexes)t[e]||delete this.layerIndexes[e]}}const Dp=(e,t)=>Bn(e,t&&t.filter((e=>"source.canvas"!==e.identifier))),zp=B(Fd,["addLayer","removeLayer","setPaintProperty","setLayoutProperty","setFilter","addSource","removeSource","setLayerZoomRange","setLight","setTransition","setGeoJSONSourceData","setTerrain","setFog","setProjection"]),kp=B(Fd,["setCenter","setZoom","setBearing","setPitch"]),Lp={version:8,layers:[],sources:{}},Bp={fill:!0,line:!0,background:!0,hillshade:!0,raster:!0};class Style extends Evented{constructor(e,t={}){super(),this.map=e,this.dispatcher=new Dispatcher(kd(),this),this.imageManager=new ImageManager,this.imageManager.setEventedParent(this),this.glyphManager=new GlyphManager(e._requestManager,t.localFontFamily?2:t.localIdeographFontFamily?1:0,t.localFontFamily||t.localIdeographFontFamily),this.crossTileSymbolIndex=new CrossTileSymbolIndex,this._layers={},this._num3DLayers=0,this._numSymbolLayers=0,this._numCircleLayers=0,this._serializedLayers={},this._sourceCaches={},this._otherSourceCaches={},this._symbolSourceCaches={},this._loaded=!1,this._availableImages=[],this._order=[],this._drapedFirstOrder=[],this._markersNeedUpdate=!1,this._resetUpdates(),this.dispatcher.broadcast("setReferrer",_e());const i=this;this._rtlTextPluginCallback=Style.registerForPluginStateChange((e=>{i.dispatcher.broadcast("syncRTLPluginState",{pluginStatus:e.pluginStatus,pluginURL:e.pluginURL},((e,t)=>{if(no(e),t&&t.every((e=>e)))for(const e in i._sourceCaches){const t=i._sourceCaches[e],r=t.getSource().type;"vector"!==r&&"geojson"!==r||t.reload()}}))})),this.on("data",(e=>{if("source"!==e.dataType||"metadata"!==e.sourceDataType)return;const t=this.getSource(e.sourceId);if(t&&t.vectorLayerIds)for(const e in this._layers){const i=this._layers[e];i.source===t.id&&this._validateLayer(i)}}))}loadURL(e,t={}){this.fire(new Event("dataloading",{dataType:"style"}));const i="boolean"==typeof t.validate?t.validate:!Ae(e);e=this.map._requestManager.normalizeStyleURL(e,t.accessToken);const r=this.map._requestManager.transformRequest(e,me.Style);this._request=ye(r,((e,t)=>{this._request=null,e?this.fire(new ErrorEvent(e)):t&&this._load(t,i)}))}loadJSON(e,t={}){this.fire(new Event("dataloading",{dataType:"style"})),this._request=it.frame((()=>{this._request=null,this._load(e,!1!==t.validate)}))}loadEmpty(){this.fire(new Event("dataloading",{dataType:"style"})),this._load(Lp,!1)}_updateLayerCount(e,t){const i=t?1:-1;e.is3D()&&(this._num3DLayers+=i),"circle"===e.type&&(this._numCircleLayers+=i),"symbol"===e.type&&(this._numSymbolLayers+=i)}_load(e,t){if(t&&Dp(this,Tn(e)))return;this._loaded=!0,this.stylesheet=Z(e),this._updateMapProjection();for(const t in e.sources)this.addSource(t,e.sources[t],{validate:!1});this._changed=!1,e.sprite?this._loadSprite(e.sprite):(this.imageManager.setLoaded(!0),this.dispatcher.broadcast("spriteLoaded",!0)),this.glyphManager.setURL(e.glyphs);const i=Rd(this.stylesheet.layers);this._order=i.map((e=>e.id)),this._layers={},this._serializedLayers={};for(const e of i){const t=kh(e);t.setEventedParent(this,{layer:{id:t.id}}),this._layers[t.id]=t,this._serializedLayers[t.id]=t.serialize(),this._updateLayerCount(t,!0)}this.dispatcher.broadcast("setLayers",this._serializeLayers(this._order)),this.light=new Light(this.stylesheet.light),this.stylesheet.terrain&&!this.terrainSetForDrapingOnly()&&this._createTerrain(this.stylesheet.terrain,1),this.stylesheet.fog&&this._createFog(this.stylesheet.fog),this._updateDrapeFirstLayers(),this.fire(new Event("data",{dataType:"style"})),this.fire(new Event("style.load"))}terrainSetForDrapingOnly(){return!!this.terrain&&0===this.terrain.drapeRenderMode}setProjection(e){e?this.stylesheet.projection=e:delete this.stylesheet.projection,this._updateMapProjection()}applyProjectionUpdate(){this._loaded&&(this.dispatcher.broadcast("setProjection",this.map.transform.projectionOptions),this.map.transform.projection.requiresDraping?this.getTerrain()||this.stylesheet.terrain||this.setTerrainForDraping():this.terrainSetForDrapingOnly()&&this.setTerrain(null))}_updateMapProjection(){this.map._useExplicitProjection?this.applyProjectionUpdate():this.map._prioritizeAndUpdateProjection(null,this.stylesheet.projection)}_loadSprite(e){this._spriteRequest=function(e,t,i){let r,n,o;const s=it.devicePixelRatio>1?"@2x":"";let a=ye(t.transformRequest(t.normalizeSpriteURL(e,s,".json"),me.SpriteJSON),((e,t)=>{a=null,o||(o=e,r=t,c())})),l=Te(t.transformRequest(t.normalizeSpriteURL(e,s,".png"),me.SpriteImage),((e,t)=>{l=null,o||(o=e,n=t,c())}));function c(){if(o)i(o);else if(r&&n){const e=it.getImageData(n),t={};for(const i in r){const{width:n,height:o,x:s,y:a,sdf:l,pixelRatio:c,stretchX:u,stretchY:h,content:d}=r[i],p=new RGBAImage({width:n,height:o});RGBAImage.copy(e,p,{x:s,y:a},{x:0,y:0},{width:n,height:o}),t[i]={data:p,pixelRatio:c,sdf:l,stretchX:u,stretchY:h,content:d}}i(null,t)}}return{cancel(){a&&(a.cancel(),a=null),l&&(l.cancel(),l=null)}}}(e,this.map._requestManager,((e,t)=>{if(this._spriteRequest=null,e)this.fire(new ErrorEvent(e));else if(t)for(const e in t)this.imageManager.addImage(e,t[e]);this.imageManager.setLoaded(!0),this._availableImages=this.imageManager.listImages(),this.dispatcher.broadcast("setImages",this._availableImages),this.dispatcher.broadcast("spriteLoaded",!0),this.fire(new Event("data",{dataType:"style"}))}))}_validateLayer(e){const t=this.getSource(e.source);if(!t)return;const i=e.sourceLayer;i&&("geojson"===t.type||t.vectorLayerIds&&-1===t.vectorLayerIds.indexOf(i))&&this.fire(new ErrorEvent(new Error(`Source layer "${i}" does not exist on source "${t.id}" as specified by style layer "${e.id}"`)))}loaded(){if(!this._loaded)return!1;if(Object.keys(this._updatedSources).length)return!1;for(const e in this._sourceCaches)if(!this._sourceCaches[e].loaded())return!1;return!!this.imageManager.isLoaded()}_serializeLayers(e){const t=[];for(const i of e){const e=this._layers[i];"custom"!==e.type&&t.push(e.serialize())}return t}hasTransitions(){if(this.light&&this.light.hasTransition())return!0;if(this.fog&&this.fog.hasTransition())return!0;for(const e in this._sourceCaches)if(this._sourceCaches[e].hasTransition())return!0;for(const e in this._layers)if(this._layers[e].hasTransition())return!0;return!1}get order(){return this.map._optimizeForTerrain&&this.terrain?this._drapedFirstOrder:this._order}isLayerDraped(e){return!!this.terrain&&("function"==typeof e.isLayerDraped?e.isLayerDraped():Bp[e.type])}_checkLoaded(){if(!this._loaded)throw new Error("Style is not done loading")}update(e){if(!this._loaded)return;const t=this._changed;if(this._changed){const t=Object.keys(this._updatedLayers),i=Object.keys(this._removedLayers);(t.length||i.length)&&this._updateWorkerLayers(t,i);for(const e in this._updatedSources){const t=this._updatedSources[e];"reload"===t?this._reloadSource(e):"clear"===t&&this._clearSource(e)}this._updateTilesForChangedImages();for(const t in this._updatedPaintProps)this._layers[t].updateTransitions(e);this.light.updateTransitions(e),this.fog&&this.fog.updateTransitions(e),this._resetUpdates()}const i={};for(const e in this._sourceCaches){const t=this._sourceCaches[e];i[e]=t.used,t.used=!1}for(const t of this._order){const i=this._layers[t];if(i.recalculate(e,this._availableImages),!i.isHidden(e.zoom)){const e=this._getLayerSourceCache(i);e&&(e.used=!0)}const r=this.map.painter;if(r){const t=i.getProgramIds();if(!t)continue;const n=i.getProgramConfiguration(e.zoom);for(const e of t)r.useProgram(e,n)}}for(const e in i){const t=this._sourceCaches[e];i[e]!==t.used&&t.getSource().fire(new Event("data",{sourceDataType:"visibility",dataType:"source",sourceId:t.getSource().id}))}this.light.recalculate(e),this.terrain&&this.terrain.recalculate(e),this.fog&&this.fog.recalculate(e),this.z=e.zoom,this._markersNeedUpdate&&(this._updateMarkersOpacity(),this._markersNeedUpdate=!1),t&&this.fire(new Event("data",{dataType:"style"}))}_updateTilesForChangedImages(){const e=Object.keys(this._changedImages);if(e.length){for(const t in this._sourceCaches)this._sourceCaches[t].reloadTilesForDependencies(["icons","patterns"],e);this._changedImages={}}}_updateWorkerLayers(e,t){this.dispatcher.broadcast("updateLayers",{layers:this._serializeLayers(e),removedIds:t})}_resetUpdates(){this._changed=!1,this._updatedLayers={},this._removedLayers={},this._updatedSources={},this._updatedPaintProps={},this._changedImages={}}setState(e){if(this._checkLoaded(),Dp(this,Tn(e)))return!1;(e=Z(e)).layers=Rd(e.layers);const t=function(e,t){if(!e)return[{command:Fd.setStyle,args:[t]}];let i=[];try{if(!y(e.version,t.version))return[{command:Fd.setStyle,args:[t]}];y(e.center,t.center)||i.push({command:Fd.setCenter,args:[t.center]}),y(e.zoom,t.zoom)||i.push({command:Fd.setZoom,args:[t.zoom]}),y(e.bearing,t.bearing)||i.push({command:Fd.setBearing,args:[t.bearing]}),y(e.pitch,t.pitch)||i.push({command:Fd.setPitch,args:[t.pitch]}),y(e.sprite,t.sprite)||i.push({command:Fd.setSprite,args:[t.sprite]}),y(e.glyphs,t.glyphs)||i.push({command:Fd.setGlyphs,args:[t.glyphs]}),y(e.transition,t.transition)||i.push({command:Fd.setTransition,args:[t.transition]}),y(e.light,t.light)||i.push({command:Fd.setLight,args:[t.light]}),y(e.fog,t.fog)||i.push({command:Fd.setFog,args:[t.fog]}),y(e.projection,t.projection)||i.push({command:Fd.setProjection,args:[t.projection]});const r={},n=[];!function(e,t,i,r){let n;for(n in t=t||{},e=e||{})e.hasOwnProperty(n)&&(t.hasOwnProperty(n)||Ud(n,i,r));for(n in t){if(!t.hasOwnProperty(n))continue;const o=t[n];e.hasOwnProperty(n)?y(e[n],o)||("geojson"===e[n].type&&"geojson"===o.type&&jd(e,t,n)?i.push({command:Fd.setGeoJSONSourceData,args:[n,o.data]}):Vd(n,t,i,r)):Od(n,t,i)}}(e.sources,t.sources,n,r);const o=[];e.layers&&e.layers.forEach((e=>{e.source&&r[e.source]?i.push({command:Fd.removeLayer,args:[e.id]}):o.push(e)}));let s=e.terrain;s&&r[s.source]&&(i.push({command:Fd.setTerrain,args:[void 0]}),s=void 0),i=i.concat(n),y(s,t.terrain)||i.push({command:Fd.setTerrain,args:[t.terrain]}),function(e,t,i){t=t||[];const r=(e=e||[]).map(Gd),n=t.map(Gd),o=e.reduce(qd,{}),s=t.reduce(qd,{}),a=r.slice(),l=Object.create(null);let c,u,h,d,p,f,m;for(c=0,u=0;c<r.length;c++)h=r[c],s.hasOwnProperty(h)?u++:(i.push({command:Fd.removeLayer,args:[h]}),a.splice(a.indexOf(h,u),1));for(c=0,u=0;c<n.length;c++)h=n[n.length-1-c],a[a.length-1-c]!==h&&(o.hasOwnProperty(h)?(i.push({command:Fd.removeLayer,args:[h]}),a.splice(a.lastIndexOf(h,a.length-u),1)):u++,f=a[a.length-c],i.push({command:Fd.addLayer,args:[s[h],f]}),a.splice(a.length-c,0,h),l[h]=!0);for(c=0;c<n.length;c++)if(h=n[c],d=o[h],p=s[h],!l[h]&&!y(d,p))if(y(d.source,p.source)&&y(d["source-layer"],p["source-layer"])&&y(d.type,p.type)){for(m in Nd(d.layout,p.layout,i,h,null,Fd.setLayoutProperty),Nd(d.paint,p.paint,i,h,null,Fd.setPaintProperty),y(d.filter,p.filter)||i.push({command:Fd.setFilter,args:[h,p.filter]}),y(d.minzoom,p.minzoom)&&y(d.maxzoom,p.maxzoom)||i.push({command:Fd.setLayerZoomRange,args:[h,p.minzoom,p.maxzoom]}),d)d.hasOwnProperty(m)&&"layout"!==m&&"paint"!==m&&"filter"!==m&&"metadata"!==m&&"minzoom"!==m&&"maxzoom"!==m&&(0===m.indexOf("paint.")?Nd(d[m],p[m],i,h,m.slice(6),Fd.setPaintProperty):y(d[m],p[m])||i.push({command:Fd.setLayerProperty,args:[h,m,p[m]]}));for(m in p)p.hasOwnProperty(m)&&!d.hasOwnProperty(m)&&"layout"!==m&&"paint"!==m&&"filter"!==m&&"metadata"!==m&&"minzoom"!==m&&"maxzoom"!==m&&(0===m.indexOf("paint.")?Nd(d[m],p[m],i,h,m.slice(6),Fd.setPaintProperty):y(d[m],p[m])||i.push({command:Fd.setLayerProperty,args:[h,m,p[m]]}))}else i.push({command:Fd.removeLayer,args:[h]}),f=a[a.lastIndexOf(h)+1],i.push({command:Fd.addLayer,args:[p,f]})}(o,t.layers,i)}catch(e){console.warn("Unable to compute style diff:",e),i=[{command:Fd.setStyle,args:[t]}]}return i}(this.serialize(),e).filter((e=>!(e.command in kp)));if(0===t.length)return!1;const i=t.filter((e=>!(e.command in zp)));if(i.length>0)throw new Error(`Unimplemented: ${i.map((e=>e.command)).join(", ")}.`);return t.forEach((e=>{"setTransition"!==e.command&&"setProjection"!==e.command&&this[e.command].apply(this,e.args)})),this.stylesheet=e,this._updateMapProjection(),!0}addImage(e,t){return this.getImage(e)?this.fire(new ErrorEvent(new Error("An image with this name already exists."))):(this.imageManager.addImage(e,t),this._afterImageUpdated(e),this)}updateImage(e,t){this.imageManager.updateImage(e,t)}getImage(e){return this.imageManager.getImage(e)}removeImage(e){return this.getImage(e)?(this.imageManager.removeImage(e),this._afterImageUpdated(e),this):this.fire(new ErrorEvent(new Error("No image with this name exists.")))}_afterImageUpdated(e){this._availableImages=this.imageManager.listImages(),this._changedImages[e]=!0,this._changed=!0,this.dispatcher.broadcast("setImages",this._availableImages),this.fire(new Event("data",{dataType:"style"}))}listImages(){return this._checkLoaded(),this._availableImages.slice()}addSource(e,t,i={}){if(this._checkLoaded(),void 0!==this.getSource(e))throw new Error("There is already a source with this ID");if(!t.type)throw new Error(`The type property must be defined, but only the following properties were given: ${Object.keys(t).join(", ")}.`);if(["vector","raster","geojson","video","image"].indexOf(t.type)>=0&&this._validate(Sn,`sources.${e}`,t,null,i))return;this.map&&this.map._collectResourceTiming&&(t.collectResourceTiming=!0);const r=Sd(e,t,this.dispatcher,this);r.setEventedParent(this,(()=>({isSourceLoaded:this._isSourceCacheLoaded(e),source:r.serialize(),sourceId:e})));const n=t=>{const i=(t?"symbol:":"other:")+e,n=this._sourceCaches[i]=new SourceCache(i,r,t);(t?this._symbolSourceCaches:this._otherSourceCaches)[e]=n,n.style=this,n.onAdd(this.map)};n(!1),"vector"!==t.type&&"geojson"!==t.type||n(!0),r.onAdd&&r.onAdd(this.map),this._changed=!0}removeSource(e){this._checkLoaded();const t=this.getSource(e);if(!t)throw new Error("There is no source with this ID");for(const t in this._layers)if(this._layers[t].source===e)return this.fire(new ErrorEvent(new Error(`Source "${e}" cannot be removed while layer "${t}" is using it.`)));if(this.terrain&&this.terrain.get().source===e)return this.fire(new ErrorEvent(new Error(`Source "${e}" cannot be removed while terrain is using it.`)));const i=this._getSourceCaches(e);for(const e of i)delete this._sourceCaches[e.id],delete this._updatedSources[e.id],e.fire(new Event("data",{sourceDataType:"metadata",dataType:"source",sourceId:e.getSource().id})),e.setEventedParent(null),e.clearTiles();return delete this._otherSourceCaches[e],delete this._symbolSourceCaches[e],t.setEventedParent(null),t.onRemove&&t.onRemove(this.map),this._changed=!0,this}setGeoJSONSourceData(e,t){this._checkLoaded(),this.getSource(e).setData(t),this._changed=!0}getSource(e){const t=this._getSourceCache(e);return t&&t.getSource()}_getSources(){const e=[];for(const t in this._otherSourceCaches){const i=this._getSourceCache(t);i&&e.push(i.getSource())}return e}addLayer(e,t,i={}){this._checkLoaded();const r=e.id;if(this.getLayer(r))return void this.fire(new ErrorEvent(new Error(`Layer with id "${r}" already exists on this map`)));let n;if("custom"===e.type){if(Dp(this,function(e){const t=[],i=e.id;return void 0===i&&t.push({message:`layers.${i}: missing required property "id"`}),void 0===e.render&&t.push({message:`layers.${i}: missing required method "render"`}),e.renderingMode&&"2d"!==e.renderingMode&&"3d"!==e.renderingMode&&t.push({message:`layers.${i}: property "renderingMode" must be either "2d" or "3d"`}),t}(e)))return;n=kh(e)}else{if("object"==typeof e.source&&(this.addSource(r,e.source),e=L(e=Z(e),{source:r})),this._validate(Pn,`layers.${r}`,e,{arrayIndex:-1},i))return;n=kh(e),this._validateLayer(n),n.setEventedParent(this,{layer:{id:r}}),this._serializedLayers[n.id]=n.serialize(),this._updateLayerCount(n,!0)}const o=t?this._order.indexOf(t):this._order.length;if(t&&-1===o)return void this.fire(new ErrorEvent(new Error(`Layer with id "${t}" does not exist on this map.`)));this._order.splice(o,0,r),this._layerOrderChanged=!0,this._layers[r]=n;const s=this._getLayerSourceCache(n);if(this._removedLayers[r]&&n.source&&s&&"custom"!==n.type){const e=this._removedLayers[r];delete this._removedLayers[r],e.type!==n.type?this._updatedSources[n.source]="clear":(this._updatedSources[n.source]="reload",s.pause())}this._updateLayer(n),n.onAdd&&n.onAdd(this.map),this._updateDrapeFirstLayers()}moveLayer(e,t){if(this._checkLoaded(),this._changed=!0,!this._layers[e])return void this.fire(new ErrorEvent(new Error(`The layer '${e}' does not exist in the map's style and cannot be moved.`)));if(e===t)return;const i=this._order.indexOf(e);this._order.splice(i,1);const r=t?this._order.indexOf(t):this._order.length;t&&-1===r?this.fire(new ErrorEvent(new Error(`Layer with id "${t}" does not exist on this map.`))):(this._order.splice(r,0,e),this._layerOrderChanged=!0,this._updateDrapeFirstLayers())}removeLayer(e){this._checkLoaded();const t=this._layers[e];if(!t)return void this.fire(new ErrorEvent(new Error(`The layer '${e}' does not exist in the map's style and cannot be removed.`)));t.setEventedParent(null),this._updateLayerCount(t,!1);const i=this._order.indexOf(e);this._order.splice(i,1),this._layerOrderChanged=!0,this._changed=!0,this._removedLayers[e]=t,delete this._layers[e],delete this._serializedLayers[e],delete this._updatedLayers[e],delete this._updatedPaintProps[e],t.onRemove&&t.onRemove(this.map),this._updateDrapeFirstLayers()}getLayer(e){return this._layers[e]}hasLayer(e){return e in this._layers}hasLayerType(e){for(const t in this._layers)if(this._layers[t].type===e)return!0;return!1}setLayerZoomRange(e,t,i){this._checkLoaded();const r=this.getLayer(e);r?r.minzoom===t&&r.maxzoom===i||(null!=t&&(r.minzoom=t),null!=i&&(r.maxzoom=i),this._updateLayer(r)):this.fire(new ErrorEvent(new Error(`The layer '${e}' does not exist in the map's style and cannot have zoom extent.`)))}setFilter(e,t,i={}){this._checkLoaded();const r=this.getLayer(e);if(r){if(!y(r.filter,t))return null==t?(r.filter=void 0,void this._updateLayer(r)):void(this._validate(Dn,`layers.${r.id}.filter`,t,{layerType:r.type},i)||(r.filter=Z(t),this._updateLayer(r)))}else this.fire(new ErrorEvent(new Error(`The layer '${e}' does not exist in the map's style and cannot be filtered.`)))}getFilter(e){const t=this.getLayer(e);return t&&Z(t.filter)}setLayoutProperty(e,t,i,r={}){this._checkLoaded();const n=this.getLayer(e);n?y(n.getLayoutProperty(t),i)||(n.setLayoutProperty(t,i,r),this._updateLayer(n)):this.fire(new ErrorEvent(new Error(`The layer '${e}' does not exist in the map's style and cannot be styled.`)))}getLayoutProperty(e,t){const i=this.getLayer(e);if(i)return i.getLayoutProperty(t);this.fire(new ErrorEvent(new Error(`The layer '${e}' does not exist in the map's style.`)))}setPaintProperty(e,t,i,r={}){this._checkLoaded();const n=this.getLayer(e);n?y(n.getPaintProperty(t),i)||(n.setPaintProperty(t,i,r)&&this._updateLayer(n),this._changed=!0,this._updatedPaintProps[e]=!0):this.fire(new ErrorEvent(new Error(`The layer '${e}' does not exist in the map's style and cannot be styled.`)))}getPaintProperty(e,t){const i=this.getLayer(e);return i&&i.getPaintProperty(t)}setFeatureState(e,t){this._checkLoaded();const i=e.source,r=e.sourceLayer,n=this.getSource(i);if(!n)return void this.fire(new ErrorEvent(new Error(`The source '${i}' does not exist in the map's style.`)));const o=n.type;if("geojson"===o&&r)return void this.fire(new ErrorEvent(new Error("GeoJSON sources cannot have a sourceLayer parameter.")));if("vector"===o&&!r)return void this.fire(new ErrorEvent(new Error("The sourceLayer parameter must be provided for vector source types.")));void 0===e.id&&this.fire(new ErrorEvent(new Error("The feature id parameter must be provided.")));const s=this._getSourceCaches(i);for(const i of s)i.setFeatureState(r,e.id,t)}removeFeatureState(e,t){this._checkLoaded();const i=e.source,r=this.getSource(i);if(!r)return void this.fire(new ErrorEvent(new Error(`The source '${i}' does not exist in the map's style.`)));const n=r.type,o="vector"===n?e.sourceLayer:void 0;if("vector"===n&&!o)return void this.fire(new ErrorEvent(new Error("The sourceLayer parameter must be provided for vector source types.")));if(t&&"string"!=typeof e.id&&"number"!=typeof e.id)return void this.fire(new ErrorEvent(new Error("A feature id is required to remove its specific state property.")));const s=this._getSourceCaches(i);for(const i of s)i.removeFeatureState(o,e.id,t)}getFeatureState(e){this._checkLoaded();const t=e.source,i=e.sourceLayer,r=this.getSource(t);if(r){if("vector"!==r.type||i)return void 0===e.id&&this.fire(new ErrorEvent(new Error("The feature id parameter must be provided."))),this._getSourceCaches(t)[0].getFeatureState(i,e.id);this.fire(new ErrorEvent(new Error("The sourceLayer parameter must be provided for vector source types.")))}else this.fire(new ErrorEvent(new Error(`The source '${t}' does not exist in the map's style.`)))}getTransition(){return L({duration:300,delay:0},this.stylesheet&&this.stylesheet.transition)}serialize(){const e={};for(const t in this._sourceCaches){const i=this._sourceCaches[t].getSource();e[i.id]||(e[i.id]=i.serialize())}return q({version:this.stylesheet.version,name:this.stylesheet.name,metadata:this.stylesheet.metadata,light:this.stylesheet.light,terrain:this.getTerrain()||void 0,fog:this.stylesheet.fog,center:this.stylesheet.center,zoom:this.stylesheet.zoom,bearing:this.stylesheet.bearing,pitch:this.stylesheet.pitch,sprite:this.stylesheet.sprite,glyphs:this.stylesheet.glyphs,transition:this.stylesheet.transition,projection:this.stylesheet.projection,sources:e,layers:this._serializeLayers(this._order)},(e=>void 0!==e))}_updateLayer(e){this._updatedLayers[e.id]=!0;const t=this._getLayerSourceCache(e);e.source&&!this._updatedSources[e.source]&&t&&"raster"!==t.getSource().type&&(this._updatedSources[e.source]="reload",t.pause()),this._changed=!0,e.invalidateCompiledFilter()}_flattenAndSortRenderedFeatures(e){const t=e=>"fill-extrusion"===this._layers[e].type,i={},r=[];for(let n=this._order.length-1;n>=0;n--){const o=this._order[n];if(t(o)){i[o]=n;for(const t of e){const e=t[o];if(e)for(const t of e)r.push(t)}}}r.sort(((e,t)=>t.intersectionZ-e.intersectionZ));const n=[];for(let o=this._order.length-1;o>=0;o--){const s=this._order[o];if(t(s))for(let e=r.length-1;e>=0;e--){const t=r[e].feature;if(i[t.layer.id]<o)break;n.push(t),r.pop()}else for(const t of e){const e=t[s];if(e)for(const t of e)n.push(t.feature)}}return n}queryRenderedFeatures(e,t,i){t&&t.filter&&this._validate(Dn,"queryRenderedFeatures.filter",t.filter,null,t);const r={};if(t&&t.layers){if(!Array.isArray(t.layers))return this.fire(new ErrorEvent(new Error("parameters.layers must be an Array."))),[];for(const e of t.layers){const t=this._layers[e];if(!t)return this.fire(new ErrorEvent(new Error(`The layer '${e}' does not exist in the map's style and cannot be queried for features.`))),[];r[t.source]=!0}}const n=[];t.availableImages=this._availableImages;const o=t&&t.layers?t.layers.some((e=>{const t=this.getLayer(e);return t&&t.is3D()})):this.has3DLayers(),s=QueryGeometry.createFromScreenPoints(e,i);for(const e in this._sourceCaches){const a=this._sourceCaches[e].getSource().id;t.layers&&!r[a]||n.push(Cd(this._sourceCaches[e],this._layers,this._serializedLayers,s,t,i,o,!!this.map._showQueryGeometry))}return this.placement&&n.push(function(e,t,i,r,n,o,s){const a={},l=o.queryRenderedSymbols(r),c=[];for(const e of Object.keys(l).map(Number))c.push(s[e]);c.sort(Md);for(const i of c){const r=i.featureIndex.lookupSymbolFeatures(l[i.bucketInstanceId],t,i.bucketIndex,i.sourceLayerIndex,n.filter,n.layers,n.availableImages,e);for(const e in r){const t=a[e]=a[e]||[],n=r[e];n.sort(((e,t)=>{const r=i.featureSortOrder;if(r){const i=r.indexOf(e.featureIndex);return r.indexOf(t.featureIndex)-i}return t.featureIndex-e.featureIndex}));for(const e of n)t.push(e)}}for(const t in a)a[t].forEach((r=>{const n=r.feature,o=i(e[t]);if(!o)return;const s=o.getFeatureState(n.layer["source-layer"],n.id);n.source=n.layer.source,n.layer["source-layer"]&&(n.sourceLayer=n.layer["source-layer"]),n.state=s}));return a}(this._layers,this._serializedLayers,this._getLayerSourceCache.bind(this),s.screenGeometry,t,this.placement.collisionIndex,this.placement.retainedQueryData)),this._flattenAndSortRenderedFeatures(n)}querySourceFeatures(e,t){t&&t.filter&&this._validate(Dn,"querySourceFeatures.filter",t.filter,null,t);const i=this._getSourceCaches(e);let r=[];for(const e of i)r=r.concat(Id(e,t));return r}addSourceType(e,t,i){return Style.getSourceType(e)?i(new Error(`A source type called "${e}" already exists.`)):(Style.setSourceType(e,t),t.workerSourceURL?void this.dispatcher.broadcast("loadWorkerSource",{name:e,url:t.workerSourceURL},i):i(null,null))}getLight(){return this.light.getLight()}setLight(e,t={}){this._checkLoaded();const i=this.light.getLight();let r=!1;for(const t in e)if(!y(e[t],i[t])){r=!0;break}if(!r)return;const n=this._setTransitionParameters({duration:300,delay:0});this.light.setLight(e,t),this.light.updateTransitions(n)}getTerrain(){return this.terrain&&1===this.terrain.drapeRenderMode?this.terrain.get():null}setTerrainForDraping(){this.setTerrain({source:"",exaggeration:0},0)}setTerrain(e,t=1){if(this._checkLoaded(),!e)return delete this.terrain,delete this.stylesheet.terrain,this.dispatcher.broadcast("enableTerrain",!1),this._force3DLayerUpdate(),void(this._markersNeedUpdate=!0);let i=e;if(1===t){if("object"==typeof i.source){const e="terrain-dem-src";this.addSource(e,i.source),i=Z(i),i=L(i,{source:e})}if(this._validate(Cn,"terrain",i))return}if(!this.terrain||this.terrain&&t!==this.terrain.drapeRenderMode){if(!i)return;this._createTerrain(i,t)}else{const e=this.terrain,t=e.get();for(const e of Object.keys(yt.terrain))!i.hasOwnProperty(e)&&yt.terrain[e].default&&(i[e]=yt.terrain[e].default);for(const r in i)if(!y(i[r],t[r])){e.set(i),this.stylesheet.terrain=i;const t=this._setTransitionParameters({duration:0});e.updateTransitions(t);break}}this._updateDrapeFirstLayers(),this._markersNeedUpdate=!0}_createFog(e){const t=this.fog=new Fog(e,this.map.transform);this.stylesheet.fog=e;const i=this._setTransitionParameters({duration:0});t.updateTransitions(i)}_updateMarkersOpacity(){0!==this.map._markers.length&&this.map._requestDomTask((()=>{for(const e of this.map._markers)e._evaluateOpacity()}))}getFog(){return this.fog?this.fog.get():null}setFog(e){if(this._checkLoaded(),!e)return delete this.fog,delete this.stylesheet.fog,void(this._markersNeedUpdate=!0);if(this.fog){const t=this.fog,i=t.get();0===Object.keys(e).length&&t.set(e);for(const r in e)if(!y(e[r],i[r])){t.set(e),this.stylesheet.fog=e;const i=this._setTransitionParameters({duration:0});t.updateTransitions(i);break}}else this._createFog(e);this._markersNeedUpdate=!0}_setTransitionParameters(e){return{now:it.now(),transition:L(e,this.stylesheet.transition)}}_updateDrapeFirstLayers(){if(!this.map._optimizeForTerrain||!this.terrain)return;const e=this._order.filter((e=>this.isLayerDraped(this._layers[e]))),t=this._order.filter((e=>!this.isLayerDraped(this._layers[e])));this._drapedFirstOrder=[],this._drapedFirstOrder.push(...e),this._drapedFirstOrder.push(...t)}_createTerrain(e,t){const i=this.terrain=new Fh(e,t);this.stylesheet.terrain=e,this.dispatcher.broadcast("enableTerrain",!this.terrainSetForDrapingOnly()),this._force3DLayerUpdate();const r=this._setTransitionParameters({duration:0});i.updateTransitions(r)}_force3DLayerUpdate(){for(const e in this._layers){const t=this._layers[e];"fill-extrusion"===t.type&&this._updateLayer(t)}}_forceSymbolLayerUpdate(){for(const e in this._layers){const t=this._layers[e];"symbol"===t.type&&this._updateLayer(t)}}_validate(e,t,i,r,n={}){return(!n||!1!==n.validate)&&Dp(this,e.call(Tn,L({key:t,style:this.serialize(),value:i,styleSpec:yt},r)))}_remove(){this._request&&(this._request.cancel(),this._request=null),this._spriteRequest&&(this._spriteRequest.cancel(),this._spriteRequest=null),so.off("pluginStateChange",this._rtlTextPluginCallback);for(const e in this._layers)this._layers[e].setEventedParent(null);for(const e in this._sourceCaches)this._sourceCaches[e].clearTiles(),this._sourceCaches[e].setEventedParent(null);this.imageManager.setEventedParent(null),this.setEventedParent(null),this.dispatcher.remove()}_clearSource(e){const t=this._getSourceCaches(e);for(const e of t)e.clearTiles()}_reloadSource(e){const t=this._getSourceCaches(e);for(const e of t)e.resume(),e.reload()}_reloadSources(){for(const e of this._getSources())e.reload&&e.reload()}_updateSources(e){for(const t in this._sourceCaches)this._sourceCaches[t].update(e)}_generateCollisionBoxes(){for(const e in this._sourceCaches){const t=this._sourceCaches[e];t.resume(),t.reload()}}_updatePlacement(e,t,i,r,n=!1){let o=!1,s=!1;const a={};for(const t of this._order){const i=this._layers[t];if("symbol"!==i.type)continue;if(!a[i.source]){const e=this._getLayerSourceCache(i);if(!e)continue;a[i.source]=e.getRenderableIds(!0).map((t=>e.getTileByID(t))).sort(((e,t)=>t.tileID.overscaledZ-e.tileID.overscaledZ||(e.tileID.isLessThan(t.tileID)?-1:1)))}const r=this.crossTileSymbolIndex.addLayer(i,a[i.source],e.center.lng,e.projection);o=o||r}if(this.crossTileSymbolIndex.pruneUnusedLayers(this._order),n=n||this._layerOrderChanged||0===i,this._layerOrderChanged&&this.fire(new Event("neworder")),(n||!this.pauseablePlacement||this.pauseablePlacement.isDone()&&!this.placement.stillRecent(it.now(),e.zoom))&&(this.pauseablePlacement=new PauseablePlacement(e,this._order,n,t,i,r,this.placement,this.fog&&e.projection.supportsFog?this.fog.state:null),this._layerOrderChanged=!1),this.pauseablePlacement.isDone()?this.placement.setStale():(this.pauseablePlacement.continuePlacement(this._order,this._layers,a),this.pauseablePlacement.isDone()&&(this.placement=this.pauseablePlacement.commit(it.now()),s=!0),o&&this.pauseablePlacement.placement.setStale()),s||o)for(const e of this._order){const t=this._layers[e];"symbol"===t.type&&this.placement.updateLayerOpacities(t,a[t.source])}return!this.pauseablePlacement.isDone()||this.placement.hasTransitions(it.now())}_releaseSymbolFadeTiles(){for(const e in this._sourceCaches)this._sourceCaches[e].releaseSymbolFadeTiles()}getImages(e,t,i){this.imageManager.getImages(t.icons,i),this._updateTilesForChangedImages();const r=e=>{e&&e.setDependencies(t.tileID.key,t.type,t.icons)};r(this._otherSourceCaches[t.source]),r(this._symbolSourceCaches[t.source])}getGlyphs(e,t,i){this.glyphManager.getGlyphs(t.stacks,i)}getResource(e,t,i){return ge(t,i)}_getSourceCache(e){return this._otherSourceCaches[e]}_getLayerSourceCache(e){return"symbol"===e.type?this._symbolSourceCaches[e.source]:this._otherSourceCaches[e.source]}_getSourceCaches(e){const t=[];return this._otherSourceCaches[e]&&t.push(this._otherSourceCaches[e]),this._symbolSourceCaches[e]&&t.push(this._symbolSourceCaches[e]),t}_isSourceCacheLoaded(e){const t=this._getSourceCaches(e);return 0===t.length?(this.fire(new ErrorEvent(new Error(`There is no source with ID '${e}'`))),!1):t.every((e=>e.loaded()))}has3DLayers(){return this._num3DLayers>0}hasSymbolLayers(){return this._numSymbolLayers>0}hasCircleLayers(){return this._numCircleLayers>0}_clearWorkerCaches(){this.dispatcher.broadcast("clearCaches")}destroy(){this._clearWorkerCaches(),this.terrainSetForDrapingOnly()&&(delete this.terrain,delete this.stylesheet.terrain)}}Style.getSourceType=function(e){return Td[e]},Style.setSourceType=function(e,t){Td[e]=t},Style.registerForPluginStateChange=function(e){return e({pluginStatus:io,pluginURL:ro}),so.on("pluginStateChange",e),e};var Rp="\n#define EPSILON 0.0000001\n#define PI 3.141592653589793\n#define EXTENT 8192.0\n#define HALF_PI PI/2.0\n#define QUARTER_PI PI/4.0\n#define RAD_TO_DEG 180.0/PI\n#define DEG_TO_RAD PI/180.0\n#define GLOBE_RADIUS EXTENT/PI/2.0",Fp="attribute highp vec3 a_pos_3f;uniform lowp mat4 u_matrix;varying highp vec3 v_uv;void main() {const mat3 half_neg_pi_around_x=mat3(1.0,0.0, 0.0,0.0,0.0,-1.0,0.0,1.0, 0.0);v_uv=half_neg_pi_around_x*a_pos_3f;vec4 pos=u_matrix*vec4(a_pos_3f,1.0);gl_Position=pos.xyww;}",Op="\n#define ELEVATION_SCALE 7.0\n#define ELEVATION_OFFSET 450.0\n#ifdef PROJECTION_GLOBE_VIEW\nuniform vec3 u_tile_tl_up;uniform vec3 u_tile_tr_up;uniform vec3 u_tile_br_up;uniform vec3 u_tile_bl_up;uniform float u_tile_up_scale;vec3 elevationVector(vec2 pos) {vec2 uv=pos/EXTENT;vec3 up=normalize(mix(\nmix(u_tile_tl_up,u_tile_tr_up,uv.xxx),mix(u_tile_bl_up,u_tile_br_up,uv.xxx),uv.yyy));return up*u_tile_up_scale;}\n#else\nvec3 elevationVector(vec2 pos) { return vec3(0,0,1); }\n#endif\nconst float skirtOffset=24575.0;vec3 decomposeToPosAndSkirt(vec2 posWithComposedSkirt)\n{float skirt=float(posWithComposedSkirt.x >=skirtOffset);vec2 pos=posWithComposedSkirt-vec2(skirt*skirtOffset,0.0);return vec3(pos,skirt);}\n#ifdef TERRAIN\n#ifdef TERRAIN_DEM_FLOAT_FORMAT\nuniform highp sampler2D u_dem;uniform highp sampler2D u_dem_prev;\n#else\nuniform sampler2D u_dem;uniform sampler2D u_dem_prev;\n#endif\nuniform vec4 u_dem_unpack;uniform vec2 u_dem_tl;uniform vec2 u_dem_tl_prev;uniform float u_dem_scale;uniform float u_dem_scale_prev;uniform float u_dem_size;uniform float u_dem_lerp;uniform float u_exaggeration;uniform float u_meter_to_dem;uniform mat4 u_label_plane_matrix_inv;uniform sampler2D u_depth;uniform vec2 u_depth_size_inv;vec4 tileUvToDemSample(vec2 uv,float dem_size,float dem_scale,vec2 dem_tl) {vec2 pos=dem_size*(uv*dem_scale+dem_tl)+1.0;vec2 f=fract(pos);return vec4((pos-f+0.5)/(dem_size+2.0),f);}float decodeElevation(vec4 v) {return dot(vec4(v.xyz*255.0,-1.0),u_dem_unpack);}float currentElevation(vec2 apos) {\n#ifdef TERRAIN_DEM_FLOAT_FORMAT\nvec2 pos=(u_dem_size*(apos/8192.0*u_dem_scale+u_dem_tl)+1.5)/(u_dem_size+2.0);return u_exaggeration*texture2D(u_dem,pos).a;\n#else\nfloat dd=1.0/(u_dem_size+2.0);vec4 r=tileUvToDemSample(apos/8192.0,u_dem_size,u_dem_scale,u_dem_tl);vec2 pos=r.xy;vec2 f=r.zw;float tl=decodeElevation(texture2D(u_dem,pos));\n#ifdef TERRAIN_DEM_NEAREST_FILTER\nreturn u_exaggeration*tl;\n#endif\nfloat tr=decodeElevation(texture2D(u_dem,pos+vec2(dd,0.0)));float bl=decodeElevation(texture2D(u_dem,pos+vec2(0.0,dd)));float br=decodeElevation(texture2D(u_dem,pos+vec2(dd,dd)));return u_exaggeration*mix(mix(tl,tr,f.x),mix(bl,br,f.x),f.y);\n#endif\n}float prevElevation(vec2 apos) {\n#ifdef TERRAIN_DEM_FLOAT_FORMAT\nvec2 pos=(u_dem_size*(apos/8192.0*u_dem_scale_prev+u_dem_tl_prev)+1.5)/(u_dem_size+2.0);return u_exaggeration*texture2D(u_dem_prev,pos).a;\n#else\nfloat dd=1.0/(u_dem_size+2.0);vec4 r=tileUvToDemSample(apos/8192.0,u_dem_size,u_dem_scale_prev,u_dem_tl_prev);vec2 pos=r.xy;vec2 f=r.zw;float tl=decodeElevation(texture2D(u_dem_prev,pos));float tr=decodeElevation(texture2D(u_dem_prev,pos+vec2(dd,0.0)));float bl=decodeElevation(texture2D(u_dem_prev,pos+vec2(0.0,dd)));float br=decodeElevation(texture2D(u_dem_prev,pos+vec2(dd,dd)));return u_exaggeration*mix(mix(tl,tr,f.x),mix(bl,br,f.x),f.y);\n#endif\n}\n#ifdef TERRAIN_VERTEX_MORPHING\nfloat elevation(vec2 apos) {\n#ifdef ZERO_EXAGGERATION\nreturn 0.0;\n#endif\nfloat nextElevation=currentElevation(apos);float prevElevation=prevElevation(apos);return mix(prevElevation,nextElevation,u_dem_lerp);}\n#else\nfloat elevation(vec2 apos) {\n#ifdef ZERO_EXAGGERATION\nreturn 0.0;\n#endif\nreturn currentElevation(apos);}\n#endif\nhighp float unpack_depth(highp vec4 rgba_depth)\n{const highp vec4 bit_shift=vec4(1.0/(255.0*255.0*255.0),1.0/(255.0*255.0),1.0/255.0,1.0);return dot(rgba_depth,bit_shift)*2.0-1.0;}bool isOccluded(vec4 frag) {vec3 coord=frag.xyz/frag.w;float depth=unpack_depth(texture2D(u_depth,(coord.xy+1.0)*0.5));return coord.z > depth+0.0005;}float occlusionFade(vec4 frag) {vec3 coord=frag.xyz/frag.w;vec3 df=vec3(5.0*u_depth_size_inv,0.0);vec2 uv=0.5*coord.xy+0.5;vec4 depth=vec4(\nunpack_depth(texture2D(u_depth,uv-df.xz)),unpack_depth(texture2D(u_depth,uv+df.xz)),unpack_depth(texture2D(u_depth,uv-df.zy)),unpack_depth(texture2D(u_depth,uv+df.zy))\n);return dot(vec4(0.25),vec4(1.0)-clamp(300.0*(vec4(coord.z-0.001)-depth),0.0,1.0));}vec4 fourSample(vec2 pos,vec2 off) {\n#ifdef TERRAIN_DEM_FLOAT_FORMAT\nfloat tl=texture2D(u_dem,pos).a;float tr=texture2D(u_dem,pos+vec2(off.x,0.0)).a;float bl=texture2D(u_dem,pos+vec2(0.0,off.y)).a;float br=texture2D(u_dem,pos+off).a;\n#else\nvec4 demtl=vec4(texture2D(u_dem,pos).xyz*255.0,-1.0);float tl=dot(demtl,u_dem_unpack);vec4 demtr=vec4(texture2D(u_dem,pos+vec2(off.x,0.0)).xyz*255.0,-1.0);float tr=dot(demtr,u_dem_unpack);vec4 dembl=vec4(texture2D(u_dem,pos+vec2(0.0,off.y)).xyz*255.0,-1.0);float bl=dot(dembl,u_dem_unpack);vec4 dembr=vec4(texture2D(u_dem,pos+off).xyz*255.0,-1.0);float br=dot(dembr,u_dem_unpack);\n#endif\nreturn vec4(tl,tr,bl,br);}float flatElevation(vec2 pack) {vec2 apos=floor(pack/8.0);vec2 span=10.0*(pack-apos*8.0);vec2 uvTex=(apos-vec2(1.0,1.0))/8190.0;float size=u_dem_size+2.0;float dd=1.0/size;vec2 pos=u_dem_size*(uvTex*u_dem_scale+u_dem_tl)+1.0;vec2 f=fract(pos);pos=(pos-f+0.5)*dd;vec4 h=fourSample(pos,vec2(dd));float z=mix(mix(h.x,h.y,f.x),mix(h.z,h.w,f.x),f.y);vec2 w=floor(0.5*(span*u_meter_to_dem-1.0));vec2 d=dd*w;h=fourSample(pos-d,2.0*d+vec2(dd));vec4 diff=abs(h.xzxy-h.ywzw);vec2 slope=min(vec2(0.25),u_meter_to_dem*0.5*(diff.xz+diff.yw)/(2.0*w+vec2(1.0)));vec2 fix=slope*span;float base=z+max(fix.x,fix.y);return u_exaggeration*base;}float elevationFromUint16(float word) {return u_exaggeration*(word/ELEVATION_SCALE-ELEVATION_OFFSET);}\n#else\nfloat elevation(vec2 pos) { return 0.0; }bool isOccluded(vec4 frag) { return false; }float occlusionFade(vec4 frag) { return 1.0; }\n#endif",Up="#ifdef FOG\nuniform mediump vec4 u_fog_color;uniform mediump vec2 u_fog_range;uniform mediump float u_fog_horizon_blend;uniform mediump mat4 u_fog_matrix;varying vec3 v_fog_pos;float fog_range(float depth) {return (depth-u_fog_range[0])/(u_fog_range[1]-u_fog_range[0]);}float fog_horizon_blending(vec3 camera_dir) {float t=max(0.0,camera_dir.z/u_fog_horizon_blend);return u_fog_color.a*exp(-3.0*t*t);}float fog_opacity(float t) {const float decay=6.0;float falloff=1.0-min(1.0,exp(-decay*t));falloff*=falloff*falloff;return u_fog_color.a*min(1.0,1.00747*falloff);}vec3 fog_position(vec3 pos) {return (u_fog_matrix*vec4(pos,1.0)).xyz;}vec3 fog_position(vec2 pos) {return fog_position(vec3(pos,0.0));}float fog(vec3 pos) {float depth=length(pos);float opacity=fog_opacity(fog_range(depth));return opacity*fog_horizon_blending(pos/depth);}\n#endif",Vp="#ifdef FOG\nuniform mediump vec4 u_fog_color;uniform mediump vec2 u_fog_range;uniform mediump float u_fog_horizon_blend;uniform mediump float u_fog_temporal_offset;varying vec3 v_fog_pos;uniform highp vec3 u_frustum_tl;uniform highp vec3 u_frustum_tr;uniform highp vec3 u_frustum_br;uniform highp vec3 u_frustum_bl;uniform highp vec3 u_globe_pos;uniform highp float u_globe_radius;uniform highp vec2 u_viewport;uniform float u_globe_transition;uniform int u_is_globe;float fog_range(float depth) {return (depth-u_fog_range[0])/(u_fog_range[1]-u_fog_range[0]);}float fog_horizon_blending(vec3 camera_dir) {float t=max(0.0,camera_dir.z/u_fog_horizon_blend);return u_fog_color.a*exp(-3.0*t*t);}float fog_opacity(float t) {const float decay=6.0;float falloff=1.0-min(1.0,exp(-decay*t));falloff*=falloff*falloff;return u_fog_color.a*min(1.0,1.00747*falloff);}float globe_glow_progress() {highp vec2 uv=gl_FragCoord.xy/u_viewport;highp vec3 ray_dir=mix(\nmix(u_frustum_tl,u_frustum_tr,uv.x),mix(u_frustum_bl,u_frustum_br,uv.x),1.0-uv.y);highp vec3 dir=normalize(ray_dir);highp vec3 closest_point=dot(u_globe_pos,dir)*dir;highp float sdf=length(closest_point-u_globe_pos)/u_globe_radius;return sdf+PI*0.5;}float fog_opacity(vec3 pos) {float depth=length(pos);return fog_opacity(fog_range(depth));}vec3 fog_apply(vec3 color,vec3 pos) {float depth=length(pos);float opacity;if (u_is_globe==1) {float glow_progress=globe_glow_progress();float t=mix(glow_progress,depth,u_globe_transition);opacity=fog_opacity(fog_range(t));} else {opacity=fog_opacity(fog_range(depth));opacity*=fog_horizon_blending(pos/depth);}return mix(color,u_fog_color.rgb,opacity);}vec4 fog_apply_from_vert(vec4 color,float fog_opac) {float alpha=EPSILON+color.a;color.rgb=mix(color.rgb/alpha,u_fog_color.rgb,fog_opac)*alpha;return color;}vec3 fog_apply_sky_gradient(vec3 camera_ray,vec3 sky_color) {float horizon_blend=fog_horizon_blending(normalize(camera_ray));return mix(sky_color,u_fog_color.rgb,horizon_blend);}vec4 fog_apply_premultiplied(vec4 color,vec3 pos) {float alpha=EPSILON+color.a;color.rgb=fog_apply(color.rgb/alpha,pos)*alpha;return color;}vec3 fog_dither(vec3 color) {vec2 dither_seed=gl_FragCoord.xy+u_fog_temporal_offset;return dither(color,dither_seed);}vec4 fog_dither(vec4 color) {return vec4(fog_dither(color.rgb),color.a);}\n#endif";let jp={},Np={};const Gp=[];Hp(Rp,Gp),Hp(Op,Gp),Hp(Up,Gp),Hp(Vp,Gp),jp=Xp("",Op),Np=Xp(Vp,Up);const qp=Xp("\n#if __VERSION__ >=300\n#define varying in\n#define gl_FragColor glFragColor\n#define texture2D texture\n#define textureCube texture\nout vec4 glFragColor;\n#endif\nhighp vec3 hash(highp vec2 p) {highp vec3 p3=fract(p.xyx*vec3(443.8975,397.2973,491.1871));p3+=dot(p3,p3.yxz+19.19);return fract((p3.xxy+p3.yzz)*p3.zyx);}vec3 dither(vec3 color,highp vec2 seed) {vec3 rnd=hash(seed)+hash(seed+0.59374)-0.5;return color+rnd/255.0;}highp float unpack_depth(highp vec4 rgba_depth)\n{const highp vec4 bit_shift=vec4(1.0/(255.0*255.0*255.0),1.0/(255.0*255.0),1.0/255.0,1.0);return dot(rgba_depth,bit_shift)*2.0-1.0;}highp vec4 pack_depth(highp float ndc_z) {highp float depth=ndc_z*0.5+0.5;const highp vec4 bit_shift=vec4(255.0*255.0*255.0,255.0*255.0,255.0,1.0);const highp vec4 bit_mask =vec4(0.0,1.0/255.0,1.0/255.0,1.0/255.0);highp vec4 res=fract(depth*bit_shift);res-=res.xxyz*bit_mask;return res;}","\n#if __VERSION__ >=300\n#define attribute in\n#define varying out\n#define texture2D texture\n#endif\nfloat wrap(float n,float min,float max) {float d=max-min;float w=mod(mod(n-min,d)+d,d)+min;return (w==min) ? max : w;}\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 mercator_tile_position(mat4 matrix,vec2 tile_anchor,vec3 tile_id,vec2 mercator_center) {\n#ifndef PROJECTED_POS_ON_VIEWPORT\nfloat tiles=tile_id.z;vec2 mercator=(tile_anchor/EXTENT+tile_id.xy)/tiles;mercator-=mercator_center;mercator.x=wrap(mercator.x,-0.5,0.5);vec4 mercator_tile=vec4(mercator.xy*EXTENT,EXTENT/(2.0*PI),1.0);mercator_tile=matrix*mercator_tile;return mercator_tile.xyz;\n#else\nreturn vec3(0.0);\n#endif\n}vec3 mix_globe_mercator(vec3 globe,vec3 mercator,float t) {return mix(globe,mercator,t);}mat3 globe_mercator_surface_vectors(vec3 pos_normal,vec3 up_dir,float zoom_transition) {vec3 normal=zoom_transition==0.0 ? pos_normal : normalize(mix(pos_normal,up_dir,zoom_transition));vec3 xAxis=normalize(vec3(normal.z,0.0,-normal.x));vec3 yAxis=normalize(cross(normal,xAxis));return mat3(xAxis,yAxis,normal);}\n#endif\nvec2 unpack_float(const float packedValue) {int packedIntValue=int(packedValue);int v0=packedIntValue/256;return vec2(v0,packedIntValue-v0*256);}vec2 unpack_opacity(const float packedOpacity) {int intOpacity=int(packedOpacity)/2;return vec2(float(intOpacity)/127.0,mod(packedOpacity,2.0));}vec4 decode_color(const vec2 encodedColor) {return vec4(\nunpack_float(encodedColor[0])/255.0,unpack_float(encodedColor[1])/255.0\n);}float unpack_mix_vec2(const vec2 packedValue,const float t) {return mix(packedValue[0],packedValue[1],t);}vec4 unpack_mix_color(const vec4 packedColors,const float t) {vec4 minColor=decode_color(vec2(packedColors[0],packedColors[1]));vec4 maxColor=decode_color(vec2(packedColors[2],packedColors[3]));return mix(minColor,maxColor,t);}vec2 get_pattern_pos(const vec2 pixel_coord_upper,const vec2 pixel_coord_lower,const vec2 pattern_size,const float tile_units_to_pixels,const vec2 pos) {vec2 offset=mod(mod(mod(pixel_coord_upper,pattern_size)*256.0,pattern_size)*256.0+pixel_coord_lower,pattern_size);return (tile_units_to_pixels*pos+offset)/pattern_size;}const vec4 AWAY=vec4(-1000.0,-1000.0,-1000.0,1);//Normalized device coordinate that is not rendered."),Zp=Rp,$p="\n#ifdef GL_ES\nprecision mediump float;\n#else\n\n#if !defined(lowp)\n#define lowp\n#endif\n\n#if !defined(mediump)\n#define mediump\n#endif\n\n#if !defined(highp)\n#define highp\n#endif\n\n#endif";var Wp={background:Xp("uniform vec4 u_color;uniform float u_opacity;\n#ifdef LIGHTING_3D_MODE\nvarying vec4 v_color;\n#endif\nvoid main() {vec4 out_color;\n#ifdef LIGHTING_3D_MODE\nout_color=v_color;\n#else\nout_color=u_color;\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\ngl_FragColor=out_color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec2 a_pos;uniform mat4 u_matrix;\n#ifdef LIGHTING_3D_MODE\nuniform vec4 u_color;varying vec4 v_color;\n#endif\nvoid main() {gl_Position=u_matrix*vec4(a_pos,0,1);\n#ifdef LIGHTING_3D_MODE\nv_color=apply_lighting(u_color);\n#endif\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}"),backgroundPattern:Xp("uniform vec2 u_pattern_tl;uniform vec2 u_pattern_br;uniform vec2 u_texsize;uniform float u_opacity;uniform sampler2D u_image;varying vec2 v_pos;void main() {vec2 imagecoord=mod(v_pos,1.0);vec2 pos=mix(u_pattern_tl/u_texsize,u_pattern_br/u_texsize,imagecoord);vec4 out_color=texture2D(u_image,pos);\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting(out_color);\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\ngl_FragColor=out_color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_pattern_size;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_tile_units_to_pixels;attribute vec2 a_pos;varying vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);v_pos=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_pattern_size,u_tile_units_to_pixels,a_pos);\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}"),circle:Xp("varying vec3 v_data;varying float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 extrude=v_data.xy;float extrude_length=length(extrude);lowp float antialiasblur=v_data.z;float antialiased_blur=-max(blur,antialiasblur);float opacity_t=smoothstep(0.0,antialiased_blur,extrude_length-1.0);float color_t=stroke_width < 0.01 ? 0.0 : smoothstep(\nantialiased_blur,0.0,extrude_length-radius/(radius+stroke_width)\n);vec4 out_color=mix(color*opacity,stroke_color*stroke_opacity,color_t);\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting(out_color);\n#endif\n#ifdef FOG\nout_color=fog_apply_premultiplied(out_color,v_fog_pos);\n#endif\ngl_FragColor=out_color*(v_visibility*opacity_t);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","#define NUM_VISIBILITY_RINGS 2\n#define INV_SQRT2 0.70710678\n#define ELEVATION_BIAS 0.0001\n#define NUM_SAMPLES_PER_RING 16\nuniform mat4 u_matrix;uniform mat2 u_extrude_scale;uniform lowp float u_device_pixel_ratio;uniform highp float u_camera_to_center_distance;attribute vec2 a_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nattribute vec3 a_pos_3;attribute vec3 a_pos_normal_3;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_tile_id;uniform float u_zoom_transition;uniform vec3 u_up_dir;\n#endif\nvarying vec3 v_data;varying float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvec2 calc_offset(vec2 extrusion,float radius,float stroke_width, float view_scale) {return extrusion*(radius+stroke_width)*u_extrude_scale*view_scale;}float cantilevered_elevation(vec2 pos,float radius,float stroke_width,float view_scale) {vec2 c1=pos+calc_offset(vec2(-1,-1),radius,stroke_width,view_scale);vec2 c2=pos+calc_offset(vec2(1,-1),radius,stroke_width,view_scale);vec2 c3=pos+calc_offset(vec2(1,1),radius,stroke_width,view_scale);vec2 c4=pos+calc_offset(vec2(-1,1),radius,stroke_width,view_scale);float h1=elevation(c1)+ELEVATION_BIAS;float h2=elevation(c2)+ELEVATION_BIAS;float h3=elevation(c3)+ELEVATION_BIAS;float h4=elevation(c4)+ELEVATION_BIAS;return max(h4,max(h3,max(h1,h2)));}float circle_elevation(vec2 pos) {\n#if defined(TERRAIN)\nreturn elevation(pos)+ELEVATION_BIAS;\n#else\nreturn 0.0;\n#endif\n}vec4 project_vertex(vec2 extrusion,vec4 world_center,vec4 projected_center,float radius,float stroke_width, float view_scale,mat3 surface_vectors) {vec2 sample_offset=calc_offset(extrusion,radius,stroke_width,view_scale);\n#ifdef PITCH_WITH_MAP\n#ifdef PROJECTION_GLOBE_VIEW\nreturn u_matrix*( world_center+vec4(sample_offset.x*surface_vectors[0]+sample_offset.y*surface_vectors[1],0) );\n#else\nreturn u_matrix*( world_center+vec4(sample_offset,0,0) );\n#endif\n#else\nreturn projected_center+vec4(sample_offset,0,0);\n#endif\n}float get_sample_step() {\n#ifdef PITCH_WITH_MAP\nreturn 2.0*PI/float(NUM_SAMPLES_PER_RING);\n#else\nreturn PI/float(NUM_SAMPLES_PER_RING);\n#endif\n}void main(void) {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 extrude=vec2(mod(a_pos,2.0)*2.0-1.0);vec2 circle_center=floor(a_pos*0.5);vec4 world_center;mat3 surface_vectors;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 pos_normal_3=a_pos_normal_3/16384.0;surface_vectors=globe_mercator_surface_vectors(pos_normal_3,u_up_dir,u_zoom_transition);vec3 surface_extrusion=extrude.x*surface_vectors[0]+extrude.y*surface_vectors[1];vec3 globe_elevation=elevationVector(circle_center)*circle_elevation(circle_center);vec3 globe_pos=a_pos_3+surface_extrusion+globe_elevation;vec3 mercator_elevation=u_up_dir*u_tile_up_scale*circle_elevation(circle_center);vec3 merc_pos=mercator_tile_position(u_inv_rot_matrix,circle_center,u_tile_id,u_merc_center)+surface_extrusion+mercator_elevation;vec3 pos=mix_globe_mercator(globe_pos,merc_pos,u_zoom_transition);world_center=vec4(pos,1);\n#else \nsurface_vectors=mat3(1.0);float height=circle_elevation(circle_center);world_center=vec4(circle_center,height,1);\n#endif\nvec4 projected_center=u_matrix*world_center;float view_scale=0.0;\n#ifdef PITCH_WITH_MAP\n#ifdef SCALE_WITH_MAP\nview_scale=1.0;\n#else\nview_scale=projected_center.w/u_camera_to_center_distance;\n#endif\n#else\n#ifdef SCALE_WITH_MAP\nview_scale=u_camera_to_center_distance;\n#else\nview_scale=projected_center.w;\n#endif\n#endif\ngl_Position=project_vertex(extrude,world_center,projected_center,radius,stroke_width,view_scale,surface_vectors);float visibility=0.0;\n#ifdef TERRAIN\nfloat step=get_sample_step();vec4 occlusion_world_center;vec4 occlusion_projected_center;\n#ifdef PITCH_WITH_MAP\nfloat cantilevered_height=cantilevered_elevation(circle_center,radius,stroke_width,view_scale);occlusion_world_center=vec4(circle_center,cantilevered_height,1);occlusion_projected_center=u_matrix*occlusion_world_center;\n#else\nocclusion_world_center=world_center;occlusion_projected_center=projected_center;\n#endif\nfor(int ring=0; ring < NUM_VISIBILITY_RINGS; ring++) {float scale=(float(ring)+1.0)/float(NUM_VISIBILITY_RINGS);for(int i=0; i < NUM_SAMPLES_PER_RING; i++) {vec2 extrusion=vec2(cos(step*float(i)),-sin(step*float(i)))*scale;vec4 frag_pos=project_vertex(extrusion,occlusion_world_center,occlusion_projected_center,radius,stroke_width,view_scale,surface_vectors);visibility+=float(!isOccluded(frag_pos));}}visibility/=float(NUM_VISIBILITY_RINGS)*float(NUM_SAMPLES_PER_RING);\n#else\nvisibility=1.0;\n#endif\n#ifdef PROJECTION_GLOBE_VIEW\nvisibility=1.0;\n#endif\nv_visibility=visibility;lowp float antialiasblur=1.0/u_device_pixel_ratio/(radius+stroke_width);v_data=vec3(extrude.x,extrude.y,antialiasblur);\n#ifdef FOG\nv_fog_pos=fog_position(world_center.xyz);\n#endif\n}"),clippingMask:Xp("void main() {gl_FragColor=vec4(1.0);}","attribute vec2 a_pos;uniform mat4 u_matrix;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);}"),heatmap:Xp("uniform highp float u_intensity;varying vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#define GAUSS_COEF 0.3989422804014327\nvoid main() {\n#pragma mapbox: initialize highp float weight\nfloat d=-0.5*3.0*3.0*dot(v_extrude,v_extrude);float val=weight*u_intensity*GAUSS_COEF*exp(d);gl_FragColor=vec4(val,1.0,1.0,1.0);\n#ifdef FOG\nif (u_is_globe==0) {gl_FragColor.r*=pow(1.0-fog_opacity(v_fog_pos),2.0);}\n#endif\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform float u_extrude_scale;uniform float u_opacity;uniform float u_intensity;attribute vec2 a_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nattribute vec3 a_pos_3;attribute vec3 a_pos_normal_3;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_tile_id;uniform float u_zoom_transition;uniform vec3 u_up_dir;\n#endif\nvarying vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#pragma mapbox: define mediump float radius\nconst highp float ZERO=1.0/255.0/16.0;\n#define GAUSS_COEF 0.3989422804014327\nvoid main(void) {\n#pragma mapbox: initialize highp float weight\n#pragma mapbox: initialize mediump float radius\nvec2 unscaled_extrude=vec2(mod(a_pos,2.0)*2.0-1.0);float S=sqrt(-2.0*log(ZERO/weight/u_intensity/GAUSS_COEF))/3.0;v_extrude=S*unscaled_extrude;vec2 extrude=v_extrude*radius*u_extrude_scale;vec2 tilePos=floor(a_pos*0.5);vec3 pos;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 pos_normal_3=a_pos_normal_3/16384.0;mat3 surface_vectors=globe_mercator_surface_vectors(pos_normal_3,u_up_dir,u_zoom_transition);vec3 surface_extrusion=extrude.x*surface_vectors[0]+extrude.y*surface_vectors[1];vec3 globe_elevation=elevationVector(tilePos)*elevation(tilePos);vec3 globe_pos=a_pos_3+surface_extrusion+globe_elevation;vec3 mercator_elevation=u_up_dir*u_tile_up_scale*elevation(tilePos);vec3 merc_pos=mercator_tile_position(u_inv_rot_matrix,tilePos,u_tile_id,u_merc_center)+surface_extrusion+mercator_elevation;pos=mix_globe_mercator(globe_pos,merc_pos,u_zoom_transition);\n#else\npos=vec3(tilePos+extrude,elevation(tilePos));\n#endif\ngl_Position=u_matrix*vec4(pos,1);\n#ifdef FOG\nv_fog_pos=fog_position(pos);\n#endif\n}"),heatmapTexture:Xp("uniform sampler2D u_image;uniform sampler2D u_color_ramp;uniform float u_opacity;varying vec2 v_pos;void main() {float t=texture2D(u_image,v_pos).r;vec4 color=texture2D(u_color_ramp,vec2(t,0.5));gl_FragColor=color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(0.0);\n#endif\n}","attribute vec2 a_pos;varying vec2 v_pos;void main() {gl_Position=vec4(a_pos,0,1);v_pos=a_pos*0.5+0.5;}"),collisionBox:Xp("varying float v_placed;varying float v_notUsed;void main() {vec4 red =vec4(1.0,0.0,0.0,1.0);vec4 blue=vec4(0.0,0.0,1.0,0.5);gl_FragColor =mix(red,blue,step(0.5,v_placed))*0.5;gl_FragColor*=mix(1.0,0.1,step(0.5,v_notUsed));}","attribute vec3 a_pos;attribute vec2 a_anchor_pos;attribute vec2 a_extrude;attribute vec2 a_placed;attribute vec2 a_shift;attribute float a_size_scale;attribute vec2 a_padding;uniform mat4 u_matrix;uniform vec2 u_extrude_scale;uniform float u_camera_to_center_distance;varying float v_placed;varying float v_notUsed;void main() {vec4 projectedPoint=u_matrix*vec4(a_pos+elevationVector(a_anchor_pos)*elevation(a_anchor_pos),1);highp float camera_to_anchor_distance=projectedPoint.w;highp float collision_perspective_ratio=clamp(\n0.5+0.5*(u_camera_to_center_distance/camera_to_anchor_distance),0.0,1.5);gl_Position=projectedPoint;gl_Position.xy+=(a_extrude*a_size_scale+a_shift+a_padding)*u_extrude_scale*gl_Position.w*collision_perspective_ratio;v_placed=a_placed.x;v_notUsed=a_placed.y;}"),collisionCircle:Xp("varying float v_radius;varying vec2 v_extrude;varying float v_perspective_ratio;varying float v_collision;void main() {float alpha=0.5*min(v_perspective_ratio,1.0);float stroke_radius=0.9*max(v_perspective_ratio,1.0);float distance_to_center=length(v_extrude);float distance_to_edge=abs(distance_to_center-v_radius);float opacity_t=smoothstep(-stroke_radius,0.0,-distance_to_edge);vec4 color=mix(vec4(0.0,0.0,1.0,0.5),vec4(1.0,0.0,0.0,1.0),v_collision);gl_FragColor=color*alpha*opacity_t;}","attribute vec2 a_pos_2f;attribute float a_radius;attribute vec2 a_flags;uniform mat4 u_matrix;uniform mat4 u_inv_matrix;uniform vec2 u_viewport_size;uniform float u_camera_to_center_distance;varying float v_radius;varying vec2 v_extrude;varying float v_perspective_ratio;varying float v_collision;vec3 toTilePosition(vec2 screenPos) {vec4 rayStart=u_inv_matrix*vec4(screenPos,-1.0,1.0);vec4 rayEnd  =u_inv_matrix*vec4(screenPos, 1.0,1.0);rayStart.xyz/=rayStart.w;rayEnd.xyz  /=rayEnd.w;highp float t=(0.0-rayStart.z)/(rayEnd.z-rayStart.z);return mix(rayStart.xyz,rayEnd.xyz,t);}void main() {vec2 quadCenterPos=a_pos_2f;float radius=a_radius;float collision=a_flags.x;float vertexIdx=a_flags.y;vec2 quadVertexOffset=vec2(\nmix(-1.0,1.0,float(vertexIdx >=2.0)),mix(-1.0,1.0,float(vertexIdx >=1.0 && vertexIdx <=2.0)));vec2 quadVertexExtent=quadVertexOffset*radius;vec3 tilePos=toTilePosition(quadCenterPos);vec4 clipPos=u_matrix*vec4(tilePos,1.0);highp float camera_to_anchor_distance=clipPos.w;highp float collision_perspective_ratio=clamp(\n0.5+0.5*(u_camera_to_center_distance/camera_to_anchor_distance),0.0,4.0);float padding_factor=1.2;v_radius=radius;v_extrude=quadVertexExtent*padding_factor;v_perspective_ratio=collision_perspective_ratio;v_collision=collision;gl_Position=vec4(clipPos.xyz/clipPos.w,1.0)+vec4(quadVertexExtent*padding_factor/u_viewport_size*2.0,0.0,0.0);}"),debug:Xp("uniform highp vec4 u_color;uniform sampler2D u_overlay;varying vec2 v_uv;void main() {vec4 overlay_color=texture2D(u_overlay,v_uv);gl_FragColor=mix(u_color,overlay_color,overlay_color.a);}","attribute vec2 a_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nattribute vec3 a_pos_3;\n#endif\nvarying vec2 v_uv;uniform mat4 u_matrix;uniform float u_overlay_scale;void main() {float h=elevation(a_pos);v_uv=a_pos/8192.0;\n#ifdef PROJECTION_GLOBE_VIEW\ngl_Position=u_matrix*vec4(a_pos_3+elevationVector(a_pos)*h,1);\n#else\ngl_Position=u_matrix*vec4(a_pos*u_overlay_scale,h,1);\n#endif\n}"),fill:Xp("#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\nvec4 out_color=color;\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting(out_color);\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\ngl_FragColor=out_color*opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec2 a_pos;uniform mat4 u_matrix;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=u_matrix*vec4(a_pos,0,1);\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}"),fillOutline:Xp("varying vec2 v_pos;\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);vec4 out_color=outline_color;\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting(out_color);\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\ngl_FragColor=out_color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec2 a_pos;uniform mat4 u_matrix;uniform vec2 u_world;varying vec2 v_pos;\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=u_matrix*vec4(a_pos,0,1);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}"),fillOutlinePattern:Xp("uniform vec2 u_texsize;uniform sampler2D u_image;varying vec2 v_pos;varying vec2 v_pos_world;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;vec2 imagecoord=mod(v_pos,1.0);vec2 pos=mix(pattern_tl/u_texsize,pattern_br/u_texsize,imagecoord);float dist=length(v_pos_world-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);vec4 out_color=texture2D(u_image,pos);\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting(out_color);\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\ngl_FragColor=out_color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_world;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_tile_units_to_pixels;attribute vec2 a_pos;varying vec2 v_pos;varying vec2 v_pos_world;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern\n#pragma mapbox: define lowp float pixel_ratio\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern\n#pragma mapbox: initialize lowp float pixel_ratio\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;gl_Position=u_matrix*vec4(a_pos,0,1);vec2 display_size=(pattern_br-pattern_tl)/pixel_ratio;v_pos=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,display_size,u_tile_units_to_pixels,a_pos);v_pos_world=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}"),fillPattern:Xp("uniform vec2 u_texsize;uniform sampler2D u_image;varying vec2 v_pos;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;vec2 imagecoord=mod(v_pos,1.0);vec2 pos=mix(pattern_tl/u_texsize,pattern_br/u_texsize,imagecoord);vec4 out_color=texture2D(u_image,pos);\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting(out_color);\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\ngl_FragColor=out_color*opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_tile_units_to_pixels;attribute vec2 a_pos;varying vec2 v_pos;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern\n#pragma mapbox: define lowp float pixel_ratio\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern\n#pragma mapbox: initialize lowp float pixel_ratio\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;vec2 display_size=(pattern_br-pattern_tl)/pixel_ratio;gl_Position=u_matrix*vec4(a_pos,0,1);v_pos=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,display_size,u_tile_units_to_pixels,a_pos);\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}"),fillExtrusion:Xp("varying vec4 v_color;\n#ifdef RENDER_SHADOWS\nvarying highp vec4 v_pos_light_view_0;varying highp vec4 v_pos_light_view_1;varying float v_depth;\n#endif\n#ifdef FAUX_AO\nuniform lowp vec2 u_ao;varying vec3 v_ao;\n#endif\n#ifdef ZERO_ROOF_RADIUS\nvarying vec4 v_roof_color;\n#endif\n#if defined(ZERO_ROOF_RADIUS) || defined(RENDER_SHADOWS)\nvarying highp vec3 v_normal;\n#endif\nvoid main() {\n#if defined(ZERO_ROOF_RADIUS) || defined(RENDER_SHADOWS)\nvec3 normal=v_normal;\n#endif\nfloat z;vec4 color;\n#ifdef ZERO_ROOF_RADIUS\nz=float(normal.z > 0.00001);color=mix(v_color,v_roof_color,z);\n#else\ncolor=v_color;\n#endif\n#ifdef FAUX_AO\nfloat intensity=u_ao[0];float h=max(0.0,v_ao.z);float h_floors=h/u_ao[1];float y_shade=1.0-0.9*intensity*min(v_ao.y,1.0);float shade=(1.0-0.08*intensity)*(y_shade+(1.0-y_shade)*(1.0-pow(1.0-min(h_floors/16.0,1.0),16.0)))+0.08*intensity*min(h_floors/160.0,1.0);float concave=v_ao.x*v_ao.x;\n#ifdef ZERO_ROOF_RADIUS\nconcave*=(1.0-z);\n#endif\nfloat x_shade=mix(1.0,mix(0.6,0.75,min(h_floors/30.0,1.0)),intensity)+0.1*intensity*min(h,1.0);shade*=mix(1.0,x_shade*x_shade*x_shade,concave);color.rgb=color.rgb*shade;\n#endif\n#ifdef RENDER_SHADOWS\n#ifdef ZERO_ROOF_RADIUS\nnormal=mix(normal,vec3(0.0,0.0,1.0),z);\n#endif\ncolor.xyz=shadowed_color_normal(color.xyz,normalize(normal),v_pos_light_view_0,v_pos_light_view_1,v_depth);\n#endif\n#ifdef FOG\ncolor=fog_dither(fog_apply_premultiplied(color,v_fog_pos));\n#endif\ngl_FragColor=color;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp float u_lightintensity;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform float u_edge_radius;attribute vec4 a_pos_normal_ed;attribute vec2 a_centroid_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nattribute vec3 a_pos_3;attribute vec3 a_pos_normal_3;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_tile_id;uniform float u_zoom_transition;uniform vec3 u_up_dir;uniform float u_height_lift;\n#endif\nvarying vec4 v_color;\n#ifdef RENDER_SHADOWS\nuniform mat4 u_light_matrix_0;uniform mat4 u_light_matrix_1;varying highp vec4 v_pos_light_view_0;varying highp vec4 v_pos_light_view_1;varying float v_depth;\n#endif\n#ifdef ZERO_ROOF_RADIUS\nvarying vec4 v_roof_color;\n#endif\n#if defined(ZERO_ROOF_RADIUS) || defined(RENDER_SHADOWS)\nvarying highp vec3 v_normal;\n#endif\n#ifdef FAUX_AO\nuniform lowp vec2 u_ao;varying vec3 v_ao;\n#endif\n#pragma mapbox: define highp float base\n#pragma mapbox: define highp float height\n#pragma mapbox: define highp vec4 color\nvoid main() {\n#pragma mapbox: initialize highp float base\n#pragma mapbox: initialize highp float height\n#pragma mapbox: initialize highp vec4 color\nvec4 pos_nx=floor(a_pos_normal_ed*0.5);vec4 top_up_ny_start=a_pos_normal_ed-2.0*pos_nx;vec3 top_up_ny=top_up_ny_start.xyz;float x_normal=pos_nx.z/8192.0;vec3 normal=top_up_ny.y==1.0 ? vec3(0.0,0.0,1.0) : normalize(vec3(x_normal,(2.0*top_up_ny.z-1.0)*(1.0-abs(x_normal)),0.0));\n#if defined(ZERO_ROOF_RADIUS) || defined(RENDER_SHADOWS)\nv_normal=normal;\n#endif\nbase=max(0.0,base);height=max(0.0,top_up_ny.y==0.0 && top_up_ny.x==1.0 ? height-u_edge_radius : height);float t=top_up_ny.x;vec2 centroid_pos=vec2(0.0);\n#if defined(HAS_CENTROID) || defined(TERRAIN)\ncentroid_pos=a_centroid_pos;\n#endif\nfloat ele=0.0;float h=0.0;float c_ele;vec3 pos;\n#ifdef TERRAIN\nbool flat_roof=centroid_pos.x !=0.0 && t > 0.0;ele=elevation(pos_nx.xy);c_ele=flat_roof ? centroid_pos.y==0.0 ? elevationFromUint16(centroid_pos.x) : flatElevation(centroid_pos) : ele;h=flat_roof ? max(c_ele+height,ele+base+2.0) : ele+(t > 0.0 ? height : base==0.0 ?-5.0 : base);pos=vec3(pos_nx.xy,h);\n#else\nh=t > 0.0 ? height : base;pos=vec3(pos_nx.xy,h);\n#endif\n#ifdef PROJECTION_GLOBE_VIEW\nfloat lift=float((t+base) > 0.0)*u_height_lift;h+=lift;vec3 globe_normal=normalize(mix(a_pos_normal_3/16384.0,u_up_dir,u_zoom_transition));vec3 globe_pos=a_pos_3+globe_normal*(u_tile_up_scale*h);vec3 merc_pos=mercator_tile_position(u_inv_rot_matrix,pos.xy,u_tile_id,u_merc_center)+u_up_dir*u_tile_up_scale*pos.z;pos=mix_globe_mercator(globe_pos,merc_pos,u_zoom_transition);\n#endif\nfloat hidden=float(centroid_pos.x==0.0 && centroid_pos.y==1.0);gl_Position=mix(u_matrix*vec4(pos,1),AWAY,hidden);\n#ifdef RENDER_SHADOWS\nv_pos_light_view_0=u_light_matrix_0*vec4(pos,1);v_pos_light_view_1=u_light_matrix_1*vec4(pos,1);v_depth=gl_Position.w;\n#endif\nfloat NdotL=0.0;float colorvalue=0.0;\n#ifdef LIGHTING_3D_MODE\nNdotL=calculate_NdotL(normal);\n#else\ncolorvalue=color.r*0.2126+color.g*0.7152+color.b*0.0722;vec4 ambientlight=vec4(0.03,0.03,0.03,1.0);color+=ambientlight;NdotL=clamp(dot(normal,u_lightpos),0.0,1.0);NdotL=mix((1.0-u_lightintensity),max((1.0-colorvalue+u_lightintensity),1.0),NdotL);\n#endif\nif (normal.y !=0.0) {float r=0.84;\n#ifndef LIGHTING_3D_MODE\nr=mix(0.7,0.98,1.0-u_lightintensity);\n#endif\nNdotL*=(\n(1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),r,1.0)));}v_color=vec4(0.0,0.0,0.0,1.0);\n#ifdef FAUX_AO\nfloat concave=pos_nx.w-floor(pos_nx.w*0.5)*2.0;float start=top_up_ny_start.w;float y_ground=1.0-clamp(t+base,0.0,1.0);float top_height=height;\n#ifdef TERRAIN\ntop_height=mix(max(c_ele+height,ele+base+2.0),ele+height,float(centroid_pos.x==0.0))-ele;y_ground+=y_ground*5.0/max(3.0,top_height);\n#endif\nv_ao=vec3(mix(concave,-concave,start),y_ground,h-ele);NdotL*=(1.0+0.05*(1.0-top_up_ny.y)*u_ao[0]);\n#ifdef PROJECTION_GLOBE_VIEW\ntop_height+=u_height_lift;\n#endif\ngl_Position.z-=(0.0000006*(min(top_height,500.)+2.0*min(base,500.0)+60.0*concave+3.0*start))*gl_Position.w;\n#endif\n#ifdef LIGHTING_3D_MODE\nv_color=apply_lighting(color,NdotL);\n#else\nv_color.rgb+=clamp(color.rgb*NdotL*u_lightcolor,mix(vec3(0.0),vec3(0.3),1.0-u_lightcolor),vec3(1.0));\n#endif\nv_color*=u_opacity;\n#ifdef ZERO_ROOF_RADIUS\nv_roof_color=vec4(0.0,0.0,0.0,1.0);\n#ifdef LIGHTING_3D_MODE\nv_roof_color=apply_lighting(color,calculate_NdotL(vec3(0.0,0.0,1.0)));\n#else\nfloat roofNdotL=clamp(u_lightpos.z,0.0,1.0);roofNdotL=mix((1.0-u_lightintensity),max((1.0-colorvalue+u_lightintensity),1.0),roofNdotL);v_roof_color.rgb+=clamp(color.rgb*roofNdotL*u_lightcolor,mix(vec3(0.0),vec3(0.3),1.0-u_lightcolor),vec3(1.0));\n#endif\nv_roof_color*=u_opacity;\n#endif\n#ifdef FOG\nv_fog_pos=fog_position(pos);\n#endif\n}"),fillExtrusionPattern:Xp("uniform vec2 u_texsize;uniform sampler2D u_image;\n#ifdef FAUX_AO\nuniform lowp vec2 u_ao;varying vec3 v_ao;\n#endif\n#ifdef LIGHTING_3D_MODE\nvarying float v_NdotL;\n#endif\nvarying vec2 v_pos;varying vec4 v_lighting;uniform lowp float u_opacity;\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern\n#pragma mapbox: define lowp float pixel_ratio\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern\n#pragma mapbox: initialize lowp float pixel_ratio\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;vec2 imagecoord=mod(v_pos,1.0);vec2 pos=mix(pattern_tl/u_texsize,pattern_br/u_texsize,imagecoord);vec4 out_color=texture2D(u_image,pos);\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting(out_color,v_NdotL)*u_opacity;\n#else\nout_color=out_color*v_lighting;\n#endif\n#ifdef FAUX_AO\nfloat intensity=u_ao[0];float h=max(0.0,v_ao.z);float h_floors=h/u_ao[1];float y_shade=1.0-0.9*intensity*min(v_ao.y,1.0);float shade=(1.0-0.08*intensity)*(y_shade+(1.0-y_shade)*(1.0-pow(1.0-min(h_floors/16.0,1.0),16.0)))+0.08*intensity*min(h_floors/160.0,1.0);float concave=v_ao.x*v_ao.x;float x_shade=mix(1.0,mix(0.6,0.75,min(h_floors/30.0,1.0)),intensity)+0.1*intensity*min(h,1.0);shade*=mix(1.0,x_shade*x_shade*x_shade,concave);out_color.rgb=out_color.rgb*shade;\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\ngl_FragColor=out_color;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_height_factor;uniform float u_tile_units_to_pixels;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp float u_lightintensity;attribute vec4 a_pos_normal_ed;attribute vec2 a_centroid_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nattribute vec3 a_pos_3;attribute vec3 a_pos_normal_3;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_tile_id;uniform float u_zoom_transition;uniform vec3 u_up_dir;uniform float u_height_lift;\n#endif\nvarying vec2 v_pos;varying vec4 v_lighting;\n#ifdef FAUX_AO\nuniform lowp vec2 u_ao;varying vec3 v_ao;\n#endif\n#ifdef LIGHTING_3D_MODE\nvarying float v_NdotL;\n#endif\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern\n#pragma mapbox: define lowp float pixel_ratio\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern\n#pragma mapbox: initialize lowp float pixel_ratio\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;vec4 pos_nx=floor(a_pos_normal_ed*0.5);mediump vec4 top_up_ny_start=a_pos_normal_ed-2.0*pos_nx;mediump vec3 top_up_ny=top_up_ny_start.xyz;float x_normal=pos_nx.z/8192.0;vec3 normal=top_up_ny.y==1.0 ? vec3(0.0,0.0,1.0) : normalize(vec3(x_normal,(2.0*top_up_ny.z-1.0)*(1.0-abs(x_normal)),0.0));float edgedistance=a_pos_normal_ed.w;vec2 display_size=(pattern_br-pattern_tl)/pixel_ratio;base=max(0.0,base);height=max(0.0,height);float t=top_up_ny.x;float z=t > 0.0 ? height : base;vec2 centroid_pos=vec2(0.0);\n#if defined(HAS_CENTROID) || defined(TERRAIN)\ncentroid_pos=a_centroid_pos;\n#endif\nfloat ele=0.0;float h=z;vec3 p;float c_ele;\n#ifdef TERRAIN\nbool flat_roof=centroid_pos.x !=0.0 && t > 0.0;ele=elevation(pos_nx.xy);c_ele=flat_roof ? centroid_pos.y==0.0 ? elevationFromUint16(centroid_pos.x) : flatElevation(centroid_pos) : ele;h=flat_roof ? max(c_ele+height,ele+base+2.0) : ele+(t > 0.0 ? height : base==0.0 ?-5.0 : base);p=vec3(pos_nx.xy,h);\n#else\np=vec3(pos_nx.xy,z);\n#endif\n#ifdef PROJECTION_GLOBE_VIEW\nfloat lift=float((t+base) > 0.0)*u_height_lift;h+=lift;vec3 globe_normal=normalize(mix(a_pos_normal_3/16384.0,u_up_dir,u_zoom_transition));vec3 globe_pos=a_pos_3+globe_normal*(u_tile_up_scale*(p.z+lift));vec3 merc_pos=mercator_tile_position(u_inv_rot_matrix,p.xy,u_tile_id,u_merc_center)+u_up_dir*u_tile_up_scale*p.z;p=mix_globe_mercator(globe_pos,merc_pos,u_zoom_transition);\n#endif\nfloat hidden=float(centroid_pos.x==0.0 && centroid_pos.y==1.0);gl_Position=mix(u_matrix*vec4(p,1),AWAY,hidden);vec2 pos=normal.z==1.0\n? pos_nx.xy\n: vec2(edgedistance,z*u_height_factor);v_pos=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,display_size,u_tile_units_to_pixels,pos);v_lighting=vec4(0.0,0.0,0.0,1.0);float NdotL=0.0;\n#ifdef LIGHTING_3D_MODE\nNdotL=calculate_NdotL(normal);\n#else\nNdotL=clamp(dot(normal,u_lightpos),0.0,1.0);NdotL=mix((1.0-u_lightintensity),max((0.5+u_lightintensity),1.0),NdotL);\n#endif\nif (normal.y !=0.0) {float r=0.84;\n#ifndef LIGHTING_3D_MODE\nr=mix(0.7,0.98,1.0-u_lightintensity);\n#endif\nNdotL*=(\n(1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),r,1.0)));}\n#ifdef FAUX_AO\nfloat concave=pos_nx.w-floor(pos_nx.w*0.5)*2.0;float start=top_up_ny_start.w;float y_ground=1.0-clamp(t+base,0.0,1.0);float top_height=height;\n#ifdef TERRAIN\ntop_height=mix(max(c_ele+height,ele+base+2.0),ele+height,float(centroid_pos.x==0.0))-ele;y_ground+=y_ground*5.0/max(3.0,top_height);\n#endif\nv_ao=vec3(mix(concave,-concave,start),y_ground,h-ele);NdotL*=(1.0+0.05*(1.0-top_up_ny.y)*u_ao[0]);\n#ifdef PROJECTION_GLOBE_VIEW\ntop_height+=u_height_lift;\n#endif\ngl_Position.z-=(0.0000006*(min(top_height,500.)+2.0*min(base,500.0)+60.0*concave+3.0*start))*gl_Position.w;\n#endif\n#ifdef LIGHTING_3D_MODE\nv_NdotL=NdotL;\n#else\nv_lighting.rgb+=clamp(NdotL*u_lightcolor,mix(vec3(0.0),vec3(0.3),1.0-u_lightcolor),vec3(1.0));v_lighting*=u_opacity;\n#endif \n#ifdef FOG\nv_fog_pos=fog_position(p);\n#endif\n}"),hillshadePrepare:Xp("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D u_image;varying vec2 v_pos;uniform vec2 u_dimension;uniform float u_zoom;uniform vec4 u_unpack;float getElevation(vec2 coord) {\n#ifdef TERRAIN_DEM_FLOAT_FORMAT\nreturn texture2D(u_image,coord).a/4.0;\n#else\nvec4 data=texture2D(u_image,coord)*255.0;data.a=-1.0;return dot(data,u_unpack)/4.0;\n#endif\n}void main() {vec2 epsilon=1.0/u_dimension;float a=getElevation(v_pos+vec2(-epsilon.x,-epsilon.y));float b=getElevation(v_pos+vec2(0,-epsilon.y));float c=getElevation(v_pos+vec2(epsilon.x,-epsilon.y));float d=getElevation(v_pos+vec2(-epsilon.x,0));float e=getElevation(v_pos+vec2(epsilon.x,0));float f=getElevation(v_pos+vec2(-epsilon.x,epsilon.y));float g=getElevation(v_pos+vec2(0,epsilon.y));float h=getElevation(v_pos+vec2(epsilon.x,epsilon.y));float exaggerationFactor=u_zoom < 2.0 ? 0.4 : u_zoom < 4.5 ? 0.35 : 0.3;float exaggeration=u_zoom < 15.0 ? (u_zoom-15.0)*exaggerationFactor : 0.0;vec2 deriv=vec2(\n(c+e+e+h)-(a+d+d+f),(f+g+g+h)-(a+b+b+c)\n)/pow(2.0,exaggeration+(19.2562-u_zoom));gl_FragColor=clamp(vec4(\nderiv.x/2.0+0.5,deriv.y/2.0+0.5,1.0,1.0),0.0,1.0);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_dimension;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);highp vec2 epsilon=1.0/u_dimension;float scale=(u_dimension.x-2.0)/u_dimension.x;v_pos=(a_texture_pos/8192.0)*scale+epsilon;}"),hillshade:Xp("uniform sampler2D u_image;varying vec2 v_pos;uniform vec2 u_latrange;uniform vec2 u_light;uniform vec4 u_shadow;uniform vec4 u_highlight;uniform vec4 u_accent;void main() {vec4 pixel=texture2D(u_image,v_pos);vec2 deriv=((pixel.rg*2.0)-1.0);float scaleFactor=cos(radians((u_latrange[0]-u_latrange[1])*(1.0-v_pos.y)+u_latrange[1]));float slope=atan(1.25*length(deriv)/scaleFactor);float aspect=deriv.x !=0.0 ? atan(deriv.y,-deriv.x) : PI/2.0*(deriv.y > 0.0 ? 1.0 :-1.0);float intensity=u_light.x;float azimuth=u_light.y+PI;float base=1.875-intensity*1.75;float maxValue=0.5*PI;float scaledSlope=intensity !=0.5 ? ((pow(base,slope)-1.0)/(pow(base,maxValue)-1.0))*maxValue : slope;float accent=cos(scaledSlope);vec4 accent_color=(1.0-accent)*u_accent*clamp(intensity*2.0,0.0,1.0);float shade=abs(mod((aspect+azimuth)/PI+0.5,2.0)-1.0);vec4 shade_color=mix(u_shadow,u_highlight,shade)*sin(scaledSlope)*clamp(intensity*2.0,0.0,1.0);gl_FragColor=accent_color*(1.0-shade_color.a)+shade_color;\n#ifdef LIGHTING_3D_MODE\ngl_FragColor=apply_lighting(gl_FragColor);\n#endif\n#ifdef FOG\ngl_FragColor=fog_dither(fog_apply_premultiplied(gl_FragColor,v_fog_pos));\n#endif\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);v_pos=a_texture_pos/8192.0;\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}"),line:Xp("uniform lowp float u_device_pixel_ratio;uniform float u_alpha_discard_threshold;uniform highp vec2 u_trim_offset;varying vec2 v_width2;varying vec2 v_normal;varying float v_gamma_scale;varying highp vec4 v_uv;\n#ifdef RENDER_LINE_DASH\nuniform sampler2D u_dash_image;varying vec2 v_tex;\n#endif\n#ifdef RENDER_LINE_GRADIENT\nuniform sampler2D u_gradient_image;\n#endif\nuniform float u_border_width;uniform vec4 u_border_color;float luminance(vec3 c) {return (c.r+c.r+c.b+c.g+c.g+c.g)*0.1667;}\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define lowp vec4 dash\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nfloat linearstep(float edge0,float edge1,float x) {return  clamp((x-edge0)/(edge1-edge0),0.0,1.0);}void main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize lowp vec4 dash\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);\n#ifdef RENDER_LINE_DASH\nfloat sdfdist=texture2D(u_dash_image,v_tex).a;float sdfgamma=1.0/(2.0*u_device_pixel_ratio)/dash.z;alpha*=linearstep(0.5-sdfgamma/floorwidth,0.5+sdfgamma/floorwidth,sdfdist);\n#endif\nhighp vec4 out_color;\n#ifdef RENDER_LINE_GRADIENT\nout_color=texture2D(u_gradient_image,v_uv.xy);\n#else\nout_color=color;\n#endif\nfloat trimmed=1.0;\n#ifdef RENDER_LINE_TRIM_OFFSET\nhighp float start=v_uv[2];highp float end=v_uv[3];highp float trim_start=u_trim_offset[0];highp float trim_end=u_trim_offset[1];highp float line_progress=(start+(v_uv.x)*(end-start));if (trim_end > trim_start) {if (line_progress <=trim_end && line_progress >=trim_start) {out_color=vec4(0,0,0,0);trimmed=0.0;}}\n#endif\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting(out_color);\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\n#ifdef RENDER_LINE_ALPHA_DISCARD\nif (alpha < u_alpha_discard_threshold) {discard;}\n#endif\n#ifdef RENDER_LINE_BORDER\nfloat edgeBlur=(u_border_width+1.0/u_device_pixel_ratio);float alpha2=clamp(min(dist-(v_width2.t-edgeBlur),v_width2.s-dist)/edgeBlur,0.0,1.0);if (alpha2 < 1.) {float smoothAlpha=smoothstep(0.6,1.0,alpha2);\n#ifdef RENDER_LINE_BORDER_AUTO\nfloat Y=(out_color.a > 0.01) ? luminance(out_color.rgb/out_color.a) : 1.;float adjustment=(Y > 0.) ? 0.5/Y : 0.45;if (out_color.a > 0.25 && Y < 0.25) {vec3 borderColor=(Y > 0.) ? out_color.rgb : vec3(1,1,1)*out_color.a;out_color.rgb=out_color.rgb+borderColor*(adjustment*(1.0-smoothAlpha));} else {out_color.rgb*=(0.6 +0.4*smoothAlpha);}\n#else\nout_color.rgb=mix(u_border_color.rgb*u_border_color.a*trimmed,out_color.rgb,smoothAlpha);\n#endif\n}\n#endif\ngl_FragColor=out_color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","\n#define EXTRUDE_SCALE 0.015873016\nattribute vec2 a_pos_normal;attribute vec4 a_data;\n#if defined(RENDER_LINE_GRADIENT) || defined(RENDER_LINE_TRIM_OFFSET)\nattribute highp vec4 a_packed;\n#endif\n#ifdef RENDER_LINE_DASH\nattribute float a_linesofar;\n#endif\nuniform mat4 u_matrix;uniform mat2 u_pixels_to_tile_units;uniform vec2 u_units_to_pixels;uniform lowp float u_device_pixel_ratio;varying vec2 v_normal;varying vec2 v_width2;varying float v_gamma_scale;varying highp vec4 v_uv;\n#ifdef RENDER_LINE_DASH\nuniform vec2 u_texsize;uniform float u_tile_units_to_pixels;varying vec2 v_tex;\n#endif\n#ifdef RENDER_LINE_GRADIENT\nuniform float u_image_height;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define lowp vec4 dash\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize lowp vec4 dash\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*EXTRUDE_SCALE;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*EXTRUDE_SCALE*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist*u_pixels_to_tile_units,0.0,0.0);gl_Position=u_matrix*vec4(pos+offset2*u_pixels_to_tile_units,0.0,1.0)+projected_extrude;\n#ifndef RENDER_TO_TEXTURE\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#else\nv_gamma_scale=1.0;\n#endif\n#if defined(RENDER_LINE_GRADIENT) || defined(RENDER_LINE_TRIM_OFFSET)\nfloat a_uv_x=a_packed[0];float a_split_index=a_packed[1];highp float a_clip_start=a_packed[2];highp float a_clip_end=a_packed[3];\n#ifdef RENDER_LINE_GRADIENT\nhighp float texel_height=1.0/u_image_height;highp float half_texel_height=0.5*texel_height;v_uv=vec4(a_uv_x,a_split_index*texel_height-half_texel_height,a_clip_start,a_clip_end);\n#else\nv_uv=vec4(a_uv_x,0.0,a_clip_start,a_clip_end);\n#endif\n#endif\n#ifdef RENDER_LINE_DASH\nfloat scale=dash.z==0.0 ? 0.0 : u_tile_units_to_pixels/dash.z;float height=dash.y;v_tex=vec2(a_linesofar*scale/floorwidth,(-normal.y*height+dash.x+0.5)/u_texsize.y);\n#endif\nv_width2=vec2(outset,inset);\n#ifdef FOG\nv_fog_pos=fog_position(pos);\n#endif\n}"),linePattern:Xp("uniform lowp float u_device_pixel_ratio;uniform vec2 u_texsize;uniform float u_tile_units_to_pixels;uniform sampler2D u_image;varying vec2 v_normal;varying vec2 v_width2;varying float v_linesofar;varying float v_gamma_scale;varying float v_width;\n#pragma mapbox: define lowp vec4 pattern\n#pragma mapbox: define lowp float pixel_ratio\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize mediump vec4 pattern\n#pragma mapbox: initialize lowp float pixel_ratio\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;vec2 display_size=(pattern_br-pattern_tl)/pixel_ratio;vec2 pattern_size=vec2(display_size.x/u_tile_units_to_pixels,display_size.y);float aspect=display_size.y/v_width;float dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float x=mod(v_linesofar/pattern_size.x*aspect,1.0);float y=0.5*v_normal.y+0.5;vec2 texel_size=1.0/u_texsize;vec2 pos=mix(pattern_tl*texel_size-texel_size,pattern_br*texel_size+texel_size,vec2(x,y));vec4 color=texture2D(u_image,pos);\n#ifdef LIGHTING_3D_MODE\ncolor=apply_lighting(color);\n#endif\n#ifdef FOG\ncolor=fog_dither(fog_apply_premultiplied(color,v_fog_pos));\n#endif\ngl_FragColor=color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nattribute vec2 a_pos_normal;attribute vec4 a_data;attribute float a_linesofar;uniform mat4 u_matrix;uniform vec2 u_units_to_pixels;uniform mat2 u_pixels_to_tile_units;uniform lowp float u_device_pixel_ratio;varying vec2 v_normal;varying vec2 v_width2;varying float v_linesofar;varying float v_gamma_scale;varying float v_width;\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define lowp vec4 pattern\n#pragma mapbox: define lowp float pixel_ratio\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 pattern\n#pragma mapbox: initialize lowp float pixel_ratio\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist*u_pixels_to_tile_units,0.0,0.0);gl_Position=u_matrix*vec4(pos+offset2*u_pixels_to_tile_units,0.0,1.0)+projected_extrude;\n#ifndef RENDER_TO_TEXTURE\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#else\nv_gamma_scale=1.0;\n#endif\nv_linesofar=a_linesofar;v_width2=vec2(outset,inset);v_width=floorwidth;\n#ifdef FOG\nv_fog_pos=fog_position(pos);\n#endif\n}"),raster:Xp("uniform float u_fade_t;uniform float u_opacity;uniform sampler2D u_image0;uniform sampler2D u_image1;varying vec2 v_pos0;varying vec2 v_pos1;uniform float u_brightness_low;uniform float u_brightness_high;uniform float u_saturation_factor;uniform float u_contrast_factor;uniform vec3 u_spin_weights;void main() {vec4 color0=texture2D(u_image0,v_pos0);vec4 color1=texture2D(u_image1,v_pos1);if (color0.a > 0.0) {color0.rgb=color0.rgb/color0.a;}if (color1.a > 0.0) {color1.rgb=color1.rgb/color1.a;}vec4 color=mix(color0,color1,u_fade_t);color.a*=u_opacity;vec3 rgb=color.rgb;rgb=vec3(\ndot(rgb,u_spin_weights.xyz),dot(rgb,u_spin_weights.zxy),dot(rgb,u_spin_weights.yzx));float average=(color.r+color.g+color.b)/3.0;rgb+=(average-rgb)*u_saturation_factor;rgb=(rgb-0.5)*u_contrast_factor+0.5;vec3 u_high_vec=vec3(u_brightness_low,u_brightness_low,u_brightness_low);vec3 u_low_vec=vec3(u_brightness_high,u_brightness_high,u_brightness_high);vec3 out_color=mix(u_high_vec,u_low_vec,rgb);\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting(out_color);\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply(out_color,v_fog_pos));\n#endif\ngl_FragColor=vec4(out_color*color.a,color.a);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_tl_parent;uniform float u_scale_parent;uniform vec2 u_perspective_transform;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying vec2 v_pos0;varying vec2 v_pos1;void main() {float w=1.0+dot(a_texture_pos,u_perspective_transform);gl_Position=u_matrix*vec4(a_pos*w,0,w);v_pos0=a_texture_pos/8192.0;v_pos1=(v_pos0*u_scale_parent)+u_tl_parent;\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}"),symbolIcon:Xp("uniform sampler2D u_texture;varying vec2 v_tex;varying float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nlowp float alpha=opacity*v_fade_opacity;gl_FragColor=texture2D(u_texture,v_tex)*alpha;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec4 a_pos_offset;attribute vec4 a_tex_size;attribute vec4 a_pixeloffset;attribute vec4 a_projected_pos;attribute float a_fade_opacity;\n#ifdef PROJECTION_GLOBE_VIEW\nattribute vec3 a_globe_anchor;attribute vec3 a_globe_normal;\n#endif\nuniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform highp float u_camera_to_center_distance;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform float u_fade_change;uniform mat4 u_matrix;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform vec2 u_texsize;uniform vec3 u_up_vector;\n#ifdef PROJECTION_GLOBE_VIEW\nuniform vec3 u_tile_id;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_camera_forward;uniform float u_zoom_transition;uniform vec3 u_ecef_origin;uniform mat4 u_tile_matrix;\n#endif\nvarying vec2 v_tex;varying float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_tex_size.xy;vec2 a_size=a_tex_size.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;vec2 a_min_font_scale=a_pixeloffset.zw/256.0;highp float segment_angle=-a_projected_pos[3];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 tile_anchor=a_pos;vec3 h=elevationVector(tile_anchor)*elevation(tile_anchor);float globe_occlusion_fade;vec3 world_pos;vec3 mercator_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nmercator_pos=mercator_tile_position(u_inv_rot_matrix,tile_anchor,u_tile_id,u_merc_center);world_pos=mix_globe_mercator(a_globe_anchor+h,mercator_pos,u_zoom_transition);vec4 ecef_point=u_tile_matrix*vec4(world_pos,1.0);vec3 origin_to_point=ecef_point.xyz-u_ecef_origin;globe_occlusion_fade=dot(origin_to_point,u_camera_forward) >=0.0 ? 0.0 : 1.0;\n#else\nworld_pos=vec3(tile_anchor,0)+h;globe_occlusion_fade=1.0;\n#endif\nvec4 projected_point=u_matrix*vec4(world_pos,1);highp float camera_to_anchor_distance=projected_point.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(\n0.5+0.5*distance_ratio,0.0,1.5);size*=perspective_ratio;float font_scale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjected_point;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 displacement=vec3(a_globe_normal.z,0,-a_globe_normal.x);offsetProjected_point=u_matrix*vec4(a_globe_anchor+displacement,1);\n#else\noffsetProjected_point=u_matrix*vec4(tile_anchor+vec2(1,0),0,1);\n#endif\nvec2 a=projected_point.xy/projected_point.w;vec2 b=offsetProjected_point.xy/offsetProjected_point.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}vec4 projected_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 proj_pos=mix_globe_mercator(a_projected_pos.xyz+h,mercator_pos,u_zoom_transition);projected_pos=u_label_plane_matrix*vec4(proj_pos,1.0);\n#else\nprojected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy,h.z,1.0);\n#endif\nhighp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);float z=0.0;vec2 offset=rotation_matrix*(a_offset/32.0*max(a_min_font_scale,font_scale)+a_pxoffset/16.0);\n#ifdef TERRAIN\n#ifdef PITCH_WITH_MAP_TERRAIN\nvec4 tile_pos=u_label_plane_matrix_inv*vec4(a_projected_pos.xy+offset,0.0,1.0);z=elevation(tile_pos.xy);\n#endif\n#endif\nfloat occlusion_fade=occlusionFade(projected_point)*globe_occlusion_fade;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 xAxis=u_pitch_with_map ? normalize(cross(a_globe_normal,u_up_vector)) : vec3(1,0,0);vec3 yAxis=u_pitch_with_map ? normalize(cross(a_globe_normal,xAxis)) : vec3(0,1,0);gl_Position=mix(u_coord_matrix*vec4(projected_pos.xyz/projected_pos.w+xAxis*offset.x+yAxis*offset.y,1.0),AWAY,float(projected_point.w <=0.0 || occlusion_fade==0.0));\n#else\ngl_Position=mix(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+offset,z,1.0),AWAY,float(projected_point.w <=0.0 || occlusion_fade==0.0));\n#endif\nfloat projection_transition_fade=1.0;\n#if defined(PROJECTED_POS_ON_VIEWPORT) && defined(PROJECTION_GLOBE_VIEW)\nprojection_transition_fade=1.0-step(EPSILON,u_zoom_transition);\n#endif\nv_tex=a_tex/u_texsize;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;v_fade_opacity=max(0.0,min(occlusion_fade,fade_opacity[0]+fade_change))*projection_transition_fade;}"),symbolSDF:Xp("#define SDF_PX 8.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;uniform bool u_is_text;varying vec2 v_data0;varying vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat EDGE_GAMMA=0.105/u_device_pixel_ratio;vec2 tex=v_data0.xy;float gamma_scale=v_data1.x;float size=v_data1.y;float fade_opacity=v_data1[2];float fontScale=u_is_text ? size/24.0 : size;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float buff=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);buff=(6.0-halo_width/fontScale)/SDF_PX;}lowp float dist=texture2D(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(buff-gamma_scaled,buff+gamma_scaled,dist);gl_FragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec4 a_pos_offset;attribute vec4 a_tex_size;attribute vec4 a_pixeloffset;attribute vec4 a_projected_pos;attribute float a_fade_opacity;\n#ifdef PROJECTION_GLOBE_VIEW\nattribute vec3 a_globe_anchor;attribute vec3 a_globe_normal;\n#endif\nuniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_matrix;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec3 u_up_vector;\n#ifdef PROJECTION_GLOBE_VIEW\nuniform vec3 u_tile_id;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_camera_forward;uniform float u_zoom_transition;uniform vec3 u_ecef_origin;uniform mat4 u_tile_matrix;\n#endif\nvarying vec2 v_data0;varying vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_tex_size.xy;vec2 a_size=a_tex_size.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;highp float segment_angle=-a_projected_pos[3];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 tile_anchor=a_pos;vec3 h=elevationVector(tile_anchor)*elevation(tile_anchor);float globe_occlusion_fade;vec3 world_pos;vec3 mercator_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nmercator_pos=mercator_tile_position(u_inv_rot_matrix,tile_anchor,u_tile_id,u_merc_center);world_pos=mix_globe_mercator(a_globe_anchor+h,mercator_pos,u_zoom_transition);vec4 ecef_point=u_tile_matrix*vec4(world_pos,1.0);vec3 origin_to_point=ecef_point.xyz-u_ecef_origin;globe_occlusion_fade=dot(origin_to_point,u_camera_forward) >=0.0 ? 0.0 : 1.0;\n#else\nworld_pos=vec3(tile_anchor,0)+h;globe_occlusion_fade=1.0;\n#endif\nvec4 projected_point=u_matrix*vec4(world_pos,1);highp float camera_to_anchor_distance=projected_point.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(\n0.5+0.5*distance_ratio,0.0,1.5);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetprojected_point;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 displacement=vec3(a_globe_normal.z,0,-a_globe_normal.x);offsetprojected_point=u_matrix*vec4(a_globe_anchor+displacement,1);\n#else\noffsetprojected_point=u_matrix*vec4(tile_anchor+vec2(1,0),0,1);\n#endif\nvec2 a=projected_point.xy/projected_point.w;vec2 b=offsetprojected_point.xy/offsetprojected_point.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}vec4 projected_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 proj_pos=mix_globe_mercator(a_projected_pos.xyz+h,mercator_pos,u_zoom_transition);projected_pos=u_label_plane_matrix*vec4(proj_pos,1.0);\n#else\nprojected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy,h.z,1.0);\n#endif\nhighp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);float z=0.0;vec2 offset=rotation_matrix*(a_offset/32.0*fontScale+a_pxoffset);\n#ifdef TERRAIN\n#ifdef PITCH_WITH_MAP_TERRAIN\nvec4 tile_pos=u_label_plane_matrix_inv*vec4(a_projected_pos.xy+offset,0.0,1.0);z=elevation(tile_pos.xy);\n#endif\n#endif\nfloat occlusion_fade=occlusionFade(projected_point)*globe_occlusion_fade;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 xAxis=u_pitch_with_map ? normalize(cross(a_globe_normal,u_up_vector)) : vec3(1,0,0);vec3 yAxis=u_pitch_with_map ? normalize(cross(a_globe_normal,xAxis)) : vec3(0,1,0);gl_Position=mix(u_coord_matrix*vec4(projected_pos.xyz/projected_pos.w+xAxis*offset.x+yAxis*offset.y,1.0),AWAY,float(projected_point.w <=0.0 || occlusion_fade==0.0));\n#else\ngl_Position=mix(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+offset,z,1.0),AWAY,float(projected_point.w <=0.0 || occlusion_fade==0.0));\n#endif\nfloat gamma_scale=gl_Position.w;float projection_transition_fade=1.0;\n#if defined(PROJECTED_POS_ON_VIEWPORT) && defined(PROJECTION_GLOBE_VIEW)\nprojection_transition_fade=1.0-step(EPSILON,u_zoom_transition);\n#endif\nvec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(occlusion_fade,fade_opacity[0]+fade_change));v_data0=a_tex/u_texsize;v_data1=vec3(gamma_scale,size,interpolated_fade_opacity*projection_transition_fade);}"),symbolTextAndIcon:Xp("#define SDF_PX 8.0\n#define SDF 1.0\n#define ICON 0.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform sampler2D u_texture_icon;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;varying vec4 v_data0;varying vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat fade_opacity=v_data1[2];if (v_data1.w==ICON) {vec2 tex_icon=v_data0.zw;lowp float alpha=opacity*fade_opacity;gl_FragColor=texture2D(u_texture_icon,tex_icon)*alpha;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\nreturn;}vec2 tex=v_data0.xy;float EDGE_GAMMA=0.105/u_device_pixel_ratio;float gamma_scale=v_data1.x;float size=v_data1.y;float fontScale=size/24.0;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float buff=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);buff=(6.0-halo_width/fontScale)/SDF_PX;}lowp float dist=texture2D(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(buff-gamma_scaled,buff+gamma_scaled,dist);gl_FragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec4 a_pos_offset;attribute vec4 a_tex_size;attribute vec4 a_projected_pos;attribute float a_fade_opacity;\n#ifdef PROJECTION_GLOBE_VIEW\nattribute vec3 a_globe_anchor;attribute vec3 a_globe_normal;\n#endif\nuniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_matrix;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec3 u_up_vector;uniform vec2 u_texsize_icon;\n#ifdef PROJECTION_GLOBE_VIEW\nuniform vec3 u_tile_id;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_camera_forward;uniform float u_zoom_transition;uniform vec3 u_ecef_origin;uniform mat4 u_tile_matrix;\n#endif\nvarying vec4 v_data0;varying vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_tex_size.xy;vec2 a_size=a_tex_size.zw;float a_size_min=floor(a_size[0]*0.5);float is_sdf=a_size[0]-2.0*a_size_min;highp float segment_angle=-a_projected_pos[3];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 tile_anchor=a_pos;vec3 h=elevationVector(tile_anchor)*elevation(tile_anchor);float globe_occlusion_fade;vec3 world_pos;vec3 mercator_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nmercator_pos=mercator_tile_position(u_inv_rot_matrix,tile_anchor,u_tile_id,u_merc_center);world_pos=mix_globe_mercator(a_globe_anchor+h,mercator_pos,u_zoom_transition);vec4 ecef_point=u_tile_matrix*vec4(world_pos,1.0);vec3 origin_to_point=ecef_point.xyz-u_ecef_origin;globe_occlusion_fade=dot(origin_to_point,u_camera_forward) >=0.0 ? 0.0 : 1.0;\n#else\nworld_pos=vec3(tile_anchor,0)+h;globe_occlusion_fade=1.0;\n#endif\nvec4 projected_point=u_matrix*vec4(world_pos,1);highp float camera_to_anchor_distance=projected_point.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(\n0.5+0.5*distance_ratio,0.0,1.5);size*=perspective_ratio;float font_scale=size/24.0;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offset_projected_point=u_matrix*vec4(a_pos+vec2(1,0),0,1);vec2 a=projected_point.xy/projected_point.w;vec2 b=offset_projected_point.xy/offset_projected_point.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}vec4 projected_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 proj_pos=mix_globe_mercator(a_projected_pos.xyz+h,mercator_pos,u_zoom_transition);projected_pos=u_label_plane_matrix*vec4(proj_pos,1.0);\n#else\nprojected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy,h.z,1.0);\n#endif\nhighp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);float z=0.0;vec2 offset=rotation_matrix*(a_offset/32.0*font_scale);\n#ifdef TERRAIN\n#ifdef PITCH_WITH_MAP_TERRAIN\nvec4 tile_pos=u_label_plane_matrix_inv*vec4(a_projected_pos.xy+offset,0.0,1.0);z=elevation(tile_pos.xy);\n#endif\n#endif\nfloat occlusion_fade=occlusionFade(projected_point)*globe_occlusion_fade;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 xAxis=u_pitch_with_map ? normalize(cross(a_globe_normal,u_up_vector)) : vec3(1,0,0);vec3 yAxis=u_pitch_with_map ? normalize(cross(a_globe_normal,xAxis)) : vec3(0,1,0);gl_Position=mix(u_coord_matrix*vec4(projected_pos.xyz/projected_pos.w+xAxis*offset.x+yAxis*offset.y,1.0),AWAY,float(projected_point.w <=0.0 || occlusion_fade==0.0));\n#else\ngl_Position=mix(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+offset,z,1.0),AWAY,float(projected_point.w <=0.0 || occlusion_fade==0.0));\n#endif\nfloat gamma_scale=gl_Position.w;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(occlusion_fade,fade_opacity[0]+fade_change));float projection_transition_fade=1.0;\n#if defined(PROJECTED_POS_ON_VIEWPORT) && defined(PROJECTION_GLOBE_VIEW)\nprojection_transition_fade=1.0-step(EPSILON,u_zoom_transition);\n#endif\nv_data0.xy=a_tex/u_texsize;v_data0.zw=a_tex/u_texsize_icon;v_data1=vec4(gamma_scale,size,interpolated_fade_opacity*projection_transition_fade,is_sdf);}"),terrainRaster:Xp("uniform sampler2D u_image0;varying vec2 v_pos0;\n#ifdef FOG\nvarying float v_fog_opacity;\n#endif\n#ifdef RENDER_SHADOWS\nvarying vec4 v_pos_light_view_0;varying vec4 v_pos_light_view_1;varying float v_depth;\n#endif\nvoid main() {vec4 color=texture2D(u_image0,v_pos0);\n#ifdef RENDER_SHADOWS\ncolor.xyz=shadowed_color(color.xyz,v_pos_light_view_0,v_pos_light_view_1,v_depth);\n#endif\n#ifdef FOG\n#ifdef ZERO_EXAGGERATION\ncolor=fog_dither(fog_apply_premultiplied(color,v_fog_pos));\n#else\ncolor=fog_dither(fog_apply_from_vert(color,v_fog_opacity));\n#endif\n#endif\ngl_FragColor=color;\n#ifdef TERRAIN_WIREFRAME\ngl_FragColor=vec4(1.0,0.0,0.0,0.8);\n#endif\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform float u_skirt_height;attribute vec2 a_pos;varying vec2 v_pos0;\n#ifdef FOG\nvarying float v_fog_opacity;\n#endif\n#ifdef RENDER_SHADOWS\nuniform mat4 u_light_matrix_0;uniform mat4 u_light_matrix_1;varying vec4 v_pos_light_view_0;varying vec4 v_pos_light_view_1;varying float v_depth;\n#endif\nconst float wireframeOffset=0.00015;void main() {vec3 decomposedPosAndSkirt=decomposeToPosAndSkirt(a_pos);float skirt=decomposedPosAndSkirt.z;vec2 decodedPos=decomposedPosAndSkirt.xy;float elevation=elevation(decodedPos)-skirt*u_skirt_height;\n#ifdef TERRAIN_WIREFRAME\nelevation+=wireframeOffset;\n#endif\nv_pos0=decodedPos/8192.0;gl_Position=u_matrix*vec4(decodedPos,elevation,1.0);\n#ifdef FOG\n#ifdef ZERO_EXAGGERATION\nv_fog_pos=fog_position(decodedPos);\n#else\nv_fog_opacity=fog(fog_position(vec3(decodedPos,elevation)));\n#endif\n#endif\n#ifdef RENDER_SHADOWS\nvec3 pos=vec3(decodedPos,elevation);v_pos_light_view_0=u_light_matrix_0*vec4(pos,1.);v_pos_light_view_1=u_light_matrix_1*vec4(pos,1.);v_depth=gl_Position.w;\n#endif\n}"),terrainDepth:Xp("#ifdef GL_ES\nprecision highp float;\n#endif\nvarying float v_depth;void main() {gl_FragColor=pack_depth(v_depth);}","uniform mat4 u_matrix;attribute vec2 a_pos;varying float v_depth;void main() {float elevation=elevation(a_pos);gl_Position=u_matrix*vec4(a_pos,elevation,1.0);v_depth=gl_Position.z/gl_Position.w;}"),skybox:Xp("\nvarying lowp vec3 v_uv;uniform lowp samplerCube u_cubemap;uniform lowp float u_opacity;uniform highp float u_temporal_offset;uniform highp vec3 u_sun_direction;float sun_disk(highp vec3 ray_direction,highp vec3 sun_direction) {highp float cos_angle=dot(normalize(ray_direction),sun_direction);const highp float cos_sun_angular_diameter=0.99996192306;const highp float smoothstep_delta=1e-5;return smoothstep(\ncos_sun_angular_diameter-smoothstep_delta,cos_sun_angular_diameter+smoothstep_delta,cos_angle);}float map(float value,float start,float end,float new_start,float new_end) {return ((value-start)*(new_end-new_start))/(end-start)+new_start;}void main() {vec3 uv=v_uv;const float y_bias=0.015;uv.y+=y_bias;uv.y=pow(abs(uv.y),1.0/5.0);uv.y=map(uv.y,0.0,1.0,-1.0,1.0);vec3 sky_color=textureCube(u_cubemap,uv).rgb;\n#ifdef FOG\nsky_color=fog_apply_sky_gradient(v_uv.xzy,sky_color);\n#endif\nsky_color.rgb=dither(sky_color.rgb,gl_FragCoord.xy+u_temporal_offset);sky_color+=0.1*sun_disk(v_uv,u_sun_direction);gl_FragColor=vec4(sky_color*u_opacity,u_opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}",Fp),skyboxGradient:Xp("varying highp vec3 v_uv;uniform lowp sampler2D u_color_ramp;uniform highp vec3 u_center_direction;uniform lowp float u_radius;uniform lowp float u_opacity;uniform highp float u_temporal_offset;void main() {float progress=acos(dot(normalize(v_uv),u_center_direction))/u_radius;vec4 color=texture2D(u_color_ramp,vec2(progress,0.5));\n#ifdef FOG\ncolor.rgb=fog_apply_sky_gradient(v_uv.xzy,color.rgb/color.a)*color.a;\n#endif\ncolor*=u_opacity;color.rgb=dither(color.rgb,gl_FragCoord.xy+u_temporal_offset);gl_FragColor=color;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}",Fp),skyboxCapture:Xp("\nvarying highp vec3 v_position;uniform highp float u_sun_intensity;uniform highp float u_luminance;uniform lowp vec3 u_sun_direction;uniform highp vec4 u_color_tint_r;uniform highp vec4 u_color_tint_m;\n#ifdef GL_ES\nprecision highp float;\n#endif\n#define BETA_R                  vec3(5.5e-6,13.0e-6,22.4e-6)\n#define BETA_M                  vec3(21e-6,21e-6,21e-6)\n#define MIE_G                   0.76\n#define DENSITY_HEIGHT_SCALE_R  8000.0\n#define DENSITY_HEIGHT_SCALE_M  1200.0\n#define PLANET_RADIUS           6360e3\n#define ATMOSPHERE_RADIUS       6420e3\n#define SAMPLE_STEPS            10\n#define DENSITY_STEPS           4\nfloat ray_sphere_exit(vec3 orig,vec3 dir,float radius) {float a=dot(dir,dir);float b=2.0*dot(dir,orig);float c=dot(orig,orig)-radius*radius;float d=sqrt(b*b-4.0*a*c);return (-b+d)/(2.0*a);}vec3 extinction(vec2 density) {return exp(-vec3(BETA_R*u_color_tint_r.a*density.x+BETA_M*u_color_tint_m.a*density.y));}vec2 local_density(vec3 point) {float height=max(length(point)-PLANET_RADIUS,0.0);float exp_r=exp(-height/DENSITY_HEIGHT_SCALE_R);float exp_m=exp(-height/DENSITY_HEIGHT_SCALE_M);return vec2(exp_r,exp_m);}float phase_ray(float cos_angle) {return (3.0/(16.0*PI))*(1.0+cos_angle*cos_angle);}float phase_mie(float cos_angle) {return (3.0/(8.0*PI))*((1.0-MIE_G*MIE_G)*(1.0+cos_angle*cos_angle))/((2.0+MIE_G*MIE_G)*pow(1.0+MIE_G*MIE_G-2.0*MIE_G*cos_angle,1.5));}vec2 density_to_atmosphere(vec3 point,vec3 light_dir) {float ray_len=ray_sphere_exit(point,light_dir,ATMOSPHERE_RADIUS);float step_len=ray_len/float(DENSITY_STEPS);vec2 density_point_to_atmosphere=vec2(0.0);for (int i=0; i < DENSITY_STEPS;++i) {vec3 point_on_ray=point+light_dir*((float(i)+0.5)*step_len);density_point_to_atmosphere+=local_density(point_on_ray)*step_len;;}return density_point_to_atmosphere;}vec3 atmosphere(vec3 ray_dir,vec3 sun_direction,float sun_intensity) {vec2 density_orig_to_point=vec2(0.0);vec3 scatter_r=vec3(0.0);vec3 scatter_m=vec3(0.0);vec3 origin=vec3(0.0,PLANET_RADIUS,0.0);float ray_len=ray_sphere_exit(origin,ray_dir,ATMOSPHERE_RADIUS);float step_len=ray_len/float(SAMPLE_STEPS);for (int i=0; i < SAMPLE_STEPS;++i) {vec3 point_on_ray=origin+ray_dir*((float(i)+0.5)*step_len);vec2 density=local_density(point_on_ray)*step_len;density_orig_to_point+=density;vec2 density_point_to_atmosphere=density_to_atmosphere(point_on_ray,sun_direction);vec2 density_orig_to_atmosphere=density_orig_to_point+density_point_to_atmosphere;vec3 extinction=extinction(density_orig_to_atmosphere);scatter_r+=density.x*extinction;scatter_m+=density.y*extinction;}float cos_angle=dot(ray_dir,sun_direction);float phase_r=phase_ray(cos_angle);float phase_m=phase_mie(cos_angle);vec3 beta_r=BETA_R*u_color_tint_r.rgb*u_color_tint_r.a;vec3 beta_m=BETA_M*u_color_tint_m.rgb*u_color_tint_m.a;return (scatter_r*phase_r*beta_r+scatter_m*phase_m*beta_m)*sun_intensity;}const float A=0.15;const float B=0.50;const float C=0.10;const float D=0.20;const float E=0.02;const float F=0.30;vec3 uncharted2_tonemap(vec3 x) {return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;}void main() {vec3 ray_direction=v_position;ray_direction.y=pow(ray_direction.y,5.0);const float y_bias=0.015;ray_direction.y+=y_bias;vec3 color=atmosphere(normalize(ray_direction),u_sun_direction,u_sun_intensity);float white_scale=1.0748724675633854;color=uncharted2_tonemap((log2(2.0/pow(u_luminance,4.0)))*color)*white_scale;gl_FragColor=vec4(color,1.0);}","attribute highp vec3 a_pos_3f;uniform mat3 u_matrix_3f;varying highp vec3 v_position;float map(float value,float start,float end,float new_start,float new_end) {return ((value-start)*(new_end-new_start))/(end-start)+new_start;}void main() {vec4 pos=vec4(u_matrix_3f*a_pos_3f,1.0);v_position=pos.xyz;v_position.y*=-1.0;v_position.y=map(v_position.y,-1.0,1.0,0.0,1.0);gl_Position=vec4(a_pos_3f.xy,0.0,1.0);}"),globeRaster:Xp("uniform sampler2D u_image0;varying vec2 v_pos0;\n#ifndef FOG\nuniform highp vec3 u_frustum_tl;uniform highp vec3 u_frustum_tr;uniform highp vec3 u_frustum_br;uniform highp vec3 u_frustum_bl;uniform highp vec3 u_globe_pos;uniform highp float u_globe_radius;uniform vec2 u_viewport;\n#endif\nvoid main() {vec4 color;\n#ifdef CUSTOM_ANTIALIASING\nvec2 uv=gl_FragCoord.xy/u_viewport;highp vec3 ray_dir=mix(\nmix(u_frustum_tl,u_frustum_tr,uv.x),mix(u_frustum_bl,u_frustum_br,uv.x),1.0-uv.y);vec3 dir=normalize(ray_dir);vec3 closest_point=dot(u_globe_pos,dir)*dir;float norm_dist_from_center=1.0-length(closest_point-u_globe_pos)/u_globe_radius;const float antialias_pixel=2.0;float antialias_factor=antialias_pixel*fwidth(norm_dist_from_center);float antialias=smoothstep(0.0,antialias_factor,norm_dist_from_center);vec4 raster=texture2D(u_image0,v_pos0);color=vec4(raster.rgb*antialias,raster.a*antialias);\n#else\ncolor=texture2D(u_image0,v_pos0);\n#endif\n#ifdef FOG\ncolor=fog_dither(fog_apply_premultiplied(color,v_fog_pos));\n#endif\ngl_FragColor=color;\n#ifdef TERRAIN_WIREFRAME\ngl_FragColor=vec4(1.0,0.0,0.0,0.8);\n#endif\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_proj_matrix;uniform mat4 u_normalize_matrix;uniform mat4 u_globe_matrix;uniform mat4 u_merc_matrix;uniform float u_zoom_transition;uniform vec2 u_merc_center;uniform mat3 u_grid_matrix;uniform float u_skirt_height;\n#ifdef GLOBE_POLES\nattribute vec3 a_globe_pos;attribute vec2 a_uv;\n#else\nattribute vec2 a_pos;\n#endif\nvarying vec2 v_pos0;const float wireframeOffset=1e3;float mercatorXfromLng(float lng) {return (180.0+lng)/360.0;}float mercatorYfromLat(float lat) {return (180.0-(RAD_TO_DEG*log(tan(QUARTER_PI+lat/2.0*DEG_TO_RAD))))/360.0;}vec3 latLngToECEF(vec2 latLng) {latLng=DEG_TO_RAD*latLng;float cosLat=cos(latLng[0]);float sinLat=sin(latLng[0]);float cosLng=cos(latLng[1]);float sinLng=sin(latLng[1]);float sx=cosLat*sinLng*GLOBE_RADIUS;float sy=-sinLat*GLOBE_RADIUS;float sz=cosLat*cosLng*GLOBE_RADIUS;return vec3(sx,sy,sz);}void main() {\n#ifdef GLOBE_POLES\nvec3 globe_pos=a_globe_pos;vec2 uv=a_uv;\n#else\nfloat tiles=u_grid_matrix[0][2];float idx=u_grid_matrix[1][2];float idy=u_grid_matrix[2][2];vec3 decomposed_pos_and_skirt=decomposeToPosAndSkirt(a_pos);vec3 latLng=u_grid_matrix*vec3(decomposed_pos_and_skirt.xy,1.0);float mercatorY=mercatorYfromLat(latLng[0]);float uvY=mercatorY*tiles-idy;float mercatorX=mercatorXfromLng(latLng[1]);float uvX=mercatorX*tiles-idx;vec3 globe_pos=latLngToECEF(latLng.xy);vec2 merc_pos=vec2(mercatorX,mercatorY);vec2 uv=vec2(uvX,uvY);\n#endif\nv_pos0=uv;vec2 tile_pos=uv*EXTENT;vec3 globe_derived_up_vector=normalize(globe_pos)*u_tile_up_scale;\n#ifdef GLOBE_POLES\nvec3 up_vector=globe_derived_up_vector;\n#else\nvec3 up_vector=elevationVector(tile_pos);\n#endif\nfloat height=elevation(tile_pos);\n#ifdef TERRAIN_WIREFRAME\nheight+=wireframeOffset;\n#endif\nglobe_pos+=up_vector*height;\n#ifndef GLOBE_POLES\nglobe_pos-=globe_derived_up_vector*u_skirt_height*decomposed_pos_and_skirt.z;\n#endif\n#ifdef GLOBE_POLES\nvec4 interpolated_pos=u_globe_matrix*vec4(globe_pos,1.0);\n#else\nvec4 globe_world_pos=u_globe_matrix*vec4(globe_pos,1.0);vec4 merc_world_pos=vec4(0.0);if (u_zoom_transition > 0.0) {merc_world_pos=vec4(merc_pos,height-u_skirt_height*decomposed_pos_and_skirt.z,1.0);merc_world_pos.xy-=u_merc_center;merc_world_pos.x=wrap(merc_world_pos.x,-0.5,0.5);merc_world_pos=u_merc_matrix*merc_world_pos;}vec4 interpolated_pos=vec4(mix(globe_world_pos.xyz,merc_world_pos.xyz,u_zoom_transition),1.0);\n#endif\ngl_Position=u_proj_matrix*interpolated_pos;\n#ifdef FOG\nv_fog_pos=fog_position((u_normalize_matrix*vec4(globe_pos,1.0)).xyz);\n#endif\n}"),globeAtmosphere:Xp("uniform float u_transition;uniform highp float u_fadeout_range;uniform highp float u_temporal_offset;uniform vec3 u_start_color;uniform vec4 u_color;uniform vec4 u_space_color;uniform vec4 u_high_color;uniform float u_star_intensity;uniform float u_star_size;uniform float u_star_density;uniform float u_horizon_angle;uniform mat4 u_rotation_matrix;varying highp vec3 v_ray_dir;varying highp vec3 v_horizon_dir;highp float random(highp vec3 p) {p=fract(p*vec3(23.2342,97.1231,91.2342));p+=dot(p.zxy,p.yxz+123.1234);return fract(p.x*p.y);}float stars(vec3 p,float scale,vec2 offset) {vec2 uv_scale=(u_viewport/u_star_size)*scale;vec3 position=vec3(p.xy*uv_scale+offset*u_viewport,p.z);vec3 q=fract(position)-0.5;vec3 id=floor(position);float random_visibility=step(random(id),u_star_density);float circle=smoothstep(0.5+u_star_intensity,0.5,length(q));return circle*random_visibility;}void main() {highp vec3 dir=normalize(v_ray_dir);float globe_pos_dot_dir;\n#ifdef PROJECTION_GLOBE_VIEW\nglobe_pos_dot_dir=dot(u_globe_pos,dir);highp vec3 closest_point_forward=abs(globe_pos_dot_dir)*dir;float norm_dist_from_center=length(closest_point_forward-u_globe_pos)/u_globe_radius;if (norm_dist_from_center < 0.98) {discard;return;}\n#endif\nhighp vec3 horizon_dir=normalize(v_horizon_dir);float horizon_angle_mercator=dir.y < horizon_dir.y ?\n0.0 : max(acos(dot(dir,horizon_dir)),0.0);float horizon_angle;\n#ifdef PROJECTION_GLOBE_VIEW\nhighp vec3 closest_point=globe_pos_dot_dir*dir;float closest_point_to_center=length(closest_point-u_globe_pos);float theta=asin(clamp(closest_point_to_center/length(u_globe_pos),-1.0,1.0));horizon_angle=globe_pos_dot_dir < 0.0 ?\nPI-theta-u_horizon_angle : theta-u_horizon_angle;float angle_t=pow(u_transition,10.0);horizon_angle=mix(horizon_angle,horizon_angle_mercator,angle_t);\n#else\nhorizon_angle=horizon_angle_mercator;\n#endif\nhorizon_angle/=PI;float t=exp(-horizon_angle/u_fadeout_range);float alpha_0=u_color.a;float alpha_1=u_high_color.a;float alpha_2=u_space_color.a;vec3 color_stop_0=u_color.rgb;vec3 color_stop_1=u_high_color.rgb;vec3 color_stop_2=u_space_color.rgb;vec3 c0=mix(color_stop_2,color_stop_1,alpha_1);vec3 c1=mix(c0,color_stop_0,alpha_0);vec3 c2=mix(c0,c1,t);vec3 c =mix(color_stop_2,c2,t);float a0=mix(alpha_2,1.0,alpha_1);float a1=mix(a0,1.0,alpha_0);float a2=mix(a0,a1,t);float a =mix(alpha_2,a2,t);vec2 uv=gl_FragCoord.xy/u_viewport-0.5;float aspect_ratio=u_viewport.x/u_viewport.y;vec4 uv_dir=vec4(normalize(vec3(uv.x*aspect_ratio,uv.y,1.0)),1.0);uv_dir=u_rotation_matrix*uv_dir;vec3 n=abs(uv_dir.xyz);vec2 uv_remap=(n.x > n.y && n.x > n.z) ? uv_dir.yz/uv_dir.x:\n(n.y > n.x && n.y > n.z) ? uv_dir.zx/uv_dir.y:\nuv_dir.xy/uv_dir.z;uv_remap.x/=aspect_ratio;vec3 D=vec3(uv_remap,1.0);highp float star_field=0.0;if (u_star_intensity > 0.0) {star_field+=stars(D,1.2,vec2(0.0,0.0));star_field+=stars(D,1.0,vec2(1.0,0.0));star_field+=stars(D,0.8,vec2(0.0,1.0));star_field+=stars(D,0.6,vec2(1.0,1.0));star_field*=(1.0-pow(t,0.25+(1.0-u_high_color.a)*0.75));c+=star_field*alpha_2;}c=dither(c,gl_FragCoord.xy+u_temporal_offset);gl_FragColor=vec4(c,a);}","attribute vec3 a_pos;attribute vec2 a_uv;uniform vec3 u_frustum_tl;uniform vec3 u_frustum_tr;uniform vec3 u_frustum_br;uniform vec3 u_frustum_bl;uniform float u_horizon;varying highp vec3 v_ray_dir;varying highp vec3 v_horizon_dir;void main() {v_ray_dir=mix(\nmix(u_frustum_tl,u_frustum_tr,a_uv.x),mix(u_frustum_bl,u_frustum_br,a_uv.x),a_uv.y);v_horizon_dir=mix(\nmix(u_frustum_tl,u_frustum_bl,u_horizon),mix(u_frustum_tr,u_frustum_br,u_horizon),a_uv.x);gl_Position=vec4(a_pos,1.0);}")};function Hp(e,t){const i=e.replace(/\s*\/\/[^\n]*\n/g,"\n").split("\n");for(let e of i)if(e=e.trim(),"#"===e[0]&&e.includes("if")&&!e.includes("endif")){e=e.replace("#","").replace(/ifdef|ifndef|elif|if/g,"").replace(/!|defined|\(|\)|\|\||&&/g,"").replace(/\s+/g," ").trim();const i=e.split(" ");for(const e of i)t.includes(e)||t.push(e)}}function Xp(e,t){const i=/#pragma mapbox: ([\w]+) ([\w]+) ([\w]+) ([\w]+)/g,r=t.match(/attribute (highp |mediump |lowp )?([\w]+) ([\w]+)/g),n={},o=[...Gp];return Hp(e,o),Hp(t,o),{fragmentSource:e=e.replace(i,((e,t,i,r,o)=>(n[o]=!0,"define"===t?`\n#ifndef HAS_UNIFORM_u_${o}\nvarying ${i} ${r} ${o};\n#else\nuniform ${i} ${r} u_${o};\n#endif\n`:`\n#ifdef HAS_UNIFORM_u_${o}\n    ${i} ${r} ${o} = u_${o};\n#endif\n`))),vertexSource:t=t.replace(i,((e,t,i,r,o)=>{const s="float"===r?"vec2":"vec4",a=o.match(/color/)?"color":s;return n[o]?"define"===t?`\n#ifndef HAS_UNIFORM_u_${o}\nuniform lowp float u_${o}_t;\nattribute ${i} ${s} a_${o};\nvarying ${i} ${r} ${o};\n#else\nuniform ${i} ${r} u_${o};\n#endif\n`:"vec4"===a?`\n#ifndef HAS_UNIFORM_u_${o}\n    ${o} = a_${o};\n#else\n    ${i} ${r} ${o} = u_${o};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${o}\n    ${o} = unpack_mix_${a}(a_${o}, u_${o}_t);\n#else\n    ${i} ${r} ${o} = u_${o};\n#endif\n`:"define"===t?`\n#ifndef HAS_UNIFORM_u_${o}\nuniform lowp float u_${o}_t;\nattribute ${i} ${s} a_${o};\n#else\nuniform ${i} ${r} u_${o};\n#endif\n`:"vec4"===a?`\n#ifndef HAS_UNIFORM_u_${o}\n    ${i} ${r} ${o} = a_${o};\n#else\n    ${i} ${r} ${o} = u_${o};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${o}\n    ${i} ${r} ${o} = unpack_mix_${a}(a_${o}, u_${o}_t);\n#else\n    ${i} ${r} ${o} = u_${o};\n#endif\n`})),staticAttributes:r,usedDefines:o}}class VertexArrayObject{constructor(){this.boundProgram=null,this.boundLayoutVertexBuffer=null,this.boundPaintVertexBuffers=[],this.boundIndexBuffer=null,this.boundVertexOffset=null,this.boundDynamicVertexBuffers=[],this.vao=null}bind(e,t,i,r,n,o,s){this.context=e;let a=this.boundPaintVertexBuffers.length!==r.length;for(let e=0;!a&&e<r.length;e++)this.boundPaintVertexBuffers[e]!==r[e]&&(a=!0);let l=this.boundDynamicVertexBuffers.length!==s.length;for(let e=0;!l&&e<s.length;e++)this.boundDynamicVertexBuffers[e]!==s[e]&&(l=!0);if(!e.extVertexArrayObject||!this.vao||this.boundProgram!==t||this.boundLayoutVertexBuffer!==i||a||l||this.boundIndexBuffer!==n||this.boundVertexOffset!==o)this.freshBind(t,i,r,n,o,s);else{e.bindVertexArrayOES.set(this.vao);for(const e of s)e&&e.bind();n&&n.dynamicDraw&&n.bind()}}freshBind(e,t,i,r,n,o){let s;const a=e.numAttributes,l=this.context,c=l.gl;if(l.extVertexArrayObject)this.vao&&this.destroy(),this.vao=l.extVertexArrayObject.createVertexArrayOES(),l.bindVertexArrayOES.set(this.vao),s=0,this.boundProgram=e,this.boundLayoutVertexBuffer=t,this.boundPaintVertexBuffers=i,this.boundIndexBuffer=r,this.boundVertexOffset=n,this.boundDynamicVertexBuffers=o;else{s=l.currentNumAttributes||0;for(let e=a;e<s;e++)c.disableVertexAttribArray(e)}t.enableAttributes(c,e),t.bind(),t.setVertexAttribPointers(c,e,n);for(const t of i)t.enableAttributes(c,e),t.bind(),t.setVertexAttribPointers(c,e,n);for(const t of o)t&&(t.enableAttributes(c,e),t.bind(),t.setVertexAttribPointers(c,e,n));r&&r.bind(),l.currentNumAttributes=a}destroy(){this.vao&&(this.context.extVertexArrayObject.deleteVertexArrayOES(this.vao),this.vao=null)}}function Kp(e,t){const i=Math.pow(2,t.canonical.z),r=t.canonical.y;return[new MercatorCoordinate(0,r/i).toLngLat().lat,new MercatorCoordinate(0,(r+1)/i).toLngLat().lat]}function Jp(e,t,i,r,n,o,s){const a=e.context,l=a.gl,c=i.fbo;if(!c)return;e.prepareDrawTile();const u=e.useProgram("hillshade");a.activeTexture.set(l.TEXTURE0),l.bindTexture(l.TEXTURE_2D,c.colorAttachment.get());const h=((e,t,i,r)=>{const n=i.paint.get("hillshade-shadow-color"),o=i.paint.get("hillshade-highlight-color"),s=i.paint.get("hillshade-accent-color");let a=i.paint.get("hillshade-illumination-direction")*(Math.PI/180);"viewport"===i.paint.get("hillshade-illumination-anchor")&&(a-=e.transform.angle);const l=!e.options.moving;return{u_matrix:r||e.transform.calculateProjMatrix(t.tileID.toUnwrapped(),l),u_image:0,u_latrange:Kp(0,t.tileID),u_light:[i.paint.get("hillshade-exaggeration"),a],u_shadow:n,u_highlight:o,u_accent:s}})(e,i,r,e.terrain?t.projMatrix:null);e.prepareDrawProgram(a,u,t.toUnwrapped());const{tileBoundsBuffer:d,tileBoundsIndexBuffer:p,tileBoundsSegments:f}=e.getTileBoundsBuffers(i);u.draw(a,l.TRIANGLES,n,o,s,CullFaceMode.disabled,h,r.id,d,p,f)}function Yp(e,t,i){if(!t.needsDEMTextureUpload)return;const r=e.context,n=r.gl;r.pixelStoreUnpackPremultiplyAlpha.set(!1),t.demTexture=t.demTexture||e.getTileTexture(i.stride);const o=i.getPixels();t.demTexture?t.demTexture.update(o,{premultiply:!1}):t.demTexture=new Texture(r,o,n.RGBA,{premultiply:!1}),t.needsDEMTextureUpload=!1}function Qp(e,t,i,r,n,o){const s=e.context,a=s.gl;if(!t.dem)return;const l=t.dem;if(s.activeTexture.set(a.TEXTURE1),Yp(e,t,l),!t.demTexture)return;t.demTexture.bind(a.NEAREST,a.CLAMP_TO_EDGE);const c=l.dim;s.activeTexture.set(a.TEXTURE0);let u=t.fbo;if(!u){const e=new Texture(s,{width:c,height:c,data:null},a.RGBA);e.bind(a.LINEAR,a.CLAMP_TO_EDGE),u=t.fbo=s.createFramebuffer(c,c,!0),u.colorAttachment.set(e.texture)}s.bindFramebuffer.set(u.framebuffer),s.viewport.set([0,0,c,c]);const{tileBoundsBuffer:h,tileBoundsIndexBuffer:d,tileBoundsSegments:p}=e.getMercatorTileBoundsBuffers();e.useProgram("hillshadePrepare").draw(s,a.TRIANGLES,r,n,o,CullFaceMode.disabled,((e,t)=>{const i=t.stride,r=$o();return os(r,0,Uo,-Uo,0,0,1),Ko(r,r,[0,-Uo,0]),{u_matrix:r,u_image:1,u_dimension:[i,i],u_zoom:e.overscaledZ,u_unpack:t.unpackVector}})(t.tileID,l),i.id,h,d,p),t.needsHillshadePrepare=!1}const ef=e=>({u_matrix:new UniformMatrix4f(e),u_image0:new Uniform1i(e),u_skirt_height:new Uniform1f(e)}),tf=(e,t)=>({u_matrix:e,u_image0:0,u_skirt_height:t}),rf=(e,t,i,r,n,o,s,a,l,c,u,h,d,p,f)=>({u_proj_matrix:Float32Array.from(e),u_globe_matrix:t,u_normalize_matrix:Float32Array.from(r),u_merc_matrix:i,u_zoom_transition:n,u_merc_center:o,u_image0:0,u_frustum_tl:s,u_frustum_tr:a,u_frustum_br:l,u_frustum_bl:c,u_globe_pos:u,u_globe_radius:h,u_viewport:d,u_grid_matrix:f?Float32Array.from(f):new Float32Array(9),u_skirt_height:p});function nf(e,t){return null!=e&&null!=t&&!(!e.hasData()||!t.hasData())&&null!=e.demTexture&&null!=t.demTexture&&e.tileID.key!==t.tileID.key}const of=new class VertexMorphing{constructor(){this.operations={}}newMorphing(e,t,i,r,n){if(e in this.operations){const t=this.operations[e];t.to.tileID.key!==i.tileID.key&&(t.queued=i)}else this.operations[e]={startTime:r,phase:0,duration:n,from:t,to:i,queued:null}}getMorphValuesForProxy(e){if(!(e in this.operations))return null;const t=this.operations[e];return{from:t.from,to:t.to,phase:t.phase}}update(e){for(const t in this.operations){const i=this.operations[t];for(i.phase=(e-i.startTime)/i.duration;i.phase>=1||!this._validOp(i);)if(!this._nextOp(i,e)){delete this.operations[t];break}}}_nextOp(e,t){return!!e.queued&&(e.from=e.to,e.to=e.queued,e.queued=null,e.phase=0,e.startTime=t,!0)}_validOp(e){return e.from.hasData()&&e.to.hasData()}},sf={0:null,1:"TERRAIN_VERTEX_MORPHING",2:"TERRAIN_WIREFRAME"};function af(e){return 6*Math.pow(1.5,22-e)}function lf(e,t){const i=1<<e.z;return!t&&(0===e.x||e.x===i-1)||0===e.y||e.y===i-1}const cf=e=>({u_matrix:e});function uf(e,t,i,r,n){if(n>0){const o=it.now(),s=(o-e.timeAdded)/n,a=t?(o-t.timeAdded)/n:-1,l=i.getSource(),c=r.coveringZoomLevel({tileSize:l.tileSize,roundZoom:l.roundZoom}),u=!t||Math.abs(t.tileID.overscaledZ-c)>Math.abs(e.tileID.overscaledZ-c),h=u&&e.refreshedUponExpiration?1:M(u?s:1-a,0,1);return e.refreshedUponExpiration&&s>=1&&(e.refreshedUponExpiration=!1),t?{opacity:1,mix:1-h}:{opacity:h,mix:0}}return{opacity:1,mix:0}}class MockSourceCache extends SourceCache{constructor(e){const t={type:"raster-dem",maxzoom:e.transform.maxZoom},i=new Dispatcher(kd(),null),r=Sd("mock-dem",t,i,e.style);super("mock-dem",r,!1),r.setEventedParent(this),this._sourceLoaded=!0}_loadTile(e,t){e.state="loaded",t(null)}}class ProxySourceCache extends SourceCache{constructor(e){const t=Sd("proxy",{type:"geojson",maxzoom:e.transform.maxZoom},new Dispatcher(kd(),null),e.style);super("proxy",t,!1),t.setEventedParent(this),this.map=this.getSource().map=e,this.used=this._sourceLoaded=!0,this.renderCache=[],this.renderCachePool=[],this.proxyCachedFBO={}}update(e,t,i){if(e.freezeTileCoverage)return;this.transform=e;const r=e.coveringTiles({tileSize:this._source.tileSize,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:this._source.roundZoom,reparseOverscaled:this._source.reparseOverscaled}).reduce(((t,i)=>{if(t[i.key]="",!this._tiles[i.key]){const t=new Tile(i,this._source.tileSize*i.overscaleFactor(),e.tileZoom);t.state="loaded",this._tiles[i.key]=t}return t}),{});for(const e in this._tiles)e in r||(this.freeFBO(e),this._tiles[e].unloadVectorData(),delete this._tiles[e])}freeFBO(e){const t=this.proxyCachedFBO[e];if(void 0!==t){const i=Object.values(t);this.renderCachePool.push(...i),delete this.proxyCachedFBO[e]}}deallocRenderCache(){this.renderCache.forEach((e=>e.fb.destroy())),this.renderCache=[],this.renderCachePool=[],this.proxyCachedFBO={}}}class ProxiedTileID extends OverscaledTileID{constructor(e,t,i){super(e.overscaledZ,e.wrap,e.canonical.z,e.canonical.x,e.canonical.y),this.proxyTileKey=t,this.projMatrix=i}}class Terrain extends Elevation{constructor(e,t){super(),this.painter=e,this.terrainTileForTile={},this.prevTerrainTileForTile={};const[i,r,n]=function(e){const t=new StructArrayLayout2i4,i=new StructArrayLayout3ui6,r=131;t.reserve(17161),i.reserve(33800);const n=Uo/128,o=Uo+n/2,s=o+n;for(let e=-n;e<s;e+=n)for(let i=-n;i<s;i+=n){const r=i<0||i>o||e<0||e>o?24575:0,n=M(Math.round(i),0,Uo),s=M(Math.round(e),0,Uo);t.emplaceBack(n+r,s)}const a=(e,t)=>{const n=t*r+e;i.emplaceBack(n+1,n,n+r),i.emplaceBack(n+r,n+r+1,n+1)};for(let e=1;e<129;e++)for(let t=1;t<129;t++)a(t,e);return[0,129].forEach((e=>{for(let t=0;t<130;t++)a(t,e),a(e,t)})),[t,i,32768]}(),o=e.context;this.gridBuffer=o.createVertexBuffer(i,Ns.members),this.gridIndexBuffer=o.createIndexBuffer(r),this.gridSegments=SegmentVector.simpleSegment(0,0,i.length,r.length),this.gridNoSkirtSegments=SegmentVector.simpleSegment(0,0,i.length,n),this.proxyCoords=[],this.proxiedCoords={},this._visibleDemTiles=[],this._drapedRenderBatches=[],this._sourceTilesOverlap={},this.proxySourceCache=new ProxySourceCache(t.map),this.orthoMatrix=$o(),os(this.orthoMatrix,"globe"===this.painter.transform.projection.name?.015:0,Uo,0,Uo,0,1);const s=o.gl;this._overlapStencilMode=new StencilMode({func:s.GEQUAL,mask:255},0,255,s.KEEP,s.KEEP,s.REPLACE),this._previousZoom=e.transform.zoom,this.pool=[],this._findCoveringTileCache={},this._tilesDirty={},this.style=t,this._useVertexMorphing=!0,this._exaggeration=1,this._mockSourceCache=new MockSourceCache(t.map)}set style(e){e.on("data",this._onStyleDataEvent.bind(this)),e.on("neworder",this._checkRenderCacheEfficiency.bind(this)),this._style=e,this._checkRenderCacheEfficiency(),this._style.map.on("moveend",(()=>{this._clearLineLayersFromRenderCache()}))}update(e,t,i){if(e&&e.terrain){this._style!==e&&(this.style=e),this.enabled=!0;const r=e.terrain.properties;this.sourceCache=0===e.terrain.drapeRenderMode?this._mockSourceCache:e._getSourceCache(r.get("source")),this._exaggeration=r.get("exaggeration");const n=()=>{this.sourceCache.used&&H(`Raster DEM source '${this.sourceCache.id}' is used both for terrain and as layer source.\nThis leads to lower resolution of hillshade. For full hillshade resolution but higher memory consumption, define another raster DEM source.`);const e=this.getScaledDemTileSize();this.sourceCache.update(t,e,!0),this.resetTileLookupCache(this.sourceCache.id)};this.sourceCache.usedForTerrain||(this.resetTileLookupCache(this.sourceCache.id),this.sourceCache.usedForTerrain=!0,n(),this._initializing=!0),n(),t.updateElevation(!0,i),this.resetTileLookupCache(this.proxySourceCache.id),this.proxySourceCache.update(t),this._emptyDEMTextureDirty=!0}else this._disable()}resetTileLookupCache(e){this._findCoveringTileCache[e]={}}getScaledDemTileSize(){return this.sourceCache.getSource().tileSize/128*this.proxySourceCache.getSource().tileSize}_checkRenderCacheEfficiency(){const e=this.renderCacheEfficiency(this._style);this._style.map._optimizeForTerrain||100!==e.efficiency&&H(`Terrain render cache efficiency is not optimal (${e.efficiency}%) and performance\n                may be affected negatively, consider placing all background, fill and line layers before layer\n                with id '${e.firstUndrapedLayer}' or create a map using optimizeForTerrain: true option.`)}_onStyleDataEvent(e){e.coord&&"source"===e.dataType?this._clearRenderCacheForTile(e.sourceCacheId,e.coord):"style"===e.dataType&&(this._invalidateRenderCache=!0)}_disable(){if(this.enabled&&(this.enabled=!1,this._sharedDepthStencil=void 0,this.proxySourceCache.deallocRenderCache(),this._style))for(const e in this._style._sourceCaches)this._style._sourceCaches[e].usedForTerrain=!1}destroy(){this._disable(),this._emptyDEMTexture&&this._emptyDEMTexture.destroy(),this._emptyDepthBufferTexture&&this._emptyDepthBufferTexture.destroy(),this.pool.forEach((e=>e.fb.destroy())),this.pool=[],this._depthFBO&&(this._depthFBO.destroy(),this._depthFBO=void 0,this._depthTexture=void 0)}_source(){return this.enabled?this.sourceCache:null}isUsingMockSource(){return this.sourceCache===this._mockSourceCache}exaggeration(){return this._exaggeration}get visibleDemTiles(){return this._visibleDemTiles}get drapeBufferSize(){const e=2*this.proxySourceCache.getSource().tileSize;return[e,e]}set useVertexMorphing(e){this._useVertexMorphing=e}updateTileBinding(e){if(!this.enabled)return;this.prevTerrainTileForTile=this.terrainTileForTile;const t=this.proxySourceCache,i=this.painter.transform;this._initializing&&(this._initializing=0===i._centerAltitude&&-1===this.getAtPointOrZero(MercatorCoordinate.fromLngLat(i.center),-1),this._emptyDEMTextureDirty=!this._initializing);const r=this.proxyCoords=t.getIds().map((e=>{const r=t.getTileByID(e).tileID;return r.projMatrix=i.calculateProjMatrix(r.toUnwrapped()),r}));!function(e,t){const i=t.transform.pointCoordinate(t.transform.getCameraPoint()),r=new g(i.x,i.y);e.sort(((e,t)=>{if(t.overscaledZ-e.overscaledZ)return t.overscaledZ-e.overscaledZ;const i=new g(e.canonical.x+(1<<e.canonical.z)*e.wrap,e.canonical.y),n=new g(t.canonical.x+(1<<t.canonical.z)*t.wrap,t.canonical.y),o=r.mult(1<<e.canonical.z);return o.x-=.5,o.y-=.5,o.distSqr(i)-o.distSqr(n)}))}(r,this.painter),this._previousZoom=i.zoom;const n=this.proxyToSource||{};this.proxyToSource={},r.forEach((e=>{this.proxyToSource[e.key]={}})),this.terrainTileForTile={};const o=this._style._sourceCaches;for(const t in o){const i=o[t];if(!i.used)continue;if(i!==this.sourceCache&&this.resetTileLookupCache(i.id),this._setupProxiedCoordsForOrtho(i,e[t],n),i.usedForTerrain)continue;const r=e[t];i.getSource().reparseOverscaled&&this._assignTerrainTiles(r)}this.proxiedCoords[t.id]=r.map((e=>new ProxiedTileID(e,e.key,this.orthoMatrix))),this._assignTerrainTiles(r),this._prepareDEMTextures(),this._setupDrapedRenderBatches(),this._initFBOPool(),this._setupRenderCache(n),this.renderingToTexture=!1,this._updateTimestamp=it.now();const s={};this._visibleDemTiles=[];for(const e of this.proxyCoords){const t=this.terrainTileForTile[e.key];if(!t)continue;const i=t.tileID.key;i in s||(this._visibleDemTiles.push(t),s[i]=i)}}_assignTerrainTiles(e){this._initializing||e.forEach((e=>{if(this.terrainTileForTile[e.key])return;const t=this._findTileCoveringTileID(e,this.sourceCache);t&&(this.terrainTileForTile[e.key]=t)}))}_prepareDEMTextures(){const e=this.painter.context,t=e.gl;for(const i in this.terrainTileForTile){const r=this.terrainTileForTile[i],n=r.dem;!n||r.demTexture&&!r.needsDEMTextureUpload||(e.activeTexture.set(t.TEXTURE1),Yp(this.painter,r,n))}}_prepareDemTileUniforms(e,t,i,r){if(!t||null==t.demTexture)return!1;const n=e.tileID.canonical,o=Math.pow(2,t.tileID.canonical.z-n.z),s=r||"";return i[`u_dem_tl${s}`]=[n.x*o%1,n.y*o%1],i[`u_dem_scale${s}`]=o,!0}get emptyDEMTexture(){return!this._emptyDEMTextureDirty&&this._emptyDEMTexture?this._emptyDEMTexture:this._updateEmptyDEMTexture()}get emptyDepthBufferTexture(){const e=this.painter.context,t=e.gl;if(!this._emptyDepthBufferTexture){const i=new RGBAImage({width:1,height:1},Uint8Array.of(255,255,255,255));this._emptyDepthBufferTexture=new Texture(e,i,t.RGBA,{premultiply:!1})}return this._emptyDepthBufferTexture}_getLoadedAreaMinimum(){let e=0;const t=this._visibleDemTiles.reduce(((t,i)=>{if(!i.dem)return t;const r=i.dem.tree.minimums[0];return r>0&&e++,t+r}),0);return e?t/e:0}_updateEmptyDEMTexture(){const e=this.painter.context,t=e.gl;e.activeTexture.set(t.TEXTURE2);const i=this._getLoadedAreaMinimum(),r=new RGBAImage({width:1,height:1},new Uint8Array(DEMData.pack(i,this.sourceCache.getSource().encoding)));this._emptyDEMTextureDirty=!1;let n=this._emptyDEMTexture;return n?n.update(r,{premultiply:!1}):n=this._emptyDEMTexture=new Texture(e,r,t.RGBA,{premultiply:!1}),n}setupElevationDraw(e,t,i){const r=this.painter.context,n=r.gl,o=(s=this.sourceCache.getSource().encoding,{u_dem:2,u_dem_prev:4,u_dem_unpack:DEMData.getUnpackVector(s),u_dem_tl:[0,0],u_dem_tl_prev:[0,0],u_dem_scale:0,u_dem_scale_prev:0,u_dem_size:0,u_dem_lerp:1,u_depth:3,u_depth_size_inv:[0,0],u_exaggeration:0});var s;o.u_dem_size=this.sourceCache.getSource().tileSize,o.u_exaggeration=this.exaggeration();let a=null,l=null,c=1;if(i&&i.morphing&&this._useVertexMorphing){const t=i.morphing.srcDemTile,r=i.morphing.dstDemTile;c=i.morphing.phase,t&&r&&(this._prepareDemTileUniforms(e,t,o,"_prev")&&(l=t),this._prepareDemTileUniforms(e,r,o)&&(a=r))}if(l&&a?(r.activeTexture.set(n.TEXTURE2),a.demTexture.bind(n.NEAREST,n.CLAMP_TO_EDGE,n.NEAREST),r.activeTexture.set(n.TEXTURE4),l.demTexture.bind(n.NEAREST,n.CLAMP_TO_EDGE,n.NEAREST),o.u_dem_lerp=c):(a=this.terrainTileForTile[e.tileID.key],r.activeTexture.set(n.TEXTURE2),(this._prepareDemTileUniforms(e,a,o)?a.demTexture:this.emptyDEMTexture).bind(n.NEAREST,n.CLAMP_TO_EDGE)),r.activeTexture.set(n.TEXTURE3),i&&i.useDepthForOcclusion?(this._depthTexture&&this._depthTexture.bind(n.NEAREST,n.CLAMP_TO_EDGE),this._depthFBO&&(o.u_depth_size_inv=[1/this._depthFBO.width,1/this._depthFBO.height])):(this.emptyDepthBufferTexture.bind(n.NEAREST,n.CLAMP_TO_EDGE),o.u_depth_size_inv=[1,1]),i&&i.useMeterToDem&&a){const e=(1<<a.tileID.canonical.z)*La(1,this.painter.transform.center.lat)*this.sourceCache.getSource().tileSize;o.u_meter_to_dem=e}if(i&&i.labelPlaneMatrixInv&&(o.u_label_plane_matrix_inv=i.labelPlaneMatrixInv),t.setTerrainUniformValues(r,o),"globe"===this.painter.transform.projection.name){const n=this.globeUniformValues(this.painter.transform,e.tileID.canonical,i&&i.useDenormalizedUpVectorScale);t.setGlobeUniformValues(r,n)}}globeUniformValues(e,t,i){const r=e.projection;return{u_tile_tl_up:r.upVector(t,0,0),u_tile_tr_up:r.upVector(t,Uo,0),u_tile_br_up:r.upVector(t,Uo,Uo),u_tile_bl_up:r.upVector(t,0,Uo),u_tile_up_scale:i?Ys(1):r.upVectorScale(t,e.center.lat,e.worldSize).metersToTile}}renderToBackBuffer(e){const t=this.painter,i=this.painter.context;0!==e.length&&(i.bindFramebuffer.set(null),i.viewport.set([0,0,t.width,t.height]),t.gpuTimingDeferredRenderStart(),this.renderingToTexture=!1,function(e,t,i,r,n){if("globe"===e.transform.projection.name)!function(e,t,i,r,n){const o=e.context,s=o.gl;let a,l;const c=e.options.showTerrainWireframe?2:0,u=e.transform,h=xa(e,o,u),d=(t,i)=>{if(l===t)return;const r=[sf[t],"PROJECTION_GLOBE_VIEW"];h&&r.push("CUSTOM_ANTIALIASING"),i&&r.push(sf[c]),a=e.useProgram("globeRaster",null,r),l=t},p=e.colorModeForRenderPass(),f=new DepthMode(s.LEQUAL,DepthMode.ReadWrite,e.depthRangeFor3D);of.update(n);const m=function(e){const t=e.pixelsPerMeter,i=t/La(1,e.center.lat),r=Wo(new Float64Array(16));return Ko(r,r,[e.point.x,e.point.y,0]),Jo(r,r,[i,i,t]),Float32Array.from(r)}(u),_=[za(u.center.lng),ka(u.center.lat)],g=c?[!1,!0]:[!1],y=e.globeSharedBuffers,x=[u.width*it.devicePixelRatio,u.height*it.devicePixelRatio],v=Float32Array.from(u.globeMatrix),b={useDenormalizedUpVectorScale:!0};if(g.forEach((c=>{const u=e.transform,h=af(u.zoom)*t.exaggeration();l=-1;const g=c?s.LINES:s.TRIANGLES;for(const l of r){const r=i.getTile(l),w=StencilMode.disabled,E=t.prevTerrainTileForTile[l.key],S=t.terrainTileForTile[l.key];nf(E,S)&&of.newMorphing(l.key,E,S,n,250),o.activeTexture.set(s.TEXTURE0),r.texture.bind(s.LINEAR,s.CLAMP_TO_EDGE);const A=of.getMorphValuesForProxy(l.key),C=A?1:0;A&&xt(b,{morphing:{srcDemTile:A.from,dstDemTile:A.to,phase:T(A.phase)}});const I=sa(l.canonical),M=ba(I.getCenter().lat),P=va(l.canonical,I,M,u.worldSize/u._pixelsPerMercatorPixel),D=pa(ta(l.canonical)),z=rf(u.projMatrix,v,m,D,ga(u.zoom),_,u.frustumCorners.TL,u.frustumCorners.TR,u.frustumCorners.BR,u.frustumCorners.BL,u.globeCenterInViewSpace,u.globeRadius,x,h,P);if(d(C,c),t.setupElevationDraw(r,a,b),e.prepareDrawProgram(o,a,l.toUnwrapped()),y){const[t,i,r]=c?y.getWirefameBuffers(e.context,M):y.getGridBuffers(M,0!==h);a.draw(o,g,f,w,p,CullFaceMode.backCCW,z,"globe_raster",t,i,r)}}})),y){const n=["GLOBE_POLES","PROJECTION_GLOBE_VIEW"];h&&n.push("CUSTOM_ANTIALIASING"),a=e.useProgram("globeRaster",null,n);for(const n of r){const{x:r,y:l,z:c}=n.canonical,h=0===l,d=l===(1<<c)-1,[m,g,v,w]=y.getPoleBuffers(c);if(w&&(h||d)){const l=i.getTile(n);o.activeTexture.set(s.TEXTURE0),l.texture.bind(s.LINEAR,s.CLAMP_TO_EDGE);let y=ya(c,r,u);const E=pa(ta(n.canonical)),T=(e,t)=>e.draw(o,s.TRIANGLES,f,StencilMode.disabled,p,CullFaceMode.disabled,rf(u.projMatrix,y,y,E,0,_,u.frustumCorners.TL,u.frustumCorners.TR,u.frustumCorners.BR,u.frustumCorners.BL,u.globeCenterInViewSpace,u.globeRadius,x,0),"globe_pole_raster",t,v,w);t.setupElevationDraw(l,a,b),e.prepareDrawProgram(o,a,n.toUnwrapped()),h&&T(a,m),d&&(y=Jo($o(),y,[1,-1,1]),T(a,g))}}}}(e,t,i,r,n);else{const o=e.context,s=o.gl;let a,l;const c=e.options.showTerrainWireframe?2:0,u=(t,i)=>{if(l===t)return;const r=[sf[t]];i&&r.push(sf[c]),a=e.useProgram("terrainRaster",null,r),l=t},h=e.colorModeForRenderPass(),d=new DepthMode(s.LEQUAL,DepthMode.ReadWrite,e.depthRangeFor3D);of.update(n);const p=e.transform,f=af(p.zoom)*t.exaggeration();(c?[!1,!0]:[!1]).forEach((c=>{l=-1;const m=c?s.LINES:s.TRIANGLES,[_,g]=c?t.getWirefameBuffer():[t.gridIndexBuffer,t.gridSegments];for(const l of r){const r=i.getTile(l),y=StencilMode.disabled,x=t.prevTerrainTileForTile[l.key],v=t.terrainTileForTile[l.key];nf(x,v)&&of.newMorphing(l.key,x,v,n,250),o.activeTexture.set(s.TEXTURE0),r.texture.bind(s.LINEAR,s.CLAMP_TO_EDGE,s.LINEAR_MIPMAP_NEAREST);const b=of.getMorphValuesForProxy(l.key),w=b?1:0;let E;b&&(E={morphing:{srcDemTile:b.from,dstDemTile:b.to,phase:T(b.phase)}});const S=tf(l.projMatrix,lf(l.canonical,p.renderWorldCopies)?f/10:f);u(w,c),t.setupElevationDraw(r,a,E),e.prepareDrawProgram(o,a,l.toUnwrapped()),a.draw(o,m,d,y,h,CullFaceMode.backCCW,S,"terrain_raster",t.gridBuffer,_,g)}}))}}(t,this,this.proxySourceCache,e,this._updateTimestamp),this.renderingToTexture=!0,t.gpuTimingDeferredRenderEnd(),e.splice(0,e.length))}renderBatch(e){if(0===this._drapedRenderBatches.length)return e+1;this.renderingToTexture=!0;const t=this.painter,i=this.painter.context,r=this.proxySourceCache,n=this.proxiedCoords[r.id],o=this._drapedRenderBatches.shift(),s=[],a=t.style.order;let l=0;for(const c of n){const n=r.getTileByID(c.proxyTileKey),u=r.proxyCachedFBO[c.key]?r.proxyCachedFBO[c.key][e]:void 0,h=void 0!==u?r.renderCache[u]:this.pool[l++],d=void 0!==u;if(n.texture=h.tex,d&&!h.dirty){s.push(n.tileID);continue}let p;i.bindFramebuffer.set(h.fb.framebuffer),this.renderedToTile=!1,h.dirty&&(i.clear({color:Wt.transparent,stencil:0}),h.dirty=!1);for(let e=o.start;e<=o.end;++e){const r=t.style._layers[a[e]];if(r.isHidden(t.transform.zoom))continue;const n=t.style._getLayerSourceCache(r),o=n?this.proxyToSource[c.key][n.id]:[c];if(!o)continue;const s=o;i.viewport.set([0,0,h.fb.width,h.fb.height]),p!==(n?n.id:null)&&(this._setupStencil(h,o,r,n),p=n?n.id:null),t.renderLayer(t,n,r,s)}this.renderedToTile?(h.dirty=!0,s.push(n.tileID)):d||--l,5===l&&(l=0,this.renderToBackBuffer(s))}return this.renderToBackBuffer(s),this.renderingToTexture=!1,i.bindFramebuffer.set(null),i.viewport.set([0,0,t.width,t.height]),o.end+1}postRender(){}renderCacheEfficiency(e){const t=e.order.length;if(0===t)return{efficiency:100};let i,r=0,n=0,o=!1;for(let s=0;s<t;++s){const t=e._layers[e.order[s]];this._style.isLayerDraped(t)?(o&&++r,++n):o||(o=!0,i=t.id)}return 0===n?{efficiency:100}:{efficiency:100*(1-r/n),firstUndrapedLayer:i}}getMinElevationBelowMSL(){let e=0;return this._visibleDemTiles.filter((e=>e.dem)).forEach((t=>{e=Math.min(e,t.dem.tree.minimums[0])})),0===e?e:(e-30)*this._exaggeration}raycast(e,t,i){if(!this._visibleDemTiles)return null;const r=this._visibleDemTiles.filter((e=>e.dem)).map((r=>{const n=r.tileID,o=1<<n.overscaledZ,{x:s,y:a}=n.canonical,l=s/o,c=(s+1)/o,u=a/o,h=(a+1)/o;return{minx:l,miny:u,maxx:c,maxy:h,t:r.dem.tree.raycastRoot(l,u,c,h,e,t,i),tile:r}}));r.sort(((e,t)=>(null!==e.t?e.t:Number.MAX_VALUE)-(null!==t.t?t.t:Number.MAX_VALUE)));for(const n of r){if(null==n.t)return null;const r=n.tile.dem.tree.raycast(n.minx,n.miny,n.maxx,n.maxy,e,t,i);if(null!=r)return r}return null}_createFBO(){const e=this.painter.context,t=e.gl,i=this.drapeBufferSize;e.activeTexture.set(t.TEXTURE0);const r=new Texture(e,{width:i[0],height:i[1],data:null},t.RGBA);r.bind(t.LINEAR,t.CLAMP_TO_EDGE);const n=e.createFramebuffer(i[0],i[1],!1);return n.colorAttachment.set(r.texture),n.depthAttachment=new DepthStencilAttachment(e,n.framebuffer),void 0===this._sharedDepthStencil?(this._sharedDepthStencil=e.createRenderbuffer(e.gl.DEPTH_STENCIL,i[0],i[1]),this._stencilRef=0,n.depthAttachment.set(this._sharedDepthStencil),e.clear({stencil:0})):n.depthAttachment.set(this._sharedDepthStencil),e.extTextureFilterAnisotropic&&!e.extTextureFilterAnisotropicForceOff&&t.texParameterf(t.TEXTURE_2D,e.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,e.extTextureFilterAnisotropicMax),{fb:n,tex:r,dirty:!1}}_initFBOPool(){for(;this.pool.length<Math.min(5,this.proxyCoords.length);)this.pool.push(this._createFBO())}_shouldDisableRenderCache(){if(this._style.light&&this._style.light.hasTransition())return!0;for(const e in this._style._sourceCaches)if(this._style._sourceCaches[e].hasTransition())return!0;return this._style.order.some((e=>{const t=this._style._layers[e],i=t.isHidden(this.painter.transform.zoom);return"custom"===t.type?!i&&t.shouldRedrape():!i&&t.hasTransition()}))}_clearLineLayersFromRenderCache(){let e=!1;for(const t of this._style._getSources())if(t instanceof VectorTileSource){e=!0;break}if(!e)return;const t={};for(let e=0;e<this._style.order.length;++e){const i=this._style._layers[this._style.order[e]],r=this._style._getLayerSourceCache(i);if(r&&!t[r.id]&&!i.isHidden(this.painter.transform.zoom)&&"line"===i.type&&i.widthExpression()instanceof ZoomDependentExpression){t[r.id]=!0;for(const e of this.proxyCoords){const t=this.proxyToSource[e.key][r.id];if(t)for(const e of t)this._clearRenderCacheForTile(r.id,e)}}}}_clearRasterLayersFromRenderCache(){let e=!1;for(const t in this._style._sourceCaches)if(this._style._sourceCaches[t]._source instanceof RasterTileSource){e=!0;break}if(!e)return;const t={};for(let e=0;e<this._style.order.length;++e){const i=this._style._layers[this._style.order[e]],r=this._style._getLayerSourceCache(i);if(!r||t[r.id])continue;if(i.isHidden(this.painter.transform.zoom)||"raster"!==i.type)continue;const n=i.paint.get("raster-fade-duration");for(const e of this.proxyCoords){const t=this.proxyToSource[e.key][r.id];if(t)for(const e of t){const t=uf(r.getTile(e),r.findLoadedParent(e,0),r,this.painter.transform,n);(1!==t.opacity||0!==t.mix)&&this._clearRenderCacheForTile(r.id,e)}}}}_setupDrapedRenderBatches(){const e=this._style.order,t=e.length;if(0===t)return;const i=[];let r,n=0,o=this._style._layers[e[n]];for(;!this._style.isLayerDraped(o)&&o.isHidden(this.painter.transform.zoom)&&++n<t;)o=this._style._layers[e[n]];for(;n<t;++n){const t=this._style._layers[e[n]];t.isHidden(this.painter.transform.zoom)||(this._style.isLayerDraped(t)?void 0===r&&(r=n):void 0!==r&&(i.push({start:r,end:n-1}),r=void 0))}void 0!==r&&i.push({start:r,end:n-1}),this._drapedRenderBatches=i}_setupRenderCache(e){const t=this.proxySourceCache;if(this._shouldDisableRenderCache()||this._invalidateRenderCache){if(this._invalidateRenderCache=!1,t.renderCache.length>t.renderCachePool.length){const e=Object.values(t.proxyCachedFBO);t.proxyCachedFBO={};for(let i=0;i<e.length;++i){const r=Object.values(e[i]);t.renderCachePool.push(...r)}}return}this._clearRasterLayersFromRenderCache();const i=this.proxyCoords,r=this._tilesDirty;for(let n=i.length-1;n>=0;n--){const o=i[n];if(t.getTileByID(o.key),void 0!==t.proxyCachedFBO[o.key]){const i=e[o.key],n=this.proxyToSource[o.key];let s=0;for(const e in n){const t=n[e],o=i[e];if(!o||o.length!==t.length||t.some(((t,i)=>t!==o[i]||r[e]&&r[e].hasOwnProperty(t.key)))){s=-1;break}++s}for(const e in t.proxyCachedFBO[o.key])t.renderCache[t.proxyCachedFBO[o.key][e]].dirty=s<0||s!==Object.values(i).length}}const n=[...this._drapedRenderBatches];n.sort(((e,t)=>t.end-t.start-(e.end-e.start)));for(const e of n)for(const r of i){if(t.proxyCachedFBO[r.key])continue;let i=t.renderCachePool.pop();void 0===i&&t.renderCache.length<50&&(i=t.renderCache.length,t.renderCache.push(this._createFBO())),void 0!==i&&(t.proxyCachedFBO[r.key]={},t.proxyCachedFBO[r.key][e.start]=i,t.renderCache[i].dirty=!0)}this._tilesDirty={}}_setupStencil(e,t,i,r){if(!r||!this._sourceTilesOverlap[r.id])return void(this._overlapStencilType&&(this._overlapStencilType=!1));const n=this.painter.context,o=n.gl;if(t.length<=1)return void(this._overlapStencilType=!1);let s;if(i.isTileClipped())s=t.length,this._overlapStencilMode.test={func:o.EQUAL,mask:255},this._overlapStencilType="Clip";else{if(!(t[0].overscaledZ>t[t.length-1].overscaledZ))return void(this._overlapStencilType=!1);s=1,this._overlapStencilMode.test={func:o.GREATER,mask:255},this._overlapStencilType="Mask"}this._stencilRef+s>255&&(n.clear({stencil:0}),this._stencilRef=0),this._stencilRef+=s,this._overlapStencilMode.ref=this._stencilRef,i.isTileClipped()&&this._renderTileClippingMasks(t,this._overlapStencilMode.ref)}clipOrMaskOverlapStencilType(){return"Clip"===this._overlapStencilType||"Mask"===this._overlapStencilType}stencilModeForRTTOverlap(e){return this.renderingToTexture&&this._overlapStencilType?("Clip"===this._overlapStencilType&&(this._overlapStencilMode.ref=this.painter._tileClippingMaskIDs[e.key]),this._overlapStencilMode):StencilMode.disabled}_renderTileClippingMasks(e,t){const i=this.painter,r=this.painter.context,n=r.gl;i._tileClippingMaskIDs={},r.setColorMode(ColorMode.disabled),r.setDepthMode(DepthMode.disabled);const o=i.useProgram("clippingMask");for(const s of e){const e=i._tileClippingMaskIDs[s.key]=--t;o.draw(r,n.TRIANGLES,DepthMode.disabled,new StencilMode({func:n.ALWAYS,mask:0},e,255,n.KEEP,n.KEEP,n.REPLACE),ColorMode.disabled,CullFaceMode.disabled,cf(s.projMatrix),"$clipping",i.tileExtentBuffer,i.quadTriangleIndexBuffer,i.tileExtentSegments)}}pointCoordinate(e){const t=this.painter.transform;if(e.x<0||e.x>t.width||e.y<0||e.y>t.height)return null;const i=[e.x,e.y,1,1];zs(i,i,t.pixelMatrixInverse),Ps(i,i,1/i[3]),i[0]/=t.worldSize,i[1]/=t.worldSize;const r=t._camera.position,n=La(1,t.center.lat),o=[r[0],r[1],r[2]/n,0],s=ds([],i.slice(0,3),o);xs(s,s);const a=this.raycast(o,s,this._exaggeration);return null!==a&&a?(gs(o,o,s,a),o[3]=o[2],o[2]*=n,o):null}drawDepth(){const e=this.painter,t=e.context,i=this.proxySourceCache,r=Math.ceil(e.width),n=Math.ceil(e.height);if(!this._depthFBO||this._depthFBO.width===r&&this._depthFBO.height===n||(this._depthFBO.destroy(),this._depthFBO=void 0,this._depthTexture=void 0),!this._depthFBO){const e=t.gl,i=t.createFramebuffer(r,n,!0);t.activeTexture.set(e.TEXTURE0);const o=new Texture(t,{width:r,height:n,data:null},e.RGBA);o.bind(e.NEAREST,e.CLAMP_TO_EDGE),i.colorAttachment.set(o.texture);const s=t.createRenderbuffer(t.gl.DEPTH_COMPONENT16,r,n);i.depthAttachment.set(s),this._depthFBO=i,this._depthTexture=o}t.bindFramebuffer.set(this._depthFBO.framebuffer),t.viewport.set([0,0,r,n]),function(e,t,i,r){if("globe"===e.transform.projection.name)return;const n=e.context,o=n.gl;n.clear({depth:1});const s=e.useProgram("terrainDepth"),a=new DepthMode(o.LESS,DepthMode.ReadWrite,e.depthRangeFor3D);for(const e of r){const r=i.getTile(e),l=tf(e.projMatrix,0);t.setupElevationDraw(r,s),s.draw(n,o.TRIANGLES,a,StencilMode.disabled,ColorMode.unblended,CullFaceMode.backCCW,l,"terrain_depth",t.gridBuffer,t.gridIndexBuffer,t.gridNoSkirtSegments)}}(e,this,i,this.proxyCoords)}_setupProxiedCoordsForOrtho(e,t,i){if(e.getSource()instanceof ImageSource)return this._setupProxiedCoordsForImageSource(e,t,i);this._findCoveringTileCache[e.id]=this._findCoveringTileCache[e.id]||{};const r=this.proxiedCoords[e.id]=[],n=this.proxyCoords;for(let t=0;t<n.length;t++){const o=n[t],s=this._findTileCoveringTileID(o,e);if(s){const t=this._createProxiedId(o,s,i[o.key]&&i[o.key][e.id]);r.push(t),this.proxyToSource[o.key][e.id]=[t]}}let o=!1;for(let n=0;n<t.length;n++){const s=e.getTile(t[n]);if(!s||!s.hasData())continue;const a=this._findTileCoveringTileID(s.tileID,this.proxySourceCache);if(a&&a.tileID.canonical.z!==s.tileID.canonical.z){const t=this.proxyToSource[a.tileID.key][e.id],n=this._createProxiedId(a.tileID,s,i[a.tileID.key]&&i[a.tileID.key][e.id]);t?t.splice(t.length-1,0,n):this.proxyToSource[a.tileID.key][e.id]=[n],r.push(n),o=!0}}this._sourceTilesOverlap[e.id]=o}_setupProxiedCoordsForImageSource(e,t,i){if(!e.getSource().loaded())return;const r=this.proxiedCoords[e.id]=[],n=this.proxyCoords,o=e.getSource(),s=new g(o.tileID.x,o.tileID.y)._div(1<<o.tileID.z),a=o.coordinates.map(MercatorCoordinate.fromLngLat).reduce(((e,t)=>(e.min.x=Math.min(e.min.x,t.x-s.x),e.min.y=Math.min(e.min.y,t.y-s.y),e.max.x=Math.max(e.max.x,t.x-s.x),e.max.y=Math.max(e.max.y,t.y-s.y),e)),{min:new g(Number.MAX_VALUE,Number.MAX_VALUE),max:new g(-Number.MAX_VALUE,-Number.MAX_VALUE)}),l=(e,t)=>{const i=e.wrap+e.canonical.x/(1<<e.canonical.z),r=e.canonical.y/(1<<e.canonical.z),n=Uo/(1<<e.canonical.z),o=t.wrap+t.canonical.x/(1<<t.canonical.z),s=t.canonical.y/(1<<t.canonical.z);return i+n<o+a.min.x||i>o+a.max.x||r+n<s+a.min.y||r>s+a.max.y};for(let o=0;o<n.length;o++){const s=n[o];for(let n=0;n<t.length;n++){const o=e.getTile(t[n]);if(!o||!o.hasData())continue;if(l(s,o.tileID))continue;const a=this._createProxiedId(s,o,i[s.key]&&i[s.key][e.id]),c=this.proxyToSource[s.key][e.id];c?c.push(a):this.proxyToSource[s.key][e.id]=[a],r.push(a)}}}_createProxiedId(e,t,i){let r=this.orthoMatrix;if(i){const e=i.find((e=>e.key===t.tileID.key));if(e)return e}if(t.tileID.key!==e.key){const i=e.canonical.z-t.tileID.canonical.z;let n,o,s;r=$o();const a=t.tileID.wrap-e.wrap<<e.overscaledZ;i>0?(n=Uo>>i,o=n*((t.tileID.canonical.x<<i)-e.canonical.x+a),s=n*((t.tileID.canonical.y<<i)-e.canonical.y)):(n=Uo<<-i,o=Uo*(t.tileID.canonical.x-(e.canonical.x+a<<-i)),s=Uo*(t.tileID.canonical.y-(e.canonical.y<<-i))),os(r,0,n,0,n,0,1),Ko(r,r,[o,s,0])}return new ProxiedTileID(t.tileID,e.key,r)}_findTileCoveringTileID(e,t){let i=t.getTile(e);if(i&&i.hasData())return i;const r=this._findCoveringTileCache[t.id],n=r[e.key];if(i=n?t.getTileByID(n):null,i&&i.hasData()||null===n)return i;let o=i?i.tileID:e,s=o.overscaledZ;const a=t.getSource().minzoom,l=[];if(!n){const r=t.getSource().maxzoom;if(e.canonical.z>=r){const i=e.canonical.z-r;t.getSource().reparseOverscaled?(s=Math.max(e.canonical.z+2,t.transform.tileZoom),o=new OverscaledTileID(s,e.wrap,r,e.canonical.x>>i,e.canonical.y>>i)):0!==i&&(s=r,o=new OverscaledTileID(s,e.wrap,r,e.canonical.x>>i,e.canonical.y>>i))}o.key!==e.key&&(l.push(o.key),i=t.getTile(o))}const c=e=>{l.forEach((t=>{r[t]=e})),l.length=0};for(s-=1;s>=a&&(!i||!i.hasData());s--){i&&c(i.tileID.key);const e=o.calculateScaledKey(s);if(i=t.getTileByID(e),i&&i.hasData())break;const n=r[e];if(null===n)break;void 0===n?l.push(e):i=t.getTileByID(n)}return c(i?i.tileID.key:null),i&&i.hasData()?i:null}findDEMTileFor(e){return this.enabled?this._findTileCoveringTileID(e,this.sourceCache):null}prepareDrawTile(){this.renderedToTile=!0}_clearRenderCacheForTile(e,t){let i=this._tilesDirty[e];i||(i=this._tilesDirty[e]={}),i[t.key]=!0}getWirefameBuffer(){if(!this.wireframeSegments){const e=function(e){let t=0;const i=new StructArrayLayout2ui4,r=131;for(let e=1;e<129;e++){for(let n=1;n<129;n++)t=e*r+n,i.emplaceBack(t,t+1),i.emplaceBack(t,t+r),i.emplaceBack(t+1,t+r),128===e&&i.emplaceBack(t+r,t+r+1);i.emplaceBack(t+1,t+1+r)}return i}();this.wireframeIndexBuffer=this.painter.context.createIndexBuffer(e),this.wireframeSegments=SegmentVector.simpleSegment(0,0,this.gridBuffer.length,e.length)}return[this.wireframeIndexBuffer,this.wireframeSegments]}}class Program{static cacheKey(e,t,i,r){let n=`${t}${r?r.cacheKey:""}`;for(const t of i)e.usedDefines.includes(t)&&(n+=`/${t}`);return n}constructor(e,t,i,r,n,o){const s=e.gl;this.program=s.createProgram();const a=function(e){const t=[];for(let i=0;i<e.length;i++){if(null===e[i])continue;const r=e[i].split(" ");t.push(r.pop())}return t}(i.staticAttributes),l=r?r.getBinderAttributes():[],c=a.concat(l);let u=r?r.defines():[];u=u.concat(o.map((e=>`#define ${e}`)));const h=e.isWebGL2?"#version 300 es\n":"",d=h+u.concat(e.extStandardDerivatives&&0===h.length?"#extension GL_OES_standard_derivatives : enable\n".concat($p):$p,$p,Zp,qp.fragmentSource,Np.fragmentSource,i.fragmentSource).join("\n"),p=h+u.concat("\n#ifdef GL_ES\nprecision highp float;\n#else\n\n#if !defined(lowp)\n#define lowp\n#endif\n\n#if !defined(mediump)\n#define mediump\n#endif\n\n#if !defined(highp)\n#define highp\n#endif\n\n#endif",Zp,qp.vertexSource,Np.vertexSource,jp.vertexSource,i.vertexSource).join("\n"),f=s.createShader(s.FRAGMENT_SHADER);if(s.isContextLost())return void(this.failedToCreate=!0);s.shaderSource(f,d),s.compileShader(f),s.attachShader(this.program,f);const m=s.createShader(s.VERTEX_SHADER);if(s.isContextLost())this.failedToCreate=!0;else{s.shaderSource(m,p),s.compileShader(m),s.attachShader(this.program,m),this.attributes={},this.numAttributes=c.length;for(let e=0;e<this.numAttributes;e++)c[e]&&(s.bindAttribLocation(this.program,e,c[e]),this.attributes[c[e]]=e);s.linkProgram(this.program),s.deleteShader(m),s.deleteShader(f),this.fixedUniforms=n(e),this.binderUniforms=r?r.getUniforms(e):[],o.includes("TERRAIN")&&(this.terrainUniforms=(e=>({u_dem:new Uniform1i(e),u_dem_prev:new Uniform1i(e),u_dem_unpack:new Uniform4f(e),u_dem_tl:new Uniform2f(e),u_dem_scale:new Uniform1f(e),u_dem_tl_prev:new Uniform2f(e),u_dem_scale_prev:new Uniform1f(e),u_dem_size:new Uniform1f(e),u_dem_lerp:new Uniform1f(e),u_exaggeration:new Uniform1f(e),u_depth:new Uniform1i(e),u_depth_size_inv:new Uniform2f(e),u_meter_to_dem:new Uniform1f(e),u_label_plane_matrix_inv:new UniformMatrix4f(e)}))(e)),o.includes("GLOBE")&&(this.globeUniforms=(e=>({u_tile_tl_up:new Uniform3f(e),u_tile_tr_up:new Uniform3f(e),u_tile_br_up:new Uniform3f(e),u_tile_bl_up:new Uniform3f(e),u_tile_up_scale:new Uniform1f(e)}))(e)),o.includes("FOG")&&(this.fogUniforms=(e=>({u_fog_matrix:new UniformMatrix4f(e),u_fog_range:new Uniform2f(e),u_fog_color:new Uniform4f(e),u_fog_horizon_blend:new Uniform1f(e),u_fog_temporal_offset:new Uniform1f(e),u_frustum_tl:new Uniform3f(e),u_frustum_tr:new Uniform3f(e),u_frustum_br:new Uniform3f(e),u_frustum_bl:new Uniform3f(e),u_globe_pos:new Uniform3f(e),u_globe_radius:new Uniform1f(e),u_globe_transition:new Uniform1f(e),u_is_globe:new Uniform1i(e),u_viewport:new Uniform2f(e)}))(e))}}setTerrainUniformValues(e,t){if(!this.terrainUniforms)return;const i=this.terrainUniforms;if(!this.failedToCreate){e.program.set(this.program);for(const e in t)i[e]&&i[e].set(this.program,e,t[e])}}setGlobeUniformValues(e,t){if(!this.globeUniforms)return;const i=this.globeUniforms;if(!this.failedToCreate){e.program.set(this.program);for(const e in t)i[e]&&i[e].set(this.program,e,t[e])}}setFogUniformValues(e,t){if(!this.fogUniforms)return;const i=this.fogUniforms;if(!this.failedToCreate){e.program.set(this.program);for(const e in t)i[e].set(this.program,e,t[e])}}draw(e,t,i,r,n,o,s,a,l,c,u,h,d,p,f){const m=e.gl;if(this.failedToCreate)return;e.program.set(this.program),e.setDepthMode(i),e.setStencilMode(r),e.setColorMode(n),e.setCullFace(o);for(const e of Object.keys(this.fixedUniforms))this.fixedUniforms[e].set(this.program,e,s[e]);p&&p.setUniforms(this.program,e,this.binderUniforms,h,{zoom:d});const _={[m.LINES]:2,[m.TRIANGLES]:3,[m.LINE_STRIP]:1}[t];for(const i of u.get()){const r=i.vaos||(i.vaos={});(r[a]||(r[a]=new VertexArrayObject)).bind(e,this,l,p?p.getPaintVertexBuffers():[],c,i.vertexOffset,f||[]),m.drawElements(t,i.primitiveLength*_,m.UNSIGNED_SHORT,i.primitiveOffset*_*2)}}}function hf(e,t){const i=Math.pow(2,t.tileID.overscaledZ),r=t.tileSize*Math.pow(2,e.transform.tileZoom)/i,n=r*(t.tileID.canonical.x+t.tileID.wrap*i),o=r*t.tileID.canonical.y;return{u_image:0,u_texsize:t.imageAtlasTexture.size,u_tile_units_to_pixels:1/jh(t,1,e.transform.tileZoom),u_pixel_coord_upper:[n>>16,o>>16],u_pixel_coord_lower:[65535&n,65535&o]}}const df=$o(),pf=(e,t,i,r,n,o,s,a,l,c,u)=>{const h=t.style.light,d=h.properties.get("position"),p=[d.x,d.y,d.z],f=Go();var m,_,g,y;"viewport"===h.properties.get("anchor")&&(m=f,_=-t.transform.angle,g=Math.sin(_),y=Math.cos(_),m[0]=y,m[1]=g,m[2]=0,m[3]=-g,m[4]=y,m[5]=0,m[6]=0,m[7]=0,m[8]=1,Es(p,p,f));const x=h.properties.get("color"),v=t.transform,b={u_matrix:e,u_lightpos:p,u_lightintensity:h.properties.get("intensity"),u_lightcolor:[x.r,x.g,x.b],u_vertical_gradient:+i,u_opacity:r,u_tile_id:[0,0,0],u_zoom_transition:0,u_inv_rot_matrix:df,u_merc_center:[0,0],u_up_dir:[0,0,0],u_height_lift:0,u_ao:n,u_edge_radius:o};return"globe"===v.projection.name&&(b.u_tile_id=[s.canonical.x,s.canonical.y,1<<s.canonical.z],b.u_zoom_transition=l,b.u_inv_rot_matrix=u,b.u_merc_center=c,b.u_up_dir=v.projection.upVector(new CanonicalTileID(0,0,0),c[0]*Uo,c[1]*Uo),b.u_height_lift=a),b},ff=(e,t,i,r,n,o,s,a,l,c,u,h)=>{const d=pf(e,t,i,r,n,o,s,l,c,u,h),p={u_height_factor:-Math.pow(2,s.overscaledZ)/a.tileSize/8};return L(d,hf(t,a),p)},mf=e=>({u_matrix:e}),_f=(e,t,i)=>L(mf(e),hf(t,i)),gf=(e,t)=>({u_matrix:e,u_world:t}),yf=(e,t,i,r)=>L(_f(e,t,i),{u_world:r}),xf=$o(),vf=(e,t,i,r,n,o)=>{const s=e.transform,a="globe"===s.projection.name;let l;if("map"===o.paint.get("circle-pitch-alignment"))if(a){const e=ma(s.zoom,t.canonical)*s._pixelsPerMercatorPixel;l=Float32Array.from([e,0,0,e])}else l=s.calculatePixelsToTileUnitsMatrix(i);else l=new Float32Array([s.pixelsToGLUnits[0],0,0,s.pixelsToGLUnits[1]]);const c={u_camera_to_center_distance:s.cameraToCenterDistance,u_matrix:e.translatePosMatrix(t.projMatrix,i,o.paint.get("circle-translate"),o.paint.get("circle-translate-anchor")),u_device_pixel_ratio:it.devicePixelRatio,u_extrude_scale:l,u_inv_rot_matrix:xf,u_merc_center:[0,0],u_tile_id:[0,0,0],u_zoom_transition:0,u_up_dir:[0,0,0]};if(a){c.u_inv_rot_matrix=r,c.u_merc_center=n,c.u_tile_id=[t.canonical.x,t.canonical.y,1<<t.canonical.z],c.u_zoom_transition=ga(s.zoom);const e=n[0]*Uo,i=n[1]*Uo;c.u_up_dir=s.projection.upVector(new CanonicalTileID(0,0,0),e,i)}return c},bf=e=>{const t=[];return"map"===e.paint.get("circle-pitch-alignment")&&t.push("PITCH_WITH_MAP"),"map"===e.paint.get("circle-pitch-scale")&&t.push("SCALE_WITH_MAP"),t},wf=(e,t,i,r)=>{const n=Uo/i.tileSize;return{u_matrix:e,u_camera_to_center_distance:t.getCameraToCenterDistance(r),u_extrude_scale:[t.pixelsToGLUnits[0]/n,t.pixelsToGLUnits[1]/n]}},Ef=(e,t,i=1)=>({u_matrix:e,u_color:t,u_overlay:0,u_overlay_scale:i}),Tf=$o(),Sf=(e,t,i,r,n,o,s)=>{const a=e.transform,l="globe"===a.projection.name,c=l?ma(a.zoom,t.canonical)*a._pixelsPerMercatorPixel:jh(i,1,o),u={u_matrix:t.projMatrix,u_extrude_scale:c,u_intensity:s,u_inv_rot_matrix:Tf,u_merc_center:[0,0],u_tile_id:[0,0,0],u_zoom_transition:0,u_up_dir:[0,0,0]};if(l){u.u_inv_rot_matrix=r,u.u_merc_center=n,u.u_tile_id=[t.canonical.x,t.canonical.y,1<<t.canonical.z],u.u_zoom_transition=ga(a.zoom);const e=n[0]*Uo,i=n[1]*Uo;u.u_up_dir=a.projection.upVector(new CanonicalTileID(0,0,0),e,i)}return u},Af=(e,t,i,r,n,o,s)=>{const a=e.transform,l=a.calculatePixelsToTileUnitsMatrix(t);return{u_matrix:Mf(e,t,i,r),u_pixels_to_tile_units:l,u_device_pixel_ratio:o,u_units_to_pixels:[1/a.pixelsToGLUnits[0],1/a.pixelsToGLUnits[1]],u_dash_image:0,u_gradient_image:1,u_image_height:n,u_texsize:Pf(i)?t.lineAtlasTexture.size:[0,0],u_tile_units_to_pixels:If(t,e.transform),u_alpha_discard_threshold:0,u_trim_offset:s}},Cf=(e,t,i,r,n)=>{const o=e.transform;return{u_matrix:Mf(e,t,i,r),u_texsize:t.imageAtlasTexture.size,u_pixels_to_tile_units:o.calculatePixelsToTileUnitsMatrix(t),u_device_pixel_ratio:n,u_image:0,u_tile_units_to_pixels:If(t,o),u_units_to_pixels:[1/o.pixelsToGLUnits[0],1/o.pixelsToGLUnits[1]],u_alpha_discard_threshold:0}};function If(e,t){return 1/jh(e,1,t.tileZoom)}function Mf(e,t,i,r){return e.translatePosMatrix(r||t.tileID.projMatrix,t,i.paint.get("line-translate"),i.paint.get("line-translate-anchor"))}function Pf(e){const t=e.paint.get("line-dasharray").value;return t.value||"constant"!==t.kind}const Df=(e,t,i,r,n,o)=>{return{u_matrix:e,u_tl_parent:t,u_scale_parent:i,u_fade_t:r.mix,u_opacity:r.opacity*n.paint.get("raster-opacity"),u_image0:0,u_image1:1,u_brightness_low:n.paint.get("raster-brightness-min"),u_brightness_high:n.paint.get("raster-brightness-max"),u_saturation_factor:(a=n.paint.get("raster-saturation"),a>0?1-1/(1.001-a):-a),u_contrast_factor:(s=n.paint.get("raster-contrast"),s>0?1/(1-s):1+s),u_spin_weights:zf(n.paint.get("raster-hue-rotate")),u_perspective_transform:o};var s,a};function zf(e){e*=Math.PI/180;const t=Math.sin(e),i=Math.cos(e);return[(2*i+1)/3,(-Math.sqrt(3)*t-i+1)/3,(Math.sqrt(3)*t-i+1)/3]}const kf=$o(),Lf=(e,t,i,r,n,o,s,a,l,c,u,h,d,p,f,m)=>{const _=n.transform,g={u_is_size_zoom_constant:+("constant"===e||"source"===e),u_is_size_feature_constant:+("constant"===e||"camera"===e),u_size_t:t?t.uSizeT:0,u_size:t?t.uSize:0,u_camera_to_center_distance:_.cameraToCenterDistance,u_rotate_symbol:+i,u_aspect_ratio:_.width/_.height,u_fade_change:n.options.fadeDuration?n.symbolFadeChange:1,u_matrix:o,u_label_plane_matrix:s,u_coord_matrix:a,u_is_text:+l,u_pitch_with_map:+r,u_texsize:c,u_texture:0,u_tile_id:[0,0,0],u_zoom_transition:0,u_inv_rot_matrix:kf,u_merc_center:[0,0],u_camera_forward:[0,0,0],u_ecef_origin:[0,0,0],u_tile_matrix:kf,u_up_vector:[0,-1,0]};return"globe"===m.name&&(g.u_tile_id=[u.canonical.x,u.canonical.y,1<<u.canonical.z],g.u_zoom_transition=h,g.u_inv_rot_matrix=p,g.u_merc_center=d,g.u_camera_forward=_._camera.forward(),g.u_ecef_origin=function(e,t){const i=[0,0,0];return ws(i,i,pa(ta(t.canonical))),ws(i,i,e),i}(_.globeMatrix,u.toUnwrapped()),g.u_tile_matrix=Float32Array.from(_.globeMatrix),g.u_up_vector=f),g},Bf=(e,t,i,r,n,o,s,a,l,c,u,h,d,p,f,m,_)=>L(Lf(e,t,i,r,n,o,s,a,l,c,h,d,p,f,m,_),{u_gamma_scale:r?n.transform.cameraToCenterDistance*Math.cos(n.terrain?0:n.transform._pitch):1,u_device_pixel_ratio:it.devicePixelRatio,u_is_halo:+u}),Rf=(e,t,i,r,n,o,s,a,l,c,u,h,d,p,f,m)=>L(Bf(e,t,i,r,n,o,s,a,!0,l,!0,u,h,d,p,f,m),{u_texsize_icon:c,u_texture_icon:1}),Ff=(e,t,i)=>({u_matrix:e,u_opacity:t,u_color:i}),Of=(e,t,i,r,n)=>L(function(e,t,i){const r=t.imageManager.getPattern(e.toString()),{width:n,height:o}=t.imageManager.getPixelSize(),s=Math.pow(2,i.tileID.overscaledZ),a=i.tileSize*Math.pow(2,t.transform.tileZoom)/s,l=a*(i.tileID.canonical.x+i.tileID.wrap*s),c=a*i.tileID.canonical.y;return{u_image:0,u_pattern_tl:r.tl,u_pattern_br:r.br,u_texsize:[n,o],u_pattern_size:r.displaySize,u_tile_units_to_pixels:1/jh(i,1,t.transform.tileZoom),u_pixel_coord_upper:[l>>16,c>>16],u_pixel_coord_lower:[65535&l,65535&c]}}(r,i,n),{u_matrix:e,u_opacity:t}),Uf={fillExtrusion:e=>({u_matrix:new UniformMatrix4f(e),u_lightpos:new Uniform3f(e),u_lightintensity:new Uniform1f(e),u_lightcolor:new Uniform3f(e),u_vertical_gradient:new Uniform1f(e),u_opacity:new Uniform1f(e),u_edge_radius:new Uniform1f(e),u_ao:new Uniform2f(e),u_tile_id:new Uniform3f(e),u_zoom_transition:new Uniform1f(e),u_inv_rot_matrix:new UniformMatrix4f(e),u_merc_center:new Uniform2f(e),u_up_dir:new Uniform3f(e),u_height_lift:new Uniform1f(e)}),fillExtrusionPattern:e=>({u_matrix:new UniformMatrix4f(e),u_lightpos:new Uniform3f(e),u_lightintensity:new Uniform1f(e),u_lightcolor:new Uniform3f(e),u_vertical_gradient:new Uniform1f(e),u_height_factor:new Uniform1f(e),u_edge_radius:new Uniform1f(e),u_ao:new Uniform2f(e),u_tile_id:new Uniform3f(e),u_zoom_transition:new Uniform1f(e),u_inv_rot_matrix:new UniformMatrix4f(e),u_merc_center:new Uniform2f(e),u_up_dir:new Uniform3f(e),u_height_lift:new Uniform1f(e),u_image:new Uniform1i(e),u_texsize:new Uniform2f(e),u_pixel_coord_upper:new Uniform2f(e),u_pixel_coord_lower:new Uniform2f(e),u_tile_units_to_pixels:new Uniform1f(e),u_opacity:new Uniform1f(e)}),fill:e=>({u_matrix:new UniformMatrix4f(e)}),fillPattern:e=>({u_matrix:new UniformMatrix4f(e),u_image:new Uniform1i(e),u_texsize:new Uniform2f(e),u_pixel_coord_upper:new Uniform2f(e),u_pixel_coord_lower:new Uniform2f(e),u_tile_units_to_pixels:new Uniform1f(e)}),fillOutline:e=>({u_matrix:new UniformMatrix4f(e),u_world:new Uniform2f(e)}),fillOutlinePattern:e=>({u_matrix:new UniformMatrix4f(e),u_world:new Uniform2f(e),u_image:new Uniform1i(e),u_texsize:new Uniform2f(e),u_pixel_coord_upper:new Uniform2f(e),u_pixel_coord_lower:new Uniform2f(e),u_tile_units_to_pixels:new Uniform1f(e)}),circle:e=>({u_camera_to_center_distance:new Uniform1f(e),u_extrude_scale:new UniformMatrix2f(e),u_device_pixel_ratio:new Uniform1f(e),u_matrix:new UniformMatrix4f(e),u_inv_rot_matrix:new UniformMatrix4f(e),u_merc_center:new Uniform2f(e),u_tile_id:new Uniform3f(e),u_zoom_transition:new Uniform1f(e),u_up_dir:new Uniform3f(e)}),collisionBox:e=>({u_matrix:new UniformMatrix4f(e),u_camera_to_center_distance:new Uniform1f(e),u_extrude_scale:new Uniform2f(e)}),collisionCircle:e=>({u_matrix:new UniformMatrix4f(e),u_inv_matrix:new UniformMatrix4f(e),u_camera_to_center_distance:new Uniform1f(e),u_viewport_size:new Uniform2f(e)}),debug:e=>({u_color:new UniformColor(e),u_matrix:new UniformMatrix4f(e),u_overlay:new Uniform1i(e),u_overlay_scale:new Uniform1f(e)}),clippingMask:e=>({u_matrix:new UniformMatrix4f(e)}),heatmap:e=>({u_extrude_scale:new Uniform1f(e),u_intensity:new Uniform1f(e),u_matrix:new UniformMatrix4f(e),u_inv_rot_matrix:new UniformMatrix4f(e),u_merc_center:new Uniform2f(e),u_tile_id:new Uniform3f(e),u_zoom_transition:new Uniform1f(e),u_up_dir:new Uniform3f(e)}),heatmapTexture:e=>({u_image:new Uniform1i(e),u_color_ramp:new Uniform1i(e),u_opacity:new Uniform1f(e)}),hillshade:e=>({u_matrix:new UniformMatrix4f(e),u_image:new Uniform1i(e),u_latrange:new Uniform2f(e),u_light:new Uniform2f(e),u_shadow:new UniformColor(e),u_highlight:new UniformColor(e),u_accent:new UniformColor(e)}),hillshadePrepare:e=>({u_matrix:new UniformMatrix4f(e),u_image:new Uniform1i(e),u_dimension:new Uniform2f(e),u_zoom:new Uniform1f(e),u_unpack:new Uniform4f(e)}),line:e=>({u_matrix:new UniformMatrix4f(e),u_pixels_to_tile_units:new UniformMatrix2f(e),u_device_pixel_ratio:new Uniform1f(e),u_units_to_pixels:new Uniform2f(e),u_dash_image:new Uniform1i(e),u_gradient_image:new Uniform1i(e),u_image_height:new Uniform1f(e),u_texsize:new Uniform2f(e),u_tile_units_to_pixels:new Uniform1f(e),u_alpha_discard_threshold:new Uniform1f(e),u_trim_offset:new Uniform2f(e)}),linePattern:e=>({u_matrix:new UniformMatrix4f(e),u_texsize:new Uniform2f(e),u_pixels_to_tile_units:new UniformMatrix2f(e),u_device_pixel_ratio:new Uniform1f(e),u_image:new Uniform1i(e),u_units_to_pixels:new Uniform2f(e),u_tile_units_to_pixels:new Uniform1f(e),u_alpha_discard_threshold:new Uniform1f(e)}),raster:e=>({u_matrix:new UniformMatrix4f(e),u_tl_parent:new Uniform2f(e),u_scale_parent:new Uniform1f(e),u_fade_t:new Uniform1f(e),u_opacity:new Uniform1f(e),u_image0:new Uniform1i(e),u_image1:new Uniform1i(e),u_brightness_low:new Uniform1f(e),u_brightness_high:new Uniform1f(e),u_saturation_factor:new Uniform1f(e),u_contrast_factor:new Uniform1f(e),u_spin_weights:new Uniform3f(e),u_perspective_transform:new Uniform2f(e)}),symbolIcon:e=>({u_is_size_zoom_constant:new Uniform1i(e),u_is_size_feature_constant:new Uniform1i(e),u_size_t:new Uniform1f(e),u_size:new Uniform1f(e),u_camera_to_center_distance:new Uniform1f(e),u_rotate_symbol:new Uniform1i(e),u_aspect_ratio:new Uniform1f(e),u_fade_change:new Uniform1f(e),u_matrix:new UniformMatrix4f(e),u_label_plane_matrix:new UniformMatrix4f(e),u_coord_matrix:new UniformMatrix4f(e),u_is_text:new Uniform1i(e),u_pitch_with_map:new Uniform1i(e),u_texsize:new Uniform2f(e),u_tile_id:new Uniform3f(e),u_zoom_transition:new Uniform1f(e),u_inv_rot_matrix:new UniformMatrix4f(e),u_merc_center:new Uniform2f(e),u_camera_forward:new Uniform3f(e),u_tile_matrix:new UniformMatrix4f(e),u_up_vector:new Uniform3f(e),u_ecef_origin:new Uniform3f(e),u_texture:new Uniform1i(e)}),symbolSDF:e=>({u_is_size_zoom_constant:new Uniform1i(e),u_is_size_feature_constant:new Uniform1i(e),u_size_t:new Uniform1f(e),u_size:new Uniform1f(e),u_camera_to_center_distance:new Uniform1f(e),u_rotate_symbol:new Uniform1i(e),u_aspect_ratio:new Uniform1f(e),u_fade_change:new Uniform1f(e),u_matrix:new UniformMatrix4f(e),u_label_plane_matrix:new UniformMatrix4f(e),u_coord_matrix:new UniformMatrix4f(e),u_is_text:new Uniform1i(e),u_pitch_with_map:new Uniform1i(e),u_texsize:new Uniform2f(e),u_texture:new Uniform1i(e),u_gamma_scale:new Uniform1f(e),u_device_pixel_ratio:new Uniform1f(e),u_tile_id:new Uniform3f(e),u_zoom_transition:new Uniform1f(e),u_inv_rot_matrix:new UniformMatrix4f(e),u_merc_center:new Uniform2f(e),u_camera_forward:new Uniform3f(e),u_tile_matrix:new UniformMatrix4f(e),u_up_vector:new Uniform3f(e),u_ecef_origin:new Uniform3f(e),u_is_halo:new Uniform1i(e)}),symbolTextAndIcon:e=>({u_is_size_zoom_constant:new Uniform1i(e),u_is_size_feature_constant:new Uniform1i(e),u_size_t:new Uniform1f(e),u_size:new Uniform1f(e),u_camera_to_center_distance:new Uniform1f(e),u_rotate_symbol:new Uniform1i(e),u_aspect_ratio:new Uniform1f(e),u_fade_change:new Uniform1f(e),u_matrix:new UniformMatrix4f(e),u_label_plane_matrix:new UniformMatrix4f(e),u_coord_matrix:new UniformMatrix4f(e),u_is_text:new Uniform1i(e),u_pitch_with_map:new Uniform1i(e),u_texsize:new Uniform2f(e),u_texsize_icon:new Uniform2f(e),u_texture:new Uniform1i(e),u_texture_icon:new Uniform1i(e),u_gamma_scale:new Uniform1f(e),u_device_pixel_ratio:new Uniform1f(e),u_is_halo:new Uniform1i(e)}),background:e=>({u_matrix:new UniformMatrix4f(e),u_opacity:new Uniform1f(e),u_color:new UniformColor(e)}),backgroundPattern:e=>({u_matrix:new UniformMatrix4f(e),u_opacity:new Uniform1f(e),u_image:new Uniform1i(e),u_pattern_tl:new Uniform2f(e),u_pattern_br:new Uniform2f(e),u_texsize:new Uniform2f(e),u_pattern_size:new Uniform2f(e),u_pixel_coord_upper:new Uniform2f(e),u_pixel_coord_lower:new Uniform2f(e),u_tile_units_to_pixels:new Uniform1f(e)}),terrainRaster:ef,terrainDepth:ef,skybox:e=>({u_matrix:new UniformMatrix4f(e),u_sun_direction:new Uniform3f(e),u_cubemap:new Uniform1i(e),u_opacity:new Uniform1f(e),u_temporal_offset:new Uniform1f(e)}),skyboxGradient:e=>({u_matrix:new UniformMatrix4f(e),u_color_ramp:new Uniform1i(e),u_center_direction:new Uniform3f(e),u_radius:new Uniform1f(e),u_opacity:new Uniform1f(e),u_temporal_offset:new Uniform1f(e)}),skyboxCapture:e=>({u_matrix_3f:new UniformMatrix3f(e),u_sun_direction:new Uniform3f(e),u_sun_intensity:new Uniform1f(e),u_color_tint_r:new Uniform4f(e),u_color_tint_m:new Uniform4f(e),u_luminance:new Uniform1f(e)}),globeRaster:e=>({u_proj_matrix:new UniformMatrix4f(e),u_globe_matrix:new UniformMatrix4f(e),u_normalize_matrix:new UniformMatrix4f(e),u_merc_matrix:new UniformMatrix4f(e),u_zoom_transition:new Uniform1f(e),u_merc_center:new Uniform2f(e),u_image0:new Uniform1i(e),u_grid_matrix:new UniformMatrix3f(e),u_skirt_height:new Uniform1f(e),u_frustum_tl:new Uniform3f(e),u_frustum_tr:new Uniform3f(e),u_frustum_br:new Uniform3f(e),u_frustum_bl:new Uniform3f(e),u_globe_pos:new Uniform3f(e),u_globe_radius:new Uniform1f(e),u_viewport:new Uniform2f(e)}),globeAtmosphere:e=>({u_frustum_tl:new Uniform3f(e),u_frustum_tr:new Uniform3f(e),u_frustum_br:new Uniform3f(e),u_frustum_bl:new Uniform3f(e),u_horizon:new Uniform1f(e),u_transition:new Uniform1f(e),u_fadeout_range:new Uniform1f(e),u_color:new Uniform4f(e),u_high_color:new Uniform4f(e),u_space_color:new Uniform4f(e),u_star_intensity:new Uniform1f(e),u_star_density:new Uniform1f(e),u_star_size:new Uniform1f(e),u_temporal_offset:new Uniform1f(e),u_horizon_angle:new Uniform1f(e),u_rotation_matrix:new UniformMatrix4f(e)})};let Vf;function jf(e,t,i,r,n,o,s){const a=e.context,l=a.gl,c=e.transform,u=e.useProgram("collisionBox"),h=[];let d=0,p=0;for(let f=0;f<r.length;f++){const m=r[f],_=t.getTile(m),g=_.getBucket(i);if(!g)continue;const y=up(m,g,c);let x=y;0===n[0]&&0===n[1]||(x=e.translatePosMatrix(y,_,n,o));const v=s?g.textCollisionBox:g.iconCollisionBox,b=g.collisionCircleArray;if(b.length>0){const e=$o(),t=x;ss(e,g.placementInvProjMatrix,c.glCoordMatrix),ss(e,e,g.placementViewportMatrix),h.push({circleArray:b,circleOffset:p,transform:t,invTransform:e,projection:g.getProjection()}),d+=b.length/4,p=d}v&&(e.terrain&&e.terrain.setupElevationDraw(_,u),u.draw(a,l.LINES,DepthMode.disabled,StencilMode.disabled,e.colorModeForRenderPass(),CullFaceMode.disabled,wf(x,c,_,g.getProjection()),i.id,v.layoutVertexBuffer,v.indexBuffer,v.segments,null,c.zoom,null,[v.collisionVertexBuffer,v.collisionVertexBufferExt]))}if(!s||!h.length)return;const f=e.useProgram("collisionCircle"),m=new StructArrayLayout2f1f2i16;m.resize(4*d),m._trim();let _=0;for(const e of h)for(let t=0;t<e.circleArray.length/4;t++){const i=4*t,r=e.circleArray[i+0],n=e.circleArray[i+1],o=e.circleArray[i+2],s=e.circleArray[i+3];m.emplace(_++,r,n,o,s,0),m.emplace(_++,r,n,o,s,1),m.emplace(_++,r,n,o,s,2),m.emplace(_++,r,n,o,s,3)}(!Vf||Vf.length<2*d)&&(Vf=function(e){const t=2*e,i=new StructArrayLayout3ui6;i.resize(t),i._trim();for(let e=0;e<t;e++){const t=6*e;i.uint16[t+0]=4*e+0,i.uint16[t+1]=4*e+1,i.uint16[t+2]=4*e+2,i.uint16[t+3]=4*e+2,i.uint16[t+4]=4*e+3,i.uint16[t+5]=4*e+0}return i}(d));const g=a.createIndexBuffer(Vf,!0),y=a.createVertexBuffer(m,hu.members,!0);for(const t of h){const r={u_matrix:t.transform,u_inv_matrix:t.invTransform,u_camera_to_center_distance:(x=c).getCameraToCenterDistance(t.projection),u_viewport_size:[x.width,x.height]};f.draw(a,l.TRIANGLES,DepthMode.disabled,StencilMode.disabled,e.colorModeForRenderPass(),CullFaceMode.disabled,r,i.id,y,g,SegmentVector.simpleSegment(0,2*t.circleOffset,t.circleArray.length,t.circleArray.length/2),null,c.zoom)}var x;y.destroy(),g.destroy()}const Nf=$o();function Gf({width:e,height:t,anchor:i,textOffset:r,textScale:n},o){const{horizontalAlign:s,verticalAlign:a}=Hu(i),l=-(s-.5)*e,c=-(a-.5)*t,u=th(i,r);return new g((l/n+u[0])*o,(c/n+u[1])*o)}function qf(e,t,i,r,n,o,s,a,l,c,u){const h=e.text.placedSymbolArray,d=e.text.dynamicLayoutVertexArray,p=e.icon.dynamicLayoutVertexArray,f={},m=e.getProjection(),_=hp(a,m,o),g=o.elevation,y=m.upVectorScale(a.canonical,o.center.lat,o.worldSize).metersToTile;d.clear();for(let p=0;p<h.length;p++){const x=h.get(p),{tileAnchorX:v,tileAnchorY:b,numGlyphs:w}=x,E=x.hidden||!x.crossTileID||e.allowVerticalPlacement&&!x.placedOrientation?null:r[x.crossTileID];if(E){let r=0,h=0,p=0;if(g){const e=g?g.getAtTileOffset(a,v,b):0,[t,i,n]=m.upVector(a.canonical,v,b);r=e*t*y,h=e*i*y,p=e*n*y}let[T,S,A,C]=Kd(x.projectedAnchorX+r,x.projectedAnchorY+h,x.projectedAnchorZ+p,i?_:s);const I=Jd(o.getCameraToCenterDistance(m),C);let M=n.evaluateSizeForFeature(e.textSizeData,c,x)*I/24;i&&(M*=e.tilePixelRatio/l);const P=Gf(E,M);i?(({x:T,y:S,z:A}=m.projectTilePoint(v+P.x,b+P.y,a.canonical)),[T,S,A]=Kd(T+r,S+h,A+p,s)):(t&&P._rotate(-o.angle),T+=P.x,S+=P.y,A=0);const D=e.allowVerticalPlacement&&x.placedOrientation===Wu.vertical?Math.PI/2:0;for(let e=0;e<w;e++)Th(d,T,S,A,D);u&&x.associatedIconIndex>=0&&(f[x.associatedIconIndex]={x:T,y:S,z:A,angle:D})}else sp(w,d)}if(u){p.clear();const t=e.icon.placedSymbolArray;for(let e=0;e<t.length;e++){const i=t.get(e),{numGlyphs:r}=i,n=f[e];if(i.hidden||!n)sp(r,p);else{const{x:e,y:t,z:i,angle:o}=n;for(let n=0;n<r;n++)Th(p,e,t,i,o)}}e.icon.dynamicLayoutVertexBuffer.updateData(p)}e.text.dynamicLayoutVertexBuffer.updateData(d)}function Zf(e,t,i){return i.iconsInText&&t?"symbolTextAndIcon":e?"symbolSDF":"symbolIcon"}function $f(e,t,i,r,n,o,s,a,l,c,u,h){const d=e.context,p=d.gl,f=e.transform,m="map"===a,_="map"===l,g=m&&"point"!==i.layout.get("symbol-placement"),y=m&&!_&&!g,x=void 0!==i.layout.get("symbol-sort-key").constantOr(1);let v=!1;const b=e.depthModeForSublayer(0,DepthMode.ReadOnly),w=[za(f.center.lng),ka(f.center.lat)],E=i.layout.get("text-variable-anchor"),T="globe"===f.projection.name,S=[],A=[0,-1,0];let C=A;!T&&!f.mercatorFromTransition||m||(C=function(e){const t=Xo([],e._camera.getWorldToCamera(e.worldSize,1),e.globeMatrix);Ho(t,t);const i=[0,0,0],r=[0,1,0,0];return zs(r,r,t),i[0]=r[0],i[1]=r[1],i[2]=r[2],xs(i,i),i}(f));for(const a of r){const r=t.getTile(a),l=r.getBucket(i);if(!l)continue;if("mercator"===l.projection.name&&T)continue;const u=n?l.text:l.icon;if(!u||l.fullyClipped||!u.segments.get().length)continue;const h=u.programConfigurations.get(i.id),d=n||l.sdfIcons,b=n?l.textSizeData:l.iconSizeData,I=_||0!==f.pitch,M=mu(b,f.zoom);let P,D,z,k,L=[0,0],B=null;if(n)D=r.glyphAtlasTexture,z=p.LINEAR,P=r.glyphAtlasTexture.size,l.iconsInText&&(L=r.imageAtlasTexture.size,B=r.imageAtlasTexture,k=I||e.options.rotating||e.options.zooming||"composite"===b.kind||"camera"===b.kind?p.LINEAR:p.NEAREST);else{const t=1!==i.layout.get("icon-size").constantOr(0)||l.iconsNeedLinear;D=r.imageAtlasTexture,z=d||e.options.rotating||e.options.zooming||t||I?p.LINEAR:p.NEAREST,P=r.imageAtlasTexture.size}const R="globe"===l.projection.name,F=R?C:A,O=R?ga(f.zoom):0,U=hp(a,l.getProjection(),f),V=f.calculatePixelsToTileUnitsMatrix(r),j=Wd(U,r.tileID.canonical,_,m,f,l.getProjection(),V),N=e.terrain&&_&&g?Ho($o(),j):Nf,G=Xd(U,r.tileID.canonical,_,m,f,l.getProjection(),V),q=E&&l.hasTextData(),Z="none"!==i.layout.get("icon-text-fit")&&q&&l.hasIconData();if(g){const t=f.elevation,i=t?t.getAtTileOffsetFunc(a,f.center.lat,f.worldSize,l.getProjection()):null,o=Hd(U,r.tileID.canonical,_,m,f,l.getProjection(),V);Qd(l,U,e,n,o,G,_,c,i,a)}const $=g||n&&E||Z,W=e.translatePosMatrix(U,r,o,s),H=$?Nf:j,X=e.translatePosMatrix(G,r,o,s,!0),K=l.getProjection().createInversionMatrix(f,a.canonical),J=[];e.terrainRenderModeElevated()&&_&&J.push("PITCH_WITH_MAP_TERRAIN"),R&&J.push("PROJECTION_GLOBE_VIEW"),$&&J.push("PROJECTED_POS_ON_VIEWPORT");const Y=d&&0!==i.paint.get(n?"text-halo-width":"icon-halo-width").constantOr(1);let Q;Q=d?l.iconsInText?Rf(b.kind,M,y,_,e,W,H,X,P,L,a,O,w,K,F,l.getProjection()):Bf(b.kind,M,y,_,e,W,H,X,n,P,!0,a,O,w,K,F,l.getProjection()):Lf(b.kind,M,y,_,e,W,H,X,n,P,a,O,w,K,F,l.getProjection());const ee={program:e.useProgram(Zf(d,n,l),h,J),buffers:u,uniformValues:Q,atlasTexture:D,atlasTextureIcon:B,atlasInterpolation:z,atlasInterpolationIcon:k,isSDF:d,hasHalo:Y,tile:r,labelPlaneMatrixInv:N};if(x&&l.canOverlap){v=!0;const e=u.segments.get();for(const t of e)S.push({segments:new SegmentVector([t]),sortKey:t.sortKey,state:ee})}else S.push({segments:u.segments,sortKey:0,state:ee})}v&&S.sort(((e,t)=>e.sortKey-t.sortKey));for(const t of S){const r=t.state;if(e.terrain&&e.terrain.setupElevationDraw(r.tile,r.program,{useDepthForOcclusion:!T,labelPlaneMatrixInv:r.labelPlaneMatrixInv}),d.activeTexture.set(p.TEXTURE0),r.atlasTexture.bind(r.atlasInterpolation,p.CLAMP_TO_EDGE),r.atlasTextureIcon&&(d.activeTexture.set(p.TEXTURE1),r.atlasTextureIcon&&r.atlasTextureIcon.bind(r.atlasInterpolationIcon,p.CLAMP_TO_EDGE)),r.isSDF){const n=r.uniformValues;r.hasHalo&&(n.u_is_halo=1,Wf(r.buffers,t.segments,i,e,r.program,b,u,h,n)),n.u_is_halo=0}Wf(r.buffers,t.segments,i,e,r.program,b,u,h,r.uniformValues)}}function Wf(e,t,i,r,n,o,s,a,l){const c=r.context,u=[e.dynamicLayoutVertexBuffer,e.opacityVertexBuffer,e.globeExtVertexBuffer];n.draw(c,c.gl.TRIANGLES,o,s,a,CullFaceMode.disabled,l,i.id,e.layoutVertexBuffer,e.indexBuffer,t,i.paint,r.transform.zoom,e.programConfigurations.get(i.id),u)}function Hf(e,t,i,r,n,o,s){const a=e.context.gl,l=i.paint.get("fill-pattern"),c=l&&l.constantOr(1);let u,h,d,p,f;s?(h=c&&!i.getPaintProperty("fill-outline-color")?"fillOutlinePattern":"fillOutline",u=a.LINES):(h=c?"fillPattern":"fill",u=a.TRIANGLES);for(const m of r){const r=t.getTile(m);if(c&&!r.patternsLoaded())continue;const _=r.getBucket(i);if(!_)continue;e.prepareDrawTile();const g=_.programConfigurations.get(i.id),y=e.useProgram(h,g);c&&(e.context.activeTexture.set(a.TEXTURE0),r.imageAtlasTexture.bind(a.LINEAR,a.CLAMP_TO_EDGE),g.updatePaintBuffers());const x=l.constantOr(null);if(x&&r.imageAtlas){const e=r.imageAtlas.patternPositions[x.toString()];e&&g.setConstantPatternPositions(e)}const v=e.translatePosMatrix(m.projMatrix,r,i.paint.get("fill-translate"),i.paint.get("fill-translate-anchor"));if(s){p=_.indexBuffer2,f=_.segments2;const t=e.terrain&&e.terrain.renderingToTexture?e.terrain.drapeBufferSize:[a.drawingBufferWidth,a.drawingBufferHeight];d="fillOutlinePattern"===h&&c?yf(v,e,r,t):gf(v,t)}else p=_.indexBuffer,f=_.segments,d=c?_f(v,e,r):mf(v);e.prepareDrawProgram(e.context,y,m.toUnwrapped()),y.draw(e.context,u,n,e.stencilModeForClipping(m),o,CullFaceMode.disabled,d,i.id,_.layoutVertexBuffer,p,f,i.paint,e.transform.zoom,g)}}function Xf(e,t,i,r,n,o,s){const a=e.context,l=a.gl,c=e.transform,u=i.paint.get("fill-extrusion-pattern"),h=u.constantOr(1),d=i.paint.get("fill-extrusion-opacity"),p=[i.paint.get("fill-extrusion-ambient-occlusion-intensity"),i.paint.get("fill-extrusion-ambient-occlusion-radius")],f=i.layout.get("fill-extrusion-edge-radius"),m=f>0&&!i.paint.get("fill-extrusion-rounded-roof"),_=m?0:f,g="globe"===c.projection.name?Vc():0,y="globe"===c.projection.name,x=y?ga(c.zoom):0,v=[za(c.center.lng),ka(c.center.lat)],b=[];y&&b.push("PROJECTION_GLOBE_VIEW"),p[0]>0&&b.push("FAUX_AO"),m&&b.push("ZERO_ROOF_RADIUS");for(const f of r){const r=t.getTile(f),m=r.getBucket(i);if(!m||m.projection.name!==c.projection.name)continue;const w=m.programConfigurations.get(i.id),E=e.useProgram(h?"fillExtrusionPattern":"fillExtrusion",w,b);if(e.terrain){const n=e.terrain;if(e.style.terrainSetForDrapingOnly())n.setupElevationDraw(r,E,{useMeterToDem:!0});else{if(!m.enableTerrain)continue;if(n.setupElevationDraw(r,E,{useMeterToDem:!0}),Kf(a,t,f,m,i,n),!m.centroidVertexBuffer){const e=E.attributes.a_centroid_pos;void 0!==e&&l.vertexAttrib2f(e,0,0)}}}h&&(e.context.activeTexture.set(l.TEXTURE0),r.imageAtlasTexture.bind(l.LINEAR,l.CLAMP_TO_EDGE),w.updatePaintBuffers());const T=u.constantOr(null);if(T&&r.imageAtlas){const e=r.imageAtlas.patternPositions[T.toString()];e&&w.setConstantPatternPositions(e)}const S=e.translatePosMatrix(f.projMatrix,r,i.paint.get("fill-extrusion-translate"),i.paint.get("fill-extrusion-translate-anchor")),A=c.projection.createInversionMatrix(c,f.canonical),C=i.paint.get("fill-extrusion-vertical-gradient"),I=h?ff(S,e,C,d,p,_,f,r,g,x,v,A):pf(S,e,C,d,p,_,f,g,x,v,A);e.prepareDrawProgram(a,E,f.toUnwrapped());const M=[];e.terrain&&M.push(m.centroidVertexBuffer),y&&M.push(m.layoutVertexExtBuffer),E.draw(a,a.gl.TRIANGLES,n,o,s,CullFaceMode.backCCW,I,i.id,m.layoutVertexBuffer,m.indexBuffer,m.segments,i.paint,e.transform.zoom,w,M)}}function Kf(e,t,i,r,n,o){const s=[e=>{let t=e.canonical.x-1,i=e.wrap;return t<0&&(t=(1<<e.canonical.z)-1,i--),new OverscaledTileID(e.overscaledZ,i,e.canonical.z,t,e.canonical.y)},e=>{let t=e.canonical.x+1,i=e.wrap;return t===1<<e.canonical.z&&(t=0,i++),new OverscaledTileID(e.overscaledZ,i,e.canonical.z,t,e.canonical.y)},e=>new OverscaledTileID(e.overscaledZ,e.wrap,e.canonical.z,e.canonical.x,(0===e.canonical.y?1<<e.canonical.z:e.canonical.y)-1),e=>new OverscaledTileID(e.overscaledZ,e.wrap,e.canonical.z,e.canonical.x,e.canonical.y===(1<<e.canonical.z)-1?0:e.canonical.y+1)],a=e=>{const i=t.getSource().minzoom,r=e=>{const i=t.getTileByID(e);if(i&&i.hasData())return i.getBucket(n)},o=[0,-1,1];for(const t of o){if(e.overscaledZ+t<i)continue;const n=r(e.calculateScaledKey(e.overscaledZ+t));if(n)return n}},l=[0,0,0],c=(e,t)=>(l[0]=Math.min(e.min.y,t.min.y),l[1]=Math.max(e.max.y,t.max.y),l[2]=Uo-t.min.x>e.max.x?t.min.x-Uo:e.max.x,l),u=(e,t)=>(l[0]=Math.min(e.min.x,t.min.x),l[1]=Math.max(e.max.x,t.max.x),l[2]=Uo-t.min.y>e.max.y?t.min.y-Uo:e.max.y,l),h=[(e,t)=>c(e,t),(e,t)=>c(t,e),(e,t)=>u(e,t),(e,t)=>u(t,e)],d=new g(0,0);let p,f,m;const _=(e,t,r,n,s)=>{const a=[[n?r:e,n?e:r,0],[n?r:t,n?t:r,0]],l=s<0?Uo+s:s,c=[n?l:(e+t)/2,n?(e+t)/2:l,0];return 0===r&&s<0||0!==r&&s>0?o.getForTilePoints(m,[c],!0,f):a.push(c),o.getForTilePoints(i,a,!0,p),Math.max(a[0][2],a[1][2],c[2])/o.exaggeration()};for(let e=0;e<4;e++){const t=(e<2?1:5)-e,n=r.borders[e];if(0===n.length)continue;const l=m=s[e](i),c=a(l);if(!(c&&c instanceof FillExtrusionBucket&&c.enableTerrain))continue;if(r.borderDoneWithNeighborZ[e]===c.canonical.z&&c.borderDoneWithNeighborZ[t]===r.canonical.z)continue;if(f=o.findDEMTileFor(l),!f||!f.dem)continue;if(!p){const e=o.findDEMTileFor(i);if(!e||!e.dem)return;p=e}const u=c.borders[t];let g=0;const y=c.borderDoneWithNeighborZ[t]!==r.canonical.z;if(r.canonical.z===c.canonical.z){for(let i=0;i<n.length;i++){const o=r.featuresOnBorder[n[i]],s=o.borders[e];let a;for(;g<u.length&&(a=c.featuresOnBorder[u[g]],!(a.borders[t][1]>s[0]+3));)y&&c.encodeCentroid(void 0,a,!1),g++;if(a&&g<u.length){const i=g;let n=0;for(;!(a.borders[t][0]>s[1]-3)&&(n++,++g!==u.length);)a=c.featuresOnBorder[u[g]];if(a=c.featuresOnBorder[u[i]],o.intersectsCount()>1||a.intersectsCount()>1||1!==n){1!==n&&(g=i),r.encodeCentroid(void 0,o,!1),y&&c.encodeCentroid(void 0,a,!1);continue}const l=h[e](o,a),p=e%2?Uo-1:0;d.x=_(l[0],Math.min(Uo-1,l[1]),p,e<2,l[2]),d.y=0,r.encodeCentroid(d,o,!1),y&&c.encodeCentroid(d,a,!1)}else r.encodeCentroid(void 0,o,!1)}r.borderDoneWithNeighborZ[e]=c.canonical.z,r.needsCentroidUpdate=!0,y&&(c.borderDoneWithNeighborZ[t]=r.canonical.z,c.needsCentroidUpdate=!0)}else{for(const e of n)r.encodeCentroid(void 0,r.featuresOnBorder[e],!1);if(y){for(const e of u)c.encodeCentroid(void 0,c.featuresOnBorder[e],!1);c.borderDoneWithNeighborZ[t]=r.canonical.z,c.needsCentroidUpdate=!0}r.borderDoneWithNeighborZ[e]=c.canonical.z,r.needsCentroidUpdate=!0}}(r.needsCentroidUpdate||!r.centroidVertexBuffer&&0!==r.centroidVertexArray.length)&&r.uploadCentroid(e)}const Jf=new Wt(1,0,0,1),Yf=new Wt(0,1,0,1),Qf=new Wt(0,0,1,1),em=new Wt(1,0,1,1),tm=new Wt(0,1,1,1);function im(e,t,i){const r=e.context,n=e.transform,o=r.gl,s="globe"===n.projection.name,a=s?["PROJECTION_GLOBE_VIEW"]:null;let l=i.projMatrix;if(s&&ga(n.zoom)>0){const e=fa(ra(i.canonical,n));l=Xo(new Float32Array(16),n.globeMatrix,e),Xo(l,n.projMatrix,l)}const c=e.useProgram("debug",null,a),u=t.getTileByID(i.key);e.terrain&&e.terrain.setupElevationDraw(u,c);const h=DepthMode.disabled,d=StencilMode.disabled,p=e.colorModeForRenderPass(),f="$debug";r.activeTexture.set(o.TEXTURE0),e.emptyTexture.bind(o.LINEAR,o.CLAMP_TO_EDGE),s?u._makeGlobeTileDebugBuffers(e.context,n):u._makeDebugTileBoundsBuffers(e.context,n.projection);const m=u._tileDebugBuffer||e.debugBuffer,_=u._tileDebugIndexBuffer||e.debugIndexBuffer,g=u._tileDebugSegments||e.debugSegments;c.draw(r,o.LINE_STRIP,h,d,p,CullFaceMode.disabled,Ef(l,Wt.red),f,m,_,g,null,null,null,[u._globeTileDebugBorderBuffer]);const y=u.latestRawTileData,x=Math.floor((y&&y.byteLength||0)/1024),v=t.getTile(i).tileSize,b=512/Math.min(v,512)*(i.overscaledZ/n.zoom)*.5;let w=i.canonical.toString();i.overscaledZ!==i.canonical.z&&(w+=` => ${i.overscaledZ}`),w+=` ${x}kb`,function(e,t){e.initDebugOverlayCanvas();const i=e.debugOverlayCanvas,r=e.context.gl,n=e.debugOverlayCanvas.getContext("2d");n.clearRect(0,0,i.width,i.height),n.shadowColor="white",n.shadowBlur=2,n.lineWidth=1.5,n.strokeStyle="white",n.textBaseline="top",n.font="bold 36px Open Sans, sans-serif",n.fillText(t,5,5),n.strokeText(t,5,5),e.debugOverlayTexture.update(i),e.debugOverlayTexture.bind(r.LINEAR,r.CLAMP_TO_EDGE)}(e,w);const E=u._tileDebugTextBuffer||e.debugBuffer,T=u._tileDebugTextIndexBuffer||e.quadTriangleIndexBuffer,S=u._tileDebugTextSegments||e.debugSegments;c.draw(r,o.TRIANGLES,h,d,ColorMode.alphaBlended,CullFaceMode.disabled,Ef(l,Wt.transparent,b),f,E,T,S,null,null,null,[u._globeTileDebugTextBuffer])}function rm(e,t,i,r){om(e,0,t+i/2,e.transform.width,i,r)}function nm(e,t,i,r){om(e,t-i/2,0,i,e.transform.height,r)}function om(e,t,i,r,n,o){const s=e.context,a=s.gl;a.enable(a.SCISSOR_TEST),a.scissor(t*it.devicePixelRatio,i*it.devicePixelRatio,r*it.devicePixelRatio,n*it.devicePixelRatio),s.clear({color:o}),a.disable(a.SCISSOR_TEST)}const sm=po([{name:"a_pos_3f",components:3,type:"Float32"}]),{members:am}=sm;function lm(e,t,i,r){e.emplaceBack(t,i,r)}class SkyboxGeometry{constructor(e){this.vertexArray=new StructArrayLayout3f12,this.indices=new StructArrayLayout3ui6,lm(this.vertexArray,-1,-1,1),lm(this.vertexArray,1,-1,1),lm(this.vertexArray,-1,1,1),lm(this.vertexArray,1,1,1),lm(this.vertexArray,-1,-1,-1),lm(this.vertexArray,1,-1,-1),lm(this.vertexArray,-1,1,-1),lm(this.vertexArray,1,1,-1),this.indices.emplaceBack(5,1,3),this.indices.emplaceBack(3,7,5),this.indices.emplaceBack(6,2,0),this.indices.emplaceBack(0,4,6),this.indices.emplaceBack(2,6,7),this.indices.emplaceBack(7,3,2),this.indices.emplaceBack(5,4,0),this.indices.emplaceBack(0,1,5),this.indices.emplaceBack(0,2,3),this.indices.emplaceBack(3,1,0),this.indices.emplaceBack(7,6,4),this.indices.emplaceBack(4,5,7),this.vertexBuffer=e.createVertexBuffer(this.vertexArray,am),this.indexBuffer=e.createIndexBuffer(this.indices),this.segment=SegmentVector.simpleSegment(0,0,36,12)}}function cm(e,t,i,r,n,o){const s=e.gl,a=t.paint.get("sky-atmosphere-color"),l=t.paint.get("sky-atmosphere-halo-color"),c=t.paint.get("sky-atmosphere-sun-intensity"),u=((e,t,i,r,n)=>({u_matrix_3f:e,u_sun_direction:t,u_sun_intensity:i,u_color_tint_r:[r.r,r.g,r.b,r.a],u_color_tint_m:[n.r,n.g,n.b,n.a],u_luminance:5e-5}))(((h=Go())[0]=(d=r)[0],h[1]=d[1],h[2]=d[2],h[3]=d[4],h[4]=d[5],h[5]=d[6],h[6]=d[8],h[7]=d[9],h[8]=d[10],h),n,c,a,l);var h,d;s.framebufferTexture2D(s.FRAMEBUFFER,s.COLOR_ATTACHMENT0,s.TEXTURE_CUBE_MAP_POSITIVE_X+o,t.skyboxTexture,0),i.draw(e,s.TRIANGLES,DepthMode.disabled,StencilMode.disabled,ColorMode.unblended,CullFaceMode.frontCW,u,"skyboxCapture",t.skyboxGeometry.vertexBuffer,t.skyboxGeometry.indexBuffer,t.skyboxGeometry.segment)}const um=po([{type:"Float32",name:"a_pos",components:3},{type:"Float32",name:"a_uv",components:2}]);class AtmosphereBuffer{constructor(e){const t=new StructArrayLayout5f20;t.emplaceBack(-1,1,1,0,0),t.emplaceBack(1,1,1,1,0),t.emplaceBack(1,-1,1,1,1),t.emplaceBack(-1,-1,1,0,1);const i=new StructArrayLayout3ui6;i.emplaceBack(0,1,2),i.emplaceBack(2,3,0),this.vertexBuffer=e.createVertexBuffer(t,um.members),this.indexBuffer=e.createIndexBuffer(i),this.segments=SegmentVector.simpleSegment(0,0,4,2)}destroy(){this.vertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy()}}const hm={symbol:function(e,t,i,r,n){if("translucent"!==e.renderPass)return;const o=StencilMode.disabled,s=e.colorModeForRenderPass();i.layout.get("text-variable-anchor")&&function(e,t,i,r,n,o,s){const a=t.transform,l="map"===n,c="map"===o;for(const t of e){const e=r.getTile(t),n=e.getBucket(i);if(!n||!n.text||!n.text.segments.get().length)continue;const o=mu(n.textSizeData,a.zoom),u=hp(t,n.getProjection(),a),h=a.calculatePixelsToTileUnitsMatrix(e),d=Wd(u,e.tileID.canonical,c,l,a,n.getProjection(),h),p="none"!==i.layout.get("icon-text-fit")&&n.hasIconData();if(o){const i=Math.pow(2,a.zoom-e.tileID.overscaledZ);qf(n,l,c,s,_u,a,d,t,i,o,p)}}}(r,e,i,t,i.layout.get("text-rotation-alignment"),i.layout.get("text-pitch-alignment"),n),0!==i.paint.get("icon-opacity").constantOr(1)&&$f(e,t,i,r,!1,i.paint.get("icon-translate"),i.paint.get("icon-translate-anchor"),i.layout.get("icon-rotation-alignment"),i.layout.get("icon-pitch-alignment"),i.layout.get("icon-keep-upright"),o,s),0!==i.paint.get("text-opacity").constantOr(1)&&$f(e,t,i,r,!0,i.paint.get("text-translate"),i.paint.get("text-translate-anchor"),i.layout.get("text-rotation-alignment"),i.layout.get("text-pitch-alignment"),i.layout.get("text-keep-upright"),o,s),t.map.showCollisionBoxes&&(jf(e,t,i,r,i.paint.get("text-translate"),i.paint.get("text-translate-anchor"),!0),jf(e,t,i,r,i.paint.get("icon-translate"),i.paint.get("icon-translate-anchor"),!1))},circle:function(e,t,i,r){if("translucent"!==e.renderPass)return;const n=i.paint.get("circle-opacity"),o=i.paint.get("circle-stroke-width"),s=i.paint.get("circle-stroke-opacity"),a=void 0!==i.layout.get("circle-sort-key").constantOr(1);if(0===n.constantOr(1)&&(0===o.constantOr(1)||0===s.constantOr(1)))return;const l=e.context,c=l.gl,u=e.transform,h=e.depthModeForSublayer(0,DepthMode.ReadOnly),d=StencilMode.disabled,p=e.colorModeForRenderPass(),f="globe"===u.projection.name,m=[za(u.center.lng),ka(u.center.lat)],_=[];for(let n=0;n<r.length;n++){const o=r[n],s=t.getTile(o),l=s.getBucket(i);if(!l||l.projection.name!==u.projection.name)continue;const c=l.programConfigurations.get(i.id),h=bf(i);f&&h.push("PROJECTION_GLOBE_VIEW");const d=e.useProgram("circle",c,h),p=l.layoutVertexBuffer,g=l.globeExtVertexBuffer,y=l.indexBuffer,x=u.projection.createInversionMatrix(u,o.canonical),v={programConfiguration:c,program:d,layoutVertexBuffer:p,globeExtVertexBuffer:g,indexBuffer:y,uniformValues:vf(e,o,s,x,m,i),tile:s};if(a){const e=l.segments.get();for(const t of e)_.push({segments:new SegmentVector([t]),sortKey:t.sortKey,state:v})}else _.push({segments:l.segments,sortKey:0,state:v})}a&&_.sort(((e,t)=>e.sortKey-t.sortKey));const g={useDepthForOcclusion:!f};for(const t of _){const{programConfiguration:r,program:n,layoutVertexBuffer:o,globeExtVertexBuffer:s,indexBuffer:a,uniformValues:f,tile:m}=t.state,_=t.segments;e.terrain&&e.terrain.setupElevationDraw(m,n,g),e.prepareDrawProgram(l,n,m.tileID.toUnwrapped()),n.draw(l,c.TRIANGLES,h,d,p,CullFaceMode.disabled,f,i.id,o,a,_,i.paint,u.zoom,r,[s])}},heatmap:function(e,t,i,r){if(0!==i.paint.get("heatmap-opacity"))if("offscreen"===e.renderPass){const n=e.context,o=n.gl,s=StencilMode.disabled,a=new ColorMode([o.ONE,o.ONE],Wt.transparent,[!0,!0,!0,!0]);!function(e,t,i,r){const n=e.gl,o=t.width*r,s=t.height*r;e.activeTexture.set(n.TEXTURE1),e.viewport.set([0,0,o,s]);let a=i.heatmapFbo;if(!a||a&&(a.width!==o||a.height!==s)){a&&a.destroy();const t=n.createTexture();n.bindTexture(n.TEXTURE_2D,t),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_S,n.CLAMP_TO_EDGE),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_T,n.CLAMP_TO_EDGE),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MIN_FILTER,n.LINEAR),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MAG_FILTER,n.LINEAR),a=i.heatmapFbo=e.createFramebuffer(o,s,!1),function(e,t,i,r,n,o){const s=e.gl;s.texImage2D(s.TEXTURE_2D,0,e.isWebGL2&&e.extRenderToTextureHalfFloat?s.RGBA16F:s.RGBA,n,o,0,s.RGBA,e.extRenderToTextureHalfFloat?e.isWebGL2?s.HALF_FLOAT:e.extTextureHalfFloat.HALF_FLOAT_OES:s.UNSIGNED_BYTE,null),r.colorAttachment.set(i)}(e,0,t,a,o,s)}else n.bindTexture(n.TEXTURE_2D,a.colorAttachment.get()),e.bindFramebuffer.set(a.framebuffer)}(n,e,i,"globe"===e.transform.projection.name?.5:.25),n.clear({color:Wt.transparent});const l=e.transform,c="globe"===l.projection.name,u=c?["PROJECTION_GLOBE_VIEW"]:null,h=c?CullFaceMode.frontCCW:CullFaceMode.disabled,d=[za(l.center.lng),ka(l.center.lat)];for(let p=0;p<r.length;p++){const f=r[p];if(t.hasRenderableParent(f))continue;const m=t.getTile(f),_=m.getBucket(i);if(!_||_.projection.name!==l.projection.name)continue;const g=_.programConfigurations.get(i.id),y=e.useProgram("heatmap",g,u),{zoom:x}=e.transform;e.terrain&&e.terrain.setupElevationDraw(m,y),e.prepareDrawProgram(n,y,f.toUnwrapped());const v=l.projection.createInversionMatrix(l,f.canonical);y.draw(n,o.TRIANGLES,DepthMode.disabled,s,a,h,Sf(e,f,m,v,d,x,i.paint.get("heatmap-intensity")),i.id,_.layoutVertexBuffer,_.indexBuffer,_.segments,i.paint,e.transform.zoom,g,c?[_.globeExtVertexBuffer]:null)}n.viewport.set([0,0,e.width,e.height])}else"translucent"===e.renderPass&&(e.context.setColorMode(e.colorModeForRenderPass()),function(e,t){const i=e.context,r=i.gl,n=t.heatmapFbo;if(!n)return;i.activeTexture.set(r.TEXTURE0),r.bindTexture(r.TEXTURE_2D,n.colorAttachment.get()),i.activeTexture.set(r.TEXTURE1);let o=t.colorRampTexture;o||(o=t.colorRampTexture=new Texture(i,t.colorRamp,r.RGBA)),o.bind(r.LINEAR,r.CLAMP_TO_EDGE),e.useProgram("heatmapTexture").draw(i,r.TRIANGLES,DepthMode.disabled,StencilMode.disabled,e.colorModeForRenderPass(),CullFaceMode.disabled,((e,t,i,r)=>({u_image:0,u_color_ramp:1,u_opacity:t.paint.get("heatmap-opacity")}))(0,t),t.id,e.viewportBuffer,e.quadTriangleIndexBuffer,e.viewportSegments,t.paint,e.transform.zoom)}(e,i))},line:function(e,t,i,r){if("translucent"!==e.renderPass)return;const n=i.paint.get("line-opacity"),o=i.paint.get("line-width");if(0===n.constantOr(1)||0===o.constantOr(1))return;const s=e.depthModeForSublayer(0,DepthMode.ReadOnly),a=e.colorModeForRenderPass(),l=e.terrain&&e.terrain.renderingToTexture?1:it.devicePixelRatio,c=i.paint.get("line-dasharray"),u=c.constantOr(1),h=i.layout.get("line-cap"),d=i.paint.get("line-pattern"),p=d.constantOr(1),f=i.paint.get("line-gradient"),m=p?"linePattern":"line",_=e.context,g=_.gl,y=(e=>{const t=[];Pf(e)&&t.push("RENDER_LINE_DASH"),e.paint.get("line-gradient")&&t.push("RENDER_LINE_GRADIENT");const i=e.paint.get("line-trim-offset");0===i[0]&&0===i[1]||t.push("RENDER_LINE_TRIM_OFFSET");const r=e.paint.get("line-pattern").constantOr(1),n=1!==e.paint.get("line-opacity").constantOr(1);return!r&&n&&t.push("RENDER_LINE_ALPHA_DISCARD"),t})(i);let x=y.includes("RENDER_LINE_ALPHA_DISCARD");e.terrain&&e.terrain.clipOrMaskOverlapStencilType()&&(x=!1);for(const n of r){const r=t.getTile(n);if(p&&!r.patternsLoaded())continue;const o=r.getBucket(i);if(!o)continue;e.prepareDrawTile();const v=o.programConfigurations.get(i.id),b=e.useProgram(m,v,y),w=d.constantOr(null);if(w&&r.imageAtlas){const e=r.imageAtlas.patternPositions[w.toString()];e&&v.setConstantPatternPositions(e)}const E=c.constantOr(null),T=h.constantOr(null);if(!p&&E&&T&&r.lineAtlas){const e=r.lineAtlas.getDash(E,T);e&&v.setConstantPatternPositions(e)}let[S,A]=i.paint.get("line-trim-offset");if("round"===T||"square"===T){const e=1;S!==A&&(0===S&&(S-=e),1===A&&(A+=e))}const C=e.terrain?n.projMatrix:null,I=p?Cf(e,r,i,C,l):Af(e,r,i,C,o.lineClipsArray.length,l,[S,A]);if(f){const r=o.gradients[i.id];let s=r.texture;if(i.gradientVersion!==r.version){let a=256;if(i.stepInterpolant){const i=t.getSource().maxzoom,r=n.canonical.z===i?Math.ceil(1<<e.transform.maxZoom-n.canonical.z):1;a=M(U(o.maxLineLength/Uo*1024*r),256,_.maxTextureSize)}r.gradient=Tl({expression:i.gradientExpression(),evaluationKey:"lineProgress",resolution:a,image:r.gradient||void 0,clips:o.lineClipsArray}),r.texture?r.texture.update(r.gradient):r.texture=new Texture(_,r.gradient,g.RGBA),r.version=i.gradientVersion,s=r.texture}_.activeTexture.set(g.TEXTURE1),s.bind(i.stepInterpolant?g.NEAREST:g.LINEAR,g.CLAMP_TO_EDGE)}u&&(_.activeTexture.set(g.TEXTURE0),r.lineAtlasTexture.bind(g.LINEAR,g.REPEAT),v.updatePaintBuffers()),p&&(_.activeTexture.set(g.TEXTURE0),r.imageAtlasTexture.bind(g.LINEAR,g.CLAMP_TO_EDGE),v.updatePaintBuffers()),e.prepareDrawProgram(_,b,n.toUnwrapped());const P=t=>{b.draw(_,g.TRIANGLES,s,t,a,CullFaceMode.disabled,I,i.id,o.layoutVertexBuffer,o.indexBuffer,o.segments,i.paint,e.transform.zoom,v,[o.layoutVertexBuffer2])};if(x){const t=e.stencilModeForClipping(n).ref;0===t&&e.terrain&&_.clear({stencil:0});const i={func:g.EQUAL,mask:255};I.u_alpha_discard_threshold=.8,P(new StencilMode(i,t,255,g.KEEP,g.KEEP,g.INVERT)),I.u_alpha_discard_threshold=0,P(new StencilMode(i,t,255,g.KEEP,g.KEEP,g.KEEP))}else P(e.stencilModeForClipping(n))}x&&(e.resetStencilClippingMasks(),e.terrain&&_.clear({stencil:0}))},fill:function(e,t,i,r){const n=i.paint.get("fill-color"),o=i.paint.get("fill-opacity");if(0===o.constantOr(1))return;const s=e.colorModeForRenderPass(),a=i.paint.get("fill-pattern"),l=e.opaquePassEnabledForLayer()&&!a.constantOr(1)&&1===n.constantOr(Wt.transparent).a&&1===o.constantOr(0)?"opaque":"translucent";if(e.renderPass===l){const n=e.depthModeForSublayer(1,"opaque"===e.renderPass?DepthMode.ReadWrite:DepthMode.ReadOnly);Hf(e,t,i,r,n,s,!1)}if("translucent"===e.renderPass&&i.paint.get("fill-antialias")){const n=e.depthModeForSublayer(i.getPaintProperty("fill-outline-color")?2:0,DepthMode.ReadOnly);Hf(e,t,i,r,n,s,!0)}},"fill-extrusion":function(e,t,i,r){const n=i.paint.get("fill-extrusion-opacity");if(0!==n&&"translucent"===e.renderPass){const o=new DepthMode(e.context.gl.LEQUAL,DepthMode.ReadWrite,e.depthRangeFor3D);if(1!==n||i.paint.get("fill-extrusion-pattern").constantOr(1))Xf(e,t,i,r,o,StencilMode.disabled,ColorMode.disabled),Xf(e,t,i,r,o,e.stencilModeFor3D(),e.colorModeForRenderPass()),e.resetStencilClippingMasks();else{const n=e.colorModeForRenderPass();Xf(e,t,i,r,o,StencilMode.disabled,n)}}},hillshade:function(e,t,i,r){if("offscreen"!==e.renderPass&&"translucent"!==e.renderPass)return;const n=e.context,o=e.depthModeForSublayer(0,DepthMode.ReadOnly),s=e.colorModeForRenderPass(),a=e.terrain&&e.terrain.renderingToTexture,[l,c]="translucent"!==e.renderPass||a?[{},r]:e.stencilConfigForOverlap(r);for(const r of c){const n=t.getTile(r);if(n.needsHillshadePrepare&&"offscreen"===e.renderPass)Qp(e,n,i,o,StencilMode.disabled,s);else if("translucent"===e.renderPass){const t=a&&e.terrain?e.terrain.stencilModeForRTTOverlap(r):l[r.overscaledZ];Jp(e,r,n,i,o,t,s)}}n.viewport.set([0,0,e.width,e.height]),e.resetStencilClippingMasks()},raster:function(e,t,i,r,n,o){if("translucent"!==e.renderPass)return;if(0===i.paint.get("raster-opacity"))return;if(!r.length)return;const s=e.context,a=s.gl,l=t.getSource(),c=e.useProgram("raster"),u=e.colorModeForRenderPass(),h=e.terrain&&e.terrain.renderingToTexture,[d,p]=l instanceof ImageSource||h?[{},r]:e.stencilConfigForOverlap(r),f=p[p.length-1].overscaledZ,m=!e.options.moving;for(const r of p){const n=h?DepthMode.disabled:e.depthModeForSublayer(r.overscaledZ-f,1===i.paint.get("raster-opacity")?DepthMode.ReadWrite:DepthMode.ReadOnly,a.LESS),p=r.toUnwrapped(),_=t.getTile(r);if(h&&(!_||!_.hasData()))continue;const g=h?r.projMatrix:e.transform.calculateProjMatrix(p,m),y=e.terrain&&h?e.terrain.stencilModeForRTTOverlap(r):d[r.overscaledZ],x=o?0:i.paint.get("raster-fade-duration");_.registerFadeDuration(x);const v=t.findLoadedParent(r,0),b=uf(_,v,t,e.transform,x);let w,E;e.terrain&&e.terrain.prepareDrawTile();const T="nearest"===i.paint.get("raster-resampling")?a.NEAREST:a.LINEAR;s.activeTexture.set(a.TEXTURE0),_.texture.bind(T,a.CLAMP_TO_EDGE),s.activeTexture.set(a.TEXTURE1),v?(v.texture.bind(T,a.CLAMP_TO_EDGE),w=Math.pow(2,v.tileID.overscaledZ-_.tileID.overscaledZ),E=[_.tileID.canonical.x*w%1,_.tileID.canonical.y*w%1]):_.texture.bind(T,a.CLAMP_TO_EDGE),_.texture.useMipmap&&s.extTextureFilterAnisotropic&&e.transform.pitch>20&&a.texParameterf(a.TEXTURE_2D,s.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,s.extTextureFilterAnisotropicMax);const S=Df(g,E||[0,0],w||1,b,i,l instanceof ImageSource?l.perspectiveTransform:[0,0]);if(e.prepareDrawProgram(s,c,p),l instanceof ImageSource)l.boundsBuffer&&l.boundsSegments&&c.draw(s,a.TRIANGLES,n,StencilMode.disabled,u,CullFaceMode.disabled,S,i.id,l.boundsBuffer,e.quadTriangleIndexBuffer,l.boundsSegments);else{const{tileBoundsBuffer:t,tileBoundsIndexBuffer:r,tileBoundsSegments:o}=e.getTileBoundsBuffers(_);c.draw(s,a.TRIANGLES,n,y,u,CullFaceMode.disabled,S,i.id,t,r,o)}}e.resetStencilClippingMasks()},background:function(e,t,i,r){const n=i.paint.get("background-color"),o=i.paint.get("background-opacity");if(0===o)return;const s=e.context,a=s.gl,l=e.transform,c=l.tileSize,u=i.paint.get("background-pattern");if(e.isPatternMissing(u))return;const h=!u&&1===n.a&&1===o&&e.opaquePassEnabledForLayer()?"opaque":"translucent";if(e.renderPass!==h)return;const d=StencilMode.disabled,p=e.depthModeForSublayer(0,"opaque"===h?DepthMode.ReadWrite:DepthMode.ReadOnly),f=e.colorModeForRenderPass(),m=e.useProgram(u?"backgroundPattern":"background");let _,g=r;g||(_=e.getBackgroundTiles(),g=Object.values(_).map((e=>e.tileID))),u&&(s.activeTexture.set(a.TEXTURE0),e.imageManager.bind(e.context));for(const h of g){const g=h.toUnwrapped(),y=r?h.projMatrix:e.transform.calculateProjMatrix(g);e.prepareDrawTile();const x=t?t.getTile(h):_?_[h.key]:new Tile(h,c,l.zoom,e),v=u?Of(y,o,e,u,{tileID:h,tileSize:c}):Ff(y,o,n);e.prepareDrawProgram(s,m,g);const{tileBoundsBuffer:b,tileBoundsIndexBuffer:w,tileBoundsSegments:E}=e.getTileBoundsBuffers(x);m.draw(s,a.TRIANGLES,p,d,f,CullFaceMode.disabled,v,i.id,b,w,E)}},sky:function(e,t,i){const r=e.transform,n="mercator"===r.projection.name||"globe"===r.projection.name?1:P(7,8,r.zoom),o=i.paint.get("sky-opacity")*n;if(0===o)return;const s=e.context,a=i.paint.get("sky-type"),l=new DepthMode(s.gl.LEQUAL,DepthMode.ReadOnly,[0,1]),c=e.frameCounter/1e3%1;"atmosphere"===a?"offscreen"===e.renderPass?i.needsSkyboxCapture(e)&&(function(e,t,i,r){const n=e.context,o=n.gl;let s=t.skyboxFbo;if(!s){s=t.skyboxFbo=n.createFramebuffer(32,32,!1),t.skyboxGeometry=new SkyboxGeometry(n),t.skyboxTexture=n.gl.createTexture(),o.bindTexture(o.TEXTURE_CUBE_MAP,t.skyboxTexture),o.texParameteri(o.TEXTURE_CUBE_MAP,o.TEXTURE_WRAP_S,o.CLAMP_TO_EDGE),o.texParameteri(o.TEXTURE_CUBE_MAP,o.TEXTURE_WRAP_T,o.CLAMP_TO_EDGE),o.texParameteri(o.TEXTURE_CUBE_MAP,o.TEXTURE_MIN_FILTER,o.LINEAR),o.texParameteri(o.TEXTURE_CUBE_MAP,o.TEXTURE_MAG_FILTER,o.LINEAR);for(let e=0;e<6;++e)o.texImage2D(o.TEXTURE_CUBE_MAP_POSITIVE_X+e,0,o.RGBA,32,32,0,o.RGBA,o.UNSIGNED_BYTE,null)}n.bindFramebuffer.set(s.framebuffer),n.viewport.set([0,0,32,32]);const a=t.getCenter(e,!0),l=e.useProgram("skyboxCapture"),c=new Float64Array(16);Wo(c),Qo(c,c,.5*-Math.PI),cm(n,t,l,c,a,0),Wo(c),Qo(c,c,.5*Math.PI),cm(n,t,l,c,a,1),Wo(c),Yo(c,c,.5*-Math.PI),cm(n,t,l,c,a,2),Wo(c),Yo(c,c,.5*Math.PI),cm(n,t,l,c,a,3),Wo(c),cm(n,t,l,c,a,4),Wo(c),Qo(c,c,Math.PI),cm(n,t,l,c,a,5),n.viewport.set([0,0,e.width,e.height])}(e,i),i.markSkyboxValid(e)):"sky"===e.renderPass&&function(e,t,i,r,n){const o=e.context,s=o.gl,a=e.transform,l=e.useProgram("skybox");o.activeTexture.set(s.TEXTURE0),s.bindTexture(s.TEXTURE_CUBE_MAP,t.skyboxTexture);const c=((e,t,i,r,n)=>({u_matrix:e,u_sun_direction:t,u_cubemap:0,u_opacity:r,u_temporal_offset:n}))(a.skyboxMatrix,t.getCenter(e,!1),0,r,n);e.prepareDrawProgram(o,l),l.draw(o,s.TRIANGLES,i,StencilMode.disabled,e.colorModeForRenderPass(),CullFaceMode.backCW,c,"skybox",t.skyboxGeometry.vertexBuffer,t.skyboxGeometry.indexBuffer,t.skyboxGeometry.segment)}(e,i,l,o,c):"gradient"===a&&"sky"===e.renderPass&&function(e,t,i,r,n){const o=e.context,s=o.gl,a=e.transform,l=e.useProgram("skyboxGradient");t.skyboxGeometry||(t.skyboxGeometry=new SkyboxGeometry(o)),o.activeTexture.set(s.TEXTURE0);let c=t.colorRampTexture;c||(c=t.colorRampTexture=new Texture(o,t.colorRamp,s.RGBA)),c.bind(s.LINEAR,s.CLAMP_TO_EDGE);const u=((e,t,i,r,n)=>({u_matrix:e,u_color_ramp:0,u_center_direction:t,u_radius:b(i),u_opacity:r,u_temporal_offset:n}))(a.skyboxMatrix,t.getCenter(e,!1),t.paint.get("sky-gradient-radius"),r,n);e.prepareDrawProgram(o,l),l.draw(o,s.TRIANGLES,i,StencilMode.disabled,e.colorModeForRenderPass(),CullFaceMode.backCW,u,"skyboxGradient",t.skyboxGeometry.vertexBuffer,t.skyboxGeometry.indexBuffer,t.skyboxGeometry.segment)}(e,i,l,o,c)},debug:function(e,t,i){for(let r=0;r<i.length;r++)im(e,t,i[r])},custom:function(e,t,i,r){const n=e.context,o=i.implementation;if(!e.transform.projection.unsupportedLayers||!e.transform.projection.unsupportedLayers.includes("custom")||e.terrain&&(e.terrain.renderingToTexture||"offscreen"===e.renderPass)&&i.isLayerDraped()){if("offscreen"===e.renderPass){const t=o.prerender;if(t){if(e.setCustomLayerDefaults(),n.setColorMode(e.colorModeForRenderPass()),"globe"===e.transform.projection.name){const i=e.transform.pointMerc;t.call(o,n.gl,e.transform.customLayerMatrix(),e.transform.getProjection(),e.transform.globeToMercatorMatrix(),ga(e.transform.zoom),[i.x,i.y],e.transform.pixelsPerMeterRatio)}else t.call(o,n.gl,e.transform.customLayerMatrix());n.setDirty(),e.setBaseState()}}else if("translucent"===e.renderPass){if(e.terrain&&e.terrain.renderingToTexture){const t=o.renderToTile;if(t){const i=r[0].canonical,s=new MercatorCoordinate(i.x+r[0].wrap*(1<<i.z),i.y,i.z);n.setDepthMode(DepthMode.disabled),n.setStencilMode(StencilMode.disabled),n.setColorMode(e.colorModeForRenderPass()),e.setCustomLayerDefaults(),t.call(o,n.gl,s),n.setDirty(),e.setBaseState()}return}e.setCustomLayerDefaults(),n.setColorMode(e.colorModeForRenderPass()),n.setStencilMode(StencilMode.disabled);const t="3d"===o.renderingMode?new DepthMode(e.context.gl.LEQUAL,DepthMode.ReadWrite,e.depthRangeFor3D):e.depthModeForSublayer(0,DepthMode.ReadOnly);if(n.setDepthMode(t),"globe"===e.transform.projection.name){const t=e.transform.pointMerc;o.render(n.gl,e.transform.customLayerMatrix(),e.transform.getProjection(),e.transform.globeToMercatorMatrix(),ga(e.transform.zoom),[t.x,t.y],e.transform.pixelsPerMeterRatio)}else o.render(n.gl,e.transform.customLayerMatrix());n.setDirty(),e.setBaseState(),n.bindFramebuffer.set(null)}}else H("Custom layers are not yet supported with this projection. Use mercator or globe to enable usage of custom layers.")}};class Painter{constructor(e,t,i=!1){this.context=new Context(e,i),this.transform=t,this._tileTextures={},this.frameCopies=[],this.loadTimeStamps=[],this.setup(),this.numSublayers=SourceCache.maxUnderzooming+SourceCache.maxOverzooming+1,this.depthEpsilon=1/Math.pow(2,16),this.deferredRenderGpuTimeQueries=[],this.gpuTimers={},this.frameCounter=0,this._backgroundTiles={}}updateTerrain(e,t){const i=!!e&&!!e.terrain&&this.transform.projection.supportsTerrain;if(!(i||this._terrain&&this._terrain.enabled))return;this._terrain||(this._terrain=new Terrain(this,e));const r=this._terrain;this.transform.elevation=i?r:null,r.update(e,this.transform,t)}_updateFog(e){const t=e.fog;if(!t||"globe"===this.transform.projection.name||t.getOpacity(this.transform.pitch)<1||t.properties.get("horizon-blend")<.03)return void(this.transform.fogCullDistSq=null);const[i,r]=t.getFovAdjustedRange(this.transform._fov);if(i>r)return void(this.transform.fogCullDistSq=null);const n=i+.78*(r-i);this.transform.fogCullDistSq=n*n}get terrain(){return this.transform._terrainEnabled()&&this._terrain&&this._terrain.enabled?this._terrain:null}resize(e,t){if(this.width=e*it.devicePixelRatio,this.height=t*it.devicePixelRatio,this.context.viewport.set([0,0,this.width,this.height]),this.style)for(const e of this.style.order)this.style._layers[e].resize()}setup(){const t=this.context,i=new StructArrayLayout2i4;i.emplaceBack(0,0),i.emplaceBack(Uo,0),i.emplaceBack(0,Uo),i.emplaceBack(Uo,Uo),this.tileExtentBuffer=t.createVertexBuffer(i,Ns.members),this.tileExtentSegments=SegmentVector.simpleSegment(0,0,4,2);const r=new StructArrayLayout2i4;r.emplaceBack(0,0),r.emplaceBack(Uo,0),r.emplaceBack(0,Uo),r.emplaceBack(Uo,Uo),this.debugBuffer=t.createVertexBuffer(r,Ns.members),this.debugSegments=SegmentVector.simpleSegment(0,0,4,5);const n=new StructArrayLayout2i4;n.emplaceBack(-1,-1),n.emplaceBack(1,-1),n.emplaceBack(-1,1),n.emplaceBack(1,1),this.viewportBuffer=t.createVertexBuffer(n,Ns.members),this.viewportSegments=SegmentVector.simpleSegment(0,0,4,2);const o=new StructArrayLayout4i8;o.emplaceBack(0,0,0,0),o.emplaceBack(Uo,0,Uo,0),o.emplaceBack(0,Uo,0,Uo),o.emplaceBack(Uo,Uo,Uo,Uo),this.mercatorBoundsBuffer=t.createVertexBuffer(o,ed.members),this.mercatorBoundsSegments=SegmentVector.simpleSegment(0,0,4,2);const s=new StructArrayLayout3ui6;s.emplaceBack(0,1,2),s.emplaceBack(2,1,3),this.quadTriangleIndexBuffer=t.createIndexBuffer(s);const a=new StructArrayLayout1ui2;for(const e of[0,1,3,2,0])a.emplaceBack(e);this.debugIndexBuffer=t.createIndexBuffer(a),this.emptyTexture=new Texture(t,new RGBAImage({width:1,height:1},Uint8Array.of(0,0,0,0)),t.gl.RGBA),this.identityMat=$o();const l=this.context.gl;this.stencilClearMode=new StencilMode({func:l.ALWAYS,mask:0},0,255,l.ZERO,l.ZERO,l.ZERO),this.loadTimeStamps.push(e.performance.now()),this.atmosphereBuffer=new AtmosphereBuffer(this.context)}getMercatorTileBoundsBuffers(){return{tileBoundsBuffer:this.mercatorBoundsBuffer,tileBoundsIndexBuffer:this.quadTriangleIndexBuffer,tileBoundsSegments:this.mercatorBoundsSegments}}getTileBoundsBuffers(e){return e._makeTileBoundsBuffers(this.context,this.transform.projection),e._tileBoundsBuffer?{tileBoundsBuffer:e._tileBoundsBuffer,tileBoundsIndexBuffer:e._tileBoundsIndexBuffer,tileBoundsSegments:e._tileBoundsSegments}:this.getMercatorTileBoundsBuffers()}clearStencil(){const e=this.context,t=e.gl;this.nextStencilID=1,this.currentStencilSource=void 0,this._tileClippingMaskIDs={},this.useProgram("clippingMask").draw(e,t.TRIANGLES,DepthMode.disabled,this.stencilClearMode,ColorMode.disabled,CullFaceMode.disabled,cf(this.identityMat),"$clipping",this.viewportBuffer,this.quadTriangleIndexBuffer,this.viewportSegments)}resetStencilClippingMasks(){this.terrain||(this.currentStencilSource=void 0,this._tileClippingMaskIDs={})}_renderTileClippingMasks(e,t,i){if(!t||this.currentStencilSource===t.id||!e.isTileClipped()||!i||0===i.length)return;if(this._tileClippingMaskIDs&&!this.terrain){let e=!1;for(const t of i)if(void 0===this._tileClippingMaskIDs[t.key]){e=!0;break}if(!e)return}this.currentStencilSource=t.id;const r=this.context,n=r.gl;this.nextStencilID+i.length>256&&this.clearStencil(),r.setColorMode(ColorMode.disabled),r.setDepthMode(DepthMode.disabled);const o=this.useProgram("clippingMask");this._tileClippingMaskIDs={};for(const e of i){const i=t.getTile(e),s=this._tileClippingMaskIDs[e.key]=this.nextStencilID++,{tileBoundsBuffer:a,tileBoundsIndexBuffer:l,tileBoundsSegments:c}=this.getTileBoundsBuffers(i);o.draw(r,n.TRIANGLES,DepthMode.disabled,new StencilMode({func:n.ALWAYS,mask:0},s,255,n.KEEP,n.KEEP,n.REPLACE),ColorMode.disabled,CullFaceMode.disabled,cf(e.projMatrix),"$clipping",a,l,c)}}stencilModeFor3D(){this.currentStencilSource=void 0,this.nextStencilID+1>256&&this.clearStencil();const e=this.nextStencilID++,t=this.context.gl;return new StencilMode({func:t.NOTEQUAL,mask:255},e,255,t.KEEP,t.KEEP,t.REPLACE)}stencilModeForClipping(e){if(this.terrain)return this.terrain.stencilModeForRTTOverlap(e);const t=this.context.gl;return new StencilMode({func:t.EQUAL,mask:255},this._tileClippingMaskIDs[e.key],0,t.KEEP,t.KEEP,t.REPLACE)}stencilConfigForOverlap(e){const t=this.context.gl,i=e.sort(((e,t)=>t.overscaledZ-e.overscaledZ)),r=i[i.length-1].overscaledZ,n=i[0].overscaledZ-r+1;if(n>1){this.currentStencilSource=void 0,this.nextStencilID+n>256&&this.clearStencil();const e={};for(let i=0;i<n;i++)e[i+r]=new StencilMode({func:t.GEQUAL,mask:255},i+this.nextStencilID,255,t.KEEP,t.KEEP,t.REPLACE);return this.nextStencilID+=n,[e,i]}return[{[r]:StencilMode.disabled},i]}colorModeForRenderPass(){const e=this.context.gl;if(this._showOverdrawInspector){const t=1/8;return new ColorMode([e.CONSTANT_COLOR,e.ONE],new Wt(t,t,t,0),[!0,!0,!0,!0])}return"opaque"===this.renderPass?ColorMode.unblended:ColorMode.alphaBlended}depthModeForSublayer(e,t,i){if(!this.opaquePassEnabledForLayer())return DepthMode.disabled;const r=1-((1+this.currentLayer)*this.numSublayers+e)*this.depthEpsilon;return new DepthMode(i||this.context.gl.LEQUAL,t,[r,r])}opaquePassEnabledForLayer(){return this.currentLayer<this.opaquePassCutoff}render(t,i){this.style=t,this.options=i,this.imageManager=t.imageManager,this.glyphManager=t.glyphManager,this.symbolFadeChange=t.placement.symbolFadeChange(it.now()),this.imageManager.beginFrame();const r=this.style.order,n=this.style._sourceCaches;for(const e in n){const t=n[e];t.used&&t.prepare(this.context)}const o={},s={},a={};for(const e in n){const t=n[e];o[e]=t.getVisibleCoordinates(),s[e]=o[e].slice().reverse(),a[e]=t.getVisibleCoordinates(!0).reverse()}this.opaquePassCutoff=1/0;for(let e=0;e<r.length;e++)if(this.style._layers[r[e]].is3D()){this.opaquePassCutoff=e;break}if(this.terrain&&(this.terrain.updateTileBinding(a),this.opaquePassCutoff=0),"globe"!==this.transform.projection.name||this.globeSharedBuffers||(this.globeSharedBuffers=new GlobeSharedBuffers(this.context)),!qe.has(this.context.gl))return;this.renderPass="offscreen";for(const e of r){const i=this.style._layers[e],r=t._getLayerSourceCache(i);if(!i.hasOffscreenPass()||i.isHidden(this.transform.zoom))continue;const n=r?s[r.id]:void 0;("custom"===i.type||i.isSky()||n&&n.length)&&this.renderLayer(this,r,i,n)}this.depthRangeFor3D=[0,1-(t.order.length+2)*this.numSublayers*this.depthEpsilon];const l=this.terrain;if(l&&(this.style.hasSymbolLayers()||this.style.hasCircleLayers())&&l.drawDepth(),this.context.bindFramebuffer.set(null),this.context.viewport.set([0,0,this.width,this.height]),this.context.clear({color:i.showOverdrawInspector?Wt.black:Wt.transparent,depth:1}),this.clearStencil(),this._showOverdrawInspector=i.showOverdrawInspector,this.renderPass="opaque",!this.terrain)for(this.currentLayer=r.length-1;this.currentLayer>=0;this.currentLayer--){const e=this.style._layers[r[this.currentLayer]],i=t._getLayerSourceCache(e);if(e.isSky())continue;const n=i?s[i.id]:void 0;this._renderTileClippingMasks(e,i,n),this.renderLayer(this,i,e,n)}if(this.style.fog&&this.transform.projection.supportsFog&&function(e,t){const i=e.context,r=i.gl,n=e.transform,o=new DepthMode(r.LEQUAL,DepthMode.ReadOnly,[0,1]),s=e.useProgram("globeAtmosphere",null,"globe"===n.projection.name?["PROJECTION_GLOBE_VIEW","FOG"]:["FOG"]),a=ga(n.zoom),l=t.properties.get("color").toArray01(),c=t.properties.get("high-color").toArray01(),u=t.properties.get("space-color").toArray01PremultipliedAlpha(),h=Ls([]);Rs(h,h,-b(n._center.lng)),Bs(h,h,b(n._center.lat)),Fs(h,h,n.angle),Bs(h,h,-n._pitch);const d=rs(new Float32Array(16),h),p=$(t.properties.get("star-intensity"),0,1,0,.25),f=5e-4,m=$(t.properties.get("horizon-blend"),0,1,f,.25),_=xa(e,i,n)&&m===f?n.worldSize/(2*Math.PI*1.025)-1:n.globeRadius,g=e.frameCounter/1e3%1,y=cs(n.globeCenterInViewSpace),x=Math.sqrt(Math.pow(y,2)-Math.pow(_,2)),v=Math.acos(x/y),w=((e,t,i,r,n,o,s,a,l,c,u,h,d,p)=>({u_frustum_tl:e,u_frustum_tr:t,u_frustum_br:i,u_frustum_bl:r,u_horizon:n,u_transition:o,u_fadeout_range:s,u_color:a,u_high_color:l,u_space_color:c,u_star_intensity:u,u_star_size:5*it.devicePixelRatio,u_star_density:0,u_temporal_offset:h,u_horizon_angle:d,u_rotation_matrix:p}))(n.frustumCorners.TL,n.frustumCorners.TR,n.frustumCorners.BR,n.frustumCorners.BL,n.frustumCorners.horizon,a,m,l,c,u,p,g,v,d);e.prepareDrawProgram(i,s);const E=e.atmosphereBuffer;E&&s.draw(i,r.TRIANGLES,o,StencilMode.disabled,ColorMode.alphaBlended,CullFaceMode.backCW,w,"skybox",E.vertexBuffer,E.indexBuffer,E.segments)}(this,this.style.fog),this.renderPass="sky",(ga(this.transform.zoom)>0||"globe"!==this.transform.projection.name)&&this.transform.isHorizonVisible())for(this.currentLayer=0;this.currentLayer<r.length;this.currentLayer++){const e=this.style._layers[r[this.currentLayer]],i=t._getLayerSourceCache(e);e.isSky()&&this.renderLayer(this,i,e,i?s[i.id]:void 0)}for(this.renderPass="translucent",this.currentLayer=0;this.currentLayer<r.length;){const e=this.style._layers[r[this.currentLayer]],i=t._getLayerSourceCache(e);if(e.isSky()){++this.currentLayer;continue}if(this.terrain&&this.style.isLayerDraped(e)){if(e.isHidden(this.transform.zoom)){++this.currentLayer;continue}this.currentLayer=this.terrain.renderBatch(this.currentLayer);continue}const n=i?("symbol"===e.type?a:s)[i.id]:void 0;this._renderTileClippingMasks(e,i,i?o[i.id]:void 0),this.renderLayer(this,i,e,n),++this.currentLayer}if(this.terrain&&this.terrain.postRender(),this.options.showTileBoundaries||this.options.showQueryGeometry||this.options.showTileAABBs){let e=null;k(this.style._layers).forEach((i=>{const r=t._getLayerSourceCache(i);r&&!i.isHidden(this.transform.zoom)&&(!e||e.getSource().maxzoom<r.getSource().maxzoom)&&(e=r)})),e&&this.options.showTileBoundaries&&hm.debug(this,e,e.getVisibleCoordinates())}this.options.showPadding&&function(e){const t=e.transform.padding;rm(e,e.transform.height-(t.top||0),3,Jf),rm(e,t.bottom||0,3,Yf),nm(e,t.left||0,3,Qf),nm(e,e.transform.width-(t.right||0),3,em);const i=e.transform.centerPoint;!function(e,t,i,r){om(e,t-1,i-10,2,20,r),om(e,t-10,i-1,20,2,r)}(e,i.x,e.transform.height-i.y,tm)}(this),this.context.setDefault(),this.frameCounter=(this.frameCounter+1)%Number.MAX_SAFE_INTEGER,this.tileLoaded&&this.options.speedIndexTiming&&(this.loadTimeStamps.push(e.performance.now()),this.saveCanvasCopy())}renderLayer(e,t,i,r){i.isHidden(this.transform.zoom)||("background"===i.type||"sky"===i.type||"custom"===i.type||r&&r.length)&&(this.id=i.id,this.gpuTimingStart(i),(!e.transform.projection.unsupportedLayers||!e.transform.projection.unsupportedLayers.includes(i.type)||e.terrain&&"custom"===i.type)&&hm[i.type](e,t,i,r,this.style.placement.variableOffsets,this.options.isInitialLoad),this.gpuTimingEnd())}gpuTimingStart(e){if(!this.options.gpuTiming)return;const t=this.context.extTimerQuery;let i=this.gpuTimers[e.id];i||(i=this.gpuTimers[e.id]={calls:0,cpuTime:0,query:t.createQueryEXT()}),i.calls++,t.beginQueryEXT(t.TIME_ELAPSED_EXT,i.query)}gpuTimingDeferredRenderStart(){if(this.options.gpuTimingDeferredRender){const e=this.context.extTimerQuery,t=e.createQueryEXT();this.deferredRenderGpuTimeQueries.push(t),e.beginQueryEXT(e.TIME_ELAPSED_EXT,t)}}gpuTimingDeferredRenderEnd(){if(!this.options.gpuTimingDeferredRender)return;const e=this.context.extTimerQuery;e.endQueryEXT(e.TIME_ELAPSED_EXT)}gpuTimingEnd(){if(!this.options.gpuTiming)return;const e=this.context.extTimerQuery;e.endQueryEXT(e.TIME_ELAPSED_EXT)}collectGpuTimers(){const e=this.gpuTimers;return this.gpuTimers={},e}collectDeferredRenderGpuQueries(){const e=this.deferredRenderGpuTimeQueries;return this.deferredRenderGpuTimeQueries=[],e}queryGpuTimers(e){const t={};for(const i in e){const r=e[i],n=this.context.extTimerQuery,o=n.getQueryObjectEXT(r.query,n.QUERY_RESULT_EXT)/1e6;n.deleteQueryEXT(r.query),t[i]=o}return t}queryGpuTimeDeferredRender(e){if(!this.options.gpuTimingDeferredRender)return 0;const t=this.context.extTimerQuery;let i=0;for(const r of e)i+=t.getQueryObjectEXT(r,t.QUERY_RESULT_EXT)/1e6,t.deleteQueryEXT(r);return i}translatePosMatrix(e,t,i,r,n){if(!i[0]&&!i[1])return e;const o=n?"map"===r?this.transform.angle:0:"viewport"===r?-this.transform.angle:0;if(o){const e=Math.sin(o),t=Math.cos(o);i=[i[0]*t-i[1]*e,i[0]*e+i[1]*t]}const s=[n?i[0]:jh(t,i[0],this.transform.zoom),n?i[1]:jh(t,i[1],this.transform.zoom),0],a=new Float32Array(16);return Ko(a,e,s),a}saveTileTexture(e){const t=this._tileTextures[e.size[0]];t?t.push(e):this._tileTextures[e.size[0]]=[e]}getTileTexture(e){const t=this._tileTextures[e];return t&&t.length>0?t.pop():null}isPatternMissing(e){return null===e||void 0!==e&&!this.imageManager.getPattern(e.toString())}terrainRenderModeElevated(){return this.style&&!!this.style.getTerrain()&&!!this.terrain&&!this.terrain.renderingToTexture}currentGlobalDefines(){const e=this.terrain&&this.terrain.renderingToTexture,t=this.terrain&&0===this.terrain.exaggeration(),i=this.style&&this.style.fog,r=[];return this.terrainRenderModeElevated()&&r.push("TERRAIN"),"globe"===this.transform.projection.name&&r.push("GLOBE"),t&&r.push("ZERO_EXAGGERATION"),i&&!e&&0!==i.getOpacity(this.transform.pitch)&&r.push("FOG"),e&&r.push("RENDER_TO_TEXTURE"),this._showOverdrawInspector&&r.push("OVERDRAW_INSPECTOR"),r}useProgram(e,t,i){this.cache=this.cache||{};const r=i||[],n=this.currentGlobalDefines().concat(r),o=Program.cacheKey(Wp[e],e,n,t);return this.cache[o]||(this.cache[o]=new Program(this.context,e,Wp[e],t,Uf[e],n)),this.cache[o]}setCustomLayerDefaults(){this.context.unbindVAO(),this.context.cullFace.setDefault(),this.context.frontFace.setDefault(),this.context.cullFaceSide.setDefault(),this.context.activeTexture.setDefault(),this.context.pixelStoreUnpack.setDefault(),this.context.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.context.pixelStoreUnpackFlipY.setDefault()}setBaseState(){const e=this.context.gl;this.context.cullFace.set(!1),this.context.viewport.set([0,0,this.width,this.height]),this.context.blendEquation.set(e.FUNC_ADD)}initDebugOverlayCanvas(){null==this.debugOverlayCanvas&&(this.debugOverlayCanvas=e.document.createElement("canvas"),this.debugOverlayCanvas.width=512,this.debugOverlayCanvas.height=512,this.debugOverlayTexture=new Texture(this.context,this.debugOverlayCanvas,this.context.gl.RGBA))}destroy(){this._terrain&&this._terrain.destroy(),this.globeSharedBuffers&&this.globeSharedBuffers.destroy(),this.emptyTexture.destroy(),this.debugOverlayTexture&&this.debugOverlayTexture.destroy(),this.atmosphereBuffer&&this.atmosphereBuffer.destroy()}prepareDrawTile(){this.terrain&&this.terrain.prepareDrawTile()}prepareDrawProgram(e,t,i){if(this.terrain&&this.terrain.renderingToTexture)return;const r=this.style.fog;if(r){const n=r.getOpacity(this.transform.pitch),o=((e,t,i,r,n,o,s,a,l,c,u)=>{const h=e.transform,d=t.properties.get("color").toArray01();d[3]=r;const p=e.frameCounter/1e3%1;return{u_fog_matrix:i?h.calculateFogTileMatrix(i):e.identityMat,u_fog_range:t.getFovAdjustedRange(h._fov),u_fog_color:d,u_fog_horizon_blend:t.properties.get("horizon-blend"),u_fog_temporal_offset:p,u_frustum_tl:n,u_frustum_tr:o,u_frustum_br:s,u_frustum_bl:a,u_globe_pos:l,u_globe_radius:c,u_viewport:u,u_globe_transition:ga(h.zoom),u_is_globe:+("globe"===h.projection.name)}})(this,r,i,n,this.transform.frustumCorners.TL,this.transform.frustumCorners.TR,this.transform.frustumCorners.BR,this.transform.frustumCorners.BL,this.transform.globeCenterInViewSpace,this.transform.globeRadius,[this.transform.width*it.devicePixelRatio,this.transform.height*it.devicePixelRatio]);t.setFogUniformValues(e,o)}}setTileLoadedFlag(e){this.tileLoaded=e}saveCanvasCopy(){const e=this.canvasCopy();e&&(this.frameCopies.push(e),this.tileLoaded=!1)}canvasCopy(){const e=this.context.gl,t=e.createTexture();return e.bindTexture(e.TEXTURE_2D,t),e.copyTexImage2D(e.TEXTURE_2D,0,e.RGBA,0,0,e.drawingBufferWidth,e.drawingBufferHeight,0),t}getCanvasCopiesAndTimestamps(){return{canvasCopies:this.frameCopies,timeStamps:this.loadTimeStamps}}averageElevationNeedsEasing(){if(!this.transform._elevation)return!1;const e=this.style&&this.style.fog;return!!e&&0!==e.getOpacity(this.transform.pitch)}getBackgroundTiles(){const e=this._backgroundTiles,t=this._backgroundTiles={},i=this.transform.coveringTiles({tileSize:512});for(const r of i)t[r.key]=e[r.key]||new Tile(r,512,this.transform.tileZoom,this);return t}clearBackgroundTiles(){this._backgroundTiles={}}}class EdgeInsets{constructor(e=0,t=0,i=0,r=0){if(isNaN(e)||e<0||isNaN(t)||t<0||isNaN(i)||i<0||isNaN(r)||r<0)throw new Error("Invalid value for edge-insets, top, bottom, left and right must all be numbers");this.top=e,this.bottom=t,this.left=i,this.right=r}interpolate(e,t,i){return null!=t.top&&null!=e.top&&(this.top=zi(e.top,t.top,i)),null!=t.bottom&&null!=e.bottom&&(this.bottom=zi(e.bottom,t.bottom,i)),null!=t.left&&null!=e.left&&(this.left=zi(e.left,t.left,i)),null!=t.right&&null!=e.right&&(this.right=zi(e.right,t.right,i)),this}getCenter(e,t){const i=M((this.left+e-this.right)/2,0,e),r=M((this.top+t-this.bottom)/2,0,t);return new g(i,r)}equals(e){return this.top===e.top&&this.bottom===e.bottom&&this.left===e.left&&this.right===e.right}clone(){return new EdgeInsets(this.top,this.bottom,this.left,this.right)}toJSON(){return{top:this.top,bottom:this.bottom,left:this.left,right:this.right}}}function dm(e,t){const i=re(e,3);rs(e,t),ne(e,3,i)}function pm(e,t){const i=Ls([]);return Fs(i,i,-t),Bs(i,i,-e),i}function fm(e,t){const i=[e[0],e[1],0],r=[t[0],t[1],0];if(cs(i)>=1e-15){const e=xs([],i);_s(r,e,vs(r,e)),t[0]=r[0],t[1]=r[1]}const n=bs([],t,e);if(Ms(n)<1e-15)return null;const o=Math.atan2(-n[1],n[0]);return pm(Math.atan2(Math.sqrt(e[0]*e[0]+e[1]*e[1]),-e[2]),o)}class FreeCameraOptions{constructor(e,t){this.position=e,this.orientation=t}get position(){return this._position}set position(e){if(e){const t=e instanceof MercatorCoordinate?e:new MercatorCoordinate(e[0],e[1],e[2]);this._renderWorldCopies&&(t.x=D(t.x,0,1)),this._position=t}else this._position=null}lookAtPoint(e,t){if(this.orientation=null,!this.position)return;const i=this.position,r=this._elevation?this._elevation.getAtPointOrZero(MercatorCoordinate.fromLngLat(e)):0,n=MercatorCoordinate.fromLngLat(e,r),o=[n.x-i.x,n.y-i.y,n.z-i.z];t||(t=[0,0,1]),t[2]=Math.abs(t[2]),this.orientation=fm(o,t)}setPitchBearing(e,t){this.orientation=pm(b(e),b(-t))}}class FreeCamera{constructor(e,t){this._transform=Wo([]),this.orientation=t,this.position=e}get mercatorPosition(){const e=this.position;return new MercatorCoordinate(e[0],e[1],e[2])}get position(){const e=re(this._transform,3);return[e[0],e[1],e[2]]}set position(e){var t;e&&ne(this._transform,3,[(t=e)[0],t[1],t[2],1])}get orientation(){return this._orientation}set orientation(e){this._orientation=e||Ls([]),e&&dm(this._transform,this._orientation)}getPitchBearing(){const e=this.forward(),t=this.right();return{bearing:Math.atan2(-t[1],t[0]),pitch:Math.atan2(Math.sqrt(e[0]*e[0]+e[1]*e[1]),-e[2])}}setPitchBearing(e,t){this._orientation=pm(e,t),dm(this._transform,this._orientation)}forward(){const e=re(this._transform,2);return[-e[0],-e[1],-e[2]]}up(){const e=re(this._transform,1);return[-e[0],-e[1],-e[2]]}right(){const e=re(this._transform,0);return[e[0],e[1],e[2]]}getCameraToWorld(e,t){const i=new Float64Array(16);return Ho(i,this.getWorldToCamera(e,t)),i}getWorldToCameraPosition(e,t,i){const r=this.position;_s(r,r,-e);const n=new Float64Array(16);return ts(n,[i,i,i]),Ko(n,n,r),n[10]*=t,n}getWorldToCamera(e,t){const i=new Float64Array(16),r=new Float64Array(4),n=this.position;var o,s;return(o=r)[0]=-(s=this._orientation)[0],o[1]=-s[1],o[2]=-s[2],o[3]=s[3],_s(n,n,-e),rs(i,r),Ko(i,i,n),i[1]*=-1,i[5]*=-1,i[9]*=-1,i[13]*=-1,i[8]*=t,i[9]*=t,i[10]*=t,i[11]*=t,i}getCameraToClipPerspective(e,t,i,r){const n=new Float64Array(16);return ns(n,e,t,i,r),n}getDistanceToElevation(e,t=!1){const i=0===e?0:La(e,t?Ra(this.position[1]):this.position[1]),r=this.forward();return(i-this.position[2])/r[2]}clone(){return new FreeCamera([...this.position],[...this.orientation])}}function mm(e,t){const i=gm(e.projection,e.zoom,e.width,e.height),r=function(e,t,i,r,n){const o=new Pa(i.lng-180*ym,i.lat),s=new Pa(i.lng+180*ym,i.lat),a=e.project(o.lng,o.lat),l=e.project(s.lng,s.lat),c=-Math.atan2(l.y-a.y,l.x-a.x),u=MercatorCoordinate.fromLngLat(i);u.y=M(u.y,-1+ym,1-ym);const h=u.toLngLat(),d=e.project(h.lng,h.lat),p=MercatorCoordinate.fromLngLat(h);p.x+=ym;const f=p.toLngLat(),m=e.project(f.lng,f.lat),_=vm(m.x-d.x,m.y-d.y,c),g=MercatorCoordinate.fromLngLat(h);g.y+=ym;const y=g.toLngLat(),x=e.project(y.lng,y.lat),v=vm(x.x-d.x,x.y-d.y,c),b=Math.abs(_.x)/Math.abs(v.y),w=Wo([]);es(w,w,-c*(1-(n?0:r)));const E=Wo([]);return Jo(E,E,[1,1-(1-b)*r,1]),E[4]=-v.x/v.y*r,es(E,E,c),Xo(E,w,E),E}(e.projection,0,e.center,i,t),n=_m(e);return Jo(r,r,[n,n,1]),r}function _m(e){const t=e.projection,i=gm(e.projection,e.zoom,e.width,e.height),r=xm(t,e.center),n=xm(t,Pa.convert(t.center));return Math.pow(2,r*i+(1-i)*n)}function gm(e,t,i,r,n=1/0){const o=e.range;if(!o)return 0;const s=Math.min(n,Math.max(i,r)),a=Math.log(s/1024)/Math.LN2;return P(o[0]+a,o[1]+a,t)}const ym=1/4e4;function xm(e,t){const i=M(t.lat,-Oa,Oa),r=new Pa(t.lng-180*ym,i),n=new Pa(t.lng+180*ym,i),o=e.project(r.lng,i),s=e.project(n.lng,i),a=MercatorCoordinate.fromLngLat(r),l=MercatorCoordinate.fromLngLat(n),c=s.x-o.x,u=s.y-o.y,h=l.x-a.x,d=l.y-a.y,p=Math.sqrt((h*h+d*d)/(c*c+u*u));return Math.log(p)/Math.LN2}function vm(e,t,i){const r=Math.cos(i),n=Math.sin(i);return{x:e*r-t*n,y:e*n+t*r}}class Transform{constructor(e,t,i,r,n,o,s){this.tileSize=512,this._renderWorldCopies=void 0===n||n,this._minZoom=e||0,this._maxZoom=t||22,this._minPitch=null==i?0:i,this._maxPitch=null==r?60:r,this.setProjection(o),this.setMaxBounds(s),this.width=0,this.height=0,this._center=new Pa(0,0),this.zoom=0,this.angle=0,this._fov=.6435011087932844,this._pitch=0,this._nearZ=0,this._farZ=0,this._unmodified=!0,this._edgeInsets=new EdgeInsets,this._projMatrixCache={},this._alignedProjMatrixCache={},this._fogTileMatrixCache={},this._distanceTileDataCache={},this._camera=new FreeCamera,this._centerAltitude=0,this._averageElevation=0,this.cameraElevationReference="ground",this._pixelsPerMercatorPixel=1,this.globeRadius=0,this.globeCenterInViewSpace=[0,0,0],this._horizonShift=.1}clone(){const e=new Transform(this._minZoom,this._maxZoom,this._minPitch,this.maxPitch,this._renderWorldCopies,this.getProjection());return e._elevation=this._elevation,e._centerAltitude=this._centerAltitude,e._centerAltitudeValidForExaggeration=this._centerAltitudeValidForExaggeration,e.tileSize=this.tileSize,e.mercatorFromTransition=this.mercatorFromTransition,e.width=this.width,e.height=this.height,e.cameraElevationReference=this.cameraElevationReference,e._center=this._center,e._setZoom(this.zoom),e._seaLevelZoom=this._seaLevelZoom,e.angle=this.angle,e._fov=this._fov,e._pitch=this._pitch,e._nearZ=this._nearZ,e._farZ=this._farZ,e._averageElevation=this._averageElevation,e._unmodified=this._unmodified,e._edgeInsets=this._edgeInsets.clone(),e._camera=this._camera.clone(),e._calcMatrices(),e.freezeTileCoverage=this.freezeTileCoverage,e.frustumCorners=this.frustumCorners,e}get elevation(){return this._elevation}set elevation(e){this._elevation!==e&&(this._elevation=e,this._updateCameraOnTerrain(),this._calcMatrices())}updateElevation(e,t=!1){const i=this._elevation&&this._elevation.exaggeration()!==this._centerAltitudeValidForExaggeration;(null==this._seaLevelZoom||i)&&this._updateCameraOnTerrain(),(e||i)&&this._constrainCamera(t),this._calcMatrices()}getProjection(){return B(this.projection,["name","center","parallels"])}setProjection(e){this.projectionOptions=e||{name:"mercator"};const t=this.projection?this.getProjection():void 0;this.projection=yh(this.projectionOptions);const i=!y(t,this.getProjection());return i&&this._calcMatrices(),this.mercatorFromTransition=!1,i}setMercatorFromTransition(){const e=this.projection.name;this.mercatorFromTransition=!0,this.projectionOptions={name:"mercator"},this.projection=yh({name:"mercator"});const t=e!==this.projection.name;return t&&this._calcMatrices(),t}get minZoom(){return this._minZoom}set minZoom(e){this._minZoom!==e&&(this._minZoom=e,this.zoom=Math.max(this.zoom,e))}get maxZoom(){return this._maxZoom}set maxZoom(e){this._maxZoom!==e&&(this._maxZoom=e,this.zoom=Math.min(this.zoom,e))}get minPitch(){return this._minPitch}set minPitch(e){this._minPitch!==e&&(this._minPitch=e,this.pitch=Math.max(this.pitch,e))}get maxPitch(){return this._maxPitch}set maxPitch(e){this._maxPitch!==e&&(this._maxPitch=e,this.pitch=Math.min(this.pitch,e))}get renderWorldCopies(){return this._renderWorldCopies&&!0===this.projection.supportsWorldCopies}set renderWorldCopies(e){void 0===e?e=!0:null===e&&(e=!1),this._renderWorldCopies=e}get worldSize(){return this.tileSize*this.scale}get cameraWorldSizeForFog(){const e=Math.max(this._camera.getDistanceToElevation(this._averageElevation),Number.EPSILON);return this._worldSizeFromZoom(this._zoomFromMercatorZ(e))}get cameraWorldSize(){const e=Math.max(this._camera.getDistanceToElevation(this._averageElevation,!0),Number.EPSILON);return this._worldSizeFromZoom(this._zoomFromMercatorZ(e))}get pixelsPerMeter(){return this.projection.pixelsPerMeter(this.center.lat,this.worldSize)}get cameraPixelsPerMeter(){return La(this.center.lat,this.cameraWorldSizeForFog)}get centerOffset(){return this.centerPoint._sub(this.size._div(2))}get size(){return new g(this.width,this.height)}get bearing(){return D(this.rotation,-180,180)}set bearing(e){this.rotation=e}get rotation(){return-this.angle/Math.PI*180}set rotation(e){const t=-e*Math.PI/180;var i;this.angle!==t&&(this._unmodified=!1,this.angle=t,this._calcMatrices(),this.rotationMatrix=(i=new jo(4),jo!=Float32Array&&(i[1]=0,i[2]=0),i[0]=1,i[3]=1,i),function(e,t,i){var r=t[0],n=t[1],o=t[2],s=t[3],a=Math.sin(i),l=Math.cos(i);e[0]=r*l+o*a,e[1]=n*l+s*a,e[2]=r*-a+o*l,e[3]=n*-a+s*l}(this.rotationMatrix,this.rotationMatrix,this.angle))}get pitch(){return this._pitch/Math.PI*180}set pitch(e){const t=M(e,this.minPitch,this.maxPitch)/180*Math.PI;this._pitch!==t&&(this._unmodified=!1,this._pitch=t,this._calcMatrices())}get aspect(){return this.width/this.height}get fov(){return this._fov/Math.PI*180}get fovX(){return this._fov}get fovY(){const e=1/Math.tan(.5*this.fovX);return 2*Math.atan(1/this.aspect/e)}set fov(e){e=Math.max(.01,Math.min(60,e)),this._fov!==e&&(this._unmodified=!1,this._fov=b(e),this._calcMatrices())}get averageElevation(){return this._averageElevation}set averageElevation(e){this._averageElevation=e,this._calcFogMatrices(),this._distanceTileDataCache={}}get zoom(){return this._zoom}set zoom(e){const t=Math.min(Math.max(e,this.minZoom),this.maxZoom);this._zoom!==t&&(this._unmodified=!1,this._setZoom(t),this._updateSeaLevelZoom(),this._constrain(),this._calcMatrices())}_setZoom(e){this._zoom=e,this.scale=this.zoomScale(e),this.tileZoom=Math.floor(e),this.zoomFraction=e-this.tileZoom}_updateCameraOnTerrain(){if(!this._elevation||!this._elevation.isDataAvailableAtPoint(this.locationCoordinate(this.center)))return this._centerAltitude=0,this._seaLevelZoom=null,void(this._centerAltitudeValidForExaggeration=void 0);const e=this._elevation;this._centerAltitude=e.getAtPointOrZero(this.locationCoordinate(this.center)),this._centerAltitudeValidForExaggeration=e.exaggeration(),this._updateSeaLevelZoom()}_updateSeaLevelZoom(){void 0!==this._centerAltitudeValidForExaggeration&&(this._seaLevelZoom=this._zoomFromMercatorZ((this.pixelsPerMeter*this._centerAltitude+this.cameraToCenterDistance)/this.worldSize))}sampleAverageElevation(){if(!this._elevation)return 0;const e=this._elevation,t=[[.5,.2],[.3,.5],[.5,.5],[.7,.5],[.5,.8]],i=this.horizonLineFromTop();let r=0,n=0;for(let o=0;o<t.length;o++){const s=new g(t[o][0]*this.width,i+t[o][1]*(this.height-i)),a=e.pointCoordinate(s);if(!a)continue;const l=1/Math.hypot(a[0]-this._camera.position[0],a[1]-this._camera.position[1]);r+=a[3]*l,n+=l}return 0===n?NaN:r/n}get center(){return this._center}set center(e){e.lat===this._center.lat&&e.lng===this._center.lng||(this._unmodified=!1,this._center=e,this._terrainEnabled()&&("ground"===this.cameraElevationReference?this._updateCameraOnTerrain():this._updateZoomFromElevation()),this._constrain(),this._calcMatrices())}_updateZoomFromElevation(){if(null==this._seaLevelZoom||!this._elevation)return;const e=this._seaLevelZoom,t=this._elevation.getAtPointOrZero(this.locationCoordinate(this.center)),i=this.pixelsPerMeter/this.worldSize*t,r=this._mercatorZfromZoom(e),n=this._mercatorZfromZoom(this._maxZoom),o=Math.max(r-i,n);this._setZoom(this._zoomFromMercatorZ(o))}get padding(){return this._edgeInsets.toJSON()}set padding(e){this._edgeInsets.equals(e)||(this._unmodified=!1,this._edgeInsets.interpolate(this._edgeInsets,e,1),this._calcMatrices())}computeZoomRelativeTo(e){const t=this.rayIntersectionCoordinate(this.pointRayIntersection(this.centerPoint,e.toAltitude()));let i;i=e.z<this._camera.position[2]?[t.x,t.y,t.z]:[e.x,e.y,e.z];const r=cs(As([],this._camera.position,i));return M(this._zoomFromMercatorZ(r),this._minZoom,this._maxZoom)}setFreeCameraOptions(e){if(!this.height)return;if(!e.position&&!e.orientation)return;this._updateCameraState();let t=!1;if(e.orientation&&!function(e,t){return e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]}(e.orientation,this._camera.orientation)&&(t=this._setCameraOrientation(e.orientation)),e.position){const n=[e.position.x,e.position.y,e.position.z];((i=n)[0]!==(r=this._camera.position)[0]||i[1]!==r[1]||i[2]!==r[2])&&(this._setCameraPosition(n),t=!0)}var i,r;t&&(this._updateStateFromCamera(),this.recenterOnTerrain())}getFreeCameraOptions(){this._updateCameraState();const e=this._camera.position,t=new FreeCameraOptions;return t.position=new MercatorCoordinate(e[0],e[1],e[2]),t.orientation=this._camera.orientation,t._elevation=this.elevation,t._renderWorldCopies=this.renderWorldCopies,t}_setCameraOrientation(e){if(t=e,!Math.hypot(t[0],t[1],t[2],t[3]))return!1;var t;Os(e,e);const i=Ts([],[0,0,-1],e),r=Ts([],[0,-1,0],e);if(r[2]<0)return!1;const n=fm(i,r);return!!n&&(this._camera.orientation=n,!0)}_setCameraPosition(e){const t=this.zoomScale(this.minZoom)*this.tileSize,i=this.zoomScale(this.maxZoom)*this.tileSize,r=this.cameraToCenterDistance;e[2]=M(e[2],r/i,r/t),this._camera.position=e}get centerPoint(){return this._edgeInsets.getCenter(this.width,this.height)}get fovAboveCenter(){return this._fov*(.5+this.centerOffset.y/this.height)}isPaddingEqual(e){return this._edgeInsets.equals(e)}interpolatePadding(e,t,i){this._unmodified=!1,this._edgeInsets.interpolate(e,t,i),this._constrain(),this._calcMatrices()}coveringZoomLevel(e){const t=(e.roundZoom?Math.round:Math.floor)(this.zoom+this.scaleZoom(this.tileSize/e.tileSize));return Math.max(0,t)}getVisibleUnwrappedCoordinates(e){const t=[new UnwrappedTileID(0,e)];if(this.renderWorldCopies){const i=this.pointCoordinate(new g(0,0)),r=this.pointCoordinate(new g(this.width,0)),n=this.pointCoordinate(new g(this.width,this.height)),o=this.pointCoordinate(new g(0,this.height)),s=Math.floor(Math.min(i.x,r.x,n.x,o.x)),a=Math.floor(Math.max(i.x,r.x,n.x,o.x)),l=1;for(let i=s-l;i<=a+l;i++)0!==i&&t.push(new UnwrappedTileID(i,e))}return t}coveringTiles(e){let t=this.coveringZoomLevel(e);const i=t,r=this.elevation&&!e.isTerrainDEM,n="mercator"===this.projection.name;if(void 0!==e.minzoom&&t<e.minzoom)return[];void 0!==e.maxzoom&&t>e.maxzoom&&(t=e.maxzoom);const o=this.locationCoordinate(this.center),s=this.center.lat,a=1<<t,l=[a*o.x,a*o.y,0],c="globe"===this.projection.name,u=!c,h=Frustum.fromInvProjectionMatrix(this.invProjMatrix,this.worldSize,t,u),d=c?this._camera.mercatorPosition:this.pointCoordinate(this.getCameraPoint()),p=a*La(1,this.center.lat),f=this._camera.position[2]/La(1,this.center.lat),m=[a*d.x,a*d.y,f*(u?1:p)],_=this.cameraToCenterDistance/e.tileSize*(e.roundZoom?1:.502),g=this.pitch<=60&&this._edgeInsets.top<=this._edgeInsets.bottom&&!this._elevation&&!this.projection.isReprojectedInTileSpace?t:0,y=e.isTerrainDEM&&this._elevation?1e4*this._elevation.exaggeration():this._centerAltitude,x=e.isTerrainDEM?-y:this._elevation?this._elevation.getMinElevationBelowMSL():0,v=this.projection.isReprojectedInTileSpace?_m(this):1,b=e=>{const t=1/4e4,i=new MercatorCoordinate(e.x+t,e.y,e.z),r=new MercatorCoordinate(e.x,e.y+t,e.z),n=e.toLngLat(),o=i.toLngLat(),s=r.toLngLat(),a=this.locationCoordinate(n),l=this.locationCoordinate(o),c=this.locationCoordinate(s),u=Math.hypot(l.x-a.x,l.y-a.y),h=Math.hypot(c.x-a.x,c.y-a.y);return Math.sqrt(u*h)*v/t},w=e=>{const t=y,i=x;return{aabb:oh(this,a,0,0,0,e,i,t,this.projection),zoom:0,x:0,y:0,minZ:i,maxZ:t,wrap:e,fullyVisible:!1}},T=[];let S=[];const A=t,C=e.reparseOverscaled?i:t,I=e=>e*e,M=I((f-this._centerAltitude)*p),P=e=>{if(!this._elevation||!e.tileID||!n)return;const t=this._elevation.getMinMaxForTile(e.tileID),i=e.aabb;t?(i.min[2]=t.min,i.max[2]=t.max,i.center[2]=(i.min[2]+i.max[2])/2):(e.shouldSplit=D(e),e.shouldSplit||(i.min[2]=i.max[2]=i.center[2]=this._centerAltitude))},D=e=>{if(e.zoom<g)return!0;if(e.zoom===A)return!1;if(null!=e.shouldSplit)return e.shouldSplit;const t=e.aabb.distanceX(m),n=e.aabb.distanceY(m);let o=M,a=1;if(c){o=I(e.aabb.distanceZ(m));const t=Math.pow(2,e.zoom),i=Ra((e.y+1)/t),r=Ra(e.y/t),n=Math.min(Math.max(s,i),r),l=Da(n)/Da(s);if(a=n===s?1/Math.max(1,this._mercatorScaleRatio-.3):Math.min(1,l/this._mercatorScaleRatio),this.zoom<=Gs&&e.zoom===A-1&&l>=.9)return!0}else if(r&&(o=I(e.aabb.distanceZ(m)*p)),this.projection.isReprojectedInTileSpace&&i<=5){const t=Math.pow(2,e.zoom),i=b(new MercatorCoordinate((e.x+.5)/t,(e.y+.5)/t));a=i>.85?1:i}const l=t*t+n*n+o,u=I((1<<A-e.zoom)*_*a*((e,t)=>{if(t*I(.707)<e)return 1;const i=Math.sqrt(t/e);return i/(1.4144271570014144+(Math.pow(1.1,i-1.4144271570014144+1)-1)/(1.1-1)-1)})(Math.max(o,M),l));return l<u};if(this.renderWorldCopies)for(let e=1;e<=3;e++)T.push(w(-e)),T.push(w(e));for(T.push(w(0));T.length>0;){const i=T.pop(),o=i.x,s=i.y;let u=i.fullyVisible;if(!u){const e=i.aabb.intersects(h);if(0===e)continue;u=2===e}if(i.zoom!==A&&D(i))for(let e=0;e<4;e++){const t=(o<<1)+e%2,l=(s<<1)+(e>>1),h={aabb:n?i.aabb.quadrant(e):oh(this,a,i.zoom+1,t,l,i.wrap,i.minZ,i.maxZ,this.projection),zoom:i.zoom+1,x:t,y:l,wrap:i.wrap,fullyVisible:u,tileID:void 0,shouldSplit:void 0,minZ:i.minZ,maxZ:i.maxZ};r&&!c&&(h.tileID=new OverscaledTileID(i.zoom+1===A?C:i.zoom+1,i.wrap,i.zoom+1,t,l),P(h)),T.push(h)}else{const r=i.zoom===A?C:i.zoom;if(e.minzoom&&e.minzoom>r)continue;const n=l[0]-(.5+o+(i.wrap<<i.zoom))*(1<<t-i.zoom),a=l[1]-.5-s,c=i.tileID?i.tileID:new OverscaledTileID(r,i.wrap,i.zoom,o,s);S.push({tileID:c,distanceSq:n*n+a*a})}}if(this.fogCullDistSq){const t=this.fogCullDistSq,i=this.horizonLineFromTop();S=S.filter((r=>{const n=[0,0,0,1],o=[Uo,Uo,0,1],s=this.calculateFogTileMatrix(r.tileID.toUnwrapped());zs(n,n,s),zs(o,o,s);const a=function(e,t,i){let r=0;for(let i=0;i<2;++i){const n=0;e[i]>n&&(r+=(e[i]-n)*(e[i]-n)),t[i]<n&&(r+=(n-t[i])*(n-t[i]))}return r}(n,o);if(0===a)return!0;let l=!1;const c=this._elevation;if(c&&a>t&&0!==i){const t=this.calculateProjMatrix(r.tileID.toUnwrapped());let n;e.isTerrainDEM||(n=c.getMinMaxForTile(r.tileID)),n||(n={min:x,max:y});const o=function(e){const t=Math.round((e+45+360)%360/90)%4;return E[t]}(this.rotation),s=[o[0]*Uo,o[1]*Uo,n.max];ws(s,s,t),l=(1-s[1])*this.height*.5<i}return a<t||l}))}return S.sort(((e,t)=>e.distanceSq-t.distanceSq)).map((e=>e.tileID))}resize(e,t){this.width=e,this.height=t,this.pixelsToGLUnits=[2/e,-2/t],this._constrain(),this._calcMatrices()}get unmodified(){return this._unmodified}zoomScale(e){return Math.pow(2,e)}scaleZoom(e){return Math.log(e)/Math.LN2}project(e){const t=M(e.lat,-Oa,Oa),i=this.projection.project(e.lng,t);return new g(i.x*this.worldSize,i.y*this.worldSize)}unproject(e){return this.projection.unproject(e.x/this.worldSize,e.y/this.worldSize)}get point(){return this.project(this.center)}get pointMerc(){return this.point._div(this.worldSize)}get pixelsPerMeterRatio(){return this.pixelsPerMeter/La(1,this.center.lat)/this.worldSize}setLocationAtPoint(e,t){let i,r;const n=this.centerPoint;if("globe"===this.projection.name){const e=this.worldSize;i=(t.x-n.x)/e,r=(t.y-n.y)/e}else{const e=this.pointCoordinate(t),o=this.pointCoordinate(n);i=e.x-o.x,r=e.y-o.y}const o=this.locationCoordinate(e);this.setLocation(new MercatorCoordinate(o.x-i,o.y-r))}setLocation(e){this.center=this.coordinateLocation(e),this.projection.wrap&&(this.center=this.center.wrap())}locationPoint(e){return this.projection.locationPoint(this,e)}locationPoint3D(e){return this.projection.locationPoint(this,e,!0)}pointLocation(e){return this.coordinateLocation(this.pointCoordinate(e))}pointLocation3D(e){return this.coordinateLocation(this.pointCoordinate3D(e))}locationCoordinate(e,t){const i=t?La(t,e.lat):void 0,r=this.projection.project(e.lng,e.lat);return new MercatorCoordinate(r.x,r.y,i)}coordinateLocation(e){return this.projection.unproject(e.x,e.y)}pointRayIntersection(e,t){const i=null!=t?t:this._centerAltitude,r=[e.x,e.y,0,1],n=[e.x,e.y,1,1];zs(r,r,this.pixelMatrixInverse),zs(n,n,this.pixelMatrixInverse);const o=n[3];Ps(r,r,1/r[3]),Ps(n,n,1/o);const s=r[2],a=n[2];return{p0:r,p1:n,t:s===a?0:(i-s)/(a-s)}}screenPointToMercatorRay(e){const t=[e.x,e.y,0,1],i=[e.x,e.y,1,1];return zs(t,t,this.pixelMatrixInverse),zs(i,i,this.pixelMatrixInverse),Ps(t,t,1/t[3]),Ps(i,i,1/i[3]),t[2]=La(t[2],this._center.lat)*this.worldSize,i[2]=La(i[2],this._center.lat)*this.worldSize,Ps(t,t,1/this.worldSize),Ps(i,i,1/this.worldSize),new Ray([t[0],t[1],t[2]],xs([],As([],i,t)))}rayIntersectionCoordinate(e){const{p0:t,p1:i,t:r}=e,n=La(t[2],this._center.lat),o=La(i[2],this._center.lat);return new MercatorCoordinate(zi(t[0],i[0],r)/this.worldSize,zi(t[1],i[1],r)/this.worldSize,zi(n,o,r))}pointCoordinate(e,t=this._centerAltitude){return this.projection.pointCoordinate(this,e.x,e.y,t)}pointCoordinate3D(e){if(!this.elevation)return this.pointCoordinate(e);let t=this.projection.pointCoordinate3D(this,e.x,e.y);if(t)return new MercatorCoordinate(t[0],t[1],t[2]);let i=0,r=this.horizonLineFromTop();if(e.y>r)return this.pointCoordinate(e);const n=.02*r,o=e.clone();for(let e=0;e<10&&r-i>n;e++){o.y=zi(i,r,.66);const e=this.projection.pointCoordinate3D(this,o.x,o.y);e?(r=o.y,t=e):i=o.y}return t?new MercatorCoordinate(t[0],t[1],t[2]):this.pointCoordinate(e)}isPointAboveHorizon(e){return this.projection.isPointAboveHorizon(this,e)}isPointOnSurface(e){if(e.y<0||e.y>this.height||e.x<0||e.x>this.width)return!1;if(this.elevation||this.zoom>=qs)return!this.isPointAboveHorizon(e);const t=this.pointCoordinate(e);return t.y>=0&&t.y<=1}_coordinatePoint(e,t){const i=t&&this.elevation?this.elevation.getAtPointOrZero(e,this._centerAltitude):this._centerAltitude,r=[e.x*this.worldSize,e.y*this.worldSize,i+e.toAltitude(),1];return zs(r,r,this.pixelMatrix),r[3]>0?new g(r[0]/r[3],r[1]/r[3]):new g(Number.MAX_VALUE,Number.MAX_VALUE)}_getBoundsNonRectangular(){const{top:e,left:t}=this._edgeInsets,i=this.height-this._edgeInsets.bottom,r=this.width-this._edgeInsets.right,n=this.pointLocation3D(new g(t,e)),o=this.pointLocation3D(new g(r,e)),s=this.pointLocation3D(new g(r,i)),a=this.pointLocation3D(new g(t,i));let l=Math.min(n.lng,o.lng,s.lng,a.lng),c=Math.max(n.lng,o.lng,s.lng,a.lng),u=Math.min(n.lat,o.lat,s.lat,a.lat),h=Math.max(n.lat,o.lat,s.lat,a.lat);const d=Math.pow(2,-this.zoom)/16*270,p="globe"===this.projection.name?1:4,f=(e,t,i,r,n)=>{const o=(e+i)/2,s=(t+r)/2,a=new g(o,s),{lng:m,lat:_}=this.pointLocation3D(a),y=Math.max(0,l-m,u-_,m-c,_-h);l=Math.min(l,m),c=Math.max(c,m),u=Math.min(u,_),h=Math.max(h,_),(n<p||y>d)&&(f(e,t,o,s,n+1),f(o,s,i,r,n+1))};if(f(t,e,r,e,1),f(r,e,r,i,1),f(r,i,t,i,1),f(t,i,t,e,1),"globe"===this.projection.name){const[e,t]=function(e){const t=Wo(new Float64Array(16));Xo(t,e.pixelMatrix,e.globeMatrix);const i=[0,Xs,0],r=[0,Ks,0];return ws(i,i,t),ws(r,r,t),[i[0]>0&&i[0]<=e.width&&i[1]>0&&i[1]<=e.height&&!Ta(e,new Pa(e.center.lat,90)),r[0]>0&&r[0]<=e.width&&r[1]>0&&r[1]<=e.height&&!Ta(e,new Pa(e.center.lat,-90))]}(this);e?(h=90,c=180,l=-180):t&&(u=-90,c=180,l=-180)}return new LngLatBounds(new Pa(l,u),new Pa(c,h))}_getBoundsRectangular(e,t){const{top:i,left:r}=this._edgeInsets,n=this.height-this._edgeInsets.bottom,o=this.width-this._edgeInsets.right,s=new g(r,i),a=new g(o,i),l=new g(o,n),c=new g(r,n);let u=this.pointCoordinate(s,e),h=this.pointCoordinate(a,e);const d=this.pointCoordinate(l,t),p=this.pointCoordinate(c,t),f=(e,t)=>(t.y-e.y)/(t.x-e.x);return u.y>1&&h.y>=0?u=new MercatorCoordinate((1-p.y)/f(p,u)+p.x,1):u.y<0&&h.y<=1&&(u=new MercatorCoordinate(-p.y/f(p,u)+p.x,0)),h.y>1&&u.y>=0?h=new MercatorCoordinate((1-d.y)/f(d,h)+d.x,1):h.y<0&&u.y<=1&&(h=new MercatorCoordinate(-d.y/f(d,h)+d.x,0)),(new LngLatBounds).extend(this.coordinateLocation(u)).extend(this.coordinateLocation(h)).extend(this.coordinateLocation(p)).extend(this.coordinateLocation(d))}_getBoundsRectangularTerrain(){const e=this.elevation;if(!e.visibleDemTiles.length||e.isUsingMockSource())return this._getBoundsRectangular(0,0);const t=e.visibleDemTiles.reduce(((e,t)=>{if(t.dem){const i=t.dem.tree;e.min=Math.min(e.min,i.minimums[0]),e.max=Math.max(e.max,i.maximums[0])}return e}),{min:Number.MAX_VALUE,max:0});return this._getBoundsRectangular(t.min*e.exaggeration(),t.max*e.exaggeration())}getBounds(){return"mercator"===this.projection.name||"equirectangular"===this.projection.name?this._terrainEnabled()?this._getBoundsRectangularTerrain():this._getBoundsRectangular(0,0):this._getBoundsNonRectangular()}horizonLineFromTop(e=!0){const t=this.height/2/Math.tan(this._fov/2)/Math.tan(Math.max(this._pitch,.1))+this.centerOffset.y,i=this.height/2-t*(1-this._horizonShift);return e?Math.max(0,i):i}getMaxBounds(){return this.maxBounds}setMaxBounds(e){this.maxBounds=e,this.minLat=-Oa,this.maxLat=Oa,this.minLng=-180,this.maxLng=180,e&&(this.minLat=e.getSouth(),this.maxLat=e.getNorth(),this.minLng=e.getWest(),this.maxLng=e.getEast(),this.maxLng<this.minLng&&(this.maxLng+=360)),this.worldMinX=za(this.minLng)*this.tileSize,this.worldMaxX=za(this.maxLng)*this.tileSize,this.worldMinY=ka(this.maxLat)*this.tileSize,this.worldMaxY=ka(this.minLat)*this.tileSize,this._constrain()}calculatePosMatrix(e,t){return this.projection.createTileMatrix(this,t,e)}calculateDistanceTileData(e){const t=e.key,i=this._distanceTileDataCache;if(i[t])return i[t];const r=e.canonical,n=1/this.height,o=this.cameraWorldSize,s=o/this.zoomScale(r.z),a=(r.x+Math.pow(2,r.z)*e.wrap)*s,l=r.y*s,c=this.point;c.x*=o/this.worldSize,c.y*=o/this.worldSize;const u=this.angle,h=Math.sin(-u),d=-Math.cos(-u);return i[t]={bearing:[h,d],center:[(c.x-a)*n,(c.y-l)*n],scale:s/Uo*n},i[t]}calculateFogTileMatrix(e){const t=e.key,i=this._fogTileMatrixCache;if(i[t])return i[t];const r=this.projection.createTileMatrix(this,this.cameraWorldSizeForFog,e);return Xo(r,this.worldToFogMatrix,r),i[t]=new Float32Array(r),i[t]}calculateProjMatrix(e,t=!1){const i=e.key,r=t?this._alignedProjMatrixCache:this._projMatrixCache;if(r[i])return r[i];const n=this.calculatePosMatrix(e,this.worldSize);return Xo(n,this.projection.isReprojectedInTileSpace?this.mercatorMatrix:t?this.alignedProjMatrix:this.projMatrix,n),r[i]=new Float32Array(n),r[i]}calculatePixelsToTileUnitsMatrix(e){const t=e.tileID.key,i=this._pixelsToTileUnitsCache;if(i[t])return i[t];const r=function(e,t){const{scale:i}=e.tileTransform,r=i*Uo/(e.tileSize*Math.pow(2,t.zoom-e.tileID.overscaledZ+e.tileID.canonical.z));return function(e,t,i){var r=t[1],n=t[2],o=t[3],s=i[0],a=i[1];return e[0]=t[0]*s,e[1]=r*s,e[2]=n*a,e[3]=o*a,e}(new Float32Array(4),t.inverseAdjustmentMatrix,[r,r])}(e,this);return i[t]=r,i[t]}customLayerMatrix(){return this.mercatorMatrix.slice()}globeToMercatorMatrix(){if("globe"===this.projection.name){const e=1/this.worldSize,t=ts([],[e,e,e]);return Xo(t,t,this.globeMatrix),t}}recenterOnTerrain(){if(!this._elevation||"globe"===this.projection.name)return;const e=this._elevation;this._updateCameraState();const t=La(1,this._center.lat)*this.worldSize,i=this._computeCameraPosition(t),r=this._camera.forward(),n=La(1,this._center.lat);i[2]/=n,r[2]/=n,xs(r,r);const o=e.raycast(i,r,e.exaggeration());if(o){const e=gs([],i,r,o),t=new MercatorCoordinate(e[0],e[1],La(e[2],Ra(e[1]))),s=(t.z+cs([t.x-i[0],t.y-i[1],t.z-i[2]*n]))*this._pixelsPerMercatorPixel;this._seaLevelZoom=this._zoomFromMercatorZ(s),this._centerAltitude=t.toAltitude(),this._center=this.coordinateLocation(t),this._updateZoomFromElevation(),this._constrain(),this._calcMatrices()}}_constrainCamera(e=!1){if(!this._elevation)return;const t=this._elevation,i=La(1,this._center.lat)*this.worldSize,r=this._computeCameraPosition(i),n=t.getAtPointOrZero(new MercatorCoordinate(...r)),o=this.pixelsPerMeter/this.worldSize*n,s=this._minimumHeightOverTerrain(),a=r[2]-o;if(a<=s)if(a<0||e){const e=this.locationCoordinate(this._center,this._centerAltitude),t=[r[0],r[1],e.z-r[2]],i=cs(t);t[2]-=(s-a)/this._pixelsPerMercatorPixel;const n=cs(t);if(0===n)return;_s(t,t,i/n*this._pixelsPerMercatorPixel),this._camera.position=[r[0],r[1],e.z*this._pixelsPerMercatorPixel-t[2]],this._updateStateFromCamera()}else this._isCameraConstrained=!0}_constrain(){if(!this.center||!this.width||!this.height||this._constraining)return;this._constraining=!0;const e="globe"===this.projection.name||this.mercatorFromTransition;if(this.projection.isReprojectedInTileSpace||e){const t=this.center;return t.lat=M(t.lat,this.minLat,this.maxLat),(this.maxBounds||!this.renderWorldCopies&&!e)&&(t.lng=M(t.lng,this.minLng,this.maxLng)),this.center=t,void(this._constraining=!1)}const t=this._unmodified,{x:i,y:r}=this.point;let n=0,o=i,s=r;const a=this.width/2,l=this.height/2,c=this.worldMinY*this.scale,u=this.worldMaxY*this.scale;if(r-l<c&&(s=c+l),r+l>u&&(s=u-l),u-c<this.height&&(n=Math.max(n,this.height/(u-c)),s=(u+c)/2),this.maxBounds||!this._renderWorldCopies||!this.projection.wrap){const e=this.worldMinX*this.scale,t=this.worldMaxX*this.scale,r=this.worldSize/2-(e+t)/2;o=(i+r+this.worldSize)%this.worldSize-r,o-a<e&&(o=e+a),o+a>t&&(o=t-a),t-e<this.width&&(n=Math.max(n,this.width/(t-e)),o=(t+e)/2)}o===i&&s===r||(this.center=this.unproject(new g(o,s))),n&&(this.zoom+=this.scaleZoom(n)),this._constrainCamera(),this._unmodified=t,this._constraining=!1}_minZoomForBounds(){let e=Math.max(0,this.scaleZoom(this.height/(this.worldMaxY-this.worldMinY)));return this.maxBounds&&(e=Math.max(e,this.scaleZoom(this.width/(this.worldMaxX-this.worldMinX)))),e}_maxCameraBoundsDistance(){return this._mercatorZfromZoom(this._minZoomForBounds())}_calcMatrices(){if(!this.height)return;const e=this.centerOffset,t=this.pixelsPerMeter;"globe"===this.projection.name&&(this._mercatorScaleRatio=La(1,this.center.lat)/La(1,45));const i=gm(this.projection,this.zoom,this.width,this.height,1024);this._pixelsPerMercatorPixel=this.projection.pixelSpaceConversion(this.center.lat,this.worldSize,i),this.cameraToCenterDistance=.5/Math.tan(.5*this._fov)*this.height*this._pixelsPerMercatorPixel,this._updateCameraState(),this._farZ=this.projection.farthestPixelDistance(this),this._nearZ=this.height/50;const r="meters"===this.projection.zAxisUnit?t:1,n=this._camera.getWorldToCamera(this.worldSize,r),o=this._camera.getCameraToClipPerspective(this._fov,this.width/this.height,this._nearZ,this._farZ);o[8]=2*-e.x/this.width,o[9]=2*e.y/this.height;let s=ss([],o,n);if(this.projection.isReprojectedInTileSpace){const e=this.locationCoordinate(this.center),t=Wo([]);Ko(t,t,[e.x*this.worldSize,e.y*this.worldSize,0]),Xo(t,t,mm(this)),Ko(t,t,[-e.x*this.worldSize,-e.y*this.worldSize,0]),Xo(s,s,t),this.inverseAdjustmentMatrix=function(e){const t=mm(e,!0);return No([],[t[0],t[1],t[4],t[5]])}(this)}else this.inverseAdjustmentMatrix=[1,0,0,1];this.mercatorMatrix=Jo([],s,[this.worldSize,this.worldSize,this.worldSize/r,1]),this.projMatrix=s,this.invProjMatrix=Ho(new Float64Array(16),this.projMatrix);const a=Ho([],o);this.frustumCorners=FrustumCorners.fromInvProjectionMatrix(a,this.horizonLineFromTop(),this.height);const l=new Float32Array(16);Wo(l),Jo(l,l,[1,-1,1]),Yo(l,l,this._pitch),es(l,l,this.angle);const c=ns(new Float32Array(16),this._fov,this.width/this.height,this._nearZ,this._farZ),u=(Math.PI/2-this._pitch)*(this.height/this._fov)*this._horizonShift;c[8]=2*-e.x/this.width,c[9]=2*(e.y+u)/this.height,this.skyboxMatrix=Xo(l,c,l);const h=this.point,d=h.x,p=h.y,f=this.width%2/2,m=this.height%2/2,_=Math.cos(this.angle),g=Math.sin(this.angle),y=d-Math.round(d)+_*f+g*m,x=p-Math.round(p)+_*m+g*f,v=new Float64Array(s);if(Ko(v,v,[y>.5?y-1:y,x>.5?x-1:x,0]),this.alignedProjMatrix=v,s=$o(),Jo(s,s,[this.width/2,-this.height/2,1]),Ko(s,s,[1,-1,0]),this.labelPlaneMatrix=s,s=$o(),Jo(s,s,[1,-1,1]),Ko(s,s,[-1,-1,0]),Jo(s,s,[2/this.width,2/this.height,1]),this.glCoordMatrix=s,this.pixelMatrix=Xo(new Float64Array(16),this.labelPlaneMatrix,this.projMatrix),this._calcFogMatrices(),this._distanceTileDataCache={},s=Ho(new Float64Array(16),this.pixelMatrix),!s)throw new Error("failed to invert matrix");if(this.pixelMatrixInverse=s,"globe"===this.projection.name||this.mercatorFromTransition){this.globeMatrix=function(e){const{x:t,y:i}=e.point,{lng:r,lat:n}=e._center;return _a(t,i,e.worldSize,r,n)}(this);const e=[this.globeMatrix[12],this.globeMatrix[13],this.globeMatrix[14]];this.globeCenterInViewSpace=ws(e,e,n),this.globeRadius=this.worldSize/2/Math.PI-1}else this.globeMatrix=s;this._projMatrixCache={},this._alignedProjMatrixCache={},this._pixelsToTileUnitsCache={}}_calcFogMatrices(){this._fogTileMatrixCache={};const e=this.cameraWorldSizeForFog,t=this.cameraPixelsPerMeter,i=this._camera.position,r=1/this.height/this._pixelsPerMercatorPixel,n=[e,e,t];_s(n,n,r),_s(i,i,-1),ps(i,i,n);const o=$o();Ko(o,o,i),Jo(o,o,n),this.mercatorFogMatrix=o,this.worldToFogMatrix=this._camera.getWorldToCameraPosition(e,t,r)}_computeCameraPosition(e){const t=(e=e||this.pixelsPerMeter)/this.pixelsPerMeter,i=this._camera.forward(),r=this.point,n=this._mercatorZfromZoom(this._seaLevelZoom?this._seaLevelZoom:this._zoom)*t-e/this.worldSize*this._centerAltitude;return[r.x/this.worldSize-i[0]*n,r.y/this.worldSize-i[1]*n,e/this.worldSize*this._centerAltitude-i[2]*n]}_updateCameraState(){this.height&&(this._camera.setPitchBearing(this._pitch,this.angle),this._camera.position=this._computeCameraPosition())}_translateCameraConstrained(e){const t=this._maxCameraBoundsDistance()*Math.cos(this._pitch),i=this._camera.position[2],r=e[2];let n=1;this.projection.wrap&&(this.center=this.center.wrap()),r>0&&(n=Math.min((t-i)/r,1)),this._camera.position=gs([],this._camera.position,e,n),this._updateStateFromCamera()}_updateStateFromCamera(){const e=this._camera.position,t=this._camera.forward(),{pitch:i,bearing:r}=this._camera.getPitchBearing(),n=La(this._centerAltitude,this.center.lat)*this._pixelsPerMercatorPixel,o=this._mercatorZfromZoom(this._maxZoom)*Math.cos(b(this._maxPitch)),s=Math.max((e[2]-n)/Math.cos(i),o),a=this._zoomFromMercatorZ(s);gs(e,e,t,s),this._pitch=M(i,b(this.minPitch),b(this.maxPitch)),this.angle=D(r,-Math.PI,Math.PI),this._setZoom(M(a,this._minZoom,this._maxZoom)),this._updateSeaLevelZoom(),this._center=this.coordinateLocation(new MercatorCoordinate(e[0],e[1],e[2])),this._unmodified=!1,this._constrain(),this._calcMatrices()}_worldSizeFromZoom(e){return Math.pow(2,e)*this.tileSize}_mercatorZfromZoom(e){return this.cameraToCenterDistance/this._worldSizeFromZoom(e)}_minimumHeightOverTerrain(){const e=Math.min((null!=this._seaLevelZoom?this._seaLevelZoom:this._zoom)+4,this._maxZoom);return this._mercatorZfromZoom(e)}_zoomFromMercatorZ(e){return this.scaleZoom(this.cameraToCenterDistance/(e*this.tileSize))}zoomFromMercatorZAdjusted(e){let t=0,i=qs,r=0,n=1/0;for(;i-t>1e-6&&i>t;){const o=t+.5*(i-t),s=this.tileSize*Math.pow(2,o),a=this.getCameraToCenterDistance(this.projection,o,s),l=this.scaleZoom(a/(e*this.tileSize)),c=Math.abs(o-l);c<n&&(n=c,r=o),o<l?t=o:i=o}return r}_terrainEnabled(){return!(!this._elevation||!this.projection.supportsTerrain&&(H("Terrain is not yet supported with alternate projections. Use mercator or globe to enable terrain."),1))}anyCornerOffEdge(e,t){const i=Math.min(e.x,t.x),r=Math.max(e.x,t.x),n=Math.min(e.y,t.y),o=Math.max(e.y,t.y);if(n<this.horizonLineFromTop(!1))return!0;if("mercator"!==this.projection.name)return!1;const s=[new g(i,n),new g(r,o),new g(i,o),new g(r,n)],a=this.renderWorldCopies?-3:0,l=this.renderWorldCopies?4:1;for(const e of s){const t=this.pointRayIntersection(e);if(t.t<0)return!0;const i=this.rayIntersectionCoordinate(t);if(i.x<a||i.y<0||i.x>l||i.y>1)return!0}return!1}isHorizonVisible(){return this.pitch+w(this.fovAboveCenter)>88||this.anyCornerOffEdge(new g(0,0),new g(this.width,this.height))}zoomDeltaToMovement(e,t){const i=cs(As([],this._camera.position,e)),r=this._zoomFromMercatorZ(i)+t;return i-this._mercatorZfromZoom(r)}getCameraPoint(){if("globe"===this.projection.name){const e=function([e,t,i],r){const n=[e,t,i,1];zs(n,n,r);const o=n[3]=Math.max(n[3],1e-6);return n[0]/=o,n[1]/=o,n[2]/=o,n}([this.globeMatrix[12],this.globeMatrix[13],this.globeMatrix[14]],this.pixelMatrix);return new g(e[0],e[1])}{const e=Math.tan(this._pitch)*(this.cameraToCenterDistance||1);return this.centerPoint.add(new g(0,e))}}getCameraToCenterDistance(e,t=this.zoom,i=this.worldSize){const r=gm(e,t,this.width,this.height,1024),n=e.pixelSpaceConversion(this.center.lat,i,r);return.5/Math.tan(.5*this._fov)*this.height*n}getWorldToCameraMatrix(){const e=this._camera.getWorldToCamera(this.worldSize,"meters"===this.projection.zAxisUnit?this.pixelsPerMeter:1);return"globe"===this.projection.name&&Xo(e,e,this.globeMatrix),e}}function bm(e,t){let i=!1,r=null;const n=()=>{r=null,i&&(e(),r=setTimeout(n,t),i=!1)};return()=>(i=!0,r||n(),r)}class Hash{constructor(e){this._hashName=e&&encodeURIComponent(e),j(["_getCurrentHash","_onHashChange","_updateHash"],this),this._updateHash=bm(this._updateHashUnthrottled.bind(this),300)}addTo(t){return this._map=t,e.addEventListener("hashchange",this._onHashChange,!1),t.on("moveend",this._updateHash),this}remove(){return this._map?(this._map.off("moveend",this._updateHash),e.removeEventListener("hashchange",this._onHashChange,!1),clearTimeout(this._updateHash()),this._map=void 0,this):this}getHashString(){const t=this._map;if(!t)return"";const i=wm(t);if(this._hashName){const t=this._hashName;let r=!1;const n=e.location.hash.slice(1).split("&").map((e=>{const n=e.split("=")[0];return n===t?(r=!0,`${n}=${i}`):e})).filter((e=>e));return r||n.push(`${t}=${i}`),`#${n.join("&")}`}return`#${i}`}_getCurrentHash(){const t=e.location.hash.replace("#","");if(this._hashName){let e;return t.split("&").map((e=>e.split("="))).forEach((t=>{t[0]===this._hashName&&(e=t)})),(e&&e[1]||"").split("/")}return t.split("/")}_onHashChange(){const e=this._map;if(!e)return!1;const t=this._getCurrentHash();if(t.length>=3&&!t.some((e=>isNaN(e)))){const i=e.dragRotate.isEnabled()&&e.touchZoomRotate.isEnabled()?+(t[3]||0):e.getBearing();return e.jumpTo({center:[+t[2],+t[1]],zoom:+t[0],bearing:i,pitch:+(t[4]||0)}),!0}return!1}_updateHashUnthrottled(){const t=e.location.href.replace(/(#.+)?$/,this.getHashString());e.history.replaceState(e.history.state,null,t)}}function wm(e,t){const i=e.getCenter(),r=Math.round(100*e.getZoom())/100,n=Math.ceil((r*Math.LN2+Math.log(512/360/.5))/Math.LN10),o=Math.pow(10,n),s=Math.round(i.lng*o)/o,a=Math.round(i.lat*o)/o,l=e.getBearing(),c=e.getPitch();let u=t?`/${s}/${a}/${r}`:`${r}/${a}/${s}`;return(l||c)&&(u+="/"+Math.round(10*l)/10),c&&(u+=`/${Math.round(c)}`),u}const Em={linearity:.3,easing:C(0,0,.3,1)},Tm=L({deceleration:2500,maxSpeed:1400},Em),Sm=L({deceleration:20,maxSpeed:1400},Em),Am=L({deceleration:1e3,maxSpeed:360},Em),Cm=L({deceleration:1e3,maxSpeed:90},Em);class HandlerInertia{constructor(e){this._map=e,this.clear()}clear(){this._inertiaBuffer=[]}record(e){this._drainInertiaBuffer(),this._inertiaBuffer.push({time:it.now(),settings:e})}_drainInertiaBuffer(){const e=this._inertiaBuffer,t=it.now();for(;e.length>0&&t-e[0].time>160;)e.shift()}_onMoveEnd(e){if(this._map._prefersReducedMotion())return;if(this._drainInertiaBuffer(),this._inertiaBuffer.length<2)return;const t={zoom:0,bearing:0,pitch:0,pan:new g(0,0),pinchAround:void 0,around:void 0};for(const{settings:e}of this._inertiaBuffer)t.zoom+=e.zoomDelta||0,t.bearing+=e.bearingDelta||0,t.pitch+=e.pitchDelta||0,e.panDelta&&t.pan._add(e.panDelta),e.around&&(t.around=e.around),e.pinchAround&&(t.pinchAround=e.pinchAround);const i=this._inertiaBuffer[this._inertiaBuffer.length-1].time-this._inertiaBuffer[0].time,r={};if(t.pan.mag()){const n=Mm(t.pan.mag(),i,L({},Tm,e||{}));r.offset=t.pan.mult(n.amount/t.pan.mag()),r.center=this._map.transform.center,Im(r,n)}if(t.zoom){const e=Mm(t.zoom,i,Sm);r.zoom=this._map.transform.zoom+e.amount,Im(r,e)}if(t.bearing){const e=Mm(t.bearing,i,Am);r.bearing=this._map.transform.bearing+M(e.amount,-179,179),Im(r,e)}if(t.pitch){const e=Mm(t.pitch,i,Cm);r.pitch=this._map.transform.pitch+e.amount,Im(r,e)}if(r.zoom||r.bearing){const e=void 0===t.pinchAround?t.around:t.pinchAround;r.around=e?this._map.unproject(e):this._map.getCenter()}return this.clear(),r.noMoveStart=!0,r}}function Im(e,t){(!e.duration||e.duration<t.duration)&&(e.duration=t.duration,e.easing=t.easing)}function Mm(e,t,i){const{maxSpeed:r,linearity:n,deceleration:o}=i,s=M(e*n/(t/1e3),-r,r),a=Math.abs(s)/(o*n);return{easing:i.easing,duration:1e3*a,amount:s*(a/2)}}class MapMouseEvent extends Event{preventDefault(){this._defaultPrevented=!0}get defaultPrevented(){return this._defaultPrevented}constructor(e,t,i,r={}){const n=dt(t.getCanvasContainer(),i);super(e,L({point:n,lngLat:t.unproject(n),originalEvent:i},r)),this._defaultPrevented=!1,this.target=t}}class MapTouchEvent extends Event{preventDefault(){this._defaultPrevented=!0}get defaultPrevented(){return this._defaultPrevented}constructor(e,t,i){const r="touchend"===e?i.changedTouches:i.touches,n=pt(t.getCanvasContainer(),r),o=n.map((e=>t.unproject(e))),s=n.reduce(((e,t,i,r)=>e.add(t.div(r.length))),new g(0,0));super(e,{points:n,point:s,lngLats:o,lngLat:t.unproject(s),originalEvent:i}),this._defaultPrevented=!1}}class MapWheelEvent extends Event{preventDefault(){this._defaultPrevented=!0}get defaultPrevented(){return this._defaultPrevented}constructor(e,t,i){super(e,{originalEvent:i}),this._defaultPrevented=!1}}class MapEventHandler{constructor(e,t){this._map=e,this._clickTolerance=t.clickTolerance}reset(){this._mousedownPos=void 0}wheel(e){return this._firePreventable(new MapWheelEvent(e.type,this._map,e))}mousedown(e,t){return this._mousedownPos=t,this._firePreventable(new MapMouseEvent(e.type,this._map,e))}mouseup(e){this._map.fire(new MapMouseEvent(e.type,this._map,e))}preclick(e){const t=L({},e);t.type="preclick",this._map.fire(new MapMouseEvent(t.type,this._map,t))}click(e,t){this._mousedownPos&&this._mousedownPos.dist(t)>=this._clickTolerance||(this.preclick(e),this._map.fire(new MapMouseEvent(e.type,this._map,e)))}dblclick(e){return this._firePreventable(new MapMouseEvent(e.type,this._map,e))}mouseover(e){this._map.fire(new MapMouseEvent(e.type,this._map,e))}mouseout(e){this._map.fire(new MapMouseEvent(e.type,this._map,e))}touchstart(e){return this._firePreventable(new MapTouchEvent(e.type,this._map,e))}touchmove(e){this._map.fire(new MapTouchEvent(e.type,this._map,e))}touchend(e){this._map.fire(new MapTouchEvent(e.type,this._map,e))}touchcancel(e){this._map.fire(new MapTouchEvent(e.type,this._map,e))}_firePreventable(e){if(this._map.fire(e),e.defaultPrevented)return{}}isEnabled(){return!0}isActive(){return!1}enable(){}disable(){}}class BlockableMapEventHandler{constructor(e){this._map=e}reset(){this._delayContextMenu=!1,this._contextMenuEvent=void 0}mousemove(e){this._map.fire(new MapMouseEvent(e.type,this._map,e))}mousedown(){this._delayContextMenu=!0}mouseup(){this._delayContextMenu=!1,this._contextMenuEvent&&(this._map.fire(new MapMouseEvent("contextmenu",this._map,this._contextMenuEvent)),delete this._contextMenuEvent)}contextmenu(e){this._delayContextMenu?this._contextMenuEvent=e:this._map.fire(new MapMouseEvent(e.type,this._map,e)),this._map.listens("contextmenu")&&e.preventDefault()}isEnabled(){return!0}isActive(){return!1}enable(){}disable(){}}class BoxZoomHandler{constructor(e,t){this._map=e,this._el=e.getCanvasContainer(),this._container=e.getContainer(),this._clickTolerance=t.clickTolerance||1}isEnabled(){return!!this._enabled}isActive(){return!!this._active}enable(){this.isEnabled()||(this._enabled=!0)}disable(){this.isEnabled()&&(this._enabled=!1)}mousedown(e,t){this.isEnabled()&&e.shiftKey&&0===e.button&&(lt(),this._startPos=this._lastPos=t,this._active=!0)}mousemoveWindow(e,t){if(!this._active)return;const i=t,r=this._startPos,n=this._lastPos;if(!r||!n||n.equals(i)||!this._box&&i.dist(r)<this._clickTolerance)return;this._lastPos=i,this._box||(this._box=rt("div","mapboxgl-boxzoom",this._container),this._container.classList.add("mapboxgl-crosshair"),this._fireEvent("boxzoomstart",e));const o=Math.min(r.x,i.x),s=Math.max(r.x,i.x),a=Math.min(r.y,i.y),l=Math.max(r.y,i.y);this._map._requestDomTask((()=>{this._box&&(this._box.style.transform=`translate(${o}px,${a}px)`,this._box.style.width=s-o+"px",this._box.style.height=l-a+"px")}))}mouseupWindow(e,t){if(!this._active)return;const i=this._startPos,r=t;if(i&&0===e.button){if(this.reset(),ht(),i.x!==r.x||i.y!==r.y)return this._map.fire(new Event("boxzoomend",{originalEvent:e})),{cameraAnimation:e=>e.fitScreenCoordinates(i,r,this._map.getBearing(),{linear:!1})};this._fireEvent("boxzoomcancel",e)}}keydown(e){this._active&&27===e.keyCode&&(this.reset(),this._fireEvent("boxzoomcancel",e))}blur(){this.reset()}reset(){this._active=!1,this._container.classList.remove("mapboxgl-crosshair"),this._box&&(this._box.remove(),this._box=null),ct(),delete this._startPos,delete this._lastPos}_fireEvent(e,t){return this._map.fire(new Event(e,{originalEvent:t}))}}function Pm(e,t){const i={};for(let r=0;r<e.length;r++)i[e[r].identifier]=t[r];return i}class SingleTapRecognizer{constructor(e){this.reset(),this.numTouches=e.numTouches}reset(){this.centroid=void 0,this.startTime=0,this.touches={},this.aborted=!1}touchstart(e,t,i){(this.centroid||i.length>this.numTouches)&&(this.aborted=!0),this.aborted||(0===this.startTime&&(this.startTime=e.timeStamp),i.length===this.numTouches&&(this.centroid=function(e){const t=new g(0,0);for(const i of e)t._add(i);return t.div(e.length)}(t),this.touches=Pm(i,t)))}touchmove(e,t,i){if(this.aborted||!this.centroid)return;const r=Pm(i,t);for(const e in this.touches){const t=r[e];(!t||t.dist(this.touches[e])>30)&&(this.aborted=!0)}}touchend(e,t,i){if((!this.centroid||e.timeStamp-this.startTime>500)&&(this.aborted=!0),0===i.length){const e=!this.aborted&&this.centroid;if(this.reset(),e)return e}}}class TapRecognizer{constructor(e){this.singleTap=new SingleTapRecognizer(e),this.numTaps=e.numTaps,this.reset()}reset(){this.lastTime=1/0,this.lastTap=void 0,this.count=0,this.singleTap.reset()}touchstart(e,t,i){this.singleTap.touchstart(e,t,i)}touchmove(e,t,i){this.singleTap.touchmove(e,t,i)}touchend(e,t,i){const r=this.singleTap.touchend(e,t,i);if(r){const t=e.timeStamp-this.lastTime<500,i=!this.lastTap||this.lastTap.dist(r)<30;if(t&&i||this.reset(),this.count++,this.lastTime=e.timeStamp,this.lastTap=r,this.count===this.numTaps)return this.reset(),r}}}class TapZoomHandler{constructor(){this._zoomIn=new TapRecognizer({numTouches:1,numTaps:2}),this._zoomOut=new TapRecognizer({numTouches:2,numTaps:1}),this.reset()}reset(){this._active=!1,this._zoomIn.reset(),this._zoomOut.reset()}touchstart(e,t,i){this._zoomIn.touchstart(e,t,i),this._zoomOut.touchstart(e,t,i)}touchmove(e,t,i){this._zoomIn.touchmove(e,t,i),this._zoomOut.touchmove(e,t,i)}touchend(e,t,i){const r=this._zoomIn.touchend(e,t,i),n=this._zoomOut.touchend(e,t,i);return r?(this._active=!0,e.preventDefault(),setTimeout((()=>this.reset()),0),{cameraAnimation:t=>t.easeTo({duration:300,zoom:t.getZoom()+1,around:t.unproject(r)},{originalEvent:e})}):n?(this._active=!0,e.preventDefault(),setTimeout((()=>this.reset()),0),{cameraAnimation:t=>t.easeTo({duration:300,zoom:t.getZoom()-1,around:t.unproject(n)},{originalEvent:e})}):void 0}touchcancel(){this.reset()}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}}const Dm={0:1,2:2};class MouseHandler{constructor(e){this.reset(),this._clickTolerance=e.clickTolerance||1}blur(){this.reset()}reset(){this._active=!1,this._moved=!1,this._lastPoint=void 0,this._eventButton=void 0}_correctButton(e,t){return!1}_move(e,t){return{}}mousedown(e,t){if(this._lastPoint)return;const i=ft(e);this._correctButton(e,i)&&(this._lastPoint=t,this._eventButton=i)}mousemoveWindow(e,t){const i=this._lastPoint;if(i)if(e.preventDefault(),null!=this._eventButton&&function(e,t){const i=Dm[t];return void 0===e.buttons||(e.buttons&i)!==i}(e,this._eventButton))this.reset();else if(this._moved||!(t.dist(i)<this._clickTolerance))return this._moved=!0,this._lastPoint=t,this._move(i,t)}mouseupWindow(e){this._lastPoint&&ft(e)===this._eventButton&&(this._moved&&ht(),this.reset())}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}}class MousePanHandler extends MouseHandler{mousedown(e,t){super.mousedown(e,t),this._lastPoint&&(this._active=!0)}_correctButton(e,t){return 0===t&&!e.ctrlKey}_move(e,t){return{around:t,panDelta:t.sub(e)}}}class MouseRotateHandler extends MouseHandler{_correctButton(e,t){return 0===t&&e.ctrlKey||2===t}_move(e,t){const i=.8*(t.x-e.x);if(i)return this._active=!0,{bearingDelta:i}}contextmenu(e){e.preventDefault()}}class MousePitchHandler extends MouseHandler{_correctButton(e,t){return 0===t&&e.ctrlKey||2===t}_move(e,t){const i=-.5*(t.y-e.y);if(i)return this._active=!0,{pitchDelta:i}}contextmenu(e){e.preventDefault()}}class TouchPanHandler{constructor(e,t){this._map=e,this._el=e.getCanvasContainer(),this._minTouches=1,this._clickTolerance=t.clickTolerance||1,this.reset(),j(["_addTouchPanBlocker","_showTouchPanBlockerAlert"],this)}reset(){this._active=!1,this._touches={},this._sum=new g(0,0)}touchstart(e,t,i){return this._calculateTransform(e,t,i)}touchmove(e,t,i){if(this._active&&!(i.length<this._minTouches)){if(this._map._cooperativeGestures&&!this._map.isMoving()){if(1===i.length&&!te())return void this._showTouchPanBlockerAlert();"hidden"!==this._alertContainer.style.visibility&&(this._alertContainer.style.visibility="hidden",clearTimeout(this._alertTimer))}return e.cancelable&&e.preventDefault(),this._calculateTransform(e,t,i)}}touchend(e,t,i){this._calculateTransform(e,t,i),this._active&&i.length<this._minTouches&&this.reset()}touchcancel(){this.reset()}_calculateTransform(e,t,i){i.length>0&&(this._active=!0);const r=Pm(i,t),n=new g(0,0),o=new g(0,0);let s=0;for(const e in r){const t=r[e],i=this._touches[e];i&&(n._add(t),o._add(t.sub(i)),s++,r[e]=t)}if(this._touches=r,s<this._minTouches||!o.mag())return;const a=o.div(s);return this._sum._add(a),this._sum.mag()<this._clickTolerance?void 0:{around:n.div(s),panDelta:a}}enable(){this._enabled=!0,this._map._cooperativeGestures&&(this._addTouchPanBlocker(),this._el.classList.add("mapboxgl-touch-pan-blocker-override","mapboxgl-scrollable-page"))}disable(){this._enabled=!1,this._map._cooperativeGestures&&(clearTimeout(this._alertTimer),this._alertContainer.remove(),this._el.classList.remove("mapboxgl-touch-pan-blocker-override","mapboxgl-scrollable-page")),this.reset()}isEnabled(){return!!this._enabled}isActive(){return!!this._active}_addTouchPanBlocker(){this._map&&!this._alertContainer&&(this._alertContainer=rt("div","mapboxgl-touch-pan-blocker",this._map._container),this._alertContainer.textContent=this._map._getUIString("TouchPanBlocker.Message"),this._alertContainer.style.fontSize=`${Math.max(10,Math.min(24,Math.floor(.05*this._el.clientWidth)))}px`)}_showTouchPanBlockerAlert(){this._alertContainer.style.visibility="visible",this._alertContainer.classList.add("mapboxgl-touch-pan-blocker-show"),this._alertContainer.setAttribute("role","alert"),clearTimeout(this._alertTimer),this._alertTimer=setTimeout((()=>{this._alertContainer.classList.remove("mapboxgl-touch-pan-blocker-show"),this._alertContainer.setAttribute("role","null")}),500)}}class TwoTouchHandler{constructor(){this.reset()}reset(){this._active=!1,this._firstTwoTouches=void 0}_start(e){}_move(e,t,i){return{}}touchstart(e,t,i){this._firstTwoTouches||i.length<2||(this._firstTwoTouches=[i[0].identifier,i[1].identifier],this._start([t[0],t[1]]))}touchmove(e,t,i){const r=this._firstTwoTouches;if(!r)return;e.preventDefault();const[n,o]=r,s=zm(i,t,n),a=zm(i,t,o);if(!s||!a)return;const l=this._aroundCenter?null:s.add(a).div(2);return this._move([s,a],l,e)}touchend(e,t,i){if(!this._firstTwoTouches)return;const[r,n]=this._firstTwoTouches,o=zm(i,t,r),s=zm(i,t,n);o&&s||(this._active&&ht(),this.reset())}touchcancel(){this.reset()}enable(e){this._enabled=!0,this._aroundCenter=!!e&&"center"===e.around}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}}function zm(e,t,i){for(let r=0;r<e.length;r++)if(e[r].identifier===i)return t[r]}function km(e,t){return Math.log(e/t)/Math.LN2}class TouchZoomHandler extends TwoTouchHandler{reset(){super.reset(),this._distance=0,this._startDistance=0}_start(e){this._startDistance=this._distance=e[0].dist(e[1])}_move(e,t){const i=this._distance;if(this._distance=e[0].dist(e[1]),this._active||!(Math.abs(km(this._distance,this._startDistance))<.1))return this._active=!0,{zoomDelta:km(this._distance,i),pinchAround:t}}}function Lm(e,t){return 180*e.angleWith(t)/Math.PI}class TouchRotateHandler extends TwoTouchHandler{reset(){super.reset(),this._minDiameter=0,this._startVector=void 0,this._vector=void 0}_start(e){this._startVector=this._vector=e[0].sub(e[1]),this._minDiameter=e[0].dist(e[1])}_move(e,t){const i=this._vector;if(this._vector=e[0].sub(e[1]),i&&(this._active||!this._isBelowThreshold(this._vector)))return this._active=!0,{bearingDelta:Lm(this._vector,i),pinchAround:t}}_isBelowThreshold(e){this._minDiameter=Math.min(this._minDiameter,e.mag());const t=25/(Math.PI*this._minDiameter)*360,i=this._startVector;if(!i)return!1;const r=Lm(e,i);return Math.abs(r)<t}}function Bm(e){return Math.abs(e.y)>Math.abs(e.x)}class TouchPitchHandler extends TwoTouchHandler{constructor(e){super(),this._map=e}reset(){super.reset(),this._valid=void 0,this._firstMove=void 0,this._lastPoints=void 0}_start(e){this._lastPoints=e,Bm(e[0].sub(e[1]))&&(this._valid=!1)}_move(e,t,i){const r=this._lastPoints;if(!r)return;const n=e[0].sub(r[0]),o=e[1].sub(r[1]);return this._map._cooperativeGestures&&!te()&&i.touches.length<3||(this._valid=this.gestureBeginsVertically(n,o,i.timeStamp),!this._valid)?void 0:(this._lastPoints=e,this._active=!0,{pitchDelta:(n.y+o.y)/2*-.5})}gestureBeginsVertically(e,t,i){if(void 0!==this._valid)return this._valid;const r=e.mag()>=2,n=t.mag()>=2;if(!r&&!n)return;if(!r||!n)return null==this._firstMove&&(this._firstMove=i),i-this._firstMove<100&&void 0;const o=e.y>0==t.y>0;return Bm(e)&&Bm(t)&&o}}const Rm={panStep:100,bearingStep:15,pitchStep:10};class KeyboardHandler{constructor(){const e=Rm;this._panStep=e.panStep,this._bearingStep=e.bearingStep,this._pitchStep=e.pitchStep,this._rotationDisabled=!1}blur(){this.reset()}reset(){this._active=!1}keydown(e){if(e.altKey||e.ctrlKey||e.metaKey)return;let t=0,i=0,r=0,n=0,o=0;switch(e.keyCode){case 61:case 107:case 171:case 187:t=1;break;case 189:case 109:case 173:t=-1;break;case 37:e.shiftKey?i=-1:(e.preventDefault(),n=-1);break;case 39:e.shiftKey?i=1:(e.preventDefault(),n=1);break;case 38:e.shiftKey?r=1:(e.preventDefault(),o=-1);break;case 40:e.shiftKey?r=-1:(e.preventDefault(),o=1);break;default:return}return this._rotationDisabled&&(i=0,r=0),{cameraAnimation:s=>{const a=s.getZoom();s.easeTo({duration:300,easeId:"keyboardHandler",easing:Fm,zoom:t?Math.round(a)+t*(e.shiftKey?2:1):a,bearing:s.getBearing()+i*this._bearingStep,pitch:s.getPitch()+r*this._pitchStep,offset:[-n*this._panStep,-o*this._panStep],center:s.getCenter()},{originalEvent:e})}}}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}disableRotation(){this._rotationDisabled=!0}enableRotation(){this._rotationDisabled=!1}}function Fm(e){return e*(2-e)}const Om=4.000244140625;class ScrollZoomHandler{constructor(e,t){this._map=e,this._el=e.getCanvasContainer(),this._handler=t,this._delta=0,this._defaultZoomRate=.01,this._wheelZoomRate=.0022222222222222222,j(["_onTimeout","_addScrollZoomBlocker","_showBlockerAlert"],this)}setZoomRate(e){this._defaultZoomRate=e}setWheelZoomRate(e){this._wheelZoomRate=e}isEnabled(){return!!this._enabled}isActive(){return this._active||void 0!==this._finishTimeout}isZooming(){return!!this._zooming}enable(e){this.isEnabled()||(this._enabled=!0,this._aroundCenter=!!e&&"center"===e.around,this._map._cooperativeGestures&&this._addScrollZoomBlocker())}disable(){this.isEnabled()&&(this._enabled=!1,this._map._cooperativeGestures&&(clearTimeout(this._alertTimer),this._alertContainer.remove()))}wheel(t){if(!this.isEnabled())return;if(this._map._cooperativeGestures){if(!(t.ctrlKey||t.metaKey||this.isZooming()||te()))return void this._showBlockerAlert();"hidden"!==this._alertContainer.style.visibility&&(this._alertContainer.style.visibility="hidden",clearTimeout(this._alertTimer))}let i=t.deltaMode===e.WheelEvent.DOM_DELTA_LINE?40*t.deltaY:t.deltaY;const r=it.now(),n=r-(this._lastWheelEventTime||0);this._lastWheelEventTime=r,0!==i&&i%Om==0?this._type="wheel":0!==i&&Math.abs(i)<4?this._type="trackpad":n>400?(this._type=null,this._lastValue=i,this._timeout=setTimeout(this._onTimeout,40,t)):this._type||(this._type=Math.abs(n*i)<200?"trackpad":"wheel",this._timeout&&(clearTimeout(this._timeout),this._timeout=null,i+=this._lastValue)),t.shiftKey&&i&&(i/=4),this._type&&(this._lastWheelEvent=t,this._delta-=i,this._active||this._start(t)),t.preventDefault()}_onTimeout(e){this._type="wheel",this._delta-=this._lastValue,this._active||this._start(e)}_start(e){if(!this._delta)return;this._frameId&&(this._frameId=null),this._active=!0,this.isZooming()||(this._zooming=!0),this._finishTimeout&&(clearTimeout(this._finishTimeout),delete this._finishTimeout);const t=dt(this._el,e);this._aroundPoint=this._aroundCenter?this._map.transform.centerPoint:t,this._aroundCoord=this._map.transform.pointCoordinate3D(this._aroundPoint),this._targetZoom=void 0,this._frameId||(this._frameId=!0,this._handler._triggerRenderFrame())}renderFrame(){if(!this._frameId)return;if(this._frameId=null,!this.isActive())return;const e=this._map.transform;"wheel"===this._type&&e.projection.wrap&&(e._center.lng>=180||e._center.lng<=-180)&&(this._prevEase=null,this._easing=null,this._lastWheelEvent=null,this._lastWheelEventTime=0);const t=()=>e._terrainEnabled()&&this._aroundCoord?e.computeZoomRelativeTo(this._aroundCoord):e.zoom;if(0!==this._delta){const i="wheel"===this._type&&Math.abs(this._delta)>Om?this._wheelZoomRate:this._defaultZoomRate;let r=2/(1+Math.exp(-Math.abs(this._delta*i)));this._delta<0&&0!==r&&(r=1/r);const n=t(),o=Math.pow(2,n),s="number"==typeof this._targetZoom?e.zoomScale(this._targetZoom):o;this._targetZoom=Math.min(e.maxZoom,Math.max(e.minZoom,e.scaleZoom(s*r))),"wheel"===this._type&&(this._startZoom=n,this._easing=this._smoothOutEasing(200)),this._delta=0}const i="number"==typeof this._targetZoom?this._targetZoom:t(),r=this._startZoom,n=this._easing;let o,s=!1;if("wheel"===this._type&&r&&n){const e=Math.min((it.now()-this._lastWheelEventTime)/200,1);o=zi(r,i,n(e)),e<1?this._frameId||(this._frameId=!0):s=!0}else o=i,s=!0;return this._active=!0,s&&(this._active=!1,this._finishTimeout=setTimeout((()=>{this._zooming=!1,this._handler._triggerRenderFrame(),delete this._targetZoom,delete this._finishTimeout}),200)),{noInertia:!0,needsRenderFrame:!s,zoomDelta:o-t(),around:this._aroundPoint,aroundCoord:this._aroundCoord,originalEvent:this._lastWheelEvent}}_smoothOutEasing(e){let t=I;if(this._prevEase){const e=this._prevEase,i=(it.now()-e.start)/e.duration,r=e.easing(i+.01)-e.easing(i),n=.27/Math.sqrt(r*r+1e-4)*.01;t=C(n,Math.sqrt(.0729-n*n),.25,1)}return this._prevEase={start:it.now(),duration:e,easing:t},t}blur(){this.reset()}reset(){this._active=!1}_addScrollZoomBlocker(){this._map&&!this._alertContainer&&(this._alertContainer=rt("div","mapboxgl-scroll-zoom-blocker",this._map._container),this._alertContainer.textContent=/(Mac|iPad)/i.test(e.navigator.userAgent)?this._map._getUIString("ScrollZoomBlocker.CmdMessage"):this._map._getUIString("ScrollZoomBlocker.CtrlMessage"),this._alertContainer.style.fontSize=`${Math.max(10,Math.min(24,Math.floor(.05*this._el.clientWidth)))}px`)}_showBlockerAlert(){this._alertContainer.style.visibility="visible",this._alertContainer.classList.add("mapboxgl-scroll-zoom-blocker-show"),this._alertContainer.setAttribute("role","alert"),clearTimeout(this._alertTimer),this._alertTimer=setTimeout((()=>{this._alertContainer.classList.remove("mapboxgl-scroll-zoom-blocker-show"),this._alertContainer.setAttribute("role","null")}),200)}}class DoubleClickZoomHandler{constructor(e,t){this._clickZoom=e,this._tapZoom=t}enable(){this._clickZoom.enable(),this._tapZoom.enable()}disable(){this._clickZoom.disable(),this._tapZoom.disable()}isEnabled(){return this._clickZoom.isEnabled()&&this._tapZoom.isEnabled()}isActive(){return this._clickZoom.isActive()||this._tapZoom.isActive()}}class ClickZoomHandler{constructor(){this.reset()}reset(){this._active=!1}blur(){this.reset()}dblclick(e,t){return e.preventDefault(),{cameraAnimation:i=>{i.easeTo({duration:300,zoom:i.getZoom()+(e.shiftKey?-1:1),around:i.unproject(t)},{originalEvent:e})}}}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}}class TapDragZoomHandler{constructor(){this._tap=new TapRecognizer({numTouches:1,numTaps:1}),this.reset()}reset(){this._active=!1,this._swipePoint=void 0,this._swipeTouch=0,this._tapTime=0,this._tap.reset()}touchstart(e,t,i){this._swipePoint||(this._tapTime&&e.timeStamp-this._tapTime>500&&this.reset(),this._tapTime?i.length>0&&(this._swipePoint=t[0],this._swipeTouch=i[0].identifier):this._tap.touchstart(e,t,i))}touchmove(e,t,i){if(this._tapTime){if(this._swipePoint){if(i[0].identifier!==this._swipeTouch)return;const r=t[0],n=r.y-this._swipePoint.y;return this._swipePoint=r,e.preventDefault(),this._active=!0,{zoomDelta:n/128}}}else this._tap.touchmove(e,t,i)}touchend(e,t,i){this._tapTime?this._swipePoint&&0===i.length&&this.reset():this._tap.touchend(e,t,i)&&(this._tapTime=e.timeStamp)}touchcancel(){this.reset()}enable(){this._enabled=!0}disable(){this._enabled=!1,this.reset()}isEnabled(){return this._enabled}isActive(){return this._active}}class DragPanHandler{constructor(e,t,i){this._el=e,this._mousePan=t,this._touchPan=i}enable(e){this._inertiaOptions=e||{},this._mousePan.enable(),this._touchPan.enable(),this._el.classList.add("mapboxgl-touch-drag-pan")}disable(){this._mousePan.disable(),this._touchPan.disable(),this._el.classList.remove("mapboxgl-touch-drag-pan")}isEnabled(){return this._mousePan.isEnabled()&&this._touchPan.isEnabled()}isActive(){return this._mousePan.isActive()||this._touchPan.isActive()}}class DragRotateHandler{constructor(e,t,i){this._pitchWithRotate=e.pitchWithRotate,this._mouseRotate=t,this._mousePitch=i}enable(){this._mouseRotate.enable(),this._pitchWithRotate&&this._mousePitch.enable()}disable(){this._mouseRotate.disable(),this._mousePitch.disable()}isEnabled(){return this._mouseRotate.isEnabled()&&(!this._pitchWithRotate||this._mousePitch.isEnabled())}isActive(){return this._mouseRotate.isActive()||this._mousePitch.isActive()}}class TouchZoomRotateHandler{constructor(e,t,i,r){this._el=e,this._touchZoom=t,this._touchRotate=i,this._tapDragZoom=r,this._rotationDisabled=!1,this._enabled=!0}enable(e){this._touchZoom.enable(e),this._rotationDisabled||this._touchRotate.enable(e),this._tapDragZoom.enable(),this._el.classList.add("mapboxgl-touch-zoom-rotate")}disable(){this._touchZoom.disable(),this._touchRotate.disable(),this._tapDragZoom.disable(),this._el.classList.remove("mapboxgl-touch-zoom-rotate")}isEnabled(){return this._touchZoom.isEnabled()&&(this._rotationDisabled||this._touchRotate.isEnabled())&&this._tapDragZoom.isEnabled()}isActive(){return this._touchZoom.isActive()||this._touchRotate.isActive()||this._tapDragZoom.isActive()}disableRotation(){this._rotationDisabled=!0,this._touchRotate.disable()}enableRotation(){this._rotationDisabled=!1,this._touchZoom.isEnabled()&&this._touchRotate.enable()}}const Um=e=>e.zoom||e.drag||e.pitch||e.rotate;class RenderFrameEvent extends Event{}class TrackingEllipsoid{constructor(){this.constants=[1,1,.01],this.radius=0}setup(e,t){const i=As([],t,e);this.radius=cs(i[2]<0?Is([],i,this.constants):[i[0],i[1],0])}projectRay(e){Is(e,e,this.constants),xs(e,e),Cs(e,e,this.constants);const t=_s([],e,this.radius);if(t[2]>0){const e=_s([],[0,0,1],vs(t,[0,0,1])),i=_s([],xs([],[t[0],t[1],0]),this.radius),r=hs([],t,_s([],As([],hs([],i,e),t),2));t[0]=r[0],t[1]=r[1]}return t}}function Vm(e){return e.panDelta&&e.panDelta.mag()||e.zoomDelta||e.bearingDelta||e.pitchDelta}class HandlerManager{constructor(t,i){this._map=t,this._el=this._map.getCanvasContainer(),this._handlers=[],this._handlersById={},this._changes=[],this._inertia=new HandlerInertia(t),this._bearingSnap=i.bearingSnap,this._previousActiveHandlers={},this._trackingEllipsoid=new TrackingEllipsoid,this._dragOrigin=null,this._eventsInProgress={},this._addDefaultHandlers(i),j(["handleEvent","handleWindowEvent"],this);const r=this._el;this._listeners=[[r,"touchstart",{passive:!0}],[r,"touchmove",{passive:!1}],[r,"touchend",void 0],[r,"touchcancel",void 0],[r,"mousedown",void 0],[r,"mousemove",void 0],[r,"mouseup",void 0],[e.document,"mousemove",{capture:!0}],[e.document,"mouseup",void 0],[r,"mouseover",void 0],[r,"mouseout",void 0],[r,"dblclick",void 0],[r,"click",void 0],[r,"keydown",{capture:!1}],[r,"keyup",void 0],[r,"wheel",{passive:!1}],[r,"contextmenu",void 0],[e,"blur",void 0]];for(const[t,i,r]of this._listeners)t.addEventListener(i,t===e.document?this.handleWindowEvent:this.handleEvent,r)}destroy(){for(const[t,i,r]of this._listeners)t.removeEventListener(i,t===e.document?this.handleWindowEvent:this.handleEvent,r)}_addDefaultHandlers(e){const t=this._map,i=t.getCanvasContainer();this._add("mapEvent",new MapEventHandler(t,e));const r=t.boxZoom=new BoxZoomHandler(t,e);this._add("boxZoom",r);const n=new TapZoomHandler,o=new ClickZoomHandler;t.doubleClickZoom=new DoubleClickZoomHandler(o,n),this._add("tapZoom",n),this._add("clickZoom",o);const s=new TapDragZoomHandler;this._add("tapDragZoom",s);const a=t.touchPitch=new TouchPitchHandler(t);this._add("touchPitch",a);const l=new MouseRotateHandler(e),c=new MousePitchHandler(e);t.dragRotate=new DragRotateHandler(e,l,c),this._add("mouseRotate",l,["mousePitch"]),this._add("mousePitch",c,["mouseRotate"]);const u=new MousePanHandler(e),h=new TouchPanHandler(t,e);t.dragPan=new DragPanHandler(i,u,h),this._add("mousePan",u),this._add("touchPan",h,["touchZoom","touchRotate"]);const d=new TouchRotateHandler,p=new TouchZoomHandler;t.touchZoomRotate=new TouchZoomRotateHandler(i,p,d,s),this._add("touchRotate",d,["touchPan","touchZoom"]),this._add("touchZoom",p,["touchPan","touchRotate"]),this._add("blockableMapEvent",new BlockableMapEventHandler(t));const f=t.scrollZoom=new ScrollZoomHandler(t,this);this._add("scrollZoom",f,["mousePan"]);const m=t.keyboard=new KeyboardHandler;this._add("keyboard",m);for(const i of["boxZoom","doubleClickZoom","tapDragZoom","touchPitch","dragRotate","dragPan","touchZoomRotate","scrollZoom","keyboard"])e.interactive&&e[i]&&t[i].enable(e[i])}_add(e,t,i){this._handlers.push({handlerName:e,handler:t,allowed:i}),this._handlersById[e]=t}stop(e){if(!this._updatingCamera){for(const{handler:e}of this._handlers)e.reset();this._inertia.clear(),this._fireEvents({},{},e),this._changes=[]}}isActive(){for(const{handler:e}of this._handlers)if(e.isActive())return!0;return!1}isZooming(){return!!this._eventsInProgress.zoom||this._map.scrollZoom.isZooming()}isRotating(){return!!this._eventsInProgress.rotate}isMoving(){return!!Um(this._eventsInProgress)||this.isZooming()}_isDragging(){return!!this._eventsInProgress.drag}_blockedByActive(e,t,i){for(const r in e)if(r!==i&&(!t||t.indexOf(r)<0))return!0;return!1}handleWindowEvent(e){this.handleEvent(e,`${e.type}Window`)}_getMapTouches(e){const t=[];for(const i of e)this._el.contains(i.target)&&t.push(i);return t}handleEvent(e,t){this._updatingCamera=!0;const i="renderFrame"===e.type,r=i?void 0:e,n={needsRenderFrame:!1},o={},s={},a=e.touches?this._getMapTouches(e.touches):void 0,l=a?pt(this._el,a):i?void 0:dt(this._el,e);for(const{handlerName:i,handler:c,allowed:u}of this._handlers){if(!c.isEnabled())continue;let h;this._blockedByActive(s,u,i)?c.reset():c[t||e.type]&&(h=c[t||e.type](e,l,a),this.mergeHandlerResult(n,o,h,i,r),h&&h.needsRenderFrame&&this._triggerRenderFrame()),(h||c.isActive())&&(s[i]=c)}const c={};for(const e in this._previousActiveHandlers)s[e]||(c[e]=r);this._previousActiveHandlers=s,(Object.keys(c).length||Vm(n))&&(this._changes.push([n,o,c]),this._triggerRenderFrame()),(Object.keys(s).length||Vm(n))&&this._map._stop(!0),this._updatingCamera=!1;const{cameraAnimation:u}=n;u&&(this._inertia.clear(),this._fireEvents({},{},!0),this._changes=[],u(this._map))}mergeHandlerResult(e,t,i,r,n){if(!i)return;L(e,i);const o={handlerName:r,originalEvent:i.originalEvent||n};void 0!==i.zoomDelta&&(t.zoom=o),void 0!==i.panDelta&&(t.drag=o),void 0!==i.pitchDelta&&(t.pitch=o),void 0!==i.bearingDelta&&(t.rotate=o)}_applyChanges(){const e={},t={},i={};for(const[r,n,o]of this._changes)r.panDelta&&(e.panDelta=(e.panDelta||new g(0,0))._add(r.panDelta)),r.zoomDelta&&(e.zoomDelta=(e.zoomDelta||0)+r.zoomDelta),r.bearingDelta&&(e.bearingDelta=(e.bearingDelta||0)+r.bearingDelta),r.pitchDelta&&(e.pitchDelta=(e.pitchDelta||0)+r.pitchDelta),void 0!==r.around&&(e.around=r.around),void 0!==r.aroundCoord&&(e.aroundCoord=r.aroundCoord),void 0!==r.pinchAround&&(e.pinchAround=r.pinchAround),r.noInertia&&(e.noInertia=r.noInertia),L(t,n),L(i,o);this._updateMapTransform(e,t,i),this._changes=[]}_updateMapTransform(e,t,i){const r=this._map,n=r.transform,o=e=>[e.x,e.y,e.z];if((e=>{const t=this._eventsInProgress.drag;return t&&!this._handlersById[t.handlerName].isActive()})()&&!Vm(e)){const e=n.zoom;n.cameraElevationReference="sea",n.recenterOnTerrain(),n.cameraElevationReference="ground",e!==n.zoom&&this._map._update(!0)}if(n._isCameraConstrained&&r._stop(!0),!Vm(e))return void this._fireEvents(t,i,!0);let{panDelta:s,zoomDelta:a,bearingDelta:l,pitchDelta:c,around:u,aroundCoord:h,pinchAround:d}=e;n._isCameraConstrained&&(a>0&&(a=0),n._isCameraConstrained=!1),void 0!==d&&(u=d),(a||(e=>t[e]&&!this._eventsInProgress[e])("drag"))&&u&&(this._dragOrigin=o(n.pointCoordinate3D(u)),this._trackingEllipsoid.setup(n._camera.position,this._dragOrigin)),n.cameraElevationReference="sea",r._stop(!0),u=u||r.transform.centerPoint,l&&(n.bearing+=l),c&&(n.pitch+=c),n._updateCameraState();const p=[0,0,0];if(s)if("mercator"===n.projection.name){const e=this._trackingEllipsoid.projectRay(n.screenPointToMercatorRay(u).dir),t=this._trackingEllipsoid.projectRay(n.screenPointToMercatorRay(u.sub(s)).dir);p[0]=t[0]-e[0],p[1]=t[1]-e[1]}else{const e=n.pointCoordinate(u);if("globe"===n.projection.name){s=s.rotate(-n.angle);const t=n._pixelsPerMercatorPixel/n.worldSize;p[0]=-s.x*Ua(Ra(e.y))*t,p[1]=-s.y*Ua(n.center.lat)*t}else{const t=n.pointCoordinate(u.sub(s));e&&t&&(p[0]=t.x-e.x,p[1]=t.y-e.y)}}const f=n.zoom,m=[0,0,0];if(a){const e=o(h||n.pointCoordinate3D(u)),t={dir:xs([],As([],e,n._camera.position))};if(t.dir[2]<0){const i=n.zoomDeltaToMovement(e,a);_s(m,t.dir,i)}}const _=hs(p,p,m);n._translateCameraConstrained(_),a&&Math.abs(n.zoom-f)>1e-4&&n.recenterOnTerrain(),n.cameraElevationReference="ground",this._map._update(),e.noInertia||this._inertia.record(e),this._fireEvents(t,i,!0)}_fireEvents(e,t,i){const r=Um(this._eventsInProgress),n=Um(e),o={};for(const t in e){const{originalEvent:i}=e[t];this._eventsInProgress[t]||(o[`${t}start`]=i),this._eventsInProgress[t]=e[t]}!r&&n&&this._fireEvent("movestart",n.originalEvent);for(const e in o)this._fireEvent(e,o[e]);n&&this._fireEvent("move",n.originalEvent);for(const t in e){const{originalEvent:i}=e[t];this._fireEvent(t,i)}const s={};let a;for(const e in this._eventsInProgress){const{handlerName:i,originalEvent:r}=this._eventsInProgress[e];this._handlersById[i].isActive()||(delete this._eventsInProgress[e],a=t[i]||r,s[`${e}end`]=a)}for(const e in s)this._fireEvent(e,s[e]);const l=Um(this._eventsInProgress);if(i&&(r||n)&&!l){this._updatingCamera=!0;const e=this._inertia._onMoveEnd(this._map.dragPan._inertiaOptions),t=e=>0!==e&&-this._bearingSnap<e&&e<this._bearingSnap;e?(t(e.bearing||this._map.getBearing())&&(e.bearing=0),this._map.easeTo(e,{originalEvent:a})):(this._map.fire(new Event("moveend",{originalEvent:a})),t(this._map.getBearing())&&this._map.resetNorth()),this._updatingCamera=!1}}_fireEvent(e,t){this._map.fire(new Event(e,t?{originalEvent:t}:{}))}_requestFrame(){return this._map.triggerRepaint(),this._map._renderTaskQueue.add((e=>{this._frameId=void 0,this.handleEvent(new RenderFrameEvent("renderFrame",{timeStamp:e})),this._applyChanges()}))}_triggerRenderFrame(){void 0===this._frameId&&(this._frameId=this._requestFrame())}}const jm="map.setFreeCameraOptions(...) and map.getFreeCameraOptions() are not yet supported for non-mercator projections.";class Camera extends Evented{constructor(e,t){super(),this._moving=!1,this._zooming=!1,this.transform=e,this._bearingSnap=t.bearingSnap,this._respectPrefersReducedMotion=!1!==t.respectPrefersReducedMotion,j(["_renderFrameCallback"],this)}getCenter(){return new Pa(this.transform.center.lng,this.transform.center.lat)}setCenter(e,t){return this.jumpTo({center:e},t)}panBy(e,t,i){return e=g.convert(e).mult(-1),this.panTo(this.transform.center,L({offset:e},t),i)}panTo(e,t,i){return this.easeTo(L({center:e},t),i)}getZoom(){return this.transform.zoom}setZoom(e,t){return this.jumpTo({zoom:e},t),this}zoomTo(e,t,i){return this.easeTo(L({zoom:e},t),i)}zoomIn(e,t){return this.zoomTo(this.getZoom()+1,e,t),this}zoomOut(e,t){return this.zoomTo(this.getZoom()-1,e,t),this}getBearing(){return this.transform.bearing}setBearing(e,t){return this.jumpTo({bearing:e},t),this}getPadding(){return this.transform.padding}setPadding(e,t){return this.jumpTo({padding:e},t),this}rotateTo(e,t,i){return this.easeTo(L({bearing:e},t),i)}resetNorth(e,t){return this.rotateTo(0,L({duration:1e3},e),t),this}resetNorthPitch(e,t){return this.easeTo(L({bearing:0,pitch:0,duration:1e3},e),t),this}snapToNorth(e,t){return Math.abs(this.getBearing())<this._bearingSnap?this.resetNorth(e,t):this}getPitch(){return this.transform.pitch}setPitch(e,t){return this.jumpTo({pitch:e},t),this}cameraForBounds(e,t){e=LngLatBounds.convert(e);const i=t&&t.bearing||0,r=t&&t.pitch||0,n=e.getNorthWest(),o=e.getSouthEast();return this._cameraForBounds(this.transform,n,o,i,r,t)}_extendCameraOptions(e){const t={top:0,bottom:0,right:0,left:0};if("number"==typeof(e=L({padding:t,offset:[0,0],maxZoom:this.transform.maxZoom},e)).padding){const t=e.padding;e.padding={top:t,bottom:t,right:t,left:t}}return e.padding=L(t,e.padding),e}_minimumAABBFrustumDistance(e,t){const i=t.max[0]-t.min[0],r=t.max[1]-t.min[1];return i/r>e.aspect?i/(2*Math.tan(.5*e.fovX)*e.aspect):r/(2*Math.tan(.5*e.fovY)*e.aspect)}_cameraForBoundsOnGlobe(e,t,i,r,n,o){const s=e.clone(),a=this._extendCameraOptions(o);s.bearing=r,s.pitch=n;const l=Pa.convert(t),c=Pa.convert(i),u=.5*(l.lat+c.lat),h=.5*(l.lng+c.lng),d=ca(u,h),p=xs([],d),f=xs([],bs([],p,[0,1,0])),m=bs([],f,p),_=[f[0],f[1],f[2],0,m[0],m[1],m[2],0,p[0],p[1],p[2],0,0,0,0,1],g=[d,ca(l.lat,l.lng),ca(c.lat,l.lng),ca(c.lat,c.lng),ca(l.lat,c.lng),ca(u,l.lng),ca(u,c.lng),ca(l.lat,h),ca(c.lat,h)];let y=Aabb.fromPoints(g.map((e=>[vs(f,e),vs(m,e),vs(p,e)])));const x=ws([],y.center,_);var v,b,E,T;0==(b=(v=x)[0])*b+(E=v[1])*E+(T=v[2])*T&&function(e,t,i,r){e[0]=0,e[1]=0,e[2]=1}(x),xs(x,x),_s(x,x,Zs),s.center=function([e,t,i]){const r=Math.hypot(e,t,i),n=Math.atan2(e,i),o=.5*Math.PI-Math.acos(-t/r);return new Pa(w(n),w(o))}(x);const S=s.getWorldToCameraMatrix(),A=Ho(new Float64Array(16),S);y=Aabb.applyTransform(y,Xo([],S,_)),ws(x,x,S);const C=.5*(y.max[2]-y.min[2]),I=this._minimumAABBFrustumDistance(s,y),M=_s([],[0,0,1],C),P=hs(M,x,M),D=I+(0===s.pitch?0:ys(x,P)),z=s.globeCenterInViewSpace,k=As([],x,[z[0],z[1],z[2]]);xs(k,k),_s(k,k,D);const L=hs([],x,k);ws(L,L,A);const B=Ia/Zs,R=cs(L),F=La(Math.max(R*B-Ia,Number.EPSILON),0),O=Math.min(s.zoomFromMercatorZAdjusted(F),a.maxZoom);return O>.5*(Gs+qs)?(s.setProjection({name:"mercator"}),s.zoom=O,this._cameraForBounds(s,t,i,r,n,o)):{center:s.center,zoom:O,bearing:r,pitch:n}}queryTerrainElevation(e,t){const i=this.transform.elevation;return i?(t=L({},{exaggerated:!0},t),i.getAtPoint(MercatorCoordinate.fromLngLat(e),null,t.exaggerated)):null}_cameraForBounds(e,t,i,r,n,o){if("globe"===e.projection.name)return this._cameraForBoundsOnGlobe(e,t,i,r,n,o);const s=e.clone(),a=this._extendCameraOptions(o),l=s.padding;s.bearing=r,s.pitch=n;const c=Pa.convert(t),u=Pa.convert(i),h=new Pa(c.lng,u.lat),d=new Pa(u.lng,c.lat),p=s.project(c),f=s.project(u),m=this.queryTerrainElevation(c),_=this.queryTerrainElevation(u),y=this.queryTerrainElevation(h),x=this.queryTerrainElevation(d),v=[[p.x,p.y,Math.min(m||0,_||0,y||0,x||0)],[f.x,f.y,Math.max(m||0,_||0,y||0,x||0)]];let w=Aabb.fromPoints(v);const E=s.getWorldToCameraMatrix(),T=Ho(new Float64Array(16),E);w=Aabb.applyTransform(w,E);const S=As([],w.max,w.min),A=l.left||0,C=l.right||0,I=l.bottom||0,M=l.top||0,{left:P,right:D,top:z,bottom:k}=a.padding,L=.5*(A+C),B=.5*(M+I),R=Math.min(s.scaleZoom(s.scale*Math.min((s.width-(A+C+P+D))/S[0],(s.height-(I+M+k+z))/S[1])),a.maxZoom),F=s.scale/s.zoomScale(R);w=new Aabb([w.min[0]-(P+L)*F,w.min[1]-(k+B)*F,w.min[2]],[w.max[0]+(D+L)*F,w.max[1]+(z+B)*F,w.max[2]]);const O=.5*S[2],U=this._minimumAABBFrustumDistance(s,w),V=[0,0,1,0];zs(V,V,E),Ds(V,V);const j=_s([],V,U+O),N=hs([],w.center,j),G=("number"==typeof a.offset.x&&"number"==typeof a.offset.y?new g(a.offset.x,a.offset.y):g.convert(a.offset)).rotate(-b(r));w.center[0]-=G.x*F,w.center[1]+=G.y*F,ws(w.center,w.center,T),ws(N,N,T);const q=[w.center[0],w.center[1],N[2]*s.pixelsPerMeter];_s(q,q,1/s.worldSize);const Z=Ba(q[0]),$=Ra(q[1]),W=Math.min(s._zoomFromMercatorZ(q[2]),a.maxZoom),H=new Pa(Z,$);return s.mercatorFromTransition&&W<.5*(Gs+qs)?(s.setProjection({name:"globe"}),s.zoom=W,this._cameraForBounds(s,t,i,r,n,o)):{center:H,zoom:W,bearing:r,pitch:n}}fitBounds(e,t,i){const r=this.cameraForBounds(e,t);return this._fitInternal(r,t,i)}fitScreenCoordinates(e,t,i,r,n){const o=g.convert(e),s=g.convert(t),a=new g(Math.min(o.x,s.x),Math.min(o.y,s.y)),l=new g(Math.max(o.x,s.x),Math.max(o.y,s.y));if("mercator"===this.transform.projection.name&&this.transform.anyCornerOffEdge(o,s))return this;const c=this.transform.pointLocation3D(a),u=this.transform.pointLocation3D(l),h=this.transform.pointLocation3D(new g(a.x,l.y)),d=this.transform.pointLocation3D(new g(l.x,a.y)),p=[Math.min(c.lng,u.lng,h.lng,d.lng),Math.min(c.lat,u.lat,h.lat,d.lat)],f=[Math.max(c.lng,u.lng,h.lng,d.lng),Math.max(c.lat,u.lat,h.lat,d.lat)],m=r&&r.pitch?r.pitch:this.getPitch(),_=this._cameraForBounds(this.transform,p,f,i,m,r);return this._fitInternal(_,r,n)}_fitInternal(e,t,i){return e?(delete(t=L(e,t)).padding,t.linear?this.easeTo(t,i):this.flyTo(t,i)):this}jumpTo(e,t){this.stop();const i=e.preloadOnly?this.transform.clone():this.transform;let r=!1,n=!1,o=!1;return"zoom"in e&&i.zoom!==+e.zoom&&(r=!0,i.zoom=+e.zoom),void 0!==e.center&&(i.center=Pa.convert(e.center)),"bearing"in e&&i.bearing!==+e.bearing&&(n=!0,i.bearing=+e.bearing),"pitch"in e&&i.pitch!==+e.pitch&&(o=!0,i.pitch=+e.pitch),null==e.padding||i.isPaddingEqual(e.padding)||(i.padding=e.padding),e.preloadOnly?(this._preloadTiles(i),this):(this.fire(new Event("movestart",t)).fire(new Event("move",t)),r&&this.fire(new Event("zoomstart",t)).fire(new Event("zoom",t)).fire(new Event("zoomend",t)),n&&this.fire(new Event("rotatestart",t)).fire(new Event("rotate",t)).fire(new Event("rotateend",t)),o&&this.fire(new Event("pitchstart",t)).fire(new Event("pitch",t)).fire(new Event("pitchend",t)),this.fire(new Event("moveend",t)))}getFreeCameraOptions(){return this.transform.projection.supportsFreeCamera||H(jm),this.transform.getFreeCameraOptions()}setFreeCameraOptions(e,t){const i=this.transform;if(!i.projection.supportsFreeCamera)return H(jm),this;this.stop();const r=i.zoom,n=i.pitch,o=i.bearing;i.setFreeCameraOptions(e);const s=r!==i.zoom,a=n!==i.pitch,l=o!==i.bearing;return this.fire(new Event("movestart",t)).fire(new Event("move",t)),s&&this.fire(new Event("zoomstart",t)).fire(new Event("zoom",t)).fire(new Event("zoomend",t)),l&&this.fire(new Event("rotatestart",t)).fire(new Event("rotate",t)).fire(new Event("rotateend",t)),a&&this.fire(new Event("pitchstart",t)).fire(new Event("pitch",t)).fire(new Event("pitchend",t)),this.fire(new Event("moveend",t)),this}easeTo(e,t){this._stop(!1,e.easeId),(!1===(e=L({offset:[0,0],duration:500,easing:I},e)).animate||this._prefersReducedMotion(e))&&(e.duration=0);const i=this.transform,r=this.getZoom(),n=this.getBearing(),o=this.getPitch(),s=this.getPadding(),a="zoom"in e?+e.zoom:r,l="bearing"in e?this._normalizeBearing(e.bearing,n):n,c="pitch"in e?+e.pitch:o,u="padding"in e?e.padding:i.padding,h=g.convert(e.offset);let d,p,f;if("globe"===i.projection.name){const t=MercatorCoordinate.fromLngLat(i.center),r=h.rotate(-i.angle);t.x+=r.x/i.worldSize,t.y+=r.y/i.worldSize;const n=t.toLngLat(),o=Pa.convert(e.center||n);this._normalizeCenter(o),d=i.centerPoint.add(r),p=new g(t.x,t.y).mult(i.worldSize),f=new g(za(o.lng),ka(o.lat)).mult(i.worldSize).sub(p)}else{d=i.centerPoint.add(h);const t=i.pointLocation(d),r=Pa.convert(e.center||t);this._normalizeCenter(r),p=i.project(t),f=i.project(r).sub(p)}const m=i.zoomScale(a-r);let _,y;e.around&&(_=Pa.convert(e.around),y=i.locationPoint(_));const x=this._zooming||a!==r,v=this._rotating||n!==l,b=this._pitching||c!==o,w=!i.isPaddingEqual(u),E=i=>g=>{if(x&&(i.zoom=zi(r,a,g)),v&&(i.bearing=zi(n,l,g)),b&&(i.pitch=zi(o,c,g)),w&&(i.interpolatePadding(s,u,g),d=i.centerPoint.add(h)),_)i.setLocationAtPoint(_,y);else{const e=i.zoomScale(i.zoom-r),t=a>r?Math.min(2,m):Math.max(.5,m),n=Math.pow(t,1-g),o=i.unproject(p.add(f.mult(g*n)).mult(e));i.setLocationAtPoint(i.renderWorldCopies?o.wrap():o,d)}return e.preloadOnly||this._fireMoveEvents(t),i};if(e.preloadOnly){const t=this._emulate(E,e.duration,i);return this._preloadTiles(t),this}const T={moving:this._moving,zooming:this._zooming,rotating:this._rotating,pitching:this._pitching};return this._zooming=x,this._rotating=v,this._pitching=b,this._padding=w,this._easeId=e.easeId,this._prepareEase(t,e.noMoveStart,T),this._ease(E(i),(e=>{i.recenterOnTerrain(),this._afterEase(t,e)}),e),this}_prepareEase(e,t,i={}){this._moving=!0,this.transform.cameraElevationReference="sea",t||i.moving||this.fire(new Event("movestart",e)),this._zooming&&!i.zooming&&this.fire(new Event("zoomstart",e)),this._rotating&&!i.rotating&&this.fire(new Event("rotatestart",e)),this._pitching&&!i.pitching&&this.fire(new Event("pitchstart",e))}_fireMoveEvents(e){this.fire(new Event("move",e)),this._zooming&&this.fire(new Event("zoom",e)),this._rotating&&this.fire(new Event("rotate",e)),this._pitching&&this.fire(new Event("pitch",e))}_afterEase(e,t){if(this._easeId&&t&&this._easeId===t)return;this._easeId=void 0,this.transform.cameraElevationReference="ground";const i=this._zooming,r=this._rotating,n=this._pitching;this._moving=!1,this._zooming=!1,this._rotating=!1,this._pitching=!1,this._padding=!1,i&&this.fire(new Event("zoomend",e)),r&&this.fire(new Event("rotateend",e)),n&&this.fire(new Event("pitchend",e)),this.fire(new Event("moveend",e))}flyTo(e,t){if(this._prefersReducedMotion(e)){const i=B(e,["center","zoom","bearing","pitch","around"]);return this.jumpTo(i,t)}this.stop(),e=L({offset:[0,0],speed:1.2,curve:1.42,easing:I},e);const i=this.transform,r=this.getZoom(),n=this.getBearing(),o=this.getPitch(),s=this.getPadding(),a="zoom"in e?M(+e.zoom,i.minZoom,i.maxZoom):r,l="bearing"in e?this._normalizeBearing(e.bearing,n):n,c="pitch"in e?+e.pitch:o,u="padding"in e?e.padding:i.padding,h=i.zoomScale(a-r),d=g.convert(e.offset);let p=i.centerPoint.add(d);const f=i.pointLocation(p),m=Pa.convert(e.center||f);this._normalizeCenter(m);const _=i.project(f),y=i.project(m).sub(_);let x=e.curve;const v=Math.max(i.width,i.height),b=v/h,w=y.mag();if("minZoom"in e){const t=M(Math.min(e.minZoom,r,a),i.minZoom,i.maxZoom),n=v/i.zoomScale(t-r);x=Math.sqrt(n/w*2)}const E=x*x;function T(e){const t=(b*b-v*v+(e?-1:1)*E*E*w*w)/(2*(e?b:v)*E*w);return Math.log(Math.sqrt(t*t+1)-t)}function S(e){return(Math.exp(e)-Math.exp(-e))/2}function A(e){return(Math.exp(e)+Math.exp(-e))/2}const C=T(0);let P=function(e){return A(C)/A(C+x*e)},D=function(e){return v*((A(C)*(S(t=C+x*e)/A(t))-S(C))/E)/w;var t},z=(T(1)-C)/x;if(Math.abs(w)<1e-6||!isFinite(z)){if(Math.abs(v-b)<1e-6)return this.easeTo(e,t);const i=b<v?-1:1;z=Math.abs(Math.log(b/v))/x,D=function(){return 0},P=function(e){return Math.exp(i*x*e)}}e.duration="duration"in e?+e.duration:1e3*z/("screenSpeed"in e?+e.screenSpeed/x:+e.speed),e.maxDuration&&e.duration>e.maxDuration&&(e.duration=0);const k=n!==l,R=c!==o,F=!i.isPaddingEqual(u),O=i=>h=>{const f=h*z,g=1/P(f);i.zoom=1===h?a:r+i.scaleZoom(g),k&&(i.bearing=zi(n,l,h)),R&&(i.pitch=zi(o,c,h)),F&&(i.interpolatePadding(s,u,h),p=i.centerPoint.add(d));const x=1===h?m:i.unproject(_.add(y.mult(D(f))).mult(g));return i.setLocationAtPoint(i.renderWorldCopies?x.wrap():x,p),i._updateCameraOnTerrain(),e.preloadOnly||this._fireMoveEvents(t),i};if(e.preloadOnly){const t=this._emulate(O,e.duration,i);return this._preloadTiles(t),this}return this._zooming=!0,this._rotating=k,this._pitching=R,this._padding=F,this._prepareEase(t,!1),this._ease(O(i),(()=>this._afterEase(t)),e),this}isEasing(){return!!this._easeFrameId}stop(){return this._stop()}_stop(e,t){if(this._easeFrameId&&(this._cancelRenderFrame(this._easeFrameId),this._easeFrameId=void 0,this._onEaseFrame=void 0),this._onEaseEnd){const e=this._onEaseEnd;this._onEaseEnd=void 0,e.call(this,t)}if(!e){const e=this.handlers;e&&e.stop(!1)}return this}_ease(e,t,i){!1===i.animate||0===i.duration?(e(1),t()):(this._easeStart=it.now(),this._easeOptions=i,this._onEaseFrame=e,this._onEaseEnd=t,this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback))}_renderFrameCallback(){const e=Math.min((it.now()-this._easeStart)/this._easeOptions.duration,1),t=this._onEaseFrame;t&&t(this._easeOptions.easing(e)),e<1?this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback):this.stop()}_normalizeBearing(e,t){e=D(e,-180,180);const i=Math.abs(e-t);return Math.abs(e-360-t)<i&&(e-=360),Math.abs(e+360-t)<i&&(e+=360),e}_normalizeCenter(e){const t=this.transform;if(!t.renderWorldCopies||t.maxBounds)return;const i=e.lng-t.center.lng;e.lng+=i>180?-360:i<-180?360:0}_prefersReducedMotion(e){return this._respectPrefersReducedMotion&&it.prefersReducedMotion&&!(e&&e.essential)}_emulate(e,t,i){const r=Math.ceil(15*t/1e3),n=[],o=e(i.clone());for(let e=0;e<=r;e++){const t=o(e/r);n.push(t.clone())}return n}}class AttributionControl{constructor(e={}){this.options=e,j(["_toggleAttribution","_updateEditLink","_updateData","_updateCompact"],this)}getDefaultPosition(){return"bottom-right"}onAdd(e){const t=this.options&&this.options.compact;return this._map=e,this._container=rt("div","mapboxgl-ctrl mapboxgl-ctrl-attrib"),this._compactButton=rt("button","mapboxgl-ctrl-attrib-button",this._container),rt("span","mapboxgl-ctrl-icon",this._compactButton).setAttribute("aria-hidden","true"),this._compactButton.type="button",this._compactButton.addEventListener("click",this._toggleAttribution),this._setElementTitle(this._compactButton,"ToggleAttribution"),this._innerContainer=rt("div","mapboxgl-ctrl-attrib-inner",this._container),this._innerContainer.setAttribute("role","list"),t&&this._container.classList.add("mapboxgl-compact"),this._updateAttributions(),this._updateEditLink(),this._map.on("styledata",this._updateData),this._map.on("sourcedata",this._updateData),this._map.on("moveend",this._updateEditLink),void 0===t&&(this._map.on("resize",this._updateCompact),this._updateCompact()),this._container}onRemove(){this._container.remove(),this._map.off("styledata",this._updateData),this._map.off("sourcedata",this._updateData),this._map.off("moveend",this._updateEditLink),this._map.off("resize",this._updateCompact),this._map=void 0,this._attribHTML=void 0}_setElementTitle(e,t){const i=this._map._getUIString(`AttributionControl.${t}`);e.setAttribute("aria-label",i),e.removeAttribute("title"),e.firstElementChild&&e.firstElementChild.setAttribute("title",i)}_toggleAttribution(){this._container.classList.contains("mapboxgl-compact-show")?(this._container.classList.remove("mapboxgl-compact-show"),this._compactButton.setAttribute("aria-expanded","false")):(this._container.classList.add("mapboxgl-compact-show"),this._compactButton.setAttribute("aria-expanded","true"))}_updateEditLink(){let e=this._editLink;e||(e=this._editLink=this._container.querySelector(".mapbox-improve-map"));const t=[{key:"owner",value:this.styleOwner},{key:"id",value:this.styleId},{key:"access_token",value:this._map._requestManager._customAccessToken||r.ACCESS_TOKEN}];if(e){const i=t.reduce(((e,i,r)=>(i.value&&(e+=`${i.key}=${i.value}${r<t.length-1?"&":""}`),e)),"?");e.href=`${r.FEEDBACK_URL}/${i}#${wm(this._map,!0)}`,e.rel="noopener nofollow",this._setElementTitle(e,"MapFeedback")}}_updateData(e){!e||"metadata"!==e.sourceDataType&&"visibility"!==e.sourceDataType&&"style"!==e.dataType||(this._updateAttributions(),this._updateEditLink())}_updateAttributions(){if(!this._map.style)return;let e=[];if(this._map.style.stylesheet){const e=this._map.style.stylesheet;this.styleOwner=e.owner,this.styleId=e.id}const t=this._map.style._sourceCaches;for(const i in t){const r=t[i];if(r.used){const t=r.getSource();t.attribution&&e.indexOf(t.attribution)<0&&e.push(t.attribution)}}e.sort(((e,t)=>e.length-t.length)),e=e.filter(((t,i)=>{for(let r=i+1;r<e.length;r++)if(e[r].indexOf(t)>=0)return!1;return!0})),this.options.customAttribution&&(Array.isArray(this.options.customAttribution)?e=[...this.options.customAttribution,...e]:e.unshift(this.options.customAttribution));const i=e.join(" | ");i!==this._attribHTML&&(this._attribHTML=i,e.length?(this._innerContainer.innerHTML=i,this._container.classList.remove("mapboxgl-attrib-empty")):this._container.classList.add("mapboxgl-attrib-empty"),this._editLink=null)}_updateCompact(){this._map.getCanvasContainer().offsetWidth<=640?this._container.classList.add("mapboxgl-compact"):this._container.classList.remove("mapboxgl-compact","mapboxgl-compact-show")}}class LogoControl{constructor(){j(["_updateLogo","_updateCompact"],this)}onAdd(e){this._map=e,this._container=rt("div","mapboxgl-ctrl");const t=rt("a","mapboxgl-ctrl-logo");return t.target="_blank",t.rel="noopener nofollow",t.href="https://www.mapbox.com/",t.setAttribute("aria-label",this._map._getUIString("LogoControl.Title")),t.setAttribute("rel","noopener nofollow"),this._container.appendChild(t),this._container.style.display="none",this._map.on("sourcedata",this._updateLogo),this._updateLogo(),this._map.on("resize",this._updateCompact),this._updateCompact(),this._container}onRemove(){this._container.remove(),this._map.off("sourcedata",this._updateLogo),this._map.off("resize",this._updateCompact)}getDefaultPosition(){return"bottom-left"}_updateLogo(e){e&&"metadata"!==e.sourceDataType||(this._container.style.display=this._logoRequired()?"block":"none")}_logoRequired(){if(!this._map.style)return!0;const e=this._map.style._sourceCaches;if(0===Object.entries(e).length)return!0;for(const t in e){const i=e[t].getSource();if(i.hasOwnProperty("mapbox_logo")&&!i.mapbox_logo)return!1}return!0}_updateCompact(){const e=this._container.children;if(e.length){const t=e[0];this._map.getCanvasContainer().offsetWidth<250?t.classList.add("mapboxgl-compact"):t.classList.remove("mapboxgl-compact")}}}class TaskQueue{constructor(){this._queue=[],this._id=0,this._cleared=!1,this._currentlyRunning=!1}add(e){const t=++this._id;return this._queue.push({callback:e,id:t,cancelled:!1}),t}remove(e){const t=this._currentlyRunning,i=t?this._queue.concat(t):this._queue;for(const t of i)if(t.id===e)return void(t.cancelled=!0)}run(e=0){const t=this._currentlyRunning=this._queue;this._queue=[];for(const i of t)if(!i.cancelled&&(i.callback(e),this._cleared))break;this._cleared=!1,this._currentlyRunning=!1}clear(){this._currentlyRunning&&(this._cleared=!0),this._queue=[]}}function Nm(e,t,i){if(e=new Pa(e.lng,e.lat),t){const r=new Pa(e.lng-360,e.lat),n=new Pa(e.lng+360,e.lat),o=360*Math.ceil(Math.abs(e.lng-i.center.lng)/360),s=i.locationPoint(e).distSqr(t),a=t.x<0||t.y<0||t.x>i.width||t.y>i.height;i.locationPoint(r).distSqr(t)<s&&(a||Math.abs(r.lng-i.center.lng)<o)?e=r:i.locationPoint(n).distSqr(t)<s&&(a||Math.abs(n.lng-i.center.lng)<o)&&(e=n)}for(;Math.abs(e.lng-i.center.lng)>180;){const t=i.locationPoint(e);if(t.x>=0&&t.y>=0&&t.x<=i.width&&t.y<=i.height)break;e.lng>i.center.lng?e.lng-=360:e.lng+=360}return e}const Gm={center:"translate(-50%,-50%)",top:"translate(-50%,0)","top-left":"translate(0,0)","top-right":"translate(-100%,0)",bottom:"translate(-50%,-100%)","bottom-left":"translate(0,-100%)","bottom-right":"translate(-100%,-100%)",left:"translate(0,-50%)",right:"translate(-100%,-50%)"};class Marker extends Evented{constructor(t,i){if(super(),(t instanceof e.HTMLElement||i)&&(t=L({element:t},i)),j(["_update","_onMove","_onUp","_addDragHandler","_onMapClick","_onKeyPress","_clearFadeTimer"],this),this._anchor=t&&t.anchor||"center",this._color=t&&t.color||"#3FB1CE",this._scale=t&&t.scale||1,this._draggable=t&&t.draggable||!1,this._clickTolerance=t&&t.clickTolerance||0,this._isDragging=!1,this._state="inactive",this._rotation=t&&t.rotation||0,this._rotationAlignment=t&&t.rotationAlignment||"auto",this._pitchAlignment=t&&t.pitchAlignment&&t.pitchAlignment||"auto",this._updateMoving=()=>this._update(!0),this._occludedOpacity=t&&t.occludedOpacity||.2,t&&t.element)this._element=t.element,this._offset=g.convert(t&&t.offset||[0,0]);else{this._defaultMarker=!0,this._element=rt("div");const e=41,i=27,r=nt("svg",{display:"block",height:e*this._scale+"px",width:i*this._scale+"px",viewBox:`0 0 ${i} ${e}`},this._element),n=nt("radialGradient",{id:"shadowGradient"},nt("defs",{},r));nt("stop",{offset:"10%","stop-opacity":.4},n),nt("stop",{offset:"100%","stop-opacity":.05},n),nt("ellipse",{cx:13.5,cy:34.8,rx:10.5,ry:5.25,fill:"url(#shadowGradient)"},r),nt("path",{fill:this._color,d:"M27,13.5C27,19.07 20.25,27 14.75,34.5C14.02,35.5 12.98,35.5 12.25,34.5C6.75,27 0,19.22 0,13.5C0,6.04 6.04,0 13.5,0C20.96,0 27,6.04 27,13.5Z"},r),nt("path",{opacity:.25,d:"M13.5,0C6.04,0 0,6.04 0,13.5C0,19.22 6.75,27 12.25,34.5C13,35.52 14.02,35.5 14.75,34.5C20.25,27 27,19.07 27,13.5C27,6.04 20.96,0 13.5,0ZM13.5,1C20.42,1 26,6.58 26,13.5C26,15.9 24.5,19.18 22.22,22.74C19.95,26.3 16.71,30.14 13.94,33.91C13.74,34.18 13.61,34.32 13.5,34.44C13.39,34.32 13.26,34.18 13.06,33.91C10.28,30.13 7.41,26.31 5.02,22.77C2.62,19.23 1,15.95 1,13.5C1,6.58 6.58,1 13.5,1Z"},r),nt("circle",{fill:"white",cx:13.5,cy:13.5,r:5.5},r),this._offset=g.convert(t&&t.offset||[0,-14])}this._element.hasAttribute("aria-label")||this._element.setAttribute("aria-label","Map marker"),this._element.classList.add("mapboxgl-marker"),this._element.addEventListener("dragstart",(e=>{e.preventDefault()})),this._element.addEventListener("mousedown",(e=>{e.preventDefault()}));const r=this._element.classList;for(const e in Gm)r.remove(`mapboxgl-marker-anchor-${e}`);r.add(`mapboxgl-marker-anchor-${this._anchor}`),this._popup=null}addTo(e){return e===this._map||(this.remove(),this._map=e,e.getCanvasContainer().appendChild(this._element),e.on("move",this._updateMoving),e.on("moveend",this._update),e.on("remove",this._clearFadeTimer),e._addMarker(this),this.setDraggable(this._draggable),this._update(),e.on("click",this._onMapClick)),this}remove(){const e=this._map;return e&&(e.off("click",this._onMapClick),e.off("move",this._updateMoving),e.off("moveend",this._update),e.off("mousedown",this._addDragHandler),e.off("touchstart",this._addDragHandler),e.off("mouseup",this._onUp),e.off("touchend",this._onUp),e.off("mousemove",this._onMove),e.off("touchmove",this._onMove),e.off("remove",this._clearFadeTimer),e._removeMarker(this),this._map=void 0),this._clearFadeTimer(),this._element.remove(),this._popup&&this._popup.remove(),this}getLngLat(){return this._lngLat}setLngLat(e){return this._lngLat=Pa.convert(e),this._pos=null,this._popup&&this._popup.setLngLat(this._lngLat),this._update(!0),this}getElement(){return this._element}setPopup(e){if(this._popup&&(this._popup.remove(),this._popup=null,this._element.removeAttribute("role"),this._element.removeEventListener("keypress",this._onKeyPress),this._originalTabIndex||this._element.removeAttribute("tabindex")),e){if(!("offset"in e.options)){const t=38.1,i=13.5,r=Math.sqrt(Math.pow(i,2)/2);e.options.offset=this._defaultMarker?{top:[0,0],"top-left":[0,0],"top-right":[0,0],bottom:[0,-t],"bottom-left":[r,-1*(t-i+r)],"bottom-right":[-r,-1*(t-i+r)],left:[i,-1*(t-i)],right:[-i,-1*(t-i)]}:this._offset}this._popup=e,e._marker=this,this._lngLat&&this._popup.setLngLat(this._lngLat),this._element.setAttribute("role","button"),this._originalTabIndex=this._element.getAttribute("tabindex"),this._originalTabIndex||this._element.setAttribute("tabindex","0"),this._element.addEventListener("keypress",this._onKeyPress),this._element.setAttribute("aria-expanded","false")}return this}_onKeyPress(e){const t=e.code,i=e.charCode||e.keyCode;"Space"!==t&&"Enter"!==t&&32!==i&&13!==i||this.togglePopup()}_onMapClick(e){const t=e.originalEvent.target,i=this._element;this._popup&&(t===i||i.contains(t))&&this.togglePopup()}getPopup(){return this._popup}togglePopup(){const e=this._popup;return e?(e.isOpen()?(e.remove(),this._element.setAttribute("aria-expanded","false")):this._map&&(e.addTo(this._map),this._element.setAttribute("aria-expanded","true")),this):this}_behindTerrain(){const e=this._map,t=this._pos;if(!e||!t)return!1;const i=e.unproject(t),r=e.getFreeCameraOptions();if(!r.position)return!1;const n=r.position.toLngLat();return n.distanceTo(i)<.9*n.distanceTo(this._lngLat)}_evaluateOpacity(){const e=this._map;if(!e)return;const t=this._pos;if(!t||t.x<0||t.x>e.transform.width||t.y<0||t.y>e.transform.height)return void this._clearFadeTimer();const i=e.unproject(t);let r;e._showingGlobe()&&Ta(e.transform,this._lngLat)?r=0:(r=1-e._queryFogOpacity(i),e.transform._terrainEnabled()&&e.getTerrain()&&this._behindTerrain()&&(r*=this._occludedOpacity)),this._element.style.opacity=`${r}`,this._element.style.pointerEvents=r>0?"auto":"none",this._popup&&this._popup._setOpacity(r),this._fadeTimer=null}_clearFadeTimer(){this._fadeTimer&&(clearTimeout(this._fadeTimer),this._fadeTimer=null)}_updateDOM(){const e=this._pos;if(!e||!this._map)return;const t=this._offset.mult(this._scale);this._element.style.transform=`\n            translate(${e.x}px,${e.y}px)\n            ${Gm[this._anchor]}\n            ${this._calculateXYTransform()} ${this._calculateZTransform()}\n            translate(${t.x}px,${t.y}px)\n        `}_calculateXYTransform(){const e=this._pos,t=this._map,i=this.getPitchAlignment();if(!t||!e||"map"!==i)return"";if(!t._showingGlobe()){const e=t.getPitch();return e?`rotateX(${e}deg)`:""}const r=w(Ea(t.transform,this._lngLat)),n=e.sub(wa(t.transform)),o=Math.abs(n.x)+Math.abs(n.y);if(0===o)return"";const s=r/o;return`rotateX(${-n.y*s}deg) rotateY(${n.x*s}deg)`}_calculateZTransform(){const e=this._pos,t=this._map;if(!t||!e)return"";let i=0;const r=this.getRotationAlignment();if("map"===r)if(t._showingGlobe()){const e=t.project(new Pa(this._lngLat.lng,this._lngLat.lat+.001)),r=t.project(new Pa(this._lngLat.lng,this._lngLat.lat-.001)).sub(e);i=w(Math.atan2(r.y,r.x))-90}else i=-t.getBearing();else if("horizon"===r){const r=P(4,6,t.getZoom()),n=wa(t.transform);n.y+=r*t.transform.height;const o=e.sub(n),s=w(Math.atan2(o.y,o.x));i=(s>90?s-270:s+90)*(1-r)}return i+=this._rotation,i?`rotateZ(${i}deg)`:""}_update(t){e.cancelAnimationFrame(this._updateFrameId);const i=this._map;i&&(i.transform.renderWorldCopies&&(this._lngLat=Nm(this._lngLat,this._pos,i.transform)),this._pos=i.project(this._lngLat),!0===t?this._updateFrameId=e.requestAnimationFrame((()=>{this._element&&this._pos&&this._anchor&&(this._pos=this._pos.round(),this._updateDOM())})):this._pos=this._pos.round(),i._requestDomTask((()=>{this._map&&(this._element&&this._pos&&this._anchor&&this._updateDOM(),(i._showingGlobe()||i.getTerrain()||i.getFog())&&!this._fadeTimer&&(this._fadeTimer=setTimeout(this._evaluateOpacity.bind(this),60)))})))}getOffset(){return this._offset}setOffset(e){return this._offset=g.convert(e),this._update(),this}_onMove(e){const t=this._map;if(!t)return;const i=this._pointerdownPos,r=this._positionDelta;if(i&&r){if(!this._isDragging){const r=this._clickTolerance||t._clickTolerance;if(e.point.dist(i)<r)return;this._isDragging=!0}this._pos=e.point.sub(r),this._lngLat=t.unproject(this._pos),this.setLngLat(this._lngLat),this._element.style.pointerEvents="none","pending"===this._state&&(this._state="active",this.fire(new Event("dragstart"))),this.fire(new Event("drag"))}}_onUp(){this._element.style.pointerEvents="auto",this._positionDelta=null,this._pointerdownPos=null,this._isDragging=!1;const e=this._map;e&&(e.off("mousemove",this._onMove),e.off("touchmove",this._onMove)),"active"===this._state&&this.fire(new Event("dragend")),this._state="inactive"}_addDragHandler(e){const t=this._map,i=this._pos;t&&i&&this._element.contains(e.originalEvent.target)&&(e.preventDefault(),this._positionDelta=e.point.sub(i),this._pointerdownPos=e.point,this._state="pending",t.on("mousemove",this._onMove),t.on("touchmove",this._onMove),t.once("mouseup",this._onUp),t.once("touchend",this._onUp))}setDraggable(e){this._draggable=!!e;const t=this._map;return t&&(e?(t.on("mousedown",this._addDragHandler),t.on("touchstart",this._addDragHandler)):(t.off("mousedown",this._addDragHandler),t.off("touchstart",this._addDragHandler))),this}isDraggable(){return this._draggable}setRotation(e){return this._rotation=e||0,this._update(),this}getRotation(){return this._rotation}setRotationAlignment(e){return this._rotationAlignment=e||"auto",this._update(),this}getRotationAlignment(){return"auto"===this._rotationAlignment||"horizon"===this._rotationAlignment&&this._map&&!this._map._showingGlobe()?"viewport":this._rotationAlignment}setPitchAlignment(e){return this._pitchAlignment=e||"auto",this._update(),this}getPitchAlignment(){return"auto"===this._pitchAlignment?this.getRotationAlignment():this._pitchAlignment}setOccludedOpacity(e){return this._occludedOpacity=e||.2,this._update(),this}getOccludedOpacity(){return this._occludedOpacity}}const qm={closeButton:!0,closeOnClick:!0,focusAfterOpen:!0,className:"",maxWidth:"240px"},Zm=["a[href]","[tabindex]:not([tabindex='-1'])","[contenteditable]:not([contenteditable='false'])","button:not([disabled])","input:not([disabled])","select:not([disabled])","textarea:not([disabled])"].join(", ");function $m(e=new g(0,0),t="bottom"){if("number"==typeof e){const i=Math.round(Math.sqrt(.5*Math.pow(e,2)));switch(t){case"top":return new g(0,e);case"top-left":return new g(i,i);case"top-right":return new g(-i,i);case"bottom":return new g(0,-e);case"bottom-left":return new g(i,-i);case"bottom-right":return new g(-i,-i);case"left":return new g(e,0);case"right":return new g(-e,0)}return new g(0,0)}return e instanceof g||Array.isArray(e)?g.convert(e):g.convert(e[t]||[0,0])}class EasedVariable{constructor(e){this.jumpTo(e)}getValue(e){if(e<=this._startTime)return this._start;if(e>=this._endTime)return this._end;const t=T((e-this._startTime)/(this._endTime-this._startTime));return this._start*(1-t)+this._end*t}isEasing(e){return e>=this._startTime&&e<=this._endTime}jumpTo(e){this._startTime=-1/0,this._endTime=-1/0,this._start=e,this._end=e}easeTo(e,t,i){this._start=this.getValue(t),this._end=e,this._startTime=t,this._endTime=t+i}}const Wm={"AttributionControl.ToggleAttribution":"Toggle attribution","AttributionControl.MapFeedback":"Map feedback","FullscreenControl.Enter":"Enter fullscreen","FullscreenControl.Exit":"Exit fullscreen","GeolocateControl.FindMyLocation":"Find my location","GeolocateControl.LocationNotAvailable":"Location not available","LogoControl.Title":"Mapbox logo","Map.Title":"Map","NavigationControl.ResetBearing":"Reset bearing to north","NavigationControl.ZoomIn":"Zoom in","NavigationControl.ZoomOut":"Zoom out","ScrollZoomBlocker.CtrlMessage":"Use ctrl + scroll to zoom the map","ScrollZoomBlocker.CmdMessage":"Use ⌘ + scroll to zoom the map","TouchPanBlocker.Message":"Use two fingers to move the map"},Hm={center:[0,0],zoom:0,bearing:0,pitch:0,minZoom:-2,maxZoom:22,minPitch:0,maxPitch:85,interactive:!0,scrollZoom:!0,boxZoom:!0,dragRotate:!0,dragPan:!0,keyboard:!0,doubleClickZoom:!0,touchZoomRotate:!0,touchPitch:!0,cooperativeGestures:!1,performanceMetricsCollection:!0,bearingSnap:7,clickTolerance:3,pitchWithRotate:!0,hash:!1,attributionControl:!0,failIfMajorPerformanceCaveat:!1,preserveDrawingBuffer:!1,trackResize:!0,optimizeForTerrain:!0,renderWorldCopies:!0,refreshExpiredTiles:!0,minTileCacheSize:null,maxTileCacheSize:null,localIdeographFontFamily:"sans-serif",localFontFamily:null,transformRequest:null,accessToken:null,fadeDuration:300,respectPrefersReducedMotion:!0,crossSourceCollisions:!0},Xm={showCompass:!0,showZoom:!0,visualizePitch:!1};class MouseRotateWrapper{constructor(e,t,i=!1){this._clickTolerance=10,this.element=t,this.mouseRotate=new MouseRotateHandler({clickTolerance:e.dragRotate._mouseRotate._clickTolerance}),this.map=e,i&&(this.mousePitch=new MousePitchHandler({clickTolerance:e.dragRotate._mousePitch._clickTolerance})),j(["mousedown","mousemove","mouseup","touchstart","touchmove","touchend","reset"],this),t.addEventListener("mousedown",this.mousedown),t.addEventListener("touchstart",this.touchstart,{passive:!1}),t.addEventListener("touchmove",this.touchmove),t.addEventListener("touchend",this.touchend),t.addEventListener("touchcancel",this.reset)}down(e,t){this.mouseRotate.mousedown(e,t),this.mousePitch&&this.mousePitch.mousedown(e,t),lt()}move(e,t){const i=this.map,r=this.mouseRotate.mousemoveWindow(e,t),n=r&&r.bearingDelta;if(n&&i.setBearing(i.getBearing()+n),this.mousePitch){const r=this.mousePitch.mousemoveWindow(e,t),n=r&&r.pitchDelta;n&&i.setPitch(i.getPitch()+n)}}off(){const e=this.element;e.removeEventListener("mousedown",this.mousedown),e.removeEventListener("touchstart",this.touchstart,{passive:!1}),e.removeEventListener("touchmove",this.touchmove),e.removeEventListener("touchend",this.touchend),e.removeEventListener("touchcancel",this.reset),this.offTemp()}offTemp(){ct(),e.removeEventListener("mousemove",this.mousemove),e.removeEventListener("mouseup",this.mouseup)}mousedown(t){this.down(L({},t,{ctrlKey:!0,preventDefault:()=>t.preventDefault()}),dt(this.element,t)),e.addEventListener("mousemove",this.mousemove),e.addEventListener("mouseup",this.mouseup)}mousemove(e){this.move(e,dt(this.element,e))}mouseup(e){this.mouseRotate.mouseupWindow(e),this.mousePitch&&this.mousePitch.mouseupWindow(e),this.offTemp()}touchstart(e){1!==e.targetTouches.length?this.reset():(this._startPos=this._lastPos=pt(this.element,e.targetTouches)[0],this.down({type:"mousedown",button:0,ctrlKey:!0,preventDefault:()=>e.preventDefault()},this._startPos))}touchmove(e){1!==e.targetTouches.length?this.reset():(this._lastPos=pt(this.element,e.targetTouches)[0],this.move({preventDefault:()=>e.preventDefault()},this._lastPos))}touchend(e){0===e.targetTouches.length&&this._startPos&&this._lastPos&&this._startPos.dist(this._lastPos)<this._clickTolerance&&this.element.click(),this.reset()}reset(){this.mouseRotate.reset(),this.mousePitch&&this.mousePitch.reset(),delete this._startPos,delete this._lastPos,this.offTemp()}}const Km={positionOptions:{enableHighAccuracy:!1,maximumAge:0,timeout:6e3},fitBoundsOptions:{maxZoom:15},trackUserLocation:!1,showAccuracyCircle:!0,showUserLocation:!0,showUserHeading:!1},Jm={maxWidth:100,unit:"metric"},Ym={kilometer:"km",meter:"m",mile:"mi",foot:"ft","nautical-mile":"nm"},Qm={version:t,supported:Xe,setRTLTextPlugin:function(e,t,i=!1){if(io===Yn||io===Qn||io===eo)throw new Error("setRTLTextPlugin cannot be called multiple times.");ro=it.resolveURL(e),io=Yn,to=t,oo(),i||lo()},getRTLTextPluginStatus:ao,Map:class Map extends Camera{constructor(t){if(We.mark($e.create),null!=(t=L({},Hm,t)).minZoom&&null!=t.maxZoom&&t.minZoom>t.maxZoom)throw new Error("maxZoom must be greater than or equal to minZoom");if(null!=t.minPitch&&null!=t.maxPitch&&t.minPitch>t.maxPitch)throw new Error("maxPitch must be greater than or equal to minPitch");if(null!=t.minPitch&&t.minPitch<0)throw new Error("minPitch must be greater than or equal to 0");if(null!=t.maxPitch&&t.maxPitch>85)throw new Error("maxPitch must be less than or equal to 85");if(t.antialias&&function(e){const t=e.navigator?e.navigator.userAgent:null;return!!ee(e)&&t&&(t.match("Version/15.4")||t.match("Version/15.5")||t.match(/CPU (OS|iPhone OS) (15_4|15_5) like Mac OS X/))}(e)&&(t.antialias=!1,H("Antialiasing is disabled for this WebGL context to avoid browser bug: https://github.com/mapbox/mapbox-gl-js/issues/11609")),super(new Transform(t.minZoom,t.maxZoom,t.minPitch,t.maxPitch,t.renderWorldCopies),t),this._interactive=t.interactive,this._minTileCacheSize=t.minTileCacheSize,this._maxTileCacheSize=t.maxTileCacheSize,this._failIfMajorPerformanceCaveat=t.failIfMajorPerformanceCaveat,this._preserveDrawingBuffer=t.preserveDrawingBuffer,this._antialias=t.antialias,this._useWebGL2=t.useWebGL2,this._trackResize=t.trackResize,this._bearingSnap=t.bearingSnap,this._refreshExpiredTiles=t.refreshExpiredTiles,this._fadeDuration=t.fadeDuration,this._isInitialLoad=!0,this._crossSourceCollisions=t.crossSourceCollisions,this._collectResourceTiming=t.collectResourceTiming,this._optimizeForTerrain=t.optimizeForTerrain,this._language=this._parseLanguage(t.language),this._worldview=t.worldview,this._renderTaskQueue=new TaskQueue,this._domRenderTaskQueue=new TaskQueue,this._controls=[],this._markers=[],this._popups=[],this._mapId=F(),this._locale=L({},Wm,t.locale),this._clickTolerance=t.clickTolerance,this._cooperativeGestures=t.cooperativeGestures,this._performanceMetricsCollection=t.performanceMetricsCollection,this._containerWidth=0,this._containerHeight=0,this._averageElevationLastSampledAt=-1/0,this._averageElevationExaggeration=0,this._averageElevation=new EasedVariable(0),this._interactionRange=[1/0,-1/0],this._visibilityHidden=0,this._useExplicitProjection=!1,this._requestManager=new RequestManager(t.transformRequest,t.accessToken,t.testMode),this._silenceAuthErrors=!!t.testMode,"string"==typeof t.container){if(this._container=e.document.getElementById(t.container),!this._container)throw new Error(`Container '${t.container}' not found.`)}else{if(!(t.container instanceof e.HTMLElement))throw new Error("Invalid type: 'container' must be a String or HTMLElement.");this._container=t.container}if(this._container.childNodes.length>0&&H("The map container element should be empty, otherwise the map's interactivity will be negatively impacted. If you want to display a message when WebGL is not supported, use the Mapbox GL Supported plugin instead."),t.maxBounds&&this.setMaxBounds(t.maxBounds),j(["_onWindowOnline","_onWindowResize","_onVisibilityChange","_onMapScroll","_contextLost","_contextRestored"],this),this._setupContainer(),this._setupPainter(),void 0===this.painter)throw new Error("Failed to initialize WebGL.");this.on("move",(()=>this._update(!1))),this.on("moveend",(()=>this._update(!1))),this.on("zoom",(()=>this._update(!0))),void 0!==e&&(e.addEventListener("online",this._onWindowOnline,!1),e.addEventListener("resize",this._onWindowResize,!1),e.addEventListener("orientationchange",this._onWindowResize,!1),e.addEventListener("webkitfullscreenchange",this._onWindowResize,!1),e.addEventListener("visibilitychange",this._onVisibilityChange,!1)),this.handlers=new HandlerManager(this,t),this._localFontFamily=t.localFontFamily,this._localIdeographFontFamily=t.localIdeographFontFamily,t.style&&this.setStyle(t.style,{localFontFamily:this._localFontFamily,localIdeographFontFamily:this._localIdeographFontFamily}),t.projection&&this.setProjection(t.projection),this._hash=t.hash&&new Hash("string"==typeof t.hash&&t.hash||void 0).addTo(this),this._hash&&this._hash._onHashChange()||(this.jumpTo({center:t.center,zoom:t.zoom,bearing:t.bearing,pitch:t.pitch}),t.bounds&&(this.resize(),this.fitBounds(t.bounds,L({},t.fitBoundsOptions,{duration:0})))),this.resize(),t.attributionControl&&this.addControl(new AttributionControl({customAttribution:t.customAttribution})),this._logoControl=new LogoControl,this.addControl(this._logoControl,t.logoPosition),this.on("style.load",(()=>{this.transform.unmodified&&this.jumpTo(this.style.stylesheet)})),this.on("data",(e=>{this._update("style"===e.dataType),this.fire(new Event(`${e.dataType}data`,e))})),this.on("dataloading",(e=>{this.fire(new Event(`${e.dataType}dataloading`,e))}))}_getMapId(){return this._mapId}addControl(e,t){if(void 0===t&&(t=e.getDefaultPosition?e.getDefaultPosition():"top-right"),!e||!e.onAdd)return this.fire(new ErrorEvent(new Error("Invalid argument to map.addControl(). Argument must be a control with onAdd and onRemove methods.")));const i=e.onAdd(this);this._controls.push(e);const r=this._controlPositions[t];return-1!==t.indexOf("bottom")?r.insertBefore(i,r.firstChild):r.appendChild(i),this}removeControl(e){if(!e||!e.onRemove)return this.fire(new ErrorEvent(new Error("Invalid argument to map.removeControl(). Argument must be a control with onAdd and onRemove methods.")));const t=this._controls.indexOf(e);return t>-1&&this._controls.splice(t,1),e.onRemove(this),this}hasControl(e){return this._controls.indexOf(e)>-1}getContainer(){return this._container}getCanvasContainer(){return this._canvasContainer}getCanvas(){return this._canvas}resize(e){if(this._updateContainerDimensions(),this._containerWidth===this.transform.width&&this._containerHeight===this.transform.height)return this;this._resizeCanvas(this._containerWidth,this._containerHeight),this.transform.resize(this._containerWidth,this._containerHeight),this.painter.resize(Math.ceil(this._containerWidth),Math.ceil(this._containerHeight));const t=!this._moving;return t&&this.fire(new Event("movestart",e)).fire(new Event("move",e)),this.fire(new Event("resize",e)),t&&this.fire(new Event("moveend",e)),this}getBounds(){return this.transform.getBounds()}getMaxBounds(){return this.transform.getMaxBounds()||null}setMaxBounds(e){return this.transform.setMaxBounds(LngLatBounds.convert(e)),this._update()}setMinZoom(e){if((e=null==e?-2:e)>=-2&&e<=this.transform.maxZoom)return this.transform.minZoom=e,this._update(),this.getZoom()<e?this.setZoom(e):this.fire(new Event("zoomstart")).fire(new Event("zoom")).fire(new Event("zoomend")),this;throw new Error("minZoom must be between -2 and the current maxZoom, inclusive")}getMinZoom(){return this.transform.minZoom}setMaxZoom(e){if((e=null==e?22:e)>=this.transform.minZoom)return this.transform.maxZoom=e,this._update(),this.getZoom()>e?this.setZoom(e):this.fire(new Event("zoomstart")).fire(new Event("zoom")).fire(new Event("zoomend")),this;throw new Error("maxZoom must be greater than the current minZoom")}getMaxZoom(){return this.transform.maxZoom}setMinPitch(e){if((e=null==e?0:e)<0)throw new Error("minPitch must be greater than or equal to 0");if(e>=0&&e<=this.transform.maxPitch)return this.transform.minPitch=e,this._update(),this.getPitch()<e?this.setPitch(e):this.fire(new Event("pitchstart")).fire(new Event("pitch")).fire(new Event("pitchend")),this;throw new Error("minPitch must be between 0 and the current maxPitch, inclusive")}getMinPitch(){return this.transform.minPitch}setMaxPitch(e){if((e=null==e?85:e)>85)throw new Error("maxPitch must be less than or equal to 85");if(e>=this.transform.minPitch)return this.transform.maxPitch=e,this._update(),this.getPitch()>e?this.setPitch(e):this.fire(new Event("pitchstart")).fire(new Event("pitch")).fire(new Event("pitchend")),this;throw new Error("maxPitch must be greater than or equal to minPitch")}getMaxPitch(){return this.transform.maxPitch}getRenderWorldCopies(){return this.transform.renderWorldCopies}setRenderWorldCopies(e){return this.transform.renderWorldCopies=e,this.transform.renderWorldCopies||this._forceMarkerAndPopupUpdate(!0),this._update()}getLanguage(){return this._language}_parseLanguage(t){return"auto"===t?e.navigator.language:Array.isArray(t)?0===t.length?void 0:t.map((t=>"auto"===t?e.navigator.language:t)):t}setLanguage(e){const t=this._parseLanguage(e);if(!this.style||t===this._language)return this;this._language=t,this.style._reloadSources();for(const e of this._controls)e._setLanguage&&e._setLanguage(this._language);return this}getWorldview(){return this._worldview}setWorldview(e){return this.style&&e!==this._worldview?(this._worldview=e,this.style._reloadSources(),this):this}getProjection(){return this.transform.mercatorFromTransition?{name:"globe",center:[0,0]}:this.transform.getProjection()}_showingGlobe(){return"globe"===this.transform.projection.name}setProjection(e){return this._lazyInitEmptyStyle(),e?"string"==typeof e&&(e={name:e}):e=null,this._useExplicitProjection=!!e,this._prioritizeAndUpdateProjection(e,this.style.stylesheet?this.style.stylesheet.projection:null)}_updateProjectionTransition(){if("globe"!==this.getProjection().name)return;const e=this.transform,t=e.projection.name;let i;"globe"===t&&e.zoom>=qs?(e.setMercatorFromTransition(),i=!0):"mercator"===t&&e.zoom<qs&&(e.setProjection({name:"globe"}),i=!0),i&&(this.style.applyProjectionUpdate(),this.style._forceSymbolLayerUpdate())}_prioritizeAndUpdateProjection(e,t){return this._updateProjection(e||t||{name:"mercator"})}_updateProjection(e){let t;if(t="globe"===e.name&&this.transform.zoom>=qs?this.transform.setMercatorFromTransition():this.transform.setProjection(e),this.style.applyProjectionUpdate(),t){this.painter.clearBackgroundTiles();for(const e in this.style._sourceCaches)this.style._sourceCaches[e].clearTiles();this._update(!0),this._forceMarkerAndPopupUpdate(!0)}return this}project(e){return this.transform.locationPoint3D(Pa.convert(e))}unproject(e){return this.transform.pointLocation3D(g.convert(e))}isMoving(){return this._moving||this.handlers&&this.handlers.isMoving()||!1}isZooming(){return this._zooming||this.handlers&&this.handlers.isZooming()||!1}isRotating(){return this._rotating||this.handlers&&this.handlers.isRotating()||!1}_isDragging(){return this.handlers&&this.handlers._isDragging()||!1}_createDelegatedListener(e,t,i){if("mouseenter"===e||"mouseover"===e){let r=!1;const n=n=>{const o=t.filter((e=>this.getLayer(e))),s=o.length?this.queryRenderedFeatures(n.point,{layers:o}):[];s.length?r||(r=!0,i.call(this,new MapMouseEvent(e,this,n.originalEvent,{features:s}))):r=!1},o=()=>{r=!1};return{layers:new Set(t),listener:i,delegates:{mousemove:n,mouseout:o}}}if("mouseleave"===e||"mouseout"===e){let r=!1;const n=n=>{const o=t.filter((e=>this.getLayer(e)));(o.length?this.queryRenderedFeatures(n.point,{layers:o}):[]).length?r=!0:r&&(r=!1,i.call(this,new MapMouseEvent(e,this,n.originalEvent)))},o=t=>{r&&(r=!1,i.call(this,new MapMouseEvent(e,this,t.originalEvent)))};return{layers:new Set(t),listener:i,delegates:{mousemove:n,mouseout:o}}}{const r=e=>{const r=t.filter((e=>this.getLayer(e))),n=r.length?this.queryRenderedFeatures(e.point,{layers:r}):[];n.length&&(e.features=n,i.call(this,e),delete e.features)};return{layers:new Set(t),listener:i,delegates:{[e]:r}}}}on(e,t,i){if(void 0===i)return super.on(e,t);Array.isArray(t)||(t=[t]);const r=this._createDelegatedListener(e,t,i);this._delegatedListeners=this._delegatedListeners||{},this._delegatedListeners[e]=this._delegatedListeners[e]||[],this._delegatedListeners[e].push(r);for(const e in r.delegates)this.on(e,r.delegates[e]);return this}once(e,t,i){if(void 0===i)return super.once(e,t);Array.isArray(t)||(t=[t]);const r=this._createDelegatedListener(e,t,i);for(const e in r.delegates)this.once(e,r.delegates[e]);return this}off(e,t,i){if(void 0===i)return super.off(e,t);t=new Set(Array.isArray(t)?t:[t]);const r=(e,t)=>{if(e.size!==t.size)return!1;for(const i of e)if(!t.has(i))return!1;return!0},n=this._delegatedListeners?this._delegatedListeners[e]:void 0;return n&&(e=>{for(let n=0;n<e.length;n++){const o=e[n];if(o.listener===i&&r(o.layers,t)){for(const e in o.delegates)this.off(e,o.delegates[e]);return e.splice(n,1),this}}})(n),this}queryRenderedFeatures(e,t){return this.style?(void 0!==t||void 0===e||e instanceof g||Array.isArray(e)||(t=e,e=void 0),this.style.queryRenderedFeatures(e=e||[[0,0],[this.transform.width,this.transform.height]],t=t||{},this.transform)):[]}querySourceFeatures(e,t){return this.style.querySourceFeatures(e,t)}isPointOnSurface(e){const{name:t}=this.transform.projection;return"globe"!==t&&"mercator"!==t&&H(`${t} projection does not support isPointOnSurface, this API may behave unexpectedly.`),this.transform.isPointOnSurface(g.convert(e))}setStyle(e,t){return!1!==(t=L({},{localIdeographFontFamily:this._localIdeographFontFamily,localFontFamily:this._localFontFamily},t)).diff&&t.localIdeographFontFamily===this._localIdeographFontFamily&&t.localFontFamily===this._localFontFamily&&this.style&&e?(this._diffStyle(e,t),this):(this._localIdeographFontFamily=t.localIdeographFontFamily,this._localFontFamily=t.localFontFamily,this._updateStyle(e,t))}_getUIString(e){const t=this._locale[e];if(null==t)throw new Error(`Missing UI string '${e}'`);return t}_updateStyle(e,t){return this.style&&(this.style.setEventedParent(null),this.style._remove(),this.style=void 0),e&&(this.style=new Style(this,t||{}),this.style.setEventedParent(this,{style:this.style}),"string"==typeof e?this.style.loadURL(e):this.style.loadJSON(e)),this._updateTerrain(),this}_lazyInitEmptyStyle(){this.style||(this.style=new Style(this,{}),this.style.setEventedParent(this,{style:this.style}),this.style.loadEmpty())}_diffStyle(e,t){if("string"==typeof e){const i=this._requestManager.normalizeStyleURL(e),r=this._requestManager.transformRequest(i,me.Style);ye(r,((e,i)=>{e?this.fire(new ErrorEvent(e)):i&&this._updateDiff(i,t)}))}else"object"==typeof e&&this._updateDiff(e,t)}_updateDiff(e,t){try{this.style.setState(e)&&this._update(!0)}catch(i){H(`Unable to perform style diff: ${i.message||i.error||i}.  Rebuilding the style from scratch.`),this._updateStyle(e,t)}}getStyle(){if(this.style)return this.style.serialize()}isStyleLoaded(){return this.style?this.style.loaded():(H("There is no style added to the map."),!1)}addSource(e,t){return this._lazyInitEmptyStyle(),this.style.addSource(e,t),this._update(!0)}isSourceLoaded(e){return!!this.style&&this.style._isSourceCacheLoaded(e)}areTilesLoaded(){const e=this.style&&this.style._sourceCaches;for(const t in e){const i=e[t]._tiles;for(const e in i){const t=i[e];if("loaded"!==t.state&&"errored"!==t.state)return!1}}return!0}addSourceType(e,t,i){this._lazyInitEmptyStyle(),this.style.addSourceType(e,t,i)}removeSource(e){return this.style.removeSource(e),this._updateTerrain(),this._update(!0)}getSource(e){return this.style.getSource(e)}addImage(t,i,{pixelRatio:r=1,sdf:n=!1,stretchX:o,stretchY:s,content:a}={}){if(this._lazyInitEmptyStyle(),i instanceof e.HTMLImageElement||e.ImageBitmap&&i instanceof e.ImageBitmap){const{width:e,height:l,data:c}=it.getImageData(i);this.style.addImage(t,{data:new RGBAImage({width:e,height:l},c),pixelRatio:r,stretchX:o,stretchY:s,content:a,sdf:n,version:0})}else if(void 0===i.width||void 0===i.height)this.fire(new ErrorEvent(new Error("Invalid arguments to map.addImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`")));else{const{width:e,height:l}=i,c=i;this.style.addImage(t,{data:new RGBAImage({width:e,height:l},new Uint8Array(c.data)),pixelRatio:r,stretchX:o,stretchY:s,content:a,sdf:n,version:0,userImage:c}),c.onAdd&&c.onAdd(this,t)}}updateImage(t,i){const r=this.style.getImage(t);if(!r)return void this.fire(new ErrorEvent(new Error("The map has no image with that id. If you are adding a new image use `map.addImage(...)` instead.")));const n=i instanceof e.HTMLImageElement||e.ImageBitmap&&i instanceof e.ImageBitmap?it.getImageData(i):i,{width:o,height:s}=n;void 0!==o&&void 0!==s?o===r.data.width&&s===r.data.height?(r.data.replace(n.data,!(i instanceof e.HTMLImageElement||e.ImageBitmap&&i instanceof e.ImageBitmap)),this.style.updateImage(t,r)):this.fire(new ErrorEvent(new Error(`The width and height of the updated image (${o}, ${s})\n                must be that same as the previous version of the image\n                (${r.data.width}, ${r.data.height})`))):this.fire(new ErrorEvent(new Error("Invalid arguments to map.updateImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`")))}hasImage(e){return e?!!this.style.getImage(e):(this.fire(new ErrorEvent(new Error("Missing required image id"))),!1)}removeImage(e){this.style.removeImage(e)}loadImage(t,i){Te(this._requestManager.transformRequest(t,me.Image),((t,r)=>{i(t,r instanceof e.HTMLImageElement?it.getImageData(r):r)}))}listImages(){return this.style.listImages()}addLayer(e,t){return this._lazyInitEmptyStyle(),this.style.addLayer(e,t),this._update(!0)}moveLayer(e,t){return this.style.moveLayer(e,t),this._update(!0)}removeLayer(e){return this.style.removeLayer(e),this._update(!0)}getLayer(e){return this.style.getLayer(e)}setLayerZoomRange(e,t,i){return this.style.setLayerZoomRange(e,t,i),this._update(!0)}setFilter(e,t,i={}){return this.style.setFilter(e,t,i),this._update(!0)}getFilter(e){return this.style.getFilter(e)}setPaintProperty(e,t,i,r={}){return this.style.setPaintProperty(e,t,i,r),this._update(!0)}getPaintProperty(e,t){return this.style.getPaintProperty(e,t)}setLayoutProperty(e,t,i,r={}){return this.style.setLayoutProperty(e,t,i,r),this._update(!0)}getLayoutProperty(e,t){return this.style.getLayoutProperty(e,t)}setLight(e,t={}){return this._lazyInitEmptyStyle(),this.style.setLight(e,t),this._update(!0)}getLight(){return this.style.getLight()}setTerrain(e){return this._lazyInitEmptyStyle(),!e&&this.transform.projection.requiresDraping?this.style.setTerrainForDraping():this.style.setTerrain(e),this._averageElevationLastSampledAt=-1/0,this._update(!0)}getTerrain(){return this.style?this.style.getTerrain():null}setFog(e){return this._lazyInitEmptyStyle(),this.style.setFog(e),this._update(!0)}getFog(){return this.style?this.style.getFog():null}_queryFogOpacity(e){return this.style&&this.style.fog?this.style.fog.getOpacityAtLatLng(Pa.convert(e),this.transform):0}setFeatureState(e,t){return this.style.setFeatureState(e,t),this._update()}removeFeatureState(e,t){return this.style.removeFeatureState(e,t),this._update()}getFeatureState(e){return this.style.getFeatureState(e)}_updateContainerDimensions(){if(!this._container)return;const t=this._container.getBoundingClientRect().width||400,i=this._container.getBoundingClientRect().height||300;let r,n,o,s=this._container;for(;s&&(!n||!o);){const t=e.getComputedStyle(s).transform;t&&"none"!==t&&(r=t.match(/matrix.*\((.+)\)/)[1].split(", "),r[0]&&"0"!==r[0]&&"1"!==r[0]&&(n=r[0]),r[3]&&"0"!==r[3]&&"1"!==r[3]&&(o=r[3])),s=s.parentElement}this._containerWidth=n?Math.abs(t/n):t,this._containerHeight=o?Math.abs(i/o):i}_detectMissingCSS(){"rgb(250, 128, 114)"!==e.getComputedStyle(this._missingCSSCanary).getPropertyValue("background-color")&&H("This page appears to be missing CSS declarations for Mapbox GL JS, which may cause the map to display incorrectly. Please ensure your page includes mapbox-gl.css, as described in https://www.mapbox.com/mapbox-gl-js/api/.")}_setupContainer(){const e=this._container;e.classList.add("mapboxgl-map"),(this._missingCSSCanary=rt("div","mapboxgl-canary",e)).style.visibility="hidden",this._detectMissingCSS();const t=this._canvasContainer=rt("div","mapboxgl-canvas-container",e);this._interactive&&t.classList.add("mapboxgl-interactive"),this._canvas=rt("canvas","mapboxgl-canvas",t),this._canvas.addEventListener("webglcontextlost",this._contextLost,!1),this._canvas.addEventListener("webglcontextrestored",this._contextRestored,!1),this._canvas.setAttribute("tabindex","0"),this._canvas.setAttribute("aria-label",this._getUIString("Map.Title")),this._canvas.setAttribute("role","region"),this._updateContainerDimensions(),this._resizeCanvas(this._containerWidth,this._containerHeight);const i=this._controlContainer=rt("div","mapboxgl-control-container",e),r=this._controlPositions={};["top-left","top-right","bottom-left","bottom-right"].forEach((e=>{r[e]=rt("div",`mapboxgl-ctrl-${e}`,i)})),this._container.addEventListener("scroll",this._onMapScroll,!1)}_resizeCanvas(e,t){const i=it.devicePixelRatio||1;this._canvas.width=i*Math.ceil(e),this._canvas.height=i*Math.ceil(t),this._canvas.style.width=`${e}px`,this._canvas.style.height=`${t}px`}_addMarker(e){this._markers.push(e)}_removeMarker(e){const t=this._markers.indexOf(e);-1!==t&&this._markers.splice(t,1)}_addPopup(e){this._popups.push(e)}_removePopup(e){const t=this._popups.indexOf(e);-1!==t&&this._popups.splice(t,1)}_setupPainter(){const e=L({},Xe.webGLContextAttributes,{failIfMajorPerformanceCaveat:this._failIfMajorPerformanceCaveat,preserveDrawingBuffer:this._preserveDrawingBuffer,antialias:this._antialias||!1}),t=this._useWebGL2&&this._canvas.getContext("webgl2",e),i=t||this._canvas.getContext("webgl",e)||this._canvas.getContext("experimental-webgl",e);i?(this._useWebGL2&&!t&&H("Failed to create WebGL 2 context. Using WebGL 1."),Ze(i,!0),this.painter=new Painter(i,this.transform,!!t),this.on("data",(e=>{"source"===e.dataType&&this.painter.setTileLoadedFlag(!0)})),n.testSupport(i)):this.fire(new ErrorEvent(new Error("Failed to initialize WebGL")))}_contextLost(e){e.preventDefault(),this._frame&&(this._frame.cancel(),this._frame=null),this.fire(new Event("webglcontextlost",{originalEvent:e}))}_contextRestored(e){this._setupPainter(),this.resize(),this._update(),this.fire(new Event("webglcontextrestored",{originalEvent:e}))}_onMapScroll(e){if(e.target===this._container)return this._container.scrollTop=0,this._container.scrollLeft=0,!1}loaded(){return!this._styleDirty&&!this._sourcesDirty&&!!this.style&&this.style.loaded()}_update(e){return this.style?(this._styleDirty=this._styleDirty||e,this._sourcesDirty=!0,this.triggerRepaint(),this):this}_requestRenderFrame(e){return this._update(),this._renderTaskQueue.add(e)}_cancelRenderFrame(e){this._renderTaskQueue.remove(e)}_requestDomTask(e){!this.loaded()||this.loaded()&&!this.isMoving()?e():this._domRenderTaskQueue.add(e)}_render(t){let i;const r=this.painter.context.extTimerQuery,n=it.now();if(this.listens("gpu-timing-frame")&&(i=r.createQueryEXT(),r.beginQueryEXT(r.TIME_ELAPSED_EXT,i)),this.painter.context.setDirty(),this.painter.setBaseState(),(this.isMoving()||this.isRotating()||this.isZooming())&&(this._interactionRange[0]=Math.min(this._interactionRange[0],e.performance.now()),this._interactionRange[1]=Math.max(this._interactionRange[1],e.performance.now())),this._renderTaskQueue.run(t),this._domRenderTaskQueue.run(t),this._removed)return;this._updateProjectionTransition();const o=this._isInitialLoad?0:this._fadeDuration;if(this.style&&this._styleDirty){this._styleDirty=!1;const e=this.transform.zoom,t=this.transform.pitch,i=it.now(),r=new EvaluationParameters(e,{now:i,fadeDuration:o,pitch:t,transition:this.style.getTransition()});this.style.update(r)}this.style&&this.style.fog&&this.style.fog.hasTransition()&&(this.style._markersNeedUpdate=!0,this._sourcesDirty=!0);let s=!1;if(this.style&&this._sourcesDirty?(this._sourcesDirty=!1,this.painter._updateFog(this.style),this._updateTerrain(),s=this._updateAverageElevation(n),this.style._updateSources(this.transform),this._forceMarkerAndPopupUpdate()):s=this._updateAverageElevation(n),this._placementDirty=this.style&&this.style._updatePlacement(this.painter.transform,this.showCollisionBoxes,o,this._crossSourceCollisions),this.style&&this.painter.render(this.style,{showTileBoundaries:this.showTileBoundaries,showTerrainWireframe:this.showTerrainWireframe,showOverdrawInspector:this._showOverdrawInspector,showQueryGeometry:!!this._showQueryGeometry,showTileAABBs:this.showTileAABBs,rotating:this.isRotating(),zooming:this.isZooming(),moving:this.isMoving(),fadeDuration:o,isInitialLoad:this._isInitialLoad,showPadding:this.showPadding,gpuTiming:!!this.listens("gpu-timing-layer"),gpuTimingDeferredRender:!!this.listens("gpu-timing-deferred-render"),speedIndexTiming:this.speedIndexTiming}),this.fire(new Event("render")),this.loaded()&&!this._loaded&&(this._loaded=!0,this.fire(new Event("load"))),this.style&&this.style.hasTransitions()&&(this._styleDirty=!0),this.style&&!this._placementDirty&&this.style._releaseSymbolFadeTiles(),i){const t=it.now()-n;r.endQueryEXT(r.TIME_ELAPSED_EXT,i),setTimeout((()=>{const o=r.getQueryObjectEXT(i,r.QUERY_RESULT_EXT)/1e6;r.deleteQueryEXT(i),this.fire(new Event("gpu-timing-frame",{cpuTime:t,gpuTime:o})),e.performance.mark("frame-gpu",{startTime:n,detail:{gpuTime:o}})}),50)}if(this.listens("gpu-timing-layer")){const e=this.painter.collectGpuTimers();setTimeout((()=>{const t=this.painter.queryGpuTimers(e);this.fire(new Event("gpu-timing-layer",{layerTimes:t}))}),50)}if(this.listens("gpu-timing-deferred-render")){const e=this.painter.collectDeferredRenderGpuQueries();setTimeout((()=>{const t=this.painter.queryGpuTimeDeferredRender(e);this.fire(new Event("gpu-timing-deferred-render",{gpuTime:t}))}),50)}const a=this._sourcesDirty||this._styleDirty||this._placementDirty||s;if(a||this._repaint)this.triggerRepaint();else{const e=!this.isMoving()&&this.loaded();if(e&&(s=this._updateAverageElevation(n,!0)),s)this.triggerRepaint();else if(this._triggerFrame(!1),e&&(this.fire(new Event("idle")),this._isInitialLoad=!1,this.speedIndexTiming)){const e=this._calculateSpeedIndex();this.fire(new Event("speedindexcompleted",{speedIndex:e})),this.speedIndexTiming=!1}}!this._loaded||this._fullyLoaded||a||(this._fullyLoaded=!0,We.mark($e.fullLoad),this._performanceMetricsCollection&&je(this._requestManager._customAccessToken,{width:this.painter.width,height:this.painter.height,interactionRange:this._interactionRange,visibilityHidden:this._visibilityHidden,terrainEnabled:!!this.painter.style.getTerrain(),fogEnabled:!!this.painter.style.getFog(),projection:this.getProjection().name,zoom:this.transform.zoom,renderer:this.painter.context.renderer,vendor:this.painter.context.vendor}),this._authenticate())}_forceMarkerAndPopupUpdate(e){for(const t of this._markers)e&&!this.getRenderWorldCopies()&&(t._lngLat=t._lngLat.wrap()),t._update();for(const t of this._popups)!e||this.getRenderWorldCopies()||t._trackPointer||(t._lngLat=t._lngLat.wrap()),t._update()}_updateAverageElevation(e,t=!1){const i=e=>(this.transform.averageElevation=e,this._update(!1),!0);if(!this.painter.averageElevationNeedsEasing())return 0!==this.transform.averageElevation&&i(0);if((t||e-this._averageElevationLastSampledAt>500)&&!this._averageElevation.isEasing(e)){const t=this.transform.averageElevation;let r=this.transform.sampleAverageElevation(),n=!1;this.transform.elevation&&(n=this.transform.elevation.exaggeration()!==this._averageElevationExaggeration,this._averageElevationExaggeration=this.transform.elevation.exaggeration()),isNaN(r)?r=0:this._averageElevationLastSampledAt=e;const o=Math.abs(t-r);if(o>1){if(this._isInitialLoad||n)return this._averageElevation.jumpTo(r),i(r);this._averageElevation.easeTo(r,e,300)}else if(o>1e-4)return this._averageElevation.jumpTo(r),i(r)}return!!this._averageElevation.isEasing(e)&&i(this._averageElevation.getValue(e))}_authenticate(){Ge(this._getMapId(),this._requestManager._skuToken,this._requestManager._customAccessToken,(e=>{if(e&&(e.message===Se||401===e.status)){const e=this.painter.context.gl;Ze(e,!1),this._logoControl instanceof LogoControl&&this._logoControl._updateLogo(),e&&e.clear(e.DEPTH_BUFFER_BIT|e.COLOR_BUFFER_BIT|e.STENCIL_BUFFER_BIT),this._silenceAuthErrors||this.fire(new ErrorEvent(new Error("A valid Mapbox access token is required to use Mapbox GL JS. To create an account or a new access token, visit https://account.mapbox.com/")))}})),Ue(this._getMapId(),this._requestManager._skuToken,this._requestManager._customAccessToken,(()=>{}))}_updateTerrain(){const e=this._isDragging();this.painter.updateTerrain(this.style,e)}_calculateSpeedIndex(){const e=this.painter.canvasCopy(),t=this.painter.getCanvasCopiesAndTimestamps();t.timeStamps.push(performance.now());const i=this.painter.context.gl,r=i.createFramebuffer();function n(e){i.framebufferTexture2D(i.FRAMEBUFFER,i.COLOR_ATTACHMENT0,i.TEXTURE_2D,e,0);const t=new Uint8Array(i.drawingBufferWidth*i.drawingBufferHeight*4);return i.readPixels(0,0,i.drawingBufferWidth,i.drawingBufferHeight,i.RGBA,i.UNSIGNED_BYTE,t),t}return i.bindFramebuffer(i.FRAMEBUFFER,r),this._canvasPixelComparison(n(e),t.canvasCopies.map(n),t.timeStamps)}_canvasPixelComparison(e,t,i){let r=i[1]-i[0];const n=e.length/4;for(let o=0;o<t.length;o++){const s=t[o];let a=0;for(let t=0;t<s.length;t+=4)s[t]===e[t]&&s[t+1]===e[t+1]&&s[t+2]===e[t+2]&&s[t+3]===e[t+3]&&(a+=1);r+=(i[o+2]-i[o+1])*(1-a/n)}return r}remove(){this._hash&&this._hash.remove();for(const e of this._controls)e.onRemove(this);this._controls=[],this._frame&&(this._frame.cancel(),this._frame=null),this._renderTaskQueue.clear(),this._domRenderTaskQueue.clear(),this.style&&this.style.destroy(),this.painter.destroy(),this.handlers&&this.handlers.destroy(),this.handlers=void 0,this.setStyle(null),void 0!==e&&(e.removeEventListener("resize",this._onWindowResize,!1),e.removeEventListener("orientationchange",this._onWindowResize,!1),e.removeEventListener("webkitfullscreenchange",this._onWindowResize,!1),e.removeEventListener("online",this._onWindowOnline,!1),e.removeEventListener("visibilitychange",this._onVisibilityChange,!1));const t=this.painter.context.gl.getExtension("WEBGL_lose_context");t&&t.loseContext(),this._canvas.removeEventListener("webglcontextlost",this._contextLost,!1),this._canvas.removeEventListener("webglcontextrestored",this._contextRestored,!1),this._canvasContainer.remove(),this._controlContainer.remove(),this._missingCSSCanary.remove(),this._canvas=void 0,this._canvasContainer=void 0,this._controlContainer=void 0,this._missingCSSCanary=void 0,this._container.classList.remove("mapboxgl-map"),this._container.removeEventListener("scroll",this._onMapScroll,!1),qe.delete(this.painter.context.gl),this._removed=!0,this.fire(new Event("remove"))}triggerRepaint(){this._triggerFrame(!0)}_triggerFrame(e){this._renderNextFrame=this._renderNextFrame||e,this.style&&!this._frame&&(this._frame=it.frame((e=>{const t=!!this._renderNextFrame;this._frame=null,this._renderNextFrame=null,t&&this._render(e)})))}_preloadTiles(e){return z(this.style?Object.values(this.style._sourceCaches):[],((t,i)=>t._preloadTiles(e,i)),(()=>{this.triggerRepaint()})),this}_onWindowOnline(){this._update()}_onWindowResize(e){this._trackResize&&this.resize({originalEvent:e})._update()}_onVisibilityChange(){"hidden"===e.document.visibilityState&&this._visibilityHidden++}get showTileBoundaries(){return!!this._showTileBoundaries}set showTileBoundaries(e){this._showTileBoundaries!==e&&(this._showTileBoundaries=e,this._update())}get showTerrainWireframe(){return!!this._showTerrainWireframe}set showTerrainWireframe(e){this._showTerrainWireframe!==e&&(this._showTerrainWireframe=e,this._update())}get speedIndexTiming(){return!!this._speedIndexTiming}set speedIndexTiming(e){this._speedIndexTiming!==e&&(this._speedIndexTiming=e,this._update())}get showPadding(){return!!this._showPadding}set showPadding(e){this._showPadding!==e&&(this._showPadding=e,this._update())}get showCollisionBoxes(){return!!this._showCollisionBoxes}set showCollisionBoxes(e){this._showCollisionBoxes!==e&&(this._showCollisionBoxes=e,e?this.style._generateCollisionBoxes():this._update())}get showOverdrawInspector(){return!!this._showOverdrawInspector}set showOverdrawInspector(e){this._showOverdrawInspector!==e&&(this._showOverdrawInspector=e,this._update())}get repaint(){return!!this._repaint}set repaint(e){this._repaint!==e&&(this._repaint=e,this.triggerRepaint())}get vertices(){return!!this._vertices}set vertices(e){this._vertices=e,this._update()}get showTileAABBs(){return!!this._showTileAABBs}set showTileAABBs(e){this._showTileAABBs!==e&&(this._showTileAABBs=e,e&&this._update())}_setCacheLimits(e,t){!function(e,t){se=e,ae=t}(e,t)}get version(){return t}},NavigationControl:class NavigationControl{constructor(e){this.options=L({},Xm,e),this._container=rt("div","mapboxgl-ctrl mapboxgl-ctrl-group"),this._container.addEventListener("contextmenu",(e=>e.preventDefault())),this.options.showZoom&&(j(["_setButtonTitle","_updateZoomButtons"],this),this._zoomInButton=this._createButton("mapboxgl-ctrl-zoom-in",(e=>{this._map&&this._map.zoomIn({},{originalEvent:e})})),rt("span","mapboxgl-ctrl-icon",this._zoomInButton).setAttribute("aria-hidden","true"),this._zoomOutButton=this._createButton("mapboxgl-ctrl-zoom-out",(e=>{this._map&&this._map.zoomOut({},{originalEvent:e})})),rt("span","mapboxgl-ctrl-icon",this._zoomOutButton).setAttribute("aria-hidden","true")),this.options.showCompass&&(j(["_rotateCompassArrow"],this),this._compass=this._createButton("mapboxgl-ctrl-compass",(e=>{const t=this._map;t&&(this.options.visualizePitch?t.resetNorthPitch({},{originalEvent:e}):t.resetNorth({},{originalEvent:e}))})),this._compassIcon=rt("span","mapboxgl-ctrl-icon",this._compass),this._compassIcon.setAttribute("aria-hidden","true"))}_updateZoomButtons(){const e=this._map;if(!e)return;const t=e.getZoom(),i=t===e.getMaxZoom(),r=t===e.getMinZoom();this._zoomInButton.disabled=i,this._zoomOutButton.disabled=r,this._zoomInButton.setAttribute("aria-disabled",i.toString()),this._zoomOutButton.setAttribute("aria-disabled",r.toString())}_rotateCompassArrow(){const e=this._map;if(!e)return;const t=this.options.visualizePitch?`scale(${1/Math.pow(Math.cos(e.transform.pitch*(Math.PI/180)),.5)}) rotateX(${e.transform.pitch}deg) rotateZ(${e.transform.angle*(180/Math.PI)}deg)`:`rotate(${e.transform.angle*(180/Math.PI)}deg)`;e._requestDomTask((()=>{this._compassIcon&&(this._compassIcon.style.transform=t)}))}onAdd(e){return this._map=e,this.options.showZoom&&(this._setButtonTitle(this._zoomInButton,"ZoomIn"),this._setButtonTitle(this._zoomOutButton,"ZoomOut"),e.on("zoom",this._updateZoomButtons),this._updateZoomButtons()),this.options.showCompass&&(this._setButtonTitle(this._compass,"ResetBearing"),this.options.visualizePitch&&e.on("pitch",this._rotateCompassArrow),e.on("rotate",this._rotateCompassArrow),this._rotateCompassArrow(),this._handler=new MouseRotateWrapper(e,this._compass,this.options.visualizePitch)),this._container}onRemove(){const e=this._map;e&&(this._container.remove(),this.options.showZoom&&e.off("zoom",this._updateZoomButtons),this.options.showCompass&&(this.options.visualizePitch&&e.off("pitch",this._rotateCompassArrow),e.off("rotate",this._rotateCompassArrow),this._handler&&this._handler.off(),this._handler=void 0),this._map=void 0)}_createButton(e,t){const i=rt("button",e,this._container);return i.type="button",i.addEventListener("click",t),i}_setButtonTitle(e,t){if(!this._map)return;const i=this._map._getUIString(`NavigationControl.${t}`);e.setAttribute("aria-label",i),e.firstElementChild&&e.firstElementChild.setAttribute("title",i)}},GeolocateControl:class GeolocateControl extends Evented{constructor(t){super(),this.options=L({geolocation:e.navigator.geolocation},Km,t),j(["_onSuccess","_onError","_onZoom","_finish","_setupUI","_updateCamera","_updateMarker","_updateMarkerRotation","_onDeviceOrientation"],this),this._updateMarkerRotationThrottled=bm(this._updateMarkerRotation,20),this._numberOfWatches=0}onAdd(e){return this._map=e,this._container=rt("div","mapboxgl-ctrl mapboxgl-ctrl-group"),this._checkGeolocationSupport(this._setupUI),this._container}onRemove(){void 0!==this._geolocationWatchID&&(this.options.geolocation.clearWatch(this._geolocationWatchID),this._geolocationWatchID=void 0),this.options.showUserLocation&&this._userLocationDotMarker&&this._userLocationDotMarker.remove(),this.options.showAccuracyCircle&&this._accuracyCircleMarker&&this._accuracyCircleMarker.remove(),this._container.remove(),this._map.off("zoom",this._onZoom),this._map=void 0,this._numberOfWatches=0,this._noTimeout=!1}_checkGeolocationSupport(t){const i=(e=!!this.options.geolocation)=>{this._supportsGeolocation=e,t(e)};void 0!==this._supportsGeolocation?t(this._supportsGeolocation):void 0!==e.navigator.permissions?e.navigator.permissions.query({name:"geolocation"}).then((e=>i("denied"!==e.state))).catch((()=>i())):i()}_isOutOfMapMaxBounds(e){const t=this._map.getMaxBounds(),i=e.coords;return!!t&&(i.longitude<t.getWest()||i.longitude>t.getEast()||i.latitude<t.getSouth()||i.latitude>t.getNorth())}_setErrorState(){switch(this._watchState){case"WAITING_ACTIVE":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active-error");break;case"ACTIVE_LOCK":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting");break;case"BACKGROUND":this._watchState="BACKGROUND_ERROR",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting")}}_onSuccess(e){if(this._map){if(this._isOutOfMapMaxBounds(e))return this._setErrorState(),this.fire(new Event("outofmaxbounds",e)),this._updateMarker(),void this._finish();if(this.options.trackUserLocation)switch(this._lastKnownPosition=e,this._watchState){case"WAITING_ACTIVE":case"ACTIVE_LOCK":case"ACTIVE_ERROR":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active");break;case"BACKGROUND":case"BACKGROUND_ERROR":this._watchState="BACKGROUND",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-background")}this.options.showUserLocation&&"OFF"!==this._watchState&&this._updateMarker(e),this.options.trackUserLocation&&"ACTIVE_LOCK"!==this._watchState||this._updateCamera(e),this.options.showUserLocation&&this._dotElement.classList.remove("mapboxgl-user-location-dot-stale"),this.fire(new Event("geolocate",e)),this._finish()}}_updateCamera(e){const t=new Pa(e.coords.longitude,e.coords.latitude),i=e.coords.accuracy,r=L({bearing:this._map.getBearing()},this.options.fitBoundsOptions);this._map.fitBounds(t.toBounds(i),r,{geolocateSource:!0})}_updateMarker(e){if(e){const t=new Pa(e.coords.longitude,e.coords.latitude);this._accuracyCircleMarker.setLngLat(t).addTo(this._map),this._userLocationDotMarker.setLngLat(t).addTo(this._map),this._accuracy=e.coords.accuracy,this.options.showUserLocation&&this.options.showAccuracyCircle&&this._updateCircleRadius()}else this._userLocationDotMarker.remove(),this._accuracyCircleMarker.remove()}_updateCircleRadius(){const e=this._map.transform,t=La(1,e._center.lat)*e.worldSize,i=Math.ceil(2*this._accuracy*t);this._circleElement.style.width=`${i}px`,this._circleElement.style.height=`${i}px`}_onZoom(){this.options.showUserLocation&&this.options.showAccuracyCircle&&this._updateCircleRadius()}_updateMarkerRotation(){this._userLocationDotMarker&&"number"==typeof this._heading?(this._userLocationDotMarker.setRotation(this._heading),this._dotElement.classList.add("mapboxgl-user-location-show-heading")):(this._dotElement.classList.remove("mapboxgl-user-location-show-heading"),this._userLocationDotMarker.setRotation(0))}_onError(e){if(this._map){if(this.options.trackUserLocation)if(1===e.code){this._watchState="OFF",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background-error"),this._geolocateButton.disabled=!0;const e=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.setAttribute("aria-label",e),this._geolocateButton.firstElementChild&&this._geolocateButton.firstElementChild.setAttribute("title",e),void 0!==this._geolocationWatchID&&this._clearWatch()}else{if(3===e.code&&this._noTimeout)return;this._setErrorState()}"OFF"!==this._watchState&&this.options.showUserLocation&&this._dotElement.classList.add("mapboxgl-user-location-dot-stale"),this.fire(new Event("error",e)),this._finish()}}_finish(){this._timeoutId&&clearTimeout(this._timeoutId),this._timeoutId=void 0}_setupUI(e){if(void 0!==this._map){if(this._container.addEventListener("contextmenu",(e=>e.preventDefault())),this._geolocateButton=rt("button","mapboxgl-ctrl-geolocate",this._container),rt("span","mapboxgl-ctrl-icon",this._geolocateButton).setAttribute("aria-hidden","true"),this._geolocateButton.type="button",!1===e){H("Geolocation support is not available so the GeolocateControl will be disabled.");const e=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.disabled=!0,this._geolocateButton.setAttribute("aria-label",e),this._geolocateButton.firstElementChild&&this._geolocateButton.firstElementChild.setAttribute("title",e)}else{const e=this._map._getUIString("GeolocateControl.FindMyLocation");this._geolocateButton.setAttribute("aria-label",e),this._geolocateButton.firstElementChild&&this._geolocateButton.firstElementChild.setAttribute("title",e)}this.options.trackUserLocation&&(this._geolocateButton.setAttribute("aria-pressed","false"),this._watchState="OFF"),this.options.showUserLocation&&(this._dotElement=rt("div","mapboxgl-user-location"),this._dotElement.appendChild(rt("div","mapboxgl-user-location-dot")),this._dotElement.appendChild(rt("div","mapboxgl-user-location-heading")),this._userLocationDotMarker=new Marker({element:this._dotElement,rotationAlignment:"map",pitchAlignment:"map"}),this._circleElement=rt("div","mapboxgl-user-location-accuracy-circle"),this._accuracyCircleMarker=new Marker({element:this._circleElement,pitchAlignment:"map"}),this.options.trackUserLocation&&(this._watchState="OFF"),this._map.on("zoom",this._onZoom)),this._geolocateButton.addEventListener("click",this.trigger.bind(this)),this._setup=!0,this.options.trackUserLocation&&this._map.on("movestart",(e=>{e.geolocateSource||"ACTIVE_LOCK"!==this._watchState||e.originalEvent&&"resize"===e.originalEvent.type||(this._watchState="BACKGROUND",this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active"),this.fire(new Event("trackuserlocationend")))}))}}_onDeviceOrientation(e){this._userLocationDotMarker&&(e.webkitCompassHeading?this._heading=e.webkitCompassHeading:!0===e.absolute&&(this._heading=-1*e.alpha),this._updateMarkerRotationThrottled())}trigger(){if(!this._setup)return H("Geolocate control triggered before added to a map"),!1;if(this.options.trackUserLocation){switch(this._watchState){case"OFF":this._watchState="WAITING_ACTIVE",this.fire(new Event("trackuserlocationstart"));break;case"WAITING_ACTIVE":case"ACTIVE_LOCK":case"ACTIVE_ERROR":case"BACKGROUND_ERROR":this._numberOfWatches--,this._noTimeout=!1,this._watchState="OFF",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background-error"),this.fire(new Event("trackuserlocationend"));break;case"BACKGROUND":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background"),this._lastKnownPosition&&this._updateCamera(this._lastKnownPosition),this.fire(new Event("trackuserlocationstart"))}switch(this._watchState){case"WAITING_ACTIVE":this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active");break;case"ACTIVE_LOCK":this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active");break;case"ACTIVE_ERROR":this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active-error");break;case"BACKGROUND":this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-background");break;case"BACKGROUND_ERROR":this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-background-error")}if("OFF"===this._watchState&&void 0!==this._geolocationWatchID)this._clearWatch();else if(void 0===this._geolocationWatchID){let e;this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","true"),this._numberOfWatches++,this._numberOfWatches>1?(e={maximumAge:6e5,timeout:0},this._noTimeout=!0):(e=this.options.positionOptions,this._noTimeout=!1),this._geolocationWatchID=this.options.geolocation.watchPosition(this._onSuccess,this._onError,e),this.options.showUserHeading&&this._addDeviceOrientationListener()}}else this.options.geolocation.getCurrentPosition(this._onSuccess,this._onError,this.options.positionOptions),this._timeoutId=setTimeout(this._finish,1e4);return!0}_addDeviceOrientationListener(){const t=()=>{e.addEventListener("ondeviceorientationabsolute"in e?"deviceorientationabsolute":"deviceorientation",this._onDeviceOrientation)};void 0!==e.DeviceMotionEvent&&"function"==typeof e.DeviceMotionEvent.requestPermission?DeviceOrientationEvent.requestPermission().then((e=>{"granted"===e&&t()})).catch(console.error):t()}_clearWatch(){this.options.geolocation.clearWatch(this._geolocationWatchID),e.removeEventListener("deviceorientation",this._onDeviceOrientation),e.removeEventListener("deviceorientationabsolute",this._onDeviceOrientation),this._geolocationWatchID=void 0,this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","false"),this.options.showUserLocation&&this._updateMarker(null)}},AttributionControl:AttributionControl,ScaleControl:class ScaleControl{constructor(e){this.options=L({},Jm,e),this._isNumberFormatSupported=function(){try{return new Intl.NumberFormat("en",{style:"unit",unitDisplay:"short",unit:"meter"}),!0}catch(e){return!1}}(),j(["_update","_setScale","setUnit"],this)}getDefaultPosition(){return"bottom-left"}_update(){const e=this.options.maxWidth||100,t=this._map,i=t._containerHeight/2,r=t._containerWidth/2-e/2,n=t.unproject([r,i]),o=t.unproject([r+e,i]),s=n.distanceTo(o);if("imperial"===this.options.unit){const t=3.2808*s;t>5280?this._setScale(e,t/5280,"mile"):this._setScale(e,t,"foot")}else"nautical"===this.options.unit?this._setScale(e,s/1852,"nautical-mile"):s>=1e3?this._setScale(e,s/1e3,"kilometer"):this._setScale(e,s,"meter")}_setScale(e,t,i){this._map._requestDomTask((()=>{const r=function(e){const t=Math.pow(10,`${Math.floor(e)}`.length-1);let i=e/t;return i=i>=10?10:i>=5?5:i>=3?3:i>=2?2:i>=1?1:function(e){const t=Math.pow(10,Math.ceil(-Math.log(e)/Math.LN10));return Math.round(e*t)/t}(i),t*i}(t),n=r/t;this._container.innerHTML=this._isNumberFormatSupported&&"nautical-mile"!==i?new Intl.NumberFormat(this._language,{style:"unit",unitDisplay:"short",unit:i}).format(r):`${r}&nbsp;${Ym[i]}`,this._container.style.width=e*n+"px"}))}onAdd(e){return this._map=e,this._language=e.getLanguage(),this._container=rt("div","mapboxgl-ctrl mapboxgl-ctrl-scale",e.getContainer()),this._container.dir="auto",this._map.on("move",this._update),this._update(),this._container}onRemove(){this._container.remove(),this._map.off("move",this._update),this._map=void 0}_setLanguage(e){this._language=e,this._update()}setUnit(e){this.options.unit=e,this._update()}},FullscreenControl:class FullscreenControl{constructor(t){this._fullscreen=!1,t&&t.container&&(t.container instanceof e.HTMLElement?this._container=t.container:H("Full screen control 'container' must be a DOM element.")),j(["_onClickFullscreen","_changeIcon"],this),"onfullscreenchange"in e.document?this._fullscreenchange="fullscreenchange":"onwebkitfullscreenchange"in e.document&&(this._fullscreenchange="webkitfullscreenchange")}onAdd(e){return this._map=e,this._container||(this._container=this._map.getContainer()),this._controlContainer=rt("div","mapboxgl-ctrl mapboxgl-ctrl-group"),this._checkFullscreenSupport()?this._setupUI():(this._controlContainer.style.display="none",H("This device does not support fullscreen mode.")),this._controlContainer}onRemove(){this._controlContainer.remove(),this._map=null,e.document.removeEventListener(this._fullscreenchange,this._changeIcon)}_checkFullscreenSupport(){return!(!e.document.fullscreenEnabled&&!e.document.webkitFullscreenEnabled)}_setupUI(){const t=this._fullscreenButton=rt("button","mapboxgl-ctrl-fullscreen",this._controlContainer);rt("span","mapboxgl-ctrl-icon",t).setAttribute("aria-hidden","true"),t.type="button",this._updateTitle(),this._fullscreenButton.addEventListener("click",this._onClickFullscreen),e.document.addEventListener(this._fullscreenchange,this._changeIcon)}_updateTitle(){const e=this._getTitle();this._fullscreenButton.setAttribute("aria-label",e),this._fullscreenButton.firstElementChild&&this._fullscreenButton.firstElementChild.setAttribute("title",e)}_getTitle(){return this._map._getUIString(this._isFullscreen()?"FullscreenControl.Exit":"FullscreenControl.Enter")}_isFullscreen(){return this._fullscreen}_changeIcon(){(e.document.fullscreenElement||e.document.webkitFullscreenElement)===this._container!==this._fullscreen&&(this._fullscreen=!this._fullscreen,this._fullscreenButton.classList.toggle("mapboxgl-ctrl-shrink"),this._fullscreenButton.classList.toggle("mapboxgl-ctrl-fullscreen"),this._updateTitle())}_onClickFullscreen(){this._isFullscreen()?e.document.exitFullscreen?e.document.exitFullscreen():e.document.webkitCancelFullScreen&&e.document.webkitCancelFullScreen():this._container.requestFullscreen?this._container.requestFullscreen():this._container.webkitRequestFullscreen&&this._container.webkitRequestFullscreen()}},Popup:class Popup extends Evented{constructor(e){super(),this.options=L(Object.create(qm),e),j(["_update","_onClose","remove","_onMouseEvent"],this),this._classList=new Set(e&&e.className?e.className.trim().split(/\s+/):[])}addTo(e){return this._map&&this.remove(),this._map=e,this.options.closeOnClick&&e.on("preclick",this._onClose),this.options.closeOnMove&&e.on("move",this._onClose),e.on("remove",this.remove),this._update(),e._addPopup(this),this._focusFirstElement(),this._trackPointer?(e.on("mousemove",this._onMouseEvent),e.on("mouseup",this._onMouseEvent),e._canvasContainer.classList.add("mapboxgl-track-pointer")):e.on("move",this._update),this.fire(new Event("open")),this}isOpen(){return!!this._map}remove(){this._content&&this._content.remove(),this._container&&(this._container.remove(),this._container=void 0);const e=this._map;return e&&(e.off("move",this._update),e.off("move",this._onClose),e.off("preclick",this._onClose),e.off("click",this._onClose),e.off("remove",this.remove),e.off("mousemove",this._onMouseEvent),e.off("mouseup",this._onMouseEvent),e.off("drag",this._onMouseEvent),e._canvasContainer&&e._canvasContainer.classList.remove("mapboxgl-track-pointer"),e._removePopup(this),this._map=void 0),this.fire(new Event("close")),this}getLngLat(){return this._lngLat}setLngLat(e){this._lngLat=Pa.convert(e),this._pos=null,this._trackPointer=!1,this._update();const t=this._map;return t&&(t.on("move",this._update),t.off("mousemove",this._onMouseEvent),t._canvasContainer.classList.remove("mapboxgl-track-pointer")),this}trackPointer(){this._trackPointer=!0,this._pos=null,this._update();const e=this._map;return e&&(e.off("move",this._update),e.on("mousemove",this._onMouseEvent),e.on("drag",this._onMouseEvent),e._canvasContainer.classList.add("mapboxgl-track-pointer")),this}getElement(){return this._container}setText(t){return this.setDOMContent(e.document.createTextNode(t))}setHTML(t){const i=e.document.createDocumentFragment(),r=e.document.createElement("body");let n;for(r.innerHTML=t;n=r.firstChild,n;)i.appendChild(n);return this.setDOMContent(i)}getMaxWidth(){return this._container&&this._container.style.maxWidth}setMaxWidth(e){return this.options.maxWidth=e,this._update(),this}setDOMContent(e){let t=this._content;if(t)for(;t.hasChildNodes();)t.firstChild&&t.removeChild(t.firstChild);else t=this._content=rt("div","mapboxgl-popup-content",this._container||void 0);if(t.appendChild(e),this.options.closeButton){const e=this._closeButton=rt("button","mapboxgl-popup-close-button",t);e.type="button",e.setAttribute("aria-label","Close popup"),e.setAttribute("aria-hidden","true"),e.innerHTML="&#215;",e.addEventListener("click",this._onClose)}return this._update(),this._focusFirstElement(),this}addClassName(e){return this._classList.add(e),this._updateClassList(),this}removeClassName(e){return this._classList.delete(e),this._updateClassList(),this}setOffset(e){return this.options.offset=e,this._update(),this}toggleClassName(e){let t;return this._classList.delete(e)?t=!1:(this._classList.add(e),t=!0),this._updateClassList(),t}_onMouseEvent(e){this._update(e.point)}_getAnchor(e){if(this.options.anchor)return this.options.anchor;const t=this._map,i=this._container,r=this._pos;if(!t||!i||!r)return"bottom";const n=i.offsetWidth,o=i.offsetHeight,s=r.x<n/2,a=r.x>t.transform.width-n/2;if(r.y+e<o)return s?"top-left":a?"top-right":"top";if(r.y>t.transform.height-o){if(s)return"bottom-left";if(a)return"bottom-right"}return s?"left":a?"right":"bottom"}_updateClassList(){const e=this._container;if(!e)return;const t=[...this._classList];t.push("mapboxgl-popup"),this._anchor&&t.push(`mapboxgl-popup-anchor-${this._anchor}`),this._trackPointer&&t.push("mapboxgl-popup-track-pointer"),e.className=t.join(" ")}_update(e){const t=this._map,i=this._content;if(!t||!this._lngLat&&!this._trackPointer||!i)return;let r=this._container;if(r||(r=this._container=rt("div","mapboxgl-popup",t.getContainer()),this._tip=rt("div","mapboxgl-popup-tip",r),r.appendChild(i)),this.options.maxWidth&&r.style.maxWidth!==this.options.maxWidth&&(r.style.maxWidth=this.options.maxWidth),t.transform.renderWorldCopies&&!this._trackPointer&&(this._lngLat=Nm(this._lngLat,this._pos,t.transform)),!this._trackPointer||e){const i=this._pos=this._trackPointer&&e?e:t.project(this._lngLat),r=$m(this.options.offset),n=this._anchor=this._getAnchor(r.y),o=$m(this.options.offset,n),s=i.add(o).round();t._requestDomTask((()=>{this._container&&n&&(this._container.style.transform=`${Gm[n]} translate(${s.x}px,${s.y}px)`)}))}if(!this._marker&&t._showingGlobe()){const e=Ta(t.transform,this._lngLat)?0:1;this._setOpacity(e)}this._updateClassList()}_focusFirstElement(){if(!this.options.focusAfterOpen||!this._container)return;const e=this._container.querySelector(Zm);e&&e.focus()}_onClose(){this.remove()}_setOpacity(e){this._container&&(this._container.style.opacity=`${e}`),this._content&&(this._content.style.pointerEvents=e?"auto":"none")}},Marker:Marker,Style:Style,LngLat:Pa,LngLatBounds:LngLatBounds,Point:g,MercatorCoordinate:MercatorCoordinate,FreeCameraOptions:FreeCameraOptions,Evented:Evented,config:r,prewarm:function(){kd().acquire(Dd)},clearPrewarmedResources:function(){const e=zd;e&&(e.isPreloaded()&&1===e.numActive()?(e.release(Dd),zd=null):console.warn("Could not clear WebWorkers since there are active Map instances that still reference it. The pre-warmed WebWorker pool can only be cleared when all map instances have been removed with map.remove()"))},get accessToken(){return r.ACCESS_TOKEN},set accessToken(e){r.ACCESS_TOKEN=e},get baseApiUrl(){return r.API_URL},set baseApiUrl(e){r.API_URL=e},get workerCount(){return WorkerPool.workerCount},set workerCount(e){WorkerPool.workerCount=e},get maxParallelImageRequests(){return r.MAX_PARALLEL_IMAGE_REQUESTS},set maxParallelImageRequests(e){r.MAX_PARALLEL_IMAGE_REQUESTS=e},clearStorage(t){!function(t){if(!ue())return;const i=e.caches.delete(oe);t&&i.catch(t).then((()=>t()))}(t)},workerUrl:"",workerClass:null,setNow:it.setNow,restoreNow:it.restoreNow};return Qm}));
//# sourceMappingURL=mapbox-gl-csp.js.map
