<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('yemeks', function (Blueprint $table) {
            $table->id();
            $table->foreignId('alt_menu_id')->constrained('alt_menus')->onDelete('cascade');
            $table->string('name');
            $table->string('image');
            $table->integer('hazirlik_suresi');
            $table->string('kisa_aciklama');
            $table->double('fiyat');
            $table->integer('sira');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('yemeks');
    }
};
