<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\AnaMenu;
use App\Models\AltMenu;
use App\Models\Yemek;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File as FacadesFile;

class YemekController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $yemeks = Yemek::join('alt_menus', 'yemeks.alt_menu_id', '=', 'alt_menus.id')
        ->join('ana_menus', 'alt_menus.ana_menu_id', '=', 'ana_menus.id')
        ->select('yemeks.*', 'alt_menus.name as alt_menu_name', 'ana_menus.name as ana_menu_name', 'ana_menus.id as ana_menu_id', 'alt_menus.id as alt_menu_id')
        ->orderBy('yemeks.sira');

        $search_data = array();
        if ($request->has('arama')){
            $search_data['arama'] = $request->input('arama');
            $yemeks = $yemeks->where('yemeks.name', 'like', '%'.$search_data['arama'].'%');
        }
        if ($request->has('alt_menu_id')){
            $search_data['alt_menu_id'] = $request->input('alt_menu_id');
            $yemeks = $yemeks->where('yemeks.alt_menu_id', $search_data['alt_menu_id']);
        }
        $yemek_count = Yemek::count();
        $ana_menus = AnaMenu::select('id','name')->orderBy('sira')->get();
        $alt_menus = AltMenu::select('id','name')->orderBy('sira')->get();
        $yemeks = $yemeks->paginate(10);
        return view('admin.yemek.index', compact('yemeks', 'yemek_count', 'ana_menus', 'alt_menus', 'search_data'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $alt_menus = AltMenu::select('id','name')->orderBy('sira')->get();
        return view('admin.yemek.create', compact('alt_menus'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name'=>'required',
            'image'=>'required|image|mimes:jpeg,png,jpg|max:2048',
            'sira'=>'required|numeric',
            'hazirlik_suresi'=>'required|numeric',
            'kisa_aciklama'=>'required',
            'fiyat'=>'required',
            'alt_menu_id'=>'required|numeric',
        ]);

        $yemek = new Yemek();
        $yemek->name = $request->input('name');
        $yemek->sira = $request->input('sira');
        $yemek->hazirlik_suresi = $request->input('hazirlik_suresi');
        $yemek->kisa_aciklama = $request->input('kisa_aciklama');
        $yemek->fiyat = $request->input('fiyat');
        $yemek->alt_menu_id = $request->input('alt_menu_id');
        $file = $request->file('image');
        if ($request->hasFile('image')) {
            $profile_photo_path = bin2hex(random_bytes(32));
            $file_name = $profile_photo_path . '.' . $file->getClientOriginalExtension();
            Storage::disk('public')->put($file_name, FacadesFile::get($file));
        }else{
            return redirect()->back()->with('error', 'Resim yüklenemedi.');
        }
        $yemek->image = $file_name;
        $yemek->save();
        return redirect()->route('yemek.index')->with('success', 'Yemek başarıyla eklendi.');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $data = Yemek::join('alt_menus', 'yemeks.alt_menu_id', '=', 'alt_menus.id')
        ->join('ana_menus', 'alt_menus.ana_menu_id', '=', 'ana_menus.id')
        ->select('yemeks.*', 'alt_menus.name as alt_menu_name', 'ana_menus.name as ana_menu_name', 'ana_menus.id as ana_menu_id', 'alt_menus.id as alt_menu_id')
        ->where('yemeks.id', $id)
        ->first();
        if (!$data) {
            return redirect()->route('yemek.index')->with('error', 'Yemek bulunamadı.');
        }
        $alt_menus = AltMenu::select('id','name')->orderBy('sira')->get();
        return view('admin.yemek.show', compact('data', 'alt_menus'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $data = Yemek::find($id);
        if (!$data) {
            return redirect()->route('yemek.index')->with('error', 'Yemek bulunamadı.');
        }
        $alt_menus = AltMenu::select('id','name')->orderBy('sira')->get();
        return view('admin.yemek.edit', compact('data', 'alt_menus'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        

        $yemek = Yemek::find($id);
        if (!$yemek) {
            return redirect()->route('yemek.index')->with('error', 'Yemek bulunamadı.');
        }
        $yemek->name = $request->input('name');
        $yemek->sira = $request->input('sira');
        $yemek->hazirlik_suresi = $request->input('hazirlik_suresi');
        $yemek->kisa_aciklama = $request->input('kisa_aciklama');
        $yemek->fiyat = $request->input('fiyat');
        $yemek->alt_menu_id = $request->input('alt_menu_id');
        if ($request->hasFile('image')) {
            if (Storage::disk('public')->exists($yemek->image)) {
                Storage::disk('public')->delete($yemek->image);
            }
            $file = $request->file('image');
            $profile_photo_path = bin2hex(random_bytes(32));
            $file_name = $profile_photo_path . '.' . $file->getClientOriginalExtension();
            Storage::disk('public')->put($file_name, FacadesFile::get($file));
            $yemek->image = $file_name;
        }
        $yemek->save();
        return redirect()->route('yemek.index')->with('success', 'Yemek başarıyla güncellendi.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $yemek = Yemek::find($id);
        if (!$yemek) {
            return redirect()->route('yemek.index')->with('error', 'Yemek bulunamadı.');
        }
        if (Storage::disk('public')->exists($yemek->image)) {
            Storage::disk('public')->delete($yemek->image);
        }
        $yemek->delete();
        return redirect()->route('yemek.index')->with('success', 'Yemek başarıyla silindi.');
    }
}
